// MFINDER.H : a molecule identifier class (also see the sequence builder).

// Copyright (C) 2006 Tommi Hassinen.

// This package is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this package; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

/*################################################################################################*/

#ifndef MFINDER_H
#define MFINDER_H

#include "libghemicaldefine.h"

class mfinder;

class mf_data_atm;
class mf_data_bnd;

struct mf_tdata;

/*################################################################################################*/

#include "atom.h"
#include "bond.h"

#include "model.h"
#include "typerule.h"

typedef vector<atom *> atmr_vector;

/*################################################################################################*/

/**	A generic molecule finder class ; this is a simplified version of the
	older (and more complicated) sequence builder class.
*/

class mfinder
{
	protected:
	
	vector<mf_data_atm> main_vector;
	vector<mf_data_atm> conn_vector;
	
//vector<mf_data_RES> resi_vector;
//mf_data_RES * mod[3];

	i32s id;
	
	char symbol1;		// a single-char symbol
	char symbol3[4];	// a three-char string symbol
	
	char * description;
	
	vector<mf_data_atm> atm_vector;
	vector<mf_data_bnd> bnd_vector;
	
//public:
//mf_data_RES(void);
//mf_data_RES(const mf_data_RES &);
//~mf_data_RES(void);

void ReadModification(istream &);
//friend istream & operator>>(istream &, mf_data_RES &);

////////////////////////////////////////////
	
	vector<typerule> head_vector;
	vector<typerule> tail_vector;
	
	char buffer[256];
	
	vector<i32s> id_vector;
	atmr_vector ref_vector;
	
	atmr_vector temporary_vector;
	vector<atmr_vector> path_vector;
	
	friend class model;
	friend class setup1_sf;
	
	public:
	
	mfinder(char *);
	~mfinder(void);
	
	void Identify(model *);
	
	private:
	
	void BuildTemplate(vector<mf_tdata> &, i32s, bool, bool);
	void BuildPartialT(vector<mf_tdata> &, vector<mf_data_atm> &);
	void FindPath(model *, atom *, atom *, i32u = 0);
	bool CheckTemplate(vector<mf_tdata> &, i32s);
};

/*################################################################################################*/

class mf_data_atm
{
	protected:
	
	i32s id;
	i32s prev[3];
	
	element el;
	bondtype bt;
	
	typerule * tr;
	
	f64 ic1[3];
	i32s ic2;
	
	friend class mfinder;
	
	public:
	
	mf_data_atm(void);
	mf_data_atm(const mf_data_atm &);
	~mf_data_atm(void);
	
	friend istream & operator>>(istream &, mf_data_atm &);
	friend ostream & operator<<(ostream &, mf_data_atm &);
};

/*################################################################################################*/

class mf_data_bnd
{
	protected:
	
	i32s atm[2];
	bondtype bt;

	friend class mfinder;
	
	public:
	
	mf_data_bnd(void);
	~mf_data_bnd(void);
	
	friend istream & operator>>(istream &, mf_data_bnd &);
};

/*################################################################################################*/

struct mf_tdata
{
	element el; bondtype bt;
	i32s id[2]; atom * ref;
};

/*################################################################################################*/

#endif	// MFINDER_H

// eof
