// unicode data, built from the unicode standard on: 2022-09-29
// see gen-wcwidth.py
#pragma once
#include "data-types.h"

START_ALLOW_CASE_RANGE

static const char* name_map[37997] = { // {{{
	"NULL",
	"START OF HEADING",
	"START OF TEXT",
	"END OF TEXT",
	"END OF TRANSMISSION",
	"ENQUIRY",
	"ACKNOWLEDGE",
	"BELL",
	"BACKSPACE",
	"CHARACTER TABULATION",
	"LINE FEED (LF)",
	"LINE TABULATION",
	"FORM FEED (FF)",
	"CARRIAGE RETURN (CR)",
	"SHIFT OUT",
	"SHIFT IN",
	"DATA LINK ESCAPE",
	"DEVICE CONTROL ONE",
	"DEVICE CONTROL TWO",
	"DEVICE CONTROL THREE",
	"DEVICE CONTROL FOUR",
	"NEGATIVE ACKNOWLEDGE",
	"SYNCHRONOUS IDLE",
	"END OF TRANSMISSION BLOCK",
	"CANCEL",
	"END OF MEDIUM",
	"SUBSTITUTE",
	"ESCAPE",
	"INFORMATION SEPARATOR FOUR",
	"INFORMATION SEPARATOR THREE",
	"INFORMATION SEPARATOR TWO",
	"INFORMATION SEPARATOR ONE",
	"SPACE",
	"EXCLAMATION MARK",
	"QUOTATION MARK",
	"NUMBER SIGN",
	"DOLLAR SIGN",
	"PERCENT SIGN",
	"AMPERSAND",
	"APOSTROPHE",
	"LEFT PARENTHESIS",
	"RIGHT PARENTHESIS",
	"ASTERISK",
	"PLUS SIGN",
	"COMMA",
	"HYPHEN-MINUS",
	"FULL STOP",
	"SOLIDUS",
	"DIGIT ZERO",
	"DIGIT ONE",
	"DIGIT TWO",
	"DIGIT THREE",
	"DIGIT FOUR",
	"DIGIT FIVE",
	"DIGIT SIX",
	"DIGIT SEVEN",
	"DIGIT EIGHT",
	"DIGIT NINE",
	"COLON",
	"SEMICOLON",
	"LESS-THAN SIGN",
	"EQUALS SIGN",
	"GREATER-THAN SIGN",
	"QUESTION MARK",
	"COMMERCIAL AT",
	"LATIN CAPITAL LETTER A",
	"LATIN CAPITAL LETTER B",
	"LATIN CAPITAL LETTER C",
	"LATIN CAPITAL LETTER D",
	"LATIN CAPITAL LETTER E",
	"LATIN CAPITAL LETTER F",
	"LATIN CAPITAL LETTER G",
	"LATIN CAPITAL LETTER H",
	"LATIN CAPITAL LETTER I",
	"LATIN CAPITAL LETTER J",
	"LATIN CAPITAL LETTER K",
	"LATIN CAPITAL LETTER L",
	"LATIN CAPITAL LETTER M",
	"LATIN CAPITAL LETTER N",
	"LATIN CAPITAL LETTER O",
	"LATIN CAPITAL LETTER P",
	"LATIN CAPITAL LETTER Q",
	"LATIN CAPITAL LETTER R",
	"LATIN CAPITAL LETTER S",
	"LATIN CAPITAL LETTER T",
	"LATIN CAPITAL LETTER U",
	"LATIN CAPITAL LETTER V",
	"LATIN CAPITAL LETTER W",
	"LATIN CAPITAL LETTER X",
	"LATIN CAPITAL LETTER Y",
	"LATIN CAPITAL LETTER Z",
	"LEFT SQUARE BRACKET",
	"REVERSE SOLIDUS",
	"RIGHT SQUARE BRACKET",
	"CIRCUMFLEX ACCENT",
	"LOW LINE",
	"GRAVE ACCENT",
	"LATIN SMALL LETTER A",
	"LATIN SMALL LETTER B",
	"LATIN SMALL LETTER C",
	"LATIN SMALL LETTER D",
	"LATIN SMALL LETTER E",
	"LATIN SMALL LETTER F",
	"LATIN SMALL LETTER G",
	"LATIN SMALL LETTER H",
	"LATIN SMALL LETTER I",
	"LATIN SMALL LETTER J",
	"LATIN SMALL LETTER K",
	"LATIN SMALL LETTER L",
	"LATIN SMALL LETTER M",
	"LATIN SMALL LETTER N",
	"LATIN SMALL LETTER O",
	"LATIN SMALL LETTER P",
	"LATIN SMALL LETTER Q",
	"LATIN SMALL LETTER R",
	"LATIN SMALL LETTER S",
	"LATIN SMALL LETTER T",
	"LATIN SMALL LETTER U",
	"LATIN SMALL LETTER V",
	"LATIN SMALL LETTER W",
	"LATIN SMALL LETTER X",
	"LATIN SMALL LETTER Y",
	"LATIN SMALL LETTER Z",
	"LEFT CURLY BRACKET",
	"VERTICAL LINE",
	"RIGHT CURLY BRACKET",
	"TILDE",
	"DELETE",
	"BREAK PERMITTED HERE",
	"NO BREAK HERE",
	"NEXT LINE (NEL)",
	"START OF SELECTED AREA",
	"END OF SELECTED AREA",
	"CHARACTER TABULATION SET",
	"CHARACTER TABULATION WITH JUSTIFICATION",
	"LINE TABULATION SET",
	"PARTIAL LINE FORWARD",
	"PARTIAL LINE BACKWARD",
	"REVERSE LINE FEED",
	"SINGLE SHIFT TWO",
	"SINGLE SHIFT THREE",
	"DEVICE CONTROL STRING",
	"PRIVATE USE ONE",
	"PRIVATE USE TWO",
	"SET TRANSMIT STATE",
	"CANCEL CHARACTER",
	"MESSAGE WAITING",
	"START OF GUARDED AREA",
	"END OF GUARDED AREA",
	"START OF STRING",
	"SINGLE CHARACTER INTRODUCER",
	"CONTROL SEQUENCE INTRODUCER",
	"STRING TERMINATOR",
	"OPERATING SYSTEM COMMAND",
	"PRIVACY MESSAGE",
	"APPLICATION PROGRAM COMMAND",
	"NO-BREAK SPACE",
	"INVERTED EXCLAMATION MARK",
	"CENT SIGN",
	"POUND SIGN",
	"CURRENCY SIGN",
	"YEN SIGN",
	"BROKEN BAR",
	"SECTION SIGN",
	"DIAERESIS",
	"COPYRIGHT SIGN",
	"FEMININE ORDINAL INDICATOR",
	"LEFT-POINTING DOUBLE ANGLE QUOTATION MARK",
	"NOT SIGN",
	"SOFT HYPHEN",
	"REGISTERED SIGN",
	"MACRON",
	"DEGREE SIGN",
	"PLUS-MINUS SIGN",
	"SUPERSCRIPT TWO",
	"SUPERSCRIPT THREE",
	"ACUTE ACCENT",
	"MICRO SIGN",
	"PILCROW SIGN",
	"MIDDLE DOT",
	"CEDILLA",
	"SUPERSCRIPT ONE",
	"MASCULINE ORDINAL INDICATOR",
	"RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK",
	"VULGAR FRACTION ONE QUARTER",
	"VULGAR FRACTION ONE HALF",
	"VULGAR FRACTION THREE QUARTERS",
	"INVERTED QUESTION MARK",
	"LATIN CAPITAL LETTER A WITH GRAVE",
	"LATIN CAPITAL LETTER A WITH ACUTE",
	"LATIN CAPITAL LETTER A WITH CIRCUMFLEX",
	"LATIN CAPITAL LETTER A WITH TILDE",
	"LATIN CAPITAL LETTER A WITH DIAERESIS",
	"LATIN CAPITAL LETTER A WITH RING ABOVE",
	"LATIN CAPITAL LETTER AE",
	"LATIN CAPITAL LETTER C WITH CEDILLA",
	"LATIN CAPITAL LETTER E WITH GRAVE",
	"LATIN CAPITAL LETTER E WITH ACUTE",
	"LATIN CAPITAL LETTER E WITH CIRCUMFLEX",
	"LATIN CAPITAL LETTER E WITH DIAERESIS",
	"LATIN CAPITAL LETTER I WITH GRAVE",
	"LATIN CAPITAL LETTER I WITH ACUTE",
	"LATIN CAPITAL LETTER I WITH CIRCUMFLEX",
	"LATIN CAPITAL LETTER I WITH DIAERESIS",
	"LATIN CAPITAL LETTER ETH",
	"LATIN CAPITAL LETTER N WITH TILDE",
	"LATIN CAPITAL LETTER O WITH GRAVE",
	"LATIN CAPITAL LETTER O WITH ACUTE",
	"LATIN CAPITAL LETTER O WITH CIRCUMFLEX",
	"LATIN CAPITAL LETTER O WITH TILDE",
	"LATIN CAPITAL LETTER O WITH DIAERESIS",
	"MULTIPLICATION SIGN",
	"LATIN CAPITAL LETTER O WITH STROKE",
	"LATIN CAPITAL LETTER U WITH GRAVE",
	"LATIN CAPITAL LETTER U WITH ACUTE",
	"LATIN CAPITAL LETTER U WITH CIRCUMFLEX",
	"LATIN CAPITAL LETTER U WITH DIAERESIS",
	"LATIN CAPITAL LETTER Y WITH ACUTE",
	"LATIN CAPITAL LETTER THORN",
	"LATIN SMALL LETTER SHARP S",
	"LATIN SMALL LETTER A WITH GRAVE",
	"LATIN SMALL LETTER A WITH ACUTE",
	"LATIN SMALL LETTER A WITH CIRCUMFLEX",
	"LATIN SMALL LETTER A WITH TILDE",
	"LATIN SMALL LETTER A WITH DIAERESIS",
	"LATIN SMALL LETTER A WITH RING ABOVE",
	"LATIN SMALL LETTER AE",
	"LATIN SMALL LETTER C WITH CEDILLA",
	"LATIN SMALL LETTER E WITH GRAVE",
	"LATIN SMALL LETTER E WITH ACUTE",
	"LATIN SMALL LETTER E WITH CIRCUMFLEX",
	"LATIN SMALL LETTER E WITH DIAERESIS",
	"LATIN SMALL LETTER I WITH GRAVE",
	"LATIN SMALL LETTER I WITH ACUTE",
	"LATIN SMALL LETTER I WITH CIRCUMFLEX",
	"LATIN SMALL LETTER I WITH DIAERESIS",
	"LATIN SMALL LETTER ETH",
	"LATIN SMALL LETTER N WITH TILDE",
	"LATIN SMALL LETTER O WITH GRAVE",
	"LATIN SMALL LETTER O WITH ACUTE",
	"LATIN SMALL LETTER O WITH CIRCUMFLEX",
	"LATIN SMALL LETTER O WITH TILDE",
	"LATIN SMALL LETTER O WITH DIAERESIS",
	"DIVISION SIGN",
	"LATIN SMALL LETTER O WITH STROKE",
	"LATIN SMALL LETTER U WITH GRAVE",
	"LATIN SMALL LETTER U WITH ACUTE",
	"LATIN SMALL LETTER U WITH CIRCUMFLEX",
	"LATIN SMALL LETTER U WITH DIAERESIS",
	"LATIN SMALL LETTER Y WITH ACUTE",
	"LATIN SMALL LETTER THORN",
	"LATIN SMALL LETTER Y WITH DIAERESIS",
	"LATIN CAPITAL LETTER A WITH MACRON",
	"LATIN SMALL LETTER A WITH MACRON",
	"LATIN CAPITAL LETTER A WITH BREVE",
	"LATIN SMALL LETTER A WITH BREVE",
	"LATIN CAPITAL LETTER A WITH OGONEK",
	"LATIN SMALL LETTER A WITH OGONEK",
	"LATIN CAPITAL LETTER C WITH ACUTE",
	"LATIN SMALL LETTER C WITH ACUTE",
	"LATIN CAPITAL LETTER C WITH CIRCUMFLEX",
	"LATIN SMALL LETTER C WITH CIRCUMFLEX",
	"LATIN CAPITAL LETTER C WITH DOT ABOVE",
	"LATIN SMALL LETTER C WITH DOT ABOVE",
	"LATIN CAPITAL LETTER C WITH CARON",
	"LATIN SMALL LETTER C WITH CARON",
	"LATIN CAPITAL LETTER D WITH CARON",
	"LATIN SMALL LETTER D WITH CARON",
	"LATIN CAPITAL LETTER D WITH STROKE",
	"LATIN SMALL LETTER D WITH STROKE",
	"LATIN CAPITAL LETTER E WITH MACRON",
	"LATIN SMALL LETTER E WITH MACRON",
	"LATIN CAPITAL LETTER E WITH BREVE",
	"LATIN SMALL LETTER E WITH BREVE",
	"LATIN CAPITAL LETTER E WITH DOT ABOVE",
	"LATIN SMALL LETTER E WITH DOT ABOVE",
	"LATIN CAPITAL LETTER E WITH OGONEK",
	"LATIN SMALL LETTER E WITH OGONEK",
	"LATIN CAPITAL LETTER E WITH CARON",
	"LATIN SMALL LETTER E WITH CARON",
	"LATIN CAPITAL LETTER G WITH CIRCUMFLEX",
	"LATIN SMALL LETTER G WITH CIRCUMFLEX",
	"LATIN CAPITAL LETTER G WITH BREVE",
	"LATIN SMALL LETTER G WITH BREVE",
	"LATIN CAPITAL LETTER G WITH DOT ABOVE",
	"LATIN SMALL LETTER G WITH DOT ABOVE",
	"LATIN CAPITAL LETTER G WITH CEDILLA",
	"LATIN SMALL LETTER G WITH CEDILLA",
	"LATIN CAPITAL LETTER H WITH CIRCUMFLEX",
	"LATIN SMALL LETTER H WITH CIRCUMFLEX",
	"LATIN CAPITAL LETTER H WITH STROKE",
	"LATIN SMALL LETTER H WITH STROKE",
	"LATIN CAPITAL LETTER I WITH TILDE",
	"LATIN SMALL LETTER I WITH TILDE",
	"LATIN CAPITAL LETTER I WITH MACRON",
	"LATIN SMALL LETTER I WITH MACRON",
	"LATIN CAPITAL LETTER I WITH BREVE",
	"LATIN SMALL LETTER I WITH BREVE",
	"LATIN CAPITAL LETTER I WITH OGONEK",
	"LATIN SMALL LETTER I WITH OGONEK",
	"LATIN CAPITAL LETTER I WITH DOT ABOVE",
	"LATIN SMALL LETTER DOTLESS I",
	"LATIN CAPITAL LIGATURE IJ",
	"LATIN SMALL LIGATURE IJ",
	"LATIN CAPITAL LETTER J WITH CIRCUMFLEX",
	"LATIN SMALL LETTER J WITH CIRCUMFLEX",
	"LATIN CAPITAL LETTER K WITH CEDILLA",
	"LATIN SMALL LETTER K WITH CEDILLA",
	"LATIN SMALL LETTER KRA",
	"LATIN CAPITAL LETTER L WITH ACUTE",
	"LATIN SMALL LETTER L WITH ACUTE",
	"LATIN CAPITAL LETTER L WITH CEDILLA",
	"LATIN SMALL LETTER L WITH CEDILLA",
	"LATIN CAPITAL LETTER L WITH CARON",
	"LATIN SMALL LETTER L WITH CARON",
	"LATIN CAPITAL LETTER L WITH MIDDLE DOT",
	"LATIN SMALL LETTER L WITH MIDDLE DOT",
	"LATIN CAPITAL LETTER L WITH STROKE",
	"LATIN SMALL LETTER L WITH STROKE",
	"LATIN CAPITAL LETTER N WITH ACUTE",
	"LATIN SMALL LETTER N WITH ACUTE",
	"LATIN CAPITAL LETTER N WITH CEDILLA",
	"LATIN SMALL LETTER N WITH CEDILLA",
	"LATIN CAPITAL LETTER N WITH CARON",
	"LATIN SMALL LETTER N WITH CARON",
	"LATIN SMALL LETTER N PRECEDED BY APOSTROPHE",
	"LATIN CAPITAL LETTER ENG",
	"LATIN SMALL LETTER ENG",
	"LATIN CAPITAL LETTER O WITH MACRON",
	"LATIN SMALL LETTER O WITH MACRON",
	"LATIN CAPITAL LETTER O WITH BREVE",
	"LATIN SMALL LETTER O WITH BREVE",
	"LATIN CAPITAL LETTER O WITH DOUBLE ACUTE",
	"LATIN SMALL LETTER O WITH DOUBLE ACUTE",
	"LATIN CAPITAL LIGATURE OE",
	"LATIN SMALL LIGATURE OE",
	"LATIN CAPITAL LETTER R WITH ACUTE",
	"LATIN SMALL LETTER R WITH ACUTE",
	"LATIN CAPITAL LETTER R WITH CEDILLA",
	"LATIN SMALL LETTER R WITH CEDILLA",
	"LATIN CAPITAL LETTER R WITH CARON",
	"LATIN SMALL LETTER R WITH CARON",
	"LATIN CAPITAL LETTER S WITH ACUTE",
	"LATIN SMALL LETTER S WITH ACUTE",
	"LATIN CAPITAL LETTER S WITH CIRCUMFLEX",
	"LATIN SMALL LETTER S WITH CIRCUMFLEX",
	"LATIN CAPITAL LETTER S WITH CEDILLA",
	"LATIN SMALL LETTER S WITH CEDILLA",
	"LATIN CAPITAL LETTER S WITH CARON",
	"LATIN SMALL LETTER S WITH CARON",
	"LATIN CAPITAL LETTER T WITH CEDILLA",
	"LATIN SMALL LETTER T WITH CEDILLA",
	"LATIN CAPITAL LETTER T WITH CARON",
	"LATIN SMALL LETTER T WITH CARON",
	"LATIN CAPITAL LETTER T WITH STROKE",
	"LATIN SMALL LETTER T WITH STROKE",
	"LATIN CAPITAL LETTER U WITH TILDE",
	"LATIN SMALL LETTER U WITH TILDE",
	"LATIN CAPITAL LETTER U WITH MACRON",
	"LATIN SMALL LETTER U WITH MACRON",
	"LATIN CAPITAL LETTER U WITH BREVE",
	"LATIN SMALL LETTER U WITH BREVE",
	"LATIN CAPITAL LETTER U WITH RING ABOVE",
	"LATIN SMALL LETTER U WITH RING ABOVE",
	"LATIN CAPITAL LETTER U WITH DOUBLE ACUTE",
	"LATIN SMALL LETTER U WITH DOUBLE ACUTE",
	"LATIN CAPITAL LETTER U WITH OGONEK",
	"LATIN SMALL LETTER U WITH OGONEK",
	"LATIN CAPITAL LETTER W WITH CIRCUMFLEX",
	"LATIN SMALL LETTER W WITH CIRCUMFLEX",
	"LATIN CAPITAL LETTER Y WITH CIRCUMFLEX",
	"LATIN SMALL LETTER Y WITH CIRCUMFLEX",
	"LATIN CAPITAL LETTER Y WITH DIAERESIS",
	"LATIN CAPITAL LETTER Z WITH ACUTE",
	"LATIN SMALL LETTER Z WITH ACUTE",
	"LATIN CAPITAL LETTER Z WITH DOT ABOVE",
	"LATIN SMALL LETTER Z WITH DOT ABOVE",
	"LATIN CAPITAL LETTER Z WITH CARON",
	"LATIN SMALL LETTER Z WITH CARON",
	"LATIN SMALL LETTER LONG S",
	"LATIN SMALL LETTER B WITH STROKE",
	"LATIN CAPITAL LETTER B WITH HOOK",
	"LATIN CAPITAL LETTER B WITH TOPBAR",
	"LATIN SMALL LETTER B WITH TOPBAR",
	"LATIN CAPITAL LETTER TONE SIX",
	"LATIN SMALL LETTER TONE SIX",
	"LATIN CAPITAL LETTER OPEN O",
	"LATIN CAPITAL LETTER C WITH HOOK",
	"LATIN SMALL LETTER C WITH HOOK",
	"LATIN CAPITAL LETTER AFRICAN D",
	"LATIN CAPITAL LETTER D WITH HOOK",
	"LATIN CAPITAL LETTER D WITH TOPBAR",
	"LATIN SMALL LETTER D WITH TOPBAR",
	"LATIN SMALL LETTER TURNED DELTA",
	"LATIN CAPITAL LETTER REVERSED E",
	"LATIN CAPITAL LETTER SCHWA",
	"LATIN CAPITAL LETTER OPEN E",
	"LATIN CAPITAL LETTER F WITH HOOK",
	"LATIN SMALL LETTER F WITH HOOK",
	"LATIN CAPITAL LETTER G WITH HOOK",
	"LATIN CAPITAL LETTER GAMMA",
	"LATIN SMALL LETTER HV",
	"LATIN CAPITAL LETTER IOTA",
	"LATIN CAPITAL LETTER I WITH STROKE",
	"LATIN CAPITAL LETTER K WITH HOOK",
	"LATIN SMALL LETTER K WITH HOOK",
	"LATIN SMALL LETTER L WITH BAR",
	"LATIN SMALL LETTER LAMBDA WITH STROKE",
	"LATIN CAPITAL LETTER TURNED M",
	"LATIN CAPITAL LETTER N WITH LEFT HOOK",
	"LATIN SMALL LETTER N WITH LONG RIGHT LEG",
	"LATIN CAPITAL LETTER O WITH MIDDLE TILDE",
	"LATIN CAPITAL LETTER O WITH HORN",
	"LATIN SMALL LETTER O WITH HORN",
	"LATIN CAPITAL LETTER OI",
	"LATIN SMALL LETTER OI",
	"LATIN CAPITAL LETTER P WITH HOOK",
	"LATIN SMALL LETTER P WITH HOOK",
	"LATIN LETTER YR",
	"LATIN CAPITAL LETTER TONE TWO",
	"LATIN SMALL LETTER TONE TWO",
	"LATIN CAPITAL LETTER ESH",
	"LATIN LETTER REVERSED ESH LOOP",
	"LATIN SMALL LETTER T WITH PALATAL HOOK",
	"LATIN CAPITAL LETTER T WITH HOOK",
	"LATIN SMALL LETTER T WITH HOOK",
	"LATIN CAPITAL LETTER T WITH RETROFLEX HOOK",
	"LATIN CAPITAL LETTER U WITH HORN",
	"LATIN SMALL LETTER U WITH HORN",
	"LATIN CAPITAL LETTER UPSILON",
	"LATIN CAPITAL LETTER V WITH HOOK",
	"LATIN CAPITAL LETTER Y WITH HOOK",
	"LATIN SMALL LETTER Y WITH HOOK",
	"LATIN CAPITAL LETTER Z WITH STROKE",
	"LATIN SMALL LETTER Z WITH STROKE",
	"LATIN CAPITAL LETTER EZH",
	"LATIN CAPITAL LETTER EZH REVERSED",
	"LATIN SMALL LETTER EZH REVERSED",
	"LATIN SMALL LETTER EZH WITH TAIL",
	"LATIN LETTER TWO WITH STROKE",
	"LATIN CAPITAL LETTER TONE FIVE",
	"LATIN SMALL LETTER TONE FIVE",
	"LATIN LETTER INVERTED GLOTTAL STOP WITH STROKE",
	"LATIN LETTER WYNN",
	"LATIN LETTER DENTAL CLICK",
	"LATIN LETTER LATERAL CLICK",
	"LATIN LETTER ALVEOLAR CLICK",
	"LATIN LETTER RETROFLEX CLICK",
	"LATIN CAPITAL LETTER DZ WITH CARON",
	"LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON",
	"LATIN SMALL LETTER DZ WITH CARON",
	"LATIN CAPITAL LETTER LJ",
	"LATIN CAPITAL LETTER L WITH SMALL LETTER J",
	"LATIN SMALL LETTER LJ",
	"LATIN CAPITAL LETTER NJ",
	"LATIN CAPITAL LETTER N WITH SMALL LETTER J",
	"LATIN SMALL LETTER NJ",
	"LATIN CAPITAL LETTER A WITH CARON",
	"LATIN SMALL LETTER A WITH CARON",
	"LATIN CAPITAL LETTER I WITH CARON",
	"LATIN SMALL LETTER I WITH CARON",
	"LATIN CAPITAL LETTER O WITH CARON",
	"LATIN SMALL LETTER O WITH CARON",
	"LATIN CAPITAL LETTER U WITH CARON",
	"LATIN SMALL LETTER U WITH CARON",
	"LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON",
	"LATIN SMALL LETTER U WITH DIAERESIS AND MACRON",
	"LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE",
	"LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE",
	"LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON",
	"LATIN SMALL LETTER U WITH DIAERESIS AND CARON",
	"LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE",
	"LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE",
	"LATIN SMALL LETTER TURNED E",
	"LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON",
	"LATIN SMALL LETTER A WITH DIAERESIS AND MACRON",
	"LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON",
	"LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON",
	"LATIN CAPITAL LETTER AE WITH MACRON",
	"LATIN SMALL LETTER AE WITH MACRON",
	"LATIN CAPITAL LETTER G WITH STROKE",
	"LATIN SMALL LETTER G WITH STROKE",
	"LATIN CAPITAL LETTER G WITH CARON",
	"LATIN SMALL LETTER G WITH CARON",
	"LATIN CAPITAL LETTER K WITH CARON",
	"LATIN SMALL LETTER K WITH CARON",
	"LATIN CAPITAL LETTER O WITH OGONEK",
	"LATIN SMALL LETTER O WITH OGONEK",
	"LATIN CAPITAL LETTER O WITH OGONEK AND MACRON",
	"LATIN SMALL LETTER O WITH OGONEK AND MACRON",
	"LATIN CAPITAL LETTER EZH WITH CARON",
	"LATIN SMALL LETTER EZH WITH CARON",
	"LATIN SMALL LETTER J WITH CARON",
	"LATIN CAPITAL LETTER DZ",
	"LATIN CAPITAL LETTER D WITH SMALL LETTER Z",
	"LATIN SMALL LETTER DZ",
	"LATIN CAPITAL LETTER G WITH ACUTE",
	"LATIN SMALL LETTER G WITH ACUTE",
	"LATIN CAPITAL LETTER HWAIR",
	"LATIN CAPITAL LETTER WYNN",
	"LATIN CAPITAL LETTER N WITH GRAVE",
	"LATIN SMALL LETTER N WITH GRAVE",
	"LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE",
	"LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE",
	"LATIN CAPITAL LETTER AE WITH ACUTE",
	"LATIN SMALL LETTER AE WITH ACUTE",
	"LATIN CAPITAL LETTER O WITH STROKE AND ACUTE",
	"LATIN SMALL LETTER O WITH STROKE AND ACUTE",
	"LATIN CAPITAL LETTER A WITH DOUBLE GRAVE",
	"LATIN SMALL LETTER A WITH DOUBLE GRAVE",
	"LATIN CAPITAL LETTER A WITH INVERTED BREVE",
	"LATIN SMALL LETTER A WITH INVERTED BREVE",
	"LATIN CAPITAL LETTER E WITH DOUBLE GRAVE",
	"LATIN SMALL LETTER E WITH DOUBLE GRAVE",
	"LATIN CAPITAL LETTER E WITH INVERTED BREVE",
	"LATIN SMALL LETTER E WITH INVERTED BREVE",
	"LATIN CAPITAL LETTER I WITH DOUBLE GRAVE",
	"LATIN SMALL LETTER I WITH DOUBLE GRAVE",
	"LATIN CAPITAL LETTER I WITH INVERTED BREVE",
	"LATIN SMALL LETTER I WITH INVERTED BREVE",
	"LATIN CAPITAL LETTER O WITH DOUBLE GRAVE",
	"LATIN SMALL LETTER O WITH DOUBLE GRAVE",
	"LATIN CAPITAL LETTER O WITH INVERTED BREVE",
	"LATIN SMALL LETTER O WITH INVERTED BREVE",
	"LATIN CAPITAL LETTER R WITH DOUBLE GRAVE",
	"LATIN SMALL LETTER R WITH DOUBLE GRAVE",
	"LATIN CAPITAL LETTER R WITH INVERTED BREVE",
	"LATIN SMALL LETTER R WITH INVERTED BREVE",
	"LATIN CAPITAL LETTER U WITH DOUBLE GRAVE",
	"LATIN SMALL LETTER U WITH DOUBLE GRAVE",
	"LATIN CAPITAL LETTER U WITH INVERTED BREVE",
	"LATIN SMALL LETTER U WITH INVERTED BREVE",
	"LATIN CAPITAL LETTER S WITH COMMA BELOW",
	"LATIN SMALL LETTER S WITH COMMA BELOW",
	"LATIN CAPITAL LETTER T WITH COMMA BELOW",
	"LATIN SMALL LETTER T WITH COMMA BELOW",
	"LATIN CAPITAL LETTER YOGH",
	"LATIN SMALL LETTER YOGH",
	"LATIN CAPITAL LETTER H WITH CARON",
	"LATIN SMALL LETTER H WITH CARON",
	"LATIN CAPITAL LETTER N WITH LONG RIGHT LEG",
	"LATIN SMALL LETTER D WITH CURL",
	"LATIN CAPITAL LETTER OU",
	"LATIN SMALL LETTER OU",
	"LATIN CAPITAL LETTER Z WITH HOOK",
	"LATIN SMALL LETTER Z WITH HOOK",
	"LATIN CAPITAL LETTER A WITH DOT ABOVE",
	"LATIN SMALL LETTER A WITH DOT ABOVE",
	"LATIN CAPITAL LETTER E WITH CEDILLA",
	"LATIN SMALL LETTER E WITH CEDILLA",
	"LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON",
	"LATIN SMALL LETTER O WITH DIAERESIS AND MACRON",
	"LATIN CAPITAL LETTER O WITH TILDE AND MACRON",
	"LATIN SMALL LETTER O WITH TILDE AND MACRON",
	"LATIN CAPITAL LETTER O WITH DOT ABOVE",
	"LATIN SMALL LETTER O WITH DOT ABOVE",
	"LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON",
	"LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON",
	"LATIN CAPITAL LETTER Y WITH MACRON",
	"LATIN SMALL LETTER Y WITH MACRON",
	"LATIN SMALL LETTER L WITH CURL",
	"LATIN SMALL LETTER N WITH CURL",
	"LATIN SMALL LETTER T WITH CURL",
	"LATIN SMALL LETTER DOTLESS J",
	"LATIN SMALL LETTER DB DIGRAPH",
	"LATIN SMALL LETTER QP DIGRAPH",
	"LATIN CAPITAL LETTER A WITH STROKE",
	"LATIN CAPITAL LETTER C WITH STROKE",
	"LATIN SMALL LETTER C WITH STROKE",
	"LATIN CAPITAL LETTER L WITH BAR",
	"LATIN CAPITAL LETTER T WITH DIAGONAL STROKE",
	"LATIN SMALL LETTER S WITH SWASH TAIL",
	"LATIN SMALL LETTER Z WITH SWASH TAIL",
	"LATIN CAPITAL LETTER GLOTTAL STOP",
	"LATIN SMALL LETTER GLOTTAL STOP",
	"LATIN CAPITAL LETTER B WITH STROKE",
	"LATIN CAPITAL LETTER U BAR",
	"LATIN CAPITAL LETTER TURNED V",
	"LATIN CAPITAL LETTER E WITH STROKE",
	"LATIN SMALL LETTER E WITH STROKE",
	"LATIN CAPITAL LETTER J WITH STROKE",
	"LATIN SMALL LETTER J WITH STROKE",
	"LATIN CAPITAL LETTER SMALL Q WITH HOOK TAIL",
	"LATIN SMALL LETTER Q WITH HOOK TAIL",
	"LATIN CAPITAL LETTER R WITH STROKE",
	"LATIN SMALL LETTER R WITH STROKE",
	"LATIN CAPITAL LETTER Y WITH STROKE",
	"LATIN SMALL LETTER Y WITH STROKE",
	"LATIN SMALL LETTER TURNED A",
	"LATIN SMALL LETTER ALPHA",
	"LATIN SMALL LETTER TURNED ALPHA",
	"LATIN SMALL LETTER B WITH HOOK",
	"LATIN SMALL LETTER OPEN O",
	"LATIN SMALL LETTER C WITH CURL",
	"LATIN SMALL LETTER D WITH TAIL",
	"LATIN SMALL LETTER D WITH HOOK",
	"LATIN SMALL LETTER REVERSED E",
	"LATIN SMALL LETTER SCHWA",
	"LATIN SMALL LETTER SCHWA WITH HOOK",
	"LATIN SMALL LETTER OPEN E",
	"LATIN SMALL LETTER REVERSED OPEN E",
	"LATIN SMALL LETTER REVERSED OPEN E WITH HOOK",
	"LATIN SMALL LETTER CLOSED REVERSED OPEN E",
	"LATIN SMALL LETTER DOTLESS J WITH STROKE",
	"LATIN SMALL LETTER G WITH HOOK",
	"LATIN SMALL LETTER SCRIPT G",
	"LATIN LETTER SMALL CAPITAL G",
	"LATIN SMALL LETTER GAMMA",
	"LATIN SMALL LETTER RAMS HORN",
	"LATIN SMALL LETTER TURNED H",
	"LATIN SMALL LETTER H WITH HOOK",
	"LATIN SMALL LETTER HENG WITH HOOK",
	"LATIN SMALL LETTER I WITH STROKE",
	"LATIN SMALL LETTER IOTA",
	"LATIN LETTER SMALL CAPITAL I",
	"LATIN SMALL LETTER L WITH MIDDLE TILDE",
	"LATIN SMALL LETTER L WITH BELT",
	"LATIN SMALL LETTER L WITH RETROFLEX HOOK",
	"LATIN SMALL LETTER LEZH",
	"LATIN SMALL LETTER TURNED M",
	"LATIN SMALL LETTER TURNED M WITH LONG LEG",
	"LATIN SMALL LETTER M WITH HOOK",
	"LATIN SMALL LETTER N WITH LEFT HOOK",
	"LATIN SMALL LETTER N WITH RETROFLEX HOOK",
	"LATIN LETTER SMALL CAPITAL N",
	"LATIN SMALL LETTER BARRED O",
	"LATIN LETTER SMALL CAPITAL OE",
	"LATIN SMALL LETTER CLOSED OMEGA",
	"LATIN SMALL LETTER PHI",
	"LATIN SMALL LETTER TURNED R",
	"LATIN SMALL LETTER TURNED R WITH LONG LEG",
	"LATIN SMALL LETTER TURNED R WITH HOOK",
	"LATIN SMALL LETTER R WITH LONG LEG",
	"LATIN SMALL LETTER R WITH TAIL",
	"LATIN SMALL LETTER R WITH FISHHOOK",
	"LATIN SMALL LETTER REVERSED R WITH FISHHOOK",
	"LATIN LETTER SMALL CAPITAL R",
	"LATIN LETTER SMALL CAPITAL INVERTED R",
	"LATIN SMALL LETTER S WITH HOOK",
	"LATIN SMALL LETTER ESH",
	"LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK",
	"LATIN SMALL LETTER SQUAT REVERSED ESH",
	"LATIN SMALL LETTER ESH WITH CURL",
	"LATIN SMALL LETTER TURNED T",
	"LATIN SMALL LETTER T WITH RETROFLEX HOOK",
	"LATIN SMALL LETTER U BAR",
	"LATIN SMALL LETTER UPSILON",
	"LATIN SMALL LETTER V WITH HOOK",
	"LATIN SMALL LETTER TURNED V",
	"LATIN SMALL LETTER TURNED W",
	"LATIN SMALL LETTER TURNED Y",
	"LATIN LETTER SMALL CAPITAL Y",
	"LATIN SMALL LETTER Z WITH RETROFLEX HOOK",
	"LATIN SMALL LETTER Z WITH CURL",
	"LATIN SMALL LETTER EZH",
	"LATIN SMALL LETTER EZH WITH CURL",
	"LATIN LETTER GLOTTAL STOP",
	"LATIN LETTER PHARYNGEAL VOICED FRICATIVE",
	"LATIN LETTER INVERTED GLOTTAL STOP",
	"LATIN LETTER STRETCHED C",
	"LATIN LETTER BILABIAL CLICK",
	"LATIN LETTER SMALL CAPITAL B",
	"LATIN SMALL LETTER CLOSED OPEN E",
	"LATIN LETTER SMALL CAPITAL G WITH HOOK",
	"LATIN LETTER SMALL CAPITAL H",
	"LATIN SMALL LETTER J WITH CROSSED-TAIL",
	"LATIN SMALL LETTER TURNED K",
	"LATIN LETTER SMALL CAPITAL L",
	"LATIN SMALL LETTER Q WITH HOOK",
	"LATIN LETTER GLOTTAL STOP WITH STROKE",
	"LATIN LETTER REVERSED GLOTTAL STOP WITH STROKE",
	"LATIN SMALL LETTER DZ DIGRAPH",
	"LATIN SMALL LETTER DEZH DIGRAPH",
	"LATIN SMALL LETTER DZ DIGRAPH WITH CURL",
	"LATIN SMALL LETTER TS DIGRAPH",
	"LATIN SMALL LETTER TESH DIGRAPH",
	"LATIN SMALL LETTER TC DIGRAPH WITH CURL",
	"LATIN SMALL LETTER FENG DIGRAPH",
	"LATIN SMALL LETTER LS DIGRAPH",
	"LATIN SMALL LETTER LZ DIGRAPH",
	"LATIN LETTER BILABIAL PERCUSSIVE",
	"LATIN LETTER BIDENTAL PERCUSSIVE",
	"LATIN SMALL LETTER TURNED H WITH FISHHOOK",
	"LATIN SMALL LETTER TURNED H WITH FISHHOOK AND TAIL",
	"MODIFIER LETTER SMALL H",
	"MODIFIER LETTER SMALL H WITH HOOK",
	"MODIFIER LETTER SMALL J",
	"MODIFIER LETTER SMALL R",
	"MODIFIER LETTER SMALL TURNED R",
	"MODIFIER LETTER SMALL TURNED R WITH HOOK",
	"MODIFIER LETTER SMALL CAPITAL INVERTED R",
	"MODIFIER LETTER SMALL W",
	"MODIFIER LETTER SMALL Y",
	"MODIFIER LETTER PRIME",
	"MODIFIER LETTER DOUBLE PRIME",
	"MODIFIER LETTER TURNED COMMA",
	"MODIFIER LETTER APOSTROPHE",
	"MODIFIER LETTER REVERSED COMMA",
	"MODIFIER LETTER RIGHT HALF RING",
	"MODIFIER LETTER LEFT HALF RING",
	"MODIFIER LETTER GLOTTAL STOP",
	"MODIFIER LETTER REVERSED GLOTTAL STOP",
	"MODIFIER LETTER LEFT ARROWHEAD",
	"MODIFIER LETTER RIGHT ARROWHEAD",
	"MODIFIER LETTER UP ARROWHEAD",
	"MODIFIER LETTER DOWN ARROWHEAD",
	"MODIFIER LETTER CIRCUMFLEX ACCENT",
	"CARON",
	"MODIFIER LETTER VERTICAL LINE",
	"MODIFIER LETTER MACRON",
	"MODIFIER LETTER ACUTE ACCENT",
	"MODIFIER LETTER GRAVE ACCENT",
	"MODIFIER LETTER LOW VERTICAL LINE",
	"MODIFIER LETTER LOW MACRON",
	"MODIFIER LETTER LOW GRAVE ACCENT",
	"MODIFIER LETTER LOW ACUTE ACCENT",
	"MODIFIER LETTER TRIANGULAR COLON",
	"MODIFIER LETTER HALF TRIANGULAR COLON",
	"MODIFIER LETTER CENTRED RIGHT HALF RING",
	"MODIFIER LETTER CENTRED LEFT HALF RING",
	"MODIFIER LETTER UP TACK",
	"MODIFIER LETTER DOWN TACK",
	"MODIFIER LETTER PLUS SIGN",
	"MODIFIER LETTER MINUS SIGN",
	"BREVE",
	"DOT ABOVE",
	"RING ABOVE",
	"OGONEK",
	"SMALL TILDE",
	"DOUBLE ACUTE ACCENT",
	"MODIFIER LETTER RHOTIC HOOK",
	"MODIFIER LETTER CROSS ACCENT",
	"MODIFIER LETTER SMALL GAMMA",
	"MODIFIER LETTER SMALL L",
	"MODIFIER LETTER SMALL S",
	"MODIFIER LETTER SMALL X",
	"MODIFIER LETTER SMALL REVERSED GLOTTAL STOP",
	"MODIFIER LETTER EXTRA-HIGH TONE BAR",
	"MODIFIER LETTER HIGH TONE BAR",
	"MODIFIER LETTER MID TONE BAR",
	"MODIFIER LETTER LOW TONE BAR",
	"MODIFIER LETTER EXTRA-LOW TONE BAR",
	"MODIFIER LETTER YIN DEPARTING TONE MARK",
	"MODIFIER LETTER YANG DEPARTING TONE MARK",
	"MODIFIER LETTER VOICING",
	"MODIFIER LETTER UNASPIRATED",
	"MODIFIER LETTER DOUBLE APOSTROPHE",
	"MODIFIER LETTER LOW DOWN ARROWHEAD",
	"MODIFIER LETTER LOW UP ARROWHEAD",
	"MODIFIER LETTER LOW LEFT ARROWHEAD",
	"MODIFIER LETTER LOW RIGHT ARROWHEAD",
	"MODIFIER LETTER LOW RING",
	"MODIFIER LETTER MIDDLE GRAVE ACCENT",
	"MODIFIER LETTER MIDDLE DOUBLE GRAVE ACCENT",
	"MODIFIER LETTER MIDDLE DOUBLE ACUTE ACCENT",
	"MODIFIER LETTER LOW TILDE",
	"MODIFIER LETTER RAISED COLON",
	"MODIFIER LETTER BEGIN HIGH TONE",
	"MODIFIER LETTER END HIGH TONE",
	"MODIFIER LETTER BEGIN LOW TONE",
	"MODIFIER LETTER END LOW TONE",
	"MODIFIER LETTER SHELF",
	"MODIFIER LETTER OPEN SHELF",
	"MODIFIER LETTER LOW LEFT ARROW",
	"COMBINING GRAVE ACCENT",
	"COMBINING ACUTE ACCENT",
	"COMBINING CIRCUMFLEX ACCENT",
	"COMBINING TILDE",
	"COMBINING MACRON",
	"COMBINING OVERLINE",
	"COMBINING BREVE",
	"COMBINING DOT ABOVE",
	"COMBINING DIAERESIS",
	"COMBINING HOOK ABOVE",
	"COMBINING RING ABOVE",
	"COMBINING DOUBLE ACUTE ACCENT",
	"COMBINING CARON",
	"COMBINING VERTICAL LINE ABOVE",
	"COMBINING DOUBLE VERTICAL LINE ABOVE",
	"COMBINING DOUBLE GRAVE ACCENT",
	"COMBINING CANDRABINDU",
	"COMBINING INVERTED BREVE",
	"COMBINING TURNED COMMA ABOVE",
	"COMBINING COMMA ABOVE",
	"COMBINING REVERSED COMMA ABOVE",
	"COMBINING COMMA ABOVE RIGHT",
	"COMBINING GRAVE ACCENT BELOW",
	"COMBINING ACUTE ACCENT BELOW",
	"COMBINING LEFT TACK BELOW",
	"COMBINING RIGHT TACK BELOW",
	"COMBINING LEFT ANGLE ABOVE",
	"COMBINING HORN",
	"COMBINING LEFT HALF RING BELOW",
	"COMBINING UP TACK BELOW",
	"COMBINING DOWN TACK BELOW",
	"COMBINING PLUS SIGN BELOW",
	"COMBINING MINUS SIGN BELOW",
	"COMBINING PALATALIZED HOOK BELOW",
	"COMBINING RETROFLEX HOOK BELOW",
	"COMBINING DOT BELOW",
	"COMBINING DIAERESIS BELOW",
	"COMBINING RING BELOW",
	"COMBINING COMMA BELOW",
	"COMBINING CEDILLA",
	"COMBINING OGONEK",
	"COMBINING VERTICAL LINE BELOW",
	"COMBINING BRIDGE BELOW",
	"COMBINING INVERTED DOUBLE ARCH BELOW",
	"COMBINING CARON BELOW",
	"COMBINING CIRCUMFLEX ACCENT BELOW",
	"COMBINING BREVE BELOW",
	"COMBINING INVERTED BREVE BELOW",
	"COMBINING TILDE BELOW",
	"COMBINING MACRON BELOW",
	"COMBINING LOW LINE",
	"COMBINING DOUBLE LOW LINE",
	"COMBINING TILDE OVERLAY",
	"COMBINING SHORT STROKE OVERLAY",
	"COMBINING LONG STROKE OVERLAY",
	"COMBINING SHORT SOLIDUS OVERLAY",
	"COMBINING LONG SOLIDUS OVERLAY",
	"COMBINING RIGHT HALF RING BELOW",
	"COMBINING INVERTED BRIDGE BELOW",
	"COMBINING SQUARE BELOW",
	"COMBINING SEAGULL BELOW",
	"COMBINING X ABOVE",
	"COMBINING VERTICAL TILDE",
	"COMBINING DOUBLE OVERLINE",
	"COMBINING GRAVE TONE MARK",
	"COMBINING ACUTE TONE MARK",
	"COMBINING GREEK PERISPOMENI",
	"COMBINING GREEK KORONIS",
	"COMBINING GREEK DIALYTIKA TONOS",
	"COMBINING GREEK YPOGEGRAMMENI",
	"COMBINING BRIDGE ABOVE",
	"COMBINING EQUALS SIGN BELOW",
	"COMBINING DOUBLE VERTICAL LINE BELOW",
	"COMBINING LEFT ANGLE BELOW",
	"COMBINING NOT TILDE ABOVE",
	"COMBINING HOMOTHETIC ABOVE",
	"COMBINING ALMOST EQUAL TO ABOVE",
	"COMBINING LEFT RIGHT ARROW BELOW",
	"COMBINING UPWARDS ARROW BELOW",
	"COMBINING GRAPHEME JOINER",
	"COMBINING RIGHT ARROWHEAD ABOVE",
	"COMBINING LEFT HALF RING ABOVE",
	"COMBINING FERMATA",
	"COMBINING X BELOW",
	"COMBINING LEFT ARROWHEAD BELOW",
	"COMBINING RIGHT ARROWHEAD BELOW",
	"COMBINING RIGHT ARROWHEAD AND UP ARROWHEAD BELOW",
	"COMBINING RIGHT HALF RING ABOVE",
	"COMBINING DOT ABOVE RIGHT",
	"COMBINING ASTERISK BELOW",
	"COMBINING DOUBLE RING BELOW",
	"COMBINING ZIGZAG ABOVE",
	"COMBINING DOUBLE BREVE BELOW",
	"COMBINING DOUBLE BREVE",
	"COMBINING DOUBLE MACRON",
	"COMBINING DOUBLE MACRON BELOW",
	"COMBINING DOUBLE TILDE",
	"COMBINING DOUBLE INVERTED BREVE",
	"COMBINING DOUBLE RIGHTWARDS ARROW BELOW",
	"COMBINING LATIN SMALL LETTER A",
	"COMBINING LATIN SMALL LETTER E",
	"COMBINING LATIN SMALL LETTER I",
	"COMBINING LATIN SMALL LETTER O",
	"COMBINING LATIN SMALL LETTER U",
	"COMBINING LATIN SMALL LETTER C",
	"COMBINING LATIN SMALL LETTER D",
	"COMBINING LATIN SMALL LETTER H",
	"COMBINING LATIN SMALL LETTER M",
	"COMBINING LATIN SMALL LETTER R",
	"COMBINING LATIN SMALL LETTER T",
	"COMBINING LATIN SMALL LETTER V",
	"COMBINING LATIN SMALL LETTER X",
	"GREEK CAPITAL LETTER HETA",
	"GREEK SMALL LETTER HETA",
	"GREEK CAPITAL LETTER ARCHAIC SAMPI",
	"GREEK SMALL LETTER ARCHAIC SAMPI",
	"GREEK NUMERAL SIGN",
	"GREEK LOWER NUMERAL SIGN",
	"GREEK CAPITAL LETTER PAMPHYLIAN DIGAMMA",
	"GREEK SMALL LETTER PAMPHYLIAN DIGAMMA",
	"GREEK YPOGEGRAMMENI",
	"GREEK SMALL REVERSED LUNATE SIGMA SYMBOL",
	"GREEK SMALL DOTTED LUNATE SIGMA SYMBOL",
	"GREEK SMALL REVERSED DOTTED LUNATE SIGMA SYMBOL",
	"GREEK QUESTION MARK",
	"GREEK CAPITAL LETTER YOT",
	"GREEK TONOS",
	"GREEK DIALYTIKA TONOS",
	"GREEK CAPITAL LETTER ALPHA WITH TONOS",
	"GREEK ANO TELEIA",
	"GREEK CAPITAL LETTER EPSILON WITH TONOS",
	"GREEK CAPITAL LETTER ETA WITH TONOS",
	"GREEK CAPITAL LETTER IOTA WITH TONOS",
	"GREEK CAPITAL LETTER OMICRON WITH TONOS",
	"GREEK CAPITAL LETTER UPSILON WITH TONOS",
	"GREEK CAPITAL LETTER OMEGA WITH TONOS",
	"GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS",
	"GREEK CAPITAL LETTER ALPHA",
	"GREEK CAPITAL LETTER BETA",
	"GREEK CAPITAL LETTER GAMMA",
	"GREEK CAPITAL LETTER DELTA",
	"GREEK CAPITAL LETTER EPSILON",
	"GREEK CAPITAL LETTER ZETA",
	"GREEK CAPITAL LETTER ETA",
	"GREEK CAPITAL LETTER THETA",
	"GREEK CAPITAL LETTER IOTA",
	"GREEK CAPITAL LETTER KAPPA",
	"GREEK CAPITAL LETTER LAMDA",
	"GREEK CAPITAL LETTER MU",
	"GREEK CAPITAL LETTER NU",
	"GREEK CAPITAL LETTER XI",
	"GREEK CAPITAL LETTER OMICRON",
	"GREEK CAPITAL LETTER PI",
	"GREEK CAPITAL LETTER RHO",
	"GREEK CAPITAL LETTER SIGMA",
	"GREEK CAPITAL LETTER TAU",
	"GREEK CAPITAL LETTER UPSILON",
	"GREEK CAPITAL LETTER PHI",
	"GREEK CAPITAL LETTER CHI",
	"GREEK CAPITAL LETTER PSI",
	"GREEK CAPITAL LETTER OMEGA",
	"GREEK CAPITAL LETTER IOTA WITH DIALYTIKA",
	"GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA",
	"GREEK SMALL LETTER ALPHA WITH TONOS",
	"GREEK SMALL LETTER EPSILON WITH TONOS",
	"GREEK SMALL LETTER ETA WITH TONOS",
	"GREEK SMALL LETTER IOTA WITH TONOS",
	"GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS",
	"GREEK SMALL LETTER ALPHA",
	"GREEK SMALL LETTER BETA",
	"GREEK SMALL LETTER GAMMA",
	"GREEK SMALL LETTER DELTA",
	"GREEK SMALL LETTER EPSILON",
	"GREEK SMALL LETTER ZETA",
	"GREEK SMALL LETTER ETA",
	"GREEK SMALL LETTER THETA",
	"GREEK SMALL LETTER IOTA",
	"GREEK SMALL LETTER KAPPA",
	"GREEK SMALL LETTER LAMDA",
	"GREEK SMALL LETTER MU",
	"GREEK SMALL LETTER NU",
	"GREEK SMALL LETTER XI",
	"GREEK SMALL LETTER OMICRON",
	"GREEK SMALL LETTER PI",
	"GREEK SMALL LETTER RHO",
	"GREEK SMALL LETTER FINAL SIGMA",
	"GREEK SMALL LETTER SIGMA",
	"GREEK SMALL LETTER TAU",
	"GREEK SMALL LETTER UPSILON",
	"GREEK SMALL LETTER PHI",
	"GREEK SMALL LETTER CHI",
	"GREEK SMALL LETTER PSI",
	"GREEK SMALL LETTER OMEGA",
	"GREEK SMALL LETTER IOTA WITH DIALYTIKA",
	"GREEK SMALL LETTER UPSILON WITH DIALYTIKA",
	"GREEK SMALL LETTER OMICRON WITH TONOS",
	"GREEK SMALL LETTER UPSILON WITH TONOS",
	"GREEK SMALL LETTER OMEGA WITH TONOS",
	"GREEK CAPITAL KAI SYMBOL",
	"GREEK BETA SYMBOL",
	"GREEK THETA SYMBOL",
	"GREEK UPSILON WITH HOOK SYMBOL",
	"GREEK UPSILON WITH ACUTE AND HOOK SYMBOL",
	"GREEK UPSILON WITH DIAERESIS AND HOOK SYMBOL",
	"GREEK PHI SYMBOL",
	"GREEK PI SYMBOL",
	"GREEK KAI SYMBOL",
	"GREEK LETTER ARCHAIC KOPPA",
	"GREEK SMALL LETTER ARCHAIC KOPPA",
	"GREEK LETTER STIGMA",
	"GREEK SMALL LETTER STIGMA",
	"GREEK LETTER DIGAMMA",
	"GREEK SMALL LETTER DIGAMMA",
	"GREEK LETTER KOPPA",
	"GREEK SMALL LETTER KOPPA",
	"GREEK LETTER SAMPI",
	"GREEK SMALL LETTER SAMPI",
	"COPTIC CAPITAL LETTER SHEI",
	"COPTIC SMALL LETTER SHEI",
	"COPTIC CAPITAL LETTER FEI",
	"COPTIC SMALL LETTER FEI",
	"COPTIC CAPITAL LETTER KHEI",
	"COPTIC SMALL LETTER KHEI",
	"COPTIC CAPITAL LETTER HORI",
	"COPTIC SMALL LETTER HORI",
	"COPTIC CAPITAL LETTER GANGIA",
	"COPTIC SMALL LETTER GANGIA",
	"COPTIC CAPITAL LETTER SHIMA",
	"COPTIC SMALL LETTER SHIMA",
	"COPTIC CAPITAL LETTER DEI",
	"COPTIC SMALL LETTER DEI",
	"GREEK KAPPA SYMBOL",
	"GREEK RHO SYMBOL",
	"GREEK LUNATE SIGMA SYMBOL",
	"GREEK LETTER YOT",
	"GREEK CAPITAL THETA SYMBOL",
	"GREEK LUNATE EPSILON SYMBOL",
	"GREEK REVERSED LUNATE EPSILON SYMBOL",
	"GREEK CAPITAL LETTER SHO",
	"GREEK SMALL LETTER SHO",
	"GREEK CAPITAL LUNATE SIGMA SYMBOL",
	"GREEK CAPITAL LETTER SAN",
	"GREEK SMALL LETTER SAN",
	"GREEK RHO WITH STROKE SYMBOL",
	"GREEK CAPITAL REVERSED LUNATE SIGMA SYMBOL",
	"GREEK CAPITAL DOTTED LUNATE SIGMA SYMBOL",
	"GREEK CAPITAL REVERSED DOTTED LUNATE SIGMA SYMBOL",
	"CYRILLIC CAPITAL LETTER IE WITH GRAVE",
	"CYRILLIC CAPITAL LETTER IO",
	"CYRILLIC CAPITAL LETTER DJE",
	"CYRILLIC CAPITAL LETTER GJE",
	"CYRILLIC CAPITAL LETTER UKRAINIAN IE",
	"CYRILLIC CAPITAL LETTER DZE",
	"CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I",
	"CYRILLIC CAPITAL LETTER YI",
	"CYRILLIC CAPITAL LETTER JE",
	"CYRILLIC CAPITAL LETTER LJE",
	"CYRILLIC CAPITAL LETTER NJE",
	"CYRILLIC CAPITAL LETTER TSHE",
	"CYRILLIC CAPITAL LETTER KJE",
	"CYRILLIC CAPITAL LETTER I WITH GRAVE",
	"CYRILLIC CAPITAL LETTER SHORT U",
	"CYRILLIC CAPITAL LETTER DZHE",
	"CYRILLIC CAPITAL LETTER A",
	"CYRILLIC CAPITAL LETTER BE",
	"CYRILLIC CAPITAL LETTER VE",
	"CYRILLIC CAPITAL LETTER GHE",
	"CYRILLIC CAPITAL LETTER DE",
	"CYRILLIC CAPITAL LETTER IE",
	"CYRILLIC CAPITAL LETTER ZHE",
	"CYRILLIC CAPITAL LETTER ZE",
	"CYRILLIC CAPITAL LETTER I",
	"CYRILLIC CAPITAL LETTER SHORT I",
	"CYRILLIC CAPITAL LETTER KA",
	"CYRILLIC CAPITAL LETTER EL",
	"CYRILLIC CAPITAL LETTER EM",
	"CYRILLIC CAPITAL LETTER EN",
	"CYRILLIC CAPITAL LETTER O",
	"CYRILLIC CAPITAL LETTER PE",
	"CYRILLIC CAPITAL LETTER ER",
	"CYRILLIC CAPITAL LETTER ES",
	"CYRILLIC CAPITAL LETTER TE",
	"CYRILLIC CAPITAL LETTER U",
	"CYRILLIC CAPITAL LETTER EF",
	"CYRILLIC CAPITAL LETTER HA",
	"CYRILLIC CAPITAL LETTER TSE",
	"CYRILLIC CAPITAL LETTER CHE",
	"CYRILLIC CAPITAL LETTER SHA",
	"CYRILLIC CAPITAL LETTER SHCHA",
	"CYRILLIC CAPITAL LETTER HARD SIGN",
	"CYRILLIC CAPITAL LETTER YERU",
	"CYRILLIC CAPITAL LETTER SOFT SIGN",
	"CYRILLIC CAPITAL LETTER E",
	"CYRILLIC CAPITAL LETTER YU",
	"CYRILLIC CAPITAL LETTER YA",
	"CYRILLIC SMALL LETTER A",
	"CYRILLIC SMALL LETTER BE",
	"CYRILLIC SMALL LETTER VE",
	"CYRILLIC SMALL LETTER GHE",
	"CYRILLIC SMALL LETTER DE",
	"CYRILLIC SMALL LETTER IE",
	"CYRILLIC SMALL LETTER ZHE",
	"CYRILLIC SMALL LETTER ZE",
	"CYRILLIC SMALL LETTER I",
	"CYRILLIC SMALL LETTER SHORT I",
	"CYRILLIC SMALL LETTER KA",
	"CYRILLIC SMALL LETTER EL",
	"CYRILLIC SMALL LETTER EM",
	"CYRILLIC SMALL LETTER EN",
	"CYRILLIC SMALL LETTER O",
	"CYRILLIC SMALL LETTER PE",
	"CYRILLIC SMALL LETTER ER",
	"CYRILLIC SMALL LETTER ES",
	"CYRILLIC SMALL LETTER TE",
	"CYRILLIC SMALL LETTER U",
	"CYRILLIC SMALL LETTER EF",
	"CYRILLIC SMALL LETTER HA",
	"CYRILLIC SMALL LETTER TSE",
	"CYRILLIC SMALL LETTER CHE",
	"CYRILLIC SMALL LETTER SHA",
	"CYRILLIC SMALL LETTER SHCHA",
	"CYRILLIC SMALL LETTER HARD SIGN",
	"CYRILLIC SMALL LETTER YERU",
	"CYRILLIC SMALL LETTER SOFT SIGN",
	"CYRILLIC SMALL LETTER E",
	"CYRILLIC SMALL LETTER YU",
	"CYRILLIC SMALL LETTER YA",
	"CYRILLIC SMALL LETTER IE WITH GRAVE",
	"CYRILLIC SMALL LETTER IO",
	"CYRILLIC SMALL LETTER DJE",
	"CYRILLIC SMALL LETTER GJE",
	"CYRILLIC SMALL LETTER UKRAINIAN IE",
	"CYRILLIC SMALL LETTER DZE",
	"CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I",
	"CYRILLIC SMALL LETTER YI",
	"CYRILLIC SMALL LETTER JE",
	"CYRILLIC SMALL LETTER LJE",
	"CYRILLIC SMALL LETTER NJE",
	"CYRILLIC SMALL LETTER TSHE",
	"CYRILLIC SMALL LETTER KJE",
	"CYRILLIC SMALL LETTER I WITH GRAVE",
	"CYRILLIC SMALL LETTER SHORT U",
	"CYRILLIC SMALL LETTER DZHE",
	"CYRILLIC CAPITAL LETTER OMEGA",
	"CYRILLIC SMALL LETTER OMEGA",
	"CYRILLIC CAPITAL LETTER YAT",
	"CYRILLIC SMALL LETTER YAT",
	"CYRILLIC CAPITAL LETTER IOTIFIED E",
	"CYRILLIC SMALL LETTER IOTIFIED E",
	"CYRILLIC CAPITAL LETTER LITTLE YUS",
	"CYRILLIC SMALL LETTER LITTLE YUS",
	"CYRILLIC CAPITAL LETTER IOTIFIED LITTLE YUS",
	"CYRILLIC SMALL LETTER IOTIFIED LITTLE YUS",
	"CYRILLIC CAPITAL LETTER BIG YUS",
	"CYRILLIC SMALL LETTER BIG YUS",
	"CYRILLIC CAPITAL LETTER IOTIFIED BIG YUS",
	"CYRILLIC SMALL LETTER IOTIFIED BIG YUS",
	"CYRILLIC CAPITAL LETTER KSI",
	"CYRILLIC SMALL LETTER KSI",
	"CYRILLIC CAPITAL LETTER PSI",
	"CYRILLIC SMALL LETTER PSI",
	"CYRILLIC CAPITAL LETTER FITA",
	"CYRILLIC SMALL LETTER FITA",
	"CYRILLIC CAPITAL LETTER IZHITSA",
	"CYRILLIC SMALL LETTER IZHITSA",
	"CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT",
	"CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT",
	"CYRILLIC CAPITAL LETTER UK",
	"CYRILLIC SMALL LETTER UK",
	"CYRILLIC CAPITAL LETTER ROUND OMEGA",
	"CYRILLIC SMALL LETTER ROUND OMEGA",
	"CYRILLIC CAPITAL LETTER OMEGA WITH TITLO",
	"CYRILLIC SMALL LETTER OMEGA WITH TITLO",
	"CYRILLIC CAPITAL LETTER OT",
	"CYRILLIC SMALL LETTER OT",
	"CYRILLIC CAPITAL LETTER KOPPA",
	"CYRILLIC SMALL LETTER KOPPA",
	"CYRILLIC THOUSANDS SIGN",
	"COMBINING CYRILLIC TITLO",
	"COMBINING CYRILLIC PALATALIZATION",
	"COMBINING CYRILLIC DASIA PNEUMATA",
	"COMBINING CYRILLIC PSILI PNEUMATA",
	"COMBINING CYRILLIC POKRYTIE",
	"COMBINING CYRILLIC HUNDRED THOUSANDS SIGN",
	"COMBINING CYRILLIC MILLIONS SIGN",
	"CYRILLIC CAPITAL LETTER SHORT I WITH TAIL",
	"CYRILLIC SMALL LETTER SHORT I WITH TAIL",
	"CYRILLIC CAPITAL LETTER SEMISOFT SIGN",
	"CYRILLIC SMALL LETTER SEMISOFT SIGN",
	"CYRILLIC CAPITAL LETTER ER WITH TICK",
	"CYRILLIC SMALL LETTER ER WITH TICK",
	"CYRILLIC CAPITAL LETTER GHE WITH UPTURN",
	"CYRILLIC SMALL LETTER GHE WITH UPTURN",
	"CYRILLIC CAPITAL LETTER GHE WITH STROKE",
	"CYRILLIC SMALL LETTER GHE WITH STROKE",
	"CYRILLIC CAPITAL LETTER GHE WITH MIDDLE HOOK",
	"CYRILLIC SMALL LETTER GHE WITH MIDDLE HOOK",
	"CYRILLIC CAPITAL LETTER ZHE WITH DESCENDER",
	"CYRILLIC SMALL LETTER ZHE WITH DESCENDER",
	"CYRILLIC CAPITAL LETTER ZE WITH DESCENDER",
	"CYRILLIC SMALL LETTER ZE WITH DESCENDER",
	"CYRILLIC CAPITAL LETTER KA WITH DESCENDER",
	"CYRILLIC SMALL LETTER KA WITH DESCENDER",
	"CYRILLIC CAPITAL LETTER KA WITH VERTICAL STROKE",
	"CYRILLIC SMALL LETTER KA WITH VERTICAL STROKE",
	"CYRILLIC CAPITAL LETTER KA WITH STROKE",
	"CYRILLIC SMALL LETTER KA WITH STROKE",
	"CYRILLIC CAPITAL LETTER BASHKIR KA",
	"CYRILLIC SMALL LETTER BASHKIR KA",
	"CYRILLIC CAPITAL LETTER EN WITH DESCENDER",
	"CYRILLIC SMALL LETTER EN WITH DESCENDER",
	"CYRILLIC CAPITAL LIGATURE EN GHE",
	"CYRILLIC SMALL LIGATURE EN GHE",
	"CYRILLIC CAPITAL LETTER PE WITH MIDDLE HOOK",
	"CYRILLIC SMALL LETTER PE WITH MIDDLE HOOK",
	"CYRILLIC CAPITAL LETTER ABKHASIAN HA",
	"CYRILLIC SMALL LETTER ABKHASIAN HA",
	"CYRILLIC CAPITAL LETTER ES WITH DESCENDER",
	"CYRILLIC SMALL LETTER ES WITH DESCENDER",
	"CYRILLIC CAPITAL LETTER TE WITH DESCENDER",
	"CYRILLIC SMALL LETTER TE WITH DESCENDER",
	"CYRILLIC CAPITAL LETTER STRAIGHT U",
	"CYRILLIC SMALL LETTER STRAIGHT U",
	"CYRILLIC CAPITAL LETTER STRAIGHT U WITH STROKE",
	"CYRILLIC SMALL LETTER STRAIGHT U WITH STROKE",
	"CYRILLIC CAPITAL LETTER HA WITH DESCENDER",
	"CYRILLIC SMALL LETTER HA WITH DESCENDER",
	"CYRILLIC CAPITAL LIGATURE TE TSE",
	"CYRILLIC SMALL LIGATURE TE TSE",
	"CYRILLIC CAPITAL LETTER CHE WITH DESCENDER",
	"CYRILLIC SMALL LETTER CHE WITH DESCENDER",
	"CYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROKE",
	"CYRILLIC SMALL LETTER CHE WITH VERTICAL STROKE",
	"CYRILLIC CAPITAL LETTER SHHA",
	"CYRILLIC SMALL LETTER SHHA",
	"CYRILLIC CAPITAL LETTER ABKHASIAN CHE",
	"CYRILLIC SMALL LETTER ABKHASIAN CHE",
	"CYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH DESCENDER",
	"CYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDER",
	"CYRILLIC LETTER PALOCHKA",
	"CYRILLIC CAPITAL LETTER ZHE WITH BREVE",
	"CYRILLIC SMALL LETTER ZHE WITH BREVE",
	"CYRILLIC CAPITAL LETTER KA WITH HOOK",
	"CYRILLIC SMALL LETTER KA WITH HOOK",
	"CYRILLIC CAPITAL LETTER EL WITH TAIL",
	"CYRILLIC SMALL LETTER EL WITH TAIL",
	"CYRILLIC CAPITAL LETTER EN WITH HOOK",
	"CYRILLIC SMALL LETTER EN WITH HOOK",
	"CYRILLIC CAPITAL LETTER EN WITH TAIL",
	"CYRILLIC SMALL LETTER EN WITH TAIL",
	"CYRILLIC CAPITAL LETTER KHAKASSIAN CHE",
	"CYRILLIC SMALL LETTER KHAKASSIAN CHE",
	"CYRILLIC CAPITAL LETTER EM WITH TAIL",
	"CYRILLIC SMALL LETTER EM WITH TAIL",
	"CYRILLIC SMALL LETTER PALOCHKA",
	"CYRILLIC CAPITAL LETTER A WITH BREVE",
	"CYRILLIC SMALL LETTER A WITH BREVE",
	"CYRILLIC CAPITAL LETTER A WITH DIAERESIS",
	"CYRILLIC SMALL LETTER A WITH DIAERESIS",
	"CYRILLIC CAPITAL LIGATURE A IE",
	"CYRILLIC SMALL LIGATURE A IE",
	"CYRILLIC CAPITAL LETTER IE WITH BREVE",
	"CYRILLIC SMALL LETTER IE WITH BREVE",
	"CYRILLIC CAPITAL LETTER SCHWA",
	"CYRILLIC SMALL LETTER SCHWA",
	"CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS",
	"CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS",
	"CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS",
	"CYRILLIC SMALL LETTER ZHE WITH DIAERESIS",
	"CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS",
	"CYRILLIC SMALL LETTER ZE WITH DIAERESIS",
	"CYRILLIC CAPITAL LETTER ABKHASIAN DZE",
	"CYRILLIC SMALL LETTER ABKHASIAN DZE",
	"CYRILLIC CAPITAL LETTER I WITH MACRON",
	"CYRILLIC SMALL LETTER I WITH MACRON",
	"CYRILLIC CAPITAL LETTER I WITH DIAERESIS",
	"CYRILLIC SMALL LETTER I WITH DIAERESIS",
	"CYRILLIC CAPITAL LETTER O WITH DIAERESIS",
	"CYRILLIC SMALL LETTER O WITH DIAERESIS",
	"CYRILLIC CAPITAL LETTER BARRED O",
	"CYRILLIC SMALL LETTER BARRED O",
	"CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS",
	"CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS",
	"CYRILLIC CAPITAL LETTER E WITH DIAERESIS",
	"CYRILLIC SMALL LETTER E WITH DIAERESIS",
	"CYRILLIC CAPITAL LETTER U WITH MACRON",
	"CYRILLIC SMALL LETTER U WITH MACRON",
	"CYRILLIC CAPITAL LETTER U WITH DIAERESIS",
	"CYRILLIC SMALL LETTER U WITH DIAERESIS",
	"CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE",
	"CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE",
	"CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS",
	"CYRILLIC SMALL LETTER CHE WITH DIAERESIS",
	"CYRILLIC CAPITAL LETTER GHE WITH DESCENDER",
	"CYRILLIC SMALL LETTER GHE WITH DESCENDER",
	"CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS",
	"CYRILLIC SMALL LETTER YERU WITH DIAERESIS",
	"CYRILLIC CAPITAL LETTER GHE WITH STROKE AND HOOK",
	"CYRILLIC SMALL LETTER GHE WITH STROKE AND HOOK",
	"CYRILLIC CAPITAL LETTER HA WITH HOOK",
	"CYRILLIC SMALL LETTER HA WITH HOOK",
	"CYRILLIC CAPITAL LETTER HA WITH STROKE",
	"CYRILLIC SMALL LETTER HA WITH STROKE",
	"CYRILLIC CAPITAL LETTER KOMI DE",
	"CYRILLIC SMALL LETTER KOMI DE",
	"CYRILLIC CAPITAL LETTER KOMI DJE",
	"CYRILLIC SMALL LETTER KOMI DJE",
	"CYRILLIC CAPITAL LETTER KOMI ZJE",
	"CYRILLIC SMALL LETTER KOMI ZJE",
	"CYRILLIC CAPITAL LETTER KOMI DZJE",
	"CYRILLIC SMALL LETTER KOMI DZJE",
	"CYRILLIC CAPITAL LETTER KOMI LJE",
	"CYRILLIC SMALL LETTER KOMI LJE",
	"CYRILLIC CAPITAL LETTER KOMI NJE",
	"CYRILLIC SMALL LETTER KOMI NJE",
	"CYRILLIC CAPITAL LETTER KOMI SJE",
	"CYRILLIC SMALL LETTER KOMI SJE",
	"CYRILLIC CAPITAL LETTER KOMI TJE",
	"CYRILLIC SMALL LETTER KOMI TJE",
	"CYRILLIC CAPITAL LETTER REVERSED ZE",
	"CYRILLIC SMALL LETTER REVERSED ZE",
	"CYRILLIC CAPITAL LETTER EL WITH HOOK",
	"CYRILLIC SMALL LETTER EL WITH HOOK",
	"CYRILLIC CAPITAL LETTER LHA",
	"CYRILLIC SMALL LETTER LHA",
	"CYRILLIC CAPITAL LETTER RHA",
	"CYRILLIC SMALL LETTER RHA",
	"CYRILLIC CAPITAL LETTER YAE",
	"CYRILLIC SMALL LETTER YAE",
	"CYRILLIC CAPITAL LETTER QA",
	"CYRILLIC SMALL LETTER QA",
	"CYRILLIC CAPITAL LETTER WE",
	"CYRILLIC SMALL LETTER WE",
	"CYRILLIC CAPITAL LETTER ALEUT KA",
	"CYRILLIC SMALL LETTER ALEUT KA",
	"CYRILLIC CAPITAL LETTER EL WITH MIDDLE HOOK",
	"CYRILLIC SMALL LETTER EL WITH MIDDLE HOOK",
	"CYRILLIC CAPITAL LETTER EN WITH MIDDLE HOOK",
	"CYRILLIC SMALL LETTER EN WITH MIDDLE HOOK",
	"CYRILLIC CAPITAL LETTER PE WITH DESCENDER",
	"CYRILLIC SMALL LETTER PE WITH DESCENDER",
	"CYRILLIC CAPITAL LETTER SHHA WITH DESCENDER",
	"CYRILLIC SMALL LETTER SHHA WITH DESCENDER",
	"CYRILLIC CAPITAL LETTER EN WITH LEFT HOOK",
	"CYRILLIC SMALL LETTER EN WITH LEFT HOOK",
	"CYRILLIC CAPITAL LETTER DZZHE",
	"CYRILLIC SMALL LETTER DZZHE",
	"CYRILLIC CAPITAL LETTER DCHE",
	"CYRILLIC SMALL LETTER DCHE",
	"CYRILLIC CAPITAL LETTER EL WITH DESCENDER",
	"CYRILLIC SMALL LETTER EL WITH DESCENDER",
	"ARMENIAN CAPITAL LETTER AYB",
	"ARMENIAN CAPITAL LETTER BEN",
	"ARMENIAN CAPITAL LETTER GIM",
	"ARMENIAN CAPITAL LETTER DA",
	"ARMENIAN CAPITAL LETTER ECH",
	"ARMENIAN CAPITAL LETTER ZA",
	"ARMENIAN CAPITAL LETTER EH",
	"ARMENIAN CAPITAL LETTER ET",
	"ARMENIAN CAPITAL LETTER TO",
	"ARMENIAN CAPITAL LETTER ZHE",
	"ARMENIAN CAPITAL LETTER INI",
	"ARMENIAN CAPITAL LETTER LIWN",
	"ARMENIAN CAPITAL LETTER XEH",
	"ARMENIAN CAPITAL LETTER CA",
	"ARMENIAN CAPITAL LETTER KEN",
	"ARMENIAN CAPITAL LETTER HO",
	"ARMENIAN CAPITAL LETTER JA",
	"ARMENIAN CAPITAL LETTER GHAD",
	"ARMENIAN CAPITAL LETTER CHEH",
	"ARMENIAN CAPITAL LETTER MEN",
	"ARMENIAN CAPITAL LETTER YI",
	"ARMENIAN CAPITAL LETTER NOW",
	"ARMENIAN CAPITAL LETTER SHA",
	"ARMENIAN CAPITAL LETTER VO",
	"ARMENIAN CAPITAL LETTER CHA",
	"ARMENIAN CAPITAL LETTER PEH",
	"ARMENIAN CAPITAL LETTER JHEH",
	"ARMENIAN CAPITAL LETTER RA",
	"ARMENIAN CAPITAL LETTER SEH",
	"ARMENIAN CAPITAL LETTER VEW",
	"ARMENIAN CAPITAL LETTER TIWN",
	"ARMENIAN CAPITAL LETTER REH",
	"ARMENIAN CAPITAL LETTER CO",
	"ARMENIAN CAPITAL LETTER YIWN",
	"ARMENIAN CAPITAL LETTER PIWR",
	"ARMENIAN CAPITAL LETTER KEH",
	"ARMENIAN CAPITAL LETTER OH",
	"ARMENIAN CAPITAL LETTER FEH",
	"ARMENIAN MODIFIER LETTER LEFT HALF RING",
	"ARMENIAN APOSTROPHE",
	"ARMENIAN EMPHASIS MARK",
	"ARMENIAN EXCLAMATION MARK",
	"ARMENIAN COMMA",
	"ARMENIAN QUESTION MARK",
	"ARMENIAN ABBREVIATION MARK",
	"ARMENIAN SMALL LETTER TURNED AYB",
	"ARMENIAN SMALL LETTER AYB",
	"ARMENIAN SMALL LETTER BEN",
	"ARMENIAN SMALL LETTER GIM",
	"ARMENIAN SMALL LETTER DA",
	"ARMENIAN SMALL LETTER ECH",
	"ARMENIAN SMALL LETTER ZA",
	"ARMENIAN SMALL LETTER EH",
	"ARMENIAN SMALL LETTER ET",
	"ARMENIAN SMALL LETTER TO",
	"ARMENIAN SMALL LETTER ZHE",
	"ARMENIAN SMALL LETTER INI",
	"ARMENIAN SMALL LETTER LIWN",
	"ARMENIAN SMALL LETTER XEH",
	"ARMENIAN SMALL LETTER CA",
	"ARMENIAN SMALL LETTER KEN",
	"ARMENIAN SMALL LETTER HO",
	"ARMENIAN SMALL LETTER JA",
	"ARMENIAN SMALL LETTER GHAD",
	"ARMENIAN SMALL LETTER CHEH",
	"ARMENIAN SMALL LETTER MEN",
	"ARMENIAN SMALL LETTER YI",
	"ARMENIAN SMALL LETTER NOW",
	"ARMENIAN SMALL LETTER SHA",
	"ARMENIAN SMALL LETTER VO",
	"ARMENIAN SMALL LETTER CHA",
	"ARMENIAN SMALL LETTER PEH",
	"ARMENIAN SMALL LETTER JHEH",
	"ARMENIAN SMALL LETTER RA",
	"ARMENIAN SMALL LETTER SEH",
	"ARMENIAN SMALL LETTER VEW",
	"ARMENIAN SMALL LETTER TIWN",
	"ARMENIAN SMALL LETTER REH",
	"ARMENIAN SMALL LETTER CO",
	"ARMENIAN SMALL LETTER YIWN",
	"ARMENIAN SMALL LETTER PIWR",
	"ARMENIAN SMALL LETTER KEH",
	"ARMENIAN SMALL LETTER OH",
	"ARMENIAN SMALL LETTER FEH",
	"ARMENIAN SMALL LIGATURE ECH YIWN",
	"ARMENIAN SMALL LETTER YI WITH STROKE",
	"ARMENIAN FULL STOP",
	"ARMENIAN HYPHEN",
	"RIGHT-FACING ARMENIAN ETERNITY SIGN",
	"LEFT-FACING ARMENIAN ETERNITY SIGN",
	"ARMENIAN DRAM SIGN",
	"HEBREW ACCENT ETNAHTA",
	"HEBREW ACCENT SEGOL",
	"HEBREW ACCENT SHALSHELET",
	"HEBREW ACCENT ZAQEF QATAN",
	"HEBREW ACCENT ZAQEF GADOL",
	"HEBREW ACCENT TIPEHA",
	"HEBREW ACCENT REVIA",
	"HEBREW ACCENT ZARQA",
	"HEBREW ACCENT PASHTA",
	"HEBREW ACCENT YETIV",
	"HEBREW ACCENT TEVIR",
	"HEBREW ACCENT GERESH",
	"HEBREW ACCENT GERESH MUQDAM",
	"HEBREW ACCENT GERSHAYIM",
	"HEBREW ACCENT QARNEY PARA",
	"HEBREW ACCENT TELISHA GEDOLA",
	"HEBREW ACCENT PAZER",
	"HEBREW ACCENT ATNAH HAFUKH",
	"HEBREW ACCENT MUNAH",
	"HEBREW ACCENT MAHAPAKH",
	"HEBREW ACCENT MERKHA",
	"HEBREW ACCENT MERKHA KEFULA",
	"HEBREW ACCENT DARGA",
	"HEBREW ACCENT QADMA",
	"HEBREW ACCENT TELISHA QETANA",
	"HEBREW ACCENT YERAH BEN YOMO",
	"HEBREW ACCENT OLE",
	"HEBREW ACCENT ILUY",
	"HEBREW ACCENT DEHI",
	"HEBREW ACCENT ZINOR",
	"HEBREW MARK MASORA CIRCLE",
	"HEBREW POINT SHEVA",
	"HEBREW POINT HATAF SEGOL",
	"HEBREW POINT HATAF PATAH",
	"HEBREW POINT HATAF QAMATS",
	"HEBREW POINT HIRIQ",
	"HEBREW POINT TSERE",
	"HEBREW POINT SEGOL",
	"HEBREW POINT PATAH",
	"HEBREW POINT QAMATS",
	"HEBREW POINT HOLAM",
	"HEBREW POINT HOLAM HASER FOR VAV",
	"HEBREW POINT QUBUTS",
	"HEBREW POINT DAGESH OR MAPIQ",
	"HEBREW POINT METEG",
	"HEBREW PUNCTUATION MAQAF",
	"HEBREW POINT RAFE",
	"HEBREW PUNCTUATION PASEQ",
	"HEBREW POINT SHIN DOT",
	"HEBREW POINT SIN DOT",
	"HEBREW PUNCTUATION SOF PASUQ",
	"HEBREW MARK UPPER DOT",
	"HEBREW MARK LOWER DOT",
	"HEBREW PUNCTUATION NUN HAFUKHA",
	"HEBREW POINT QAMATS QATAN",
	"HEBREW LETTER ALEF",
	"HEBREW LETTER BET",
	"HEBREW LETTER GIMEL",
	"HEBREW LETTER DALET",
	"HEBREW LETTER HE",
	"HEBREW LETTER VAV",
	"HEBREW LETTER ZAYIN",
	"HEBREW LETTER HET",
	"HEBREW LETTER TET",
	"HEBREW LETTER YOD",
	"HEBREW LETTER FINAL KAF",
	"HEBREW LETTER KAF",
	"HEBREW LETTER LAMED",
	"HEBREW LETTER FINAL MEM",
	"HEBREW LETTER MEM",
	"HEBREW LETTER FINAL NUN",
	"HEBREW LETTER NUN",
	"HEBREW LETTER SAMEKH",
	"HEBREW LETTER AYIN",
	"HEBREW LETTER FINAL PE",
	"HEBREW LETTER PE",
	"HEBREW LETTER FINAL TSADI",
	"HEBREW LETTER TSADI",
	"HEBREW LETTER QOF",
	"HEBREW LETTER RESH",
	"HEBREW LETTER SHIN",
	"HEBREW LETTER TAV",
	"HEBREW YOD TRIANGLE",
	"HEBREW LIGATURE YIDDISH DOUBLE VAV",
	"HEBREW LIGATURE YIDDISH VAV YOD",
	"HEBREW LIGATURE YIDDISH DOUBLE YOD",
	"HEBREW PUNCTUATION GERESH",
	"HEBREW PUNCTUATION GERSHAYIM",
	"ARABIC NUMBER SIGN",
	"ARABIC SIGN SANAH",
	"ARABIC FOOTNOTE MARKER",
	"ARABIC SIGN SAFHA",
	"ARABIC SIGN SAMVAT",
	"ARABIC NUMBER MARK ABOVE",
	"ARABIC-INDIC CUBE ROOT",
	"ARABIC-INDIC FOURTH ROOT",
	"ARABIC RAY",
	"ARABIC-INDIC PER MILLE SIGN",
	"ARABIC-INDIC PER TEN THOUSAND SIGN",
	"AFGHANI SIGN",
	"ARABIC COMMA",
	"ARABIC DATE SEPARATOR",
	"ARABIC POETIC VERSE SIGN",
	"ARABIC SIGN MISRA",
	"ARABIC SIGN SALLALLAHOU ALAYHE WASSALLAM",
	"ARABIC SIGN ALAYHE ASSALLAM",
	"ARABIC SIGN RAHMATULLAH ALAYHE",
	"ARABIC SIGN RADI ALLAHOU ANHU",
	"ARABIC SIGN TAKHALLUS",
	"ARABIC SMALL HIGH TAH",
	"ARABIC SMALL HIGH LIGATURE ALEF WITH LAM WITH YEH",
	"ARABIC SMALL HIGH ZAIN",
	"ARABIC SMALL FATHA",
	"ARABIC SMALL DAMMA",
	"ARABIC SMALL KASRA",
	"ARABIC SEMICOLON",
	"ARABIC LETTER MARK",
	"ARABIC END OF TEXT MARK",
	"ARABIC TRIPLE DOT PUNCTUATION MARK",
	"ARABIC QUESTION MARK",
	"ARABIC LETTER KASHMIRI YEH",
	"ARABIC LETTER HAMZA",
	"ARABIC LETTER ALEF WITH MADDA ABOVE",
	"ARABIC LETTER ALEF WITH HAMZA ABOVE",
	"ARABIC LETTER WAW WITH HAMZA ABOVE",
	"ARABIC LETTER ALEF WITH HAMZA BELOW",
	"ARABIC LETTER YEH WITH HAMZA ABOVE",
	"ARABIC LETTER ALEF",
	"ARABIC LETTER BEH",
	"ARABIC LETTER TEH MARBUTA",
	"ARABIC LETTER TEH",
	"ARABIC LETTER THEH",
	"ARABIC LETTER JEEM",
	"ARABIC LETTER HAH",
	"ARABIC LETTER KHAH",
	"ARABIC LETTER DAL",
	"ARABIC LETTER THAL",
	"ARABIC LETTER REH",
	"ARABIC LETTER ZAIN",
	"ARABIC LETTER SEEN",
	"ARABIC LETTER SHEEN",
	"ARABIC LETTER SAD",
	"ARABIC LETTER DAD",
	"ARABIC LETTER TAH",
	"ARABIC LETTER ZAH",
	"ARABIC LETTER AIN",
	"ARABIC LETTER GHAIN",
	"ARABIC LETTER KEHEH WITH TWO DOTS ABOVE",
	"ARABIC LETTER KEHEH WITH THREE DOTS BELOW",
	"ARABIC LETTER FARSI YEH WITH INVERTED V",
	"ARABIC LETTER FARSI YEH WITH TWO DOTS ABOVE",
	"ARABIC LETTER FARSI YEH WITH THREE DOTS ABOVE",
	"ARABIC TATWEEL",
	"ARABIC LETTER FEH",
	"ARABIC LETTER QAF",
	"ARABIC LETTER KAF",
	"ARABIC LETTER LAM",
	"ARABIC LETTER MEEM",
	"ARABIC LETTER NOON",
	"ARABIC LETTER HEH",
	"ARABIC LETTER WAW",
	"ARABIC LETTER ALEF MAKSURA",
	"ARABIC LETTER YEH",
	"ARABIC FATHATAN",
	"ARABIC DAMMATAN",
	"ARABIC KASRATAN",
	"ARABIC FATHA",
	"ARABIC DAMMA",
	"ARABIC KASRA",
	"ARABIC SHADDA",
	"ARABIC SUKUN",
	"ARABIC MADDAH ABOVE",
	"ARABIC HAMZA ABOVE",
	"ARABIC HAMZA BELOW",
	"ARABIC SUBSCRIPT ALEF",
	"ARABIC INVERTED DAMMA",
	"ARABIC MARK NOON GHUNNA",
	"ARABIC ZWARAKAY",
	"ARABIC VOWEL SIGN SMALL V ABOVE",
	"ARABIC VOWEL SIGN INVERTED SMALL V ABOVE",
	"ARABIC VOWEL SIGN DOT BELOW",
	"ARABIC REVERSED DAMMA",
	"ARABIC FATHA WITH TWO DOTS",
	"ARABIC WAVY HAMZA BELOW",
	"ARABIC-INDIC DIGIT ZERO",
	"ARABIC-INDIC DIGIT ONE",
	"ARABIC-INDIC DIGIT TWO",
	"ARABIC-INDIC DIGIT THREE",
	"ARABIC-INDIC DIGIT FOUR",
	"ARABIC-INDIC DIGIT FIVE",
	"ARABIC-INDIC DIGIT SIX",
	"ARABIC-INDIC DIGIT SEVEN",
	"ARABIC-INDIC DIGIT EIGHT",
	"ARABIC-INDIC DIGIT NINE",
	"ARABIC PERCENT SIGN",
	"ARABIC DECIMAL SEPARATOR",
	"ARABIC THOUSANDS SEPARATOR",
	"ARABIC FIVE POINTED STAR",
	"ARABIC LETTER DOTLESS BEH",
	"ARABIC LETTER DOTLESS QAF",
	"ARABIC LETTER SUPERSCRIPT ALEF",
	"ARABIC LETTER ALEF WASLA",
	"ARABIC LETTER ALEF WITH WAVY HAMZA ABOVE",
	"ARABIC LETTER ALEF WITH WAVY HAMZA BELOW",
	"ARABIC LETTER HIGH HAMZA",
	"ARABIC LETTER HIGH HAMZA ALEF",
	"ARABIC LETTER HIGH HAMZA WAW",
	"ARABIC LETTER U WITH HAMZA ABOVE",
	"ARABIC LETTER HIGH HAMZA YEH",
	"ARABIC LETTER TTEH",
	"ARABIC LETTER TTEHEH",
	"ARABIC LETTER BEEH",
	"ARABIC LETTER TEH WITH RING",
	"ARABIC LETTER TEH WITH THREE DOTS ABOVE DOWNWARDS",
	"ARABIC LETTER PEH",
	"ARABIC LETTER TEHEH",
	"ARABIC LETTER BEHEH",
	"ARABIC LETTER HAH WITH HAMZA ABOVE",
	"ARABIC LETTER HAH WITH TWO DOTS VERTICAL ABOVE",
	"ARABIC LETTER NYEH",
	"ARABIC LETTER DYEH",
	"ARABIC LETTER HAH WITH THREE DOTS ABOVE",
	"ARABIC LETTER TCHEH",
	"ARABIC LETTER TCHEHEH",
	"ARABIC LETTER DDAL",
	"ARABIC LETTER DAL WITH RING",
	"ARABIC LETTER DAL WITH DOT BELOW",
	"ARABIC LETTER DAL WITH DOT BELOW AND SMALL TAH",
	"ARABIC LETTER DAHAL",
	"ARABIC LETTER DDAHAL",
	"ARABIC LETTER DUL",
	"ARABIC LETTER DAL WITH THREE DOTS ABOVE DOWNWARDS",
	"ARABIC LETTER DAL WITH FOUR DOTS ABOVE",
	"ARABIC LETTER RREH",
	"ARABIC LETTER REH WITH SMALL V",
	"ARABIC LETTER REH WITH RING",
	"ARABIC LETTER REH WITH DOT BELOW",
	"ARABIC LETTER REH WITH SMALL V BELOW",
	"ARABIC LETTER REH WITH DOT BELOW AND DOT ABOVE",
	"ARABIC LETTER REH WITH TWO DOTS ABOVE",
	"ARABIC LETTER JEH",
	"ARABIC LETTER REH WITH FOUR DOTS ABOVE",
	"ARABIC LETTER SEEN WITH DOT BELOW AND DOT ABOVE",
	"ARABIC LETTER SEEN WITH THREE DOTS BELOW",
	"ARABIC LETTER SEEN WITH THREE DOTS BELOW AND THREE DOTS ABOVE",
	"ARABIC LETTER SAD WITH TWO DOTS BELOW",
	"ARABIC LETTER SAD WITH THREE DOTS ABOVE",
	"ARABIC LETTER TAH WITH THREE DOTS ABOVE",
	"ARABIC LETTER AIN WITH THREE DOTS ABOVE",
	"ARABIC LETTER DOTLESS FEH",
	"ARABIC LETTER FEH WITH DOT MOVED BELOW",
	"ARABIC LETTER FEH WITH DOT BELOW",
	"ARABIC LETTER VEH",
	"ARABIC LETTER FEH WITH THREE DOTS BELOW",
	"ARABIC LETTER PEHEH",
	"ARABIC LETTER QAF WITH DOT ABOVE",
	"ARABIC LETTER QAF WITH THREE DOTS ABOVE",
	"ARABIC LETTER KEHEH",
	"ARABIC LETTER SWASH KAF",
	"ARABIC LETTER KAF WITH RING",
	"ARABIC LETTER KAF WITH DOT ABOVE",
	"ARABIC LETTER NG",
	"ARABIC LETTER KAF WITH THREE DOTS BELOW",
	"ARABIC LETTER GAF",
	"ARABIC LETTER GAF WITH RING",
	"ARABIC LETTER NGOEH",
	"ARABIC LETTER GAF WITH TWO DOTS BELOW",
	"ARABIC LETTER GUEH",
	"ARABIC LETTER GAF WITH THREE DOTS ABOVE",
	"ARABIC LETTER LAM WITH SMALL V",
	"ARABIC LETTER LAM WITH DOT ABOVE",
	"ARABIC LETTER LAM WITH THREE DOTS ABOVE",
	"ARABIC LETTER LAM WITH THREE DOTS BELOW",
	"ARABIC LETTER NOON WITH DOT BELOW",
	"ARABIC LETTER NOON GHUNNA",
	"ARABIC LETTER RNOON",
	"ARABIC LETTER NOON WITH RING",
	"ARABIC LETTER NOON WITH THREE DOTS ABOVE",
	"ARABIC LETTER HEH DOACHASHMEE",
	"ARABIC LETTER TCHEH WITH DOT ABOVE",
	"ARABIC LETTER HEH WITH YEH ABOVE",
	"ARABIC LETTER HEH GOAL",
	"ARABIC LETTER HEH GOAL WITH HAMZA ABOVE",
	"ARABIC LETTER TEH MARBUTA GOAL",
	"ARABIC LETTER WAW WITH RING",
	"ARABIC LETTER KIRGHIZ OE",
	"ARABIC LETTER OE",
	"ARABIC LETTER U",
	"ARABIC LETTER YU",
	"ARABIC LETTER KIRGHIZ YU",
	"ARABIC LETTER WAW WITH TWO DOTS ABOVE",
	"ARABIC LETTER VE",
	"ARABIC LETTER FARSI YEH",
	"ARABIC LETTER YEH WITH TAIL",
	"ARABIC LETTER YEH WITH SMALL V",
	"ARABIC LETTER WAW WITH DOT ABOVE",
	"ARABIC LETTER E",
	"ARABIC LETTER YEH WITH THREE DOTS BELOW",
	"ARABIC LETTER YEH BARREE",
	"ARABIC LETTER YEH BARREE WITH HAMZA ABOVE",
	"ARABIC FULL STOP",
	"ARABIC LETTER AE",
	"ARABIC SMALL HIGH LIGATURE SAD WITH LAM WITH ALEF MAKSURA",
	"ARABIC SMALL HIGH LIGATURE QAF WITH LAM WITH ALEF MAKSURA",
	"ARABIC SMALL HIGH MEEM INITIAL FORM",
	"ARABIC SMALL HIGH LAM ALEF",
	"ARABIC SMALL HIGH JEEM",
	"ARABIC SMALL HIGH THREE DOTS",
	"ARABIC SMALL HIGH SEEN",
	"ARABIC END OF AYAH",
	"ARABIC START OF RUB EL HIZB",
	"ARABIC SMALL HIGH ROUNDED ZERO",
	"ARABIC SMALL HIGH UPRIGHT RECTANGULAR ZERO",
	"ARABIC SMALL HIGH DOTLESS HEAD OF KHAH",
	"ARABIC SMALL HIGH MEEM ISOLATED FORM",
	"ARABIC SMALL LOW SEEN",
	"ARABIC SMALL HIGH MADDA",
	"ARABIC SMALL WAW",
	"ARABIC SMALL YEH",
	"ARABIC SMALL HIGH YEH",
	"ARABIC SMALL HIGH NOON",
	"ARABIC PLACE OF SAJDAH",
	"ARABIC EMPTY CENTRE LOW STOP",
	"ARABIC EMPTY CENTRE HIGH STOP",
	"ARABIC ROUNDED HIGH STOP WITH FILLED CENTRE",
	"ARABIC SMALL LOW MEEM",
	"ARABIC LETTER DAL WITH INVERTED V",
	"ARABIC LETTER REH WITH INVERTED V",
	"EXTENDED ARABIC-INDIC DIGIT ZERO",
	"EXTENDED ARABIC-INDIC DIGIT ONE",
	"EXTENDED ARABIC-INDIC DIGIT TWO",
	"EXTENDED ARABIC-INDIC DIGIT THREE",
	"EXTENDED ARABIC-INDIC DIGIT FOUR",
	"EXTENDED ARABIC-INDIC DIGIT FIVE",
	"EXTENDED ARABIC-INDIC DIGIT SIX",
	"EXTENDED ARABIC-INDIC DIGIT SEVEN",
	"EXTENDED ARABIC-INDIC DIGIT EIGHT",
	"EXTENDED ARABIC-INDIC DIGIT NINE",
	"ARABIC LETTER SHEEN WITH DOT BELOW",
	"ARABIC LETTER DAD WITH DOT BELOW",
	"ARABIC LETTER GHAIN WITH DOT BELOW",
	"ARABIC SIGN SINDHI AMPERSAND",
	"ARABIC SIGN SINDHI POSTPOSITION MEN",
	"ARABIC LETTER HEH WITH INVERTED V",
	"SYRIAC END OF PARAGRAPH",
	"SYRIAC SUPRALINEAR FULL STOP",
	"SYRIAC SUBLINEAR FULL STOP",
	"SYRIAC SUPRALINEAR COLON",
	"SYRIAC SUBLINEAR COLON",
	"SYRIAC HORIZONTAL COLON",
	"SYRIAC COLON SKEWED LEFT",
	"SYRIAC COLON SKEWED RIGHT",
	"SYRIAC SUPRALINEAR COLON SKEWED LEFT",
	"SYRIAC SUBLINEAR COLON SKEWED RIGHT",
	"SYRIAC CONTRACTION",
	"SYRIAC HARKLEAN OBELUS",
	"SYRIAC HARKLEAN METOBELUS",
	"SYRIAC HARKLEAN ASTERISCUS",
	"SYRIAC ABBREVIATION MARK",
	"SYRIAC LETTER ALAPH",
	"SYRIAC LETTER SUPERSCRIPT ALAPH",
	"SYRIAC LETTER BETH",
	"SYRIAC LETTER GAMAL",
	"SYRIAC LETTER GAMAL GARSHUNI",
	"SYRIAC LETTER DALATH",
	"SYRIAC LETTER DOTLESS DALATH RISH",
	"SYRIAC LETTER HE",
	"SYRIAC LETTER WAW",
	"SYRIAC LETTER ZAIN",
	"SYRIAC LETTER HETH",
	"SYRIAC LETTER TETH",
	"SYRIAC LETTER TETH GARSHUNI",
	"SYRIAC LETTER YUDH",
	"SYRIAC LETTER YUDH HE",
	"SYRIAC LETTER KAPH",
	"SYRIAC LETTER LAMADH",
	"SYRIAC LETTER MIM",
	"SYRIAC LETTER NUN",
	"SYRIAC LETTER SEMKATH",
	"SYRIAC LETTER FINAL SEMKATH",
	"SYRIAC LETTER E",
	"SYRIAC LETTER PE",
	"SYRIAC LETTER REVERSED PE",
	"SYRIAC LETTER SADHE",
	"SYRIAC LETTER QAPH",
	"SYRIAC LETTER RISH",
	"SYRIAC LETTER SHIN",
	"SYRIAC LETTER TAW",
	"SYRIAC LETTER PERSIAN BHETH",
	"SYRIAC LETTER PERSIAN GHAMAL",
	"SYRIAC LETTER PERSIAN DHALATH",
	"SYRIAC PTHAHA ABOVE",
	"SYRIAC PTHAHA BELOW",
	"SYRIAC PTHAHA DOTTED",
	"SYRIAC ZQAPHA ABOVE",
	"SYRIAC ZQAPHA BELOW",
	"SYRIAC ZQAPHA DOTTED",
	"SYRIAC RBASA ABOVE",
	"SYRIAC RBASA BELOW",
	"SYRIAC DOTTED ZLAMA HORIZONTAL",
	"SYRIAC DOTTED ZLAMA ANGULAR",
	"SYRIAC HBASA ABOVE",
	"SYRIAC HBASA BELOW",
	"SYRIAC HBASA-ESASA DOTTED",
	"SYRIAC ESASA ABOVE",
	"SYRIAC ESASA BELOW",
	"SYRIAC RWAHA",
	"SYRIAC FEMININE DOT",
	"SYRIAC QUSHSHAYA",
	"SYRIAC RUKKAKHA",
	"SYRIAC TWO VERTICAL DOTS ABOVE",
	"SYRIAC TWO VERTICAL DOTS BELOW",
	"SYRIAC THREE DOTS ABOVE",
	"SYRIAC THREE DOTS BELOW",
	"SYRIAC OBLIQUE LINE ABOVE",
	"SYRIAC OBLIQUE LINE BELOW",
	"SYRIAC MUSIC",
	"SYRIAC BARREKH",
	"SYRIAC LETTER SOGDIAN ZHAIN",
	"SYRIAC LETTER SOGDIAN KHAPH",
	"SYRIAC LETTER SOGDIAN FE",
	"ARABIC LETTER BEH WITH THREE DOTS HORIZONTALLY BELOW",
	"ARABIC LETTER BEH WITH DOT BELOW AND THREE DOTS ABOVE",
	"ARABIC LETTER BEH WITH THREE DOTS POINTING UPWARDS BELOW",
	"ARABIC LETTER BEH WITH THREE DOTS POINTING UPWARDS BELOW AND TWO DOTS ABOVE",
	"ARABIC LETTER BEH WITH TWO DOTS BELOW AND DOT ABOVE",
	"ARABIC LETTER BEH WITH INVERTED SMALL V BELOW",
	"ARABIC LETTER BEH WITH SMALL V",
	"ARABIC LETTER HAH WITH TWO DOTS ABOVE",
	"ARABIC LETTER HAH WITH THREE DOTS POINTING UPWARDS BELOW",
	"ARABIC LETTER DAL WITH TWO DOTS VERTICALLY BELOW AND SMALL TAH",
	"ARABIC LETTER DAL WITH INVERTED SMALL V BELOW",
	"ARABIC LETTER REH WITH STROKE",
	"ARABIC LETTER SEEN WITH FOUR DOTS ABOVE",
	"ARABIC LETTER AIN WITH TWO DOTS ABOVE",
	"ARABIC LETTER AIN WITH THREE DOTS POINTING DOWNWARDS ABOVE",
	"ARABIC LETTER AIN WITH TWO DOTS VERTICALLY ABOVE",
	"ARABIC LETTER FEH WITH TWO DOTS BELOW",
	"ARABIC LETTER FEH WITH THREE DOTS POINTING UPWARDS BELOW",
	"ARABIC LETTER KEHEH WITH DOT ABOVE",
	"ARABIC LETTER KEHEH WITH THREE DOTS ABOVE",
	"ARABIC LETTER KEHEH WITH THREE DOTS POINTING UPWARDS BELOW",
	"ARABIC LETTER MEEM WITH DOT ABOVE",
	"ARABIC LETTER MEEM WITH DOT BELOW",
	"ARABIC LETTER NOON WITH TWO DOTS BELOW",
	"ARABIC LETTER NOON WITH SMALL TAH",
	"ARABIC LETTER NOON WITH SMALL V",
	"ARABIC LETTER LAM WITH BAR",
	"ARABIC LETTER REH WITH TWO DOTS VERTICALLY ABOVE",
	"ARABIC LETTER REH WITH HAMZA ABOVE",
	"ARABIC LETTER SEEN WITH TWO DOTS VERTICALLY ABOVE",
	"ARABIC LETTER HAH WITH SMALL ARABIC LETTER TAH BELOW",
	"ARABIC LETTER HAH WITH SMALL ARABIC LETTER TAH AND TWO DOTS",
	"ARABIC LETTER SEEN WITH SMALL ARABIC LETTER TAH AND TWO DOTS",
	"ARABIC LETTER REH WITH SMALL ARABIC LETTER TAH AND TWO DOTS",
	"ARABIC LETTER HAH WITH SMALL ARABIC LETTER TAH ABOVE",
	"ARABIC LETTER ALEF WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVE",
	"ARABIC LETTER ALEF WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVE",
	"ARABIC LETTER FARSI YEH WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVE",
	"ARABIC LETTER FARSI YEH WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVE",
	"ARABIC LETTER FARSI YEH WITH EXTENDED ARABIC-INDIC DIGIT FOUR BELOW",
	"ARABIC LETTER WAW WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVE",
	"ARABIC LETTER WAW WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVE",
	"ARABIC LETTER YEH BARREE WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVE",
	"ARABIC LETTER YEH BARREE WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVE",
	"ARABIC LETTER HAH WITH EXTENDED ARABIC-INDIC DIGIT FOUR BELOW",
	"ARABIC LETTER SEEN WITH EXTENDED ARABIC-INDIC DIGIT FOUR ABOVE",
	"ARABIC LETTER SEEN WITH INVERTED V",
	"ARABIC LETTER KAF WITH TWO DOTS ABOVE",
	"THAANA LETTER HAA",
	"THAANA LETTER SHAVIYANI",
	"THAANA LETTER NOONU",
	"THAANA LETTER RAA",
	"THAANA LETTER BAA",
	"THAANA LETTER LHAVIYANI",
	"THAANA LETTER KAAFU",
	"THAANA LETTER ALIFU",
	"THAANA LETTER VAAVU",
	"THAANA LETTER MEEMU",
	"THAANA LETTER FAAFU",
	"THAANA LETTER DHAALU",
	"THAANA LETTER THAA",
	"THAANA LETTER LAAMU",
	"THAANA LETTER GAAFU",
	"THAANA LETTER GNAVIYANI",
	"THAANA LETTER SEENU",
	"THAANA LETTER DAVIYANI",
	"THAANA LETTER ZAVIYANI",
	"THAANA LETTER TAVIYANI",
	"THAANA LETTER YAA",
	"THAANA LETTER PAVIYANI",
	"THAANA LETTER JAVIYANI",
	"THAANA LETTER CHAVIYANI",
	"THAANA LETTER TTAA",
	"THAANA LETTER HHAA",
	"THAANA LETTER KHAA",
	"THAANA LETTER THAALU",
	"THAANA LETTER ZAA",
	"THAANA LETTER SHEENU",
	"THAANA LETTER SAADHU",
	"THAANA LETTER DAADHU",
	"THAANA LETTER TO",
	"THAANA LETTER ZO",
	"THAANA LETTER AINU",
	"THAANA LETTER GHAINU",
	"THAANA LETTER QAAFU",
	"THAANA LETTER WAAVU",
	"THAANA ABAFILI",
	"THAANA AABAAFILI",
	"THAANA IBIFILI",
	"THAANA EEBEEFILI",
	"THAANA UBUFILI",
	"THAANA OOBOOFILI",
	"THAANA EBEFILI",
	"THAANA EYBEYFILI",
	"THAANA OBOFILI",
	"THAANA OABOAFILI",
	"THAANA SUKUN",
	"THAANA LETTER NAA",
	"NKO DIGIT ZERO",
	"NKO DIGIT ONE",
	"NKO DIGIT TWO",
	"NKO DIGIT THREE",
	"NKO DIGIT FOUR",
	"NKO DIGIT FIVE",
	"NKO DIGIT SIX",
	"NKO DIGIT SEVEN",
	"NKO DIGIT EIGHT",
	"NKO DIGIT NINE",
	"NKO LETTER A",
	"NKO LETTER EE",
	"NKO LETTER I",
	"NKO LETTER E",
	"NKO LETTER U",
	"NKO LETTER OO",
	"NKO LETTER O",
	"NKO LETTER DAGBASINNA",
	"NKO LETTER N",
	"NKO LETTER BA",
	"NKO LETTER PA",
	"NKO LETTER TA",
	"NKO LETTER JA",
	"NKO LETTER CHA",
	"NKO LETTER DA",
	"NKO LETTER RA",
	"NKO LETTER RRA",
	"NKO LETTER SA",
	"NKO LETTER GBA",
	"NKO LETTER FA",
	"NKO LETTER KA",
	"NKO LETTER LA",
	"NKO LETTER NA WOLOSO",
	"NKO LETTER MA",
	"NKO LETTER NYA",
	"NKO LETTER NA",
	"NKO LETTER HA",
	"NKO LETTER WA",
	"NKO LETTER YA",
	"NKO LETTER NYA WOLOSO",
	"NKO LETTER JONA JA",
	"NKO LETTER JONA CHA",
	"NKO LETTER JONA RA",
	"NKO COMBINING SHORT HIGH TONE",
	"NKO COMBINING SHORT LOW TONE",
	"NKO COMBINING SHORT RISING TONE",
	"NKO COMBINING LONG DESCENDING TONE",
	"NKO COMBINING LONG HIGH TONE",
	"NKO COMBINING LONG LOW TONE",
	"NKO COMBINING LONG RISING TONE",
	"NKO COMBINING NASALIZATION MARK",
	"NKO COMBINING DOUBLE DOT ABOVE",
	"NKO HIGH TONE APOSTROPHE",
	"NKO LOW TONE APOSTROPHE",
	"NKO SYMBOL OO DENNEN",
	"NKO SYMBOL GBAKURUNEN",
	"NKO COMMA",
	"NKO EXCLAMATION MARK",
	"NKO LAJANYALAN",
	"NKO DANTAYALAN",
	"NKO DOROME SIGN",
	"NKO TAMAN SIGN",
	"SAMARITAN LETTER ALAF",
	"SAMARITAN LETTER BIT",
	"SAMARITAN LETTER GAMAN",
	"SAMARITAN LETTER DALAT",
	"SAMARITAN LETTER IY",
	"SAMARITAN LETTER BAA",
	"SAMARITAN LETTER ZEN",
	"SAMARITAN LETTER IT",
	"SAMARITAN LETTER TIT",
	"SAMARITAN LETTER YUT",
	"SAMARITAN LETTER KAAF",
	"SAMARITAN LETTER LABAT",
	"SAMARITAN LETTER MIM",
	"SAMARITAN LETTER NUN",
	"SAMARITAN LETTER SINGAAT",
	"SAMARITAN LETTER IN",
	"SAMARITAN LETTER FI",
	"SAMARITAN LETTER TSAADIY",
	"SAMARITAN LETTER QUF",
	"SAMARITAN LETTER RISH",
	"SAMARITAN LETTER SHAN",
	"SAMARITAN LETTER TAAF",
	"SAMARITAN MARK IN",
	"SAMARITAN MARK IN-ALAF",
	"SAMARITAN MARK OCCLUSION",
	"SAMARITAN MARK DAGESH",
	"SAMARITAN MODIFIER LETTER EPENTHETIC YUT",
	"SAMARITAN MARK EPENTHETIC YUT",
	"SAMARITAN VOWEL SIGN LONG E",
	"SAMARITAN VOWEL SIGN E",
	"SAMARITAN VOWEL SIGN OVERLONG AA",
	"SAMARITAN VOWEL SIGN LONG AA",
	"SAMARITAN VOWEL SIGN AA",
	"SAMARITAN VOWEL SIGN OVERLONG A",
	"SAMARITAN VOWEL SIGN LONG A",
	"SAMARITAN VOWEL SIGN A",
	"SAMARITAN MODIFIER LETTER SHORT A",
	"SAMARITAN VOWEL SIGN SHORT A",
	"SAMARITAN VOWEL SIGN LONG U",
	"SAMARITAN VOWEL SIGN U",
	"SAMARITAN MODIFIER LETTER I",
	"SAMARITAN VOWEL SIGN LONG I",
	"SAMARITAN VOWEL SIGN I",
	"SAMARITAN VOWEL SIGN O",
	"SAMARITAN VOWEL SIGN SUKUN",
	"SAMARITAN MARK NEQUDAA",
	"SAMARITAN PUNCTUATION NEQUDAA",
	"SAMARITAN PUNCTUATION AFSAAQ",
	"SAMARITAN PUNCTUATION ANGED",
	"SAMARITAN PUNCTUATION BAU",
	"SAMARITAN PUNCTUATION ATMAAU",
	"SAMARITAN PUNCTUATION SHIYYAALAA",
	"SAMARITAN ABBREVIATION MARK",
	"SAMARITAN PUNCTUATION MELODIC QITSA",
	"SAMARITAN PUNCTUATION ZIQAA",
	"SAMARITAN PUNCTUATION QITSA",
	"SAMARITAN PUNCTUATION ZAEF",
	"SAMARITAN PUNCTUATION TURU",
	"SAMARITAN PUNCTUATION ARKAANU",
	"SAMARITAN PUNCTUATION SOF MASHFAAT",
	"SAMARITAN PUNCTUATION ANNAAU",
	"MANDAIC LETTER HALQA",
	"MANDAIC LETTER AB",
	"MANDAIC LETTER AG",
	"MANDAIC LETTER AD",
	"MANDAIC LETTER AH",
	"MANDAIC LETTER USHENNA",
	"MANDAIC LETTER AZ",
	"MANDAIC LETTER IT",
	"MANDAIC LETTER ATT",
	"MANDAIC LETTER AKSA",
	"MANDAIC LETTER AK",
	"MANDAIC LETTER AL",
	"MANDAIC LETTER AM",
	"MANDAIC LETTER AN",
	"MANDAIC LETTER AS",
	"MANDAIC LETTER IN",
	"MANDAIC LETTER AP",
	"MANDAIC LETTER ASZ",
	"MANDAIC LETTER AQ",
	"MANDAIC LETTER AR",
	"MANDAIC LETTER ASH",
	"MANDAIC LETTER AT",
	"MANDAIC LETTER DUSHENNA",
	"MANDAIC LETTER KAD",
	"MANDAIC LETTER AIN",
	"MANDAIC AFFRICATION MARK",
	"MANDAIC VOCALIZATION MARK",
	"MANDAIC GEMINATION MARK",
	"MANDAIC PUNCTUATION",
	"SYRIAC LETTER MALAYALAM NGA",
	"SYRIAC LETTER MALAYALAM JA",
	"SYRIAC LETTER MALAYALAM NYA",
	"SYRIAC LETTER MALAYALAM TTA",
	"SYRIAC LETTER MALAYALAM NNA",
	"SYRIAC LETTER MALAYALAM NNNA",
	"SYRIAC LETTER MALAYALAM BHA",
	"SYRIAC LETTER MALAYALAM RA",
	"SYRIAC LETTER MALAYALAM LLA",
	"SYRIAC LETTER MALAYALAM LLLA",
	"SYRIAC LETTER MALAYALAM SSA",
	"ARABIC LETTER ALEF WITH ATTACHED FATHA",
	"ARABIC LETTER ALEF WITH ATTACHED TOP RIGHT FATHA",
	"ARABIC LETTER ALEF WITH RIGHT MIDDLE STROKE",
	"ARABIC LETTER ALEF WITH LEFT MIDDLE STROKE",
	"ARABIC LETTER ALEF WITH ATTACHED KASRA",
	"ARABIC LETTER ALEF WITH ATTACHED BOTTOM RIGHT KASRA",
	"ARABIC LETTER ALEF WITH ATTACHED ROUND DOT ABOVE",
	"ARABIC LETTER ALEF WITH ATTACHED RIGHT ROUND DOT",
	"ARABIC LETTER ALEF WITH ATTACHED LEFT ROUND DOT",
	"ARABIC LETTER ALEF WITH ATTACHED ROUND DOT BELOW",
	"ARABIC LETTER ALEF WITH DOT ABOVE",
	"ARABIC LETTER ALEF WITH ATTACHED TOP RIGHT FATHA AND DOT ABOVE",
	"ARABIC LETTER ALEF WITH RIGHT MIDDLE STROKE AND DOT ABOVE",
	"ARABIC LETTER ALEF WITH ATTACHED BOTTOM RIGHT KASRA AND DOT ABOVE",
	"ARABIC LETTER ALEF WITH ATTACHED TOP RIGHT FATHA AND LEFT RING",
	"ARABIC LETTER ALEF WITH RIGHT MIDDLE STROKE AND LEFT RING",
	"ARABIC LETTER ALEF WITH ATTACHED BOTTOM RIGHT KASRA AND LEFT RING",
	"ARABIC LETTER ALEF WITH ATTACHED RIGHT HAMZA",
	"ARABIC LETTER ALEF WITH ATTACHED LEFT HAMZA",
	"ARABIC TATWEEL WITH OVERSTRUCK HAMZA",
	"ARABIC TATWEEL WITH OVERSTRUCK WAW",
	"ARABIC TATWEEL WITH TWO DOTS BELOW",
	"ARABIC LETTER THIN YEH",
	"ARABIC BASELINE ROUND DOT",
	"ARABIC RAISED ROUND DOT",
	"ARABIC LETTER NOON WITH INVERTED SMALL V",
	"ARABIC LETTER HAH WITH INVERTED SMALL V BELOW",
	"ARABIC LETTER TAH WITH DOT BELOW",
	"ARABIC LETTER TAH WITH THREE DOTS BELOW",
	"ARABIC LETTER KEHEH WITH TWO DOTS VERTICALLY BELOW",
	"ARABIC VERTICAL TAIL",
	"ARABIC POUND MARK ABOVE",
	"ARABIC PIASTRE MARK ABOVE",
	"ARABIC SMALL HIGH WORD AL-JUZ",
	"ARABIC SMALL LOW WORD ISHMAAM",
	"ARABIC SMALL LOW WORD IMAALA",
	"ARABIC SMALL LOW WORD TASHEEL",
	"ARABIC MADDA WAAJIB",
	"ARABIC SUPERSCRIPT ALEF MOKHASSAS",
	"ARABIC DOUBLED MADDA",
	"ARABIC HALF MADDA OVER MADDA",
	"ARABIC LETTER BEH WITH SMALL V BELOW",
	"ARABIC LETTER BEH WITH HAMZA ABOVE",
	"ARABIC LETTER JEEM WITH TWO DOTS ABOVE",
	"ARABIC LETTER TAH WITH TWO DOTS ABOVE",
	"ARABIC LETTER FEH WITH DOT BELOW AND THREE DOTS ABOVE",
	"ARABIC LETTER QAF WITH DOT BELOW",
	"ARABIC LETTER LAM WITH DOUBLE BAR",
	"ARABIC LETTER MEEM WITH THREE DOTS ABOVE",
	"ARABIC LETTER YEH WITH TWO DOTS BELOW AND HAMZA ABOVE",
	"ARABIC LETTER YEH WITH TWO DOTS BELOW AND DOT ABOVE",
	"ARABIC LETTER REH WITH LOOP",
	"ARABIC LETTER WAW WITH DOT WITHIN",
	"ARABIC LETTER ROHINGYA YEH",
	"ARABIC LETTER LOW ALEF",
	"ARABIC LETTER DAL WITH THREE DOTS BELOW",
	"ARABIC LETTER SAD WITH THREE DOTS BELOW",
	"ARABIC LETTER GAF WITH INVERTED STROKE",
	"ARABIC LETTER STRAIGHT WAW",
	"ARABIC LETTER ZAIN WITH INVERTED V ABOVE",
	"ARABIC LETTER AIN WITH THREE DOTS BELOW",
	"ARABIC LETTER KAF WITH DOT BELOW",
	"ARABIC LETTER QAF WITH DOT BELOW AND NO DOTS ABOVE",
	"ARABIC LETTER BEH WITH SMALL MEEM ABOVE",
	"ARABIC LETTER PEH WITH SMALL MEEM ABOVE",
	"ARABIC LETTER TEH WITH SMALL TEH ABOVE",
	"ARABIC LETTER REH WITH SMALL NOON ABOVE",
	"ARABIC LETTER YEH WITH TWO DOTS BELOW AND SMALL NOON ABOVE",
	"ARABIC LETTER AFRICAN FEH",
	"ARABIC LETTER AFRICAN QAF",
	"ARABIC LETTER AFRICAN NOON",
	"ARABIC LETTER PEH WITH SMALL V",
	"ARABIC LETTER TEH WITH SMALL V",
	"ARABIC LETTER TTEH WITH SMALL V",
	"ARABIC LETTER TCHEH WITH SMALL V",
	"ARABIC LETTER KEHEH WITH SMALL V",
	"ARABIC LETTER GHAIN WITH THREE DOTS ABOVE",
	"ARABIC LETTER AFRICAN QAF WITH THREE DOTS ABOVE",
	"ARABIC LETTER JEEM WITH THREE DOTS ABOVE",
	"ARABIC LETTER JEEM WITH THREE DOTS BELOW",
	"ARABIC LETTER LAM WITH SMALL ARABIC LETTER TAH ABOVE",
	"ARABIC LETTER GRAF",
	"ARABIC SMALL FARSI YEH",
	"ARABIC SMALL HIGH FARSI YEH",
	"ARABIC SMALL HIGH YEH BARREE WITH TWO DOTS BELOW",
	"ARABIC SMALL HIGH WORD SAH",
	"ARABIC SMALL HIGH ZAH",
	"ARABIC LARGE ROUND DOT ABOVE",
	"ARABIC LARGE ROUND DOT BELOW",
	"ARABIC SUKUN BELOW",
	"ARABIC LARGE CIRCLE BELOW",
	"ARABIC LARGE ROUND DOT INSIDE CIRCLE BELOW",
	"ARABIC SMALL LOW WAW",
	"ARABIC SMALL HIGH WORD AR-RUB",
	"ARABIC SMALL HIGH SAD",
	"ARABIC SMALL HIGH AIN",
	"ARABIC SMALL HIGH QAF",
	"ARABIC SMALL HIGH NOON WITH KASRA",
	"ARABIC SMALL LOW NOON WITH KASRA",
	"ARABIC SMALL HIGH WORD ATH-THALATHA",
	"ARABIC SMALL HIGH WORD AS-SAJDA",
	"ARABIC SMALL HIGH WORD AN-NISF",
	"ARABIC SMALL HIGH WORD SAKTA",
	"ARABIC SMALL HIGH WORD QIF",
	"ARABIC SMALL HIGH WORD WAQFA",
	"ARABIC SMALL HIGH FOOTNOTE MARKER",
	"ARABIC SMALL HIGH SIGN SAFHA",
	"ARABIC DISPUTED END OF AYAH",
	"ARABIC TURNED DAMMA BELOW",
	"ARABIC CURLY FATHA",
	"ARABIC CURLY DAMMA",
	"ARABIC CURLY KASRA",
	"ARABIC CURLY FATHATAN",
	"ARABIC CURLY DAMMATAN",
	"ARABIC CURLY KASRATAN",
	"ARABIC TONE ONE DOT ABOVE",
	"ARABIC TONE TWO DOTS ABOVE",
	"ARABIC TONE LOOP ABOVE",
	"ARABIC TONE ONE DOT BELOW",
	"ARABIC TONE TWO DOTS BELOW",
	"ARABIC TONE LOOP BELOW",
	"ARABIC OPEN FATHATAN",
	"ARABIC OPEN DAMMATAN",
	"ARABIC OPEN KASRATAN",
	"ARABIC SMALL HIGH WAW",
	"ARABIC FATHA WITH RING",
	"ARABIC FATHA WITH DOT ABOVE",
	"ARABIC KASRA WITH DOT BELOW",
	"ARABIC LEFT ARROWHEAD ABOVE",
	"ARABIC RIGHT ARROWHEAD ABOVE",
	"ARABIC LEFT ARROWHEAD BELOW",
	"ARABIC RIGHT ARROWHEAD BELOW",
	"ARABIC DOUBLE RIGHT ARROWHEAD ABOVE",
	"ARABIC DOUBLE RIGHT ARROWHEAD ABOVE WITH DOT",
	"ARABIC RIGHT ARROWHEAD ABOVE WITH DOT",
	"ARABIC DAMMA WITH DOT",
	"ARABIC MARK SIDEWAYS NOON GHUNNA",
	"DEVANAGARI SIGN INVERTED CANDRABINDU",
	"DEVANAGARI SIGN CANDRABINDU",
	"DEVANAGARI SIGN ANUSVARA",
	"DEVANAGARI SIGN VISARGA",
	"DEVANAGARI LETTER SHORT A",
	"DEVANAGARI LETTER A",
	"DEVANAGARI LETTER AA",
	"DEVANAGARI LETTER I",
	"DEVANAGARI LETTER II",
	"DEVANAGARI LETTER U",
	"DEVANAGARI LETTER UU",
	"DEVANAGARI LETTER VOCALIC R",
	"DEVANAGARI LETTER VOCALIC L",
	"DEVANAGARI LETTER CANDRA E",
	"DEVANAGARI LETTER SHORT E",
	"DEVANAGARI LETTER E",
	"DEVANAGARI LETTER AI",
	"DEVANAGARI LETTER CANDRA O",
	"DEVANAGARI LETTER SHORT O",
	"DEVANAGARI LETTER O",
	"DEVANAGARI LETTER AU",
	"DEVANAGARI LETTER KA",
	"DEVANAGARI LETTER KHA",
	"DEVANAGARI LETTER GA",
	"DEVANAGARI LETTER GHA",
	"DEVANAGARI LETTER NGA",
	"DEVANAGARI LETTER CA",
	"DEVANAGARI LETTER CHA",
	"DEVANAGARI LETTER JA",
	"DEVANAGARI LETTER JHA",
	"DEVANAGARI LETTER NYA",
	"DEVANAGARI LETTER TTA",
	"DEVANAGARI LETTER TTHA",
	"DEVANAGARI LETTER DDA",
	"DEVANAGARI LETTER DDHA",
	"DEVANAGARI LETTER NNA",
	"DEVANAGARI LETTER TA",
	"DEVANAGARI LETTER THA",
	"DEVANAGARI LETTER DA",
	"DEVANAGARI LETTER DHA",
	"DEVANAGARI LETTER NA",
	"DEVANAGARI LETTER NNNA",
	"DEVANAGARI LETTER PA",
	"DEVANAGARI LETTER PHA",
	"DEVANAGARI LETTER BA",
	"DEVANAGARI LETTER BHA",
	"DEVANAGARI LETTER MA",
	"DEVANAGARI LETTER YA",
	"DEVANAGARI LETTER RA",
	"DEVANAGARI LETTER RRA",
	"DEVANAGARI LETTER LA",
	"DEVANAGARI LETTER LLA",
	"DEVANAGARI LETTER LLLA",
	"DEVANAGARI LETTER VA",
	"DEVANAGARI LETTER SHA",
	"DEVANAGARI LETTER SSA",
	"DEVANAGARI LETTER SA",
	"DEVANAGARI LETTER HA",
	"DEVANAGARI VOWEL SIGN OE",
	"DEVANAGARI VOWEL SIGN OOE",
	"DEVANAGARI SIGN NUKTA",
	"DEVANAGARI SIGN AVAGRAHA",
	"DEVANAGARI VOWEL SIGN AA",
	"DEVANAGARI VOWEL SIGN I",
	"DEVANAGARI VOWEL SIGN II",
	"DEVANAGARI VOWEL SIGN U",
	"DEVANAGARI VOWEL SIGN UU",
	"DEVANAGARI VOWEL SIGN VOCALIC R",
	"DEVANAGARI VOWEL SIGN VOCALIC RR",
	"DEVANAGARI VOWEL SIGN CANDRA E",
	"DEVANAGARI VOWEL SIGN SHORT E",
	"DEVANAGARI VOWEL SIGN E",
	"DEVANAGARI VOWEL SIGN AI",
	"DEVANAGARI VOWEL SIGN CANDRA O",
	"DEVANAGARI VOWEL SIGN SHORT O",
	"DEVANAGARI VOWEL SIGN O",
	"DEVANAGARI VOWEL SIGN AU",
	"DEVANAGARI SIGN VIRAMA",
	"DEVANAGARI VOWEL SIGN PRISHTHAMATRA E",
	"DEVANAGARI VOWEL SIGN AW",
	"DEVANAGARI OM",
	"DEVANAGARI STRESS SIGN UDATTA",
	"DEVANAGARI STRESS SIGN ANUDATTA",
	"DEVANAGARI GRAVE ACCENT",
	"DEVANAGARI ACUTE ACCENT",
	"DEVANAGARI VOWEL SIGN CANDRA LONG E",
	"DEVANAGARI VOWEL SIGN UE",
	"DEVANAGARI VOWEL SIGN UUE",
	"DEVANAGARI LETTER QA",
	"DEVANAGARI LETTER KHHA",
	"DEVANAGARI LETTER GHHA",
	"DEVANAGARI LETTER ZA",
	"DEVANAGARI LETTER DDDHA",
	"DEVANAGARI LETTER RHA",
	"DEVANAGARI LETTER FA",
	"DEVANAGARI LETTER YYA",
	"DEVANAGARI LETTER VOCALIC RR",
	"DEVANAGARI LETTER VOCALIC LL",
	"DEVANAGARI VOWEL SIGN VOCALIC L",
	"DEVANAGARI VOWEL SIGN VOCALIC LL",
	"DEVANAGARI DANDA",
	"DEVANAGARI DOUBLE DANDA",
	"DEVANAGARI DIGIT ZERO",
	"DEVANAGARI DIGIT ONE",
	"DEVANAGARI DIGIT TWO",
	"DEVANAGARI DIGIT THREE",
	"DEVANAGARI DIGIT FOUR",
	"DEVANAGARI DIGIT FIVE",
	"DEVANAGARI DIGIT SIX",
	"DEVANAGARI DIGIT SEVEN",
	"DEVANAGARI DIGIT EIGHT",
	"DEVANAGARI DIGIT NINE",
	"DEVANAGARI ABBREVIATION SIGN",
	"DEVANAGARI SIGN HIGH SPACING DOT",
	"DEVANAGARI LETTER CANDRA A",
	"DEVANAGARI LETTER OE",
	"DEVANAGARI LETTER OOE",
	"DEVANAGARI LETTER AW",
	"DEVANAGARI LETTER UE",
	"DEVANAGARI LETTER UUE",
	"DEVANAGARI LETTER MARWARI DDA",
	"DEVANAGARI LETTER ZHA",
	"DEVANAGARI LETTER HEAVY YA",
	"DEVANAGARI LETTER GGA",
	"DEVANAGARI LETTER JJA",
	"DEVANAGARI LETTER GLOTTAL STOP",
	"DEVANAGARI LETTER DDDA",
	"DEVANAGARI LETTER BBA",
	"BENGALI ANJI",
	"BENGALI SIGN CANDRABINDU",
	"BENGALI SIGN ANUSVARA",
	"BENGALI SIGN VISARGA",
	"BENGALI LETTER A",
	"BENGALI LETTER AA",
	"BENGALI LETTER I",
	"BENGALI LETTER II",
	"BENGALI LETTER U",
	"BENGALI LETTER UU",
	"BENGALI LETTER VOCALIC R",
	"BENGALI LETTER VOCALIC L",
	"BENGALI LETTER E",
	"BENGALI LETTER AI",
	"BENGALI LETTER O",
	"BENGALI LETTER AU",
	"BENGALI LETTER KA",
	"BENGALI LETTER KHA",
	"BENGALI LETTER GA",
	"BENGALI LETTER GHA",
	"BENGALI LETTER NGA",
	"BENGALI LETTER CA",
	"BENGALI LETTER CHA",
	"BENGALI LETTER JA",
	"BENGALI LETTER JHA",
	"BENGALI LETTER NYA",
	"BENGALI LETTER TTA",
	"BENGALI LETTER TTHA",
	"BENGALI LETTER DDA",
	"BENGALI LETTER DDHA",
	"BENGALI LETTER NNA",
	"BENGALI LETTER TA",
	"BENGALI LETTER THA",
	"BENGALI LETTER DA",
	"BENGALI LETTER DHA",
	"BENGALI LETTER NA",
	"BENGALI LETTER PA",
	"BENGALI LETTER PHA",
	"BENGALI LETTER BA",
	"BENGALI LETTER BHA",
	"BENGALI LETTER MA",
	"BENGALI LETTER YA",
	"BENGALI LETTER RA",
	"BENGALI LETTER LA",
	"BENGALI LETTER SHA",
	"BENGALI LETTER SSA",
	"BENGALI LETTER SA",
	"BENGALI LETTER HA",
	"BENGALI SIGN NUKTA",
	"BENGALI SIGN AVAGRAHA",
	"BENGALI VOWEL SIGN AA",
	"BENGALI VOWEL SIGN I",
	"BENGALI VOWEL SIGN II",
	"BENGALI VOWEL SIGN U",
	"BENGALI VOWEL SIGN UU",
	"BENGALI VOWEL SIGN VOCALIC R",
	"BENGALI VOWEL SIGN VOCALIC RR",
	"BENGALI VOWEL SIGN E",
	"BENGALI VOWEL SIGN AI",
	"BENGALI VOWEL SIGN O",
	"BENGALI VOWEL SIGN AU",
	"BENGALI SIGN VIRAMA",
	"BENGALI LETTER KHANDA TA",
	"BENGALI AU LENGTH MARK",
	"BENGALI LETTER RRA",
	"BENGALI LETTER RHA",
	"BENGALI LETTER YYA",
	"BENGALI LETTER VOCALIC RR",
	"BENGALI LETTER VOCALIC LL",
	"BENGALI VOWEL SIGN VOCALIC L",
	"BENGALI VOWEL SIGN VOCALIC LL",
	"BENGALI DIGIT ZERO",
	"BENGALI DIGIT ONE",
	"BENGALI DIGIT TWO",
	"BENGALI DIGIT THREE",
	"BENGALI DIGIT FOUR",
	"BENGALI DIGIT FIVE",
	"BENGALI DIGIT SIX",
	"BENGALI DIGIT SEVEN",
	"BENGALI DIGIT EIGHT",
	"BENGALI DIGIT NINE",
	"BENGALI LETTER RA WITH MIDDLE DIAGONAL",
	"BENGALI LETTER RA WITH LOWER DIAGONAL",
	"BENGALI RUPEE MARK",
	"BENGALI RUPEE SIGN",
	"BENGALI CURRENCY NUMERATOR ONE",
	"BENGALI CURRENCY NUMERATOR TWO",
	"BENGALI CURRENCY NUMERATOR THREE",
	"BENGALI CURRENCY NUMERATOR FOUR",
	"BENGALI CURRENCY NUMERATOR ONE LESS THAN THE DENOMINATOR",
	"BENGALI CURRENCY DENOMINATOR SIXTEEN",
	"BENGALI ISSHAR",
	"BENGALI GANDA MARK",
	"BENGALI LETTER VEDIC ANUSVARA",
	"BENGALI ABBREVIATION SIGN",
	"BENGALI SANDHI MARK",
	"GURMUKHI SIGN ADAK BINDI",
	"GURMUKHI SIGN BINDI",
	"GURMUKHI SIGN VISARGA",
	"GURMUKHI LETTER A",
	"GURMUKHI LETTER AA",
	"GURMUKHI LETTER I",
	"GURMUKHI LETTER II",
	"GURMUKHI LETTER U",
	"GURMUKHI LETTER UU",
	"GURMUKHI LETTER EE",
	"GURMUKHI LETTER AI",
	"GURMUKHI LETTER OO",
	"GURMUKHI LETTER AU",
	"GURMUKHI LETTER KA",
	"GURMUKHI LETTER KHA",
	"GURMUKHI LETTER GA",
	"GURMUKHI LETTER GHA",
	"GURMUKHI LETTER NGA",
	"GURMUKHI LETTER CA",
	"GURMUKHI LETTER CHA",
	"GURMUKHI LETTER JA",
	"GURMUKHI LETTER JHA",
	"GURMUKHI LETTER NYA",
	"GURMUKHI LETTER TTA",
	"GURMUKHI LETTER TTHA",
	"GURMUKHI LETTER DDA",
	"GURMUKHI LETTER DDHA",
	"GURMUKHI LETTER NNA",
	"GURMUKHI LETTER TA",
	"GURMUKHI LETTER THA",
	"GURMUKHI LETTER DA",
	"GURMUKHI LETTER DHA",
	"GURMUKHI LETTER NA",
	"GURMUKHI LETTER PA",
	"GURMUKHI LETTER PHA",
	"GURMUKHI LETTER BA",
	"GURMUKHI LETTER BHA",
	"GURMUKHI LETTER MA",
	"GURMUKHI LETTER YA",
	"GURMUKHI LETTER RA",
	"GURMUKHI LETTER LA",
	"GURMUKHI LETTER LLA",
	"GURMUKHI LETTER VA",
	"GURMUKHI LETTER SHA",
	"GURMUKHI LETTER SA",
	"GURMUKHI LETTER HA",
	"GURMUKHI SIGN NUKTA",
	"GURMUKHI VOWEL SIGN AA",
	"GURMUKHI VOWEL SIGN I",
	"GURMUKHI VOWEL SIGN II",
	"GURMUKHI VOWEL SIGN U",
	"GURMUKHI VOWEL SIGN UU",
	"GURMUKHI VOWEL SIGN EE",
	"GURMUKHI VOWEL SIGN AI",
	"GURMUKHI VOWEL SIGN OO",
	"GURMUKHI VOWEL SIGN AU",
	"GURMUKHI SIGN VIRAMA",
	"GURMUKHI SIGN UDAAT",
	"GURMUKHI LETTER KHHA",
	"GURMUKHI LETTER GHHA",
	"GURMUKHI LETTER ZA",
	"GURMUKHI LETTER RRA",
	"GURMUKHI LETTER FA",
	"GURMUKHI DIGIT ZERO",
	"GURMUKHI DIGIT ONE",
	"GURMUKHI DIGIT TWO",
	"GURMUKHI DIGIT THREE",
	"GURMUKHI DIGIT FOUR",
	"GURMUKHI DIGIT FIVE",
	"GURMUKHI DIGIT SIX",
	"GURMUKHI DIGIT SEVEN",
	"GURMUKHI DIGIT EIGHT",
	"GURMUKHI DIGIT NINE",
	"GURMUKHI TIPPI",
	"GURMUKHI ADDAK",
	"GURMUKHI IRI",
	"GURMUKHI URA",
	"GURMUKHI EK ONKAR",
	"GURMUKHI SIGN YAKASH",
	"GURMUKHI ABBREVIATION SIGN",
	"GUJARATI SIGN CANDRABINDU",
	"GUJARATI SIGN ANUSVARA",
	"GUJARATI SIGN VISARGA",
	"GUJARATI LETTER A",
	"GUJARATI LETTER AA",
	"GUJARATI LETTER I",
	"GUJARATI LETTER II",
	"GUJARATI LETTER U",
	"GUJARATI LETTER UU",
	"GUJARATI LETTER VOCALIC R",
	"GUJARATI LETTER VOCALIC L",
	"GUJARATI VOWEL CANDRA E",
	"GUJARATI LETTER E",
	"GUJARATI LETTER AI",
	"GUJARATI VOWEL CANDRA O",
	"GUJARATI LETTER O",
	"GUJARATI LETTER AU",
	"GUJARATI LETTER KA",
	"GUJARATI LETTER KHA",
	"GUJARATI LETTER GA",
	"GUJARATI LETTER GHA",
	"GUJARATI LETTER NGA",
	"GUJARATI LETTER CA",
	"GUJARATI LETTER CHA",
	"GUJARATI LETTER JA",
	"GUJARATI LETTER JHA",
	"GUJARATI LETTER NYA",
	"GUJARATI LETTER TTA",
	"GUJARATI LETTER TTHA",
	"GUJARATI LETTER DDA",
	"GUJARATI LETTER DDHA",
	"GUJARATI LETTER NNA",
	"GUJARATI LETTER TA",
	"GUJARATI LETTER THA",
	"GUJARATI LETTER DA",
	"GUJARATI LETTER DHA",
	"GUJARATI LETTER NA",
	"GUJARATI LETTER PA",
	"GUJARATI LETTER PHA",
	"GUJARATI LETTER BA",
	"GUJARATI LETTER BHA",
	"GUJARATI LETTER MA",
	"GUJARATI LETTER YA",
	"GUJARATI LETTER RA",
	"GUJARATI LETTER LA",
	"GUJARATI LETTER LLA",
	"GUJARATI LETTER VA",
	"GUJARATI LETTER SHA",
	"GUJARATI LETTER SSA",
	"GUJARATI LETTER SA",
	"GUJARATI LETTER HA",
	"GUJARATI SIGN NUKTA",
	"GUJARATI SIGN AVAGRAHA",
	"GUJARATI VOWEL SIGN AA",
	"GUJARATI VOWEL SIGN I",
	"GUJARATI VOWEL SIGN II",
	"GUJARATI VOWEL SIGN U",
	"GUJARATI VOWEL SIGN UU",
	"GUJARATI VOWEL SIGN VOCALIC R",
	"GUJARATI VOWEL SIGN VOCALIC RR",
	"GUJARATI VOWEL SIGN CANDRA E",
	"GUJARATI VOWEL SIGN E",
	"GUJARATI VOWEL SIGN AI",
	"GUJARATI VOWEL SIGN CANDRA O",
	"GUJARATI VOWEL SIGN O",
	"GUJARATI VOWEL SIGN AU",
	"GUJARATI SIGN VIRAMA",
	"GUJARATI OM",
	"GUJARATI LETTER VOCALIC RR",
	"GUJARATI LETTER VOCALIC LL",
	"GUJARATI VOWEL SIGN VOCALIC L",
	"GUJARATI VOWEL SIGN VOCALIC LL",
	"GUJARATI DIGIT ZERO",
	"GUJARATI DIGIT ONE",
	"GUJARATI DIGIT TWO",
	"GUJARATI DIGIT THREE",
	"GUJARATI DIGIT FOUR",
	"GUJARATI DIGIT FIVE",
	"GUJARATI DIGIT SIX",
	"GUJARATI DIGIT SEVEN",
	"GUJARATI DIGIT EIGHT",
	"GUJARATI DIGIT NINE",
	"GUJARATI ABBREVIATION SIGN",
	"GUJARATI RUPEE SIGN",
	"GUJARATI LETTER ZHA",
	"GUJARATI SIGN SUKUN",
	"GUJARATI SIGN SHADDA",
	"GUJARATI SIGN MADDAH",
	"GUJARATI SIGN THREE-DOT NUKTA ABOVE",
	"GUJARATI SIGN CIRCLE NUKTA ABOVE",
	"GUJARATI SIGN TWO-CIRCLE NUKTA ABOVE",
	"ORIYA SIGN CANDRABINDU",
	"ORIYA SIGN ANUSVARA",
	"ORIYA SIGN VISARGA",
	"ORIYA LETTER A",
	"ORIYA LETTER AA",
	"ORIYA LETTER I",
	"ORIYA LETTER II",
	"ORIYA LETTER U",
	"ORIYA LETTER UU",
	"ORIYA LETTER VOCALIC R",
	"ORIYA LETTER VOCALIC L",
	"ORIYA LETTER E",
	"ORIYA LETTER AI",
	"ORIYA LETTER O",
	"ORIYA LETTER AU",
	"ORIYA LETTER KA",
	"ORIYA LETTER KHA",
	"ORIYA LETTER GA",
	"ORIYA LETTER GHA",
	"ORIYA LETTER NGA",
	"ORIYA LETTER CA",
	"ORIYA LETTER CHA",
	"ORIYA LETTER JA",
	"ORIYA LETTER JHA",
	"ORIYA LETTER NYA",
	"ORIYA LETTER TTA",
	"ORIYA LETTER TTHA",
	"ORIYA LETTER DDA",
	"ORIYA LETTER DDHA",
	"ORIYA LETTER NNA",
	"ORIYA LETTER TA",
	"ORIYA LETTER THA",
	"ORIYA LETTER DA",
	"ORIYA LETTER DHA",
	"ORIYA LETTER NA",
	"ORIYA LETTER PA",
	"ORIYA LETTER PHA",
	"ORIYA LETTER BA",
	"ORIYA LETTER BHA",
	"ORIYA LETTER MA",
	"ORIYA LETTER YA",
	"ORIYA LETTER RA",
	"ORIYA LETTER LA",
	"ORIYA LETTER LLA",
	"ORIYA LETTER VA",
	"ORIYA LETTER SHA",
	"ORIYA LETTER SSA",
	"ORIYA LETTER SA",
	"ORIYA LETTER HA",
	"ORIYA SIGN NUKTA",
	"ORIYA SIGN AVAGRAHA",
	"ORIYA VOWEL SIGN AA",
	"ORIYA VOWEL SIGN I",
	"ORIYA VOWEL SIGN II",
	"ORIYA VOWEL SIGN U",
	"ORIYA VOWEL SIGN UU",
	"ORIYA VOWEL SIGN VOCALIC R",
	"ORIYA VOWEL SIGN VOCALIC RR",
	"ORIYA VOWEL SIGN E",
	"ORIYA VOWEL SIGN AI",
	"ORIYA VOWEL SIGN O",
	"ORIYA VOWEL SIGN AU",
	"ORIYA SIGN VIRAMA",
	"ORIYA SIGN OVERLINE",
	"ORIYA AI LENGTH MARK",
	"ORIYA AU LENGTH MARK",
	"ORIYA LETTER RRA",
	"ORIYA LETTER RHA",
	"ORIYA LETTER YYA",
	"ORIYA LETTER VOCALIC RR",
	"ORIYA LETTER VOCALIC LL",
	"ORIYA VOWEL SIGN VOCALIC L",
	"ORIYA VOWEL SIGN VOCALIC LL",
	"ORIYA DIGIT ZERO",
	"ORIYA DIGIT ONE",
	"ORIYA DIGIT TWO",
	"ORIYA DIGIT THREE",
	"ORIYA DIGIT FOUR",
	"ORIYA DIGIT FIVE",
	"ORIYA DIGIT SIX",
	"ORIYA DIGIT SEVEN",
	"ORIYA DIGIT EIGHT",
	"ORIYA DIGIT NINE",
	"ORIYA ISSHAR",
	"ORIYA LETTER WA",
	"ORIYA FRACTION ONE QUARTER",
	"ORIYA FRACTION ONE HALF",
	"ORIYA FRACTION THREE QUARTERS",
	"ORIYA FRACTION ONE SIXTEENTH",
	"ORIYA FRACTION ONE EIGHTH",
	"ORIYA FRACTION THREE SIXTEENTHS",
	"TAMIL SIGN ANUSVARA",
	"TAMIL SIGN VISARGA",
	"TAMIL LETTER A",
	"TAMIL LETTER AA",
	"TAMIL LETTER I",
	"TAMIL LETTER II",
	"TAMIL LETTER U",
	"TAMIL LETTER UU",
	"TAMIL LETTER E",
	"TAMIL LETTER EE",
	"TAMIL LETTER AI",
	"TAMIL LETTER O",
	"TAMIL LETTER OO",
	"TAMIL LETTER AU",
	"TAMIL LETTER KA",
	"TAMIL LETTER NGA",
	"TAMIL LETTER CA",
	"TAMIL LETTER JA",
	"TAMIL LETTER NYA",
	"TAMIL LETTER TTA",
	"TAMIL LETTER NNA",
	"TAMIL LETTER TA",
	"TAMIL LETTER NA",
	"TAMIL LETTER NNNA",
	"TAMIL LETTER PA",
	"TAMIL LETTER MA",
	"TAMIL LETTER YA",
	"TAMIL LETTER RA",
	"TAMIL LETTER RRA",
	"TAMIL LETTER LA",
	"TAMIL LETTER LLA",
	"TAMIL LETTER LLLA",
	"TAMIL LETTER VA",
	"TAMIL LETTER SHA",
	"TAMIL LETTER SSA",
	"TAMIL LETTER SA",
	"TAMIL LETTER HA",
	"TAMIL VOWEL SIGN AA",
	"TAMIL VOWEL SIGN I",
	"TAMIL VOWEL SIGN II",
	"TAMIL VOWEL SIGN U",
	"TAMIL VOWEL SIGN UU",
	"TAMIL VOWEL SIGN E",
	"TAMIL VOWEL SIGN EE",
	"TAMIL VOWEL SIGN AI",
	"TAMIL VOWEL SIGN O",
	"TAMIL VOWEL SIGN OO",
	"TAMIL VOWEL SIGN AU",
	"TAMIL SIGN VIRAMA",
	"TAMIL OM",
	"TAMIL AU LENGTH MARK",
	"TAMIL DIGIT ZERO",
	"TAMIL DIGIT ONE",
	"TAMIL DIGIT TWO",
	"TAMIL DIGIT THREE",
	"TAMIL DIGIT FOUR",
	"TAMIL DIGIT FIVE",
	"TAMIL DIGIT SIX",
	"TAMIL DIGIT SEVEN",
	"TAMIL DIGIT EIGHT",
	"TAMIL DIGIT NINE",
	"TAMIL NUMBER TEN",
	"TAMIL NUMBER ONE HUNDRED",
	"TAMIL NUMBER ONE THOUSAND",
	"TAMIL DAY SIGN",
	"TAMIL MONTH SIGN",
	"TAMIL YEAR SIGN",
	"TAMIL DEBIT SIGN",
	"TAMIL CREDIT SIGN",
	"TAMIL AS ABOVE SIGN",
	"TAMIL RUPEE SIGN",
	"TAMIL NUMBER SIGN",
	"TELUGU SIGN COMBINING CANDRABINDU ABOVE",
	"TELUGU SIGN CANDRABINDU",
	"TELUGU SIGN ANUSVARA",
	"TELUGU SIGN VISARGA",
	"TELUGU SIGN COMBINING ANUSVARA ABOVE",
	"TELUGU LETTER A",
	"TELUGU LETTER AA",
	"TELUGU LETTER I",
	"TELUGU LETTER II",
	"TELUGU LETTER U",
	"TELUGU LETTER UU",
	"TELUGU LETTER VOCALIC R",
	"TELUGU LETTER VOCALIC L",
	"TELUGU LETTER E",
	"TELUGU LETTER EE",
	"TELUGU LETTER AI",
	"TELUGU LETTER O",
	"TELUGU LETTER OO",
	"TELUGU LETTER AU",
	"TELUGU LETTER KA",
	"TELUGU LETTER KHA",
	"TELUGU LETTER GA",
	"TELUGU LETTER GHA",
	"TELUGU LETTER NGA",
	"TELUGU LETTER CA",
	"TELUGU LETTER CHA",
	"TELUGU LETTER JA",
	"TELUGU LETTER JHA",
	"TELUGU LETTER NYA",
	"TELUGU LETTER TTA",
	"TELUGU LETTER TTHA",
	"TELUGU LETTER DDA",
	"TELUGU LETTER DDHA",
	"TELUGU LETTER NNA",
	"TELUGU LETTER TA",
	"TELUGU LETTER THA",
	"TELUGU LETTER DA",
	"TELUGU LETTER DHA",
	"TELUGU LETTER NA",
	"TELUGU LETTER PA",
	"TELUGU LETTER PHA",
	"TELUGU LETTER BA",
	"TELUGU LETTER BHA",
	"TELUGU LETTER MA",
	"TELUGU LETTER YA",
	"TELUGU LETTER RA",
	"TELUGU LETTER RRA",
	"TELUGU LETTER LA",
	"TELUGU LETTER LLA",
	"TELUGU LETTER LLLA",
	"TELUGU LETTER VA",
	"TELUGU LETTER SHA",
	"TELUGU LETTER SSA",
	"TELUGU LETTER SA",
	"TELUGU LETTER HA",
	"TELUGU SIGN NUKTA",
	"TELUGU SIGN AVAGRAHA",
	"TELUGU VOWEL SIGN AA",
	"TELUGU VOWEL SIGN I",
	"TELUGU VOWEL SIGN II",
	"TELUGU VOWEL SIGN U",
	"TELUGU VOWEL SIGN UU",
	"TELUGU VOWEL SIGN VOCALIC R",
	"TELUGU VOWEL SIGN VOCALIC RR",
	"TELUGU VOWEL SIGN E",
	"TELUGU VOWEL SIGN EE",
	"TELUGU VOWEL SIGN AI",
	"TELUGU VOWEL SIGN O",
	"TELUGU VOWEL SIGN OO",
	"TELUGU VOWEL SIGN AU",
	"TELUGU SIGN VIRAMA",
	"TELUGU LENGTH MARK",
	"TELUGU AI LENGTH MARK",
	"TELUGU LETTER TSA",
	"TELUGU LETTER DZA",
	"TELUGU LETTER RRRA",
	"TELUGU LETTER NAKAARA POLLU",
	"TELUGU LETTER VOCALIC RR",
	"TELUGU LETTER VOCALIC LL",
	"TELUGU VOWEL SIGN VOCALIC L",
	"TELUGU VOWEL SIGN VOCALIC LL",
	"TELUGU DIGIT ZERO",
	"TELUGU DIGIT ONE",
	"TELUGU DIGIT TWO",
	"TELUGU DIGIT THREE",
	"TELUGU DIGIT FOUR",
	"TELUGU DIGIT FIVE",
	"TELUGU DIGIT SIX",
	"TELUGU DIGIT SEVEN",
	"TELUGU DIGIT EIGHT",
	"TELUGU DIGIT NINE",
	"TELUGU SIGN SIDDHAM",
	"TELUGU FRACTION DIGIT ZERO FOR ODD POWERS OF FOUR",
	"TELUGU FRACTION DIGIT ONE FOR ODD POWERS OF FOUR",
	"TELUGU FRACTION DIGIT TWO FOR ODD POWERS OF FOUR",
	"TELUGU FRACTION DIGIT THREE FOR ODD POWERS OF FOUR",
	"TELUGU FRACTION DIGIT ONE FOR EVEN POWERS OF FOUR",
	"TELUGU FRACTION DIGIT TWO FOR EVEN POWERS OF FOUR",
	"TELUGU FRACTION DIGIT THREE FOR EVEN POWERS OF FOUR",
	"TELUGU SIGN TUUMU",
	"KANNADA SIGN SPACING CANDRABINDU",
	"KANNADA SIGN CANDRABINDU",
	"KANNADA SIGN ANUSVARA",
	"KANNADA SIGN VISARGA",
	"KANNADA SIGN SIDDHAM",
	"KANNADA LETTER A",
	"KANNADA LETTER AA",
	"KANNADA LETTER I",
	"KANNADA LETTER II",
	"KANNADA LETTER U",
	"KANNADA LETTER UU",
	"KANNADA LETTER VOCALIC R",
	"KANNADA LETTER VOCALIC L",
	"KANNADA LETTER E",
	"KANNADA LETTER EE",
	"KANNADA LETTER AI",
	"KANNADA LETTER O",
	"KANNADA LETTER OO",
	"KANNADA LETTER AU",
	"KANNADA LETTER KA",
	"KANNADA LETTER KHA",
	"KANNADA LETTER GA",
	"KANNADA LETTER GHA",
	"KANNADA LETTER NGA",
	"KANNADA LETTER CA",
	"KANNADA LETTER CHA",
	"KANNADA LETTER JA",
	"KANNADA LETTER JHA",
	"KANNADA LETTER NYA",
	"KANNADA LETTER TTA",
	"KANNADA LETTER TTHA",
	"KANNADA LETTER DDA",
	"KANNADA LETTER DDHA",
	"KANNADA LETTER NNA",
	"KANNADA LETTER TA",
	"KANNADA LETTER THA",
	"KANNADA LETTER DA",
	"KANNADA LETTER DHA",
	"KANNADA LETTER NA",
	"KANNADA LETTER PA",
	"KANNADA LETTER PHA",
	"KANNADA LETTER BA",
	"KANNADA LETTER BHA",
	"KANNADA LETTER MA",
	"KANNADA LETTER YA",
	"KANNADA LETTER RA",
	"KANNADA LETTER RRA",
	"KANNADA LETTER LA",
	"KANNADA LETTER LLA",
	"KANNADA LETTER VA",
	"KANNADA LETTER SHA",
	"KANNADA LETTER SSA",
	"KANNADA LETTER SA",
	"KANNADA LETTER HA",
	"KANNADA SIGN NUKTA",
	"KANNADA SIGN AVAGRAHA",
	"KANNADA VOWEL SIGN AA",
	"KANNADA VOWEL SIGN I",
	"KANNADA VOWEL SIGN II",
	"KANNADA VOWEL SIGN U",
	"KANNADA VOWEL SIGN UU",
	"KANNADA VOWEL SIGN VOCALIC R",
	"KANNADA VOWEL SIGN VOCALIC RR",
	"KANNADA VOWEL SIGN E",
	"KANNADA VOWEL SIGN EE",
	"KANNADA VOWEL SIGN AI",
	"KANNADA VOWEL SIGN O",
	"KANNADA VOWEL SIGN OO",
	"KANNADA VOWEL SIGN AU",
	"KANNADA SIGN VIRAMA",
	"KANNADA LENGTH MARK",
	"KANNADA AI LENGTH MARK",
	"KANNADA LETTER NAKAARA POLLU",
	"KANNADA LETTER FA",
	"KANNADA LETTER VOCALIC RR",
	"KANNADA LETTER VOCALIC LL",
	"KANNADA VOWEL SIGN VOCALIC L",
	"KANNADA VOWEL SIGN VOCALIC LL",
	"KANNADA DIGIT ZERO",
	"KANNADA DIGIT ONE",
	"KANNADA DIGIT TWO",
	"KANNADA DIGIT THREE",
	"KANNADA DIGIT FOUR",
	"KANNADA DIGIT FIVE",
	"KANNADA DIGIT SIX",
	"KANNADA DIGIT SEVEN",
	"KANNADA DIGIT EIGHT",
	"KANNADA DIGIT NINE",
	"KANNADA SIGN JIHVAMULIYA",
	"KANNADA SIGN UPADHMANIYA",
	"KANNADA SIGN COMBINING ANUSVARA ABOVE RIGHT",
	"MALAYALAM SIGN COMBINING ANUSVARA ABOVE",
	"MALAYALAM SIGN CANDRABINDU",
	"MALAYALAM SIGN ANUSVARA",
	"MALAYALAM SIGN VISARGA",
	"MALAYALAM LETTER VEDIC ANUSVARA",
	"MALAYALAM LETTER A",
	"MALAYALAM LETTER AA",
	"MALAYALAM LETTER I",
	"MALAYALAM LETTER II",
	"MALAYALAM LETTER U",
	"MALAYALAM LETTER UU",
	"MALAYALAM LETTER VOCALIC R",
	"MALAYALAM LETTER VOCALIC L",
	"MALAYALAM LETTER E",
	"MALAYALAM LETTER EE",
	"MALAYALAM LETTER AI",
	"MALAYALAM LETTER O",
	"MALAYALAM LETTER OO",
	"MALAYALAM LETTER AU",
	"MALAYALAM LETTER KA",
	"MALAYALAM LETTER KHA",
	"MALAYALAM LETTER GA",
	"MALAYALAM LETTER GHA",
	"MALAYALAM LETTER NGA",
	"MALAYALAM LETTER CA",
	"MALAYALAM LETTER CHA",
	"MALAYALAM LETTER JA",
	"MALAYALAM LETTER JHA",
	"MALAYALAM LETTER NYA",
	"MALAYALAM LETTER TTA",
	"MALAYALAM LETTER TTHA",
	"MALAYALAM LETTER DDA",
	"MALAYALAM LETTER DDHA",
	"MALAYALAM LETTER NNA",
	"MALAYALAM LETTER TA",
	"MALAYALAM LETTER THA",
	"MALAYALAM LETTER DA",
	"MALAYALAM LETTER DHA",
	"MALAYALAM LETTER NA",
	"MALAYALAM LETTER NNNA",
	"MALAYALAM LETTER PA",
	"MALAYALAM LETTER PHA",
	"MALAYALAM LETTER BA",
	"MALAYALAM LETTER BHA",
	"MALAYALAM LETTER MA",
	"MALAYALAM LETTER YA",
	"MALAYALAM LETTER RA",
	"MALAYALAM LETTER RRA",
	"MALAYALAM LETTER LA",
	"MALAYALAM LETTER LLA",
	"MALAYALAM LETTER LLLA",
	"MALAYALAM LETTER VA",
	"MALAYALAM LETTER SHA",
	"MALAYALAM LETTER SSA",
	"MALAYALAM LETTER SA",
	"MALAYALAM LETTER HA",
	"MALAYALAM LETTER TTTA",
	"MALAYALAM SIGN VERTICAL BAR VIRAMA",
	"MALAYALAM SIGN CIRCULAR VIRAMA",
	"MALAYALAM SIGN AVAGRAHA",
	"MALAYALAM VOWEL SIGN AA",
	"MALAYALAM VOWEL SIGN I",
	"MALAYALAM VOWEL SIGN II",
	"MALAYALAM VOWEL SIGN U",
	"MALAYALAM VOWEL SIGN UU",
	"MALAYALAM VOWEL SIGN VOCALIC R",
	"MALAYALAM VOWEL SIGN VOCALIC RR",
	"MALAYALAM VOWEL SIGN E",
	"MALAYALAM VOWEL SIGN EE",
	"MALAYALAM VOWEL SIGN AI",
	"MALAYALAM VOWEL SIGN O",
	"MALAYALAM VOWEL SIGN OO",
	"MALAYALAM VOWEL SIGN AU",
	"MALAYALAM SIGN VIRAMA",
	"MALAYALAM LETTER DOT REPH",
	"MALAYALAM SIGN PARA",
	"MALAYALAM LETTER CHILLU M",
	"MALAYALAM LETTER CHILLU Y",
	"MALAYALAM LETTER CHILLU LLL",
	"MALAYALAM AU LENGTH MARK",
	"MALAYALAM FRACTION ONE ONE-HUNDRED-AND-SIXTIETH",
	"MALAYALAM FRACTION ONE FORTIETH",
	"MALAYALAM FRACTION THREE EIGHTIETHS",
	"MALAYALAM FRACTION ONE TWENTIETH",
	"MALAYALAM FRACTION ONE TENTH",
	"MALAYALAM FRACTION THREE TWENTIETHS",
	"MALAYALAM FRACTION ONE FIFTH",
	"MALAYALAM LETTER ARCHAIC II",
	"MALAYALAM LETTER VOCALIC RR",
	"MALAYALAM LETTER VOCALIC LL",
	"MALAYALAM VOWEL SIGN VOCALIC L",
	"MALAYALAM VOWEL SIGN VOCALIC LL",
	"MALAYALAM DIGIT ZERO",
	"MALAYALAM DIGIT ONE",
	"MALAYALAM DIGIT TWO",
	"MALAYALAM DIGIT THREE",
	"MALAYALAM DIGIT FOUR",
	"MALAYALAM DIGIT FIVE",
	"MALAYALAM DIGIT SIX",
	"MALAYALAM DIGIT SEVEN",
	"MALAYALAM DIGIT EIGHT",
	"MALAYALAM DIGIT NINE",
	"MALAYALAM NUMBER TEN",
	"MALAYALAM NUMBER ONE HUNDRED",
	"MALAYALAM NUMBER ONE THOUSAND",
	"MALAYALAM FRACTION ONE QUARTER",
	"MALAYALAM FRACTION ONE HALF",
	"MALAYALAM FRACTION THREE QUARTERS",
	"MALAYALAM FRACTION ONE SIXTEENTH",
	"MALAYALAM FRACTION ONE EIGHTH",
	"MALAYALAM FRACTION THREE SIXTEENTHS",
	"MALAYALAM DATE MARK",
	"MALAYALAM LETTER CHILLU NN",
	"MALAYALAM LETTER CHILLU N",
	"MALAYALAM LETTER CHILLU RR",
	"MALAYALAM LETTER CHILLU L",
	"MALAYALAM LETTER CHILLU LL",
	"MALAYALAM LETTER CHILLU K",
	"SINHALA SIGN CANDRABINDU",
	"SINHALA SIGN ANUSVARAYA",
	"SINHALA SIGN VISARGAYA",
	"SINHALA LETTER AYANNA",
	"SINHALA LETTER AAYANNA",
	"SINHALA LETTER AEYANNA",
	"SINHALA LETTER AEEYANNA",
	"SINHALA LETTER IYANNA",
	"SINHALA LETTER IIYANNA",
	"SINHALA LETTER UYANNA",
	"SINHALA LETTER UUYANNA",
	"SINHALA LETTER IRUYANNA",
	"SINHALA LETTER IRUUYANNA",
	"SINHALA LETTER ILUYANNA",
	"SINHALA LETTER ILUUYANNA",
	"SINHALA LETTER EYANNA",
	"SINHALA LETTER EEYANNA",
	"SINHALA LETTER AIYANNA",
	"SINHALA LETTER OYANNA",
	"SINHALA LETTER OOYANNA",
	"SINHALA LETTER AUYANNA",
	"SINHALA LETTER ALPAPRAANA KAYANNA",
	"SINHALA LETTER MAHAAPRAANA KAYANNA",
	"SINHALA LETTER ALPAPRAANA GAYANNA",
	"SINHALA LETTER MAHAAPRAANA GAYANNA",
	"SINHALA LETTER KANTAJA NAASIKYAYA",
	"SINHALA LETTER SANYAKA GAYANNA",
	"SINHALA LETTER ALPAPRAANA CAYANNA",
	"SINHALA LETTER MAHAAPRAANA CAYANNA",
	"SINHALA LETTER ALPAPRAANA JAYANNA",
	"SINHALA LETTER MAHAAPRAANA JAYANNA",
	"SINHALA LETTER TAALUJA NAASIKYAYA",
	"SINHALA LETTER TAALUJA SANYOOGA NAAKSIKYAYA",
	"SINHALA LETTER SANYAKA JAYANNA",
	"SINHALA LETTER ALPAPRAANA TTAYANNA",
	"SINHALA LETTER MAHAAPRAANA TTAYANNA",
	"SINHALA LETTER ALPAPRAANA DDAYANNA",
	"SINHALA LETTER MAHAAPRAANA DDAYANNA",
	"SINHALA LETTER MUURDHAJA NAYANNA",
	"SINHALA LETTER SANYAKA DDAYANNA",
	"SINHALA LETTER ALPAPRAANA TAYANNA",
	"SINHALA LETTER MAHAAPRAANA TAYANNA",
	"SINHALA LETTER ALPAPRAANA DAYANNA",
	"SINHALA LETTER MAHAAPRAANA DAYANNA",
	"SINHALA LETTER DANTAJA NAYANNA",
	"SINHALA LETTER SANYAKA DAYANNA",
	"SINHALA LETTER ALPAPRAANA PAYANNA",
	"SINHALA LETTER MAHAAPRAANA PAYANNA",
	"SINHALA LETTER ALPAPRAANA BAYANNA",
	"SINHALA LETTER MAHAAPRAANA BAYANNA",
	"SINHALA LETTER MAYANNA",
	"SINHALA LETTER AMBA BAYANNA",
	"SINHALA LETTER YAYANNA",
	"SINHALA LETTER RAYANNA",
	"SINHALA LETTER DANTAJA LAYANNA",
	"SINHALA LETTER VAYANNA",
	"SINHALA LETTER TAALUJA SAYANNA",
	"SINHALA LETTER MUURDHAJA SAYANNA",
	"SINHALA LETTER DANTAJA SAYANNA",
	"SINHALA LETTER HAYANNA",
	"SINHALA LETTER MUURDHAJA LAYANNA",
	"SINHALA LETTER FAYANNA",
	"SINHALA SIGN AL-LAKUNA",
	"SINHALA VOWEL SIGN AELA-PILLA",
	"SINHALA VOWEL SIGN KETTI AEDA-PILLA",
	"SINHALA VOWEL SIGN DIGA AEDA-PILLA",
	"SINHALA VOWEL SIGN KETTI IS-PILLA",
	"SINHALA VOWEL SIGN DIGA IS-PILLA",
	"SINHALA VOWEL SIGN KETTI PAA-PILLA",
	"SINHALA VOWEL SIGN DIGA PAA-PILLA",
	"SINHALA VOWEL SIGN GAETTA-PILLA",
	"SINHALA VOWEL SIGN KOMBUVA",
	"SINHALA VOWEL SIGN DIGA KOMBUVA",
	"SINHALA VOWEL SIGN KOMBU DEKA",
	"SINHALA VOWEL SIGN KOMBUVA HAA AELA-PILLA",
	"SINHALA VOWEL SIGN KOMBUVA HAA DIGA AELA-PILLA",
	"SINHALA VOWEL SIGN KOMBUVA HAA GAYANUKITTA",
	"SINHALA VOWEL SIGN GAYANUKITTA",
	"SINHALA LITH DIGIT ZERO",
	"SINHALA LITH DIGIT ONE",
	"SINHALA LITH DIGIT TWO",
	"SINHALA LITH DIGIT THREE",
	"SINHALA LITH DIGIT FOUR",
	"SINHALA LITH DIGIT FIVE",
	"SINHALA LITH DIGIT SIX",
	"SINHALA LITH DIGIT SEVEN",
	"SINHALA LITH DIGIT EIGHT",
	"SINHALA LITH DIGIT NINE",
	"SINHALA VOWEL SIGN DIGA GAETTA-PILLA",
	"SINHALA VOWEL SIGN DIGA GAYANUKITTA",
	"SINHALA PUNCTUATION KUNDDALIYA",
	"THAI CHARACTER KO KAI",
	"THAI CHARACTER KHO KHAI",
	"THAI CHARACTER KHO KHUAT",
	"THAI CHARACTER KHO KHWAI",
	"THAI CHARACTER KHO KHON",
	"THAI CHARACTER KHO RAKHANG",
	"THAI CHARACTER NGO NGU",
	"THAI CHARACTER CHO CHAN",
	"THAI CHARACTER CHO CHING",
	"THAI CHARACTER CHO CHANG",
	"THAI CHARACTER SO SO",
	"THAI CHARACTER CHO CHOE",
	"THAI CHARACTER YO YING",
	"THAI CHARACTER DO CHADA",
	"THAI CHARACTER TO PATAK",
	"THAI CHARACTER THO THAN",
	"THAI CHARACTER THO NANGMONTHO",
	"THAI CHARACTER THO PHUTHAO",
	"THAI CHARACTER NO NEN",
	"THAI CHARACTER DO DEK",
	"THAI CHARACTER TO TAO",
	"THAI CHARACTER THO THUNG",
	"THAI CHARACTER THO THAHAN",
	"THAI CHARACTER THO THONG",
	"THAI CHARACTER NO NU",
	"THAI CHARACTER BO BAIMAI",
	"THAI CHARACTER PO PLA",
	"THAI CHARACTER PHO PHUNG",
	"THAI CHARACTER FO FA",
	"THAI CHARACTER PHO PHAN",
	"THAI CHARACTER FO FAN",
	"THAI CHARACTER PHO SAMPHAO",
	"THAI CHARACTER MO MA",
	"THAI CHARACTER YO YAK",
	"THAI CHARACTER RO RUA",
	"THAI CHARACTER RU",
	"THAI CHARACTER LO LING",
	"THAI CHARACTER LU",
	"THAI CHARACTER WO WAEN",
	"THAI CHARACTER SO SALA",
	"THAI CHARACTER SO RUSI",
	"THAI CHARACTER SO SUA",
	"THAI CHARACTER HO HIP",
	"THAI CHARACTER LO CHULA",
	"THAI CHARACTER O ANG",
	"THAI CHARACTER HO NOKHUK",
	"THAI CHARACTER PAIYANNOI",
	"THAI CHARACTER SARA A",
	"THAI CHARACTER MAI HAN-AKAT",
	"THAI CHARACTER SARA AA",
	"THAI CHARACTER SARA AM",
	"THAI CHARACTER SARA I",
	"THAI CHARACTER SARA II",
	"THAI CHARACTER SARA UE",
	"THAI CHARACTER SARA UEE",
	"THAI CHARACTER SARA U",
	"THAI CHARACTER SARA UU",
	"THAI CHARACTER PHINTHU",
	"THAI CURRENCY SYMBOL BAHT",
	"THAI CHARACTER SARA E",
	"THAI CHARACTER SARA AE",
	"THAI CHARACTER SARA O",
	"THAI CHARACTER SARA AI MAIMUAN",
	"THAI CHARACTER SARA AI MAIMALAI",
	"THAI CHARACTER LAKKHANGYAO",
	"THAI CHARACTER MAIYAMOK",
	"THAI CHARACTER MAITAIKHU",
	"THAI CHARACTER MAI EK",
	"THAI CHARACTER MAI THO",
	"THAI CHARACTER MAI TRI",
	"THAI CHARACTER MAI CHATTAWA",
	"THAI CHARACTER THANTHAKHAT",
	"THAI CHARACTER NIKHAHIT",
	"THAI CHARACTER YAMAKKAN",
	"THAI CHARACTER FONGMAN",
	"THAI DIGIT ZERO",
	"THAI DIGIT ONE",
	"THAI DIGIT TWO",
	"THAI DIGIT THREE",
	"THAI DIGIT FOUR",
	"THAI DIGIT FIVE",
	"THAI DIGIT SIX",
	"THAI DIGIT SEVEN",
	"THAI DIGIT EIGHT",
	"THAI DIGIT NINE",
	"THAI CHARACTER ANGKHANKHU",
	"THAI CHARACTER KHOMUT",
	"LAO LETTER KO",
	"LAO LETTER KHO SUNG",
	"LAO LETTER KHO TAM",
	"LAO LETTER PALI GHA",
	"LAO LETTER NGO",
	"LAO LETTER CO",
	"LAO LETTER PALI CHA",
	"LAO LETTER SO TAM",
	"LAO LETTER PALI JHA",
	"LAO LETTER NYO",
	"LAO LETTER PALI NYA",
	"LAO LETTER PALI TTA",
	"LAO LETTER PALI TTHA",
	"LAO LETTER PALI DDA",
	"LAO LETTER PALI DDHA",
	"LAO LETTER PALI NNA",
	"LAO LETTER DO",
	"LAO LETTER TO",
	"LAO LETTER THO SUNG",
	"LAO LETTER THO TAM",
	"LAO LETTER PALI DHA",
	"LAO LETTER NO",
	"LAO LETTER BO",
	"LAO LETTER PO",
	"LAO LETTER PHO SUNG",
	"LAO LETTER FO TAM",
	"LAO LETTER PHO TAM",
	"LAO LETTER FO SUNG",
	"LAO LETTER PALI BHA",
	"LAO LETTER MO",
	"LAO LETTER YO",
	"LAO LETTER LO LING",
	"LAO LETTER LO LOOT",
	"LAO LETTER WO",
	"LAO LETTER SANSKRIT SHA",
	"LAO LETTER SANSKRIT SSA",
	"LAO LETTER SO SUNG",
	"LAO LETTER HO SUNG",
	"LAO LETTER PALI LLA",
	"LAO LETTER O",
	"LAO LETTER HO TAM",
	"LAO ELLIPSIS",
	"LAO VOWEL SIGN A",
	"LAO VOWEL SIGN MAI KAN",
	"LAO VOWEL SIGN AA",
	"LAO VOWEL SIGN AM",
	"LAO VOWEL SIGN I",
	"LAO VOWEL SIGN II",
	"LAO VOWEL SIGN Y",
	"LAO VOWEL SIGN YY",
	"LAO VOWEL SIGN U",
	"LAO VOWEL SIGN UU",
	"LAO SIGN PALI VIRAMA",
	"LAO VOWEL SIGN MAI KON",
	"LAO SEMIVOWEL SIGN LO",
	"LAO SEMIVOWEL SIGN NYO",
	"LAO VOWEL SIGN E",
	"LAO VOWEL SIGN EI",
	"LAO VOWEL SIGN O",
	"LAO VOWEL SIGN AY",
	"LAO VOWEL SIGN AI",
	"LAO KO LA",
	"LAO TONE MAI EK",
	"LAO TONE MAI THO",
	"LAO TONE MAI TI",
	"LAO TONE MAI CATAWA",
	"LAO CANCELLATION MARK",
	"LAO NIGGAHITA",
	"LAO YAMAKKAN",
	"LAO DIGIT ZERO",
	"LAO DIGIT ONE",
	"LAO DIGIT TWO",
	"LAO DIGIT THREE",
	"LAO DIGIT FOUR",
	"LAO DIGIT FIVE",
	"LAO DIGIT SIX",
	"LAO DIGIT SEVEN",
	"LAO DIGIT EIGHT",
	"LAO DIGIT NINE",
	"LAO HO NO",
	"LAO HO MO",
	"LAO LETTER KHMU GO",
	"LAO LETTER KHMU NYO",
	"TIBETAN SYLLABLE OM",
	"TIBETAN MARK GTER YIG MGO TRUNCATED A",
	"TIBETAN MARK GTER YIG MGO -UM RNAM BCAD MA",
	"TIBETAN MARK GTER YIG MGO -UM GTER TSHEG MA",
	"TIBETAN MARK INITIAL YIG MGO MDUN MA",
	"TIBETAN MARK CLOSING YIG MGO SGAB MA",
	"TIBETAN MARK CARET YIG MGO PHUR SHAD MA",
	"TIBETAN MARK YIG MGO TSHEG SHAD MA",
	"TIBETAN MARK SBRUL SHAD",
	"TIBETAN MARK BSKUR YIG MGO",
	"TIBETAN MARK BKA- SHOG YIG MGO",
	"TIBETAN MARK INTERSYLLABIC TSHEG",
	"TIBETAN MARK DELIMITER TSHEG BSTAR",
	"TIBETAN MARK SHAD",
	"TIBETAN MARK NYIS SHAD",
	"TIBETAN MARK TSHEG SHAD",
	"TIBETAN MARK NYIS TSHEG SHAD",
	"TIBETAN MARK RIN CHEN SPUNGS SHAD",
	"TIBETAN MARK RGYA GRAM SHAD",
	"TIBETAN MARK CARET -DZUD RTAGS ME LONG CAN",
	"TIBETAN MARK GTER TSHEG",
	"TIBETAN LOGOTYPE SIGN CHAD RTAGS",
	"TIBETAN LOGOTYPE SIGN LHAG RTAGS",
	"TIBETAN ASTROLOGICAL SIGN SGRA GCAN -CHAR RTAGS",
	"TIBETAN ASTROLOGICAL SIGN -KHYUD PA",
	"TIBETAN ASTROLOGICAL SIGN SDONG TSHUGS",
	"TIBETAN SIGN RDEL DKAR GCIG",
	"TIBETAN SIGN RDEL DKAR GNYIS",
	"TIBETAN SIGN RDEL DKAR GSUM",
	"TIBETAN SIGN RDEL NAG GCIG",
	"TIBETAN SIGN RDEL NAG GNYIS",
	"TIBETAN SIGN RDEL DKAR RDEL NAG",
	"TIBETAN DIGIT ZERO",
	"TIBETAN DIGIT ONE",
	"TIBETAN DIGIT TWO",
	"TIBETAN DIGIT THREE",
	"TIBETAN DIGIT FOUR",
	"TIBETAN DIGIT FIVE",
	"TIBETAN DIGIT SIX",
	"TIBETAN DIGIT SEVEN",
	"TIBETAN DIGIT EIGHT",
	"TIBETAN DIGIT NINE",
	"TIBETAN DIGIT HALF ONE",
	"TIBETAN DIGIT HALF TWO",
	"TIBETAN DIGIT HALF THREE",
	"TIBETAN DIGIT HALF FOUR",
	"TIBETAN DIGIT HALF FIVE",
	"TIBETAN DIGIT HALF SIX",
	"TIBETAN DIGIT HALF SEVEN",
	"TIBETAN DIGIT HALF EIGHT",
	"TIBETAN DIGIT HALF NINE",
	"TIBETAN DIGIT HALF ZERO",
	"TIBETAN MARK BSDUS RTAGS",
	"TIBETAN MARK NGAS BZUNG NYI ZLA",
	"TIBETAN MARK CARET -DZUD RTAGS BZHI MIG CAN",
	"TIBETAN MARK NGAS BZUNG SGOR RTAGS",
	"TIBETAN MARK CHE MGO",
	"TIBETAN MARK TSA -PHRU",
	"TIBETAN MARK GUG RTAGS GYON",
	"TIBETAN MARK GUG RTAGS GYAS",
	"TIBETAN MARK ANG KHANG GYON",
	"TIBETAN MARK ANG KHANG GYAS",
	"TIBETAN SIGN YAR TSHES",
	"TIBETAN SIGN MAR TSHES",
	"TIBETAN LETTER KA",
	"TIBETAN LETTER KHA",
	"TIBETAN LETTER GA",
	"TIBETAN LETTER GHA",
	"TIBETAN LETTER NGA",
	"TIBETAN LETTER CA",
	"TIBETAN LETTER CHA",
	"TIBETAN LETTER JA",
	"TIBETAN LETTER NYA",
	"TIBETAN LETTER TTA",
	"TIBETAN LETTER TTHA",
	"TIBETAN LETTER DDA",
	"TIBETAN LETTER DDHA",
	"TIBETAN LETTER NNA",
	"TIBETAN LETTER TA",
	"TIBETAN LETTER THA",
	"TIBETAN LETTER DA",
	"TIBETAN LETTER DHA",
	"TIBETAN LETTER NA",
	"TIBETAN LETTER PA",
	"TIBETAN LETTER PHA",
	"TIBETAN LETTER BA",
	"TIBETAN LETTER BHA",
	"TIBETAN LETTER MA",
	"TIBETAN LETTER TSA",
	"TIBETAN LETTER TSHA",
	"TIBETAN LETTER DZA",
	"TIBETAN LETTER DZHA",
	"TIBETAN LETTER WA",
	"TIBETAN LETTER ZHA",
	"TIBETAN LETTER ZA",
	"TIBETAN LETTER -A",
	"TIBETAN LETTER YA",
	"TIBETAN LETTER RA",
	"TIBETAN LETTER LA",
	"TIBETAN LETTER SHA",
	"TIBETAN LETTER SSA",
	"TIBETAN LETTER SA",
	"TIBETAN LETTER HA",
	"TIBETAN LETTER A",
	"TIBETAN LETTER KSSA",
	"TIBETAN LETTER FIXED-FORM RA",
	"TIBETAN LETTER KKA",
	"TIBETAN LETTER RRA",
	"TIBETAN VOWEL SIGN AA",
	"TIBETAN VOWEL SIGN I",
	"TIBETAN VOWEL SIGN II",
	"TIBETAN VOWEL SIGN U",
	"TIBETAN VOWEL SIGN UU",
	"TIBETAN VOWEL SIGN VOCALIC R",
	"TIBETAN VOWEL SIGN VOCALIC RR",
	"TIBETAN VOWEL SIGN VOCALIC L",
	"TIBETAN VOWEL SIGN VOCALIC LL",
	"TIBETAN VOWEL SIGN E",
	"TIBETAN VOWEL SIGN EE",
	"TIBETAN VOWEL SIGN O",
	"TIBETAN VOWEL SIGN OO",
	"TIBETAN SIGN RJES SU NGA RO",
	"TIBETAN SIGN RNAM BCAD",
	"TIBETAN VOWEL SIGN REVERSED I",
	"TIBETAN VOWEL SIGN REVERSED II",
	"TIBETAN SIGN NYI ZLA NAA DA",
	"TIBETAN SIGN SNA LDAN",
	"TIBETAN MARK HALANTA",
	"TIBETAN MARK PALUTA",
	"TIBETAN SIGN LCI RTAGS",
	"TIBETAN SIGN YANG RTAGS",
	"TIBETAN SIGN LCE TSA CAN",
	"TIBETAN SIGN MCHU CAN",
	"TIBETAN SIGN GRU CAN RGYINGS",
	"TIBETAN SIGN GRU MED RGYINGS",
	"TIBETAN SIGN INVERTED MCHU CAN",
	"TIBETAN SUBJOINED SIGN LCE TSA CAN",
	"TIBETAN SUBJOINED SIGN MCHU CAN",
	"TIBETAN SUBJOINED SIGN INVERTED MCHU CAN",
	"TIBETAN SUBJOINED LETTER KA",
	"TIBETAN SUBJOINED LETTER KHA",
	"TIBETAN SUBJOINED LETTER GA",
	"TIBETAN SUBJOINED LETTER GHA",
	"TIBETAN SUBJOINED LETTER NGA",
	"TIBETAN SUBJOINED LETTER CA",
	"TIBETAN SUBJOINED LETTER CHA",
	"TIBETAN SUBJOINED LETTER JA",
	"TIBETAN SUBJOINED LETTER NYA",
	"TIBETAN SUBJOINED LETTER TTA",
	"TIBETAN SUBJOINED LETTER TTHA",
	"TIBETAN SUBJOINED LETTER DDA",
	"TIBETAN SUBJOINED LETTER DDHA",
	"TIBETAN SUBJOINED LETTER NNA",
	"TIBETAN SUBJOINED LETTER TA",
	"TIBETAN SUBJOINED LETTER THA",
	"TIBETAN SUBJOINED LETTER DA",
	"TIBETAN SUBJOINED LETTER DHA",
	"TIBETAN SUBJOINED LETTER NA",
	"TIBETAN SUBJOINED LETTER PA",
	"TIBETAN SUBJOINED LETTER PHA",
	"TIBETAN SUBJOINED LETTER BA",
	"TIBETAN SUBJOINED LETTER BHA",
	"TIBETAN SUBJOINED LETTER MA",
	"TIBETAN SUBJOINED LETTER TSA",
	"TIBETAN SUBJOINED LETTER TSHA",
	"TIBETAN SUBJOINED LETTER DZA",
	"TIBETAN SUBJOINED LETTER DZHA",
	"TIBETAN SUBJOINED LETTER WA",
	"TIBETAN SUBJOINED LETTER ZHA",
	"TIBETAN SUBJOINED LETTER ZA",
	"TIBETAN SUBJOINED LETTER -A",
	"TIBETAN SUBJOINED LETTER YA",
	"TIBETAN SUBJOINED LETTER RA",
	"TIBETAN SUBJOINED LETTER LA",
	"TIBETAN SUBJOINED LETTER SHA",
	"TIBETAN SUBJOINED LETTER SSA",
	"TIBETAN SUBJOINED LETTER SA",
	"TIBETAN SUBJOINED LETTER HA",
	"TIBETAN SUBJOINED LETTER A",
	"TIBETAN SUBJOINED LETTER KSSA",
	"TIBETAN SUBJOINED LETTER FIXED-FORM WA",
	"TIBETAN SUBJOINED LETTER FIXED-FORM YA",
	"TIBETAN SUBJOINED LETTER FIXED-FORM RA",
	"TIBETAN KU RU KHA",
	"TIBETAN KU RU KHA BZHI MIG CAN",
	"TIBETAN CANTILLATION SIGN HEAVY BEAT",
	"TIBETAN CANTILLATION SIGN LIGHT BEAT",
	"TIBETAN CANTILLATION SIGN CANG TE-U",
	"TIBETAN CANTILLATION SIGN SBUB -CHAL",
	"TIBETAN SYMBOL DRIL BU",
	"TIBETAN SYMBOL RDO RJE",
	"TIBETAN SYMBOL PADMA GDAN",
	"TIBETAN SYMBOL RDO RJE RGYA GRAM",
	"TIBETAN SYMBOL PHUR PA",
	"TIBETAN SYMBOL NOR BU",
	"TIBETAN SYMBOL NOR BU NYIS -KHYIL",
	"TIBETAN SYMBOL NOR BU GSUM -KHYIL",
	"TIBETAN SYMBOL NOR BU BZHI -KHYIL",
	"TIBETAN SIGN RDEL NAG RDEL DKAR",
	"TIBETAN SIGN RDEL NAG GSUM",
	"TIBETAN MARK BSKA- SHOG GI MGO RGYAN",
	"TIBETAN MARK MNYAM YIG GI MGO RGYAN",
	"TIBETAN MARK NYIS TSHEG",
	"TIBETAN MARK INITIAL BRDA RNYING YIG MGO MDUN MA",
	"TIBETAN MARK CLOSING BRDA RNYING YIG MGO SGAB MA",
	"RIGHT-FACING SVASTI SIGN",
	"LEFT-FACING SVASTI SIGN",
	"RIGHT-FACING SVASTI SIGN WITH DOTS",
	"LEFT-FACING SVASTI SIGN WITH DOTS",
	"TIBETAN MARK LEADING MCHAN RTAGS",
	"TIBETAN MARK TRAILING MCHAN RTAGS",
	"MYANMAR LETTER KA",
	"MYANMAR LETTER KHA",
	"MYANMAR LETTER GA",
	"MYANMAR LETTER GHA",
	"MYANMAR LETTER NGA",
	"MYANMAR LETTER CA",
	"MYANMAR LETTER CHA",
	"MYANMAR LETTER JA",
	"MYANMAR LETTER JHA",
	"MYANMAR LETTER NYA",
	"MYANMAR LETTER NNYA",
	"MYANMAR LETTER TTA",
	"MYANMAR LETTER TTHA",
	"MYANMAR LETTER DDA",
	"MYANMAR LETTER DDHA",
	"MYANMAR LETTER NNA",
	"MYANMAR LETTER TA",
	"MYANMAR LETTER THA",
	"MYANMAR LETTER DA",
	"MYANMAR LETTER DHA",
	"MYANMAR LETTER NA",
	"MYANMAR LETTER PA",
	"MYANMAR LETTER PHA",
	"MYANMAR LETTER BA",
	"MYANMAR LETTER BHA",
	"MYANMAR LETTER MA",
	"MYANMAR LETTER YA",
	"MYANMAR LETTER RA",
	"MYANMAR LETTER LA",
	"MYANMAR LETTER WA",
	"MYANMAR LETTER SA",
	"MYANMAR LETTER HA",
	"MYANMAR LETTER LLA",
	"MYANMAR LETTER A",
	"MYANMAR LETTER SHAN A",
	"MYANMAR LETTER I",
	"MYANMAR LETTER II",
	"MYANMAR LETTER U",
	"MYANMAR LETTER UU",
	"MYANMAR LETTER E",
	"MYANMAR LETTER MON E",
	"MYANMAR LETTER O",
	"MYANMAR LETTER AU",
	"MYANMAR VOWEL SIGN TALL AA",
	"MYANMAR VOWEL SIGN AA",
	"MYANMAR VOWEL SIGN I",
	"MYANMAR VOWEL SIGN II",
	"MYANMAR VOWEL SIGN U",
	"MYANMAR VOWEL SIGN UU",
	"MYANMAR VOWEL SIGN E",
	"MYANMAR VOWEL SIGN AI",
	"MYANMAR VOWEL SIGN MON II",
	"MYANMAR VOWEL SIGN MON O",
	"MYANMAR VOWEL SIGN E ABOVE",
	"MYANMAR SIGN ANUSVARA",
	"MYANMAR SIGN DOT BELOW",
	"MYANMAR SIGN VISARGA",
	"MYANMAR SIGN VIRAMA",
	"MYANMAR SIGN ASAT",
	"MYANMAR CONSONANT SIGN MEDIAL YA",
	"MYANMAR CONSONANT SIGN MEDIAL RA",
	"MYANMAR CONSONANT SIGN MEDIAL WA",
	"MYANMAR CONSONANT SIGN MEDIAL HA",
	"MYANMAR LETTER GREAT SA",
	"MYANMAR DIGIT ZERO",
	"MYANMAR DIGIT ONE",
	"MYANMAR DIGIT TWO",
	"MYANMAR DIGIT THREE",
	"MYANMAR DIGIT FOUR",
	"MYANMAR DIGIT FIVE",
	"MYANMAR DIGIT SIX",
	"MYANMAR DIGIT SEVEN",
	"MYANMAR DIGIT EIGHT",
	"MYANMAR DIGIT NINE",
	"MYANMAR SIGN LITTLE SECTION",
	"MYANMAR SIGN SECTION",
	"MYANMAR SYMBOL LOCATIVE",
	"MYANMAR SYMBOL COMPLETED",
	"MYANMAR SYMBOL AFOREMENTIONED",
	"MYANMAR SYMBOL GENITIVE",
	"MYANMAR LETTER SHA",
	"MYANMAR LETTER SSA",
	"MYANMAR LETTER VOCALIC R",
	"MYANMAR LETTER VOCALIC RR",
	"MYANMAR LETTER VOCALIC L",
	"MYANMAR LETTER VOCALIC LL",
	"MYANMAR VOWEL SIGN VOCALIC R",
	"MYANMAR VOWEL SIGN VOCALIC RR",
	"MYANMAR VOWEL SIGN VOCALIC L",
	"MYANMAR VOWEL SIGN VOCALIC LL",
	"MYANMAR LETTER MON NGA",
	"MYANMAR LETTER MON JHA",
	"MYANMAR LETTER MON BBA",
	"MYANMAR LETTER MON BBE",
	"MYANMAR CONSONANT SIGN MON MEDIAL NA",
	"MYANMAR CONSONANT SIGN MON MEDIAL MA",
	"MYANMAR CONSONANT SIGN MON MEDIAL LA",
	"MYANMAR LETTER SGAW KAREN SHA",
	"MYANMAR VOWEL SIGN SGAW KAREN EU",
	"MYANMAR TONE MARK SGAW KAREN HATHI",
	"MYANMAR TONE MARK SGAW KAREN KE PHO",
	"MYANMAR LETTER WESTERN PWO KAREN THA",
	"MYANMAR LETTER WESTERN PWO KAREN PWA",
	"MYANMAR VOWEL SIGN WESTERN PWO KAREN EU",
	"MYANMAR VOWEL SIGN WESTERN PWO KAREN UE",
	"MYANMAR SIGN WESTERN PWO KAREN TONE-1",
	"MYANMAR SIGN WESTERN PWO KAREN TONE-2",
	"MYANMAR SIGN WESTERN PWO KAREN TONE-3",
	"MYANMAR SIGN WESTERN PWO KAREN TONE-4",
	"MYANMAR SIGN WESTERN PWO KAREN TONE-5",
	"MYANMAR LETTER EASTERN PWO KAREN NNA",
	"MYANMAR LETTER EASTERN PWO KAREN YWA",
	"MYANMAR LETTER EASTERN PWO KAREN GHWA",
	"MYANMAR VOWEL SIGN GEBA KAREN I",
	"MYANMAR VOWEL SIGN KAYAH OE",
	"MYANMAR VOWEL SIGN KAYAH U",
	"MYANMAR VOWEL SIGN KAYAH EE",
	"MYANMAR LETTER SHAN KA",
	"MYANMAR LETTER SHAN KHA",
	"MYANMAR LETTER SHAN GA",
	"MYANMAR LETTER SHAN CA",
	"MYANMAR LETTER SHAN ZA",
	"MYANMAR LETTER SHAN NYA",
	"MYANMAR LETTER SHAN DA",
	"MYANMAR LETTER SHAN NA",
	"MYANMAR LETTER SHAN PHA",
	"MYANMAR LETTER SHAN FA",
	"MYANMAR LETTER SHAN BA",
	"MYANMAR LETTER SHAN THA",
	"MYANMAR LETTER SHAN HA",
	"MYANMAR CONSONANT SIGN SHAN MEDIAL WA",
	"MYANMAR VOWEL SIGN SHAN AA",
	"MYANMAR VOWEL SIGN SHAN E",
	"MYANMAR VOWEL SIGN SHAN E ABOVE",
	"MYANMAR VOWEL SIGN SHAN FINAL Y",
	"MYANMAR SIGN SHAN TONE-2",
	"MYANMAR SIGN SHAN TONE-3",
	"MYANMAR SIGN SHAN TONE-5",
	"MYANMAR SIGN SHAN TONE-6",
	"MYANMAR SIGN SHAN COUNCIL TONE-2",
	"MYANMAR SIGN SHAN COUNCIL TONE-3",
	"MYANMAR SIGN SHAN COUNCIL EMPHATIC TONE",
	"MYANMAR LETTER RUMAI PALAUNG FA",
	"MYANMAR SIGN RUMAI PALAUNG TONE-5",
	"MYANMAR SHAN DIGIT ZERO",
	"MYANMAR SHAN DIGIT ONE",
	"MYANMAR SHAN DIGIT TWO",
	"MYANMAR SHAN DIGIT THREE",
	"MYANMAR SHAN DIGIT FOUR",
	"MYANMAR SHAN DIGIT FIVE",
	"MYANMAR SHAN DIGIT SIX",
	"MYANMAR SHAN DIGIT SEVEN",
	"MYANMAR SHAN DIGIT EIGHT",
	"MYANMAR SHAN DIGIT NINE",
	"MYANMAR SIGN KHAMTI TONE-1",
	"MYANMAR SIGN KHAMTI TONE-3",
	"MYANMAR VOWEL SIGN AITON A",
	"MYANMAR VOWEL SIGN AITON AI",
	"MYANMAR SYMBOL SHAN ONE",
	"MYANMAR SYMBOL SHAN EXCLAMATION",
	"GEORGIAN CAPITAL LETTER AN",
	"GEORGIAN CAPITAL LETTER BAN",
	"GEORGIAN CAPITAL LETTER GAN",
	"GEORGIAN CAPITAL LETTER DON",
	"GEORGIAN CAPITAL LETTER EN",
	"GEORGIAN CAPITAL LETTER VIN",
	"GEORGIAN CAPITAL LETTER ZEN",
	"GEORGIAN CAPITAL LETTER TAN",
	"GEORGIAN CAPITAL LETTER IN",
	"GEORGIAN CAPITAL LETTER KAN",
	"GEORGIAN CAPITAL LETTER LAS",
	"GEORGIAN CAPITAL LETTER MAN",
	"GEORGIAN CAPITAL LETTER NAR",
	"GEORGIAN CAPITAL LETTER ON",
	"GEORGIAN CAPITAL LETTER PAR",
	"GEORGIAN CAPITAL LETTER ZHAR",
	"GEORGIAN CAPITAL LETTER RAE",
	"GEORGIAN CAPITAL LETTER SAN",
	"GEORGIAN CAPITAL LETTER TAR",
	"GEORGIAN CAPITAL LETTER UN",
	"GEORGIAN CAPITAL LETTER PHAR",
	"GEORGIAN CAPITAL LETTER KHAR",
	"GEORGIAN CAPITAL LETTER GHAN",
	"GEORGIAN CAPITAL LETTER QAR",
	"GEORGIAN CAPITAL LETTER SHIN",
	"GEORGIAN CAPITAL LETTER CHIN",
	"GEORGIAN CAPITAL LETTER CAN",
	"GEORGIAN CAPITAL LETTER JIL",
	"GEORGIAN CAPITAL LETTER CIL",
	"GEORGIAN CAPITAL LETTER CHAR",
	"GEORGIAN CAPITAL LETTER XAN",
	"GEORGIAN CAPITAL LETTER JHAN",
	"GEORGIAN CAPITAL LETTER HAE",
	"GEORGIAN CAPITAL LETTER HE",
	"GEORGIAN CAPITAL LETTER HIE",
	"GEORGIAN CAPITAL LETTER WE",
	"GEORGIAN CAPITAL LETTER HAR",
	"GEORGIAN CAPITAL LETTER HOE",
	"GEORGIAN CAPITAL LETTER YN",
	"GEORGIAN CAPITAL LETTER AEN",
	"GEORGIAN LETTER AN",
	"GEORGIAN LETTER BAN",
	"GEORGIAN LETTER GAN",
	"GEORGIAN LETTER DON",
	"GEORGIAN LETTER EN",
	"GEORGIAN LETTER VIN",
	"GEORGIAN LETTER ZEN",
	"GEORGIAN LETTER TAN",
	"GEORGIAN LETTER IN",
	"GEORGIAN LETTER KAN",
	"GEORGIAN LETTER LAS",
	"GEORGIAN LETTER MAN",
	"GEORGIAN LETTER NAR",
	"GEORGIAN LETTER ON",
	"GEORGIAN LETTER PAR",
	"GEORGIAN LETTER ZHAR",
	"GEORGIAN LETTER RAE",
	"GEORGIAN LETTER SAN",
	"GEORGIAN LETTER TAR",
	"GEORGIAN LETTER UN",
	"GEORGIAN LETTER PHAR",
	"GEORGIAN LETTER KHAR",
	"GEORGIAN LETTER GHAN",
	"GEORGIAN LETTER QAR",
	"GEORGIAN LETTER SHIN",
	"GEORGIAN LETTER CHIN",
	"GEORGIAN LETTER CAN",
	"GEORGIAN LETTER JIL",
	"GEORGIAN LETTER CIL",
	"GEORGIAN LETTER CHAR",
	"GEORGIAN LETTER XAN",
	"GEORGIAN LETTER JHAN",
	"GEORGIAN LETTER HAE",
	"GEORGIAN LETTER HE",
	"GEORGIAN LETTER HIE",
	"GEORGIAN LETTER WE",
	"GEORGIAN LETTER HAR",
	"GEORGIAN LETTER HOE",
	"GEORGIAN LETTER FI",
	"GEORGIAN LETTER YN",
	"GEORGIAN LETTER ELIFI",
	"GEORGIAN LETTER TURNED GAN",
	"GEORGIAN LETTER AIN",
	"GEORGIAN PARAGRAPH SEPARATOR",
	"MODIFIER LETTER GEORGIAN NAR",
	"GEORGIAN LETTER AEN",
	"GEORGIAN LETTER HARD SIGN",
	"GEORGIAN LETTER LABIAL SIGN",
	"HANGUL CHOSEONG KIYEOK",
	"HANGUL CHOSEONG SSANGKIYEOK",
	"HANGUL CHOSEONG NIEUN",
	"HANGUL CHOSEONG TIKEUT",
	"HANGUL CHOSEONG SSANGTIKEUT",
	"HANGUL CHOSEONG RIEUL",
	"HANGUL CHOSEONG MIEUM",
	"HANGUL CHOSEONG PIEUP",
	"HANGUL CHOSEONG SSANGPIEUP",
	"HANGUL CHOSEONG SIOS",
	"HANGUL CHOSEONG SSANGSIOS",
	"HANGUL CHOSEONG IEUNG",
	"HANGUL CHOSEONG CIEUC",
	"HANGUL CHOSEONG SSANGCIEUC",
	"HANGUL CHOSEONG CHIEUCH",
	"HANGUL CHOSEONG KHIEUKH",
	"HANGUL CHOSEONG THIEUTH",
	"HANGUL CHOSEONG PHIEUPH",
	"HANGUL CHOSEONG HIEUH",
	"HANGUL CHOSEONG NIEUN-KIYEOK",
	"HANGUL CHOSEONG SSANGNIEUN",
	"HANGUL CHOSEONG NIEUN-TIKEUT",
	"HANGUL CHOSEONG NIEUN-PIEUP",
	"HANGUL CHOSEONG TIKEUT-KIYEOK",
	"HANGUL CHOSEONG RIEUL-NIEUN",
	"HANGUL CHOSEONG SSANGRIEUL",
	"HANGUL CHOSEONG RIEUL-HIEUH",
	"HANGUL CHOSEONG KAPYEOUNRIEUL",
	"HANGUL CHOSEONG MIEUM-PIEUP",
	"HANGUL CHOSEONG KAPYEOUNMIEUM",
	"HANGUL CHOSEONG PIEUP-KIYEOK",
	"HANGUL CHOSEONG PIEUP-NIEUN",
	"HANGUL CHOSEONG PIEUP-TIKEUT",
	"HANGUL CHOSEONG PIEUP-SIOS",
	"HANGUL CHOSEONG PIEUP-SIOS-KIYEOK",
	"HANGUL CHOSEONG PIEUP-SIOS-TIKEUT",
	"HANGUL CHOSEONG PIEUP-SIOS-PIEUP",
	"HANGUL CHOSEONG PIEUP-SSANGSIOS",
	"HANGUL CHOSEONG PIEUP-SIOS-CIEUC",
	"HANGUL CHOSEONG PIEUP-CIEUC",
	"HANGUL CHOSEONG PIEUP-CHIEUCH",
	"HANGUL CHOSEONG PIEUP-THIEUTH",
	"HANGUL CHOSEONG PIEUP-PHIEUPH",
	"HANGUL CHOSEONG KAPYEOUNPIEUP",
	"HANGUL CHOSEONG KAPYEOUNSSANGPIEUP",
	"HANGUL CHOSEONG SIOS-KIYEOK",
	"HANGUL CHOSEONG SIOS-NIEUN",
	"HANGUL CHOSEONG SIOS-TIKEUT",
	"HANGUL CHOSEONG SIOS-RIEUL",
	"HANGUL CHOSEONG SIOS-MIEUM",
	"HANGUL CHOSEONG SIOS-PIEUP",
	"HANGUL CHOSEONG SIOS-PIEUP-KIYEOK",
	"HANGUL CHOSEONG SIOS-SSANGSIOS",
	"HANGUL CHOSEONG SIOS-IEUNG",
	"HANGUL CHOSEONG SIOS-CIEUC",
	"HANGUL CHOSEONG SIOS-CHIEUCH",
	"HANGUL CHOSEONG SIOS-KHIEUKH",
	"HANGUL CHOSEONG SIOS-THIEUTH",
	"HANGUL CHOSEONG SIOS-PHIEUPH",
	"HANGUL CHOSEONG SIOS-HIEUH",
	"HANGUL CHOSEONG CHITUEUMSIOS",
	"HANGUL CHOSEONG CHITUEUMSSANGSIOS",
	"HANGUL CHOSEONG CEONGCHIEUMSIOS",
	"HANGUL CHOSEONG CEONGCHIEUMSSANGSIOS",
	"HANGUL CHOSEONG PANSIOS",
	"HANGUL CHOSEONG IEUNG-KIYEOK",
	"HANGUL CHOSEONG IEUNG-TIKEUT",
	"HANGUL CHOSEONG IEUNG-MIEUM",
	"HANGUL CHOSEONG IEUNG-PIEUP",
	"HANGUL CHOSEONG IEUNG-SIOS",
	"HANGUL CHOSEONG IEUNG-PANSIOS",
	"HANGUL CHOSEONG SSANGIEUNG",
	"HANGUL CHOSEONG IEUNG-CIEUC",
	"HANGUL CHOSEONG IEUNG-CHIEUCH",
	"HANGUL CHOSEONG IEUNG-THIEUTH",
	"HANGUL CHOSEONG IEUNG-PHIEUPH",
	"HANGUL CHOSEONG YESIEUNG",
	"HANGUL CHOSEONG CIEUC-IEUNG",
	"HANGUL CHOSEONG CHITUEUMCIEUC",
	"HANGUL CHOSEONG CHITUEUMSSANGCIEUC",
	"HANGUL CHOSEONG CEONGCHIEUMCIEUC",
	"HANGUL CHOSEONG CEONGCHIEUMSSANGCIEUC",
	"HANGUL CHOSEONG CHIEUCH-KHIEUKH",
	"HANGUL CHOSEONG CHIEUCH-HIEUH",
	"HANGUL CHOSEONG CHITUEUMCHIEUCH",
	"HANGUL CHOSEONG CEONGCHIEUMCHIEUCH",
	"HANGUL CHOSEONG PHIEUPH-PIEUP",
	"HANGUL CHOSEONG KAPYEOUNPHIEUPH",
	"HANGUL CHOSEONG SSANGHIEUH",
	"HANGUL CHOSEONG YEORINHIEUH",
	"HANGUL CHOSEONG KIYEOK-TIKEUT",
	"HANGUL CHOSEONG NIEUN-SIOS",
	"HANGUL CHOSEONG NIEUN-CIEUC",
	"HANGUL CHOSEONG NIEUN-HIEUH",
	"HANGUL CHOSEONG TIKEUT-RIEUL",
	"HANGUL CHOSEONG FILLER",
	"HANGUL JUNGSEONG FILLER",
	"HANGUL JUNGSEONG A",
	"HANGUL JUNGSEONG AE",
	"HANGUL JUNGSEONG YA",
	"HANGUL JUNGSEONG YAE",
	"HANGUL JUNGSEONG EO",
	"HANGUL JUNGSEONG E",
	"HANGUL JUNGSEONG YEO",
	"HANGUL JUNGSEONG YE",
	"HANGUL JUNGSEONG O",
	"HANGUL JUNGSEONG WA",
	"HANGUL JUNGSEONG WAE",
	"HANGUL JUNGSEONG OE",
	"HANGUL JUNGSEONG YO",
	"HANGUL JUNGSEONG U",
	"HANGUL JUNGSEONG WEO",
	"HANGUL JUNGSEONG WE",
	"HANGUL JUNGSEONG WI",
	"HANGUL JUNGSEONG YU",
	"HANGUL JUNGSEONG EU",
	"HANGUL JUNGSEONG YI",
	"HANGUL JUNGSEONG I",
	"HANGUL JUNGSEONG A-O",
	"HANGUL JUNGSEONG A-U",
	"HANGUL JUNGSEONG YA-O",
	"HANGUL JUNGSEONG YA-YO",
	"HANGUL JUNGSEONG EO-O",
	"HANGUL JUNGSEONG EO-U",
	"HANGUL JUNGSEONG EO-EU",
	"HANGUL JUNGSEONG YEO-O",
	"HANGUL JUNGSEONG YEO-U",
	"HANGUL JUNGSEONG O-EO",
	"HANGUL JUNGSEONG O-E",
	"HANGUL JUNGSEONG O-YE",
	"HANGUL JUNGSEONG O-O",
	"HANGUL JUNGSEONG O-U",
	"HANGUL JUNGSEONG YO-YA",
	"HANGUL JUNGSEONG YO-YAE",
	"HANGUL JUNGSEONG YO-YEO",
	"HANGUL JUNGSEONG YO-O",
	"HANGUL JUNGSEONG YO-I",
	"HANGUL JUNGSEONG U-A",
	"HANGUL JUNGSEONG U-AE",
	"HANGUL JUNGSEONG U-EO-EU",
	"HANGUL JUNGSEONG U-YE",
	"HANGUL JUNGSEONG U-U",
	"HANGUL JUNGSEONG YU-A",
	"HANGUL JUNGSEONG YU-EO",
	"HANGUL JUNGSEONG YU-E",
	"HANGUL JUNGSEONG YU-YEO",
	"HANGUL JUNGSEONG YU-YE",
	"HANGUL JUNGSEONG YU-U",
	"HANGUL JUNGSEONG YU-I",
	"HANGUL JUNGSEONG EU-U",
	"HANGUL JUNGSEONG EU-EU",
	"HANGUL JUNGSEONG YI-U",
	"HANGUL JUNGSEONG I-A",
	"HANGUL JUNGSEONG I-YA",
	"HANGUL JUNGSEONG I-O",
	"HANGUL JUNGSEONG I-U",
	"HANGUL JUNGSEONG I-EU",
	"HANGUL JUNGSEONG I-ARAEA",
	"HANGUL JUNGSEONG ARAEA",
	"HANGUL JUNGSEONG ARAEA-EO",
	"HANGUL JUNGSEONG ARAEA-U",
	"HANGUL JUNGSEONG ARAEA-I",
	"HANGUL JUNGSEONG SSANGARAEA",
	"HANGUL JUNGSEONG A-EU",
	"HANGUL JUNGSEONG YA-U",
	"HANGUL JUNGSEONG YEO-YA",
	"HANGUL JUNGSEONG O-YA",
	"HANGUL JUNGSEONG O-YAE",
	"HANGUL JONGSEONG KIYEOK",
	"HANGUL JONGSEONG SSANGKIYEOK",
	"HANGUL JONGSEONG KIYEOK-SIOS",
	"HANGUL JONGSEONG NIEUN",
	"HANGUL JONGSEONG NIEUN-CIEUC",
	"HANGUL JONGSEONG NIEUN-HIEUH",
	"HANGUL JONGSEONG TIKEUT",
	"HANGUL JONGSEONG RIEUL",
	"HANGUL JONGSEONG RIEUL-KIYEOK",
	"HANGUL JONGSEONG RIEUL-MIEUM",
	"HANGUL JONGSEONG RIEUL-PIEUP",
	"HANGUL JONGSEONG RIEUL-SIOS",
	"HANGUL JONGSEONG RIEUL-THIEUTH",
	"HANGUL JONGSEONG RIEUL-PHIEUPH",
	"HANGUL JONGSEONG RIEUL-HIEUH",
	"HANGUL JONGSEONG MIEUM",
	"HANGUL JONGSEONG PIEUP",
	"HANGUL JONGSEONG PIEUP-SIOS",
	"HANGUL JONGSEONG SIOS",
	"HANGUL JONGSEONG SSANGSIOS",
	"HANGUL JONGSEONG IEUNG",
	"HANGUL JONGSEONG CIEUC",
	"HANGUL JONGSEONG CHIEUCH",
	"HANGUL JONGSEONG KHIEUKH",
	"HANGUL JONGSEONG THIEUTH",
	"HANGUL JONGSEONG PHIEUPH",
	"HANGUL JONGSEONG HIEUH",
	"HANGUL JONGSEONG KIYEOK-RIEUL",
	"HANGUL JONGSEONG KIYEOK-SIOS-KIYEOK",
	"HANGUL JONGSEONG NIEUN-KIYEOK",
	"HANGUL JONGSEONG NIEUN-TIKEUT",
	"HANGUL JONGSEONG NIEUN-SIOS",
	"HANGUL JONGSEONG NIEUN-PANSIOS",
	"HANGUL JONGSEONG NIEUN-THIEUTH",
	"HANGUL JONGSEONG TIKEUT-KIYEOK",
	"HANGUL JONGSEONG TIKEUT-RIEUL",
	"HANGUL JONGSEONG RIEUL-KIYEOK-SIOS",
	"HANGUL JONGSEONG RIEUL-NIEUN",
	"HANGUL JONGSEONG RIEUL-TIKEUT",
	"HANGUL JONGSEONG RIEUL-TIKEUT-HIEUH",
	"HANGUL JONGSEONG SSANGRIEUL",
	"HANGUL JONGSEONG RIEUL-MIEUM-KIYEOK",
	"HANGUL JONGSEONG RIEUL-MIEUM-SIOS",
	"HANGUL JONGSEONG RIEUL-PIEUP-SIOS",
	"HANGUL JONGSEONG RIEUL-PIEUP-HIEUH",
	"HANGUL JONGSEONG RIEUL-KAPYEOUNPIEUP",
	"HANGUL JONGSEONG RIEUL-SSANGSIOS",
	"HANGUL JONGSEONG RIEUL-PANSIOS",
	"HANGUL JONGSEONG RIEUL-KHIEUKH",
	"HANGUL JONGSEONG RIEUL-YEORINHIEUH",
	"HANGUL JONGSEONG MIEUM-KIYEOK",
	"HANGUL JONGSEONG MIEUM-RIEUL",
	"HANGUL JONGSEONG MIEUM-PIEUP",
	"HANGUL JONGSEONG MIEUM-SIOS",
	"HANGUL JONGSEONG MIEUM-SSANGSIOS",
	"HANGUL JONGSEONG MIEUM-PANSIOS",
	"HANGUL JONGSEONG MIEUM-CHIEUCH",
	"HANGUL JONGSEONG MIEUM-HIEUH",
	"HANGUL JONGSEONG KAPYEOUNMIEUM",
	"HANGUL JONGSEONG PIEUP-RIEUL",
	"HANGUL JONGSEONG PIEUP-PHIEUPH",
	"HANGUL JONGSEONG PIEUP-HIEUH",
	"HANGUL JONGSEONG KAPYEOUNPIEUP",
	"HANGUL JONGSEONG SIOS-KIYEOK",
	"HANGUL JONGSEONG SIOS-TIKEUT",
	"HANGUL JONGSEONG SIOS-RIEUL",
	"HANGUL JONGSEONG SIOS-PIEUP",
	"HANGUL JONGSEONG PANSIOS",
	"HANGUL JONGSEONG IEUNG-KIYEOK",
	"HANGUL JONGSEONG IEUNG-SSANGKIYEOK",
	"HANGUL JONGSEONG SSANGIEUNG",
	"HANGUL JONGSEONG IEUNG-KHIEUKH",
	"HANGUL JONGSEONG YESIEUNG",
	"HANGUL JONGSEONG YESIEUNG-SIOS",
	"HANGUL JONGSEONG YESIEUNG-PANSIOS",
	"HANGUL JONGSEONG PHIEUPH-PIEUP",
	"HANGUL JONGSEONG KAPYEOUNPHIEUPH",
	"HANGUL JONGSEONG HIEUH-NIEUN",
	"HANGUL JONGSEONG HIEUH-RIEUL",
	"HANGUL JONGSEONG HIEUH-MIEUM",
	"HANGUL JONGSEONG HIEUH-PIEUP",
	"HANGUL JONGSEONG YEORINHIEUH",
	"HANGUL JONGSEONG KIYEOK-NIEUN",
	"HANGUL JONGSEONG KIYEOK-PIEUP",
	"HANGUL JONGSEONG KIYEOK-CHIEUCH",
	"HANGUL JONGSEONG KIYEOK-KHIEUKH",
	"HANGUL JONGSEONG KIYEOK-HIEUH",
	"HANGUL JONGSEONG SSANGNIEUN",
	"ETHIOPIC SYLLABLE HA",
	"ETHIOPIC SYLLABLE HU",
	"ETHIOPIC SYLLABLE HI",
	"ETHIOPIC SYLLABLE HAA",
	"ETHIOPIC SYLLABLE HEE",
	"ETHIOPIC SYLLABLE HE",
	"ETHIOPIC SYLLABLE HO",
	"ETHIOPIC SYLLABLE HOA",
	"ETHIOPIC SYLLABLE LA",
	"ETHIOPIC SYLLABLE LU",
	"ETHIOPIC SYLLABLE LI",
	"ETHIOPIC SYLLABLE LAA",
	"ETHIOPIC SYLLABLE LEE",
	"ETHIOPIC SYLLABLE LE",
	"ETHIOPIC SYLLABLE LO",
	"ETHIOPIC SYLLABLE LWA",
	"ETHIOPIC SYLLABLE HHA",
	"ETHIOPIC SYLLABLE HHU",
	"ETHIOPIC SYLLABLE HHI",
	"ETHIOPIC SYLLABLE HHAA",
	"ETHIOPIC SYLLABLE HHEE",
	"ETHIOPIC SYLLABLE HHE",
	"ETHIOPIC SYLLABLE HHO",
	"ETHIOPIC SYLLABLE HHWA",
	"ETHIOPIC SYLLABLE MA",
	"ETHIOPIC SYLLABLE MU",
	"ETHIOPIC SYLLABLE MI",
	"ETHIOPIC SYLLABLE MAA",
	"ETHIOPIC SYLLABLE MEE",
	"ETHIOPIC SYLLABLE ME",
	"ETHIOPIC SYLLABLE MO",
	"ETHIOPIC SYLLABLE MWA",
	"ETHIOPIC SYLLABLE SZA",
	"ETHIOPIC SYLLABLE SZU",
	"ETHIOPIC SYLLABLE SZI",
	"ETHIOPIC SYLLABLE SZAA",
	"ETHIOPIC SYLLABLE SZEE",
	"ETHIOPIC SYLLABLE SZE",
	"ETHIOPIC SYLLABLE SZO",
	"ETHIOPIC SYLLABLE SZWA",
	"ETHIOPIC SYLLABLE RA",
	"ETHIOPIC SYLLABLE RU",
	"ETHIOPIC SYLLABLE RI",
	"ETHIOPIC SYLLABLE RAA",
	"ETHIOPIC SYLLABLE REE",
	"ETHIOPIC SYLLABLE RE",
	"ETHIOPIC SYLLABLE RO",
	"ETHIOPIC SYLLABLE RWA",
	"ETHIOPIC SYLLABLE SA",
	"ETHIOPIC SYLLABLE SU",
	"ETHIOPIC SYLLABLE SI",
	"ETHIOPIC SYLLABLE SAA",
	"ETHIOPIC SYLLABLE SEE",
	"ETHIOPIC SYLLABLE SE",
	"ETHIOPIC SYLLABLE SO",
	"ETHIOPIC SYLLABLE SWA",
	"ETHIOPIC SYLLABLE SHA",
	"ETHIOPIC SYLLABLE SHU",
	"ETHIOPIC SYLLABLE SHI",
	"ETHIOPIC SYLLABLE SHAA",
	"ETHIOPIC SYLLABLE SHEE",
	"ETHIOPIC SYLLABLE SHE",
	"ETHIOPIC SYLLABLE SHO",
	"ETHIOPIC SYLLABLE SHWA",
	"ETHIOPIC SYLLABLE QA",
	"ETHIOPIC SYLLABLE QU",
	"ETHIOPIC SYLLABLE QI",
	"ETHIOPIC SYLLABLE QAA",
	"ETHIOPIC SYLLABLE QEE",
	"ETHIOPIC SYLLABLE QE",
	"ETHIOPIC SYLLABLE QO",
	"ETHIOPIC SYLLABLE QOA",
	"ETHIOPIC SYLLABLE QWA",
	"ETHIOPIC SYLLABLE QWI",
	"ETHIOPIC SYLLABLE QWAA",
	"ETHIOPIC SYLLABLE QWEE",
	"ETHIOPIC SYLLABLE QWE",
	"ETHIOPIC SYLLABLE QHA",
	"ETHIOPIC SYLLABLE QHU",
	"ETHIOPIC SYLLABLE QHI",
	"ETHIOPIC SYLLABLE QHAA",
	"ETHIOPIC SYLLABLE QHEE",
	"ETHIOPIC SYLLABLE QHE",
	"ETHIOPIC SYLLABLE QHO",
	"ETHIOPIC SYLLABLE QHWA",
	"ETHIOPIC SYLLABLE QHWI",
	"ETHIOPIC SYLLABLE QHWAA",
	"ETHIOPIC SYLLABLE QHWEE",
	"ETHIOPIC SYLLABLE QHWE",
	"ETHIOPIC SYLLABLE BA",
	"ETHIOPIC SYLLABLE BU",
	"ETHIOPIC SYLLABLE BI",
	"ETHIOPIC SYLLABLE BAA",
	"ETHIOPIC SYLLABLE BEE",
	"ETHIOPIC SYLLABLE BE",
	"ETHIOPIC SYLLABLE BO",
	"ETHIOPIC SYLLABLE BWA",
	"ETHIOPIC SYLLABLE VA",
	"ETHIOPIC SYLLABLE VU",
	"ETHIOPIC SYLLABLE VI",
	"ETHIOPIC SYLLABLE VAA",
	"ETHIOPIC SYLLABLE VEE",
	"ETHIOPIC SYLLABLE VE",
	"ETHIOPIC SYLLABLE VO",
	"ETHIOPIC SYLLABLE VWA",
	"ETHIOPIC SYLLABLE TA",
	"ETHIOPIC SYLLABLE TU",
	"ETHIOPIC SYLLABLE TI",
	"ETHIOPIC SYLLABLE TAA",
	"ETHIOPIC SYLLABLE TEE",
	"ETHIOPIC SYLLABLE TE",
	"ETHIOPIC SYLLABLE TO",
	"ETHIOPIC SYLLABLE TWA",
	"ETHIOPIC SYLLABLE CA",
	"ETHIOPIC SYLLABLE CU",
	"ETHIOPIC SYLLABLE CI",
	"ETHIOPIC SYLLABLE CAA",
	"ETHIOPIC SYLLABLE CEE",
	"ETHIOPIC SYLLABLE CE",
	"ETHIOPIC SYLLABLE CO",
	"ETHIOPIC SYLLABLE CWA",
	"ETHIOPIC SYLLABLE XA",
	"ETHIOPIC SYLLABLE XU",
	"ETHIOPIC SYLLABLE XI",
	"ETHIOPIC SYLLABLE XAA",
	"ETHIOPIC SYLLABLE XEE",
	"ETHIOPIC SYLLABLE XE",
	"ETHIOPIC SYLLABLE XO",
	"ETHIOPIC SYLLABLE XOA",
	"ETHIOPIC SYLLABLE XWA",
	"ETHIOPIC SYLLABLE XWI",
	"ETHIOPIC SYLLABLE XWAA",
	"ETHIOPIC SYLLABLE XWEE",
	"ETHIOPIC SYLLABLE XWE",
	"ETHIOPIC SYLLABLE NA",
	"ETHIOPIC SYLLABLE NU",
	"ETHIOPIC SYLLABLE NI",
	"ETHIOPIC SYLLABLE NAA",
	"ETHIOPIC SYLLABLE NEE",
	"ETHIOPIC SYLLABLE NE",
	"ETHIOPIC SYLLABLE NO",
	"ETHIOPIC SYLLABLE NWA",
	"ETHIOPIC SYLLABLE NYA",
	"ETHIOPIC SYLLABLE NYU",
	"ETHIOPIC SYLLABLE NYI",
	"ETHIOPIC SYLLABLE NYAA",
	"ETHIOPIC SYLLABLE NYEE",
	"ETHIOPIC SYLLABLE NYE",
	"ETHIOPIC SYLLABLE NYO",
	"ETHIOPIC SYLLABLE NYWA",
	"ETHIOPIC SYLLABLE GLOTTAL A",
	"ETHIOPIC SYLLABLE GLOTTAL U",
	"ETHIOPIC SYLLABLE GLOTTAL I",
	"ETHIOPIC SYLLABLE GLOTTAL AA",
	"ETHIOPIC SYLLABLE GLOTTAL EE",
	"ETHIOPIC SYLLABLE GLOTTAL E",
	"ETHIOPIC SYLLABLE GLOTTAL O",
	"ETHIOPIC SYLLABLE GLOTTAL WA",
	"ETHIOPIC SYLLABLE KA",
	"ETHIOPIC SYLLABLE KU",
	"ETHIOPIC SYLLABLE KI",
	"ETHIOPIC SYLLABLE KAA",
	"ETHIOPIC SYLLABLE KEE",
	"ETHIOPIC SYLLABLE KE",
	"ETHIOPIC SYLLABLE KO",
	"ETHIOPIC SYLLABLE KOA",
	"ETHIOPIC SYLLABLE KWA",
	"ETHIOPIC SYLLABLE KWI",
	"ETHIOPIC SYLLABLE KWAA",
	"ETHIOPIC SYLLABLE KWEE",
	"ETHIOPIC SYLLABLE KWE",
	"ETHIOPIC SYLLABLE KXA",
	"ETHIOPIC SYLLABLE KXU",
	"ETHIOPIC SYLLABLE KXI",
	"ETHIOPIC SYLLABLE KXAA",
	"ETHIOPIC SYLLABLE KXEE",
	"ETHIOPIC SYLLABLE KXE",
	"ETHIOPIC SYLLABLE KXO",
	"ETHIOPIC SYLLABLE KXWA",
	"ETHIOPIC SYLLABLE KXWI",
	"ETHIOPIC SYLLABLE KXWAA",
	"ETHIOPIC SYLLABLE KXWEE",
	"ETHIOPIC SYLLABLE KXWE",
	"ETHIOPIC SYLLABLE WA",
	"ETHIOPIC SYLLABLE WU",
	"ETHIOPIC SYLLABLE WI",
	"ETHIOPIC SYLLABLE WAA",
	"ETHIOPIC SYLLABLE WEE",
	"ETHIOPIC SYLLABLE WE",
	"ETHIOPIC SYLLABLE WO",
	"ETHIOPIC SYLLABLE WOA",
	"ETHIOPIC SYLLABLE PHARYNGEAL A",
	"ETHIOPIC SYLLABLE PHARYNGEAL U",
	"ETHIOPIC SYLLABLE PHARYNGEAL I",
	"ETHIOPIC SYLLABLE PHARYNGEAL AA",
	"ETHIOPIC SYLLABLE PHARYNGEAL EE",
	"ETHIOPIC SYLLABLE PHARYNGEAL E",
	"ETHIOPIC SYLLABLE PHARYNGEAL O",
	"ETHIOPIC SYLLABLE ZA",
	"ETHIOPIC SYLLABLE ZU",
	"ETHIOPIC SYLLABLE ZI",
	"ETHIOPIC SYLLABLE ZAA",
	"ETHIOPIC SYLLABLE ZEE",
	"ETHIOPIC SYLLABLE ZE",
	"ETHIOPIC SYLLABLE ZO",
	"ETHIOPIC SYLLABLE ZWA",
	"ETHIOPIC SYLLABLE ZHA",
	"ETHIOPIC SYLLABLE ZHU",
	"ETHIOPIC SYLLABLE ZHI",
	"ETHIOPIC SYLLABLE ZHAA",
	"ETHIOPIC SYLLABLE ZHEE",
	"ETHIOPIC SYLLABLE ZHE",
	"ETHIOPIC SYLLABLE ZHO",
	"ETHIOPIC SYLLABLE ZHWA",
	"ETHIOPIC SYLLABLE YA",
	"ETHIOPIC SYLLABLE YU",
	"ETHIOPIC SYLLABLE YI",
	"ETHIOPIC SYLLABLE YAA",
	"ETHIOPIC SYLLABLE YEE",
	"ETHIOPIC SYLLABLE YE",
	"ETHIOPIC SYLLABLE YO",
	"ETHIOPIC SYLLABLE YOA",
	"ETHIOPIC SYLLABLE DA",
	"ETHIOPIC SYLLABLE DU",
	"ETHIOPIC SYLLABLE DI",
	"ETHIOPIC SYLLABLE DAA",
	"ETHIOPIC SYLLABLE DEE",
	"ETHIOPIC SYLLABLE DE",
	"ETHIOPIC SYLLABLE DO",
	"ETHIOPIC SYLLABLE DWA",
	"ETHIOPIC SYLLABLE DDA",
	"ETHIOPIC SYLLABLE DDU",
	"ETHIOPIC SYLLABLE DDI",
	"ETHIOPIC SYLLABLE DDAA",
	"ETHIOPIC SYLLABLE DDEE",
	"ETHIOPIC SYLLABLE DDE",
	"ETHIOPIC SYLLABLE DDO",
	"ETHIOPIC SYLLABLE DDWA",
	"ETHIOPIC SYLLABLE JA",
	"ETHIOPIC SYLLABLE JU",
	"ETHIOPIC SYLLABLE JI",
	"ETHIOPIC SYLLABLE JAA",
	"ETHIOPIC SYLLABLE JEE",
	"ETHIOPIC SYLLABLE JE",
	"ETHIOPIC SYLLABLE JO",
	"ETHIOPIC SYLLABLE JWA",
	"ETHIOPIC SYLLABLE GA",
	"ETHIOPIC SYLLABLE GU",
	"ETHIOPIC SYLLABLE GI",
	"ETHIOPIC SYLLABLE GAA",
	"ETHIOPIC SYLLABLE GEE",
	"ETHIOPIC SYLLABLE GE",
	"ETHIOPIC SYLLABLE GO",
	"ETHIOPIC SYLLABLE GOA",
	"ETHIOPIC SYLLABLE GWA",
	"ETHIOPIC SYLLABLE GWI",
	"ETHIOPIC SYLLABLE GWAA",
	"ETHIOPIC SYLLABLE GWEE",
	"ETHIOPIC SYLLABLE GWE",
	"ETHIOPIC SYLLABLE GGA",
	"ETHIOPIC SYLLABLE GGU",
	"ETHIOPIC SYLLABLE GGI",
	"ETHIOPIC SYLLABLE GGAA",
	"ETHIOPIC SYLLABLE GGEE",
	"ETHIOPIC SYLLABLE GGE",
	"ETHIOPIC SYLLABLE GGO",
	"ETHIOPIC SYLLABLE GGWAA",
	"ETHIOPIC SYLLABLE THA",
	"ETHIOPIC SYLLABLE THU",
	"ETHIOPIC SYLLABLE THI",
	"ETHIOPIC SYLLABLE THAA",
	"ETHIOPIC SYLLABLE THEE",
	"ETHIOPIC SYLLABLE THE",
	"ETHIOPIC SYLLABLE THO",
	"ETHIOPIC SYLLABLE THWA",
	"ETHIOPIC SYLLABLE CHA",
	"ETHIOPIC SYLLABLE CHU",
	"ETHIOPIC SYLLABLE CHI",
	"ETHIOPIC SYLLABLE CHAA",
	"ETHIOPIC SYLLABLE CHEE",
	"ETHIOPIC SYLLABLE CHE",
	"ETHIOPIC SYLLABLE CHO",
	"ETHIOPIC SYLLABLE CHWA",
	"ETHIOPIC SYLLABLE PHA",
	"ETHIOPIC SYLLABLE PHU",
	"ETHIOPIC SYLLABLE PHI",
	"ETHIOPIC SYLLABLE PHAA",
	"ETHIOPIC SYLLABLE PHEE",
	"ETHIOPIC SYLLABLE PHE",
	"ETHIOPIC SYLLABLE PHO",
	"ETHIOPIC SYLLABLE PHWA",
	"ETHIOPIC SYLLABLE TSA",
	"ETHIOPIC SYLLABLE TSU",
	"ETHIOPIC SYLLABLE TSI",
	"ETHIOPIC SYLLABLE TSAA",
	"ETHIOPIC SYLLABLE TSEE",
	"ETHIOPIC SYLLABLE TSE",
	"ETHIOPIC SYLLABLE TSO",
	"ETHIOPIC SYLLABLE TSWA",
	"ETHIOPIC SYLLABLE TZA",
	"ETHIOPIC SYLLABLE TZU",
	"ETHIOPIC SYLLABLE TZI",
	"ETHIOPIC SYLLABLE TZAA",
	"ETHIOPIC SYLLABLE TZEE",
	"ETHIOPIC SYLLABLE TZE",
	"ETHIOPIC SYLLABLE TZO",
	"ETHIOPIC SYLLABLE TZOA",
	"ETHIOPIC SYLLABLE FA",
	"ETHIOPIC SYLLABLE FU",
	"ETHIOPIC SYLLABLE FI",
	"ETHIOPIC SYLLABLE FAA",
	"ETHIOPIC SYLLABLE FEE",
	"ETHIOPIC SYLLABLE FE",
	"ETHIOPIC SYLLABLE FO",
	"ETHIOPIC SYLLABLE FWA",
	"ETHIOPIC SYLLABLE PA",
	"ETHIOPIC SYLLABLE PU",
	"ETHIOPIC SYLLABLE PI",
	"ETHIOPIC SYLLABLE PAA",
	"ETHIOPIC SYLLABLE PEE",
	"ETHIOPIC SYLLABLE PE",
	"ETHIOPIC SYLLABLE PO",
	"ETHIOPIC SYLLABLE PWA",
	"ETHIOPIC SYLLABLE RYA",
	"ETHIOPIC SYLLABLE MYA",
	"ETHIOPIC SYLLABLE FYA",
	"ETHIOPIC COMBINING GEMINATION AND VOWEL LENGTH MARK",
	"ETHIOPIC COMBINING VOWEL LENGTH MARK",
	"ETHIOPIC COMBINING GEMINATION MARK",
	"ETHIOPIC SECTION MARK",
	"ETHIOPIC WORDSPACE",
	"ETHIOPIC FULL STOP",
	"ETHIOPIC COMMA",
	"ETHIOPIC SEMICOLON",
	"ETHIOPIC COLON",
	"ETHIOPIC PREFACE COLON",
	"ETHIOPIC QUESTION MARK",
	"ETHIOPIC PARAGRAPH SEPARATOR",
	"ETHIOPIC DIGIT ONE",
	"ETHIOPIC DIGIT TWO",
	"ETHIOPIC DIGIT THREE",
	"ETHIOPIC DIGIT FOUR",
	"ETHIOPIC DIGIT FIVE",
	"ETHIOPIC DIGIT SIX",
	"ETHIOPIC DIGIT SEVEN",
	"ETHIOPIC DIGIT EIGHT",
	"ETHIOPIC DIGIT NINE",
	"ETHIOPIC NUMBER TEN",
	"ETHIOPIC NUMBER TWENTY",
	"ETHIOPIC NUMBER THIRTY",
	"ETHIOPIC NUMBER FORTY",
	"ETHIOPIC NUMBER FIFTY",
	"ETHIOPIC NUMBER SIXTY",
	"ETHIOPIC NUMBER SEVENTY",
	"ETHIOPIC NUMBER EIGHTY",
	"ETHIOPIC NUMBER NINETY",
	"ETHIOPIC NUMBER HUNDRED",
	"ETHIOPIC NUMBER TEN THOUSAND",
	"ETHIOPIC SYLLABLE SEBATBEIT MWA",
	"ETHIOPIC SYLLABLE MWI",
	"ETHIOPIC SYLLABLE MWEE",
	"ETHIOPIC SYLLABLE MWE",
	"ETHIOPIC SYLLABLE SEBATBEIT BWA",
	"ETHIOPIC SYLLABLE BWI",
	"ETHIOPIC SYLLABLE BWEE",
	"ETHIOPIC SYLLABLE BWE",
	"ETHIOPIC SYLLABLE SEBATBEIT FWA",
	"ETHIOPIC SYLLABLE FWI",
	"ETHIOPIC SYLLABLE FWEE",
	"ETHIOPIC SYLLABLE FWE",
	"ETHIOPIC SYLLABLE SEBATBEIT PWA",
	"ETHIOPIC SYLLABLE PWI",
	"ETHIOPIC SYLLABLE PWEE",
	"ETHIOPIC SYLLABLE PWE",
	"ETHIOPIC TONAL MARK YIZET",
	"ETHIOPIC TONAL MARK DERET",
	"ETHIOPIC TONAL MARK RIKRIK",
	"ETHIOPIC TONAL MARK SHORT RIKRIK",
	"ETHIOPIC TONAL MARK DIFAT",
	"ETHIOPIC TONAL MARK KENAT",
	"ETHIOPIC TONAL MARK CHIRET",
	"ETHIOPIC TONAL MARK HIDET",
	"ETHIOPIC TONAL MARK DERET-HIDET",
	"ETHIOPIC TONAL MARK KURT",
	"CHEROKEE LETTER A",
	"CHEROKEE LETTER E",
	"CHEROKEE LETTER I",
	"CHEROKEE LETTER O",
	"CHEROKEE LETTER U",
	"CHEROKEE LETTER V",
	"CHEROKEE LETTER GA",
	"CHEROKEE LETTER KA",
	"CHEROKEE LETTER GE",
	"CHEROKEE LETTER GI",
	"CHEROKEE LETTER GO",
	"CHEROKEE LETTER GU",
	"CHEROKEE LETTER GV",
	"CHEROKEE LETTER HA",
	"CHEROKEE LETTER HE",
	"CHEROKEE LETTER HI",
	"CHEROKEE LETTER HO",
	"CHEROKEE LETTER HU",
	"CHEROKEE LETTER HV",
	"CHEROKEE LETTER LA",
	"CHEROKEE LETTER LE",
	"CHEROKEE LETTER LI",
	"CHEROKEE LETTER LO",
	"CHEROKEE LETTER LU",
	"CHEROKEE LETTER LV",
	"CHEROKEE LETTER MA",
	"CHEROKEE LETTER ME",
	"CHEROKEE LETTER MI",
	"CHEROKEE LETTER MO",
	"CHEROKEE LETTER MU",
	"CHEROKEE LETTER NA",
	"CHEROKEE LETTER HNA",
	"CHEROKEE LETTER NAH",
	"CHEROKEE LETTER NE",
	"CHEROKEE LETTER NI",
	"CHEROKEE LETTER NO",
	"CHEROKEE LETTER NU",
	"CHEROKEE LETTER NV",
	"CHEROKEE LETTER QUA",
	"CHEROKEE LETTER QUE",
	"CHEROKEE LETTER QUI",
	"CHEROKEE LETTER QUO",
	"CHEROKEE LETTER QUU",
	"CHEROKEE LETTER QUV",
	"CHEROKEE LETTER SA",
	"CHEROKEE LETTER S",
	"CHEROKEE LETTER SE",
	"CHEROKEE LETTER SI",
	"CHEROKEE LETTER SO",
	"CHEROKEE LETTER SU",
	"CHEROKEE LETTER SV",
	"CHEROKEE LETTER DA",
	"CHEROKEE LETTER TA",
	"CHEROKEE LETTER DE",
	"CHEROKEE LETTER TE",
	"CHEROKEE LETTER DI",
	"CHEROKEE LETTER TI",
	"CHEROKEE LETTER DO",
	"CHEROKEE LETTER DU",
	"CHEROKEE LETTER DV",
	"CHEROKEE LETTER DLA",
	"CHEROKEE LETTER TLA",
	"CHEROKEE LETTER TLE",
	"CHEROKEE LETTER TLI",
	"CHEROKEE LETTER TLO",
	"CHEROKEE LETTER TLU",
	"CHEROKEE LETTER TLV",
	"CHEROKEE LETTER TSA",
	"CHEROKEE LETTER TSE",
	"CHEROKEE LETTER TSI",
	"CHEROKEE LETTER TSO",
	"CHEROKEE LETTER TSU",
	"CHEROKEE LETTER TSV",
	"CHEROKEE LETTER WA",
	"CHEROKEE LETTER WE",
	"CHEROKEE LETTER WI",
	"CHEROKEE LETTER WO",
	"CHEROKEE LETTER WU",
	"CHEROKEE LETTER WV",
	"CHEROKEE LETTER YA",
	"CHEROKEE LETTER YE",
	"CHEROKEE LETTER YI",
	"CHEROKEE LETTER YO",
	"CHEROKEE LETTER YU",
	"CHEROKEE LETTER YV",
	"CHEROKEE LETTER MV",
	"CHEROKEE SMALL LETTER YE",
	"CHEROKEE SMALL LETTER YI",
	"CHEROKEE SMALL LETTER YO",
	"CHEROKEE SMALL LETTER YU",
	"CHEROKEE SMALL LETTER YV",
	"CHEROKEE SMALL LETTER MV",
	"CANADIAN SYLLABICS HYPHEN",
	"CANADIAN SYLLABICS E",
	"CANADIAN SYLLABICS AAI",
	"CANADIAN SYLLABICS I",
	"CANADIAN SYLLABICS II",
	"CANADIAN SYLLABICS O",
	"CANADIAN SYLLABICS OO",
	"CANADIAN SYLLABICS Y-CREE OO",
	"CANADIAN SYLLABICS CARRIER EE",
	"CANADIAN SYLLABICS CARRIER I",
	"CANADIAN SYLLABICS A",
	"CANADIAN SYLLABICS AA",
	"CANADIAN SYLLABICS WE",
	"CANADIAN SYLLABICS WEST-CREE WE",
	"CANADIAN SYLLABICS WI",
	"CANADIAN SYLLABICS WEST-CREE WI",
	"CANADIAN SYLLABICS WII",
	"CANADIAN SYLLABICS WEST-CREE WII",
	"CANADIAN SYLLABICS WO",
	"CANADIAN SYLLABICS WEST-CREE WO",
	"CANADIAN SYLLABICS WOO",
	"CANADIAN SYLLABICS WEST-CREE WOO",
	"CANADIAN SYLLABICS NASKAPI WOO",
	"CANADIAN SYLLABICS WA",
	"CANADIAN SYLLABICS WEST-CREE WA",
	"CANADIAN SYLLABICS WAA",
	"CANADIAN SYLLABICS WEST-CREE WAA",
	"CANADIAN SYLLABICS NASKAPI WAA",
	"CANADIAN SYLLABICS AI",
	"CANADIAN SYLLABICS Y-CREE W",
	"CANADIAN SYLLABICS GLOTTAL STOP",
	"CANADIAN SYLLABICS FINAL ACUTE",
	"CANADIAN SYLLABICS FINAL GRAVE",
	"CANADIAN SYLLABICS FINAL BOTTOM HALF RING",
	"CANADIAN SYLLABICS FINAL TOP HALF RING",
	"CANADIAN SYLLABICS FINAL RIGHT HALF RING",
	"CANADIAN SYLLABICS FINAL RING",
	"CANADIAN SYLLABICS FINAL DOUBLE ACUTE",
	"CANADIAN SYLLABICS FINAL DOUBLE SHORT VERTICAL STROKES",
	"CANADIAN SYLLABICS FINAL MIDDLE DOT",
	"CANADIAN SYLLABICS FINAL SHORT HORIZONTAL STROKE",
	"CANADIAN SYLLABICS FINAL PLUS",
	"CANADIAN SYLLABICS FINAL DOWN TACK",
	"CANADIAN SYLLABICS EN",
	"CANADIAN SYLLABICS IN",
	"CANADIAN SYLLABICS ON",
	"CANADIAN SYLLABICS AN",
	"CANADIAN SYLLABICS PE",
	"CANADIAN SYLLABICS PAAI",
	"CANADIAN SYLLABICS PI",
	"CANADIAN SYLLABICS PII",
	"CANADIAN SYLLABICS PO",
	"CANADIAN SYLLABICS POO",
	"CANADIAN SYLLABICS Y-CREE POO",
	"CANADIAN SYLLABICS CARRIER HEE",
	"CANADIAN SYLLABICS CARRIER HI",
	"CANADIAN SYLLABICS PA",
	"CANADIAN SYLLABICS PAA",
	"CANADIAN SYLLABICS PWE",
	"CANADIAN SYLLABICS WEST-CREE PWE",
	"CANADIAN SYLLABICS PWI",
	"CANADIAN SYLLABICS WEST-CREE PWI",
	"CANADIAN SYLLABICS PWII",
	"CANADIAN SYLLABICS WEST-CREE PWII",
	"CANADIAN SYLLABICS PWO",
	"CANADIAN SYLLABICS WEST-CREE PWO",
	"CANADIAN SYLLABICS PWOO",
	"CANADIAN SYLLABICS WEST-CREE PWOO",
	"CANADIAN SYLLABICS PWA",
	"CANADIAN SYLLABICS WEST-CREE PWA",
	"CANADIAN SYLLABICS PWAA",
	"CANADIAN SYLLABICS WEST-CREE PWAA",
	"CANADIAN SYLLABICS Y-CREE PWAA",
	"CANADIAN SYLLABICS P",
	"CANADIAN SYLLABICS WEST-CREE P",
	"CANADIAN SYLLABICS CARRIER H",
	"CANADIAN SYLLABICS TE",
	"CANADIAN SYLLABICS TAAI",
	"CANADIAN SYLLABICS TI",
	"CANADIAN SYLLABICS TII",
	"CANADIAN SYLLABICS TO",
	"CANADIAN SYLLABICS TOO",
	"CANADIAN SYLLABICS Y-CREE TOO",
	"CANADIAN SYLLABICS CARRIER DEE",
	"CANADIAN SYLLABICS CARRIER DI",
	"CANADIAN SYLLABICS TA",
	"CANADIAN SYLLABICS TAA",
	"CANADIAN SYLLABICS TWE",
	"CANADIAN SYLLABICS WEST-CREE TWE",
	"CANADIAN SYLLABICS TWI",
	"CANADIAN SYLLABICS WEST-CREE TWI",
	"CANADIAN SYLLABICS TWII",
	"CANADIAN SYLLABICS WEST-CREE TWII",
	"CANADIAN SYLLABICS TWO",
	"CANADIAN SYLLABICS WEST-CREE TWO",
	"CANADIAN SYLLABICS TWOO",
	"CANADIAN SYLLABICS WEST-CREE TWOO",
	"CANADIAN SYLLABICS TWA",
	"CANADIAN SYLLABICS WEST-CREE TWA",
	"CANADIAN SYLLABICS TWAA",
	"CANADIAN SYLLABICS WEST-CREE TWAA",
	"CANADIAN SYLLABICS NASKAPI TWAA",
	"CANADIAN SYLLABICS T",
	"CANADIAN SYLLABICS TTE",
	"CANADIAN SYLLABICS TTI",
	"CANADIAN SYLLABICS TTO",
	"CANADIAN SYLLABICS TTA",
	"CANADIAN SYLLABICS KE",
	"CANADIAN SYLLABICS KAAI",
	"CANADIAN SYLLABICS KI",
	"CANADIAN SYLLABICS KII",
	"CANADIAN SYLLABICS KO",
	"CANADIAN SYLLABICS KOO",
	"CANADIAN SYLLABICS Y-CREE KOO",
	"CANADIAN SYLLABICS KA",
	"CANADIAN SYLLABICS KAA",
	"CANADIAN SYLLABICS KWE",
	"CANADIAN SYLLABICS WEST-CREE KWE",
	"CANADIAN SYLLABICS KWI",
	"CANADIAN SYLLABICS WEST-CREE KWI",
	"CANADIAN SYLLABICS KWII",
	"CANADIAN SYLLABICS WEST-CREE KWII",
	"CANADIAN SYLLABICS KWO",
	"CANADIAN SYLLABICS WEST-CREE KWO",
	"CANADIAN SYLLABICS KWOO",
	"CANADIAN SYLLABICS WEST-CREE KWOO",
	"CANADIAN SYLLABICS KWA",
	"CANADIAN SYLLABICS WEST-CREE KWA",
	"CANADIAN SYLLABICS KWAA",
	"CANADIAN SYLLABICS WEST-CREE KWAA",
	"CANADIAN SYLLABICS NASKAPI KWAA",
	"CANADIAN SYLLABICS K",
	"CANADIAN SYLLABICS KW",
	"CANADIAN SYLLABICS SOUTH-SLAVEY KEH",
	"CANADIAN SYLLABICS SOUTH-SLAVEY KIH",
	"CANADIAN SYLLABICS SOUTH-SLAVEY KOH",
	"CANADIAN SYLLABICS SOUTH-SLAVEY KAH",
	"CANADIAN SYLLABICS CE",
	"CANADIAN SYLLABICS CAAI",
	"CANADIAN SYLLABICS CI",
	"CANADIAN SYLLABICS CII",
	"CANADIAN SYLLABICS CO",
	"CANADIAN SYLLABICS COO",
	"CANADIAN SYLLABICS Y-CREE COO",
	"CANADIAN SYLLABICS CA",
	"CANADIAN SYLLABICS CAA",
	"CANADIAN SYLLABICS CWE",
	"CANADIAN SYLLABICS WEST-CREE CWE",
	"CANADIAN SYLLABICS CWI",
	"CANADIAN SYLLABICS WEST-CREE CWI",
	"CANADIAN SYLLABICS CWII",
	"CANADIAN SYLLABICS WEST-CREE CWII",
	"CANADIAN SYLLABICS CWO",
	"CANADIAN SYLLABICS WEST-CREE CWO",
	"CANADIAN SYLLABICS CWOO",
	"CANADIAN SYLLABICS WEST-CREE CWOO",
	"CANADIAN SYLLABICS CWA",
	"CANADIAN SYLLABICS WEST-CREE CWA",
	"CANADIAN SYLLABICS CWAA",
	"CANADIAN SYLLABICS WEST-CREE CWAA",
	"CANADIAN SYLLABICS NASKAPI CWAA",
	"CANADIAN SYLLABICS C",
	"CANADIAN SYLLABICS SAYISI TH",
	"CANADIAN SYLLABICS ME",
	"CANADIAN SYLLABICS MAAI",
	"CANADIAN SYLLABICS MI",
	"CANADIAN SYLLABICS MII",
	"CANADIAN SYLLABICS MO",
	"CANADIAN SYLLABICS MOO",
	"CANADIAN SYLLABICS Y-CREE MOO",
	"CANADIAN SYLLABICS MA",
	"CANADIAN SYLLABICS MAA",
	"CANADIAN SYLLABICS MWE",
	"CANADIAN SYLLABICS WEST-CREE MWE",
	"CANADIAN SYLLABICS MWI",
	"CANADIAN SYLLABICS WEST-CREE MWI",
	"CANADIAN SYLLABICS MWII",
	"CANADIAN SYLLABICS WEST-CREE MWII",
	"CANADIAN SYLLABICS MWO",
	"CANADIAN SYLLABICS WEST-CREE MWO",
	"CANADIAN SYLLABICS MWOO",
	"CANADIAN SYLLABICS WEST-CREE MWOO",
	"CANADIAN SYLLABICS MWA",
	"CANADIAN SYLLABICS WEST-CREE MWA",
	"CANADIAN SYLLABICS MWAA",
	"CANADIAN SYLLABICS WEST-CREE MWAA",
	"CANADIAN SYLLABICS NASKAPI MWAA",
	"CANADIAN SYLLABICS M",
	"CANADIAN SYLLABICS WEST-CREE M",
	"CANADIAN SYLLABICS MH",
	"CANADIAN SYLLABICS ATHAPASCAN M",
	"CANADIAN SYLLABICS SAYISI M",
	"CANADIAN SYLLABICS NE",
	"CANADIAN SYLLABICS NAAI",
	"CANADIAN SYLLABICS NI",
	"CANADIAN SYLLABICS NII",
	"CANADIAN SYLLABICS NO",
	"CANADIAN SYLLABICS NOO",
	"CANADIAN SYLLABICS Y-CREE NOO",
	"CANADIAN SYLLABICS NA",
	"CANADIAN SYLLABICS NAA",
	"CANADIAN SYLLABICS NWE",
	"CANADIAN SYLLABICS WEST-CREE NWE",
	"CANADIAN SYLLABICS NWA",
	"CANADIAN SYLLABICS WEST-CREE NWA",
	"CANADIAN SYLLABICS NWAA",
	"CANADIAN SYLLABICS WEST-CREE NWAA",
	"CANADIAN SYLLABICS NASKAPI NWAA",
	"CANADIAN SYLLABICS N",
	"CANADIAN SYLLABICS CARRIER NG",
	"CANADIAN SYLLABICS NH",
	"CANADIAN SYLLABICS LE",
	"CANADIAN SYLLABICS LAAI",
	"CANADIAN SYLLABICS LI",
	"CANADIAN SYLLABICS LII",
	"CANADIAN SYLLABICS LO",
	"CANADIAN SYLLABICS LOO",
	"CANADIAN SYLLABICS Y-CREE LOO",
	"CANADIAN SYLLABICS LA",
	"CANADIAN SYLLABICS LAA",
	"CANADIAN SYLLABICS LWE",
	"CANADIAN SYLLABICS WEST-CREE LWE",
	"CANADIAN SYLLABICS LWI",
	"CANADIAN SYLLABICS WEST-CREE LWI",
	"CANADIAN SYLLABICS LWII",
	"CANADIAN SYLLABICS WEST-CREE LWII",
	"CANADIAN SYLLABICS LWO",
	"CANADIAN SYLLABICS WEST-CREE LWO",
	"CANADIAN SYLLABICS LWOO",
	"CANADIAN SYLLABICS WEST-CREE LWOO",
	"CANADIAN SYLLABICS LWA",
	"CANADIAN SYLLABICS WEST-CREE LWA",
	"CANADIAN SYLLABICS LWAA",
	"CANADIAN SYLLABICS WEST-CREE LWAA",
	"CANADIAN SYLLABICS L",
	"CANADIAN SYLLABICS WEST-CREE L",
	"CANADIAN SYLLABICS MEDIAL L",
	"CANADIAN SYLLABICS SE",
	"CANADIAN SYLLABICS SAAI",
	"CANADIAN SYLLABICS SI",
	"CANADIAN SYLLABICS SII",
	"CANADIAN SYLLABICS SO",
	"CANADIAN SYLLABICS SOO",
	"CANADIAN SYLLABICS Y-CREE SOO",
	"CANADIAN SYLLABICS SA",
	"CANADIAN SYLLABICS SAA",
	"CANADIAN SYLLABICS SWE",
	"CANADIAN SYLLABICS WEST-CREE SWE",
	"CANADIAN SYLLABICS SWI",
	"CANADIAN SYLLABICS WEST-CREE SWI",
	"CANADIAN SYLLABICS SWII",
	"CANADIAN SYLLABICS WEST-CREE SWII",
	"CANADIAN SYLLABICS SWO",
	"CANADIAN SYLLABICS WEST-CREE SWO",
	"CANADIAN SYLLABICS SWOO",
	"CANADIAN SYLLABICS WEST-CREE SWOO",
	"CANADIAN SYLLABICS SWA",
	"CANADIAN SYLLABICS WEST-CREE SWA",
	"CANADIAN SYLLABICS SWAA",
	"CANADIAN SYLLABICS WEST-CREE SWAA",
	"CANADIAN SYLLABICS NASKAPI SWAA",
	"CANADIAN SYLLABICS S",
	"CANADIAN SYLLABICS ATHAPASCAN S",
	"CANADIAN SYLLABICS SW",
	"CANADIAN SYLLABICS BLACKFOOT S",
	"CANADIAN SYLLABICS MOOSE-CREE SK",
	"CANADIAN SYLLABICS NASKAPI SKW",
	"CANADIAN SYLLABICS NASKAPI S-W",
	"CANADIAN SYLLABICS NASKAPI SPWA",
	"CANADIAN SYLLABICS NASKAPI STWA",
	"CANADIAN SYLLABICS NASKAPI SKWA",
	"CANADIAN SYLLABICS NASKAPI SCWA",
	"CANADIAN SYLLABICS SHE",
	"CANADIAN SYLLABICS SHI",
	"CANADIAN SYLLABICS SHII",
	"CANADIAN SYLLABICS SHO",
	"CANADIAN SYLLABICS SHOO",
	"CANADIAN SYLLABICS SHA",
	"CANADIAN SYLLABICS SHAA",
	"CANADIAN SYLLABICS SHWE",
	"CANADIAN SYLLABICS WEST-CREE SHWE",
	"CANADIAN SYLLABICS SHWI",
	"CANADIAN SYLLABICS WEST-CREE SHWI",
	"CANADIAN SYLLABICS SHWII",
	"CANADIAN SYLLABICS WEST-CREE SHWII",
	"CANADIAN SYLLABICS SHWO",
	"CANADIAN SYLLABICS WEST-CREE SHWO",
	"CANADIAN SYLLABICS SHWOO",
	"CANADIAN SYLLABICS WEST-CREE SHWOO",
	"CANADIAN SYLLABICS SHWA",
	"CANADIAN SYLLABICS WEST-CREE SHWA",
	"CANADIAN SYLLABICS SHWAA",
	"CANADIAN SYLLABICS WEST-CREE SHWAA",
	"CANADIAN SYLLABICS SH",
	"CANADIAN SYLLABICS YE",
	"CANADIAN SYLLABICS YAAI",
	"CANADIAN SYLLABICS YI",
	"CANADIAN SYLLABICS YII",
	"CANADIAN SYLLABICS YO",
	"CANADIAN SYLLABICS YOO",
	"CANADIAN SYLLABICS Y-CREE YOO",
	"CANADIAN SYLLABICS YA",
	"CANADIAN SYLLABICS YAA",
	"CANADIAN SYLLABICS YWE",
	"CANADIAN SYLLABICS WEST-CREE YWE",
	"CANADIAN SYLLABICS YWI",
	"CANADIAN SYLLABICS WEST-CREE YWI",
	"CANADIAN SYLLABICS YWII",
	"CANADIAN SYLLABICS WEST-CREE YWII",
	"CANADIAN SYLLABICS YWO",
	"CANADIAN SYLLABICS WEST-CREE YWO",
	"CANADIAN SYLLABICS YWOO",
	"CANADIAN SYLLABICS WEST-CREE YWOO",
	"CANADIAN SYLLABICS YWA",
	"CANADIAN SYLLABICS WEST-CREE YWA",
	"CANADIAN SYLLABICS YWAA",
	"CANADIAN SYLLABICS WEST-CREE YWAA",
	"CANADIAN SYLLABICS NASKAPI YWAA",
	"CANADIAN SYLLABICS Y",
	"CANADIAN SYLLABICS BIBLE-CREE Y",
	"CANADIAN SYLLABICS WEST-CREE Y",
	"CANADIAN SYLLABICS SAYISI YI",
	"CANADIAN SYLLABICS RE",
	"CANADIAN SYLLABICS R-CREE RE",
	"CANADIAN SYLLABICS WEST-CREE LE",
	"CANADIAN SYLLABICS RAAI",
	"CANADIAN SYLLABICS RI",
	"CANADIAN SYLLABICS RII",
	"CANADIAN SYLLABICS RO",
	"CANADIAN SYLLABICS ROO",
	"CANADIAN SYLLABICS WEST-CREE LO",
	"CANADIAN SYLLABICS RA",
	"CANADIAN SYLLABICS RAA",
	"CANADIAN SYLLABICS WEST-CREE LA",
	"CANADIAN SYLLABICS RWAA",
	"CANADIAN SYLLABICS WEST-CREE RWAA",
	"CANADIAN SYLLABICS R",
	"CANADIAN SYLLABICS WEST-CREE R",
	"CANADIAN SYLLABICS MEDIAL R",
	"CANADIAN SYLLABICS FE",
	"CANADIAN SYLLABICS FAAI",
	"CANADIAN SYLLABICS FI",
	"CANADIAN SYLLABICS FII",
	"CANADIAN SYLLABICS FO",
	"CANADIAN SYLLABICS FOO",
	"CANADIAN SYLLABICS FA",
	"CANADIAN SYLLABICS FAA",
	"CANADIAN SYLLABICS FWAA",
	"CANADIAN SYLLABICS WEST-CREE FWAA",
	"CANADIAN SYLLABICS F",
	"CANADIAN SYLLABICS THE",
	"CANADIAN SYLLABICS N-CREE THE",
	"CANADIAN SYLLABICS THI",
	"CANADIAN SYLLABICS N-CREE THI",
	"CANADIAN SYLLABICS THII",
	"CANADIAN SYLLABICS N-CREE THII",
	"CANADIAN SYLLABICS THO",
	"CANADIAN SYLLABICS THOO",
	"CANADIAN SYLLABICS THA",
	"CANADIAN SYLLABICS THAA",
	"CANADIAN SYLLABICS THWAA",
	"CANADIAN SYLLABICS WEST-CREE THWAA",
	"CANADIAN SYLLABICS TH",
	"CANADIAN SYLLABICS TTHE",
	"CANADIAN SYLLABICS TTHI",
	"CANADIAN SYLLABICS TTHO",
	"CANADIAN SYLLABICS TTHA",
	"CANADIAN SYLLABICS TTH",
	"CANADIAN SYLLABICS TYE",
	"CANADIAN SYLLABICS TYI",
	"CANADIAN SYLLABICS TYO",
	"CANADIAN SYLLABICS TYA",
	"CANADIAN SYLLABICS NUNAVIK HE",
	"CANADIAN SYLLABICS NUNAVIK HI",
	"CANADIAN SYLLABICS NUNAVIK HII",
	"CANADIAN SYLLABICS NUNAVIK HO",
	"CANADIAN SYLLABICS NUNAVIK HOO",
	"CANADIAN SYLLABICS NUNAVIK HA",
	"CANADIAN SYLLABICS NUNAVIK HAA",
	"CANADIAN SYLLABICS NUNAVIK H",
	"CANADIAN SYLLABICS NUNAVUT H",
	"CANADIAN SYLLABICS HK",
	"CANADIAN SYLLABICS QAAI",
	"CANADIAN SYLLABICS QI",
	"CANADIAN SYLLABICS QII",
	"CANADIAN SYLLABICS QO",
	"CANADIAN SYLLABICS QOO",
	"CANADIAN SYLLABICS QA",
	"CANADIAN SYLLABICS QAA",
	"CANADIAN SYLLABICS Q",
	"CANADIAN SYLLABICS TLHE",
	"CANADIAN SYLLABICS TLHI",
	"CANADIAN SYLLABICS TLHO",
	"CANADIAN SYLLABICS TLHA",
	"CANADIAN SYLLABICS WEST-CREE RE",
	"CANADIAN SYLLABICS WEST-CREE RI",
	"CANADIAN SYLLABICS WEST-CREE RO",
	"CANADIAN SYLLABICS WEST-CREE RA",
	"CANADIAN SYLLABICS NGAAI",
	"CANADIAN SYLLABICS NGI",
	"CANADIAN SYLLABICS NGII",
	"CANADIAN SYLLABICS NGO",
	"CANADIAN SYLLABICS NGOO",
	"CANADIAN SYLLABICS NGA",
	"CANADIAN SYLLABICS NGAA",
	"CANADIAN SYLLABICS NG",
	"CANADIAN SYLLABICS NNG",
	"CANADIAN SYLLABICS SAYISI SHE",
	"CANADIAN SYLLABICS SAYISI SHI",
	"CANADIAN SYLLABICS SAYISI SHO",
	"CANADIAN SYLLABICS SAYISI SHA",
	"CANADIAN SYLLABICS WOODS-CREE THE",
	"CANADIAN SYLLABICS WOODS-CREE THI",
	"CANADIAN SYLLABICS WOODS-CREE THO",
	"CANADIAN SYLLABICS WOODS-CREE THA",
	"CANADIAN SYLLABICS WOODS-CREE TH",
	"CANADIAN SYLLABICS LHI",
	"CANADIAN SYLLABICS LHII",
	"CANADIAN SYLLABICS LHO",
	"CANADIAN SYLLABICS LHOO",
	"CANADIAN SYLLABICS LHA",
	"CANADIAN SYLLABICS LHAA",
	"CANADIAN SYLLABICS LH",
	"CANADIAN SYLLABICS TH-CREE THE",
	"CANADIAN SYLLABICS TH-CREE THI",
	"CANADIAN SYLLABICS TH-CREE THII",
	"CANADIAN SYLLABICS TH-CREE THO",
	"CANADIAN SYLLABICS TH-CREE THOO",
	"CANADIAN SYLLABICS TH-CREE THA",
	"CANADIAN SYLLABICS TH-CREE THAA",
	"CANADIAN SYLLABICS TH-CREE TH",
	"CANADIAN SYLLABICS AIVILIK B",
	"CANADIAN SYLLABICS BLACKFOOT E",
	"CANADIAN SYLLABICS BLACKFOOT I",
	"CANADIAN SYLLABICS BLACKFOOT O",
	"CANADIAN SYLLABICS BLACKFOOT A",
	"CANADIAN SYLLABICS BLACKFOOT WE",
	"CANADIAN SYLLABICS BLACKFOOT WI",
	"CANADIAN SYLLABICS BLACKFOOT WO",
	"CANADIAN SYLLABICS BLACKFOOT WA",
	"CANADIAN SYLLABICS BLACKFOOT NE",
	"CANADIAN SYLLABICS BLACKFOOT NI",
	"CANADIAN SYLLABICS BLACKFOOT NO",
	"CANADIAN SYLLABICS BLACKFOOT NA",
	"CANADIAN SYLLABICS BLACKFOOT KE",
	"CANADIAN SYLLABICS BLACKFOOT KI",
	"CANADIAN SYLLABICS BLACKFOOT KO",
	"CANADIAN SYLLABICS BLACKFOOT KA",
	"CANADIAN SYLLABICS SAYISI HE",
	"CANADIAN SYLLABICS SAYISI HI",
	"CANADIAN SYLLABICS SAYISI HO",
	"CANADIAN SYLLABICS SAYISI HA",
	"CANADIAN SYLLABICS CARRIER GHU",
	"CANADIAN SYLLABICS CARRIER GHO",
	"CANADIAN SYLLABICS CARRIER GHE",
	"CANADIAN SYLLABICS CARRIER GHEE",
	"CANADIAN SYLLABICS CARRIER GHI",
	"CANADIAN SYLLABICS CARRIER GHA",
	"CANADIAN SYLLABICS CARRIER RU",
	"CANADIAN SYLLABICS CARRIER RO",
	"CANADIAN SYLLABICS CARRIER RE",
	"CANADIAN SYLLABICS CARRIER REE",
	"CANADIAN SYLLABICS CARRIER RI",
	"CANADIAN SYLLABICS CARRIER RA",
	"CANADIAN SYLLABICS CARRIER WU",
	"CANADIAN SYLLABICS CARRIER WO",
	"CANADIAN SYLLABICS CARRIER WE",
	"CANADIAN SYLLABICS CARRIER WEE",
	"CANADIAN SYLLABICS CARRIER WI",
	"CANADIAN SYLLABICS CARRIER WA",
	"CANADIAN SYLLABICS CARRIER HWU",
	"CANADIAN SYLLABICS CARRIER HWO",
	"CANADIAN SYLLABICS CARRIER HWE",
	"CANADIAN SYLLABICS CARRIER HWEE",
	"CANADIAN SYLLABICS CARRIER HWI",
	"CANADIAN SYLLABICS CARRIER HWA",
	"CANADIAN SYLLABICS CARRIER THU",
	"CANADIAN SYLLABICS CARRIER THO",
	"CANADIAN SYLLABICS CARRIER THE",
	"CANADIAN SYLLABICS CARRIER THEE",
	"CANADIAN SYLLABICS CARRIER THI",
	"CANADIAN SYLLABICS CARRIER THA",
	"CANADIAN SYLLABICS CARRIER TTU",
	"CANADIAN SYLLABICS CARRIER TTO",
	"CANADIAN SYLLABICS CARRIER TTE",
	"CANADIAN SYLLABICS CARRIER TTEE",
	"CANADIAN SYLLABICS CARRIER TTI",
	"CANADIAN SYLLABICS CARRIER TTA",
	"CANADIAN SYLLABICS CARRIER PU",
	"CANADIAN SYLLABICS CARRIER PO",
	"CANADIAN SYLLABICS CARRIER PE",
	"CANADIAN SYLLABICS CARRIER PEE",
	"CANADIAN SYLLABICS CARRIER PI",
	"CANADIAN SYLLABICS CARRIER PA",
	"CANADIAN SYLLABICS CARRIER P",
	"CANADIAN SYLLABICS CARRIER GU",
	"CANADIAN SYLLABICS CARRIER GO",
	"CANADIAN SYLLABICS CARRIER GE",
	"CANADIAN SYLLABICS CARRIER GEE",
	"CANADIAN SYLLABICS CARRIER GI",
	"CANADIAN SYLLABICS CARRIER GA",
	"CANADIAN SYLLABICS CARRIER KHU",
	"CANADIAN SYLLABICS CARRIER KHO",
	"CANADIAN SYLLABICS CARRIER KHE",
	"CANADIAN SYLLABICS CARRIER KHEE",
	"CANADIAN SYLLABICS CARRIER KHI",
	"CANADIAN SYLLABICS CARRIER KHA",
	"CANADIAN SYLLABICS CARRIER KKU",
	"CANADIAN SYLLABICS CARRIER KKO",
	"CANADIAN SYLLABICS CARRIER KKE",
	"CANADIAN SYLLABICS CARRIER KKEE",
	"CANADIAN SYLLABICS CARRIER KKI",
	"CANADIAN SYLLABICS CARRIER KKA",
	"CANADIAN SYLLABICS CARRIER KK",
	"CANADIAN SYLLABICS CARRIER NU",
	"CANADIAN SYLLABICS CARRIER NO",
	"CANADIAN SYLLABICS CARRIER NE",
	"CANADIAN SYLLABICS CARRIER NEE",
	"CANADIAN SYLLABICS CARRIER NI",
	"CANADIAN SYLLABICS CARRIER NA",
	"CANADIAN SYLLABICS CARRIER MU",
	"CANADIAN SYLLABICS CARRIER MO",
	"CANADIAN SYLLABICS CARRIER ME",
	"CANADIAN SYLLABICS CARRIER MEE",
	"CANADIAN SYLLABICS CARRIER MI",
	"CANADIAN SYLLABICS CARRIER MA",
	"CANADIAN SYLLABICS CARRIER YU",
	"CANADIAN SYLLABICS CARRIER YO",
	"CANADIAN SYLLABICS CARRIER YE",
	"CANADIAN SYLLABICS CARRIER YEE",
	"CANADIAN SYLLABICS CARRIER YI",
	"CANADIAN SYLLABICS CARRIER YA",
	"CANADIAN SYLLABICS CARRIER JU",
	"CANADIAN SYLLABICS SAYISI JU",
	"CANADIAN SYLLABICS CARRIER JO",
	"CANADIAN SYLLABICS CARRIER JE",
	"CANADIAN SYLLABICS CARRIER JEE",
	"CANADIAN SYLLABICS CARRIER JI",
	"CANADIAN SYLLABICS SAYISI JI",
	"CANADIAN SYLLABICS CARRIER JA",
	"CANADIAN SYLLABICS CARRIER JJU",
	"CANADIAN SYLLABICS CARRIER JJO",
	"CANADIAN SYLLABICS CARRIER JJE",
	"CANADIAN SYLLABICS CARRIER JJEE",
	"CANADIAN SYLLABICS CARRIER JJI",
	"CANADIAN SYLLABICS CARRIER JJA",
	"CANADIAN SYLLABICS CARRIER LU",
	"CANADIAN SYLLABICS CARRIER LO",
	"CANADIAN SYLLABICS CARRIER LE",
	"CANADIAN SYLLABICS CARRIER LEE",
	"CANADIAN SYLLABICS CARRIER LI",
	"CANADIAN SYLLABICS CARRIER LA",
	"CANADIAN SYLLABICS CARRIER DLU",
	"CANADIAN SYLLABICS CARRIER DLO",
	"CANADIAN SYLLABICS CARRIER DLE",
	"CANADIAN SYLLABICS CARRIER DLEE",
	"CANADIAN SYLLABICS CARRIER DLI",
	"CANADIAN SYLLABICS CARRIER DLA",
	"CANADIAN SYLLABICS CARRIER LHU",
	"CANADIAN SYLLABICS CARRIER LHO",
	"CANADIAN SYLLABICS CARRIER LHE",
	"CANADIAN SYLLABICS CARRIER LHEE",
	"CANADIAN SYLLABICS CARRIER LHI",
	"CANADIAN SYLLABICS CARRIER LHA",
	"CANADIAN SYLLABICS CARRIER TLHU",
	"CANADIAN SYLLABICS CARRIER TLHO",
	"CANADIAN SYLLABICS CARRIER TLHE",
	"CANADIAN SYLLABICS CARRIER TLHEE",
	"CANADIAN SYLLABICS CARRIER TLHI",
	"CANADIAN SYLLABICS CARRIER TLHA",
	"CANADIAN SYLLABICS CARRIER TLU",
	"CANADIAN SYLLABICS CARRIER TLO",
	"CANADIAN SYLLABICS CARRIER TLE",
	"CANADIAN SYLLABICS CARRIER TLEE",
	"CANADIAN SYLLABICS CARRIER TLI",
	"CANADIAN SYLLABICS CARRIER TLA",
	"CANADIAN SYLLABICS CARRIER ZU",
	"CANADIAN SYLLABICS CARRIER ZO",
	"CANADIAN SYLLABICS CARRIER ZE",
	"CANADIAN SYLLABICS CARRIER ZEE",
	"CANADIAN SYLLABICS CARRIER ZI",
	"CANADIAN SYLLABICS CARRIER ZA",
	"CANADIAN SYLLABICS CARRIER Z",
	"CANADIAN SYLLABICS CARRIER INITIAL Z",
	"CANADIAN SYLLABICS CARRIER DZU",
	"CANADIAN SYLLABICS CARRIER DZO",
	"CANADIAN SYLLABICS CARRIER DZE",
	"CANADIAN SYLLABICS CARRIER DZEE",
	"CANADIAN SYLLABICS CARRIER DZI",
	"CANADIAN SYLLABICS CARRIER DZA",
	"CANADIAN SYLLABICS CARRIER SU",
	"CANADIAN SYLLABICS CARRIER SO",
	"CANADIAN SYLLABICS CARRIER SE",
	"CANADIAN SYLLABICS CARRIER SEE",
	"CANADIAN SYLLABICS CARRIER SI",
	"CANADIAN SYLLABICS CARRIER SA",
	"CANADIAN SYLLABICS CARRIER SHU",
	"CANADIAN SYLLABICS CARRIER SHO",
	"CANADIAN SYLLABICS CARRIER SHE",
	"CANADIAN SYLLABICS CARRIER SHEE",
	"CANADIAN SYLLABICS CARRIER SHI",
	"CANADIAN SYLLABICS CARRIER SHA",
	"CANADIAN SYLLABICS CARRIER SH",
	"CANADIAN SYLLABICS CARRIER TSU",
	"CANADIAN SYLLABICS CARRIER TSO",
	"CANADIAN SYLLABICS CARRIER TSE",
	"CANADIAN SYLLABICS CARRIER TSEE",
	"CANADIAN SYLLABICS CARRIER TSI",
	"CANADIAN SYLLABICS CARRIER TSA",
	"CANADIAN SYLLABICS CARRIER CHU",
	"CANADIAN SYLLABICS CARRIER CHO",
	"CANADIAN SYLLABICS CARRIER CHE",
	"CANADIAN SYLLABICS CARRIER CHEE",
	"CANADIAN SYLLABICS CARRIER CHI",
	"CANADIAN SYLLABICS CARRIER CHA",
	"CANADIAN SYLLABICS CARRIER TTSU",
	"CANADIAN SYLLABICS CARRIER TTSO",
	"CANADIAN SYLLABICS CARRIER TTSE",
	"CANADIAN SYLLABICS CARRIER TTSEE",
	"CANADIAN SYLLABICS CARRIER TTSI",
	"CANADIAN SYLLABICS CARRIER TTSA",
	"CANADIAN SYLLABICS CHI SIGN",
	"CANADIAN SYLLABICS FULL STOP",
	"CANADIAN SYLLABICS QAI",
	"CANADIAN SYLLABICS NGAI",
	"CANADIAN SYLLABICS NNGI",
	"CANADIAN SYLLABICS NNGII",
	"CANADIAN SYLLABICS NNGO",
	"CANADIAN SYLLABICS NNGOO",
	"CANADIAN SYLLABICS NNGA",
	"CANADIAN SYLLABICS NNGAA",
	"CANADIAN SYLLABICS WOODS-CREE THWEE",
	"CANADIAN SYLLABICS WOODS-CREE THWI",
	"CANADIAN SYLLABICS WOODS-CREE THWII",
	"CANADIAN SYLLABICS WOODS-CREE THWO",
	"CANADIAN SYLLABICS WOODS-CREE THWOO",
	"CANADIAN SYLLABICS WOODS-CREE THWA",
	"CANADIAN SYLLABICS WOODS-CREE THWAA",
	"CANADIAN SYLLABICS WOODS-CREE FINAL TH",
	"CANADIAN SYLLABICS BLACKFOOT W",
	"OGHAM SPACE MARK",
	"OGHAM LETTER BEITH",
	"OGHAM LETTER LUIS",
	"OGHAM LETTER FEARN",
	"OGHAM LETTER SAIL",
	"OGHAM LETTER NION",
	"OGHAM LETTER UATH",
	"OGHAM LETTER DAIR",
	"OGHAM LETTER TINNE",
	"OGHAM LETTER COLL",
	"OGHAM LETTER CEIRT",
	"OGHAM LETTER MUIN",
	"OGHAM LETTER GORT",
	"OGHAM LETTER NGEADAL",
	"OGHAM LETTER STRAIF",
	"OGHAM LETTER RUIS",
	"OGHAM LETTER AILM",
	"OGHAM LETTER ONN",
	"OGHAM LETTER UR",
	"OGHAM LETTER EADHADH",
	"OGHAM LETTER IODHADH",
	"OGHAM LETTER EABHADH",
	"OGHAM LETTER OR",
	"OGHAM LETTER UILLEANN",
	"OGHAM LETTER IFIN",
	"OGHAM LETTER EAMHANCHOLL",
	"OGHAM LETTER PEITH",
	"OGHAM FEATHER MARK",
	"OGHAM REVERSED FEATHER MARK",
	"RUNIC LETTER FEHU FEOH FE F",
	"RUNIC LETTER V",
	"RUNIC LETTER URUZ UR U",
	"RUNIC LETTER YR",
	"RUNIC LETTER Y",
	"RUNIC LETTER W",
	"RUNIC LETTER THURISAZ THURS THORN",
	"RUNIC LETTER ETH",
	"RUNIC LETTER ANSUZ A",
	"RUNIC LETTER OS O",
	"RUNIC LETTER AC A",
	"RUNIC LETTER AESC",
	"RUNIC LETTER LONG-BRANCH-OSS O",
	"RUNIC LETTER SHORT-TWIG-OSS O",
	"RUNIC LETTER O",
	"RUNIC LETTER OE",
	"RUNIC LETTER ON",
	"RUNIC LETTER RAIDO RAD REID R",
	"RUNIC LETTER KAUNA",
	"RUNIC LETTER CEN",
	"RUNIC LETTER KAUN K",
	"RUNIC LETTER G",
	"RUNIC LETTER ENG",
	"RUNIC LETTER GEBO GYFU G",
	"RUNIC LETTER GAR",
	"RUNIC LETTER WUNJO WYNN W",
	"RUNIC LETTER HAGLAZ H",
	"RUNIC LETTER HAEGL H",
	"RUNIC LETTER LONG-BRANCH-HAGALL H",
	"RUNIC LETTER SHORT-TWIG-HAGALL H",
	"RUNIC LETTER NAUDIZ NYD NAUD N",
	"RUNIC LETTER SHORT-TWIG-NAUD N",
	"RUNIC LETTER DOTTED-N",
	"RUNIC LETTER ISAZ IS ISS I",
	"RUNIC LETTER E",
	"RUNIC LETTER JERAN J",
	"RUNIC LETTER GER",
	"RUNIC LETTER LONG-BRANCH-AR AE",
	"RUNIC LETTER SHORT-TWIG-AR A",
	"RUNIC LETTER IWAZ EOH",
	"RUNIC LETTER PERTHO PEORTH P",
	"RUNIC LETTER ALGIZ EOLHX",
	"RUNIC LETTER SOWILO S",
	"RUNIC LETTER SIGEL LONG-BRANCH-SOL S",
	"RUNIC LETTER SHORT-TWIG-SOL S",
	"RUNIC LETTER C",
	"RUNIC LETTER Z",
	"RUNIC LETTER TIWAZ TIR TYR T",
	"RUNIC LETTER SHORT-TWIG-TYR T",
	"RUNIC LETTER D",
	"RUNIC LETTER BERKANAN BEORC BJARKAN B",
	"RUNIC LETTER SHORT-TWIG-BJARKAN B",
	"RUNIC LETTER DOTTED-P",
	"RUNIC LETTER OPEN-P",
	"RUNIC LETTER EHWAZ EH E",
	"RUNIC LETTER MANNAZ MAN M",
	"RUNIC LETTER LONG-BRANCH-MADR M",
	"RUNIC LETTER SHORT-TWIG-MADR M",
	"RUNIC LETTER LAUKAZ LAGU LOGR L",
	"RUNIC LETTER DOTTED-L",
	"RUNIC LETTER INGWAZ",
	"RUNIC LETTER ING",
	"RUNIC LETTER DAGAZ DAEG D",
	"RUNIC LETTER OTHALAN ETHEL O",
	"RUNIC LETTER EAR",
	"RUNIC LETTER IOR",
	"RUNIC LETTER CWEORTH",
	"RUNIC LETTER CALC",
	"RUNIC LETTER CEALC",
	"RUNIC LETTER STAN",
	"RUNIC LETTER LONG-BRANCH-YR",
	"RUNIC LETTER SHORT-TWIG-YR",
	"RUNIC LETTER ICELANDIC-YR",
	"RUNIC LETTER Q",
	"RUNIC LETTER X",
	"RUNIC SINGLE PUNCTUATION",
	"RUNIC MULTIPLE PUNCTUATION",
	"RUNIC CROSS PUNCTUATION",
	"RUNIC ARLAUG SYMBOL",
	"RUNIC TVIMADUR SYMBOL",
	"RUNIC BELGTHOR SYMBOL",
	"RUNIC LETTER K",
	"RUNIC LETTER SH",
	"RUNIC LETTER OO",
	"RUNIC LETTER FRANKS CASKET OS",
	"RUNIC LETTER FRANKS CASKET IS",
	"RUNIC LETTER FRANKS CASKET EH",
	"RUNIC LETTER FRANKS CASKET AC",
	"RUNIC LETTER FRANKS CASKET AESC",
	"TAGALOG LETTER A",
	"TAGALOG LETTER I",
	"TAGALOG LETTER U",
	"TAGALOG LETTER KA",
	"TAGALOG LETTER GA",
	"TAGALOG LETTER NGA",
	"TAGALOG LETTER TA",
	"TAGALOG LETTER DA",
	"TAGALOG LETTER NA",
	"TAGALOG LETTER PA",
	"TAGALOG LETTER BA",
	"TAGALOG LETTER MA",
	"TAGALOG LETTER YA",
	"TAGALOG LETTER RA",
	"TAGALOG LETTER LA",
	"TAGALOG LETTER WA",
	"TAGALOG LETTER SA",
	"TAGALOG LETTER HA",
	"TAGALOG VOWEL SIGN I",
	"TAGALOG VOWEL SIGN U",
	"TAGALOG SIGN VIRAMA",
	"TAGALOG SIGN PAMUDPOD",
	"TAGALOG LETTER ARCHAIC RA",
	"HANUNOO LETTER A",
	"HANUNOO LETTER I",
	"HANUNOO LETTER U",
	"HANUNOO LETTER KA",
	"HANUNOO LETTER GA",
	"HANUNOO LETTER NGA",
	"HANUNOO LETTER TA",
	"HANUNOO LETTER DA",
	"HANUNOO LETTER NA",
	"HANUNOO LETTER PA",
	"HANUNOO LETTER BA",
	"HANUNOO LETTER MA",
	"HANUNOO LETTER YA",
	"HANUNOO LETTER RA",
	"HANUNOO LETTER LA",
	"HANUNOO LETTER WA",
	"HANUNOO LETTER SA",
	"HANUNOO LETTER HA",
	"HANUNOO VOWEL SIGN I",
	"HANUNOO VOWEL SIGN U",
	"HANUNOO SIGN PAMUDPOD",
	"PHILIPPINE SINGLE PUNCTUATION",
	"PHILIPPINE DOUBLE PUNCTUATION",
	"BUHID LETTER A",
	"BUHID LETTER I",
	"BUHID LETTER U",
	"BUHID LETTER KA",
	"BUHID LETTER GA",
	"BUHID LETTER NGA",
	"BUHID LETTER TA",
	"BUHID LETTER DA",
	"BUHID LETTER NA",
	"BUHID LETTER PA",
	"BUHID LETTER BA",
	"BUHID LETTER MA",
	"BUHID LETTER YA",
	"BUHID LETTER RA",
	"BUHID LETTER LA",
	"BUHID LETTER WA",
	"BUHID LETTER SA",
	"BUHID LETTER HA",
	"BUHID VOWEL SIGN I",
	"BUHID VOWEL SIGN U",
	"TAGBANWA LETTER A",
	"TAGBANWA LETTER I",
	"TAGBANWA LETTER U",
	"TAGBANWA LETTER KA",
	"TAGBANWA LETTER GA",
	"TAGBANWA LETTER NGA",
	"TAGBANWA LETTER TA",
	"TAGBANWA LETTER DA",
	"TAGBANWA LETTER NA",
	"TAGBANWA LETTER PA",
	"TAGBANWA LETTER BA",
	"TAGBANWA LETTER MA",
	"TAGBANWA LETTER YA",
	"TAGBANWA LETTER LA",
	"TAGBANWA LETTER WA",
	"TAGBANWA LETTER SA",
	"TAGBANWA VOWEL SIGN I",
	"TAGBANWA VOWEL SIGN U",
	"KHMER LETTER KA",
	"KHMER LETTER KHA",
	"KHMER LETTER KO",
	"KHMER LETTER KHO",
	"KHMER LETTER NGO",
	"KHMER LETTER CA",
	"KHMER LETTER CHA",
	"KHMER LETTER CO",
	"KHMER LETTER CHO",
	"KHMER LETTER NYO",
	"KHMER LETTER DA",
	"KHMER LETTER TTHA",
	"KHMER LETTER DO",
	"KHMER LETTER TTHO",
	"KHMER LETTER NNO",
	"KHMER LETTER TA",
	"KHMER LETTER THA",
	"KHMER LETTER TO",
	"KHMER LETTER THO",
	"KHMER LETTER NO",
	"KHMER LETTER BA",
	"KHMER LETTER PHA",
	"KHMER LETTER PO",
	"KHMER LETTER PHO",
	"KHMER LETTER MO",
	"KHMER LETTER YO",
	"KHMER LETTER RO",
	"KHMER LETTER LO",
	"KHMER LETTER VO",
	"KHMER LETTER SHA",
	"KHMER LETTER SSO",
	"KHMER LETTER SA",
	"KHMER LETTER HA",
	"KHMER LETTER LA",
	"KHMER LETTER QA",
	"KHMER INDEPENDENT VOWEL QAQ",
	"KHMER INDEPENDENT VOWEL QAA",
	"KHMER INDEPENDENT VOWEL QI",
	"KHMER INDEPENDENT VOWEL QII",
	"KHMER INDEPENDENT VOWEL QU",
	"KHMER INDEPENDENT VOWEL QUK",
	"KHMER INDEPENDENT VOWEL QUU",
	"KHMER INDEPENDENT VOWEL QUUV",
	"KHMER INDEPENDENT VOWEL RY",
	"KHMER INDEPENDENT VOWEL RYY",
	"KHMER INDEPENDENT VOWEL LY",
	"KHMER INDEPENDENT VOWEL LYY",
	"KHMER INDEPENDENT VOWEL QE",
	"KHMER INDEPENDENT VOWEL QAI",
	"KHMER INDEPENDENT VOWEL QOO TYPE ONE",
	"KHMER INDEPENDENT VOWEL QOO TYPE TWO",
	"KHMER INDEPENDENT VOWEL QAU",
	"KHMER VOWEL INHERENT AQ",
	"KHMER VOWEL INHERENT AA",
	"KHMER VOWEL SIGN AA",
	"KHMER VOWEL SIGN I",
	"KHMER VOWEL SIGN II",
	"KHMER VOWEL SIGN Y",
	"KHMER VOWEL SIGN YY",
	"KHMER VOWEL SIGN U",
	"KHMER VOWEL SIGN UU",
	"KHMER VOWEL SIGN UA",
	"KHMER VOWEL SIGN OE",
	"KHMER VOWEL SIGN YA",
	"KHMER VOWEL SIGN IE",
	"KHMER VOWEL SIGN E",
	"KHMER VOWEL SIGN AE",
	"KHMER VOWEL SIGN AI",
	"KHMER VOWEL SIGN OO",
	"KHMER VOWEL SIGN AU",
	"KHMER SIGN NIKAHIT",
	"KHMER SIGN REAHMUK",
	"KHMER SIGN YUUKALEAPINTU",
	"KHMER SIGN MUUSIKATOAN",
	"KHMER SIGN TRIISAP",
	"KHMER SIGN BANTOC",
	"KHMER SIGN ROBAT",
	"KHMER SIGN TOANDAKHIAT",
	"KHMER SIGN KAKABAT",
	"KHMER SIGN AHSDA",
	"KHMER SIGN SAMYOK SANNYA",
	"KHMER SIGN VIRIAM",
	"KHMER SIGN COENG",
	"KHMER SIGN BATHAMASAT",
	"KHMER SIGN KHAN",
	"KHMER SIGN BARIYOOSAN",
	"KHMER SIGN CAMNUC PII KUUH",
	"KHMER SIGN LEK TOO",
	"KHMER SIGN BEYYAL",
	"KHMER SIGN PHNAEK MUAN",
	"KHMER SIGN KOOMUUT",
	"KHMER CURRENCY SYMBOL RIEL",
	"KHMER SIGN AVAKRAHASANYA",
	"KHMER SIGN ATTHACAN",
	"KHMER DIGIT ZERO",
	"KHMER DIGIT ONE",
	"KHMER DIGIT TWO",
	"KHMER DIGIT THREE",
	"KHMER DIGIT FOUR",
	"KHMER DIGIT FIVE",
	"KHMER DIGIT SIX",
	"KHMER DIGIT SEVEN",
	"KHMER DIGIT EIGHT",
	"KHMER DIGIT NINE",
	"KHMER SYMBOL LEK ATTAK SON",
	"KHMER SYMBOL LEK ATTAK MUOY",
	"KHMER SYMBOL LEK ATTAK PII",
	"KHMER SYMBOL LEK ATTAK BEI",
	"KHMER SYMBOL LEK ATTAK BUON",
	"KHMER SYMBOL LEK ATTAK PRAM",
	"KHMER SYMBOL LEK ATTAK PRAM-MUOY",
	"KHMER SYMBOL LEK ATTAK PRAM-PII",
	"KHMER SYMBOL LEK ATTAK PRAM-BEI",
	"KHMER SYMBOL LEK ATTAK PRAM-BUON",
	"MONGOLIAN BIRGA",
	"MONGOLIAN ELLIPSIS",
	"MONGOLIAN COMMA",
	"MONGOLIAN FULL STOP",
	"MONGOLIAN COLON",
	"MONGOLIAN FOUR DOTS",
	"MONGOLIAN TODO SOFT HYPHEN",
	"MONGOLIAN SIBE SYLLABLE BOUNDARY MARKER",
	"MONGOLIAN MANCHU COMMA",
	"MONGOLIAN MANCHU FULL STOP",
	"MONGOLIAN NIRUGU",
	"MONGOLIAN FREE VARIATION SELECTOR ONE",
	"MONGOLIAN FREE VARIATION SELECTOR TWO",
	"MONGOLIAN FREE VARIATION SELECTOR THREE",
	"MONGOLIAN VOWEL SEPARATOR",
	"MONGOLIAN FREE VARIATION SELECTOR FOUR",
	"MONGOLIAN DIGIT ZERO",
	"MONGOLIAN DIGIT ONE",
	"MONGOLIAN DIGIT TWO",
	"MONGOLIAN DIGIT THREE",
	"MONGOLIAN DIGIT FOUR",
	"MONGOLIAN DIGIT FIVE",
	"MONGOLIAN DIGIT SIX",
	"MONGOLIAN DIGIT SEVEN",
	"MONGOLIAN DIGIT EIGHT",
	"MONGOLIAN DIGIT NINE",
	"MONGOLIAN LETTER A",
	"MONGOLIAN LETTER E",
	"MONGOLIAN LETTER I",
	"MONGOLIAN LETTER O",
	"MONGOLIAN LETTER U",
	"MONGOLIAN LETTER OE",
	"MONGOLIAN LETTER UE",
	"MONGOLIAN LETTER EE",
	"MONGOLIAN LETTER NA",
	"MONGOLIAN LETTER ANG",
	"MONGOLIAN LETTER BA",
	"MONGOLIAN LETTER PA",
	"MONGOLIAN LETTER QA",
	"MONGOLIAN LETTER GA",
	"MONGOLIAN LETTER MA",
	"MONGOLIAN LETTER LA",
	"MONGOLIAN LETTER SA",
	"MONGOLIAN LETTER SHA",
	"MONGOLIAN LETTER TA",
	"MONGOLIAN LETTER DA",
	"MONGOLIAN LETTER CHA",
	"MONGOLIAN LETTER JA",
	"MONGOLIAN LETTER YA",
	"MONGOLIAN LETTER RA",
	"MONGOLIAN LETTER WA",
	"MONGOLIAN LETTER FA",
	"MONGOLIAN LETTER KA",
	"MONGOLIAN LETTER KHA",
	"MONGOLIAN LETTER TSA",
	"MONGOLIAN LETTER ZA",
	"MONGOLIAN LETTER HAA",
	"MONGOLIAN LETTER ZRA",
	"MONGOLIAN LETTER LHA",
	"MONGOLIAN LETTER ZHI",
	"MONGOLIAN LETTER CHI",
	"MONGOLIAN LETTER TODO LONG VOWEL SIGN",
	"MONGOLIAN LETTER TODO E",
	"MONGOLIAN LETTER TODO I",
	"MONGOLIAN LETTER TODO O",
	"MONGOLIAN LETTER TODO U",
	"MONGOLIAN LETTER TODO OE",
	"MONGOLIAN LETTER TODO UE",
	"MONGOLIAN LETTER TODO ANG",
	"MONGOLIAN LETTER TODO BA",
	"MONGOLIAN LETTER TODO PA",
	"MONGOLIAN LETTER TODO QA",
	"MONGOLIAN LETTER TODO GA",
	"MONGOLIAN LETTER TODO MA",
	"MONGOLIAN LETTER TODO TA",
	"MONGOLIAN LETTER TODO DA",
	"MONGOLIAN LETTER TODO CHA",
	"MONGOLIAN LETTER TODO JA",
	"MONGOLIAN LETTER TODO TSA",
	"MONGOLIAN LETTER TODO YA",
	"MONGOLIAN LETTER TODO WA",
	"MONGOLIAN LETTER TODO KA",
	"MONGOLIAN LETTER TODO GAA",
	"MONGOLIAN LETTER TODO HAA",
	"MONGOLIAN LETTER TODO JIA",
	"MONGOLIAN LETTER TODO NIA",
	"MONGOLIAN LETTER TODO DZA",
	"MONGOLIAN LETTER SIBE E",
	"MONGOLIAN LETTER SIBE I",
	"MONGOLIAN LETTER SIBE IY",
	"MONGOLIAN LETTER SIBE UE",
	"MONGOLIAN LETTER SIBE U",
	"MONGOLIAN LETTER SIBE ANG",
	"MONGOLIAN LETTER SIBE KA",
	"MONGOLIAN LETTER SIBE GA",
	"MONGOLIAN LETTER SIBE HA",
	"MONGOLIAN LETTER SIBE PA",
	"MONGOLIAN LETTER SIBE SHA",
	"MONGOLIAN LETTER SIBE TA",
	"MONGOLIAN LETTER SIBE DA",
	"MONGOLIAN LETTER SIBE JA",
	"MONGOLIAN LETTER SIBE FA",
	"MONGOLIAN LETTER SIBE GAA",
	"MONGOLIAN LETTER SIBE HAA",
	"MONGOLIAN LETTER SIBE TSA",
	"MONGOLIAN LETTER SIBE ZA",
	"MONGOLIAN LETTER SIBE RAA",
	"MONGOLIAN LETTER SIBE CHA",
	"MONGOLIAN LETTER SIBE ZHA",
	"MONGOLIAN LETTER MANCHU I",
	"MONGOLIAN LETTER MANCHU KA",
	"MONGOLIAN LETTER MANCHU RA",
	"MONGOLIAN LETTER MANCHU FA",
	"MONGOLIAN LETTER MANCHU ZHA",
	"MONGOLIAN LETTER CHA WITH TWO DOTS",
	"MONGOLIAN LETTER ALI GALI ANUSVARA ONE",
	"MONGOLIAN LETTER ALI GALI VISARGA ONE",
	"MONGOLIAN LETTER ALI GALI DAMARU",
	"MONGOLIAN LETTER ALI GALI UBADAMA",
	"MONGOLIAN LETTER ALI GALI INVERTED UBADAMA",
	"MONGOLIAN LETTER ALI GALI BALUDA",
	"MONGOLIAN LETTER ALI GALI THREE BALUDA",
	"MONGOLIAN LETTER ALI GALI A",
	"MONGOLIAN LETTER ALI GALI I",
	"MONGOLIAN LETTER ALI GALI KA",
	"MONGOLIAN LETTER ALI GALI NGA",
	"MONGOLIAN LETTER ALI GALI CA",
	"MONGOLIAN LETTER ALI GALI TTA",
	"MONGOLIAN LETTER ALI GALI TTHA",
	"MONGOLIAN LETTER ALI GALI DDA",
	"MONGOLIAN LETTER ALI GALI NNA",
	"MONGOLIAN LETTER ALI GALI TA",
	"MONGOLIAN LETTER ALI GALI DA",
	"MONGOLIAN LETTER ALI GALI PA",
	"MONGOLIAN LETTER ALI GALI PHA",
	"MONGOLIAN LETTER ALI GALI SSA",
	"MONGOLIAN LETTER ALI GALI ZHA",
	"MONGOLIAN LETTER ALI GALI ZA",
	"MONGOLIAN LETTER ALI GALI AH",
	"MONGOLIAN LETTER TODO ALI GALI TA",
	"MONGOLIAN LETTER TODO ALI GALI ZHA",
	"MONGOLIAN LETTER MANCHU ALI GALI GHA",
	"MONGOLIAN LETTER MANCHU ALI GALI NGA",
	"MONGOLIAN LETTER MANCHU ALI GALI CA",
	"MONGOLIAN LETTER MANCHU ALI GALI JHA",
	"MONGOLIAN LETTER MANCHU ALI GALI TTA",
	"MONGOLIAN LETTER MANCHU ALI GALI DDHA",
	"MONGOLIAN LETTER MANCHU ALI GALI TA",
	"MONGOLIAN LETTER MANCHU ALI GALI DHA",
	"MONGOLIAN LETTER MANCHU ALI GALI SSA",
	"MONGOLIAN LETTER MANCHU ALI GALI CYA",
	"MONGOLIAN LETTER MANCHU ALI GALI ZHA",
	"MONGOLIAN LETTER MANCHU ALI GALI ZA",
	"MONGOLIAN LETTER ALI GALI HALF U",
	"MONGOLIAN LETTER ALI GALI HALF YA",
	"MONGOLIAN LETTER MANCHU ALI GALI BHA",
	"MONGOLIAN LETTER ALI GALI DAGALGA",
	"MONGOLIAN LETTER MANCHU ALI GALI LHA",
	"CANADIAN SYLLABICS OY",
	"CANADIAN SYLLABICS AY",
	"CANADIAN SYLLABICS AAY",
	"CANADIAN SYLLABICS WAY",
	"CANADIAN SYLLABICS POY",
	"CANADIAN SYLLABICS PAY",
	"CANADIAN SYLLABICS PWOY",
	"CANADIAN SYLLABICS TAY",
	"CANADIAN SYLLABICS KAY",
	"CANADIAN SYLLABICS KWAY",
	"CANADIAN SYLLABICS MAY",
	"CANADIAN SYLLABICS NOY",
	"CANADIAN SYLLABICS NAY",
	"CANADIAN SYLLABICS LAY",
	"CANADIAN SYLLABICS SOY",
	"CANADIAN SYLLABICS SAY",
	"CANADIAN SYLLABICS SHOY",
	"CANADIAN SYLLABICS SHAY",
	"CANADIAN SYLLABICS SHWOY",
	"CANADIAN SYLLABICS YOY",
	"CANADIAN SYLLABICS YAY",
	"CANADIAN SYLLABICS RAY",
	"CANADIAN SYLLABICS NWI",
	"CANADIAN SYLLABICS OJIBWAY NWI",
	"CANADIAN SYLLABICS NWII",
	"CANADIAN SYLLABICS OJIBWAY NWII",
	"CANADIAN SYLLABICS NWO",
	"CANADIAN SYLLABICS OJIBWAY NWO",
	"CANADIAN SYLLABICS NWOO",
	"CANADIAN SYLLABICS OJIBWAY NWOO",
	"CANADIAN SYLLABICS RWEE",
	"CANADIAN SYLLABICS RWI",
	"CANADIAN SYLLABICS RWII",
	"CANADIAN SYLLABICS RWO",
	"CANADIAN SYLLABICS RWOO",
	"CANADIAN SYLLABICS RWA",
	"CANADIAN SYLLABICS OJIBWAY P",
	"CANADIAN SYLLABICS OJIBWAY T",
	"CANADIAN SYLLABICS OJIBWAY K",
	"CANADIAN SYLLABICS OJIBWAY C",
	"CANADIAN SYLLABICS OJIBWAY M",
	"CANADIAN SYLLABICS OJIBWAY N",
	"CANADIAN SYLLABICS OJIBWAY S",
	"CANADIAN SYLLABICS OJIBWAY SH",
	"CANADIAN SYLLABICS EASTERN W",
	"CANADIAN SYLLABICS WESTERN W",
	"CANADIAN SYLLABICS FINAL SMALL RING",
	"CANADIAN SYLLABICS FINAL RAISED DOT",
	"CANADIAN SYLLABICS R-CREE RWE",
	"CANADIAN SYLLABICS WEST-CREE LOO",
	"CANADIAN SYLLABICS WEST-CREE LAA",
	"CANADIAN SYLLABICS THWE",
	"CANADIAN SYLLABICS THWA",
	"CANADIAN SYLLABICS TTHWE",
	"CANADIAN SYLLABICS TTHOO",
	"CANADIAN SYLLABICS TTHAA",
	"CANADIAN SYLLABICS TLHWE",
	"CANADIAN SYLLABICS TLHOO",
	"CANADIAN SYLLABICS SAYISI SHWE",
	"CANADIAN SYLLABICS SAYISI SHOO",
	"CANADIAN SYLLABICS SAYISI HOO",
	"CANADIAN SYLLABICS CARRIER GWU",
	"CANADIAN SYLLABICS CARRIER DENE GEE",
	"CANADIAN SYLLABICS CARRIER GAA",
	"CANADIAN SYLLABICS CARRIER GWA",
	"CANADIAN SYLLABICS SAYISI JUU",
	"CANADIAN SYLLABICS CARRIER JWA",
	"CANADIAN SYLLABICS BEAVER DENE L",
	"CANADIAN SYLLABICS BEAVER DENE R",
	"CANADIAN SYLLABICS CARRIER DENTAL S",
	"LIMBU VOWEL-CARRIER LETTER",
	"LIMBU LETTER KA",
	"LIMBU LETTER KHA",
	"LIMBU LETTER GA",
	"LIMBU LETTER GHA",
	"LIMBU LETTER NGA",
	"LIMBU LETTER CA",
	"LIMBU LETTER CHA",
	"LIMBU LETTER JA",
	"LIMBU LETTER JHA",
	"LIMBU LETTER YAN",
	"LIMBU LETTER TA",
	"LIMBU LETTER THA",
	"LIMBU LETTER DA",
	"LIMBU LETTER DHA",
	"LIMBU LETTER NA",
	"LIMBU LETTER PA",
	"LIMBU LETTER PHA",
	"LIMBU LETTER BA",
	"LIMBU LETTER BHA",
	"LIMBU LETTER MA",
	"LIMBU LETTER YA",
	"LIMBU LETTER RA",
	"LIMBU LETTER LA",
	"LIMBU LETTER WA",
	"LIMBU LETTER SHA",
	"LIMBU LETTER SSA",
	"LIMBU LETTER SA",
	"LIMBU LETTER HA",
	"LIMBU LETTER GYAN",
	"LIMBU LETTER TRA",
	"LIMBU VOWEL SIGN A",
	"LIMBU VOWEL SIGN I",
	"LIMBU VOWEL SIGN U",
	"LIMBU VOWEL SIGN EE",
	"LIMBU VOWEL SIGN AI",
	"LIMBU VOWEL SIGN OO",
	"LIMBU VOWEL SIGN AU",
	"LIMBU VOWEL SIGN E",
	"LIMBU VOWEL SIGN O",
	"LIMBU SUBJOINED LETTER YA",
	"LIMBU SUBJOINED LETTER RA",
	"LIMBU SUBJOINED LETTER WA",
	"LIMBU SMALL LETTER KA",
	"LIMBU SMALL LETTER NGA",
	"LIMBU SMALL LETTER ANUSVARA",
	"LIMBU SMALL LETTER TA",
	"LIMBU SMALL LETTER NA",
	"LIMBU SMALL LETTER PA",
	"LIMBU SMALL LETTER MA",
	"LIMBU SMALL LETTER RA",
	"LIMBU SMALL LETTER LA",
	"LIMBU SIGN MUKPHRENG",
	"LIMBU SIGN KEMPHRENG",
	"LIMBU SIGN SA-I",
	"LIMBU SIGN LOO",
	"LIMBU EXCLAMATION MARK",
	"LIMBU QUESTION MARK",
	"LIMBU DIGIT ZERO",
	"LIMBU DIGIT ONE",
	"LIMBU DIGIT TWO",
	"LIMBU DIGIT THREE",
	"LIMBU DIGIT FOUR",
	"LIMBU DIGIT FIVE",
	"LIMBU DIGIT SIX",
	"LIMBU DIGIT SEVEN",
	"LIMBU DIGIT EIGHT",
	"LIMBU DIGIT NINE",
	"TAI LE LETTER KA",
	"TAI LE LETTER XA",
	"TAI LE LETTER NGA",
	"TAI LE LETTER TSA",
	"TAI LE LETTER SA",
	"TAI LE LETTER YA",
	"TAI LE LETTER TA",
	"TAI LE LETTER THA",
	"TAI LE LETTER LA",
	"TAI LE LETTER PA",
	"TAI LE LETTER PHA",
	"TAI LE LETTER MA",
	"TAI LE LETTER FA",
	"TAI LE LETTER VA",
	"TAI LE LETTER HA",
	"TAI LE LETTER QA",
	"TAI LE LETTER KHA",
	"TAI LE LETTER TSHA",
	"TAI LE LETTER NA",
	"TAI LE LETTER A",
	"TAI LE LETTER I",
	"TAI LE LETTER EE",
	"TAI LE LETTER EH",
	"TAI LE LETTER U",
	"TAI LE LETTER OO",
	"TAI LE LETTER O",
	"TAI LE LETTER UE",
	"TAI LE LETTER E",
	"TAI LE LETTER AUE",
	"TAI LE LETTER AI",
	"TAI LE LETTER TONE-2",
	"TAI LE LETTER TONE-3",
	"TAI LE LETTER TONE-4",
	"TAI LE LETTER TONE-5",
	"TAI LE LETTER TONE-6",
	"NEW TAI LUE LETTER HIGH QA",
	"NEW TAI LUE LETTER LOW QA",
	"NEW TAI LUE LETTER HIGH KA",
	"NEW TAI LUE LETTER HIGH XA",
	"NEW TAI LUE LETTER HIGH NGA",
	"NEW TAI LUE LETTER LOW KA",
	"NEW TAI LUE LETTER LOW XA",
	"NEW TAI LUE LETTER LOW NGA",
	"NEW TAI LUE LETTER HIGH TSA",
	"NEW TAI LUE LETTER HIGH SA",
	"NEW TAI LUE LETTER HIGH YA",
	"NEW TAI LUE LETTER LOW TSA",
	"NEW TAI LUE LETTER LOW SA",
	"NEW TAI LUE LETTER LOW YA",
	"NEW TAI LUE LETTER HIGH TA",
	"NEW TAI LUE LETTER HIGH THA",
	"NEW TAI LUE LETTER HIGH NA",
	"NEW TAI LUE LETTER LOW TA",
	"NEW TAI LUE LETTER LOW THA",
	"NEW TAI LUE LETTER LOW NA",
	"NEW TAI LUE LETTER HIGH PA",
	"NEW TAI LUE LETTER HIGH PHA",
	"NEW TAI LUE LETTER HIGH MA",
	"NEW TAI LUE LETTER LOW PA",
	"NEW TAI LUE LETTER LOW PHA",
	"NEW TAI LUE LETTER LOW MA",
	"NEW TAI LUE LETTER HIGH FA",
	"NEW TAI LUE LETTER HIGH VA",
	"NEW TAI LUE LETTER HIGH LA",
	"NEW TAI LUE LETTER LOW FA",
	"NEW TAI LUE LETTER LOW VA",
	"NEW TAI LUE LETTER LOW LA",
	"NEW TAI LUE LETTER HIGH HA",
	"NEW TAI LUE LETTER HIGH DA",
	"NEW TAI LUE LETTER HIGH BA",
	"NEW TAI LUE LETTER LOW HA",
	"NEW TAI LUE LETTER LOW DA",
	"NEW TAI LUE LETTER LOW BA",
	"NEW TAI LUE LETTER HIGH KVA",
	"NEW TAI LUE LETTER HIGH XVA",
	"NEW TAI LUE LETTER LOW KVA",
	"NEW TAI LUE LETTER LOW XVA",
	"NEW TAI LUE LETTER HIGH SUA",
	"NEW TAI LUE LETTER LOW SUA",
	"NEW TAI LUE VOWEL SIGN VOWEL SHORTENER",
	"NEW TAI LUE VOWEL SIGN AA",
	"NEW TAI LUE VOWEL SIGN II",
	"NEW TAI LUE VOWEL SIGN U",
	"NEW TAI LUE VOWEL SIGN UU",
	"NEW TAI LUE VOWEL SIGN E",
	"NEW TAI LUE VOWEL SIGN AE",
	"NEW TAI LUE VOWEL SIGN O",
	"NEW TAI LUE VOWEL SIGN OA",
	"NEW TAI LUE VOWEL SIGN UE",
	"NEW TAI LUE VOWEL SIGN AY",
	"NEW TAI LUE VOWEL SIGN AAY",
	"NEW TAI LUE VOWEL SIGN UY",
	"NEW TAI LUE VOWEL SIGN OY",
	"NEW TAI LUE VOWEL SIGN OAY",
	"NEW TAI LUE VOWEL SIGN UEY",
	"NEW TAI LUE VOWEL SIGN IY",
	"NEW TAI LUE LETTER FINAL V",
	"NEW TAI LUE LETTER FINAL NG",
	"NEW TAI LUE LETTER FINAL N",
	"NEW TAI LUE LETTER FINAL M",
	"NEW TAI LUE LETTER FINAL K",
	"NEW TAI LUE LETTER FINAL D",
	"NEW TAI LUE LETTER FINAL B",
	"NEW TAI LUE TONE MARK-1",
	"NEW TAI LUE TONE MARK-2",
	"NEW TAI LUE DIGIT ZERO",
	"NEW TAI LUE DIGIT ONE",
	"NEW TAI LUE DIGIT TWO",
	"NEW TAI LUE DIGIT THREE",
	"NEW TAI LUE DIGIT FOUR",
	"NEW TAI LUE DIGIT FIVE",
	"NEW TAI LUE DIGIT SIX",
	"NEW TAI LUE DIGIT SEVEN",
	"NEW TAI LUE DIGIT EIGHT",
	"NEW TAI LUE DIGIT NINE",
	"NEW TAI LUE THAM DIGIT ONE",
	"NEW TAI LUE SIGN LAE",
	"NEW TAI LUE SIGN LAEV",
	"KHMER SYMBOL PATHAMASAT",
	"KHMER SYMBOL MUOY KOET",
	"KHMER SYMBOL PII KOET",
	"KHMER SYMBOL BEI KOET",
	"KHMER SYMBOL BUON KOET",
	"KHMER SYMBOL PRAM KOET",
	"KHMER SYMBOL PRAM-MUOY KOET",
	"KHMER SYMBOL PRAM-PII KOET",
	"KHMER SYMBOL PRAM-BEI KOET",
	"KHMER SYMBOL PRAM-BUON KOET",
	"KHMER SYMBOL DAP KOET",
	"KHMER SYMBOL DAP-MUOY KOET",
	"KHMER SYMBOL DAP-PII KOET",
	"KHMER SYMBOL DAP-BEI KOET",
	"KHMER SYMBOL DAP-BUON KOET",
	"KHMER SYMBOL DAP-PRAM KOET",
	"KHMER SYMBOL TUTEYASAT",
	"KHMER SYMBOL MUOY ROC",
	"KHMER SYMBOL PII ROC",
	"KHMER SYMBOL BEI ROC",
	"KHMER SYMBOL BUON ROC",
	"KHMER SYMBOL PRAM ROC",
	"KHMER SYMBOL PRAM-MUOY ROC",
	"KHMER SYMBOL PRAM-PII ROC",
	"KHMER SYMBOL PRAM-BEI ROC",
	"KHMER SYMBOL PRAM-BUON ROC",
	"KHMER SYMBOL DAP ROC",
	"KHMER SYMBOL DAP-MUOY ROC",
	"KHMER SYMBOL DAP-PII ROC",
	"KHMER SYMBOL DAP-BEI ROC",
	"KHMER SYMBOL DAP-BUON ROC",
	"KHMER SYMBOL DAP-PRAM ROC",
	"BUGINESE LETTER KA",
	"BUGINESE LETTER GA",
	"BUGINESE LETTER NGA",
	"BUGINESE LETTER NGKA",
	"BUGINESE LETTER PA",
	"BUGINESE LETTER BA",
	"BUGINESE LETTER MA",
	"BUGINESE LETTER MPA",
	"BUGINESE LETTER TA",
	"BUGINESE LETTER DA",
	"BUGINESE LETTER NA",
	"BUGINESE LETTER NRA",
	"BUGINESE LETTER CA",
	"BUGINESE LETTER JA",
	"BUGINESE LETTER NYA",
	"BUGINESE LETTER NYCA",
	"BUGINESE LETTER YA",
	"BUGINESE LETTER RA",
	"BUGINESE LETTER LA",
	"BUGINESE LETTER VA",
	"BUGINESE LETTER SA",
	"BUGINESE LETTER A",
	"BUGINESE LETTER HA",
	"BUGINESE VOWEL SIGN I",
	"BUGINESE VOWEL SIGN U",
	"BUGINESE VOWEL SIGN E",
	"BUGINESE VOWEL SIGN O",
	"BUGINESE VOWEL SIGN AE",
	"BUGINESE PALLAWA",
	"BUGINESE END OF SECTION",
	"TAI THAM LETTER HIGH KA",
	"TAI THAM LETTER HIGH KHA",
	"TAI THAM LETTER HIGH KXA",
	"TAI THAM LETTER LOW KA",
	"TAI THAM LETTER LOW KXA",
	"TAI THAM LETTER LOW KHA",
	"TAI THAM LETTER NGA",
	"TAI THAM LETTER HIGH CA",
	"TAI THAM LETTER HIGH CHA",
	"TAI THAM LETTER LOW CA",
	"TAI THAM LETTER LOW SA",
	"TAI THAM LETTER LOW CHA",
	"TAI THAM LETTER NYA",
	"TAI THAM LETTER RATA",
	"TAI THAM LETTER HIGH RATHA",
	"TAI THAM LETTER DA",
	"TAI THAM LETTER LOW RATHA",
	"TAI THAM LETTER RANA",
	"TAI THAM LETTER HIGH TA",
	"TAI THAM LETTER HIGH THA",
	"TAI THAM LETTER LOW TA",
	"TAI THAM LETTER LOW THA",
	"TAI THAM LETTER NA",
	"TAI THAM LETTER BA",
	"TAI THAM LETTER HIGH PA",
	"TAI THAM LETTER HIGH PHA",
	"TAI THAM LETTER HIGH FA",
	"TAI THAM LETTER LOW PA",
	"TAI THAM LETTER LOW FA",
	"TAI THAM LETTER LOW PHA",
	"TAI THAM LETTER MA",
	"TAI THAM LETTER LOW YA",
	"TAI THAM LETTER HIGH YA",
	"TAI THAM LETTER RA",
	"TAI THAM LETTER RUE",
	"TAI THAM LETTER LA",
	"TAI THAM LETTER LUE",
	"TAI THAM LETTER WA",
	"TAI THAM LETTER HIGH SHA",
	"TAI THAM LETTER HIGH SSA",
	"TAI THAM LETTER HIGH SA",
	"TAI THAM LETTER HIGH HA",
	"TAI THAM LETTER LLA",
	"TAI THAM LETTER A",
	"TAI THAM LETTER LOW HA",
	"TAI THAM LETTER I",
	"TAI THAM LETTER II",
	"TAI THAM LETTER U",
	"TAI THAM LETTER UU",
	"TAI THAM LETTER EE",
	"TAI THAM LETTER OO",
	"TAI THAM LETTER LAE",
	"TAI THAM LETTER GREAT SA",
	"TAI THAM CONSONANT SIGN MEDIAL RA",
	"TAI THAM CONSONANT SIGN MEDIAL LA",
	"TAI THAM CONSONANT SIGN LA TANG LAI",
	"TAI THAM SIGN MAI KANG LAI",
	"TAI THAM CONSONANT SIGN FINAL NGA",
	"TAI THAM CONSONANT SIGN LOW PA",
	"TAI THAM CONSONANT SIGN HIGH RATHA OR LOW PA",
	"TAI THAM CONSONANT SIGN MA",
	"TAI THAM CONSONANT SIGN BA",
	"TAI THAM CONSONANT SIGN SA",
	"TAI THAM SIGN SAKOT",
	"TAI THAM VOWEL SIGN A",
	"TAI THAM VOWEL SIGN MAI SAT",
	"TAI THAM VOWEL SIGN AA",
	"TAI THAM VOWEL SIGN TALL AA",
	"TAI THAM VOWEL SIGN I",
	"TAI THAM VOWEL SIGN II",
	"TAI THAM VOWEL SIGN UE",
	"TAI THAM VOWEL SIGN UUE",
	"TAI THAM VOWEL SIGN U",
	"TAI THAM VOWEL SIGN UU",
	"TAI THAM VOWEL SIGN O",
	"TAI THAM VOWEL SIGN OA BELOW",
	"TAI THAM VOWEL SIGN OY",
	"TAI THAM VOWEL SIGN E",
	"TAI THAM VOWEL SIGN AE",
	"TAI THAM VOWEL SIGN OO",
	"TAI THAM VOWEL SIGN AI",
	"TAI THAM VOWEL SIGN THAM AI",
	"TAI THAM VOWEL SIGN OA ABOVE",
	"TAI THAM SIGN MAI KANG",
	"TAI THAM SIGN TONE-1",
	"TAI THAM SIGN TONE-2",
	"TAI THAM SIGN KHUEN TONE-3",
	"TAI THAM SIGN KHUEN TONE-4",
	"TAI THAM SIGN KHUEN TONE-5",
	"TAI THAM SIGN RA HAAM",
	"TAI THAM SIGN MAI SAM",
	"TAI THAM SIGN KHUEN-LUE KARAN",
	"TAI THAM COMBINING CRYPTOGRAMMIC DOT",
	"TAI THAM HORA DIGIT ZERO",
	"TAI THAM HORA DIGIT ONE",
	"TAI THAM HORA DIGIT TWO",
	"TAI THAM HORA DIGIT THREE",
	"TAI THAM HORA DIGIT FOUR",
	"TAI THAM HORA DIGIT FIVE",
	"TAI THAM HORA DIGIT SIX",
	"TAI THAM HORA DIGIT SEVEN",
	"TAI THAM HORA DIGIT EIGHT",
	"TAI THAM HORA DIGIT NINE",
	"TAI THAM THAM DIGIT ZERO",
	"TAI THAM THAM DIGIT ONE",
	"TAI THAM THAM DIGIT TWO",
	"TAI THAM THAM DIGIT THREE",
	"TAI THAM THAM DIGIT FOUR",
	"TAI THAM THAM DIGIT FIVE",
	"TAI THAM THAM DIGIT SIX",
	"TAI THAM THAM DIGIT SEVEN",
	"TAI THAM THAM DIGIT EIGHT",
	"TAI THAM THAM DIGIT NINE",
	"TAI THAM SIGN WIANG",
	"TAI THAM SIGN WIANGWAAK",
	"TAI THAM SIGN SAWAN",
	"TAI THAM SIGN KEOW",
	"TAI THAM SIGN HOY",
	"TAI THAM SIGN DOKMAI",
	"TAI THAM SIGN REVERSED ROTATED RANA",
	"TAI THAM SIGN MAI YAMOK",
	"TAI THAM SIGN KAAN",
	"TAI THAM SIGN KAANKUU",
	"TAI THAM SIGN SATKAAN",
	"TAI THAM SIGN SATKAANKUU",
	"TAI THAM SIGN HANG",
	"TAI THAM SIGN CAANG",
	"COMBINING DOUBLED CIRCUMFLEX ACCENT",
	"COMBINING DIAERESIS-RING",
	"COMBINING INFINITY",
	"COMBINING DOWNWARDS ARROW",
	"COMBINING TRIPLE DOT",
	"COMBINING X-X BELOW",
	"COMBINING WIGGLY LINE BELOW",
	"COMBINING OPEN MARK BELOW",
	"COMBINING DOUBLE OPEN MARK BELOW",
	"COMBINING LIGHT CENTRALIZATION STROKE BELOW",
	"COMBINING STRONG CENTRALIZATION STROKE BELOW",
	"COMBINING PARENTHESES ABOVE",
	"COMBINING DOUBLE PARENTHESES ABOVE",
	"COMBINING PARENTHESES BELOW",
	"COMBINING PARENTHESES OVERLAY",
	"COMBINING LATIN SMALL LETTER W BELOW",
	"COMBINING LATIN SMALL LETTER TURNED W BELOW",
	"COMBINING LEFT PARENTHESIS ABOVE LEFT",
	"COMBINING RIGHT PARENTHESIS ABOVE RIGHT",
	"COMBINING LEFT PARENTHESIS BELOW LEFT",
	"COMBINING RIGHT PARENTHESIS BELOW RIGHT",
	"COMBINING SQUARE BRACKETS ABOVE",
	"COMBINING NUMBER SIGN ABOVE",
	"COMBINING INVERTED DOUBLE ARCH ABOVE",
	"COMBINING PLUS SIGN ABOVE",
	"COMBINING DOUBLE PLUS SIGN ABOVE",
	"COMBINING DOUBLE PLUS SIGN BELOW",
	"COMBINING TRIPLE ACUTE ACCENT",
	"COMBINING LATIN SMALL LETTER INSULAR G",
	"COMBINING LATIN SMALL LETTER INSULAR R",
	"COMBINING LATIN SMALL LETTER INSULAR T",
	"BALINESE SIGN ULU RICEM",
	"BALINESE SIGN ULU CANDRA",
	"BALINESE SIGN CECEK",
	"BALINESE SIGN SURANG",
	"BALINESE SIGN BISAH",
	"BALINESE LETTER AKARA",
	"BALINESE LETTER AKARA TEDUNG",
	"BALINESE LETTER IKARA",
	"BALINESE LETTER IKARA TEDUNG",
	"BALINESE LETTER UKARA",
	"BALINESE LETTER UKARA TEDUNG",
	"BALINESE LETTER RA REPA",
	"BALINESE LETTER RA REPA TEDUNG",
	"BALINESE LETTER LA LENGA",
	"BALINESE LETTER LA LENGA TEDUNG",
	"BALINESE LETTER EKARA",
	"BALINESE LETTER AIKARA",
	"BALINESE LETTER OKARA",
	"BALINESE LETTER OKARA TEDUNG",
	"BALINESE LETTER KA",
	"BALINESE LETTER KA MAHAPRANA",
	"BALINESE LETTER GA",
	"BALINESE LETTER GA GORA",
	"BALINESE LETTER NGA",
	"BALINESE LETTER CA",
	"BALINESE LETTER CA LACA",
	"BALINESE LETTER JA",
	"BALINESE LETTER JA JERA",
	"BALINESE LETTER NYA",
	"BALINESE LETTER TA LATIK",
	"BALINESE LETTER TA MURDA MAHAPRANA",
	"BALINESE LETTER DA MURDA ALPAPRANA",
	"BALINESE LETTER DA MURDA MAHAPRANA",
	"BALINESE LETTER NA RAMBAT",
	"BALINESE LETTER TA",
	"BALINESE LETTER TA TAWA",
	"BALINESE LETTER DA",
	"BALINESE LETTER DA MADU",
	"BALINESE LETTER NA",
	"BALINESE LETTER PA",
	"BALINESE LETTER PA KAPAL",
	"BALINESE LETTER BA",
	"BALINESE LETTER BA KEMBANG",
	"BALINESE LETTER MA",
	"BALINESE LETTER YA",
	"BALINESE LETTER RA",
	"BALINESE LETTER LA",
	"BALINESE LETTER WA",
	"BALINESE LETTER SA SAGA",
	"BALINESE LETTER SA SAPA",
	"BALINESE LETTER SA",
	"BALINESE LETTER HA",
	"BALINESE SIGN REREKAN",
	"BALINESE VOWEL SIGN TEDUNG",
	"BALINESE VOWEL SIGN ULU",
	"BALINESE VOWEL SIGN ULU SARI",
	"BALINESE VOWEL SIGN SUKU",
	"BALINESE VOWEL SIGN SUKU ILUT",
	"BALINESE VOWEL SIGN RA REPA",
	"BALINESE VOWEL SIGN RA REPA TEDUNG",
	"BALINESE VOWEL SIGN LA LENGA",
	"BALINESE VOWEL SIGN LA LENGA TEDUNG",
	"BALINESE VOWEL SIGN TALING",
	"BALINESE VOWEL SIGN TALING REPA",
	"BALINESE VOWEL SIGN TALING TEDUNG",
	"BALINESE VOWEL SIGN TALING REPA TEDUNG",
	"BALINESE VOWEL SIGN PEPET",
	"BALINESE VOWEL SIGN PEPET TEDUNG",
	"BALINESE ADEG ADEG",
	"BALINESE LETTER KAF SASAK",
	"BALINESE LETTER KHOT SASAK",
	"BALINESE LETTER TZIR SASAK",
	"BALINESE LETTER EF SASAK",
	"BALINESE LETTER VE SASAK",
	"BALINESE LETTER ZAL SASAK",
	"BALINESE LETTER ASYURA SASAK",
	"BALINESE LETTER ARCHAIC JNYA",
	"BALINESE DIGIT ZERO",
	"BALINESE DIGIT ONE",
	"BALINESE DIGIT TWO",
	"BALINESE DIGIT THREE",
	"BALINESE DIGIT FOUR",
	"BALINESE DIGIT FIVE",
	"BALINESE DIGIT SIX",
	"BALINESE DIGIT SEVEN",
	"BALINESE DIGIT EIGHT",
	"BALINESE DIGIT NINE",
	"BALINESE PANTI",
	"BALINESE PAMADA",
	"BALINESE WINDU",
	"BALINESE CARIK PAMUNGKAH",
	"BALINESE CARIK SIKI",
	"BALINESE CARIK PAREREN",
	"BALINESE PAMENENG",
	"BALINESE MUSICAL SYMBOL DONG",
	"BALINESE MUSICAL SYMBOL DENG",
	"BALINESE MUSICAL SYMBOL DUNG",
	"BALINESE MUSICAL SYMBOL DANG",
	"BALINESE MUSICAL SYMBOL DANG SURANG",
	"BALINESE MUSICAL SYMBOL DING",
	"BALINESE MUSICAL SYMBOL DAENG",
	"BALINESE MUSICAL SYMBOL DEUNG",
	"BALINESE MUSICAL SYMBOL DAING",
	"BALINESE MUSICAL SYMBOL DANG GEDE",
	"BALINESE MUSICAL SYMBOL COMBINING TEGEH",
	"BALINESE MUSICAL SYMBOL COMBINING ENDEP",
	"BALINESE MUSICAL SYMBOL COMBINING KEMPUL",
	"BALINESE MUSICAL SYMBOL COMBINING KEMPLI",
	"BALINESE MUSICAL SYMBOL COMBINING JEGOGAN",
	"BALINESE MUSICAL SYMBOL COMBINING KEMPUL WITH JEGOGAN",
	"BALINESE MUSICAL SYMBOL COMBINING KEMPLI WITH JEGOGAN",
	"BALINESE MUSICAL SYMBOL COMBINING BENDE",
	"BALINESE MUSICAL SYMBOL COMBINING GONG",
	"BALINESE MUSICAL SYMBOL RIGHT-HAND OPEN DUG",
	"BALINESE MUSICAL SYMBOL RIGHT-HAND OPEN DAG",
	"BALINESE MUSICAL SYMBOL RIGHT-HAND CLOSED TUK",
	"BALINESE MUSICAL SYMBOL RIGHT-HAND CLOSED TAK",
	"BALINESE MUSICAL SYMBOL LEFT-HAND OPEN PANG",
	"BALINESE MUSICAL SYMBOL LEFT-HAND OPEN PUNG",
	"BALINESE MUSICAL SYMBOL LEFT-HAND CLOSED PLAK",
	"BALINESE MUSICAL SYMBOL LEFT-HAND CLOSED PLUK",
	"BALINESE MUSICAL SYMBOL LEFT-HAND OPEN PING",
	"BALINESE PANTI LANTANG",
	"BALINESE PAMADA LANTANG",
	"SUNDANESE SIGN PANYECEK",
	"SUNDANESE SIGN PANGLAYAR",
	"SUNDANESE SIGN PANGWISAD",
	"SUNDANESE LETTER A",
	"SUNDANESE LETTER I",
	"SUNDANESE LETTER U",
	"SUNDANESE LETTER AE",
	"SUNDANESE LETTER O",
	"SUNDANESE LETTER E",
	"SUNDANESE LETTER EU",
	"SUNDANESE LETTER KA",
	"SUNDANESE LETTER QA",
	"SUNDANESE LETTER GA",
	"SUNDANESE LETTER NGA",
	"SUNDANESE LETTER CA",
	"SUNDANESE LETTER JA",
	"SUNDANESE LETTER ZA",
	"SUNDANESE LETTER NYA",
	"SUNDANESE LETTER TA",
	"SUNDANESE LETTER DA",
	"SUNDANESE LETTER NA",
	"SUNDANESE LETTER PA",
	"SUNDANESE LETTER FA",
	"SUNDANESE LETTER VA",
	"SUNDANESE LETTER BA",
	"SUNDANESE LETTER MA",
	"SUNDANESE LETTER YA",
	"SUNDANESE LETTER RA",
	"SUNDANESE LETTER LA",
	"SUNDANESE LETTER WA",
	"SUNDANESE LETTER SA",
	"SUNDANESE LETTER XA",
	"SUNDANESE LETTER HA",
	"SUNDANESE CONSONANT SIGN PAMINGKAL",
	"SUNDANESE CONSONANT SIGN PANYAKRA",
	"SUNDANESE CONSONANT SIGN PANYIKU",
	"SUNDANESE VOWEL SIGN PANGHULU",
	"SUNDANESE VOWEL SIGN PANYUKU",
	"SUNDANESE VOWEL SIGN PANAELAENG",
	"SUNDANESE VOWEL SIGN PANOLONG",
	"SUNDANESE VOWEL SIGN PAMEPET",
	"SUNDANESE VOWEL SIGN PANEULEUNG",
	"SUNDANESE SIGN PAMAAEH",
	"SUNDANESE SIGN VIRAMA",
	"SUNDANESE CONSONANT SIGN PASANGAN MA",
	"SUNDANESE CONSONANT SIGN PASANGAN WA",
	"SUNDANESE LETTER KHA",
	"SUNDANESE LETTER SYA",
	"SUNDANESE DIGIT ZERO",
	"SUNDANESE DIGIT ONE",
	"SUNDANESE DIGIT TWO",
	"SUNDANESE DIGIT THREE",
	"SUNDANESE DIGIT FOUR",
	"SUNDANESE DIGIT FIVE",
	"SUNDANESE DIGIT SIX",
	"SUNDANESE DIGIT SEVEN",
	"SUNDANESE DIGIT EIGHT",
	"SUNDANESE DIGIT NINE",
	"SUNDANESE AVAGRAHA",
	"SUNDANESE LETTER REU",
	"SUNDANESE LETTER LEU",
	"SUNDANESE LETTER BHA",
	"SUNDANESE LETTER FINAL K",
	"SUNDANESE LETTER FINAL M",
	"BATAK LETTER A",
	"BATAK LETTER SIMALUNGUN A",
	"BATAK LETTER HA",
	"BATAK LETTER SIMALUNGUN HA",
	"BATAK LETTER MANDAILING HA",
	"BATAK LETTER BA",
	"BATAK LETTER KARO BA",
	"BATAK LETTER PA",
	"BATAK LETTER SIMALUNGUN PA",
	"BATAK LETTER NA",
	"BATAK LETTER MANDAILING NA",
	"BATAK LETTER WA",
	"BATAK LETTER SIMALUNGUN WA",
	"BATAK LETTER PAKPAK WA",
	"BATAK LETTER GA",
	"BATAK LETTER SIMALUNGUN GA",
	"BATAK LETTER JA",
	"BATAK LETTER DA",
	"BATAK LETTER RA",
	"BATAK LETTER SIMALUNGUN RA",
	"BATAK LETTER MA",
	"BATAK LETTER SIMALUNGUN MA",
	"BATAK LETTER SOUTHERN TA",
	"BATAK LETTER NORTHERN TA",
	"BATAK LETTER SA",
	"BATAK LETTER SIMALUNGUN SA",
	"BATAK LETTER MANDAILING SA",
	"BATAK LETTER YA",
	"BATAK LETTER SIMALUNGUN YA",
	"BATAK LETTER NGA",
	"BATAK LETTER LA",
	"BATAK LETTER SIMALUNGUN LA",
	"BATAK LETTER NYA",
	"BATAK LETTER CA",
	"BATAK LETTER NDA",
	"BATAK LETTER MBA",
	"BATAK LETTER I",
	"BATAK LETTER U",
	"BATAK SIGN TOMPI",
	"BATAK VOWEL SIGN E",
	"BATAK VOWEL SIGN PAKPAK E",
	"BATAK VOWEL SIGN EE",
	"BATAK VOWEL SIGN I",
	"BATAK VOWEL SIGN KARO I",
	"BATAK VOWEL SIGN O",
	"BATAK VOWEL SIGN KARO O",
	"BATAK VOWEL SIGN U",
	"BATAK VOWEL SIGN U FOR SIMALUNGUN SA",
	"BATAK CONSONANT SIGN NG",
	"BATAK CONSONANT SIGN H",
	"BATAK PANGOLAT",
	"BATAK PANONGONAN",
	"BATAK SYMBOL BINDU NA METEK",
	"BATAK SYMBOL BINDU PINARBORAS",
	"BATAK SYMBOL BINDU JUDUL",
	"BATAK SYMBOL BINDU PANGOLAT",
	"LEPCHA LETTER KA",
	"LEPCHA LETTER KLA",
	"LEPCHA LETTER KHA",
	"LEPCHA LETTER GA",
	"LEPCHA LETTER GLA",
	"LEPCHA LETTER NGA",
	"LEPCHA LETTER CA",
	"LEPCHA LETTER CHA",
	"LEPCHA LETTER JA",
	"LEPCHA LETTER NYA",
	"LEPCHA LETTER TA",
	"LEPCHA LETTER THA",
	"LEPCHA LETTER DA",
	"LEPCHA LETTER NA",
	"LEPCHA LETTER PA",
	"LEPCHA LETTER PLA",
	"LEPCHA LETTER PHA",
	"LEPCHA LETTER FA",
	"LEPCHA LETTER FLA",
	"LEPCHA LETTER BA",
	"LEPCHA LETTER BLA",
	"LEPCHA LETTER MA",
	"LEPCHA LETTER MLA",
	"LEPCHA LETTER TSA",
	"LEPCHA LETTER TSHA",
	"LEPCHA LETTER DZA",
	"LEPCHA LETTER YA",
	"LEPCHA LETTER RA",
	"LEPCHA LETTER LA",
	"LEPCHA LETTER HA",
	"LEPCHA LETTER HLA",
	"LEPCHA LETTER VA",
	"LEPCHA LETTER SA",
	"LEPCHA LETTER SHA",
	"LEPCHA LETTER WA",
	"LEPCHA LETTER A",
	"LEPCHA SUBJOINED LETTER YA",
	"LEPCHA SUBJOINED LETTER RA",
	"LEPCHA VOWEL SIGN AA",
	"LEPCHA VOWEL SIGN I",
	"LEPCHA VOWEL SIGN O",
	"LEPCHA VOWEL SIGN OO",
	"LEPCHA VOWEL SIGN U",
	"LEPCHA VOWEL SIGN UU",
	"LEPCHA VOWEL SIGN E",
	"LEPCHA CONSONANT SIGN K",
	"LEPCHA CONSONANT SIGN M",
	"LEPCHA CONSONANT SIGN L",
	"LEPCHA CONSONANT SIGN N",
	"LEPCHA CONSONANT SIGN P",
	"LEPCHA CONSONANT SIGN R",
	"LEPCHA CONSONANT SIGN T",
	"LEPCHA CONSONANT SIGN NYIN-DO",
	"LEPCHA CONSONANT SIGN KANG",
	"LEPCHA SIGN RAN",
	"LEPCHA SIGN NUKTA",
	"LEPCHA PUNCTUATION TA-ROL",
	"LEPCHA PUNCTUATION NYET THYOOM TA-ROL",
	"LEPCHA PUNCTUATION CER-WA",
	"LEPCHA PUNCTUATION TSHOOK CER-WA",
	"LEPCHA PUNCTUATION TSHOOK",
	"LEPCHA DIGIT ZERO",
	"LEPCHA DIGIT ONE",
	"LEPCHA DIGIT TWO",
	"LEPCHA DIGIT THREE",
	"LEPCHA DIGIT FOUR",
	"LEPCHA DIGIT FIVE",
	"LEPCHA DIGIT SIX",
	"LEPCHA DIGIT SEVEN",
	"LEPCHA DIGIT EIGHT",
	"LEPCHA DIGIT NINE",
	"LEPCHA LETTER TTA",
	"LEPCHA LETTER TTHA",
	"LEPCHA LETTER DDA",
	"OL CHIKI DIGIT ZERO",
	"OL CHIKI DIGIT ONE",
	"OL CHIKI DIGIT TWO",
	"OL CHIKI DIGIT THREE",
	"OL CHIKI DIGIT FOUR",
	"OL CHIKI DIGIT FIVE",
	"OL CHIKI DIGIT SIX",
	"OL CHIKI DIGIT SEVEN",
	"OL CHIKI DIGIT EIGHT",
	"OL CHIKI DIGIT NINE",
	"OL CHIKI LETTER LA",
	"OL CHIKI LETTER AT",
	"OL CHIKI LETTER AG",
	"OL CHIKI LETTER ANG",
	"OL CHIKI LETTER AL",
	"OL CHIKI LETTER LAA",
	"OL CHIKI LETTER AAK",
	"OL CHIKI LETTER AAJ",
	"OL CHIKI LETTER AAM",
	"OL CHIKI LETTER AAW",
	"OL CHIKI LETTER LI",
	"OL CHIKI LETTER IS",
	"OL CHIKI LETTER IH",
	"OL CHIKI LETTER INY",
	"OL CHIKI LETTER IR",
	"OL CHIKI LETTER LU",
	"OL CHIKI LETTER UC",
	"OL CHIKI LETTER UD",
	"OL CHIKI LETTER UNN",
	"OL CHIKI LETTER UY",
	"OL CHIKI LETTER LE",
	"OL CHIKI LETTER EP",
	"OL CHIKI LETTER EDD",
	"OL CHIKI LETTER EN",
	"OL CHIKI LETTER ERR",
	"OL CHIKI LETTER LO",
	"OL CHIKI LETTER OTT",
	"OL CHIKI LETTER OB",
	"OL CHIKI LETTER OV",
	"OL CHIKI LETTER OH",
	"OL CHIKI MU TTUDDAG",
	"OL CHIKI GAAHLAA TTUDDAAG",
	"OL CHIKI MU-GAAHLAA TTUDDAAG",
	"OL CHIKI RELAA",
	"OL CHIKI PHAARKAA",
	"OL CHIKI AHAD",
	"OL CHIKI PUNCTUATION MUCAAD",
	"OL CHIKI PUNCTUATION DOUBLE MUCAAD",
	"CYRILLIC SMALL LETTER ROUNDED VE",
	"CYRILLIC SMALL LETTER LONG-LEGGED DE",
	"CYRILLIC SMALL LETTER NARROW O",
	"CYRILLIC SMALL LETTER WIDE ES",
	"CYRILLIC SMALL LETTER TALL TE",
	"CYRILLIC SMALL LETTER THREE-LEGGED TE",
	"CYRILLIC SMALL LETTER TALL HARD SIGN",
	"CYRILLIC SMALL LETTER TALL YAT",
	"CYRILLIC SMALL LETTER UNBLENDED UK",
	"GEORGIAN MTAVRULI CAPITAL LETTER AN",
	"GEORGIAN MTAVRULI CAPITAL LETTER BAN",
	"GEORGIAN MTAVRULI CAPITAL LETTER GAN",
	"GEORGIAN MTAVRULI CAPITAL LETTER DON",
	"GEORGIAN MTAVRULI CAPITAL LETTER EN",
	"GEORGIAN MTAVRULI CAPITAL LETTER VIN",
	"GEORGIAN MTAVRULI CAPITAL LETTER ZEN",
	"GEORGIAN MTAVRULI CAPITAL LETTER TAN",
	"GEORGIAN MTAVRULI CAPITAL LETTER IN",
	"GEORGIAN MTAVRULI CAPITAL LETTER KAN",
	"GEORGIAN MTAVRULI CAPITAL LETTER LAS",
	"GEORGIAN MTAVRULI CAPITAL LETTER MAN",
	"GEORGIAN MTAVRULI CAPITAL LETTER NAR",
	"GEORGIAN MTAVRULI CAPITAL LETTER ON",
	"GEORGIAN MTAVRULI CAPITAL LETTER PAR",
	"GEORGIAN MTAVRULI CAPITAL LETTER ZHAR",
	"GEORGIAN MTAVRULI CAPITAL LETTER RAE",
	"GEORGIAN MTAVRULI CAPITAL LETTER SAN",
	"GEORGIAN MTAVRULI CAPITAL LETTER TAR",
	"GEORGIAN MTAVRULI CAPITAL LETTER UN",
	"GEORGIAN MTAVRULI CAPITAL LETTER PHAR",
	"GEORGIAN MTAVRULI CAPITAL LETTER KHAR",
	"GEORGIAN MTAVRULI CAPITAL LETTER GHAN",
	"GEORGIAN MTAVRULI CAPITAL LETTER QAR",
	"GEORGIAN MTAVRULI CAPITAL LETTER SHIN",
	"GEORGIAN MTAVRULI CAPITAL LETTER CHIN",
	"GEORGIAN MTAVRULI CAPITAL LETTER CAN",
	"GEORGIAN MTAVRULI CAPITAL LETTER JIL",
	"GEORGIAN MTAVRULI CAPITAL LETTER CIL",
	"GEORGIAN MTAVRULI CAPITAL LETTER CHAR",
	"GEORGIAN MTAVRULI CAPITAL LETTER XAN",
	"GEORGIAN MTAVRULI CAPITAL LETTER JHAN",
	"GEORGIAN MTAVRULI CAPITAL LETTER HAE",
	"GEORGIAN MTAVRULI CAPITAL LETTER HE",
	"GEORGIAN MTAVRULI CAPITAL LETTER HIE",
	"GEORGIAN MTAVRULI CAPITAL LETTER WE",
	"GEORGIAN MTAVRULI CAPITAL LETTER HAR",
	"GEORGIAN MTAVRULI CAPITAL LETTER HOE",
	"GEORGIAN MTAVRULI CAPITAL LETTER FI",
	"GEORGIAN MTAVRULI CAPITAL LETTER YN",
	"GEORGIAN MTAVRULI CAPITAL LETTER ELIFI",
	"GEORGIAN MTAVRULI CAPITAL LETTER TURNED GAN",
	"GEORGIAN MTAVRULI CAPITAL LETTER AIN",
	"GEORGIAN MTAVRULI CAPITAL LETTER AEN",
	"GEORGIAN MTAVRULI CAPITAL LETTER HARD SIGN",
	"GEORGIAN MTAVRULI CAPITAL LETTER LABIAL SIGN",
	"SUNDANESE PUNCTUATION BINDU SURYA",
	"SUNDANESE PUNCTUATION BINDU PANGLONG",
	"SUNDANESE PUNCTUATION BINDU PURNAMA",
	"SUNDANESE PUNCTUATION BINDU CAKRA",
	"SUNDANESE PUNCTUATION BINDU LEU SATANGA",
	"SUNDANESE PUNCTUATION BINDU KA SATANGA",
	"SUNDANESE PUNCTUATION BINDU DA SATANGA",
	"SUNDANESE PUNCTUATION BINDU BA SATANGA",
	"VEDIC TONE KARSHANA",
	"VEDIC TONE SHARA",
	"VEDIC TONE PRENKHA",
	"VEDIC SIGN NIHSHVASA",
	"VEDIC SIGN YAJURVEDIC MIDLINE SVARITA",
	"VEDIC TONE YAJURVEDIC AGGRAVATED INDEPENDENT SVARITA",
	"VEDIC TONE YAJURVEDIC INDEPENDENT SVARITA",
	"VEDIC TONE YAJURVEDIC KATHAKA INDEPENDENT SVARITA",
	"VEDIC TONE CANDRA BELOW",
	"VEDIC TONE YAJURVEDIC KATHAKA INDEPENDENT SVARITA SCHROEDER",
	"VEDIC TONE DOUBLE SVARITA",
	"VEDIC TONE TRIPLE SVARITA",
	"VEDIC TONE KATHAKA ANUDATTA",
	"VEDIC TONE DOT BELOW",
	"VEDIC TONE TWO DOTS BELOW",
	"VEDIC TONE THREE DOTS BELOW",
	"VEDIC TONE RIGVEDIC KASHMIRI INDEPENDENT SVARITA",
	"VEDIC TONE ATHARVAVEDIC INDEPENDENT SVARITA",
	"VEDIC SIGN VISARGA SVARITA",
	"VEDIC SIGN VISARGA UDATTA",
	"VEDIC SIGN REVERSED VISARGA UDATTA",
	"VEDIC SIGN VISARGA ANUDATTA",
	"VEDIC SIGN REVERSED VISARGA ANUDATTA",
	"VEDIC SIGN VISARGA UDATTA WITH TAIL",
	"VEDIC SIGN VISARGA ANUDATTA WITH TAIL",
	"VEDIC SIGN ANUSVARA ANTARGOMUKHA",
	"VEDIC SIGN ANUSVARA BAHIRGOMUKHA",
	"VEDIC SIGN ANUSVARA VAMAGOMUKHA",
	"VEDIC SIGN ANUSVARA VAMAGOMUKHA WITH TAIL",
	"VEDIC SIGN TIRYAK",
	"VEDIC SIGN HEXIFORM LONG ANUSVARA",
	"VEDIC SIGN LONG ANUSVARA",
	"VEDIC SIGN RTHANG LONG ANUSVARA",
	"VEDIC SIGN ANUSVARA UBHAYATO MUKHA",
	"VEDIC SIGN ARDHAVISARGA",
	"VEDIC SIGN ROTATED ARDHAVISARGA",
	"VEDIC TONE CANDRA ABOVE",
	"VEDIC SIGN JIHVAMULIYA",
	"VEDIC SIGN UPADHMANIYA",
	"VEDIC SIGN ATIKRAMA",
	"VEDIC TONE RING ABOVE",
	"VEDIC TONE DOUBLE RING ABOVE",
	"VEDIC SIGN DOUBLE ANUSVARA ANTARGOMUKHA",
	"LATIN LETTER SMALL CAPITAL A",
	"LATIN LETTER SMALL CAPITAL AE",
	"LATIN SMALL LETTER TURNED AE",
	"LATIN LETTER SMALL CAPITAL BARRED B",
	"LATIN LETTER SMALL CAPITAL C",
	"LATIN LETTER SMALL CAPITAL D",
	"LATIN LETTER SMALL CAPITAL ETH",
	"LATIN LETTER SMALL CAPITAL E",
	"LATIN SMALL LETTER TURNED OPEN E",
	"LATIN SMALL LETTER TURNED I",
	"LATIN LETTER SMALL CAPITAL J",
	"LATIN LETTER SMALL CAPITAL K",
	"LATIN LETTER SMALL CAPITAL L WITH STROKE",
	"LATIN LETTER SMALL CAPITAL M",
	"LATIN LETTER SMALL CAPITAL REVERSED N",
	"LATIN LETTER SMALL CAPITAL O",
	"LATIN LETTER SMALL CAPITAL OPEN O",
	"LATIN SMALL LETTER SIDEWAYS O",
	"LATIN SMALL LETTER SIDEWAYS OPEN O",
	"LATIN SMALL LETTER SIDEWAYS O WITH STROKE",
	"LATIN SMALL LETTER TURNED OE",
	"LATIN LETTER SMALL CAPITAL OU",
	"LATIN SMALL LETTER TOP HALF O",
	"LATIN SMALL LETTER BOTTOM HALF O",
	"LATIN LETTER SMALL CAPITAL P",
	"LATIN LETTER SMALL CAPITAL REVERSED R",
	"LATIN LETTER SMALL CAPITAL TURNED R",
	"LATIN LETTER SMALL CAPITAL T",
	"LATIN LETTER SMALL CAPITAL U",
	"LATIN SMALL LETTER SIDEWAYS U",
	"LATIN SMALL LETTER SIDEWAYS DIAERESIZED U",
	"LATIN SMALL LETTER SIDEWAYS TURNED M",
	"LATIN LETTER SMALL CAPITAL V",
	"LATIN LETTER SMALL CAPITAL W",
	"LATIN LETTER SMALL CAPITAL Z",
	"LATIN LETTER SMALL CAPITAL EZH",
	"LATIN LETTER VOICED LARYNGEAL SPIRANT",
	"LATIN LETTER AIN",
	"GREEK LETTER SMALL CAPITAL GAMMA",
	"GREEK LETTER SMALL CAPITAL LAMDA",
	"GREEK LETTER SMALL CAPITAL PI",
	"GREEK LETTER SMALL CAPITAL RHO",
	"GREEK LETTER SMALL CAPITAL PSI",
	"CYRILLIC LETTER SMALL CAPITAL EL",
	"MODIFIER LETTER CAPITAL A",
	"MODIFIER LETTER CAPITAL AE",
	"MODIFIER LETTER CAPITAL B",
	"MODIFIER LETTER CAPITAL BARRED B",
	"MODIFIER LETTER CAPITAL D",
	"MODIFIER LETTER CAPITAL E",
	"MODIFIER LETTER CAPITAL REVERSED E",
	"MODIFIER LETTER CAPITAL G",
	"MODIFIER LETTER CAPITAL H",
	"MODIFIER LETTER CAPITAL I",
	"MODIFIER LETTER CAPITAL J",
	"MODIFIER LETTER CAPITAL K",
	"MODIFIER LETTER CAPITAL L",
	"MODIFIER LETTER CAPITAL M",
	"MODIFIER LETTER CAPITAL N",
	"MODIFIER LETTER CAPITAL REVERSED N",
	"MODIFIER LETTER CAPITAL O",
	"MODIFIER LETTER CAPITAL OU",
	"MODIFIER LETTER CAPITAL P",
	"MODIFIER LETTER CAPITAL R",
	"MODIFIER LETTER CAPITAL T",
	"MODIFIER LETTER CAPITAL U",
	"MODIFIER LETTER CAPITAL W",
	"MODIFIER LETTER SMALL A",
	"MODIFIER LETTER SMALL TURNED A",
	"MODIFIER LETTER SMALL ALPHA",
	"MODIFIER LETTER SMALL TURNED AE",
	"MODIFIER LETTER SMALL B",
	"MODIFIER LETTER SMALL D",
	"MODIFIER LETTER SMALL E",
	"MODIFIER LETTER SMALL SCHWA",
	"MODIFIER LETTER SMALL OPEN E",
	"MODIFIER LETTER SMALL TURNED OPEN E",
	"MODIFIER LETTER SMALL G",
	"MODIFIER LETTER SMALL TURNED I",
	"MODIFIER LETTER SMALL K",
	"MODIFIER LETTER SMALL M",
	"MODIFIER LETTER SMALL ENG",
	"MODIFIER LETTER SMALL O",
	"MODIFIER LETTER SMALL OPEN O",
	"MODIFIER LETTER SMALL TOP HALF O",
	"MODIFIER LETTER SMALL BOTTOM HALF O",
	"MODIFIER LETTER SMALL P",
	"MODIFIER LETTER SMALL T",
	"MODIFIER LETTER SMALL U",
	"MODIFIER LETTER SMALL SIDEWAYS U",
	"MODIFIER LETTER SMALL TURNED M",
	"MODIFIER LETTER SMALL V",
	"MODIFIER LETTER SMALL AIN",
	"MODIFIER LETTER SMALL BETA",
	"MODIFIER LETTER SMALL GREEK GAMMA",
	"MODIFIER LETTER SMALL DELTA",
	"MODIFIER LETTER SMALL GREEK PHI",
	"MODIFIER LETTER SMALL CHI",
	"LATIN SUBSCRIPT SMALL LETTER I",
	"LATIN SUBSCRIPT SMALL LETTER R",
	"LATIN SUBSCRIPT SMALL LETTER U",
	"LATIN SUBSCRIPT SMALL LETTER V",
	"GREEK SUBSCRIPT SMALL LETTER BETA",
	"GREEK SUBSCRIPT SMALL LETTER GAMMA",
	"GREEK SUBSCRIPT SMALL LETTER RHO",
	"GREEK SUBSCRIPT SMALL LETTER PHI",
	"GREEK SUBSCRIPT SMALL LETTER CHI",
	"LATIN SMALL LETTER UE",
	"LATIN SMALL LETTER B WITH MIDDLE TILDE",
	"LATIN SMALL LETTER D WITH MIDDLE TILDE",
	"LATIN SMALL LETTER F WITH MIDDLE TILDE",
	"LATIN SMALL LETTER M WITH MIDDLE TILDE",
	"LATIN SMALL LETTER N WITH MIDDLE TILDE",
	"LATIN SMALL LETTER P WITH MIDDLE TILDE",
	"LATIN SMALL LETTER R WITH MIDDLE TILDE",
	"LATIN SMALL LETTER R WITH FISHHOOK AND MIDDLE TILDE",
	"LATIN SMALL LETTER S WITH MIDDLE TILDE",
	"LATIN SMALL LETTER T WITH MIDDLE TILDE",
	"LATIN SMALL LETTER Z WITH MIDDLE TILDE",
	"LATIN SMALL LETTER TURNED G",
	"MODIFIER LETTER CYRILLIC EN",
	"LATIN SMALL LETTER INSULAR G",
	"LATIN SMALL LETTER TH WITH STRIKETHROUGH",
	"LATIN SMALL CAPITAL LETTER I WITH STROKE",
	"LATIN SMALL LETTER IOTA WITH STROKE",
	"LATIN SMALL LETTER P WITH STROKE",
	"LATIN SMALL CAPITAL LETTER U WITH STROKE",
	"LATIN SMALL LETTER UPSILON WITH STROKE",
	"LATIN SMALL LETTER B WITH PALATAL HOOK",
	"LATIN SMALL LETTER D WITH PALATAL HOOK",
	"LATIN SMALL LETTER F WITH PALATAL HOOK",
	"LATIN SMALL LETTER G WITH PALATAL HOOK",
	"LATIN SMALL LETTER K WITH PALATAL HOOK",
	"LATIN SMALL LETTER L WITH PALATAL HOOK",
	"LATIN SMALL LETTER M WITH PALATAL HOOK",
	"LATIN SMALL LETTER N WITH PALATAL HOOK",
	"LATIN SMALL LETTER P WITH PALATAL HOOK",
	"LATIN SMALL LETTER R WITH PALATAL HOOK",
	"LATIN SMALL LETTER S WITH PALATAL HOOK",
	"LATIN SMALL LETTER ESH WITH PALATAL HOOK",
	"LATIN SMALL LETTER V WITH PALATAL HOOK",
	"LATIN SMALL LETTER X WITH PALATAL HOOK",
	"LATIN SMALL LETTER Z WITH PALATAL HOOK",
	"LATIN SMALL LETTER A WITH RETROFLEX HOOK",
	"LATIN SMALL LETTER ALPHA WITH RETROFLEX HOOK",
	"LATIN SMALL LETTER D WITH HOOK AND TAIL",
	"LATIN SMALL LETTER E WITH RETROFLEX HOOK",
	"LATIN SMALL LETTER OPEN E WITH RETROFLEX HOOK",
	"LATIN SMALL LETTER REVERSED OPEN E WITH RETROFLEX HOOK",
	"LATIN SMALL LETTER SCHWA WITH RETROFLEX HOOK",
	"LATIN SMALL LETTER I WITH RETROFLEX HOOK",
	"LATIN SMALL LETTER OPEN O WITH RETROFLEX HOOK",
	"LATIN SMALL LETTER ESH WITH RETROFLEX HOOK",
	"LATIN SMALL LETTER U WITH RETROFLEX HOOK",
	"LATIN SMALL LETTER EZH WITH RETROFLEX HOOK",
	"MODIFIER LETTER SMALL TURNED ALPHA",
	"MODIFIER LETTER SMALL C",
	"MODIFIER LETTER SMALL C WITH CURL",
	"MODIFIER LETTER SMALL ETH",
	"MODIFIER LETTER SMALL REVERSED OPEN E",
	"MODIFIER LETTER SMALL F",
	"MODIFIER LETTER SMALL DOTLESS J WITH STROKE",
	"MODIFIER LETTER SMALL SCRIPT G",
	"MODIFIER LETTER SMALL TURNED H",
	"MODIFIER LETTER SMALL I WITH STROKE",
	"MODIFIER LETTER SMALL IOTA",
	"MODIFIER LETTER SMALL CAPITAL I",
	"MODIFIER LETTER SMALL CAPITAL I WITH STROKE",
	"MODIFIER LETTER SMALL J WITH CROSSED-TAIL",
	"MODIFIER LETTER SMALL L WITH RETROFLEX HOOK",
	"MODIFIER LETTER SMALL L WITH PALATAL HOOK",
	"MODIFIER LETTER SMALL CAPITAL L",
	"MODIFIER LETTER SMALL M WITH HOOK",
	"MODIFIER LETTER SMALL TURNED M WITH LONG LEG",
	"MODIFIER LETTER SMALL N WITH LEFT HOOK",
	"MODIFIER LETTER SMALL N WITH RETROFLEX HOOK",
	"MODIFIER LETTER SMALL CAPITAL N",
	"MODIFIER LETTER SMALL BARRED O",
	"MODIFIER LETTER SMALL PHI",
	"MODIFIER LETTER SMALL S WITH HOOK",
	"MODIFIER LETTER SMALL ESH",
	"MODIFIER LETTER SMALL T WITH PALATAL HOOK",
	"MODIFIER LETTER SMALL U BAR",
	"MODIFIER LETTER SMALL UPSILON",
	"MODIFIER LETTER SMALL CAPITAL U",
	"MODIFIER LETTER SMALL V WITH HOOK",
	"MODIFIER LETTER SMALL TURNED V",
	"MODIFIER LETTER SMALL Z",
	"MODIFIER LETTER SMALL Z WITH RETROFLEX HOOK",
	"MODIFIER LETTER SMALL Z WITH CURL",
	"MODIFIER LETTER SMALL EZH",
	"MODIFIER LETTER SMALL THETA",
	"COMBINING DOTTED GRAVE ACCENT",
	"COMBINING DOTTED ACUTE ACCENT",
	"COMBINING SNAKE BELOW",
	"COMBINING SUSPENSION MARK",
	"COMBINING MACRON-ACUTE",
	"COMBINING GRAVE-MACRON",
	"COMBINING MACRON-GRAVE",
	"COMBINING ACUTE-MACRON",
	"COMBINING GRAVE-ACUTE-GRAVE",
	"COMBINING ACUTE-GRAVE-ACUTE",
	"COMBINING LATIN SMALL LETTER R BELOW",
	"COMBINING BREVE-MACRON",
	"COMBINING MACRON-BREVE",
	"COMBINING DOUBLE CIRCUMFLEX ABOVE",
	"COMBINING OGONEK ABOVE",
	"COMBINING ZIGZAG BELOW",
	"COMBINING IS BELOW",
	"COMBINING UR ABOVE",
	"COMBINING US ABOVE",
	"COMBINING LATIN SMALL LETTER FLATTENED OPEN A ABOVE",
	"COMBINING LATIN SMALL LETTER AE",
	"COMBINING LATIN SMALL LETTER AO",
	"COMBINING LATIN SMALL LETTER AV",
	"COMBINING LATIN SMALL LETTER C CEDILLA",
	"COMBINING LATIN SMALL LETTER INSULAR D",
	"COMBINING LATIN SMALL LETTER ETH",
	"COMBINING LATIN SMALL LETTER G",
	"COMBINING LATIN LETTER SMALL CAPITAL G",
	"COMBINING LATIN SMALL LETTER K",
	"COMBINING LATIN SMALL LETTER L",
	"COMBINING LATIN LETTER SMALL CAPITAL L",
	"COMBINING LATIN LETTER SMALL CAPITAL M",
	"COMBINING LATIN SMALL LETTER N",
	"COMBINING LATIN LETTER SMALL CAPITAL N",
	"COMBINING LATIN LETTER SMALL CAPITAL R",
	"COMBINING LATIN SMALL LETTER R ROTUNDA",
	"COMBINING LATIN SMALL LETTER S",
	"COMBINING LATIN SMALL LETTER LONG S",
	"COMBINING LATIN SMALL LETTER Z",
	"COMBINING LATIN SMALL LETTER ALPHA",
	"COMBINING LATIN SMALL LETTER B",
	"COMBINING LATIN SMALL LETTER BETA",
	"COMBINING LATIN SMALL LETTER SCHWA",
	"COMBINING LATIN SMALL LETTER F",
	"COMBINING LATIN SMALL LETTER L WITH DOUBLE MIDDLE TILDE",
	"COMBINING LATIN SMALL LETTER O WITH LIGHT CENTRALIZATION STROKE",
	"COMBINING LATIN SMALL LETTER P",
	"COMBINING LATIN SMALL LETTER ESH",
	"COMBINING LATIN SMALL LETTER U WITH LIGHT CENTRALIZATION STROKE",
	"COMBINING LATIN SMALL LETTER W",
	"COMBINING LATIN SMALL LETTER A WITH DIAERESIS",
	"COMBINING LATIN SMALL LETTER O WITH DIAERESIS",
	"COMBINING LATIN SMALL LETTER U WITH DIAERESIS",
	"COMBINING UP TACK ABOVE",
	"COMBINING KAVYKA ABOVE RIGHT",
	"COMBINING KAVYKA ABOVE LEFT",
	"COMBINING DOT ABOVE LEFT",
	"COMBINING WIDE INVERTED BRIDGE BELOW",
	"COMBINING DOT BELOW LEFT",
	"COMBINING DELETION MARK",
	"COMBINING DOUBLE INVERTED BREVE BELOW",
	"COMBINING ALMOST EQUAL TO BELOW",
	"COMBINING LEFT ARROWHEAD ABOVE",
	"COMBINING RIGHT ARROWHEAD AND DOWN ARROWHEAD BELOW",
	"LATIN CAPITAL LETTER A WITH RING BELOW",
	"LATIN SMALL LETTER A WITH RING BELOW",
	"LATIN CAPITAL LETTER B WITH DOT ABOVE",
	"LATIN SMALL LETTER B WITH DOT ABOVE",
	"LATIN CAPITAL LETTER B WITH DOT BELOW",
	"LATIN SMALL LETTER B WITH DOT BELOW",
	"LATIN CAPITAL LETTER B WITH LINE BELOW",
	"LATIN SMALL LETTER B WITH LINE BELOW",
	"LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE",
	"LATIN SMALL LETTER C WITH CEDILLA AND ACUTE",
	"LATIN CAPITAL LETTER D WITH DOT ABOVE",
	"LATIN SMALL LETTER D WITH DOT ABOVE",
	"LATIN CAPITAL LETTER D WITH DOT BELOW",
	"LATIN SMALL LETTER D WITH DOT BELOW",
	"LATIN CAPITAL LETTER D WITH LINE BELOW",
	"LATIN SMALL LETTER D WITH LINE BELOW",
	"LATIN CAPITAL LETTER D WITH CEDILLA",
	"LATIN SMALL LETTER D WITH CEDILLA",
	"LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW",
	"LATIN SMALL LETTER D WITH CIRCUMFLEX BELOW",
	"LATIN CAPITAL LETTER E WITH MACRON AND GRAVE",
	"LATIN SMALL LETTER E WITH MACRON AND GRAVE",
	"LATIN CAPITAL LETTER E WITH MACRON AND ACUTE",
	"LATIN SMALL LETTER E WITH MACRON AND ACUTE",
	"LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW",
	"LATIN SMALL LETTER E WITH CIRCUMFLEX BELOW",
	"LATIN CAPITAL LETTER E WITH TILDE BELOW",
	"LATIN SMALL LETTER E WITH TILDE BELOW",
	"LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE",
	"LATIN SMALL LETTER E WITH CEDILLA AND BREVE",
	"LATIN CAPITAL LETTER F WITH DOT ABOVE",
	"LATIN SMALL LETTER F WITH DOT ABOVE",
	"LATIN CAPITAL LETTER G WITH MACRON",
	"LATIN SMALL LETTER G WITH MACRON",
	"LATIN CAPITAL LETTER H WITH DOT ABOVE",
	"LATIN SMALL LETTER H WITH DOT ABOVE",
	"LATIN CAPITAL LETTER H WITH DOT BELOW",
	"LATIN SMALL LETTER H WITH DOT BELOW",
	"LATIN CAPITAL LETTER H WITH DIAERESIS",
	"LATIN SMALL LETTER H WITH DIAERESIS",
	"LATIN CAPITAL LETTER H WITH CEDILLA",
	"LATIN SMALL LETTER H WITH CEDILLA",
	"LATIN CAPITAL LETTER H WITH BREVE BELOW",
	"LATIN SMALL LETTER H WITH BREVE BELOW",
	"LATIN CAPITAL LETTER I WITH TILDE BELOW",
	"LATIN SMALL LETTER I WITH TILDE BELOW",
	"LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE",
	"LATIN SMALL LETTER I WITH DIAERESIS AND ACUTE",
	"LATIN CAPITAL LETTER K WITH ACUTE",
	"LATIN SMALL LETTER K WITH ACUTE",
	"LATIN CAPITAL LETTER K WITH DOT BELOW",
	"LATIN SMALL LETTER K WITH DOT BELOW",
	"LATIN CAPITAL LETTER K WITH LINE BELOW",
	"LATIN SMALL LETTER K WITH LINE BELOW",
	"LATIN CAPITAL LETTER L WITH DOT BELOW",
	"LATIN SMALL LETTER L WITH DOT BELOW",
	"LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON",
	"LATIN SMALL LETTER L WITH DOT BELOW AND MACRON",
	"LATIN CAPITAL LETTER L WITH LINE BELOW",
	"LATIN SMALL LETTER L WITH LINE BELOW",
	"LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW",
	"LATIN SMALL LETTER L WITH CIRCUMFLEX BELOW",
	"LATIN CAPITAL LETTER M WITH ACUTE",
	"LATIN SMALL LETTER M WITH ACUTE",
	"LATIN CAPITAL LETTER M WITH DOT ABOVE",
	"LATIN SMALL LETTER M WITH DOT ABOVE",
	"LATIN CAPITAL LETTER M WITH DOT BELOW",
	"LATIN SMALL LETTER M WITH DOT BELOW",
	"LATIN CAPITAL LETTER N WITH DOT ABOVE",
	"LATIN SMALL LETTER N WITH DOT ABOVE",
	"LATIN CAPITAL LETTER N WITH DOT BELOW",
	"LATIN SMALL LETTER N WITH DOT BELOW",
	"LATIN CAPITAL LETTER N WITH LINE BELOW",
	"LATIN SMALL LETTER N WITH LINE BELOW",
	"LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW",
	"LATIN SMALL LETTER N WITH CIRCUMFLEX BELOW",
	"LATIN CAPITAL LETTER O WITH TILDE AND ACUTE",
	"LATIN SMALL LETTER O WITH TILDE AND ACUTE",
	"LATIN CAPITAL LETTER O WITH TILDE AND DIAERESIS",
	"LATIN SMALL LETTER O WITH TILDE AND DIAERESIS",
	"LATIN CAPITAL LETTER O WITH MACRON AND GRAVE",
	"LATIN SMALL LETTER O WITH MACRON AND GRAVE",
	"LATIN CAPITAL LETTER O WITH MACRON AND ACUTE",
	"LATIN SMALL LETTER O WITH MACRON AND ACUTE",
	"LATIN CAPITAL LETTER P WITH ACUTE",
	"LATIN SMALL LETTER P WITH ACUTE",
	"LATIN CAPITAL LETTER P WITH DOT ABOVE",
	"LATIN SMALL LETTER P WITH DOT ABOVE",
	"LATIN CAPITAL LETTER R WITH DOT ABOVE",
	"LATIN SMALL LETTER R WITH DOT ABOVE",
	"LATIN CAPITAL LETTER R WITH DOT BELOW",
	"LATIN SMALL LETTER R WITH DOT BELOW",
	"LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON",
	"LATIN SMALL LETTER R WITH DOT BELOW AND MACRON",
	"LATIN CAPITAL LETTER R WITH LINE BELOW",
	"LATIN SMALL LETTER R WITH LINE BELOW",
	"LATIN CAPITAL LETTER S WITH DOT ABOVE",
	"LATIN SMALL LETTER S WITH DOT ABOVE",
	"LATIN CAPITAL LETTER S WITH DOT BELOW",
	"LATIN SMALL LETTER S WITH DOT BELOW",
	"LATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVE",
	"LATIN SMALL LETTER S WITH ACUTE AND DOT ABOVE",
	"LATIN CAPITAL LETTER S WITH CARON AND DOT ABOVE",
	"LATIN SMALL LETTER S WITH CARON AND DOT ABOVE",
	"LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE",
	"LATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVE",
	"LATIN CAPITAL LETTER T WITH DOT ABOVE",
	"LATIN SMALL LETTER T WITH DOT ABOVE",
	"LATIN CAPITAL LETTER T WITH DOT BELOW",
	"LATIN SMALL LETTER T WITH DOT BELOW",
	"LATIN CAPITAL LETTER T WITH LINE BELOW",
	"LATIN SMALL LETTER T WITH LINE BELOW",
	"LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW",
	"LATIN SMALL LETTER T WITH CIRCUMFLEX BELOW",
	"LATIN CAPITAL LETTER U WITH DIAERESIS BELOW",
	"LATIN SMALL LETTER U WITH DIAERESIS BELOW",
	"LATIN CAPITAL LETTER U WITH TILDE BELOW",
	"LATIN SMALL LETTER U WITH TILDE BELOW",
	"LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW",
	"LATIN SMALL LETTER U WITH CIRCUMFLEX BELOW",
	"LATIN CAPITAL LETTER U WITH TILDE AND ACUTE",
	"LATIN SMALL LETTER U WITH TILDE AND ACUTE",
	"LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS",
	"LATIN SMALL LETTER U WITH MACRON AND DIAERESIS",
	"LATIN CAPITAL LETTER V WITH TILDE",
	"LATIN SMALL LETTER V WITH TILDE",
	"LATIN CAPITAL LETTER V WITH DOT BELOW",
	"LATIN SMALL LETTER V WITH DOT BELOW",
	"LATIN CAPITAL LETTER W WITH GRAVE",
	"LATIN SMALL LETTER W WITH GRAVE",
	"LATIN CAPITAL LETTER W WITH ACUTE",
	"LATIN SMALL LETTER W WITH ACUTE",
	"LATIN CAPITAL LETTER W WITH DIAERESIS",
	"LATIN SMALL LETTER W WITH DIAERESIS",
	"LATIN CAPITAL LETTER W WITH DOT ABOVE",
	"LATIN SMALL LETTER W WITH DOT ABOVE",
	"LATIN CAPITAL LETTER W WITH DOT BELOW",
	"LATIN SMALL LETTER W WITH DOT BELOW",
	"LATIN CAPITAL LETTER X WITH DOT ABOVE",
	"LATIN SMALL LETTER X WITH DOT ABOVE",
	"LATIN CAPITAL LETTER X WITH DIAERESIS",
	"LATIN SMALL LETTER X WITH DIAERESIS",
	"LATIN CAPITAL LETTER Y WITH DOT ABOVE",
	"LATIN SMALL LETTER Y WITH DOT ABOVE",
	"LATIN CAPITAL LETTER Z WITH CIRCUMFLEX",
	"LATIN SMALL LETTER Z WITH CIRCUMFLEX",
	"LATIN CAPITAL LETTER Z WITH DOT BELOW",
	"LATIN SMALL LETTER Z WITH DOT BELOW",
	"LATIN CAPITAL LETTER Z WITH LINE BELOW",
	"LATIN SMALL LETTER Z WITH LINE BELOW",
	"LATIN SMALL LETTER H WITH LINE BELOW",
	"LATIN SMALL LETTER T WITH DIAERESIS",
	"LATIN SMALL LETTER W WITH RING ABOVE",
	"LATIN SMALL LETTER Y WITH RING ABOVE",
	"LATIN SMALL LETTER A WITH RIGHT HALF RING",
	"LATIN SMALL LETTER LONG S WITH DOT ABOVE",
	"LATIN SMALL LETTER LONG S WITH DIAGONAL STROKE",
	"LATIN SMALL LETTER LONG S WITH HIGH STROKE",
	"LATIN CAPITAL LETTER SHARP S",
	"LATIN SMALL LETTER DELTA",
	"LATIN CAPITAL LETTER A WITH DOT BELOW",
	"LATIN SMALL LETTER A WITH DOT BELOW",
	"LATIN CAPITAL LETTER A WITH HOOK ABOVE",
	"LATIN SMALL LETTER A WITH HOOK ABOVE",
	"LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE",
	"LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE",
	"LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE",
	"LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE",
	"LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE",
	"LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE",
	"LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE",
	"LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE",
	"LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW",
	"LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW",
	"LATIN CAPITAL LETTER A WITH BREVE AND ACUTE",
	"LATIN SMALL LETTER A WITH BREVE AND ACUTE",
	"LATIN CAPITAL LETTER A WITH BREVE AND GRAVE",
	"LATIN SMALL LETTER A WITH BREVE AND GRAVE",
	"LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE",
	"LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE",
	"LATIN CAPITAL LETTER A WITH BREVE AND TILDE",
	"LATIN SMALL LETTER A WITH BREVE AND TILDE",
	"LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW",
	"LATIN SMALL LETTER A WITH BREVE AND DOT BELOW",
	"LATIN CAPITAL LETTER E WITH DOT BELOW",
	"LATIN SMALL LETTER E WITH DOT BELOW",
	"LATIN CAPITAL LETTER E WITH HOOK ABOVE",
	"LATIN SMALL LETTER E WITH HOOK ABOVE",
	"LATIN CAPITAL LETTER E WITH TILDE",
	"LATIN SMALL LETTER E WITH TILDE",
	"LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE",
	"LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE",
	"LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE",
	"LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE",
	"LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE",
	"LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE",
	"LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE",
	"LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE",
	"LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW",
	"LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW",
	"LATIN CAPITAL LETTER I WITH HOOK ABOVE",
	"LATIN SMALL LETTER I WITH HOOK ABOVE",
	"LATIN CAPITAL LETTER I WITH DOT BELOW",
	"LATIN SMALL LETTER I WITH DOT BELOW",
	"LATIN CAPITAL LETTER O WITH DOT BELOW",
	"LATIN SMALL LETTER O WITH DOT BELOW",
	"LATIN CAPITAL LETTER O WITH HOOK ABOVE",
	"LATIN SMALL LETTER O WITH HOOK ABOVE",
	"LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE",
	"LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE",
	"LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE",
	"LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE",
	"LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE",
	"LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE",
	"LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE",
	"LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE",
	"LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW",
	"LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW",
	"LATIN CAPITAL LETTER O WITH HORN AND ACUTE",
	"LATIN SMALL LETTER O WITH HORN AND ACUTE",
	"LATIN CAPITAL LETTER O WITH HORN AND GRAVE",
	"LATIN SMALL LETTER O WITH HORN AND GRAVE",
	"LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE",
	"LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE",
	"LATIN CAPITAL LETTER O WITH HORN AND TILDE",
	"LATIN SMALL LETTER O WITH HORN AND TILDE",
	"LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW",
	"LATIN SMALL LETTER O WITH HORN AND DOT BELOW",
	"LATIN CAPITAL LETTER U WITH DOT BELOW",
	"LATIN SMALL LETTER U WITH DOT BELOW",
	"LATIN CAPITAL LETTER U WITH HOOK ABOVE",
	"LATIN SMALL LETTER U WITH HOOK ABOVE",
	"LATIN CAPITAL LETTER U WITH HORN AND ACUTE",
	"LATIN SMALL LETTER U WITH HORN AND ACUTE",
	"LATIN CAPITAL LETTER U WITH HORN AND GRAVE",
	"LATIN SMALL LETTER U WITH HORN AND GRAVE",
	"LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE",
	"LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE",
	"LATIN CAPITAL LETTER U WITH HORN AND TILDE",
	"LATIN SMALL LETTER U WITH HORN AND TILDE",
	"LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW",
	"LATIN SMALL LETTER U WITH HORN AND DOT BELOW",
	"LATIN CAPITAL LETTER Y WITH GRAVE",
	"LATIN SMALL LETTER Y WITH GRAVE",
	"LATIN CAPITAL LETTER Y WITH DOT BELOW",
	"LATIN SMALL LETTER Y WITH DOT BELOW",
	"LATIN CAPITAL LETTER Y WITH HOOK ABOVE",
	"LATIN SMALL LETTER Y WITH HOOK ABOVE",
	"LATIN CAPITAL LETTER Y WITH TILDE",
	"LATIN SMALL LETTER Y WITH TILDE",
	"LATIN CAPITAL LETTER MIDDLE-WELSH LL",
	"LATIN SMALL LETTER MIDDLE-WELSH LL",
	"LATIN CAPITAL LETTER MIDDLE-WELSH V",
	"LATIN SMALL LETTER MIDDLE-WELSH V",
	"LATIN CAPITAL LETTER Y WITH LOOP",
	"LATIN SMALL LETTER Y WITH LOOP",
	"GREEK SMALL LETTER ALPHA WITH PSILI",
	"GREEK SMALL LETTER ALPHA WITH DASIA",
	"GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA",
	"GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA",
	"GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA",
	"GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA",
	"GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI",
	"GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI",
	"GREEK CAPITAL LETTER ALPHA WITH PSILI",
	"GREEK CAPITAL LETTER ALPHA WITH DASIA",
	"GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA",
	"GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA",
	"GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA",
	"GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA",
	"GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI",
	"GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI",
	"GREEK SMALL LETTER EPSILON WITH PSILI",
	"GREEK SMALL LETTER EPSILON WITH DASIA",
	"GREEK SMALL LETTER EPSILON WITH PSILI AND VARIA",
	"GREEK SMALL LETTER EPSILON WITH DASIA AND VARIA",
	"GREEK SMALL LETTER EPSILON WITH PSILI AND OXIA",
	"GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA",
	"GREEK CAPITAL LETTER EPSILON WITH PSILI",
	"GREEK CAPITAL LETTER EPSILON WITH DASIA",
	"GREEK CAPITAL LETTER EPSILON WITH PSILI AND VARIA",
	"GREEK CAPITAL LETTER EPSILON WITH DASIA AND VARIA",
	"GREEK CAPITAL LETTER EPSILON WITH PSILI AND OXIA",
	"GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA",
	"GREEK SMALL LETTER ETA WITH PSILI",
	"GREEK SMALL LETTER ETA WITH DASIA",
	"GREEK SMALL LETTER ETA WITH PSILI AND VARIA",
	"GREEK SMALL LETTER ETA WITH DASIA AND VARIA",
	"GREEK SMALL LETTER ETA WITH PSILI AND OXIA",
	"GREEK SMALL LETTER ETA WITH DASIA AND OXIA",
	"GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI",
	"GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI",
	"GREEK CAPITAL LETTER ETA WITH PSILI",
	"GREEK CAPITAL LETTER ETA WITH DASIA",
	"GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA",
	"GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA",
	"GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA",
	"GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA",
	"GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI",
	"GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI",
	"GREEK SMALL LETTER IOTA WITH PSILI",
	"GREEK SMALL LETTER IOTA WITH DASIA",
	"GREEK SMALL LETTER IOTA WITH PSILI AND VARIA",
	"GREEK SMALL LETTER IOTA WITH DASIA AND VARIA",
	"GREEK SMALL LETTER IOTA WITH PSILI AND OXIA",
	"GREEK SMALL LETTER IOTA WITH DASIA AND OXIA",
	"GREEK SMALL LETTER IOTA WITH PSILI AND PERISPOMENI",
	"GREEK SMALL LETTER IOTA WITH DASIA AND PERISPOMENI",
	"GREEK CAPITAL LETTER IOTA WITH PSILI",
	"GREEK CAPITAL LETTER IOTA WITH DASIA",
	"GREEK CAPITAL LETTER IOTA WITH PSILI AND VARIA",
	"GREEK CAPITAL LETTER IOTA WITH DASIA AND VARIA",
	"GREEK CAPITAL LETTER IOTA WITH PSILI AND OXIA",
	"GREEK CAPITAL LETTER IOTA WITH DASIA AND OXIA",
	"GREEK CAPITAL LETTER IOTA WITH PSILI AND PERISPOMENI",
	"GREEK CAPITAL LETTER IOTA WITH DASIA AND PERISPOMENI",
	"GREEK SMALL LETTER OMICRON WITH PSILI",
	"GREEK SMALL LETTER OMICRON WITH DASIA",
	"GREEK SMALL LETTER OMICRON WITH PSILI AND VARIA",
	"GREEK SMALL LETTER OMICRON WITH DASIA AND VARIA",
	"GREEK SMALL LETTER OMICRON WITH PSILI AND OXIA",
	"GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA",
	"GREEK CAPITAL LETTER OMICRON WITH PSILI",
	"GREEK CAPITAL LETTER OMICRON WITH DASIA",
	"GREEK CAPITAL LETTER OMICRON WITH PSILI AND VARIA",
	"GREEK CAPITAL LETTER OMICRON WITH DASIA AND VARIA",
	"GREEK CAPITAL LETTER OMICRON WITH PSILI AND OXIA",
	"GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA",
	"GREEK SMALL LETTER UPSILON WITH PSILI",
	"GREEK SMALL LETTER UPSILON WITH DASIA",
	"GREEK SMALL LETTER UPSILON WITH PSILI AND VARIA",
	"GREEK SMALL LETTER UPSILON WITH DASIA AND VARIA",
	"GREEK SMALL LETTER UPSILON WITH PSILI AND OXIA",
	"GREEK SMALL LETTER UPSILON WITH DASIA AND OXIA",
	"GREEK SMALL LETTER UPSILON WITH PSILI AND PERISPOMENI",
	"GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI",
	"GREEK CAPITAL LETTER UPSILON WITH DASIA",
	"GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA",
	"GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA",
	"GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI",
	"GREEK SMALL LETTER OMEGA WITH PSILI",
	"GREEK SMALL LETTER OMEGA WITH DASIA",
	"GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA",
	"GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA",
	"GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA",
	"GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA",
	"GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI",
	"GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI",
	"GREEK CAPITAL LETTER OMEGA WITH PSILI",
	"GREEK CAPITAL LETTER OMEGA WITH DASIA",
	"GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA",
	"GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA",
	"GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA",
	"GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA",
	"GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI",
	"GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI",
	"GREEK SMALL LETTER ALPHA WITH VARIA",
	"GREEK SMALL LETTER ALPHA WITH OXIA",
	"GREEK SMALL LETTER EPSILON WITH VARIA",
	"GREEK SMALL LETTER EPSILON WITH OXIA",
	"GREEK SMALL LETTER ETA WITH VARIA",
	"GREEK SMALL LETTER ETA WITH OXIA",
	"GREEK SMALL LETTER IOTA WITH VARIA",
	"GREEK SMALL LETTER IOTA WITH OXIA",
	"GREEK SMALL LETTER OMICRON WITH VARIA",
	"GREEK SMALL LETTER OMICRON WITH OXIA",
	"GREEK SMALL LETTER UPSILON WITH VARIA",
	"GREEK SMALL LETTER UPSILON WITH OXIA",
	"GREEK SMALL LETTER OMEGA WITH VARIA",
	"GREEK SMALL LETTER OMEGA WITH OXIA",
	"GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI",
	"GREEK SMALL LETTER ALPHA WITH DASIA AND YPOGEGRAMMENI",
	"GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA AND YPOGEGRAMMENI",
	"GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA AND YPOGEGRAMMENI",
	"GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA AND YPOGEGRAMMENI",
	"GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA AND YPOGEGRAMMENI",
	"GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI",
	"GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI",
	"GREEK CAPITAL LETTER ALPHA WITH PSILI AND PROSGEGRAMMENI",
	"GREEK CAPITAL LETTER ALPHA WITH DASIA AND PROSGEGRAMMENI",
	"GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA AND PROSGEGRAMMENI",
	"GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA AND PROSGEGRAMMENI",
	"GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA AND PROSGEGRAMMENI",
	"GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA AND PROSGEGRAMMENI",
	"GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI",
	"GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI",
	"GREEK SMALL LETTER ETA WITH PSILI AND YPOGEGRAMMENI",
	"GREEK SMALL LETTER ETA WITH DASIA AND YPOGEGRAMMENI",
	"GREEK SMALL LETTER ETA WITH PSILI AND VARIA AND YPOGEGRAMMENI",
	"GREEK SMALL LETTER ETA WITH DASIA AND VARIA AND YPOGEGRAMMENI",
	"GREEK SMALL LETTER ETA WITH PSILI AND OXIA AND YPOGEGRAMMENI",
	"GREEK SMALL LETTER ETA WITH DASIA AND OXIA AND YPOGEGRAMMENI",
	"GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI",
	"GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI",
	"GREEK CAPITAL LETTER ETA WITH PSILI AND PROSGEGRAMMENI",
	"GREEK CAPITAL LETTER ETA WITH DASIA AND PROSGEGRAMMENI",
	"GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA AND PROSGEGRAMMENI",
	"GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA AND PROSGEGRAMMENI",
	"GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA AND PROSGEGRAMMENI",
	"GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA AND PROSGEGRAMMENI",
	"GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI",
	"GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI",
	"GREEK SMALL LETTER OMEGA WITH PSILI AND YPOGEGRAMMENI",
	"GREEK SMALL LETTER OMEGA WITH DASIA AND YPOGEGRAMMENI",
	"GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA AND YPOGEGRAMMENI",
	"GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA AND YPOGEGRAMMENI",
	"GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA AND YPOGEGRAMMENI",
	"GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA AND YPOGEGRAMMENI",
	"GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI",
	"GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI",
	"GREEK CAPITAL LETTER OMEGA WITH PSILI AND PROSGEGRAMMENI",
	"GREEK CAPITAL LETTER OMEGA WITH DASIA AND PROSGEGRAMMENI",
	"GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA AND PROSGEGRAMMENI",
	"GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA AND PROSGEGRAMMENI",
	"GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA AND PROSGEGRAMMENI",
	"GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA AND PROSGEGRAMMENI",
	"GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI",
	"GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI",
	"GREEK SMALL LETTER ALPHA WITH VRACHY",
	"GREEK SMALL LETTER ALPHA WITH MACRON",
	"GREEK SMALL LETTER ALPHA WITH VARIA AND YPOGEGRAMMENI",
	"GREEK SMALL LETTER ALPHA WITH YPOGEGRAMMENI",
	"GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI",
	"GREEK SMALL LETTER ALPHA WITH PERISPOMENI",
	"GREEK SMALL LETTER ALPHA WITH PERISPOMENI AND YPOGEGRAMMENI",
	"GREEK CAPITAL LETTER ALPHA WITH VRACHY",
	"GREEK CAPITAL LETTER ALPHA WITH MACRON",
	"GREEK CAPITAL LETTER ALPHA WITH VARIA",
	"GREEK CAPITAL LETTER ALPHA WITH OXIA",
	"GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI",
	"GREEK KORONIS",
	"GREEK PROSGEGRAMMENI",
	"GREEK PSILI",
	"GREEK PERISPOMENI",
	"GREEK DIALYTIKA AND PERISPOMENI",
	"GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI",
	"GREEK SMALL LETTER ETA WITH YPOGEGRAMMENI",
	"GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI",
	"GREEK SMALL LETTER ETA WITH PERISPOMENI",
	"GREEK SMALL LETTER ETA WITH PERISPOMENI AND YPOGEGRAMMENI",
	"GREEK CAPITAL LETTER EPSILON WITH VARIA",
	"GREEK CAPITAL LETTER EPSILON WITH OXIA",
	"GREEK CAPITAL LETTER ETA WITH VARIA",
	"GREEK CAPITAL LETTER ETA WITH OXIA",
	"GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI",
	"GREEK PSILI AND VARIA",
	"GREEK PSILI AND OXIA",
	"GREEK PSILI AND PERISPOMENI",
	"GREEK SMALL LETTER IOTA WITH VRACHY",
	"GREEK SMALL LETTER IOTA WITH MACRON",
	"GREEK SMALL LETTER IOTA WITH DIALYTIKA AND VARIA",
	"GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA",
	"GREEK SMALL LETTER IOTA WITH PERISPOMENI",
	"GREEK SMALL LETTER IOTA WITH DIALYTIKA AND PERISPOMENI",
	"GREEK CAPITAL LETTER IOTA WITH VRACHY",
	"GREEK CAPITAL LETTER IOTA WITH MACRON",
	"GREEK CAPITAL LETTER IOTA WITH VARIA",
	"GREEK CAPITAL LETTER IOTA WITH OXIA",
	"GREEK DASIA AND VARIA",
	"GREEK DASIA AND OXIA",
	"GREEK DASIA AND PERISPOMENI",
	"GREEK SMALL LETTER UPSILON WITH VRACHY",
	"GREEK SMALL LETTER UPSILON WITH MACRON",
	"GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND VARIA",
	"GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND OXIA",
	"GREEK SMALL LETTER RHO WITH PSILI",
	"GREEK SMALL LETTER RHO WITH DASIA",
	"GREEK SMALL LETTER UPSILON WITH PERISPOMENI",
	"GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND PERISPOMENI",
	"GREEK CAPITAL LETTER UPSILON WITH VRACHY",
	"GREEK CAPITAL LETTER UPSILON WITH MACRON",
	"GREEK CAPITAL LETTER UPSILON WITH VARIA",
	"GREEK CAPITAL LETTER UPSILON WITH OXIA",
	"GREEK CAPITAL LETTER RHO WITH DASIA",
	"GREEK DIALYTIKA AND VARIA",
	"GREEK DIALYTIKA AND OXIA",
	"GREEK VARIA",
	"GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI",
	"GREEK SMALL LETTER OMEGA WITH YPOGEGRAMMENI",
	"GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI",
	"GREEK SMALL LETTER OMEGA WITH PERISPOMENI",
	"GREEK SMALL LETTER OMEGA WITH PERISPOMENI AND YPOGEGRAMMENI",
	"GREEK CAPITAL LETTER OMICRON WITH VARIA",
	"GREEK CAPITAL LETTER OMICRON WITH OXIA",
	"GREEK CAPITAL LETTER OMEGA WITH VARIA",
	"GREEK CAPITAL LETTER OMEGA WITH OXIA",
	"GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI",
	"GREEK OXIA",
	"GREEK DASIA",
	"EN QUAD",
	"EM QUAD",
	"EN SPACE",
	"EM SPACE",
	"THREE-PER-EM SPACE",
	"FOUR-PER-EM SPACE",
	"SIX-PER-EM SPACE",
	"FIGURE SPACE",
	"PUNCTUATION SPACE",
	"THIN SPACE",
	"HAIR SPACE",
	"ZERO WIDTH SPACE",
	"ZERO WIDTH NON-JOINER",
	"ZERO WIDTH JOINER",
	"LEFT-TO-RIGHT MARK",
	"RIGHT-TO-LEFT MARK",
	"HYPHEN",
	"NON-BREAKING HYPHEN",
	"FIGURE DASH",
	"EN DASH",
	"EM DASH",
	"HORIZONTAL BAR",
	"DOUBLE VERTICAL LINE",
	"DOUBLE LOW LINE",
	"LEFT SINGLE QUOTATION MARK",
	"RIGHT SINGLE QUOTATION MARK",
	"SINGLE LOW-9 QUOTATION MARK",
	"SINGLE HIGH-REVERSED-9 QUOTATION MARK",
	"LEFT DOUBLE QUOTATION MARK",
	"RIGHT DOUBLE QUOTATION MARK",
	"DOUBLE LOW-9 QUOTATION MARK",
	"DOUBLE HIGH-REVERSED-9 QUOTATION MARK",
	"DAGGER",
	"DOUBLE DAGGER",
	"BULLET",
	"TRIANGULAR BULLET",
	"ONE DOT LEADER",
	"TWO DOT LEADER",
	"HORIZONTAL ELLIPSIS",
	"HYPHENATION POINT",
	"LINE SEPARATOR",
	"PARAGRAPH SEPARATOR",
	"LEFT-TO-RIGHT EMBEDDING",
	"RIGHT-TO-LEFT EMBEDDING",
	"POP DIRECTIONAL FORMATTING",
	"LEFT-TO-RIGHT OVERRIDE",
	"RIGHT-TO-LEFT OVERRIDE",
	"NARROW NO-BREAK SPACE",
	"PER MILLE SIGN",
	"PER TEN THOUSAND SIGN",
	"PRIME",
	"DOUBLE PRIME",
	"TRIPLE PRIME",
	"REVERSED PRIME",
	"REVERSED DOUBLE PRIME",
	"REVERSED TRIPLE PRIME",
	"CARET",
	"SINGLE LEFT-POINTING ANGLE QUOTATION MARK",
	"SINGLE RIGHT-POINTING ANGLE QUOTATION MARK",
	"REFERENCE MARK",
	"DOUBLE EXCLAMATION MARK",
	"INTERROBANG",
	"OVERLINE",
	"UNDERTIE",
	"CHARACTER TIE",
	"CARET INSERTION POINT",
	"ASTERISM",
	"HYPHEN BULLET",
	"FRACTION SLASH",
	"LEFT SQUARE BRACKET WITH QUILL",
	"RIGHT SQUARE BRACKET WITH QUILL",
	"DOUBLE QUESTION MARK",
	"QUESTION EXCLAMATION MARK",
	"EXCLAMATION QUESTION MARK",
	"TIRONIAN SIGN ET",
	"REVERSED PILCROW SIGN",
	"BLACK LEFTWARDS BULLET",
	"BLACK RIGHTWARDS BULLET",
	"LOW ASTERISK",
	"REVERSED SEMICOLON",
	"CLOSE UP",
	"TWO ASTERISKS ALIGNED VERTICALLY",
	"COMMERCIAL MINUS SIGN",
	"SWUNG DASH",
	"INVERTED UNDERTIE",
	"FLOWER PUNCTUATION MARK",
	"THREE DOT PUNCTUATION",
	"QUADRUPLE PRIME",
	"FOUR DOT PUNCTUATION",
	"FIVE DOT PUNCTUATION",
	"TWO DOT PUNCTUATION",
	"FOUR DOT MARK",
	"DOTTED CROSS",
	"TRICOLON",
	"VERTICAL FOUR DOTS",
	"MEDIUM MATHEMATICAL SPACE",
	"WORD JOINER",
	"FUNCTION APPLICATION",
	"INVISIBLE TIMES",
	"INVISIBLE SEPARATOR",
	"INVISIBLE PLUS",
	"LEFT-TO-RIGHT ISOLATE",
	"RIGHT-TO-LEFT ISOLATE",
	"FIRST STRONG ISOLATE",
	"POP DIRECTIONAL ISOLATE",
	"INHIBIT SYMMETRIC SWAPPING",
	"ACTIVATE SYMMETRIC SWAPPING",
	"INHIBIT ARABIC FORM SHAPING",
	"ACTIVATE ARABIC FORM SHAPING",
	"NATIONAL DIGIT SHAPES",
	"NOMINAL DIGIT SHAPES",
	"SUPERSCRIPT ZERO",
	"SUPERSCRIPT LATIN SMALL LETTER I",
	"SUPERSCRIPT FOUR",
	"SUPERSCRIPT FIVE",
	"SUPERSCRIPT SIX",
	"SUPERSCRIPT SEVEN",
	"SUPERSCRIPT EIGHT",
	"SUPERSCRIPT NINE",
	"SUPERSCRIPT PLUS SIGN",
	"SUPERSCRIPT MINUS",
	"SUPERSCRIPT EQUALS SIGN",
	"SUPERSCRIPT LEFT PARENTHESIS",
	"SUPERSCRIPT RIGHT PARENTHESIS",
	"SUPERSCRIPT LATIN SMALL LETTER N",
	"SUBSCRIPT ZERO",
	"SUBSCRIPT ONE",
	"SUBSCRIPT TWO",
	"SUBSCRIPT THREE",
	"SUBSCRIPT FOUR",
	"SUBSCRIPT FIVE",
	"SUBSCRIPT SIX",
	"SUBSCRIPT SEVEN",
	"SUBSCRIPT EIGHT",
	"SUBSCRIPT NINE",
	"SUBSCRIPT PLUS SIGN",
	"SUBSCRIPT MINUS",
	"SUBSCRIPT EQUALS SIGN",
	"SUBSCRIPT LEFT PARENTHESIS",
	"SUBSCRIPT RIGHT PARENTHESIS",
	"LATIN SUBSCRIPT SMALL LETTER A",
	"LATIN SUBSCRIPT SMALL LETTER E",
	"LATIN SUBSCRIPT SMALL LETTER O",
	"LATIN SUBSCRIPT SMALL LETTER X",
	"LATIN SUBSCRIPT SMALL LETTER SCHWA",
	"LATIN SUBSCRIPT SMALL LETTER H",
	"LATIN SUBSCRIPT SMALL LETTER K",
	"LATIN SUBSCRIPT SMALL LETTER L",
	"LATIN SUBSCRIPT SMALL LETTER M",
	"LATIN SUBSCRIPT SMALL LETTER N",
	"LATIN SUBSCRIPT SMALL LETTER P",
	"LATIN SUBSCRIPT SMALL LETTER S",
	"LATIN SUBSCRIPT SMALL LETTER T",
	"EURO-CURRENCY SIGN",
	"COLON SIGN",
	"CRUZEIRO SIGN",
	"FRENCH FRANC SIGN",
	"LIRA SIGN",
	"MILL SIGN",
	"NAIRA SIGN",
	"PESETA SIGN",
	"RUPEE SIGN",
	"WON SIGN",
	"NEW SHEQEL SIGN",
	"DONG SIGN",
	"EURO SIGN",
	"KIP SIGN",
	"TUGRIK SIGN",
	"DRACHMA SIGN",
	"GERMAN PENNY SIGN",
	"PESO SIGN",
	"GUARANI SIGN",
	"AUSTRAL SIGN",
	"HRYVNIA SIGN",
	"CEDI SIGN",
	"LIVRE TOURNOIS SIGN",
	"SPESMILO SIGN",
	"TENGE SIGN",
	"INDIAN RUPEE SIGN",
	"TURKISH LIRA SIGN",
	"NORDIC MARK SIGN",
	"MANAT SIGN",
	"RUBLE SIGN",
	"LARI SIGN",
	"BITCOIN SIGN",
	"SOM SIGN",
	"COMBINING LEFT HARPOON ABOVE",
	"COMBINING RIGHT HARPOON ABOVE",
	"COMBINING LONG VERTICAL LINE OVERLAY",
	"COMBINING SHORT VERTICAL LINE OVERLAY",
	"COMBINING ANTICLOCKWISE ARROW ABOVE",
	"COMBINING CLOCKWISE ARROW ABOVE",
	"COMBINING LEFT ARROW ABOVE",
	"COMBINING RIGHT ARROW ABOVE",
	"COMBINING RING OVERLAY",
	"COMBINING CLOCKWISE RING OVERLAY",
	"COMBINING ANTICLOCKWISE RING OVERLAY",
	"COMBINING THREE DOTS ABOVE",
	"COMBINING FOUR DOTS ABOVE",
	"COMBINING ENCLOSING CIRCLE",
	"COMBINING ENCLOSING SQUARE",
	"COMBINING ENCLOSING DIAMOND",
	"COMBINING ENCLOSING CIRCLE BACKSLASH",
	"COMBINING LEFT RIGHT ARROW ABOVE",
	"COMBINING ENCLOSING SCREEN",
	"COMBINING ENCLOSING KEYCAP",
	"COMBINING ENCLOSING UPWARD POINTING TRIANGLE",
	"COMBINING REVERSE SOLIDUS OVERLAY",
	"COMBINING DOUBLE VERTICAL STROKE OVERLAY",
	"COMBINING ANNUITY SYMBOL",
	"COMBINING TRIPLE UNDERDOT",
	"COMBINING WIDE BRIDGE ABOVE",
	"COMBINING LEFTWARDS ARROW OVERLAY",
	"COMBINING LONG DOUBLE SOLIDUS OVERLAY",
	"COMBINING RIGHTWARDS HARPOON WITH BARB DOWNWARDS",
	"COMBINING LEFTWARDS HARPOON WITH BARB DOWNWARDS",
	"COMBINING LEFT ARROW BELOW",
	"COMBINING RIGHT ARROW BELOW",
	"COMBINING ASTERISK ABOVE",
	"ACCOUNT OF",
	"ADDRESSED TO THE SUBJECT",
	"DOUBLE-STRUCK CAPITAL C",
	"DEGREE CELSIUS",
	"CENTRE LINE SYMBOL",
	"CARE OF",
	"CADA UNA",
	"EULER CONSTANT",
	"SCRUPLE",
	"DEGREE FAHRENHEIT",
	"SCRIPT SMALL G",
	"SCRIPT CAPITAL H",
	"BLACK-LETTER CAPITAL H",
	"DOUBLE-STRUCK CAPITAL H",
	"PLANCK CONSTANT",
	"PLANCK CONSTANT OVER TWO PI",
	"SCRIPT CAPITAL I",
	"BLACK-LETTER CAPITAL I",
	"SCRIPT CAPITAL L",
	"SCRIPT SMALL L",
	"L B BAR SYMBOL",
	"DOUBLE-STRUCK CAPITAL N",
	"NUMERO SIGN",
	"SOUND RECORDING COPYRIGHT",
	"SCRIPT CAPITAL P",
	"DOUBLE-STRUCK CAPITAL P",
	"DOUBLE-STRUCK CAPITAL Q",
	"SCRIPT CAPITAL R",
	"BLACK-LETTER CAPITAL R",
	"DOUBLE-STRUCK CAPITAL R",
	"PRESCRIPTION TAKE",
	"RESPONSE",
	"SERVICE MARK",
	"TELEPHONE SIGN",
	"TRADE MARK SIGN",
	"VERSICLE",
	"DOUBLE-STRUCK CAPITAL Z",
	"OUNCE SIGN",
	"OHM SIGN",
	"INVERTED OHM SIGN",
	"BLACK-LETTER CAPITAL Z",
	"TURNED GREEK SMALL LETTER IOTA",
	"KELVIN SIGN",
	"ANGSTROM SIGN",
	"SCRIPT CAPITAL B",
	"BLACK-LETTER CAPITAL C",
	"ESTIMATED SYMBOL",
	"SCRIPT SMALL E",
	"SCRIPT CAPITAL E",
	"SCRIPT CAPITAL F",
	"TURNED CAPITAL F",
	"SCRIPT CAPITAL M",
	"SCRIPT SMALL O",
	"ALEF SYMBOL",
	"BET SYMBOL",
	"GIMEL SYMBOL",
	"DALET SYMBOL",
	"INFORMATION SOURCE",
	"ROTATED CAPITAL Q",
	"FACSIMILE SIGN",
	"DOUBLE-STRUCK SMALL PI",
	"DOUBLE-STRUCK SMALL GAMMA",
	"DOUBLE-STRUCK CAPITAL GAMMA",
	"DOUBLE-STRUCK CAPITAL PI",
	"DOUBLE-STRUCK N-ARY SUMMATION",
	"TURNED SANS-SERIF CAPITAL G",
	"TURNED SANS-SERIF CAPITAL L",
	"REVERSED SANS-SERIF CAPITAL L",
	"TURNED SANS-SERIF CAPITAL Y",
	"DOUBLE-STRUCK ITALIC CAPITAL D",
	"DOUBLE-STRUCK ITALIC SMALL D",
	"DOUBLE-STRUCK ITALIC SMALL E",
	"DOUBLE-STRUCK ITALIC SMALL I",
	"DOUBLE-STRUCK ITALIC SMALL J",
	"PROPERTY LINE",
	"TURNED AMPERSAND",
	"PER SIGN",
	"AKTIESELSKAB",
	"TURNED SMALL F",
	"SYMBOL FOR SAMARITAN SOURCE",
	"VULGAR FRACTION ONE SEVENTH",
	"VULGAR FRACTION ONE NINTH",
	"VULGAR FRACTION ONE TENTH",
	"VULGAR FRACTION ONE THIRD",
	"VULGAR FRACTION TWO THIRDS",
	"VULGAR FRACTION ONE FIFTH",
	"VULGAR FRACTION TWO FIFTHS",
	"VULGAR FRACTION THREE FIFTHS",
	"VULGAR FRACTION FOUR FIFTHS",
	"VULGAR FRACTION ONE SIXTH",
	"VULGAR FRACTION FIVE SIXTHS",
	"VULGAR FRACTION ONE EIGHTH",
	"VULGAR FRACTION THREE EIGHTHS",
	"VULGAR FRACTION FIVE EIGHTHS",
	"VULGAR FRACTION SEVEN EIGHTHS",
	"FRACTION NUMERATOR ONE",
	"ROMAN NUMERAL ONE",
	"ROMAN NUMERAL TWO",
	"ROMAN NUMERAL THREE",
	"ROMAN NUMERAL FOUR",
	"ROMAN NUMERAL FIVE",
	"ROMAN NUMERAL SIX",
	"ROMAN NUMERAL SEVEN",
	"ROMAN NUMERAL EIGHT",
	"ROMAN NUMERAL NINE",
	"ROMAN NUMERAL TEN",
	"ROMAN NUMERAL ELEVEN",
	"ROMAN NUMERAL TWELVE",
	"ROMAN NUMERAL FIFTY",
	"ROMAN NUMERAL ONE HUNDRED",
	"ROMAN NUMERAL FIVE HUNDRED",
	"ROMAN NUMERAL ONE THOUSAND",
	"SMALL ROMAN NUMERAL ONE",
	"SMALL ROMAN NUMERAL TWO",
	"SMALL ROMAN NUMERAL THREE",
	"SMALL ROMAN NUMERAL FOUR",
	"SMALL ROMAN NUMERAL FIVE",
	"SMALL ROMAN NUMERAL SIX",
	"SMALL ROMAN NUMERAL SEVEN",
	"SMALL ROMAN NUMERAL EIGHT",
	"SMALL ROMAN NUMERAL NINE",
	"SMALL ROMAN NUMERAL TEN",
	"SMALL ROMAN NUMERAL ELEVEN",
	"SMALL ROMAN NUMERAL TWELVE",
	"SMALL ROMAN NUMERAL FIFTY",
	"SMALL ROMAN NUMERAL ONE HUNDRED",
	"SMALL ROMAN NUMERAL FIVE HUNDRED",
	"SMALL ROMAN NUMERAL ONE THOUSAND",
	"ROMAN NUMERAL ONE THOUSAND C D",
	"ROMAN NUMERAL FIVE THOUSAND",
	"ROMAN NUMERAL TEN THOUSAND",
	"ROMAN NUMERAL REVERSED ONE HUNDRED",
	"LATIN SMALL LETTER REVERSED C",
	"ROMAN NUMERAL SIX LATE FORM",
	"ROMAN NUMERAL FIFTY EARLY FORM",
	"ROMAN NUMERAL FIFTY THOUSAND",
	"ROMAN NUMERAL ONE HUNDRED THOUSAND",
	"VULGAR FRACTION ZERO THIRDS",
	"TURNED DIGIT TWO",
	"TURNED DIGIT THREE",
	"LEFTWARDS ARROW",
	"UPWARDS ARROW",
	"RIGHTWARDS ARROW",
	"DOWNWARDS ARROW",
	"LEFT RIGHT ARROW",
	"UP DOWN ARROW",
	"NORTH WEST ARROW",
	"NORTH EAST ARROW",
	"SOUTH EAST ARROW",
	"SOUTH WEST ARROW",
	"LEFTWARDS ARROW WITH STROKE",
	"RIGHTWARDS ARROW WITH STROKE",
	"LEFTWARDS WAVE ARROW",
	"RIGHTWARDS WAVE ARROW",
	"LEFTWARDS TWO HEADED ARROW",
	"UPWARDS TWO HEADED ARROW",
	"RIGHTWARDS TWO HEADED ARROW",
	"DOWNWARDS TWO HEADED ARROW",
	"LEFTWARDS ARROW WITH TAIL",
	"RIGHTWARDS ARROW WITH TAIL",
	"LEFTWARDS ARROW FROM BAR",
	"UPWARDS ARROW FROM BAR",
	"RIGHTWARDS ARROW FROM BAR",
	"DOWNWARDS ARROW FROM BAR",
	"UP DOWN ARROW WITH BASE",
	"LEFTWARDS ARROW WITH HOOK",
	"RIGHTWARDS ARROW WITH HOOK",
	"LEFTWARDS ARROW WITH LOOP",
	"RIGHTWARDS ARROW WITH LOOP",
	"LEFT RIGHT WAVE ARROW",
	"LEFT RIGHT ARROW WITH STROKE",
	"DOWNWARDS ZIGZAG ARROW",
	"UPWARDS ARROW WITH TIP LEFTWARDS",
	"UPWARDS ARROW WITH TIP RIGHTWARDS",
	"DOWNWARDS ARROW WITH TIP LEFTWARDS",
	"DOWNWARDS ARROW WITH TIP RIGHTWARDS",
	"RIGHTWARDS ARROW WITH CORNER DOWNWARDS",
	"DOWNWARDS ARROW WITH CORNER LEFTWARDS",
	"ANTICLOCKWISE TOP SEMICIRCLE ARROW",
	"CLOCKWISE TOP SEMICIRCLE ARROW",
	"NORTH WEST ARROW TO LONG BAR",
	"LEFTWARDS ARROW TO BAR OVER RIGHTWARDS ARROW TO BAR",
	"ANTICLOCKWISE OPEN CIRCLE ARROW",
	"CLOCKWISE OPEN CIRCLE ARROW",
	"LEFTWARDS HARPOON WITH BARB UPWARDS",
	"LEFTWARDS HARPOON WITH BARB DOWNWARDS",
	"UPWARDS HARPOON WITH BARB RIGHTWARDS",
	"UPWARDS HARPOON WITH BARB LEFTWARDS",
	"RIGHTWARDS HARPOON WITH BARB UPWARDS",
	"RIGHTWARDS HARPOON WITH BARB DOWNWARDS",
	"DOWNWARDS HARPOON WITH BARB RIGHTWARDS",
	"DOWNWARDS HARPOON WITH BARB LEFTWARDS",
	"RIGHTWARDS ARROW OVER LEFTWARDS ARROW",
	"UPWARDS ARROW LEFTWARDS OF DOWNWARDS ARROW",
	"LEFTWARDS ARROW OVER RIGHTWARDS ARROW",
	"LEFTWARDS PAIRED ARROWS",
	"UPWARDS PAIRED ARROWS",
	"RIGHTWARDS PAIRED ARROWS",
	"DOWNWARDS PAIRED ARROWS",
	"LEFTWARDS HARPOON OVER RIGHTWARDS HARPOON",
	"RIGHTWARDS HARPOON OVER LEFTWARDS HARPOON",
	"LEFTWARDS DOUBLE ARROW WITH STROKE",
	"LEFT RIGHT DOUBLE ARROW WITH STROKE",
	"RIGHTWARDS DOUBLE ARROW WITH STROKE",
	"LEFTWARDS DOUBLE ARROW",
	"UPWARDS DOUBLE ARROW",
	"RIGHTWARDS DOUBLE ARROW",
	"DOWNWARDS DOUBLE ARROW",
	"LEFT RIGHT DOUBLE ARROW",
	"UP DOWN DOUBLE ARROW",
	"NORTH WEST DOUBLE ARROW",
	"NORTH EAST DOUBLE ARROW",
	"SOUTH EAST DOUBLE ARROW",
	"SOUTH WEST DOUBLE ARROW",
	"LEFTWARDS TRIPLE ARROW",
	"RIGHTWARDS TRIPLE ARROW",
	"LEFTWARDS SQUIGGLE ARROW",
	"RIGHTWARDS SQUIGGLE ARROW",
	"UPWARDS ARROW WITH DOUBLE STROKE",
	"DOWNWARDS ARROW WITH DOUBLE STROKE",
	"LEFTWARDS DASHED ARROW",
	"UPWARDS DASHED ARROW",
	"RIGHTWARDS DASHED ARROW",
	"DOWNWARDS DASHED ARROW",
	"LEFTWARDS ARROW TO BAR",
	"RIGHTWARDS ARROW TO BAR",
	"LEFTWARDS WHITE ARROW",
	"UPWARDS WHITE ARROW",
	"RIGHTWARDS WHITE ARROW",
	"DOWNWARDS WHITE ARROW",
	"UPWARDS WHITE ARROW FROM BAR",
	"UPWARDS WHITE ARROW ON PEDESTAL",
	"UPWARDS WHITE ARROW ON PEDESTAL WITH HORIZONTAL BAR",
	"UPWARDS WHITE ARROW ON PEDESTAL WITH VERTICAL BAR",
	"UPWARDS WHITE DOUBLE ARROW",
	"UPWARDS WHITE DOUBLE ARROW ON PEDESTAL",
	"RIGHTWARDS WHITE ARROW FROM WALL",
	"NORTH WEST ARROW TO CORNER",
	"SOUTH EAST ARROW TO CORNER",
	"UP DOWN WHITE ARROW",
	"RIGHT ARROW WITH SMALL CIRCLE",
	"DOWNWARDS ARROW LEFTWARDS OF UPWARDS ARROW",
	"THREE RIGHTWARDS ARROWS",
	"LEFTWARDS ARROW WITH VERTICAL STROKE",
	"RIGHTWARDS ARROW WITH VERTICAL STROKE",
	"LEFT RIGHT ARROW WITH VERTICAL STROKE",
	"LEFTWARDS ARROW WITH DOUBLE VERTICAL STROKE",
	"RIGHTWARDS ARROW WITH DOUBLE VERTICAL STROKE",
	"LEFT RIGHT ARROW WITH DOUBLE VERTICAL STROKE",
	"LEFTWARDS OPEN-HEADED ARROW",
	"RIGHTWARDS OPEN-HEADED ARROW",
	"LEFT RIGHT OPEN-HEADED ARROW",
	"FOR ALL",
	"COMPLEMENT",
	"PARTIAL DIFFERENTIAL",
	"THERE EXISTS",
	"THERE DOES NOT EXIST",
	"EMPTY SET",
	"INCREMENT",
	"NABLA",
	"ELEMENT OF",
	"NOT AN ELEMENT OF",
	"SMALL ELEMENT OF",
	"CONTAINS AS MEMBER",
	"DOES NOT CONTAIN AS MEMBER",
	"SMALL CONTAINS AS MEMBER",
	"END OF PROOF",
	"N-ARY PRODUCT",
	"N-ARY COPRODUCT",
	"N-ARY SUMMATION",
	"MINUS SIGN",
	"MINUS-OR-PLUS SIGN",
	"DOT PLUS",
	"DIVISION SLASH",
	"SET MINUS",
	"ASTERISK OPERATOR",
	"RING OPERATOR",
	"BULLET OPERATOR",
	"SQUARE ROOT",
	"CUBE ROOT",
	"FOURTH ROOT",
	"PROPORTIONAL TO",
	"INFINITY",
	"RIGHT ANGLE",
	"ANGLE",
	"MEASURED ANGLE",
	"SPHERICAL ANGLE",
	"DIVIDES",
	"DOES NOT DIVIDE",
	"PARALLEL TO",
	"NOT PARALLEL TO",
	"LOGICAL AND",
	"LOGICAL OR",
	"INTERSECTION",
	"UNION",
	"INTEGRAL",
	"DOUBLE INTEGRAL",
	"TRIPLE INTEGRAL",
	"CONTOUR INTEGRAL",
	"SURFACE INTEGRAL",
	"VOLUME INTEGRAL",
	"CLOCKWISE INTEGRAL",
	"CLOCKWISE CONTOUR INTEGRAL",
	"ANTICLOCKWISE CONTOUR INTEGRAL",
	"THEREFORE",
	"BECAUSE",
	"RATIO",
	"PROPORTION",
	"DOT MINUS",
	"EXCESS",
	"GEOMETRIC PROPORTION",
	"HOMOTHETIC",
	"TILDE OPERATOR",
	"REVERSED TILDE",
	"INVERTED LAZY S",
	"SINE WAVE",
	"WREATH PRODUCT",
	"NOT TILDE",
	"MINUS TILDE",
	"ASYMPTOTICALLY EQUAL TO",
	"NOT ASYMPTOTICALLY EQUAL TO",
	"APPROXIMATELY EQUAL TO",
	"APPROXIMATELY BUT NOT ACTUALLY EQUAL TO",
	"NEITHER APPROXIMATELY NOR ACTUALLY EQUAL TO",
	"ALMOST EQUAL TO",
	"NOT ALMOST EQUAL TO",
	"ALMOST EQUAL OR EQUAL TO",
	"TRIPLE TILDE",
	"ALL EQUAL TO",
	"EQUIVALENT TO",
	"GEOMETRICALLY EQUIVALENT TO",
	"DIFFERENCE BETWEEN",
	"APPROACHES THE LIMIT",
	"GEOMETRICALLY EQUAL TO",
	"APPROXIMATELY EQUAL TO OR THE IMAGE OF",
	"IMAGE OF OR APPROXIMATELY EQUAL TO",
	"COLON EQUALS",
	"EQUALS COLON",
	"RING IN EQUAL TO",
	"RING EQUAL TO",
	"CORRESPONDS TO",
	"ESTIMATES",
	"EQUIANGULAR TO",
	"STAR EQUALS",
	"DELTA EQUAL TO",
	"EQUAL TO BY DEFINITION",
	"MEASURED BY",
	"QUESTIONED EQUAL TO",
	"NOT EQUAL TO",
	"IDENTICAL TO",
	"NOT IDENTICAL TO",
	"STRICTLY EQUIVALENT TO",
	"LESS-THAN OR EQUAL TO",
	"GREATER-THAN OR EQUAL TO",
	"LESS-THAN OVER EQUAL TO",
	"GREATER-THAN OVER EQUAL TO",
	"LESS-THAN BUT NOT EQUAL TO",
	"GREATER-THAN BUT NOT EQUAL TO",
	"MUCH LESS-THAN",
	"MUCH GREATER-THAN",
	"BETWEEN",
	"NOT EQUIVALENT TO",
	"NOT LESS-THAN",
	"NOT GREATER-THAN",
	"NEITHER LESS-THAN NOR EQUAL TO",
	"NEITHER GREATER-THAN NOR EQUAL TO",
	"LESS-THAN OR EQUIVALENT TO",
	"GREATER-THAN OR EQUIVALENT TO",
	"NEITHER LESS-THAN NOR EQUIVALENT TO",
	"NEITHER GREATER-THAN NOR EQUIVALENT TO",
	"LESS-THAN OR GREATER-THAN",
	"GREATER-THAN OR LESS-THAN",
	"NEITHER LESS-THAN NOR GREATER-THAN",
	"NEITHER GREATER-THAN NOR LESS-THAN",
	"PRECEDES",
	"SUCCEEDS",
	"PRECEDES OR EQUAL TO",
	"SUCCEEDS OR EQUAL TO",
	"PRECEDES OR EQUIVALENT TO",
	"SUCCEEDS OR EQUIVALENT TO",
	"DOES NOT PRECEDE",
	"DOES NOT SUCCEED",
	"SUBSET OF",
	"SUPERSET OF",
	"NOT A SUBSET OF",
	"NOT A SUPERSET OF",
	"SUBSET OF OR EQUAL TO",
	"SUPERSET OF OR EQUAL TO",
	"NEITHER A SUBSET OF NOR EQUAL TO",
	"NEITHER A SUPERSET OF NOR EQUAL TO",
	"SUBSET OF WITH NOT EQUAL TO",
	"SUPERSET OF WITH NOT EQUAL TO",
	"MULTISET",
	"MULTISET MULTIPLICATION",
	"MULTISET UNION",
	"SQUARE IMAGE OF",
	"SQUARE ORIGINAL OF",
	"SQUARE IMAGE OF OR EQUAL TO",
	"SQUARE ORIGINAL OF OR EQUAL TO",
	"SQUARE CAP",
	"SQUARE CUP",
	"CIRCLED PLUS",
	"CIRCLED MINUS",
	"CIRCLED TIMES",
	"CIRCLED DIVISION SLASH",
	"CIRCLED DOT OPERATOR",
	"CIRCLED RING OPERATOR",
	"CIRCLED ASTERISK OPERATOR",
	"CIRCLED EQUALS",
	"CIRCLED DASH",
	"SQUARED PLUS",
	"SQUARED MINUS",
	"SQUARED TIMES",
	"SQUARED DOT OPERATOR",
	"RIGHT TACK",
	"LEFT TACK",
	"DOWN TACK",
	"UP TACK",
	"ASSERTION",
	"MODELS",
	"TRUE",
	"FORCES",
	"TRIPLE VERTICAL BAR RIGHT TURNSTILE",
	"DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE",
	"DOES NOT PROVE",
	"NOT TRUE",
	"DOES NOT FORCE",
	"NEGATED DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE",
	"PRECEDES UNDER RELATION",
	"SUCCEEDS UNDER RELATION",
	"NORMAL SUBGROUP OF",
	"CONTAINS AS NORMAL SUBGROUP",
	"NORMAL SUBGROUP OF OR EQUAL TO",
	"CONTAINS AS NORMAL SUBGROUP OR EQUAL TO",
	"ORIGINAL OF",
	"IMAGE OF",
	"MULTIMAP",
	"HERMITIAN CONJUGATE MATRIX",
	"INTERCALATE",
	"XOR",
	"NAND",
	"NOR",
	"RIGHT ANGLE WITH ARC",
	"RIGHT TRIANGLE",
	"N-ARY LOGICAL AND",
	"N-ARY LOGICAL OR",
	"N-ARY INTERSECTION",
	"N-ARY UNION",
	"DIAMOND OPERATOR",
	"DOT OPERATOR",
	"STAR OPERATOR",
	"DIVISION TIMES",
	"BOWTIE",
	"LEFT NORMAL FACTOR SEMIDIRECT PRODUCT",
	"RIGHT NORMAL FACTOR SEMIDIRECT PRODUCT",
	"LEFT SEMIDIRECT PRODUCT",
	"RIGHT SEMIDIRECT PRODUCT",
	"REVERSED TILDE EQUALS",
	"CURLY LOGICAL OR",
	"CURLY LOGICAL AND",
	"DOUBLE SUBSET",
	"DOUBLE SUPERSET",
	"DOUBLE INTERSECTION",
	"DOUBLE UNION",
	"PITCHFORK",
	"EQUAL AND PARALLEL TO",
	"LESS-THAN WITH DOT",
	"GREATER-THAN WITH DOT",
	"VERY MUCH LESS-THAN",
	"VERY MUCH GREATER-THAN",
	"LESS-THAN EQUAL TO OR GREATER-THAN",
	"GREATER-THAN EQUAL TO OR LESS-THAN",
	"EQUAL TO OR LESS-THAN",
	"EQUAL TO OR GREATER-THAN",
	"EQUAL TO OR PRECEDES",
	"EQUAL TO OR SUCCEEDS",
	"DOES NOT PRECEDE OR EQUAL",
	"DOES NOT SUCCEED OR EQUAL",
	"NOT SQUARE IMAGE OF OR EQUAL TO",
	"NOT SQUARE ORIGINAL OF OR EQUAL TO",
	"SQUARE IMAGE OF OR NOT EQUAL TO",
	"SQUARE ORIGINAL OF OR NOT EQUAL TO",
	"LESS-THAN BUT NOT EQUIVALENT TO",
	"GREATER-THAN BUT NOT EQUIVALENT TO",
	"PRECEDES BUT NOT EQUIVALENT TO",
	"SUCCEEDS BUT NOT EQUIVALENT TO",
	"NOT NORMAL SUBGROUP OF",
	"DOES NOT CONTAIN AS NORMAL SUBGROUP",
	"NOT NORMAL SUBGROUP OF OR EQUAL TO",
	"DOES NOT CONTAIN AS NORMAL SUBGROUP OR EQUAL",
	"VERTICAL ELLIPSIS",
	"MIDLINE HORIZONTAL ELLIPSIS",
	"UP RIGHT DIAGONAL ELLIPSIS",
	"DOWN RIGHT DIAGONAL ELLIPSIS",
	"ELEMENT OF WITH LONG HORIZONTAL STROKE",
	"ELEMENT OF WITH VERTICAL BAR AT END OF HORIZONTAL STROKE",
	"SMALL ELEMENT OF WITH VERTICAL BAR AT END OF HORIZONTAL STROKE",
	"ELEMENT OF WITH DOT ABOVE",
	"ELEMENT OF WITH OVERBAR",
	"SMALL ELEMENT OF WITH OVERBAR",
	"ELEMENT OF WITH UNDERBAR",
	"ELEMENT OF WITH TWO HORIZONTAL STROKES",
	"CONTAINS WITH LONG HORIZONTAL STROKE",
	"CONTAINS WITH VERTICAL BAR AT END OF HORIZONTAL STROKE",
	"SMALL CONTAINS WITH VERTICAL BAR AT END OF HORIZONTAL STROKE",
	"CONTAINS WITH OVERBAR",
	"SMALL CONTAINS WITH OVERBAR",
	"Z NOTATION BAG MEMBERSHIP",
	"DIAMETER SIGN",
	"ELECTRIC ARROW",
	"HOUSE",
	"UP ARROWHEAD",
	"DOWN ARROWHEAD",
	"PROJECTIVE",
	"PERSPECTIVE",
	"WAVY LINE",
	"LEFT CEILING",
	"RIGHT CEILING",
	"LEFT FLOOR",
	"RIGHT FLOOR",
	"BOTTOM RIGHT CROP",
	"BOTTOM LEFT CROP",
	"TOP RIGHT CROP",
	"TOP LEFT CROP",
	"REVERSED NOT SIGN",
	"SQUARE LOZENGE",
	"ARC",
	"SEGMENT",
	"SECTOR",
	"TELEPHONE RECORDER",
	"POSITION INDICATOR",
	"VIEWDATA SQUARE",
	"PLACE OF INTEREST SIGN",
	"TURNED NOT SIGN",
	"WATCH",
	"HOURGLASS",
	"TOP LEFT CORNER",
	"TOP RIGHT CORNER",
	"BOTTOM LEFT CORNER",
	"BOTTOM RIGHT CORNER",
	"TOP HALF INTEGRAL",
	"BOTTOM HALF INTEGRAL",
	"FROWN",
	"SMILE",
	"UP ARROWHEAD BETWEEN TWO HORIZONTAL BARS",
	"OPTION KEY",
	"ERASE TO THE RIGHT",
	"X IN A RECTANGLE BOX",
	"KEYBOARD",
	"LEFT-POINTING ANGLE BRACKET",
	"RIGHT-POINTING ANGLE BRACKET",
	"ERASE TO THE LEFT",
	"BENZENE RING",
	"CYLINDRICITY",
	"ALL AROUND-PROFILE",
	"SYMMETRY",
	"TOTAL RUNOUT",
	"DIMENSION ORIGIN",
	"CONICAL TAPER",
	"SLOPE",
	"COUNTERBORE",
	"COUNTERSINK",
	"APL FUNCTIONAL SYMBOL I-BEAM",
	"APL FUNCTIONAL SYMBOL SQUISH QUAD",
	"APL FUNCTIONAL SYMBOL QUAD EQUAL",
	"APL FUNCTIONAL SYMBOL QUAD DIVIDE",
	"APL FUNCTIONAL SYMBOL QUAD DIAMOND",
	"APL FUNCTIONAL SYMBOL QUAD JOT",
	"APL FUNCTIONAL SYMBOL QUAD CIRCLE",
	"APL FUNCTIONAL SYMBOL CIRCLE STILE",
	"APL FUNCTIONAL SYMBOL CIRCLE JOT",
	"APL FUNCTIONAL SYMBOL SLASH BAR",
	"APL FUNCTIONAL SYMBOL BACKSLASH BAR",
	"APL FUNCTIONAL SYMBOL QUAD SLASH",
	"APL FUNCTIONAL SYMBOL QUAD BACKSLASH",
	"APL FUNCTIONAL SYMBOL QUAD LESS-THAN",
	"APL FUNCTIONAL SYMBOL QUAD GREATER-THAN",
	"APL FUNCTIONAL SYMBOL LEFTWARDS VANE",
	"APL FUNCTIONAL SYMBOL RIGHTWARDS VANE",
	"APL FUNCTIONAL SYMBOL QUAD LEFTWARDS ARROW",
	"APL FUNCTIONAL SYMBOL QUAD RIGHTWARDS ARROW",
	"APL FUNCTIONAL SYMBOL CIRCLE BACKSLASH",
	"APL FUNCTIONAL SYMBOL DOWN TACK UNDERBAR",
	"APL FUNCTIONAL SYMBOL DELTA STILE",
	"APL FUNCTIONAL SYMBOL QUAD DOWN CARET",
	"APL FUNCTIONAL SYMBOL QUAD DELTA",
	"APL FUNCTIONAL SYMBOL DOWN TACK JOT",
	"APL FUNCTIONAL SYMBOL UPWARDS VANE",
	"APL FUNCTIONAL SYMBOL QUAD UPWARDS ARROW",
	"APL FUNCTIONAL SYMBOL UP TACK OVERBAR",
	"APL FUNCTIONAL SYMBOL DEL STILE",
	"APL FUNCTIONAL SYMBOL QUAD UP CARET",
	"APL FUNCTIONAL SYMBOL QUAD DEL",
	"APL FUNCTIONAL SYMBOL UP TACK JOT",
	"APL FUNCTIONAL SYMBOL DOWNWARDS VANE",
	"APL FUNCTIONAL SYMBOL QUAD DOWNWARDS ARROW",
	"APL FUNCTIONAL SYMBOL QUOTE UNDERBAR",
	"APL FUNCTIONAL SYMBOL DELTA UNDERBAR",
	"APL FUNCTIONAL SYMBOL DIAMOND UNDERBAR",
	"APL FUNCTIONAL SYMBOL JOT UNDERBAR",
	"APL FUNCTIONAL SYMBOL CIRCLE UNDERBAR",
	"APL FUNCTIONAL SYMBOL UP SHOE JOT",
	"APL FUNCTIONAL SYMBOL QUOTE QUAD",
	"APL FUNCTIONAL SYMBOL CIRCLE STAR",
	"APL FUNCTIONAL SYMBOL QUAD COLON",
	"APL FUNCTIONAL SYMBOL UP TACK DIAERESIS",
	"APL FUNCTIONAL SYMBOL DEL DIAERESIS",
	"APL FUNCTIONAL SYMBOL STAR DIAERESIS",
	"APL FUNCTIONAL SYMBOL JOT DIAERESIS",
	"APL FUNCTIONAL SYMBOL CIRCLE DIAERESIS",
	"APL FUNCTIONAL SYMBOL DOWN SHOE STILE",
	"APL FUNCTIONAL SYMBOL LEFT SHOE STILE",
	"APL FUNCTIONAL SYMBOL TILDE DIAERESIS",
	"APL FUNCTIONAL SYMBOL GREATER-THAN DIAERESIS",
	"APL FUNCTIONAL SYMBOL COMMA BAR",
	"APL FUNCTIONAL SYMBOL DEL TILDE",
	"APL FUNCTIONAL SYMBOL ZILDE",
	"APL FUNCTIONAL SYMBOL STILE TILDE",
	"APL FUNCTIONAL SYMBOL SEMICOLON UNDERBAR",
	"APL FUNCTIONAL SYMBOL QUAD NOT EQUAL",
	"APL FUNCTIONAL SYMBOL QUAD QUESTION",
	"APL FUNCTIONAL SYMBOL DOWN CARET TILDE",
	"APL FUNCTIONAL SYMBOL UP CARET TILDE",
	"APL FUNCTIONAL SYMBOL IOTA",
	"APL FUNCTIONAL SYMBOL RHO",
	"APL FUNCTIONAL SYMBOL OMEGA",
	"APL FUNCTIONAL SYMBOL ALPHA UNDERBAR",
	"APL FUNCTIONAL SYMBOL EPSILON UNDERBAR",
	"APL FUNCTIONAL SYMBOL IOTA UNDERBAR",
	"APL FUNCTIONAL SYMBOL OMEGA UNDERBAR",
	"APL FUNCTIONAL SYMBOL ALPHA",
	"NOT CHECK MARK",
	"RIGHT ANGLE WITH DOWNWARDS ZIGZAG ARROW",
	"SHOULDERED OPEN BOX",
	"BELL SYMBOL",
	"VERTICAL LINE WITH MIDDLE DOT",
	"INSERTION SYMBOL",
	"CONTINUOUS UNDERLINE SYMBOL",
	"DISCONTINUOUS UNDERLINE SYMBOL",
	"EMPHASIS SYMBOL",
	"COMPOSITION SYMBOL",
	"WHITE SQUARE WITH CENTRE VERTICAL LINE",
	"ENTER SYMBOL",
	"ALTERNATIVE KEY SYMBOL",
	"HELM SYMBOL",
	"CIRCLED HORIZONTAL BAR WITH NOTCH",
	"CIRCLED TRIANGLE DOWN",
	"BROKEN CIRCLE WITH NORTHWEST ARROW",
	"UNDO SYMBOL",
	"MONOSTABLE SYMBOL",
	"HYSTERESIS SYMBOL",
	"OPEN-CIRCUIT-OUTPUT H-TYPE SYMBOL",
	"OPEN-CIRCUIT-OUTPUT L-TYPE SYMBOL",
	"PASSIVE-PULL-DOWN-OUTPUT SYMBOL",
	"PASSIVE-PULL-UP-OUTPUT SYMBOL",
	"DIRECT CURRENT SYMBOL FORM TWO",
	"SOFTWARE-FUNCTION SYMBOL",
	"APL FUNCTIONAL SYMBOL QUAD",
	"DECIMAL SEPARATOR KEY SYMBOL",
	"PREVIOUS PAGE",
	"NEXT PAGE",
	"PRINT SCREEN SYMBOL",
	"CLEAR SCREEN SYMBOL",
	"LEFT PARENTHESIS UPPER HOOK",
	"LEFT PARENTHESIS EXTENSION",
	"LEFT PARENTHESIS LOWER HOOK",
	"RIGHT PARENTHESIS UPPER HOOK",
	"RIGHT PARENTHESIS EXTENSION",
	"RIGHT PARENTHESIS LOWER HOOK",
	"LEFT SQUARE BRACKET UPPER CORNER",
	"LEFT SQUARE BRACKET EXTENSION",
	"LEFT SQUARE BRACKET LOWER CORNER",
	"RIGHT SQUARE BRACKET UPPER CORNER",
	"RIGHT SQUARE BRACKET EXTENSION",
	"RIGHT SQUARE BRACKET LOWER CORNER",
	"LEFT CURLY BRACKET UPPER HOOK",
	"LEFT CURLY BRACKET MIDDLE PIECE",
	"LEFT CURLY BRACKET LOWER HOOK",
	"CURLY BRACKET EXTENSION",
	"RIGHT CURLY BRACKET UPPER HOOK",
	"RIGHT CURLY BRACKET MIDDLE PIECE",
	"RIGHT CURLY BRACKET LOWER HOOK",
	"INTEGRAL EXTENSION",
	"HORIZONTAL LINE EXTENSION",
	"UPPER LEFT OR LOWER RIGHT CURLY BRACKET SECTION",
	"UPPER RIGHT OR LOWER LEFT CURLY BRACKET SECTION",
	"SUMMATION TOP",
	"SUMMATION BOTTOM",
	"TOP SQUARE BRACKET",
	"BOTTOM SQUARE BRACKET",
	"BOTTOM SQUARE BRACKET OVER TOP SQUARE BRACKET",
	"RADICAL SYMBOL BOTTOM",
	"LEFT VERTICAL BOX LINE",
	"RIGHT VERTICAL BOX LINE",
	"HORIZONTAL SCAN LINE-1",
	"HORIZONTAL SCAN LINE-3",
	"HORIZONTAL SCAN LINE-7",
	"HORIZONTAL SCAN LINE-9",
	"DENTISTRY SYMBOL LIGHT VERTICAL AND TOP RIGHT",
	"DENTISTRY SYMBOL LIGHT VERTICAL AND BOTTOM RIGHT",
	"DENTISTRY SYMBOL LIGHT VERTICAL WITH CIRCLE",
	"DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH CIRCLE",
	"DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH CIRCLE",
	"DENTISTRY SYMBOL LIGHT VERTICAL WITH TRIANGLE",
	"DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH TRIANGLE",
	"DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH TRIANGLE",
	"DENTISTRY SYMBOL LIGHT VERTICAL AND WAVE",
	"DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH WAVE",
	"DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH WAVE",
	"DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL",
	"DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL",
	"DENTISTRY SYMBOL LIGHT VERTICAL AND TOP LEFT",
	"DENTISTRY SYMBOL LIGHT VERTICAL AND BOTTOM LEFT",
	"SQUARE FOOT",
	"RETURN SYMBOL",
	"EJECT SYMBOL",
	"VERTICAL LINE EXTENSION",
	"METRICAL BREVE",
	"METRICAL LONG OVER SHORT",
	"METRICAL SHORT OVER LONG",
	"METRICAL LONG OVER TWO SHORTS",
	"METRICAL TWO SHORTS OVER LONG",
	"METRICAL TWO SHORTS JOINED",
	"METRICAL TRISEME",
	"METRICAL TETRASEME",
	"METRICAL PENTASEME",
	"EARTH GROUND",
	"FUSE",
	"TOP PARENTHESIS",
	"BOTTOM PARENTHESIS",
	"TOP CURLY BRACKET",
	"BOTTOM CURLY BRACKET",
	"TOP TORTOISE SHELL BRACKET",
	"BOTTOM TORTOISE SHELL BRACKET",
	"WHITE TRAPEZIUM",
	"BENZENE RING WITH CIRCLE",
	"STRAIGHTNESS",
	"FLATNESS",
	"AC CURRENT",
	"ELECTRICAL INTERSECTION",
	"DECIMAL EXPONENT SYMBOL",
	"BLACK RIGHT-POINTING DOUBLE TRIANGLE",
	"BLACK LEFT-POINTING DOUBLE TRIANGLE",
	"BLACK UP-POINTING DOUBLE TRIANGLE",
	"BLACK DOWN-POINTING DOUBLE TRIANGLE",
	"BLACK RIGHT-POINTING DOUBLE TRIANGLE WITH VERTICAL BAR",
	"BLACK LEFT-POINTING DOUBLE TRIANGLE WITH VERTICAL BAR",
	"BLACK RIGHT-POINTING TRIANGLE WITH DOUBLE VERTICAL BAR",
	"ALARM CLOCK",
	"STOPWATCH",
	"TIMER CLOCK",
	"HOURGLASS WITH FLOWING SAND",
	"BLACK MEDIUM LEFT-POINTING TRIANGLE",
	"BLACK MEDIUM RIGHT-POINTING TRIANGLE",
	"BLACK MEDIUM UP-POINTING TRIANGLE",
	"BLACK MEDIUM DOWN-POINTING TRIANGLE",
	"DOUBLE VERTICAL BAR",
	"BLACK SQUARE FOR STOP",
	"BLACK CIRCLE FOR RECORD",
	"POWER SYMBOL",
	"POWER ON-OFF SYMBOL",
	"POWER ON SYMBOL",
	"POWER SLEEP SYMBOL",
	"OBSERVER EYE SYMBOL",
	"SYMBOL FOR NULL",
	"SYMBOL FOR START OF HEADING",
	"SYMBOL FOR START OF TEXT",
	"SYMBOL FOR END OF TEXT",
	"SYMBOL FOR END OF TRANSMISSION",
	"SYMBOL FOR ENQUIRY",
	"SYMBOL FOR ACKNOWLEDGE",
	"SYMBOL FOR BELL",
	"SYMBOL FOR BACKSPACE",
	"SYMBOL FOR HORIZONTAL TABULATION",
	"SYMBOL FOR LINE FEED",
	"SYMBOL FOR VERTICAL TABULATION",
	"SYMBOL FOR FORM FEED",
	"SYMBOL FOR CARRIAGE RETURN",
	"SYMBOL FOR SHIFT OUT",
	"SYMBOL FOR SHIFT IN",
	"SYMBOL FOR DATA LINK ESCAPE",
	"SYMBOL FOR DEVICE CONTROL ONE",
	"SYMBOL FOR DEVICE CONTROL TWO",
	"SYMBOL FOR DEVICE CONTROL THREE",
	"SYMBOL FOR DEVICE CONTROL FOUR",
	"SYMBOL FOR NEGATIVE ACKNOWLEDGE",
	"SYMBOL FOR SYNCHRONOUS IDLE",
	"SYMBOL FOR END OF TRANSMISSION BLOCK",
	"SYMBOL FOR CANCEL",
	"SYMBOL FOR END OF MEDIUM",
	"SYMBOL FOR SUBSTITUTE",
	"SYMBOL FOR ESCAPE",
	"SYMBOL FOR FILE SEPARATOR",
	"SYMBOL FOR GROUP SEPARATOR",
	"SYMBOL FOR RECORD SEPARATOR",
	"SYMBOL FOR UNIT SEPARATOR",
	"SYMBOL FOR SPACE",
	"SYMBOL FOR DELETE",
	"BLANK SYMBOL",
	"OPEN BOX",
	"SYMBOL FOR NEWLINE",
	"SYMBOL FOR DELETE FORM TWO",
	"SYMBOL FOR SUBSTITUTE FORM TWO",
	"OCR HOOK",
	"OCR CHAIR",
	"OCR FORK",
	"OCR INVERTED FORK",
	"OCR BELT BUCKLE",
	"OCR BOW TIE",
	"OCR BRANCH BANK IDENTIFICATION",
	"OCR AMOUNT OF CHECK",
	"OCR DASH",
	"OCR CUSTOMER ACCOUNT NUMBER",
	"OCR DOUBLE BACKSLASH",
	"CIRCLED DIGIT ONE",
	"CIRCLED DIGIT TWO",
	"CIRCLED DIGIT THREE",
	"CIRCLED DIGIT FOUR",
	"CIRCLED DIGIT FIVE",
	"CIRCLED DIGIT SIX",
	"CIRCLED DIGIT SEVEN",
	"CIRCLED DIGIT EIGHT",
	"CIRCLED DIGIT NINE",
	"CIRCLED NUMBER TEN",
	"CIRCLED NUMBER ELEVEN",
	"CIRCLED NUMBER TWELVE",
	"CIRCLED NUMBER THIRTEEN",
	"CIRCLED NUMBER FOURTEEN",
	"CIRCLED NUMBER FIFTEEN",
	"CIRCLED NUMBER SIXTEEN",
	"CIRCLED NUMBER SEVENTEEN",
	"CIRCLED NUMBER EIGHTEEN",
	"CIRCLED NUMBER NINETEEN",
	"CIRCLED NUMBER TWENTY",
	"PARENTHESIZED DIGIT ONE",
	"PARENTHESIZED DIGIT TWO",
	"PARENTHESIZED DIGIT THREE",
	"PARENTHESIZED DIGIT FOUR",
	"PARENTHESIZED DIGIT FIVE",
	"PARENTHESIZED DIGIT SIX",
	"PARENTHESIZED DIGIT SEVEN",
	"PARENTHESIZED DIGIT EIGHT",
	"PARENTHESIZED DIGIT NINE",
	"PARENTHESIZED NUMBER TEN",
	"PARENTHESIZED NUMBER ELEVEN",
	"PARENTHESIZED NUMBER TWELVE",
	"PARENTHESIZED NUMBER THIRTEEN",
	"PARENTHESIZED NUMBER FOURTEEN",
	"PARENTHESIZED NUMBER FIFTEEN",
	"PARENTHESIZED NUMBER SIXTEEN",
	"PARENTHESIZED NUMBER SEVENTEEN",
	"PARENTHESIZED NUMBER EIGHTEEN",
	"PARENTHESIZED NUMBER NINETEEN",
	"PARENTHESIZED NUMBER TWENTY",
	"DIGIT ONE FULL STOP",
	"DIGIT TWO FULL STOP",
	"DIGIT THREE FULL STOP",
	"DIGIT FOUR FULL STOP",
	"DIGIT FIVE FULL STOP",
	"DIGIT SIX FULL STOP",
	"DIGIT SEVEN FULL STOP",
	"DIGIT EIGHT FULL STOP",
	"DIGIT NINE FULL STOP",
	"NUMBER TEN FULL STOP",
	"NUMBER ELEVEN FULL STOP",
	"NUMBER TWELVE FULL STOP",
	"NUMBER THIRTEEN FULL STOP",
	"NUMBER FOURTEEN FULL STOP",
	"NUMBER FIFTEEN FULL STOP",
	"NUMBER SIXTEEN FULL STOP",
	"NUMBER SEVENTEEN FULL STOP",
	"NUMBER EIGHTEEN FULL STOP",
	"NUMBER NINETEEN FULL STOP",
	"NUMBER TWENTY FULL STOP",
	"PARENTHESIZED LATIN SMALL LETTER A",
	"PARENTHESIZED LATIN SMALL LETTER B",
	"PARENTHESIZED LATIN SMALL LETTER C",
	"PARENTHESIZED LATIN SMALL LETTER D",
	"PARENTHESIZED LATIN SMALL LETTER E",
	"PARENTHESIZED LATIN SMALL LETTER F",
	"PARENTHESIZED LATIN SMALL LETTER G",
	"PARENTHESIZED LATIN SMALL LETTER H",
	"PARENTHESIZED LATIN SMALL LETTER I",
	"PARENTHESIZED LATIN SMALL LETTER J",
	"PARENTHESIZED LATIN SMALL LETTER K",
	"PARENTHESIZED LATIN SMALL LETTER L",
	"PARENTHESIZED LATIN SMALL LETTER M",
	"PARENTHESIZED LATIN SMALL LETTER N",
	"PARENTHESIZED LATIN SMALL LETTER O",
	"PARENTHESIZED LATIN SMALL LETTER P",
	"PARENTHESIZED LATIN SMALL LETTER Q",
	"PARENTHESIZED LATIN SMALL LETTER R",
	"PARENTHESIZED LATIN SMALL LETTER S",
	"PARENTHESIZED LATIN SMALL LETTER T",
	"PARENTHESIZED LATIN SMALL LETTER U",
	"PARENTHESIZED LATIN SMALL LETTER V",
	"PARENTHESIZED LATIN SMALL LETTER W",
	"PARENTHESIZED LATIN SMALL LETTER X",
	"PARENTHESIZED LATIN SMALL LETTER Y",
	"PARENTHESIZED LATIN SMALL LETTER Z",
	"CIRCLED LATIN CAPITAL LETTER A",
	"CIRCLED LATIN CAPITAL LETTER B",
	"CIRCLED LATIN CAPITAL LETTER C",
	"CIRCLED LATIN CAPITAL LETTER D",
	"CIRCLED LATIN CAPITAL LETTER E",
	"CIRCLED LATIN CAPITAL LETTER F",
	"CIRCLED LATIN CAPITAL LETTER G",
	"CIRCLED LATIN CAPITAL LETTER H",
	"CIRCLED LATIN CAPITAL LETTER I",
	"CIRCLED LATIN CAPITAL LETTER J",
	"CIRCLED LATIN CAPITAL LETTER K",
	"CIRCLED LATIN CAPITAL LETTER L",
	"CIRCLED LATIN CAPITAL LETTER M",
	"CIRCLED LATIN CAPITAL LETTER N",
	"CIRCLED LATIN CAPITAL LETTER O",
	"CIRCLED LATIN CAPITAL LETTER P",
	"CIRCLED LATIN CAPITAL LETTER Q",
	"CIRCLED LATIN CAPITAL LETTER R",
	"CIRCLED LATIN CAPITAL LETTER S",
	"CIRCLED LATIN CAPITAL LETTER T",
	"CIRCLED LATIN CAPITAL LETTER U",
	"CIRCLED LATIN CAPITAL LETTER V",
	"CIRCLED LATIN CAPITAL LETTER W",
	"CIRCLED LATIN CAPITAL LETTER X",
	"CIRCLED LATIN CAPITAL LETTER Y",
	"CIRCLED LATIN CAPITAL LETTER Z",
	"CIRCLED LATIN SMALL LETTER A",
	"CIRCLED LATIN SMALL LETTER B",
	"CIRCLED LATIN SMALL LETTER C",
	"CIRCLED LATIN SMALL LETTER D",
	"CIRCLED LATIN SMALL LETTER E",
	"CIRCLED LATIN SMALL LETTER F",
	"CIRCLED LATIN SMALL LETTER G",
	"CIRCLED LATIN SMALL LETTER H",
	"CIRCLED LATIN SMALL LETTER I",
	"CIRCLED LATIN SMALL LETTER J",
	"CIRCLED LATIN SMALL LETTER K",
	"CIRCLED LATIN SMALL LETTER L",
	"CIRCLED LATIN SMALL LETTER M",
	"CIRCLED LATIN SMALL LETTER N",
	"CIRCLED LATIN SMALL LETTER O",
	"CIRCLED LATIN SMALL LETTER P",
	"CIRCLED LATIN SMALL LETTER Q",
	"CIRCLED LATIN SMALL LETTER R",
	"CIRCLED LATIN SMALL LETTER S",
	"CIRCLED LATIN SMALL LETTER T",
	"CIRCLED LATIN SMALL LETTER U",
	"CIRCLED LATIN SMALL LETTER V",
	"CIRCLED LATIN SMALL LETTER W",
	"CIRCLED LATIN SMALL LETTER X",
	"CIRCLED LATIN SMALL LETTER Y",
	"CIRCLED LATIN SMALL LETTER Z",
	"CIRCLED DIGIT ZERO",
	"NEGATIVE CIRCLED NUMBER ELEVEN",
	"NEGATIVE CIRCLED NUMBER TWELVE",
	"NEGATIVE CIRCLED NUMBER THIRTEEN",
	"NEGATIVE CIRCLED NUMBER FOURTEEN",
	"NEGATIVE CIRCLED NUMBER FIFTEEN",
	"NEGATIVE CIRCLED NUMBER SIXTEEN",
	"NEGATIVE CIRCLED NUMBER SEVENTEEN",
	"NEGATIVE CIRCLED NUMBER EIGHTEEN",
	"NEGATIVE CIRCLED NUMBER NINETEEN",
	"NEGATIVE CIRCLED NUMBER TWENTY",
	"DOUBLE CIRCLED DIGIT ONE",
	"DOUBLE CIRCLED DIGIT TWO",
	"DOUBLE CIRCLED DIGIT THREE",
	"DOUBLE CIRCLED DIGIT FOUR",
	"DOUBLE CIRCLED DIGIT FIVE",
	"DOUBLE CIRCLED DIGIT SIX",
	"DOUBLE CIRCLED DIGIT SEVEN",
	"DOUBLE CIRCLED DIGIT EIGHT",
	"DOUBLE CIRCLED DIGIT NINE",
	"DOUBLE CIRCLED NUMBER TEN",
	"NEGATIVE CIRCLED DIGIT ZERO",
	"BOX DRAWINGS LIGHT HORIZONTAL",
	"BOX DRAWINGS HEAVY HORIZONTAL",
	"BOX DRAWINGS LIGHT VERTICAL",
	"BOX DRAWINGS HEAVY VERTICAL",
	"BOX DRAWINGS LIGHT TRIPLE DASH HORIZONTAL",
	"BOX DRAWINGS HEAVY TRIPLE DASH HORIZONTAL",
	"BOX DRAWINGS LIGHT TRIPLE DASH VERTICAL",
	"BOX DRAWINGS HEAVY TRIPLE DASH VERTICAL",
	"BOX DRAWINGS LIGHT QUADRUPLE DASH HORIZONTAL",
	"BOX DRAWINGS HEAVY QUADRUPLE DASH HORIZONTAL",
	"BOX DRAWINGS LIGHT QUADRUPLE DASH VERTICAL",
	"BOX DRAWINGS HEAVY QUADRUPLE DASH VERTICAL",
	"BOX DRAWINGS LIGHT DOWN AND RIGHT",
	"BOX DRAWINGS DOWN LIGHT AND RIGHT HEAVY",
	"BOX DRAWINGS DOWN HEAVY AND RIGHT LIGHT",
	"BOX DRAWINGS HEAVY DOWN AND RIGHT",
	"BOX DRAWINGS LIGHT DOWN AND LEFT",
	"BOX DRAWINGS DOWN LIGHT AND LEFT HEAVY",
	"BOX DRAWINGS DOWN HEAVY AND LEFT LIGHT",
	"BOX DRAWINGS HEAVY DOWN AND LEFT",
	"BOX DRAWINGS LIGHT UP AND RIGHT",
	"BOX DRAWINGS UP LIGHT AND RIGHT HEAVY",
	"BOX DRAWINGS UP HEAVY AND RIGHT LIGHT",
	"BOX DRAWINGS HEAVY UP AND RIGHT",
	"BOX DRAWINGS LIGHT UP AND LEFT",
	"BOX DRAWINGS UP LIGHT AND LEFT HEAVY",
	"BOX DRAWINGS UP HEAVY AND LEFT LIGHT",
	"BOX DRAWINGS HEAVY UP AND LEFT",
	"BOX DRAWINGS LIGHT VERTICAL AND RIGHT",
	"BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY",
	"BOX DRAWINGS UP HEAVY AND RIGHT DOWN LIGHT",
	"BOX DRAWINGS DOWN HEAVY AND RIGHT UP LIGHT",
	"BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT",
	"BOX DRAWINGS DOWN LIGHT AND RIGHT UP HEAVY",
	"BOX DRAWINGS UP LIGHT AND RIGHT DOWN HEAVY",
	"BOX DRAWINGS HEAVY VERTICAL AND RIGHT",
	"BOX DRAWINGS LIGHT VERTICAL AND LEFT",
	"BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY",
	"BOX DRAWINGS UP HEAVY AND LEFT DOWN LIGHT",
	"BOX DRAWINGS DOWN HEAVY AND LEFT UP LIGHT",
	"BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT",
	"BOX DRAWINGS DOWN LIGHT AND LEFT UP HEAVY",
	"BOX DRAWINGS UP LIGHT AND LEFT DOWN HEAVY",
	"BOX DRAWINGS HEAVY VERTICAL AND LEFT",
	"BOX DRAWINGS LIGHT DOWN AND HORIZONTAL",
	"BOX DRAWINGS LEFT HEAVY AND RIGHT DOWN LIGHT",
	"BOX DRAWINGS RIGHT HEAVY AND LEFT DOWN LIGHT",
	"BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY",
	"BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT",
	"BOX DRAWINGS RIGHT LIGHT AND LEFT DOWN HEAVY",
	"BOX DRAWINGS LEFT LIGHT AND RIGHT DOWN HEAVY",
	"BOX DRAWINGS HEAVY DOWN AND HORIZONTAL",
	"BOX DRAWINGS LIGHT UP AND HORIZONTAL",
	"BOX DRAWINGS LEFT HEAVY AND RIGHT UP LIGHT",
	"BOX DRAWINGS RIGHT HEAVY AND LEFT UP LIGHT",
	"BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY",
	"BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT",
	"BOX DRAWINGS RIGHT LIGHT AND LEFT UP HEAVY",
	"BOX DRAWINGS LEFT LIGHT AND RIGHT UP HEAVY",
	"BOX DRAWINGS HEAVY UP AND HORIZONTAL",
	"BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL",
	"BOX DRAWINGS LEFT HEAVY AND RIGHT VERTICAL LIGHT",
	"BOX DRAWINGS RIGHT HEAVY AND LEFT VERTICAL LIGHT",
	"BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY",
	"BOX DRAWINGS UP HEAVY AND DOWN HORIZONTAL LIGHT",
	"BOX DRAWINGS DOWN HEAVY AND UP HORIZONTAL LIGHT",
	"BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT",
	"BOX DRAWINGS LEFT UP HEAVY AND RIGHT DOWN LIGHT",
	"BOX DRAWINGS RIGHT UP HEAVY AND LEFT DOWN LIGHT",
	"BOX DRAWINGS LEFT DOWN HEAVY AND RIGHT UP LIGHT",
	"BOX DRAWINGS RIGHT DOWN HEAVY AND LEFT UP LIGHT",
	"BOX DRAWINGS DOWN LIGHT AND UP HORIZONTAL HEAVY",
	"BOX DRAWINGS UP LIGHT AND DOWN HORIZONTAL HEAVY",
	"BOX DRAWINGS RIGHT LIGHT AND LEFT VERTICAL HEAVY",
	"BOX DRAWINGS LEFT LIGHT AND RIGHT VERTICAL HEAVY",
	"BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL",
	"BOX DRAWINGS LIGHT DOUBLE DASH HORIZONTAL",
	"BOX DRAWINGS HEAVY DOUBLE DASH HORIZONTAL",
	"BOX DRAWINGS LIGHT DOUBLE DASH VERTICAL",
	"BOX DRAWINGS HEAVY DOUBLE DASH VERTICAL",
	"BOX DRAWINGS DOUBLE HORIZONTAL",
	"BOX DRAWINGS DOUBLE VERTICAL",
	"BOX DRAWINGS DOWN SINGLE AND RIGHT DOUBLE",
	"BOX DRAWINGS DOWN DOUBLE AND RIGHT SINGLE",
	"BOX DRAWINGS DOUBLE DOWN AND RIGHT",
	"BOX DRAWINGS DOWN SINGLE AND LEFT DOUBLE",
	"BOX DRAWINGS DOWN DOUBLE AND LEFT SINGLE",
	"BOX DRAWINGS DOUBLE DOWN AND LEFT",
	"BOX DRAWINGS UP SINGLE AND RIGHT DOUBLE",
	"BOX DRAWINGS UP DOUBLE AND RIGHT SINGLE",
	"BOX DRAWINGS DOUBLE UP AND RIGHT",
	"BOX DRAWINGS UP SINGLE AND LEFT DOUBLE",
	"BOX DRAWINGS UP DOUBLE AND LEFT SINGLE",
	"BOX DRAWINGS DOUBLE UP AND LEFT",
	"BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE",
	"BOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLE",
	"BOX DRAWINGS DOUBLE VERTICAL AND RIGHT",
	"BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE",
	"BOX DRAWINGS VERTICAL DOUBLE AND LEFT SINGLE",
	"BOX DRAWINGS DOUBLE VERTICAL AND LEFT",
	"BOX DRAWINGS DOWN SINGLE AND HORIZONTAL DOUBLE",
	"BOX DRAWINGS DOWN DOUBLE AND HORIZONTAL SINGLE",
	"BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL",
	"BOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLE",
	"BOX DRAWINGS UP DOUBLE AND HORIZONTAL SINGLE",
	"BOX DRAWINGS DOUBLE UP AND HORIZONTAL",
	"BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE",
	"BOX DRAWINGS VERTICAL DOUBLE AND HORIZONTAL SINGLE",
	"BOX DRAWINGS DOUBLE VERTICAL AND HORIZONTAL",
	"BOX DRAWINGS LIGHT ARC DOWN AND RIGHT",
	"BOX DRAWINGS LIGHT ARC DOWN AND LEFT",
	"BOX DRAWINGS LIGHT ARC UP AND LEFT",
	"BOX DRAWINGS LIGHT ARC UP AND RIGHT",
	"BOX DRAWINGS LIGHT DIAGONAL UPPER RIGHT TO LOWER LEFT",
	"BOX DRAWINGS LIGHT DIAGONAL UPPER LEFT TO LOWER RIGHT",
	"BOX DRAWINGS LIGHT DIAGONAL CROSS",
	"BOX DRAWINGS LIGHT LEFT",
	"BOX DRAWINGS LIGHT UP",
	"BOX DRAWINGS LIGHT RIGHT",
	"BOX DRAWINGS LIGHT DOWN",
	"BOX DRAWINGS HEAVY LEFT",
	"BOX DRAWINGS HEAVY UP",
	"BOX DRAWINGS HEAVY RIGHT",
	"BOX DRAWINGS HEAVY DOWN",
	"BOX DRAWINGS LIGHT LEFT AND HEAVY RIGHT",
	"BOX DRAWINGS LIGHT UP AND HEAVY DOWN",
	"BOX DRAWINGS HEAVY LEFT AND LIGHT RIGHT",
	"BOX DRAWINGS HEAVY UP AND LIGHT DOWN",
	"UPPER HALF BLOCK",
	"LOWER ONE EIGHTH BLOCK",
	"LOWER ONE QUARTER BLOCK",
	"LOWER THREE EIGHTHS BLOCK",
	"LOWER HALF BLOCK",
	"LOWER FIVE EIGHTHS BLOCK",
	"LOWER THREE QUARTERS BLOCK",
	"LOWER SEVEN EIGHTHS BLOCK",
	"FULL BLOCK",
	"LEFT SEVEN EIGHTHS BLOCK",
	"LEFT THREE QUARTERS BLOCK",
	"LEFT FIVE EIGHTHS BLOCK",
	"LEFT HALF BLOCK",
	"LEFT THREE EIGHTHS BLOCK",
	"LEFT ONE QUARTER BLOCK",
	"LEFT ONE EIGHTH BLOCK",
	"RIGHT HALF BLOCK",
	"LIGHT SHADE",
	"MEDIUM SHADE",
	"DARK SHADE",
	"UPPER ONE EIGHTH BLOCK",
	"RIGHT ONE EIGHTH BLOCK",
	"QUADRANT LOWER LEFT",
	"QUADRANT LOWER RIGHT",
	"QUADRANT UPPER LEFT",
	"QUADRANT UPPER LEFT AND LOWER LEFT AND LOWER RIGHT",
	"QUADRANT UPPER LEFT AND LOWER RIGHT",
	"QUADRANT UPPER LEFT AND UPPER RIGHT AND LOWER LEFT",
	"QUADRANT UPPER LEFT AND UPPER RIGHT AND LOWER RIGHT",
	"QUADRANT UPPER RIGHT",
	"QUADRANT UPPER RIGHT AND LOWER LEFT",
	"QUADRANT UPPER RIGHT AND LOWER LEFT AND LOWER RIGHT",
	"BLACK SQUARE",
	"WHITE SQUARE",
	"WHITE SQUARE WITH ROUNDED CORNERS",
	"WHITE SQUARE CONTAINING BLACK SMALL SQUARE",
	"SQUARE WITH HORIZONTAL FILL",
	"SQUARE WITH VERTICAL FILL",
	"SQUARE WITH ORTHOGONAL CROSSHATCH FILL",
	"SQUARE WITH UPPER LEFT TO LOWER RIGHT FILL",
	"SQUARE WITH UPPER RIGHT TO LOWER LEFT FILL",
	"SQUARE WITH DIAGONAL CROSSHATCH FILL",
	"BLACK SMALL SQUARE",
	"WHITE SMALL SQUARE",
	"BLACK RECTANGLE",
	"WHITE RECTANGLE",
	"BLACK VERTICAL RECTANGLE",
	"WHITE VERTICAL RECTANGLE",
	"BLACK PARALLELOGRAM",
	"WHITE PARALLELOGRAM",
	"BLACK UP-POINTING TRIANGLE",
	"WHITE UP-POINTING TRIANGLE",
	"BLACK UP-POINTING SMALL TRIANGLE",
	"WHITE UP-POINTING SMALL TRIANGLE",
	"BLACK RIGHT-POINTING TRIANGLE",
	"WHITE RIGHT-POINTING TRIANGLE",
	"BLACK RIGHT-POINTING SMALL TRIANGLE",
	"WHITE RIGHT-POINTING SMALL TRIANGLE",
	"BLACK RIGHT-POINTING POINTER",
	"WHITE RIGHT-POINTING POINTER",
	"BLACK DOWN-POINTING TRIANGLE",
	"WHITE DOWN-POINTING TRIANGLE",
	"BLACK DOWN-POINTING SMALL TRIANGLE",
	"WHITE DOWN-POINTING SMALL TRIANGLE",
	"BLACK LEFT-POINTING TRIANGLE",
	"WHITE LEFT-POINTING TRIANGLE",
	"BLACK LEFT-POINTING SMALL TRIANGLE",
	"WHITE LEFT-POINTING SMALL TRIANGLE",
	"BLACK LEFT-POINTING POINTER",
	"WHITE LEFT-POINTING POINTER",
	"BLACK DIAMOND",
	"WHITE DIAMOND",
	"WHITE DIAMOND CONTAINING BLACK SMALL DIAMOND",
	"FISHEYE",
	"LOZENGE",
	"WHITE CIRCLE",
	"DOTTED CIRCLE",
	"CIRCLE WITH VERTICAL FILL",
	"BULLSEYE",
	"BLACK CIRCLE",
	"CIRCLE WITH LEFT HALF BLACK",
	"CIRCLE WITH RIGHT HALF BLACK",
	"CIRCLE WITH LOWER HALF BLACK",
	"CIRCLE WITH UPPER HALF BLACK",
	"CIRCLE WITH UPPER RIGHT QUADRANT BLACK",
	"CIRCLE WITH ALL BUT UPPER LEFT QUADRANT BLACK",
	"LEFT HALF BLACK CIRCLE",
	"RIGHT HALF BLACK CIRCLE",
	"INVERSE BULLET",
	"INVERSE WHITE CIRCLE",
	"UPPER HALF INVERSE WHITE CIRCLE",
	"LOWER HALF INVERSE WHITE CIRCLE",
	"UPPER LEFT QUADRANT CIRCULAR ARC",
	"UPPER RIGHT QUADRANT CIRCULAR ARC",
	"LOWER RIGHT QUADRANT CIRCULAR ARC",
	"LOWER LEFT QUADRANT CIRCULAR ARC",
	"UPPER HALF CIRCLE",
	"LOWER HALF CIRCLE",
	"BLACK LOWER RIGHT TRIANGLE",
	"BLACK LOWER LEFT TRIANGLE",
	"BLACK UPPER LEFT TRIANGLE",
	"BLACK UPPER RIGHT TRIANGLE",
	"WHITE BULLET",
	"SQUARE WITH LEFT HALF BLACK",
	"SQUARE WITH RIGHT HALF BLACK",
	"SQUARE WITH UPPER LEFT DIAGONAL HALF BLACK",
	"SQUARE WITH LOWER RIGHT DIAGONAL HALF BLACK",
	"WHITE SQUARE WITH VERTICAL BISECTING LINE",
	"WHITE UP-POINTING TRIANGLE WITH DOT",
	"UP-POINTING TRIANGLE WITH LEFT HALF BLACK",
	"UP-POINTING TRIANGLE WITH RIGHT HALF BLACK",
	"LARGE CIRCLE",
	"WHITE SQUARE WITH UPPER LEFT QUADRANT",
	"WHITE SQUARE WITH LOWER LEFT QUADRANT",
	"WHITE SQUARE WITH LOWER RIGHT QUADRANT",
	"WHITE SQUARE WITH UPPER RIGHT QUADRANT",
	"WHITE CIRCLE WITH UPPER LEFT QUADRANT",
	"WHITE CIRCLE WITH LOWER LEFT QUADRANT",
	"WHITE CIRCLE WITH LOWER RIGHT QUADRANT",
	"WHITE CIRCLE WITH UPPER RIGHT QUADRANT",
	"UPPER LEFT TRIANGLE",
	"UPPER RIGHT TRIANGLE",
	"LOWER LEFT TRIANGLE",
	"WHITE MEDIUM SQUARE",
	"BLACK MEDIUM SQUARE",
	"WHITE MEDIUM SMALL SQUARE",
	"BLACK MEDIUM SMALL SQUARE",
	"LOWER RIGHT TRIANGLE",
	"BLACK SUN WITH RAYS",
	"CLOUD",
	"UMBRELLA",
	"SNOWMAN",
	"COMET",
	"BLACK STAR",
	"WHITE STAR",
	"LIGHTNING",
	"THUNDERSTORM",
	"SUN",
	"ASCENDING NODE",
	"DESCENDING NODE",
	"CONJUNCTION",
	"OPPOSITION",
	"BLACK TELEPHONE",
	"WHITE TELEPHONE",
	"BALLOT BOX",
	"BALLOT BOX WITH CHECK",
	"BALLOT BOX WITH X",
	"SALTIRE",
	"UMBRELLA WITH RAIN DROPS",
	"HOT BEVERAGE",
	"WHITE SHOGI PIECE",
	"BLACK SHOGI PIECE",
	"SHAMROCK",
	"REVERSED ROTATED FLORAL HEART BULLET",
	"BLACK LEFT POINTING INDEX",
	"BLACK RIGHT POINTING INDEX",
	"WHITE LEFT POINTING INDEX",
	"WHITE UP POINTING INDEX",
	"WHITE RIGHT POINTING INDEX",
	"WHITE DOWN POINTING INDEX",
	"SKULL AND CROSSBONES",
	"CAUTION SIGN",
	"RADIOACTIVE SIGN",
	"BIOHAZARD SIGN",
	"CADUCEUS",
	"ANKH",
	"ORTHODOX CROSS",
	"CHI RHO",
	"CROSS OF LORRAINE",
	"CROSS OF JERUSALEM",
	"STAR AND CRESCENT",
	"FARSI SYMBOL",
	"ADI SHAKTI",
	"HAMMER AND SICKLE",
	"PEACE SYMBOL",
	"YIN YANG",
	"TRIGRAM FOR HEAVEN",
	"TRIGRAM FOR LAKE",
	"TRIGRAM FOR FIRE",
	"TRIGRAM FOR THUNDER",
	"TRIGRAM FOR WIND",
	"TRIGRAM FOR WATER",
	"TRIGRAM FOR MOUNTAIN",
	"TRIGRAM FOR EARTH",
	"WHEEL OF DHARMA",
	"WHITE FROWNING FACE",
	"WHITE SMILING FACE",
	"BLACK SMILING FACE",
	"WHITE SUN WITH RAYS",
	"FIRST QUARTER MOON",
	"LAST QUARTER MOON",
	"MERCURY",
	"FEMALE SIGN",
	"EARTH",
	"MALE SIGN",
	"JUPITER",
	"SATURN",
	"URANUS",
	"NEPTUNE",
	"PLUTO",
	"ARIES",
	"TAURUS",
	"GEMINI",
	"CANCER",
	"LEO",
	"VIRGO",
	"LIBRA",
	"SCORPIUS",
	"SAGITTARIUS",
	"CAPRICORN",
	"AQUARIUS",
	"PISCES",
	"WHITE CHESS KING",
	"WHITE CHESS QUEEN",
	"WHITE CHESS ROOK",
	"WHITE CHESS BISHOP",
	"WHITE CHESS KNIGHT",
	"WHITE CHESS PAWN",
	"BLACK CHESS KING",
	"BLACK CHESS QUEEN",
	"BLACK CHESS ROOK",
	"BLACK CHESS BISHOP",
	"BLACK CHESS KNIGHT",
	"BLACK CHESS PAWN",
	"BLACK SPADE SUIT",
	"WHITE HEART SUIT",
	"WHITE DIAMOND SUIT",
	"BLACK CLUB SUIT",
	"WHITE SPADE SUIT",
	"BLACK HEART SUIT",
	"BLACK DIAMOND SUIT",
	"WHITE CLUB SUIT",
	"HOT SPRINGS",
	"QUARTER NOTE",
	"EIGHTH NOTE",
	"BEAMED EIGHTH NOTES",
	"BEAMED SIXTEENTH NOTES",
	"MUSIC FLAT SIGN",
	"MUSIC NATURAL SIGN",
	"MUSIC SHARP SIGN",
	"WEST SYRIAC CROSS",
	"EAST SYRIAC CROSS",
	"UNIVERSAL RECYCLING SYMBOL",
	"RECYCLING SYMBOL FOR TYPE-1 PLASTICS",
	"RECYCLING SYMBOL FOR TYPE-2 PLASTICS",
	"RECYCLING SYMBOL FOR TYPE-3 PLASTICS",
	"RECYCLING SYMBOL FOR TYPE-4 PLASTICS",
	"RECYCLING SYMBOL FOR TYPE-5 PLASTICS",
	"RECYCLING SYMBOL FOR TYPE-6 PLASTICS",
	"RECYCLING SYMBOL FOR TYPE-7 PLASTICS",
	"RECYCLING SYMBOL FOR GENERIC MATERIALS",
	"BLACK UNIVERSAL RECYCLING SYMBOL",
	"RECYCLED PAPER SYMBOL",
	"PARTIALLY-RECYCLED PAPER SYMBOL",
	"PERMANENT PAPER SIGN",
	"WHEELCHAIR SYMBOL",
	"DIE FACE-1",
	"DIE FACE-2",
	"DIE FACE-3",
	"DIE FACE-4",
	"DIE FACE-5",
	"DIE FACE-6",
	"WHITE CIRCLE WITH DOT RIGHT",
	"WHITE CIRCLE WITH TWO DOTS",
	"BLACK CIRCLE WITH WHITE DOT RIGHT",
	"BLACK CIRCLE WITH TWO WHITE DOTS",
	"MONOGRAM FOR YANG",
	"MONOGRAM FOR YIN",
	"DIGRAM FOR GREATER YANG",
	"DIGRAM FOR LESSER YIN",
	"DIGRAM FOR LESSER YANG",
	"DIGRAM FOR GREATER YIN",
	"WHITE FLAG",
	"BLACK FLAG",
	"HAMMER AND PICK",
	"ANCHOR",
	"CROSSED SWORDS",
	"STAFF OF AESCULAPIUS",
	"SCALES",
	"ALEMBIC",
	"FLOWER",
	"GEAR",
	"STAFF OF HERMES",
	"ATOM SYMBOL",
	"FLEUR-DE-LIS",
	"OUTLINED WHITE STAR",
	"THREE LINES CONVERGING RIGHT",
	"THREE LINES CONVERGING LEFT",
	"WARNING SIGN",
	"HIGH VOLTAGE SIGN",
	"DOUBLED FEMALE SIGN",
	"DOUBLED MALE SIGN",
	"INTERLOCKED FEMALE AND MALE SIGN",
	"MALE AND FEMALE SIGN",
	"MALE WITH STROKE SIGN",
	"MALE WITH STROKE AND MALE AND FEMALE SIGN",
	"VERTICAL MALE WITH STROKE SIGN",
	"HORIZONTAL MALE WITH STROKE SIGN",
	"MEDIUM WHITE CIRCLE",
	"MEDIUM BLACK CIRCLE",
	"MEDIUM SMALL WHITE CIRCLE",
	"MARRIAGE SYMBOL",
	"DIVORCE SYMBOL",
	"UNMARRIED PARTNERSHIP SYMBOL",
	"COFFIN",
	"FUNERAL URN",
	"NEUTER",
	"CERES",
	"PALLAS",
	"JUNO",
	"VESTA",
	"CHIRON",
	"BLACK MOON LILITH",
	"SEXTILE",
	"SEMISEXTILE",
	"QUINCUNX",
	"SESQUIQUADRATE",
	"SOCCER BALL",
	"BASEBALL",
	"SQUARED KEY",
	"WHITE DRAUGHTS MAN",
	"WHITE DRAUGHTS KING",
	"BLACK DRAUGHTS MAN",
	"BLACK DRAUGHTS KING",
	"SNOWMAN WITHOUT SNOW",
	"SUN BEHIND CLOUD",
	"RAIN",
	"BLACK SNOWMAN",
	"THUNDER CLOUD AND RAIN",
	"TURNED WHITE SHOGI PIECE",
	"TURNED BLACK SHOGI PIECE",
	"WHITE DIAMOND IN SQUARE",
	"CROSSING LANES",
	"DISABLED CAR",
	"OPHIUCHUS",
	"PICK",
	"CAR SLIDING",
	"HELMET WITH WHITE CROSS",
	"CIRCLED CROSSING LANES",
	"CHAINS",
	"NO ENTRY",
	"ALTERNATE ONE-WAY LEFT WAY TRAFFIC",
	"BLACK TWO-WAY LEFT WAY TRAFFIC",
	"WHITE TWO-WAY LEFT WAY TRAFFIC",
	"BLACK LEFT LANE MERGE",
	"WHITE LEFT LANE MERGE",
	"DRIVE SLOW SIGN",
	"HEAVY WHITE DOWN-POINTING TRIANGLE",
	"LEFT CLOSED ENTRY",
	"SQUARED SALTIRE",
	"FALLING DIAGONAL IN WHITE CIRCLE IN BLACK SQUARE",
	"BLACK TRUCK",
	"RESTRICTED LEFT ENTRY-1",
	"RESTRICTED LEFT ENTRY-2",
	"ASTRONOMICAL SYMBOL FOR URANUS",
	"HEAVY CIRCLE WITH STROKE AND TWO DOTS ABOVE",
	"PENTAGRAM",
	"RIGHT-HANDED INTERLACED PENTAGRAM",
	"LEFT-HANDED INTERLACED PENTAGRAM",
	"INVERTED PENTAGRAM",
	"BLACK CROSS ON SHIELD",
	"SHINTO SHRINE",
	"CHURCH",
	"CASTLE",
	"HISTORIC SITE",
	"GEAR WITHOUT HUB",
	"GEAR WITH HANDLES",
	"MAP SYMBOL FOR LIGHTHOUSE",
	"MOUNTAIN",
	"UMBRELLA ON GROUND",
	"FOUNTAIN",
	"FLAG IN HOLE",
	"FERRY",
	"SAILBOAT",
	"SQUARE FOUR CORNERS",
	"SKIER",
	"ICE SKATE",
	"PERSON WITH BALL",
	"TENT",
	"JAPANESE BANK SYMBOL",
	"HEADSTONE GRAVEYARD SYMBOL",
	"FUEL PUMP",
	"CUP ON BLACK SQUARE",
	"WHITE FLAG WITH HORIZONTAL MIDDLE BLACK STRIPE",
	"BLACK SAFETY SCISSORS",
	"UPPER BLADE SCISSORS",
	"BLACK SCISSORS",
	"LOWER BLADE SCISSORS",
	"WHITE SCISSORS",
	"WHITE HEAVY CHECK MARK",
	"TELEPHONE LOCATION SIGN",
	"TAPE DRIVE",
	"AIRPLANE",
	"ENVELOPE",
	"RAISED FIST",
	"RAISED HAND",
	"VICTORY HAND",
	"WRITING HAND",
	"LOWER RIGHT PENCIL",
	"PENCIL",
	"UPPER RIGHT PENCIL",
	"WHITE NIB",
	"BLACK NIB",
	"CHECK MARK",
	"HEAVY CHECK MARK",
	"MULTIPLICATION X",
	"HEAVY MULTIPLICATION X",
	"BALLOT X",
	"HEAVY BALLOT X",
	"OUTLINED GREEK CROSS",
	"HEAVY GREEK CROSS",
	"OPEN CENTRE CROSS",
	"HEAVY OPEN CENTRE CROSS",
	"LATIN CROSS",
	"SHADOWED WHITE LATIN CROSS",
	"OUTLINED LATIN CROSS",
	"MALTESE CROSS",
	"STAR OF DAVID",
	"FOUR TEARDROP-SPOKED ASTERISK",
	"FOUR BALLOON-SPOKED ASTERISK",
	"HEAVY FOUR BALLOON-SPOKED ASTERISK",
	"FOUR CLUB-SPOKED ASTERISK",
	"BLACK FOUR POINTED STAR",
	"WHITE FOUR POINTED STAR",
	"SPARKLES",
	"STRESS OUTLINED WHITE STAR",
	"CIRCLED WHITE STAR",
	"OPEN CENTRE BLACK STAR",
	"BLACK CENTRE WHITE STAR",
	"OUTLINED BLACK STAR",
	"HEAVY OUTLINED BLACK STAR",
	"PINWHEEL STAR",
	"SHADOWED WHITE STAR",
	"HEAVY ASTERISK",
	"OPEN CENTRE ASTERISK",
	"EIGHT SPOKED ASTERISK",
	"EIGHT POINTED BLACK STAR",
	"EIGHT POINTED PINWHEEL STAR",
	"SIX POINTED BLACK STAR",
	"EIGHT POINTED RECTILINEAR BLACK STAR",
	"HEAVY EIGHT POINTED RECTILINEAR BLACK STAR",
	"TWELVE POINTED BLACK STAR",
	"SIXTEEN POINTED ASTERISK",
	"TEARDROP-SPOKED ASTERISK",
	"OPEN CENTRE TEARDROP-SPOKED ASTERISK",
	"HEAVY TEARDROP-SPOKED ASTERISK",
	"SIX PETALLED BLACK AND WHITE FLORETTE",
	"BLACK FLORETTE",
	"WHITE FLORETTE",
	"EIGHT PETALLED OUTLINED BLACK FLORETTE",
	"CIRCLED OPEN CENTRE EIGHT POINTED STAR",
	"HEAVY TEARDROP-SPOKED PINWHEEL ASTERISK",
	"SNOWFLAKE",
	"TIGHT TRIFOLIATE SNOWFLAKE",
	"HEAVY CHEVRON SNOWFLAKE",
	"SPARKLE",
	"HEAVY SPARKLE",
	"BALLOON-SPOKED ASTERISK",
	"EIGHT TEARDROP-SPOKED PROPELLER ASTERISK",
	"HEAVY EIGHT TEARDROP-SPOKED PROPELLER ASTERISK",
	"CROSS MARK",
	"SHADOWED WHITE CIRCLE",
	"NEGATIVE SQUARED CROSS MARK",
	"LOWER RIGHT DROP-SHADOWED WHITE SQUARE",
	"UPPER RIGHT DROP-SHADOWED WHITE SQUARE",
	"LOWER RIGHT SHADOWED WHITE SQUARE",
	"UPPER RIGHT SHADOWED WHITE SQUARE",
	"BLACK QUESTION MARK ORNAMENT",
	"WHITE QUESTION MARK ORNAMENT",
	"WHITE EXCLAMATION MARK ORNAMENT",
	"BLACK DIAMOND MINUS WHITE X",
	"HEAVY EXCLAMATION MARK SYMBOL",
	"LIGHT VERTICAL BAR",
	"MEDIUM VERTICAL BAR",
	"HEAVY VERTICAL BAR",
	"HEAVY SINGLE TURNED COMMA QUOTATION MARK ORNAMENT",
	"HEAVY SINGLE COMMA QUOTATION MARK ORNAMENT",
	"HEAVY DOUBLE TURNED COMMA QUOTATION MARK ORNAMENT",
	"HEAVY DOUBLE COMMA QUOTATION MARK ORNAMENT",
	"HEAVY LOW SINGLE COMMA QUOTATION MARK ORNAMENT",
	"HEAVY LOW DOUBLE COMMA QUOTATION MARK ORNAMENT",
	"CURVED STEM PARAGRAPH SIGN ORNAMENT",
	"HEAVY EXCLAMATION MARK ORNAMENT",
	"HEAVY HEART EXCLAMATION MARK ORNAMENT",
	"HEAVY BLACK HEART",
	"ROTATED HEAVY BLACK HEART BULLET",
	"FLORAL HEART",
	"ROTATED FLORAL HEART BULLET",
	"MEDIUM LEFT PARENTHESIS ORNAMENT",
	"MEDIUM RIGHT PARENTHESIS ORNAMENT",
	"MEDIUM FLATTENED LEFT PARENTHESIS ORNAMENT",
	"MEDIUM FLATTENED RIGHT PARENTHESIS ORNAMENT",
	"MEDIUM LEFT-POINTING ANGLE BRACKET ORNAMENT",
	"MEDIUM RIGHT-POINTING ANGLE BRACKET ORNAMENT",
	"HEAVY LEFT-POINTING ANGLE QUOTATION MARK ORNAMENT",
	"HEAVY RIGHT-POINTING ANGLE QUOTATION MARK ORNAMENT",
	"HEAVY LEFT-POINTING ANGLE BRACKET ORNAMENT",
	"HEAVY RIGHT-POINTING ANGLE BRACKET ORNAMENT",
	"LIGHT LEFT TORTOISE SHELL BRACKET ORNAMENT",
	"LIGHT RIGHT TORTOISE SHELL BRACKET ORNAMENT",
	"MEDIUM LEFT CURLY BRACKET ORNAMENT",
	"MEDIUM RIGHT CURLY BRACKET ORNAMENT",
	"DINGBAT NEGATIVE CIRCLED DIGIT ONE",
	"DINGBAT NEGATIVE CIRCLED DIGIT TWO",
	"DINGBAT NEGATIVE CIRCLED DIGIT THREE",
	"DINGBAT NEGATIVE CIRCLED DIGIT FOUR",
	"DINGBAT NEGATIVE CIRCLED DIGIT FIVE",
	"DINGBAT NEGATIVE CIRCLED DIGIT SIX",
	"DINGBAT NEGATIVE CIRCLED DIGIT SEVEN",
	"DINGBAT NEGATIVE CIRCLED DIGIT EIGHT",
	"DINGBAT NEGATIVE CIRCLED DIGIT NINE",
	"DINGBAT NEGATIVE CIRCLED NUMBER TEN",
	"DINGBAT CIRCLED SANS-SERIF DIGIT ONE",
	"DINGBAT CIRCLED SANS-SERIF DIGIT TWO",
	"DINGBAT CIRCLED SANS-SERIF DIGIT THREE",
	"DINGBAT CIRCLED SANS-SERIF DIGIT FOUR",
	"DINGBAT CIRCLED SANS-SERIF DIGIT FIVE",
	"DINGBAT CIRCLED SANS-SERIF DIGIT SIX",
	"DINGBAT CIRCLED SANS-SERIF DIGIT SEVEN",
	"DINGBAT CIRCLED SANS-SERIF DIGIT EIGHT",
	"DINGBAT CIRCLED SANS-SERIF DIGIT NINE",
	"DINGBAT CIRCLED SANS-SERIF NUMBER TEN",
	"DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT ONE",
	"DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT TWO",
	"DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT THREE",
	"DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT FOUR",
	"DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT FIVE",
	"DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT SIX",
	"DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT SEVEN",
	"DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT EIGHT",
	"DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT NINE",
	"DINGBAT NEGATIVE CIRCLED SANS-SERIF NUMBER TEN",
	"HEAVY WIDE-HEADED RIGHTWARDS ARROW",
	"HEAVY PLUS SIGN",
	"HEAVY MINUS SIGN",
	"HEAVY DIVISION SIGN",
	"HEAVY SOUTH EAST ARROW",
	"HEAVY RIGHTWARDS ARROW",
	"HEAVY NORTH EAST ARROW",
	"DRAFTING POINT RIGHTWARDS ARROW",
	"HEAVY ROUND-TIPPED RIGHTWARDS ARROW",
	"TRIANGLE-HEADED RIGHTWARDS ARROW",
	"HEAVY TRIANGLE-HEADED RIGHTWARDS ARROW",
	"DASHED TRIANGLE-HEADED RIGHTWARDS ARROW",
	"HEAVY DASHED TRIANGLE-HEADED RIGHTWARDS ARROW",
	"BLACK RIGHTWARDS ARROW",
	"THREE-D TOP-LIGHTED RIGHTWARDS ARROWHEAD",
	"THREE-D BOTTOM-LIGHTED RIGHTWARDS ARROWHEAD",
	"BLACK RIGHTWARDS ARROWHEAD",
	"HEAVY BLACK CURVED DOWNWARDS AND RIGHTWARDS ARROW",
	"HEAVY BLACK CURVED UPWARDS AND RIGHTWARDS ARROW",
	"SQUAT BLACK RIGHTWARDS ARROW",
	"HEAVY CONCAVE-POINTED BLACK RIGHTWARDS ARROW",
	"RIGHT-SHADED WHITE RIGHTWARDS ARROW",
	"LEFT-SHADED WHITE RIGHTWARDS ARROW",
	"BACK-TILTED SHADOWED WHITE RIGHTWARDS ARROW",
	"FRONT-TILTED SHADOWED WHITE RIGHTWARDS ARROW",
	"HEAVY LOWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW",
	"HEAVY UPPER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW",
	"NOTCHED LOWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW",
	"CURLY LOOP",
	"NOTCHED UPPER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW",
	"CIRCLED HEAVY WHITE RIGHTWARDS ARROW",
	"WHITE-FEATHERED RIGHTWARDS ARROW",
	"BLACK-FEATHERED SOUTH EAST ARROW",
	"BLACK-FEATHERED RIGHTWARDS ARROW",
	"BLACK-FEATHERED NORTH EAST ARROW",
	"HEAVY BLACK-FEATHERED SOUTH EAST ARROW",
	"HEAVY BLACK-FEATHERED RIGHTWARDS ARROW",
	"HEAVY BLACK-FEATHERED NORTH EAST ARROW",
	"TEARDROP-BARBED RIGHTWARDS ARROW",
	"HEAVY TEARDROP-SHANKED RIGHTWARDS ARROW",
	"WEDGE-TAILED RIGHTWARDS ARROW",
	"HEAVY WEDGE-TAILED RIGHTWARDS ARROW",
	"OPEN-OUTLINED RIGHTWARDS ARROW",
	"DOUBLE CURLY LOOP",
	"THREE DIMENSIONAL ANGLE",
	"WHITE TRIANGLE CONTAINING SMALL WHITE TRIANGLE",
	"PERPENDICULAR",
	"OPEN SUBSET",
	"OPEN SUPERSET",
	"LEFT S-SHAPED BAG DELIMITER",
	"RIGHT S-SHAPED BAG DELIMITER",
	"OR WITH DOT INSIDE",
	"REVERSE SOLIDUS PRECEDING SUBSET",
	"SUPERSET PRECEDING SOLIDUS",
	"VERTICAL BAR WITH HORIZONTAL STROKE",
	"MATHEMATICAL RISING DIAGONAL",
	"LONG DIVISION",
	"MATHEMATICAL FALLING DIAGONAL",
	"SQUARED LOGICAL AND",
	"SQUARED LOGICAL OR",
	"WHITE DIAMOND WITH CENTRED DOT",
	"AND WITH DOT",
	"ELEMENT OF OPENING UPWARDS",
	"LOWER RIGHT CORNER WITH DOT",
	"UPPER LEFT CORNER WITH DOT",
	"LEFT OUTER JOIN",
	"RIGHT OUTER JOIN",
	"FULL OUTER JOIN",
	"LARGE UP TACK",
	"LARGE DOWN TACK",
	"LEFT AND RIGHT DOUBLE TURNSTILE",
	"LEFT AND RIGHT TACK",
	"LEFT MULTIMAP",
	"LONG RIGHT TACK",
	"LONG LEFT TACK",
	"UP TACK WITH CIRCLE ABOVE",
	"LOZENGE DIVIDED BY HORIZONTAL RULE",
	"WHITE CONCAVE-SIDED DIAMOND",
	"WHITE CONCAVE-SIDED DIAMOND WITH LEFTWARDS TICK",
	"WHITE CONCAVE-SIDED DIAMOND WITH RIGHTWARDS TICK",
	"WHITE SQUARE WITH LEFTWARDS TICK",
	"WHITE SQUARE WITH RIGHTWARDS TICK",
	"MATHEMATICAL LEFT WHITE SQUARE BRACKET",
	"MATHEMATICAL RIGHT WHITE SQUARE BRACKET",
	"MATHEMATICAL LEFT ANGLE BRACKET",
	"MATHEMATICAL RIGHT ANGLE BRACKET",
	"MATHEMATICAL LEFT DOUBLE ANGLE BRACKET",
	"MATHEMATICAL RIGHT DOUBLE ANGLE BRACKET",
	"MATHEMATICAL LEFT WHITE TORTOISE SHELL BRACKET",
	"MATHEMATICAL RIGHT WHITE TORTOISE SHELL BRACKET",
	"MATHEMATICAL LEFT FLATTENED PARENTHESIS",
	"MATHEMATICAL RIGHT FLATTENED PARENTHESIS",
	"UPWARDS QUADRUPLE ARROW",
	"DOWNWARDS QUADRUPLE ARROW",
	"ANTICLOCKWISE GAPPED CIRCLE ARROW",
	"CLOCKWISE GAPPED CIRCLE ARROW",
	"RIGHT ARROW WITH CIRCLED PLUS",
	"LONG LEFTWARDS ARROW",
	"LONG RIGHTWARDS ARROW",
	"LONG LEFT RIGHT ARROW",
	"LONG LEFTWARDS DOUBLE ARROW",
	"LONG RIGHTWARDS DOUBLE ARROW",
	"LONG LEFT RIGHT DOUBLE ARROW",
	"LONG LEFTWARDS ARROW FROM BAR",
	"LONG RIGHTWARDS ARROW FROM BAR",
	"LONG LEFTWARDS DOUBLE ARROW FROM BAR",
	"LONG RIGHTWARDS DOUBLE ARROW FROM BAR",
	"LONG RIGHTWARDS SQUIGGLE ARROW",
	"BRAILLE PATTERN BLANK",
	"BRAILLE PATTERN DOTS-1",
	"BRAILLE PATTERN DOTS-2",
	"BRAILLE PATTERN DOTS-12",
	"BRAILLE PATTERN DOTS-3",
	"BRAILLE PATTERN DOTS-13",
	"BRAILLE PATTERN DOTS-23",
	"BRAILLE PATTERN DOTS-123",
	"BRAILLE PATTERN DOTS-4",
	"BRAILLE PATTERN DOTS-14",
	"BRAILLE PATTERN DOTS-24",
	"BRAILLE PATTERN DOTS-124",
	"BRAILLE PATTERN DOTS-34",
	"BRAILLE PATTERN DOTS-134",
	"BRAILLE PATTERN DOTS-234",
	"BRAILLE PATTERN DOTS-1234",
	"BRAILLE PATTERN DOTS-5",
	"BRAILLE PATTERN DOTS-15",
	"BRAILLE PATTERN DOTS-25",
	"BRAILLE PATTERN DOTS-125",
	"BRAILLE PATTERN DOTS-35",
	"BRAILLE PATTERN DOTS-135",
	"BRAILLE PATTERN DOTS-235",
	"BRAILLE PATTERN DOTS-1235",
	"BRAILLE PATTERN DOTS-45",
	"BRAILLE PATTERN DOTS-145",
	"BRAILLE PATTERN DOTS-245",
	"BRAILLE PATTERN DOTS-1245",
	"BRAILLE PATTERN DOTS-345",
	"BRAILLE PATTERN DOTS-1345",
	"BRAILLE PATTERN DOTS-2345",
	"BRAILLE PATTERN DOTS-12345",
	"BRAILLE PATTERN DOTS-6",
	"BRAILLE PATTERN DOTS-16",
	"BRAILLE PATTERN DOTS-26",
	"BRAILLE PATTERN DOTS-126",
	"BRAILLE PATTERN DOTS-36",
	"BRAILLE PATTERN DOTS-136",
	"BRAILLE PATTERN DOTS-236",
	"BRAILLE PATTERN DOTS-1236",
	"BRAILLE PATTERN DOTS-46",
	"BRAILLE PATTERN DOTS-146",
	"BRAILLE PATTERN DOTS-246",
	"BRAILLE PATTERN DOTS-1246",
	"BRAILLE PATTERN DOTS-346",
	"BRAILLE PATTERN DOTS-1346",
	"BRAILLE PATTERN DOTS-2346",
	"BRAILLE PATTERN DOTS-12346",
	"BRAILLE PATTERN DOTS-56",
	"BRAILLE PATTERN DOTS-156",
	"BRAILLE PATTERN DOTS-256",
	"BRAILLE PATTERN DOTS-1256",
	"BRAILLE PATTERN DOTS-356",
	"BRAILLE PATTERN DOTS-1356",
	"BRAILLE PATTERN DOTS-2356",
	"BRAILLE PATTERN DOTS-12356",
	"BRAILLE PATTERN DOTS-456",
	"BRAILLE PATTERN DOTS-1456",
	"BRAILLE PATTERN DOTS-2456",
	"BRAILLE PATTERN DOTS-12456",
	"BRAILLE PATTERN DOTS-3456",
	"BRAILLE PATTERN DOTS-13456",
	"BRAILLE PATTERN DOTS-23456",
	"BRAILLE PATTERN DOTS-123456",
	"BRAILLE PATTERN DOTS-7",
	"BRAILLE PATTERN DOTS-17",
	"BRAILLE PATTERN DOTS-27",
	"BRAILLE PATTERN DOTS-127",
	"BRAILLE PATTERN DOTS-37",
	"BRAILLE PATTERN DOTS-137",
	"BRAILLE PATTERN DOTS-237",
	"BRAILLE PATTERN DOTS-1237",
	"BRAILLE PATTERN DOTS-47",
	"BRAILLE PATTERN DOTS-147",
	"BRAILLE PATTERN DOTS-247",
	"BRAILLE PATTERN DOTS-1247",
	"BRAILLE PATTERN DOTS-347",
	"BRAILLE PATTERN DOTS-1347",
	"BRAILLE PATTERN DOTS-2347",
	"BRAILLE PATTERN DOTS-12347",
	"BRAILLE PATTERN DOTS-57",
	"BRAILLE PATTERN DOTS-157",
	"BRAILLE PATTERN DOTS-257",
	"BRAILLE PATTERN DOTS-1257",
	"BRAILLE PATTERN DOTS-357",
	"BRAILLE PATTERN DOTS-1357",
	"BRAILLE PATTERN DOTS-2357",
	"BRAILLE PATTERN DOTS-12357",
	"BRAILLE PATTERN DOTS-457",
	"BRAILLE PATTERN DOTS-1457",
	"BRAILLE PATTERN DOTS-2457",
	"BRAILLE PATTERN DOTS-12457",
	"BRAILLE PATTERN DOTS-3457",
	"BRAILLE PATTERN DOTS-13457",
	"BRAILLE PATTERN DOTS-23457",
	"BRAILLE PATTERN DOTS-123457",
	"BRAILLE PATTERN DOTS-67",
	"BRAILLE PATTERN DOTS-167",
	"BRAILLE PATTERN DOTS-267",
	"BRAILLE PATTERN DOTS-1267",
	"BRAILLE PATTERN DOTS-367",
	"BRAILLE PATTERN DOTS-1367",
	"BRAILLE PATTERN DOTS-2367",
	"BRAILLE PATTERN DOTS-12367",
	"BRAILLE PATTERN DOTS-467",
	"BRAILLE PATTERN DOTS-1467",
	"BRAILLE PATTERN DOTS-2467",
	"BRAILLE PATTERN DOTS-12467",
	"BRAILLE PATTERN DOTS-3467",
	"BRAILLE PATTERN DOTS-13467",
	"BRAILLE PATTERN DOTS-23467",
	"BRAILLE PATTERN DOTS-123467",
	"BRAILLE PATTERN DOTS-567",
	"BRAILLE PATTERN DOTS-1567",
	"BRAILLE PATTERN DOTS-2567",
	"BRAILLE PATTERN DOTS-12567",
	"BRAILLE PATTERN DOTS-3567",
	"BRAILLE PATTERN DOTS-13567",
	"BRAILLE PATTERN DOTS-23567",
	"BRAILLE PATTERN DOTS-123567",
	"BRAILLE PATTERN DOTS-4567",
	"BRAILLE PATTERN DOTS-14567",
	"BRAILLE PATTERN DOTS-24567",
	"BRAILLE PATTERN DOTS-124567",
	"BRAILLE PATTERN DOTS-34567",
	"BRAILLE PATTERN DOTS-134567",
	"BRAILLE PATTERN DOTS-234567",
	"BRAILLE PATTERN DOTS-1234567",
	"BRAILLE PATTERN DOTS-8",
	"BRAILLE PATTERN DOTS-18",
	"BRAILLE PATTERN DOTS-28",
	"BRAILLE PATTERN DOTS-128",
	"BRAILLE PATTERN DOTS-38",
	"BRAILLE PATTERN DOTS-138",
	"BRAILLE PATTERN DOTS-238",
	"BRAILLE PATTERN DOTS-1238",
	"BRAILLE PATTERN DOTS-48",
	"BRAILLE PATTERN DOTS-148",
	"BRAILLE PATTERN DOTS-248",
	"BRAILLE PATTERN DOTS-1248",
	"BRAILLE PATTERN DOTS-348",
	"BRAILLE PATTERN DOTS-1348",
	"BRAILLE PATTERN DOTS-2348",
	"BRAILLE PATTERN DOTS-12348",
	"BRAILLE PATTERN DOTS-58",
	"BRAILLE PATTERN DOTS-158",
	"BRAILLE PATTERN DOTS-258",
	"BRAILLE PATTERN DOTS-1258",
	"BRAILLE PATTERN DOTS-358",
	"BRAILLE PATTERN DOTS-1358",
	"BRAILLE PATTERN DOTS-2358",
	"BRAILLE PATTERN DOTS-12358",
	"BRAILLE PATTERN DOTS-458",
	"BRAILLE PATTERN DOTS-1458",
	"BRAILLE PATTERN DOTS-2458",
	"BRAILLE PATTERN DOTS-12458",
	"BRAILLE PATTERN DOTS-3458",
	"BRAILLE PATTERN DOTS-13458",
	"BRAILLE PATTERN DOTS-23458",
	"BRAILLE PATTERN DOTS-123458",
	"BRAILLE PATTERN DOTS-68",
	"BRAILLE PATTERN DOTS-168",
	"BRAILLE PATTERN DOTS-268",
	"BRAILLE PATTERN DOTS-1268",
	"BRAILLE PATTERN DOTS-368",
	"BRAILLE PATTERN DOTS-1368",
	"BRAILLE PATTERN DOTS-2368",
	"BRAILLE PATTERN DOTS-12368",
	"BRAILLE PATTERN DOTS-468",
	"BRAILLE PATTERN DOTS-1468",
	"BRAILLE PATTERN DOTS-2468",
	"BRAILLE PATTERN DOTS-12468",
	"BRAILLE PATTERN DOTS-3468",
	"BRAILLE PATTERN DOTS-13468",
	"BRAILLE PATTERN DOTS-23468",
	"BRAILLE PATTERN DOTS-123468",
	"BRAILLE PATTERN DOTS-568",
	"BRAILLE PATTERN DOTS-1568",
	"BRAILLE PATTERN DOTS-2568",
	"BRAILLE PATTERN DOTS-12568",
	"BRAILLE PATTERN DOTS-3568",
	"BRAILLE PATTERN DOTS-13568",
	"BRAILLE PATTERN DOTS-23568",
	"BRAILLE PATTERN DOTS-123568",
	"BRAILLE PATTERN DOTS-4568",
	"BRAILLE PATTERN DOTS-14568",
	"BRAILLE PATTERN DOTS-24568",
	"BRAILLE PATTERN DOTS-124568",
	"BRAILLE PATTERN DOTS-34568",
	"BRAILLE PATTERN DOTS-134568",
	"BRAILLE PATTERN DOTS-234568",
	"BRAILLE PATTERN DOTS-1234568",
	"BRAILLE PATTERN DOTS-78",
	"BRAILLE PATTERN DOTS-178",
	"BRAILLE PATTERN DOTS-278",
	"BRAILLE PATTERN DOTS-1278",
	"BRAILLE PATTERN DOTS-378",
	"BRAILLE PATTERN DOTS-1378",
	"BRAILLE PATTERN DOTS-2378",
	"BRAILLE PATTERN DOTS-12378",
	"BRAILLE PATTERN DOTS-478",
	"BRAILLE PATTERN DOTS-1478",
	"BRAILLE PATTERN DOTS-2478",
	"BRAILLE PATTERN DOTS-12478",
	"BRAILLE PATTERN DOTS-3478",
	"BRAILLE PATTERN DOTS-13478",
	"BRAILLE PATTERN DOTS-23478",
	"BRAILLE PATTERN DOTS-123478",
	"BRAILLE PATTERN DOTS-578",
	"BRAILLE PATTERN DOTS-1578",
	"BRAILLE PATTERN DOTS-2578",
	"BRAILLE PATTERN DOTS-12578",
	"BRAILLE PATTERN DOTS-3578",
	"BRAILLE PATTERN DOTS-13578",
	"BRAILLE PATTERN DOTS-23578",
	"BRAILLE PATTERN DOTS-123578",
	"BRAILLE PATTERN DOTS-4578",
	"BRAILLE PATTERN DOTS-14578",
	"BRAILLE PATTERN DOTS-24578",
	"BRAILLE PATTERN DOTS-124578",
	"BRAILLE PATTERN DOTS-34578",
	"BRAILLE PATTERN DOTS-134578",
	"BRAILLE PATTERN DOTS-234578",
	"BRAILLE PATTERN DOTS-1234578",
	"BRAILLE PATTERN DOTS-678",
	"BRAILLE PATTERN DOTS-1678",
	"BRAILLE PATTERN DOTS-2678",
	"BRAILLE PATTERN DOTS-12678",
	"BRAILLE PATTERN DOTS-3678",
	"BRAILLE PATTERN DOTS-13678",
	"BRAILLE PATTERN DOTS-23678",
	"BRAILLE PATTERN DOTS-123678",
	"BRAILLE PATTERN DOTS-4678",
	"BRAILLE PATTERN DOTS-14678",
	"BRAILLE PATTERN DOTS-24678",
	"BRAILLE PATTERN DOTS-124678",
	"BRAILLE PATTERN DOTS-34678",
	"BRAILLE PATTERN DOTS-134678",
	"BRAILLE PATTERN DOTS-234678",
	"BRAILLE PATTERN DOTS-1234678",
	"BRAILLE PATTERN DOTS-5678",
	"BRAILLE PATTERN DOTS-15678",
	"BRAILLE PATTERN DOTS-25678",
	"BRAILLE PATTERN DOTS-125678",
	"BRAILLE PATTERN DOTS-35678",
	"BRAILLE PATTERN DOTS-135678",
	"BRAILLE PATTERN DOTS-235678",
	"BRAILLE PATTERN DOTS-1235678",
	"BRAILLE PATTERN DOTS-45678",
	"BRAILLE PATTERN DOTS-145678",
	"BRAILLE PATTERN DOTS-245678",
	"BRAILLE PATTERN DOTS-1245678",
	"BRAILLE PATTERN DOTS-345678",
	"BRAILLE PATTERN DOTS-1345678",
	"BRAILLE PATTERN DOTS-2345678",
	"BRAILLE PATTERN DOTS-12345678",
	"RIGHTWARDS TWO-HEADED ARROW WITH VERTICAL STROKE",
	"RIGHTWARDS TWO-HEADED ARROW WITH DOUBLE VERTICAL STROKE",
	"LEFTWARDS DOUBLE ARROW WITH VERTICAL STROKE",
	"RIGHTWARDS DOUBLE ARROW WITH VERTICAL STROKE",
	"LEFT RIGHT DOUBLE ARROW WITH VERTICAL STROKE",
	"RIGHTWARDS TWO-HEADED ARROW FROM BAR",
	"LEFTWARDS DOUBLE ARROW FROM BAR",
	"RIGHTWARDS DOUBLE ARROW FROM BAR",
	"DOWNWARDS ARROW WITH HORIZONTAL STROKE",
	"UPWARDS ARROW WITH HORIZONTAL STROKE",
	"UPWARDS TRIPLE ARROW",
	"DOWNWARDS TRIPLE ARROW",
	"LEFTWARDS DOUBLE DASH ARROW",
	"RIGHTWARDS DOUBLE DASH ARROW",
	"LEFTWARDS TRIPLE DASH ARROW",
	"RIGHTWARDS TRIPLE DASH ARROW",
	"RIGHTWARDS TWO-HEADED TRIPLE DASH ARROW",
	"RIGHTWARDS ARROW WITH DOTTED STEM",
	"UPWARDS ARROW TO BAR",
	"DOWNWARDS ARROW TO BAR",
	"RIGHTWARDS ARROW WITH TAIL WITH VERTICAL STROKE",
	"RIGHTWARDS ARROW WITH TAIL WITH DOUBLE VERTICAL STROKE",
	"RIGHTWARDS TWO-HEADED ARROW WITH TAIL",
	"RIGHTWARDS TWO-HEADED ARROW WITH TAIL WITH VERTICAL STROKE",
	"RIGHTWARDS TWO-HEADED ARROW WITH TAIL WITH DOUBLE VERTICAL STROKE",
	"LEFTWARDS ARROW-TAIL",
	"RIGHTWARDS ARROW-TAIL",
	"LEFTWARDS DOUBLE ARROW-TAIL",
	"RIGHTWARDS DOUBLE ARROW-TAIL",
	"LEFTWARDS ARROW TO BLACK DIAMOND",
	"RIGHTWARDS ARROW TO BLACK DIAMOND",
	"LEFTWARDS ARROW FROM BAR TO BLACK DIAMOND",
	"RIGHTWARDS ARROW FROM BAR TO BLACK DIAMOND",
	"NORTH WEST AND SOUTH EAST ARROW",
	"NORTH EAST AND SOUTH WEST ARROW",
	"NORTH WEST ARROW WITH HOOK",
	"NORTH EAST ARROW WITH HOOK",
	"SOUTH EAST ARROW WITH HOOK",
	"SOUTH WEST ARROW WITH HOOK",
	"NORTH WEST ARROW AND NORTH EAST ARROW",
	"NORTH EAST ARROW AND SOUTH EAST ARROW",
	"SOUTH EAST ARROW AND SOUTH WEST ARROW",
	"SOUTH WEST ARROW AND NORTH WEST ARROW",
	"RISING DIAGONAL CROSSING FALLING DIAGONAL",
	"FALLING DIAGONAL CROSSING RISING DIAGONAL",
	"SOUTH EAST ARROW CROSSING NORTH EAST ARROW",
	"NORTH EAST ARROW CROSSING SOUTH EAST ARROW",
	"FALLING DIAGONAL CROSSING NORTH EAST ARROW",
	"RISING DIAGONAL CROSSING SOUTH EAST ARROW",
	"NORTH EAST ARROW CROSSING NORTH WEST ARROW",
	"NORTH WEST ARROW CROSSING NORTH EAST ARROW",
	"WAVE ARROW POINTING DIRECTLY RIGHT",
	"ARROW POINTING RIGHTWARDS THEN CURVING UPWARDS",
	"ARROW POINTING RIGHTWARDS THEN CURVING DOWNWARDS",
	"ARROW POINTING DOWNWARDS THEN CURVING LEFTWARDS",
	"ARROW POINTING DOWNWARDS THEN CURVING RIGHTWARDS",
	"RIGHT-SIDE ARC CLOCKWISE ARROW",
	"LEFT-SIDE ARC ANTICLOCKWISE ARROW",
	"TOP ARC ANTICLOCKWISE ARROW",
	"BOTTOM ARC ANTICLOCKWISE ARROW",
	"TOP ARC CLOCKWISE ARROW WITH MINUS",
	"TOP ARC ANTICLOCKWISE ARROW WITH PLUS",
	"LOWER RIGHT SEMICIRCULAR CLOCKWISE ARROW",
	"LOWER LEFT SEMICIRCULAR ANTICLOCKWISE ARROW",
	"ANTICLOCKWISE CLOSED CIRCLE ARROW",
	"CLOCKWISE CLOSED CIRCLE ARROW",
	"RIGHTWARDS ARROW ABOVE SHORT LEFTWARDS ARROW",
	"LEFTWARDS ARROW ABOVE SHORT RIGHTWARDS ARROW",
	"SHORT RIGHTWARDS ARROW ABOVE LEFTWARDS ARROW",
	"RIGHTWARDS ARROW WITH PLUS BELOW",
	"LEFTWARDS ARROW WITH PLUS BELOW",
	"RIGHTWARDS ARROW THROUGH X",
	"LEFT RIGHT ARROW THROUGH SMALL CIRCLE",
	"UPWARDS TWO-HEADED ARROW FROM SMALL CIRCLE",
	"LEFT BARB UP RIGHT BARB DOWN HARPOON",
	"LEFT BARB DOWN RIGHT BARB UP HARPOON",
	"UP BARB RIGHT DOWN BARB LEFT HARPOON",
	"UP BARB LEFT DOWN BARB RIGHT HARPOON",
	"LEFT BARB UP RIGHT BARB UP HARPOON",
	"UP BARB RIGHT DOWN BARB RIGHT HARPOON",
	"LEFT BARB DOWN RIGHT BARB DOWN HARPOON",
	"UP BARB LEFT DOWN BARB LEFT HARPOON",
	"LEFTWARDS HARPOON WITH BARB UP TO BAR",
	"RIGHTWARDS HARPOON WITH BARB UP TO BAR",
	"UPWARDS HARPOON WITH BARB RIGHT TO BAR",
	"DOWNWARDS HARPOON WITH BARB RIGHT TO BAR",
	"LEFTWARDS HARPOON WITH BARB DOWN TO BAR",
	"RIGHTWARDS HARPOON WITH BARB DOWN TO BAR",
	"UPWARDS HARPOON WITH BARB LEFT TO BAR",
	"DOWNWARDS HARPOON WITH BARB LEFT TO BAR",
	"LEFTWARDS HARPOON WITH BARB UP FROM BAR",
	"RIGHTWARDS HARPOON WITH BARB UP FROM BAR",
	"UPWARDS HARPOON WITH BARB RIGHT FROM BAR",
	"DOWNWARDS HARPOON WITH BARB RIGHT FROM BAR",
	"LEFTWARDS HARPOON WITH BARB DOWN FROM BAR",
	"RIGHTWARDS HARPOON WITH BARB DOWN FROM BAR",
	"UPWARDS HARPOON WITH BARB LEFT FROM BAR",
	"DOWNWARDS HARPOON WITH BARB LEFT FROM BAR",
	"LEFTWARDS HARPOON WITH BARB UP ABOVE LEFTWARDS HARPOON WITH BARB DOWN",
	"UPWARDS HARPOON WITH BARB LEFT BESIDE UPWARDS HARPOON WITH BARB RIGHT",
	"RIGHTWARDS HARPOON WITH BARB UP ABOVE RIGHTWARDS HARPOON WITH BARB DOWN",
	"DOWNWARDS HARPOON WITH BARB LEFT BESIDE DOWNWARDS HARPOON WITH BARB RIGHT",
	"LEFTWARDS HARPOON WITH BARB UP ABOVE RIGHTWARDS HARPOON WITH BARB UP",
	"LEFTWARDS HARPOON WITH BARB DOWN ABOVE RIGHTWARDS HARPOON WITH BARB DOWN",
	"RIGHTWARDS HARPOON WITH BARB UP ABOVE LEFTWARDS HARPOON WITH BARB UP",
	"RIGHTWARDS HARPOON WITH BARB DOWN ABOVE LEFTWARDS HARPOON WITH BARB DOWN",
	"LEFTWARDS HARPOON WITH BARB UP ABOVE LONG DASH",
	"LEFTWARDS HARPOON WITH BARB DOWN BELOW LONG DASH",
	"RIGHTWARDS HARPOON WITH BARB UP ABOVE LONG DASH",
	"RIGHTWARDS HARPOON WITH BARB DOWN BELOW LONG DASH",
	"UPWARDS HARPOON WITH BARB LEFT BESIDE DOWNWARDS HARPOON WITH BARB RIGHT",
	"DOWNWARDS HARPOON WITH BARB LEFT BESIDE UPWARDS HARPOON WITH BARB RIGHT",
	"RIGHT DOUBLE ARROW WITH ROUNDED HEAD",
	"EQUALS SIGN ABOVE RIGHTWARDS ARROW",
	"TILDE OPERATOR ABOVE RIGHTWARDS ARROW",
	"LEFTWARDS ARROW ABOVE TILDE OPERATOR",
	"RIGHTWARDS ARROW ABOVE TILDE OPERATOR",
	"RIGHTWARDS ARROW ABOVE ALMOST EQUAL TO",
	"LESS-THAN ABOVE LEFTWARDS ARROW",
	"LEFTWARDS ARROW THROUGH LESS-THAN",
	"GREATER-THAN ABOVE RIGHTWARDS ARROW",
	"SUBSET ABOVE RIGHTWARDS ARROW",
	"LEFTWARDS ARROW THROUGH SUBSET",
	"SUPERSET ABOVE LEFTWARDS ARROW",
	"LEFT FISH TAIL",
	"RIGHT FISH TAIL",
	"UP FISH TAIL",
	"DOWN FISH TAIL",
	"TRIPLE VERTICAL BAR DELIMITER",
	"Z NOTATION SPOT",
	"Z NOTATION TYPE COLON",
	"LEFT WHITE CURLY BRACKET",
	"RIGHT WHITE CURLY BRACKET",
	"LEFT WHITE PARENTHESIS",
	"RIGHT WHITE PARENTHESIS",
	"Z NOTATION LEFT IMAGE BRACKET",
	"Z NOTATION RIGHT IMAGE BRACKET",
	"Z NOTATION LEFT BINDING BRACKET",
	"Z NOTATION RIGHT BINDING BRACKET",
	"LEFT SQUARE BRACKET WITH UNDERBAR",
	"RIGHT SQUARE BRACKET WITH UNDERBAR",
	"LEFT SQUARE BRACKET WITH TICK IN TOP CORNER",
	"RIGHT SQUARE BRACKET WITH TICK IN BOTTOM CORNER",
	"LEFT SQUARE BRACKET WITH TICK IN BOTTOM CORNER",
	"RIGHT SQUARE BRACKET WITH TICK IN TOP CORNER",
	"LEFT ANGLE BRACKET WITH DOT",
	"RIGHT ANGLE BRACKET WITH DOT",
	"LEFT ARC LESS-THAN BRACKET",
	"RIGHT ARC GREATER-THAN BRACKET",
	"DOUBLE LEFT ARC GREATER-THAN BRACKET",
	"DOUBLE RIGHT ARC LESS-THAN BRACKET",
	"LEFT BLACK TORTOISE SHELL BRACKET",
	"RIGHT BLACK TORTOISE SHELL BRACKET",
	"DOTTED FENCE",
	"VERTICAL ZIGZAG LINE",
	"MEASURED ANGLE OPENING LEFT",
	"RIGHT ANGLE VARIANT WITH SQUARE",
	"MEASURED RIGHT ANGLE WITH DOT",
	"ANGLE WITH S INSIDE",
	"ACUTE ANGLE",
	"SPHERICAL ANGLE OPENING LEFT",
	"SPHERICAL ANGLE OPENING UP",
	"TURNED ANGLE",
	"REVERSED ANGLE",
	"ANGLE WITH UNDERBAR",
	"REVERSED ANGLE WITH UNDERBAR",
	"OBLIQUE ANGLE OPENING UP",
	"OBLIQUE ANGLE OPENING DOWN",
	"MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING UP AND RIGHT",
	"MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING UP AND LEFT",
	"MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING DOWN AND RIGHT",
	"MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING DOWN AND LEFT",
	"MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING RIGHT AND UP",
	"MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING LEFT AND UP",
	"MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING RIGHT AND DOWN",
	"MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING LEFT AND DOWN",
	"REVERSED EMPTY SET",
	"EMPTY SET WITH OVERBAR",
	"EMPTY SET WITH SMALL CIRCLE ABOVE",
	"EMPTY SET WITH RIGHT ARROW ABOVE",
	"EMPTY SET WITH LEFT ARROW ABOVE",
	"CIRCLE WITH HORIZONTAL BAR",
	"CIRCLED VERTICAL BAR",
	"CIRCLED PARALLEL",
	"CIRCLED REVERSE SOLIDUS",
	"CIRCLED PERPENDICULAR",
	"CIRCLE DIVIDED BY HORIZONTAL BAR AND TOP HALF DIVIDED BY VERTICAL BAR",
	"CIRCLE WITH SUPERIMPOSED X",
	"CIRCLED ANTICLOCKWISE-ROTATED DIVISION SIGN",
	"UP ARROW THROUGH CIRCLE",
	"CIRCLED WHITE BULLET",
	"CIRCLED BULLET",
	"CIRCLED LESS-THAN",
	"CIRCLED GREATER-THAN",
	"CIRCLE WITH SMALL CIRCLE TO THE RIGHT",
	"CIRCLE WITH TWO HORIZONTAL STROKES TO THE RIGHT",
	"SQUARED RISING DIAGONAL SLASH",
	"SQUARED FALLING DIAGONAL SLASH",
	"SQUARED ASTERISK",
	"SQUARED SMALL CIRCLE",
	"SQUARED SQUARE",
	"TWO JOINED SQUARES",
	"TRIANGLE WITH DOT ABOVE",
	"TRIANGLE WITH UNDERBAR",
	"S IN TRIANGLE",
	"TRIANGLE WITH SERIFS AT BOTTOM",
	"RIGHT TRIANGLE ABOVE LEFT TRIANGLE",
	"LEFT TRIANGLE BESIDE VERTICAL BAR",
	"VERTICAL BAR BESIDE RIGHT TRIANGLE",
	"BOWTIE WITH LEFT HALF BLACK",
	"BOWTIE WITH RIGHT HALF BLACK",
	"BLACK BOWTIE",
	"TIMES WITH LEFT HALF BLACK",
	"TIMES WITH RIGHT HALF BLACK",
	"WHITE HOURGLASS",
	"BLACK HOURGLASS",
	"LEFT WIGGLY FENCE",
	"RIGHT WIGGLY FENCE",
	"LEFT DOUBLE WIGGLY FENCE",
	"RIGHT DOUBLE WIGGLY FENCE",
	"INCOMPLETE INFINITY",
	"TIE OVER INFINITY",
	"INFINITY NEGATED WITH VERTICAL BAR",
	"DOUBLE-ENDED MULTIMAP",
	"SQUARE WITH CONTOURED OUTLINE",
	"INCREASES AS",
	"SHUFFLE PRODUCT",
	"EQUALS SIGN AND SLANTED PARALLEL",
	"EQUALS SIGN AND SLANTED PARALLEL WITH TILDE ABOVE",
	"IDENTICAL TO AND SLANTED PARALLEL",
	"GLEICH STARK",
	"THERMODYNAMIC",
	"DOWN-POINTING TRIANGLE WITH LEFT HALF BLACK",
	"DOWN-POINTING TRIANGLE WITH RIGHT HALF BLACK",
	"BLACK DIAMOND WITH DOWN ARROW",
	"BLACK LOZENGE",
	"WHITE CIRCLE WITH DOWN ARROW",
	"BLACK CIRCLE WITH DOWN ARROW",
	"ERROR-BARRED WHITE SQUARE",
	"ERROR-BARRED BLACK SQUARE",
	"ERROR-BARRED WHITE DIAMOND",
	"ERROR-BARRED BLACK DIAMOND",
	"ERROR-BARRED WHITE CIRCLE",
	"ERROR-BARRED BLACK CIRCLE",
	"RULE-DELAYED",
	"REVERSE SOLIDUS OPERATOR",
	"SOLIDUS WITH OVERBAR",
	"REVERSE SOLIDUS WITH HORIZONTAL STROKE",
	"BIG SOLIDUS",
	"BIG REVERSE SOLIDUS",
	"DOUBLE PLUS",
	"TRIPLE PLUS",
	"LEFT-POINTING CURVED ANGLE BRACKET",
	"RIGHT-POINTING CURVED ANGLE BRACKET",
	"TINY",
	"MINY",
	"N-ARY CIRCLED DOT OPERATOR",
	"N-ARY CIRCLED PLUS OPERATOR",
	"N-ARY CIRCLED TIMES OPERATOR",
	"N-ARY UNION OPERATOR WITH DOT",
	"N-ARY UNION OPERATOR WITH PLUS",
	"N-ARY SQUARE INTERSECTION OPERATOR",
	"N-ARY SQUARE UNION OPERATOR",
	"TWO LOGICAL AND OPERATOR",
	"TWO LOGICAL OR OPERATOR",
	"N-ARY TIMES OPERATOR",
	"MODULO TWO SUM",
	"SUMMATION WITH INTEGRAL",
	"QUADRUPLE INTEGRAL OPERATOR",
	"FINITE PART INTEGRAL",
	"INTEGRAL WITH DOUBLE STROKE",
	"INTEGRAL AVERAGE WITH SLASH",
	"CIRCULATION FUNCTION",
	"ANTICLOCKWISE INTEGRATION",
	"LINE INTEGRATION WITH RECTANGULAR PATH AROUND POLE",
	"LINE INTEGRATION WITH SEMICIRCULAR PATH AROUND POLE",
	"LINE INTEGRATION NOT INCLUDING THE POLE",
	"INTEGRAL AROUND A POINT OPERATOR",
	"QUATERNION INTEGRAL OPERATOR",
	"INTEGRAL WITH LEFTWARDS ARROW WITH HOOK",
	"INTEGRAL WITH TIMES SIGN",
	"INTEGRAL WITH INTERSECTION",
	"INTEGRAL WITH UNION",
	"INTEGRAL WITH OVERBAR",
	"INTEGRAL WITH UNDERBAR",
	"JOIN",
	"LARGE LEFT TRIANGLE OPERATOR",
	"Z NOTATION SCHEMA COMPOSITION",
	"Z NOTATION SCHEMA PIPING",
	"Z NOTATION SCHEMA PROJECTION",
	"PLUS SIGN WITH SMALL CIRCLE ABOVE",
	"PLUS SIGN WITH CIRCUMFLEX ACCENT ABOVE",
	"PLUS SIGN WITH TILDE ABOVE",
	"PLUS SIGN WITH DOT BELOW",
	"PLUS SIGN WITH TILDE BELOW",
	"PLUS SIGN WITH SUBSCRIPT TWO",
	"PLUS SIGN WITH BLACK TRIANGLE",
	"MINUS SIGN WITH COMMA ABOVE",
	"MINUS SIGN WITH DOT BELOW",
	"MINUS SIGN WITH FALLING DOTS",
	"MINUS SIGN WITH RISING DOTS",
	"PLUS SIGN IN LEFT HALF CIRCLE",
	"PLUS SIGN IN RIGHT HALF CIRCLE",
	"VECTOR OR CROSS PRODUCT",
	"MULTIPLICATION SIGN WITH DOT ABOVE",
	"MULTIPLICATION SIGN WITH UNDERBAR",
	"SEMIDIRECT PRODUCT WITH BOTTOM CLOSED",
	"SMASH PRODUCT",
	"MULTIPLICATION SIGN IN LEFT HALF CIRCLE",
	"MULTIPLICATION SIGN IN RIGHT HALF CIRCLE",
	"CIRCLED MULTIPLICATION SIGN WITH CIRCUMFLEX ACCENT",
	"MULTIPLICATION SIGN IN DOUBLE CIRCLE",
	"CIRCLED DIVISION SIGN",
	"PLUS SIGN IN TRIANGLE",
	"MINUS SIGN IN TRIANGLE",
	"MULTIPLICATION SIGN IN TRIANGLE",
	"INTERIOR PRODUCT",
	"RIGHTHAND INTERIOR PRODUCT",
	"Z NOTATION RELATIONAL COMPOSITION",
	"AMALGAMATION OR COPRODUCT",
	"INTERSECTION WITH DOT",
	"UNION WITH MINUS SIGN",
	"UNION WITH OVERBAR",
	"INTERSECTION WITH OVERBAR",
	"INTERSECTION WITH LOGICAL AND",
	"UNION WITH LOGICAL OR",
	"UNION ABOVE INTERSECTION",
	"INTERSECTION ABOVE UNION",
	"UNION ABOVE BAR ABOVE INTERSECTION",
	"INTERSECTION ABOVE BAR ABOVE UNION",
	"UNION BESIDE AND JOINED WITH UNION",
	"INTERSECTION BESIDE AND JOINED WITH INTERSECTION",
	"CLOSED UNION WITH SERIFS",
	"CLOSED INTERSECTION WITH SERIFS",
	"DOUBLE SQUARE INTERSECTION",
	"DOUBLE SQUARE UNION",
	"CLOSED UNION WITH SERIFS AND SMASH PRODUCT",
	"LOGICAL AND WITH DOT ABOVE",
	"LOGICAL OR WITH DOT ABOVE",
	"DOUBLE LOGICAL AND",
	"DOUBLE LOGICAL OR",
	"TWO INTERSECTING LOGICAL AND",
	"TWO INTERSECTING LOGICAL OR",
	"SLOPING LARGE OR",
	"SLOPING LARGE AND",
	"LOGICAL OR OVERLAPPING LOGICAL AND",
	"LOGICAL AND WITH MIDDLE STEM",
	"LOGICAL OR WITH MIDDLE STEM",
	"LOGICAL AND WITH HORIZONTAL DASH",
	"LOGICAL OR WITH HORIZONTAL DASH",
	"LOGICAL AND WITH DOUBLE OVERBAR",
	"LOGICAL AND WITH UNDERBAR",
	"LOGICAL AND WITH DOUBLE UNDERBAR",
	"SMALL VEE WITH UNDERBAR",
	"LOGICAL OR WITH DOUBLE OVERBAR",
	"LOGICAL OR WITH DOUBLE UNDERBAR",
	"Z NOTATION DOMAIN ANTIRESTRICTION",
	"Z NOTATION RANGE ANTIRESTRICTION",
	"EQUALS SIGN WITH DOT BELOW",
	"IDENTICAL WITH DOT ABOVE",
	"TRIPLE HORIZONTAL BAR WITH DOUBLE VERTICAL STROKE",
	"TRIPLE HORIZONTAL BAR WITH TRIPLE VERTICAL STROKE",
	"TILDE OPERATOR WITH DOT ABOVE",
	"TILDE OPERATOR WITH RISING DOTS",
	"SIMILAR MINUS SIMILAR",
	"CONGRUENT WITH DOT ABOVE",
	"EQUALS WITH ASTERISK",
	"ALMOST EQUAL TO WITH CIRCUMFLEX ACCENT",
	"APPROXIMATELY EQUAL OR EQUAL TO",
	"EQUALS SIGN ABOVE PLUS SIGN",
	"PLUS SIGN ABOVE EQUALS SIGN",
	"EQUALS SIGN ABOVE TILDE OPERATOR",
	"DOUBLE COLON EQUAL",
	"TWO CONSECUTIVE EQUALS SIGNS",
	"THREE CONSECUTIVE EQUALS SIGNS",
	"EQUALS SIGN WITH TWO DOTS ABOVE AND TWO DOTS BELOW",
	"EQUIVALENT WITH FOUR DOTS ABOVE",
	"LESS-THAN WITH CIRCLE INSIDE",
	"GREATER-THAN WITH CIRCLE INSIDE",
	"LESS-THAN WITH QUESTION MARK ABOVE",
	"GREATER-THAN WITH QUESTION MARK ABOVE",
	"LESS-THAN OR SLANTED EQUAL TO",
	"GREATER-THAN OR SLANTED EQUAL TO",
	"LESS-THAN OR SLANTED EQUAL TO WITH DOT INSIDE",
	"GREATER-THAN OR SLANTED EQUAL TO WITH DOT INSIDE",
	"LESS-THAN OR SLANTED EQUAL TO WITH DOT ABOVE",
	"GREATER-THAN OR SLANTED EQUAL TO WITH DOT ABOVE",
	"LESS-THAN OR SLANTED EQUAL TO WITH DOT ABOVE RIGHT",
	"GREATER-THAN OR SLANTED EQUAL TO WITH DOT ABOVE LEFT",
	"LESS-THAN OR APPROXIMATE",
	"GREATER-THAN OR APPROXIMATE",
	"LESS-THAN AND SINGLE-LINE NOT EQUAL TO",
	"GREATER-THAN AND SINGLE-LINE NOT EQUAL TO",
	"LESS-THAN AND NOT APPROXIMATE",
	"GREATER-THAN AND NOT APPROXIMATE",
	"LESS-THAN ABOVE DOUBLE-LINE EQUAL ABOVE GREATER-THAN",
	"GREATER-THAN ABOVE DOUBLE-LINE EQUAL ABOVE LESS-THAN",
	"LESS-THAN ABOVE SIMILAR OR EQUAL",
	"GREATER-THAN ABOVE SIMILAR OR EQUAL",
	"LESS-THAN ABOVE SIMILAR ABOVE GREATER-THAN",
	"GREATER-THAN ABOVE SIMILAR ABOVE LESS-THAN",
	"LESS-THAN ABOVE GREATER-THAN ABOVE DOUBLE-LINE EQUAL",
	"GREATER-THAN ABOVE LESS-THAN ABOVE DOUBLE-LINE EQUAL",
	"LESS-THAN ABOVE SLANTED EQUAL ABOVE GREATER-THAN ABOVE SLANTED EQUAL",
	"GREATER-THAN ABOVE SLANTED EQUAL ABOVE LESS-THAN ABOVE SLANTED EQUAL",
	"SLANTED EQUAL TO OR LESS-THAN",
	"SLANTED EQUAL TO OR GREATER-THAN",
	"SLANTED EQUAL TO OR LESS-THAN WITH DOT INSIDE",
	"SLANTED EQUAL TO OR GREATER-THAN WITH DOT INSIDE",
	"DOUBLE-LINE EQUAL TO OR LESS-THAN",
	"DOUBLE-LINE EQUAL TO OR GREATER-THAN",
	"DOUBLE-LINE SLANTED EQUAL TO OR LESS-THAN",
	"DOUBLE-LINE SLANTED EQUAL TO OR GREATER-THAN",
	"SIMILAR OR LESS-THAN",
	"SIMILAR OR GREATER-THAN",
	"SIMILAR ABOVE LESS-THAN ABOVE EQUALS SIGN",
	"SIMILAR ABOVE GREATER-THAN ABOVE EQUALS SIGN",
	"DOUBLE NESTED LESS-THAN",
	"DOUBLE NESTED GREATER-THAN",
	"DOUBLE NESTED LESS-THAN WITH UNDERBAR",
	"GREATER-THAN OVERLAPPING LESS-THAN",
	"GREATER-THAN BESIDE LESS-THAN",
	"LESS-THAN CLOSED BY CURVE",
	"GREATER-THAN CLOSED BY CURVE",
	"LESS-THAN CLOSED BY CURVE ABOVE SLANTED EQUAL",
	"GREATER-THAN CLOSED BY CURVE ABOVE SLANTED EQUAL",
	"SMALLER THAN",
	"LARGER THAN",
	"SMALLER THAN OR EQUAL TO",
	"LARGER THAN OR EQUAL TO",
	"EQUALS SIGN WITH BUMPY ABOVE",
	"PRECEDES ABOVE SINGLE-LINE EQUALS SIGN",
	"SUCCEEDS ABOVE SINGLE-LINE EQUALS SIGN",
	"PRECEDES ABOVE SINGLE-LINE NOT EQUAL TO",
	"SUCCEEDS ABOVE SINGLE-LINE NOT EQUAL TO",
	"PRECEDES ABOVE EQUALS SIGN",
	"SUCCEEDS ABOVE EQUALS SIGN",
	"PRECEDES ABOVE NOT EQUAL TO",
	"SUCCEEDS ABOVE NOT EQUAL TO",
	"PRECEDES ABOVE ALMOST EQUAL TO",
	"SUCCEEDS ABOVE ALMOST EQUAL TO",
	"PRECEDES ABOVE NOT ALMOST EQUAL TO",
	"SUCCEEDS ABOVE NOT ALMOST EQUAL TO",
	"DOUBLE PRECEDES",
	"DOUBLE SUCCEEDS",
	"SUBSET WITH DOT",
	"SUPERSET WITH DOT",
	"SUBSET WITH PLUS SIGN BELOW",
	"SUPERSET WITH PLUS SIGN BELOW",
	"SUBSET WITH MULTIPLICATION SIGN BELOW",
	"SUPERSET WITH MULTIPLICATION SIGN BELOW",
	"SUBSET OF OR EQUAL TO WITH DOT ABOVE",
	"SUPERSET OF OR EQUAL TO WITH DOT ABOVE",
	"SUBSET OF ABOVE EQUALS SIGN",
	"SUPERSET OF ABOVE EQUALS SIGN",
	"SUBSET OF ABOVE TILDE OPERATOR",
	"SUPERSET OF ABOVE TILDE OPERATOR",
	"SUBSET OF ABOVE ALMOST EQUAL TO",
	"SUPERSET OF ABOVE ALMOST EQUAL TO",
	"SUBSET OF ABOVE NOT EQUAL TO",
	"SUPERSET OF ABOVE NOT EQUAL TO",
	"SQUARE LEFT OPEN BOX OPERATOR",
	"SQUARE RIGHT OPEN BOX OPERATOR",
	"CLOSED SUBSET",
	"CLOSED SUPERSET",
	"CLOSED SUBSET OR EQUAL TO",
	"CLOSED SUPERSET OR EQUAL TO",
	"SUBSET ABOVE SUPERSET",
	"SUPERSET ABOVE SUBSET",
	"SUBSET ABOVE SUBSET",
	"SUPERSET ABOVE SUPERSET",
	"SUPERSET BESIDE SUBSET",
	"SUPERSET BESIDE AND JOINED BY DASH WITH SUBSET",
	"ELEMENT OF OPENING DOWNWARDS",
	"PITCHFORK WITH TEE TOP",
	"TRANSVERSAL INTERSECTION",
	"FORKING",
	"NONFORKING",
	"SHORT LEFT TACK",
	"SHORT DOWN TACK",
	"SHORT UP TACK",
	"PERPENDICULAR WITH S",
	"VERTICAL BAR TRIPLE RIGHT TURNSTILE",
	"DOUBLE VERTICAL BAR LEFT TURNSTILE",
	"VERTICAL BAR DOUBLE LEFT TURNSTILE",
	"DOUBLE VERTICAL BAR DOUBLE LEFT TURNSTILE",
	"LONG DASH FROM LEFT MEMBER OF DOUBLE VERTICAL",
	"SHORT DOWN TACK WITH OVERBAR",
	"SHORT UP TACK WITH UNDERBAR",
	"SHORT UP TACK ABOVE SHORT DOWN TACK",
	"DOUBLE DOWN TACK",
	"DOUBLE UP TACK",
	"DOUBLE STROKE NOT SIGN",
	"REVERSED DOUBLE STROKE NOT SIGN",
	"DOES NOT DIVIDE WITH REVERSED NEGATION SLASH",
	"VERTICAL LINE WITH CIRCLE ABOVE",
	"VERTICAL LINE WITH CIRCLE BELOW",
	"DOWN TACK WITH CIRCLE BELOW",
	"PARALLEL WITH HORIZONTAL STROKE",
	"PARALLEL WITH TILDE OPERATOR",
	"TRIPLE VERTICAL BAR BINARY RELATION",
	"TRIPLE VERTICAL BAR WITH HORIZONTAL STROKE",
	"TRIPLE COLON OPERATOR",
	"TRIPLE NESTED LESS-THAN",
	"TRIPLE NESTED GREATER-THAN",
	"DOUBLE-LINE SLANTED LESS-THAN OR EQUAL TO",
	"DOUBLE-LINE SLANTED GREATER-THAN OR EQUAL TO",
	"TRIPLE SOLIDUS BINARY RELATION",
	"LARGE TRIPLE VERTICAL BAR OPERATOR",
	"DOUBLE SOLIDUS OPERATOR",
	"WHITE VERTICAL BAR",
	"N-ARY WHITE VERTICAL BAR",
	"NORTH EAST WHITE ARROW",
	"NORTH WEST WHITE ARROW",
	"SOUTH EAST WHITE ARROW",
	"SOUTH WEST WHITE ARROW",
	"LEFT RIGHT WHITE ARROW",
	"LEFTWARDS BLACK ARROW",
	"UPWARDS BLACK ARROW",
	"DOWNWARDS BLACK ARROW",
	"NORTH EAST BLACK ARROW",
	"NORTH WEST BLACK ARROW",
	"SOUTH EAST BLACK ARROW",
	"SOUTH WEST BLACK ARROW",
	"LEFT RIGHT BLACK ARROW",
	"UP DOWN BLACK ARROW",
	"RIGHTWARDS ARROW WITH TIP DOWNWARDS",
	"RIGHTWARDS ARROW WITH TIP UPWARDS",
	"LEFTWARDS ARROW WITH TIP DOWNWARDS",
	"LEFTWARDS ARROW WITH TIP UPWARDS",
	"SQUARE WITH TOP HALF BLACK",
	"SQUARE WITH BOTTOM HALF BLACK",
	"SQUARE WITH UPPER RIGHT DIAGONAL HALF BLACK",
	"SQUARE WITH LOWER LEFT DIAGONAL HALF BLACK",
	"DIAMOND WITH LEFT HALF BLACK",
	"DIAMOND WITH RIGHT HALF BLACK",
	"DIAMOND WITH TOP HALF BLACK",
	"DIAMOND WITH BOTTOM HALF BLACK",
	"DOTTED SQUARE",
	"BLACK LARGE SQUARE",
	"WHITE LARGE SQUARE",
	"BLACK VERY SMALL SQUARE",
	"WHITE VERY SMALL SQUARE",
	"BLACK PENTAGON",
	"WHITE PENTAGON",
	"WHITE HEXAGON",
	"BLACK HEXAGON",
	"HORIZONTAL BLACK HEXAGON",
	"BLACK LARGE CIRCLE",
	"BLACK MEDIUM DIAMOND",
	"WHITE MEDIUM DIAMOND",
	"BLACK MEDIUM LOZENGE",
	"WHITE MEDIUM LOZENGE",
	"BLACK SMALL DIAMOND",
	"BLACK SMALL LOZENGE",
	"WHITE SMALL LOZENGE",
	"BLACK HORIZONTAL ELLIPSE",
	"WHITE HORIZONTAL ELLIPSE",
	"BLACK VERTICAL ELLIPSE",
	"WHITE VERTICAL ELLIPSE",
	"LEFT ARROW WITH SMALL CIRCLE",
	"THREE LEFTWARDS ARROWS",
	"LEFT ARROW WITH CIRCLED PLUS",
	"LONG LEFTWARDS SQUIGGLE ARROW",
	"LEFTWARDS TWO-HEADED ARROW WITH VERTICAL STROKE",
	"LEFTWARDS TWO-HEADED ARROW WITH DOUBLE VERTICAL STROKE",
	"LEFTWARDS TWO-HEADED ARROW FROM BAR",
	"LEFTWARDS TWO-HEADED TRIPLE DASH ARROW",
	"LEFTWARDS ARROW WITH DOTTED STEM",
	"LEFTWARDS ARROW WITH TAIL WITH VERTICAL STROKE",
	"LEFTWARDS ARROW WITH TAIL WITH DOUBLE VERTICAL STROKE",
	"LEFTWARDS TWO-HEADED ARROW WITH TAIL",
	"LEFTWARDS TWO-HEADED ARROW WITH TAIL WITH VERTICAL STROKE",
	"LEFTWARDS TWO-HEADED ARROW WITH TAIL WITH DOUBLE VERTICAL STROKE",
	"LEFTWARDS ARROW THROUGH X",
	"WAVE ARROW POINTING DIRECTLY LEFT",
	"EQUALS SIGN ABOVE LEFTWARDS ARROW",
	"REVERSE TILDE OPERATOR ABOVE LEFTWARDS ARROW",
	"LEFTWARDS ARROW ABOVE REVERSE ALMOST EQUAL TO",
	"RIGHTWARDS ARROW THROUGH GREATER-THAN",
	"RIGHTWARDS ARROW THROUGH SUPERSET",
	"LEFTWARDS QUADRUPLE ARROW",
	"RIGHTWARDS QUADRUPLE ARROW",
	"REVERSE TILDE OPERATOR ABOVE RIGHTWARDS ARROW",
	"RIGHTWARDS ARROW ABOVE REVERSE ALMOST EQUAL TO",
	"TILDE OPERATOR ABOVE LEFTWARDS ARROW",
	"LEFTWARDS ARROW ABOVE ALMOST EQUAL TO",
	"LEFTWARDS ARROW ABOVE REVERSE TILDE OPERATOR",
	"RIGHTWARDS ARROW ABOVE REVERSE TILDE OPERATOR",
	"DOWNWARDS TRIANGLE-HEADED ZIGZAG ARROW",
	"SHORT SLANTED NORTH ARROW",
	"SHORT BACKSLANTED SOUTH ARROW",
	"WHITE MEDIUM STAR",
	"BLACK SMALL STAR",
	"WHITE SMALL STAR",
	"BLACK RIGHT-POINTING PENTAGON",
	"WHITE RIGHT-POINTING PENTAGON",
	"HEAVY LARGE CIRCLE",
	"HEAVY OVAL WITH OVAL INSIDE",
	"HEAVY CIRCLE WITH CIRCLE INSIDE",
	"HEAVY CIRCLE",
	"HEAVY CIRCLED SALTIRE",
	"SLANTED NORTH ARROW WITH HOOKED HEAD",
	"BACKSLANTED SOUTH ARROW WITH HOOKED TAIL",
	"SLANTED NORTH ARROW WITH HORIZONTAL TAIL",
	"BACKSLANTED SOUTH ARROW WITH HORIZONTAL TAIL",
	"BENT ARROW POINTING DOWNWARDS THEN NORTH EAST",
	"SHORT BENT ARROW POINTING DOWNWARDS THEN NORTH EAST",
	"LEFTWARDS TRIANGLE-HEADED ARROW",
	"UPWARDS TRIANGLE-HEADED ARROW",
	"RIGHTWARDS TRIANGLE-HEADED ARROW",
	"DOWNWARDS TRIANGLE-HEADED ARROW",
	"LEFT RIGHT TRIANGLE-HEADED ARROW",
	"UP DOWN TRIANGLE-HEADED ARROW",
	"NORTH WEST TRIANGLE-HEADED ARROW",
	"NORTH EAST TRIANGLE-HEADED ARROW",
	"SOUTH EAST TRIANGLE-HEADED ARROW",
	"SOUTH WEST TRIANGLE-HEADED ARROW",
	"LEFTWARDS TRIANGLE-HEADED DASHED ARROW",
	"UPWARDS TRIANGLE-HEADED DASHED ARROW",
	"RIGHTWARDS TRIANGLE-HEADED DASHED ARROW",
	"DOWNWARDS TRIANGLE-HEADED DASHED ARROW",
	"CLOCKWISE TRIANGLE-HEADED OPEN CIRCLE ARROW",
	"ANTICLOCKWISE TRIANGLE-HEADED OPEN CIRCLE ARROW",
	"LEFTWARDS TRIANGLE-HEADED ARROW TO BAR",
	"UPWARDS TRIANGLE-HEADED ARROW TO BAR",
	"RIGHTWARDS TRIANGLE-HEADED ARROW TO BAR",
	"DOWNWARDS TRIANGLE-HEADED ARROW TO BAR",
	"NORTH WEST TRIANGLE-HEADED ARROW TO BAR",
	"NORTH EAST TRIANGLE-HEADED ARROW TO BAR",
	"SOUTH EAST TRIANGLE-HEADED ARROW TO BAR",
	"SOUTH WEST TRIANGLE-HEADED ARROW TO BAR",
	"LEFTWARDS TRIANGLE-HEADED ARROW WITH DOUBLE HORIZONTAL STROKE",
	"UPWARDS TRIANGLE-HEADED ARROW WITH DOUBLE HORIZONTAL STROKE",
	"RIGHTWARDS TRIANGLE-HEADED ARROW WITH DOUBLE HORIZONTAL STROKE",
	"DOWNWARDS TRIANGLE-HEADED ARROW WITH DOUBLE HORIZONTAL STROKE",
	"HORIZONTAL TAB KEY",
	"VERTICAL TAB KEY",
	"LEFTWARDS TRIANGLE-HEADED ARROW OVER RIGHTWARDS TRIANGLE-HEADED ARROW",
	"UPWARDS TRIANGLE-HEADED ARROW LEFTWARDS OF DOWNWARDS TRIANGLE-HEADED ARROW",
	"RIGHTWARDS TRIANGLE-HEADED ARROW OVER LEFTWARDS TRIANGLE-HEADED ARROW",
	"DOWNWARDS TRIANGLE-HEADED ARROW LEFTWARDS OF UPWARDS TRIANGLE-HEADED ARROW",
	"LEFTWARDS TRIANGLE-HEADED PAIRED ARROWS",
	"UPWARDS TRIANGLE-HEADED PAIRED ARROWS",
	"RIGHTWARDS TRIANGLE-HEADED PAIRED ARROWS",
	"DOWNWARDS TRIANGLE-HEADED PAIRED ARROWS",
	"LEFTWARDS BLACK CIRCLED WHITE ARROW",
	"UPWARDS BLACK CIRCLED WHITE ARROW",
	"RIGHTWARDS BLACK CIRCLED WHITE ARROW",
	"DOWNWARDS BLACK CIRCLED WHITE ARROW",
	"ANTICLOCKWISE TRIANGLE-HEADED RIGHT U-SHAPED ARROW",
	"ANTICLOCKWISE TRIANGLE-HEADED BOTTOM U-SHAPED ARROW",
	"ANTICLOCKWISE TRIANGLE-HEADED LEFT U-SHAPED ARROW",
	"ANTICLOCKWISE TRIANGLE-HEADED TOP U-SHAPED ARROW",
	"RETURN LEFT",
	"RETURN RIGHT",
	"NEWLINE LEFT",
	"NEWLINE RIGHT",
	"FOUR CORNER ARROWS CIRCLING ANTICLOCKWISE",
	"RIGHTWARDS BLACK ARROW",
	"SYMBOL FOR TYPE A ELECTRONICS",
	"THREE-D TOP-LIGHTED LEFTWARDS EQUILATERAL ARROWHEAD",
	"THREE-D RIGHT-LIGHTED UPWARDS EQUILATERAL ARROWHEAD",
	"THREE-D TOP-LIGHTED RIGHTWARDS EQUILATERAL ARROWHEAD",
	"THREE-D LEFT-LIGHTED DOWNWARDS EQUILATERAL ARROWHEAD",
	"BLACK LEFTWARDS EQUILATERAL ARROWHEAD",
	"BLACK UPWARDS EQUILATERAL ARROWHEAD",
	"BLACK RIGHTWARDS EQUILATERAL ARROWHEAD",
	"BLACK DOWNWARDS EQUILATERAL ARROWHEAD",
	"DOWNWARDS TRIANGLE-HEADED ARROW WITH LONG TIP LEFTWARDS",
	"DOWNWARDS TRIANGLE-HEADED ARROW WITH LONG TIP RIGHTWARDS",
	"UPWARDS TRIANGLE-HEADED ARROW WITH LONG TIP LEFTWARDS",
	"UPWARDS TRIANGLE-HEADED ARROW WITH LONG TIP RIGHTWARDS",
	"LEFTWARDS TRIANGLE-HEADED ARROW WITH LONG TIP UPWARDS",
	"RIGHTWARDS TRIANGLE-HEADED ARROW WITH LONG TIP UPWARDS",
	"LEFTWARDS TRIANGLE-HEADED ARROW WITH LONG TIP DOWNWARDS",
	"RIGHTWARDS TRIANGLE-HEADED ARROW WITH LONG TIP DOWNWARDS",
	"BLACK CURVED DOWNWARDS AND LEFTWARDS ARROW",
	"BLACK CURVED DOWNWARDS AND RIGHTWARDS ARROW",
	"BLACK CURVED UPWARDS AND LEFTWARDS ARROW",
	"BLACK CURVED UPWARDS AND RIGHTWARDS ARROW",
	"BLACK CURVED LEFTWARDS AND UPWARDS ARROW",
	"BLACK CURVED RIGHTWARDS AND UPWARDS ARROW",
	"BLACK CURVED LEFTWARDS AND DOWNWARDS ARROW",
	"BLACK CURVED RIGHTWARDS AND DOWNWARDS ARROW",
	"RIBBON ARROW DOWN LEFT",
	"RIBBON ARROW DOWN RIGHT",
	"RIBBON ARROW UP LEFT",
	"RIBBON ARROW UP RIGHT",
	"RIBBON ARROW LEFT UP",
	"RIBBON ARROW RIGHT UP",
	"RIBBON ARROW LEFT DOWN",
	"RIBBON ARROW RIGHT DOWN",
	"UPWARDS WHITE ARROW FROM BAR WITH HORIZONTAL BAR",
	"UP ARROWHEAD IN A RECTANGLE BOX",
	"OVERLAPPING WHITE SQUARES",
	"OVERLAPPING WHITE AND BLACK SQUARES",
	"OVERLAPPING BLACK SQUARES",
	"BALLOT BOX WITH LIGHT X",
	"CIRCLED X",
	"CIRCLED BOLD X",
	"BLACK SQUARE CENTRED",
	"BLACK DIAMOND CENTRED",
	"TURNED BLACK PENTAGON",
	"HORIZONTAL BLACK OCTAGON",
	"BLACK OCTAGON",
	"BLACK MEDIUM UP-POINTING TRIANGLE CENTRED",
	"BLACK MEDIUM DOWN-POINTING TRIANGLE CENTRED",
	"BLACK MEDIUM LEFT-POINTING TRIANGLE CENTRED",
	"BLACK MEDIUM RIGHT-POINTING TRIANGLE CENTRED",
	"NEPTUNE FORM TWO",
	"TOP HALF BLACK CIRCLE",
	"BOTTOM HALF BLACK CIRCLE",
	"LIGHT FOUR POINTED BLACK CUSP",
	"ROTATED LIGHT FOUR POINTED BLACK CUSP",
	"WHITE FOUR POINTED CUSP",
	"ROTATED WHITE FOUR POINTED CUSP",
	"SQUARE POSITION INDICATOR",
	"UNCERTAINTY SIGN",
	"GROUP MARK",
	"PLUTO FORM TWO",
	"PLUTO FORM THREE",
	"PLUTO FORM FOUR",
	"PLUTO FORM FIVE",
	"TRANSPLUTO",
	"PROSERPINA",
	"ASTRAEA",
	"HYGIEA",
	"PHOLUS",
	"NESSUS",
	"WHITE MOON SELENA",
	"BLACK DIAMOND ON CROSS",
	"TRUE LIGHT MOON ARTA",
	"CUPIDO",
	"HADES",
	"ZEUS",
	"KRONOS",
	"APOLLON",
	"ADMETOS",
	"VULCANUS",
	"POSEIDON",
	"LEFT HALF BLACK STAR",
	"RIGHT HALF BLACK STAR",
	"STAR WITH LEFT HALF BLACK",
	"STAR WITH RIGHT HALF BLACK",
	"LEFTWARDS TWO-HEADED ARROW WITH TRIANGLE ARROWHEADS",
	"UPWARDS TWO-HEADED ARROW WITH TRIANGLE ARROWHEADS",
	"RIGHTWARDS TWO-HEADED ARROW WITH TRIANGLE ARROWHEADS",
	"DOWNWARDS TWO-HEADED ARROW WITH TRIANGLE ARROWHEADS",
	"ERIS FORM ONE",
	"ERIS FORM TWO",
	"SEDNA",
	"RUSSIAN ASTROLOGICAL SYMBOL VIGINTILE",
	"RUSSIAN ASTROLOGICAL SYMBOL NOVILE",
	"RUSSIAN ASTROLOGICAL SYMBOL QUINTILE",
	"RUSSIAN ASTROLOGICAL SYMBOL BINOVILE",
	"RUSSIAN ASTROLOGICAL SYMBOL SENTAGON",
	"RUSSIAN ASTROLOGICAL SYMBOL TREDECILE",
	"EQUALS SIGN WITH INFINITY BELOW",
	"UNITED SYMBOL",
	"SEPARATED SYMBOL",
	"DOUBLED SYMBOL",
	"PASSED SYMBOL",
	"REVERSED RIGHT ANGLE",
	"HELLSCHREIBER PAUSE SYMBOL",
	"GLAGOLITIC CAPITAL LETTER AZU",
	"GLAGOLITIC CAPITAL LETTER BUKY",
	"GLAGOLITIC CAPITAL LETTER VEDE",
	"GLAGOLITIC CAPITAL LETTER GLAGOLI",
	"GLAGOLITIC CAPITAL LETTER DOBRO",
	"GLAGOLITIC CAPITAL LETTER YESTU",
	"GLAGOLITIC CAPITAL LETTER ZHIVETE",
	"GLAGOLITIC CAPITAL LETTER DZELO",
	"GLAGOLITIC CAPITAL LETTER ZEMLJA",
	"GLAGOLITIC CAPITAL LETTER IZHE",
	"GLAGOLITIC CAPITAL LETTER INITIAL IZHE",
	"GLAGOLITIC CAPITAL LETTER I",
	"GLAGOLITIC CAPITAL LETTER DJERVI",
	"GLAGOLITIC CAPITAL LETTER KAKO",
	"GLAGOLITIC CAPITAL LETTER LJUDIJE",
	"GLAGOLITIC CAPITAL LETTER MYSLITE",
	"GLAGOLITIC CAPITAL LETTER NASHI",
	"GLAGOLITIC CAPITAL LETTER ONU",
	"GLAGOLITIC CAPITAL LETTER POKOJI",
	"GLAGOLITIC CAPITAL LETTER RITSI",
	"GLAGOLITIC CAPITAL LETTER SLOVO",
	"GLAGOLITIC CAPITAL LETTER TVRIDO",
	"GLAGOLITIC CAPITAL LETTER UKU",
	"GLAGOLITIC CAPITAL LETTER FRITU",
	"GLAGOLITIC CAPITAL LETTER HERU",
	"GLAGOLITIC CAPITAL LETTER OTU",
	"GLAGOLITIC CAPITAL LETTER PE",
	"GLAGOLITIC CAPITAL LETTER SHTA",
	"GLAGOLITIC CAPITAL LETTER TSI",
	"GLAGOLITIC CAPITAL LETTER CHRIVI",
	"GLAGOLITIC CAPITAL LETTER SHA",
	"GLAGOLITIC CAPITAL LETTER YERU",
	"GLAGOLITIC CAPITAL LETTER YERI",
	"GLAGOLITIC CAPITAL LETTER YATI",
	"GLAGOLITIC CAPITAL LETTER SPIDERY HA",
	"GLAGOLITIC CAPITAL LETTER YU",
	"GLAGOLITIC CAPITAL LETTER SMALL YUS",
	"GLAGOLITIC CAPITAL LETTER SMALL YUS WITH TAIL",
	"GLAGOLITIC CAPITAL LETTER YO",
	"GLAGOLITIC CAPITAL LETTER IOTATED SMALL YUS",
	"GLAGOLITIC CAPITAL LETTER BIG YUS",
	"GLAGOLITIC CAPITAL LETTER IOTATED BIG YUS",
	"GLAGOLITIC CAPITAL LETTER FITA",
	"GLAGOLITIC CAPITAL LETTER IZHITSA",
	"GLAGOLITIC CAPITAL LETTER SHTAPIC",
	"GLAGOLITIC CAPITAL LETTER TROKUTASTI A",
	"GLAGOLITIC CAPITAL LETTER LATINATE MYSLITE",
	"GLAGOLITIC CAPITAL LETTER CAUDATE CHRIVI",
	"GLAGOLITIC SMALL LETTER AZU",
	"GLAGOLITIC SMALL LETTER BUKY",
	"GLAGOLITIC SMALL LETTER VEDE",
	"GLAGOLITIC SMALL LETTER GLAGOLI",
	"GLAGOLITIC SMALL LETTER DOBRO",
	"GLAGOLITIC SMALL LETTER YESTU",
	"GLAGOLITIC SMALL LETTER ZHIVETE",
	"GLAGOLITIC SMALL LETTER DZELO",
	"GLAGOLITIC SMALL LETTER ZEMLJA",
	"GLAGOLITIC SMALL LETTER IZHE",
	"GLAGOLITIC SMALL LETTER INITIAL IZHE",
	"GLAGOLITIC SMALL LETTER I",
	"GLAGOLITIC SMALL LETTER DJERVI",
	"GLAGOLITIC SMALL LETTER KAKO",
	"GLAGOLITIC SMALL LETTER LJUDIJE",
	"GLAGOLITIC SMALL LETTER MYSLITE",
	"GLAGOLITIC SMALL LETTER NASHI",
	"GLAGOLITIC SMALL LETTER ONU",
	"GLAGOLITIC SMALL LETTER POKOJI",
	"GLAGOLITIC SMALL LETTER RITSI",
	"GLAGOLITIC SMALL LETTER SLOVO",
	"GLAGOLITIC SMALL LETTER TVRIDO",
	"GLAGOLITIC SMALL LETTER UKU",
	"GLAGOLITIC SMALL LETTER FRITU",
	"GLAGOLITIC SMALL LETTER HERU",
	"GLAGOLITIC SMALL LETTER OTU",
	"GLAGOLITIC SMALL LETTER PE",
	"GLAGOLITIC SMALL LETTER SHTA",
	"GLAGOLITIC SMALL LETTER TSI",
	"GLAGOLITIC SMALL LETTER CHRIVI",
	"GLAGOLITIC SMALL LETTER SHA",
	"GLAGOLITIC SMALL LETTER YERU",
	"GLAGOLITIC SMALL LETTER YERI",
	"GLAGOLITIC SMALL LETTER YATI",
	"GLAGOLITIC SMALL LETTER SPIDERY HA",
	"GLAGOLITIC SMALL LETTER YU",
	"GLAGOLITIC SMALL LETTER SMALL YUS",
	"GLAGOLITIC SMALL LETTER SMALL YUS WITH TAIL",
	"GLAGOLITIC SMALL LETTER YO",
	"GLAGOLITIC SMALL LETTER IOTATED SMALL YUS",
	"GLAGOLITIC SMALL LETTER BIG YUS",
	"GLAGOLITIC SMALL LETTER IOTATED BIG YUS",
	"GLAGOLITIC SMALL LETTER FITA",
	"GLAGOLITIC SMALL LETTER IZHITSA",
	"GLAGOLITIC SMALL LETTER SHTAPIC",
	"GLAGOLITIC SMALL LETTER TROKUTASTI A",
	"GLAGOLITIC SMALL LETTER LATINATE MYSLITE",
	"GLAGOLITIC SMALL LETTER CAUDATE CHRIVI",
	"LATIN CAPITAL LETTER L WITH DOUBLE BAR",
	"LATIN SMALL LETTER L WITH DOUBLE BAR",
	"LATIN CAPITAL LETTER L WITH MIDDLE TILDE",
	"LATIN CAPITAL LETTER P WITH STROKE",
	"LATIN CAPITAL LETTER R WITH TAIL",
	"LATIN SMALL LETTER A WITH STROKE",
	"LATIN SMALL LETTER T WITH DIAGONAL STROKE",
	"LATIN CAPITAL LETTER H WITH DESCENDER",
	"LATIN SMALL LETTER H WITH DESCENDER",
	"LATIN CAPITAL LETTER K WITH DESCENDER",
	"LATIN SMALL LETTER K WITH DESCENDER",
	"LATIN CAPITAL LETTER Z WITH DESCENDER",
	"LATIN SMALL LETTER Z WITH DESCENDER",
	"LATIN CAPITAL LETTER ALPHA",
	"LATIN CAPITAL LETTER M WITH HOOK",
	"LATIN CAPITAL LETTER TURNED A",
	"LATIN CAPITAL LETTER TURNED ALPHA",
	"LATIN SMALL LETTER V WITH RIGHT HOOK",
	"LATIN CAPITAL LETTER W WITH HOOK",
	"LATIN SMALL LETTER W WITH HOOK",
	"LATIN SMALL LETTER V WITH CURL",
	"LATIN CAPITAL LETTER HALF H",
	"LATIN SMALL LETTER HALF H",
	"LATIN SMALL LETTER TAILLESS PHI",
	"LATIN SMALL LETTER E WITH NOTCH",
	"LATIN SMALL LETTER TURNED R WITH TAIL",
	"LATIN SMALL LETTER O WITH LOW RING INSIDE",
	"LATIN LETTER SMALL CAPITAL TURNED E",
	"LATIN SUBSCRIPT SMALL LETTER J",
	"MODIFIER LETTER CAPITAL V",
	"LATIN CAPITAL LETTER S WITH SWASH TAIL",
	"LATIN CAPITAL LETTER Z WITH SWASH TAIL",
	"COPTIC CAPITAL LETTER ALFA",
	"COPTIC SMALL LETTER ALFA",
	"COPTIC CAPITAL LETTER VIDA",
	"COPTIC SMALL LETTER VIDA",
	"COPTIC CAPITAL LETTER GAMMA",
	"COPTIC SMALL LETTER GAMMA",
	"COPTIC CAPITAL LETTER DALDA",
	"COPTIC SMALL LETTER DALDA",
	"COPTIC CAPITAL LETTER EIE",
	"COPTIC SMALL LETTER EIE",
	"COPTIC CAPITAL LETTER SOU",
	"COPTIC SMALL LETTER SOU",
	"COPTIC CAPITAL LETTER ZATA",
	"COPTIC SMALL LETTER ZATA",
	"COPTIC CAPITAL LETTER HATE",
	"COPTIC SMALL LETTER HATE",
	"COPTIC CAPITAL LETTER THETHE",
	"COPTIC SMALL LETTER THETHE",
	"COPTIC CAPITAL LETTER IAUDA",
	"COPTIC SMALL LETTER IAUDA",
	"COPTIC CAPITAL LETTER KAPA",
	"COPTIC SMALL LETTER KAPA",
	"COPTIC CAPITAL LETTER LAULA",
	"COPTIC SMALL LETTER LAULA",
	"COPTIC CAPITAL LETTER MI",
	"COPTIC SMALL LETTER MI",
	"COPTIC CAPITAL LETTER NI",
	"COPTIC SMALL LETTER NI",
	"COPTIC CAPITAL LETTER KSI",
	"COPTIC SMALL LETTER KSI",
	"COPTIC CAPITAL LETTER O",
	"COPTIC SMALL LETTER O",
	"COPTIC CAPITAL LETTER PI",
	"COPTIC SMALL LETTER PI",
	"COPTIC CAPITAL LETTER RO",
	"COPTIC SMALL LETTER RO",
	"COPTIC CAPITAL LETTER SIMA",
	"COPTIC SMALL LETTER SIMA",
	"COPTIC CAPITAL LETTER TAU",
	"COPTIC SMALL LETTER TAU",
	"COPTIC CAPITAL LETTER UA",
	"COPTIC SMALL LETTER UA",
	"COPTIC CAPITAL LETTER FI",
	"COPTIC SMALL LETTER FI",
	"COPTIC CAPITAL LETTER KHI",
	"COPTIC SMALL LETTER KHI",
	"COPTIC CAPITAL LETTER PSI",
	"COPTIC SMALL LETTER PSI",
	"COPTIC CAPITAL LETTER OOU",
	"COPTIC SMALL LETTER OOU",
	"COPTIC CAPITAL LETTER DIALECT-P ALEF",
	"COPTIC SMALL LETTER DIALECT-P ALEF",
	"COPTIC CAPITAL LETTER OLD COPTIC AIN",
	"COPTIC SMALL LETTER OLD COPTIC AIN",
	"COPTIC CAPITAL LETTER CRYPTOGRAMMIC EIE",
	"COPTIC SMALL LETTER CRYPTOGRAMMIC EIE",
	"COPTIC CAPITAL LETTER DIALECT-P KAPA",
	"COPTIC SMALL LETTER DIALECT-P KAPA",
	"COPTIC CAPITAL LETTER DIALECT-P NI",
	"COPTIC SMALL LETTER DIALECT-P NI",
	"COPTIC CAPITAL LETTER CRYPTOGRAMMIC NI",
	"COPTIC SMALL LETTER CRYPTOGRAMMIC NI",
	"COPTIC CAPITAL LETTER OLD COPTIC OOU",
	"COPTIC SMALL LETTER OLD COPTIC OOU",
	"COPTIC CAPITAL LETTER SAMPI",
	"COPTIC SMALL LETTER SAMPI",
	"COPTIC CAPITAL LETTER CROSSED SHEI",
	"COPTIC SMALL LETTER CROSSED SHEI",
	"COPTIC CAPITAL LETTER OLD COPTIC SHEI",
	"COPTIC SMALL LETTER OLD COPTIC SHEI",
	"COPTIC CAPITAL LETTER OLD COPTIC ESH",
	"COPTIC SMALL LETTER OLD COPTIC ESH",
	"COPTIC CAPITAL LETTER AKHMIMIC KHEI",
	"COPTIC SMALL LETTER AKHMIMIC KHEI",
	"COPTIC CAPITAL LETTER DIALECT-P HORI",
	"COPTIC SMALL LETTER DIALECT-P HORI",
	"COPTIC CAPITAL LETTER OLD COPTIC HORI",
	"COPTIC SMALL LETTER OLD COPTIC HORI",
	"COPTIC CAPITAL LETTER OLD COPTIC HA",
	"COPTIC SMALL LETTER OLD COPTIC HA",
	"COPTIC CAPITAL LETTER L-SHAPED HA",
	"COPTIC SMALL LETTER L-SHAPED HA",
	"COPTIC CAPITAL LETTER OLD COPTIC HEI",
	"COPTIC SMALL LETTER OLD COPTIC HEI",
	"COPTIC CAPITAL LETTER OLD COPTIC HAT",
	"COPTIC SMALL LETTER OLD COPTIC HAT",
	"COPTIC CAPITAL LETTER OLD COPTIC GANGIA",
	"COPTIC SMALL LETTER OLD COPTIC GANGIA",
	"COPTIC CAPITAL LETTER OLD COPTIC DJA",
	"COPTIC SMALL LETTER OLD COPTIC DJA",
	"COPTIC CAPITAL LETTER OLD COPTIC SHIMA",
	"COPTIC SMALL LETTER OLD COPTIC SHIMA",
	"COPTIC CAPITAL LETTER OLD NUBIAN SHIMA",
	"COPTIC SMALL LETTER OLD NUBIAN SHIMA",
	"COPTIC CAPITAL LETTER OLD NUBIAN NGI",
	"COPTIC SMALL LETTER OLD NUBIAN NGI",
	"COPTIC CAPITAL LETTER OLD NUBIAN NYI",
	"COPTIC SMALL LETTER OLD NUBIAN NYI",
	"COPTIC CAPITAL LETTER OLD NUBIAN WAU",
	"COPTIC SMALL LETTER OLD NUBIAN WAU",
	"COPTIC SYMBOL KAI",
	"COPTIC SYMBOL MI RO",
	"COPTIC SYMBOL PI RO",
	"COPTIC SYMBOL STAUROS",
	"COPTIC SYMBOL TAU RO",
	"COPTIC SYMBOL KHI RO",
	"COPTIC SYMBOL SHIMA SIMA",
	"COPTIC CAPITAL LETTER CRYPTOGRAMMIC SHEI",
	"COPTIC SMALL LETTER CRYPTOGRAMMIC SHEI",
	"COPTIC CAPITAL LETTER CRYPTOGRAMMIC GANGIA",
	"COPTIC SMALL LETTER CRYPTOGRAMMIC GANGIA",
	"COPTIC COMBINING NI ABOVE",
	"COPTIC COMBINING SPIRITUS ASPER",
	"COPTIC COMBINING SPIRITUS LENIS",
	"COPTIC CAPITAL LETTER BOHAIRIC KHEI",
	"COPTIC SMALL LETTER BOHAIRIC KHEI",
	"COPTIC OLD NUBIAN FULL STOP",
	"COPTIC OLD NUBIAN DIRECT QUESTION MARK",
	"COPTIC OLD NUBIAN INDIRECT QUESTION MARK",
	"COPTIC OLD NUBIAN VERSE DIVIDER",
	"COPTIC FRACTION ONE HALF",
	"COPTIC FULL STOP",
	"COPTIC MORPHOLOGICAL DIVIDER",
	"GEORGIAN SMALL LETTER AN",
	"GEORGIAN SMALL LETTER BAN",
	"GEORGIAN SMALL LETTER GAN",
	"GEORGIAN SMALL LETTER DON",
	"GEORGIAN SMALL LETTER EN",
	"GEORGIAN SMALL LETTER VIN",
	"GEORGIAN SMALL LETTER ZEN",
	"GEORGIAN SMALL LETTER TAN",
	"GEORGIAN SMALL LETTER IN",
	"GEORGIAN SMALL LETTER KAN",
	"GEORGIAN SMALL LETTER LAS",
	"GEORGIAN SMALL LETTER MAN",
	"GEORGIAN SMALL LETTER NAR",
	"GEORGIAN SMALL LETTER ON",
	"GEORGIAN SMALL LETTER PAR",
	"GEORGIAN SMALL LETTER ZHAR",
	"GEORGIAN SMALL LETTER RAE",
	"GEORGIAN SMALL LETTER SAN",
	"GEORGIAN SMALL LETTER TAR",
	"GEORGIAN SMALL LETTER UN",
	"GEORGIAN SMALL LETTER PHAR",
	"GEORGIAN SMALL LETTER KHAR",
	"GEORGIAN SMALL LETTER GHAN",
	"GEORGIAN SMALL LETTER QAR",
	"GEORGIAN SMALL LETTER SHIN",
	"GEORGIAN SMALL LETTER CHIN",
	"GEORGIAN SMALL LETTER CAN",
	"GEORGIAN SMALL LETTER JIL",
	"GEORGIAN SMALL LETTER CIL",
	"GEORGIAN SMALL LETTER CHAR",
	"GEORGIAN SMALL LETTER XAN",
	"GEORGIAN SMALL LETTER JHAN",
	"GEORGIAN SMALL LETTER HAE",
	"GEORGIAN SMALL LETTER HE",
	"GEORGIAN SMALL LETTER HIE",
	"GEORGIAN SMALL LETTER WE",
	"GEORGIAN SMALL LETTER HAR",
	"GEORGIAN SMALL LETTER HOE",
	"GEORGIAN SMALL LETTER YN",
	"GEORGIAN SMALL LETTER AEN",
	"TIFINAGH LETTER YA",
	"TIFINAGH LETTER YAB",
	"TIFINAGH LETTER YABH",
	"TIFINAGH LETTER YAG",
	"TIFINAGH LETTER YAGHH",
	"TIFINAGH LETTER BERBER ACADEMY YAJ",
	"TIFINAGH LETTER YAJ",
	"TIFINAGH LETTER YAD",
	"TIFINAGH LETTER YADH",
	"TIFINAGH LETTER YADD",
	"TIFINAGH LETTER YADDH",
	"TIFINAGH LETTER YEY",
	"TIFINAGH LETTER YAF",
	"TIFINAGH LETTER YAK",
	"TIFINAGH LETTER TUAREG YAK",
	"TIFINAGH LETTER YAKHH",
	"TIFINAGH LETTER YAH",
	"TIFINAGH LETTER BERBER ACADEMY YAH",
	"TIFINAGH LETTER TUAREG YAH",
	"TIFINAGH LETTER YAHH",
	"TIFINAGH LETTER YAA",
	"TIFINAGH LETTER YAKH",
	"TIFINAGH LETTER TUAREG YAKH",
	"TIFINAGH LETTER YAQ",
	"TIFINAGH LETTER TUAREG YAQ",
	"TIFINAGH LETTER YI",
	"TIFINAGH LETTER YAZH",
	"TIFINAGH LETTER AHAGGAR YAZH",
	"TIFINAGH LETTER TUAREG YAZH",
	"TIFINAGH LETTER YAL",
	"TIFINAGH LETTER YAM",
	"TIFINAGH LETTER YAN",
	"TIFINAGH LETTER TUAREG YAGN",
	"TIFINAGH LETTER TUAREG YANG",
	"TIFINAGH LETTER YAP",
	"TIFINAGH LETTER YU",
	"TIFINAGH LETTER YAR",
	"TIFINAGH LETTER YARR",
	"TIFINAGH LETTER YAGH",
	"TIFINAGH LETTER TUAREG YAGH",
	"TIFINAGH LETTER AYER YAGH",
	"TIFINAGH LETTER YAS",
	"TIFINAGH LETTER YASS",
	"TIFINAGH LETTER YASH",
	"TIFINAGH LETTER YAT",
	"TIFINAGH LETTER YATH",
	"TIFINAGH LETTER YACH",
	"TIFINAGH LETTER YATT",
	"TIFINAGH LETTER YAV",
	"TIFINAGH LETTER YAW",
	"TIFINAGH LETTER YAY",
	"TIFINAGH LETTER YAZ",
	"TIFINAGH LETTER TAWELLEMET YAZ",
	"TIFINAGH LETTER YAZZ",
	"TIFINAGH LETTER YE",
	"TIFINAGH LETTER YO",
	"TIFINAGH MODIFIER LETTER LABIALIZATION MARK",
	"TIFINAGH SEPARATOR MARK",
	"TIFINAGH CONSONANT JOINER",
	"ETHIOPIC SYLLABLE LOA",
	"ETHIOPIC SYLLABLE MOA",
	"ETHIOPIC SYLLABLE ROA",
	"ETHIOPIC SYLLABLE SOA",
	"ETHIOPIC SYLLABLE SHOA",
	"ETHIOPIC SYLLABLE BOA",
	"ETHIOPIC SYLLABLE TOA",
	"ETHIOPIC SYLLABLE COA",
	"ETHIOPIC SYLLABLE NOA",
	"ETHIOPIC SYLLABLE NYOA",
	"ETHIOPIC SYLLABLE GLOTTAL OA",
	"ETHIOPIC SYLLABLE ZOA",
	"ETHIOPIC SYLLABLE DOA",
	"ETHIOPIC SYLLABLE DDOA",
	"ETHIOPIC SYLLABLE JOA",
	"ETHIOPIC SYLLABLE THOA",
	"ETHIOPIC SYLLABLE CHOA",
	"ETHIOPIC SYLLABLE PHOA",
	"ETHIOPIC SYLLABLE POA",
	"ETHIOPIC SYLLABLE GGWA",
	"ETHIOPIC SYLLABLE GGWI",
	"ETHIOPIC SYLLABLE GGWEE",
	"ETHIOPIC SYLLABLE GGWE",
	"ETHIOPIC SYLLABLE SSA",
	"ETHIOPIC SYLLABLE SSU",
	"ETHIOPIC SYLLABLE SSI",
	"ETHIOPIC SYLLABLE SSAA",
	"ETHIOPIC SYLLABLE SSEE",
	"ETHIOPIC SYLLABLE SSE",
	"ETHIOPIC SYLLABLE SSO",
	"ETHIOPIC SYLLABLE CCA",
	"ETHIOPIC SYLLABLE CCU",
	"ETHIOPIC SYLLABLE CCI",
	"ETHIOPIC SYLLABLE CCAA",
	"ETHIOPIC SYLLABLE CCEE",
	"ETHIOPIC SYLLABLE CCE",
	"ETHIOPIC SYLLABLE CCO",
	"ETHIOPIC SYLLABLE ZZA",
	"ETHIOPIC SYLLABLE ZZU",
	"ETHIOPIC SYLLABLE ZZI",
	"ETHIOPIC SYLLABLE ZZAA",
	"ETHIOPIC SYLLABLE ZZEE",
	"ETHIOPIC SYLLABLE ZZE",
	"ETHIOPIC SYLLABLE ZZO",
	"ETHIOPIC SYLLABLE CCHA",
	"ETHIOPIC SYLLABLE CCHU",
	"ETHIOPIC SYLLABLE CCHI",
	"ETHIOPIC SYLLABLE CCHAA",
	"ETHIOPIC SYLLABLE CCHEE",
	"ETHIOPIC SYLLABLE CCHE",
	"ETHIOPIC SYLLABLE CCHO",
	"ETHIOPIC SYLLABLE QYA",
	"ETHIOPIC SYLLABLE QYU",
	"ETHIOPIC SYLLABLE QYI",
	"ETHIOPIC SYLLABLE QYAA",
	"ETHIOPIC SYLLABLE QYEE",
	"ETHIOPIC SYLLABLE QYE",
	"ETHIOPIC SYLLABLE QYO",
	"ETHIOPIC SYLLABLE KYA",
	"ETHIOPIC SYLLABLE KYU",
	"ETHIOPIC SYLLABLE KYI",
	"ETHIOPIC SYLLABLE KYAA",
	"ETHIOPIC SYLLABLE KYEE",
	"ETHIOPIC SYLLABLE KYE",
	"ETHIOPIC SYLLABLE KYO",
	"ETHIOPIC SYLLABLE XYA",
	"ETHIOPIC SYLLABLE XYU",
	"ETHIOPIC SYLLABLE XYI",
	"ETHIOPIC SYLLABLE XYAA",
	"ETHIOPIC SYLLABLE XYEE",
	"ETHIOPIC SYLLABLE XYE",
	"ETHIOPIC SYLLABLE XYO",
	"ETHIOPIC SYLLABLE GYA",
	"ETHIOPIC SYLLABLE GYU",
	"ETHIOPIC SYLLABLE GYI",
	"ETHIOPIC SYLLABLE GYAA",
	"ETHIOPIC SYLLABLE GYEE",
	"ETHIOPIC SYLLABLE GYE",
	"ETHIOPIC SYLLABLE GYO",
	"COMBINING CYRILLIC LETTER BE",
	"COMBINING CYRILLIC LETTER VE",
	"COMBINING CYRILLIC LETTER GHE",
	"COMBINING CYRILLIC LETTER DE",
	"COMBINING CYRILLIC LETTER ZHE",
	"COMBINING CYRILLIC LETTER ZE",
	"COMBINING CYRILLIC LETTER KA",
	"COMBINING CYRILLIC LETTER EL",
	"COMBINING CYRILLIC LETTER EM",
	"COMBINING CYRILLIC LETTER EN",
	"COMBINING CYRILLIC LETTER O",
	"COMBINING CYRILLIC LETTER PE",
	"COMBINING CYRILLIC LETTER ER",
	"COMBINING CYRILLIC LETTER ES",
	"COMBINING CYRILLIC LETTER TE",
	"COMBINING CYRILLIC LETTER HA",
	"COMBINING CYRILLIC LETTER TSE",
	"COMBINING CYRILLIC LETTER CHE",
	"COMBINING CYRILLIC LETTER SHA",
	"COMBINING CYRILLIC LETTER SHCHA",
	"COMBINING CYRILLIC LETTER FITA",
	"COMBINING CYRILLIC LETTER ES-TE",
	"COMBINING CYRILLIC LETTER A",
	"COMBINING CYRILLIC LETTER IE",
	"COMBINING CYRILLIC LETTER DJERV",
	"COMBINING CYRILLIC LETTER MONOGRAPH UK",
	"COMBINING CYRILLIC LETTER YAT",
	"COMBINING CYRILLIC LETTER YU",
	"COMBINING CYRILLIC LETTER IOTIFIED A",
	"COMBINING CYRILLIC LETTER LITTLE YUS",
	"COMBINING CYRILLIC LETTER BIG YUS",
	"COMBINING CYRILLIC LETTER IOTIFIED BIG YUS",
	"RIGHT ANGLE SUBSTITUTION MARKER",
	"RIGHT ANGLE DOTTED SUBSTITUTION MARKER",
	"LEFT SUBSTITUTION BRACKET",
	"RIGHT SUBSTITUTION BRACKET",
	"LEFT DOTTED SUBSTITUTION BRACKET",
	"RIGHT DOTTED SUBSTITUTION BRACKET",
	"RAISED INTERPOLATION MARKER",
	"RAISED DOTTED INTERPOLATION MARKER",
	"DOTTED TRANSPOSITION MARKER",
	"LEFT TRANSPOSITION BRACKET",
	"RIGHT TRANSPOSITION BRACKET",
	"RAISED SQUARE",
	"LEFT RAISED OMISSION BRACKET",
	"RIGHT RAISED OMISSION BRACKET",
	"EDITORIAL CORONIS",
	"PARAGRAPHOS",
	"FORKED PARAGRAPHOS",
	"REVERSED FORKED PARAGRAPHOS",
	"HYPODIASTOLE",
	"DOTTED OBELOS",
	"DOWNWARDS ANCORA",
	"UPWARDS ANCORA",
	"DOTTED RIGHT-POINTING ANGLE",
	"DOUBLE OBLIQUE HYPHEN",
	"INVERTED INTERROBANG",
	"PALM BRANCH",
	"HYPHEN WITH DIAERESIS",
	"TILDE WITH RING ABOVE",
	"LEFT LOW PARAPHRASE BRACKET",
	"RIGHT LOW PARAPHRASE BRACKET",
	"TILDE WITH DOT ABOVE",
	"TILDE WITH DOT BELOW",
	"LEFT VERTICAL BAR WITH QUILL",
	"RIGHT VERTICAL BAR WITH QUILL",
	"TOP LEFT HALF BRACKET",
	"TOP RIGHT HALF BRACKET",
	"BOTTOM LEFT HALF BRACKET",
	"BOTTOM RIGHT HALF BRACKET",
	"LEFT SIDEWAYS U BRACKET",
	"RIGHT SIDEWAYS U BRACKET",
	"LEFT DOUBLE PARENTHESIS",
	"RIGHT DOUBLE PARENTHESIS",
	"TWO DOTS OVER ONE DOT PUNCTUATION",
	"ONE DOT OVER TWO DOTS PUNCTUATION",
	"SQUARED FOUR DOT PUNCTUATION",
	"FIVE DOT MARK",
	"REVERSED QUESTION MARK",
	"VERTICAL TILDE",
	"RING POINT",
	"WORD SEPARATOR MIDDLE DOT",
	"TURNED COMMA",
	"RAISED DOT",
	"RAISED COMMA",
	"TURNED SEMICOLON",
	"DAGGER WITH LEFT GUARD",
	"DAGGER WITH RIGHT GUARD",
	"TURNED DAGGER",
	"TOP HALF SECTION SIGN",
	"TWO-EM DASH",
	"THREE-EM DASH",
	"STENOGRAPHIC FULL STOP",
	"VERTICAL SIX DOTS",
	"WIGGLY VERTICAL LINE",
	"CAPITULUM",
	"DOUBLE HYPHEN",
	"REVERSED COMMA",
	"DOUBLE LOW-REVERSED-9 QUOTATION MARK",
	"DASH WITH LEFT UPTURN",
	"DOUBLE SUSPENSION MARK",
	"INVERTED LOW KAVYKA",
	"INVERTED LOW KAVYKA WITH KAVYKA ABOVE",
	"LOW KAVYKA",
	"LOW KAVYKA WITH DOT",
	"DOUBLE STACKED COMMA",
	"DOTTED SOLIDUS",
	"TRIPLE DAGGER",
	"MEDIEVAL COMMA",
	"PARAGRAPHUS MARK",
	"PUNCTUS ELEVATUS MARK",
	"CORNISH VERSE DIVIDER",
	"CROSS PATTY WITH RIGHT CROSSBAR",
	"CROSS PATTY WITH LEFT CROSSBAR",
	"TIRONIAN SIGN CAPITAL ET",
	"MEDIEVAL EXCLAMATION MARK",
	"MEDIEVAL QUESTION MARK",
	"LEFT SQUARE BRACKET WITH STROKE",
	"RIGHT SQUARE BRACKET WITH STROKE",
	"LEFT SQUARE BRACKET WITH DOUBLE STROKE",
	"RIGHT SQUARE BRACKET WITH DOUBLE STROKE",
	"TOP HALF LEFT PARENTHESIS",
	"TOP HALF RIGHT PARENTHESIS",
	"BOTTOM HALF LEFT PARENTHESIS",
	"BOTTOM HALF RIGHT PARENTHESIS",
	"OBLIQUE HYPHEN",
	"CJK RADICAL REPEAT",
	"CJK RADICAL CLIFF",
	"CJK RADICAL SECOND ONE",
	"CJK RADICAL SECOND TWO",
	"CJK RADICAL SECOND THREE",
	"CJK RADICAL PERSON",
	"CJK RADICAL BOX",
	"CJK RADICAL TABLE",
	"CJK RADICAL KNIFE ONE",
	"CJK RADICAL KNIFE TWO",
	"CJK RADICAL DIVINATION",
	"CJK RADICAL SEAL",
	"CJK RADICAL SMALL ONE",
	"CJK RADICAL SMALL TWO",
	"CJK RADICAL LAME ONE",
	"CJK RADICAL LAME TWO",
	"CJK RADICAL LAME THREE",
	"CJK RADICAL LAME FOUR",
	"CJK RADICAL SNAKE",
	"CJK RADICAL THREAD",
	"CJK RADICAL SNOUT ONE",
	"CJK RADICAL SNOUT TWO",
	"CJK RADICAL HEART ONE",
	"CJK RADICAL HEART TWO",
	"CJK RADICAL HAND",
	"CJK RADICAL RAP",
	"CJK RADICAL CHOKE",
	"CJK RADICAL SUN",
	"CJK RADICAL MOON",
	"CJK RADICAL DEATH",
	"CJK RADICAL MOTHER",
	"CJK RADICAL CIVILIAN",
	"CJK RADICAL WATER ONE",
	"CJK RADICAL WATER TWO",
	"CJK RADICAL FIRE",
	"CJK RADICAL PAW ONE",
	"CJK RADICAL PAW TWO",
	"CJK RADICAL SIMPLIFIED HALF TREE TRUNK",
	"CJK RADICAL COW",
	"CJK RADICAL DOG",
	"CJK RADICAL JADE",
	"CJK RADICAL BOLT OF CLOTH",
	"CJK RADICAL EYE",
	"CJK RADICAL SPIRIT ONE",
	"CJK RADICAL SPIRIT TWO",
	"CJK RADICAL BAMBOO",
	"CJK RADICAL SILK",
	"CJK RADICAL C-SIMPLIFIED SILK",
	"CJK RADICAL NET ONE",
	"CJK RADICAL NET TWO",
	"CJK RADICAL NET THREE",
	"CJK RADICAL NET FOUR",
	"CJK RADICAL MESH",
	"CJK RADICAL SHEEP",
	"CJK RADICAL RAM",
	"CJK RADICAL EWE",
	"CJK RADICAL OLD",
	"CJK RADICAL BRUSH ONE",
	"CJK RADICAL BRUSH TWO",
	"CJK RADICAL MEAT",
	"CJK RADICAL MORTAR",
	"CJK RADICAL GRASS ONE",
	"CJK RADICAL GRASS TWO",
	"CJK RADICAL GRASS THREE",
	"CJK RADICAL TIGER",
	"CJK RADICAL CLOTHES",
	"CJK RADICAL WEST ONE",
	"CJK RADICAL WEST TWO",
	"CJK RADICAL C-SIMPLIFIED SEE",
	"CJK RADICAL SIMPLIFIED HORN",
	"CJK RADICAL HORN",
	"CJK RADICAL C-SIMPLIFIED SPEECH",
	"CJK RADICAL C-SIMPLIFIED SHELL",
	"CJK RADICAL FOOT",
	"CJK RADICAL C-SIMPLIFIED CART",
	"CJK RADICAL SIMPLIFIED WALK",
	"CJK RADICAL WALK ONE",
	"CJK RADICAL WALK TWO",
	"CJK RADICAL CITY",
	"CJK RADICAL C-SIMPLIFIED GOLD",
	"CJK RADICAL LONG ONE",
	"CJK RADICAL LONG TWO",
	"CJK RADICAL C-SIMPLIFIED LONG",
	"CJK RADICAL C-SIMPLIFIED GATE",
	"CJK RADICAL MOUND ONE",
	"CJK RADICAL MOUND TWO",
	"CJK RADICAL RAIN",
	"CJK RADICAL BLUE",
	"CJK RADICAL C-SIMPLIFIED TANNED LEATHER",
	"CJK RADICAL C-SIMPLIFIED LEAF",
	"CJK RADICAL C-SIMPLIFIED WIND",
	"CJK RADICAL C-SIMPLIFIED FLY",
	"CJK RADICAL EAT ONE",
	"CJK RADICAL EAT TWO",
	"CJK RADICAL EAT THREE",
	"CJK RADICAL C-SIMPLIFIED EAT",
	"CJK RADICAL HEAD",
	"CJK RADICAL C-SIMPLIFIED HORSE",
	"CJK RADICAL BONE",
	"CJK RADICAL GHOST",
	"CJK RADICAL C-SIMPLIFIED FISH",
	"CJK RADICAL C-SIMPLIFIED BIRD",
	"CJK RADICAL C-SIMPLIFIED SALT",
	"CJK RADICAL SIMPLIFIED WHEAT",
	"CJK RADICAL SIMPLIFIED YELLOW",
	"CJK RADICAL C-SIMPLIFIED FROG",
	"CJK RADICAL J-SIMPLIFIED EVEN",
	"CJK RADICAL C-SIMPLIFIED EVEN",
	"CJK RADICAL J-SIMPLIFIED TOOTH",
	"CJK RADICAL C-SIMPLIFIED TOOTH",
	"CJK RADICAL J-SIMPLIFIED DRAGON",
	"CJK RADICAL C-SIMPLIFIED DRAGON",
	"CJK RADICAL TURTLE",
	"CJK RADICAL J-SIMPLIFIED TURTLE",
	"CJK RADICAL C-SIMPLIFIED TURTLE",
	"KANGXI RADICAL ONE",
	"KANGXI RADICAL LINE",
	"KANGXI RADICAL DOT",
	"KANGXI RADICAL SLASH",
	"KANGXI RADICAL SECOND",
	"KANGXI RADICAL HOOK",
	"KANGXI RADICAL TWO",
	"KANGXI RADICAL LID",
	"KANGXI RADICAL MAN",
	"KANGXI RADICAL LEGS",
	"KANGXI RADICAL ENTER",
	"KANGXI RADICAL EIGHT",
	"KANGXI RADICAL DOWN BOX",
	"KANGXI RADICAL COVER",
	"KANGXI RADICAL ICE",
	"KANGXI RADICAL TABLE",
	"KANGXI RADICAL OPEN BOX",
	"KANGXI RADICAL KNIFE",
	"KANGXI RADICAL POWER",
	"KANGXI RADICAL WRAP",
	"KANGXI RADICAL SPOON",
	"KANGXI RADICAL RIGHT OPEN BOX",
	"KANGXI RADICAL HIDING ENCLOSURE",
	"KANGXI RADICAL TEN",
	"KANGXI RADICAL DIVINATION",
	"KANGXI RADICAL SEAL",
	"KANGXI RADICAL CLIFF",
	"KANGXI RADICAL PRIVATE",
	"KANGXI RADICAL AGAIN",
	"KANGXI RADICAL MOUTH",
	"KANGXI RADICAL ENCLOSURE",
	"KANGXI RADICAL EARTH",
	"KANGXI RADICAL SCHOLAR",
	"KANGXI RADICAL GO",
	"KANGXI RADICAL GO SLOWLY",
	"KANGXI RADICAL EVENING",
	"KANGXI RADICAL BIG",
	"KANGXI RADICAL WOMAN",
	"KANGXI RADICAL CHILD",
	"KANGXI RADICAL ROOF",
	"KANGXI RADICAL INCH",
	"KANGXI RADICAL SMALL",
	"KANGXI RADICAL LAME",
	"KANGXI RADICAL CORPSE",
	"KANGXI RADICAL SPROUT",
	"KANGXI RADICAL MOUNTAIN",
	"KANGXI RADICAL RIVER",
	"KANGXI RADICAL WORK",
	"KANGXI RADICAL ONESELF",
	"KANGXI RADICAL TURBAN",
	"KANGXI RADICAL DRY",
	"KANGXI RADICAL SHORT THREAD",
	"KANGXI RADICAL DOTTED CLIFF",
	"KANGXI RADICAL LONG STRIDE",
	"KANGXI RADICAL TWO HANDS",
	"KANGXI RADICAL SHOOT",
	"KANGXI RADICAL BOW",
	"KANGXI RADICAL SNOUT",
	"KANGXI RADICAL BRISTLE",
	"KANGXI RADICAL STEP",
	"KANGXI RADICAL HEART",
	"KANGXI RADICAL HALBERD",
	"KANGXI RADICAL DOOR",
	"KANGXI RADICAL HAND",
	"KANGXI RADICAL BRANCH",
	"KANGXI RADICAL RAP",
	"KANGXI RADICAL SCRIPT",
	"KANGXI RADICAL DIPPER",
	"KANGXI RADICAL AXE",
	"KANGXI RADICAL SQUARE",
	"KANGXI RADICAL NOT",
	"KANGXI RADICAL SUN",
	"KANGXI RADICAL SAY",
	"KANGXI RADICAL MOON",
	"KANGXI RADICAL TREE",
	"KANGXI RADICAL LACK",
	"KANGXI RADICAL STOP",
	"KANGXI RADICAL DEATH",
	"KANGXI RADICAL WEAPON",
	"KANGXI RADICAL DO NOT",
	"KANGXI RADICAL COMPARE",
	"KANGXI RADICAL FUR",
	"KANGXI RADICAL CLAN",
	"KANGXI RADICAL STEAM",
	"KANGXI RADICAL WATER",
	"KANGXI RADICAL FIRE",
	"KANGXI RADICAL CLAW",
	"KANGXI RADICAL FATHER",
	"KANGXI RADICAL DOUBLE X",
	"KANGXI RADICAL HALF TREE TRUNK",
	"KANGXI RADICAL SLICE",
	"KANGXI RADICAL FANG",
	"KANGXI RADICAL COW",
	"KANGXI RADICAL DOG",
	"KANGXI RADICAL PROFOUND",
	"KANGXI RADICAL JADE",
	"KANGXI RADICAL MELON",
	"KANGXI RADICAL TILE",
	"KANGXI RADICAL SWEET",
	"KANGXI RADICAL LIFE",
	"KANGXI RADICAL USE",
	"KANGXI RADICAL FIELD",
	"KANGXI RADICAL BOLT OF CLOTH",
	"KANGXI RADICAL SICKNESS",
	"KANGXI RADICAL DOTTED TENT",
	"KANGXI RADICAL WHITE",
	"KANGXI RADICAL SKIN",
	"KANGXI RADICAL DISH",
	"KANGXI RADICAL EYE",
	"KANGXI RADICAL SPEAR",
	"KANGXI RADICAL ARROW",
	"KANGXI RADICAL STONE",
	"KANGXI RADICAL SPIRIT",
	"KANGXI RADICAL TRACK",
	"KANGXI RADICAL GRAIN",
	"KANGXI RADICAL CAVE",
	"KANGXI RADICAL STAND",
	"KANGXI RADICAL BAMBOO",
	"KANGXI RADICAL RICE",
	"KANGXI RADICAL SILK",
	"KANGXI RADICAL JAR",
	"KANGXI RADICAL NET",
	"KANGXI RADICAL SHEEP",
	"KANGXI RADICAL FEATHER",
	"KANGXI RADICAL OLD",
	"KANGXI RADICAL AND",
	"KANGXI RADICAL PLOW",
	"KANGXI RADICAL EAR",
	"KANGXI RADICAL BRUSH",
	"KANGXI RADICAL MEAT",
	"KANGXI RADICAL MINISTER",
	"KANGXI RADICAL SELF",
	"KANGXI RADICAL ARRIVE",
	"KANGXI RADICAL MORTAR",
	"KANGXI RADICAL TONGUE",
	"KANGXI RADICAL OPPOSE",
	"KANGXI RADICAL BOAT",
	"KANGXI RADICAL STOPPING",
	"KANGXI RADICAL COLOR",
	"KANGXI RADICAL GRASS",
	"KANGXI RADICAL TIGER",
	"KANGXI RADICAL INSECT",
	"KANGXI RADICAL BLOOD",
	"KANGXI RADICAL WALK ENCLOSURE",
	"KANGXI RADICAL CLOTHES",
	"KANGXI RADICAL WEST",
	"KANGXI RADICAL SEE",
	"KANGXI RADICAL HORN",
	"KANGXI RADICAL SPEECH",
	"KANGXI RADICAL VALLEY",
	"KANGXI RADICAL BEAN",
	"KANGXI RADICAL PIG",
	"KANGXI RADICAL BADGER",
	"KANGXI RADICAL SHELL",
	"KANGXI RADICAL RED",
	"KANGXI RADICAL RUN",
	"KANGXI RADICAL FOOT",
	"KANGXI RADICAL BODY",
	"KANGXI RADICAL CART",
	"KANGXI RADICAL BITTER",
	"KANGXI RADICAL MORNING",
	"KANGXI RADICAL WALK",
	"KANGXI RADICAL CITY",
	"KANGXI RADICAL WINE",
	"KANGXI RADICAL DISTINGUISH",
	"KANGXI RADICAL VILLAGE",
	"KANGXI RADICAL GOLD",
	"KANGXI RADICAL LONG",
	"KANGXI RADICAL GATE",
	"KANGXI RADICAL MOUND",
	"KANGXI RADICAL SLAVE",
	"KANGXI RADICAL SHORT TAILED BIRD",
	"KANGXI RADICAL RAIN",
	"KANGXI RADICAL BLUE",
	"KANGXI RADICAL WRONG",
	"KANGXI RADICAL FACE",
	"KANGXI RADICAL LEATHER",
	"KANGXI RADICAL TANNED LEATHER",
	"KANGXI RADICAL LEEK",
	"KANGXI RADICAL SOUND",
	"KANGXI RADICAL LEAF",
	"KANGXI RADICAL WIND",
	"KANGXI RADICAL FLY",
	"KANGXI RADICAL EAT",
	"KANGXI RADICAL HEAD",
	"KANGXI RADICAL FRAGRANT",
	"KANGXI RADICAL HORSE",
	"KANGXI RADICAL BONE",
	"KANGXI RADICAL TALL",
	"KANGXI RADICAL HAIR",
	"KANGXI RADICAL FIGHT",
	"KANGXI RADICAL SACRIFICIAL WINE",
	"KANGXI RADICAL CAULDRON",
	"KANGXI RADICAL GHOST",
	"KANGXI RADICAL FISH",
	"KANGXI RADICAL BIRD",
	"KANGXI RADICAL SALT",
	"KANGXI RADICAL DEER",
	"KANGXI RADICAL WHEAT",
	"KANGXI RADICAL HEMP",
	"KANGXI RADICAL YELLOW",
	"KANGXI RADICAL MILLET",
	"KANGXI RADICAL BLACK",
	"KANGXI RADICAL EMBROIDERY",
	"KANGXI RADICAL FROG",
	"KANGXI RADICAL TRIPOD",
	"KANGXI RADICAL DRUM",
	"KANGXI RADICAL RAT",
	"KANGXI RADICAL NOSE",
	"KANGXI RADICAL EVEN",
	"KANGXI RADICAL TOOTH",
	"KANGXI RADICAL DRAGON",
	"KANGXI RADICAL TURTLE",
	"KANGXI RADICAL FLUTE",
	"IDEOGRAPHIC DESCRIPTION CHARACTER LEFT TO RIGHT",
	"IDEOGRAPHIC DESCRIPTION CHARACTER ABOVE TO BELOW",
	"IDEOGRAPHIC DESCRIPTION CHARACTER LEFT TO MIDDLE AND RIGHT",
	"IDEOGRAPHIC DESCRIPTION CHARACTER ABOVE TO MIDDLE AND BELOW",
	"IDEOGRAPHIC DESCRIPTION CHARACTER FULL SURROUND",
	"IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM ABOVE",
	"IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM BELOW",
	"IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM LEFT",
	"IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM UPPER LEFT",
	"IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM UPPER RIGHT",
	"IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM LOWER LEFT",
	"IDEOGRAPHIC DESCRIPTION CHARACTER OVERLAID",
	"IDEOGRAPHIC SPACE",
	"IDEOGRAPHIC COMMA",
	"IDEOGRAPHIC FULL STOP",
	"DITTO MARK",
	"JAPANESE INDUSTRIAL STANDARD SYMBOL",
	"IDEOGRAPHIC ITERATION MARK",
	"IDEOGRAPHIC CLOSING MARK",
	"IDEOGRAPHIC NUMBER ZERO",
	"LEFT ANGLE BRACKET",
	"RIGHT ANGLE BRACKET",
	"LEFT DOUBLE ANGLE BRACKET",
	"RIGHT DOUBLE ANGLE BRACKET",
	"LEFT CORNER BRACKET",
	"RIGHT CORNER BRACKET",
	"LEFT WHITE CORNER BRACKET",
	"RIGHT WHITE CORNER BRACKET",
	"LEFT BLACK LENTICULAR BRACKET",
	"RIGHT BLACK LENTICULAR BRACKET",
	"POSTAL MARK",
	"GETA MARK",
	"LEFT TORTOISE SHELL BRACKET",
	"RIGHT TORTOISE SHELL BRACKET",
	"LEFT WHITE LENTICULAR BRACKET",
	"RIGHT WHITE LENTICULAR BRACKET",
	"LEFT WHITE TORTOISE SHELL BRACKET",
	"RIGHT WHITE TORTOISE SHELL BRACKET",
	"LEFT WHITE SQUARE BRACKET",
	"RIGHT WHITE SQUARE BRACKET",
	"WAVE DASH",
	"REVERSED DOUBLE PRIME QUOTATION MARK",
	"DOUBLE PRIME QUOTATION MARK",
	"LOW DOUBLE PRIME QUOTATION MARK",
	"POSTAL MARK FACE",
	"HANGZHOU NUMERAL ONE",
	"HANGZHOU NUMERAL TWO",
	"HANGZHOU NUMERAL THREE",
	"HANGZHOU NUMERAL FOUR",
	"HANGZHOU NUMERAL FIVE",
	"HANGZHOU NUMERAL SIX",
	"HANGZHOU NUMERAL SEVEN",
	"HANGZHOU NUMERAL EIGHT",
	"HANGZHOU NUMERAL NINE",
	"IDEOGRAPHIC LEVEL TONE MARK",
	"IDEOGRAPHIC RISING TONE MARK",
	"IDEOGRAPHIC DEPARTING TONE MARK",
	"IDEOGRAPHIC ENTERING TONE MARK",
	"HANGUL SINGLE DOT TONE MARK",
	"HANGUL DOUBLE DOT TONE MARK",
	"WAVY DASH",
	"VERTICAL KANA REPEAT MARK",
	"VERTICAL KANA REPEAT WITH VOICED SOUND MARK",
	"VERTICAL KANA REPEAT MARK UPPER HALF",
	"VERTICAL KANA REPEAT WITH VOICED SOUND MARK UPPER HALF",
	"VERTICAL KANA REPEAT MARK LOWER HALF",
	"CIRCLED POSTAL MARK",
	"IDEOGRAPHIC TELEGRAPH LINE FEED SEPARATOR SYMBOL",
	"HANGZHOU NUMERAL TEN",
	"HANGZHOU NUMERAL TWENTY",
	"HANGZHOU NUMERAL THIRTY",
	"VERTICAL IDEOGRAPHIC ITERATION MARK",
	"MASU MARK",
	"PART ALTERNATION MARK",
	"IDEOGRAPHIC VARIATION INDICATOR",
	"IDEOGRAPHIC HALF FILL SPACE",
	"HIRAGANA LETTER SMALL A",
	"HIRAGANA LETTER A",
	"HIRAGANA LETTER SMALL I",
	"HIRAGANA LETTER I",
	"HIRAGANA LETTER SMALL U",
	"HIRAGANA LETTER U",
	"HIRAGANA LETTER SMALL E",
	"HIRAGANA LETTER E",
	"HIRAGANA LETTER SMALL O",
	"HIRAGANA LETTER O",
	"HIRAGANA LETTER KA",
	"HIRAGANA LETTER GA",
	"HIRAGANA LETTER KI",
	"HIRAGANA LETTER GI",
	"HIRAGANA LETTER KU",
	"HIRAGANA LETTER GU",
	"HIRAGANA LETTER KE",
	"HIRAGANA LETTER GE",
	"HIRAGANA LETTER KO",
	"HIRAGANA LETTER GO",
	"HIRAGANA LETTER SA",
	"HIRAGANA LETTER ZA",
	"HIRAGANA LETTER SI",
	"HIRAGANA LETTER ZI",
	"HIRAGANA LETTER SU",
	"HIRAGANA LETTER ZU",
	"HIRAGANA LETTER SE",
	"HIRAGANA LETTER ZE",
	"HIRAGANA LETTER SO",
	"HIRAGANA LETTER ZO",
	"HIRAGANA LETTER TA",
	"HIRAGANA LETTER DA",
	"HIRAGANA LETTER TI",
	"HIRAGANA LETTER DI",
	"HIRAGANA LETTER SMALL TU",
	"HIRAGANA LETTER TU",
	"HIRAGANA LETTER DU",
	"HIRAGANA LETTER TE",
	"HIRAGANA LETTER DE",
	"HIRAGANA LETTER TO",
	"HIRAGANA LETTER DO",
	"HIRAGANA LETTER NA",
	"HIRAGANA LETTER NI",
	"HIRAGANA LETTER NU",
	"HIRAGANA LETTER NE",
	"HIRAGANA LETTER NO",
	"HIRAGANA LETTER HA",
	"HIRAGANA LETTER BA",
	"HIRAGANA LETTER PA",
	"HIRAGANA LETTER HI",
	"HIRAGANA LETTER BI",
	"HIRAGANA LETTER PI",
	"HIRAGANA LETTER HU",
	"HIRAGANA LETTER BU",
	"HIRAGANA LETTER PU",
	"HIRAGANA LETTER HE",
	"HIRAGANA LETTER BE",
	"HIRAGANA LETTER PE",
	"HIRAGANA LETTER HO",
	"HIRAGANA LETTER BO",
	"HIRAGANA LETTER PO",
	"HIRAGANA LETTER MA",
	"HIRAGANA LETTER MI",
	"HIRAGANA LETTER MU",
	"HIRAGANA LETTER ME",
	"HIRAGANA LETTER MO",
	"HIRAGANA LETTER SMALL YA",
	"HIRAGANA LETTER YA",
	"HIRAGANA LETTER SMALL YU",
	"HIRAGANA LETTER YU",
	"HIRAGANA LETTER SMALL YO",
	"HIRAGANA LETTER YO",
	"HIRAGANA LETTER RA",
	"HIRAGANA LETTER RI",
	"HIRAGANA LETTER RU",
	"HIRAGANA LETTER RE",
	"HIRAGANA LETTER RO",
	"HIRAGANA LETTER SMALL WA",
	"HIRAGANA LETTER WA",
	"HIRAGANA LETTER WI",
	"HIRAGANA LETTER WE",
	"HIRAGANA LETTER WO",
	"HIRAGANA LETTER N",
	"HIRAGANA LETTER VU",
	"HIRAGANA LETTER SMALL KA",
	"HIRAGANA LETTER SMALL KE",
	"COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK",
	"COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK",
	"KATAKANA-HIRAGANA VOICED SOUND MARK",
	"KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK",
	"HIRAGANA ITERATION MARK",
	"HIRAGANA VOICED ITERATION MARK",
	"HIRAGANA DIGRAPH YORI",
	"KATAKANA-HIRAGANA DOUBLE HYPHEN",
	"KATAKANA LETTER SMALL A",
	"KATAKANA LETTER A",
	"KATAKANA LETTER SMALL I",
	"KATAKANA LETTER I",
	"KATAKANA LETTER SMALL U",
	"KATAKANA LETTER U",
	"KATAKANA LETTER SMALL E",
	"KATAKANA LETTER E",
	"KATAKANA LETTER SMALL O",
	"KATAKANA LETTER O",
	"KATAKANA LETTER KA",
	"KATAKANA LETTER GA",
	"KATAKANA LETTER KI",
	"KATAKANA LETTER GI",
	"KATAKANA LETTER KU",
	"KATAKANA LETTER GU",
	"KATAKANA LETTER KE",
	"KATAKANA LETTER GE",
	"KATAKANA LETTER KO",
	"KATAKANA LETTER GO",
	"KATAKANA LETTER SA",
	"KATAKANA LETTER ZA",
	"KATAKANA LETTER SI",
	"KATAKANA LETTER ZI",
	"KATAKANA LETTER SU",
	"KATAKANA LETTER ZU",
	"KATAKANA LETTER SE",
	"KATAKANA LETTER ZE",
	"KATAKANA LETTER SO",
	"KATAKANA LETTER ZO",
	"KATAKANA LETTER TA",
	"KATAKANA LETTER DA",
	"KATAKANA LETTER TI",
	"KATAKANA LETTER DI",
	"KATAKANA LETTER SMALL TU",
	"KATAKANA LETTER TU",
	"KATAKANA LETTER DU",
	"KATAKANA LETTER TE",
	"KATAKANA LETTER DE",
	"KATAKANA LETTER TO",
	"KATAKANA LETTER DO",
	"KATAKANA LETTER NA",
	"KATAKANA LETTER NI",
	"KATAKANA LETTER NU",
	"KATAKANA LETTER NE",
	"KATAKANA LETTER NO",
	"KATAKANA LETTER HA",
	"KATAKANA LETTER BA",
	"KATAKANA LETTER PA",
	"KATAKANA LETTER HI",
	"KATAKANA LETTER BI",
	"KATAKANA LETTER PI",
	"KATAKANA LETTER HU",
	"KATAKANA LETTER BU",
	"KATAKANA LETTER PU",
	"KATAKANA LETTER HE",
	"KATAKANA LETTER BE",
	"KATAKANA LETTER PE",
	"KATAKANA LETTER HO",
	"KATAKANA LETTER BO",
	"KATAKANA LETTER PO",
	"KATAKANA LETTER MA",
	"KATAKANA LETTER MI",
	"KATAKANA LETTER MU",
	"KATAKANA LETTER ME",
	"KATAKANA LETTER MO",
	"KATAKANA LETTER SMALL YA",
	"KATAKANA LETTER YA",
	"KATAKANA LETTER SMALL YU",
	"KATAKANA LETTER YU",
	"KATAKANA LETTER SMALL YO",
	"KATAKANA LETTER YO",
	"KATAKANA LETTER RA",
	"KATAKANA LETTER RI",
	"KATAKANA LETTER RU",
	"KATAKANA LETTER RE",
	"KATAKANA LETTER RO",
	"KATAKANA LETTER SMALL WA",
	"KATAKANA LETTER WA",
	"KATAKANA LETTER WI",
	"KATAKANA LETTER WE",
	"KATAKANA LETTER WO",
	"KATAKANA LETTER N",
	"KATAKANA LETTER VU",
	"KATAKANA LETTER SMALL KA",
	"KATAKANA LETTER SMALL KE",
	"KATAKANA LETTER VA",
	"KATAKANA LETTER VI",
	"KATAKANA LETTER VE",
	"KATAKANA LETTER VO",
	"KATAKANA MIDDLE DOT",
	"KATAKANA-HIRAGANA PROLONGED SOUND MARK",
	"KATAKANA ITERATION MARK",
	"KATAKANA VOICED ITERATION MARK",
	"KATAKANA DIGRAPH KOTO",
	"BOPOMOFO LETTER B",
	"BOPOMOFO LETTER P",
	"BOPOMOFO LETTER M",
	"BOPOMOFO LETTER F",
	"BOPOMOFO LETTER D",
	"BOPOMOFO LETTER T",
	"BOPOMOFO LETTER N",
	"BOPOMOFO LETTER L",
	"BOPOMOFO LETTER G",
	"BOPOMOFO LETTER K",
	"BOPOMOFO LETTER H",
	"BOPOMOFO LETTER J",
	"BOPOMOFO LETTER Q",
	"BOPOMOFO LETTER X",
	"BOPOMOFO LETTER ZH",
	"BOPOMOFO LETTER CH",
	"BOPOMOFO LETTER SH",
	"BOPOMOFO LETTER R",
	"BOPOMOFO LETTER Z",
	"BOPOMOFO LETTER C",
	"BOPOMOFO LETTER S",
	"BOPOMOFO LETTER A",
	"BOPOMOFO LETTER O",
	"BOPOMOFO LETTER E",
	"BOPOMOFO LETTER EH",
	"BOPOMOFO LETTER AI",
	"BOPOMOFO LETTER EI",
	"BOPOMOFO LETTER AU",
	"BOPOMOFO LETTER OU",
	"BOPOMOFO LETTER AN",
	"BOPOMOFO LETTER EN",
	"BOPOMOFO LETTER ANG",
	"BOPOMOFO LETTER ENG",
	"BOPOMOFO LETTER ER",
	"BOPOMOFO LETTER I",
	"BOPOMOFO LETTER U",
	"BOPOMOFO LETTER IU",
	"BOPOMOFO LETTER V",
	"BOPOMOFO LETTER NG",
	"BOPOMOFO LETTER GN",
	"BOPOMOFO LETTER IH",
	"BOPOMOFO LETTER O WITH DOT ABOVE",
	"BOPOMOFO LETTER NN",
	"HANGUL LETTER KIYEOK",
	"HANGUL LETTER SSANGKIYEOK",
	"HANGUL LETTER KIYEOK-SIOS",
	"HANGUL LETTER NIEUN",
	"HANGUL LETTER NIEUN-CIEUC",
	"HANGUL LETTER NIEUN-HIEUH",
	"HANGUL LETTER TIKEUT",
	"HANGUL LETTER SSANGTIKEUT",
	"HANGUL LETTER RIEUL",
	"HANGUL LETTER RIEUL-KIYEOK",
	"HANGUL LETTER RIEUL-MIEUM",
	"HANGUL LETTER RIEUL-PIEUP",
	"HANGUL LETTER RIEUL-SIOS",
	"HANGUL LETTER RIEUL-THIEUTH",
	"HANGUL LETTER RIEUL-PHIEUPH",
	"HANGUL LETTER RIEUL-HIEUH",
	"HANGUL LETTER MIEUM",
	"HANGUL LETTER PIEUP",
	"HANGUL LETTER SSANGPIEUP",
	"HANGUL LETTER PIEUP-SIOS",
	"HANGUL LETTER SIOS",
	"HANGUL LETTER SSANGSIOS",
	"HANGUL LETTER IEUNG",
	"HANGUL LETTER CIEUC",
	"HANGUL LETTER SSANGCIEUC",
	"HANGUL LETTER CHIEUCH",
	"HANGUL LETTER KHIEUKH",
	"HANGUL LETTER THIEUTH",
	"HANGUL LETTER PHIEUPH",
	"HANGUL LETTER HIEUH",
	"HANGUL LETTER A",
	"HANGUL LETTER AE",
	"HANGUL LETTER YA",
	"HANGUL LETTER YAE",
	"HANGUL LETTER EO",
	"HANGUL LETTER E",
	"HANGUL LETTER YEO",
	"HANGUL LETTER YE",
	"HANGUL LETTER O",
	"HANGUL LETTER WA",
	"HANGUL LETTER WAE",
	"HANGUL LETTER OE",
	"HANGUL LETTER YO",
	"HANGUL LETTER U",
	"HANGUL LETTER WEO",
	"HANGUL LETTER WE",
	"HANGUL LETTER WI",
	"HANGUL LETTER YU",
	"HANGUL LETTER EU",
	"HANGUL LETTER YI",
	"HANGUL LETTER I",
	"HANGUL FILLER",
	"HANGUL LETTER SSANGNIEUN",
	"HANGUL LETTER NIEUN-TIKEUT",
	"HANGUL LETTER NIEUN-SIOS",
	"HANGUL LETTER NIEUN-PANSIOS",
	"HANGUL LETTER RIEUL-KIYEOK-SIOS",
	"HANGUL LETTER RIEUL-TIKEUT",
	"HANGUL LETTER RIEUL-PIEUP-SIOS",
	"HANGUL LETTER RIEUL-PANSIOS",
	"HANGUL LETTER RIEUL-YEORINHIEUH",
	"HANGUL LETTER MIEUM-PIEUP",
	"HANGUL LETTER MIEUM-SIOS",
	"HANGUL LETTER MIEUM-PANSIOS",
	"HANGUL LETTER KAPYEOUNMIEUM",
	"HANGUL LETTER PIEUP-KIYEOK",
	"HANGUL LETTER PIEUP-TIKEUT",
	"HANGUL LETTER PIEUP-SIOS-KIYEOK",
	"HANGUL LETTER PIEUP-SIOS-TIKEUT",
	"HANGUL LETTER PIEUP-CIEUC",
	"HANGUL LETTER PIEUP-THIEUTH",
	"HANGUL LETTER KAPYEOUNPIEUP",
	"HANGUL LETTER KAPYEOUNSSANGPIEUP",
	"HANGUL LETTER SIOS-KIYEOK",
	"HANGUL LETTER SIOS-NIEUN",
	"HANGUL LETTER SIOS-TIKEUT",
	"HANGUL LETTER SIOS-PIEUP",
	"HANGUL LETTER SIOS-CIEUC",
	"HANGUL LETTER PANSIOS",
	"HANGUL LETTER SSANGIEUNG",
	"HANGUL LETTER YESIEUNG",
	"HANGUL LETTER YESIEUNG-SIOS",
	"HANGUL LETTER YESIEUNG-PANSIOS",
	"HANGUL LETTER KAPYEOUNPHIEUPH",
	"HANGUL LETTER SSANGHIEUH",
	"HANGUL LETTER YEORINHIEUH",
	"HANGUL LETTER YO-YA",
	"HANGUL LETTER YO-YAE",
	"HANGUL LETTER YO-I",
	"HANGUL LETTER YU-YEO",
	"HANGUL LETTER YU-YE",
	"HANGUL LETTER YU-I",
	"HANGUL LETTER ARAEA",
	"HANGUL LETTER ARAEAE",
	"IDEOGRAPHIC ANNOTATION LINKING MARK",
	"IDEOGRAPHIC ANNOTATION REVERSE MARK",
	"IDEOGRAPHIC ANNOTATION ONE MARK",
	"IDEOGRAPHIC ANNOTATION TWO MARK",
	"IDEOGRAPHIC ANNOTATION THREE MARK",
	"IDEOGRAPHIC ANNOTATION FOUR MARK",
	"IDEOGRAPHIC ANNOTATION TOP MARK",
	"IDEOGRAPHIC ANNOTATION MIDDLE MARK",
	"IDEOGRAPHIC ANNOTATION BOTTOM MARK",
	"IDEOGRAPHIC ANNOTATION FIRST MARK",
	"IDEOGRAPHIC ANNOTATION SECOND MARK",
	"IDEOGRAPHIC ANNOTATION THIRD MARK",
	"IDEOGRAPHIC ANNOTATION FOURTH MARK",
	"IDEOGRAPHIC ANNOTATION HEAVEN MARK",
	"IDEOGRAPHIC ANNOTATION EARTH MARK",
	"IDEOGRAPHIC ANNOTATION MAN MARK",
	"BOPOMOFO LETTER BU",
	"BOPOMOFO LETTER ZI",
	"BOPOMOFO LETTER JI",
	"BOPOMOFO LETTER GU",
	"BOPOMOFO LETTER EE",
	"BOPOMOFO LETTER ENN",
	"BOPOMOFO LETTER OO",
	"BOPOMOFO LETTER ONN",
	"BOPOMOFO LETTER IR",
	"BOPOMOFO LETTER ANN",
	"BOPOMOFO LETTER INN",
	"BOPOMOFO LETTER UNN",
	"BOPOMOFO LETTER IM",
	"BOPOMOFO LETTER NGG",
	"BOPOMOFO LETTER AINN",
	"BOPOMOFO LETTER AUNN",
	"BOPOMOFO LETTER AM",
	"BOPOMOFO LETTER OM",
	"BOPOMOFO LETTER ONG",
	"BOPOMOFO LETTER INNN",
	"BOPOMOFO FINAL LETTER P",
	"BOPOMOFO FINAL LETTER T",
	"BOPOMOFO FINAL LETTER K",
	"BOPOMOFO FINAL LETTER H",
	"BOPOMOFO LETTER GH",
	"BOPOMOFO LETTER LH",
	"BOPOMOFO LETTER ZY",
	"BOPOMOFO FINAL LETTER G",
	"BOPOMOFO LETTER GW",
	"BOPOMOFO LETTER KW",
	"BOPOMOFO LETTER OE",
	"BOPOMOFO LETTER AH",
	"CJK STROKE T",
	"CJK STROKE WG",
	"CJK STROKE XG",
	"CJK STROKE BXG",
	"CJK STROKE SW",
	"CJK STROKE HZZ",
	"CJK STROKE HZG",
	"CJK STROKE HP",
	"CJK STROKE HZWG",
	"CJK STROKE SZWG",
	"CJK STROKE HZT",
	"CJK STROKE HZZP",
	"CJK STROKE HPWG",
	"CJK STROKE HZW",
	"CJK STROKE HZZZ",
	"CJK STROKE N",
	"CJK STROKE H",
	"CJK STROKE S",
	"CJK STROKE P",
	"CJK STROKE SP",
	"CJK STROKE D",
	"CJK STROKE HZ",
	"CJK STROKE HG",
	"CJK STROKE SZ",
	"CJK STROKE SWZ",
	"CJK STROKE ST",
	"CJK STROKE SG",
	"CJK STROKE PD",
	"CJK STROKE PZ",
	"CJK STROKE TN",
	"CJK STROKE SZZ",
	"CJK STROKE SWG",
	"CJK STROKE HXWG",
	"CJK STROKE HZZZG",
	"CJK STROKE PG",
	"CJK STROKE Q",
	"KATAKANA LETTER SMALL KU",
	"KATAKANA LETTER SMALL SI",
	"KATAKANA LETTER SMALL SU",
	"KATAKANA LETTER SMALL TO",
	"KATAKANA LETTER SMALL NU",
	"KATAKANA LETTER SMALL HA",
	"KATAKANA LETTER SMALL HI",
	"KATAKANA LETTER SMALL HU",
	"KATAKANA LETTER SMALL HE",
	"KATAKANA LETTER SMALL HO",
	"KATAKANA LETTER SMALL MU",
	"KATAKANA LETTER SMALL RA",
	"KATAKANA LETTER SMALL RI",
	"KATAKANA LETTER SMALL RU",
	"KATAKANA LETTER SMALL RE",
	"KATAKANA LETTER SMALL RO",
	"PARENTHESIZED HANGUL KIYEOK",
	"PARENTHESIZED HANGUL NIEUN",
	"PARENTHESIZED HANGUL TIKEUT",
	"PARENTHESIZED HANGUL RIEUL",
	"PARENTHESIZED HANGUL MIEUM",
	"PARENTHESIZED HANGUL PIEUP",
	"PARENTHESIZED HANGUL SIOS",
	"PARENTHESIZED HANGUL IEUNG",
	"PARENTHESIZED HANGUL CIEUC",
	"PARENTHESIZED HANGUL CHIEUCH",
	"PARENTHESIZED HANGUL KHIEUKH",
	"PARENTHESIZED HANGUL THIEUTH",
	"PARENTHESIZED HANGUL PHIEUPH",
	"PARENTHESIZED HANGUL HIEUH",
	"PARENTHESIZED HANGUL KIYEOK A",
	"PARENTHESIZED HANGUL NIEUN A",
	"PARENTHESIZED HANGUL TIKEUT A",
	"PARENTHESIZED HANGUL RIEUL A",
	"PARENTHESIZED HANGUL MIEUM A",
	"PARENTHESIZED HANGUL PIEUP A",
	"PARENTHESIZED HANGUL SIOS A",
	"PARENTHESIZED HANGUL IEUNG A",
	"PARENTHESIZED HANGUL CIEUC A",
	"PARENTHESIZED HANGUL CHIEUCH A",
	"PARENTHESIZED HANGUL KHIEUKH A",
	"PARENTHESIZED HANGUL THIEUTH A",
	"PARENTHESIZED HANGUL PHIEUPH A",
	"PARENTHESIZED HANGUL HIEUH A",
	"PARENTHESIZED HANGUL CIEUC U",
	"PARENTHESIZED KOREAN CHARACTER OJEON",
	"PARENTHESIZED KOREAN CHARACTER O HU",
	"PARENTHESIZED IDEOGRAPH ONE",
	"PARENTHESIZED IDEOGRAPH TWO",
	"PARENTHESIZED IDEOGRAPH THREE",
	"PARENTHESIZED IDEOGRAPH FOUR",
	"PARENTHESIZED IDEOGRAPH FIVE",
	"PARENTHESIZED IDEOGRAPH SIX",
	"PARENTHESIZED IDEOGRAPH SEVEN",
	"PARENTHESIZED IDEOGRAPH EIGHT",
	"PARENTHESIZED IDEOGRAPH NINE",
	"PARENTHESIZED IDEOGRAPH TEN",
	"PARENTHESIZED IDEOGRAPH MOON",
	"PARENTHESIZED IDEOGRAPH FIRE",
	"PARENTHESIZED IDEOGRAPH WATER",
	"PARENTHESIZED IDEOGRAPH WOOD",
	"PARENTHESIZED IDEOGRAPH METAL",
	"PARENTHESIZED IDEOGRAPH EARTH",
	"PARENTHESIZED IDEOGRAPH SUN",
	"PARENTHESIZED IDEOGRAPH STOCK",
	"PARENTHESIZED IDEOGRAPH HAVE",
	"PARENTHESIZED IDEOGRAPH SOCIETY",
	"PARENTHESIZED IDEOGRAPH NAME",
	"PARENTHESIZED IDEOGRAPH SPECIAL",
	"PARENTHESIZED IDEOGRAPH FINANCIAL",
	"PARENTHESIZED IDEOGRAPH CONGRATULATION",
	"PARENTHESIZED IDEOGRAPH LABOR",
	"PARENTHESIZED IDEOGRAPH REPRESENT",
	"PARENTHESIZED IDEOGRAPH CALL",
	"PARENTHESIZED IDEOGRAPH STUDY",
	"PARENTHESIZED IDEOGRAPH SUPERVISE",
	"PARENTHESIZED IDEOGRAPH ENTERPRISE",
	"PARENTHESIZED IDEOGRAPH RESOURCE",
	"PARENTHESIZED IDEOGRAPH ALLIANCE",
	"PARENTHESIZED IDEOGRAPH FESTIVAL",
	"PARENTHESIZED IDEOGRAPH REST",
	"PARENTHESIZED IDEOGRAPH SELF",
	"PARENTHESIZED IDEOGRAPH REACH",
	"CIRCLED IDEOGRAPH QUESTION",
	"CIRCLED IDEOGRAPH KINDERGARTEN",
	"CIRCLED IDEOGRAPH SCHOOL",
	"CIRCLED IDEOGRAPH KOTO",
	"CIRCLED NUMBER TEN ON BLACK SQUARE",
	"CIRCLED NUMBER TWENTY ON BLACK SQUARE",
	"CIRCLED NUMBER THIRTY ON BLACK SQUARE",
	"CIRCLED NUMBER FORTY ON BLACK SQUARE",
	"CIRCLED NUMBER FIFTY ON BLACK SQUARE",
	"CIRCLED NUMBER SIXTY ON BLACK SQUARE",
	"CIRCLED NUMBER SEVENTY ON BLACK SQUARE",
	"CIRCLED NUMBER EIGHTY ON BLACK SQUARE",
	"PARTNERSHIP SIGN",
	"CIRCLED NUMBER TWENTY ONE",
	"CIRCLED NUMBER TWENTY TWO",
	"CIRCLED NUMBER TWENTY THREE",
	"CIRCLED NUMBER TWENTY FOUR",
	"CIRCLED NUMBER TWENTY FIVE",
	"CIRCLED NUMBER TWENTY SIX",
	"CIRCLED NUMBER TWENTY SEVEN",
	"CIRCLED NUMBER TWENTY EIGHT",
	"CIRCLED NUMBER TWENTY NINE",
	"CIRCLED NUMBER THIRTY",
	"CIRCLED NUMBER THIRTY ONE",
	"CIRCLED NUMBER THIRTY TWO",
	"CIRCLED NUMBER THIRTY THREE",
	"CIRCLED NUMBER THIRTY FOUR",
	"CIRCLED NUMBER THIRTY FIVE",
	"CIRCLED HANGUL KIYEOK",
	"CIRCLED HANGUL NIEUN",
	"CIRCLED HANGUL TIKEUT",
	"CIRCLED HANGUL RIEUL",
	"CIRCLED HANGUL MIEUM",
	"CIRCLED HANGUL PIEUP",
	"CIRCLED HANGUL SIOS",
	"CIRCLED HANGUL IEUNG",
	"CIRCLED HANGUL CIEUC",
	"CIRCLED HANGUL CHIEUCH",
	"CIRCLED HANGUL KHIEUKH",
	"CIRCLED HANGUL THIEUTH",
	"CIRCLED HANGUL PHIEUPH",
	"CIRCLED HANGUL HIEUH",
	"CIRCLED HANGUL KIYEOK A",
	"CIRCLED HANGUL NIEUN A",
	"CIRCLED HANGUL TIKEUT A",
	"CIRCLED HANGUL RIEUL A",
	"CIRCLED HANGUL MIEUM A",
	"CIRCLED HANGUL PIEUP A",
	"CIRCLED HANGUL SIOS A",
	"CIRCLED HANGUL IEUNG A",
	"CIRCLED HANGUL CIEUC A",
	"CIRCLED HANGUL CHIEUCH A",
	"CIRCLED HANGUL KHIEUKH A",
	"CIRCLED HANGUL THIEUTH A",
	"CIRCLED HANGUL PHIEUPH A",
	"CIRCLED HANGUL HIEUH A",
	"CIRCLED KOREAN CHARACTER CHAMKO",
	"CIRCLED KOREAN CHARACTER JUEUI",
	"CIRCLED HANGUL IEUNG U",
	"KOREAN STANDARD SYMBOL",
	"CIRCLED IDEOGRAPH ONE",
	"CIRCLED IDEOGRAPH TWO",
	"CIRCLED IDEOGRAPH THREE",
	"CIRCLED IDEOGRAPH FOUR",
	"CIRCLED IDEOGRAPH FIVE",
	"CIRCLED IDEOGRAPH SIX",
	"CIRCLED IDEOGRAPH SEVEN",
	"CIRCLED IDEOGRAPH EIGHT",
	"CIRCLED IDEOGRAPH NINE",
	"CIRCLED IDEOGRAPH TEN",
	"CIRCLED IDEOGRAPH MOON",
	"CIRCLED IDEOGRAPH FIRE",
	"CIRCLED IDEOGRAPH WATER",
	"CIRCLED IDEOGRAPH WOOD",
	"CIRCLED IDEOGRAPH METAL",
	"CIRCLED IDEOGRAPH EARTH",
	"CIRCLED IDEOGRAPH SUN",
	"CIRCLED IDEOGRAPH STOCK",
	"CIRCLED IDEOGRAPH HAVE",
	"CIRCLED IDEOGRAPH SOCIETY",
	"CIRCLED IDEOGRAPH NAME",
	"CIRCLED IDEOGRAPH SPECIAL",
	"CIRCLED IDEOGRAPH FINANCIAL",
	"CIRCLED IDEOGRAPH CONGRATULATION",
	"CIRCLED IDEOGRAPH LABOR",
	"CIRCLED IDEOGRAPH SECRET",
	"CIRCLED IDEOGRAPH MALE",
	"CIRCLED IDEOGRAPH FEMALE",
	"CIRCLED IDEOGRAPH SUITABLE",
	"CIRCLED IDEOGRAPH EXCELLENT",
	"CIRCLED IDEOGRAPH PRINT",
	"CIRCLED IDEOGRAPH ATTENTION",
	"CIRCLED IDEOGRAPH ITEM",
	"CIRCLED IDEOGRAPH REST",
	"CIRCLED IDEOGRAPH COPY",
	"CIRCLED IDEOGRAPH CORRECT",
	"CIRCLED IDEOGRAPH HIGH",
	"CIRCLED IDEOGRAPH CENTRE",
	"CIRCLED IDEOGRAPH LOW",
	"CIRCLED IDEOGRAPH LEFT",
	"CIRCLED IDEOGRAPH RIGHT",
	"CIRCLED IDEOGRAPH MEDICINE",
	"CIRCLED IDEOGRAPH RELIGION",
	"CIRCLED IDEOGRAPH STUDY",
	"CIRCLED IDEOGRAPH SUPERVISE",
	"CIRCLED IDEOGRAPH ENTERPRISE",
	"CIRCLED IDEOGRAPH RESOURCE",
	"CIRCLED IDEOGRAPH ALLIANCE",
	"CIRCLED IDEOGRAPH NIGHT",
	"CIRCLED NUMBER THIRTY SIX",
	"CIRCLED NUMBER THIRTY SEVEN",
	"CIRCLED NUMBER THIRTY EIGHT",
	"CIRCLED NUMBER THIRTY NINE",
	"CIRCLED NUMBER FORTY",
	"CIRCLED NUMBER FORTY ONE",
	"CIRCLED NUMBER FORTY TWO",
	"CIRCLED NUMBER FORTY THREE",
	"CIRCLED NUMBER FORTY FOUR",
	"CIRCLED NUMBER FORTY FIVE",
	"CIRCLED NUMBER FORTY SIX",
	"CIRCLED NUMBER FORTY SEVEN",
	"CIRCLED NUMBER FORTY EIGHT",
	"CIRCLED NUMBER FORTY NINE",
	"CIRCLED NUMBER FIFTY",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR JANUARY",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR FEBRUARY",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR MARCH",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR APRIL",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR MAY",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR JUNE",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR JULY",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR AUGUST",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR SEPTEMBER",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR OCTOBER",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR NOVEMBER",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DECEMBER",
	"SQUARE HG",
	"SQUARE ERG",
	"SQUARE EV",
	"LIMITED LIABILITY SIGN",
	"CIRCLED KATAKANA A",
	"CIRCLED KATAKANA I",
	"CIRCLED KATAKANA U",
	"CIRCLED KATAKANA E",
	"CIRCLED KATAKANA O",
	"CIRCLED KATAKANA KA",
	"CIRCLED KATAKANA KI",
	"CIRCLED KATAKANA KU",
	"CIRCLED KATAKANA KE",
	"CIRCLED KATAKANA KO",
	"CIRCLED KATAKANA SA",
	"CIRCLED KATAKANA SI",
	"CIRCLED KATAKANA SU",
	"CIRCLED KATAKANA SE",
	"CIRCLED KATAKANA SO",
	"CIRCLED KATAKANA TA",
	"CIRCLED KATAKANA TI",
	"CIRCLED KATAKANA TU",
	"CIRCLED KATAKANA TE",
	"CIRCLED KATAKANA TO",
	"CIRCLED KATAKANA NA",
	"CIRCLED KATAKANA NI",
	"CIRCLED KATAKANA NU",
	"CIRCLED KATAKANA NE",
	"CIRCLED KATAKANA NO",
	"CIRCLED KATAKANA HA",
	"CIRCLED KATAKANA HI",
	"CIRCLED KATAKANA HU",
	"CIRCLED KATAKANA HE",
	"CIRCLED KATAKANA HO",
	"CIRCLED KATAKANA MA",
	"CIRCLED KATAKANA MI",
	"CIRCLED KATAKANA MU",
	"CIRCLED KATAKANA ME",
	"CIRCLED KATAKANA MO",
	"CIRCLED KATAKANA YA",
	"CIRCLED KATAKANA YU",
	"CIRCLED KATAKANA YO",
	"CIRCLED KATAKANA RA",
	"CIRCLED KATAKANA RI",
	"CIRCLED KATAKANA RU",
	"CIRCLED KATAKANA RE",
	"CIRCLED KATAKANA RO",
	"CIRCLED KATAKANA WA",
	"CIRCLED KATAKANA WI",
	"CIRCLED KATAKANA WE",
	"CIRCLED KATAKANA WO",
	"SQUARE ERA NAME REIWA",
	"SQUARE APAATO",
	"SQUARE ARUHUA",
	"SQUARE ANPEA",
	"SQUARE AARU",
	"SQUARE ININGU",
	"SQUARE INTI",
	"SQUARE UON",
	"SQUARE ESUKUUDO",
	"SQUARE EEKAA",
	"SQUARE ONSU",
	"SQUARE OOMU",
	"SQUARE KAIRI",
	"SQUARE KARATTO",
	"SQUARE KARORII",
	"SQUARE GARON",
	"SQUARE GANMA",
	"SQUARE GIGA",
	"SQUARE GINII",
	"SQUARE KYURII",
	"SQUARE GIRUDAA",
	"SQUARE KIRO",
	"SQUARE KIROGURAMU",
	"SQUARE KIROMEETORU",
	"SQUARE KIROWATTO",
	"SQUARE GURAMU",
	"SQUARE GURAMUTON",
	"SQUARE KURUZEIRO",
	"SQUARE KUROONE",
	"SQUARE KEESU",
	"SQUARE KORUNA",
	"SQUARE KOOPO",
	"SQUARE SAIKURU",
	"SQUARE SANTIIMU",
	"SQUARE SIRINGU",
	"SQUARE SENTI",
	"SQUARE SENTO",
	"SQUARE DAASU",
	"SQUARE DESI",
	"SQUARE DORU",
	"SQUARE TON",
	"SQUARE NANO",
	"SQUARE NOTTO",
	"SQUARE HAITU",
	"SQUARE PAASENTO",
	"SQUARE PAATU",
	"SQUARE BAARERU",
	"SQUARE PIASUTORU",
	"SQUARE PIKURU",
	"SQUARE PIKO",
	"SQUARE BIRU",
	"SQUARE HUARADDO",
	"SQUARE HUIITO",
	"SQUARE BUSSYERU",
	"SQUARE HURAN",
	"SQUARE HEKUTAARU",
	"SQUARE PESO",
	"SQUARE PENIHI",
	"SQUARE HERUTU",
	"SQUARE PENSU",
	"SQUARE PEEZI",
	"SQUARE BEETA",
	"SQUARE POINTO",
	"SQUARE BORUTO",
	"SQUARE HON",
	"SQUARE PONDO",
	"SQUARE HOORU",
	"SQUARE HOON",
	"SQUARE MAIKURO",
	"SQUARE MAIRU",
	"SQUARE MAHHA",
	"SQUARE MARUKU",
	"SQUARE MANSYON",
	"SQUARE MIKURON",
	"SQUARE MIRI",
	"SQUARE MIRIBAARU",
	"SQUARE MEGA",
	"SQUARE MEGATON",
	"SQUARE MEETORU",
	"SQUARE YAADO",
	"SQUARE YAARU",
	"SQUARE YUAN",
	"SQUARE RITTORU",
	"SQUARE RIRA",
	"SQUARE RUPII",
	"SQUARE RUUBURU",
	"SQUARE REMU",
	"SQUARE RENTOGEN",
	"SQUARE WATTO",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ZERO",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ONE",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWO",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR THREE",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOUR",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FIVE",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIX",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVEN",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR EIGHT",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINE",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TEN",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ELEVEN",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWELVE",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR THIRTEEN",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOURTEEN",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FIFTEEN",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIXTEEN",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVENTEEN",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR EIGHTEEN",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINETEEN",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-ONE",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-TWO",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-THREE",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-FOUR",
	"SQUARE HPA",
	"SQUARE DA",
	"SQUARE AU",
	"SQUARE BAR",
	"SQUARE OV",
	"SQUARE PC",
	"SQUARE DM",
	"SQUARE DM SQUARED",
	"SQUARE DM CUBED",
	"SQUARE IU",
	"SQUARE ERA NAME HEISEI",
	"SQUARE ERA NAME SYOUWA",
	"SQUARE ERA NAME TAISYOU",
	"SQUARE ERA NAME MEIZI",
	"SQUARE CORPORATION",
	"SQUARE PA AMPS",
	"SQUARE NA",
	"SQUARE MU A",
	"SQUARE MA",
	"SQUARE KA",
	"SQUARE KB",
	"SQUARE MB",
	"SQUARE GB",
	"SQUARE CAL",
	"SQUARE KCAL",
	"SQUARE PF",
	"SQUARE NF",
	"SQUARE MU F",
	"SQUARE MU G",
	"SQUARE MG",
	"SQUARE KG",
	"SQUARE HZ",
	"SQUARE KHZ",
	"SQUARE MHZ",
	"SQUARE GHZ",
	"SQUARE THZ",
	"SQUARE MU L",
	"SQUARE ML",
	"SQUARE DL",
	"SQUARE KL",
	"SQUARE FM",
	"SQUARE NM",
	"SQUARE MU M",
	"SQUARE MM",
	"SQUARE CM",
	"SQUARE KM",
	"SQUARE MM SQUARED",
	"SQUARE CM SQUARED",
	"SQUARE M SQUARED",
	"SQUARE KM SQUARED",
	"SQUARE MM CUBED",
	"SQUARE CM CUBED",
	"SQUARE M CUBED",
	"SQUARE KM CUBED",
	"SQUARE M OVER S",
	"SQUARE M OVER S SQUARED",
	"SQUARE PA",
	"SQUARE KPA",
	"SQUARE MPA",
	"SQUARE GPA",
	"SQUARE RAD",
	"SQUARE RAD OVER S",
	"SQUARE RAD OVER S SQUARED",
	"SQUARE PS",
	"SQUARE NS",
	"SQUARE MU S",
	"SQUARE MS",
	"SQUARE PV",
	"SQUARE NV",
	"SQUARE MU V",
	"SQUARE MV",
	"SQUARE KV",
	"SQUARE MV MEGA",
	"SQUARE PW",
	"SQUARE NW",
	"SQUARE MU W",
	"SQUARE MW",
	"SQUARE KW",
	"SQUARE MW MEGA",
	"SQUARE K OHM",
	"SQUARE M OHM",
	"SQUARE AM",
	"SQUARE BQ",
	"SQUARE CC",
	"SQUARE CD",
	"SQUARE C OVER KG",
	"SQUARE CO",
	"SQUARE DB",
	"SQUARE GY",
	"SQUARE HA",
	"SQUARE HP",
	"SQUARE IN",
	"SQUARE KK",
	"SQUARE KM CAPITAL",
	"SQUARE KT",
	"SQUARE LM",
	"SQUARE LN",
	"SQUARE LOG",
	"SQUARE LX",
	"SQUARE MB SMALL",
	"SQUARE MIL",
	"SQUARE MOL",
	"SQUARE PH",
	"SQUARE PM",
	"SQUARE PPM",
	"SQUARE PR",
	"SQUARE SR",
	"SQUARE SV",
	"SQUARE WB",
	"SQUARE V OVER M",
	"SQUARE A OVER M",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY ONE",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWO",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THREE",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FOUR",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FIVE",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SIX",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVEN",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY EIGHT",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINE",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TEN",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY ELEVEN",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWELVE",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTEEN",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FOURTEEN",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FIFTEEN",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SIXTEEN",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVENTEEN",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY EIGHTEEN",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINETEEN",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-ONE",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-TWO",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-THREE",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-FOUR",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-FIVE",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-SIX",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-SEVEN",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-EIGHT",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-NINE",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTY",
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTY-ONE",
	"SQUARE GAL",
	"<CJK Ideograph Extension A, First>",
	"<CJK Ideograph Extension A, Last>",
	"HEXAGRAM FOR THE CREATIVE HEAVEN",
	"HEXAGRAM FOR THE RECEPTIVE EARTH",
	"HEXAGRAM FOR DIFFICULTY AT THE BEGINNING",
	"HEXAGRAM FOR YOUTHFUL FOLLY",
	"HEXAGRAM FOR WAITING",
	"HEXAGRAM FOR CONFLICT",
	"HEXAGRAM FOR THE ARMY",
	"HEXAGRAM FOR HOLDING TOGETHER",
	"HEXAGRAM FOR SMALL TAMING",
	"HEXAGRAM FOR TREADING",
	"HEXAGRAM FOR PEACE",
	"HEXAGRAM FOR STANDSTILL",
	"HEXAGRAM FOR FELLOWSHIP",
	"HEXAGRAM FOR GREAT POSSESSION",
	"HEXAGRAM FOR MODESTY",
	"HEXAGRAM FOR ENTHUSIASM",
	"HEXAGRAM FOR FOLLOWING",
	"HEXAGRAM FOR WORK ON THE DECAYED",
	"HEXAGRAM FOR APPROACH",
	"HEXAGRAM FOR CONTEMPLATION",
	"HEXAGRAM FOR BITING THROUGH",
	"HEXAGRAM FOR GRACE",
	"HEXAGRAM FOR SPLITTING APART",
	"HEXAGRAM FOR RETURN",
	"HEXAGRAM FOR INNOCENCE",
	"HEXAGRAM FOR GREAT TAMING",
	"HEXAGRAM FOR MOUTH CORNERS",
	"HEXAGRAM FOR GREAT PREPONDERANCE",
	"HEXAGRAM FOR THE ABYSMAL WATER",
	"HEXAGRAM FOR THE CLINGING FIRE",
	"HEXAGRAM FOR INFLUENCE",
	"HEXAGRAM FOR DURATION",
	"HEXAGRAM FOR RETREAT",
	"HEXAGRAM FOR GREAT POWER",
	"HEXAGRAM FOR PROGRESS",
	"HEXAGRAM FOR DARKENING OF THE LIGHT",
	"HEXAGRAM FOR THE FAMILY",
	"HEXAGRAM FOR OPPOSITION",
	"HEXAGRAM FOR OBSTRUCTION",
	"HEXAGRAM FOR DELIVERANCE",
	"HEXAGRAM FOR DECREASE",
	"HEXAGRAM FOR INCREASE",
	"HEXAGRAM FOR BREAKTHROUGH",
	"HEXAGRAM FOR COMING TO MEET",
	"HEXAGRAM FOR GATHERING TOGETHER",
	"HEXAGRAM FOR PUSHING UPWARD",
	"HEXAGRAM FOR OPPRESSION",
	"HEXAGRAM FOR THE WELL",
	"HEXAGRAM FOR REVOLUTION",
	"HEXAGRAM FOR THE CAULDRON",
	"HEXAGRAM FOR THE AROUSING THUNDER",
	"HEXAGRAM FOR THE KEEPING STILL MOUNTAIN",
	"HEXAGRAM FOR DEVELOPMENT",
	"HEXAGRAM FOR THE MARRYING MAIDEN",
	"HEXAGRAM FOR ABUNDANCE",
	"HEXAGRAM FOR THE WANDERER",
	"HEXAGRAM FOR THE GENTLE WIND",
	"HEXAGRAM FOR THE JOYOUS LAKE",
	"HEXAGRAM FOR DISPERSION",
	"HEXAGRAM FOR LIMITATION",
	"HEXAGRAM FOR INNER TRUTH",
	"HEXAGRAM FOR SMALL PREPONDERANCE",
	"HEXAGRAM FOR AFTER COMPLETION",
	"HEXAGRAM FOR BEFORE COMPLETION",
	"<CJK Ideograph, First>",
	"<CJK Ideograph, Last>",
	"YI SYLLABLE IT",
	"YI SYLLABLE IX",
	"YI SYLLABLE I",
	"YI SYLLABLE IP",
	"YI SYLLABLE IET",
	"YI SYLLABLE IEX",
	"YI SYLLABLE IE",
	"YI SYLLABLE IEP",
	"YI SYLLABLE AT",
	"YI SYLLABLE AX",
	"YI SYLLABLE A",
	"YI SYLLABLE AP",
	"YI SYLLABLE UOX",
	"YI SYLLABLE UO",
	"YI SYLLABLE UOP",
	"YI SYLLABLE OT",
	"YI SYLLABLE OX",
	"YI SYLLABLE O",
	"YI SYLLABLE OP",
	"YI SYLLABLE EX",
	"YI SYLLABLE E",
	"YI SYLLABLE WU",
	"YI SYLLABLE BIT",
	"YI SYLLABLE BIX",
	"YI SYLLABLE BI",
	"YI SYLLABLE BIP",
	"YI SYLLABLE BIET",
	"YI SYLLABLE BIEX",
	"YI SYLLABLE BIE",
	"YI SYLLABLE BIEP",
	"YI SYLLABLE BAT",
	"YI SYLLABLE BAX",
	"YI SYLLABLE BA",
	"YI SYLLABLE BAP",
	"YI SYLLABLE BUOX",
	"YI SYLLABLE BUO",
	"YI SYLLABLE BUOP",
	"YI SYLLABLE BOT",
	"YI SYLLABLE BOX",
	"YI SYLLABLE BO",
	"YI SYLLABLE BOP",
	"YI SYLLABLE BEX",
	"YI SYLLABLE BE",
	"YI SYLLABLE BEP",
	"YI SYLLABLE BUT",
	"YI SYLLABLE BUX",
	"YI SYLLABLE BU",
	"YI SYLLABLE BUP",
	"YI SYLLABLE BURX",
	"YI SYLLABLE BUR",
	"YI SYLLABLE BYT",
	"YI SYLLABLE BYX",
	"YI SYLLABLE BY",
	"YI SYLLABLE BYP",
	"YI SYLLABLE BYRX",
	"YI SYLLABLE BYR",
	"YI SYLLABLE PIT",
	"YI SYLLABLE PIX",
	"YI SYLLABLE PI",
	"YI SYLLABLE PIP",
	"YI SYLLABLE PIEX",
	"YI SYLLABLE PIE",
	"YI SYLLABLE PIEP",
	"YI SYLLABLE PAT",
	"YI SYLLABLE PAX",
	"YI SYLLABLE PA",
	"YI SYLLABLE PAP",
	"YI SYLLABLE PUOX",
	"YI SYLLABLE PUO",
	"YI SYLLABLE PUOP",
	"YI SYLLABLE POT",
	"YI SYLLABLE POX",
	"YI SYLLABLE PO",
	"YI SYLLABLE POP",
	"YI SYLLABLE PUT",
	"YI SYLLABLE PUX",
	"YI SYLLABLE PU",
	"YI SYLLABLE PUP",
	"YI SYLLABLE PURX",
	"YI SYLLABLE PUR",
	"YI SYLLABLE PYT",
	"YI SYLLABLE PYX",
	"YI SYLLABLE PY",
	"YI SYLLABLE PYP",
	"YI SYLLABLE PYRX",
	"YI SYLLABLE PYR",
	"YI SYLLABLE BBIT",
	"YI SYLLABLE BBIX",
	"YI SYLLABLE BBI",
	"YI SYLLABLE BBIP",
	"YI SYLLABLE BBIET",
	"YI SYLLABLE BBIEX",
	"YI SYLLABLE BBIE",
	"YI SYLLABLE BBIEP",
	"YI SYLLABLE BBAT",
	"YI SYLLABLE BBAX",
	"YI SYLLABLE BBA",
	"YI SYLLABLE BBAP",
	"YI SYLLABLE BBUOX",
	"YI SYLLABLE BBUO",
	"YI SYLLABLE BBUOP",
	"YI SYLLABLE BBOT",
	"YI SYLLABLE BBOX",
	"YI SYLLABLE BBO",
	"YI SYLLABLE BBOP",
	"YI SYLLABLE BBEX",
	"YI SYLLABLE BBE",
	"YI SYLLABLE BBEP",
	"YI SYLLABLE BBUT",
	"YI SYLLABLE BBUX",
	"YI SYLLABLE BBU",
	"YI SYLLABLE BBUP",
	"YI SYLLABLE BBURX",
	"YI SYLLABLE BBUR",
	"YI SYLLABLE BBYT",
	"YI SYLLABLE BBYX",
	"YI SYLLABLE BBY",
	"YI SYLLABLE BBYP",
	"YI SYLLABLE NBIT",
	"YI SYLLABLE NBIX",
	"YI SYLLABLE NBI",
	"YI SYLLABLE NBIP",
	"YI SYLLABLE NBIEX",
	"YI SYLLABLE NBIE",
	"YI SYLLABLE NBIEP",
	"YI SYLLABLE NBAT",
	"YI SYLLABLE NBAX",
	"YI SYLLABLE NBA",
	"YI SYLLABLE NBAP",
	"YI SYLLABLE NBOT",
	"YI SYLLABLE NBOX",
	"YI SYLLABLE NBO",
	"YI SYLLABLE NBOP",
	"YI SYLLABLE NBUT",
	"YI SYLLABLE NBUX",
	"YI SYLLABLE NBU",
	"YI SYLLABLE NBUP",
	"YI SYLLABLE NBURX",
	"YI SYLLABLE NBUR",
	"YI SYLLABLE NBYT",
	"YI SYLLABLE NBYX",
	"YI SYLLABLE NBY",
	"YI SYLLABLE NBYP",
	"YI SYLLABLE NBYRX",
	"YI SYLLABLE NBYR",
	"YI SYLLABLE HMIT",
	"YI SYLLABLE HMIX",
	"YI SYLLABLE HMI",
	"YI SYLLABLE HMIP",
	"YI SYLLABLE HMIEX",
	"YI SYLLABLE HMIE",
	"YI SYLLABLE HMIEP",
	"YI SYLLABLE HMAT",
	"YI SYLLABLE HMAX",
	"YI SYLLABLE HMA",
	"YI SYLLABLE HMAP",
	"YI SYLLABLE HMUOX",
	"YI SYLLABLE HMUO",
	"YI SYLLABLE HMUOP",
	"YI SYLLABLE HMOT",
	"YI SYLLABLE HMOX",
	"YI SYLLABLE HMO",
	"YI SYLLABLE HMOP",
	"YI SYLLABLE HMUT",
	"YI SYLLABLE HMUX",
	"YI SYLLABLE HMU",
	"YI SYLLABLE HMUP",
	"YI SYLLABLE HMURX",
	"YI SYLLABLE HMUR",
	"YI SYLLABLE HMYX",
	"YI SYLLABLE HMY",
	"YI SYLLABLE HMYP",
	"YI SYLLABLE HMYRX",
	"YI SYLLABLE HMYR",
	"YI SYLLABLE MIT",
	"YI SYLLABLE MIX",
	"YI SYLLABLE MI",
	"YI SYLLABLE MIP",
	"YI SYLLABLE MIEX",
	"YI SYLLABLE MIE",
	"YI SYLLABLE MIEP",
	"YI SYLLABLE MAT",
	"YI SYLLABLE MAX",
	"YI SYLLABLE MA",
	"YI SYLLABLE MAP",
	"YI SYLLABLE MUOT",
	"YI SYLLABLE MUOX",
	"YI SYLLABLE MUO",
	"YI SYLLABLE MUOP",
	"YI SYLLABLE MOT",
	"YI SYLLABLE MOX",
	"YI SYLLABLE MO",
	"YI SYLLABLE MOP",
	"YI SYLLABLE MEX",
	"YI SYLLABLE ME",
	"YI SYLLABLE MUT",
	"YI SYLLABLE MUX",
	"YI SYLLABLE MU",
	"YI SYLLABLE MUP",
	"YI SYLLABLE MURX",
	"YI SYLLABLE MUR",
	"YI SYLLABLE MYT",
	"YI SYLLABLE MYX",
	"YI SYLLABLE MY",
	"YI SYLLABLE MYP",
	"YI SYLLABLE FIT",
	"YI SYLLABLE FIX",
	"YI SYLLABLE FI",
	"YI SYLLABLE FIP",
	"YI SYLLABLE FAT",
	"YI SYLLABLE FAX",
	"YI SYLLABLE FA",
	"YI SYLLABLE FAP",
	"YI SYLLABLE FOX",
	"YI SYLLABLE FO",
	"YI SYLLABLE FOP",
	"YI SYLLABLE FUT",
	"YI SYLLABLE FUX",
	"YI SYLLABLE FU",
	"YI SYLLABLE FUP",
	"YI SYLLABLE FURX",
	"YI SYLLABLE FUR",
	"YI SYLLABLE FYT",
	"YI SYLLABLE FYX",
	"YI SYLLABLE FY",
	"YI SYLLABLE FYP",
	"YI SYLLABLE VIT",
	"YI SYLLABLE VIX",
	"YI SYLLABLE VI",
	"YI SYLLABLE VIP",
	"YI SYLLABLE VIET",
	"YI SYLLABLE VIEX",
	"YI SYLLABLE VIE",
	"YI SYLLABLE VIEP",
	"YI SYLLABLE VAT",
	"YI SYLLABLE VAX",
	"YI SYLLABLE VA",
	"YI SYLLABLE VAP",
	"YI SYLLABLE VOT",
	"YI SYLLABLE VOX",
	"YI SYLLABLE VO",
	"YI SYLLABLE VOP",
	"YI SYLLABLE VEX",
	"YI SYLLABLE VEP",
	"YI SYLLABLE VUT",
	"YI SYLLABLE VUX",
	"YI SYLLABLE VU",
	"YI SYLLABLE VUP",
	"YI SYLLABLE VURX",
	"YI SYLLABLE VUR",
	"YI SYLLABLE VYT",
	"YI SYLLABLE VYX",
	"YI SYLLABLE VY",
	"YI SYLLABLE VYP",
	"YI SYLLABLE VYRX",
	"YI SYLLABLE VYR",
	"YI SYLLABLE DIT",
	"YI SYLLABLE DIX",
	"YI SYLLABLE DI",
	"YI SYLLABLE DIP",
	"YI SYLLABLE DIEX",
	"YI SYLLABLE DIE",
	"YI SYLLABLE DIEP",
	"YI SYLLABLE DAT",
	"YI SYLLABLE DAX",
	"YI SYLLABLE DA",
	"YI SYLLABLE DAP",
	"YI SYLLABLE DUOX",
	"YI SYLLABLE DUO",
	"YI SYLLABLE DOT",
	"YI SYLLABLE DOX",
	"YI SYLLABLE DO",
	"YI SYLLABLE DOP",
	"YI SYLLABLE DEX",
	"YI SYLLABLE DE",
	"YI SYLLABLE DEP",
	"YI SYLLABLE DUT",
	"YI SYLLABLE DUX",
	"YI SYLLABLE DU",
	"YI SYLLABLE DUP",
	"YI SYLLABLE DURX",
	"YI SYLLABLE DUR",
	"YI SYLLABLE TIT",
	"YI SYLLABLE TIX",
	"YI SYLLABLE TI",
	"YI SYLLABLE TIP",
	"YI SYLLABLE TIEX",
	"YI SYLLABLE TIE",
	"YI SYLLABLE TIEP",
	"YI SYLLABLE TAT",
	"YI SYLLABLE TAX",
	"YI SYLLABLE TA",
	"YI SYLLABLE TAP",
	"YI SYLLABLE TUOT",
	"YI SYLLABLE TUOX",
	"YI SYLLABLE TUO",
	"YI SYLLABLE TUOP",
	"YI SYLLABLE TOT",
	"YI SYLLABLE TOX",
	"YI SYLLABLE TO",
	"YI SYLLABLE TOP",
	"YI SYLLABLE TEX",
	"YI SYLLABLE TE",
	"YI SYLLABLE TEP",
	"YI SYLLABLE TUT",
	"YI SYLLABLE TUX",
	"YI SYLLABLE TU",
	"YI SYLLABLE TUP",
	"YI SYLLABLE TURX",
	"YI SYLLABLE TUR",
	"YI SYLLABLE DDIT",
	"YI SYLLABLE DDIX",
	"YI SYLLABLE DDI",
	"YI SYLLABLE DDIP",
	"YI SYLLABLE DDIEX",
	"YI SYLLABLE DDIE",
	"YI SYLLABLE DDIEP",
	"YI SYLLABLE DDAT",
	"YI SYLLABLE DDAX",
	"YI SYLLABLE DDA",
	"YI SYLLABLE DDAP",
	"YI SYLLABLE DDUOX",
	"YI SYLLABLE DDUO",
	"YI SYLLABLE DDUOP",
	"YI SYLLABLE DDOT",
	"YI SYLLABLE DDOX",
	"YI SYLLABLE DDO",
	"YI SYLLABLE DDOP",
	"YI SYLLABLE DDEX",
	"YI SYLLABLE DDE",
	"YI SYLLABLE DDEP",
	"YI SYLLABLE DDUT",
	"YI SYLLABLE DDUX",
	"YI SYLLABLE DDU",
	"YI SYLLABLE DDUP",
	"YI SYLLABLE DDURX",
	"YI SYLLABLE DDUR",
	"YI SYLLABLE NDIT",
	"YI SYLLABLE NDIX",
	"YI SYLLABLE NDI",
	"YI SYLLABLE NDIP",
	"YI SYLLABLE NDIEX",
	"YI SYLLABLE NDIE",
	"YI SYLLABLE NDAT",
	"YI SYLLABLE NDAX",
	"YI SYLLABLE NDA",
	"YI SYLLABLE NDAP",
	"YI SYLLABLE NDOT",
	"YI SYLLABLE NDOX",
	"YI SYLLABLE NDO",
	"YI SYLLABLE NDOP",
	"YI SYLLABLE NDEX",
	"YI SYLLABLE NDE",
	"YI SYLLABLE NDEP",
	"YI SYLLABLE NDUT",
	"YI SYLLABLE NDUX",
	"YI SYLLABLE NDU",
	"YI SYLLABLE NDUP",
	"YI SYLLABLE NDURX",
	"YI SYLLABLE NDUR",
	"YI SYLLABLE HNIT",
	"YI SYLLABLE HNIX",
	"YI SYLLABLE HNI",
	"YI SYLLABLE HNIP",
	"YI SYLLABLE HNIET",
	"YI SYLLABLE HNIEX",
	"YI SYLLABLE HNIE",
	"YI SYLLABLE HNIEP",
	"YI SYLLABLE HNAT",
	"YI SYLLABLE HNAX",
	"YI SYLLABLE HNA",
	"YI SYLLABLE HNAP",
	"YI SYLLABLE HNUOX",
	"YI SYLLABLE HNUO",
	"YI SYLLABLE HNOT",
	"YI SYLLABLE HNOX",
	"YI SYLLABLE HNOP",
	"YI SYLLABLE HNEX",
	"YI SYLLABLE HNE",
	"YI SYLLABLE HNEP",
	"YI SYLLABLE HNUT",
	"YI SYLLABLE NIT",
	"YI SYLLABLE NIX",
	"YI SYLLABLE NI",
	"YI SYLLABLE NIP",
	"YI SYLLABLE NIEX",
	"YI SYLLABLE NIE",
	"YI SYLLABLE NIEP",
	"YI SYLLABLE NAX",
	"YI SYLLABLE NA",
	"YI SYLLABLE NAP",
	"YI SYLLABLE NUOX",
	"YI SYLLABLE NUO",
	"YI SYLLABLE NUOP",
	"YI SYLLABLE NOT",
	"YI SYLLABLE NOX",
	"YI SYLLABLE NO",
	"YI SYLLABLE NOP",
	"YI SYLLABLE NEX",
	"YI SYLLABLE NE",
	"YI SYLLABLE NEP",
	"YI SYLLABLE NUT",
	"YI SYLLABLE NUX",
	"YI SYLLABLE NU",
	"YI SYLLABLE NUP",
	"YI SYLLABLE NURX",
	"YI SYLLABLE NUR",
	"YI SYLLABLE HLIT",
	"YI SYLLABLE HLIX",
	"YI SYLLABLE HLI",
	"YI SYLLABLE HLIP",
	"YI SYLLABLE HLIEX",
	"YI SYLLABLE HLIE",
	"YI SYLLABLE HLIEP",
	"YI SYLLABLE HLAT",
	"YI SYLLABLE HLAX",
	"YI SYLLABLE HLA",
	"YI SYLLABLE HLAP",
	"YI SYLLABLE HLUOX",
	"YI SYLLABLE HLUO",
	"YI SYLLABLE HLUOP",
	"YI SYLLABLE HLOX",
	"YI SYLLABLE HLO",
	"YI SYLLABLE HLOP",
	"YI SYLLABLE HLEX",
	"YI SYLLABLE HLE",
	"YI SYLLABLE HLEP",
	"YI SYLLABLE HLUT",
	"YI SYLLABLE HLUX",
	"YI SYLLABLE HLU",
	"YI SYLLABLE HLUP",
	"YI SYLLABLE HLURX",
	"YI SYLLABLE HLUR",
	"YI SYLLABLE HLYT",
	"YI SYLLABLE HLYX",
	"YI SYLLABLE HLY",
	"YI SYLLABLE HLYP",
	"YI SYLLABLE HLYRX",
	"YI SYLLABLE HLYR",
	"YI SYLLABLE LIT",
	"YI SYLLABLE LIX",
	"YI SYLLABLE LI",
	"YI SYLLABLE LIP",
	"YI SYLLABLE LIET",
	"YI SYLLABLE LIEX",
	"YI SYLLABLE LIE",
	"YI SYLLABLE LIEP",
	"YI SYLLABLE LAT",
	"YI SYLLABLE LAX",
	"YI SYLLABLE LA",
	"YI SYLLABLE LAP",
	"YI SYLLABLE LUOT",
	"YI SYLLABLE LUOX",
	"YI SYLLABLE LUO",
	"YI SYLLABLE LUOP",
	"YI SYLLABLE LOT",
	"YI SYLLABLE LOX",
	"YI SYLLABLE LO",
	"YI SYLLABLE LOP",
	"YI SYLLABLE LEX",
	"YI SYLLABLE LE",
	"YI SYLLABLE LEP",
	"YI SYLLABLE LUT",
	"YI SYLLABLE LUX",
	"YI SYLLABLE LU",
	"YI SYLLABLE LUP",
	"YI SYLLABLE LURX",
	"YI SYLLABLE LUR",
	"YI SYLLABLE LYT",
	"YI SYLLABLE LYX",
	"YI SYLLABLE LY",
	"YI SYLLABLE LYP",
	"YI SYLLABLE LYRX",
	"YI SYLLABLE LYR",
	"YI SYLLABLE GIT",
	"YI SYLLABLE GIX",
	"YI SYLLABLE GI",
	"YI SYLLABLE GIP",
	"YI SYLLABLE GIET",
	"YI SYLLABLE GIEX",
	"YI SYLLABLE GIE",
	"YI SYLLABLE GIEP",
	"YI SYLLABLE GAT",
	"YI SYLLABLE GAX",
	"YI SYLLABLE GA",
	"YI SYLLABLE GAP",
	"YI SYLLABLE GUOT",
	"YI SYLLABLE GUOX",
	"YI SYLLABLE GUO",
	"YI SYLLABLE GUOP",
	"YI SYLLABLE GOT",
	"YI SYLLABLE GOX",
	"YI SYLLABLE GO",
	"YI SYLLABLE GOP",
	"YI SYLLABLE GET",
	"YI SYLLABLE GEX",
	"YI SYLLABLE GE",
	"YI SYLLABLE GEP",
	"YI SYLLABLE GUT",
	"YI SYLLABLE GUX",
	"YI SYLLABLE GU",
	"YI SYLLABLE GUP",
	"YI SYLLABLE GURX",
	"YI SYLLABLE GUR",
	"YI SYLLABLE KIT",
	"YI SYLLABLE KIX",
	"YI SYLLABLE KI",
	"YI SYLLABLE KIP",
	"YI SYLLABLE KIEX",
	"YI SYLLABLE KIE",
	"YI SYLLABLE KIEP",
	"YI SYLLABLE KAT",
	"YI SYLLABLE KAX",
	"YI SYLLABLE KA",
	"YI SYLLABLE KAP",
	"YI SYLLABLE KUOX",
	"YI SYLLABLE KUO",
	"YI SYLLABLE KUOP",
	"YI SYLLABLE KOT",
	"YI SYLLABLE KOX",
	"YI SYLLABLE KO",
	"YI SYLLABLE KOP",
	"YI SYLLABLE KET",
	"YI SYLLABLE KEX",
	"YI SYLLABLE KE",
	"YI SYLLABLE KEP",
	"YI SYLLABLE KUT",
	"YI SYLLABLE KUX",
	"YI SYLLABLE KU",
	"YI SYLLABLE KUP",
	"YI SYLLABLE KURX",
	"YI SYLLABLE KUR",
	"YI SYLLABLE GGIT",
	"YI SYLLABLE GGIX",
	"YI SYLLABLE GGI",
	"YI SYLLABLE GGIEX",
	"YI SYLLABLE GGIE",
	"YI SYLLABLE GGIEP",
	"YI SYLLABLE GGAT",
	"YI SYLLABLE GGAX",
	"YI SYLLABLE GGA",
	"YI SYLLABLE GGAP",
	"YI SYLLABLE GGUOT",
	"YI SYLLABLE GGUOX",
	"YI SYLLABLE GGUO",
	"YI SYLLABLE GGUOP",
	"YI SYLLABLE GGOT",
	"YI SYLLABLE GGOX",
	"YI SYLLABLE GGO",
	"YI SYLLABLE GGOP",
	"YI SYLLABLE GGET",
	"YI SYLLABLE GGEX",
	"YI SYLLABLE GGE",
	"YI SYLLABLE GGEP",
	"YI SYLLABLE GGUT",
	"YI SYLLABLE GGUX",
	"YI SYLLABLE GGU",
	"YI SYLLABLE GGUP",
	"YI SYLLABLE GGURX",
	"YI SYLLABLE GGUR",
	"YI SYLLABLE MGIEX",
	"YI SYLLABLE MGIE",
	"YI SYLLABLE MGAT",
	"YI SYLLABLE MGAX",
	"YI SYLLABLE MGA",
	"YI SYLLABLE MGAP",
	"YI SYLLABLE MGUOX",
	"YI SYLLABLE MGUO",
	"YI SYLLABLE MGUOP",
	"YI SYLLABLE MGOT",
	"YI SYLLABLE MGOX",
	"YI SYLLABLE MGO",
	"YI SYLLABLE MGOP",
	"YI SYLLABLE MGEX",
	"YI SYLLABLE MGE",
	"YI SYLLABLE MGEP",
	"YI SYLLABLE MGUT",
	"YI SYLLABLE MGUX",
	"YI SYLLABLE MGU",
	"YI SYLLABLE MGUP",
	"YI SYLLABLE MGURX",
	"YI SYLLABLE MGUR",
	"YI SYLLABLE HXIT",
	"YI SYLLABLE HXIX",
	"YI SYLLABLE HXI",
	"YI SYLLABLE HXIP",
	"YI SYLLABLE HXIET",
	"YI SYLLABLE HXIEX",
	"YI SYLLABLE HXIE",
	"YI SYLLABLE HXIEP",
	"YI SYLLABLE HXAT",
	"YI SYLLABLE HXAX",
	"YI SYLLABLE HXA",
	"YI SYLLABLE HXAP",
	"YI SYLLABLE HXUOT",
	"YI SYLLABLE HXUOX",
	"YI SYLLABLE HXUO",
	"YI SYLLABLE HXUOP",
	"YI SYLLABLE HXOT",
	"YI SYLLABLE HXOX",
	"YI SYLLABLE HXO",
	"YI SYLLABLE HXOP",
	"YI SYLLABLE HXEX",
	"YI SYLLABLE HXE",
	"YI SYLLABLE HXEP",
	"YI SYLLABLE NGIEX",
	"YI SYLLABLE NGIE",
	"YI SYLLABLE NGIEP",
	"YI SYLLABLE NGAT",
	"YI SYLLABLE NGAX",
	"YI SYLLABLE NGA",
	"YI SYLLABLE NGAP",
	"YI SYLLABLE NGUOT",
	"YI SYLLABLE NGUOX",
	"YI SYLLABLE NGUO",
	"YI SYLLABLE NGOT",
	"YI SYLLABLE NGOX",
	"YI SYLLABLE NGO",
	"YI SYLLABLE NGOP",
	"YI SYLLABLE NGEX",
	"YI SYLLABLE NGE",
	"YI SYLLABLE NGEP",
	"YI SYLLABLE HIT",
	"YI SYLLABLE HIEX",
	"YI SYLLABLE HIE",
	"YI SYLLABLE HAT",
	"YI SYLLABLE HAX",
	"YI SYLLABLE HA",
	"YI SYLLABLE HAP",
	"YI SYLLABLE HUOT",
	"YI SYLLABLE HUOX",
	"YI SYLLABLE HUO",
	"YI SYLLABLE HUOP",
	"YI SYLLABLE HOT",
	"YI SYLLABLE HOX",
	"YI SYLLABLE HO",
	"YI SYLLABLE HOP",
	"YI SYLLABLE HEX",
	"YI SYLLABLE HE",
	"YI SYLLABLE HEP",
	"YI SYLLABLE WAT",
	"YI SYLLABLE WAX",
	"YI SYLLABLE WA",
	"YI SYLLABLE WAP",
	"YI SYLLABLE WUOX",
	"YI SYLLABLE WUO",
	"YI SYLLABLE WUOP",
	"YI SYLLABLE WOX",
	"YI SYLLABLE WO",
	"YI SYLLABLE WOP",
	"YI SYLLABLE WEX",
	"YI SYLLABLE WE",
	"YI SYLLABLE WEP",
	"YI SYLLABLE ZIT",
	"YI SYLLABLE ZIX",
	"YI SYLLABLE ZI",
	"YI SYLLABLE ZIP",
	"YI SYLLABLE ZIEX",
	"YI SYLLABLE ZIE",
	"YI SYLLABLE ZIEP",
	"YI SYLLABLE ZAT",
	"YI SYLLABLE ZAX",
	"YI SYLLABLE ZA",
	"YI SYLLABLE ZAP",
	"YI SYLLABLE ZUOX",
	"YI SYLLABLE ZUO",
	"YI SYLLABLE ZUOP",
	"YI SYLLABLE ZOT",
	"YI SYLLABLE ZOX",
	"YI SYLLABLE ZO",
	"YI SYLLABLE ZOP",
	"YI SYLLABLE ZEX",
	"YI SYLLABLE ZE",
	"YI SYLLABLE ZEP",
	"YI SYLLABLE ZUT",
	"YI SYLLABLE ZUX",
	"YI SYLLABLE ZU",
	"YI SYLLABLE ZUP",
	"YI SYLLABLE ZURX",
	"YI SYLLABLE ZUR",
	"YI SYLLABLE ZYT",
	"YI SYLLABLE ZYX",
	"YI SYLLABLE ZY",
	"YI SYLLABLE ZYP",
	"YI SYLLABLE ZYRX",
	"YI SYLLABLE ZYR",
	"YI SYLLABLE CIT",
	"YI SYLLABLE CIX",
	"YI SYLLABLE CI",
	"YI SYLLABLE CIP",
	"YI SYLLABLE CIET",
	"YI SYLLABLE CIEX",
	"YI SYLLABLE CIE",
	"YI SYLLABLE CIEP",
	"YI SYLLABLE CAT",
	"YI SYLLABLE CAX",
	"YI SYLLABLE CA",
	"YI SYLLABLE CAP",
	"YI SYLLABLE CUOX",
	"YI SYLLABLE CUO",
	"YI SYLLABLE CUOP",
	"YI SYLLABLE COT",
	"YI SYLLABLE COX",
	"YI SYLLABLE CO",
	"YI SYLLABLE COP",
	"YI SYLLABLE CEX",
	"YI SYLLABLE CE",
	"YI SYLLABLE CEP",
	"YI SYLLABLE CUT",
	"YI SYLLABLE CUX",
	"YI SYLLABLE CU",
	"YI SYLLABLE CUP",
	"YI SYLLABLE CURX",
	"YI SYLLABLE CUR",
	"YI SYLLABLE CYT",
	"YI SYLLABLE CYX",
	"YI SYLLABLE CY",
	"YI SYLLABLE CYP",
	"YI SYLLABLE CYRX",
	"YI SYLLABLE CYR",
	"YI SYLLABLE ZZIT",
	"YI SYLLABLE ZZIX",
	"YI SYLLABLE ZZI",
	"YI SYLLABLE ZZIP",
	"YI SYLLABLE ZZIET",
	"YI SYLLABLE ZZIEX",
	"YI SYLLABLE ZZIE",
	"YI SYLLABLE ZZIEP",
	"YI SYLLABLE ZZAT",
	"YI SYLLABLE ZZAX",
	"YI SYLLABLE ZZA",
	"YI SYLLABLE ZZAP",
	"YI SYLLABLE ZZOX",
	"YI SYLLABLE ZZO",
	"YI SYLLABLE ZZOP",
	"YI SYLLABLE ZZEX",
	"YI SYLLABLE ZZE",
	"YI SYLLABLE ZZEP",
	"YI SYLLABLE ZZUX",
	"YI SYLLABLE ZZU",
	"YI SYLLABLE ZZUP",
	"YI SYLLABLE ZZURX",
	"YI SYLLABLE ZZUR",
	"YI SYLLABLE ZZYT",
	"YI SYLLABLE ZZYX",
	"YI SYLLABLE ZZY",
	"YI SYLLABLE ZZYP",
	"YI SYLLABLE ZZYRX",
	"YI SYLLABLE ZZYR",
	"YI SYLLABLE NZIT",
	"YI SYLLABLE NZIX",
	"YI SYLLABLE NZI",
	"YI SYLLABLE NZIP",
	"YI SYLLABLE NZIEX",
	"YI SYLLABLE NZIE",
	"YI SYLLABLE NZIEP",
	"YI SYLLABLE NZAT",
	"YI SYLLABLE NZAX",
	"YI SYLLABLE NZA",
	"YI SYLLABLE NZAP",
	"YI SYLLABLE NZUOX",
	"YI SYLLABLE NZUO",
	"YI SYLLABLE NZOX",
	"YI SYLLABLE NZOP",
	"YI SYLLABLE NZEX",
	"YI SYLLABLE NZE",
	"YI SYLLABLE NZUX",
	"YI SYLLABLE NZU",
	"YI SYLLABLE NZUP",
	"YI SYLLABLE NZURX",
	"YI SYLLABLE NZUR",
	"YI SYLLABLE NZYT",
	"YI SYLLABLE NZYX",
	"YI SYLLABLE NZY",
	"YI SYLLABLE NZYP",
	"YI SYLLABLE NZYRX",
	"YI SYLLABLE NZYR",
	"YI SYLLABLE SIT",
	"YI SYLLABLE SIX",
	"YI SYLLABLE SI",
	"YI SYLLABLE SIP",
	"YI SYLLABLE SIEX",
	"YI SYLLABLE SIE",
	"YI SYLLABLE SIEP",
	"YI SYLLABLE SAT",
	"YI SYLLABLE SAX",
	"YI SYLLABLE SA",
	"YI SYLLABLE SAP",
	"YI SYLLABLE SUOX",
	"YI SYLLABLE SUO",
	"YI SYLLABLE SUOP",
	"YI SYLLABLE SOT",
	"YI SYLLABLE SOX",
	"YI SYLLABLE SO",
	"YI SYLLABLE SOP",
	"YI SYLLABLE SEX",
	"YI SYLLABLE SE",
	"YI SYLLABLE SEP",
	"YI SYLLABLE SUT",
	"YI SYLLABLE SUX",
	"YI SYLLABLE SU",
	"YI SYLLABLE SUP",
	"YI SYLLABLE SURX",
	"YI SYLLABLE SUR",
	"YI SYLLABLE SYT",
	"YI SYLLABLE SYX",
	"YI SYLLABLE SY",
	"YI SYLLABLE SYP",
	"YI SYLLABLE SYRX",
	"YI SYLLABLE SYR",
	"YI SYLLABLE SSIT",
	"YI SYLLABLE SSIX",
	"YI SYLLABLE SSI",
	"YI SYLLABLE SSIP",
	"YI SYLLABLE SSIEX",
	"YI SYLLABLE SSIE",
	"YI SYLLABLE SSIEP",
	"YI SYLLABLE SSAT",
	"YI SYLLABLE SSAX",
	"YI SYLLABLE SSA",
	"YI SYLLABLE SSAP",
	"YI SYLLABLE SSOT",
	"YI SYLLABLE SSOX",
	"YI SYLLABLE SSO",
	"YI SYLLABLE SSOP",
	"YI SYLLABLE SSEX",
	"YI SYLLABLE SSE",
	"YI SYLLABLE SSEP",
	"YI SYLLABLE SSUT",
	"YI SYLLABLE SSUX",
	"YI SYLLABLE SSU",
	"YI SYLLABLE SSUP",
	"YI SYLLABLE SSYT",
	"YI SYLLABLE SSYX",
	"YI SYLLABLE SSY",
	"YI SYLLABLE SSYP",
	"YI SYLLABLE SSYRX",
	"YI SYLLABLE SSYR",
	"YI SYLLABLE ZHAT",
	"YI SYLLABLE ZHAX",
	"YI SYLLABLE ZHA",
	"YI SYLLABLE ZHAP",
	"YI SYLLABLE ZHUOX",
	"YI SYLLABLE ZHUO",
	"YI SYLLABLE ZHUOP",
	"YI SYLLABLE ZHOT",
	"YI SYLLABLE ZHOX",
	"YI SYLLABLE ZHO",
	"YI SYLLABLE ZHOP",
	"YI SYLLABLE ZHET",
	"YI SYLLABLE ZHEX",
	"YI SYLLABLE ZHE",
	"YI SYLLABLE ZHEP",
	"YI SYLLABLE ZHUT",
	"YI SYLLABLE ZHUX",
	"YI SYLLABLE ZHU",
	"YI SYLLABLE ZHUP",
	"YI SYLLABLE ZHURX",
	"YI SYLLABLE ZHUR",
	"YI SYLLABLE ZHYT",
	"YI SYLLABLE ZHYX",
	"YI SYLLABLE ZHY",
	"YI SYLLABLE ZHYP",
	"YI SYLLABLE ZHYRX",
	"YI SYLLABLE ZHYR",
	"YI SYLLABLE CHAT",
	"YI SYLLABLE CHAX",
	"YI SYLLABLE CHA",
	"YI SYLLABLE CHAP",
	"YI SYLLABLE CHUOT",
	"YI SYLLABLE CHUOX",
	"YI SYLLABLE CHUO",
	"YI SYLLABLE CHUOP",
	"YI SYLLABLE CHOT",
	"YI SYLLABLE CHOX",
	"YI SYLLABLE CHO",
	"YI SYLLABLE CHOP",
	"YI SYLLABLE CHET",
	"YI SYLLABLE CHEX",
	"YI SYLLABLE CHE",
	"YI SYLLABLE CHEP",
	"YI SYLLABLE CHUX",
	"YI SYLLABLE CHU",
	"YI SYLLABLE CHUP",
	"YI SYLLABLE CHURX",
	"YI SYLLABLE CHUR",
	"YI SYLLABLE CHYT",
	"YI SYLLABLE CHYX",
	"YI SYLLABLE CHY",
	"YI SYLLABLE CHYP",
	"YI SYLLABLE CHYRX",
	"YI SYLLABLE CHYR",
	"YI SYLLABLE RRAX",
	"YI SYLLABLE RRA",
	"YI SYLLABLE RRUOX",
	"YI SYLLABLE RRUO",
	"YI SYLLABLE RROT",
	"YI SYLLABLE RROX",
	"YI SYLLABLE RRO",
	"YI SYLLABLE RROP",
	"YI SYLLABLE RRET",
	"YI SYLLABLE RREX",
	"YI SYLLABLE RRE",
	"YI SYLLABLE RREP",
	"YI SYLLABLE RRUT",
	"YI SYLLABLE RRUX",
	"YI SYLLABLE RRU",
	"YI SYLLABLE RRUP",
	"YI SYLLABLE RRURX",
	"YI SYLLABLE RRUR",
	"YI SYLLABLE RRYT",
	"YI SYLLABLE RRYX",
	"YI SYLLABLE RRY",
	"YI SYLLABLE RRYP",
	"YI SYLLABLE RRYRX",
	"YI SYLLABLE RRYR",
	"YI SYLLABLE NRAT",
	"YI SYLLABLE NRAX",
	"YI SYLLABLE NRA",
	"YI SYLLABLE NRAP",
	"YI SYLLABLE NROX",
	"YI SYLLABLE NRO",
	"YI SYLLABLE NROP",
	"YI SYLLABLE NRET",
	"YI SYLLABLE NREX",
	"YI SYLLABLE NRE",
	"YI SYLLABLE NREP",
	"YI SYLLABLE NRUT",
	"YI SYLLABLE NRUX",
	"YI SYLLABLE NRU",
	"YI SYLLABLE NRUP",
	"YI SYLLABLE NRURX",
	"YI SYLLABLE NRUR",
	"YI SYLLABLE NRYT",
	"YI SYLLABLE NRYX",
	"YI SYLLABLE NRY",
	"YI SYLLABLE NRYP",
	"YI SYLLABLE NRYRX",
	"YI SYLLABLE NRYR",
	"YI SYLLABLE SHAT",
	"YI SYLLABLE SHAX",
	"YI SYLLABLE SHA",
	"YI SYLLABLE SHAP",
	"YI SYLLABLE SHUOX",
	"YI SYLLABLE SHUO",
	"YI SYLLABLE SHUOP",
	"YI SYLLABLE SHOT",
	"YI SYLLABLE SHOX",
	"YI SYLLABLE SHO",
	"YI SYLLABLE SHOP",
	"YI SYLLABLE SHET",
	"YI SYLLABLE SHEX",
	"YI SYLLABLE SHE",
	"YI SYLLABLE SHEP",
	"YI SYLLABLE SHUT",
	"YI SYLLABLE SHUX",
	"YI SYLLABLE SHU",
	"YI SYLLABLE SHUP",
	"YI SYLLABLE SHURX",
	"YI SYLLABLE SHUR",
	"YI SYLLABLE SHYT",
	"YI SYLLABLE SHYX",
	"YI SYLLABLE SHY",
	"YI SYLLABLE SHYP",
	"YI SYLLABLE SHYRX",
	"YI SYLLABLE SHYR",
	"YI SYLLABLE RAT",
	"YI SYLLABLE RAX",
	"YI SYLLABLE RA",
	"YI SYLLABLE RAP",
	"YI SYLLABLE RUOX",
	"YI SYLLABLE RUO",
	"YI SYLLABLE RUOP",
	"YI SYLLABLE ROT",
	"YI SYLLABLE ROX",
	"YI SYLLABLE RO",
	"YI SYLLABLE ROP",
	"YI SYLLABLE REX",
	"YI SYLLABLE RE",
	"YI SYLLABLE REP",
	"YI SYLLABLE RUT",
	"YI SYLLABLE RUX",
	"YI SYLLABLE RU",
	"YI SYLLABLE RUP",
	"YI SYLLABLE RURX",
	"YI SYLLABLE RUR",
	"YI SYLLABLE RYT",
	"YI SYLLABLE RYX",
	"YI SYLLABLE RY",
	"YI SYLLABLE RYP",
	"YI SYLLABLE RYRX",
	"YI SYLLABLE RYR",
	"YI SYLLABLE JIT",
	"YI SYLLABLE JIX",
	"YI SYLLABLE JI",
	"YI SYLLABLE JIP",
	"YI SYLLABLE JIET",
	"YI SYLLABLE JIEX",
	"YI SYLLABLE JIE",
	"YI SYLLABLE JIEP",
	"YI SYLLABLE JUOT",
	"YI SYLLABLE JUOX",
	"YI SYLLABLE JUO",
	"YI SYLLABLE JUOP",
	"YI SYLLABLE JOT",
	"YI SYLLABLE JOX",
	"YI SYLLABLE JO",
	"YI SYLLABLE JOP",
	"YI SYLLABLE JUT",
	"YI SYLLABLE JUX",
	"YI SYLLABLE JU",
	"YI SYLLABLE JUP",
	"YI SYLLABLE JURX",
	"YI SYLLABLE JUR",
	"YI SYLLABLE JYT",
	"YI SYLLABLE JYX",
	"YI SYLLABLE JY",
	"YI SYLLABLE JYP",
	"YI SYLLABLE JYRX",
	"YI SYLLABLE JYR",
	"YI SYLLABLE QIT",
	"YI SYLLABLE QIX",
	"YI SYLLABLE QI",
	"YI SYLLABLE QIP",
	"YI SYLLABLE QIET",
	"YI SYLLABLE QIEX",
	"YI SYLLABLE QIE",
	"YI SYLLABLE QIEP",
	"YI SYLLABLE QUOT",
	"YI SYLLABLE QUOX",
	"YI SYLLABLE QUO",
	"YI SYLLABLE QUOP",
	"YI SYLLABLE QOT",
	"YI SYLLABLE QOX",
	"YI SYLLABLE QO",
	"YI SYLLABLE QOP",
	"YI SYLLABLE QUT",
	"YI SYLLABLE QUX",
	"YI SYLLABLE QU",
	"YI SYLLABLE QUP",
	"YI SYLLABLE QURX",
	"YI SYLLABLE QUR",
	"YI SYLLABLE QYT",
	"YI SYLLABLE QYX",
	"YI SYLLABLE QY",
	"YI SYLLABLE QYP",
	"YI SYLLABLE QYRX",
	"YI SYLLABLE QYR",
	"YI SYLLABLE JJIT",
	"YI SYLLABLE JJIX",
	"YI SYLLABLE JJI",
	"YI SYLLABLE JJIP",
	"YI SYLLABLE JJIET",
	"YI SYLLABLE JJIEX",
	"YI SYLLABLE JJIE",
	"YI SYLLABLE JJIEP",
	"YI SYLLABLE JJUOX",
	"YI SYLLABLE JJUO",
	"YI SYLLABLE JJUOP",
	"YI SYLLABLE JJOT",
	"YI SYLLABLE JJOX",
	"YI SYLLABLE JJO",
	"YI SYLLABLE JJOP",
	"YI SYLLABLE JJUT",
	"YI SYLLABLE JJUX",
	"YI SYLLABLE JJU",
	"YI SYLLABLE JJUP",
	"YI SYLLABLE JJURX",
	"YI SYLLABLE JJUR",
	"YI SYLLABLE JJYT",
	"YI SYLLABLE JJYX",
	"YI SYLLABLE JJY",
	"YI SYLLABLE JJYP",
	"YI SYLLABLE NJIT",
	"YI SYLLABLE NJIX",
	"YI SYLLABLE NJI",
	"YI SYLLABLE NJIP",
	"YI SYLLABLE NJIET",
	"YI SYLLABLE NJIEX",
	"YI SYLLABLE NJIE",
	"YI SYLLABLE NJIEP",
	"YI SYLLABLE NJUOX",
	"YI SYLLABLE NJUO",
	"YI SYLLABLE NJOT",
	"YI SYLLABLE NJOX",
	"YI SYLLABLE NJO",
	"YI SYLLABLE NJOP",
	"YI SYLLABLE NJUX",
	"YI SYLLABLE NJU",
	"YI SYLLABLE NJUP",
	"YI SYLLABLE NJURX",
	"YI SYLLABLE NJUR",
	"YI SYLLABLE NJYT",
	"YI SYLLABLE NJYX",
	"YI SYLLABLE NJY",
	"YI SYLLABLE NJYP",
	"YI SYLLABLE NJYRX",
	"YI SYLLABLE NJYR",
	"YI SYLLABLE NYIT",
	"YI SYLLABLE NYIX",
	"YI SYLLABLE NYI",
	"YI SYLLABLE NYIP",
	"YI SYLLABLE NYIET",
	"YI SYLLABLE NYIEX",
	"YI SYLLABLE NYIE",
	"YI SYLLABLE NYIEP",
	"YI SYLLABLE NYUOX",
	"YI SYLLABLE NYUO",
	"YI SYLLABLE NYUOP",
	"YI SYLLABLE NYOT",
	"YI SYLLABLE NYOX",
	"YI SYLLABLE NYO",
	"YI SYLLABLE NYOP",
	"YI SYLLABLE NYUT",
	"YI SYLLABLE NYUX",
	"YI SYLLABLE NYU",
	"YI SYLLABLE NYUP",
	"YI SYLLABLE XIT",
	"YI SYLLABLE XIX",
	"YI SYLLABLE XI",
	"YI SYLLABLE XIP",
	"YI SYLLABLE XIET",
	"YI SYLLABLE XIEX",
	"YI SYLLABLE XIE",
	"YI SYLLABLE XIEP",
	"YI SYLLABLE XUOX",
	"YI SYLLABLE XUO",
	"YI SYLLABLE XOT",
	"YI SYLLABLE XOX",
	"YI SYLLABLE XO",
	"YI SYLLABLE XOP",
	"YI SYLLABLE XYT",
	"YI SYLLABLE XYX",
	"YI SYLLABLE XY",
	"YI SYLLABLE XYP",
	"YI SYLLABLE XYRX",
	"YI SYLLABLE XYR",
	"YI SYLLABLE YIT",
	"YI SYLLABLE YIX",
	"YI SYLLABLE YI",
	"YI SYLLABLE YIP",
	"YI SYLLABLE YIET",
	"YI SYLLABLE YIEX",
	"YI SYLLABLE YIE",
	"YI SYLLABLE YIEP",
	"YI SYLLABLE YUOT",
	"YI SYLLABLE YUOX",
	"YI SYLLABLE YUO",
	"YI SYLLABLE YUOP",
	"YI SYLLABLE YOT",
	"YI SYLLABLE YOX",
	"YI SYLLABLE YO",
	"YI SYLLABLE YOP",
	"YI SYLLABLE YUT",
	"YI SYLLABLE YUX",
	"YI SYLLABLE YU",
	"YI SYLLABLE YUP",
	"YI SYLLABLE YURX",
	"YI SYLLABLE YUR",
	"YI SYLLABLE YYT",
	"YI SYLLABLE YYX",
	"YI SYLLABLE YY",
	"YI SYLLABLE YYP",
	"YI SYLLABLE YYRX",
	"YI SYLLABLE YYR",
	"YI RADICAL QOT",
	"YI RADICAL LI",
	"YI RADICAL KIT",
	"YI RADICAL NYIP",
	"YI RADICAL CYP",
	"YI RADICAL SSI",
	"YI RADICAL GGOP",
	"YI RADICAL GEP",
	"YI RADICAL MI",
	"YI RADICAL HXIT",
	"YI RADICAL LYR",
	"YI RADICAL BBUT",
	"YI RADICAL MOP",
	"YI RADICAL YO",
	"YI RADICAL PUT",
	"YI RADICAL HXUO",
	"YI RADICAL TAT",
	"YI RADICAL GA",
	"YI RADICAL ZUP",
	"YI RADICAL CYT",
	"YI RADICAL DDUR",
	"YI RADICAL BUR",
	"YI RADICAL GGUO",
	"YI RADICAL NYOP",
	"YI RADICAL TU",
	"YI RADICAL OP",
	"YI RADICAL JJUT",
	"YI RADICAL ZOT",
	"YI RADICAL PYT",
	"YI RADICAL HMO",
	"YI RADICAL YIT",
	"YI RADICAL VUR",
	"YI RADICAL SHY",
	"YI RADICAL VEP",
	"YI RADICAL ZA",
	"YI RADICAL JO",
	"YI RADICAL NZUP",
	"YI RADICAL JJY",
	"YI RADICAL GOT",
	"YI RADICAL JJIE",
	"YI RADICAL WO",
	"YI RADICAL DU",
	"YI RADICAL SHUR",
	"YI RADICAL LIE",
	"YI RADICAL CY",
	"YI RADICAL CUOP",
	"YI RADICAL CIP",
	"YI RADICAL HXOP",
	"YI RADICAL SHAT",
	"YI RADICAL ZUR",
	"YI RADICAL SHOP",
	"YI RADICAL CHE",
	"YI RADICAL ZZIET",
	"YI RADICAL NBIE",
	"YI RADICAL KE",
	"LISU LETTER BA",
	"LISU LETTER PA",
	"LISU LETTER PHA",
	"LISU LETTER DA",
	"LISU LETTER TA",
	"LISU LETTER THA",
	"LISU LETTER GA",
	"LISU LETTER KA",
	"LISU LETTER KHA",
	"LISU LETTER JA",
	"LISU LETTER CA",
	"LISU LETTER CHA",
	"LISU LETTER DZA",
	"LISU LETTER TSA",
	"LISU LETTER TSHA",
	"LISU LETTER MA",
	"LISU LETTER NA",
	"LISU LETTER LA",
	"LISU LETTER SA",
	"LISU LETTER ZHA",
	"LISU LETTER ZA",
	"LISU LETTER NGA",
	"LISU LETTER HA",
	"LISU LETTER XA",
	"LISU LETTER HHA",
	"LISU LETTER FA",
	"LISU LETTER WA",
	"LISU LETTER SHA",
	"LISU LETTER YA",
	"LISU LETTER GHA",
	"LISU LETTER A",
	"LISU LETTER AE",
	"LISU LETTER E",
	"LISU LETTER EU",
	"LISU LETTER I",
	"LISU LETTER O",
	"LISU LETTER U",
	"LISU LETTER UE",
	"LISU LETTER UH",
	"LISU LETTER OE",
	"LISU LETTER TONE MYA TI",
	"LISU LETTER TONE NA PO",
	"LISU LETTER TONE MYA CYA",
	"LISU LETTER TONE MYA BO",
	"LISU LETTER TONE MYA NA",
	"LISU LETTER TONE MYA JEU",
	"LISU PUNCTUATION COMMA",
	"LISU PUNCTUATION FULL STOP",
	"VAI SYLLABLE EE",
	"VAI SYLLABLE EEN",
	"VAI SYLLABLE HEE",
	"VAI SYLLABLE WEE",
	"VAI SYLLABLE WEEN",
	"VAI SYLLABLE PEE",
	"VAI SYLLABLE BHEE",
	"VAI SYLLABLE BEE",
	"VAI SYLLABLE MBEE",
	"VAI SYLLABLE KPEE",
	"VAI SYLLABLE MGBEE",
	"VAI SYLLABLE GBEE",
	"VAI SYLLABLE FEE",
	"VAI SYLLABLE VEE",
	"VAI SYLLABLE TEE",
	"VAI SYLLABLE THEE",
	"VAI SYLLABLE DHEE",
	"VAI SYLLABLE DHHEE",
	"VAI SYLLABLE LEE",
	"VAI SYLLABLE REE",
	"VAI SYLLABLE DEE",
	"VAI SYLLABLE NDEE",
	"VAI SYLLABLE SEE",
	"VAI SYLLABLE SHEE",
	"VAI SYLLABLE ZEE",
	"VAI SYLLABLE ZHEE",
	"VAI SYLLABLE CEE",
	"VAI SYLLABLE JEE",
	"VAI SYLLABLE NJEE",
	"VAI SYLLABLE YEE",
	"VAI SYLLABLE KEE",
	"VAI SYLLABLE NGGEE",
	"VAI SYLLABLE GEE",
	"VAI SYLLABLE MEE",
	"VAI SYLLABLE NEE",
	"VAI SYLLABLE NYEE",
	"VAI SYLLABLE I",
	"VAI SYLLABLE IN",
	"VAI SYLLABLE HI",
	"VAI SYLLABLE HIN",
	"VAI SYLLABLE WI",
	"VAI SYLLABLE WIN",
	"VAI SYLLABLE PI",
	"VAI SYLLABLE BHI",
	"VAI SYLLABLE BI",
	"VAI SYLLABLE MBI",
	"VAI SYLLABLE KPI",
	"VAI SYLLABLE MGBI",
	"VAI SYLLABLE GBI",
	"VAI SYLLABLE FI",
	"VAI SYLLABLE VI",
	"VAI SYLLABLE TI",
	"VAI SYLLABLE THI",
	"VAI SYLLABLE DHI",
	"VAI SYLLABLE DHHI",
	"VAI SYLLABLE LI",
	"VAI SYLLABLE RI",
	"VAI SYLLABLE DI",
	"VAI SYLLABLE NDI",
	"VAI SYLLABLE SI",
	"VAI SYLLABLE SHI",
	"VAI SYLLABLE ZI",
	"VAI SYLLABLE ZHI",
	"VAI SYLLABLE CI",
	"VAI SYLLABLE JI",
	"VAI SYLLABLE NJI",
	"VAI SYLLABLE YI",
	"VAI SYLLABLE KI",
	"VAI SYLLABLE NGGI",
	"VAI SYLLABLE GI",
	"VAI SYLLABLE MI",
	"VAI SYLLABLE NI",
	"VAI SYLLABLE NYI",
	"VAI SYLLABLE A",
	"VAI SYLLABLE AN",
	"VAI SYLLABLE NGAN",
	"VAI SYLLABLE HA",
	"VAI SYLLABLE HAN",
	"VAI SYLLABLE WA",
	"VAI SYLLABLE WAN",
	"VAI SYLLABLE PA",
	"VAI SYLLABLE BHA",
	"VAI SYLLABLE BA",
	"VAI SYLLABLE MBA",
	"VAI SYLLABLE KPA",
	"VAI SYLLABLE KPAN",
	"VAI SYLLABLE MGBA",
	"VAI SYLLABLE GBA",
	"VAI SYLLABLE FA",
	"VAI SYLLABLE VA",
	"VAI SYLLABLE TA",
	"VAI SYLLABLE THA",
	"VAI SYLLABLE DHA",
	"VAI SYLLABLE DHHA",
	"VAI SYLLABLE LA",
	"VAI SYLLABLE RA",
	"VAI SYLLABLE DA",
	"VAI SYLLABLE NDA",
	"VAI SYLLABLE SA",
	"VAI SYLLABLE SHA",
	"VAI SYLLABLE ZA",
	"VAI SYLLABLE ZHA",
	"VAI SYLLABLE CA",
	"VAI SYLLABLE JA",
	"VAI SYLLABLE NJA",
	"VAI SYLLABLE YA",
	"VAI SYLLABLE KA",
	"VAI SYLLABLE KAN",
	"VAI SYLLABLE NGGA",
	"VAI SYLLABLE GA",
	"VAI SYLLABLE MA",
	"VAI SYLLABLE NA",
	"VAI SYLLABLE NYA",
	"VAI SYLLABLE OO",
	"VAI SYLLABLE OON",
	"VAI SYLLABLE HOO",
	"VAI SYLLABLE WOO",
	"VAI SYLLABLE WOON",
	"VAI SYLLABLE POO",
	"VAI SYLLABLE BHOO",
	"VAI SYLLABLE BOO",
	"VAI SYLLABLE MBOO",
	"VAI SYLLABLE KPOO",
	"VAI SYLLABLE MGBOO",
	"VAI SYLLABLE GBOO",
	"VAI SYLLABLE FOO",
	"VAI SYLLABLE VOO",
	"VAI SYLLABLE TOO",
	"VAI SYLLABLE THOO",
	"VAI SYLLABLE DHOO",
	"VAI SYLLABLE DHHOO",
	"VAI SYLLABLE LOO",
	"VAI SYLLABLE ROO",
	"VAI SYLLABLE DOO",
	"VAI SYLLABLE NDOO",
	"VAI SYLLABLE SOO",
	"VAI SYLLABLE SHOO",
	"VAI SYLLABLE ZOO",
	"VAI SYLLABLE ZHOO",
	"VAI SYLLABLE COO",
	"VAI SYLLABLE JOO",
	"VAI SYLLABLE NJOO",
	"VAI SYLLABLE YOO",
	"VAI SYLLABLE KOO",
	"VAI SYLLABLE NGGOO",
	"VAI SYLLABLE GOO",
	"VAI SYLLABLE MOO",
	"VAI SYLLABLE NOO",
	"VAI SYLLABLE NYOO",
	"VAI SYLLABLE U",
	"VAI SYLLABLE UN",
	"VAI SYLLABLE HU",
	"VAI SYLLABLE HUN",
	"VAI SYLLABLE WU",
	"VAI SYLLABLE WUN",
	"VAI SYLLABLE PU",
	"VAI SYLLABLE BHU",
	"VAI SYLLABLE BU",
	"VAI SYLLABLE MBU",
	"VAI SYLLABLE KPU",
	"VAI SYLLABLE MGBU",
	"VAI SYLLABLE GBU",
	"VAI SYLLABLE FU",
	"VAI SYLLABLE VU",
	"VAI SYLLABLE TU",
	"VAI SYLLABLE THU",
	"VAI SYLLABLE DHU",
	"VAI SYLLABLE DHHU",
	"VAI SYLLABLE LU",
	"VAI SYLLABLE RU",
	"VAI SYLLABLE DU",
	"VAI SYLLABLE NDU",
	"VAI SYLLABLE SU",
	"VAI SYLLABLE SHU",
	"VAI SYLLABLE ZU",
	"VAI SYLLABLE ZHU",
	"VAI SYLLABLE CU",
	"VAI SYLLABLE JU",
	"VAI SYLLABLE NJU",
	"VAI SYLLABLE YU",
	"VAI SYLLABLE KU",
	"VAI SYLLABLE NGGU",
	"VAI SYLLABLE GU",
	"VAI SYLLABLE MU",
	"VAI SYLLABLE NU",
	"VAI SYLLABLE NYU",
	"VAI SYLLABLE O",
	"VAI SYLLABLE ON",
	"VAI SYLLABLE NGON",
	"VAI SYLLABLE HO",
	"VAI SYLLABLE HON",
	"VAI SYLLABLE WO",
	"VAI SYLLABLE WON",
	"VAI SYLLABLE PO",
	"VAI SYLLABLE BHO",
	"VAI SYLLABLE BO",
	"VAI SYLLABLE MBO",
	"VAI SYLLABLE KPO",
	"VAI SYLLABLE MGBO",
	"VAI SYLLABLE GBO",
	"VAI SYLLABLE GBON",
	"VAI SYLLABLE FO",
	"VAI SYLLABLE VO",
	"VAI SYLLABLE TO",
	"VAI SYLLABLE THO",
	"VAI SYLLABLE DHO",
	"VAI SYLLABLE DHHO",
	"VAI SYLLABLE LO",
	"VAI SYLLABLE RO",
	"VAI SYLLABLE DO",
	"VAI SYLLABLE NDO",
	"VAI SYLLABLE SO",
	"VAI SYLLABLE SHO",
	"VAI SYLLABLE ZO",
	"VAI SYLLABLE ZHO",
	"VAI SYLLABLE CO",
	"VAI SYLLABLE JO",
	"VAI SYLLABLE NJO",
	"VAI SYLLABLE YO",
	"VAI SYLLABLE KO",
	"VAI SYLLABLE NGGO",
	"VAI SYLLABLE GO",
	"VAI SYLLABLE MO",
	"VAI SYLLABLE NO",
	"VAI SYLLABLE NYO",
	"VAI SYLLABLE E",
	"VAI SYLLABLE EN",
	"VAI SYLLABLE NGEN",
	"VAI SYLLABLE HE",
	"VAI SYLLABLE HEN",
	"VAI SYLLABLE WE",
	"VAI SYLLABLE WEN",
	"VAI SYLLABLE PE",
	"VAI SYLLABLE BHE",
	"VAI SYLLABLE BE",
	"VAI SYLLABLE MBE",
	"VAI SYLLABLE KPE",
	"VAI SYLLABLE KPEN",
	"VAI SYLLABLE MGBE",
	"VAI SYLLABLE GBE",
	"VAI SYLLABLE GBEN",
	"VAI SYLLABLE FE",
	"VAI SYLLABLE VE",
	"VAI SYLLABLE TE",
	"VAI SYLLABLE THE",
	"VAI SYLLABLE DHE",
	"VAI SYLLABLE DHHE",
	"VAI SYLLABLE LE",
	"VAI SYLLABLE RE",
	"VAI SYLLABLE DE",
	"VAI SYLLABLE NDE",
	"VAI SYLLABLE SE",
	"VAI SYLLABLE SHE",
	"VAI SYLLABLE ZE",
	"VAI SYLLABLE ZHE",
	"VAI SYLLABLE CE",
	"VAI SYLLABLE JE",
	"VAI SYLLABLE NJE",
	"VAI SYLLABLE YE",
	"VAI SYLLABLE KE",
	"VAI SYLLABLE NGGE",
	"VAI SYLLABLE NGGEN",
	"VAI SYLLABLE GE",
	"VAI SYLLABLE GEN",
	"VAI SYLLABLE ME",
	"VAI SYLLABLE NE",
	"VAI SYLLABLE NYE",
	"VAI SYLLABLE NG",
	"VAI SYLLABLE LENGTHENER",
	"VAI COMMA",
	"VAI FULL STOP",
	"VAI QUESTION MARK",
	"VAI SYLLABLE NDOLE FA",
	"VAI SYLLABLE NDOLE KA",
	"VAI SYLLABLE NDOLE SOO",
	"VAI SYMBOL FEENG",
	"VAI SYMBOL KEENG",
	"VAI SYMBOL TING",
	"VAI SYMBOL NII",
	"VAI SYMBOL BANG",
	"VAI SYMBOL FAA",
	"VAI SYMBOL TAA",
	"VAI SYMBOL DANG",
	"VAI SYMBOL DOONG",
	"VAI SYMBOL KUNG",
	"VAI SYMBOL TONG",
	"VAI SYMBOL DO-O",
	"VAI SYMBOL JONG",
	"VAI DIGIT ZERO",
	"VAI DIGIT ONE",
	"VAI DIGIT TWO",
	"VAI DIGIT THREE",
	"VAI DIGIT FOUR",
	"VAI DIGIT FIVE",
	"VAI DIGIT SIX",
	"VAI DIGIT SEVEN",
	"VAI DIGIT EIGHT",
	"VAI DIGIT NINE",
	"VAI SYLLABLE NDOLE MA",
	"VAI SYLLABLE NDOLE DO",
	"CYRILLIC CAPITAL LETTER ZEMLYA",
	"CYRILLIC SMALL LETTER ZEMLYA",
	"CYRILLIC CAPITAL LETTER DZELO",
	"CYRILLIC SMALL LETTER DZELO",
	"CYRILLIC CAPITAL LETTER REVERSED DZE",
	"CYRILLIC SMALL LETTER REVERSED DZE",
	"CYRILLIC CAPITAL LETTER IOTA",
	"CYRILLIC SMALL LETTER IOTA",
	"CYRILLIC CAPITAL LETTER DJERV",
	"CYRILLIC SMALL LETTER DJERV",
	"CYRILLIC CAPITAL LETTER MONOGRAPH UK",
	"CYRILLIC SMALL LETTER MONOGRAPH UK",
	"CYRILLIC CAPITAL LETTER BROAD OMEGA",
	"CYRILLIC SMALL LETTER BROAD OMEGA",
	"CYRILLIC CAPITAL LETTER NEUTRAL YER",
	"CYRILLIC SMALL LETTER NEUTRAL YER",
	"CYRILLIC CAPITAL LETTER YERU WITH BACK YER",
	"CYRILLIC SMALL LETTER YERU WITH BACK YER",
	"CYRILLIC CAPITAL LETTER IOTIFIED YAT",
	"CYRILLIC SMALL LETTER IOTIFIED YAT",
	"CYRILLIC CAPITAL LETTER REVERSED YU",
	"CYRILLIC SMALL LETTER REVERSED YU",
	"CYRILLIC CAPITAL LETTER IOTIFIED A",
	"CYRILLIC SMALL LETTER IOTIFIED A",
	"CYRILLIC CAPITAL LETTER CLOSED LITTLE YUS",
	"CYRILLIC SMALL LETTER CLOSED LITTLE YUS",
	"CYRILLIC CAPITAL LETTER BLENDED YUS",
	"CYRILLIC SMALL LETTER BLENDED YUS",
	"CYRILLIC CAPITAL LETTER IOTIFIED CLOSED LITTLE YUS",
	"CYRILLIC SMALL LETTER IOTIFIED CLOSED LITTLE YUS",
	"CYRILLIC CAPITAL LETTER YN",
	"CYRILLIC SMALL LETTER YN",
	"CYRILLIC CAPITAL LETTER REVERSED TSE",
	"CYRILLIC SMALL LETTER REVERSED TSE",
	"CYRILLIC CAPITAL LETTER SOFT DE",
	"CYRILLIC SMALL LETTER SOFT DE",
	"CYRILLIC CAPITAL LETTER SOFT EL",
	"CYRILLIC SMALL LETTER SOFT EL",
	"CYRILLIC CAPITAL LETTER SOFT EM",
	"CYRILLIC SMALL LETTER SOFT EM",
	"CYRILLIC CAPITAL LETTER MONOCULAR O",
	"CYRILLIC SMALL LETTER MONOCULAR O",
	"CYRILLIC CAPITAL LETTER BINOCULAR O",
	"CYRILLIC SMALL LETTER BINOCULAR O",
	"CYRILLIC CAPITAL LETTER DOUBLE MONOCULAR O",
	"CYRILLIC SMALL LETTER DOUBLE MONOCULAR O",
	"CYRILLIC LETTER MULTIOCULAR O",
	"COMBINING CYRILLIC VZMET",
	"COMBINING CYRILLIC TEN MILLIONS SIGN",
	"COMBINING CYRILLIC HUNDRED MILLIONS SIGN",
	"COMBINING CYRILLIC THOUSAND MILLIONS SIGN",
	"SLAVONIC ASTERISK",
	"COMBINING CYRILLIC LETTER UKRAINIAN IE",
	"COMBINING CYRILLIC LETTER I",
	"COMBINING CYRILLIC LETTER YI",
	"COMBINING CYRILLIC LETTER U",
	"COMBINING CYRILLIC LETTER HARD SIGN",
	"COMBINING CYRILLIC LETTER YERU",
	"COMBINING CYRILLIC LETTER SOFT SIGN",
	"COMBINING CYRILLIC LETTER OMEGA",
	"COMBINING CYRILLIC KAVYKA",
	"COMBINING CYRILLIC PAYEROK",
	"CYRILLIC KAVYKA",
	"CYRILLIC PAYEROK",
	"CYRILLIC CAPITAL LETTER DWE",
	"CYRILLIC SMALL LETTER DWE",
	"CYRILLIC CAPITAL LETTER DZWE",
	"CYRILLIC SMALL LETTER DZWE",
	"CYRILLIC CAPITAL LETTER ZHWE",
	"CYRILLIC SMALL LETTER ZHWE",
	"CYRILLIC CAPITAL LETTER CCHE",
	"CYRILLIC SMALL LETTER CCHE",
	"CYRILLIC CAPITAL LETTER DZZE",
	"CYRILLIC SMALL LETTER DZZE",
	"CYRILLIC CAPITAL LETTER TE WITH MIDDLE HOOK",
	"CYRILLIC SMALL LETTER TE WITH MIDDLE HOOK",
	"CYRILLIC CAPITAL LETTER TWE",
	"CYRILLIC SMALL LETTER TWE",
	"CYRILLIC CAPITAL LETTER TSWE",
	"CYRILLIC SMALL LETTER TSWE",
	"CYRILLIC CAPITAL LETTER TSSE",
	"CYRILLIC SMALL LETTER TSSE",
	"CYRILLIC CAPITAL LETTER TCHE",
	"CYRILLIC SMALL LETTER TCHE",
	"CYRILLIC CAPITAL LETTER HWE",
	"CYRILLIC SMALL LETTER HWE",
	"CYRILLIC CAPITAL LETTER SHWE",
	"CYRILLIC SMALL LETTER SHWE",
	"CYRILLIC CAPITAL LETTER DOUBLE O",
	"CYRILLIC SMALL LETTER DOUBLE O",
	"CYRILLIC CAPITAL LETTER CROSSED O",
	"CYRILLIC SMALL LETTER CROSSED O",
	"MODIFIER LETTER CYRILLIC HARD SIGN",
	"MODIFIER LETTER CYRILLIC SOFT SIGN",
	"COMBINING CYRILLIC LETTER EF",
	"COMBINING CYRILLIC LETTER IOTIFIED E",
	"BAMUM LETTER A",
	"BAMUM LETTER KA",
	"BAMUM LETTER U",
	"BAMUM LETTER KU",
	"BAMUM LETTER EE",
	"BAMUM LETTER REE",
	"BAMUM LETTER TAE",
	"BAMUM LETTER O",
	"BAMUM LETTER NYI",
	"BAMUM LETTER I",
	"BAMUM LETTER LA",
	"BAMUM LETTER PA",
	"BAMUM LETTER RII",
	"BAMUM LETTER RIEE",
	"BAMUM LETTER LEEEE",
	"BAMUM LETTER MEEEE",
	"BAMUM LETTER TAA",
	"BAMUM LETTER NDAA",
	"BAMUM LETTER NJAEM",
	"BAMUM LETTER M",
	"BAMUM LETTER SUU",
	"BAMUM LETTER MU",
	"BAMUM LETTER SHII",
	"BAMUM LETTER SI",
	"BAMUM LETTER SHEUX",
	"BAMUM LETTER SEUX",
	"BAMUM LETTER KYEE",
	"BAMUM LETTER KET",
	"BAMUM LETTER NUAE",
	"BAMUM LETTER NU",
	"BAMUM LETTER NJUAE",
	"BAMUM LETTER YOQ",
	"BAMUM LETTER SHU",
	"BAMUM LETTER YUQ",
	"BAMUM LETTER YA",
	"BAMUM LETTER NSHA",
	"BAMUM LETTER KEUX",
	"BAMUM LETTER PEUX",
	"BAMUM LETTER NJEE",
	"BAMUM LETTER NTEE",
	"BAMUM LETTER PUE",
	"BAMUM LETTER WUE",
	"BAMUM LETTER PEE",
	"BAMUM LETTER FEE",
	"BAMUM LETTER RU",
	"BAMUM LETTER LU",
	"BAMUM LETTER MI",
	"BAMUM LETTER NI",
	"BAMUM LETTER REUX",
	"BAMUM LETTER RAE",
	"BAMUM LETTER KEN",
	"BAMUM LETTER NGKWAEN",
	"BAMUM LETTER NGGA",
	"BAMUM LETTER NGA",
	"BAMUM LETTER SHO",
	"BAMUM LETTER PUAE",
	"BAMUM LETTER FU",
	"BAMUM LETTER FOM",
	"BAMUM LETTER WA",
	"BAMUM LETTER NA",
	"BAMUM LETTER LI",
	"BAMUM LETTER PI",
	"BAMUM LETTER LOQ",
	"BAMUM LETTER KO",
	"BAMUM LETTER MBEN",
	"BAMUM LETTER REN",
	"BAMUM LETTER MEN",
	"BAMUM LETTER MA",
	"BAMUM LETTER TI",
	"BAMUM LETTER KI",
	"BAMUM LETTER MO",
	"BAMUM LETTER MBAA",
	"BAMUM LETTER TET",
	"BAMUM LETTER KPA",
	"BAMUM LETTER TEN",
	"BAMUM LETTER NTUU",
	"BAMUM LETTER SAMBA",
	"BAMUM LETTER FAAMAE",
	"BAMUM LETTER KOVUU",
	"BAMUM LETTER KOGHOM",
	"BAMUM COMBINING MARK KOQNDON",
	"BAMUM COMBINING MARK TUKWENTIS",
	"BAMUM NJAEMLI",
	"BAMUM FULL STOP",
	"BAMUM COLON",
	"BAMUM COMMA",
	"BAMUM SEMICOLON",
	"BAMUM QUESTION MARK",
	"MODIFIER LETTER CHINESE TONE YIN PING",
	"MODIFIER LETTER CHINESE TONE YANG PING",
	"MODIFIER LETTER CHINESE TONE YIN SHANG",
	"MODIFIER LETTER CHINESE TONE YANG SHANG",
	"MODIFIER LETTER CHINESE TONE YIN QU",
	"MODIFIER LETTER CHINESE TONE YANG QU",
	"MODIFIER LETTER CHINESE TONE YIN RU",
	"MODIFIER LETTER CHINESE TONE YANG RU",
	"MODIFIER LETTER EXTRA-HIGH DOTTED TONE BAR",
	"MODIFIER LETTER HIGH DOTTED TONE BAR",
	"MODIFIER LETTER MID DOTTED TONE BAR",
	"MODIFIER LETTER LOW DOTTED TONE BAR",
	"MODIFIER LETTER EXTRA-LOW DOTTED TONE BAR",
	"MODIFIER LETTER EXTRA-HIGH DOTTED LEFT-STEM TONE BAR",
	"MODIFIER LETTER HIGH DOTTED LEFT-STEM TONE BAR",
	"MODIFIER LETTER MID DOTTED LEFT-STEM TONE BAR",
	"MODIFIER LETTER LOW DOTTED LEFT-STEM TONE BAR",
	"MODIFIER LETTER EXTRA-LOW DOTTED LEFT-STEM TONE BAR",
	"MODIFIER LETTER EXTRA-HIGH LEFT-STEM TONE BAR",
	"MODIFIER LETTER HIGH LEFT-STEM TONE BAR",
	"MODIFIER LETTER MID LEFT-STEM TONE BAR",
	"MODIFIER LETTER LOW LEFT-STEM TONE BAR",
	"MODIFIER LETTER EXTRA-LOW LEFT-STEM TONE BAR",
	"MODIFIER LETTER DOT VERTICAL BAR",
	"MODIFIER LETTER DOT SLASH",
	"MODIFIER LETTER DOT HORIZONTAL BAR",
	"MODIFIER LETTER LOWER RIGHT CORNER ANGLE",
	"MODIFIER LETTER RAISED UP ARROW",
	"MODIFIER LETTER RAISED DOWN ARROW",
	"MODIFIER LETTER RAISED EXCLAMATION MARK",
	"MODIFIER LETTER RAISED INVERTED EXCLAMATION MARK",
	"MODIFIER LETTER LOW INVERTED EXCLAMATION MARK",
	"MODIFIER LETTER STRESS AND HIGH TONE",
	"MODIFIER LETTER STRESS AND LOW TONE",
	"LATIN CAPITAL LETTER EGYPTOLOGICAL ALEF",
	"LATIN SMALL LETTER EGYPTOLOGICAL ALEF",
	"LATIN CAPITAL LETTER EGYPTOLOGICAL AIN",
	"LATIN SMALL LETTER EGYPTOLOGICAL AIN",
	"LATIN CAPITAL LETTER HENG",
	"LATIN SMALL LETTER HENG",
	"LATIN CAPITAL LETTER TZ",
	"LATIN SMALL LETTER TZ",
	"LATIN CAPITAL LETTER TRESILLO",
	"LATIN SMALL LETTER TRESILLO",
	"LATIN CAPITAL LETTER CUATRILLO",
	"LATIN SMALL LETTER CUATRILLO",
	"LATIN CAPITAL LETTER CUATRILLO WITH COMMA",
	"LATIN SMALL LETTER CUATRILLO WITH COMMA",
	"LATIN LETTER SMALL CAPITAL F",
	"LATIN LETTER SMALL CAPITAL S",
	"LATIN CAPITAL LETTER AA",
	"LATIN SMALL LETTER AA",
	"LATIN CAPITAL LETTER AO",
	"LATIN SMALL LETTER AO",
	"LATIN CAPITAL LETTER AU",
	"LATIN SMALL LETTER AU",
	"LATIN CAPITAL LETTER AV",
	"LATIN SMALL LETTER AV",
	"LATIN CAPITAL LETTER AV WITH HORIZONTAL BAR",
	"LATIN SMALL LETTER AV WITH HORIZONTAL BAR",
	"LATIN CAPITAL LETTER AY",
	"LATIN SMALL LETTER AY",
	"LATIN CAPITAL LETTER REVERSED C WITH DOT",
	"LATIN SMALL LETTER REVERSED C WITH DOT",
	"LATIN CAPITAL LETTER K WITH STROKE",
	"LATIN SMALL LETTER K WITH STROKE",
	"LATIN CAPITAL LETTER K WITH DIAGONAL STROKE",
	"LATIN SMALL LETTER K WITH DIAGONAL STROKE",
	"LATIN CAPITAL LETTER K WITH STROKE AND DIAGONAL STROKE",
	"LATIN SMALL LETTER K WITH STROKE AND DIAGONAL STROKE",
	"LATIN CAPITAL LETTER BROKEN L",
	"LATIN SMALL LETTER BROKEN L",
	"LATIN CAPITAL LETTER L WITH HIGH STROKE",
	"LATIN SMALL LETTER L WITH HIGH STROKE",
	"LATIN CAPITAL LETTER O WITH LONG STROKE OVERLAY",
	"LATIN SMALL LETTER O WITH LONG STROKE OVERLAY",
	"LATIN CAPITAL LETTER O WITH LOOP",
	"LATIN SMALL LETTER O WITH LOOP",
	"LATIN CAPITAL LETTER OO",
	"LATIN SMALL LETTER OO",
	"LATIN CAPITAL LETTER P WITH STROKE THROUGH DESCENDER",
	"LATIN SMALL LETTER P WITH STROKE THROUGH DESCENDER",
	"LATIN CAPITAL LETTER P WITH FLOURISH",
	"LATIN SMALL LETTER P WITH FLOURISH",
	"LATIN CAPITAL LETTER P WITH SQUIRREL TAIL",
	"LATIN SMALL LETTER P WITH SQUIRREL TAIL",
	"LATIN CAPITAL LETTER Q WITH STROKE THROUGH DESCENDER",
	"LATIN SMALL LETTER Q WITH STROKE THROUGH DESCENDER",
	"LATIN CAPITAL LETTER Q WITH DIAGONAL STROKE",
	"LATIN SMALL LETTER Q WITH DIAGONAL STROKE",
	"LATIN CAPITAL LETTER R ROTUNDA",
	"LATIN SMALL LETTER R ROTUNDA",
	"LATIN CAPITAL LETTER RUM ROTUNDA",
	"LATIN SMALL LETTER RUM ROTUNDA",
	"LATIN CAPITAL LETTER V WITH DIAGONAL STROKE",
	"LATIN SMALL LETTER V WITH DIAGONAL STROKE",
	"LATIN CAPITAL LETTER VY",
	"LATIN SMALL LETTER VY",
	"LATIN CAPITAL LETTER VISIGOTHIC Z",
	"LATIN SMALL LETTER VISIGOTHIC Z",
	"LATIN CAPITAL LETTER THORN WITH STROKE",
	"LATIN SMALL LETTER THORN WITH STROKE",
	"LATIN CAPITAL LETTER THORN WITH STROKE THROUGH DESCENDER",
	"LATIN SMALL LETTER THORN WITH STROKE THROUGH DESCENDER",
	"LATIN CAPITAL LETTER VEND",
	"LATIN SMALL LETTER VEND",
	"LATIN CAPITAL LETTER ET",
	"LATIN SMALL LETTER ET",
	"LATIN CAPITAL LETTER IS",
	"LATIN SMALL LETTER IS",
	"LATIN CAPITAL LETTER CON",
	"LATIN SMALL LETTER CON",
	"MODIFIER LETTER US",
	"LATIN SMALL LETTER DUM",
	"LATIN SMALL LETTER LUM",
	"LATIN SMALL LETTER MUM",
	"LATIN SMALL LETTER NUM",
	"LATIN SMALL LETTER RUM",
	"LATIN LETTER SMALL CAPITAL RUM",
	"LATIN SMALL LETTER TUM",
	"LATIN SMALL LETTER UM",
	"LATIN CAPITAL LETTER INSULAR D",
	"LATIN SMALL LETTER INSULAR D",
	"LATIN CAPITAL LETTER INSULAR F",
	"LATIN SMALL LETTER INSULAR F",
	"LATIN CAPITAL LETTER INSULAR G",
	"LATIN CAPITAL LETTER TURNED INSULAR G",
	"LATIN SMALL LETTER TURNED INSULAR G",
	"LATIN CAPITAL LETTER TURNED L",
	"LATIN SMALL LETTER TURNED L",
	"LATIN CAPITAL LETTER INSULAR R",
	"LATIN SMALL LETTER INSULAR R",
	"LATIN CAPITAL LETTER INSULAR S",
	"LATIN SMALL LETTER INSULAR S",
	"LATIN CAPITAL LETTER INSULAR T",
	"LATIN SMALL LETTER INSULAR T",
	"MODIFIER LETTER LOW CIRCUMFLEX ACCENT",
	"MODIFIER LETTER COLON",
	"MODIFIER LETTER SHORT EQUALS SIGN",
	"LATIN CAPITAL LETTER SALTILLO",
	"LATIN SMALL LETTER SALTILLO",
	"LATIN CAPITAL LETTER TURNED H",
	"LATIN SMALL LETTER L WITH RETROFLEX HOOK AND BELT",
	"LATIN LETTER SINOLOGICAL DOT",
	"LATIN CAPITAL LETTER N WITH DESCENDER",
	"LATIN SMALL LETTER N WITH DESCENDER",
	"LATIN CAPITAL LETTER C WITH BAR",
	"LATIN SMALL LETTER C WITH BAR",
	"LATIN SMALL LETTER C WITH PALATAL HOOK",
	"LATIN SMALL LETTER H WITH PALATAL HOOK",
	"LATIN CAPITAL LETTER B WITH FLOURISH",
	"LATIN SMALL LETTER B WITH FLOURISH",
	"LATIN CAPITAL LETTER F WITH STROKE",
	"LATIN SMALL LETTER F WITH STROKE",
	"LATIN CAPITAL LETTER VOLAPUK AE",
	"LATIN SMALL LETTER VOLAPUK AE",
	"LATIN CAPITAL LETTER VOLAPUK OE",
	"LATIN SMALL LETTER VOLAPUK OE",
	"LATIN CAPITAL LETTER VOLAPUK UE",
	"LATIN SMALL LETTER VOLAPUK UE",
	"LATIN CAPITAL LETTER G WITH OBLIQUE STROKE",
	"LATIN SMALL LETTER G WITH OBLIQUE STROKE",
	"LATIN CAPITAL LETTER K WITH OBLIQUE STROKE",
	"LATIN SMALL LETTER K WITH OBLIQUE STROKE",
	"LATIN CAPITAL LETTER N WITH OBLIQUE STROKE",
	"LATIN SMALL LETTER N WITH OBLIQUE STROKE",
	"LATIN CAPITAL LETTER R WITH OBLIQUE STROKE",
	"LATIN SMALL LETTER R WITH OBLIQUE STROKE",
	"LATIN CAPITAL LETTER S WITH OBLIQUE STROKE",
	"LATIN SMALL LETTER S WITH OBLIQUE STROKE",
	"LATIN CAPITAL LETTER H WITH HOOK",
	"LATIN CAPITAL LETTER REVERSED OPEN E",
	"LATIN CAPITAL LETTER SCRIPT G",
	"LATIN CAPITAL LETTER L WITH BELT",
	"LATIN CAPITAL LETTER SMALL CAPITAL I",
	"LATIN LETTER SMALL CAPITAL Q",
	"LATIN CAPITAL LETTER TURNED K",
	"LATIN CAPITAL LETTER TURNED T",
	"LATIN CAPITAL LETTER J WITH CROSSED-TAIL",
	"LATIN CAPITAL LETTER CHI",
	"LATIN CAPITAL LETTER BETA",
	"LATIN SMALL LETTER BETA",
	"LATIN CAPITAL LETTER OMEGA",
	"LATIN SMALL LETTER OMEGA",
	"LATIN CAPITAL LETTER U WITH STROKE",
	"LATIN SMALL LETTER U WITH STROKE",
	"LATIN CAPITAL LETTER GLOTTAL A",
	"LATIN SMALL LETTER GLOTTAL A",
	"LATIN CAPITAL LETTER GLOTTAL I",
	"LATIN SMALL LETTER GLOTTAL I",
	"LATIN CAPITAL LETTER GLOTTAL U",
	"LATIN SMALL LETTER GLOTTAL U",
	"LATIN CAPITAL LETTER OLD POLISH O",
	"LATIN SMALL LETTER OLD POLISH O",
	"LATIN CAPITAL LETTER ANGLICANA W",
	"LATIN SMALL LETTER ANGLICANA W",
	"LATIN CAPITAL LETTER C WITH PALATAL HOOK",
	"LATIN CAPITAL LETTER S WITH HOOK",
	"LATIN CAPITAL LETTER Z WITH PALATAL HOOK",
	"LATIN CAPITAL LETTER D WITH SHORT STROKE OVERLAY",
	"LATIN SMALL LETTER D WITH SHORT STROKE OVERLAY",
	"LATIN CAPITAL LETTER S WITH SHORT STROKE OVERLAY",
	"LATIN SMALL LETTER S WITH SHORT STROKE OVERLAY",
	"LATIN CAPITAL LETTER CLOSED INSULAR G",
	"LATIN SMALL LETTER CLOSED INSULAR G",
	"LATIN SMALL LETTER DOUBLE THORN",
	"LATIN SMALL LETTER DOUBLE WYNN",
	"LATIN CAPITAL LETTER MIDDLE SCOTS S",
	"LATIN SMALL LETTER MIDDLE SCOTS S",
	"LATIN CAPITAL LETTER SIGMOID S",
	"LATIN SMALL LETTER SIGMOID S",
	"MODIFIER LETTER CAPITAL C",
	"MODIFIER LETTER CAPITAL F",
	"MODIFIER LETTER CAPITAL Q",
	"LATIN CAPITAL LETTER REVERSED HALF H",
	"LATIN SMALL LETTER REVERSED HALF H",
	"LATIN EPIGRAPHIC LETTER SIDEWAYS I",
	"MODIFIER LETTER CAPITAL H WITH STROKE",
	"MODIFIER LETTER SMALL LIGATURE OE",
	"LATIN LETTER SMALL CAPITAL TURNED M",
	"LATIN EPIGRAPHIC LETTER REVERSED F",
	"LATIN EPIGRAPHIC LETTER REVERSED P",
	"LATIN EPIGRAPHIC LETTER INVERTED M",
	"LATIN EPIGRAPHIC LETTER I LONGA",
	"LATIN EPIGRAPHIC LETTER ARCHAIC M",
	"SYLOTI NAGRI LETTER A",
	"SYLOTI NAGRI LETTER I",
	"SYLOTI NAGRI SIGN DVISVARA",
	"SYLOTI NAGRI LETTER U",
	"SYLOTI NAGRI LETTER E",
	"SYLOTI NAGRI LETTER O",
	"SYLOTI NAGRI SIGN HASANTA",
	"SYLOTI NAGRI LETTER KO",
	"SYLOTI NAGRI LETTER KHO",
	"SYLOTI NAGRI LETTER GO",
	"SYLOTI NAGRI LETTER GHO",
	"SYLOTI NAGRI SIGN ANUSVARA",
	"SYLOTI NAGRI LETTER CO",
	"SYLOTI NAGRI LETTER CHO",
	"SYLOTI NAGRI LETTER JO",
	"SYLOTI NAGRI LETTER JHO",
	"SYLOTI NAGRI LETTER TTO",
	"SYLOTI NAGRI LETTER TTHO",
	"SYLOTI NAGRI LETTER DDO",
	"SYLOTI NAGRI LETTER DDHO",
	"SYLOTI NAGRI LETTER TO",
	"SYLOTI NAGRI LETTER THO",
	"SYLOTI NAGRI LETTER DO",
	"SYLOTI NAGRI LETTER DHO",
	"SYLOTI NAGRI LETTER NO",
	"SYLOTI NAGRI LETTER PO",
	"SYLOTI NAGRI LETTER PHO",
	"SYLOTI NAGRI LETTER BO",
	"SYLOTI NAGRI LETTER BHO",
	"SYLOTI NAGRI LETTER MO",
	"SYLOTI NAGRI LETTER RO",
	"SYLOTI NAGRI LETTER LO",
	"SYLOTI NAGRI LETTER RRO",
	"SYLOTI NAGRI LETTER SO",
	"SYLOTI NAGRI LETTER HO",
	"SYLOTI NAGRI VOWEL SIGN A",
	"SYLOTI NAGRI VOWEL SIGN I",
	"SYLOTI NAGRI VOWEL SIGN U",
	"SYLOTI NAGRI VOWEL SIGN E",
	"SYLOTI NAGRI VOWEL SIGN OO",
	"SYLOTI NAGRI POETRY MARK-1",
	"SYLOTI NAGRI POETRY MARK-2",
	"SYLOTI NAGRI POETRY MARK-3",
	"SYLOTI NAGRI POETRY MARK-4",
	"SYLOTI NAGRI SIGN ALTERNATE HASANTA",
	"NORTH INDIC FRACTION ONE QUARTER",
	"NORTH INDIC FRACTION ONE HALF",
	"NORTH INDIC FRACTION THREE QUARTERS",
	"NORTH INDIC FRACTION ONE SIXTEENTH",
	"NORTH INDIC FRACTION ONE EIGHTH",
	"NORTH INDIC FRACTION THREE SIXTEENTHS",
	"NORTH INDIC QUARTER MARK",
	"NORTH INDIC PLACEHOLDER MARK",
	"NORTH INDIC RUPEE MARK",
	"NORTH INDIC QUANTITY MARK",
	"PHAGS-PA LETTER KA",
	"PHAGS-PA LETTER KHA",
	"PHAGS-PA LETTER GA",
	"PHAGS-PA LETTER NGA",
	"PHAGS-PA LETTER CA",
	"PHAGS-PA LETTER CHA",
	"PHAGS-PA LETTER JA",
	"PHAGS-PA LETTER NYA",
	"PHAGS-PA LETTER TA",
	"PHAGS-PA LETTER THA",
	"PHAGS-PA LETTER DA",
	"PHAGS-PA LETTER NA",
	"PHAGS-PA LETTER PA",
	"PHAGS-PA LETTER PHA",
	"PHAGS-PA LETTER BA",
	"PHAGS-PA LETTER MA",
	"PHAGS-PA LETTER TSA",
	"PHAGS-PA LETTER TSHA",
	"PHAGS-PA LETTER DZA",
	"PHAGS-PA LETTER WA",
	"PHAGS-PA LETTER ZHA",
	"PHAGS-PA LETTER ZA",
	"PHAGS-PA LETTER SMALL A",
	"PHAGS-PA LETTER YA",
	"PHAGS-PA LETTER RA",
	"PHAGS-PA LETTER LA",
	"PHAGS-PA LETTER SHA",
	"PHAGS-PA LETTER SA",
	"PHAGS-PA LETTER HA",
	"PHAGS-PA LETTER A",
	"PHAGS-PA LETTER I",
	"PHAGS-PA LETTER U",
	"PHAGS-PA LETTER E",
	"PHAGS-PA LETTER O",
	"PHAGS-PA LETTER QA",
	"PHAGS-PA LETTER XA",
	"PHAGS-PA LETTER FA",
	"PHAGS-PA LETTER GGA",
	"PHAGS-PA LETTER EE",
	"PHAGS-PA SUBJOINED LETTER WA",
	"PHAGS-PA SUBJOINED LETTER YA",
	"PHAGS-PA LETTER TTA",
	"PHAGS-PA LETTER TTHA",
	"PHAGS-PA LETTER DDA",
	"PHAGS-PA LETTER NNA",
	"PHAGS-PA LETTER ALTERNATE YA",
	"PHAGS-PA LETTER VOICELESS SHA",
	"PHAGS-PA LETTER VOICED HA",
	"PHAGS-PA LETTER ASPIRATED FA",
	"PHAGS-PA SUBJOINED LETTER RA",
	"PHAGS-PA SUPERFIXED LETTER RA",
	"PHAGS-PA LETTER CANDRABINDU",
	"PHAGS-PA SINGLE HEAD MARK",
	"PHAGS-PA DOUBLE HEAD MARK",
	"PHAGS-PA MARK SHAD",
	"PHAGS-PA MARK DOUBLE SHAD",
	"SAURASHTRA SIGN ANUSVARA",
	"SAURASHTRA SIGN VISARGA",
	"SAURASHTRA LETTER A",
	"SAURASHTRA LETTER AA",
	"SAURASHTRA LETTER I",
	"SAURASHTRA LETTER II",
	"SAURASHTRA LETTER U",
	"SAURASHTRA LETTER UU",
	"SAURASHTRA LETTER VOCALIC R",
	"SAURASHTRA LETTER VOCALIC RR",
	"SAURASHTRA LETTER VOCALIC L",
	"SAURASHTRA LETTER VOCALIC LL",
	"SAURASHTRA LETTER E",
	"SAURASHTRA LETTER EE",
	"SAURASHTRA LETTER AI",
	"SAURASHTRA LETTER O",
	"SAURASHTRA LETTER OO",
	"SAURASHTRA LETTER AU",
	"SAURASHTRA LETTER KA",
	"SAURASHTRA LETTER KHA",
	"SAURASHTRA LETTER GA",
	"SAURASHTRA LETTER GHA",
	"SAURASHTRA LETTER NGA",
	"SAURASHTRA LETTER CA",
	"SAURASHTRA LETTER CHA",
	"SAURASHTRA LETTER JA",
	"SAURASHTRA LETTER JHA",
	"SAURASHTRA LETTER NYA",
	"SAURASHTRA LETTER TTA",
	"SAURASHTRA LETTER TTHA",
	"SAURASHTRA LETTER DDA",
	"SAURASHTRA LETTER DDHA",
	"SAURASHTRA LETTER NNA",
	"SAURASHTRA LETTER TA",
	"SAURASHTRA LETTER THA",
	"SAURASHTRA LETTER DA",
	"SAURASHTRA LETTER DHA",
	"SAURASHTRA LETTER NA",
	"SAURASHTRA LETTER PA",
	"SAURASHTRA LETTER PHA",
	"SAURASHTRA LETTER BA",
	"SAURASHTRA LETTER BHA",
	"SAURASHTRA LETTER MA",
	"SAURASHTRA LETTER YA",
	"SAURASHTRA LETTER RA",
	"SAURASHTRA LETTER LA",
	"SAURASHTRA LETTER VA",
	"SAURASHTRA LETTER SHA",
	"SAURASHTRA LETTER SSA",
	"SAURASHTRA LETTER SA",
	"SAURASHTRA LETTER HA",
	"SAURASHTRA LETTER LLA",
	"SAURASHTRA CONSONANT SIGN HAARU",
	"SAURASHTRA VOWEL SIGN AA",
	"SAURASHTRA VOWEL SIGN I",
	"SAURASHTRA VOWEL SIGN II",
	"SAURASHTRA VOWEL SIGN U",
	"SAURASHTRA VOWEL SIGN UU",
	"SAURASHTRA VOWEL SIGN VOCALIC R",
	"SAURASHTRA VOWEL SIGN VOCALIC RR",
	"SAURASHTRA VOWEL SIGN VOCALIC L",
	"SAURASHTRA VOWEL SIGN VOCALIC LL",
	"SAURASHTRA VOWEL SIGN E",
	"SAURASHTRA VOWEL SIGN EE",
	"SAURASHTRA VOWEL SIGN AI",
	"SAURASHTRA VOWEL SIGN O",
	"SAURASHTRA VOWEL SIGN OO",
	"SAURASHTRA VOWEL SIGN AU",
	"SAURASHTRA SIGN VIRAMA",
	"SAURASHTRA SIGN CANDRABINDU",
	"SAURASHTRA DANDA",
	"SAURASHTRA DOUBLE DANDA",
	"SAURASHTRA DIGIT ZERO",
	"SAURASHTRA DIGIT ONE",
	"SAURASHTRA DIGIT TWO",
	"SAURASHTRA DIGIT THREE",
	"SAURASHTRA DIGIT FOUR",
	"SAURASHTRA DIGIT FIVE",
	"SAURASHTRA DIGIT SIX",
	"SAURASHTRA DIGIT SEVEN",
	"SAURASHTRA DIGIT EIGHT",
	"SAURASHTRA DIGIT NINE",
	"COMBINING DEVANAGARI DIGIT ZERO",
	"COMBINING DEVANAGARI DIGIT ONE",
	"COMBINING DEVANAGARI DIGIT TWO",
	"COMBINING DEVANAGARI DIGIT THREE",
	"COMBINING DEVANAGARI DIGIT FOUR",
	"COMBINING DEVANAGARI DIGIT FIVE",
	"COMBINING DEVANAGARI DIGIT SIX",
	"COMBINING DEVANAGARI DIGIT SEVEN",
	"COMBINING DEVANAGARI DIGIT EIGHT",
	"COMBINING DEVANAGARI DIGIT NINE",
	"COMBINING DEVANAGARI LETTER A",
	"COMBINING DEVANAGARI LETTER U",
	"COMBINING DEVANAGARI LETTER KA",
	"COMBINING DEVANAGARI LETTER NA",
	"COMBINING DEVANAGARI LETTER PA",
	"COMBINING DEVANAGARI LETTER RA",
	"COMBINING DEVANAGARI LETTER VI",
	"COMBINING DEVANAGARI SIGN AVAGRAHA",
	"DEVANAGARI SIGN SPACING CANDRABINDU",
	"DEVANAGARI SIGN CANDRABINDU VIRAMA",
	"DEVANAGARI SIGN DOUBLE CANDRABINDU VIRAMA",
	"DEVANAGARI SIGN CANDRABINDU TWO",
	"DEVANAGARI SIGN CANDRABINDU THREE",
	"DEVANAGARI SIGN CANDRABINDU AVAGRAHA",
	"DEVANAGARI SIGN PUSHPIKA",
	"DEVANAGARI GAP FILLER",
	"DEVANAGARI CARET",
	"DEVANAGARI HEADSTROKE",
	"DEVANAGARI SIGN SIDDHAM",
	"DEVANAGARI JAIN OM",
	"DEVANAGARI LETTER AY",
	"DEVANAGARI VOWEL SIGN AY",
	"KAYAH LI DIGIT ZERO",
	"KAYAH LI DIGIT ONE",
	"KAYAH LI DIGIT TWO",
	"KAYAH LI DIGIT THREE",
	"KAYAH LI DIGIT FOUR",
	"KAYAH LI DIGIT FIVE",
	"KAYAH LI DIGIT SIX",
	"KAYAH LI DIGIT SEVEN",
	"KAYAH LI DIGIT EIGHT",
	"KAYAH LI DIGIT NINE",
	"KAYAH LI LETTER KA",
	"KAYAH LI LETTER KHA",
	"KAYAH LI LETTER GA",
	"KAYAH LI LETTER NGA",
	"KAYAH LI LETTER SA",
	"KAYAH LI LETTER SHA",
	"KAYAH LI LETTER ZA",
	"KAYAH LI LETTER NYA",
	"KAYAH LI LETTER TA",
	"KAYAH LI LETTER HTA",
	"KAYAH LI LETTER NA",
	"KAYAH LI LETTER PA",
	"KAYAH LI LETTER PHA",
	"KAYAH LI LETTER MA",
	"KAYAH LI LETTER DA",
	"KAYAH LI LETTER BA",
	"KAYAH LI LETTER RA",
	"KAYAH LI LETTER YA",
	"KAYAH LI LETTER LA",
	"KAYAH LI LETTER WA",
	"KAYAH LI LETTER THA",
	"KAYAH LI LETTER HA",
	"KAYAH LI LETTER VA",
	"KAYAH LI LETTER CA",
	"KAYAH LI LETTER A",
	"KAYAH LI LETTER OE",
	"KAYAH LI LETTER I",
	"KAYAH LI LETTER OO",
	"KAYAH LI VOWEL UE",
	"KAYAH LI VOWEL E",
	"KAYAH LI VOWEL U",
	"KAYAH LI VOWEL EE",
	"KAYAH LI VOWEL O",
	"KAYAH LI TONE PLOPHU",
	"KAYAH LI TONE CALYA",
	"KAYAH LI TONE CALYA PLOPHU",
	"KAYAH LI SIGN CWI",
	"KAYAH LI SIGN SHYA",
	"REJANG LETTER KA",
	"REJANG LETTER GA",
	"REJANG LETTER NGA",
	"REJANG LETTER TA",
	"REJANG LETTER DA",
	"REJANG LETTER NA",
	"REJANG LETTER PA",
	"REJANG LETTER BA",
	"REJANG LETTER MA",
	"REJANG LETTER CA",
	"REJANG LETTER JA",
	"REJANG LETTER NYA",
	"REJANG LETTER SA",
	"REJANG LETTER RA",
	"REJANG LETTER LA",
	"REJANG LETTER YA",
	"REJANG LETTER WA",
	"REJANG LETTER HA",
	"REJANG LETTER MBA",
	"REJANG LETTER NGGA",
	"REJANG LETTER NDA",
	"REJANG LETTER NYJA",
	"REJANG LETTER A",
	"REJANG VOWEL SIGN I",
	"REJANG VOWEL SIGN U",
	"REJANG VOWEL SIGN E",
	"REJANG VOWEL SIGN AI",
	"REJANG VOWEL SIGN O",
	"REJANG VOWEL SIGN AU",
	"REJANG VOWEL SIGN EU",
	"REJANG VOWEL SIGN EA",
	"REJANG CONSONANT SIGN NG",
	"REJANG CONSONANT SIGN N",
	"REJANG CONSONANT SIGN R",
	"REJANG CONSONANT SIGN H",
	"REJANG VIRAMA",
	"REJANG SECTION MARK",
	"HANGUL CHOSEONG TIKEUT-MIEUM",
	"HANGUL CHOSEONG TIKEUT-PIEUP",
	"HANGUL CHOSEONG TIKEUT-SIOS",
	"HANGUL CHOSEONG TIKEUT-CIEUC",
	"HANGUL CHOSEONG RIEUL-KIYEOK",
	"HANGUL CHOSEONG RIEUL-SSANGKIYEOK",
	"HANGUL CHOSEONG RIEUL-TIKEUT",
	"HANGUL CHOSEONG RIEUL-SSANGTIKEUT",
	"HANGUL CHOSEONG RIEUL-MIEUM",
	"HANGUL CHOSEONG RIEUL-PIEUP",
	"HANGUL CHOSEONG RIEUL-SSANGPIEUP",
	"HANGUL CHOSEONG RIEUL-KAPYEOUNPIEUP",
	"HANGUL CHOSEONG RIEUL-SIOS",
	"HANGUL CHOSEONG RIEUL-CIEUC",
	"HANGUL CHOSEONG RIEUL-KHIEUKH",
	"HANGUL CHOSEONG MIEUM-KIYEOK",
	"HANGUL CHOSEONG MIEUM-TIKEUT",
	"HANGUL CHOSEONG MIEUM-SIOS",
	"HANGUL CHOSEONG PIEUP-SIOS-THIEUTH",
	"HANGUL CHOSEONG PIEUP-KHIEUKH",
	"HANGUL CHOSEONG PIEUP-HIEUH",
	"HANGUL CHOSEONG SSANGSIOS-PIEUP",
	"HANGUL CHOSEONG IEUNG-RIEUL",
	"HANGUL CHOSEONG IEUNG-HIEUH",
	"HANGUL CHOSEONG SSANGCIEUC-HIEUH",
	"HANGUL CHOSEONG SSANGTHIEUTH",
	"HANGUL CHOSEONG PHIEUPH-HIEUH",
	"HANGUL CHOSEONG HIEUH-SIOS",
	"HANGUL CHOSEONG SSANGYEORINHIEUH",
	"JAVANESE SIGN PANYANGGA",
	"JAVANESE SIGN CECAK",
	"JAVANESE SIGN LAYAR",
	"JAVANESE SIGN WIGNYAN",
	"JAVANESE LETTER A",
	"JAVANESE LETTER I KAWI",
	"JAVANESE LETTER I",
	"JAVANESE LETTER II",
	"JAVANESE LETTER U",
	"JAVANESE LETTER PA CEREK",
	"JAVANESE LETTER NGA LELET",
	"JAVANESE LETTER NGA LELET RASWADI",
	"JAVANESE LETTER E",
	"JAVANESE LETTER AI",
	"JAVANESE LETTER O",
	"JAVANESE LETTER KA",
	"JAVANESE LETTER KA SASAK",
	"JAVANESE LETTER KA MURDA",
	"JAVANESE LETTER GA",
	"JAVANESE LETTER GA MURDA",
	"JAVANESE LETTER NGA",
	"JAVANESE LETTER CA",
	"JAVANESE LETTER CA MURDA",
	"JAVANESE LETTER JA",
	"JAVANESE LETTER NYA MURDA",
	"JAVANESE LETTER JA MAHAPRANA",
	"JAVANESE LETTER NYA",
	"JAVANESE LETTER TTA",
	"JAVANESE LETTER TTA MAHAPRANA",
	"JAVANESE LETTER DDA",
	"JAVANESE LETTER DDA MAHAPRANA",
	"JAVANESE LETTER NA MURDA",
	"JAVANESE LETTER TA",
	"JAVANESE LETTER TA MURDA",
	"JAVANESE LETTER DA",
	"JAVANESE LETTER DA MAHAPRANA",
	"JAVANESE LETTER NA",
	"JAVANESE LETTER PA",
	"JAVANESE LETTER PA MURDA",
	"JAVANESE LETTER BA",
	"JAVANESE LETTER BA MURDA",
	"JAVANESE LETTER MA",
	"JAVANESE LETTER YA",
	"JAVANESE LETTER RA",
	"JAVANESE LETTER RA AGUNG",
	"JAVANESE LETTER LA",
	"JAVANESE LETTER WA",
	"JAVANESE LETTER SA MURDA",
	"JAVANESE LETTER SA MAHAPRANA",
	"JAVANESE LETTER SA",
	"JAVANESE LETTER HA",
	"JAVANESE SIGN CECAK TELU",
	"JAVANESE VOWEL SIGN TARUNG",
	"JAVANESE VOWEL SIGN TOLONG",
	"JAVANESE VOWEL SIGN WULU",
	"JAVANESE VOWEL SIGN WULU MELIK",
	"JAVANESE VOWEL SIGN SUKU",
	"JAVANESE VOWEL SIGN SUKU MENDUT",
	"JAVANESE VOWEL SIGN TALING",
	"JAVANESE VOWEL SIGN DIRGA MURE",
	"JAVANESE VOWEL SIGN PEPET",
	"JAVANESE CONSONANT SIGN KERET",
	"JAVANESE CONSONANT SIGN PENGKAL",
	"JAVANESE CONSONANT SIGN CAKRA",
	"JAVANESE PANGKON",
	"JAVANESE LEFT RERENGGAN",
	"JAVANESE RIGHT RERENGGAN",
	"JAVANESE PADA ANDAP",
	"JAVANESE PADA MADYA",
	"JAVANESE PADA LUHUR",
	"JAVANESE PADA WINDU",
	"JAVANESE PADA PANGKAT",
	"JAVANESE PADA LINGSA",
	"JAVANESE PADA LUNGSI",
	"JAVANESE PADA ADEG",
	"JAVANESE PADA ADEG ADEG",
	"JAVANESE PADA PISELEH",
	"JAVANESE TURNED PADA PISELEH",
	"JAVANESE PANGRANGKEP",
	"JAVANESE DIGIT ZERO",
	"JAVANESE DIGIT ONE",
	"JAVANESE DIGIT TWO",
	"JAVANESE DIGIT THREE",
	"JAVANESE DIGIT FOUR",
	"JAVANESE DIGIT FIVE",
	"JAVANESE DIGIT SIX",
	"JAVANESE DIGIT SEVEN",
	"JAVANESE DIGIT EIGHT",
	"JAVANESE DIGIT NINE",
	"JAVANESE PADA TIRTA TUMETES",
	"JAVANESE PADA ISEN-ISEN",
	"MYANMAR LETTER SHAN GHA",
	"MYANMAR LETTER SHAN CHA",
	"MYANMAR LETTER SHAN JHA",
	"MYANMAR LETTER SHAN NNA",
	"MYANMAR LETTER SHAN BHA",
	"MYANMAR SIGN SHAN SAW",
	"MYANMAR MODIFIER LETTER SHAN REDUPLICATION",
	"MYANMAR LETTER TAI LAING NYA",
	"MYANMAR LETTER TAI LAING FA",
	"MYANMAR LETTER TAI LAING GA",
	"MYANMAR LETTER TAI LAING GHA",
	"MYANMAR LETTER TAI LAING JA",
	"MYANMAR LETTER TAI LAING JHA",
	"MYANMAR LETTER TAI LAING DDA",
	"MYANMAR LETTER TAI LAING DDHA",
	"MYANMAR LETTER TAI LAING NNA",
	"MYANMAR TAI LAING DIGIT ZERO",
	"MYANMAR TAI LAING DIGIT ONE",
	"MYANMAR TAI LAING DIGIT TWO",
	"MYANMAR TAI LAING DIGIT THREE",
	"MYANMAR TAI LAING DIGIT FOUR",
	"MYANMAR TAI LAING DIGIT FIVE",
	"MYANMAR TAI LAING DIGIT SIX",
	"MYANMAR TAI LAING DIGIT SEVEN",
	"MYANMAR TAI LAING DIGIT EIGHT",
	"MYANMAR TAI LAING DIGIT NINE",
	"MYANMAR LETTER TAI LAING LLA",
	"MYANMAR LETTER TAI LAING DA",
	"MYANMAR LETTER TAI LAING DHA",
	"MYANMAR LETTER TAI LAING BA",
	"MYANMAR LETTER TAI LAING BHA",
	"CHAM LETTER A",
	"CHAM LETTER I",
	"CHAM LETTER U",
	"CHAM LETTER E",
	"CHAM LETTER AI",
	"CHAM LETTER O",
	"CHAM LETTER KA",
	"CHAM LETTER KHA",
	"CHAM LETTER GA",
	"CHAM LETTER GHA",
	"CHAM LETTER NGUE",
	"CHAM LETTER NGA",
	"CHAM LETTER CHA",
	"CHAM LETTER CHHA",
	"CHAM LETTER JA",
	"CHAM LETTER JHA",
	"CHAM LETTER NHUE",
	"CHAM LETTER NHA",
	"CHAM LETTER NHJA",
	"CHAM LETTER TA",
	"CHAM LETTER THA",
	"CHAM LETTER DA",
	"CHAM LETTER DHA",
	"CHAM LETTER NUE",
	"CHAM LETTER NA",
	"CHAM LETTER DDA",
	"CHAM LETTER PA",
	"CHAM LETTER PPA",
	"CHAM LETTER PHA",
	"CHAM LETTER BA",
	"CHAM LETTER BHA",
	"CHAM LETTER MUE",
	"CHAM LETTER MA",
	"CHAM LETTER BBA",
	"CHAM LETTER YA",
	"CHAM LETTER RA",
	"CHAM LETTER LA",
	"CHAM LETTER VA",
	"CHAM LETTER SSA",
	"CHAM LETTER SA",
	"CHAM LETTER HA",
	"CHAM VOWEL SIGN AA",
	"CHAM VOWEL SIGN I",
	"CHAM VOWEL SIGN II",
	"CHAM VOWEL SIGN EI",
	"CHAM VOWEL SIGN U",
	"CHAM VOWEL SIGN OE",
	"CHAM VOWEL SIGN O",
	"CHAM VOWEL SIGN AI",
	"CHAM VOWEL SIGN AU",
	"CHAM VOWEL SIGN UE",
	"CHAM CONSONANT SIGN YA",
	"CHAM CONSONANT SIGN RA",
	"CHAM CONSONANT SIGN LA",
	"CHAM CONSONANT SIGN WA",
	"CHAM LETTER FINAL K",
	"CHAM LETTER FINAL G",
	"CHAM LETTER FINAL NG",
	"CHAM CONSONANT SIGN FINAL NG",
	"CHAM LETTER FINAL CH",
	"CHAM LETTER FINAL T",
	"CHAM LETTER FINAL N",
	"CHAM LETTER FINAL P",
	"CHAM LETTER FINAL Y",
	"CHAM LETTER FINAL R",
	"CHAM LETTER FINAL L",
	"CHAM LETTER FINAL SS",
	"CHAM CONSONANT SIGN FINAL M",
	"CHAM CONSONANT SIGN FINAL H",
	"CHAM DIGIT ZERO",
	"CHAM DIGIT ONE",
	"CHAM DIGIT TWO",
	"CHAM DIGIT THREE",
	"CHAM DIGIT FOUR",
	"CHAM DIGIT FIVE",
	"CHAM DIGIT SIX",
	"CHAM DIGIT SEVEN",
	"CHAM DIGIT EIGHT",
	"CHAM DIGIT NINE",
	"CHAM PUNCTUATION SPIRAL",
	"CHAM PUNCTUATION DANDA",
	"CHAM PUNCTUATION DOUBLE DANDA",
	"CHAM PUNCTUATION TRIPLE DANDA",
	"MYANMAR LETTER KHAMTI GA",
	"MYANMAR LETTER KHAMTI CA",
	"MYANMAR LETTER KHAMTI CHA",
	"MYANMAR LETTER KHAMTI JA",
	"MYANMAR LETTER KHAMTI JHA",
	"MYANMAR LETTER KHAMTI NYA",
	"MYANMAR LETTER KHAMTI TTA",
	"MYANMAR LETTER KHAMTI TTHA",
	"MYANMAR LETTER KHAMTI DDA",
	"MYANMAR LETTER KHAMTI DDHA",
	"MYANMAR LETTER KHAMTI DHA",
	"MYANMAR LETTER KHAMTI NA",
	"MYANMAR LETTER KHAMTI SA",
	"MYANMAR LETTER KHAMTI HA",
	"MYANMAR LETTER KHAMTI HHA",
	"MYANMAR LETTER KHAMTI FA",
	"MYANMAR MODIFIER LETTER KHAMTI REDUPLICATION",
	"MYANMAR LETTER KHAMTI XA",
	"MYANMAR LETTER KHAMTI ZA",
	"MYANMAR LETTER KHAMTI RA",
	"MYANMAR LOGOGRAM KHAMTI OAY",
	"MYANMAR LOGOGRAM KHAMTI QN",
	"MYANMAR LOGOGRAM KHAMTI HM",
	"MYANMAR SYMBOL AITON EXCLAMATION",
	"MYANMAR SYMBOL AITON ONE",
	"MYANMAR SYMBOL AITON TWO",
	"MYANMAR LETTER AITON RA",
	"MYANMAR SIGN PAO KAREN TONE",
	"MYANMAR SIGN TAI LAING TONE-2",
	"MYANMAR SIGN TAI LAING TONE-5",
	"MYANMAR LETTER SHWE PALAUNG CHA",
	"MYANMAR LETTER SHWE PALAUNG SHA",
	"TAI VIET LETTER LOW KO",
	"TAI VIET LETTER HIGH KO",
	"TAI VIET LETTER LOW KHO",
	"TAI VIET LETTER HIGH KHO",
	"TAI VIET LETTER LOW KHHO",
	"TAI VIET LETTER HIGH KHHO",
	"TAI VIET LETTER LOW GO",
	"TAI VIET LETTER HIGH GO",
	"TAI VIET LETTER LOW NGO",
	"TAI VIET LETTER HIGH NGO",
	"TAI VIET LETTER LOW CO",
	"TAI VIET LETTER HIGH CO",
	"TAI VIET LETTER LOW CHO",
	"TAI VIET LETTER HIGH CHO",
	"TAI VIET LETTER LOW SO",
	"TAI VIET LETTER HIGH SO",
	"TAI VIET LETTER LOW NYO",
	"TAI VIET LETTER HIGH NYO",
	"TAI VIET LETTER LOW DO",
	"TAI VIET LETTER HIGH DO",
	"TAI VIET LETTER LOW TO",
	"TAI VIET LETTER HIGH TO",
	"TAI VIET LETTER LOW THO",
	"TAI VIET LETTER HIGH THO",
	"TAI VIET LETTER LOW NO",
	"TAI VIET LETTER HIGH NO",
	"TAI VIET LETTER LOW BO",
	"TAI VIET LETTER HIGH BO",
	"TAI VIET LETTER LOW PO",
	"TAI VIET LETTER HIGH PO",
	"TAI VIET LETTER LOW PHO",
	"TAI VIET LETTER HIGH PHO",
	"TAI VIET LETTER LOW FO",
	"TAI VIET LETTER HIGH FO",
	"TAI VIET LETTER LOW MO",
	"TAI VIET LETTER HIGH MO",
	"TAI VIET LETTER LOW YO",
	"TAI VIET LETTER HIGH YO",
	"TAI VIET LETTER LOW RO",
	"TAI VIET LETTER HIGH RO",
	"TAI VIET LETTER LOW LO",
	"TAI VIET LETTER HIGH LO",
	"TAI VIET LETTER LOW VO",
	"TAI VIET LETTER HIGH VO",
	"TAI VIET LETTER LOW HO",
	"TAI VIET LETTER HIGH HO",
	"TAI VIET LETTER LOW O",
	"TAI VIET LETTER HIGH O",
	"TAI VIET MAI KANG",
	"TAI VIET VOWEL AA",
	"TAI VIET VOWEL I",
	"TAI VIET VOWEL UE",
	"TAI VIET VOWEL U",
	"TAI VIET VOWEL E",
	"TAI VIET VOWEL O",
	"TAI VIET MAI KHIT",
	"TAI VIET VOWEL IA",
	"TAI VIET VOWEL UEA",
	"TAI VIET VOWEL UA",
	"TAI VIET VOWEL AUE",
	"TAI VIET VOWEL AY",
	"TAI VIET VOWEL AN",
	"TAI VIET VOWEL AM",
	"TAI VIET TONE MAI EK",
	"TAI VIET TONE MAI NUENG",
	"TAI VIET TONE MAI THO",
	"TAI VIET TONE MAI SONG",
	"TAI VIET SYMBOL KON",
	"TAI VIET SYMBOL NUENG",
	"TAI VIET SYMBOL SAM",
	"TAI VIET SYMBOL HO HOI",
	"TAI VIET SYMBOL KOI KOI",
	"MEETEI MAYEK LETTER E",
	"MEETEI MAYEK LETTER O",
	"MEETEI MAYEK LETTER CHA",
	"MEETEI MAYEK LETTER NYA",
	"MEETEI MAYEK LETTER TTA",
	"MEETEI MAYEK LETTER TTHA",
	"MEETEI MAYEK LETTER DDA",
	"MEETEI MAYEK LETTER DDHA",
	"MEETEI MAYEK LETTER NNA",
	"MEETEI MAYEK LETTER SHA",
	"MEETEI MAYEK LETTER SSA",
	"MEETEI MAYEK VOWEL SIGN II",
	"MEETEI MAYEK VOWEL SIGN UU",
	"MEETEI MAYEK VOWEL SIGN AAI",
	"MEETEI MAYEK VOWEL SIGN AU",
	"MEETEI MAYEK VOWEL SIGN AAU",
	"MEETEI MAYEK CHEIKHAN",
	"MEETEI MAYEK AHANG KHUDAM",
	"MEETEI MAYEK ANJI",
	"MEETEI MAYEK SYLLABLE REPETITION MARK",
	"MEETEI MAYEK WORD REPETITION MARK",
	"MEETEI MAYEK VOWEL SIGN VISARGA",
	"MEETEI MAYEK VIRAMA",
	"ETHIOPIC SYLLABLE TTHU",
	"ETHIOPIC SYLLABLE TTHI",
	"ETHIOPIC SYLLABLE TTHAA",
	"ETHIOPIC SYLLABLE TTHEE",
	"ETHIOPIC SYLLABLE TTHE",
	"ETHIOPIC SYLLABLE TTHO",
	"ETHIOPIC SYLLABLE DDHU",
	"ETHIOPIC SYLLABLE DDHI",
	"ETHIOPIC SYLLABLE DDHAA",
	"ETHIOPIC SYLLABLE DDHEE",
	"ETHIOPIC SYLLABLE DDHE",
	"ETHIOPIC SYLLABLE DDHO",
	"ETHIOPIC SYLLABLE DZU",
	"ETHIOPIC SYLLABLE DZI",
	"ETHIOPIC SYLLABLE DZAA",
	"ETHIOPIC SYLLABLE DZEE",
	"ETHIOPIC SYLLABLE DZE",
	"ETHIOPIC SYLLABLE DZO",
	"ETHIOPIC SYLLABLE CCHHA",
	"ETHIOPIC SYLLABLE CCHHU",
	"ETHIOPIC SYLLABLE CCHHI",
	"ETHIOPIC SYLLABLE CCHHAA",
	"ETHIOPIC SYLLABLE CCHHEE",
	"ETHIOPIC SYLLABLE CCHHE",
	"ETHIOPIC SYLLABLE CCHHO",
	"ETHIOPIC SYLLABLE BBA",
	"ETHIOPIC SYLLABLE BBU",
	"ETHIOPIC SYLLABLE BBI",
	"ETHIOPIC SYLLABLE BBAA",
	"ETHIOPIC SYLLABLE BBEE",
	"ETHIOPIC SYLLABLE BBE",
	"ETHIOPIC SYLLABLE BBO",
	"LATIN SMALL LETTER BARRED ALPHA",
	"LATIN SMALL LETTER A REVERSED-SCHWA",
	"LATIN SMALL LETTER BLACKLETTER E",
	"LATIN SMALL LETTER BARRED E",
	"LATIN SMALL LETTER E WITH FLOURISH",
	"LATIN SMALL LETTER LENIS F",
	"LATIN SMALL LETTER SCRIPT G WITH CROSSED-TAIL",
	"LATIN SMALL LETTER L WITH INVERTED LAZY S",
	"LATIN SMALL LETTER L WITH DOUBLE MIDDLE TILDE",
	"LATIN SMALL LETTER L WITH MIDDLE RING",
	"LATIN SMALL LETTER M WITH CROSSED-TAIL",
	"LATIN SMALL LETTER N WITH CROSSED-TAIL",
	"LATIN SMALL LETTER ENG WITH CROSSED-TAIL",
	"LATIN SMALL LETTER BLACKLETTER O",
	"LATIN SMALL LETTER BLACKLETTER O WITH STROKE",
	"LATIN SMALL LETTER OPEN O WITH STROKE",
	"LATIN SMALL LETTER INVERTED OE",
	"LATIN SMALL LETTER TURNED OE WITH STROKE",
	"LATIN SMALL LETTER TURNED OE WITH HORIZONTAL STROKE",
	"LATIN SMALL LETTER TURNED O OPEN-O",
	"LATIN SMALL LETTER TURNED O OPEN-O WITH STROKE",
	"LATIN SMALL LETTER STIRRUP R",
	"LATIN LETTER SMALL CAPITAL R WITH RIGHT LEG",
	"LATIN SMALL LETTER R WITHOUT HANDLE",
	"LATIN SMALL LETTER DOUBLE R",
	"LATIN SMALL LETTER R WITH CROSSED-TAIL",
	"LATIN SMALL LETTER DOUBLE R WITH CROSSED-TAIL",
	"LATIN SMALL LETTER SCRIPT R",
	"LATIN SMALL LETTER SCRIPT R WITH RING",
	"LATIN SMALL LETTER BASELINE ESH",
	"LATIN SMALL LETTER U WITH SHORT RIGHT LEG",
	"LATIN SMALL LETTER U BAR WITH SHORT RIGHT LEG",
	"LATIN SMALL LETTER UI",
	"LATIN SMALL LETTER TURNED UI",
	"LATIN SMALL LETTER U WITH LEFT HOOK",
	"LATIN SMALL LETTER CHI",
	"LATIN SMALL LETTER CHI WITH LOW RIGHT RING",
	"LATIN SMALL LETTER CHI WITH LOW LEFT SERIF",
	"LATIN SMALL LETTER X WITH LOW RIGHT RING",
	"LATIN SMALL LETTER X WITH LONG LEFT LEG",
	"LATIN SMALL LETTER X WITH LONG LEFT LEG AND LOW RIGHT RING",
	"LATIN SMALL LETTER X WITH LONG LEFT LEG WITH SERIF",
	"LATIN SMALL LETTER Y WITH SHORT RIGHT LEG",
	"MODIFIER BREVE WITH INVERTED BREVE",
	"MODIFIER LETTER SMALL HENG",
	"MODIFIER LETTER SMALL L WITH INVERTED LAZY S",
	"MODIFIER LETTER SMALL L WITH MIDDLE TILDE",
	"MODIFIER LETTER SMALL U WITH LEFT HOOK",
	"LATIN SMALL LETTER SAKHA YAT",
	"LATIN SMALL LETTER IOTIFIED E",
	"LATIN SMALL LETTER OPEN OE",
	"LATIN SMALL LETTER UO",
	"LATIN SMALL LETTER INVERTED ALPHA",
	"GREEK LETTER SMALL CAPITAL OMEGA",
	"LATIN SMALL LETTER DZ DIGRAPH WITH RETROFLEX HOOK",
	"LATIN SMALL LETTER TS DIGRAPH WITH RETROFLEX HOOK",
	"LATIN SMALL LETTER TURNED R WITH MIDDLE TILDE",
	"MODIFIER LETTER SMALL TURNED W",
	"MODIFIER LETTER LEFT TACK",
	"MODIFIER LETTER RIGHT TACK",
	"CHEROKEE SMALL LETTER A",
	"CHEROKEE SMALL LETTER E",
	"CHEROKEE SMALL LETTER I",
	"CHEROKEE SMALL LETTER O",
	"CHEROKEE SMALL LETTER U",
	"CHEROKEE SMALL LETTER V",
	"CHEROKEE SMALL LETTER GA",
	"CHEROKEE SMALL LETTER KA",
	"CHEROKEE SMALL LETTER GE",
	"CHEROKEE SMALL LETTER GI",
	"CHEROKEE SMALL LETTER GO",
	"CHEROKEE SMALL LETTER GU",
	"CHEROKEE SMALL LETTER GV",
	"CHEROKEE SMALL LETTER HA",
	"CHEROKEE SMALL LETTER HE",
	"CHEROKEE SMALL LETTER HI",
	"CHEROKEE SMALL LETTER HO",
	"CHEROKEE SMALL LETTER HU",
	"CHEROKEE SMALL LETTER HV",
	"CHEROKEE SMALL LETTER LA",
	"CHEROKEE SMALL LETTER LE",
	"CHEROKEE SMALL LETTER LI",
	"CHEROKEE SMALL LETTER LO",
	"CHEROKEE SMALL LETTER LU",
	"CHEROKEE SMALL LETTER LV",
	"CHEROKEE SMALL LETTER MA",
	"CHEROKEE SMALL LETTER ME",
	"CHEROKEE SMALL LETTER MI",
	"CHEROKEE SMALL LETTER MO",
	"CHEROKEE SMALL LETTER MU",
	"CHEROKEE SMALL LETTER NA",
	"CHEROKEE SMALL LETTER HNA",
	"CHEROKEE SMALL LETTER NAH",
	"CHEROKEE SMALL LETTER NE",
	"CHEROKEE SMALL LETTER NI",
	"CHEROKEE SMALL LETTER NO",
	"CHEROKEE SMALL LETTER NU",
	"CHEROKEE SMALL LETTER NV",
	"CHEROKEE SMALL LETTER QUA",
	"CHEROKEE SMALL LETTER QUE",
	"CHEROKEE SMALL LETTER QUI",
	"CHEROKEE SMALL LETTER QUO",
	"CHEROKEE SMALL LETTER QUU",
	"CHEROKEE SMALL LETTER QUV",
	"CHEROKEE SMALL LETTER SA",
	"CHEROKEE SMALL LETTER S",
	"CHEROKEE SMALL LETTER SE",
	"CHEROKEE SMALL LETTER SI",
	"CHEROKEE SMALL LETTER SO",
	"CHEROKEE SMALL LETTER SU",
	"CHEROKEE SMALL LETTER SV",
	"CHEROKEE SMALL LETTER DA",
	"CHEROKEE SMALL LETTER TA",
	"CHEROKEE SMALL LETTER DE",
	"CHEROKEE SMALL LETTER TE",
	"CHEROKEE SMALL LETTER DI",
	"CHEROKEE SMALL LETTER TI",
	"CHEROKEE SMALL LETTER DO",
	"CHEROKEE SMALL LETTER DU",
	"CHEROKEE SMALL LETTER DV",
	"CHEROKEE SMALL LETTER DLA",
	"CHEROKEE SMALL LETTER TLA",
	"CHEROKEE SMALL LETTER TLE",
	"CHEROKEE SMALL LETTER TLI",
	"CHEROKEE SMALL LETTER TLO",
	"CHEROKEE SMALL LETTER TLU",
	"CHEROKEE SMALL LETTER TLV",
	"CHEROKEE SMALL LETTER TSA",
	"CHEROKEE SMALL LETTER TSE",
	"CHEROKEE SMALL LETTER TSI",
	"CHEROKEE SMALL LETTER TSO",
	"CHEROKEE SMALL LETTER TSU",
	"CHEROKEE SMALL LETTER TSV",
	"CHEROKEE SMALL LETTER WA",
	"CHEROKEE SMALL LETTER WE",
	"CHEROKEE SMALL LETTER WI",
	"CHEROKEE SMALL LETTER WO",
	"CHEROKEE SMALL LETTER WU",
	"CHEROKEE SMALL LETTER WV",
	"CHEROKEE SMALL LETTER YA",
	"MEETEI MAYEK LETTER KOK",
	"MEETEI MAYEK LETTER SAM",
	"MEETEI MAYEK LETTER LAI",
	"MEETEI MAYEK LETTER MIT",
	"MEETEI MAYEK LETTER PA",
	"MEETEI MAYEK LETTER NA",
	"MEETEI MAYEK LETTER CHIL",
	"MEETEI MAYEK LETTER TIL",
	"MEETEI MAYEK LETTER KHOU",
	"MEETEI MAYEK LETTER NGOU",
	"MEETEI MAYEK LETTER THOU",
	"MEETEI MAYEK LETTER WAI",
	"MEETEI MAYEK LETTER YANG",
	"MEETEI MAYEK LETTER HUK",
	"MEETEI MAYEK LETTER UN",
	"MEETEI MAYEK LETTER I",
	"MEETEI MAYEK LETTER PHAM",
	"MEETEI MAYEK LETTER ATIYA",
	"MEETEI MAYEK LETTER GOK",
	"MEETEI MAYEK LETTER JHAM",
	"MEETEI MAYEK LETTER RAI",
	"MEETEI MAYEK LETTER BA",
	"MEETEI MAYEK LETTER JIL",
	"MEETEI MAYEK LETTER DIL",
	"MEETEI MAYEK LETTER GHOU",
	"MEETEI MAYEK LETTER DHOU",
	"MEETEI MAYEK LETTER BHAM",
	"MEETEI MAYEK LETTER KOK LONSUM",
	"MEETEI MAYEK LETTER LAI LONSUM",
	"MEETEI MAYEK LETTER MIT LONSUM",
	"MEETEI MAYEK LETTER PA LONSUM",
	"MEETEI MAYEK LETTER NA LONSUM",
	"MEETEI MAYEK LETTER TIL LONSUM",
	"MEETEI MAYEK LETTER NGOU LONSUM",
	"MEETEI MAYEK LETTER I LONSUM",
	"MEETEI MAYEK VOWEL SIGN ONAP",
	"MEETEI MAYEK VOWEL SIGN INAP",
	"MEETEI MAYEK VOWEL SIGN ANAP",
	"MEETEI MAYEK VOWEL SIGN YENAP",
	"MEETEI MAYEK VOWEL SIGN SOUNAP",
	"MEETEI MAYEK VOWEL SIGN UNAP",
	"MEETEI MAYEK VOWEL SIGN CHEINAP",
	"MEETEI MAYEK VOWEL SIGN NUNG",
	"MEETEI MAYEK CHEIKHEI",
	"MEETEI MAYEK LUM IYEK",
	"MEETEI MAYEK APUN IYEK",
	"MEETEI MAYEK DIGIT ZERO",
	"MEETEI MAYEK DIGIT ONE",
	"MEETEI MAYEK DIGIT TWO",
	"MEETEI MAYEK DIGIT THREE",
	"MEETEI MAYEK DIGIT FOUR",
	"MEETEI MAYEK DIGIT FIVE",
	"MEETEI MAYEK DIGIT SIX",
	"MEETEI MAYEK DIGIT SEVEN",
	"MEETEI MAYEK DIGIT EIGHT",
	"MEETEI MAYEK DIGIT NINE",
	"<Hangul Syllable, First>",
	"<Hangul Syllable, Last>",
	"HANGUL JUNGSEONG O-YEO",
	"HANGUL JUNGSEONG O-O-I",
	"HANGUL JUNGSEONG YO-A",
	"HANGUL JUNGSEONG YO-AE",
	"HANGUL JUNGSEONG YO-EO",
	"HANGUL JUNGSEONG U-YEO",
	"HANGUL JUNGSEONG U-I-I",
	"HANGUL JUNGSEONG YU-AE",
	"HANGUL JUNGSEONG YU-O",
	"HANGUL JUNGSEONG EU-A",
	"HANGUL JUNGSEONG EU-EO",
	"HANGUL JUNGSEONG EU-E",
	"HANGUL JUNGSEONG EU-O",
	"HANGUL JUNGSEONG I-YA-O",
	"HANGUL JUNGSEONG I-YAE",
	"HANGUL JUNGSEONG I-YEO",
	"HANGUL JUNGSEONG I-YE",
	"HANGUL JUNGSEONG I-O-I",
	"HANGUL JUNGSEONG I-YO",
	"HANGUL JUNGSEONG I-YU",
	"HANGUL JUNGSEONG I-I",
	"HANGUL JUNGSEONG ARAEA-A",
	"HANGUL JUNGSEONG ARAEA-E",
	"HANGUL JONGSEONG NIEUN-RIEUL",
	"HANGUL JONGSEONG NIEUN-CHIEUCH",
	"HANGUL JONGSEONG SSANGTIKEUT",
	"HANGUL JONGSEONG SSANGTIKEUT-PIEUP",
	"HANGUL JONGSEONG TIKEUT-PIEUP",
	"HANGUL JONGSEONG TIKEUT-SIOS",
	"HANGUL JONGSEONG TIKEUT-SIOS-KIYEOK",
	"HANGUL JONGSEONG TIKEUT-CIEUC",
	"HANGUL JONGSEONG TIKEUT-CHIEUCH",
	"HANGUL JONGSEONG TIKEUT-THIEUTH",
	"HANGUL JONGSEONG RIEUL-SSANGKIYEOK",
	"HANGUL JONGSEONG RIEUL-KIYEOK-HIEUH",
	"HANGUL JONGSEONG SSANGRIEUL-KHIEUKH",
	"HANGUL JONGSEONG RIEUL-MIEUM-HIEUH",
	"HANGUL JONGSEONG RIEUL-PIEUP-TIKEUT",
	"HANGUL JONGSEONG RIEUL-PIEUP-PHIEUPH",
	"HANGUL JONGSEONG RIEUL-YESIEUNG",
	"HANGUL JONGSEONG RIEUL-YEORINHIEUH-HIEUH",
	"HANGUL JONGSEONG KAPYEOUNRIEUL",
	"HANGUL JONGSEONG MIEUM-NIEUN",
	"HANGUL JONGSEONG MIEUM-SSANGNIEUN",
	"HANGUL JONGSEONG SSANGMIEUM",
	"HANGUL JONGSEONG MIEUM-PIEUP-SIOS",
	"HANGUL JONGSEONG MIEUM-CIEUC",
	"HANGUL JONGSEONG PIEUP-TIKEUT",
	"HANGUL JONGSEONG PIEUP-RIEUL-PHIEUPH",
	"HANGUL JONGSEONG PIEUP-MIEUM",
	"HANGUL JONGSEONG SSANGPIEUP",
	"HANGUL JONGSEONG PIEUP-SIOS-TIKEUT",
	"HANGUL JONGSEONG PIEUP-CIEUC",
	"HANGUL JONGSEONG PIEUP-CHIEUCH",
	"HANGUL JONGSEONG SIOS-MIEUM",
	"HANGUL JONGSEONG SIOS-KAPYEOUNPIEUP",
	"HANGUL JONGSEONG SSANGSIOS-KIYEOK",
	"HANGUL JONGSEONG SSANGSIOS-TIKEUT",
	"HANGUL JONGSEONG SIOS-PANSIOS",
	"HANGUL JONGSEONG SIOS-CIEUC",
	"HANGUL JONGSEONG SIOS-CHIEUCH",
	"HANGUL JONGSEONG SIOS-THIEUTH",
	"HANGUL JONGSEONG SIOS-HIEUH",
	"HANGUL JONGSEONG PANSIOS-PIEUP",
	"HANGUL JONGSEONG PANSIOS-KAPYEOUNPIEUP",
	"HANGUL JONGSEONG YESIEUNG-MIEUM",
	"HANGUL JONGSEONG YESIEUNG-HIEUH",
	"HANGUL JONGSEONG CIEUC-PIEUP",
	"HANGUL JONGSEONG CIEUC-SSANGPIEUP",
	"HANGUL JONGSEONG SSANGCIEUC",
	"HANGUL JONGSEONG PHIEUPH-SIOS",
	"HANGUL JONGSEONG PHIEUPH-THIEUTH",
	"<Non Private Use High Surrogate, First>",
	"<Non Private Use High Surrogate, Last>",
	"<Private Use High Surrogate, First>",
	"<Private Use High Surrogate, Last>",
	"<Low Surrogate, First>",
	"<Low Surrogate, Last>",
	"<Private Use, First>",
	"POMODORO DONE",
	"POMODORO ESTIMATED",
	"POMODORO TICKING",
	"POMODORO SQUASHED",
	"SHORT PAUSE",
	"LONG PAUSE",
	"AWAY",
	"PAIR PROGRAMMING",
	"INTERNAL INTERRUPTION",
	"EXTERNAL INTERRUPTION",
	"BRANCH",
	"LINE NUMBER",
	"HOSTNAME READONLY",
	"COLUMN NUMBER",
	"LEFT HARD DIVIDER",
	"LEFT SOFT DIVIDER",
	"RIGHT HARD DIVIDER",
	"RIGHT SOFT DIVIDER",
	"RIGHT HALF CIRCLE THICK",
	"RIGHT HALF CIRCLE THIN",
	"LEFT HALF CIRCLE THICK",
	"LEFT HALF CIRCLE THIN",
	"LOWER LEFT TRIANGLE",
	"BACKSLASH SEPARATOR",
	"LOWER RIGHT TRIANGLE",
	"FORWARDSLASH SEPARATOR",
	"UPPER LEFT TRIANGLE",
	"FORWARDSLASH SEPARATOR REDUNDANT",
	"UPPER RIGHT TRIANGLE",
	"BACKSLASH SEPARATOR REDUNDANT",
	"FLAME THICK",
	"FLAME THIN",
	"FLAME THICK MIRRORED",
	"FLAME THIN MIRRORED",
	"PIXELATED SQUARES SMALL",
	"PIXELATED SQUARES SMALL MIRRORED",
	"PIXELATED SQUARES BIG",
	"PIXELATED SQUARES BIG MIRRORED",
	"ICE WAVEFORM",
	"ICE WAVEFORM MIRRORED",
	"HONEYCOMB",
	"HONEYCOMB OUTLINE",
	"LEGO SEPARATOR",
	"LEGO SEPARATOR THIN",
	"LEGO BLOCK FACING",
	"LEGO BLOCK SIDEWAYS",
	"TRAPEZOID TOP BOTTOM",
	"TRAPEZOID TOP BOTTOM MIRRORED",
	"SMALLER",
	"SNOWING",
	"SODA",
	"SOFA",
	"SOUP",
	"SPERMATOZOON",
	"SPIN DOUBLE",
	"STOMACH",
	"STORM",
	"TELESCOPE",
	"THERMOMETER",
	"THERMOMETER HIGH",
	"THERMOMETER LOW",
	"THIN CLOSE",
	"TOILET",
	"TOOLS",
	"TOOTH",
	"UTERUS",
	"W3C",
	"WALKING",
	"VIRUS",
	"TELEGRAM CIRCLE",
	"SLASH",
	"TELEGRAM",
	"SHIRT",
	"TACOS",
	"SUSHI",
	"TRIANGLE RULER",
	"TREE",
	"SUN CLOUD",
	"RUBY O",
	"RULER",
	"UMBRELLA",
	"MEDICINE",
	"MICROSCOPE",
	"MILK BOTTLE",
	"MINIMIZE",
	"MOLECULE",
	"MOON CLOUD",
	"MUSHROOM",
	"MUSTACHE",
	"MYSQL",
	"NINTENDO",
	"PALETTE COLOR",
	"PI",
	"PIZZA",
	"PLANET",
	"PLANT",
	"PLAYSTATION",
	"POISON",
	"POPCORN",
	"POPSICLE",
	"PULSE",
	"PYTHON",
	"QUORA CIRCLE",
	"QUORA SQUARE",
	"RADIOACTIVE",
	"RAINING",
	"REAL HEART",
	"REFRIGERATOR",
	"RESTORE",
	"RING",
	"RUBY",
	"FINGERPRINT",
	"FLOPPY",
	"FOOTPRINT",
	"FREECODECAMP",
	"GALAXY",
	"GALERY",
	"GLASS",
	"GOOGLE DRIVE",
	"GOOGLE PLAY",
	"GPS",
	"GRAV",
	"GUITAR",
	"GUT",
	"HALTER",
	"HAMBURGER",
	"HAT",
	"HEXAGON",
	"HIGH HEEL",
	"HOTDOG",
	"ICE CREAM",
	"ID CARD",
	"IMDB",
	"INFINITY",
	"JAVA",
	"LAYERS",
	"LIPS",
	"LIPSTICK",
	"LIVER",
	"LUNG",
	"MAKEUP BRUSHES",
	"MAXIMIZE",
	"WALLET",
	"CHESS HORSE",
	"CHESS KING",
	"CHESS PAWN",
	"CHESS QUEEN",
	"CHESS TOWER",
	"CHEESE",
	"CHILLI",
	"CHIP",
	"CICLING",
	"CLOUD",
	"COCKROACH",
	"COFFE BEANS",
	"COINS",
	"COMB",
	"COMET",
	"CROWN",
	"CUP COFFE",
	"DICE",
	"DISCO",
	"DNA",
	"DONUT",
	"DRESS",
	"DROP",
	"ELLO",
	"ENVELOPE OPEN",
	"ENVELOPE OPEN O",
	"EQUAL",
	"EQUAL BIGGER",
	"FEEDLY",
	"FILE EXPORT",
	"FILE IMPORT",
	"WIND",
	"ATOM",
	"BACTERIA",
	"BANANA",
	"BATH",
	"BED",
	"BENZENE",
	"BIGGER",
	"BIOHAZARD",
	"BLOGGER CIRCLE",
	"BLOGGER SQUARE",
	"BONES",
	"BOOK OPEN",
	"BOOK OPEN O",
	"BRAIN",
	"BREAD",
	"BUTTERFLY",
	"CAROT",
	"CC BY",
	"CC CC",
	"CC NC",
	"CC NC EU",
	"CC NC JP",
	"CC ND",
	"CC REMIX",
	"CC SA",
	"CC SHARE",
	"CC ZERO",
	"CHECKLIST O",
	"CHERRY",
	"CHESS BISHOP",
	"XBOX",
	"APPLE FRUIT",
	"CHICKEN THIGH",
	"GIFT CARD",
	"INJECTION",
	"ISLE",
	"LOLLIPOP",
	"LOYALTY CARD",
	"MEAT",
	"MOUNTAINS",
	"ORANGE",
	"PEACH",
	"PEAR",
	"DAY CLOUDY GUSTS",
	"DAY CLOUDY WINDY",
	"DAY CLOUDY",
	"DAY FOG",
	"DAY HAIL",
	"DAY LIGHTNING",
	"DAY RAIN MIX",
	"DAY RAIN WIND",
	"DAY RAIN",
	"DAY SHOWERS",
	"DAY SNOW",
	"DAY SPRINKLE",
	"DAY SUNNY OVERCAST",
	"DAY SUNNY",
	"DAY STORM SHOWERS",
	"DAY THUNDERSTORM",
	"CLOUDY GUSTS",
	"CLOUDY WINDY",
	"CLOUDY",
	"FOG",
	"HAIL",
	"LIGHTNING",
	"RAIN MIX",
	"RAIN WIND",
	"RAIN",
	"SHOWERS",
	"SNOW",
	"SPRINKLE",
	"STORM SHOWERS",
	"THUNDERSTORM",
	"WINDY",
	"NIGHT ALT CLOUDY GUSTS",
	"NIGHT ALT CLOUDY WINDY",
	"NIGHT ALT HAIL",
	"NIGHT ALT LIGHTNING",
	"NIGHT ALT RAIN MIX",
	"NIGHT ALT RAIN WIND",
	"NIGHT ALT RAIN",
	"NIGHT ALT RAIN MIX",
	"NIGHT ALT SNOW",
	"NIGHT ALT SPRINKLE",
	"NIGHT ALT STORM SHOWERS",
	"NIGHT ALT THUNDERSTORM",
	"NIGHT CLEAR",
	"NIGHT CLOUDY GUSTS",
	"NIGHT CLOUDY WINDY",
	"NIGHT CLOUDY",
	"NIGHT HAIL",
	"NIGHT LIGHTNING",
	"NIGHT RAIN MIX",
	"NIGHT RAIN WIND",
	"NIGHT RAIN",
	"NIGHT SHOWERS",
	"NIGHT SNOW",
	"NIGHT SPRINKLE",
	"NIGHT STORM SHOWERS",
	"NIGHT THUNDERSTORM",
	"CELSIUS",
	"CLOUD DOWN",
	"CLOUD REFRESH",
	"CLOUD UP",
	"CLOUD",
	"DEGREES",
	"DIRECTION DOWN LEFT",
	"DIRECTION DOWN",
	"FAHRENHEIT",
	"HORIZON ALT",
	"HORIZON",
	"DIRECTION LEFT",
	"ALIENS",
	"NIGHT FOG",
	"REFRESH ALT",
	"REFRESH",
	"DIRECTION RIGHT",
	"RAINDROPS",
	"STRONG WIND",
	"SUNRISE",
	"SUNSET",
	"THERMOMETER EXTERIOR",
	"THERMOMETER INTERNAL",
	"THERMOMETER",
	"TORNADO",
	"DIRECTION UP RIGHT",
	"DIRECTION UP",
	"WIND WEST",
	"WIND SOUTH WEST",
	"WIND SOUTH EAST",
	"WIND SOUTH",
	"WIND NORTH WEST",
	"WIND NORTH EAST",
	"WIND NORTH",
	"WIND EAST",
	"SMOKE",
	"DUST",
	"SNOW WIND",
	"DAY SNOW WIND",
	"NIGHT SNOW WIND",
	"NIGHT ALT SNOW WIND",
	"DAY SLEET STORM",
	"NIGHT SLEET STORM",
	"NIGHT ALT SLEET STORM",
	"DAY SNOW THUNDERSTORM",
	"NIGHT SNOW THUNDERSTORM",
	"NIGHT ALT SNOW THUNDERSTORM",
	"SOLAR ECLIPSE",
	"LUNAR ECLIPSE",
	"METEOR",
	"HOT",
	"HURRICANE",
	"SMOG",
	"ALIEN",
	"SNOWFLAKE COLD",
	"STARS",
	"RAINDROP",
	"BAROMETER",
	"HUMIDITY",
	"NA",
	"FLOOD",
	"DAY CLOUDY HIGH",
	"NIGHT ALT CLOUDY HIGH",
	"NIGHT CLOUDY HIGH",
	"NIGHT ALT PARTLY CLOUDY",
	"SANDSTORM",
	"NIGHT PARTLY CLOUDY",
	"UMBRELLA",
	"DAY WINDY",
	"NIGHT ALT CLOUDY",
	"DIRECTION UP LEFT",
	"DIRECTION DOWN RIGHT",
	"TIME 12",
	"TIME 1",
	"TIME 2",
	"TIME 3",
	"TIME 4",
	"TIME 5",
	"TIME 6",
	"TIME 7",
	"TIME 8",
	"TIME 9",
	"TIME 10",
	"TIME 11",
	"MOON NEW",
	"MOON WAXING CRESCENT 1",
	"MOON WAXING CRESCENT 2",
	"MOON WAXING CRESCENT 3",
	"MOON WAXING CRESCENT 4",
	"MOON WAXING CRESCENT 5",
	"MOON WAXING CRESCENT 6",
	"MOON FIRST QUARTER",
	"MOON WAXING GIBBOUS 1",
	"MOON WAXING GIBBOUS 2",
	"MOON WAXING GIBBOUS 3",
	"MOON WAXING GIBBOUS 4",
	"MOON WAXING GIBBOUS 5",
	"MOON WAXING GIBBOUS 6",
	"MOON FULL",
	"MOON WANING GIBBOUS 1",
	"MOON WANING GIBBOUS 2",
	"MOON WANING GIBBOUS 3",
	"MOON WANING GIBBOUS 4",
	"MOON WANING GIBBOUS 5",
	"MOON WANING GIBBOUS 6",
	"MOON THIRD QUARTER",
	"MOON WANING CRESCENT 1",
	"MOON WANING CRESCENT 2",
	"MOON WANING CRESCENT 3",
	"MOON WANING CRESCENT 4",
	"MOON WANING CRESCENT 5",
	"MOON WANING CRESCENT 6",
	"WIND DIRECTION",
	"DAY SLEET",
	"NIGHT SLEET",
	"NIGHT ALT SLEET",
	"SLEET",
	"DAY HAZE",
	"WIND BEAUFORT 0",
	"WIND BEAUFORT 1",
	"WIND BEAUFORT 2",
	"WIND BEAUFORT 3",
	"WIND BEAUFORT 4",
	"WIND BEAUFORT 5",
	"WIND BEAUFORT 6",
	"WIND BEAUFORT 7",
	"WIND BEAUFORT 8",
	"WIND BEAUFORT 9",
	"WIND BEAUFORT 10",
	"WIND BEAUFORT 11",
	"WIND BEAUFORT 12",
	"DAY LIGHT WIND",
	"TSUNAMI",
	"EARTHQUAKE",
	"FIRE",
	"VOLCANO",
	"MOONRISE",
	"MOONSET",
	"TRAIN",
	"SMALL CRAFT ADVISORY",
	"GALE WARNING",
	"STORM WARNING",
	"HURRICANE WARNING",
	"MOON ALT WAXING CRESCENT 1",
	"MOON ALT WAXING CRESCENT 2",
	"MOON ALT WAXING CRESCENT 3",
	"MOON ALT WAXING CRESCENT 4",
	"MOON ALT WAXING CRESCENT 5",
	"MOON ALT WAXING CRESCENT 6",
	"MOON ALT FIRST QUARTER",
	"MOON ALT WAXING GIBBOUS 1",
	"MOON ALT WAXING GIBBOUS 2",
	"MOON ALT WAXING GIBBOUS 3",
	"MOON ALT WAXING GIBBOUS 4",
	"MOON ALT WAXING GIBBOUS 5",
	"MOON ALT WAXING GIBBOUS 6",
	"MOON ALT FULL",
	"MOON ALT WANING GIBBOUS 1",
	"MOON ALT WANING GIBBOUS 2",
	"MOON ALT WANING GIBBOUS 3",
	"MOON ALT WANING GIBBOUS 4",
	"MOON ALT WANING GIBBOUS 5",
	"MOON ALT WANING GIBBOUS 6",
	"MOON ALT THIRD QUARTER",
	"MOON ALT WANING CRESCENT 1",
	"MOON ALT WANING CRESCENT 2",
	"MOON ALT WANING CRESCENT 3",
	"MOON ALT WANING CRESCENT 4",
	"MOON ALT WANING CRESCENT 5",
	"MOON ALT WANING CRESCENT 6",
	"MOON ALT NEW",
	"FOLDER NPM",
	"FOLDER GIT BRANCH",
	"FOLDER CONFIG",
	"FOLDER GITHUB",
	"FOLDER OPEN",
	"FOLDER",
	"STYLUS",
	"PROJECT",
	"PLAY ARROW",
	"SASS",
	"RAILS",
	"RUBY",
	"PYTHON",
	"HEROKU",
	"PHP",
	"MARKDOWN",
	"LICENSE",
	"JSON LESS",
	"JAVASCRIPT",
	"IMAGE",
	"HTML",
	"MUSTACHE",
	"GULP",
	"GRUNT",
	"TEXT",
	"FOLDER",
	"CSS",
	"CONFIG",
	"NPM",
	"HOME",
	"EJS",
	"XML",
	"BOWER",
	"COFFEE CJSX",
	"TWIG",
	"CPP",
	"C",
	"HASKELL",
	"LUA",
	"LINE DOTTED GUIDE",
	"KARMA",
	"FAVICON",
	"JULIA",
	"REACT",
	"GO",
	"GO",
	"TYPESCRIPT",
	"MSDOS",
	"WINDOWS",
	"VIM",
	"ELM",
	"ELIXIR",
	"ELECTRON",
	"CRYSTAL",
	"PURESCRIPT",
	"PUPPET",
	"EMACS",
	"ORGMODE",
	"KOTLIN",
	"BING SMALL",
	"CSS TRICKS",
	"GIT",
	"BITBUCKET",
	"MYSQL",
	"STREAMLINE",
	"DATABASE",
	"DROPBOX",
	"GITHUB ALT",
	"GITHUB BADGE",
	"GITHUB",
	"WORDPRESS",
	"VISUALSTUDIO",
	"JEKYLL SMALL",
	"ANDROID",
	"WINDOWS",
	"STACKOVERFLOW",
	"APPLE",
	"LINUX",
	"APPSTORE",
	"GHOST SMALL",
	"YAHOO",
	"CODEPEN",
	"GITHUB FULL",
	"NODEJS SMALL",
	"NODEJS",
	"HACKERNEWS",
	"EMBER",
	"DOJO",
	"DJANGO",
	"NPM",
	"GHOST",
	"MODERNIZR",
	"UNITY SMALL",
	"RASBERRY PI",
	"BLACKBERRY",
	"GO",
	"GIT BRANCH",
	"GIT PULL REQUEST",
	"GIT MERGE",
	"GIT COMPARE",
	"GIT COMMIT",
	"CSSDECK",
	"YAHOO SMALL",
	"TECHCRUNCH",
	"SMASHING MAGAZINE",
	"NETMAGAZINE",
	"CODROPS",
	"PHONEGAP",
	"GOOGLE DRIVE",
	"HTML5 MULTIMEDIA",
	"HTML5 DEVICE ACCESS",
	"HTML5 CONNECTIVITY",
	"HTML5 3D EFFECTS",
	"HTML5",
	"SCALA",
	"JAVA",
	"RUBY",
	"UBUNTU",
	"RUBY ON RAILS",
	"PYTHON",
	"PHP",
	"MARKDOWN",
	"LARAVEL",
	"MAGENTO",
	"JOOMLA",
	"DRUPAL",
	"CHROME",
	"IE",
	"FIREFOX",
	"OPERA",
	"BOOTSTRAP",
	"SAFARI",
	"CSS3",
	"CSS3 FULL",
	"SASS",
	"GRUNT",
	"BOWER",
	"JAVASCRIPT",
	"JAVASCRIPT SHIELD",
	"JQUERY",
	"COFFEESCRIPT",
	"BACKBONE",
	"ANGULAR",
	"JQUERY UI",
	"SWIFT",
	"SYMFONY",
	"SYMFONY BADGE",
	"LESS",
	"STYLUS",
	"TRELLO",
	"ATLASSIAN",
	"JIRA",
	"ENVATO",
	"SNAP SVG",
	"RAPHAEL",
	"CHART",
	"COMPASS",
	"ONEDRIVE",
	"GULP",
	"ATOM",
	"CISCO",
	"NANCY",
	"JENKINS",
	"CLOJURE",
	"PERL",
	"CLOJURE ALT",
	"CELLULOID",
	"W3C",
	"REDIS",
	"POSTGRESQL",
	"WEBPLATFORM",
	"REQUIREJS",
	"OPENSOURCE",
	"TYPO3",
	"UIKIT",
	"DOCTRINE",
	"GROOVY",
	"NGINX",
	"HASKELL",
	"ZEND",
	"GNU",
	"YEOMAN",
	"HEROKU",
	"MSQL SERVER",
	"DEBIAN",
	"TRAVIS",
	"DOTNET",
	"CODEIGNITER",
	"JAVASCRIPT BADGE",
	"YII",
	"COMPOSER",
	"KRAKENJS BADGE",
	"KRAKENJS",
	"MOZILLA",
	"FIREBASE",
	"SIZZLEJS",
	"CREATIVECOMMONS",
	"CREATIVECOMMONS BADGE",
	"MITLICENCE",
	"SENCHATOUCH",
	"BUGSENSE",
	"EXTJS",
	"MOOTOOLS BADGE",
	"MOOTOOLS",
	"RUBY ROUGH",
	"KOMODO",
	"CODA",
	"BINTRAY",
	"TERMINAL",
	"CODE",
	"RESPONSIVE",
	"DART",
	"APTANA",
	"MAILCHIMP",
	"NETBEANS",
	"DREAMWEAVER",
	"BRACKETS",
	"ECLIPSE",
	"CLOUD9",
	"SCRUM",
	"PROLOG",
	"TERMINAL BADGE",
	"CODE BADGE",
	"MONGODB",
	"METEOR",
	"METEORFULL",
	"FSHARP",
	"RUST",
	"IONIC",
	"SUBLIME",
	"APPCELERATOR",
	"ASTERISK",
	"AWS",
	"DIGITAL OCEAN",
	"DLANG",
	"DOCKER",
	"ERLANG",
	"GOOGLE CLOUD PLATFORM",
	"GRAILS",
	"ILLUSTRATOR",
	"INTELLIJ",
	"MATERIALIZECSS",
	"OPENSHIFT",
	"PHOTOSHOP",
	"RACKSPACE",
	"REACT",
	"REDHAT",
	"SCRIPTCS",
	"SQLLITE",
	"VIM",
	"ADD",
	"LIGHTBULB",
	"REPO",
	"REPO FORKED",
	"GIT PULL REQUEST",
	"RECORD KEYS",
	"TAG",
	"PERSON",
	"SOURCE CONTROL",
	"MIRROR",
	"STAR EMPTY",
	"COMMENT",
	"WARNING",
	"SEARCH",
	"SIGN OUT",
	"SIGN IN",
	"EYE",
	"CIRCLE FILLED",
	"PRIMITIVE SQUARE",
	"EDIT",
	"INFO",
	"LOCK",
	"CLOSE",
	"SYNC",
	"DESKTOP DOWNLOAD",
	"BEAKER",
	"VM",
	"FILE",
	"ELLIPSIS",
	"REPLY",
	"ORGANIZATION",
	"NEW FILE",
	"NEW FOLDER",
	"TRASH",
	"HISTORY",
	"FOLDER",
	"GITHUB",
	"TERMINAL",
	"SYMBOL EVENT",
	"ERROR",
	"SYMBOL VARIABLE",
	"SYMBOL ARRAY",
	"SYMBOL NAMESPACE",
	"SYMBOL METHOD",
	"SYMBOL BOOLEAN",
	"SYMBOL NUMERIC",
	"SYMBOL STRUCTURE",
	"SYMBOL PARAMETER",
	"SYMBOL KEY",
	"GO TO FILE",
	"SYMBOL ENUM",
	"SYMBOL RULER",
	"ACTIVATE BREAKPOINTS",
	"ARCHIVE",
	"ARROW BOTH",
	"ARROW DOWN",
	"ARROW LEFT",
	"ARROW RIGHT",
	"ARROW SMALL DOWN",
	"ARROW SMALL LEFT",
	"ARROW SMALL RIGHT",
	"ARROW SMALL UP",
	"ARROW UP",
	"BELL",
	"BOLD",
	"BOOK",
	"BOOKMARK",
	"DEBUG BREAKPOINT CONDITIONAL UNVERIFIED",
	"DEBUG BREAKPOINT CONDITIONAL",
	"DEBUG BREAKPOINT DATA UNVERIFIED",
	"DEBUG BREAKPOINT DATA",
	"DEBUG BREAKPOINT LOG UNVERIFIED",
	"DEBUG BREAKPOINT LOG",
	"BRIEFCASE",
	"BROADCAST",
	"BROWSER",
	"BUG",
	"CALENDAR",
	"CASE SENSITIVE",
	"CHECK",
	"CHECKLIST",
	"CHEVRON DOWN",
	"CHEVRON LEFT",
	"CHEVRON RIGHT",
	"CHEVRON UP",
	"CHROME CLOSE",
	"CHROME MAXIMIZE",
	"CHROME MINIMIZE",
	"CHROME RESTORE",
	"CIRCLE",
	"CIRCLE SLASH",
	"CIRCUIT BOARD",
	"CLEAR ALL",
	"CLIPPY",
	"CLOSE ALL",
	"CLOUD DOWNLOAD",
	"CLOUD UPLOAD",
	"CODE",
	"COLLAPSE ALL",
	"COLOR MODE",
	"COMMENT DISCUSSION",
	"CREDIT CARD",
	"DASH",
	"DASHBOARD",
	"DATABASE",
	"DEBUG CONTINUE",
	"DEBUG DISCONNECT",
	"DEBUG PAUSE",
	"DEBUG RESTART",
	"DEBUG START",
	"DEBUG STEP INTO",
	"DEBUG STEP OUT",
	"DEBUG STEP OVER",
	"DEBUG STOP",
	"DEBUG",
	"DEVICE CAMERA VIDEO",
	"DEVICE CAMERA",
	"DEVICE MOBILE",
	"DIFF ADDED",
	"DIFF IGNORED",
	"DIFF MODIFIED",
	"DIFF REMOVED",
	"DIFF RENAMED",
	"DIFF",
	"DISCARD",
	"EDITOR LAYOUT",
	"EMPTY WINDOW",
	"EXCLUDE",
	"EXTENSIONS",
	"EYE CLOSED",
	"FILE BINARY",
	"FILE CODE",
	"FILE MEDIA",
	"FILE PDF",
	"FILE SUBMODULE",
	"FILE SYMLINK DIRECTORY",
	"FILE SYMLINK FILE",
	"FILE ZIP",
	"FILES",
	"FILTER",
	"FLAME",
	"FOLD DOWN",
	"FOLD UP",
	"FOLD",
	"FOLDER ACTIVE",
	"FOLDER OPENED",
	"GEAR",
	"GIFT",
	"GIST SECRET",
	"GIT COMMIT",
	"GIT COMPARE",
	"GIT MERGE",
	"GITHUB ACTION",
	"GITHUB ALT",
	"GLOBE",
	"GRABBER",
	"GRAPH",
	"GRIPPER",
	"HEART",
	"HOME",
	"HORIZONTAL RULE",
	"HUBOT",
	"INBOX",
	"ISSUE REOPENED",
	"ISSUES",
	"ITALIC",
	"JERSEY",
	"JSON",
	"KEBAB VERTICAL",
	"KEY",
	"LAW",
	"LIGHTBULB AUTOFIX",
	"LINK EXTERNAL",
	"LINK",
	"LIST ORDERED",
	"LIST UNORDERED",
	"LIVE SHARE",
	"LOADING",
	"LOCATION",
	"MAIL READ",
	"MAIL",
	"MARKDOWN",
	"MEGAPHONE",
	"MENTION",
	"MILESTONE",
	"MORTAR BOARD",
	"MOVE",
	"MULTIPLE WINDOWS",
	"MUTE",
	"NO NEWLINE",
	"NOTE",
	"OCTOFACE",
	"OPEN PREVIEW",
	"PACKAGE",
	"PAINTCAN",
	"PIN",
	"PLAY",
	"PLUG",
	"PRESERVE CASE",
	"PREVIEW",
	"PROJECT",
	"PULSE",
	"QUESTION",
	"QUOTE",
	"RADIO TOWER",
	"REACTIONS",
	"REFERENCES",
	"REFRESH",
	"REGEX",
	"REMOTE EXPLORER",
	"REMOTE",
	"REMOVE",
	"REPLACE ALL",
	"REPLACE",
	"REPO CLONE",
	"REPO FORCE PUSH",
	"REPO PULL",
	"REPO PUSH",
	"REPORT",
	"REQUEST CHANGES",
	"ROCKET",
	"ROOT FOLDER OPENED",
	"ROOT FOLDER",
	"RSS",
	"RUBY",
	"SAVE ALL",
	"SAVE AS",
	"SAVE",
	"SCREEN FULL",
	"SCREEN NORMAL",
	"SEARCH STOP",
	"SERVER",
	"SETTINGS GEAR",
	"SETTINGS",
	"SHIELD",
	"SMILEY",
	"SORT PRECEDENCE",
	"SPLIT HORIZONTAL",
	"SPLIT VERTICAL",
	"SQUIRREL",
	"STAR FULL",
	"STAR HALF",
	"SYMBOL CLASS",
	"SYMBOL COLOR",
	"SYMBOL CONSTANT",
	"SYMBOL ENUM MEMBER",
	"SYMBOL FIELD",
	"SYMBOL FILE",
	"SYMBOL INTERFACE",
	"SYMBOL KEYWORD",
	"SYMBOL MISC",
	"SYMBOL OPERATOR",
	"SYMBOL PROPERTY",
	"SYMBOL SNIPPET",
	"TASKLIST",
	"TELESCOPE",
	"TEXT SIZE",
	"THREE BARS",
	"THUMBSDOWN",
	"THUMBSUP",
	"TOOLS",
	"TRIANGLE DOWN",
	"TRIANGLE LEFT",
	"TRIANGLE RIGHT",
	"TRIANGLE UP",
	"TWITTER",
	"UNFOLD",
	"UNLOCK",
	"UNMUTE",
	"UNVERIFIED",
	"VERIFIED",
	"VERSIONS",
	"VM ACTIVE",
	"VM OUTLINE",
	"VM RUNNING",
	"WATCH",
	"WHITESPACE",
	"WHOLE WORD",
	"WINDOW",
	"WORD WRAP",
	"ZOOM IN",
	"ZOOM OUT",
	"LIST FILTER",
	"LIST FLAT",
	"LIST SELECTION",
	"LIST TREE",
	"DEBUG BREAKPOINT FUNCTION UNVERIFIED",
	"DEBUG BREAKPOINT FUNCTION",
	"DEBUG STACKFRAME ACTIVE",
	"CIRCLE SMALL FILLED",
	"DEBUG STACKFRAME",
	"DEBUG BREAKPOINT UNSUPPORTED",
	"SYMBOL STRING",
	"DEBUG REVERSE CONTINUE",
	"DEBUG STEP BACK",
	"DEBUG RESTART FRAME",
	"DEBUG ALT",
	"CALL INCOMING",
	"CALL OUTGOING",
	"MENU",
	"EXPAND ALL",
	"FEEDBACK",
	"GROUP BY REF TYPE",
	"UNGROUP BY REF TYPE",
	"ACCOUNT",
	"BELL DOT",
	"DEBUG CONSOLE",
	"LIBRARY",
	"OUTPUT",
	"RUN ALL",
	"SYNC IGNORED",
	"PINNED",
	"GITHUB INVERTED",
	"SERVER PROCESS",
	"SERVER ENVIRONMENT",
	"PASS",
	"STOP CIRCLE",
	"PLAY CIRCLE",
	"RECORD",
	"DEBUG ALT SMALL",
	"VM CONNECT",
	"CLOUD",
	"MERGE",
	"EXPORT",
	"GRAPH LEFT",
	"MAGNET",
	"NOTEBOOK",
	"REDO",
	"CHECK ALL",
	"PINNED DIRTY",
	"PASS FILLED",
	"CIRCLE LARGE FILLED",
	"CIRCLE LARGE",
	"COMBINE",
	"TABLE",
	"VARIABLE GROUP",
	"TYPE HIERARCHY",
	"TYPE HIERARCHY SUB",
	"TYPE HIERARCHY SUPER",
	"GIT PULL REQUEST CREATE",
	"RUN ABOVE",
	"RUN BELOW",
	"NOTEBOOK TEMPLATE",
	"DEBUG RERUN",
	"WORKSPACE TRUSTED",
	"WORKSPACE UNTRUSTED",
	"WORKSPACE UNKNOWN",
	"TERMINAL CMD",
	"TERMINAL DEBIAN",
	"TERMINAL LINUX",
	"TERMINAL POWERSHELL",
	"TERMINAL TMUX",
	"TERMINAL UBUNTU",
	"TERMINAL BASH",
	"ARROW SWAP",
	"COPY",
	"PERSON ADD",
	"FILTER FILLED",
	"WAND",
	"DEBUG LINE BY LINE",
	"INSPECT",
	"LAYERS",
	"LAYERS DOT",
	"LAYERS ACTIVE",
	"COMPASS",
	"COMPASS DOT",
	"COMPASS ACTIVE",
	"AZURE",
	"ISSUE DRAFT",
	"GIT PULL REQUEST CLOSED",
	"GIT PULL REQUEST DRAFT",
	"DEBUG ALL",
	"DEBUG COVERAGE",
	"RUN ERRORS",
	"FOLDER LIBRARY",
	"DEBUG CONTINUE SMALL",
	"BEAKER STOP",
	"GRAPH LINE",
	"GRAPH SCATTER",
	"PIE CHART",
	"BRACKET DOT",
	"BRACKET ERROR",
	"LOCK SMALL",
	"AZURE DEVOPS",
	"VERIFIED FILLED",
	"NEWLINE",
	"LAYOUT",
	"GLASS",
	"MUSIC",
	"SEARCH",
	"ENVELOPE O",
	"HEART",
	"STAR",
	"STAR O",
	"USER",
	"FILM",
	"TH LARGE",
	"TH",
	"TH LIST",
	"CHECK",
	"CLOSE REMOVE TIMES",
	"SEARCH PLUS",
	"SEARCH MINUS",
	"POWER OFF",
	"SIGNAL",
	"COG GEAR",
	"TRASH O",
	"HOME",
	"FILE O",
	"CLOCK O",
	"ROAD",
	"DOWNLOAD",
	"ARROW CIRCLE O DOWN",
	"ARROW CIRCLE O UP",
	"INBOX",
	"PLAY CIRCLE O",
	"REPEAT ROTATE RIGHT",
	"REFRESH",
	"LIST ALT",
	"LOCK",
	"FLAG",
	"HEADPHONES",
	"VOLUME OFF",
	"VOLUME DOWN",
	"VOLUME UP",
	"QRCODE",
	"BARCODE",
	"TAG",
	"TAGS",
	"BOOK",
	"BOOKMARK",
	"PRINT",
	"CAMERA",
	"FONT",
	"BOLD",
	"ITALIC",
	"TEXT HEIGHT",
	"TEXT WIDTH",
	"ALIGN LEFT",
	"ALIGN CENTER",
	"ALIGN RIGHT",
	"ALIGN JUSTIFY",
	"LIST",
	"DEDENT OUTDENT",
	"INDENT",
	"VIDEO CAMERA",
	"PICTURE O IMAGE PHOTO",
	"PENCIL",
	"MAP MARKER",
	"ADJUST",
	"TINT",
	"PENCIL SQUARE O EDIT",
	"SHARE SQUARE O",
	"CHECK SQUARE O",
	"ARROWS",
	"STEP BACKWARD",
	"FAST BACKWARD",
	"BACKWARD",
	"PLAY",
	"PAUSE",
	"STOP",
	"FORWARD",
	"FAST FORWARD",
	"STEP FORWARD",
	"EJECT",
	"CHEVRON LEFT",
	"CHEVRON RIGHT",
	"PLUS CIRCLE",
	"MINUS CIRCLE",
	"TIMES CIRCLE",
	"CHECK CIRCLE",
	"QUESTION CIRCLE",
	"INFO CIRCLE",
	"CROSSHAIRS",
	"TIMES CIRCLE O",
	"CHECK CIRCLE O",
	"BAN",
	"ARROW LEFT",
	"ARROW RIGHT",
	"ARROW UP",
	"ARROW DOWN",
	"SHARE MAIL FORWARD",
	"EXPAND",
	"COMPRESS",
	"PLUS",
	"MINUS",
	"ASTERISK",
	"EXCLAMATION CIRCLE",
	"GIFT",
	"LEAF",
	"FIRE",
	"EYE",
	"EYE SLASH",
	"EXCLAMATION TRIANGLE WARNING",
	"PLANE",
	"CALENDAR",
	"RANDOM",
	"COMMENT",
	"MAGNET",
	"CHEVRON UP",
	"CHEVRON DOWN",
	"RETWEET",
	"SHOPPING CART",
	"FOLDER",
	"FOLDER OPEN",
	"ARROWS V",
	"ARROWS H",
	"BAR CHART",
	"TWITTER SQUARE",
	"FACEBOOK SQUARE",
	"CAMERA RETRO",
	"KEY",
	"COGS GEARS",
	"COMMENTS",
	"THUMBS O UP",
	"THUMBS O DOWN",
	"STAR HALF",
	"HEART O",
	"SIGN OUT",
	"LINKEDIN SQUARE",
	"THUMB TACK",
	"EXTERNAL LINK",
	"SIGN IN",
	"TROPHY",
	"GITHUB SQUARE",
	"UPLOAD",
	"LEMON O",
	"PHONE",
	"SQUARE O",
	"BOOKMARK O",
	"PHONE SQUARE",
	"TWITTER",
	"FACEBOOK",
	"GITHUB",
	"UNLOCK",
	"CREDIT CARD",
	"RSS FEED",
	"HDD O",
	"BULLHORN",
	"BELL O",
	"CERTIFICATE",
	"HAND O RIGHT",
	"HAND O LEFT",
	"HAND O UP",
	"HAND O DOWN",
	"ARROW CIRCLE LEFT",
	"ARROW CIRCLE RIGHT",
	"ARROW CIRCLE UP",
	"ARROW CIRCLE DOWN",
	"GLOBE",
	"WRENCH",
	"TASKS",
	"FILTER",
	"BRIEFCASE",
	"ARROWS ALT",
	"USERS GROUP",
	"LINK CHAIN",
	"CLOUD",
	"FLASK",
	"SCISSORS CUT",
	"FILES O COPY",
	"PAPERCLIP",
	"FLOPPY O SAVE",
	"SQUARE",
	"BARS NAVICON REORDER",
	"LIST UL",
	"LIST OL",
	"STRIKETHROUGH",
	"UNDERLINE",
	"TABLE",
	"MAGIC",
	"TRUCK",
	"PINTEREST",
	"PINTEREST SQUARE",
	"GOOGLE PLUS SQUARE",
	"GOOGLE PLUS",
	"MONEY",
	"CARET DOWN",
	"CARET UP",
	"CARET LEFT",
	"CARET RIGHT",
	"COLUMNS",
	"SORT UNSORTED",
	"SORT DESC DOWN",
	"SORT ASC UP",
	"ENVELOPE",
	"LINKEDIN",
	"UNDO ROTATE LEFT",
	"GAVEL LEGAL",
	"TACHOMETER DASHBOARD",
	"COMMENT O",
	"COMMENTS O",
	"BOLT FLASH",
	"SITEMAP",
	"UMBRELLA",
	"CLIPBOARD PASTE",
	"LIGHTBULB O",
	"EXCHANGE",
	"CLOUD DOWNLOAD",
	"CLOUD UPLOAD",
	"USER MD",
	"STETHOSCOPE",
	"SUITCASE",
	"BELL",
	"COFFEE",
	"CUTLERY",
	"FILE TEXT O",
	"BUILDING O",
	"HOSPITAL O",
	"AMBULANCE",
	"MEDKIT",
	"FIGHTER JET",
	"BEER",
	"H SQUARE",
	"PLUS SQUARE",
	"ANGLE DOUBLE LEFT",
	"ANGLE DOUBLE RIGHT",
	"ANGLE DOUBLE UP",
	"ANGLE DOUBLE DOWN",
	"ANGLE LEFT",
	"ANGLE RIGHT",
	"ANGLE UP",
	"ANGLE DOWN",
	"DESKTOP",
	"LAPTOP",
	"TABLET",
	"MOBILE PHONE",
	"CIRCLE O",
	"QUOTE LEFT",
	"QUOTE RIGHT",
	"SPINNER",
	"CIRCLE",
	"MAIL REPLY",
	"GITHUB ALT",
	"FOLDER O",
	"FOLDER OPEN O",
	"SMILE O",
	"FROWN O",
	"MEH O",
	"GAMEPAD",
	"KEYBOARD O",
	"FLAG O",
	"FLAG CHECKERED",
	"TERMINAL",
	"CODE",
	"MAIL REPLY ALL",
	"STAR HALF O",
	"LOCATION ARROW",
	"CROP",
	"CODE FORK",
	"CHAIN BROKEN UNLINK",
	"QUESTION",
	"INFO",
	"EXCLAMATION",
	"SUPERSCRIPT",
	"SUBSCRIPT",
	"ERASER",
	"PUZZLE PIECE",
	"MICROPHONE",
	"MICROPHONE SLASH",
	"SHIELD",
	"CALENDAR O",
	"FIRE EXTINGUISHER",
	"ROCKET",
	"MAXCDN",
	"CHEVRON CIRCLE LEFT",
	"CHEVRON CIRCLE RIGHT",
	"CHEVRON CIRCLE UP",
	"CHEVRON CIRCLE DOWN",
	"HTML5",
	"CSS3",
	"ANCHOR",
	"UNLOCK ALT",
	"BULLSEYE",
	"ELLIPSIS H",
	"ELLIPSIS V",
	"RSS SQUARE",
	"PLAY CIRCLE",
	"TICKET",
	"MINUS SQUARE",
	"MINUS SQUARE O",
	"LEVEL UP",
	"LEVEL DOWN",
	"CHECK SQUARE",
	"PENCIL SQUARE",
	"EXTERNAL LINK SQUARE",
	"SHARE SQUARE",
	"COMPASS",
	"CARET SQUARE O DOWN",
	"CARET SQUARE O UP",
	"CARET SQUARE O RIGHT",
	"EUR EURO",
	"GBP",
	"USD DOLLAR",
	"INR RUPEE",
	"CNY RMB JPY YEN",
	"RUB ROUBLE",
	"KRW WON",
	"BTC BITCOIN",
	"FILE",
	"FILE TEXT",
	"SORT ALPHA ASC",
	"SORT ALPHA DESC",
	"SORT AMOUNT ASC",
	"SORT AMOUNT DESC",
	"SORT NUMERIC ASC",
	"SORT NUMERIC DESC",
	"THUMBS UP",
	"THUMBS DOWN",
	"YOUTUBE SQUARE",
	"YOUTUBE",
	"XING",
	"XING SQUARE",
	"YOUTUBE PLAY",
	"DROPBOX",
	"STACK OVERFLOW",
	"INSTAGRAM",
	"FLICKR",
	"ADN",
	"BITBUCKET",
	"BITBUCKET SQUARE",
	"TUMBLR",
	"TUMBLR SQUARE",
	"LONG ARROW DOWN",
	"LONG ARROW UP",
	"LONG ARROW LEFT",
	"LONG ARROW RIGHT",
	"APPLE",
	"WINDOWS",
	"ANDROID",
	"LINUX",
	"DRIBBBLE",
	"SKYPE",
	"FOURSQUARE",
	"TRELLO",
	"FEMALE",
	"MALE",
	"GRATIPAY",
	"SUN O",
	"MOON O",
	"ARCHIVE",
	"BUG",
	"VK",
	"WEIBO",
	"RENREN",
	"PAGELINES",
	"STACK EXCHANGE",
	"ARROW CIRCLE O RIGHT",
	"ARROW CIRCLE O LEFT",
	"CARET SQUARE O LEFT",
	"DOT CIRCLE O",
	"WHEELCHAIR",
	"VIMEO SQUARE",
	"TRY TURKISH LIRA",
	"PLUS SQUARE O",
	"SPACE SHUTTLE",
	"SLACK",
	"ENVELOPE SQUARE",
	"WORDPRESS",
	"OPENID",
	"UNIVERSITY INSTITUTION BANK",
	"GRADUATION CAP MORTAR BOARD",
	"YAHOO",
	"GOOGLE",
	"REDDIT",
	"REDDIT SQUARE",
	"STUMBLEUPON CIRCLE",
	"STUMBLEUPON",
	"DELICIOUS",
	"DIGG",
	"PIED PIPER PP",
	"PIED PIPER ALT",
	"DRUPAL",
	"JOOMLA",
	"LANGUAGE",
	"FAX",
	"BUILDING",
	"CHILD",
	"PAW",
	"SPOON",
	"CUBE",
	"CUBES",
	"BEHANCE",
	"BEHANCE SQUARE",
	"STEAM",
	"STEAM SQUARE",
	"RECYCLE",
	"CAR AUTOMOBILE",
	"TAXI CAB",
	"TREE",
	"SPOTIFY",
	"DEVIANTART",
	"SOUNDCLOUD",
	"DATABASE",
	"FILE PDF O",
	"FILE WORD O",
	"FILE EXCEL O",
	"FILE POWERPOINT O",
	"FILE IMAGE O PHOTO PICTURE",
	"FILE ARCHIVE O ZIP",
	"FILE AUDIO O SOUND",
	"FILE VIDEO O MOVIE",
	"FILE CODE O",
	"VINE",
	"CODEPEN",
	"JSFIDDLE",
	"LIFE RING SUPPORT",
	"CIRCLE O NOTCH",
	"REBEL",
	"EMPIRE",
	"GIT SQUARE",
	"GIT",
	"HACKER NEWS Y COMBINATOR",
	"TENCENT WEIBO",
	"QQ",
	"WEIXIN WECHAT",
	"PAPER PLANE SEND",
	"PAPER PLANE O SEND",
	"HISTORY",
	"CIRCLE THIN",
	"HEADER",
	"PARAGRAPH",
	"SLIDERS",
	"SHARE ALT",
	"SHARE ALT SQUARE",
	"BOMB",
	"FUTBOL O SOCCER BALL",
	"TTY",
	"BINOCULARS",
	"PLUG",
	"SLIDESHARE",
	"TWITCH",
	"YELP",
	"NEWSPAPER O",
	"WIFI",
	"CALCULATOR",
	"PAYPAL",
	"GOOGLE WALLET",
	"CC VISA",
	"CC MASTERCARD",
	"CC DISCOVER",
	"CC AMEX",
	"CC PAYPAL",
	"CC STRIPE",
	"BELL SLASH",
	"BELL SLASH O",
	"TRASH",
	"COPYRIGHT",
	"AT",
	"EYEDROPPER",
	"PAINT BRUSH",
	"BIRTHDAY CAKE",
	"AREA CHART",
	"PIE CHART",
	"LINE CHART",
	"LASTFM",
	"LASTFM SQUARE",
	"TOGGLE OFF",
	"TOGGLE ON",
	"BICYCLE",
	"BUS",
	"IOXHOST",
	"ANGELLIST",
	"CC",
	"ILS SHEKEL SHEQEL",
	"MEANPATH",
	"BUYSELLADS",
	"CONNECTDEVELOP",
	"DASHCUBE",
	"FORUMBEE",
	"LEANPUB",
	"SELLSY",
	"SHIRTSINBULK",
	"SIMPLYBUILT",
	"SKYATLAS",
	"CART PLUS",
	"CART ARROW DOWN",
	"DIAMOND",
	"SHIP",
	"USER SECRET",
	"MOTORCYCLE",
	"STREET VIEW",
	"HEARTBEAT",
	"VENUS",
	"MARS",
	"MERCURY",
	"INTERSEX TRANSGENDER",
	"TRANSGENDER ALT",
	"VENUS DOUBLE",
	"MARS DOUBLE",
	"VENUS MARS",
	"MARS STROKE",
	"MARS STROKE V",
	"MARS STROKE H",
	"NEUTER",
	"GENDERLESS",
	"FACEBOOK OFFICIAL",
	"PINTEREST P",
	"WHATSAPP",
	"SERVER",
	"USER PLUS",
	"USER TIMES",
	"BED HOTEL",
	"VIACOIN",
	"TRAIN",
	"SUBWAY",
	"MEDIUM",
	"Y COMBINATOR",
	"OPTIN MONSTER",
	"OPENCART",
	"EXPEDITEDSSL",
	"BATTERY FULL",
	"BATTERY THREE QUARTERS",
	"BATTERY HALF",
	"BATTERY QUARTER",
	"BATTERY EMPTY",
	"MOUSE POINTER",
	"I CURSOR",
	"OBJECT GROUP",
	"OBJECT UNGROUP",
	"STICKY NOTE",
	"STICKY NOTE O",
	"CC JCB",
	"CC DINERS CLUB",
	"CLONE",
	"BALANCE SCALE",
	"HOURGLASS O",
	"HOURGLASS START",
	"HOURGLASS HALF",
	"HOURGLASS END",
	"HOURGLASS",
	"HAND ROCK O",
	"HAND PAPER O",
	"HAND SCISSORS O",
	"HAND LIZARD O",
	"HAND SPOCK O",
	"HAND POINTER O",
	"HAND PEACE O",
	"TRADEMARK",
	"REGISTERED",
	"CREATIVE COMMONS",
	"GG",
	"GG CIRCLE",
	"TRIPADVISOR",
	"ODNOKLASSNIKI",
	"ODNOKLASSNIKI SQUARE",
	"GET POCKET",
	"WIKIPEDIA W",
	"SAFARI",
	"CHROME",
	"FIREFOX",
	"OPERA",
	"INTERNET EXPLORER",
	"TELEVISION TV",
	"CONTAO",
	"500PX",
	"AMAZON",
	"CALENDAR PLUS O",
	"CALENDAR MINUS O",
	"CALENDAR TIMES O",
	"CALENDAR CHECK O",
	"INDUSTRY",
	"MAP PIN",
	"MAP SIGNS",
	"MAP O",
	"MAP",
	"COMMENTING",
	"COMMENTING O",
	"HOUZZ",
	"VIMEO",
	"BLACK TIE",
	"FONTICONS",
	"REDDIT ALIEN",
	"EDGE",
	"CREDIT CARD ALT",
	"CODIEPIE",
	"MODX",
	"FORT AWESOME",
	"USB",
	"PRODUCT HUNT",
	"MIXCLOUD",
	"SCRIBD",
	"PAUSE CIRCLE",
	"PAUSE CIRCLE O",
	"STOP CIRCLE",
	"STOP CIRCLE O",
	"SHOPPING BAG",
	"SHOPPING BASKET",
	"HASHTAG",
	"BLUETOOTH",
	"BLUETOOTH B",
	"PERCENT",
	"GITLAB",
	"WPBEGINNER",
	"WPFORMS",
	"ENVIRA",
	"UNIVERSAL ACCESS",
	"WHEELCHAIR ALT",
	"QUESTION CIRCLE O",
	"BLIND",
	"AUDIO DESCRIPTION",
	"VOLUME CONTROL PHONE",
	"BRAILLE",
	"ASSISTIVE LISTENING SYSTEMS",
	"AMERICAN SIGN LANGUAGE INTERPRETING",
	"DEAF",
	"GLIDE",
	"GLIDE G",
	"SIGN LANGUAGE",
	"LOW VISION",
	"VIADEO",
	"VIADEO SQUARE",
	"SNAPCHAT",
	"SNAPCHAT GHOST",
	"SNAPCHAT SQUARE",
	"PIED PIPER",
	"FIRST ORDER",
	"YOAST",
	"THEMEISLE",
	"GOOGLE PLUS",
	"FONT AWESOME",
	"HANDSHAKE O",
	"ENVELOPE OPEN",
	"ENVELOPE OPEN O",
	"LINODE",
	"ADDRESS BOOK",
	"ADDRESS BOOK O",
	"ADDRESS CARD VCARD",
	"ADDRESS CARD O VCARD",
	"USER CIRCLE",
	"USER CIRCLE O",
	"USER O",
	"ID BADGE",
	"ID CARD",
	"ID CARD O",
	"QUORA",
	"FREE CODE CAMP",
	"TELEGRAM",
	"THERMOMETER FULL",
	"THERMOMETER THREE QUARTERS",
	"THERMOMETER HALF",
	"THERMOMETER QUARTER",
	"THERMOMETER EMPTY",
	"SHOWER",
	"BATH",
	"PODCAST",
	"WINDOW MAXIMIZE",
	"WINDOW MINIMIZE",
	"WINDOW RESTORE",
	"WINDOW CLOSE TIMES RECTANGLE",
	"WINDOW CLOSE O TIMES RECTANGLE",
	"BANDCAMP",
	"GRAV",
	"ETSY",
	"IMDB",
	"RAVELRY",
	"EERCAST",
	"MICROCHIP",
	"SNOWFLAKE O",
	"SUPERPOWERS",
	"WPEXPLORER",
	"MEETUP",
	"ALPINE",
	"AOSC",
	"APPLE",
	"ARCHLINUX",
	"CENTOS",
	"COREOS",
	"DEBIAN",
	"DEVUAN",
	"DOCKER",
	"ELEMENTARY",
	"FEDORA",
	"FEDORA INVERSE",
	"FREEBSD",
	"GENTOO",
	"LINUXMINT",
	"LINUXMINT INVERSE",
	"MAGEIA",
	"MANDRIVA",
	"MANJARO",
	"NIXOS",
	"OPENSUSE",
	"RASPBERRY PI",
	"REDHAT",
	"SABAYON",
	"SLACKWARE",
	"SLACKWARE INVERSE",
	"TUX",
	"UBUNTU",
	"UBUNTU INVERSE",
	"ALMALINUX",
	"ARCHLABS",
	"ARTIX",
	"BUDGIE",
	"DEEPIN",
	"ENDEAVOUR",
	"FERRIS",
	"FLATHUB",
	"GNU GUIX",
	"ILLUMOS",
	"KALI LINUX",
	"OPENBSD",
	"PARROT",
	"POP OS",
	"ROCKY LINUX",
	"SNAPPY",
	"SOLUS",
	"VOID",
	"ZORIN",
	"LIGHT BULB",
	"REPO",
	"REPO FORKED",
	"REPO PUSH",
	"REPO PULL",
	"BOOK",
	"OCTOFACE",
	"GIT PULL REQUEST",
	"MARK GITHUB",
	"CLOUD DOWNLOAD",
	"CLOUD UPLOAD",
	"KEYBOARD",
	"GIST",
	"FILE CODE",
	"FILE TEXT",
	"FILE MEDIA",
	"FILE ZIP",
	"FILE PDF",
	"TAG",
	"FILE DIRECTORY",
	"FILE SUBMODULE",
	"PERSON",
	"JERSEY",
	"GIT COMMIT",
	"GIT BRANCH",
	"GIT MERGE",
	"MIRROR",
	"ISSUE OPENED",
	"ISSUE REOPENED",
	"ISSUE CLOSED",
	"STAR",
	"COMMENT",
	"QUESTION",
	"ALERT",
	"SEARCH",
	"GEAR",
	"RADIO TOWER",
	"TOOLS",
	"SIGN OUT",
	"ROCKET",
	"RSS",
	"CLIPPY",
	"SIGN IN",
	"ORGANIZATION",
	"DEVICE MOBILE",
	"UNFOLD",
	"CHECK",
	"MAIL",
	"MAIL READ",
	"ARROW UP",
	"ARROW RIGHT",
	"ARROW DOWN",
	"ARROW LEFT",
	"PIN",
	"GIFT",
	"GRAPH",
	"TRIANGLE LEFT",
	"CREDIT CARD",
	"CLOCK",
	"RUBY",
	"BROADCAST",
	"KEY",
	"REPO FORCE PUSH",
	"REPO CLONE",
	"DIFF",
	"EYE",
	"COMMENT DISCUSSION",
	"MAIL REPLY",
	"PRIMITIVE DOT",
	"PRIMITIVE SQUARE",
	"DEVICE CAMERA",
	"DEVICE CAMERA VIDEO",
	"PENCIL",
	"INFO",
	"TRIANGLE RIGHT",
	"TRIANGLE DOWN",
	"LINK",
	"PLUS",
	"THREE BARS",
	"CODE",
	"LOCATION",
	"LIST UNORDERED",
	"LIST ORDERED",
	"QUOTE",
	"VERSIONS",
	"CALENDAR",
	"LOCK",
	"DIFF ADDED",
	"DIFF REMOVED",
	"DIFF MODIFIED",
	"DIFF RENAMED",
	"HORIZONTAL RULE",
	"ARROW SMALL RIGHT",
	"MILESTONE",
	"CHECKLIST",
	"MEGAPHONE",
	"CHEVRON RIGHT",
	"BOOKMARK",
	"SETTINGS",
	"DASHBOARD",
	"HISTORY",
	"LINK EXTERNAL",
	"MUTE",
	"X",
	"CIRCLE SLASH",
	"PULSE",
	"SYNC",
	"TELESCOPE",
	"GIST SECRET",
	"HOME",
	"STOP",
	"BUG",
	"LOGO GITHUB",
	"FILE BINARY",
	"DATABASE",
	"SERVER",
	"DIFF IGNORED",
	"ELLIPSIS",
	"NO NEWLINE",
	"HUBOT",
	"ARROW SMALL UP",
	"ARROW SMALL DOWN",
	"ARROW SMALL LEFT",
	"CHEVRON UP",
	"CHEVRON DOWN",
	"CHEVRON LEFT",
	"TRIANGLE UP",
	"GIT COMPARE",
	"LOGO GIST",
	"FILE SYMLINK FILE",
	"FILE SYMLINK DIRECTORY",
	"SQUIRREL",
	"GLOBE",
	"UNMUTE",
	"MENTION",
	"PACKAGE",
	"BROWSER",
	"TERMINAL",
	"MARKDOWN",
	"DASH",
	"FOLD",
	"INBOX",
	"TRASHCAN",
	"PAINTCAN",
	"FLAME",
	"BRIEFCASE",
	"PLUG",
	"CIRCUIT BOARD",
	"MORTAR BOARD",
	"LAW",
	"THUMBSUP",
	"THUMBSDOWN",
	"DESKTOP DOWNLOAD",
	"BEAKER",
	"BELL",
	"WATCH",
	"SHIELD",
	"BOLD",
	"TEXT SIZE",
	"ITALIC",
	"TASKLIST",
	"VERIFIED",
	"SMILEY",
	"UNVERIFIED",
	"ELLIPSES",
	"FILE",
	"GRABBER",
	"PLUS SMALL",
	"REPLY",
	"DEVICE DESKTOP",
	"VECTOR SQUARE",
	"ACCESS POINT",
	"ACCESS POINT NETWORK",
	"ACCOUNT",
	"ACCOUNT ALERT",
	"ACCOUNT BOX",
	"ACCOUNT BOX OUTLINE",
	"ACCOUNT CHECK",
	"ACCOUNT CIRCLE",
	"ACCOUNT CONVERT",
	"ACCOUNT KEY",
	"ACCOUNT LOCATION",
	"ACCOUNT MINUS",
	"ACCOUNT MULTIPLE",
	"ACCOUNT MULTIPLE OUTLINE",
	"ACCOUNT MULTIPLE PLUS",
	"ACCOUNT NETWORK",
	"ACCOUNT OFF",
	"ACCOUNT OUTLINE",
	"ACCOUNT PLUS",
	"ACCOUNT REMOVE",
	"ACCOUNT SEARCH",
	"ACCOUNT STAR",
	"ORBIT",
	"ACCOUNT SWITCH",
	"ADJUST",
	"AIR CONDITIONER",
	"AIRBALLOON",
	"AIRPLANE",
	"AIRPLANE OFF",
	"AIRPLAY",
	"ALARM",
	"ALARM CHECK",
	"ALARM MULTIPLE",
	"ALARM OFF",
	"ALARM PLUS",
	"ALBUM",
	"ALERT",
	"ALERT BOX",
	"ALERT CIRCLE",
	"ALERT OCTAGON",
	"ALERT OUTLINE",
	"ALPHA",
	"ALPHABETICAL",
	"AMAZON",
	"AMAZON CLOUDDRIVE",
	"AMBULANCE",
	"AMPLIFIER",
	"ANCHOR",
	"ANDROID",
	"ANDROID DEBUG BRIDGE",
	"ANDROID STUDIO",
	"APPLE",
	"APPLE FINDER",
	"APPLE IOS",
	"APPLE MOBILEME",
	"APPLE SAFARI",
	"FONT AWESOME",
	"APPS",
	"ARCHIVE",
	"ARRANGE BRING FORWARD",
	"ARRANGE BRING TO FRONT",
	"ARRANGE SEND BACKWARD",
	"ARRANGE SEND TO BACK",
	"ARROW ALL",
	"ARROW BOTTOM LEFT",
	"ARROW BOTTOM RIGHT",
	"ARROW COLLAPSE ALL",
	"ARROW DOWN",
	"ARROW DOWN THICK",
	"ARROW DOWN BOLD CIRCLE",
	"ARROW DOWN BOLD CIRCLE OUTLINE",
	"ARROW DOWN BOLD HEXAGON OUTLINE",
	"ARROW DOWN DROP CIRCLE",
	"ARROW DOWN DROP CIRCLE OUTLINE",
	"ARROW EXPAND ALL",
	"ARROW LEFT",
	"ARROW LEFT THICK",
	"ARROW LEFT BOLD CIRCLE",
	"ARROW LEFT BOLD CIRCLE OUTLINE",
	"ARROW LEFT BOLD HEXAGON OUTLINE",
	"ARROW LEFT DROP CIRCLE",
	"ARROW LEFT DROP CIRCLE OUTLINE",
	"ARROW RIGHT",
	"ARROW RIGHT THICK",
	"ARROW RIGHT BOLD CIRCLE",
	"ARROW RIGHT BOLD CIRCLE OUTLINE",
	"ARROW RIGHT BOLD HEXAGON OUTLINE",
	"ARROW RIGHT DROP CIRCLE",
	"ARROW RIGHT DROP CIRCLE OUTLINE",
	"ARROW TOP LEFT",
	"ARROW TOP RIGHT",
	"ARROW UP",
	"ARROW UP THICK",
	"ARROW UP BOLD CIRCLE",
	"ARROW UP BOLD CIRCLE OUTLINE",
	"ARROW UP BOLD HEXAGON OUTLINE",
	"ARROW UP DROP CIRCLE",
	"ARROW UP DROP CIRCLE OUTLINE",
	"ASSISTANT",
	"AT",
	"ATTACHMENT",
	"AUDIOBOOK",
	"AUTO FIX",
	"AUTO UPLOAD",
	"AUTORENEW",
	"AV TIMER",
	"BABY",
	"BACKBURGER",
	"BACKSPACE",
	"BACKUP RESTORE",
	"BANK",
	"BARCODE",
	"BARCODE SCAN",
	"BARLEY",
	"BARREL",
	"BASECAMP",
	"BASKET",
	"BASKET FILL",
	"BASKET UNFILL",
	"BATTERY",
	"BATTERY 10",
	"BATTERY 20",
	"BATTERY 30",
	"BATTERY 40",
	"BATTERY 50",
	"BATTERY 60",
	"BATTERY 70",
	"BATTERY 80",
	"BATTERY 90",
	"BATTERY ALERT",
	"BATTERY CHARGING",
	"BATTERY CHARGING 100",
	"BATTERY CHARGING 20",
	"BATTERY CHARGING 30",
	"BATTERY CHARGING 40",
	"BATTERY CHARGING 60",
	"BATTERY CHARGING 80",
	"BATTERY CHARGING 90",
	"BATTERY MINUS",
	"BATTERY NEGATIVE",
	"BATTERY OUTLINE",
	"BATTERY PLUS",
	"BATTERY POSITIVE",
	"BATTERY UNKNOWN",
	"BEACH",
	"FLASK",
	"FLASK EMPTY",
	"FLASK EMPTY OUTLINE",
	"FLASK OUTLINE",
	"BEATS",
	"BEER",
	"BEHANCE",
	"BELL",
	"BELL OFF",
	"BELL OUTLINE",
	"BELL PLUS",
	"BELL RING",
	"BELL RING OUTLINE",
	"BELL SLEEP",
	"BETA",
	"BIBLE",
	"BIKE",
	"BING",
	"BINOCULARS",
	"BIO",
	"BIOHAZARD",
	"BITBUCKET",
	"BLACK MESA",
	"BLACKBERRY",
	"BLENDER",
	"BLINDS",
	"BLOCK HELPER",
	"BLOGGER",
	"BLUETOOTH",
	"BLUETOOTH AUDIO",
	"BLUETOOTH CONNECT",
	"BLUETOOTH OFF",
	"BLUETOOTH SETTINGS",
	"BLUETOOTH TRANSFER",
	"BLUR",
	"BLUR LINEAR",
	"BLUR OFF",
	"BLUR RADIAL",
	"BONE",
	"BOOK",
	"BOOK MULTIPLE",
	"BOOK MULTIPLE VARIANT",
	"BOOK OPEN",
	"BOOK OPEN VARIANT",
	"BOOK VARIANT",
	"BOOKMARK",
	"BOOKMARK CHECK",
	"BOOKMARK MUSIC",
	"BOOKMARK OUTLINE",
	"BOOKMARK PLUS OUTLINE",
	"BOOKMARK PLUS",
	"BOOKMARK REMOVE",
	"BORDER ALL",
	"BORDER BOTTOM",
	"BORDER COLOR",
	"BORDER HORIZONTAL",
	"BORDER INSIDE",
	"BORDER LEFT",
	"BORDER NONE",
	"BORDER OUTSIDE",
	"BORDER RIGHT",
	"BORDER STYLE",
	"BORDER TOP",
	"BORDER VERTICAL",
	"BOWLING",
	"BOX",
	"BOX CUTTER",
	"BRIEFCASE",
	"BRIEFCASE CHECK",
	"BRIEFCASE DOWNLOAD",
	"BRIEFCASE UPLOAD",
	"BRIGHTNESS 1",
	"BRIGHTNESS 2",
	"BRIGHTNESS 3",
	"BRIGHTNESS 4",
	"BRIGHTNESS 5",
	"BRIGHTNESS 6",
	"BRIGHTNESS 7",
	"BRIGHTNESS AUTO",
	"BROOM",
	"BRUSH",
	"BUG",
	"BULLETIN BOARD",
	"BULLHORN",
	"BUS",
	"CACHED",
	"CAKE",
	"CAKE LAYERED",
	"CAKE VARIANT",
	"CALCULATOR",
	"CALENDAR",
	"CALENDAR BLANK",
	"CALENDAR CHECK",
	"CALENDAR CLOCK",
	"CALENDAR MULTIPLE",
	"CALENDAR MULTIPLE CHECK",
	"CALENDAR PLUS",
	"CALENDAR REMOVE",
	"CALENDAR TEXT",
	"CALENDAR TODAY",
	"CALL MADE",
	"CALL MERGE",
	"CALL MISSED",
	"CALL RECEIVED",
	"CALL SPLIT",
	"CAMCORDER",
	"CAMCORDER BOX",
	"CAMCORDER BOX OFF",
	"CAMCORDER OFF",
	"CAMERA",
	"CAMERA ENHANCE",
	"CAMERA FRONT",
	"CAMERA FRONT VARIANT",
	"CAMERA IRIS",
	"CAMERA PARTY MODE",
	"CAMERA REAR",
	"CAMERA REAR VARIANT",
	"CAMERA SWITCH",
	"CAMERA TIMER",
	"CANDYCANE",
	"CAR",
	"CAR BATTERY",
	"CAR CONNECTED",
	"CAR WASH",
	"CARROT",
	"CART",
	"CART OUTLINE",
	"CART PLUS",
	"CASE SENSITIVE ALT",
	"CASH",
	"CASH 100",
	"CASH MULTIPLE",
	"CASH USD",
	"CAST",
	"CAST CONNECTED",
	"CASTLE",
	"CAT",
	"CELLPHONE",
	"CELLPHONE ANDROID",
	"CELLPHONE BASIC",
	"CELLPHONE DOCK",
	"CELLPHONE IPHONE",
	"CELLPHONE LINK",
	"CELLPHONE LINK OFF",
	"CELLPHONE SETTINGS",
	"CERTIFICATE",
	"CHAIR SCHOOL",
	"CHART ARC",
	"CHART AREASPLINE",
	"CHART BAR",
	"CHART HISTOGRAM",
	"CHART LINE",
	"CHART PIE",
	"CHECK",
	"CHECK ALL",
	"CHECKBOX BLANK",
	"CHECKBOX BLANK CIRCLE",
	"CHECKBOX BLANK CIRCLE OUTLINE",
	"CHECKBOX BLANK OUTLINE",
	"CHECKBOX MARKED",
	"CHECKBOX MARKED CIRCLE",
	"CHECKBOX MARKED CIRCLE OUTLINE",
	"CHECKBOX MARKED OUTLINE",
	"CHECKBOX MULTIPLE BLANK",
	"CHECKBOX MULTIPLE BLANK OUTLINE",
	"CHECKBOX MULTIPLE MARKED",
	"CHECKBOX MULTIPLE MARKED OUTLINE",
	"CHECKERBOARD",
	"CHEMICAL WEAPON",
	"CHEVRON DOUBLE DOWN",
	"CHEVRON DOUBLE LEFT",
	"CHEVRON DOUBLE RIGHT",
	"CHEVRON DOUBLE UP",
	"CHEVRON DOWN",
	"CHEVRON LEFT",
	"CHEVRON RIGHT",
	"CHEVRON UP",
	"CHURCH",
	"CISCO WEBEX",
	"CITY",
	"CLIPBOARD",
	"CLIPBOARD ACCOUNT",
	"CLIPBOARD ALERT",
	"CLIPBOARD ARROW DOWN",
	"CLIPBOARD ARROW LEFT",
	"CLIPBOARD CHECK",
	"CLIPBOARD OUTLINE",
	"CLIPBOARD TEXT",
	"CLIPPY",
	"CLOCK",
	"CLOCK END",
	"CLOCK FAST",
	"CLOCK IN",
	"CLOCK OUT",
	"CLOCK START",
	"CLOSE",
	"CLOSE BOX",
	"CLOSE BOX OUTLINE",
	"CLOSE CIRCLE",
	"CLOSE CIRCLE OUTLINE",
	"CLOSE NETWORK",
	"CLOSE OCTAGON",
	"CLOSE OCTAGON OUTLINE",
	"CLOSED CAPTION",
	"CLOUD",
	"CLOUD CHECK",
	"CLOUD CIRCLE",
	"CLOUD DOWNLOAD",
	"CLOUD OUTLINE",
	"CLOUD OFF OUTLINE",
	"CLOUD PRINT",
	"CLOUD PRINT OUTLINE",
	"CLOUD UPLOAD",
	"CODE ARRAY",
	"CODE BRACES",
	"CODE BRACKETS",
	"CODE EQUAL",
	"CODE GREATER THAN",
	"CODE GREATER THAN OR EQUAL",
	"CODE LESS THAN",
	"CODE LESS THAN OR EQUAL",
	"CODE NOT EQUAL",
	"CODE NOT EQUAL VARIANT",
	"CODE PARENTHESES",
	"CODE STRING",
	"CODE TAGS",
	"CODEPEN",
	"COFFEE",
	"COFFEE TO GO",
	"COIN",
	"COLOR HELPER",
	"COMMENT",
	"COMMENT ACCOUNT",
	"COMMENT ACCOUNT OUTLINE",
	"COMMENT ALERT",
	"COMMENT ALERT OUTLINE",
	"COMMENT CHECK",
	"COMMENT CHECK OUTLINE",
	"COMMENT MULTIPLE OUTLINE",
	"COMMENT OUTLINE",
	"COMMENT PLUS OUTLINE",
	"COMMENT PROCESSING",
	"COMMENT PROCESSING OUTLINE",
	"COMMENT QUESTION OUTLINE",
	"COMMENT REMOVE OUTLINE",
	"COMMENT TEXT",
	"COMMENT TEXT OUTLINE",
	"COMPARE",
	"COMPASS",
	"COMPASS OUTLINE",
	"CONSOLE",
	"CONTACT MAIL",
	"CONTENT COPY",
	"CONTENT CUT",
	"CONTENT DUPLICATE",
	"CONTENT PASTE",
	"CONTENT SAVE",
	"CONTENT SAVE ALL",
	"CONTRAST",
	"CONTRAST BOX",
	"CONTRAST CIRCLE",
	"COOKIE",
	"COUNTER",
	"COW",
	"CREDIT CARD",
	"CREDIT CARD MULTIPLE",
	"CREDIT CARD SCAN",
	"CROP",
	"CROP FREE",
	"CROP LANDSCAPE",
	"CROP PORTRAIT",
	"CROP SQUARE",
	"CROSSHAIRS",
	"CROSSHAIRS GPS",
	"CROWN",
	"CUBE",
	"CUBE OUTLINE",
	"CUBE SEND",
	"CUBE UNFOLDED",
	"CUP",
	"CUP WATER",
	"CURRENCY BTC",
	"CURRENCY EUR",
	"CURRENCY GBP",
	"CURRENCY INR",
	"CURRENCY NGN",
	"CURRENCY RUB",
	"CURRENCY TRY",
	"CURRENCY USD",
	"CURSOR DEFAULT",
	"CURSOR DEFAULT OUTLINE",
	"CURSOR MOVE",
	"CURSOR POINTER",
	"DATABASE",
	"DATABASE MINUS",
	"DATABASE PLUS",
	"DEBUG STEP INTO",
	"DEBUG STEP OUT",
	"DEBUG STEP OVER",
	"DECIMAL DECREASE",
	"DECIMAL INCREASE",
	"DELETE",
	"DELETE VARIANT",
	"DELTA",
	"DESKPHONE",
	"DESKTOP MAC",
	"DESKTOP TOWER",
	"DETAILS",
	"DEVIANTART",
	"DIAMOND",
	"CREATION",
	"DICE 1",
	"DICE 2",
	"DICE 3",
	"DICE 4",
	"DICE 5",
	"DICE 6",
	"DIRECTIONS",
	"DISK ALERT",
	"DISQUS",
	"DISQUS OUTLINE",
	"DIVISION",
	"DIVISION BOX",
	"DNS",
	"DOMAIN",
	"DOTS HORIZONTAL",
	"DOTS VERTICAL",
	"DOWNLOAD",
	"DRAG",
	"DRAG HORIZONTAL",
	"DRAG VERTICAL",
	"DRAWING",
	"DRAWING BOX",
	"DRIBBBLE",
	"DRIBBBLE BOX",
	"DRONE",
	"DROPBOX",
	"DRUPAL",
	"DUCK",
	"DUMBBELL",
	"EARTH",
	"EARTH OFF",
	"EDGE",
	"EJECT",
	"ELEVATION DECLINE",
	"ELEVATION RISE",
	"ELEVATOR",
	"EMAIL",
	"EMAIL OPEN",
	"EMAIL OUTLINE",
	"EMAIL SECURE",
	"EMOTICON",
	"EMOTICON COOL",
	"EMOTICON DEVIL",
	"EMOTICON HAPPY",
	"EMOTICON NEUTRAL",
	"EMOTICON POOP",
	"EMOTICON SAD",
	"EMOTICON TONGUE",
	"ENGINE",
	"ENGINE OUTLINE",
	"EQUAL",
	"EQUAL BOX",
	"ERASER",
	"ESCALATOR",
	"ETHERNET",
	"ETHERNET CABLE",
	"ETHERNET CABLE OFF",
	"ETSY",
	"EVERNOTE",
	"EXCLAMATION",
	"EXIT TO APP",
	"EXPORT",
	"EYE",
	"EYE OFF",
	"EYEDROPPER",
	"EYEDROPPER VARIANT",
	"FACEBOOK",
	"FACEBOOK BOX",
	"FACEBOOK MESSENGER",
	"FACTORY",
	"FAN",
	"FAST FORWARD",
	"FAX",
	"FERRY",
	"FILE",
	"FILE CHART",
	"FILE CHECK",
	"FILE CLOUD",
	"FILE DELIMITED",
	"FILE DOCUMENT",
	"FILE DOCUMENT BOX",
	"FILE EXCEL",
	"FILE EXCEL BOX",
	"FILE EXPORT",
	"FILE FIND",
	"FILE IMAGE",
	"FILE IMPORT",
	"FILE LOCK",
	"FILE MULTIPLE",
	"FILE MUSIC",
	"FILE OUTLINE",
	"FILE PDF",
	"FILE PDF BOX",
	"FILE POWERPOINT",
	"FILE POWERPOINT BOX",
	"FILE PRESENTATION BOX",
	"FILE SEND",
	"FILE VIDEO",
	"FILE WORD",
	"FILE WORD BOX",
	"FILE XML",
	"FILM",
	"FILMSTRIP",
	"FILMSTRIP OFF",
	"FILTER",
	"FILTER OUTLINE",
	"FILTER REMOVE",
	"FILTER REMOVE OUTLINE",
	"FILTER VARIANT",
	"FINGERPRINT",
	"FIRE",
	"FIREFOX",
	"FISH",
	"FLAG",
	"FLAG CHECKERED",
	"FLAG OUTLINE",
	"FLAG VARIANT OUTLINE",
	"FLAG TRIANGLE",
	"FLAG VARIANT",
	"FLASH",
	"FLASH AUTO",
	"FLASH OFF",
	"FLASHLIGHT",
	"FLASHLIGHT OFF",
	"FLATTR",
	"FLIP TO BACK",
	"FLIP TO FRONT",
	"FLOPPY",
	"FLOWER",
	"FOLDER",
	"FOLDER ACCOUNT",
	"FOLDER DOWNLOAD",
	"FOLDER GOOGLE DRIVE",
	"FOLDER IMAGE",
	"FOLDER LOCK",
	"FOLDER LOCK OPEN",
	"FOLDER MOVE",
	"FOLDER MULTIPLE",
	"FOLDER MULTIPLE IMAGE",
	"FOLDER MULTIPLE OUTLINE",
	"FOLDER OUTLINE",
	"FOLDER PLUS",
	"FOLDER REMOVE",
	"FOLDER UPLOAD",
	"FOOD",
	"FOOD APPLE",
	"FOOD VARIANT",
	"FOOTBALL",
	"FOOTBALL AUSTRALIAN",
	"FOOTBALL HELMET",
	"FORMAT ALIGN CENTER",
	"FORMAT ALIGN JUSTIFY",
	"FORMAT ALIGN LEFT",
	"FORMAT ALIGN RIGHT",
	"FORMAT BOLD",
	"FORMAT CLEAR",
	"FORMAT COLOR FILL",
	"FORMAT FLOAT CENTER",
	"FORMAT FLOAT LEFT",
	"FORMAT FLOAT NONE",
	"FORMAT FLOAT RIGHT",
	"FORMAT HEADER 1",
	"FORMAT HEADER 2",
	"FORMAT HEADER 3",
	"FORMAT HEADER 4",
	"FORMAT HEADER 5",
	"FORMAT HEADER 6",
	"FORMAT HEADER DECREASE",
	"FORMAT HEADER EQUAL",
	"FORMAT HEADER INCREASE",
	"FORMAT HEADER POUND",
	"FORMAT INDENT DECREASE",
	"FORMAT INDENT INCREASE",
	"FORMAT ITALIC",
	"FORMAT LINE SPACING",
	"FORMAT LIST BULLETED",
	"FORMAT LIST BULLETED TYPE",
	"FORMAT LIST NUMBERS",
	"FORMAT PAINT",
	"FORMAT PARAGRAPH",
	"FORMAT QUOTE CLOSE",
	"FORMAT SIZE",
	"FORMAT STRIKETHROUGH",
	"FORMAT STRIKETHROUGH VARIANT",
	"FORMAT SUBSCRIPT",
	"FORMAT SUPERSCRIPT",
	"FORMAT TEXT",
	"FORMAT TEXTDIRECTION L TO R",
	"FORMAT TEXTDIRECTION R TO L",
	"FORMAT UNDERLINE",
	"FORMAT WRAP INLINE",
	"FORMAT WRAP SQUARE",
	"FORMAT WRAP TIGHT",
	"FORMAT WRAP TOP BOTTOM",
	"FORUM",
	"FORWARD",
	"FOURSQUARE",
	"FRIDGE",
	"FRIDGE FILLED",
	"FRIDGE FILLED BOTTOM",
	"FRIDGE FILLED TOP",
	"FULLSCREEN",
	"FULLSCREEN EXIT",
	"FUNCTION",
	"GAMEPAD",
	"GAMEPAD VARIANT",
	"GAS STATION",
	"GATE",
	"GAUGE",
	"GAVEL",
	"GENDER FEMALE",
	"GENDER MALE",
	"GENDER MALE FEMALE",
	"GENDER TRANSGENDER",
	"GHOST",
	"GIFT",
	"GIT",
	"GITHUB BOX",
	"GITHUB CIRCLE",
	"GLASS FLUTE",
	"GLASS MUG",
	"GLASS STANGE",
	"GLASS TULIP",
	"GLASSDOOR",
	"GLASSES",
	"GMAIL",
	"GNOME",
	"GOOGLE",
	"GOOGLE CARDBOARD",
	"GOOGLE CHROME",
	"GOOGLE CIRCLES",
	"GOOGLE CIRCLES COMMUNITIES",
	"GOOGLE CIRCLES EXTENDED",
	"GOOGLE CIRCLES GROUP",
	"GOOGLE CONTROLLER",
	"GOOGLE CONTROLLER OFF",
	"GOOGLE DRIVE",
	"GOOGLE EARTH",
	"GOOGLE GLASS",
	"GOOGLE NEARBY",
	"GOOGLE PAGES",
	"GOOGLE PHYSICAL WEB",
	"GOOGLE PLAY",
	"GOOGLE PLUS",
	"GOOGLE PLUS BOX",
	"GOOGLE TRANSLATE",
	"GOOGLE WALLET",
	"GRID",
	"GRID OFF",
	"GROUP",
	"GUITAR ELECTRIC",
	"GUITAR PICK",
	"GUITAR PICK OUTLINE",
	"HAND POINTING RIGHT",
	"HANGER",
	"HANGOUTS",
	"HARDDISK",
	"HEADPHONES",
	"HEADPHONES BOX",
	"HEADPHONES SETTINGS",
	"HEADSET",
	"HEADSET DOCK",
	"HEADSET OFF",
	"HEART",
	"HEART BOX",
	"HEART BOX OUTLINE",
	"HEART BROKEN",
	"HEART OUTLINE",
	"HELP",
	"HELP CIRCLE",
	"HEXAGON",
	"HEXAGON OUTLINE",
	"HISTORY",
	"HOLOLENS",
	"HOME",
	"HOME MODERN",
	"HOME VARIANT",
	"HOPS",
	"HOSPITAL",
	"HOSPITAL BUILDING",
	"HOSPITAL MARKER",
	"HOTEL",
	"HOUZZ",
	"HOUZZ BOX",
	"HUMAN",
	"HUMAN CHILD",
	"HUMAN MALE FEMALE",
	"IMAGE",
	"IMAGE ALBUM",
	"IMAGE AREA",
	"IMAGE AREA CLOSE",
	"IMAGE BROKEN",
	"IMAGE BROKEN VARIANT",
	"IMAGE FILTER",
	"IMAGE FILTER BLACK WHITE",
	"IMAGE FILTER CENTER FOCUS",
	"IMAGE FILTER CENTER FOCUS WEAK",
	"IMAGE FILTER DRAMA",
	"IMAGE FILTER FRAMES",
	"IMAGE FILTER HDR",
	"IMAGE FILTER NONE",
	"IMAGE FILTER TILT SHIFT",
	"IMAGE FILTER VINTAGE",
	"IMAGE MULTIPLE",
	"IMPORT",
	"INBOX ARROW DOWN",
	"INFORMATION",
	"INFORMATION OUTLINE",
	"INSTAGRAM",
	"INSTAPAPER",
	"INTERNET EXPLORER",
	"INVERT COLORS",
	"JEEPNEY",
	"JIRA",
	"JSFIDDLE",
	"KEG",
	"KEY",
	"KEY CHANGE",
	"KEY MINUS",
	"KEY PLUS",
	"KEY REMOVE",
	"KEY VARIANT",
	"KEYBOARD",
	"KEYBOARD BACKSPACE",
	"KEYBOARD CAPS",
	"KEYBOARD CLOSE",
	"KEYBOARD OFF",
	"KEYBOARD RETURN",
	"KEYBOARD TAB",
	"KEYBOARD VARIANT",
	"KODI",
	"LABEL",
	"LABEL OUTLINE",
	"LAN",
	"LAN CONNECT",
	"LAN DISCONNECT",
	"LAN PENDING",
	"LANGUAGE CSHARP",
	"LANGUAGE CSS3",
	"LANGUAGE HTML5",
	"LANGUAGE JAVASCRIPT",
	"LANGUAGE PHP",
	"LANGUAGE PYTHON",
	"LANGUAGE PYTHON TEXT",
	"LAPTOP",
	"LAPTOP CHROMEBOOK",
	"LAPTOP MAC",
	"LAPTOP WINDOWS",
	"LASTFM",
	"LAUNCH",
	"LAYERS",
	"LAYERS OFF",
	"LEAF",
	"LED OFF",
	"LED ON",
	"LED OUTLINE",
	"LED VARIANT OFF",
	"LED VARIANT ON",
	"LED VARIANT OUTLINE",
	"LIBRARY",
	"LIBRARY BOOKS",
	"LIBRARY MUSIC",
	"LIBRARY PLUS",
	"LIGHTBULB",
	"LIGHTBULB OUTLINE",
	"LINK",
	"LINK OFF",
	"LINK VARIANT",
	"LINK VARIANT OFF",
	"LINKEDIN",
	"LINKEDIN BOX",
	"LINUX",
	"LOCK",
	"LOCK OPEN",
	"LOCK OPEN OUTLINE",
	"LOCK OUTLINE",
	"LOGIN",
	"LOGOUT",
	"LOOKS",
	"LOUPE",
	"LUMX",
	"MAGNET",
	"MAGNET ON",
	"MAGNIFY",
	"MAGNIFY MINUS",
	"MAGNIFY PLUS",
	"MAIL RU",
	"MAP",
	"MAP MARKER",
	"MAP MARKER CIRCLE",
	"MAP MARKER MULTIPLE",
	"MAP MARKER OFF",
	"MAP MARKER RADIUS",
	"MARGIN",
	"MARKDOWN",
	"MARKER CHECK",
	"MARTINI",
	"MATERIAL UI",
	"MATH COMPASS",
	"MAXCDN",
	"MEDIUM",
	"MEMORY",
	"MENU",
	"MENU DOWN",
	"MENU LEFT",
	"MENU RIGHT",
	"MENU UP",
	"MESSAGE",
	"MESSAGE ALERT",
	"MESSAGE DRAW",
	"MESSAGE IMAGE",
	"MESSAGE OUTLINE",
	"MESSAGE PROCESSING",
	"MESSAGE REPLY",
	"MESSAGE REPLY TEXT",
	"MESSAGE TEXT",
	"MESSAGE TEXT OUTLINE",
	"MESSAGE VIDEO",
	"MICROPHONE",
	"MICROPHONE OFF",
	"MICROPHONE OUTLINE",
	"MICROPHONE SETTINGS",
	"MICROPHONE VARIANT",
	"MICROPHONE VARIANT OFF",
	"MICROSOFT",
	"MINECRAFT",
	"MINUS",
	"MINUS BOX",
	"MINUS CIRCLE",
	"MINUS CIRCLE OUTLINE",
	"MINUS NETWORK",
	"MONITOR",
	"MONITOR MULTIPLE",
	"MORE",
	"MOTORBIKE",
	"MOUSE",
	"MOUSE OFF",
	"MOUSE VARIANT",
	"MOUSE VARIANT OFF",
	"MOVIE",
	"MULTIPLICATION",
	"MULTIPLICATION BOX",
	"MUSIC BOX",
	"MUSIC BOX OUTLINE",
	"MUSIC CIRCLE",
	"MUSIC NOTE",
	"MUSIC NOTE EIGHTH",
	"MUSIC NOTE HALF",
	"MUSIC NOTE OFF",
	"MUSIC NOTE QUARTER",
	"MUSIC NOTE SIXTEENTH",
	"MUSIC NOTE WHOLE",
	"NATURE",
	"NATURE PEOPLE",
	"NAVIGATION",
	"NEEDLE",
	"NEST PROTECT",
	"NEST THERMOSTAT",
	"NEW BOX",
	"NEWSPAPER",
	"NFC",
	"NFC TAP",
	"NFC VARIANT",
	"NODEJS",
	"NOTE",
	"NOTE OUTLINE",
	"NOTE PLUS",
	"NOTE PLUS OUTLINE",
	"NOTE TEXT",
	"NOTIFICATION CLEAR ALL",
	"NUMERIC",
	"NUMERIC 0 BOX",
	"NUMERIC 0 BOX MULTIPLE OUTLINE",
	"NUMERIC 0 BOX OUTLINE",
	"NUMERIC 1 BOX",
	"NUMERIC 1 BOX MULTIPLE OUTLINE",
	"NUMERIC 1 BOX OUTLINE",
	"NUMERIC 2 BOX",
	"NUMERIC 2 BOX MULTIPLE OUTLINE",
	"NUMERIC 2 BOX OUTLINE",
	"NUMERIC 3 BOX",
	"NUMERIC 3 BOX MULTIPLE OUTLINE",
	"NUMERIC 3 BOX OUTLINE",
	"NUMERIC 4 BOX",
	"NUMERIC 4 BOX MULTIPLE OUTLINE",
	"NUMERIC 4 BOX OUTLINE",
	"NUMERIC 5 BOX",
	"NUMERIC 5 BOX MULTIPLE OUTLINE",
	"NUMERIC 5 BOX OUTLINE",
	"NUMERIC 6 BOX",
	"NUMERIC 6 BOX MULTIPLE OUTLINE",
	"NUMERIC 6 BOX OUTLINE",
	"NUMERIC 7 BOX",
	"NUMERIC 7 BOX MULTIPLE OUTLINE",
	"NUMERIC 7 BOX OUTLINE",
	"NUMERIC 8 BOX",
	"NUMERIC 8 BOX MULTIPLE OUTLINE",
	"NUMERIC 8 BOX OUTLINE",
	"NUMERIC 9 BOX",
	"NUMERIC 9 BOX MULTIPLE OUTLINE",
	"NUMERIC 9 BOX OUTLINE",
	"NUMERIC 9 PLUS BOX",
	"NUMERIC 9 PLUS BOX MULTIPLE OUTLINE",
	"NUMERIC 9 PLUS BOX OUTLINE",
	"NUTRITION",
	"OCTAGON",
	"OCTAGON OUTLINE",
	"ODNOKLASSNIKI",
	"OFFICE",
	"OIL",
	"OIL TEMPERATURE",
	"OMEGA",
	"ONEDRIVE",
	"OPEN IN APP",
	"OPEN IN NEW",
	"OPENID",
	"OPERA",
	"ORNAMENT",
	"ORNAMENT VARIANT",
	"INBOX ARROW UP",
	"OWL",
	"PACKAGE",
	"PACKAGE DOWN",
	"PACKAGE UP",
	"PACKAGE VARIANT",
	"PACKAGE VARIANT CLOSED",
	"PALETTE",
	"PALETTE ADVANCED",
	"PANDA",
	"PANDORA",
	"PANORAMA",
	"PANORAMA FISHEYE",
	"PANORAMA HORIZONTAL",
	"PANORAMA VERTICAL",
	"PANORAMA WIDE ANGLE",
	"PAPER CUT VERTICAL",
	"PAPERCLIP",
	"PARKING",
	"PAUSE",
	"PAUSE CIRCLE",
	"PAUSE CIRCLE OUTLINE",
	"PAUSE OCTAGON",
	"PAUSE OCTAGON OUTLINE",
	"PAW",
	"PEN",
	"PENCIL",
	"PENCIL BOX",
	"PENCIL BOX OUTLINE",
	"PENCIL LOCK",
	"PENCIL OFF",
	"PERCENT",
	"PHARMACY",
	"PHONE",
	"PHONE BLUETOOTH",
	"PHONE FORWARD",
	"PHONE HANGUP",
	"PHONE IN TALK",
	"PHONE INCOMING",
	"PHONE LOCKED",
	"PHONE LOG",
	"PHONE MISSED",
	"PHONE OUTGOING",
	"PHONE PAUSED",
	"PHONE SETTINGS",
	"PHONE VOIP",
	"PI",
	"<Private Use, Last>",
	"CJK COMPATIBILITY IDEOGRAPH-F900",
	"CJK COMPATIBILITY IDEOGRAPH-F901",
	"CJK COMPATIBILITY IDEOGRAPH-F902",
	"CJK COMPATIBILITY IDEOGRAPH-F903",
	"CJK COMPATIBILITY IDEOGRAPH-F904",
	"CJK COMPATIBILITY IDEOGRAPH-F905",
	"CJK COMPATIBILITY IDEOGRAPH-F906",
	"CJK COMPATIBILITY IDEOGRAPH-F907",
	"CJK COMPATIBILITY IDEOGRAPH-F908",
	"CJK COMPATIBILITY IDEOGRAPH-F909",
	"CJK COMPATIBILITY IDEOGRAPH-F90A",
	"CJK COMPATIBILITY IDEOGRAPH-F90B",
	"CJK COMPATIBILITY IDEOGRAPH-F90C",
	"CJK COMPATIBILITY IDEOGRAPH-F90D",
	"CJK COMPATIBILITY IDEOGRAPH-F90E",
	"CJK COMPATIBILITY IDEOGRAPH-F90F",
	"CJK COMPATIBILITY IDEOGRAPH-F910",
	"CJK COMPATIBILITY IDEOGRAPH-F911",
	"CJK COMPATIBILITY IDEOGRAPH-F912",
	"CJK COMPATIBILITY IDEOGRAPH-F913",
	"CJK COMPATIBILITY IDEOGRAPH-F914",
	"CJK COMPATIBILITY IDEOGRAPH-F915",
	"CJK COMPATIBILITY IDEOGRAPH-F916",
	"CJK COMPATIBILITY IDEOGRAPH-F917",
	"CJK COMPATIBILITY IDEOGRAPH-F918",
	"CJK COMPATIBILITY IDEOGRAPH-F919",
	"CJK COMPATIBILITY IDEOGRAPH-F91A",
	"CJK COMPATIBILITY IDEOGRAPH-F91B",
	"CJK COMPATIBILITY IDEOGRAPH-F91C",
	"CJK COMPATIBILITY IDEOGRAPH-F91D",
	"CJK COMPATIBILITY IDEOGRAPH-F91E",
	"CJK COMPATIBILITY IDEOGRAPH-F91F",
	"CJK COMPATIBILITY IDEOGRAPH-F920",
	"CJK COMPATIBILITY IDEOGRAPH-F921",
	"CJK COMPATIBILITY IDEOGRAPH-F922",
	"CJK COMPATIBILITY IDEOGRAPH-F923",
	"CJK COMPATIBILITY IDEOGRAPH-F924",
	"CJK COMPATIBILITY IDEOGRAPH-F925",
	"CJK COMPATIBILITY IDEOGRAPH-F926",
	"CJK COMPATIBILITY IDEOGRAPH-F927",
	"CJK COMPATIBILITY IDEOGRAPH-F928",
	"CJK COMPATIBILITY IDEOGRAPH-F929",
	"CJK COMPATIBILITY IDEOGRAPH-F92A",
	"CJK COMPATIBILITY IDEOGRAPH-F92B",
	"CJK COMPATIBILITY IDEOGRAPH-F92C",
	"CJK COMPATIBILITY IDEOGRAPH-F92D",
	"CJK COMPATIBILITY IDEOGRAPH-F92E",
	"CJK COMPATIBILITY IDEOGRAPH-F92F",
	"CJK COMPATIBILITY IDEOGRAPH-F930",
	"CJK COMPATIBILITY IDEOGRAPH-F931",
	"CJK COMPATIBILITY IDEOGRAPH-F932",
	"CJK COMPATIBILITY IDEOGRAPH-F933",
	"CJK COMPATIBILITY IDEOGRAPH-F934",
	"CJK COMPATIBILITY IDEOGRAPH-F935",
	"CJK COMPATIBILITY IDEOGRAPH-F936",
	"CJK COMPATIBILITY IDEOGRAPH-F937",
	"CJK COMPATIBILITY IDEOGRAPH-F938",
	"CJK COMPATIBILITY IDEOGRAPH-F939",
	"CJK COMPATIBILITY IDEOGRAPH-F93A",
	"CJK COMPATIBILITY IDEOGRAPH-F93B",
	"CJK COMPATIBILITY IDEOGRAPH-F93C",
	"CJK COMPATIBILITY IDEOGRAPH-F93D",
	"CJK COMPATIBILITY IDEOGRAPH-F93E",
	"CJK COMPATIBILITY IDEOGRAPH-F93F",
	"CJK COMPATIBILITY IDEOGRAPH-F940",
	"CJK COMPATIBILITY IDEOGRAPH-F941",
	"CJK COMPATIBILITY IDEOGRAPH-F942",
	"CJK COMPATIBILITY IDEOGRAPH-F943",
	"CJK COMPATIBILITY IDEOGRAPH-F944",
	"CJK COMPATIBILITY IDEOGRAPH-F945",
	"CJK COMPATIBILITY IDEOGRAPH-F946",
	"CJK COMPATIBILITY IDEOGRAPH-F947",
	"CJK COMPATIBILITY IDEOGRAPH-F948",
	"CJK COMPATIBILITY IDEOGRAPH-F949",
	"CJK COMPATIBILITY IDEOGRAPH-F94A",
	"CJK COMPATIBILITY IDEOGRAPH-F94B",
	"CJK COMPATIBILITY IDEOGRAPH-F94C",
	"CJK COMPATIBILITY IDEOGRAPH-F94D",
	"CJK COMPATIBILITY IDEOGRAPH-F94E",
	"CJK COMPATIBILITY IDEOGRAPH-F94F",
	"CJK COMPATIBILITY IDEOGRAPH-F950",
	"CJK COMPATIBILITY IDEOGRAPH-F951",
	"CJK COMPATIBILITY IDEOGRAPH-F952",
	"CJK COMPATIBILITY IDEOGRAPH-F953",
	"CJK COMPATIBILITY IDEOGRAPH-F954",
	"CJK COMPATIBILITY IDEOGRAPH-F955",
	"CJK COMPATIBILITY IDEOGRAPH-F956",
	"CJK COMPATIBILITY IDEOGRAPH-F957",
	"CJK COMPATIBILITY IDEOGRAPH-F958",
	"CJK COMPATIBILITY IDEOGRAPH-F959",
	"CJK COMPATIBILITY IDEOGRAPH-F95A",
	"CJK COMPATIBILITY IDEOGRAPH-F95B",
	"CJK COMPATIBILITY IDEOGRAPH-F95C",
	"CJK COMPATIBILITY IDEOGRAPH-F95D",
	"CJK COMPATIBILITY IDEOGRAPH-F95E",
	"CJK COMPATIBILITY IDEOGRAPH-F95F",
	"CJK COMPATIBILITY IDEOGRAPH-F960",
	"CJK COMPATIBILITY IDEOGRAPH-F961",
	"CJK COMPATIBILITY IDEOGRAPH-F962",
	"CJK COMPATIBILITY IDEOGRAPH-F963",
	"CJK COMPATIBILITY IDEOGRAPH-F964",
	"CJK COMPATIBILITY IDEOGRAPH-F965",
	"CJK COMPATIBILITY IDEOGRAPH-F966",
	"CJK COMPATIBILITY IDEOGRAPH-F967",
	"CJK COMPATIBILITY IDEOGRAPH-F968",
	"CJK COMPATIBILITY IDEOGRAPH-F969",
	"CJK COMPATIBILITY IDEOGRAPH-F96A",
	"CJK COMPATIBILITY IDEOGRAPH-F96B",
	"CJK COMPATIBILITY IDEOGRAPH-F96C",
	"CJK COMPATIBILITY IDEOGRAPH-F96D",
	"CJK COMPATIBILITY IDEOGRAPH-F96E",
	"CJK COMPATIBILITY IDEOGRAPH-F96F",
	"CJK COMPATIBILITY IDEOGRAPH-F970",
	"CJK COMPATIBILITY IDEOGRAPH-F971",
	"CJK COMPATIBILITY IDEOGRAPH-F972",
	"CJK COMPATIBILITY IDEOGRAPH-F973",
	"CJK COMPATIBILITY IDEOGRAPH-F974",
	"CJK COMPATIBILITY IDEOGRAPH-F975",
	"CJK COMPATIBILITY IDEOGRAPH-F976",
	"CJK COMPATIBILITY IDEOGRAPH-F977",
	"CJK COMPATIBILITY IDEOGRAPH-F978",
	"CJK COMPATIBILITY IDEOGRAPH-F979",
	"CJK COMPATIBILITY IDEOGRAPH-F97A",
	"CJK COMPATIBILITY IDEOGRAPH-F97B",
	"CJK COMPATIBILITY IDEOGRAPH-F97C",
	"CJK COMPATIBILITY IDEOGRAPH-F97D",
	"CJK COMPATIBILITY IDEOGRAPH-F97E",
	"CJK COMPATIBILITY IDEOGRAPH-F97F",
	"CJK COMPATIBILITY IDEOGRAPH-F980",
	"CJK COMPATIBILITY IDEOGRAPH-F981",
	"CJK COMPATIBILITY IDEOGRAPH-F982",
	"CJK COMPATIBILITY IDEOGRAPH-F983",
	"CJK COMPATIBILITY IDEOGRAPH-F984",
	"CJK COMPATIBILITY IDEOGRAPH-F985",
	"CJK COMPATIBILITY IDEOGRAPH-F986",
	"CJK COMPATIBILITY IDEOGRAPH-F987",
	"CJK COMPATIBILITY IDEOGRAPH-F988",
	"CJK COMPATIBILITY IDEOGRAPH-F989",
	"CJK COMPATIBILITY IDEOGRAPH-F98A",
	"CJK COMPATIBILITY IDEOGRAPH-F98B",
	"CJK COMPATIBILITY IDEOGRAPH-F98C",
	"CJK COMPATIBILITY IDEOGRAPH-F98D",
	"CJK COMPATIBILITY IDEOGRAPH-F98E",
	"CJK COMPATIBILITY IDEOGRAPH-F98F",
	"CJK COMPATIBILITY IDEOGRAPH-F990",
	"CJK COMPATIBILITY IDEOGRAPH-F991",
	"CJK COMPATIBILITY IDEOGRAPH-F992",
	"CJK COMPATIBILITY IDEOGRAPH-F993",
	"CJK COMPATIBILITY IDEOGRAPH-F994",
	"CJK COMPATIBILITY IDEOGRAPH-F995",
	"CJK COMPATIBILITY IDEOGRAPH-F996",
	"CJK COMPATIBILITY IDEOGRAPH-F997",
	"CJK COMPATIBILITY IDEOGRAPH-F998",
	"CJK COMPATIBILITY IDEOGRAPH-F999",
	"CJK COMPATIBILITY IDEOGRAPH-F99A",
	"CJK COMPATIBILITY IDEOGRAPH-F99B",
	"CJK COMPATIBILITY IDEOGRAPH-F99C",
	"CJK COMPATIBILITY IDEOGRAPH-F99D",
	"CJK COMPATIBILITY IDEOGRAPH-F99E",
	"CJK COMPATIBILITY IDEOGRAPH-F99F",
	"CJK COMPATIBILITY IDEOGRAPH-F9A0",
	"CJK COMPATIBILITY IDEOGRAPH-F9A1",
	"CJK COMPATIBILITY IDEOGRAPH-F9A2",
	"CJK COMPATIBILITY IDEOGRAPH-F9A3",
	"CJK COMPATIBILITY IDEOGRAPH-F9A4",
	"CJK COMPATIBILITY IDEOGRAPH-F9A5",
	"CJK COMPATIBILITY IDEOGRAPH-F9A6",
	"CJK COMPATIBILITY IDEOGRAPH-F9A7",
	"CJK COMPATIBILITY IDEOGRAPH-F9A8",
	"CJK COMPATIBILITY IDEOGRAPH-F9A9",
	"CJK COMPATIBILITY IDEOGRAPH-F9AA",
	"CJK COMPATIBILITY IDEOGRAPH-F9AB",
	"CJK COMPATIBILITY IDEOGRAPH-F9AC",
	"CJK COMPATIBILITY IDEOGRAPH-F9AD",
	"CJK COMPATIBILITY IDEOGRAPH-F9AE",
	"CJK COMPATIBILITY IDEOGRAPH-F9AF",
	"CJK COMPATIBILITY IDEOGRAPH-F9B0",
	"CJK COMPATIBILITY IDEOGRAPH-F9B1",
	"CJK COMPATIBILITY IDEOGRAPH-F9B2",
	"CJK COMPATIBILITY IDEOGRAPH-F9B3",
	"CJK COMPATIBILITY IDEOGRAPH-F9B4",
	"CJK COMPATIBILITY IDEOGRAPH-F9B5",
	"CJK COMPATIBILITY IDEOGRAPH-F9B6",
	"CJK COMPATIBILITY IDEOGRAPH-F9B7",
	"CJK COMPATIBILITY IDEOGRAPH-F9B8",
	"CJK COMPATIBILITY IDEOGRAPH-F9B9",
	"CJK COMPATIBILITY IDEOGRAPH-F9BA",
	"CJK COMPATIBILITY IDEOGRAPH-F9BB",
	"CJK COMPATIBILITY IDEOGRAPH-F9BC",
	"CJK COMPATIBILITY IDEOGRAPH-F9BD",
	"CJK COMPATIBILITY IDEOGRAPH-F9BE",
	"CJK COMPATIBILITY IDEOGRAPH-F9BF",
	"CJK COMPATIBILITY IDEOGRAPH-F9C0",
	"CJK COMPATIBILITY IDEOGRAPH-F9C1",
	"CJK COMPATIBILITY IDEOGRAPH-F9C2",
	"CJK COMPATIBILITY IDEOGRAPH-F9C3",
	"CJK COMPATIBILITY IDEOGRAPH-F9C4",
	"CJK COMPATIBILITY IDEOGRAPH-F9C5",
	"CJK COMPATIBILITY IDEOGRAPH-F9C6",
	"CJK COMPATIBILITY IDEOGRAPH-F9C7",
	"CJK COMPATIBILITY IDEOGRAPH-F9C8",
	"CJK COMPATIBILITY IDEOGRAPH-F9C9",
	"CJK COMPATIBILITY IDEOGRAPH-F9CA",
	"CJK COMPATIBILITY IDEOGRAPH-F9CB",
	"CJK COMPATIBILITY IDEOGRAPH-F9CC",
	"CJK COMPATIBILITY IDEOGRAPH-F9CD",
	"CJK COMPATIBILITY IDEOGRAPH-F9CE",
	"CJK COMPATIBILITY IDEOGRAPH-F9CF",
	"CJK COMPATIBILITY IDEOGRAPH-F9D0",
	"CJK COMPATIBILITY IDEOGRAPH-F9D1",
	"CJK COMPATIBILITY IDEOGRAPH-F9D2",
	"CJK COMPATIBILITY IDEOGRAPH-F9D3",
	"CJK COMPATIBILITY IDEOGRAPH-F9D4",
	"CJK COMPATIBILITY IDEOGRAPH-F9D5",
	"CJK COMPATIBILITY IDEOGRAPH-F9D6",
	"CJK COMPATIBILITY IDEOGRAPH-F9D7",
	"CJK COMPATIBILITY IDEOGRAPH-F9D8",
	"CJK COMPATIBILITY IDEOGRAPH-F9D9",
	"CJK COMPATIBILITY IDEOGRAPH-F9DA",
	"CJK COMPATIBILITY IDEOGRAPH-F9DB",
	"CJK COMPATIBILITY IDEOGRAPH-F9DC",
	"CJK COMPATIBILITY IDEOGRAPH-F9DD",
	"CJK COMPATIBILITY IDEOGRAPH-F9DE",
	"CJK COMPATIBILITY IDEOGRAPH-F9DF",
	"CJK COMPATIBILITY IDEOGRAPH-F9E0",
	"CJK COMPATIBILITY IDEOGRAPH-F9E1",
	"CJK COMPATIBILITY IDEOGRAPH-F9E2",
	"CJK COMPATIBILITY IDEOGRAPH-F9E3",
	"CJK COMPATIBILITY IDEOGRAPH-F9E4",
	"CJK COMPATIBILITY IDEOGRAPH-F9E5",
	"CJK COMPATIBILITY IDEOGRAPH-F9E6",
	"CJK COMPATIBILITY IDEOGRAPH-F9E7",
	"CJK COMPATIBILITY IDEOGRAPH-F9E8",
	"CJK COMPATIBILITY IDEOGRAPH-F9E9",
	"CJK COMPATIBILITY IDEOGRAPH-F9EA",
	"CJK COMPATIBILITY IDEOGRAPH-F9EB",
	"CJK COMPATIBILITY IDEOGRAPH-F9EC",
	"CJK COMPATIBILITY IDEOGRAPH-F9ED",
	"CJK COMPATIBILITY IDEOGRAPH-F9EE",
	"CJK COMPATIBILITY IDEOGRAPH-F9EF",
	"CJK COMPATIBILITY IDEOGRAPH-F9F0",
	"CJK COMPATIBILITY IDEOGRAPH-F9F1",
	"CJK COMPATIBILITY IDEOGRAPH-F9F2",
	"CJK COMPATIBILITY IDEOGRAPH-F9F3",
	"CJK COMPATIBILITY IDEOGRAPH-F9F4",
	"CJK COMPATIBILITY IDEOGRAPH-F9F5",
	"CJK COMPATIBILITY IDEOGRAPH-F9F6",
	"CJK COMPATIBILITY IDEOGRAPH-F9F7",
	"CJK COMPATIBILITY IDEOGRAPH-F9F8",
	"CJK COMPATIBILITY IDEOGRAPH-F9F9",
	"CJK COMPATIBILITY IDEOGRAPH-F9FA",
	"CJK COMPATIBILITY IDEOGRAPH-F9FB",
	"CJK COMPATIBILITY IDEOGRAPH-F9FC",
	"CJK COMPATIBILITY IDEOGRAPH-F9FD",
	"CJK COMPATIBILITY IDEOGRAPH-F9FE",
	"CJK COMPATIBILITY IDEOGRAPH-F9FF",
	"CJK COMPATIBILITY IDEOGRAPH-FA00",
	"CJK COMPATIBILITY IDEOGRAPH-FA01",
	"CJK COMPATIBILITY IDEOGRAPH-FA02",
	"CJK COMPATIBILITY IDEOGRAPH-FA03",
	"CJK COMPATIBILITY IDEOGRAPH-FA04",
	"CJK COMPATIBILITY IDEOGRAPH-FA05",
	"CJK COMPATIBILITY IDEOGRAPH-FA06",
	"CJK COMPATIBILITY IDEOGRAPH-FA07",
	"CJK COMPATIBILITY IDEOGRAPH-FA08",
	"CJK COMPATIBILITY IDEOGRAPH-FA09",
	"CJK COMPATIBILITY IDEOGRAPH-FA0A",
	"CJK COMPATIBILITY IDEOGRAPH-FA0B",
	"CJK COMPATIBILITY IDEOGRAPH-FA0C",
	"CJK COMPATIBILITY IDEOGRAPH-FA0D",
	"CJK COMPATIBILITY IDEOGRAPH-FA0E",
	"CJK COMPATIBILITY IDEOGRAPH-FA0F",
	"CJK COMPATIBILITY IDEOGRAPH-FA10",
	"CJK COMPATIBILITY IDEOGRAPH-FA11",
	"CJK COMPATIBILITY IDEOGRAPH-FA12",
	"CJK COMPATIBILITY IDEOGRAPH-FA13",
	"CJK COMPATIBILITY IDEOGRAPH-FA14",
	"CJK COMPATIBILITY IDEOGRAPH-FA15",
	"CJK COMPATIBILITY IDEOGRAPH-FA16",
	"CJK COMPATIBILITY IDEOGRAPH-FA17",
	"CJK COMPATIBILITY IDEOGRAPH-FA18",
	"CJK COMPATIBILITY IDEOGRAPH-FA19",
	"CJK COMPATIBILITY IDEOGRAPH-FA1A",
	"CJK COMPATIBILITY IDEOGRAPH-FA1B",
	"CJK COMPATIBILITY IDEOGRAPH-FA1C",
	"CJK COMPATIBILITY IDEOGRAPH-FA1D",
	"CJK COMPATIBILITY IDEOGRAPH-FA1E",
	"CJK COMPATIBILITY IDEOGRAPH-FA1F",
	"CJK COMPATIBILITY IDEOGRAPH-FA20",
	"CJK COMPATIBILITY IDEOGRAPH-FA21",
	"CJK COMPATIBILITY IDEOGRAPH-FA22",
	"CJK COMPATIBILITY IDEOGRAPH-FA23",
	"CJK COMPATIBILITY IDEOGRAPH-FA24",
	"CJK COMPATIBILITY IDEOGRAPH-FA25",
	"CJK COMPATIBILITY IDEOGRAPH-FA26",
	"CJK COMPATIBILITY IDEOGRAPH-FA27",
	"CJK COMPATIBILITY IDEOGRAPH-FA28",
	"CJK COMPATIBILITY IDEOGRAPH-FA29",
	"CJK COMPATIBILITY IDEOGRAPH-FA2A",
	"CJK COMPATIBILITY IDEOGRAPH-FA2B",
	"CJK COMPATIBILITY IDEOGRAPH-FA2C",
	"CJK COMPATIBILITY IDEOGRAPH-FA2D",
	"CJK COMPATIBILITY IDEOGRAPH-FA2E",
	"CJK COMPATIBILITY IDEOGRAPH-FA2F",
	"CJK COMPATIBILITY IDEOGRAPH-FA30",
	"CJK COMPATIBILITY IDEOGRAPH-FA31",
	"CJK COMPATIBILITY IDEOGRAPH-FA32",
	"CJK COMPATIBILITY IDEOGRAPH-FA33",
	"CJK COMPATIBILITY IDEOGRAPH-FA34",
	"CJK COMPATIBILITY IDEOGRAPH-FA35",
	"CJK COMPATIBILITY IDEOGRAPH-FA36",
	"CJK COMPATIBILITY IDEOGRAPH-FA37",
	"CJK COMPATIBILITY IDEOGRAPH-FA38",
	"CJK COMPATIBILITY IDEOGRAPH-FA39",
	"CJK COMPATIBILITY IDEOGRAPH-FA3A",
	"CJK COMPATIBILITY IDEOGRAPH-FA3B",
	"CJK COMPATIBILITY IDEOGRAPH-FA3C",
	"CJK COMPATIBILITY IDEOGRAPH-FA3D",
	"CJK COMPATIBILITY IDEOGRAPH-FA3E",
	"CJK COMPATIBILITY IDEOGRAPH-FA3F",
	"CJK COMPATIBILITY IDEOGRAPH-FA40",
	"CJK COMPATIBILITY IDEOGRAPH-FA41",
	"CJK COMPATIBILITY IDEOGRAPH-FA42",
	"CJK COMPATIBILITY IDEOGRAPH-FA43",
	"CJK COMPATIBILITY IDEOGRAPH-FA44",
	"CJK COMPATIBILITY IDEOGRAPH-FA45",
	"CJK COMPATIBILITY IDEOGRAPH-FA46",
	"CJK COMPATIBILITY IDEOGRAPH-FA47",
	"CJK COMPATIBILITY IDEOGRAPH-FA48",
	"CJK COMPATIBILITY IDEOGRAPH-FA49",
	"CJK COMPATIBILITY IDEOGRAPH-FA4A",
	"CJK COMPATIBILITY IDEOGRAPH-FA4B",
	"CJK COMPATIBILITY IDEOGRAPH-FA4C",
	"CJK COMPATIBILITY IDEOGRAPH-FA4D",
	"CJK COMPATIBILITY IDEOGRAPH-FA4E",
	"CJK COMPATIBILITY IDEOGRAPH-FA4F",
	"CJK COMPATIBILITY IDEOGRAPH-FA50",
	"CJK COMPATIBILITY IDEOGRAPH-FA51",
	"CJK COMPATIBILITY IDEOGRAPH-FA52",
	"CJK COMPATIBILITY IDEOGRAPH-FA53",
	"CJK COMPATIBILITY IDEOGRAPH-FA54",
	"CJK COMPATIBILITY IDEOGRAPH-FA55",
	"CJK COMPATIBILITY IDEOGRAPH-FA56",
	"CJK COMPATIBILITY IDEOGRAPH-FA57",
	"CJK COMPATIBILITY IDEOGRAPH-FA58",
	"CJK COMPATIBILITY IDEOGRAPH-FA59",
	"CJK COMPATIBILITY IDEOGRAPH-FA5A",
	"CJK COMPATIBILITY IDEOGRAPH-FA5B",
	"CJK COMPATIBILITY IDEOGRAPH-FA5C",
	"CJK COMPATIBILITY IDEOGRAPH-FA5D",
	"CJK COMPATIBILITY IDEOGRAPH-FA5E",
	"CJK COMPATIBILITY IDEOGRAPH-FA5F",
	"CJK COMPATIBILITY IDEOGRAPH-FA60",
	"CJK COMPATIBILITY IDEOGRAPH-FA61",
	"CJK COMPATIBILITY IDEOGRAPH-FA62",
	"CJK COMPATIBILITY IDEOGRAPH-FA63",
	"CJK COMPATIBILITY IDEOGRAPH-FA64",
	"CJK COMPATIBILITY IDEOGRAPH-FA65",
	"CJK COMPATIBILITY IDEOGRAPH-FA66",
	"CJK COMPATIBILITY IDEOGRAPH-FA67",
	"CJK COMPATIBILITY IDEOGRAPH-FA68",
	"CJK COMPATIBILITY IDEOGRAPH-FA69",
	"CJK COMPATIBILITY IDEOGRAPH-FA6A",
	"CJK COMPATIBILITY IDEOGRAPH-FA6B",
	"CJK COMPATIBILITY IDEOGRAPH-FA6C",
	"CJK COMPATIBILITY IDEOGRAPH-FA6D",
	"VIEW DAY",
	"VIEW GRID",
	"CJK COMPATIBILITY IDEOGRAPH-FA70",
	"CJK COMPATIBILITY IDEOGRAPH-FA71",
	"CJK COMPATIBILITY IDEOGRAPH-FA72",
	"CJK COMPATIBILITY IDEOGRAPH-FA73",
	"CJK COMPATIBILITY IDEOGRAPH-FA74",
	"CJK COMPATIBILITY IDEOGRAPH-FA75",
	"CJK COMPATIBILITY IDEOGRAPH-FA76",
	"CJK COMPATIBILITY IDEOGRAPH-FA77",
	"CJK COMPATIBILITY IDEOGRAPH-FA78",
	"CJK COMPATIBILITY IDEOGRAPH-FA79",
	"CJK COMPATIBILITY IDEOGRAPH-FA7A",
	"CJK COMPATIBILITY IDEOGRAPH-FA7B",
	"CJK COMPATIBILITY IDEOGRAPH-FA7C",
	"CJK COMPATIBILITY IDEOGRAPH-FA7D",
	"CJK COMPATIBILITY IDEOGRAPH-FA7E",
	"CJK COMPATIBILITY IDEOGRAPH-FA7F",
	"CJK COMPATIBILITY IDEOGRAPH-FA80",
	"CJK COMPATIBILITY IDEOGRAPH-FA81",
	"CJK COMPATIBILITY IDEOGRAPH-FA82",
	"CJK COMPATIBILITY IDEOGRAPH-FA83",
	"CJK COMPATIBILITY IDEOGRAPH-FA84",
	"CJK COMPATIBILITY IDEOGRAPH-FA85",
	"CJK COMPATIBILITY IDEOGRAPH-FA86",
	"CJK COMPATIBILITY IDEOGRAPH-FA87",
	"CJK COMPATIBILITY IDEOGRAPH-FA88",
	"CJK COMPATIBILITY IDEOGRAPH-FA89",
	"CJK COMPATIBILITY IDEOGRAPH-FA8A",
	"CJK COMPATIBILITY IDEOGRAPH-FA8B",
	"CJK COMPATIBILITY IDEOGRAPH-FA8C",
	"CJK COMPATIBILITY IDEOGRAPH-FA8D",
	"CJK COMPATIBILITY IDEOGRAPH-FA8E",
	"CJK COMPATIBILITY IDEOGRAPH-FA8F",
	"CJK COMPATIBILITY IDEOGRAPH-FA90",
	"CJK COMPATIBILITY IDEOGRAPH-FA91",
	"CJK COMPATIBILITY IDEOGRAPH-FA92",
	"CJK COMPATIBILITY IDEOGRAPH-FA93",
	"CJK COMPATIBILITY IDEOGRAPH-FA94",
	"CJK COMPATIBILITY IDEOGRAPH-FA95",
	"CJK COMPATIBILITY IDEOGRAPH-FA96",
	"CJK COMPATIBILITY IDEOGRAPH-FA97",
	"CJK COMPATIBILITY IDEOGRAPH-FA98",
	"CJK COMPATIBILITY IDEOGRAPH-FA99",
	"CJK COMPATIBILITY IDEOGRAPH-FA9A",
	"CJK COMPATIBILITY IDEOGRAPH-FA9B",
	"CJK COMPATIBILITY IDEOGRAPH-FA9C",
	"CJK COMPATIBILITY IDEOGRAPH-FA9D",
	"CJK COMPATIBILITY IDEOGRAPH-FA9E",
	"CJK COMPATIBILITY IDEOGRAPH-FA9F",
	"CJK COMPATIBILITY IDEOGRAPH-FAA0",
	"CJK COMPATIBILITY IDEOGRAPH-FAA1",
	"CJK COMPATIBILITY IDEOGRAPH-FAA2",
	"CJK COMPATIBILITY IDEOGRAPH-FAA3",
	"CJK COMPATIBILITY IDEOGRAPH-FAA4",
	"CJK COMPATIBILITY IDEOGRAPH-FAA5",
	"CJK COMPATIBILITY IDEOGRAPH-FAA6",
	"CJK COMPATIBILITY IDEOGRAPH-FAA7",
	"CJK COMPATIBILITY IDEOGRAPH-FAA8",
	"CJK COMPATIBILITY IDEOGRAPH-FAA9",
	"CJK COMPATIBILITY IDEOGRAPH-FAAA",
	"CJK COMPATIBILITY IDEOGRAPH-FAAB",
	"CJK COMPATIBILITY IDEOGRAPH-FAAC",
	"CJK COMPATIBILITY IDEOGRAPH-FAAD",
	"CJK COMPATIBILITY IDEOGRAPH-FAAE",
	"CJK COMPATIBILITY IDEOGRAPH-FAAF",
	"CJK COMPATIBILITY IDEOGRAPH-FAB0",
	"CJK COMPATIBILITY IDEOGRAPH-FAB1",
	"CJK COMPATIBILITY IDEOGRAPH-FAB2",
	"CJK COMPATIBILITY IDEOGRAPH-FAB3",
	"CJK COMPATIBILITY IDEOGRAPH-FAB4",
	"CJK COMPATIBILITY IDEOGRAPH-FAB5",
	"CJK COMPATIBILITY IDEOGRAPH-FAB6",
	"CJK COMPATIBILITY IDEOGRAPH-FAB7",
	"CJK COMPATIBILITY IDEOGRAPH-FAB8",
	"CJK COMPATIBILITY IDEOGRAPH-FAB9",
	"CJK COMPATIBILITY IDEOGRAPH-FABA",
	"CJK COMPATIBILITY IDEOGRAPH-FABB",
	"CJK COMPATIBILITY IDEOGRAPH-FABC",
	"CJK COMPATIBILITY IDEOGRAPH-FABD",
	"CJK COMPATIBILITY IDEOGRAPH-FABE",
	"CJK COMPATIBILITY IDEOGRAPH-FABF",
	"CJK COMPATIBILITY IDEOGRAPH-FAC0",
	"CJK COMPATIBILITY IDEOGRAPH-FAC1",
	"CJK COMPATIBILITY IDEOGRAPH-FAC2",
	"CJK COMPATIBILITY IDEOGRAPH-FAC3",
	"CJK COMPATIBILITY IDEOGRAPH-FAC4",
	"CJK COMPATIBILITY IDEOGRAPH-FAC5",
	"CJK COMPATIBILITY IDEOGRAPH-FAC6",
	"CJK COMPATIBILITY IDEOGRAPH-FAC7",
	"CJK COMPATIBILITY IDEOGRAPH-FAC8",
	"CJK COMPATIBILITY IDEOGRAPH-FAC9",
	"CJK COMPATIBILITY IDEOGRAPH-FACA",
	"CJK COMPATIBILITY IDEOGRAPH-FACB",
	"CJK COMPATIBILITY IDEOGRAPH-FACC",
	"CJK COMPATIBILITY IDEOGRAPH-FACD",
	"CJK COMPATIBILITY IDEOGRAPH-FACE",
	"CJK COMPATIBILITY IDEOGRAPH-FACF",
	"CJK COMPATIBILITY IDEOGRAPH-FAD0",
	"CJK COMPATIBILITY IDEOGRAPH-FAD1",
	"CJK COMPATIBILITY IDEOGRAPH-FAD2",
	"CJK COMPATIBILITY IDEOGRAPH-FAD3",
	"CJK COMPATIBILITY IDEOGRAPH-FAD4",
	"CJK COMPATIBILITY IDEOGRAPH-FAD5",
	"CJK COMPATIBILITY IDEOGRAPH-FAD6",
	"CJK COMPATIBILITY IDEOGRAPH-FAD7",
	"CJK COMPATIBILITY IDEOGRAPH-FAD8",
	"CJK COMPATIBILITY IDEOGRAPH-FAD9",
	"BOOK PLUS",
	"BOOMBOX",
	"BULLSEYE",
	"COMMENT REMOVE",
	"CAMERA OFF",
	"CHECK CIRCLE",
	"CHECK CIRCLE OUTLINE",
	"CANDLE",
	"CHART BUBBLE",
	"CREDIT CARD OFF",
	"CUP OFF",
	"COPYRIGHT",
	"CURSOR TEXT",
	"DELETE FOREVER",
	"DELETE SWEEP",
	"DICE D20",
	"DICE D4",
	"DICE D6",
	"DICE D8",
	"DISK",
	"EMAIL OPEN OUTLINE",
	"EMAIL VARIANT",
	"EV STATION",
	"FOOD FORK DRINK",
	"FOOD OFF",
	"FORMAT TITLE",
	"GOOGLE MAPS",
	"HEART PULSE",
	"HIGHWAY",
	"HOME MAP MARKER",
	"INCOGNITO",
	"KETTLE",
	"LOCK PLUS",
	"LOGIN VARIANT",
	"LOGOUT VARIANT",
	"MUSIC NOTE BLUETOOTH",
	"MUSIC NOTE BLUETOOTH OFF",
	"PAGE FIRST",
	"LATIN SMALL LIGATURE FF",
	"LATIN SMALL LIGATURE FI",
	"LATIN SMALL LIGATURE FL",
	"LATIN SMALL LIGATURE FFI",
	"LATIN SMALL LIGATURE FFL",
	"LATIN SMALL LIGATURE LONG S T",
	"LATIN SMALL LIGATURE ST",
	"ROWING",
	"SAXOPHONE",
	"SIGNAL VARIANT",
	"STACKEXCHANGE",
	"SUBDIRECTORY ARROW LEFT",
	"SUBDIRECTORY ARROW RIGHT",
	"TEXTBOX",
	"VIOLIN",
	"VISUALSTUDIO",
	"WECHAT",
	"WATERMARK",
	"FILE HIDDEN",
	"ARMENIAN SMALL LIGATURE MEN NOW",
	"ARMENIAN SMALL LIGATURE MEN ECH",
	"ARMENIAN SMALL LIGATURE MEN INI",
	"ARMENIAN SMALL LIGATURE VEW NOW",
	"ARMENIAN SMALL LIGATURE MEN XEH",
	"BUFFER",
	"CHIP",
	"CONTENT SAVE SETTINGS",
	"DIALPAD",
	"DICTIONARY",
	"HEBREW LETTER YOD WITH HIRIQ",
	"HEBREW POINT JUDEO-SPANISH VARIKA",
	"HEBREW LIGATURE YIDDISH YOD YOD PATAH",
	"HEBREW LETTER ALTERNATIVE AYIN",
	"HEBREW LETTER WIDE ALEF",
	"HEBREW LETTER WIDE DALET",
	"HEBREW LETTER WIDE HE",
	"HEBREW LETTER WIDE KAF",
	"HEBREW LETTER WIDE LAMED",
	"HEBREW LETTER WIDE FINAL MEM",
	"HEBREW LETTER WIDE RESH",
	"HEBREW LETTER WIDE TAV",
	"HEBREW LETTER ALTERNATIVE PLUS SIGN",
	"HEBREW LETTER SHIN WITH SHIN DOT",
	"HEBREW LETTER SHIN WITH SIN DOT",
	"HEBREW LETTER SHIN WITH DAGESH AND SHIN DOT",
	"HEBREW LETTER SHIN WITH DAGESH AND SIN DOT",
	"HEBREW LETTER ALEF WITH PATAH",
	"HEBREW LETTER ALEF WITH QAMATS",
	"HEBREW LETTER ALEF WITH MAPIQ",
	"HEBREW LETTER BET WITH DAGESH",
	"HEBREW LETTER GIMEL WITH DAGESH",
	"HEBREW LETTER DALET WITH DAGESH",
	"HEBREW LETTER HE WITH MAPIQ",
	"HEBREW LETTER VAV WITH DAGESH",
	"HEBREW LETTER ZAYIN WITH DAGESH",
	"CARDS",
	"HEBREW LETTER TET WITH DAGESH",
	"HEBREW LETTER YOD WITH DAGESH",
	"HEBREW LETTER FINAL KAF WITH DAGESH",
	"HEBREW LETTER KAF WITH DAGESH",
	"HEBREW LETTER LAMED WITH DAGESH",
	"CHECKBOX MULTIPLE MARKED CIRCLE OUTLINE",
	"HEBREW LETTER MEM WITH DAGESH",
	"COLLAGE",
	"HEBREW LETTER NUN WITH DAGESH",
	"HEBREW LETTER SAMEKH WITH DAGESH",
	"FACE",
	"HEBREW LETTER FINAL PE WITH DAGESH",
	"HEBREW LETTER PE WITH DAGESH",
	"FORMAT ANNOTATION PLUS",
	"HEBREW LETTER TSADI WITH DAGESH",
	"HEBREW LETTER QOF WITH DAGESH",
	"HEBREW LETTER RESH WITH DAGESH",
	"HEBREW LETTER SHIN WITH DAGESH",
	"HEBREW LETTER TAV WITH DAGESH",
	"HEBREW LETTER VAV WITH HOLAM",
	"HEBREW LETTER BET WITH RAFE",
	"HEBREW LETTER KAF WITH RAFE",
	"HEBREW LETTER PE WITH RAFE",
	"HEBREW LIGATURE ALEF LAMED",
	"ARABIC LETTER ALEF WASLA ISOLATED FORM",
	"ARABIC LETTER ALEF WASLA FINAL FORM",
	"ARABIC LETTER BEEH ISOLATED FORM",
	"ARABIC LETTER BEEH FINAL FORM",
	"ARABIC LETTER BEEH INITIAL FORM",
	"ARABIC LETTER BEEH MEDIAL FORM",
	"ARABIC LETTER PEH ISOLATED FORM",
	"ARABIC LETTER PEH FINAL FORM",
	"ARABIC LETTER PEH INITIAL FORM",
	"ARABIC LETTER PEH MEDIAL FORM",
	"ARABIC LETTER BEHEH ISOLATED FORM",
	"ARABIC LETTER BEHEH FINAL FORM",
	"ARABIC LETTER BEHEH INITIAL FORM",
	"ARABIC LETTER BEHEH MEDIAL FORM",
	"ARABIC LETTER TTEHEH ISOLATED FORM",
	"ARABIC LETTER TTEHEH FINAL FORM",
	"ARABIC LETTER TTEHEH INITIAL FORM",
	"ARABIC LETTER TTEHEH MEDIAL FORM",
	"ARABIC LETTER TEHEH ISOLATED FORM",
	"ARABIC LETTER TEHEH FINAL FORM",
	"ARABIC LETTER TEHEH INITIAL FORM",
	"ARABIC LETTER TEHEH MEDIAL FORM",
	"ARABIC LETTER TTEH ISOLATED FORM",
	"ARABIC LETTER TTEH FINAL FORM",
	"ARABIC LETTER TTEH INITIAL FORM",
	"ARABIC LETTER TTEH MEDIAL FORM",
	"ARABIC LETTER VEH ISOLATED FORM",
	"ARABIC LETTER VEH FINAL FORM",
	"ARABIC LETTER VEH INITIAL FORM",
	"ARABIC LETTER VEH MEDIAL FORM",
	"ARABIC LETTER PEHEH ISOLATED FORM",
	"ARABIC LETTER PEHEH FINAL FORM",
	"ARABIC LETTER PEHEH INITIAL FORM",
	"ARABIC LETTER PEHEH MEDIAL FORM",
	"ARABIC LETTER DYEH ISOLATED FORM",
	"ARABIC LETTER DYEH FINAL FORM",
	"ARABIC LETTER DYEH INITIAL FORM",
	"ARABIC LETTER DYEH MEDIAL FORM",
	"ARABIC LETTER NYEH ISOLATED FORM",
	"ARABIC LETTER NYEH FINAL FORM",
	"ARABIC LETTER NYEH INITIAL FORM",
	"ARABIC LETTER NYEH MEDIAL FORM",
	"ARABIC LETTER TCHEH ISOLATED FORM",
	"ARABIC LETTER TCHEH FINAL FORM",
	"ARABIC LETTER TCHEH INITIAL FORM",
	"ARABIC LETTER TCHEH MEDIAL FORM",
	"ARABIC LETTER TCHEHEH ISOLATED FORM",
	"ARABIC LETTER TCHEHEH FINAL FORM",
	"ARABIC LETTER TCHEHEH INITIAL FORM",
	"ARABIC LETTER TCHEHEH MEDIAL FORM",
	"ARABIC LETTER DDAHAL ISOLATED FORM",
	"ARABIC LETTER DDAHAL FINAL FORM",
	"ARABIC LETTER DAHAL ISOLATED FORM",
	"ARABIC LETTER DAHAL FINAL FORM",
	"ARABIC LETTER DUL ISOLATED FORM",
	"ARABIC LETTER DUL FINAL FORM",
	"ARABIC LETTER DDAL ISOLATED FORM",
	"ARABIC LETTER DDAL FINAL FORM",
	"ARABIC LETTER JEH ISOLATED FORM",
	"ARABIC LETTER JEH FINAL FORM",
	"ARABIC LETTER RREH ISOLATED FORM",
	"ARABIC LETTER RREH FINAL FORM",
	"ARABIC LETTER KEHEH ISOLATED FORM",
	"ARABIC LETTER KEHEH FINAL FORM",
	"ARABIC LETTER KEHEH INITIAL FORM",
	"ARABIC LETTER KEHEH MEDIAL FORM",
	"ARABIC LETTER GAF ISOLATED FORM",
	"ARABIC LETTER GAF FINAL FORM",
	"ARABIC LETTER GAF INITIAL FORM",
	"ARABIC LETTER GAF MEDIAL FORM",
	"ARABIC LETTER GUEH ISOLATED FORM",
	"ARABIC LETTER GUEH FINAL FORM",
	"ARABIC LETTER GUEH INITIAL FORM",
	"ARABIC LETTER GUEH MEDIAL FORM",
	"ARABIC LETTER NGOEH ISOLATED FORM",
	"ARABIC LETTER NGOEH FINAL FORM",
	"ARABIC LETTER NGOEH INITIAL FORM",
	"ARABIC LETTER NGOEH MEDIAL FORM",
	"ARABIC LETTER NOON GHUNNA ISOLATED FORM",
	"ARABIC LETTER NOON GHUNNA FINAL FORM",
	"ARABIC LETTER RNOON ISOLATED FORM",
	"ARABIC LETTER RNOON FINAL FORM",
	"ARABIC LETTER RNOON INITIAL FORM",
	"ARABIC LETTER RNOON MEDIAL FORM",
	"ARABIC LETTER HEH WITH YEH ABOVE ISOLATED FORM",
	"ARABIC LETTER HEH WITH YEH ABOVE FINAL FORM",
	"ARABIC LETTER HEH GOAL ISOLATED FORM",
	"ARABIC LETTER HEH GOAL FINAL FORM",
	"ARABIC LETTER HEH GOAL INITIAL FORM",
	"ARABIC LETTER HEH GOAL MEDIAL FORM",
	"ARABIC LETTER HEH DOACHASHMEE ISOLATED FORM",
	"ARABIC LETTER HEH DOACHASHMEE FINAL FORM",
	"ARABIC LETTER HEH DOACHASHMEE INITIAL FORM",
	"ARABIC LETTER HEH DOACHASHMEE MEDIAL FORM",
	"ARABIC LETTER YEH BARREE ISOLATED FORM",
	"ARABIC LETTER YEH BARREE FINAL FORM",
	"ARABIC LETTER YEH BARREE WITH HAMZA ABOVE ISOLATED FORM",
	"ARABIC LETTER YEH BARREE WITH HAMZA ABOVE FINAL FORM",
	"ARABIC SYMBOL DOT ABOVE",
	"ARABIC SYMBOL DOT BELOW",
	"ARABIC SYMBOL TWO DOTS ABOVE",
	"ARABIC SYMBOL TWO DOTS BELOW",
	"ARABIC SYMBOL THREE DOTS ABOVE",
	"ARABIC SYMBOL THREE DOTS BELOW",
	"ARABIC SYMBOL THREE DOTS POINTING DOWNWARDS ABOVE",
	"ARABIC SYMBOL THREE DOTS POINTING DOWNWARDS BELOW",
	"ARABIC SYMBOL FOUR DOTS ABOVE",
	"ARABIC SYMBOL FOUR DOTS BELOW",
	"ARABIC SYMBOL DOUBLE VERTICAL BAR BELOW",
	"ARABIC SYMBOL TWO DOTS VERTICALLY ABOVE",
	"ARABIC SYMBOL TWO DOTS VERTICALLY BELOW",
	"ARABIC SYMBOL RING",
	"ARABIC SYMBOL SMALL TAH ABOVE",
	"ARABIC SYMBOL SMALL TAH BELOW",
	"ARABIC SYMBOL WASLA ABOVE",
	"BOMB OFF",
	"BOOTSTRAP",
	"CARDS VARIANT",
	"CLIPBOARD FLOW",
	"CLOSE OUTLINE",
	"COFFEE OUTLINE",
	"CONTACTS",
	"DELETE EMPTY",
	"EARTH BOX",
	"EARTH BOX OFF",
	"EMAIL ALERT",
	"EYE OUTLINE",
	"EYE OFF OUTLINE",
	"FAST FORWARD OUTLINE",
	"FEATHER",
	"FIND REPLACE",
	"ARABIC LETTER NG ISOLATED FORM",
	"ARABIC LETTER NG FINAL FORM",
	"ARABIC LETTER NG INITIAL FORM",
	"ARABIC LETTER NG MEDIAL FORM",
	"ARABIC LETTER U ISOLATED FORM",
	"ARABIC LETTER U FINAL FORM",
	"ARABIC LETTER OE ISOLATED FORM",
	"ARABIC LETTER OE FINAL FORM",
	"ARABIC LETTER YU ISOLATED FORM",
	"ARABIC LETTER YU FINAL FORM",
	"ARABIC LETTER U WITH HAMZA ABOVE ISOLATED FORM",
	"ARABIC LETTER VE ISOLATED FORM",
	"ARABIC LETTER VE FINAL FORM",
	"ARABIC LETTER KIRGHIZ OE ISOLATED FORM",
	"ARABIC LETTER KIRGHIZ OE FINAL FORM",
	"ARABIC LETTER KIRGHIZ YU ISOLATED FORM",
	"ARABIC LETTER KIRGHIZ YU FINAL FORM",
	"ARABIC LETTER E ISOLATED FORM",
	"ARABIC LETTER E FINAL FORM",
	"ARABIC LETTER E INITIAL FORM",
	"ARABIC LETTER E MEDIAL FORM",
	"ARABIC LETTER UIGHUR KAZAKH KIRGHIZ ALEF MAKSURA INITIAL FORM",
	"ARABIC LETTER UIGHUR KAZAKH KIRGHIZ ALEF MAKSURA MEDIAL FORM",
	"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF ISOLATED FORM",
	"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF FINAL FORM",
	"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH AE ISOLATED FORM",
	"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH AE FINAL FORM",
	"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH WAW ISOLATED FORM",
	"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH WAW FINAL FORM",
	"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH U ISOLATED FORM",
	"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH U FINAL FORM",
	"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH OE ISOLATED FORM",
	"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH OE FINAL FORM",
	"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YU ISOLATED FORM",
	"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YU FINAL FORM",
	"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E ISOLATED FORM",
	"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E FINAL FORM",
	"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E INITIAL FORM",
	"ARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA ISOLATED FORM",
	"ARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA FINAL FORM",
	"ARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA INITIAL FORM",
	"ARABIC LETTER FARSI YEH ISOLATED FORM",
	"ARABIC LETTER FARSI YEH FINAL FORM",
	"ARABIC LETTER FARSI YEH INITIAL FORM",
	"ARABIC LETTER FARSI YEH MEDIAL FORM",
	"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH JEEM ISOLATED FORM",
	"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HAH ISOLATED FORM",
	"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM ISOLATED FORM",
	"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF MAKSURA ISOLATED FORM",
	"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YEH ISOLATED FORM",
	"ARABIC LIGATURE BEH WITH JEEM ISOLATED FORM",
	"ARABIC LIGATURE BEH WITH HAH ISOLATED FORM",
	"ARABIC LIGATURE BEH WITH KHAH ISOLATED FORM",
	"ARABIC LIGATURE BEH WITH MEEM ISOLATED FORM",
	"ARABIC LIGATURE BEH WITH ALEF MAKSURA ISOLATED FORM",
	"ARABIC LIGATURE BEH WITH YEH ISOLATED FORM",
	"ARABIC LIGATURE TEH WITH JEEM ISOLATED FORM",
	"ARABIC LIGATURE TEH WITH HAH ISOLATED FORM",
	"ARABIC LIGATURE TEH WITH KHAH ISOLATED FORM",
	"ARABIC LIGATURE TEH WITH MEEM ISOLATED FORM",
	"ARABIC LIGATURE TEH WITH ALEF MAKSURA ISOLATED FORM",
	"ARABIC LIGATURE TEH WITH YEH ISOLATED FORM",
	"ARABIC LIGATURE THEH WITH JEEM ISOLATED FORM",
	"ARABIC LIGATURE THEH WITH MEEM ISOLATED FORM",
	"ARABIC LIGATURE THEH WITH ALEF MAKSURA ISOLATED FORM",
	"ARABIC LIGATURE THEH WITH YEH ISOLATED FORM",
	"ARABIC LIGATURE JEEM WITH HAH ISOLATED FORM",
	"ARABIC LIGATURE JEEM WITH MEEM ISOLATED FORM",
	"ARABIC LIGATURE HAH WITH JEEM ISOLATED FORM",
	"ARABIC LIGATURE HAH WITH MEEM ISOLATED FORM",
	"ARABIC LIGATURE KHAH WITH JEEM ISOLATED FORM",
	"ARABIC LIGATURE KHAH WITH HAH ISOLATED FORM",
	"ARABIC LIGATURE KHAH WITH MEEM ISOLATED FORM",
	"ARABIC LIGATURE SEEN WITH JEEM ISOLATED FORM",
	"ARABIC LIGATURE SEEN WITH HAH ISOLATED FORM",
	"ARABIC LIGATURE SEEN WITH KHAH ISOLATED FORM",
	"ARABIC LIGATURE SEEN WITH MEEM ISOLATED FORM",
	"ARABIC LIGATURE SAD WITH HAH ISOLATED FORM",
	"ARABIC LIGATURE SAD WITH MEEM ISOLATED FORM",
	"ARABIC LIGATURE DAD WITH JEEM ISOLATED FORM",
	"ARABIC LIGATURE DAD WITH HAH ISOLATED FORM",
	"ARABIC LIGATURE DAD WITH KHAH ISOLATED FORM",
	"ARABIC LIGATURE DAD WITH MEEM ISOLATED FORM",
	"ARABIC LIGATURE TAH WITH HAH ISOLATED FORM",
	"ARABIC LIGATURE TAH WITH MEEM ISOLATED FORM",
	"ARABIC LIGATURE ZAH WITH MEEM ISOLATED FORM",
	"ARABIC LIGATURE AIN WITH JEEM ISOLATED FORM",
	"ARABIC LIGATURE AIN WITH MEEM ISOLATED FORM",
	"ARABIC LIGATURE GHAIN WITH JEEM ISOLATED FORM",
	"ARABIC LIGATURE GHAIN WITH MEEM ISOLATED FORM",
	"ARABIC LIGATURE FEH WITH JEEM ISOLATED FORM",
	"ARABIC LIGATURE FEH WITH HAH ISOLATED FORM",
	"ARABIC LIGATURE FEH WITH KHAH ISOLATED FORM",
	"ARABIC LIGATURE FEH WITH MEEM ISOLATED FORM",
	"ARABIC LIGATURE FEH WITH ALEF MAKSURA ISOLATED FORM",
	"ARABIC LIGATURE FEH WITH YEH ISOLATED FORM",
	"ARABIC LIGATURE QAF WITH HAH ISOLATED FORM",
	"ARABIC LIGATURE QAF WITH MEEM ISOLATED FORM",
	"ARABIC LIGATURE QAF WITH ALEF MAKSURA ISOLATED FORM",
	"ARABIC LIGATURE QAF WITH YEH ISOLATED FORM",
	"ARABIC LIGATURE KAF WITH ALEF ISOLATED FORM",
	"ARABIC LIGATURE KAF WITH JEEM ISOLATED FORM",
	"ARABIC LIGATURE KAF WITH HAH ISOLATED FORM",
	"ARABIC LIGATURE KAF WITH KHAH ISOLATED FORM",
	"ARABIC LIGATURE KAF WITH LAM ISOLATED FORM",
	"ARABIC LIGATURE KAF WITH MEEM ISOLATED FORM",
	"ARABIC LIGATURE KAF WITH ALEF MAKSURA ISOLATED FORM",
	"ARABIC LIGATURE KAF WITH YEH ISOLATED FORM",
	"ARABIC LIGATURE LAM WITH JEEM ISOLATED FORM",
	"ARABIC LIGATURE LAM WITH HAH ISOLATED FORM",
	"ARABIC LIGATURE LAM WITH KHAH ISOLATED FORM",
	"ARABIC LIGATURE LAM WITH MEEM ISOLATED FORM",
	"ARABIC LIGATURE LAM WITH ALEF MAKSURA ISOLATED FORM",
	"ARABIC LIGATURE LAM WITH YEH ISOLATED FORM",
	"ARABIC LIGATURE MEEM WITH JEEM ISOLATED FORM",
	"ARABIC LIGATURE MEEM WITH HAH ISOLATED FORM",
	"ARABIC LIGATURE MEEM WITH KHAH ISOLATED FORM",
	"ARABIC LIGATURE MEEM WITH MEEM ISOLATED FORM",
	"ARABIC LIGATURE MEEM WITH ALEF MAKSURA ISOLATED FORM",
	"ARABIC LIGATURE MEEM WITH YEH ISOLATED FORM",
	"ARABIC LIGATURE NOON WITH JEEM ISOLATED FORM",
	"ARABIC LIGATURE NOON WITH HAH ISOLATED FORM",
	"ARABIC LIGATURE NOON WITH KHAH ISOLATED FORM",
	"ARABIC LIGATURE NOON WITH MEEM ISOLATED FORM",
	"ARABIC LIGATURE NOON WITH ALEF MAKSURA ISOLATED FORM",
	"ARABIC LIGATURE NOON WITH YEH ISOLATED FORM",
	"ARABIC LIGATURE HEH WITH JEEM ISOLATED FORM",
	"ARABIC LIGATURE HEH WITH MEEM ISOLATED FORM",
	"ARABIC LIGATURE HEH WITH ALEF MAKSURA ISOLATED FORM",
	"ARABIC LIGATURE HEH WITH YEH ISOLATED FORM",
	"ARABIC LIGATURE YEH WITH JEEM ISOLATED FORM",
	"ARABIC LIGATURE YEH WITH HAH ISOLATED FORM",
	"ARABIC LIGATURE YEH WITH KHAH ISOLATED FORM",
	"ARABIC LIGATURE YEH WITH MEEM ISOLATED FORM",
	"ARABIC LIGATURE YEH WITH ALEF MAKSURA ISOLATED FORM",
	"ARABIC LIGATURE YEH WITH YEH ISOLATED FORM",
	"ARABIC LIGATURE THAL WITH SUPERSCRIPT ALEF ISOLATED FORM",
	"ARABIC LIGATURE REH WITH SUPERSCRIPT ALEF ISOLATED FORM",
	"ARABIC LIGATURE ALEF MAKSURA WITH SUPERSCRIPT ALEF ISOLATED FORM",
	"ARABIC LIGATURE SHADDA WITH DAMMATAN ISOLATED FORM",
	"ARABIC LIGATURE SHADDA WITH KASRATAN ISOLATED FORM",
	"ARABIC LIGATURE SHADDA WITH FATHA ISOLATED FORM",
	"ARABIC LIGATURE SHADDA WITH DAMMA ISOLATED FORM",
	"ARABIC LIGATURE SHADDA WITH KASRA ISOLATED FORM",
	"ARABIC LIGATURE SHADDA WITH SUPERSCRIPT ALEF ISOLATED FORM",
	"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH REH FINAL FORM",
	"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ZAIN FINAL FORM",
	"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM FINAL FORM",
	"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH NOON FINAL FORM",
	"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF MAKSURA FINAL FORM",
	"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YEH FINAL FORM",
	"ARABIC LIGATURE BEH WITH REH FINAL FORM",
	"ARABIC LIGATURE BEH WITH ZAIN FINAL FORM",
	"ARABIC LIGATURE BEH WITH MEEM FINAL FORM",
	"ARABIC LIGATURE BEH WITH NOON FINAL FORM",
	"ARABIC LIGATURE BEH WITH ALEF MAKSURA FINAL FORM",
	"ARABIC LIGATURE BEH WITH YEH FINAL FORM",
	"ARABIC LIGATURE TEH WITH REH FINAL FORM",
	"ARABIC LIGATURE TEH WITH ZAIN FINAL FORM",
	"ARABIC LIGATURE TEH WITH MEEM FINAL FORM",
	"ARABIC LIGATURE TEH WITH NOON FINAL FORM",
	"ARABIC LIGATURE TEH WITH ALEF MAKSURA FINAL FORM",
	"ARABIC LIGATURE TEH WITH YEH FINAL FORM",
	"ARABIC LIGATURE THEH WITH REH FINAL FORM",
	"ARABIC LIGATURE THEH WITH ZAIN FINAL FORM",
	"ARABIC LIGATURE THEH WITH MEEM FINAL FORM",
	"ARABIC LIGATURE THEH WITH NOON FINAL FORM",
	"ARABIC LIGATURE THEH WITH ALEF MAKSURA FINAL FORM",
	"ARABIC LIGATURE THEH WITH YEH FINAL FORM",
	"ARABIC LIGATURE FEH WITH ALEF MAKSURA FINAL FORM",
	"ARABIC LIGATURE FEH WITH YEH FINAL FORM",
	"ARABIC LIGATURE QAF WITH ALEF MAKSURA FINAL FORM",
	"ARABIC LIGATURE QAF WITH YEH FINAL FORM",
	"ARABIC LIGATURE KAF WITH ALEF FINAL FORM",
	"ARABIC LIGATURE KAF WITH LAM FINAL FORM",
	"ARABIC LIGATURE KAF WITH MEEM FINAL FORM",
	"ARABIC LIGATURE KAF WITH ALEF MAKSURA FINAL FORM",
	"ARABIC LIGATURE KAF WITH YEH FINAL FORM",
	"ARABIC LIGATURE LAM WITH MEEM FINAL FORM",
	"ARABIC LIGATURE LAM WITH ALEF MAKSURA FINAL FORM",
	"ARABIC LIGATURE LAM WITH YEH FINAL FORM",
	"ARABIC LIGATURE MEEM WITH ALEF FINAL FORM",
	"ARABIC LIGATURE MEEM WITH MEEM FINAL FORM",
	"ARABIC LIGATURE NOON WITH REH FINAL FORM",
	"ARABIC LIGATURE NOON WITH ZAIN FINAL FORM",
	"ARABIC LIGATURE NOON WITH MEEM FINAL FORM",
	"ARABIC LIGATURE NOON WITH NOON FINAL FORM",
	"ARABIC LIGATURE NOON WITH ALEF MAKSURA FINAL FORM",
	"ARABIC LIGATURE NOON WITH YEH FINAL FORM",
	"ARABIC LIGATURE ALEF MAKSURA WITH SUPERSCRIPT ALEF FINAL FORM",
	"ARABIC LIGATURE YEH WITH REH FINAL FORM",
	"ARABIC LIGATURE YEH WITH ZAIN FINAL FORM",
	"ARABIC LIGATURE YEH WITH MEEM FINAL FORM",
	"ARABIC LIGATURE YEH WITH NOON FINAL FORM",
	"ARABIC LIGATURE YEH WITH ALEF MAKSURA FINAL FORM",
	"ARABIC LIGATURE YEH WITH YEH FINAL FORM",
	"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH JEEM INITIAL FORM",
	"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HAH INITIAL FORM",
	"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH KHAH INITIAL FORM",
	"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HEH INITIAL FORM",
	"ARABIC LIGATURE BEH WITH JEEM INITIAL FORM",
	"ARABIC LIGATURE BEH WITH HAH INITIAL FORM",
	"ARABIC LIGATURE BEH WITH KHAH INITIAL FORM",
	"ARABIC LIGATURE BEH WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE BEH WITH HEH INITIAL FORM",
	"ARABIC LIGATURE TEH WITH JEEM INITIAL FORM",
	"ARABIC LIGATURE TEH WITH HAH INITIAL FORM",
	"ARABIC LIGATURE TEH WITH KHAH INITIAL FORM",
	"ARABIC LIGATURE TEH WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE TEH WITH HEH INITIAL FORM",
	"ARABIC LIGATURE THEH WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE JEEM WITH HAH INITIAL FORM",
	"ARABIC LIGATURE JEEM WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE HAH WITH JEEM INITIAL FORM",
	"ARABIC LIGATURE HAH WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE KHAH WITH JEEM INITIAL FORM",
	"ARABIC LIGATURE KHAH WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE SEEN WITH JEEM INITIAL FORM",
	"ARABIC LIGATURE SEEN WITH HAH INITIAL FORM",
	"ARABIC LIGATURE SEEN WITH KHAH INITIAL FORM",
	"ARABIC LIGATURE SEEN WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE SAD WITH HAH INITIAL FORM",
	"ARABIC LIGATURE SAD WITH KHAH INITIAL FORM",
	"ARABIC LIGATURE SAD WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE DAD WITH JEEM INITIAL FORM",
	"ARABIC LIGATURE DAD WITH HAH INITIAL FORM",
	"ARABIC LIGATURE DAD WITH KHAH INITIAL FORM",
	"ARABIC LIGATURE DAD WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE TAH WITH HAH INITIAL FORM",
	"ARABIC LIGATURE ZAH WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE AIN WITH JEEM INITIAL FORM",
	"ARABIC LIGATURE AIN WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE GHAIN WITH JEEM INITIAL FORM",
	"ARABIC LIGATURE GHAIN WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE FEH WITH JEEM INITIAL FORM",
	"ARABIC LIGATURE FEH WITH HAH INITIAL FORM",
	"ARABIC LIGATURE FEH WITH KHAH INITIAL FORM",
	"ARABIC LIGATURE FEH WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE QAF WITH HAH INITIAL FORM",
	"ARABIC LIGATURE QAF WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE KAF WITH JEEM INITIAL FORM",
	"ARABIC LIGATURE KAF WITH HAH INITIAL FORM",
	"ARABIC LIGATURE KAF WITH KHAH INITIAL FORM",
	"ARABIC LIGATURE KAF WITH LAM INITIAL FORM",
	"ARABIC LIGATURE KAF WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE LAM WITH JEEM INITIAL FORM",
	"ARABIC LIGATURE LAM WITH HAH INITIAL FORM",
	"ARABIC LIGATURE LAM WITH KHAH INITIAL FORM",
	"ARABIC LIGATURE LAM WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE LAM WITH HEH INITIAL FORM",
	"ARABIC LIGATURE MEEM WITH JEEM INITIAL FORM",
	"ARABIC LIGATURE MEEM WITH HAH INITIAL FORM",
	"ARABIC LIGATURE MEEM WITH KHAH INITIAL FORM",
	"ARABIC LIGATURE MEEM WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE NOON WITH JEEM INITIAL FORM",
	"ARABIC LIGATURE NOON WITH HAH INITIAL FORM",
	"ARABIC LIGATURE NOON WITH KHAH INITIAL FORM",
	"ARABIC LIGATURE NOON WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE NOON WITH HEH INITIAL FORM",
	"ARABIC LIGATURE HEH WITH JEEM INITIAL FORM",
	"ARABIC LIGATURE HEH WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE HEH WITH SUPERSCRIPT ALEF INITIAL FORM",
	"ARABIC LIGATURE YEH WITH JEEM INITIAL FORM",
	"ARABIC LIGATURE YEH WITH HAH INITIAL FORM",
	"ARABIC LIGATURE YEH WITH KHAH INITIAL FORM",
	"ARABIC LIGATURE YEH WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE YEH WITH HEH INITIAL FORM",
	"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM MEDIAL FORM",
	"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HEH MEDIAL FORM",
	"ARABIC LIGATURE BEH WITH MEEM MEDIAL FORM",
	"ARABIC LIGATURE BEH WITH HEH MEDIAL FORM",
	"ARABIC LIGATURE TEH WITH MEEM MEDIAL FORM",
	"ARABIC LIGATURE TEH WITH HEH MEDIAL FORM",
	"ARABIC LIGATURE THEH WITH MEEM MEDIAL FORM",
	"ARABIC LIGATURE THEH WITH HEH MEDIAL FORM",
	"ARABIC LIGATURE SEEN WITH MEEM MEDIAL FORM",
	"ARABIC LIGATURE SEEN WITH HEH MEDIAL FORM",
	"ARABIC LIGATURE SHEEN WITH MEEM MEDIAL FORM",
	"ARABIC LIGATURE SHEEN WITH HEH MEDIAL FORM",
	"ARABIC LIGATURE KAF WITH LAM MEDIAL FORM",
	"ARABIC LIGATURE KAF WITH MEEM MEDIAL FORM",
	"ARABIC LIGATURE LAM WITH MEEM MEDIAL FORM",
	"ARABIC LIGATURE NOON WITH MEEM MEDIAL FORM",
	"ARABIC LIGATURE NOON WITH HEH MEDIAL FORM",
	"ARABIC LIGATURE YEH WITH MEEM MEDIAL FORM",
	"ARABIC LIGATURE YEH WITH HEH MEDIAL FORM",
	"ARABIC LIGATURE SHADDA WITH FATHA MEDIAL FORM",
	"ARABIC LIGATURE SHADDA WITH DAMMA MEDIAL FORM",
	"ARABIC LIGATURE SHADDA WITH KASRA MEDIAL FORM",
	"ARABIC LIGATURE TAH WITH ALEF MAKSURA ISOLATED FORM",
	"ARABIC LIGATURE TAH WITH YEH ISOLATED FORM",
	"ARABIC LIGATURE AIN WITH ALEF MAKSURA ISOLATED FORM",
	"ARABIC LIGATURE AIN WITH YEH ISOLATED FORM",
	"ARABIC LIGATURE GHAIN WITH ALEF MAKSURA ISOLATED FORM",
	"ARABIC LIGATURE GHAIN WITH YEH ISOLATED FORM",
	"ARABIC LIGATURE SEEN WITH ALEF MAKSURA ISOLATED FORM",
	"ARABIC LIGATURE SEEN WITH YEH ISOLATED FORM",
	"ARABIC LIGATURE SHEEN WITH ALEF MAKSURA ISOLATED FORM",
	"ARABIC LIGATURE SHEEN WITH YEH ISOLATED FORM",
	"ARABIC LIGATURE HAH WITH ALEF MAKSURA ISOLATED FORM",
	"ARABIC LIGATURE HAH WITH YEH ISOLATED FORM",
	"ARABIC LIGATURE JEEM WITH ALEF MAKSURA ISOLATED FORM",
	"ARABIC LIGATURE JEEM WITH YEH ISOLATED FORM",
	"ARABIC LIGATURE KHAH WITH ALEF MAKSURA ISOLATED FORM",
	"ARABIC LIGATURE KHAH WITH YEH ISOLATED FORM",
	"ARABIC LIGATURE SAD WITH ALEF MAKSURA ISOLATED FORM",
	"ARABIC LIGATURE SAD WITH YEH ISOLATED FORM",
	"ARABIC LIGATURE DAD WITH ALEF MAKSURA ISOLATED FORM",
	"ARABIC LIGATURE DAD WITH YEH ISOLATED FORM",
	"ARABIC LIGATURE SHEEN WITH JEEM ISOLATED FORM",
	"ARABIC LIGATURE SHEEN WITH HAH ISOLATED FORM",
	"ARABIC LIGATURE SHEEN WITH KHAH ISOLATED FORM",
	"ARABIC LIGATURE SHEEN WITH MEEM ISOLATED FORM",
	"ARABIC LIGATURE SHEEN WITH REH ISOLATED FORM",
	"ARABIC LIGATURE SEEN WITH REH ISOLATED FORM",
	"ARABIC LIGATURE SAD WITH REH ISOLATED FORM",
	"ARABIC LIGATURE DAD WITH REH ISOLATED FORM",
	"ARABIC LIGATURE TAH WITH ALEF MAKSURA FINAL FORM",
	"ARABIC LIGATURE TAH WITH YEH FINAL FORM",
	"ARABIC LIGATURE AIN WITH ALEF MAKSURA FINAL FORM",
	"ARABIC LIGATURE AIN WITH YEH FINAL FORM",
	"ARABIC LIGATURE GHAIN WITH ALEF MAKSURA FINAL FORM",
	"ARABIC LIGATURE GHAIN WITH YEH FINAL FORM",
	"ARABIC LIGATURE SEEN WITH ALEF MAKSURA FINAL FORM",
	"ARABIC LIGATURE SEEN WITH YEH FINAL FORM",
	"ARABIC LIGATURE SHEEN WITH ALEF MAKSURA FINAL FORM",
	"ARABIC LIGATURE SHEEN WITH YEH FINAL FORM",
	"ARABIC LIGATURE HAH WITH ALEF MAKSURA FINAL FORM",
	"ARABIC LIGATURE HAH WITH YEH FINAL FORM",
	"ARABIC LIGATURE JEEM WITH ALEF MAKSURA FINAL FORM",
	"ARABIC LIGATURE JEEM WITH YEH FINAL FORM",
	"ARABIC LIGATURE KHAH WITH ALEF MAKSURA FINAL FORM",
	"ARABIC LIGATURE KHAH WITH YEH FINAL FORM",
	"ARABIC LIGATURE SAD WITH ALEF MAKSURA FINAL FORM",
	"ARABIC LIGATURE SAD WITH YEH FINAL FORM",
	"ARABIC LIGATURE DAD WITH ALEF MAKSURA FINAL FORM",
	"ARABIC LIGATURE DAD WITH YEH FINAL FORM",
	"ARABIC LIGATURE SHEEN WITH JEEM FINAL FORM",
	"ARABIC LIGATURE SHEEN WITH HAH FINAL FORM",
	"ARABIC LIGATURE SHEEN WITH KHAH FINAL FORM",
	"ARABIC LIGATURE SHEEN WITH MEEM FINAL FORM",
	"ARABIC LIGATURE SHEEN WITH REH FINAL FORM",
	"ARABIC LIGATURE SEEN WITH REH FINAL FORM",
	"ARABIC LIGATURE SAD WITH REH FINAL FORM",
	"ARABIC LIGATURE DAD WITH REH FINAL FORM",
	"ARABIC LIGATURE SHEEN WITH JEEM INITIAL FORM",
	"ARABIC LIGATURE SHEEN WITH HAH INITIAL FORM",
	"ARABIC LIGATURE SHEEN WITH KHAH INITIAL FORM",
	"ARABIC LIGATURE SHEEN WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE SEEN WITH HEH INITIAL FORM",
	"ARABIC LIGATURE SHEEN WITH HEH INITIAL FORM",
	"ARABIC LIGATURE TAH WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE SEEN WITH JEEM MEDIAL FORM",
	"ARABIC LIGATURE SEEN WITH HAH MEDIAL FORM",
	"ARABIC LIGATURE SEEN WITH KHAH MEDIAL FORM",
	"ARABIC LIGATURE SHEEN WITH JEEM MEDIAL FORM",
	"ARABIC LIGATURE SHEEN WITH HAH MEDIAL FORM",
	"ARABIC LIGATURE SHEEN WITH KHAH MEDIAL FORM",
	"ARABIC LIGATURE TAH WITH MEEM MEDIAL FORM",
	"ARABIC LIGATURE ZAH WITH MEEM MEDIAL FORM",
	"ARABIC LIGATURE ALEF WITH FATHATAN FINAL FORM",
	"ARABIC LIGATURE ALEF WITH FATHATAN ISOLATED FORM",
	"ORNATE LEFT PARENTHESIS",
	"ORNATE RIGHT PARENTHESIS",
	"ARABIC LIGATURE RAHIMAHU ALLAAH",
	"ARABIC LIGATURE RADI ALLAAHU ANH",
	"ARABIC LIGATURE RADI ALLAAHU ANHAA",
	"ARABIC LIGATURE RADI ALLAAHU ANHUM",
	"ARABIC LIGATURE RADI ALLAAHU ANHUMAA",
	"ARABIC LIGATURE RADI ALLAAHU ANHUNNA",
	"ARABIC LIGATURE SALLALLAAHU ALAYHI WA-AALIH",
	"ARABIC LIGATURE ALAYHI AS-SALAAM",
	"ARABIC LIGATURE ALAYHIM AS-SALAAM",
	"ARABIC LIGATURE ALAYHIMAA AS-SALAAM",
	"ARABIC LIGATURE ALAYHI AS-SALAATU WAS-SALAAM",
	"ARABIC LIGATURE QUDDISA SIRRAH",
	"ARABIC LIGATURE SALLALLAHU ALAYHI WAAALIHEE WA-SALLAM",
	"ARABIC LIGATURE ALAYHAA AS-SALAAM",
	"ARABIC LIGATURE TABAARAKA WA-TAAALAA",
	"ARABIC LIGATURE RAHIMAHUM ALLAAH",
	"ARABIC LIGATURE TEH WITH JEEM WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE TEH WITH HAH WITH JEEM FINAL FORM",
	"ARABIC LIGATURE TEH WITH HAH WITH JEEM INITIAL FORM",
	"ARABIC LIGATURE TEH WITH HAH WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE TEH WITH KHAH WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE TEH WITH MEEM WITH JEEM INITIAL FORM",
	"ARABIC LIGATURE TEH WITH MEEM WITH HAH INITIAL FORM",
	"ARABIC LIGATURE TEH WITH MEEM WITH KHAH INITIAL FORM",
	"ARABIC LIGATURE JEEM WITH MEEM WITH HAH FINAL FORM",
	"ARABIC LIGATURE JEEM WITH MEEM WITH HAH INITIAL FORM",
	"ARABIC LIGATURE HAH WITH MEEM WITH YEH FINAL FORM",
	"ARABIC LIGATURE HAH WITH MEEM WITH ALEF MAKSURA FINAL FORM",
	"ARABIC LIGATURE SEEN WITH HAH WITH JEEM INITIAL FORM",
	"ARABIC LIGATURE SEEN WITH JEEM WITH HAH INITIAL FORM",
	"ARABIC LIGATURE SEEN WITH JEEM WITH ALEF MAKSURA FINAL FORM",
	"ARABIC LIGATURE SEEN WITH MEEM WITH HAH FINAL FORM",
	"ARABIC LIGATURE SEEN WITH MEEM WITH HAH INITIAL FORM",
	"ARABIC LIGATURE SEEN WITH MEEM WITH JEEM INITIAL FORM",
	"ARABIC LIGATURE SEEN WITH MEEM WITH MEEM FINAL FORM",
	"ARABIC LIGATURE SEEN WITH MEEM WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE SAD WITH HAH WITH HAH FINAL FORM",
	"ARABIC LIGATURE SAD WITH HAH WITH HAH INITIAL FORM",
	"ARABIC LIGATURE SAD WITH MEEM WITH MEEM FINAL FORM",
	"ARABIC LIGATURE SHEEN WITH HAH WITH MEEM FINAL FORM",
	"ARABIC LIGATURE SHEEN WITH HAH WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE SHEEN WITH JEEM WITH YEH FINAL FORM",
	"ARABIC LIGATURE SHEEN WITH MEEM WITH KHAH FINAL FORM",
	"ARABIC LIGATURE SHEEN WITH MEEM WITH KHAH INITIAL FORM",
	"ARABIC LIGATURE SHEEN WITH MEEM WITH MEEM FINAL FORM",
	"ARABIC LIGATURE SHEEN WITH MEEM WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE DAD WITH HAH WITH ALEF MAKSURA FINAL FORM",
	"ARABIC LIGATURE DAD WITH KHAH WITH MEEM FINAL FORM",
	"ARABIC LIGATURE DAD WITH KHAH WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE TAH WITH MEEM WITH HAH FINAL FORM",
	"ARABIC LIGATURE TAH WITH MEEM WITH HAH INITIAL FORM",
	"ARABIC LIGATURE TAH WITH MEEM WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE TAH WITH MEEM WITH YEH FINAL FORM",
	"ARABIC LIGATURE AIN WITH JEEM WITH MEEM FINAL FORM",
	"ARABIC LIGATURE AIN WITH MEEM WITH MEEM FINAL FORM",
	"ARABIC LIGATURE AIN WITH MEEM WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE AIN WITH MEEM WITH ALEF MAKSURA FINAL FORM",
	"ARABIC LIGATURE GHAIN WITH MEEM WITH MEEM FINAL FORM",
	"ARABIC LIGATURE GHAIN WITH MEEM WITH YEH FINAL FORM",
	"ARABIC LIGATURE GHAIN WITH MEEM WITH ALEF MAKSURA FINAL FORM",
	"ARABIC LIGATURE FEH WITH KHAH WITH MEEM FINAL FORM",
	"ARABIC LIGATURE FEH WITH KHAH WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE QAF WITH MEEM WITH HAH FINAL FORM",
	"ARABIC LIGATURE QAF WITH MEEM WITH MEEM FINAL FORM",
	"ARABIC LIGATURE LAM WITH HAH WITH MEEM FINAL FORM",
	"ARABIC LIGATURE LAM WITH HAH WITH YEH FINAL FORM",
	"ARABIC LIGATURE LAM WITH HAH WITH ALEF MAKSURA FINAL FORM",
	"ARABIC LIGATURE LAM WITH JEEM WITH JEEM INITIAL FORM",
	"ARABIC LIGATURE LAM WITH JEEM WITH JEEM FINAL FORM",
	"ARABIC LIGATURE LAM WITH KHAH WITH MEEM FINAL FORM",
	"ARABIC LIGATURE LAM WITH KHAH WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE LAM WITH MEEM WITH HAH FINAL FORM",
	"ARABIC LIGATURE LAM WITH MEEM WITH HAH INITIAL FORM",
	"ARABIC LIGATURE MEEM WITH HAH WITH JEEM INITIAL FORM",
	"ARABIC LIGATURE MEEM WITH HAH WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE MEEM WITH HAH WITH YEH FINAL FORM",
	"ARABIC LIGATURE MEEM WITH JEEM WITH HAH INITIAL FORM",
	"ARABIC LIGATURE MEEM WITH JEEM WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE MEEM WITH KHAH WITH JEEM INITIAL FORM",
	"ARABIC LIGATURE MEEM WITH KHAH WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE MEEM WITH JEEM WITH KHAH INITIAL FORM",
	"ARABIC LIGATURE HEH WITH MEEM WITH JEEM INITIAL FORM",
	"ARABIC LIGATURE HEH WITH MEEM WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE NOON WITH HAH WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE NOON WITH HAH WITH ALEF MAKSURA FINAL FORM",
	"ARABIC LIGATURE NOON WITH JEEM WITH MEEM FINAL FORM",
	"ARABIC LIGATURE NOON WITH JEEM WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE NOON WITH JEEM WITH ALEF MAKSURA FINAL FORM",
	"ARABIC LIGATURE NOON WITH MEEM WITH YEH FINAL FORM",
	"ARABIC LIGATURE NOON WITH MEEM WITH ALEF MAKSURA FINAL FORM",
	"ARABIC LIGATURE YEH WITH MEEM WITH MEEM FINAL FORM",
	"ARABIC LIGATURE YEH WITH MEEM WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE BEH WITH KHAH WITH YEH FINAL FORM",
	"ARABIC LIGATURE TEH WITH JEEM WITH YEH FINAL FORM",
	"ARABIC LIGATURE TEH WITH JEEM WITH ALEF MAKSURA FINAL FORM",
	"ARABIC LIGATURE TEH WITH KHAH WITH YEH FINAL FORM",
	"ARABIC LIGATURE TEH WITH KHAH WITH ALEF MAKSURA FINAL FORM",
	"ARABIC LIGATURE TEH WITH MEEM WITH YEH FINAL FORM",
	"ARABIC LIGATURE TEH WITH MEEM WITH ALEF MAKSURA FINAL FORM",
	"ARABIC LIGATURE JEEM WITH MEEM WITH YEH FINAL FORM",
	"ARABIC LIGATURE JEEM WITH HAH WITH ALEF MAKSURA FINAL FORM",
	"ARABIC LIGATURE JEEM WITH MEEM WITH ALEF MAKSURA FINAL FORM",
	"ARABIC LIGATURE SEEN WITH KHAH WITH ALEF MAKSURA FINAL FORM",
	"ARABIC LIGATURE SAD WITH HAH WITH YEH FINAL FORM",
	"ARABIC LIGATURE SHEEN WITH HAH WITH YEH FINAL FORM",
	"ARABIC LIGATURE DAD WITH HAH WITH YEH FINAL FORM",
	"ARABIC LIGATURE LAM WITH JEEM WITH YEH FINAL FORM",
	"ARABIC LIGATURE LAM WITH MEEM WITH YEH FINAL FORM",
	"ARABIC LIGATURE YEH WITH HAH WITH YEH FINAL FORM",
	"ARABIC LIGATURE YEH WITH JEEM WITH YEH FINAL FORM",
	"ARABIC LIGATURE YEH WITH MEEM WITH YEH FINAL FORM",
	"ARABIC LIGATURE MEEM WITH MEEM WITH YEH FINAL FORM",
	"ARABIC LIGATURE QAF WITH MEEM WITH YEH FINAL FORM",
	"ARABIC LIGATURE NOON WITH HAH WITH YEH FINAL FORM",
	"ARABIC LIGATURE QAF WITH MEEM WITH HAH INITIAL FORM",
	"ARABIC LIGATURE LAM WITH HAH WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE AIN WITH MEEM WITH YEH FINAL FORM",
	"ARABIC LIGATURE KAF WITH MEEM WITH YEH FINAL FORM",
	"ARABIC LIGATURE NOON WITH JEEM WITH HAH INITIAL FORM",
	"ARABIC LIGATURE MEEM WITH KHAH WITH YEH FINAL FORM",
	"ARABIC LIGATURE LAM WITH JEEM WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE KAF WITH MEEM WITH MEEM FINAL FORM",
	"ARABIC LIGATURE LAM WITH JEEM WITH MEEM FINAL FORM",
	"ARABIC LIGATURE NOON WITH JEEM WITH HAH FINAL FORM",
	"ARABIC LIGATURE JEEM WITH HAH WITH YEH FINAL FORM",
	"ARABIC LIGATURE HAH WITH JEEM WITH YEH FINAL FORM",
	"ARABIC LIGATURE MEEM WITH JEEM WITH YEH FINAL FORM",
	"ARABIC LIGATURE FEH WITH MEEM WITH YEH FINAL FORM",
	"ARABIC LIGATURE BEH WITH HAH WITH YEH FINAL FORM",
	"ARABIC LIGATURE KAF WITH MEEM WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE AIN WITH JEEM WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE SAD WITH MEEM WITH MEEM INITIAL FORM",
	"ARABIC LIGATURE SEEN WITH KHAH WITH YEH FINAL FORM",
	"ARABIC LIGATURE NOON WITH JEEM WITH YEH FINAL FORM",
	"ARABIC LIGATURE SALAAMUHU ALAYNAA",
	"ARABIC LIGATURE SALLA USED AS KORANIC STOP SIGN ISOLATED FORM",
	"ARABIC LIGATURE QALA USED AS KORANIC STOP SIGN ISOLATED FORM",
	"ARABIC LIGATURE ALLAH ISOLATED FORM",
	"ARABIC LIGATURE AKBAR ISOLATED FORM",
	"ARABIC LIGATURE MOHAMMAD ISOLATED FORM",
	"ARABIC LIGATURE SALAM ISOLATED FORM",
	"ARABIC LIGATURE RASOUL ISOLATED FORM",
	"ARABIC LIGATURE ALAYHE ISOLATED FORM",
	"ARABIC LIGATURE WASALLAM ISOLATED FORM",
	"ARABIC LIGATURE SALLA ISOLATED FORM",
	"ARABIC LIGATURE SALLALLAHOU ALAYHE WASALLAM",
	"ARABIC LIGATURE JALLAJALALOUHOU",
	"RIAL SIGN",
	"ARABIC LIGATURE BISMILLAH AR-RAHMAN AR-RAHEEM",
	"ARABIC LIGATURE SUBHAANAHU WA TAAALAA",
	"ARABIC LIGATURE AZZA WA JALL",
	"VARIATION SELECTOR-1",
	"VARIATION SELECTOR-2",
	"VARIATION SELECTOR-3",
	"VARIATION SELECTOR-4",
	"VARIATION SELECTOR-5",
	"VARIATION SELECTOR-6",
	"VARIATION SELECTOR-7",
	"VARIATION SELECTOR-8",
	"VARIATION SELECTOR-9",
	"VARIATION SELECTOR-10",
	"VARIATION SELECTOR-11",
	"VARIATION SELECTOR-12",
	"VARIATION SELECTOR-13",
	"VARIATION SELECTOR-14",
	"VARIATION SELECTOR-15",
	"VARIATION SELECTOR-16",
	"PRESENTATION FORM FOR VERTICAL COMMA",
	"PRESENTATION FORM FOR VERTICAL IDEOGRAPHIC COMMA",
	"PRESENTATION FORM FOR VERTICAL IDEOGRAPHIC FULL STOP",
	"PRESENTATION FORM FOR VERTICAL COLON",
	"PRESENTATION FORM FOR VERTICAL SEMICOLON",
	"PRESENTATION FORM FOR VERTICAL EXCLAMATION MARK",
	"PRESENTATION FORM FOR VERTICAL QUESTION MARK",
	"PRESENTATION FORM FOR VERTICAL LEFT WHITE LENTICULAR BRACKET",
	"PRESENTATION FORM FOR VERTICAL RIGHT WHITE LENTICULAR BRAKCET",
	"PRESENTATION FORM FOR VERTICAL HORIZONTAL ELLIPSIS",
	"COMBINING LIGATURE LEFT HALF",
	"COMBINING LIGATURE RIGHT HALF",
	"COMBINING DOUBLE TILDE LEFT HALF",
	"COMBINING DOUBLE TILDE RIGHT HALF",
	"COMBINING MACRON LEFT HALF",
	"COMBINING MACRON RIGHT HALF",
	"COMBINING CONJOINING MACRON",
	"COMBINING LIGATURE LEFT HALF BELOW",
	"COMBINING LIGATURE RIGHT HALF BELOW",
	"COMBINING TILDE LEFT HALF BELOW",
	"COMBINING TILDE RIGHT HALF BELOW",
	"COMBINING MACRON LEFT HALF BELOW",
	"COMBINING MACRON RIGHT HALF BELOW",
	"COMBINING CONJOINING MACRON BELOW",
	"COMBINING CYRILLIC TITLO LEFT HALF",
	"COMBINING CYRILLIC TITLO RIGHT HALF",
	"PRESENTATION FORM FOR VERTICAL TWO DOT LEADER",
	"PRESENTATION FORM FOR VERTICAL EM DASH",
	"PRESENTATION FORM FOR VERTICAL EN DASH",
	"PRESENTATION FORM FOR VERTICAL LOW LINE",
	"PRESENTATION FORM FOR VERTICAL WAVY LOW LINE",
	"PRESENTATION FORM FOR VERTICAL LEFT PARENTHESIS",
	"PRESENTATION FORM FOR VERTICAL RIGHT PARENTHESIS",
	"PRESENTATION FORM FOR VERTICAL LEFT CURLY BRACKET",
	"PRESENTATION FORM FOR VERTICAL RIGHT CURLY BRACKET",
	"PRESENTATION FORM FOR VERTICAL LEFT TORTOISE SHELL BRACKET",
	"PRESENTATION FORM FOR VERTICAL RIGHT TORTOISE SHELL BRACKET",
	"PRESENTATION FORM FOR VERTICAL LEFT BLACK LENTICULAR BRACKET",
	"PRESENTATION FORM FOR VERTICAL RIGHT BLACK LENTICULAR BRACKET",
	"PRESENTATION FORM FOR VERTICAL LEFT DOUBLE ANGLE BRACKET",
	"PRESENTATION FORM FOR VERTICAL RIGHT DOUBLE ANGLE BRACKET",
	"PRESENTATION FORM FOR VERTICAL LEFT ANGLE BRACKET",
	"PRESENTATION FORM FOR VERTICAL RIGHT ANGLE BRACKET",
	"PRESENTATION FORM FOR VERTICAL LEFT CORNER BRACKET",
	"PRESENTATION FORM FOR VERTICAL RIGHT CORNER BRACKET",
	"PRESENTATION FORM FOR VERTICAL LEFT WHITE CORNER BRACKET",
	"PRESENTATION FORM FOR VERTICAL RIGHT WHITE CORNER BRACKET",
	"SESAME DOT",
	"WHITE SESAME DOT",
	"PRESENTATION FORM FOR VERTICAL LEFT SQUARE BRACKET",
	"PRESENTATION FORM FOR VERTICAL RIGHT SQUARE BRACKET",
	"DASHED OVERLINE",
	"CENTRELINE OVERLINE",
	"WAVY OVERLINE",
	"DOUBLE WAVY OVERLINE",
	"DASHED LOW LINE",
	"CENTRELINE LOW LINE",
	"WAVY LOW LINE",
	"SMALL COMMA",
	"SMALL IDEOGRAPHIC COMMA",
	"SMALL FULL STOP",
	"SMALL SEMICOLON",
	"SMALL COLON",
	"SMALL QUESTION MARK",
	"SMALL EXCLAMATION MARK",
	"SMALL EM DASH",
	"SMALL LEFT PARENTHESIS",
	"SMALL RIGHT PARENTHESIS",
	"SMALL LEFT CURLY BRACKET",
	"SMALL RIGHT CURLY BRACKET",
	"SMALL LEFT TORTOISE SHELL BRACKET",
	"SMALL RIGHT TORTOISE SHELL BRACKET",
	"SMALL NUMBER SIGN",
	"SMALL AMPERSAND",
	"SMALL ASTERISK",
	"SMALL PLUS SIGN",
	"SMALL HYPHEN-MINUS",
	"SMALL LESS-THAN SIGN",
	"SMALL GREATER-THAN SIGN",
	"SMALL EQUALS SIGN",
	"SMALL REVERSE SOLIDUS",
	"SMALL DOLLAR SIGN",
	"SMALL PERCENT SIGN",
	"SMALL COMMERCIAL AT",
	"ARABIC FATHATAN ISOLATED FORM",
	"ARABIC TATWEEL WITH FATHATAN ABOVE",
	"ARABIC DAMMATAN ISOLATED FORM",
	"ARABIC TAIL FRAGMENT",
	"ARABIC KASRATAN ISOLATED FORM",
	"ARABIC FATHA ISOLATED FORM",
	"ARABIC FATHA MEDIAL FORM",
	"ARABIC DAMMA ISOLATED FORM",
	"ARABIC DAMMA MEDIAL FORM",
	"ARABIC KASRA ISOLATED FORM",
	"ARABIC KASRA MEDIAL FORM",
	"ARABIC SHADDA ISOLATED FORM",
	"ARABIC SHADDA MEDIAL FORM",
	"ARABIC SUKUN ISOLATED FORM",
	"ARABIC SUKUN MEDIAL FORM",
	"ARABIC LETTER HAMZA ISOLATED FORM",
	"ARABIC LETTER ALEF WITH MADDA ABOVE ISOLATED FORM",
	"ARABIC LETTER ALEF WITH MADDA ABOVE FINAL FORM",
	"ARABIC LETTER ALEF WITH HAMZA ABOVE ISOLATED FORM",
	"ARABIC LETTER ALEF WITH HAMZA ABOVE FINAL FORM",
	"ARABIC LETTER WAW WITH HAMZA ABOVE ISOLATED FORM",
	"ARABIC LETTER WAW WITH HAMZA ABOVE FINAL FORM",
	"ARABIC LETTER ALEF WITH HAMZA BELOW ISOLATED FORM",
	"ARABIC LETTER ALEF WITH HAMZA BELOW FINAL FORM",
	"ARABIC LETTER YEH WITH HAMZA ABOVE ISOLATED FORM",
	"ARABIC LETTER YEH WITH HAMZA ABOVE FINAL FORM",
	"ARABIC LETTER YEH WITH HAMZA ABOVE INITIAL FORM",
	"ARABIC LETTER YEH WITH HAMZA ABOVE MEDIAL FORM",
	"ARABIC LETTER ALEF ISOLATED FORM",
	"ARABIC LETTER ALEF FINAL FORM",
	"ARABIC LETTER BEH ISOLATED FORM",
	"ARABIC LETTER BEH FINAL FORM",
	"ARABIC LETTER BEH INITIAL FORM",
	"ARABIC LETTER BEH MEDIAL FORM",
	"ARABIC LETTER TEH MARBUTA ISOLATED FORM",
	"ARABIC LETTER TEH MARBUTA FINAL FORM",
	"ARABIC LETTER TEH ISOLATED FORM",
	"ARABIC LETTER TEH FINAL FORM",
	"ARABIC LETTER TEH INITIAL FORM",
	"ARABIC LETTER TEH MEDIAL FORM",
	"ARABIC LETTER THEH ISOLATED FORM",
	"ARABIC LETTER THEH FINAL FORM",
	"ARABIC LETTER THEH INITIAL FORM",
	"ARABIC LETTER THEH MEDIAL FORM",
	"ARABIC LETTER JEEM ISOLATED FORM",
	"ARABIC LETTER JEEM FINAL FORM",
	"ARABIC LETTER JEEM INITIAL FORM",
	"ARABIC LETTER JEEM MEDIAL FORM",
	"ARABIC LETTER HAH ISOLATED FORM",
	"ARABIC LETTER HAH FINAL FORM",
	"ARABIC LETTER HAH INITIAL FORM",
	"ARABIC LETTER HAH MEDIAL FORM",
	"ARABIC LETTER KHAH ISOLATED FORM",
	"ARABIC LETTER KHAH FINAL FORM",
	"ARABIC LETTER KHAH INITIAL FORM",
	"ARABIC LETTER KHAH MEDIAL FORM",
	"ARABIC LETTER DAL ISOLATED FORM",
	"ARABIC LETTER DAL FINAL FORM",
	"ARABIC LETTER THAL ISOLATED FORM",
	"ARABIC LETTER THAL FINAL FORM",
	"ARABIC LETTER REH ISOLATED FORM",
	"ARABIC LETTER REH FINAL FORM",
	"ARABIC LETTER ZAIN ISOLATED FORM",
	"ARABIC LETTER ZAIN FINAL FORM",
	"ARABIC LETTER SEEN ISOLATED FORM",
	"ARABIC LETTER SEEN FINAL FORM",
	"ARABIC LETTER SEEN INITIAL FORM",
	"ARABIC LETTER SEEN MEDIAL FORM",
	"ARABIC LETTER SHEEN ISOLATED FORM",
	"ARABIC LETTER SHEEN FINAL FORM",
	"ARABIC LETTER SHEEN INITIAL FORM",
	"ARABIC LETTER SHEEN MEDIAL FORM",
	"ARABIC LETTER SAD ISOLATED FORM",
	"ARABIC LETTER SAD FINAL FORM",
	"ARABIC LETTER SAD INITIAL FORM",
	"ARABIC LETTER SAD MEDIAL FORM",
	"ARABIC LETTER DAD ISOLATED FORM",
	"ARABIC LETTER DAD FINAL FORM",
	"ARABIC LETTER DAD INITIAL FORM",
	"ARABIC LETTER DAD MEDIAL FORM",
	"ARABIC LETTER TAH ISOLATED FORM",
	"ARABIC LETTER TAH FINAL FORM",
	"ARABIC LETTER TAH INITIAL FORM",
	"ARABIC LETTER TAH MEDIAL FORM",
	"ARABIC LETTER ZAH ISOLATED FORM",
	"ARABIC LETTER ZAH FINAL FORM",
	"ARABIC LETTER ZAH INITIAL FORM",
	"ARABIC LETTER ZAH MEDIAL FORM",
	"ARABIC LETTER AIN ISOLATED FORM",
	"ARABIC LETTER AIN FINAL FORM",
	"ARABIC LETTER AIN INITIAL FORM",
	"ARABIC LETTER AIN MEDIAL FORM",
	"ARABIC LETTER GHAIN ISOLATED FORM",
	"ARABIC LETTER GHAIN FINAL FORM",
	"ARABIC LETTER GHAIN INITIAL FORM",
	"ARABIC LETTER GHAIN MEDIAL FORM",
	"ARABIC LETTER FEH ISOLATED FORM",
	"ARABIC LETTER FEH FINAL FORM",
	"ARABIC LETTER FEH INITIAL FORM",
	"ARABIC LETTER FEH MEDIAL FORM",
	"ARABIC LETTER QAF ISOLATED FORM",
	"ARABIC LETTER QAF FINAL FORM",
	"ARABIC LETTER QAF INITIAL FORM",
	"ARABIC LETTER QAF MEDIAL FORM",
	"ARABIC LETTER KAF ISOLATED FORM",
	"ARABIC LETTER KAF FINAL FORM",
	"ARABIC LETTER KAF INITIAL FORM",
	"ARABIC LETTER KAF MEDIAL FORM",
	"ARABIC LETTER LAM ISOLATED FORM",
	"ARABIC LETTER LAM FINAL FORM",
	"ARABIC LETTER LAM INITIAL FORM",
	"ARABIC LETTER LAM MEDIAL FORM",
	"ARABIC LETTER MEEM ISOLATED FORM",
	"ARABIC LETTER MEEM FINAL FORM",
	"ARABIC LETTER MEEM INITIAL FORM",
	"ARABIC LETTER MEEM MEDIAL FORM",
	"ARABIC LETTER NOON ISOLATED FORM",
	"ARABIC LETTER NOON FINAL FORM",
	"ARABIC LETTER NOON INITIAL FORM",
	"ARABIC LETTER NOON MEDIAL FORM",
	"ARABIC LETTER HEH ISOLATED FORM",
	"ARABIC LETTER HEH FINAL FORM",
	"ARABIC LETTER HEH INITIAL FORM",
	"ARABIC LETTER HEH MEDIAL FORM",
	"ARABIC LETTER WAW ISOLATED FORM",
	"ARABIC LETTER WAW FINAL FORM",
	"ARABIC LETTER ALEF MAKSURA ISOLATED FORM",
	"ARABIC LETTER ALEF MAKSURA FINAL FORM",
	"ARABIC LETTER YEH ISOLATED FORM",
	"ARABIC LETTER YEH FINAL FORM",
	"ARABIC LETTER YEH INITIAL FORM",
	"ARABIC LETTER YEH MEDIAL FORM",
	"ARABIC LIGATURE LAM WITH ALEF WITH MADDA ABOVE ISOLATED FORM",
	"ARABIC LIGATURE LAM WITH ALEF WITH MADDA ABOVE FINAL FORM",
	"ARABIC LIGATURE LAM WITH ALEF WITH HAMZA ABOVE ISOLATED FORM",
	"ARABIC LIGATURE LAM WITH ALEF WITH HAMZA ABOVE FINAL FORM",
	"ARABIC LIGATURE LAM WITH ALEF WITH HAMZA BELOW ISOLATED FORM",
	"ARABIC LIGATURE LAM WITH ALEF WITH HAMZA BELOW FINAL FORM",
	"ARABIC LIGATURE LAM WITH ALEF ISOLATED FORM",
	"ARABIC LIGATURE LAM WITH ALEF FINAL FORM",
	"ZERO WIDTH NO-BREAK SPACE",
	"FULLWIDTH EXCLAMATION MARK",
	"FULLWIDTH QUOTATION MARK",
	"FULLWIDTH NUMBER SIGN",
	"FULLWIDTH DOLLAR SIGN",
	"FULLWIDTH PERCENT SIGN",
	"FULLWIDTH AMPERSAND",
	"FULLWIDTH APOSTROPHE",
	"FULLWIDTH LEFT PARENTHESIS",
	"FULLWIDTH RIGHT PARENTHESIS",
	"FULLWIDTH ASTERISK",
	"FULLWIDTH PLUS SIGN",
	"FULLWIDTH COMMA",
	"FULLWIDTH HYPHEN-MINUS",
	"FULLWIDTH FULL STOP",
	"FULLWIDTH SOLIDUS",
	"FULLWIDTH DIGIT ZERO",
	"FULLWIDTH DIGIT ONE",
	"FULLWIDTH DIGIT TWO",
	"FULLWIDTH DIGIT THREE",
	"FULLWIDTH DIGIT FOUR",
	"FULLWIDTH DIGIT FIVE",
	"FULLWIDTH DIGIT SIX",
	"FULLWIDTH DIGIT SEVEN",
	"FULLWIDTH DIGIT EIGHT",
	"FULLWIDTH DIGIT NINE",
	"FULLWIDTH COLON",
	"FULLWIDTH SEMICOLON",
	"FULLWIDTH LESS-THAN SIGN",
	"FULLWIDTH EQUALS SIGN",
	"FULLWIDTH GREATER-THAN SIGN",
	"FULLWIDTH QUESTION MARK",
	"FULLWIDTH COMMERCIAL AT",
	"FULLWIDTH LATIN CAPITAL LETTER A",
	"FULLWIDTH LATIN CAPITAL LETTER B",
	"FULLWIDTH LATIN CAPITAL LETTER C",
	"FULLWIDTH LATIN CAPITAL LETTER D",
	"FULLWIDTH LATIN CAPITAL LETTER E",
	"FULLWIDTH LATIN CAPITAL LETTER F",
	"FULLWIDTH LATIN CAPITAL LETTER G",
	"FULLWIDTH LATIN CAPITAL LETTER H",
	"FULLWIDTH LATIN CAPITAL LETTER I",
	"FULLWIDTH LATIN CAPITAL LETTER J",
	"FULLWIDTH LATIN CAPITAL LETTER K",
	"FULLWIDTH LATIN CAPITAL LETTER L",
	"FULLWIDTH LATIN CAPITAL LETTER M",
	"FULLWIDTH LATIN CAPITAL LETTER N",
	"FULLWIDTH LATIN CAPITAL LETTER O",
	"FULLWIDTH LATIN CAPITAL LETTER P",
	"FULLWIDTH LATIN CAPITAL LETTER Q",
	"FULLWIDTH LATIN CAPITAL LETTER R",
	"FULLWIDTH LATIN CAPITAL LETTER S",
	"FULLWIDTH LATIN CAPITAL LETTER T",
	"FULLWIDTH LATIN CAPITAL LETTER U",
	"FULLWIDTH LATIN CAPITAL LETTER V",
	"FULLWIDTH LATIN CAPITAL LETTER W",
	"FULLWIDTH LATIN CAPITAL LETTER X",
	"FULLWIDTH LATIN CAPITAL LETTER Y",
	"FULLWIDTH LATIN CAPITAL LETTER Z",
	"FULLWIDTH LEFT SQUARE BRACKET",
	"FULLWIDTH REVERSE SOLIDUS",
	"FULLWIDTH RIGHT SQUARE BRACKET",
	"FULLWIDTH CIRCUMFLEX ACCENT",
	"FULLWIDTH LOW LINE",
	"FULLWIDTH GRAVE ACCENT",
	"FULLWIDTH LATIN SMALL LETTER A",
	"FULLWIDTH LATIN SMALL LETTER B",
	"FULLWIDTH LATIN SMALL LETTER C",
	"FULLWIDTH LATIN SMALL LETTER D",
	"FULLWIDTH LATIN SMALL LETTER E",
	"FULLWIDTH LATIN SMALL LETTER F",
	"FULLWIDTH LATIN SMALL LETTER G",
	"FULLWIDTH LATIN SMALL LETTER H",
	"FULLWIDTH LATIN SMALL LETTER I",
	"FULLWIDTH LATIN SMALL LETTER J",
	"FULLWIDTH LATIN SMALL LETTER K",
	"FULLWIDTH LATIN SMALL LETTER L",
	"FULLWIDTH LATIN SMALL LETTER M",
	"FULLWIDTH LATIN SMALL LETTER N",
	"FULLWIDTH LATIN SMALL LETTER O",
	"FULLWIDTH LATIN SMALL LETTER P",
	"FULLWIDTH LATIN SMALL LETTER Q",
	"FULLWIDTH LATIN SMALL LETTER R",
	"FULLWIDTH LATIN SMALL LETTER S",
	"FULLWIDTH LATIN SMALL LETTER T",
	"FULLWIDTH LATIN SMALL LETTER U",
	"FULLWIDTH LATIN SMALL LETTER V",
	"FULLWIDTH LATIN SMALL LETTER W",
	"FULLWIDTH LATIN SMALL LETTER X",
	"FULLWIDTH LATIN SMALL LETTER Y",
	"FULLWIDTH LATIN SMALL LETTER Z",
	"FULLWIDTH LEFT CURLY BRACKET",
	"FULLWIDTH VERTICAL LINE",
	"FULLWIDTH RIGHT CURLY BRACKET",
	"FULLWIDTH TILDE",
	"FULLWIDTH LEFT WHITE PARENTHESIS",
	"FULLWIDTH RIGHT WHITE PARENTHESIS",
	"HALFWIDTH IDEOGRAPHIC FULL STOP",
	"HALFWIDTH LEFT CORNER BRACKET",
	"HALFWIDTH RIGHT CORNER BRACKET",
	"HALFWIDTH IDEOGRAPHIC COMMA",
	"HALFWIDTH KATAKANA MIDDLE DOT",
	"HALFWIDTH KATAKANA LETTER WO",
	"HALFWIDTH KATAKANA LETTER SMALL A",
	"HALFWIDTH KATAKANA LETTER SMALL I",
	"HALFWIDTH KATAKANA LETTER SMALL U",
	"HALFWIDTH KATAKANA LETTER SMALL E",
	"HALFWIDTH KATAKANA LETTER SMALL O",
	"HALFWIDTH KATAKANA LETTER SMALL YA",
	"HALFWIDTH KATAKANA LETTER SMALL YU",
	"HALFWIDTH KATAKANA LETTER SMALL YO",
	"HALFWIDTH KATAKANA LETTER SMALL TU",
	"HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK",
	"HALFWIDTH KATAKANA LETTER A",
	"HALFWIDTH KATAKANA LETTER I",
	"HALFWIDTH KATAKANA LETTER U",
	"HALFWIDTH KATAKANA LETTER E",
	"HALFWIDTH KATAKANA LETTER O",
	"HALFWIDTH KATAKANA LETTER KA",
	"HALFWIDTH KATAKANA LETTER KI",
	"HALFWIDTH KATAKANA LETTER KU",
	"HALFWIDTH KATAKANA LETTER KE",
	"HALFWIDTH KATAKANA LETTER KO",
	"HALFWIDTH KATAKANA LETTER SA",
	"HALFWIDTH KATAKANA LETTER SI",
	"HALFWIDTH KATAKANA LETTER SU",
	"HALFWIDTH KATAKANA LETTER SE",
	"HALFWIDTH KATAKANA LETTER SO",
	"HALFWIDTH KATAKANA LETTER TA",
	"HALFWIDTH KATAKANA LETTER TI",
	"HALFWIDTH KATAKANA LETTER TU",
	"HALFWIDTH KATAKANA LETTER TE",
	"HALFWIDTH KATAKANA LETTER TO",
	"HALFWIDTH KATAKANA LETTER NA",
	"HALFWIDTH KATAKANA LETTER NI",
	"HALFWIDTH KATAKANA LETTER NU",
	"HALFWIDTH KATAKANA LETTER NE",
	"HALFWIDTH KATAKANA LETTER NO",
	"HALFWIDTH KATAKANA LETTER HA",
	"HALFWIDTH KATAKANA LETTER HI",
	"HALFWIDTH KATAKANA LETTER HU",
	"HALFWIDTH KATAKANA LETTER HE",
	"HALFWIDTH KATAKANA LETTER HO",
	"HALFWIDTH KATAKANA LETTER MA",
	"HALFWIDTH KATAKANA LETTER MI",
	"HALFWIDTH KATAKANA LETTER MU",
	"HALFWIDTH KATAKANA LETTER ME",
	"HALFWIDTH KATAKANA LETTER MO",
	"HALFWIDTH KATAKANA LETTER YA",
	"HALFWIDTH KATAKANA LETTER YU",
	"HALFWIDTH KATAKANA LETTER YO",
	"HALFWIDTH KATAKANA LETTER RA",
	"HALFWIDTH KATAKANA LETTER RI",
	"HALFWIDTH KATAKANA LETTER RU",
	"HALFWIDTH KATAKANA LETTER RE",
	"HALFWIDTH KATAKANA LETTER RO",
	"HALFWIDTH KATAKANA LETTER WA",
	"HALFWIDTH KATAKANA LETTER N",
	"HALFWIDTH KATAKANA VOICED SOUND MARK",
	"HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK",
	"HALFWIDTH HANGUL FILLER",
	"HALFWIDTH HANGUL LETTER KIYEOK",
	"HALFWIDTH HANGUL LETTER SSANGKIYEOK",
	"HALFWIDTH HANGUL LETTER KIYEOK-SIOS",
	"HALFWIDTH HANGUL LETTER NIEUN",
	"HALFWIDTH HANGUL LETTER NIEUN-CIEUC",
	"HALFWIDTH HANGUL LETTER NIEUN-HIEUH",
	"HALFWIDTH HANGUL LETTER TIKEUT",
	"HALFWIDTH HANGUL LETTER SSANGTIKEUT",
	"HALFWIDTH HANGUL LETTER RIEUL",
	"HALFWIDTH HANGUL LETTER RIEUL-KIYEOK",
	"HALFWIDTH HANGUL LETTER RIEUL-MIEUM",
	"HALFWIDTH HANGUL LETTER RIEUL-PIEUP",
	"HALFWIDTH HANGUL LETTER RIEUL-SIOS",
	"HALFWIDTH HANGUL LETTER RIEUL-THIEUTH",
	"HALFWIDTH HANGUL LETTER RIEUL-PHIEUPH",
	"HALFWIDTH HANGUL LETTER RIEUL-HIEUH",
	"HALFWIDTH HANGUL LETTER MIEUM",
	"HALFWIDTH HANGUL LETTER PIEUP",
	"HALFWIDTH HANGUL LETTER SSANGPIEUP",
	"HALFWIDTH HANGUL LETTER PIEUP-SIOS",
	"HALFWIDTH HANGUL LETTER SIOS",
	"HALFWIDTH HANGUL LETTER SSANGSIOS",
	"HALFWIDTH HANGUL LETTER IEUNG",
	"HALFWIDTH HANGUL LETTER CIEUC",
	"HALFWIDTH HANGUL LETTER SSANGCIEUC",
	"HALFWIDTH HANGUL LETTER CHIEUCH",
	"HALFWIDTH HANGUL LETTER KHIEUKH",
	"HALFWIDTH HANGUL LETTER THIEUTH",
	"HALFWIDTH HANGUL LETTER PHIEUPH",
	"HALFWIDTH HANGUL LETTER HIEUH",
	"HALFWIDTH HANGUL LETTER A",
	"HALFWIDTH HANGUL LETTER AE",
	"HALFWIDTH HANGUL LETTER YA",
	"HALFWIDTH HANGUL LETTER YAE",
	"HALFWIDTH HANGUL LETTER EO",
	"HALFWIDTH HANGUL LETTER E",
	"HALFWIDTH HANGUL LETTER YEO",
	"HALFWIDTH HANGUL LETTER YE",
	"HALFWIDTH HANGUL LETTER O",
	"HALFWIDTH HANGUL LETTER WA",
	"HALFWIDTH HANGUL LETTER WAE",
	"HALFWIDTH HANGUL LETTER OE",
	"HALFWIDTH HANGUL LETTER YO",
	"HALFWIDTH HANGUL LETTER U",
	"HALFWIDTH HANGUL LETTER WEO",
	"HALFWIDTH HANGUL LETTER WE",
	"HALFWIDTH HANGUL LETTER WI",
	"HALFWIDTH HANGUL LETTER YU",
	"HALFWIDTH HANGUL LETTER EU",
	"HALFWIDTH HANGUL LETTER YI",
	"HALFWIDTH HANGUL LETTER I",
	"FULLWIDTH CENT SIGN",
	"FULLWIDTH POUND SIGN",
	"FULLWIDTH NOT SIGN",
	"FULLWIDTH MACRON",
	"FULLWIDTH BROKEN BAR",
	"FULLWIDTH YEN SIGN",
	"FULLWIDTH WON SIGN",
	"HALFWIDTH FORMS LIGHT VERTICAL",
	"HALFWIDTH LEFTWARDS ARROW",
	"HALFWIDTH UPWARDS ARROW",
	"HALFWIDTH RIGHTWARDS ARROW",
	"HALFWIDTH DOWNWARDS ARROW",
	"HALFWIDTH BLACK SQUARE",
	"HALFWIDTH WHITE CIRCLE",
	"INTERLINEAR ANNOTATION ANCHOR",
	"INTERLINEAR ANNOTATION SEPARATOR",
	"INTERLINEAR ANNOTATION TERMINATOR",
	"OBJECT REPLACEMENT CHARACTER",
	"REPLACEMENT CHARACTER",
	"LINEAR B SYLLABLE B008 A",
	"LINEAR B SYLLABLE B038 E",
	"LINEAR B SYLLABLE B028 I",
	"LINEAR B SYLLABLE B061 O",
	"LINEAR B SYLLABLE B010 U",
	"LINEAR B SYLLABLE B001 DA",
	"LINEAR B SYLLABLE B045 DE",
	"LINEAR B SYLLABLE B007 DI",
	"LINEAR B SYLLABLE B014 DO",
	"LINEAR B SYLLABLE B051 DU",
	"LINEAR B SYLLABLE B057 JA",
	"LINEAR B SYLLABLE B046 JE",
	"LINEAR B SYLLABLE B036 JO",
	"LINEAR B SYLLABLE B065 JU",
	"LINEAR B SYLLABLE B077 KA",
	"LINEAR B SYLLABLE B044 KE",
	"LINEAR B SYLLABLE B067 KI",
	"LINEAR B SYLLABLE B070 KO",
	"LINEAR B SYLLABLE B081 KU",
	"LINEAR B SYLLABLE B080 MA",
	"LINEAR B SYLLABLE B013 ME",
	"LINEAR B SYLLABLE B073 MI",
	"LINEAR B SYLLABLE B015 MO",
	"LINEAR B SYLLABLE B023 MU",
	"LINEAR B SYLLABLE B006 NA",
	"LINEAR B SYLLABLE B024 NE",
	"LINEAR B SYLLABLE B030 NI",
	"LINEAR B SYLLABLE B052 NO",
	"LINEAR B SYLLABLE B055 NU",
	"LINEAR B SYLLABLE B003 PA",
	"LINEAR B SYLLABLE B072 PE",
	"LINEAR B SYLLABLE B039 PI",
	"LINEAR B SYLLABLE B011 PO",
	"LINEAR B SYLLABLE B050 PU",
	"LINEAR B SYLLABLE B016 QA",
	"LINEAR B SYLLABLE B078 QE",
	"LINEAR B SYLLABLE B021 QI",
	"LINEAR B SYLLABLE B032 QO",
	"LINEAR B SYLLABLE B060 RA",
	"LINEAR B SYLLABLE B027 RE",
	"LINEAR B SYLLABLE B053 RI",
	"LINEAR B SYLLABLE B002 RO",
	"LINEAR B SYLLABLE B026 RU",
	"LINEAR B SYLLABLE B031 SA",
	"LINEAR B SYLLABLE B009 SE",
	"LINEAR B SYLLABLE B041 SI",
	"LINEAR B SYLLABLE B012 SO",
	"LINEAR B SYLLABLE B058 SU",
	"LINEAR B SYLLABLE B059 TA",
	"LINEAR B SYLLABLE B004 TE",
	"LINEAR B SYLLABLE B037 TI",
	"LINEAR B SYLLABLE B005 TO",
	"LINEAR B SYLLABLE B069 TU",
	"LINEAR B SYLLABLE B054 WA",
	"LINEAR B SYLLABLE B075 WE",
	"LINEAR B SYLLABLE B040 WI",
	"LINEAR B SYLLABLE B042 WO",
	"LINEAR B SYLLABLE B017 ZA",
	"LINEAR B SYLLABLE B074 ZE",
	"LINEAR B SYLLABLE B020 ZO",
	"LINEAR B SYLLABLE B025 A2",
	"LINEAR B SYLLABLE B043 A3",
	"LINEAR B SYLLABLE B085 AU",
	"LINEAR B SYLLABLE B071 DWE",
	"LINEAR B SYLLABLE B090 DWO",
	"LINEAR B SYLLABLE B048 NWA",
	"LINEAR B SYLLABLE B029 PU2",
	"LINEAR B SYLLABLE B062 PTE",
	"LINEAR B SYLLABLE B076 RA2",
	"LINEAR B SYLLABLE B033 RA3",
	"LINEAR B SYLLABLE B068 RO2",
	"LINEAR B SYLLABLE B066 TA2",
	"LINEAR B SYLLABLE B087 TWE",
	"LINEAR B SYLLABLE B091 TWO",
	"LINEAR B SYMBOL B018",
	"LINEAR B SYMBOL B019",
	"LINEAR B SYMBOL B022",
	"LINEAR B SYMBOL B034",
	"LINEAR B SYMBOL B047",
	"LINEAR B SYMBOL B049",
	"LINEAR B SYMBOL B056",
	"LINEAR B SYMBOL B063",
	"LINEAR B SYMBOL B064",
	"LINEAR B SYMBOL B079",
	"LINEAR B SYMBOL B082",
	"LINEAR B SYMBOL B083",
	"LINEAR B SYMBOL B086",
	"LINEAR B SYMBOL B089",
	"LINEAR B IDEOGRAM B100 MAN",
	"LINEAR B IDEOGRAM B102 WOMAN",
	"LINEAR B IDEOGRAM B104 DEER",
	"LINEAR B IDEOGRAM B105 EQUID",
	"LINEAR B IDEOGRAM B105F MARE",
	"LINEAR B IDEOGRAM B105M STALLION",
	"LINEAR B IDEOGRAM B106F EWE",
	"LINEAR B IDEOGRAM B106M RAM",
	"LINEAR B IDEOGRAM B107F SHE-GOAT",
	"LINEAR B IDEOGRAM B107M HE-GOAT",
	"LINEAR B IDEOGRAM B108F SOW",
	"LINEAR B IDEOGRAM B108M BOAR",
	"LINEAR B IDEOGRAM B109F COW",
	"LINEAR B IDEOGRAM B109M BULL",
	"LINEAR B IDEOGRAM B120 WHEAT",
	"LINEAR B IDEOGRAM B121 BARLEY",
	"LINEAR B IDEOGRAM B122 OLIVE",
	"LINEAR B IDEOGRAM B123 SPICE",
	"LINEAR B IDEOGRAM B125 CYPERUS",
	"LINEAR B MONOGRAM B127 KAPO",
	"LINEAR B MONOGRAM B128 KANAKO",
	"LINEAR B IDEOGRAM B130 OIL",
	"LINEAR B IDEOGRAM B131 WINE",
	"LINEAR B IDEOGRAM B132",
	"LINEAR B MONOGRAM B133 AREPA",
	"LINEAR B MONOGRAM B135 MERI",
	"LINEAR B IDEOGRAM B140 BRONZE",
	"LINEAR B IDEOGRAM B141 GOLD",
	"LINEAR B IDEOGRAM B142",
	"LINEAR B IDEOGRAM B145 WOOL",
	"LINEAR B IDEOGRAM B146",
	"LINEAR B IDEOGRAM B150",
	"LINEAR B IDEOGRAM B151 HORN",
	"LINEAR B IDEOGRAM B152",
	"LINEAR B IDEOGRAM B153",
	"LINEAR B IDEOGRAM B154",
	"LINEAR B MONOGRAM B156 TURO2",
	"LINEAR B IDEOGRAM B157",
	"LINEAR B IDEOGRAM B158",
	"LINEAR B IDEOGRAM B159 CLOTH",
	"LINEAR B IDEOGRAM B160",
	"LINEAR B IDEOGRAM B161",
	"LINEAR B IDEOGRAM B162 GARMENT",
	"LINEAR B IDEOGRAM B163 ARMOUR",
	"LINEAR B IDEOGRAM B164",
	"LINEAR B IDEOGRAM B165",
	"LINEAR B IDEOGRAM B166",
	"LINEAR B IDEOGRAM B167",
	"LINEAR B IDEOGRAM B168",
	"LINEAR B IDEOGRAM B169",
	"LINEAR B IDEOGRAM B170",
	"LINEAR B IDEOGRAM B171",
	"LINEAR B IDEOGRAM B172",
	"LINEAR B IDEOGRAM B173 MONTH",
	"LINEAR B IDEOGRAM B174",
	"LINEAR B IDEOGRAM B176 TREE",
	"LINEAR B IDEOGRAM B177",
	"LINEAR B IDEOGRAM B178",
	"LINEAR B IDEOGRAM B179",
	"LINEAR B IDEOGRAM B180",
	"LINEAR B IDEOGRAM B181",
	"LINEAR B IDEOGRAM B182",
	"LINEAR B IDEOGRAM B183",
	"LINEAR B IDEOGRAM B184",
	"LINEAR B IDEOGRAM B185",
	"LINEAR B IDEOGRAM B189",
	"LINEAR B IDEOGRAM B190",
	"LINEAR B IDEOGRAM B191 HELMET",
	"LINEAR B IDEOGRAM B220 FOOTSTOOL",
	"LINEAR B IDEOGRAM B225 BATHTUB",
	"LINEAR B IDEOGRAM B230 SPEAR",
	"LINEAR B IDEOGRAM B231 ARROW",
	"LINEAR B IDEOGRAM B232",
	"LINEAR B IDEOGRAM B233 SWORD",
	"LINEAR B IDEOGRAM B234",
	"LINEAR B IDEOGRAM B236",
	"LINEAR B IDEOGRAM B240 WHEELED CHARIOT",
	"LINEAR B IDEOGRAM B241 CHARIOT",
	"LINEAR B IDEOGRAM B242 CHARIOT FRAME",
	"LINEAR B IDEOGRAM B243 WHEEL",
	"LINEAR B IDEOGRAM B245",
	"LINEAR B IDEOGRAM B246",
	"LINEAR B MONOGRAM B247 DIPTE",
	"LINEAR B IDEOGRAM B248",
	"LINEAR B IDEOGRAM B249",
	"LINEAR B IDEOGRAM B251",
	"LINEAR B IDEOGRAM B252",
	"LINEAR B IDEOGRAM B253",
	"LINEAR B IDEOGRAM B254 DART",
	"LINEAR B IDEOGRAM B255",
	"LINEAR B IDEOGRAM B256",
	"LINEAR B IDEOGRAM B257",
	"LINEAR B IDEOGRAM B258",
	"LINEAR B IDEOGRAM B259",
	"LINEAR B IDEOGRAM VESSEL B155",
	"LINEAR B IDEOGRAM VESSEL B200",
	"LINEAR B IDEOGRAM VESSEL B201",
	"LINEAR B IDEOGRAM VESSEL B202",
	"LINEAR B IDEOGRAM VESSEL B203",
	"LINEAR B IDEOGRAM VESSEL B204",
	"LINEAR B IDEOGRAM VESSEL B205",
	"LINEAR B IDEOGRAM VESSEL B206",
	"LINEAR B IDEOGRAM VESSEL B207",
	"LINEAR B IDEOGRAM VESSEL B208",
	"LINEAR B IDEOGRAM VESSEL B209",
	"LINEAR B IDEOGRAM VESSEL B210",
	"LINEAR B IDEOGRAM VESSEL B211",
	"LINEAR B IDEOGRAM VESSEL B212",
	"LINEAR B IDEOGRAM VESSEL B213",
	"LINEAR B IDEOGRAM VESSEL B214",
	"LINEAR B IDEOGRAM VESSEL B215",
	"LINEAR B IDEOGRAM VESSEL B216",
	"LINEAR B IDEOGRAM VESSEL B217",
	"LINEAR B IDEOGRAM VESSEL B218",
	"LINEAR B IDEOGRAM VESSEL B219",
	"LINEAR B IDEOGRAM VESSEL B221",
	"LINEAR B IDEOGRAM VESSEL B222",
	"LINEAR B IDEOGRAM VESSEL B226",
	"LINEAR B IDEOGRAM VESSEL B227",
	"LINEAR B IDEOGRAM VESSEL B228",
	"LINEAR B IDEOGRAM VESSEL B229",
	"LINEAR B IDEOGRAM VESSEL B250",
	"LINEAR B IDEOGRAM VESSEL B305",
	"AEGEAN WORD SEPARATOR LINE",
	"AEGEAN WORD SEPARATOR DOT",
	"AEGEAN CHECK MARK",
	"AEGEAN NUMBER ONE",
	"AEGEAN NUMBER TWO",
	"AEGEAN NUMBER THREE",
	"AEGEAN NUMBER FOUR",
	"AEGEAN NUMBER FIVE",
	"AEGEAN NUMBER SIX",
	"AEGEAN NUMBER SEVEN",
	"AEGEAN NUMBER EIGHT",
	"AEGEAN NUMBER NINE",
	"AEGEAN NUMBER TEN",
	"AEGEAN NUMBER TWENTY",
	"AEGEAN NUMBER THIRTY",
	"AEGEAN NUMBER FORTY",
	"AEGEAN NUMBER FIFTY",
	"AEGEAN NUMBER SIXTY",
	"AEGEAN NUMBER SEVENTY",
	"AEGEAN NUMBER EIGHTY",
	"AEGEAN NUMBER NINETY",
	"AEGEAN NUMBER ONE HUNDRED",
	"AEGEAN NUMBER TWO HUNDRED",
	"AEGEAN NUMBER THREE HUNDRED",
	"AEGEAN NUMBER FOUR HUNDRED",
	"AEGEAN NUMBER FIVE HUNDRED",
	"AEGEAN NUMBER SIX HUNDRED",
	"AEGEAN NUMBER SEVEN HUNDRED",
	"AEGEAN NUMBER EIGHT HUNDRED",
	"AEGEAN NUMBER NINE HUNDRED",
	"AEGEAN NUMBER ONE THOUSAND",
	"AEGEAN NUMBER TWO THOUSAND",
	"AEGEAN NUMBER THREE THOUSAND",
	"AEGEAN NUMBER FOUR THOUSAND",
	"AEGEAN NUMBER FIVE THOUSAND",
	"AEGEAN NUMBER SIX THOUSAND",
	"AEGEAN NUMBER SEVEN THOUSAND",
	"AEGEAN NUMBER EIGHT THOUSAND",
	"AEGEAN NUMBER NINE THOUSAND",
	"AEGEAN NUMBER TEN THOUSAND",
	"AEGEAN NUMBER TWENTY THOUSAND",
	"AEGEAN NUMBER THIRTY THOUSAND",
	"AEGEAN NUMBER FORTY THOUSAND",
	"AEGEAN NUMBER FIFTY THOUSAND",
	"AEGEAN NUMBER SIXTY THOUSAND",
	"AEGEAN NUMBER SEVENTY THOUSAND",
	"AEGEAN NUMBER EIGHTY THOUSAND",
	"AEGEAN NUMBER NINETY THOUSAND",
	"AEGEAN WEIGHT BASE UNIT",
	"AEGEAN WEIGHT FIRST SUBUNIT",
	"AEGEAN WEIGHT SECOND SUBUNIT",
	"AEGEAN WEIGHT THIRD SUBUNIT",
	"AEGEAN WEIGHT FOURTH SUBUNIT",
	"AEGEAN DRY MEASURE FIRST SUBUNIT",
	"AEGEAN LIQUID MEASURE FIRST SUBUNIT",
	"AEGEAN MEASURE SECOND SUBUNIT",
	"AEGEAN MEASURE THIRD SUBUNIT",
	"GREEK ACROPHONIC ATTIC ONE QUARTER",
	"GREEK ACROPHONIC ATTIC ONE HALF",
	"GREEK ACROPHONIC ATTIC ONE DRACHMA",
	"GREEK ACROPHONIC ATTIC FIVE",
	"GREEK ACROPHONIC ATTIC FIFTY",
	"GREEK ACROPHONIC ATTIC FIVE HUNDRED",
	"GREEK ACROPHONIC ATTIC FIVE THOUSAND",
	"GREEK ACROPHONIC ATTIC FIFTY THOUSAND",
	"GREEK ACROPHONIC ATTIC FIVE TALENTS",
	"GREEK ACROPHONIC ATTIC TEN TALENTS",
	"GREEK ACROPHONIC ATTIC FIFTY TALENTS",
	"GREEK ACROPHONIC ATTIC ONE HUNDRED TALENTS",
	"GREEK ACROPHONIC ATTIC FIVE HUNDRED TALENTS",
	"GREEK ACROPHONIC ATTIC ONE THOUSAND TALENTS",
	"GREEK ACROPHONIC ATTIC FIVE THOUSAND TALENTS",
	"GREEK ACROPHONIC ATTIC FIVE STATERS",
	"GREEK ACROPHONIC ATTIC TEN STATERS",
	"GREEK ACROPHONIC ATTIC FIFTY STATERS",
	"GREEK ACROPHONIC ATTIC ONE HUNDRED STATERS",
	"GREEK ACROPHONIC ATTIC FIVE HUNDRED STATERS",
	"GREEK ACROPHONIC ATTIC ONE THOUSAND STATERS",
	"GREEK ACROPHONIC ATTIC TEN THOUSAND STATERS",
	"GREEK ACROPHONIC ATTIC FIFTY THOUSAND STATERS",
	"GREEK ACROPHONIC ATTIC TEN MNAS",
	"GREEK ACROPHONIC HERAEUM ONE PLETHRON",
	"GREEK ACROPHONIC THESPIAN ONE",
	"GREEK ACROPHONIC HERMIONIAN ONE",
	"GREEK ACROPHONIC EPIDAUREAN TWO",
	"GREEK ACROPHONIC THESPIAN TWO",
	"GREEK ACROPHONIC CYRENAIC TWO DRACHMAS",
	"GREEK ACROPHONIC EPIDAUREAN TWO DRACHMAS",
	"GREEK ACROPHONIC TROEZENIAN FIVE",
	"GREEK ACROPHONIC TROEZENIAN TEN",
	"GREEK ACROPHONIC TROEZENIAN TEN ALTERNATE FORM",
	"GREEK ACROPHONIC HERMIONIAN TEN",
	"GREEK ACROPHONIC MESSENIAN TEN",
	"GREEK ACROPHONIC THESPIAN TEN",
	"GREEK ACROPHONIC THESPIAN THIRTY",
	"GREEK ACROPHONIC TROEZENIAN FIFTY",
	"GREEK ACROPHONIC TROEZENIAN FIFTY ALTERNATE FORM",
	"GREEK ACROPHONIC HERMIONIAN FIFTY",
	"GREEK ACROPHONIC THESPIAN FIFTY",
	"GREEK ACROPHONIC THESPIAN ONE HUNDRED",
	"GREEK ACROPHONIC THESPIAN THREE HUNDRED",
	"GREEK ACROPHONIC EPIDAUREAN FIVE HUNDRED",
	"GREEK ACROPHONIC TROEZENIAN FIVE HUNDRED",
	"GREEK ACROPHONIC THESPIAN FIVE HUNDRED",
	"GREEK ACROPHONIC CARYSTIAN FIVE HUNDRED",
	"GREEK ACROPHONIC NAXIAN FIVE HUNDRED",
	"GREEK ACROPHONIC THESPIAN ONE THOUSAND",
	"GREEK ACROPHONIC THESPIAN FIVE THOUSAND",
	"GREEK ACROPHONIC DELPHIC FIVE MNAS",
	"GREEK ACROPHONIC STRATIAN FIFTY MNAS",
	"GREEK ONE HALF SIGN",
	"GREEK ONE HALF SIGN ALTERNATE FORM",
	"GREEK TWO THIRDS SIGN",
	"GREEK THREE QUARTERS SIGN",
	"GREEK YEAR SIGN",
	"GREEK TALENT SIGN",
	"GREEK DRACHMA SIGN",
	"GREEK OBOL SIGN",
	"GREEK TWO OBOLS SIGN",
	"GREEK THREE OBOLS SIGN",
	"GREEK FOUR OBOLS SIGN",
	"GREEK FIVE OBOLS SIGN",
	"GREEK METRETES SIGN",
	"GREEK KYATHOS BASE SIGN",
	"GREEK LITRA SIGN",
	"GREEK OUNKIA SIGN",
	"GREEK XESTES SIGN",
	"GREEK ARTABE SIGN",
	"GREEK AROURA SIGN",
	"GREEK GRAMMA SIGN",
	"GREEK TRYBLION BASE SIGN",
	"GREEK ZERO SIGN",
	"GREEK ONE QUARTER SIGN",
	"GREEK SINUSOID SIGN",
	"GREEK INDICTION SIGN",
	"NOMISMA SIGN",
	"ROMAN SEXTANS SIGN",
	"ROMAN UNCIA SIGN",
	"ROMAN SEMUNCIA SIGN",
	"ROMAN SEXTULA SIGN",
	"ROMAN DIMIDIA SEXTULA SIGN",
	"ROMAN SILIQUA SIGN",
	"ROMAN DENARIUS SIGN",
	"ROMAN QUINARIUS SIGN",
	"ROMAN SESTERTIUS SIGN",
	"ROMAN DUPONDIUS SIGN",
	"ROMAN AS SIGN",
	"ROMAN CENTURIAL SIGN",
	"ASCIA SYMBOL",
	"GREEK SYMBOL TAU RHO",
	"PHAISTOS DISC SIGN PEDESTRIAN",
	"PHAISTOS DISC SIGN PLUMED HEAD",
	"PHAISTOS DISC SIGN TATTOOED HEAD",
	"PHAISTOS DISC SIGN CAPTIVE",
	"PHAISTOS DISC SIGN CHILD",
	"PHAISTOS DISC SIGN WOMAN",
	"PHAISTOS DISC SIGN HELMET",
	"PHAISTOS DISC SIGN GAUNTLET",
	"PHAISTOS DISC SIGN TIARA",
	"PHAISTOS DISC SIGN ARROW",
	"PHAISTOS DISC SIGN BOW",
	"PHAISTOS DISC SIGN SHIELD",
	"PHAISTOS DISC SIGN CLUB",
	"PHAISTOS DISC SIGN MANACLES",
	"PHAISTOS DISC SIGN MATTOCK",
	"PHAISTOS DISC SIGN SAW",
	"PHAISTOS DISC SIGN LID",
	"PHAISTOS DISC SIGN BOOMERANG",
	"PHAISTOS DISC SIGN CARPENTRY PLANE",
	"PHAISTOS DISC SIGN DOLIUM",
	"PHAISTOS DISC SIGN COMB",
	"PHAISTOS DISC SIGN SLING",
	"PHAISTOS DISC SIGN COLUMN",
	"PHAISTOS DISC SIGN BEEHIVE",
	"PHAISTOS DISC SIGN SHIP",
	"PHAISTOS DISC SIGN HORN",
	"PHAISTOS DISC SIGN HIDE",
	"PHAISTOS DISC SIGN BULLS LEG",
	"PHAISTOS DISC SIGN CAT",
	"PHAISTOS DISC SIGN RAM",
	"PHAISTOS DISC SIGN EAGLE",
	"PHAISTOS DISC SIGN DOVE",
	"PHAISTOS DISC SIGN TUNNY",
	"PHAISTOS DISC SIGN BEE",
	"PHAISTOS DISC SIGN PLANE TREE",
	"PHAISTOS DISC SIGN VINE",
	"PHAISTOS DISC SIGN PAPYRUS",
	"PHAISTOS DISC SIGN ROSETTE",
	"PHAISTOS DISC SIGN LILY",
	"PHAISTOS DISC SIGN OX BACK",
	"PHAISTOS DISC SIGN FLUTE",
	"PHAISTOS DISC SIGN GRATER",
	"PHAISTOS DISC SIGN STRAINER",
	"PHAISTOS DISC SIGN SMALL AXE",
	"PHAISTOS DISC SIGN WAVY BAND",
	"PHAISTOS DISC SIGN COMBINING OBLIQUE STROKE",
	"LYCIAN LETTER A",
	"LYCIAN LETTER E",
	"LYCIAN LETTER B",
	"LYCIAN LETTER BH",
	"LYCIAN LETTER G",
	"LYCIAN LETTER D",
	"LYCIAN LETTER I",
	"LYCIAN LETTER W",
	"LYCIAN LETTER Z",
	"LYCIAN LETTER TH",
	"LYCIAN LETTER J",
	"LYCIAN LETTER K",
	"LYCIAN LETTER Q",
	"LYCIAN LETTER L",
	"LYCIAN LETTER M",
	"LYCIAN LETTER N",
	"LYCIAN LETTER MM",
	"LYCIAN LETTER NN",
	"LYCIAN LETTER U",
	"LYCIAN LETTER P",
	"LYCIAN LETTER KK",
	"LYCIAN LETTER R",
	"LYCIAN LETTER S",
	"LYCIAN LETTER T",
	"LYCIAN LETTER TT",
	"LYCIAN LETTER AN",
	"LYCIAN LETTER EN",
	"LYCIAN LETTER H",
	"LYCIAN LETTER X",
	"CARIAN LETTER A",
	"CARIAN LETTER P2",
	"CARIAN LETTER D",
	"CARIAN LETTER L",
	"CARIAN LETTER UUU",
	"CARIAN LETTER R",
	"CARIAN LETTER LD",
	"CARIAN LETTER A2",
	"CARIAN LETTER Q",
	"CARIAN LETTER B",
	"CARIAN LETTER M",
	"CARIAN LETTER O",
	"CARIAN LETTER D2",
	"CARIAN LETTER T",
	"CARIAN LETTER SH",
	"CARIAN LETTER SH2",
	"CARIAN LETTER S",
	"CARIAN LETTER C-18",
	"CARIAN LETTER U",
	"CARIAN LETTER NN",
	"CARIAN LETTER X",
	"CARIAN LETTER N",
	"CARIAN LETTER TT2",
	"CARIAN LETTER P",
	"CARIAN LETTER SS",
	"CARIAN LETTER I",
	"CARIAN LETTER E",
	"CARIAN LETTER UUUU",
	"CARIAN LETTER K",
	"CARIAN LETTER K2",
	"CARIAN LETTER ND",
	"CARIAN LETTER UU",
	"CARIAN LETTER G",
	"CARIAN LETTER G2",
	"CARIAN LETTER ST",
	"CARIAN LETTER ST2",
	"CARIAN LETTER NG",
	"CARIAN LETTER II",
	"CARIAN LETTER C-39",
	"CARIAN LETTER TT",
	"CARIAN LETTER UUU2",
	"CARIAN LETTER RR",
	"CARIAN LETTER MB",
	"CARIAN LETTER MB2",
	"CARIAN LETTER MB3",
	"CARIAN LETTER MB4",
	"CARIAN LETTER LD2",
	"CARIAN LETTER E2",
	"CARIAN LETTER UUU3",
	"COPTIC EPACT THOUSANDS MARK",
	"COPTIC EPACT DIGIT ONE",
	"COPTIC EPACT DIGIT TWO",
	"COPTIC EPACT DIGIT THREE",
	"COPTIC EPACT DIGIT FOUR",
	"COPTIC EPACT DIGIT FIVE",
	"COPTIC EPACT DIGIT SIX",
	"COPTIC EPACT DIGIT SEVEN",
	"COPTIC EPACT DIGIT EIGHT",
	"COPTIC EPACT DIGIT NINE",
	"COPTIC EPACT NUMBER TEN",
	"COPTIC EPACT NUMBER TWENTY",
	"COPTIC EPACT NUMBER THIRTY",
	"COPTIC EPACT NUMBER FORTY",
	"COPTIC EPACT NUMBER FIFTY",
	"COPTIC EPACT NUMBER SIXTY",
	"COPTIC EPACT NUMBER SEVENTY",
	"COPTIC EPACT NUMBER EIGHTY",
	"COPTIC EPACT NUMBER NINETY",
	"COPTIC EPACT NUMBER ONE HUNDRED",
	"COPTIC EPACT NUMBER TWO HUNDRED",
	"COPTIC EPACT NUMBER THREE HUNDRED",
	"COPTIC EPACT NUMBER FOUR HUNDRED",
	"COPTIC EPACT NUMBER FIVE HUNDRED",
	"COPTIC EPACT NUMBER SIX HUNDRED",
	"COPTIC EPACT NUMBER SEVEN HUNDRED",
	"COPTIC EPACT NUMBER EIGHT HUNDRED",
	"COPTIC EPACT NUMBER NINE HUNDRED",
	"OLD ITALIC LETTER A",
	"OLD ITALIC LETTER BE",
	"OLD ITALIC LETTER KE",
	"OLD ITALIC LETTER DE",
	"OLD ITALIC LETTER E",
	"OLD ITALIC LETTER VE",
	"OLD ITALIC LETTER ZE",
	"OLD ITALIC LETTER HE",
	"OLD ITALIC LETTER THE",
	"OLD ITALIC LETTER I",
	"OLD ITALIC LETTER KA",
	"OLD ITALIC LETTER EL",
	"OLD ITALIC LETTER EM",
	"OLD ITALIC LETTER EN",
	"OLD ITALIC LETTER ESH",
	"OLD ITALIC LETTER O",
	"OLD ITALIC LETTER PE",
	"OLD ITALIC LETTER SHE",
	"OLD ITALIC LETTER KU",
	"OLD ITALIC LETTER ER",
	"OLD ITALIC LETTER ES",
	"OLD ITALIC LETTER TE",
	"OLD ITALIC LETTER U",
	"OLD ITALIC LETTER EKS",
	"OLD ITALIC LETTER PHE",
	"OLD ITALIC LETTER KHE",
	"OLD ITALIC LETTER EF",
	"OLD ITALIC LETTER ERS",
	"OLD ITALIC LETTER CHE",
	"OLD ITALIC LETTER II",
	"OLD ITALIC LETTER UU",
	"OLD ITALIC LETTER ESS",
	"OLD ITALIC NUMERAL ONE",
	"OLD ITALIC NUMERAL FIVE",
	"OLD ITALIC NUMERAL TEN",
	"OLD ITALIC NUMERAL FIFTY",
	"OLD ITALIC LETTER YE",
	"OLD ITALIC LETTER NORTHERN TSE",
	"OLD ITALIC LETTER SOUTHERN TSE",
	"GOTHIC LETTER AHSA",
	"GOTHIC LETTER BAIRKAN",
	"GOTHIC LETTER GIBA",
	"GOTHIC LETTER DAGS",
	"GOTHIC LETTER AIHVUS",
	"GOTHIC LETTER QAIRTHRA",
	"GOTHIC LETTER IUJA",
	"GOTHIC LETTER HAGL",
	"GOTHIC LETTER THIUTH",
	"GOTHIC LETTER EIS",
	"GOTHIC LETTER KUSMA",
	"GOTHIC LETTER LAGUS",
	"GOTHIC LETTER MANNA",
	"GOTHIC LETTER NAUTHS",
	"GOTHIC LETTER JER",
	"GOTHIC LETTER URUS",
	"GOTHIC LETTER PAIRTHRA",
	"GOTHIC LETTER NINETY",
	"GOTHIC LETTER RAIDA",
	"GOTHIC LETTER SAUIL",
	"GOTHIC LETTER TEIWS",
	"GOTHIC LETTER WINJA",
	"GOTHIC LETTER FAIHU",
	"GOTHIC LETTER IGGWS",
	"GOTHIC LETTER HWAIR",
	"GOTHIC LETTER OTHAL",
	"GOTHIC LETTER NINE HUNDRED",
	"OLD PERMIC LETTER AN",
	"OLD PERMIC LETTER BUR",
	"OLD PERMIC LETTER GAI",
	"OLD PERMIC LETTER DOI",
	"OLD PERMIC LETTER E",
	"OLD PERMIC LETTER ZHOI",
	"OLD PERMIC LETTER DZHOI",
	"OLD PERMIC LETTER ZATA",
	"OLD PERMIC LETTER DZITA",
	"OLD PERMIC LETTER I",
	"OLD PERMIC LETTER KOKE",
	"OLD PERMIC LETTER LEI",
	"OLD PERMIC LETTER MENOE",
	"OLD PERMIC LETTER NENOE",
	"OLD PERMIC LETTER VOOI",
	"OLD PERMIC LETTER PEEI",
	"OLD PERMIC LETTER REI",
	"OLD PERMIC LETTER SII",
	"OLD PERMIC LETTER TAI",
	"OLD PERMIC LETTER U",
	"OLD PERMIC LETTER CHERY",
	"OLD PERMIC LETTER SHOOI",
	"OLD PERMIC LETTER SHCHOOI",
	"OLD PERMIC LETTER YRY",
	"OLD PERMIC LETTER YERU",
	"OLD PERMIC LETTER O",
	"OLD PERMIC LETTER OO",
	"OLD PERMIC LETTER EF",
	"OLD PERMIC LETTER HA",
	"OLD PERMIC LETTER TSIU",
	"OLD PERMIC LETTER VER",
	"OLD PERMIC LETTER YER",
	"OLD PERMIC LETTER YERI",
	"OLD PERMIC LETTER YAT",
	"OLD PERMIC LETTER IE",
	"OLD PERMIC LETTER YU",
	"OLD PERMIC LETTER YA",
	"OLD PERMIC LETTER IA",
	"COMBINING OLD PERMIC LETTER AN",
	"COMBINING OLD PERMIC LETTER DOI",
	"COMBINING OLD PERMIC LETTER ZATA",
	"COMBINING OLD PERMIC LETTER NENOE",
	"COMBINING OLD PERMIC LETTER SII",
	"UGARITIC LETTER ALPA",
	"UGARITIC LETTER BETA",
	"UGARITIC LETTER GAMLA",
	"UGARITIC LETTER KHA",
	"UGARITIC LETTER DELTA",
	"UGARITIC LETTER HO",
	"UGARITIC LETTER WO",
	"UGARITIC LETTER ZETA",
	"UGARITIC LETTER HOTA",
	"UGARITIC LETTER TET",
	"UGARITIC LETTER YOD",
	"UGARITIC LETTER KAF",
	"UGARITIC LETTER SHIN",
	"UGARITIC LETTER LAMDA",
	"UGARITIC LETTER MEM",
	"UGARITIC LETTER DHAL",
	"UGARITIC LETTER NUN",
	"UGARITIC LETTER ZU",
	"UGARITIC LETTER SAMKA",
	"UGARITIC LETTER AIN",
	"UGARITIC LETTER PU",
	"UGARITIC LETTER SADE",
	"UGARITIC LETTER QOPA",
	"UGARITIC LETTER RASHA",
	"UGARITIC LETTER THANNA",
	"UGARITIC LETTER GHAIN",
	"UGARITIC LETTER TO",
	"UGARITIC LETTER I",
	"UGARITIC LETTER U",
	"UGARITIC LETTER SSU",
	"UGARITIC WORD DIVIDER",
	"OLD PERSIAN SIGN A",
	"OLD PERSIAN SIGN I",
	"OLD PERSIAN SIGN U",
	"OLD PERSIAN SIGN KA",
	"OLD PERSIAN SIGN KU",
	"OLD PERSIAN SIGN GA",
	"OLD PERSIAN SIGN GU",
	"OLD PERSIAN SIGN XA",
	"OLD PERSIAN SIGN CA",
	"OLD PERSIAN SIGN JA",
	"OLD PERSIAN SIGN JI",
	"OLD PERSIAN SIGN TA",
	"OLD PERSIAN SIGN TU",
	"OLD PERSIAN SIGN DA",
	"OLD PERSIAN SIGN DI",
	"OLD PERSIAN SIGN DU",
	"OLD PERSIAN SIGN THA",
	"OLD PERSIAN SIGN PA",
	"OLD PERSIAN SIGN BA",
	"OLD PERSIAN SIGN FA",
	"OLD PERSIAN SIGN NA",
	"OLD PERSIAN SIGN NU",
	"OLD PERSIAN SIGN MA",
	"OLD PERSIAN SIGN MI",
	"OLD PERSIAN SIGN MU",
	"OLD PERSIAN SIGN YA",
	"OLD PERSIAN SIGN VA",
	"OLD PERSIAN SIGN VI",
	"OLD PERSIAN SIGN RA",
	"OLD PERSIAN SIGN RU",
	"OLD PERSIAN SIGN LA",
	"OLD PERSIAN SIGN SA",
	"OLD PERSIAN SIGN ZA",
	"OLD PERSIAN SIGN SHA",
	"OLD PERSIAN SIGN SSA",
	"OLD PERSIAN SIGN HA",
	"OLD PERSIAN SIGN AURAMAZDAA",
	"OLD PERSIAN SIGN AURAMAZDAA-2",
	"OLD PERSIAN SIGN AURAMAZDAAHA",
	"OLD PERSIAN SIGN XSHAAYATHIYA",
	"OLD PERSIAN SIGN DAHYAAUSH",
	"OLD PERSIAN SIGN DAHYAAUSH-2",
	"OLD PERSIAN SIGN BAGA",
	"OLD PERSIAN SIGN BUUMISH",
	"OLD PERSIAN WORD DIVIDER",
	"OLD PERSIAN NUMBER ONE",
	"OLD PERSIAN NUMBER TWO",
	"OLD PERSIAN NUMBER TEN",
	"OLD PERSIAN NUMBER TWENTY",
	"OLD PERSIAN NUMBER HUNDRED",
	"DESERET CAPITAL LETTER LONG I",
	"DESERET CAPITAL LETTER LONG E",
	"DESERET CAPITAL LETTER LONG A",
	"DESERET CAPITAL LETTER LONG AH",
	"DESERET CAPITAL LETTER LONG O",
	"DESERET CAPITAL LETTER LONG OO",
	"DESERET CAPITAL LETTER SHORT I",
	"DESERET CAPITAL LETTER SHORT E",
	"DESERET CAPITAL LETTER SHORT A",
	"DESERET CAPITAL LETTER SHORT AH",
	"DESERET CAPITAL LETTER SHORT O",
	"DESERET CAPITAL LETTER SHORT OO",
	"DESERET CAPITAL LETTER AY",
	"DESERET CAPITAL LETTER OW",
	"DESERET CAPITAL LETTER WU",
	"DESERET CAPITAL LETTER YEE",
	"DESERET CAPITAL LETTER H",
	"DESERET CAPITAL LETTER PEE",
	"DESERET CAPITAL LETTER BEE",
	"DESERET CAPITAL LETTER TEE",
	"DESERET CAPITAL LETTER DEE",
	"DESERET CAPITAL LETTER CHEE",
	"DESERET CAPITAL LETTER JEE",
	"DESERET CAPITAL LETTER KAY",
	"DESERET CAPITAL LETTER GAY",
	"DESERET CAPITAL LETTER EF",
	"DESERET CAPITAL LETTER VEE",
	"DESERET CAPITAL LETTER ETH",
	"DESERET CAPITAL LETTER THEE",
	"DESERET CAPITAL LETTER ES",
	"DESERET CAPITAL LETTER ZEE",
	"DESERET CAPITAL LETTER ESH",
	"DESERET CAPITAL LETTER ZHEE",
	"DESERET CAPITAL LETTER ER",
	"DESERET CAPITAL LETTER EL",
	"DESERET CAPITAL LETTER EM",
	"DESERET CAPITAL LETTER EN",
	"DESERET CAPITAL LETTER ENG",
	"DESERET CAPITAL LETTER OI",
	"DESERET CAPITAL LETTER EW",
	"DESERET SMALL LETTER LONG I",
	"DESERET SMALL LETTER LONG E",
	"DESERET SMALL LETTER LONG A",
	"DESERET SMALL LETTER LONG AH",
	"DESERET SMALL LETTER LONG O",
	"DESERET SMALL LETTER LONG OO",
	"DESERET SMALL LETTER SHORT I",
	"DESERET SMALL LETTER SHORT E",
	"DESERET SMALL LETTER SHORT A",
	"DESERET SMALL LETTER SHORT AH",
	"DESERET SMALL LETTER SHORT O",
	"DESERET SMALL LETTER SHORT OO",
	"DESERET SMALL LETTER AY",
	"DESERET SMALL LETTER OW",
	"DESERET SMALL LETTER WU",
	"DESERET SMALL LETTER YEE",
	"DESERET SMALL LETTER H",
	"DESERET SMALL LETTER PEE",
	"DESERET SMALL LETTER BEE",
	"DESERET SMALL LETTER TEE",
	"DESERET SMALL LETTER DEE",
	"DESERET SMALL LETTER CHEE",
	"DESERET SMALL LETTER JEE",
	"DESERET SMALL LETTER KAY",
	"DESERET SMALL LETTER GAY",
	"DESERET SMALL LETTER EF",
	"DESERET SMALL LETTER VEE",
	"DESERET SMALL LETTER ETH",
	"DESERET SMALL LETTER THEE",
	"DESERET SMALL LETTER ES",
	"DESERET SMALL LETTER ZEE",
	"DESERET SMALL LETTER ESH",
	"DESERET SMALL LETTER ZHEE",
	"DESERET SMALL LETTER ER",
	"DESERET SMALL LETTER EL",
	"DESERET SMALL LETTER EM",
	"DESERET SMALL LETTER EN",
	"DESERET SMALL LETTER ENG",
	"DESERET SMALL LETTER OI",
	"DESERET SMALL LETTER EW",
	"SHAVIAN LETTER PEEP",
	"SHAVIAN LETTER TOT",
	"SHAVIAN LETTER KICK",
	"SHAVIAN LETTER FEE",
	"SHAVIAN LETTER THIGH",
	"SHAVIAN LETTER SO",
	"SHAVIAN LETTER SURE",
	"SHAVIAN LETTER CHURCH",
	"SHAVIAN LETTER YEA",
	"SHAVIAN LETTER HUNG",
	"SHAVIAN LETTER BIB",
	"SHAVIAN LETTER DEAD",
	"SHAVIAN LETTER GAG",
	"SHAVIAN LETTER VOW",
	"SHAVIAN LETTER THEY",
	"SHAVIAN LETTER ZOO",
	"SHAVIAN LETTER MEASURE",
	"SHAVIAN LETTER JUDGE",
	"SHAVIAN LETTER WOE",
	"SHAVIAN LETTER HA-HA",
	"SHAVIAN LETTER LOLL",
	"SHAVIAN LETTER MIME",
	"SHAVIAN LETTER IF",
	"SHAVIAN LETTER EGG",
	"SHAVIAN LETTER ASH",
	"SHAVIAN LETTER ADO",
	"SHAVIAN LETTER ON",
	"SHAVIAN LETTER WOOL",
	"SHAVIAN LETTER OUT",
	"SHAVIAN LETTER AH",
	"SHAVIAN LETTER ROAR",
	"SHAVIAN LETTER NUN",
	"SHAVIAN LETTER EAT",
	"SHAVIAN LETTER AGE",
	"SHAVIAN LETTER ICE",
	"SHAVIAN LETTER UP",
	"SHAVIAN LETTER OAK",
	"SHAVIAN LETTER OOZE",
	"SHAVIAN LETTER OIL",
	"SHAVIAN LETTER AWE",
	"SHAVIAN LETTER ARE",
	"SHAVIAN LETTER OR",
	"SHAVIAN LETTER AIR",
	"SHAVIAN LETTER ERR",
	"SHAVIAN LETTER ARRAY",
	"SHAVIAN LETTER EAR",
	"SHAVIAN LETTER IAN",
	"SHAVIAN LETTER YEW",
	"OSMANYA LETTER ALEF",
	"OSMANYA LETTER BA",
	"OSMANYA LETTER TA",
	"OSMANYA LETTER JA",
	"OSMANYA LETTER XA",
	"OSMANYA LETTER KHA",
	"OSMANYA LETTER DEEL",
	"OSMANYA LETTER RA",
	"OSMANYA LETTER SA",
	"OSMANYA LETTER SHIIN",
	"OSMANYA LETTER DHA",
	"OSMANYA LETTER CAYN",
	"OSMANYA LETTER GA",
	"OSMANYA LETTER FA",
	"OSMANYA LETTER QAAF",
	"OSMANYA LETTER KAAF",
	"OSMANYA LETTER LAAN",
	"OSMANYA LETTER MIIN",
	"OSMANYA LETTER NUUN",
	"OSMANYA LETTER WAW",
	"OSMANYA LETTER HA",
	"OSMANYA LETTER YA",
	"OSMANYA LETTER A",
	"OSMANYA LETTER E",
	"OSMANYA LETTER I",
	"OSMANYA LETTER O",
	"OSMANYA LETTER U",
	"OSMANYA LETTER AA",
	"OSMANYA LETTER EE",
	"OSMANYA LETTER OO",
	"OSMANYA DIGIT ZERO",
	"OSMANYA DIGIT ONE",
	"OSMANYA DIGIT TWO",
	"OSMANYA DIGIT THREE",
	"OSMANYA DIGIT FOUR",
	"OSMANYA DIGIT FIVE",
	"OSMANYA DIGIT SIX",
	"OSMANYA DIGIT SEVEN",
	"OSMANYA DIGIT EIGHT",
	"OSMANYA DIGIT NINE",
	"OSAGE CAPITAL LETTER A",
	"OSAGE CAPITAL LETTER AI",
	"OSAGE CAPITAL LETTER AIN",
	"OSAGE CAPITAL LETTER AH",
	"OSAGE CAPITAL LETTER BRA",
	"OSAGE CAPITAL LETTER CHA",
	"OSAGE CAPITAL LETTER EHCHA",
	"OSAGE CAPITAL LETTER E",
	"OSAGE CAPITAL LETTER EIN",
	"OSAGE CAPITAL LETTER HA",
	"OSAGE CAPITAL LETTER HYA",
	"OSAGE CAPITAL LETTER I",
	"OSAGE CAPITAL LETTER KA",
	"OSAGE CAPITAL LETTER EHKA",
	"OSAGE CAPITAL LETTER KYA",
	"OSAGE CAPITAL LETTER LA",
	"OSAGE CAPITAL LETTER MA",
	"OSAGE CAPITAL LETTER NA",
	"OSAGE CAPITAL LETTER O",
	"OSAGE CAPITAL LETTER OIN",
	"OSAGE CAPITAL LETTER PA",
	"OSAGE CAPITAL LETTER EHPA",
	"OSAGE CAPITAL LETTER SA",
	"OSAGE CAPITAL LETTER SHA",
	"OSAGE CAPITAL LETTER TA",
	"OSAGE CAPITAL LETTER EHTA",
	"OSAGE CAPITAL LETTER TSA",
	"OSAGE CAPITAL LETTER EHTSA",
	"OSAGE CAPITAL LETTER TSHA",
	"OSAGE CAPITAL LETTER DHA",
	"OSAGE CAPITAL LETTER U",
	"OSAGE CAPITAL LETTER WA",
	"OSAGE CAPITAL LETTER KHA",
	"OSAGE CAPITAL LETTER GHA",
	"OSAGE CAPITAL LETTER ZA",
	"OSAGE CAPITAL LETTER ZHA",
	"OSAGE SMALL LETTER A",
	"OSAGE SMALL LETTER AI",
	"OSAGE SMALL LETTER AIN",
	"OSAGE SMALL LETTER AH",
	"OSAGE SMALL LETTER BRA",
	"OSAGE SMALL LETTER CHA",
	"OSAGE SMALL LETTER EHCHA",
	"OSAGE SMALL LETTER E",
	"OSAGE SMALL LETTER EIN",
	"OSAGE SMALL LETTER HA",
	"OSAGE SMALL LETTER HYA",
	"OSAGE SMALL LETTER I",
	"OSAGE SMALL LETTER KA",
	"OSAGE SMALL LETTER EHKA",
	"OSAGE SMALL LETTER KYA",
	"OSAGE SMALL LETTER LA",
	"OSAGE SMALL LETTER MA",
	"OSAGE SMALL LETTER NA",
	"OSAGE SMALL LETTER O",
	"OSAGE SMALL LETTER OIN",
	"OSAGE SMALL LETTER PA",
	"OSAGE SMALL LETTER EHPA",
	"OSAGE SMALL LETTER SA",
	"OSAGE SMALL LETTER SHA",
	"OSAGE SMALL LETTER TA",
	"OSAGE SMALL LETTER EHTA",
	"OSAGE SMALL LETTER TSA",
	"OSAGE SMALL LETTER EHTSA",
	"OSAGE SMALL LETTER TSHA",
	"OSAGE SMALL LETTER DHA",
	"OSAGE SMALL LETTER U",
	"OSAGE SMALL LETTER WA",
	"OSAGE SMALL LETTER KHA",
	"OSAGE SMALL LETTER GHA",
	"OSAGE SMALL LETTER ZA",
	"OSAGE SMALL LETTER ZHA",
	"ELBASAN LETTER A",
	"ELBASAN LETTER BE",
	"ELBASAN LETTER CE",
	"ELBASAN LETTER CHE",
	"ELBASAN LETTER DE",
	"ELBASAN LETTER NDE",
	"ELBASAN LETTER DHE",
	"ELBASAN LETTER EI",
	"ELBASAN LETTER E",
	"ELBASAN LETTER FE",
	"ELBASAN LETTER GE",
	"ELBASAN LETTER GJE",
	"ELBASAN LETTER HE",
	"ELBASAN LETTER I",
	"ELBASAN LETTER JE",
	"ELBASAN LETTER KE",
	"ELBASAN LETTER LE",
	"ELBASAN LETTER LLE",
	"ELBASAN LETTER ME",
	"ELBASAN LETTER NE",
	"ELBASAN LETTER NA",
	"ELBASAN LETTER NJE",
	"ELBASAN LETTER O",
	"ELBASAN LETTER PE",
	"ELBASAN LETTER QE",
	"ELBASAN LETTER RE",
	"ELBASAN LETTER RRE",
	"ELBASAN LETTER SE",
	"ELBASAN LETTER SHE",
	"ELBASAN LETTER TE",
	"ELBASAN LETTER THE",
	"ELBASAN LETTER U",
	"ELBASAN LETTER VE",
	"ELBASAN LETTER XE",
	"ELBASAN LETTER Y",
	"ELBASAN LETTER ZE",
	"ELBASAN LETTER ZHE",
	"ELBASAN LETTER GHE",
	"ELBASAN LETTER GHAMMA",
	"ELBASAN LETTER KHE",
	"CAUCASIAN ALBANIAN LETTER ALT",
	"CAUCASIAN ALBANIAN LETTER BET",
	"CAUCASIAN ALBANIAN LETTER GIM",
	"CAUCASIAN ALBANIAN LETTER DAT",
	"CAUCASIAN ALBANIAN LETTER EB",
	"CAUCASIAN ALBANIAN LETTER ZARL",
	"CAUCASIAN ALBANIAN LETTER EYN",
	"CAUCASIAN ALBANIAN LETTER ZHIL",
	"CAUCASIAN ALBANIAN LETTER TAS",
	"CAUCASIAN ALBANIAN LETTER CHA",
	"CAUCASIAN ALBANIAN LETTER YOWD",
	"CAUCASIAN ALBANIAN LETTER ZHA",
	"CAUCASIAN ALBANIAN LETTER IRB",
	"CAUCASIAN ALBANIAN LETTER SHA",
	"CAUCASIAN ALBANIAN LETTER LAN",
	"CAUCASIAN ALBANIAN LETTER INYA",
	"CAUCASIAN ALBANIAN LETTER XEYN",
	"CAUCASIAN ALBANIAN LETTER DYAN",
	"CAUCASIAN ALBANIAN LETTER CAR",
	"CAUCASIAN ALBANIAN LETTER JHOX",
	"CAUCASIAN ALBANIAN LETTER KAR",
	"CAUCASIAN ALBANIAN LETTER LYIT",
	"CAUCASIAN ALBANIAN LETTER HEYT",
	"CAUCASIAN ALBANIAN LETTER QAY",
	"CAUCASIAN ALBANIAN LETTER AOR",
	"CAUCASIAN ALBANIAN LETTER CHOY",
	"CAUCASIAN ALBANIAN LETTER CHI",
	"CAUCASIAN ALBANIAN LETTER CYAY",
	"CAUCASIAN ALBANIAN LETTER MAQ",
	"CAUCASIAN ALBANIAN LETTER QAR",
	"CAUCASIAN ALBANIAN LETTER NOWC",
	"CAUCASIAN ALBANIAN LETTER DZYAY",
	"CAUCASIAN ALBANIAN LETTER SHAK",
	"CAUCASIAN ALBANIAN LETTER JAYN",
	"CAUCASIAN ALBANIAN LETTER ON",
	"CAUCASIAN ALBANIAN LETTER TYAY",
	"CAUCASIAN ALBANIAN LETTER FAM",
	"CAUCASIAN ALBANIAN LETTER DZAY",
	"CAUCASIAN ALBANIAN LETTER CHAT",
	"CAUCASIAN ALBANIAN LETTER PEN",
	"CAUCASIAN ALBANIAN LETTER GHEYS",
	"CAUCASIAN ALBANIAN LETTER RAT",
	"CAUCASIAN ALBANIAN LETTER SEYK",
	"CAUCASIAN ALBANIAN LETTER VEYZ",
	"CAUCASIAN ALBANIAN LETTER TIWR",
	"CAUCASIAN ALBANIAN LETTER SHOY",
	"CAUCASIAN ALBANIAN LETTER IWN",
	"CAUCASIAN ALBANIAN LETTER CYAW",
	"CAUCASIAN ALBANIAN LETTER CAYN",
	"CAUCASIAN ALBANIAN LETTER YAYD",
	"CAUCASIAN ALBANIAN LETTER PIWR",
	"CAUCASIAN ALBANIAN LETTER KIW",
	"CAUCASIAN ALBANIAN CITATION MARK",
	"VITHKUQI CAPITAL LETTER A",
	"VITHKUQI CAPITAL LETTER BBE",
	"VITHKUQI CAPITAL LETTER BE",
	"VITHKUQI CAPITAL LETTER CE",
	"VITHKUQI CAPITAL LETTER CHE",
	"VITHKUQI CAPITAL LETTER DE",
	"VITHKUQI CAPITAL LETTER DHE",
	"VITHKUQI CAPITAL LETTER EI",
	"VITHKUQI CAPITAL LETTER E",
	"VITHKUQI CAPITAL LETTER FE",
	"VITHKUQI CAPITAL LETTER GA",
	"VITHKUQI CAPITAL LETTER HA",
	"VITHKUQI CAPITAL LETTER HHA",
	"VITHKUQI CAPITAL LETTER I",
	"VITHKUQI CAPITAL LETTER IJE",
	"VITHKUQI CAPITAL LETTER JE",
	"VITHKUQI CAPITAL LETTER KA",
	"VITHKUQI CAPITAL LETTER LA",
	"VITHKUQI CAPITAL LETTER LLA",
	"VITHKUQI CAPITAL LETTER ME",
	"VITHKUQI CAPITAL LETTER NE",
	"VITHKUQI CAPITAL LETTER NJE",
	"VITHKUQI CAPITAL LETTER O",
	"VITHKUQI CAPITAL LETTER PE",
	"VITHKUQI CAPITAL LETTER QA",
	"VITHKUQI CAPITAL LETTER RE",
	"VITHKUQI CAPITAL LETTER SE",
	"VITHKUQI CAPITAL LETTER SHE",
	"VITHKUQI CAPITAL LETTER TE",
	"VITHKUQI CAPITAL LETTER THE",
	"VITHKUQI CAPITAL LETTER U",
	"VITHKUQI CAPITAL LETTER VE",
	"VITHKUQI CAPITAL LETTER XE",
	"VITHKUQI CAPITAL LETTER Y",
	"VITHKUQI CAPITAL LETTER ZE",
	"VITHKUQI SMALL LETTER A",
	"VITHKUQI SMALL LETTER BBE",
	"VITHKUQI SMALL LETTER BE",
	"VITHKUQI SMALL LETTER CE",
	"VITHKUQI SMALL LETTER CHE",
	"VITHKUQI SMALL LETTER DE",
	"VITHKUQI SMALL LETTER DHE",
	"VITHKUQI SMALL LETTER EI",
	"VITHKUQI SMALL LETTER E",
	"VITHKUQI SMALL LETTER FE",
	"VITHKUQI SMALL LETTER GA",
	"VITHKUQI SMALL LETTER HA",
	"VITHKUQI SMALL LETTER HHA",
	"VITHKUQI SMALL LETTER I",
	"VITHKUQI SMALL LETTER IJE",
	"VITHKUQI SMALL LETTER JE",
	"VITHKUQI SMALL LETTER KA",
	"VITHKUQI SMALL LETTER LA",
	"VITHKUQI SMALL LETTER LLA",
	"VITHKUQI SMALL LETTER ME",
	"VITHKUQI SMALL LETTER NE",
	"VITHKUQI SMALL LETTER NJE",
	"VITHKUQI SMALL LETTER O",
	"VITHKUQI SMALL LETTER PE",
	"VITHKUQI SMALL LETTER QA",
	"VITHKUQI SMALL LETTER RE",
	"VITHKUQI SMALL LETTER SE",
	"VITHKUQI SMALL LETTER SHE",
	"VITHKUQI SMALL LETTER TE",
	"VITHKUQI SMALL LETTER THE",
	"VITHKUQI SMALL LETTER U",
	"VITHKUQI SMALL LETTER VE",
	"VITHKUQI SMALL LETTER XE",
	"VITHKUQI SMALL LETTER Y",
	"VITHKUQI SMALL LETTER ZE",
	"LINEAR A SIGN AB001",
	"LINEAR A SIGN AB002",
	"LINEAR A SIGN AB003",
	"LINEAR A SIGN AB004",
	"LINEAR A SIGN AB005",
	"LINEAR A SIGN AB006",
	"LINEAR A SIGN AB007",
	"LINEAR A SIGN AB008",
	"LINEAR A SIGN AB009",
	"LINEAR A SIGN AB010",
	"LINEAR A SIGN AB011",
	"LINEAR A SIGN AB013",
	"LINEAR A SIGN AB016",
	"LINEAR A SIGN AB017",
	"LINEAR A SIGN AB020",
	"LINEAR A SIGN AB021",
	"LINEAR A SIGN AB021F",
	"LINEAR A SIGN AB021M",
	"LINEAR A SIGN AB022",
	"LINEAR A SIGN AB022F",
	"LINEAR A SIGN AB022M",
	"LINEAR A SIGN AB023",
	"LINEAR A SIGN AB023M",
	"LINEAR A SIGN AB024",
	"LINEAR A SIGN AB026",
	"LINEAR A SIGN AB027",
	"LINEAR A SIGN AB028",
	"LINEAR A SIGN A028B",
	"LINEAR A SIGN AB029",
	"LINEAR A SIGN AB030",
	"LINEAR A SIGN AB031",
	"LINEAR A SIGN AB034",
	"LINEAR A SIGN AB037",
	"LINEAR A SIGN AB038",
	"LINEAR A SIGN AB039",
	"LINEAR A SIGN AB040",
	"LINEAR A SIGN AB041",
	"LINEAR A SIGN AB044",
	"LINEAR A SIGN AB045",
	"LINEAR A SIGN AB046",
	"LINEAR A SIGN AB047",
	"LINEAR A SIGN AB048",
	"LINEAR A SIGN AB049",
	"LINEAR A SIGN AB050",
	"LINEAR A SIGN AB051",
	"LINEAR A SIGN AB053",
	"LINEAR A SIGN AB054",
	"LINEAR A SIGN AB055",
	"LINEAR A SIGN AB056",
	"LINEAR A SIGN AB057",
	"LINEAR A SIGN AB058",
	"LINEAR A SIGN AB059",
	"LINEAR A SIGN AB060",
	"LINEAR A SIGN AB061",
	"LINEAR A SIGN AB065",
	"LINEAR A SIGN AB066",
	"LINEAR A SIGN AB067",
	"LINEAR A SIGN AB069",
	"LINEAR A SIGN AB070",
	"LINEAR A SIGN AB073",
	"LINEAR A SIGN AB074",
	"LINEAR A SIGN AB076",
	"LINEAR A SIGN AB077",
	"LINEAR A SIGN AB078",
	"LINEAR A SIGN AB079",
	"LINEAR A SIGN AB080",
	"LINEAR A SIGN AB081",
	"LINEAR A SIGN AB082",
	"LINEAR A SIGN AB085",
	"LINEAR A SIGN AB086",
	"LINEAR A SIGN AB087",
	"LINEAR A SIGN A100-102",
	"LINEAR A SIGN AB118",
	"LINEAR A SIGN AB120",
	"LINEAR A SIGN A120B",
	"LINEAR A SIGN AB122",
	"LINEAR A SIGN AB123",
	"LINEAR A SIGN AB131A",
	"LINEAR A SIGN AB131B",
	"LINEAR A SIGN A131C",
	"LINEAR A SIGN AB164",
	"LINEAR A SIGN AB171",
	"LINEAR A SIGN AB180",
	"LINEAR A SIGN AB188",
	"LINEAR A SIGN AB191",
	"LINEAR A SIGN A301",
	"LINEAR A SIGN A302",
	"LINEAR A SIGN A303",
	"LINEAR A SIGN A304",
	"LINEAR A SIGN A305",
	"LINEAR A SIGN A306",
	"LINEAR A SIGN A307",
	"LINEAR A SIGN A308",
	"LINEAR A SIGN A309A",
	"LINEAR A SIGN A309B",
	"LINEAR A SIGN A309C",
	"LINEAR A SIGN A310",
	"LINEAR A SIGN A311",
	"LINEAR A SIGN A312",
	"LINEAR A SIGN A313A",
	"LINEAR A SIGN A313B",
	"LINEAR A SIGN A313C",
	"LINEAR A SIGN A314",
	"LINEAR A SIGN A315",
	"LINEAR A SIGN A316",
	"LINEAR A SIGN A317",
	"LINEAR A SIGN A318",
	"LINEAR A SIGN A319",
	"LINEAR A SIGN A320",
	"LINEAR A SIGN A321",
	"LINEAR A SIGN A322",
	"LINEAR A SIGN A323",
	"LINEAR A SIGN A324",
	"LINEAR A SIGN A325",
	"LINEAR A SIGN A326",
	"LINEAR A SIGN A327",
	"LINEAR A SIGN A328",
	"LINEAR A SIGN A329",
	"LINEAR A SIGN A330",
	"LINEAR A SIGN A331",
	"LINEAR A SIGN A332",
	"LINEAR A SIGN A333",
	"LINEAR A SIGN A334",
	"LINEAR A SIGN A335",
	"LINEAR A SIGN A336",
	"LINEAR A SIGN A337",
	"LINEAR A SIGN A338",
	"LINEAR A SIGN A339",
	"LINEAR A SIGN A340",
	"LINEAR A SIGN A341",
	"LINEAR A SIGN A342",
	"LINEAR A SIGN A343",
	"LINEAR A SIGN A344",
	"LINEAR A SIGN A345",
	"LINEAR A SIGN A346",
	"LINEAR A SIGN A347",
	"LINEAR A SIGN A348",
	"LINEAR A SIGN A349",
	"LINEAR A SIGN A350",
	"LINEAR A SIGN A351",
	"LINEAR A SIGN A352",
	"LINEAR A SIGN A353",
	"LINEAR A SIGN A354",
	"LINEAR A SIGN A355",
	"LINEAR A SIGN A356",
	"LINEAR A SIGN A357",
	"LINEAR A SIGN A358",
	"LINEAR A SIGN A359",
	"LINEAR A SIGN A360",
	"LINEAR A SIGN A361",
	"LINEAR A SIGN A362",
	"LINEAR A SIGN A363",
	"LINEAR A SIGN A364",
	"LINEAR A SIGN A365",
	"LINEAR A SIGN A366",
	"LINEAR A SIGN A367",
	"LINEAR A SIGN A368",
	"LINEAR A SIGN A369",
	"LINEAR A SIGN A370",
	"LINEAR A SIGN A371",
	"LINEAR A SIGN A400-VAS",
	"LINEAR A SIGN A401-VAS",
	"LINEAR A SIGN A402-VAS",
	"LINEAR A SIGN A403-VAS",
	"LINEAR A SIGN A404-VAS",
	"LINEAR A SIGN A405-VAS",
	"LINEAR A SIGN A406-VAS",
	"LINEAR A SIGN A407-VAS",
	"LINEAR A SIGN A408-VAS",
	"LINEAR A SIGN A409-VAS",
	"LINEAR A SIGN A410-VAS",
	"LINEAR A SIGN A411-VAS",
	"LINEAR A SIGN A412-VAS",
	"LINEAR A SIGN A413-VAS",
	"LINEAR A SIGN A414-VAS",
	"LINEAR A SIGN A415-VAS",
	"LINEAR A SIGN A416-VAS",
	"LINEAR A SIGN A417-VAS",
	"LINEAR A SIGN A418-VAS",
	"LINEAR A SIGN A501",
	"LINEAR A SIGN A502",
	"LINEAR A SIGN A503",
	"LINEAR A SIGN A504",
	"LINEAR A SIGN A505",
	"LINEAR A SIGN A506",
	"LINEAR A SIGN A508",
	"LINEAR A SIGN A509",
	"LINEAR A SIGN A510",
	"LINEAR A SIGN A511",
	"LINEAR A SIGN A512",
	"LINEAR A SIGN A513",
	"LINEAR A SIGN A515",
	"LINEAR A SIGN A516",
	"LINEAR A SIGN A520",
	"LINEAR A SIGN A521",
	"LINEAR A SIGN A523",
	"LINEAR A SIGN A524",
	"LINEAR A SIGN A525",
	"LINEAR A SIGN A526",
	"LINEAR A SIGN A527",
	"LINEAR A SIGN A528",
	"LINEAR A SIGN A529",
	"LINEAR A SIGN A530",
	"LINEAR A SIGN A531",
	"LINEAR A SIGN A532",
	"LINEAR A SIGN A534",
	"LINEAR A SIGN A535",
	"LINEAR A SIGN A536",
	"LINEAR A SIGN A537",
	"LINEAR A SIGN A538",
	"LINEAR A SIGN A539",
	"LINEAR A SIGN A540",
	"LINEAR A SIGN A541",
	"LINEAR A SIGN A542",
	"LINEAR A SIGN A545",
	"LINEAR A SIGN A547",
	"LINEAR A SIGN A548",
	"LINEAR A SIGN A549",
	"LINEAR A SIGN A550",
	"LINEAR A SIGN A551",
	"LINEAR A SIGN A552",
	"LINEAR A SIGN A553",
	"LINEAR A SIGN A554",
	"LINEAR A SIGN A555",
	"LINEAR A SIGN A556",
	"LINEAR A SIGN A557",
	"LINEAR A SIGN A559",
	"LINEAR A SIGN A563",
	"LINEAR A SIGN A564",
	"LINEAR A SIGN A565",
	"LINEAR A SIGN A566",
	"LINEAR A SIGN A568",
	"LINEAR A SIGN A569",
	"LINEAR A SIGN A570",
	"LINEAR A SIGN A571",
	"LINEAR A SIGN A572",
	"LINEAR A SIGN A573",
	"LINEAR A SIGN A574",
	"LINEAR A SIGN A575",
	"LINEAR A SIGN A576",
	"LINEAR A SIGN A577",
	"LINEAR A SIGN A578",
	"LINEAR A SIGN A579",
	"LINEAR A SIGN A580",
	"LINEAR A SIGN A581",
	"LINEAR A SIGN A582",
	"LINEAR A SIGN A583",
	"LINEAR A SIGN A584",
	"LINEAR A SIGN A585",
	"LINEAR A SIGN A586",
	"LINEAR A SIGN A587",
	"LINEAR A SIGN A588",
	"LINEAR A SIGN A589",
	"LINEAR A SIGN A591",
	"LINEAR A SIGN A592",
	"LINEAR A SIGN A594",
	"LINEAR A SIGN A595",
	"LINEAR A SIGN A596",
	"LINEAR A SIGN A598",
	"LINEAR A SIGN A600",
	"LINEAR A SIGN A601",
	"LINEAR A SIGN A602",
	"LINEAR A SIGN A603",
	"LINEAR A SIGN A604",
	"LINEAR A SIGN A606",
	"LINEAR A SIGN A608",
	"LINEAR A SIGN A609",
	"LINEAR A SIGN A610",
	"LINEAR A SIGN A611",
	"LINEAR A SIGN A612",
	"LINEAR A SIGN A613",
	"LINEAR A SIGN A614",
	"LINEAR A SIGN A615",
	"LINEAR A SIGN A616",
	"LINEAR A SIGN A617",
	"LINEAR A SIGN A618",
	"LINEAR A SIGN A619",
	"LINEAR A SIGN A620",
	"LINEAR A SIGN A621",
	"LINEAR A SIGN A622",
	"LINEAR A SIGN A623",
	"LINEAR A SIGN A624",
	"LINEAR A SIGN A626",
	"LINEAR A SIGN A627",
	"LINEAR A SIGN A628",
	"LINEAR A SIGN A629",
	"LINEAR A SIGN A634",
	"LINEAR A SIGN A637",
	"LINEAR A SIGN A638",
	"LINEAR A SIGN A640",
	"LINEAR A SIGN A642",
	"LINEAR A SIGN A643",
	"LINEAR A SIGN A644",
	"LINEAR A SIGN A645",
	"LINEAR A SIGN A646",
	"LINEAR A SIGN A648",
	"LINEAR A SIGN A649",
	"LINEAR A SIGN A651",
	"LINEAR A SIGN A652",
	"LINEAR A SIGN A653",
	"LINEAR A SIGN A654",
	"LINEAR A SIGN A655",
	"LINEAR A SIGN A656",
	"LINEAR A SIGN A657",
	"LINEAR A SIGN A658",
	"LINEAR A SIGN A659",
	"LINEAR A SIGN A660",
	"LINEAR A SIGN A661",
	"LINEAR A SIGN A662",
	"LINEAR A SIGN A663",
	"LINEAR A SIGN A664",
	"LINEAR A SIGN A701 A",
	"LINEAR A SIGN A702 B",
	"LINEAR A SIGN A703 D",
	"LINEAR A SIGN A704 E",
	"LINEAR A SIGN A705 F",
	"LINEAR A SIGN A706 H",
	"LINEAR A SIGN A707 J",
	"LINEAR A SIGN A708 K",
	"LINEAR A SIGN A709 L",
	"LINEAR A SIGN A709-2 L2",
	"LINEAR A SIGN A709-3 L3",
	"LINEAR A SIGN A709-4 L4",
	"LINEAR A SIGN A709-6 L6",
	"LINEAR A SIGN A710 W",
	"LINEAR A SIGN A711 X",
	"LINEAR A SIGN A712 Y",
	"LINEAR A SIGN A713 OMEGA",
	"LINEAR A SIGN A714 ABB",
	"LINEAR A SIGN A715 BB",
	"LINEAR A SIGN A717 DD",
	"LINEAR A SIGN A726 EYYY",
	"LINEAR A SIGN A732 JE",
	"LINEAR A SIGN A800",
	"LINEAR A SIGN A801",
	"LINEAR A SIGN A802",
	"LINEAR A SIGN A803",
	"LINEAR A SIGN A804",
	"LINEAR A SIGN A805",
	"LINEAR A SIGN A806",
	"LINEAR A SIGN A807",
	"MODIFIER LETTER SMALL CAPITAL AA",
	"MODIFIER LETTER SUPERSCRIPT TRIANGULAR COLON",
	"MODIFIER LETTER SUPERSCRIPT HALF TRIANGULAR COLON",
	"MODIFIER LETTER SMALL AE",
	"MODIFIER LETTER SMALL CAPITAL B",
	"MODIFIER LETTER SMALL B WITH HOOK",
	"MODIFIER LETTER SMALL DZ DIGRAPH",
	"MODIFIER LETTER SMALL DZ DIGRAPH WITH RETROFLEX HOOK",
	"MODIFIER LETTER SMALL DZ DIGRAPH WITH CURL",
	"MODIFIER LETTER SMALL DEZH DIGRAPH",
	"MODIFIER LETTER SMALL D WITH TAIL",
	"MODIFIER LETTER SMALL D WITH HOOK",
	"MODIFIER LETTER SMALL D WITH HOOK AND TAIL",
	"MODIFIER LETTER SMALL REVERSED E",
	"MODIFIER LETTER SMALL CLOSED REVERSED OPEN E",
	"MODIFIER LETTER SMALL FENG DIGRAPH",
	"MODIFIER LETTER SMALL RAMS HORN",
	"MODIFIER LETTER SMALL CAPITAL G",
	"MODIFIER LETTER SMALL G WITH HOOK",
	"MODIFIER LETTER SMALL CAPITAL G WITH HOOK",
	"MODIFIER LETTER SMALL H WITH STROKE",
	"MODIFIER LETTER SMALL CAPITAL H",
	"MODIFIER LETTER SMALL HENG WITH HOOK",
	"MODIFIER LETTER SMALL DOTLESS J WITH STROKE AND HOOK",
	"MODIFIER LETTER SMALL LS DIGRAPH",
	"MODIFIER LETTER SMALL LZ DIGRAPH",
	"MODIFIER LETTER SMALL L WITH BELT",
	"MODIFIER LETTER SMALL CAPITAL L WITH BELT",
	"MODIFIER LETTER SMALL L WITH RETROFLEX HOOK AND BELT",
	"MODIFIER LETTER SMALL LEZH",
	"MODIFIER LETTER SMALL LEZH WITH RETROFLEX HOOK",
	"MODIFIER LETTER SMALL TURNED Y",
	"MODIFIER LETTER SMALL TURNED Y WITH BELT",
	"MODIFIER LETTER SMALL O WITH STROKE",
	"MODIFIER LETTER SMALL CAPITAL OE",
	"MODIFIER LETTER SMALL CLOSED OMEGA",
	"MODIFIER LETTER SMALL Q",
	"MODIFIER LETTER SMALL TURNED R WITH LONG LEG",
	"MODIFIER LETTER SMALL TURNED R WITH LONG LEG AND RETROFLEX HOOK",
	"MODIFIER LETTER SMALL R WITH TAIL",
	"MODIFIER LETTER SMALL R WITH FISHHOOK",
	"MODIFIER LETTER SMALL CAPITAL R",
	"MODIFIER LETTER SMALL TC DIGRAPH WITH CURL",
	"MODIFIER LETTER SMALL TS DIGRAPH",
	"MODIFIER LETTER SMALL TS DIGRAPH WITH RETROFLEX HOOK",
	"MODIFIER LETTER SMALL TESH DIGRAPH",
	"MODIFIER LETTER SMALL T WITH RETROFLEX HOOK",
	"MODIFIER LETTER SMALL V WITH RIGHT HOOK",
	"MODIFIER LETTER SMALL CAPITAL Y",
	"MODIFIER LETTER GLOTTAL STOP WITH STROKE",
	"MODIFIER LETTER REVERSED GLOTTAL STOP WITH STROKE",
	"MODIFIER LETTER BILABIAL CLICK",
	"MODIFIER LETTER DENTAL CLICK",
	"MODIFIER LETTER LATERAL CLICK",
	"MODIFIER LETTER ALVEOLAR CLICK",
	"MODIFIER LETTER RETROFLEX CLICK WITH RETROFLEX HOOK",
	"MODIFIER LETTER SMALL S WITH CURL",
	"CYPRIOT SYLLABLE A",
	"CYPRIOT SYLLABLE E",
	"CYPRIOT SYLLABLE I",
	"CYPRIOT SYLLABLE O",
	"CYPRIOT SYLLABLE U",
	"CYPRIOT SYLLABLE JA",
	"CYPRIOT SYLLABLE JO",
	"CYPRIOT SYLLABLE KA",
	"CYPRIOT SYLLABLE KE",
	"CYPRIOT SYLLABLE KI",
	"CYPRIOT SYLLABLE KO",
	"CYPRIOT SYLLABLE KU",
	"CYPRIOT SYLLABLE LA",
	"CYPRIOT SYLLABLE LE",
	"CYPRIOT SYLLABLE LI",
	"CYPRIOT SYLLABLE LO",
	"CYPRIOT SYLLABLE LU",
	"CYPRIOT SYLLABLE MA",
	"CYPRIOT SYLLABLE ME",
	"CYPRIOT SYLLABLE MI",
	"CYPRIOT SYLLABLE MO",
	"CYPRIOT SYLLABLE MU",
	"CYPRIOT SYLLABLE NA",
	"CYPRIOT SYLLABLE NE",
	"CYPRIOT SYLLABLE NI",
	"CYPRIOT SYLLABLE NO",
	"CYPRIOT SYLLABLE NU",
	"CYPRIOT SYLLABLE PA",
	"CYPRIOT SYLLABLE PE",
	"CYPRIOT SYLLABLE PI",
	"CYPRIOT SYLLABLE PO",
	"CYPRIOT SYLLABLE PU",
	"CYPRIOT SYLLABLE RA",
	"CYPRIOT SYLLABLE RE",
	"CYPRIOT SYLLABLE RI",
	"CYPRIOT SYLLABLE RO",
	"CYPRIOT SYLLABLE RU",
	"CYPRIOT SYLLABLE SA",
	"CYPRIOT SYLLABLE SE",
	"CYPRIOT SYLLABLE SI",
	"CYPRIOT SYLLABLE SO",
	"CYPRIOT SYLLABLE SU",
	"CYPRIOT SYLLABLE TA",
	"CYPRIOT SYLLABLE TE",
	"CYPRIOT SYLLABLE TI",
	"CYPRIOT SYLLABLE TO",
	"CYPRIOT SYLLABLE TU",
	"CYPRIOT SYLLABLE WA",
	"CYPRIOT SYLLABLE WE",
	"CYPRIOT SYLLABLE WI",
	"CYPRIOT SYLLABLE WO",
	"CYPRIOT SYLLABLE XA",
	"CYPRIOT SYLLABLE XE",
	"CYPRIOT SYLLABLE ZA",
	"CYPRIOT SYLLABLE ZO",
	"IMPERIAL ARAMAIC LETTER ALEPH",
	"IMPERIAL ARAMAIC LETTER BETH",
	"IMPERIAL ARAMAIC LETTER GIMEL",
	"IMPERIAL ARAMAIC LETTER DALETH",
	"IMPERIAL ARAMAIC LETTER HE",
	"IMPERIAL ARAMAIC LETTER WAW",
	"IMPERIAL ARAMAIC LETTER ZAYIN",
	"IMPERIAL ARAMAIC LETTER HETH",
	"IMPERIAL ARAMAIC LETTER TETH",
	"IMPERIAL ARAMAIC LETTER YODH",
	"IMPERIAL ARAMAIC LETTER KAPH",
	"IMPERIAL ARAMAIC LETTER LAMEDH",
	"IMPERIAL ARAMAIC LETTER MEM",
	"IMPERIAL ARAMAIC LETTER NUN",
	"IMPERIAL ARAMAIC LETTER SAMEKH",
	"IMPERIAL ARAMAIC LETTER AYIN",
	"IMPERIAL ARAMAIC LETTER PE",
	"IMPERIAL ARAMAIC LETTER SADHE",
	"IMPERIAL ARAMAIC LETTER QOPH",
	"IMPERIAL ARAMAIC LETTER RESH",
	"IMPERIAL ARAMAIC LETTER SHIN",
	"IMPERIAL ARAMAIC LETTER TAW",
	"IMPERIAL ARAMAIC SECTION SIGN",
	"IMPERIAL ARAMAIC NUMBER ONE",
	"IMPERIAL ARAMAIC NUMBER TWO",
	"IMPERIAL ARAMAIC NUMBER THREE",
	"IMPERIAL ARAMAIC NUMBER TEN",
	"IMPERIAL ARAMAIC NUMBER TWENTY",
	"IMPERIAL ARAMAIC NUMBER ONE HUNDRED",
	"IMPERIAL ARAMAIC NUMBER ONE THOUSAND",
	"IMPERIAL ARAMAIC NUMBER TEN THOUSAND",
	"PALMYRENE LETTER ALEPH",
	"PALMYRENE LETTER BETH",
	"PALMYRENE LETTER GIMEL",
	"PALMYRENE LETTER DALETH",
	"PALMYRENE LETTER HE",
	"PALMYRENE LETTER WAW",
	"PALMYRENE LETTER ZAYIN",
	"PALMYRENE LETTER HETH",
	"PALMYRENE LETTER TETH",
	"PALMYRENE LETTER YODH",
	"PALMYRENE LETTER KAPH",
	"PALMYRENE LETTER LAMEDH",
	"PALMYRENE LETTER MEM",
	"PALMYRENE LETTER FINAL NUN",
	"PALMYRENE LETTER NUN",
	"PALMYRENE LETTER SAMEKH",
	"PALMYRENE LETTER AYIN",
	"PALMYRENE LETTER PE",
	"PALMYRENE LETTER SADHE",
	"PALMYRENE LETTER QOPH",
	"PALMYRENE LETTER RESH",
	"PALMYRENE LETTER SHIN",
	"PALMYRENE LETTER TAW",
	"PALMYRENE LEFT-POINTING FLEURON",
	"PALMYRENE RIGHT-POINTING FLEURON",
	"PALMYRENE NUMBER ONE",
	"PALMYRENE NUMBER TWO",
	"PALMYRENE NUMBER THREE",
	"PALMYRENE NUMBER FOUR",
	"PALMYRENE NUMBER FIVE",
	"PALMYRENE NUMBER TEN",
	"PALMYRENE NUMBER TWENTY",
	"NABATAEAN LETTER FINAL ALEPH",
	"NABATAEAN LETTER ALEPH",
	"NABATAEAN LETTER FINAL BETH",
	"NABATAEAN LETTER BETH",
	"NABATAEAN LETTER GIMEL",
	"NABATAEAN LETTER DALETH",
	"NABATAEAN LETTER FINAL HE",
	"NABATAEAN LETTER HE",
	"NABATAEAN LETTER WAW",
	"NABATAEAN LETTER ZAYIN",
	"NABATAEAN LETTER HETH",
	"NABATAEAN LETTER TETH",
	"NABATAEAN LETTER FINAL YODH",
	"NABATAEAN LETTER YODH",
	"NABATAEAN LETTER FINAL KAPH",
	"NABATAEAN LETTER KAPH",
	"NABATAEAN LETTER FINAL LAMEDH",
	"NABATAEAN LETTER LAMEDH",
	"NABATAEAN LETTER FINAL MEM",
	"NABATAEAN LETTER MEM",
	"NABATAEAN LETTER FINAL NUN",
	"NABATAEAN LETTER NUN",
	"NABATAEAN LETTER SAMEKH",
	"NABATAEAN LETTER AYIN",
	"NABATAEAN LETTER PE",
	"NABATAEAN LETTER SADHE",
	"NABATAEAN LETTER QOPH",
	"NABATAEAN LETTER RESH",
	"NABATAEAN LETTER FINAL SHIN",
	"NABATAEAN LETTER SHIN",
	"NABATAEAN LETTER TAW",
	"NABATAEAN NUMBER ONE",
	"NABATAEAN NUMBER TWO",
	"NABATAEAN NUMBER THREE",
	"NABATAEAN NUMBER FOUR",
	"NABATAEAN CRUCIFORM NUMBER FOUR",
	"NABATAEAN NUMBER FIVE",
	"NABATAEAN NUMBER TEN",
	"NABATAEAN NUMBER TWENTY",
	"NABATAEAN NUMBER ONE HUNDRED",
	"HATRAN LETTER ALEPH",
	"HATRAN LETTER BETH",
	"HATRAN LETTER GIMEL",
	"HATRAN LETTER DALETH-RESH",
	"HATRAN LETTER HE",
	"HATRAN LETTER WAW",
	"HATRAN LETTER ZAYN",
	"HATRAN LETTER HETH",
	"HATRAN LETTER TETH",
	"HATRAN LETTER YODH",
	"HATRAN LETTER KAPH",
	"HATRAN LETTER LAMEDH",
	"HATRAN LETTER MEM",
	"HATRAN LETTER NUN",
	"HATRAN LETTER SAMEKH",
	"HATRAN LETTER AYN",
	"HATRAN LETTER PE",
	"HATRAN LETTER SADHE",
	"HATRAN LETTER QOPH",
	"HATRAN LETTER SHIN",
	"HATRAN LETTER TAW",
	"HATRAN NUMBER ONE",
	"HATRAN NUMBER FIVE",
	"HATRAN NUMBER TEN",
	"HATRAN NUMBER TWENTY",
	"HATRAN NUMBER ONE HUNDRED",
	"PHOENICIAN LETTER ALF",
	"PHOENICIAN LETTER BET",
	"PHOENICIAN LETTER GAML",
	"PHOENICIAN LETTER DELT",
	"PHOENICIAN LETTER HE",
	"PHOENICIAN LETTER WAU",
	"PHOENICIAN LETTER ZAI",
	"PHOENICIAN LETTER HET",
	"PHOENICIAN LETTER TET",
	"PHOENICIAN LETTER YOD",
	"PHOENICIAN LETTER KAF",
	"PHOENICIAN LETTER LAMD",
	"PHOENICIAN LETTER MEM",
	"PHOENICIAN LETTER NUN",
	"PHOENICIAN LETTER SEMK",
	"PHOENICIAN LETTER AIN",
	"PHOENICIAN LETTER PE",
	"PHOENICIAN LETTER SADE",
	"PHOENICIAN LETTER QOF",
	"PHOENICIAN LETTER ROSH",
	"PHOENICIAN LETTER SHIN",
	"PHOENICIAN LETTER TAU",
	"PHOENICIAN NUMBER ONE",
	"PHOENICIAN NUMBER TEN",
	"PHOENICIAN NUMBER TWENTY",
	"PHOENICIAN NUMBER ONE HUNDRED",
	"PHOENICIAN NUMBER TWO",
	"PHOENICIAN NUMBER THREE",
	"PHOENICIAN WORD SEPARATOR",
	"LYDIAN LETTER A",
	"LYDIAN LETTER B",
	"LYDIAN LETTER G",
	"LYDIAN LETTER D",
	"LYDIAN LETTER E",
	"LYDIAN LETTER V",
	"LYDIAN LETTER I",
	"LYDIAN LETTER Y",
	"LYDIAN LETTER K",
	"LYDIAN LETTER L",
	"LYDIAN LETTER M",
	"LYDIAN LETTER N",
	"LYDIAN LETTER O",
	"LYDIAN LETTER R",
	"LYDIAN LETTER SS",
	"LYDIAN LETTER T",
	"LYDIAN LETTER U",
	"LYDIAN LETTER F",
	"LYDIAN LETTER Q",
	"LYDIAN LETTER S",
	"LYDIAN LETTER TT",
	"LYDIAN LETTER AN",
	"LYDIAN LETTER EN",
	"LYDIAN LETTER LY",
	"LYDIAN LETTER NN",
	"LYDIAN LETTER C",
	"LYDIAN TRIANGULAR MARK",
	"MEROITIC HIEROGLYPHIC LETTER A",
	"MEROITIC HIEROGLYPHIC LETTER E",
	"MEROITIC HIEROGLYPHIC LETTER I",
	"MEROITIC HIEROGLYPHIC LETTER O",
	"MEROITIC HIEROGLYPHIC LETTER YA",
	"MEROITIC HIEROGLYPHIC LETTER WA",
	"MEROITIC HIEROGLYPHIC LETTER BA",
	"MEROITIC HIEROGLYPHIC LETTER BA-2",
	"MEROITIC HIEROGLYPHIC LETTER PA",
	"MEROITIC HIEROGLYPHIC LETTER MA",
	"MEROITIC HIEROGLYPHIC LETTER NA",
	"MEROITIC HIEROGLYPHIC LETTER NA-2",
	"MEROITIC HIEROGLYPHIC LETTER NE",
	"MEROITIC HIEROGLYPHIC LETTER NE-2",
	"MEROITIC HIEROGLYPHIC LETTER RA",
	"MEROITIC HIEROGLYPHIC LETTER RA-2",
	"MEROITIC HIEROGLYPHIC LETTER LA",
	"MEROITIC HIEROGLYPHIC LETTER KHA",
	"MEROITIC HIEROGLYPHIC LETTER HHA",
	"MEROITIC HIEROGLYPHIC LETTER SA",
	"MEROITIC HIEROGLYPHIC LETTER SA-2",
	"MEROITIC HIEROGLYPHIC LETTER SE",
	"MEROITIC HIEROGLYPHIC LETTER KA",
	"MEROITIC HIEROGLYPHIC LETTER QA",
	"MEROITIC HIEROGLYPHIC LETTER TA",
	"MEROITIC HIEROGLYPHIC LETTER TA-2",
	"MEROITIC HIEROGLYPHIC LETTER TE",
	"MEROITIC HIEROGLYPHIC LETTER TE-2",
	"MEROITIC HIEROGLYPHIC LETTER TO",
	"MEROITIC HIEROGLYPHIC LETTER DA",
	"MEROITIC HIEROGLYPHIC SYMBOL VIDJ",
	"MEROITIC HIEROGLYPHIC SYMBOL VIDJ-2",
	"MEROITIC CURSIVE LETTER A",
	"MEROITIC CURSIVE LETTER E",
	"MEROITIC CURSIVE LETTER I",
	"MEROITIC CURSIVE LETTER O",
	"MEROITIC CURSIVE LETTER YA",
	"MEROITIC CURSIVE LETTER WA",
	"MEROITIC CURSIVE LETTER BA",
	"MEROITIC CURSIVE LETTER PA",
	"MEROITIC CURSIVE LETTER MA",
	"MEROITIC CURSIVE LETTER NA",
	"MEROITIC CURSIVE LETTER NE",
	"MEROITIC CURSIVE LETTER RA",
	"MEROITIC CURSIVE LETTER LA",
	"MEROITIC CURSIVE LETTER KHA",
	"MEROITIC CURSIVE LETTER HHA",
	"MEROITIC CURSIVE LETTER SA",
	"MEROITIC CURSIVE LETTER ARCHAIC SA",
	"MEROITIC CURSIVE LETTER SE",
	"MEROITIC CURSIVE LETTER KA",
	"MEROITIC CURSIVE LETTER QA",
	"MEROITIC CURSIVE LETTER TA",
	"MEROITIC CURSIVE LETTER TE",
	"MEROITIC CURSIVE LETTER TO",
	"MEROITIC CURSIVE LETTER DA",
	"MEROITIC CURSIVE FRACTION ELEVEN TWELFTHS",
	"MEROITIC CURSIVE FRACTION ONE HALF",
	"MEROITIC CURSIVE LOGOGRAM RMT",
	"MEROITIC CURSIVE LOGOGRAM IMN",
	"MEROITIC CURSIVE NUMBER ONE",
	"MEROITIC CURSIVE NUMBER TWO",
	"MEROITIC CURSIVE NUMBER THREE",
	"MEROITIC CURSIVE NUMBER FOUR",
	"MEROITIC CURSIVE NUMBER FIVE",
	"MEROITIC CURSIVE NUMBER SIX",
	"MEROITIC CURSIVE NUMBER SEVEN",
	"MEROITIC CURSIVE NUMBER EIGHT",
	"MEROITIC CURSIVE NUMBER NINE",
	"MEROITIC CURSIVE NUMBER TEN",
	"MEROITIC CURSIVE NUMBER TWENTY",
	"MEROITIC CURSIVE NUMBER THIRTY",
	"MEROITIC CURSIVE NUMBER FORTY",
	"MEROITIC CURSIVE NUMBER FIFTY",
	"MEROITIC CURSIVE NUMBER SIXTY",
	"MEROITIC CURSIVE NUMBER SEVENTY",
	"MEROITIC CURSIVE NUMBER ONE HUNDRED",
	"MEROITIC CURSIVE NUMBER TWO HUNDRED",
	"MEROITIC CURSIVE NUMBER THREE HUNDRED",
	"MEROITIC CURSIVE NUMBER FOUR HUNDRED",
	"MEROITIC CURSIVE NUMBER FIVE HUNDRED",
	"MEROITIC CURSIVE NUMBER SIX HUNDRED",
	"MEROITIC CURSIVE NUMBER SEVEN HUNDRED",
	"MEROITIC CURSIVE NUMBER EIGHT HUNDRED",
	"MEROITIC CURSIVE NUMBER NINE HUNDRED",
	"MEROITIC CURSIVE NUMBER ONE THOUSAND",
	"MEROITIC CURSIVE NUMBER TWO THOUSAND",
	"MEROITIC CURSIVE NUMBER THREE THOUSAND",
	"MEROITIC CURSIVE NUMBER FOUR THOUSAND",
	"MEROITIC CURSIVE NUMBER FIVE THOUSAND",
	"MEROITIC CURSIVE NUMBER SIX THOUSAND",
	"MEROITIC CURSIVE NUMBER SEVEN THOUSAND",
	"MEROITIC CURSIVE NUMBER EIGHT THOUSAND",
	"MEROITIC CURSIVE NUMBER NINE THOUSAND",
	"MEROITIC CURSIVE NUMBER TEN THOUSAND",
	"MEROITIC CURSIVE NUMBER TWENTY THOUSAND",
	"MEROITIC CURSIVE NUMBER THIRTY THOUSAND",
	"MEROITIC CURSIVE NUMBER FORTY THOUSAND",
	"MEROITIC CURSIVE NUMBER FIFTY THOUSAND",
	"MEROITIC CURSIVE NUMBER SIXTY THOUSAND",
	"MEROITIC CURSIVE NUMBER SEVENTY THOUSAND",
	"MEROITIC CURSIVE NUMBER EIGHTY THOUSAND",
	"MEROITIC CURSIVE NUMBER NINETY THOUSAND",
	"MEROITIC CURSIVE NUMBER ONE HUNDRED THOUSAND",
	"MEROITIC CURSIVE NUMBER TWO HUNDRED THOUSAND",
	"MEROITIC CURSIVE NUMBER THREE HUNDRED THOUSAND",
	"MEROITIC CURSIVE NUMBER FOUR HUNDRED THOUSAND",
	"MEROITIC CURSIVE NUMBER FIVE HUNDRED THOUSAND",
	"MEROITIC CURSIVE NUMBER SIX HUNDRED THOUSAND",
	"MEROITIC CURSIVE NUMBER SEVEN HUNDRED THOUSAND",
	"MEROITIC CURSIVE NUMBER EIGHT HUNDRED THOUSAND",
	"MEROITIC CURSIVE NUMBER NINE HUNDRED THOUSAND",
	"MEROITIC CURSIVE FRACTION ONE TWELFTH",
	"MEROITIC CURSIVE FRACTION TWO TWELFTHS",
	"MEROITIC CURSIVE FRACTION THREE TWELFTHS",
	"MEROITIC CURSIVE FRACTION FOUR TWELFTHS",
	"MEROITIC CURSIVE FRACTION FIVE TWELFTHS",
	"MEROITIC CURSIVE FRACTION SIX TWELFTHS",
	"MEROITIC CURSIVE FRACTION SEVEN TWELFTHS",
	"MEROITIC CURSIVE FRACTION EIGHT TWELFTHS",
	"MEROITIC CURSIVE FRACTION NINE TWELFTHS",
	"MEROITIC CURSIVE FRACTION TEN TWELFTHS",
	"KHAROSHTHI LETTER A",
	"KHAROSHTHI VOWEL SIGN I",
	"KHAROSHTHI VOWEL SIGN U",
	"KHAROSHTHI VOWEL SIGN VOCALIC R",
	"KHAROSHTHI VOWEL SIGN E",
	"KHAROSHTHI VOWEL SIGN O",
	"KHAROSHTHI VOWEL LENGTH MARK",
	"KHAROSHTHI SIGN DOUBLE RING BELOW",
	"KHAROSHTHI SIGN ANUSVARA",
	"KHAROSHTHI SIGN VISARGA",
	"KHAROSHTHI LETTER KA",
	"KHAROSHTHI LETTER KHA",
	"KHAROSHTHI LETTER GA",
	"KHAROSHTHI LETTER GHA",
	"KHAROSHTHI LETTER CA",
	"KHAROSHTHI LETTER CHA",
	"KHAROSHTHI LETTER JA",
	"KHAROSHTHI LETTER NYA",
	"KHAROSHTHI LETTER TTA",
	"KHAROSHTHI LETTER TTHA",
	"KHAROSHTHI LETTER DDA",
	"KHAROSHTHI LETTER DDHA",
	"KHAROSHTHI LETTER NNA",
	"KHAROSHTHI LETTER TA",
	"KHAROSHTHI LETTER THA",
	"KHAROSHTHI LETTER DA",
	"KHAROSHTHI LETTER DHA",
	"KHAROSHTHI LETTER NA",
	"KHAROSHTHI LETTER PA",
	"KHAROSHTHI LETTER PHA",
	"KHAROSHTHI LETTER BA",
	"KHAROSHTHI LETTER BHA",
	"KHAROSHTHI LETTER MA",
	"KHAROSHTHI LETTER YA",
	"KHAROSHTHI LETTER RA",
	"KHAROSHTHI LETTER LA",
	"KHAROSHTHI LETTER VA",
	"KHAROSHTHI LETTER SHA",
	"KHAROSHTHI LETTER SSA",
	"KHAROSHTHI LETTER SA",
	"KHAROSHTHI LETTER ZA",
	"KHAROSHTHI LETTER HA",
	"KHAROSHTHI LETTER KKA",
	"KHAROSHTHI LETTER TTTHA",
	"KHAROSHTHI LETTER TTTA",
	"KHAROSHTHI LETTER VHA",
	"KHAROSHTHI SIGN BAR ABOVE",
	"KHAROSHTHI SIGN CAUDA",
	"KHAROSHTHI SIGN DOT BELOW",
	"KHAROSHTHI VIRAMA",
	"KHAROSHTHI DIGIT ONE",
	"KHAROSHTHI DIGIT TWO",
	"KHAROSHTHI DIGIT THREE",
	"KHAROSHTHI DIGIT FOUR",
	"KHAROSHTHI NUMBER TEN",
	"KHAROSHTHI NUMBER TWENTY",
	"KHAROSHTHI NUMBER ONE HUNDRED",
	"KHAROSHTHI NUMBER ONE THOUSAND",
	"KHAROSHTHI FRACTION ONE HALF",
	"KHAROSHTHI PUNCTUATION DOT",
	"KHAROSHTHI PUNCTUATION SMALL CIRCLE",
	"KHAROSHTHI PUNCTUATION CIRCLE",
	"KHAROSHTHI PUNCTUATION CRESCENT BAR",
	"KHAROSHTHI PUNCTUATION MANGALAM",
	"KHAROSHTHI PUNCTUATION LOTUS",
	"KHAROSHTHI PUNCTUATION DANDA",
	"KHAROSHTHI PUNCTUATION DOUBLE DANDA",
	"KHAROSHTHI PUNCTUATION LINES",
	"OLD SOUTH ARABIAN LETTER HE",
	"OLD SOUTH ARABIAN LETTER LAMEDH",
	"OLD SOUTH ARABIAN LETTER HETH",
	"OLD SOUTH ARABIAN LETTER MEM",
	"OLD SOUTH ARABIAN LETTER QOPH",
	"OLD SOUTH ARABIAN LETTER WAW",
	"OLD SOUTH ARABIAN LETTER SHIN",
	"OLD SOUTH ARABIAN LETTER RESH",
	"OLD SOUTH ARABIAN LETTER BETH",
	"OLD SOUTH ARABIAN LETTER TAW",
	"OLD SOUTH ARABIAN LETTER SAT",
	"OLD SOUTH ARABIAN LETTER KAPH",
	"OLD SOUTH ARABIAN LETTER NUN",
	"OLD SOUTH ARABIAN LETTER KHETH",
	"OLD SOUTH ARABIAN LETTER SADHE",
	"OLD SOUTH ARABIAN LETTER SAMEKH",
	"OLD SOUTH ARABIAN LETTER FE",
	"OLD SOUTH ARABIAN LETTER ALEF",
	"OLD SOUTH ARABIAN LETTER AYN",
	"OLD SOUTH ARABIAN LETTER DHADHE",
	"OLD SOUTH ARABIAN LETTER GIMEL",
	"OLD SOUTH ARABIAN LETTER DALETH",
	"OLD SOUTH ARABIAN LETTER GHAYN",
	"OLD SOUTH ARABIAN LETTER TETH",
	"OLD SOUTH ARABIAN LETTER ZAYN",
	"OLD SOUTH ARABIAN LETTER DHALETH",
	"OLD SOUTH ARABIAN LETTER YODH",
	"OLD SOUTH ARABIAN LETTER THAW",
	"OLD SOUTH ARABIAN LETTER THETH",
	"OLD SOUTH ARABIAN NUMBER ONE",
	"OLD SOUTH ARABIAN NUMBER FIFTY",
	"OLD SOUTH ARABIAN NUMERIC INDICATOR",
	"OLD NORTH ARABIAN LETTER HEH",
	"OLD NORTH ARABIAN LETTER LAM",
	"OLD NORTH ARABIAN LETTER HAH",
	"OLD NORTH ARABIAN LETTER MEEM",
	"OLD NORTH ARABIAN LETTER QAF",
	"OLD NORTH ARABIAN LETTER WAW",
	"OLD NORTH ARABIAN LETTER ES-2",
	"OLD NORTH ARABIAN LETTER REH",
	"OLD NORTH ARABIAN LETTER BEH",
	"OLD NORTH ARABIAN LETTER TEH",
	"OLD NORTH ARABIAN LETTER ES-1",
	"OLD NORTH ARABIAN LETTER KAF",
	"OLD NORTH ARABIAN LETTER NOON",
	"OLD NORTH ARABIAN LETTER KHAH",
	"OLD NORTH ARABIAN LETTER SAD",
	"OLD NORTH ARABIAN LETTER ES-3",
	"OLD NORTH ARABIAN LETTER FEH",
	"OLD NORTH ARABIAN LETTER ALEF",
	"OLD NORTH ARABIAN LETTER AIN",
	"OLD NORTH ARABIAN LETTER DAD",
	"OLD NORTH ARABIAN LETTER GEEM",
	"OLD NORTH ARABIAN LETTER DAL",
	"OLD NORTH ARABIAN LETTER GHAIN",
	"OLD NORTH ARABIAN LETTER TAH",
	"OLD NORTH ARABIAN LETTER ZAIN",
	"OLD NORTH ARABIAN LETTER THAL",
	"OLD NORTH ARABIAN LETTER YEH",
	"OLD NORTH ARABIAN LETTER THEH",
	"OLD NORTH ARABIAN LETTER ZAH",
	"OLD NORTH ARABIAN NUMBER ONE",
	"OLD NORTH ARABIAN NUMBER TEN",
	"OLD NORTH ARABIAN NUMBER TWENTY",
	"MANICHAEAN LETTER ALEPH",
	"MANICHAEAN LETTER BETH",
	"MANICHAEAN LETTER BHETH",
	"MANICHAEAN LETTER GIMEL",
	"MANICHAEAN LETTER GHIMEL",
	"MANICHAEAN LETTER DALETH",
	"MANICHAEAN LETTER HE",
	"MANICHAEAN LETTER WAW",
	"MANICHAEAN SIGN UD",
	"MANICHAEAN LETTER ZAYIN",
	"MANICHAEAN LETTER ZHAYIN",
	"MANICHAEAN LETTER JAYIN",
	"MANICHAEAN LETTER JHAYIN",
	"MANICHAEAN LETTER HETH",
	"MANICHAEAN LETTER TETH",
	"MANICHAEAN LETTER YODH",
	"MANICHAEAN LETTER KAPH",
	"MANICHAEAN LETTER XAPH",
	"MANICHAEAN LETTER KHAPH",
	"MANICHAEAN LETTER LAMEDH",
	"MANICHAEAN LETTER DHAMEDH",
	"MANICHAEAN LETTER THAMEDH",
	"MANICHAEAN LETTER MEM",
	"MANICHAEAN LETTER NUN",
	"MANICHAEAN LETTER SAMEKH",
	"MANICHAEAN LETTER AYIN",
	"MANICHAEAN LETTER AAYIN",
	"MANICHAEAN LETTER PE",
	"MANICHAEAN LETTER FE",
	"MANICHAEAN LETTER SADHE",
	"MANICHAEAN LETTER QOPH",
	"MANICHAEAN LETTER XOPH",
	"MANICHAEAN LETTER QHOPH",
	"MANICHAEAN LETTER RESH",
	"MANICHAEAN LETTER SHIN",
	"MANICHAEAN LETTER SSHIN",
	"MANICHAEAN LETTER TAW",
	"MANICHAEAN ABBREVIATION MARK ABOVE",
	"MANICHAEAN ABBREVIATION MARK BELOW",
	"MANICHAEAN NUMBER ONE",
	"MANICHAEAN NUMBER FIVE",
	"MANICHAEAN NUMBER TEN",
	"MANICHAEAN NUMBER TWENTY",
	"MANICHAEAN NUMBER ONE HUNDRED",
	"MANICHAEAN PUNCTUATION STAR",
	"MANICHAEAN PUNCTUATION FLEURON",
	"MANICHAEAN PUNCTUATION DOUBLE DOT WITHIN DOT",
	"MANICHAEAN PUNCTUATION DOT WITHIN DOT",
	"MANICHAEAN PUNCTUATION DOT",
	"MANICHAEAN PUNCTUATION TWO DOTS",
	"MANICHAEAN PUNCTUATION LINE FILLER",
	"AVESTAN LETTER A",
	"AVESTAN LETTER AA",
	"AVESTAN LETTER AO",
	"AVESTAN LETTER AAO",
	"AVESTAN LETTER AN",
	"AVESTAN LETTER AAN",
	"AVESTAN LETTER AE",
	"AVESTAN LETTER AEE",
	"AVESTAN LETTER E",
	"AVESTAN LETTER EE",
	"AVESTAN LETTER O",
	"AVESTAN LETTER OO",
	"AVESTAN LETTER I",
	"AVESTAN LETTER II",
	"AVESTAN LETTER U",
	"AVESTAN LETTER UU",
	"AVESTAN LETTER KE",
	"AVESTAN LETTER XE",
	"AVESTAN LETTER XYE",
	"AVESTAN LETTER XVE",
	"AVESTAN LETTER GE",
	"AVESTAN LETTER GGE",
	"AVESTAN LETTER GHE",
	"AVESTAN LETTER CE",
	"AVESTAN LETTER JE",
	"AVESTAN LETTER TE",
	"AVESTAN LETTER THE",
	"AVESTAN LETTER DE",
	"AVESTAN LETTER DHE",
	"AVESTAN LETTER TTE",
	"AVESTAN LETTER PE",
	"AVESTAN LETTER FE",
	"AVESTAN LETTER BE",
	"AVESTAN LETTER BHE",
	"AVESTAN LETTER NGE",
	"AVESTAN LETTER NGYE",
	"AVESTAN LETTER NGVE",
	"AVESTAN LETTER NE",
	"AVESTAN LETTER NYE",
	"AVESTAN LETTER NNE",
	"AVESTAN LETTER ME",
	"AVESTAN LETTER HME",
	"AVESTAN LETTER YYE",
	"AVESTAN LETTER YE",
	"AVESTAN LETTER VE",
	"AVESTAN LETTER RE",
	"AVESTAN LETTER LE",
	"AVESTAN LETTER SE",
	"AVESTAN LETTER ZE",
	"AVESTAN LETTER SHE",
	"AVESTAN LETTER ZHE",
	"AVESTAN LETTER SHYE",
	"AVESTAN LETTER SSHE",
	"AVESTAN LETTER HE",
	"AVESTAN ABBREVIATION MARK",
	"TINY TWO DOTS OVER ONE DOT PUNCTUATION",
	"SMALL TWO DOTS OVER ONE DOT PUNCTUATION",
	"LARGE TWO DOTS OVER ONE DOT PUNCTUATION",
	"LARGE ONE DOT OVER TWO DOTS PUNCTUATION",
	"LARGE TWO RINGS OVER ONE RING PUNCTUATION",
	"LARGE ONE RING OVER TWO RINGS PUNCTUATION",
	"INSCRIPTIONAL PARTHIAN LETTER ALEPH",
	"INSCRIPTIONAL PARTHIAN LETTER BETH",
	"INSCRIPTIONAL PARTHIAN LETTER GIMEL",
	"INSCRIPTIONAL PARTHIAN LETTER DALETH",
	"INSCRIPTIONAL PARTHIAN LETTER HE",
	"INSCRIPTIONAL PARTHIAN LETTER WAW",
	"INSCRIPTIONAL PARTHIAN LETTER ZAYIN",
	"INSCRIPTIONAL PARTHIAN LETTER HETH",
	"INSCRIPTIONAL PARTHIAN LETTER TETH",
	"INSCRIPTIONAL PARTHIAN LETTER YODH",
	"INSCRIPTIONAL PARTHIAN LETTER KAPH",
	"INSCRIPTIONAL PARTHIAN LETTER LAMEDH",
	"INSCRIPTIONAL PARTHIAN LETTER MEM",
	"INSCRIPTIONAL PARTHIAN LETTER NUN",
	"INSCRIPTIONAL PARTHIAN LETTER SAMEKH",
	"INSCRIPTIONAL PARTHIAN LETTER AYIN",
	"INSCRIPTIONAL PARTHIAN LETTER PE",
	"INSCRIPTIONAL PARTHIAN LETTER SADHE",
	"INSCRIPTIONAL PARTHIAN LETTER QOPH",
	"INSCRIPTIONAL PARTHIAN LETTER RESH",
	"INSCRIPTIONAL PARTHIAN LETTER SHIN",
	"INSCRIPTIONAL PARTHIAN LETTER TAW",
	"INSCRIPTIONAL PARTHIAN NUMBER ONE",
	"INSCRIPTIONAL PARTHIAN NUMBER TWO",
	"INSCRIPTIONAL PARTHIAN NUMBER THREE",
	"INSCRIPTIONAL PARTHIAN NUMBER FOUR",
	"INSCRIPTIONAL PARTHIAN NUMBER TEN",
	"INSCRIPTIONAL PARTHIAN NUMBER TWENTY",
	"INSCRIPTIONAL PARTHIAN NUMBER ONE HUNDRED",
	"INSCRIPTIONAL PARTHIAN NUMBER ONE THOUSAND",
	"INSCRIPTIONAL PAHLAVI LETTER ALEPH",
	"INSCRIPTIONAL PAHLAVI LETTER BETH",
	"INSCRIPTIONAL PAHLAVI LETTER GIMEL",
	"INSCRIPTIONAL PAHLAVI LETTER DALETH",
	"INSCRIPTIONAL PAHLAVI LETTER HE",
	"INSCRIPTIONAL PAHLAVI LETTER WAW-AYIN-RESH",
	"INSCRIPTIONAL PAHLAVI LETTER ZAYIN",
	"INSCRIPTIONAL PAHLAVI LETTER HETH",
	"INSCRIPTIONAL PAHLAVI LETTER TETH",
	"INSCRIPTIONAL PAHLAVI LETTER YODH",
	"INSCRIPTIONAL PAHLAVI LETTER KAPH",
	"INSCRIPTIONAL PAHLAVI LETTER LAMEDH",
	"INSCRIPTIONAL PAHLAVI LETTER MEM-QOPH",
	"INSCRIPTIONAL PAHLAVI LETTER NUN",
	"INSCRIPTIONAL PAHLAVI LETTER SAMEKH",
	"INSCRIPTIONAL PAHLAVI LETTER PE",
	"INSCRIPTIONAL PAHLAVI LETTER SADHE",
	"INSCRIPTIONAL PAHLAVI LETTER SHIN",
	"INSCRIPTIONAL PAHLAVI LETTER TAW",
	"INSCRIPTIONAL PAHLAVI NUMBER ONE",
	"INSCRIPTIONAL PAHLAVI NUMBER TWO",
	"INSCRIPTIONAL PAHLAVI NUMBER THREE",
	"INSCRIPTIONAL PAHLAVI NUMBER FOUR",
	"INSCRIPTIONAL PAHLAVI NUMBER TEN",
	"INSCRIPTIONAL PAHLAVI NUMBER TWENTY",
	"INSCRIPTIONAL PAHLAVI NUMBER ONE HUNDRED",
	"INSCRIPTIONAL PAHLAVI NUMBER ONE THOUSAND",
	"PSALTER PAHLAVI LETTER ALEPH",
	"PSALTER PAHLAVI LETTER BETH",
	"PSALTER PAHLAVI LETTER GIMEL",
	"PSALTER PAHLAVI LETTER DALETH",
	"PSALTER PAHLAVI LETTER HE",
	"PSALTER PAHLAVI LETTER WAW-AYIN-RESH",
	"PSALTER PAHLAVI LETTER ZAYIN",
	"PSALTER PAHLAVI LETTER HETH",
	"PSALTER PAHLAVI LETTER YODH",
	"PSALTER PAHLAVI LETTER KAPH",
	"PSALTER PAHLAVI LETTER LAMEDH",
	"PSALTER PAHLAVI LETTER MEM-QOPH",
	"PSALTER PAHLAVI LETTER NUN",
	"PSALTER PAHLAVI LETTER SAMEKH",
	"PSALTER PAHLAVI LETTER PE",
	"PSALTER PAHLAVI LETTER SADHE",
	"PSALTER PAHLAVI LETTER SHIN",
	"PSALTER PAHLAVI LETTER TAW",
	"PSALTER PAHLAVI SECTION MARK",
	"PSALTER PAHLAVI TURNED SECTION MARK",
	"PSALTER PAHLAVI FOUR DOTS WITH CROSS",
	"PSALTER PAHLAVI FOUR DOTS WITH DOT",
	"PSALTER PAHLAVI NUMBER ONE",
	"PSALTER PAHLAVI NUMBER TWO",
	"PSALTER PAHLAVI NUMBER THREE",
	"PSALTER PAHLAVI NUMBER FOUR",
	"PSALTER PAHLAVI NUMBER TEN",
	"PSALTER PAHLAVI NUMBER TWENTY",
	"PSALTER PAHLAVI NUMBER ONE HUNDRED",
	"OLD TURKIC LETTER ORKHON A",
	"OLD TURKIC LETTER YENISEI A",
	"OLD TURKIC LETTER YENISEI AE",
	"OLD TURKIC LETTER ORKHON I",
	"OLD TURKIC LETTER YENISEI I",
	"OLD TURKIC LETTER YENISEI E",
	"OLD TURKIC LETTER ORKHON O",
	"OLD TURKIC LETTER ORKHON OE",
	"OLD TURKIC LETTER YENISEI OE",
	"OLD TURKIC LETTER ORKHON AB",
	"OLD TURKIC LETTER YENISEI AB",
	"OLD TURKIC LETTER ORKHON AEB",
	"OLD TURKIC LETTER YENISEI AEB",
	"OLD TURKIC LETTER ORKHON AG",
	"OLD TURKIC LETTER YENISEI AG",
	"OLD TURKIC LETTER ORKHON AEG",
	"OLD TURKIC LETTER YENISEI AEG",
	"OLD TURKIC LETTER ORKHON AD",
	"OLD TURKIC LETTER YENISEI AD",
	"OLD TURKIC LETTER ORKHON AED",
	"OLD TURKIC LETTER ORKHON EZ",
	"OLD TURKIC LETTER YENISEI EZ",
	"OLD TURKIC LETTER ORKHON AY",
	"OLD TURKIC LETTER YENISEI AY",
	"OLD TURKIC LETTER ORKHON AEY",
	"OLD TURKIC LETTER YENISEI AEY",
	"OLD TURKIC LETTER ORKHON AEK",
	"OLD TURKIC LETTER YENISEI AEK",
	"OLD TURKIC LETTER ORKHON OEK",
	"OLD TURKIC LETTER YENISEI OEK",
	"OLD TURKIC LETTER ORKHON AL",
	"OLD TURKIC LETTER YENISEI AL",
	"OLD TURKIC LETTER ORKHON AEL",
	"OLD TURKIC LETTER ORKHON ELT",
	"OLD TURKIC LETTER ORKHON EM",
	"OLD TURKIC LETTER ORKHON AN",
	"OLD TURKIC LETTER ORKHON AEN",
	"OLD TURKIC LETTER YENISEI AEN",
	"OLD TURKIC LETTER ORKHON ENT",
	"OLD TURKIC LETTER YENISEI ENT",
	"OLD TURKIC LETTER ORKHON ENC",
	"OLD TURKIC LETTER YENISEI ENC",
	"OLD TURKIC LETTER ORKHON ENY",
	"OLD TURKIC LETTER YENISEI ENY",
	"OLD TURKIC LETTER YENISEI ANG",
	"OLD TURKIC LETTER ORKHON ENG",
	"OLD TURKIC LETTER YENISEI AENG",
	"OLD TURKIC LETTER ORKHON EP",
	"OLD TURKIC LETTER ORKHON OP",
	"OLD TURKIC LETTER ORKHON IC",
	"OLD TURKIC LETTER ORKHON EC",
	"OLD TURKIC LETTER YENISEI EC",
	"OLD TURKIC LETTER ORKHON AQ",
	"OLD TURKIC LETTER YENISEI AQ",
	"OLD TURKIC LETTER ORKHON IQ",
	"OLD TURKIC LETTER YENISEI IQ",
	"OLD TURKIC LETTER ORKHON OQ",
	"OLD TURKIC LETTER YENISEI OQ",
	"OLD TURKIC LETTER ORKHON AR",
	"OLD TURKIC LETTER YENISEI AR",
	"OLD TURKIC LETTER ORKHON AER",
	"OLD TURKIC LETTER ORKHON AS",
	"OLD TURKIC LETTER ORKHON AES",
	"OLD TURKIC LETTER ORKHON ASH",
	"OLD TURKIC LETTER YENISEI ASH",
	"OLD TURKIC LETTER ORKHON ESH",
	"OLD TURKIC LETTER YENISEI ESH",
	"OLD TURKIC LETTER ORKHON AT",
	"OLD TURKIC LETTER YENISEI AT",
	"OLD TURKIC LETTER ORKHON AET",
	"OLD TURKIC LETTER YENISEI AET",
	"OLD TURKIC LETTER ORKHON OT",
	"OLD TURKIC LETTER ORKHON BASH",
	"OLD HUNGARIAN CAPITAL LETTER A",
	"OLD HUNGARIAN CAPITAL LETTER AA",
	"OLD HUNGARIAN CAPITAL LETTER EB",
	"OLD HUNGARIAN CAPITAL LETTER AMB",
	"OLD HUNGARIAN CAPITAL LETTER EC",
	"OLD HUNGARIAN CAPITAL LETTER ENC",
	"OLD HUNGARIAN CAPITAL LETTER ECS",
	"OLD HUNGARIAN CAPITAL LETTER ED",
	"OLD HUNGARIAN CAPITAL LETTER AND",
	"OLD HUNGARIAN CAPITAL LETTER E",
	"OLD HUNGARIAN CAPITAL LETTER CLOSE E",
	"OLD HUNGARIAN CAPITAL LETTER EE",
	"OLD HUNGARIAN CAPITAL LETTER EF",
	"OLD HUNGARIAN CAPITAL LETTER EG",
	"OLD HUNGARIAN CAPITAL LETTER EGY",
	"OLD HUNGARIAN CAPITAL LETTER EH",
	"OLD HUNGARIAN CAPITAL LETTER I",
	"OLD HUNGARIAN CAPITAL LETTER II",
	"OLD HUNGARIAN CAPITAL LETTER EJ",
	"OLD HUNGARIAN CAPITAL LETTER EK",
	"OLD HUNGARIAN CAPITAL LETTER AK",
	"OLD HUNGARIAN CAPITAL LETTER UNK",
	"OLD HUNGARIAN CAPITAL LETTER EL",
	"OLD HUNGARIAN CAPITAL LETTER ELY",
	"OLD HUNGARIAN CAPITAL LETTER EM",
	"OLD HUNGARIAN CAPITAL LETTER EN",
	"OLD HUNGARIAN CAPITAL LETTER ENY",
	"OLD HUNGARIAN CAPITAL LETTER O",
	"OLD HUNGARIAN CAPITAL LETTER OO",
	"OLD HUNGARIAN CAPITAL LETTER NIKOLSBURG OE",
	"OLD HUNGARIAN CAPITAL LETTER RUDIMENTA OE",
	"OLD HUNGARIAN CAPITAL LETTER OEE",
	"OLD HUNGARIAN CAPITAL LETTER EP",
	"OLD HUNGARIAN CAPITAL LETTER EMP",
	"OLD HUNGARIAN CAPITAL LETTER ER",
	"OLD HUNGARIAN CAPITAL LETTER SHORT ER",
	"OLD HUNGARIAN CAPITAL LETTER ES",
	"OLD HUNGARIAN CAPITAL LETTER ESZ",
	"OLD HUNGARIAN CAPITAL LETTER ET",
	"OLD HUNGARIAN CAPITAL LETTER ENT",
	"OLD HUNGARIAN CAPITAL LETTER ETY",
	"OLD HUNGARIAN CAPITAL LETTER ECH",
	"OLD HUNGARIAN CAPITAL LETTER U",
	"OLD HUNGARIAN CAPITAL LETTER UU",
	"OLD HUNGARIAN CAPITAL LETTER NIKOLSBURG UE",
	"OLD HUNGARIAN CAPITAL LETTER RUDIMENTA UE",
	"OLD HUNGARIAN CAPITAL LETTER EV",
	"OLD HUNGARIAN CAPITAL LETTER EZ",
	"OLD HUNGARIAN CAPITAL LETTER EZS",
	"OLD HUNGARIAN CAPITAL LETTER ENT-SHAPED SIGN",
	"OLD HUNGARIAN CAPITAL LETTER US",
	"OLD HUNGARIAN SMALL LETTER A",
	"OLD HUNGARIAN SMALL LETTER AA",
	"OLD HUNGARIAN SMALL LETTER EB",
	"OLD HUNGARIAN SMALL LETTER AMB",
	"OLD HUNGARIAN SMALL LETTER EC",
	"OLD HUNGARIAN SMALL LETTER ENC",
	"OLD HUNGARIAN SMALL LETTER ECS",
	"OLD HUNGARIAN SMALL LETTER ED",
	"OLD HUNGARIAN SMALL LETTER AND",
	"OLD HUNGARIAN SMALL LETTER E",
	"OLD HUNGARIAN SMALL LETTER CLOSE E",
	"OLD HUNGARIAN SMALL LETTER EE",
	"OLD HUNGARIAN SMALL LETTER EF",
	"OLD HUNGARIAN SMALL LETTER EG",
	"OLD HUNGARIAN SMALL LETTER EGY",
	"OLD HUNGARIAN SMALL LETTER EH",
	"OLD HUNGARIAN SMALL LETTER I",
	"OLD HUNGARIAN SMALL LETTER II",
	"OLD HUNGARIAN SMALL LETTER EJ",
	"OLD HUNGARIAN SMALL LETTER EK",
	"OLD HUNGARIAN SMALL LETTER AK",
	"OLD HUNGARIAN SMALL LETTER UNK",
	"OLD HUNGARIAN SMALL LETTER EL",
	"OLD HUNGARIAN SMALL LETTER ELY",
	"OLD HUNGARIAN SMALL LETTER EM",
	"OLD HUNGARIAN SMALL LETTER EN",
	"OLD HUNGARIAN SMALL LETTER ENY",
	"OLD HUNGARIAN SMALL LETTER O",
	"OLD HUNGARIAN SMALL LETTER OO",
	"OLD HUNGARIAN SMALL LETTER NIKOLSBURG OE",
	"OLD HUNGARIAN SMALL LETTER RUDIMENTA OE",
	"OLD HUNGARIAN SMALL LETTER OEE",
	"OLD HUNGARIAN SMALL LETTER EP",
	"OLD HUNGARIAN SMALL LETTER EMP",
	"OLD HUNGARIAN SMALL LETTER ER",
	"OLD HUNGARIAN SMALL LETTER SHORT ER",
	"OLD HUNGARIAN SMALL LETTER ES",
	"OLD HUNGARIAN SMALL LETTER ESZ",
	"OLD HUNGARIAN SMALL LETTER ET",
	"OLD HUNGARIAN SMALL LETTER ENT",
	"OLD HUNGARIAN SMALL LETTER ETY",
	"OLD HUNGARIAN SMALL LETTER ECH",
	"OLD HUNGARIAN SMALL LETTER U",
	"OLD HUNGARIAN SMALL LETTER UU",
	"OLD HUNGARIAN SMALL LETTER NIKOLSBURG UE",
	"OLD HUNGARIAN SMALL LETTER RUDIMENTA UE",
	"OLD HUNGARIAN SMALL LETTER EV",
	"OLD HUNGARIAN SMALL LETTER EZ",
	"OLD HUNGARIAN SMALL LETTER EZS",
	"OLD HUNGARIAN SMALL LETTER ENT-SHAPED SIGN",
	"OLD HUNGARIAN SMALL LETTER US",
	"OLD HUNGARIAN NUMBER ONE",
	"OLD HUNGARIAN NUMBER FIVE",
	"OLD HUNGARIAN NUMBER TEN",
	"OLD HUNGARIAN NUMBER FIFTY",
	"OLD HUNGARIAN NUMBER ONE HUNDRED",
	"OLD HUNGARIAN NUMBER ONE THOUSAND",
	"HANIFI ROHINGYA LETTER A",
	"HANIFI ROHINGYA LETTER BA",
	"HANIFI ROHINGYA LETTER PA",
	"HANIFI ROHINGYA LETTER TA",
	"HANIFI ROHINGYA LETTER TTA",
	"HANIFI ROHINGYA LETTER JA",
	"HANIFI ROHINGYA LETTER CA",
	"HANIFI ROHINGYA LETTER HA",
	"HANIFI ROHINGYA LETTER KHA",
	"HANIFI ROHINGYA LETTER FA",
	"HANIFI ROHINGYA LETTER DA",
	"HANIFI ROHINGYA LETTER DDA",
	"HANIFI ROHINGYA LETTER RA",
	"HANIFI ROHINGYA LETTER RRA",
	"HANIFI ROHINGYA LETTER ZA",
	"HANIFI ROHINGYA LETTER SA",
	"HANIFI ROHINGYA LETTER SHA",
	"HANIFI ROHINGYA LETTER KA",
	"HANIFI ROHINGYA LETTER GA",
	"HANIFI ROHINGYA LETTER LA",
	"HANIFI ROHINGYA LETTER MA",
	"HANIFI ROHINGYA LETTER NA",
	"HANIFI ROHINGYA LETTER WA",
	"HANIFI ROHINGYA LETTER KINNA WA",
	"HANIFI ROHINGYA LETTER YA",
	"HANIFI ROHINGYA LETTER KINNA YA",
	"HANIFI ROHINGYA LETTER NGA",
	"HANIFI ROHINGYA LETTER NYA",
	"HANIFI ROHINGYA LETTER VA",
	"HANIFI ROHINGYA VOWEL A",
	"HANIFI ROHINGYA VOWEL I",
	"HANIFI ROHINGYA VOWEL U",
	"HANIFI ROHINGYA VOWEL E",
	"HANIFI ROHINGYA VOWEL O",
	"HANIFI ROHINGYA MARK SAKIN",
	"HANIFI ROHINGYA MARK NA KHONNA",
	"HANIFI ROHINGYA SIGN HARBAHAY",
	"HANIFI ROHINGYA SIGN TAHALA",
	"HANIFI ROHINGYA SIGN TANA",
	"HANIFI ROHINGYA SIGN TASSI",
	"HANIFI ROHINGYA DIGIT ZERO",
	"HANIFI ROHINGYA DIGIT ONE",
	"HANIFI ROHINGYA DIGIT TWO",
	"HANIFI ROHINGYA DIGIT THREE",
	"HANIFI ROHINGYA DIGIT FOUR",
	"HANIFI ROHINGYA DIGIT FIVE",
	"HANIFI ROHINGYA DIGIT SIX",
	"HANIFI ROHINGYA DIGIT SEVEN",
	"HANIFI ROHINGYA DIGIT EIGHT",
	"HANIFI ROHINGYA DIGIT NINE",
	"RUMI DIGIT ONE",
	"RUMI DIGIT TWO",
	"RUMI DIGIT THREE",
	"RUMI DIGIT FOUR",
	"RUMI DIGIT FIVE",
	"RUMI DIGIT SIX",
	"RUMI DIGIT SEVEN",
	"RUMI DIGIT EIGHT",
	"RUMI DIGIT NINE",
	"RUMI NUMBER TEN",
	"RUMI NUMBER TWENTY",
	"RUMI NUMBER THIRTY",
	"RUMI NUMBER FORTY",
	"RUMI NUMBER FIFTY",
	"RUMI NUMBER SIXTY",
	"RUMI NUMBER SEVENTY",
	"RUMI NUMBER EIGHTY",
	"RUMI NUMBER NINETY",
	"RUMI NUMBER ONE HUNDRED",
	"RUMI NUMBER TWO HUNDRED",
	"RUMI NUMBER THREE HUNDRED",
	"RUMI NUMBER FOUR HUNDRED",
	"RUMI NUMBER FIVE HUNDRED",
	"RUMI NUMBER SIX HUNDRED",
	"RUMI NUMBER SEVEN HUNDRED",
	"RUMI NUMBER EIGHT HUNDRED",
	"RUMI NUMBER NINE HUNDRED",
	"RUMI FRACTION ONE HALF",
	"RUMI FRACTION ONE QUARTER",
	"RUMI FRACTION ONE THIRD",
	"RUMI FRACTION TWO THIRDS",
	"YEZIDI LETTER ELIF",
	"YEZIDI LETTER BE",
	"YEZIDI LETTER PE",
	"YEZIDI LETTER PHE",
	"YEZIDI LETTER THE",
	"YEZIDI LETTER SE",
	"YEZIDI LETTER CIM",
	"YEZIDI LETTER CHIM",
	"YEZIDI LETTER CHHIM",
	"YEZIDI LETTER HHA",
	"YEZIDI LETTER XA",
	"YEZIDI LETTER DAL",
	"YEZIDI LETTER ZAL",
	"YEZIDI LETTER RA",
	"YEZIDI LETTER RHA",
	"YEZIDI LETTER ZA",
	"YEZIDI LETTER JA",
	"YEZIDI LETTER SIN",
	"YEZIDI LETTER SHIN",
	"YEZIDI LETTER SAD",
	"YEZIDI LETTER DAD",
	"YEZIDI LETTER TA",
	"YEZIDI LETTER ZE",
	"YEZIDI LETTER EYN",
	"YEZIDI LETTER XHEYN",
	"YEZIDI LETTER FA",
	"YEZIDI LETTER VA",
	"YEZIDI LETTER VA ALTERNATE FORM",
	"YEZIDI LETTER QAF",
	"YEZIDI LETTER KAF",
	"YEZIDI LETTER KHAF",
	"YEZIDI LETTER GAF",
	"YEZIDI LETTER LAM",
	"YEZIDI LETTER MIM",
	"YEZIDI LETTER NUN",
	"YEZIDI LETTER UM",
	"YEZIDI LETTER WAW",
	"YEZIDI LETTER OW",
	"YEZIDI LETTER EW",
	"YEZIDI LETTER HAY",
	"YEZIDI LETTER YOT",
	"YEZIDI LETTER ET",
	"YEZIDI COMBINING HAMZA MARK",
	"YEZIDI COMBINING MADDA MARK",
	"YEZIDI HYPHENATION MARK",
	"YEZIDI LETTER LAM WITH DOT ABOVE",
	"YEZIDI LETTER YOT WITH CIRCUMFLEX ABOVE",
	"ARABIC SMALL LOW WORD SAKTA",
	"ARABIC SMALL LOW WORD QASR",
	"ARABIC SMALL LOW WORD MADDA",
	"OLD SOGDIAN LETTER ALEPH",
	"OLD SOGDIAN LETTER FINAL ALEPH",
	"OLD SOGDIAN LETTER BETH",
	"OLD SOGDIAN LETTER FINAL BETH",
	"OLD SOGDIAN LETTER GIMEL",
	"OLD SOGDIAN LETTER HE",
	"OLD SOGDIAN LETTER FINAL HE",
	"OLD SOGDIAN LETTER WAW",
	"OLD SOGDIAN LETTER ZAYIN",
	"OLD SOGDIAN LETTER HETH",
	"OLD SOGDIAN LETTER YODH",
	"OLD SOGDIAN LETTER KAPH",
	"OLD SOGDIAN LETTER LAMEDH",
	"OLD SOGDIAN LETTER MEM",
	"OLD SOGDIAN LETTER NUN",
	"OLD SOGDIAN LETTER FINAL NUN",
	"OLD SOGDIAN LETTER FINAL NUN WITH VERTICAL TAIL",
	"OLD SOGDIAN LETTER SAMEKH",
	"OLD SOGDIAN LETTER AYIN",
	"OLD SOGDIAN LETTER ALTERNATE AYIN",
	"OLD SOGDIAN LETTER PE",
	"OLD SOGDIAN LETTER SADHE",
	"OLD SOGDIAN LETTER FINAL SADHE",
	"OLD SOGDIAN LETTER FINAL SADHE WITH VERTICAL TAIL",
	"OLD SOGDIAN LETTER RESH-AYIN-DALETH",
	"OLD SOGDIAN LETTER SHIN",
	"OLD SOGDIAN LETTER TAW",
	"OLD SOGDIAN LETTER FINAL TAW",
	"OLD SOGDIAN LETTER FINAL TAW WITH VERTICAL TAIL",
	"OLD SOGDIAN NUMBER ONE",
	"OLD SOGDIAN NUMBER TWO",
	"OLD SOGDIAN NUMBER THREE",
	"OLD SOGDIAN NUMBER FOUR",
	"OLD SOGDIAN NUMBER FIVE",
	"OLD SOGDIAN NUMBER TEN",
	"OLD SOGDIAN NUMBER TWENTY",
	"OLD SOGDIAN NUMBER THIRTY",
	"OLD SOGDIAN NUMBER ONE HUNDRED",
	"OLD SOGDIAN FRACTION ONE HALF",
	"OLD SOGDIAN LIGATURE AYIN-DALETH",
	"SOGDIAN LETTER ALEPH",
	"SOGDIAN LETTER BETH",
	"SOGDIAN LETTER GIMEL",
	"SOGDIAN LETTER HE",
	"SOGDIAN LETTER WAW",
	"SOGDIAN LETTER ZAYIN",
	"SOGDIAN LETTER HETH",
	"SOGDIAN LETTER YODH",
	"SOGDIAN LETTER KAPH",
	"SOGDIAN LETTER LAMEDH",
	"SOGDIAN LETTER MEM",
	"SOGDIAN LETTER NUN",
	"SOGDIAN LETTER SAMEKH",
	"SOGDIAN LETTER AYIN",
	"SOGDIAN LETTER PE",
	"SOGDIAN LETTER SADHE",
	"SOGDIAN LETTER RESH-AYIN",
	"SOGDIAN LETTER SHIN",
	"SOGDIAN LETTER TAW",
	"SOGDIAN LETTER FETH",
	"SOGDIAN LETTER LESH",
	"SOGDIAN INDEPENDENT SHIN",
	"SOGDIAN COMBINING DOT BELOW",
	"SOGDIAN COMBINING TWO DOTS BELOW",
	"SOGDIAN COMBINING DOT ABOVE",
	"SOGDIAN COMBINING TWO DOTS ABOVE",
	"SOGDIAN COMBINING CURVE ABOVE",
	"SOGDIAN COMBINING CURVE BELOW",
	"SOGDIAN COMBINING HOOK ABOVE",
	"SOGDIAN COMBINING HOOK BELOW",
	"SOGDIAN COMBINING LONG HOOK BELOW",
	"SOGDIAN COMBINING RESH BELOW",
	"SOGDIAN COMBINING STROKE BELOW",
	"SOGDIAN NUMBER ONE",
	"SOGDIAN NUMBER TEN",
	"SOGDIAN NUMBER TWENTY",
	"SOGDIAN NUMBER ONE HUNDRED",
	"SOGDIAN PUNCTUATION TWO VERTICAL BARS",
	"SOGDIAN PUNCTUATION TWO VERTICAL BARS WITH DOTS",
	"SOGDIAN PUNCTUATION CIRCLE WITH DOT",
	"SOGDIAN PUNCTUATION TWO CIRCLES WITH DOTS",
	"SOGDIAN PUNCTUATION HALF CIRCLE WITH DOT",
	"OLD UYGHUR LETTER ALEPH",
	"OLD UYGHUR LETTER BETH",
	"OLD UYGHUR LETTER GIMEL-HETH",
	"OLD UYGHUR LETTER WAW",
	"OLD UYGHUR LETTER ZAYIN",
	"OLD UYGHUR LETTER FINAL HETH",
	"OLD UYGHUR LETTER YODH",
	"OLD UYGHUR LETTER KAPH",
	"OLD UYGHUR LETTER LAMEDH",
	"OLD UYGHUR LETTER MEM",
	"OLD UYGHUR LETTER NUN",
	"OLD UYGHUR LETTER SAMEKH",
	"OLD UYGHUR LETTER PE",
	"OLD UYGHUR LETTER SADHE",
	"OLD UYGHUR LETTER RESH",
	"OLD UYGHUR LETTER SHIN",
	"OLD UYGHUR LETTER TAW",
	"OLD UYGHUR LETTER LESH",
	"OLD UYGHUR COMBINING DOT ABOVE",
	"OLD UYGHUR COMBINING DOT BELOW",
	"OLD UYGHUR COMBINING TWO DOTS ABOVE",
	"OLD UYGHUR COMBINING TWO DOTS BELOW",
	"OLD UYGHUR PUNCTUATION BAR",
	"OLD UYGHUR PUNCTUATION TWO BARS",
	"OLD UYGHUR PUNCTUATION TWO DOTS",
	"OLD UYGHUR PUNCTUATION FOUR DOTS",
	"CHORASMIAN LETTER ALEPH",
	"CHORASMIAN LETTER SMALL ALEPH",
	"CHORASMIAN LETTER BETH",
	"CHORASMIAN LETTER GIMEL",
	"CHORASMIAN LETTER DALETH",
	"CHORASMIAN LETTER HE",
	"CHORASMIAN LETTER WAW",
	"CHORASMIAN LETTER CURLED WAW",
	"CHORASMIAN LETTER ZAYIN",
	"CHORASMIAN LETTER HETH",
	"CHORASMIAN LETTER YODH",
	"CHORASMIAN LETTER KAPH",
	"CHORASMIAN LETTER LAMEDH",
	"CHORASMIAN LETTER MEM",
	"CHORASMIAN LETTER NUN",
	"CHORASMIAN LETTER SAMEKH",
	"CHORASMIAN LETTER AYIN",
	"CHORASMIAN LETTER PE",
	"CHORASMIAN LETTER RESH",
	"CHORASMIAN LETTER SHIN",
	"CHORASMIAN LETTER TAW",
	"CHORASMIAN NUMBER ONE",
	"CHORASMIAN NUMBER TWO",
	"CHORASMIAN NUMBER THREE",
	"CHORASMIAN NUMBER FOUR",
	"CHORASMIAN NUMBER TEN",
	"CHORASMIAN NUMBER TWENTY",
	"CHORASMIAN NUMBER ONE HUNDRED",
	"ELYMAIC LETTER ALEPH",
	"ELYMAIC LETTER BETH",
	"ELYMAIC LETTER GIMEL",
	"ELYMAIC LETTER DALETH",
	"ELYMAIC LETTER HE",
	"ELYMAIC LETTER WAW",
	"ELYMAIC LETTER ZAYIN",
	"ELYMAIC LETTER HETH",
	"ELYMAIC LETTER TETH",
	"ELYMAIC LETTER YODH",
	"ELYMAIC LETTER KAPH",
	"ELYMAIC LETTER LAMEDH",
	"ELYMAIC LETTER MEM",
	"ELYMAIC LETTER NUN",
	"ELYMAIC LETTER SAMEKH",
	"ELYMAIC LETTER AYIN",
	"ELYMAIC LETTER PE",
	"ELYMAIC LETTER SADHE",
	"ELYMAIC LETTER QOPH",
	"ELYMAIC LETTER RESH",
	"ELYMAIC LETTER SHIN",
	"ELYMAIC LETTER TAW",
	"ELYMAIC LIGATURE ZAYIN-YODH",
	"BRAHMI SIGN CANDRABINDU",
	"BRAHMI SIGN ANUSVARA",
	"BRAHMI SIGN VISARGA",
	"BRAHMI SIGN JIHVAMULIYA",
	"BRAHMI SIGN UPADHMANIYA",
	"BRAHMI LETTER A",
	"BRAHMI LETTER AA",
	"BRAHMI LETTER I",
	"BRAHMI LETTER II",
	"BRAHMI LETTER U",
	"BRAHMI LETTER UU",
	"BRAHMI LETTER VOCALIC R",
	"BRAHMI LETTER VOCALIC RR",
	"BRAHMI LETTER VOCALIC L",
	"BRAHMI LETTER VOCALIC LL",
	"BRAHMI LETTER E",
	"BRAHMI LETTER AI",
	"BRAHMI LETTER O",
	"BRAHMI LETTER AU",
	"BRAHMI LETTER KA",
	"BRAHMI LETTER KHA",
	"BRAHMI LETTER GA",
	"BRAHMI LETTER GHA",
	"BRAHMI LETTER NGA",
	"BRAHMI LETTER CA",
	"BRAHMI LETTER CHA",
	"BRAHMI LETTER JA",
	"BRAHMI LETTER JHA",
	"BRAHMI LETTER NYA",
	"BRAHMI LETTER TTA",
	"BRAHMI LETTER TTHA",
	"BRAHMI LETTER DDA",
	"BRAHMI LETTER DDHA",
	"BRAHMI LETTER NNA",
	"BRAHMI LETTER TA",
	"BRAHMI LETTER THA",
	"BRAHMI LETTER DA",
	"BRAHMI LETTER DHA",
	"BRAHMI LETTER NA",
	"BRAHMI LETTER PA",
	"BRAHMI LETTER PHA",
	"BRAHMI LETTER BA",
	"BRAHMI LETTER BHA",
	"BRAHMI LETTER MA",
	"BRAHMI LETTER YA",
	"BRAHMI LETTER RA",
	"BRAHMI LETTER LA",
	"BRAHMI LETTER VA",
	"BRAHMI LETTER SHA",
	"BRAHMI LETTER SSA",
	"BRAHMI LETTER SA",
	"BRAHMI LETTER HA",
	"BRAHMI LETTER LLA",
	"BRAHMI LETTER OLD TAMIL LLLA",
	"BRAHMI LETTER OLD TAMIL RRA",
	"BRAHMI LETTER OLD TAMIL NNNA",
	"BRAHMI VOWEL SIGN AA",
	"BRAHMI VOWEL SIGN BHATTIPROLU AA",
	"BRAHMI VOWEL SIGN I",
	"BRAHMI VOWEL SIGN II",
	"BRAHMI VOWEL SIGN U",
	"BRAHMI VOWEL SIGN UU",
	"BRAHMI VOWEL SIGN VOCALIC R",
	"BRAHMI VOWEL SIGN VOCALIC RR",
	"BRAHMI VOWEL SIGN VOCALIC L",
	"BRAHMI VOWEL SIGN VOCALIC LL",
	"BRAHMI VOWEL SIGN E",
	"BRAHMI VOWEL SIGN AI",
	"BRAHMI VOWEL SIGN O",
	"BRAHMI VOWEL SIGN AU",
	"BRAHMI VIRAMA",
	"BRAHMI DANDA",
	"BRAHMI DOUBLE DANDA",
	"BRAHMI PUNCTUATION DOT",
	"BRAHMI PUNCTUATION DOUBLE DOT",
	"BRAHMI PUNCTUATION LINE",
	"BRAHMI PUNCTUATION CRESCENT BAR",
	"BRAHMI PUNCTUATION LOTUS",
	"BRAHMI NUMBER ONE",
	"BRAHMI NUMBER TWO",
	"BRAHMI NUMBER THREE",
	"BRAHMI NUMBER FOUR",
	"BRAHMI NUMBER FIVE",
	"BRAHMI NUMBER SIX",
	"BRAHMI NUMBER SEVEN",
	"BRAHMI NUMBER EIGHT",
	"BRAHMI NUMBER NINE",
	"BRAHMI NUMBER TEN",
	"BRAHMI NUMBER TWENTY",
	"BRAHMI NUMBER THIRTY",
	"BRAHMI NUMBER FORTY",
	"BRAHMI NUMBER FIFTY",
	"BRAHMI NUMBER SIXTY",
	"BRAHMI NUMBER SEVENTY",
	"BRAHMI NUMBER EIGHTY",
	"BRAHMI NUMBER NINETY",
	"BRAHMI NUMBER ONE HUNDRED",
	"BRAHMI NUMBER ONE THOUSAND",
	"BRAHMI DIGIT ZERO",
	"BRAHMI DIGIT ONE",
	"BRAHMI DIGIT TWO",
	"BRAHMI DIGIT THREE",
	"BRAHMI DIGIT FOUR",
	"BRAHMI DIGIT FIVE",
	"BRAHMI DIGIT SIX",
	"BRAHMI DIGIT SEVEN",
	"BRAHMI DIGIT EIGHT",
	"BRAHMI DIGIT NINE",
	"BRAHMI SIGN OLD TAMIL VIRAMA",
	"BRAHMI LETTER OLD TAMIL SHORT E",
	"BRAHMI LETTER OLD TAMIL SHORT O",
	"BRAHMI VOWEL SIGN OLD TAMIL SHORT E",
	"BRAHMI VOWEL SIGN OLD TAMIL SHORT O",
	"BRAHMI LETTER OLD TAMIL LLA",
	"BRAHMI NUMBER JOINER",
	"KAITHI SIGN CANDRABINDU",
	"KAITHI SIGN ANUSVARA",
	"KAITHI SIGN VISARGA",
	"KAITHI LETTER A",
	"KAITHI LETTER AA",
	"KAITHI LETTER I",
	"KAITHI LETTER II",
	"KAITHI LETTER U",
	"KAITHI LETTER UU",
	"KAITHI LETTER E",
	"KAITHI LETTER AI",
	"KAITHI LETTER O",
	"KAITHI LETTER AU",
	"KAITHI LETTER KA",
	"KAITHI LETTER KHA",
	"KAITHI LETTER GA",
	"KAITHI LETTER GHA",
	"KAITHI LETTER NGA",
	"KAITHI LETTER CA",
	"KAITHI LETTER CHA",
	"KAITHI LETTER JA",
	"KAITHI LETTER JHA",
	"KAITHI LETTER NYA",
	"KAITHI LETTER TTA",
	"KAITHI LETTER TTHA",
	"KAITHI LETTER DDA",
	"KAITHI LETTER DDDHA",
	"KAITHI LETTER DDHA",
	"KAITHI LETTER RHA",
	"KAITHI LETTER NNA",
	"KAITHI LETTER TA",
	"KAITHI LETTER THA",
	"KAITHI LETTER DA",
	"KAITHI LETTER DHA",
	"KAITHI LETTER NA",
	"KAITHI LETTER PA",
	"KAITHI LETTER PHA",
	"KAITHI LETTER BA",
	"KAITHI LETTER BHA",
	"KAITHI LETTER MA",
	"KAITHI LETTER YA",
	"KAITHI LETTER RA",
	"KAITHI LETTER LA",
	"KAITHI LETTER VA",
	"KAITHI LETTER SHA",
	"KAITHI LETTER SSA",
	"KAITHI LETTER SA",
	"KAITHI LETTER HA",
	"KAITHI VOWEL SIGN AA",
	"KAITHI VOWEL SIGN I",
	"KAITHI VOWEL SIGN II",
	"KAITHI VOWEL SIGN U",
	"KAITHI VOWEL SIGN UU",
	"KAITHI VOWEL SIGN E",
	"KAITHI VOWEL SIGN AI",
	"KAITHI VOWEL SIGN O",
	"KAITHI VOWEL SIGN AU",
	"KAITHI SIGN VIRAMA",
	"KAITHI SIGN NUKTA",
	"KAITHI ABBREVIATION SIGN",
	"KAITHI ENUMERATION SIGN",
	"KAITHI NUMBER SIGN",
	"KAITHI SECTION MARK",
	"KAITHI DOUBLE SECTION MARK",
	"KAITHI DANDA",
	"KAITHI DOUBLE DANDA",
	"KAITHI VOWEL SIGN VOCALIC R",
	"KAITHI NUMBER SIGN ABOVE",
	"SORA SOMPENG LETTER SAH",
	"SORA SOMPENG LETTER TAH",
	"SORA SOMPENG LETTER BAH",
	"SORA SOMPENG LETTER CAH",
	"SORA SOMPENG LETTER DAH",
	"SORA SOMPENG LETTER GAH",
	"SORA SOMPENG LETTER MAH",
	"SORA SOMPENG LETTER NGAH",
	"SORA SOMPENG LETTER LAH",
	"SORA SOMPENG LETTER NAH",
	"SORA SOMPENG LETTER VAH",
	"SORA SOMPENG LETTER PAH",
	"SORA SOMPENG LETTER YAH",
	"SORA SOMPENG LETTER RAH",
	"SORA SOMPENG LETTER HAH",
	"SORA SOMPENG LETTER KAH",
	"SORA SOMPENG LETTER JAH",
	"SORA SOMPENG LETTER NYAH",
	"SORA SOMPENG LETTER AH",
	"SORA SOMPENG LETTER EEH",
	"SORA SOMPENG LETTER IH",
	"SORA SOMPENG LETTER UH",
	"SORA SOMPENG LETTER OH",
	"SORA SOMPENG LETTER EH",
	"SORA SOMPENG LETTER MAE",
	"SORA SOMPENG DIGIT ZERO",
	"SORA SOMPENG DIGIT ONE",
	"SORA SOMPENG DIGIT TWO",
	"SORA SOMPENG DIGIT THREE",
	"SORA SOMPENG DIGIT FOUR",
	"SORA SOMPENG DIGIT FIVE",
	"SORA SOMPENG DIGIT SIX",
	"SORA SOMPENG DIGIT SEVEN",
	"SORA SOMPENG DIGIT EIGHT",
	"SORA SOMPENG DIGIT NINE",
	"CHAKMA SIGN CANDRABINDU",
	"CHAKMA SIGN ANUSVARA",
	"CHAKMA SIGN VISARGA",
	"CHAKMA LETTER AA",
	"CHAKMA LETTER I",
	"CHAKMA LETTER U",
	"CHAKMA LETTER E",
	"CHAKMA LETTER KAA",
	"CHAKMA LETTER KHAA",
	"CHAKMA LETTER GAA",
	"CHAKMA LETTER GHAA",
	"CHAKMA LETTER NGAA",
	"CHAKMA LETTER CAA",
	"CHAKMA LETTER CHAA",
	"CHAKMA LETTER JAA",
	"CHAKMA LETTER JHAA",
	"CHAKMA LETTER NYAA",
	"CHAKMA LETTER TTAA",
	"CHAKMA LETTER TTHAA",
	"CHAKMA LETTER DDAA",
	"CHAKMA LETTER DDHAA",
	"CHAKMA LETTER NNAA",
	"CHAKMA LETTER TAA",
	"CHAKMA LETTER THAA",
	"CHAKMA LETTER DAA",
	"CHAKMA LETTER DHAA",
	"CHAKMA LETTER NAA",
	"CHAKMA LETTER PAA",
	"CHAKMA LETTER PHAA",
	"CHAKMA LETTER BAA",
	"CHAKMA LETTER BHAA",
	"CHAKMA LETTER MAA",
	"CHAKMA LETTER YYAA",
	"CHAKMA LETTER YAA",
	"CHAKMA LETTER RAA",
	"CHAKMA LETTER LAA",
	"CHAKMA LETTER WAA",
	"CHAKMA LETTER SAA",
	"CHAKMA LETTER HAA",
	"CHAKMA VOWEL SIGN A",
	"CHAKMA VOWEL SIGN I",
	"CHAKMA VOWEL SIGN II",
	"CHAKMA VOWEL SIGN U",
	"CHAKMA VOWEL SIGN UU",
	"CHAKMA VOWEL SIGN E",
	"CHAKMA VOWEL SIGN AI",
	"CHAKMA VOWEL SIGN O",
	"CHAKMA VOWEL SIGN AU",
	"CHAKMA VOWEL SIGN OI",
	"CHAKMA O MARK",
	"CHAKMA AU MARK",
	"CHAKMA VIRAMA",
	"CHAKMA MAAYYAA",
	"CHAKMA DIGIT ZERO",
	"CHAKMA DIGIT ONE",
	"CHAKMA DIGIT TWO",
	"CHAKMA DIGIT THREE",
	"CHAKMA DIGIT FOUR",
	"CHAKMA DIGIT FIVE",
	"CHAKMA DIGIT SIX",
	"CHAKMA DIGIT SEVEN",
	"CHAKMA DIGIT EIGHT",
	"CHAKMA DIGIT NINE",
	"CHAKMA SECTION MARK",
	"CHAKMA DANDA",
	"CHAKMA DOUBLE DANDA",
	"CHAKMA QUESTION MARK",
	"CHAKMA LETTER LHAA",
	"CHAKMA VOWEL SIGN AA",
	"CHAKMA VOWEL SIGN EI",
	"CHAKMA LETTER VAA",
	"MAHAJANI LETTER A",
	"MAHAJANI LETTER I",
	"MAHAJANI LETTER U",
	"MAHAJANI LETTER E",
	"MAHAJANI LETTER O",
	"MAHAJANI LETTER KA",
	"MAHAJANI LETTER KHA",
	"MAHAJANI LETTER GA",
	"MAHAJANI LETTER GHA",
	"MAHAJANI LETTER CA",
	"MAHAJANI LETTER CHA",
	"MAHAJANI LETTER JA",
	"MAHAJANI LETTER JHA",
	"MAHAJANI LETTER NYA",
	"MAHAJANI LETTER TTA",
	"MAHAJANI LETTER TTHA",
	"MAHAJANI LETTER DDA",
	"MAHAJANI LETTER DDHA",
	"MAHAJANI LETTER NNA",
	"MAHAJANI LETTER TA",
	"MAHAJANI LETTER THA",
	"MAHAJANI LETTER DA",
	"MAHAJANI LETTER DHA",
	"MAHAJANI LETTER NA",
	"MAHAJANI LETTER PA",
	"MAHAJANI LETTER PHA",
	"MAHAJANI LETTER BA",
	"MAHAJANI LETTER BHA",
	"MAHAJANI LETTER MA",
	"MAHAJANI LETTER RA",
	"MAHAJANI LETTER LA",
	"MAHAJANI LETTER VA",
	"MAHAJANI LETTER SA",
	"MAHAJANI LETTER HA",
	"MAHAJANI LETTER RRA",
	"MAHAJANI SIGN NUKTA",
	"MAHAJANI ABBREVIATION SIGN",
	"MAHAJANI SECTION MARK",
	"MAHAJANI LIGATURE SHRI",
	"SHARADA SIGN CANDRABINDU",
	"SHARADA SIGN ANUSVARA",
	"SHARADA SIGN VISARGA",
	"SHARADA LETTER A",
	"SHARADA LETTER AA",
	"SHARADA LETTER I",
	"SHARADA LETTER II",
	"SHARADA LETTER U",
	"SHARADA LETTER UU",
	"SHARADA LETTER VOCALIC R",
	"SHARADA LETTER VOCALIC RR",
	"SHARADA LETTER VOCALIC L",
	"SHARADA LETTER VOCALIC LL",
	"SHARADA LETTER E",
	"SHARADA LETTER AI",
	"SHARADA LETTER O",
	"SHARADA LETTER AU",
	"SHARADA LETTER KA",
	"SHARADA LETTER KHA",
	"SHARADA LETTER GA",
	"SHARADA LETTER GHA",
	"SHARADA LETTER NGA",
	"SHARADA LETTER CA",
	"SHARADA LETTER CHA",
	"SHARADA LETTER JA",
	"SHARADA LETTER JHA",
	"SHARADA LETTER NYA",
	"SHARADA LETTER TTA",
	"SHARADA LETTER TTHA",
	"SHARADA LETTER DDA",
	"SHARADA LETTER DDHA",
	"SHARADA LETTER NNA",
	"SHARADA LETTER TA",
	"SHARADA LETTER THA",
	"SHARADA LETTER DA",
	"SHARADA LETTER DHA",
	"SHARADA LETTER NA",
	"SHARADA LETTER PA",
	"SHARADA LETTER PHA",
	"SHARADA LETTER BA",
	"SHARADA LETTER BHA",
	"SHARADA LETTER MA",
	"SHARADA LETTER YA",
	"SHARADA LETTER RA",
	"SHARADA LETTER LA",
	"SHARADA LETTER LLA",
	"SHARADA LETTER VA",
	"SHARADA LETTER SHA",
	"SHARADA LETTER SSA",
	"SHARADA LETTER SA",
	"SHARADA LETTER HA",
	"SHARADA VOWEL SIGN AA",
	"SHARADA VOWEL SIGN I",
	"SHARADA VOWEL SIGN II",
	"SHARADA VOWEL SIGN U",
	"SHARADA VOWEL SIGN UU",
	"SHARADA VOWEL SIGN VOCALIC R",
	"SHARADA VOWEL SIGN VOCALIC RR",
	"SHARADA VOWEL SIGN VOCALIC L",
	"SHARADA VOWEL SIGN VOCALIC LL",
	"SHARADA VOWEL SIGN E",
	"SHARADA VOWEL SIGN AI",
	"SHARADA VOWEL SIGN O",
	"SHARADA VOWEL SIGN AU",
	"SHARADA SIGN VIRAMA",
	"SHARADA SIGN AVAGRAHA",
	"SHARADA SIGN JIHVAMULIYA",
	"SHARADA SIGN UPADHMANIYA",
	"SHARADA OM",
	"SHARADA DANDA",
	"SHARADA DOUBLE DANDA",
	"SHARADA ABBREVIATION SIGN",
	"SHARADA SEPARATOR",
	"SHARADA SANDHI MARK",
	"SHARADA SIGN NUKTA",
	"SHARADA VOWEL MODIFIER MARK",
	"SHARADA EXTRA SHORT VOWEL MARK",
	"SHARADA SUTRA MARK",
	"SHARADA VOWEL SIGN PRISHTHAMATRA E",
	"SHARADA SIGN INVERTED CANDRABINDU",
	"SHARADA DIGIT ZERO",
	"SHARADA DIGIT ONE",
	"SHARADA DIGIT TWO",
	"SHARADA DIGIT THREE",
	"SHARADA DIGIT FOUR",
	"SHARADA DIGIT FIVE",
	"SHARADA DIGIT SIX",
	"SHARADA DIGIT SEVEN",
	"SHARADA DIGIT EIGHT",
	"SHARADA DIGIT NINE",
	"SHARADA EKAM",
	"SHARADA SIGN SIDDHAM",
	"SHARADA HEADSTROKE",
	"SHARADA CONTINUATION SIGN",
	"SHARADA SECTION MARK-1",
	"SHARADA SECTION MARK-2",
	"SINHALA ARCHAIC DIGIT ONE",
	"SINHALA ARCHAIC DIGIT TWO",
	"SINHALA ARCHAIC DIGIT THREE",
	"SINHALA ARCHAIC DIGIT FOUR",
	"SINHALA ARCHAIC DIGIT FIVE",
	"SINHALA ARCHAIC DIGIT SIX",
	"SINHALA ARCHAIC DIGIT SEVEN",
	"SINHALA ARCHAIC DIGIT EIGHT",
	"SINHALA ARCHAIC DIGIT NINE",
	"SINHALA ARCHAIC NUMBER TEN",
	"SINHALA ARCHAIC NUMBER TWENTY",
	"SINHALA ARCHAIC NUMBER THIRTY",
	"SINHALA ARCHAIC NUMBER FORTY",
	"SINHALA ARCHAIC NUMBER FIFTY",
	"SINHALA ARCHAIC NUMBER SIXTY",
	"SINHALA ARCHAIC NUMBER SEVENTY",
	"SINHALA ARCHAIC NUMBER EIGHTY",
	"SINHALA ARCHAIC NUMBER NINETY",
	"SINHALA ARCHAIC NUMBER ONE HUNDRED",
	"SINHALA ARCHAIC NUMBER ONE THOUSAND",
	"KHOJKI LETTER A",
	"KHOJKI LETTER AA",
	"KHOJKI LETTER I",
	"KHOJKI LETTER U",
	"KHOJKI LETTER E",
	"KHOJKI LETTER AI",
	"KHOJKI LETTER O",
	"KHOJKI LETTER AU",
	"KHOJKI LETTER KA",
	"KHOJKI LETTER KHA",
	"KHOJKI LETTER GA",
	"KHOJKI LETTER GGA",
	"KHOJKI LETTER GHA",
	"KHOJKI LETTER NGA",
	"KHOJKI LETTER CA",
	"KHOJKI LETTER CHA",
	"KHOJKI LETTER JA",
	"KHOJKI LETTER JJA",
	"KHOJKI LETTER NYA",
	"KHOJKI LETTER TTA",
	"KHOJKI LETTER TTHA",
	"KHOJKI LETTER DDA",
	"KHOJKI LETTER DDHA",
	"KHOJKI LETTER NNA",
	"KHOJKI LETTER TA",
	"KHOJKI LETTER THA",
	"KHOJKI LETTER DA",
	"KHOJKI LETTER DDDA",
	"KHOJKI LETTER DHA",
	"KHOJKI LETTER NA",
	"KHOJKI LETTER PA",
	"KHOJKI LETTER PHA",
	"KHOJKI LETTER BA",
	"KHOJKI LETTER BBA",
	"KHOJKI LETTER BHA",
	"KHOJKI LETTER MA",
	"KHOJKI LETTER YA",
	"KHOJKI LETTER RA",
	"KHOJKI LETTER LA",
	"KHOJKI LETTER VA",
	"KHOJKI LETTER SA",
	"KHOJKI LETTER HA",
	"KHOJKI LETTER LLA",
	"KHOJKI VOWEL SIGN AA",
	"KHOJKI VOWEL SIGN I",
	"KHOJKI VOWEL SIGN II",
	"KHOJKI VOWEL SIGN U",
	"KHOJKI VOWEL SIGN E",
	"KHOJKI VOWEL SIGN AI",
	"KHOJKI VOWEL SIGN O",
	"KHOJKI VOWEL SIGN AU",
	"KHOJKI SIGN ANUSVARA",
	"KHOJKI SIGN VIRAMA",
	"KHOJKI SIGN NUKTA",
	"KHOJKI SIGN SHADDA",
	"KHOJKI DANDA",
	"KHOJKI DOUBLE DANDA",
	"KHOJKI WORD SEPARATOR",
	"KHOJKI SECTION MARK",
	"KHOJKI DOUBLE SECTION MARK",
	"KHOJKI ABBREVIATION SIGN",
	"KHOJKI SIGN SUKUN",
	"KHOJKI LETTER QA",
	"KHOJKI LETTER SHORT I",
	"KHOJKI VOWEL SIGN VOCALIC R",
	"MULTANI LETTER A",
	"MULTANI LETTER I",
	"MULTANI LETTER U",
	"MULTANI LETTER E",
	"MULTANI LETTER KA",
	"MULTANI LETTER KHA",
	"MULTANI LETTER GA",
	"MULTANI LETTER GHA",
	"MULTANI LETTER CA",
	"MULTANI LETTER CHA",
	"MULTANI LETTER JA",
	"MULTANI LETTER JJA",
	"MULTANI LETTER NYA",
	"MULTANI LETTER TTA",
	"MULTANI LETTER TTHA",
	"MULTANI LETTER DDA",
	"MULTANI LETTER DDDA",
	"MULTANI LETTER DDHA",
	"MULTANI LETTER NNA",
	"MULTANI LETTER TA",
	"MULTANI LETTER THA",
	"MULTANI LETTER DA",
	"MULTANI LETTER DHA",
	"MULTANI LETTER NA",
	"MULTANI LETTER PA",
	"MULTANI LETTER PHA",
	"MULTANI LETTER BA",
	"MULTANI LETTER BHA",
	"MULTANI LETTER MA",
	"MULTANI LETTER YA",
	"MULTANI LETTER RA",
	"MULTANI LETTER LA",
	"MULTANI LETTER VA",
	"MULTANI LETTER SA",
	"MULTANI LETTER HA",
	"MULTANI LETTER RRA",
	"MULTANI LETTER RHA",
	"MULTANI SECTION MARK",
	"KHUDAWADI LETTER A",
	"KHUDAWADI LETTER AA",
	"KHUDAWADI LETTER I",
	"KHUDAWADI LETTER II",
	"KHUDAWADI LETTER U",
	"KHUDAWADI LETTER UU",
	"KHUDAWADI LETTER E",
	"KHUDAWADI LETTER AI",
	"KHUDAWADI LETTER O",
	"KHUDAWADI LETTER AU",
	"KHUDAWADI LETTER KA",
	"KHUDAWADI LETTER KHA",
	"KHUDAWADI LETTER GA",
	"KHUDAWADI LETTER GGA",
	"KHUDAWADI LETTER GHA",
	"KHUDAWADI LETTER NGA",
	"KHUDAWADI LETTER CA",
	"KHUDAWADI LETTER CHA",
	"KHUDAWADI LETTER JA",
	"KHUDAWADI LETTER JJA",
	"KHUDAWADI LETTER JHA",
	"KHUDAWADI LETTER NYA",
	"KHUDAWADI LETTER TTA",
	"KHUDAWADI LETTER TTHA",
	"KHUDAWADI LETTER DDA",
	"KHUDAWADI LETTER DDDA",
	"KHUDAWADI LETTER RRA",
	"KHUDAWADI LETTER DDHA",
	"KHUDAWADI LETTER NNA",
	"KHUDAWADI LETTER TA",
	"KHUDAWADI LETTER THA",
	"KHUDAWADI LETTER DA",
	"KHUDAWADI LETTER DHA",
	"KHUDAWADI LETTER NA",
	"KHUDAWADI LETTER PA",
	"KHUDAWADI LETTER PHA",
	"KHUDAWADI LETTER BA",
	"KHUDAWADI LETTER BBA",
	"KHUDAWADI LETTER BHA",
	"KHUDAWADI LETTER MA",
	"KHUDAWADI LETTER YA",
	"KHUDAWADI LETTER RA",
	"KHUDAWADI LETTER LA",
	"KHUDAWADI LETTER VA",
	"KHUDAWADI LETTER SHA",
	"KHUDAWADI LETTER SA",
	"KHUDAWADI LETTER HA",
	"KHUDAWADI SIGN ANUSVARA",
	"KHUDAWADI VOWEL SIGN AA",
	"KHUDAWADI VOWEL SIGN I",
	"KHUDAWADI VOWEL SIGN II",
	"KHUDAWADI VOWEL SIGN U",
	"KHUDAWADI VOWEL SIGN UU",
	"KHUDAWADI VOWEL SIGN E",
	"KHUDAWADI VOWEL SIGN AI",
	"KHUDAWADI VOWEL SIGN O",
	"KHUDAWADI VOWEL SIGN AU",
	"KHUDAWADI SIGN NUKTA",
	"KHUDAWADI SIGN VIRAMA",
	"KHUDAWADI DIGIT ZERO",
	"KHUDAWADI DIGIT ONE",
	"KHUDAWADI DIGIT TWO",
	"KHUDAWADI DIGIT THREE",
	"KHUDAWADI DIGIT FOUR",
	"KHUDAWADI DIGIT FIVE",
	"KHUDAWADI DIGIT SIX",
	"KHUDAWADI DIGIT SEVEN",
	"KHUDAWADI DIGIT EIGHT",
	"KHUDAWADI DIGIT NINE",
	"GRANTHA SIGN COMBINING ANUSVARA ABOVE",
	"GRANTHA SIGN CANDRABINDU",
	"GRANTHA SIGN ANUSVARA",
	"GRANTHA SIGN VISARGA",
	"GRANTHA LETTER A",
	"GRANTHA LETTER AA",
	"GRANTHA LETTER I",
	"GRANTHA LETTER II",
	"GRANTHA LETTER U",
	"GRANTHA LETTER UU",
	"GRANTHA LETTER VOCALIC R",
	"GRANTHA LETTER VOCALIC L",
	"GRANTHA LETTER EE",
	"GRANTHA LETTER AI",
	"GRANTHA LETTER OO",
	"GRANTHA LETTER AU",
	"GRANTHA LETTER KA",
	"GRANTHA LETTER KHA",
	"GRANTHA LETTER GA",
	"GRANTHA LETTER GHA",
	"GRANTHA LETTER NGA",
	"GRANTHA LETTER CA",
	"GRANTHA LETTER CHA",
	"GRANTHA LETTER JA",
	"GRANTHA LETTER JHA",
	"GRANTHA LETTER NYA",
	"GRANTHA LETTER TTA",
	"GRANTHA LETTER TTHA",
	"GRANTHA LETTER DDA",
	"GRANTHA LETTER DDHA",
	"GRANTHA LETTER NNA",
	"GRANTHA LETTER TA",
	"GRANTHA LETTER THA",
	"GRANTHA LETTER DA",
	"GRANTHA LETTER DHA",
	"GRANTHA LETTER NA",
	"GRANTHA LETTER PA",
	"GRANTHA LETTER PHA",
	"GRANTHA LETTER BA",
	"GRANTHA LETTER BHA",
	"GRANTHA LETTER MA",
	"GRANTHA LETTER YA",
	"GRANTHA LETTER RA",
	"GRANTHA LETTER LA",
	"GRANTHA LETTER LLA",
	"GRANTHA LETTER VA",
	"GRANTHA LETTER SHA",
	"GRANTHA LETTER SSA",
	"GRANTHA LETTER SA",
	"GRANTHA LETTER HA",
	"COMBINING BINDU BELOW",
	"GRANTHA SIGN NUKTA",
	"GRANTHA SIGN AVAGRAHA",
	"GRANTHA VOWEL SIGN AA",
	"GRANTHA VOWEL SIGN I",
	"GRANTHA VOWEL SIGN II",
	"GRANTHA VOWEL SIGN U",
	"GRANTHA VOWEL SIGN UU",
	"GRANTHA VOWEL SIGN VOCALIC R",
	"GRANTHA VOWEL SIGN VOCALIC RR",
	"GRANTHA VOWEL SIGN EE",
	"GRANTHA VOWEL SIGN AI",
	"GRANTHA VOWEL SIGN OO",
	"GRANTHA VOWEL SIGN AU",
	"GRANTHA SIGN VIRAMA",
	"GRANTHA OM",
	"GRANTHA AU LENGTH MARK",
	"GRANTHA SIGN PLUTA",
	"GRANTHA LETTER VEDIC ANUSVARA",
	"GRANTHA LETTER VEDIC DOUBLE ANUSVARA",
	"GRANTHA LETTER VOCALIC RR",
	"GRANTHA LETTER VOCALIC LL",
	"GRANTHA VOWEL SIGN VOCALIC L",
	"GRANTHA VOWEL SIGN VOCALIC LL",
	"COMBINING GRANTHA DIGIT ZERO",
	"COMBINING GRANTHA DIGIT ONE",
	"COMBINING GRANTHA DIGIT TWO",
	"COMBINING GRANTHA DIGIT THREE",
	"COMBINING GRANTHA DIGIT FOUR",
	"COMBINING GRANTHA DIGIT FIVE",
	"COMBINING GRANTHA DIGIT SIX",
	"COMBINING GRANTHA LETTER A",
	"COMBINING GRANTHA LETTER KA",
	"COMBINING GRANTHA LETTER NA",
	"COMBINING GRANTHA LETTER VI",
	"COMBINING GRANTHA LETTER PA",
	"NEWA LETTER A",
	"NEWA LETTER AA",
	"NEWA LETTER I",
	"NEWA LETTER II",
	"NEWA LETTER U",
	"NEWA LETTER UU",
	"NEWA LETTER VOCALIC R",
	"NEWA LETTER VOCALIC RR",
	"NEWA LETTER VOCALIC L",
	"NEWA LETTER VOCALIC LL",
	"NEWA LETTER E",
	"NEWA LETTER AI",
	"NEWA LETTER O",
	"NEWA LETTER AU",
	"NEWA LETTER KA",
	"NEWA LETTER KHA",
	"NEWA LETTER GA",
	"NEWA LETTER GHA",
	"NEWA LETTER NGA",
	"NEWA LETTER NGHA",
	"NEWA LETTER CA",
	"NEWA LETTER CHA",
	"NEWA LETTER JA",
	"NEWA LETTER JHA",
	"NEWA LETTER NYA",
	"NEWA LETTER NYHA",
	"NEWA LETTER TTA",
	"NEWA LETTER TTHA",
	"NEWA LETTER DDA",
	"NEWA LETTER DDHA",
	"NEWA LETTER NNA",
	"NEWA LETTER TA",
	"NEWA LETTER THA",
	"NEWA LETTER DA",
	"NEWA LETTER DHA",
	"NEWA LETTER NA",
	"NEWA LETTER NHA",
	"NEWA LETTER PA",
	"NEWA LETTER PHA",
	"NEWA LETTER BA",
	"NEWA LETTER BHA",
	"NEWA LETTER MA",
	"NEWA LETTER MHA",
	"NEWA LETTER YA",
	"NEWA LETTER RA",
	"NEWA LETTER RHA",
	"NEWA LETTER LA",
	"NEWA LETTER LHA",
	"NEWA LETTER WA",
	"NEWA LETTER SHA",
	"NEWA LETTER SSA",
	"NEWA LETTER SA",
	"NEWA LETTER HA",
	"NEWA VOWEL SIGN AA",
	"NEWA VOWEL SIGN I",
	"NEWA VOWEL SIGN II",
	"NEWA VOWEL SIGN U",
	"NEWA VOWEL SIGN UU",
	"NEWA VOWEL SIGN VOCALIC R",
	"NEWA VOWEL SIGN VOCALIC RR",
	"NEWA VOWEL SIGN VOCALIC L",
	"NEWA VOWEL SIGN VOCALIC LL",
	"NEWA VOWEL SIGN E",
	"NEWA VOWEL SIGN AI",
	"NEWA VOWEL SIGN O",
	"NEWA VOWEL SIGN AU",
	"NEWA SIGN VIRAMA",
	"NEWA SIGN CANDRABINDU",
	"NEWA SIGN ANUSVARA",
	"NEWA SIGN VISARGA",
	"NEWA SIGN NUKTA",
	"NEWA SIGN AVAGRAHA",
	"NEWA SIGN FINAL ANUSVARA",
	"NEWA OM",
	"NEWA SIDDHI",
	"NEWA DANDA",
	"NEWA DOUBLE DANDA",
	"NEWA COMMA",
	"NEWA GAP FILLER",
	"NEWA ABBREVIATION SIGN",
	"NEWA DIGIT ZERO",
	"NEWA DIGIT ONE",
	"NEWA DIGIT TWO",
	"NEWA DIGIT THREE",
	"NEWA DIGIT FOUR",
	"NEWA DIGIT FIVE",
	"NEWA DIGIT SIX",
	"NEWA DIGIT SEVEN",
	"NEWA DIGIT EIGHT",
	"NEWA DIGIT NINE",
	"NEWA DOUBLE COMMA",
	"NEWA PLACEHOLDER MARK",
	"NEWA INSERTION SIGN",
	"NEWA SANDHI MARK",
	"NEWA LETTER VEDIC ANUSVARA",
	"NEWA SIGN JIHVAMULIYA",
	"NEWA SIGN UPADHMANIYA",
	"TIRHUTA ANJI",
	"TIRHUTA LETTER A",
	"TIRHUTA LETTER AA",
	"TIRHUTA LETTER I",
	"TIRHUTA LETTER II",
	"TIRHUTA LETTER U",
	"TIRHUTA LETTER UU",
	"TIRHUTA LETTER VOCALIC R",
	"TIRHUTA LETTER VOCALIC RR",
	"TIRHUTA LETTER VOCALIC L",
	"TIRHUTA LETTER VOCALIC LL",
	"TIRHUTA LETTER E",
	"TIRHUTA LETTER AI",
	"TIRHUTA LETTER O",
	"TIRHUTA LETTER AU",
	"TIRHUTA LETTER KA",
	"TIRHUTA LETTER KHA",
	"TIRHUTA LETTER GA",
	"TIRHUTA LETTER GHA",
	"TIRHUTA LETTER NGA",
	"TIRHUTA LETTER CA",
	"TIRHUTA LETTER CHA",
	"TIRHUTA LETTER JA",
	"TIRHUTA LETTER JHA",
	"TIRHUTA LETTER NYA",
	"TIRHUTA LETTER TTA",
	"TIRHUTA LETTER TTHA",
	"TIRHUTA LETTER DDA",
	"TIRHUTA LETTER DDHA",
	"TIRHUTA LETTER NNA",
	"TIRHUTA LETTER TA",
	"TIRHUTA LETTER THA",
	"TIRHUTA LETTER DA",
	"TIRHUTA LETTER DHA",
	"TIRHUTA LETTER NA",
	"TIRHUTA LETTER PA",
	"TIRHUTA LETTER PHA",
	"TIRHUTA LETTER BA",
	"TIRHUTA LETTER BHA",
	"TIRHUTA LETTER MA",
	"TIRHUTA LETTER YA",
	"TIRHUTA LETTER RA",
	"TIRHUTA LETTER LA",
	"TIRHUTA LETTER VA",
	"TIRHUTA LETTER SHA",
	"TIRHUTA LETTER SSA",
	"TIRHUTA LETTER SA",
	"TIRHUTA LETTER HA",
	"TIRHUTA VOWEL SIGN AA",
	"TIRHUTA VOWEL SIGN I",
	"TIRHUTA VOWEL SIGN II",
	"TIRHUTA VOWEL SIGN U",
	"TIRHUTA VOWEL SIGN UU",
	"TIRHUTA VOWEL SIGN VOCALIC R",
	"TIRHUTA VOWEL SIGN VOCALIC RR",
	"TIRHUTA VOWEL SIGN VOCALIC L",
	"TIRHUTA VOWEL SIGN VOCALIC LL",
	"TIRHUTA VOWEL SIGN E",
	"TIRHUTA VOWEL SIGN SHORT E",
	"TIRHUTA VOWEL SIGN AI",
	"TIRHUTA VOWEL SIGN O",
	"TIRHUTA VOWEL SIGN SHORT O",
	"TIRHUTA VOWEL SIGN AU",
	"TIRHUTA SIGN CANDRABINDU",
	"TIRHUTA SIGN ANUSVARA",
	"TIRHUTA SIGN VISARGA",
	"TIRHUTA SIGN VIRAMA",
	"TIRHUTA SIGN NUKTA",
	"TIRHUTA SIGN AVAGRAHA",
	"TIRHUTA GVANG",
	"TIRHUTA ABBREVIATION SIGN",
	"TIRHUTA OM",
	"TIRHUTA DIGIT ZERO",
	"TIRHUTA DIGIT ONE",
	"TIRHUTA DIGIT TWO",
	"TIRHUTA DIGIT THREE",
	"TIRHUTA DIGIT FOUR",
	"TIRHUTA DIGIT FIVE",
	"TIRHUTA DIGIT SIX",
	"TIRHUTA DIGIT SEVEN",
	"TIRHUTA DIGIT EIGHT",
	"TIRHUTA DIGIT NINE",
	"SIDDHAM LETTER A",
	"SIDDHAM LETTER AA",
	"SIDDHAM LETTER I",
	"SIDDHAM LETTER II",
	"SIDDHAM LETTER U",
	"SIDDHAM LETTER UU",
	"SIDDHAM LETTER VOCALIC R",
	"SIDDHAM LETTER VOCALIC RR",
	"SIDDHAM LETTER VOCALIC L",
	"SIDDHAM LETTER VOCALIC LL",
	"SIDDHAM LETTER E",
	"SIDDHAM LETTER AI",
	"SIDDHAM LETTER O",
	"SIDDHAM LETTER AU",
	"SIDDHAM LETTER KA",
	"SIDDHAM LETTER KHA",
	"SIDDHAM LETTER GA",
	"SIDDHAM LETTER GHA",
	"SIDDHAM LETTER NGA",
	"SIDDHAM LETTER CA",
	"SIDDHAM LETTER CHA",
	"SIDDHAM LETTER JA",
	"SIDDHAM LETTER JHA",
	"SIDDHAM LETTER NYA",
	"SIDDHAM LETTER TTA",
	"SIDDHAM LETTER TTHA",
	"SIDDHAM LETTER DDA",
	"SIDDHAM LETTER DDHA",
	"SIDDHAM LETTER NNA",
	"SIDDHAM LETTER TA",
	"SIDDHAM LETTER THA",
	"SIDDHAM LETTER DA",
	"SIDDHAM LETTER DHA",
	"SIDDHAM LETTER NA",
	"SIDDHAM LETTER PA",
	"SIDDHAM LETTER PHA",
	"SIDDHAM LETTER BA",
	"SIDDHAM LETTER BHA",
	"SIDDHAM LETTER MA",
	"SIDDHAM LETTER YA",
	"SIDDHAM LETTER RA",
	"SIDDHAM LETTER LA",
	"SIDDHAM LETTER VA",
	"SIDDHAM LETTER SHA",
	"SIDDHAM LETTER SSA",
	"SIDDHAM LETTER SA",
	"SIDDHAM LETTER HA",
	"SIDDHAM VOWEL SIGN AA",
	"SIDDHAM VOWEL SIGN I",
	"SIDDHAM VOWEL SIGN II",
	"SIDDHAM VOWEL SIGN U",
	"SIDDHAM VOWEL SIGN UU",
	"SIDDHAM VOWEL SIGN VOCALIC R",
	"SIDDHAM VOWEL SIGN VOCALIC RR",
	"SIDDHAM VOWEL SIGN E",
	"SIDDHAM VOWEL SIGN AI",
	"SIDDHAM VOWEL SIGN O",
	"SIDDHAM VOWEL SIGN AU",
	"SIDDHAM SIGN CANDRABINDU",
	"SIDDHAM SIGN ANUSVARA",
	"SIDDHAM SIGN VISARGA",
	"SIDDHAM SIGN VIRAMA",
	"SIDDHAM SIGN NUKTA",
	"SIDDHAM SIGN SIDDHAM",
	"SIDDHAM DANDA",
	"SIDDHAM DOUBLE DANDA",
	"SIDDHAM SEPARATOR DOT",
	"SIDDHAM SEPARATOR BAR",
	"SIDDHAM REPETITION MARK-1",
	"SIDDHAM REPETITION MARK-2",
	"SIDDHAM REPETITION MARK-3",
	"SIDDHAM END OF TEXT MARK",
	"SIDDHAM SECTION MARK WITH TRIDENT AND U-SHAPED ORNAMENTS",
	"SIDDHAM SECTION MARK WITH TRIDENT AND DOTTED CRESCENTS",
	"SIDDHAM SECTION MARK WITH RAYS AND DOTTED CRESCENTS",
	"SIDDHAM SECTION MARK WITH RAYS AND DOTTED DOUBLE CRESCENTS",
	"SIDDHAM SECTION MARK WITH RAYS AND DOTTED TRIPLE CRESCENTS",
	"SIDDHAM SECTION MARK DOUBLE RING",
	"SIDDHAM SECTION MARK DOUBLE RING WITH RAYS",
	"SIDDHAM SECTION MARK WITH DOUBLE CRESCENTS",
	"SIDDHAM SECTION MARK WITH TRIPLE CRESCENTS",
	"SIDDHAM SECTION MARK WITH QUADRUPLE CRESCENTS",
	"SIDDHAM SECTION MARK WITH SEPTUPLE CRESCENTS",
	"SIDDHAM SECTION MARK WITH CIRCLES AND RAYS",
	"SIDDHAM SECTION MARK WITH CIRCLES AND TWO ENCLOSURES",
	"SIDDHAM SECTION MARK WITH CIRCLES AND FOUR ENCLOSURES",
	"SIDDHAM LETTER THREE-CIRCLE ALTERNATE I",
	"SIDDHAM LETTER TWO-CIRCLE ALTERNATE I",
	"SIDDHAM LETTER TWO-CIRCLE ALTERNATE II",
	"SIDDHAM LETTER ALTERNATE U",
	"SIDDHAM VOWEL SIGN ALTERNATE U",
	"SIDDHAM VOWEL SIGN ALTERNATE UU",
	"MODI LETTER A",
	"MODI LETTER AA",
	"MODI LETTER I",
	"MODI LETTER II",
	"MODI LETTER U",
	"MODI LETTER UU",
	"MODI LETTER VOCALIC R",
	"MODI LETTER VOCALIC RR",
	"MODI LETTER VOCALIC L",
	"MODI LETTER VOCALIC LL",
	"MODI LETTER E",
	"MODI LETTER AI",
	"MODI LETTER O",
	"MODI LETTER AU",
	"MODI LETTER KA",
	"MODI LETTER KHA",
	"MODI LETTER GA",
	"MODI LETTER GHA",
	"MODI LETTER NGA",
	"MODI LETTER CA",
	"MODI LETTER CHA",
	"MODI LETTER JA",
	"MODI LETTER JHA",
	"MODI LETTER NYA",
	"MODI LETTER TTA",
	"MODI LETTER TTHA",
	"MODI LETTER DDA",
	"MODI LETTER DDHA",
	"MODI LETTER NNA",
	"MODI LETTER TA",
	"MODI LETTER THA",
	"MODI LETTER DA",
	"MODI LETTER DHA",
	"MODI LETTER NA",
	"MODI LETTER PA",
	"MODI LETTER PHA",
	"MODI LETTER BA",
	"MODI LETTER BHA",
	"MODI LETTER MA",
	"MODI LETTER YA",
	"MODI LETTER RA",
	"MODI LETTER LA",
	"MODI LETTER VA",
	"MODI LETTER SHA",
	"MODI LETTER SSA",
	"MODI LETTER SA",
	"MODI LETTER HA",
	"MODI LETTER LLA",
	"MODI VOWEL SIGN AA",
	"MODI VOWEL SIGN I",
	"MODI VOWEL SIGN II",
	"MODI VOWEL SIGN U",
	"MODI VOWEL SIGN UU",
	"MODI VOWEL SIGN VOCALIC R",
	"MODI VOWEL SIGN VOCALIC RR",
	"MODI VOWEL SIGN VOCALIC L",
	"MODI VOWEL SIGN VOCALIC LL",
	"MODI VOWEL SIGN E",
	"MODI VOWEL SIGN AI",
	"MODI VOWEL SIGN O",
	"MODI VOWEL SIGN AU",
	"MODI SIGN ANUSVARA",
	"MODI SIGN VISARGA",
	"MODI SIGN VIRAMA",
	"MODI SIGN ARDHACANDRA",
	"MODI DANDA",
	"MODI DOUBLE DANDA",
	"MODI ABBREVIATION SIGN",
	"MODI SIGN HUVA",
	"MODI DIGIT ZERO",
	"MODI DIGIT ONE",
	"MODI DIGIT TWO",
	"MODI DIGIT THREE",
	"MODI DIGIT FOUR",
	"MODI DIGIT FIVE",
	"MODI DIGIT SIX",
	"MODI DIGIT SEVEN",
	"MODI DIGIT EIGHT",
	"MODI DIGIT NINE",
	"MONGOLIAN BIRGA WITH ORNAMENT",
	"MONGOLIAN ROTATED BIRGA",
	"MONGOLIAN DOUBLE BIRGA WITH ORNAMENT",
	"MONGOLIAN TRIPLE BIRGA WITH ORNAMENT",
	"MONGOLIAN BIRGA WITH DOUBLE ORNAMENT",
	"MONGOLIAN ROTATED BIRGA WITH ORNAMENT",
	"MONGOLIAN ROTATED BIRGA WITH DOUBLE ORNAMENT",
	"MONGOLIAN INVERTED BIRGA",
	"MONGOLIAN INVERTED BIRGA WITH DOUBLE ORNAMENT",
	"MONGOLIAN SWIRL BIRGA",
	"MONGOLIAN SWIRL BIRGA WITH ORNAMENT",
	"MONGOLIAN SWIRL BIRGA WITH DOUBLE ORNAMENT",
	"MONGOLIAN TURNED SWIRL BIRGA WITH DOUBLE ORNAMENT",
	"TAKRI LETTER A",
	"TAKRI LETTER AA",
	"TAKRI LETTER I",
	"TAKRI LETTER II",
	"TAKRI LETTER U",
	"TAKRI LETTER UU",
	"TAKRI LETTER E",
	"TAKRI LETTER AI",
	"TAKRI LETTER O",
	"TAKRI LETTER AU",
	"TAKRI LETTER KA",
	"TAKRI LETTER KHA",
	"TAKRI LETTER GA",
	"TAKRI LETTER GHA",
	"TAKRI LETTER NGA",
	"TAKRI LETTER CA",
	"TAKRI LETTER CHA",
	"TAKRI LETTER JA",
	"TAKRI LETTER JHA",
	"TAKRI LETTER NYA",
	"TAKRI LETTER TTA",
	"TAKRI LETTER TTHA",
	"TAKRI LETTER DDA",
	"TAKRI LETTER DDHA",
	"TAKRI LETTER NNA",
	"TAKRI LETTER TA",
	"TAKRI LETTER THA",
	"TAKRI LETTER DA",
	"TAKRI LETTER DHA",
	"TAKRI LETTER NA",
	"TAKRI LETTER PA",
	"TAKRI LETTER PHA",
	"TAKRI LETTER BA",
	"TAKRI LETTER BHA",
	"TAKRI LETTER MA",
	"TAKRI LETTER YA",
	"TAKRI LETTER RA",
	"TAKRI LETTER LA",
	"TAKRI LETTER VA",
	"TAKRI LETTER SHA",
	"TAKRI LETTER SA",
	"TAKRI LETTER HA",
	"TAKRI LETTER RRA",
	"TAKRI SIGN ANUSVARA",
	"TAKRI SIGN VISARGA",
	"TAKRI VOWEL SIGN AA",
	"TAKRI VOWEL SIGN I",
	"TAKRI VOWEL SIGN II",
	"TAKRI VOWEL SIGN U",
	"TAKRI VOWEL SIGN UU",
	"TAKRI VOWEL SIGN E",
	"TAKRI VOWEL SIGN AI",
	"TAKRI VOWEL SIGN O",
	"TAKRI VOWEL SIGN AU",
	"TAKRI SIGN VIRAMA",
	"TAKRI SIGN NUKTA",
	"TAKRI LETTER ARCHAIC KHA",
	"TAKRI ABBREVIATION SIGN",
	"TAKRI DIGIT ZERO",
	"TAKRI DIGIT ONE",
	"TAKRI DIGIT TWO",
	"TAKRI DIGIT THREE",
	"TAKRI DIGIT FOUR",
	"TAKRI DIGIT FIVE",
	"TAKRI DIGIT SIX",
	"TAKRI DIGIT SEVEN",
	"TAKRI DIGIT EIGHT",
	"TAKRI DIGIT NINE",
	"AHOM LETTER KA",
	"AHOM LETTER KHA",
	"AHOM LETTER NGA",
	"AHOM LETTER NA",
	"AHOM LETTER TA",
	"AHOM LETTER ALTERNATE TA",
	"AHOM LETTER PA",
	"AHOM LETTER PHA",
	"AHOM LETTER BA",
	"AHOM LETTER MA",
	"AHOM LETTER JA",
	"AHOM LETTER CHA",
	"AHOM LETTER THA",
	"AHOM LETTER RA",
	"AHOM LETTER LA",
	"AHOM LETTER SA",
	"AHOM LETTER NYA",
	"AHOM LETTER HA",
	"AHOM LETTER A",
	"AHOM LETTER DA",
	"AHOM LETTER DHA",
	"AHOM LETTER GA",
	"AHOM LETTER ALTERNATE GA",
	"AHOM LETTER GHA",
	"AHOM LETTER BHA",
	"AHOM LETTER JHA",
	"AHOM LETTER ALTERNATE BA",
	"AHOM CONSONANT SIGN MEDIAL LA",
	"AHOM CONSONANT SIGN MEDIAL RA",
	"AHOM CONSONANT SIGN MEDIAL LIGATING RA",
	"AHOM VOWEL SIGN A",
	"AHOM VOWEL SIGN AA",
	"AHOM VOWEL SIGN I",
	"AHOM VOWEL SIGN II",
	"AHOM VOWEL SIGN U",
	"AHOM VOWEL SIGN UU",
	"AHOM VOWEL SIGN E",
	"AHOM VOWEL SIGN AW",
	"AHOM VOWEL SIGN O",
	"AHOM VOWEL SIGN AI",
	"AHOM VOWEL SIGN AM",
	"AHOM SIGN KILLER",
	"AHOM DIGIT ZERO",
	"AHOM DIGIT ONE",
	"AHOM DIGIT TWO",
	"AHOM DIGIT THREE",
	"AHOM DIGIT FOUR",
	"AHOM DIGIT FIVE",
	"AHOM DIGIT SIX",
	"AHOM DIGIT SEVEN",
	"AHOM DIGIT EIGHT",
	"AHOM DIGIT NINE",
	"AHOM NUMBER TEN",
	"AHOM NUMBER TWENTY",
	"AHOM SIGN SMALL SECTION",
	"AHOM SIGN SECTION",
	"AHOM SIGN RULAI",
	"AHOM SYMBOL VI",
	"AHOM LETTER CA",
	"AHOM LETTER TTA",
	"AHOM LETTER TTHA",
	"AHOM LETTER DDA",
	"AHOM LETTER DDHA",
	"AHOM LETTER NNA",
	"AHOM LETTER LLA",
	"DOGRA LETTER A",
	"DOGRA LETTER AA",
	"DOGRA LETTER I",
	"DOGRA LETTER II",
	"DOGRA LETTER U",
	"DOGRA LETTER UU",
	"DOGRA LETTER E",
	"DOGRA LETTER AI",
	"DOGRA LETTER O",
	"DOGRA LETTER AU",
	"DOGRA LETTER KA",
	"DOGRA LETTER KHA",
	"DOGRA LETTER GA",
	"DOGRA LETTER GHA",
	"DOGRA LETTER NGA",
	"DOGRA LETTER CA",
	"DOGRA LETTER CHA",
	"DOGRA LETTER JA",
	"DOGRA LETTER JHA",
	"DOGRA LETTER NYA",
	"DOGRA LETTER TTA",
	"DOGRA LETTER TTHA",
	"DOGRA LETTER DDA",
	"DOGRA LETTER DDHA",
	"DOGRA LETTER NNA",
	"DOGRA LETTER TA",
	"DOGRA LETTER THA",
	"DOGRA LETTER DA",
	"DOGRA LETTER DHA",
	"DOGRA LETTER NA",
	"DOGRA LETTER PA",
	"DOGRA LETTER PHA",
	"DOGRA LETTER BA",
	"DOGRA LETTER BHA",
	"DOGRA LETTER MA",
	"DOGRA LETTER YA",
	"DOGRA LETTER RA",
	"DOGRA LETTER LA",
	"DOGRA LETTER VA",
	"DOGRA LETTER SHA",
	"DOGRA LETTER SSA",
	"DOGRA LETTER SA",
	"DOGRA LETTER HA",
	"DOGRA LETTER RRA",
	"DOGRA VOWEL SIGN AA",
	"DOGRA VOWEL SIGN I",
	"DOGRA VOWEL SIGN II",
	"DOGRA VOWEL SIGN U",
	"DOGRA VOWEL SIGN UU",
	"DOGRA VOWEL SIGN VOCALIC R",
	"DOGRA VOWEL SIGN VOCALIC RR",
	"DOGRA VOWEL SIGN E",
	"DOGRA VOWEL SIGN AI",
	"DOGRA VOWEL SIGN O",
	"DOGRA VOWEL SIGN AU",
	"DOGRA SIGN ANUSVARA",
	"DOGRA SIGN VISARGA",
	"DOGRA SIGN VIRAMA",
	"DOGRA SIGN NUKTA",
	"DOGRA ABBREVIATION SIGN",
	"WARANG CITI CAPITAL LETTER NGAA",
	"WARANG CITI CAPITAL LETTER A",
	"WARANG CITI CAPITAL LETTER WI",
	"WARANG CITI CAPITAL LETTER YU",
	"WARANG CITI CAPITAL LETTER YA",
	"WARANG CITI CAPITAL LETTER YO",
	"WARANG CITI CAPITAL LETTER II",
	"WARANG CITI CAPITAL LETTER UU",
	"WARANG CITI CAPITAL LETTER E",
	"WARANG CITI CAPITAL LETTER O",
	"WARANG CITI CAPITAL LETTER ANG",
	"WARANG CITI CAPITAL LETTER GA",
	"WARANG CITI CAPITAL LETTER KO",
	"WARANG CITI CAPITAL LETTER ENY",
	"WARANG CITI CAPITAL LETTER YUJ",
	"WARANG CITI CAPITAL LETTER UC",
	"WARANG CITI CAPITAL LETTER ENN",
	"WARANG CITI CAPITAL LETTER ODD",
	"WARANG CITI CAPITAL LETTER TTE",
	"WARANG CITI CAPITAL LETTER NUNG",
	"WARANG CITI CAPITAL LETTER DA",
	"WARANG CITI CAPITAL LETTER AT",
	"WARANG CITI CAPITAL LETTER AM",
	"WARANG CITI CAPITAL LETTER BU",
	"WARANG CITI CAPITAL LETTER PU",
	"WARANG CITI CAPITAL LETTER HIYO",
	"WARANG CITI CAPITAL LETTER HOLO",
	"WARANG CITI CAPITAL LETTER HORR",
	"WARANG CITI CAPITAL LETTER HAR",
	"WARANG CITI CAPITAL LETTER SSUU",
	"WARANG CITI CAPITAL LETTER SII",
	"WARANG CITI CAPITAL LETTER VIYO",
	"WARANG CITI SMALL LETTER NGAA",
	"WARANG CITI SMALL LETTER A",
	"WARANG CITI SMALL LETTER WI",
	"WARANG CITI SMALL LETTER YU",
	"WARANG CITI SMALL LETTER YA",
	"WARANG CITI SMALL LETTER YO",
	"WARANG CITI SMALL LETTER II",
	"WARANG CITI SMALL LETTER UU",
	"WARANG CITI SMALL LETTER E",
	"WARANG CITI SMALL LETTER O",
	"WARANG CITI SMALL LETTER ANG",
	"WARANG CITI SMALL LETTER GA",
	"WARANG CITI SMALL LETTER KO",
	"WARANG CITI SMALL LETTER ENY",
	"WARANG CITI SMALL LETTER YUJ",
	"WARANG CITI SMALL LETTER UC",
	"WARANG CITI SMALL LETTER ENN",
	"WARANG CITI SMALL LETTER ODD",
	"WARANG CITI SMALL LETTER TTE",
	"WARANG CITI SMALL LETTER NUNG",
	"WARANG CITI SMALL LETTER DA",
	"WARANG CITI SMALL LETTER AT",
	"WARANG CITI SMALL LETTER AM",
	"WARANG CITI SMALL LETTER BU",
	"WARANG CITI SMALL LETTER PU",
	"WARANG CITI SMALL LETTER HIYO",
	"WARANG CITI SMALL LETTER HOLO",
	"WARANG CITI SMALL LETTER HORR",
	"WARANG CITI SMALL LETTER HAR",
	"WARANG CITI SMALL LETTER SSUU",
	"WARANG CITI SMALL LETTER SII",
	"WARANG CITI SMALL LETTER VIYO",
	"WARANG CITI DIGIT ZERO",
	"WARANG CITI DIGIT ONE",
	"WARANG CITI DIGIT TWO",
	"WARANG CITI DIGIT THREE",
	"WARANG CITI DIGIT FOUR",
	"WARANG CITI DIGIT FIVE",
	"WARANG CITI DIGIT SIX",
	"WARANG CITI DIGIT SEVEN",
	"WARANG CITI DIGIT EIGHT",
	"WARANG CITI DIGIT NINE",
	"WARANG CITI NUMBER TEN",
	"WARANG CITI NUMBER TWENTY",
	"WARANG CITI NUMBER THIRTY",
	"WARANG CITI NUMBER FORTY",
	"WARANG CITI NUMBER FIFTY",
	"WARANG CITI NUMBER SIXTY",
	"WARANG CITI NUMBER SEVENTY",
	"WARANG CITI NUMBER EIGHTY",
	"WARANG CITI NUMBER NINETY",
	"WARANG CITI OM",
	"DIVES AKURU LETTER A",
	"DIVES AKURU LETTER AA",
	"DIVES AKURU LETTER I",
	"DIVES AKURU LETTER II",
	"DIVES AKURU LETTER U",
	"DIVES AKURU LETTER UU",
	"DIVES AKURU LETTER E",
	"DIVES AKURU LETTER O",
	"DIVES AKURU LETTER KA",
	"DIVES AKURU LETTER KHA",
	"DIVES AKURU LETTER GA",
	"DIVES AKURU LETTER GHA",
	"DIVES AKURU LETTER NGA",
	"DIVES AKURU LETTER CA",
	"DIVES AKURU LETTER CHA",
	"DIVES AKURU LETTER JA",
	"DIVES AKURU LETTER NYA",
	"DIVES AKURU LETTER TTA",
	"DIVES AKURU LETTER DDA",
	"DIVES AKURU LETTER DDHA",
	"DIVES AKURU LETTER NNA",
	"DIVES AKURU LETTER TA",
	"DIVES AKURU LETTER THA",
	"DIVES AKURU LETTER DA",
	"DIVES AKURU LETTER DHA",
	"DIVES AKURU LETTER NA",
	"DIVES AKURU LETTER PA",
	"DIVES AKURU LETTER PHA",
	"DIVES AKURU LETTER BA",
	"DIVES AKURU LETTER BHA",
	"DIVES AKURU LETTER MA",
	"DIVES AKURU LETTER YA",
	"DIVES AKURU LETTER YYA",
	"DIVES AKURU LETTER RA",
	"DIVES AKURU LETTER LA",
	"DIVES AKURU LETTER VA",
	"DIVES AKURU LETTER SHA",
	"DIVES AKURU LETTER SSA",
	"DIVES AKURU LETTER SA",
	"DIVES AKURU LETTER HA",
	"DIVES AKURU LETTER LLA",
	"DIVES AKURU LETTER ZA",
	"DIVES AKURU VOWEL SIGN AA",
	"DIVES AKURU VOWEL SIGN I",
	"DIVES AKURU VOWEL SIGN II",
	"DIVES AKURU VOWEL SIGN U",
	"DIVES AKURU VOWEL SIGN UU",
	"DIVES AKURU VOWEL SIGN E",
	"DIVES AKURU VOWEL SIGN AI",
	"DIVES AKURU VOWEL SIGN O",
	"DIVES AKURU SIGN ANUSVARA",
	"DIVES AKURU SIGN CANDRABINDU",
	"DIVES AKURU SIGN HALANTA",
	"DIVES AKURU VIRAMA",
	"DIVES AKURU PREFIXED NASAL SIGN",
	"DIVES AKURU MEDIAL YA",
	"DIVES AKURU INITIAL RA",
	"DIVES AKURU MEDIAL RA",
	"DIVES AKURU SIGN NUKTA",
	"DIVES AKURU DOUBLE DANDA",
	"DIVES AKURU GAP FILLER",
	"DIVES AKURU END OF TEXT MARK",
	"DIVES AKURU DIGIT ZERO",
	"DIVES AKURU DIGIT ONE",
	"DIVES AKURU DIGIT TWO",
	"DIVES AKURU DIGIT THREE",
	"DIVES AKURU DIGIT FOUR",
	"DIVES AKURU DIGIT FIVE",
	"DIVES AKURU DIGIT SIX",
	"DIVES AKURU DIGIT SEVEN",
	"DIVES AKURU DIGIT EIGHT",
	"DIVES AKURU DIGIT NINE",
	"NANDINAGARI LETTER A",
	"NANDINAGARI LETTER AA",
	"NANDINAGARI LETTER I",
	"NANDINAGARI LETTER II",
	"NANDINAGARI LETTER U",
	"NANDINAGARI LETTER UU",
	"NANDINAGARI LETTER VOCALIC R",
	"NANDINAGARI LETTER VOCALIC RR",
	"NANDINAGARI LETTER E",
	"NANDINAGARI LETTER AI",
	"NANDINAGARI LETTER O",
	"NANDINAGARI LETTER AU",
	"NANDINAGARI LETTER KA",
	"NANDINAGARI LETTER KHA",
	"NANDINAGARI LETTER GA",
	"NANDINAGARI LETTER GHA",
	"NANDINAGARI LETTER NGA",
	"NANDINAGARI LETTER CA",
	"NANDINAGARI LETTER CHA",
	"NANDINAGARI LETTER JA",
	"NANDINAGARI LETTER JHA",
	"NANDINAGARI LETTER NYA",
	"NANDINAGARI LETTER TTA",
	"NANDINAGARI LETTER TTHA",
	"NANDINAGARI LETTER DDA",
	"NANDINAGARI LETTER DDHA",
	"NANDINAGARI LETTER NNA",
	"NANDINAGARI LETTER TA",
	"NANDINAGARI LETTER THA",
	"NANDINAGARI LETTER DA",
	"NANDINAGARI LETTER DHA",
	"NANDINAGARI LETTER NA",
	"NANDINAGARI LETTER PA",
	"NANDINAGARI LETTER PHA",
	"NANDINAGARI LETTER BA",
	"NANDINAGARI LETTER BHA",
	"NANDINAGARI LETTER MA",
	"NANDINAGARI LETTER YA",
	"NANDINAGARI LETTER RA",
	"NANDINAGARI LETTER LA",
	"NANDINAGARI LETTER VA",
	"NANDINAGARI LETTER SHA",
	"NANDINAGARI LETTER SSA",
	"NANDINAGARI LETTER SA",
	"NANDINAGARI LETTER HA",
	"NANDINAGARI LETTER LLA",
	"NANDINAGARI LETTER RRA",
	"NANDINAGARI VOWEL SIGN AA",
	"NANDINAGARI VOWEL SIGN I",
	"NANDINAGARI VOWEL SIGN II",
	"NANDINAGARI VOWEL SIGN U",
	"NANDINAGARI VOWEL SIGN UU",
	"NANDINAGARI VOWEL SIGN VOCALIC R",
	"NANDINAGARI VOWEL SIGN VOCALIC RR",
	"NANDINAGARI VOWEL SIGN E",
	"NANDINAGARI VOWEL SIGN AI",
	"NANDINAGARI VOWEL SIGN O",
	"NANDINAGARI VOWEL SIGN AU",
	"NANDINAGARI SIGN ANUSVARA",
	"NANDINAGARI SIGN VISARGA",
	"NANDINAGARI SIGN VIRAMA",
	"NANDINAGARI SIGN AVAGRAHA",
	"NANDINAGARI SIGN SIDDHAM",
	"NANDINAGARI HEADSTROKE",
	"NANDINAGARI VOWEL SIGN PRISHTHAMATRA E",
	"ZANABAZAR SQUARE LETTER A",
	"ZANABAZAR SQUARE VOWEL SIGN I",
	"ZANABAZAR SQUARE VOWEL SIGN UE",
	"ZANABAZAR SQUARE VOWEL SIGN U",
	"ZANABAZAR SQUARE VOWEL SIGN E",
	"ZANABAZAR SQUARE VOWEL SIGN OE",
	"ZANABAZAR SQUARE VOWEL SIGN O",
	"ZANABAZAR SQUARE VOWEL SIGN AI",
	"ZANABAZAR SQUARE VOWEL SIGN AU",
	"ZANABAZAR SQUARE VOWEL SIGN REVERSED I",
	"ZANABAZAR SQUARE VOWEL LENGTH MARK",
	"ZANABAZAR SQUARE LETTER KA",
	"ZANABAZAR SQUARE LETTER KHA",
	"ZANABAZAR SQUARE LETTER GA",
	"ZANABAZAR SQUARE LETTER GHA",
	"ZANABAZAR SQUARE LETTER NGA",
	"ZANABAZAR SQUARE LETTER CA",
	"ZANABAZAR SQUARE LETTER CHA",
	"ZANABAZAR SQUARE LETTER JA",
	"ZANABAZAR SQUARE LETTER NYA",
	"ZANABAZAR SQUARE LETTER TTA",
	"ZANABAZAR SQUARE LETTER TTHA",
	"ZANABAZAR SQUARE LETTER DDA",
	"ZANABAZAR SQUARE LETTER DDHA",
	"ZANABAZAR SQUARE LETTER NNA",
	"ZANABAZAR SQUARE LETTER TA",
	"ZANABAZAR SQUARE LETTER THA",
	"ZANABAZAR SQUARE LETTER DA",
	"ZANABAZAR SQUARE LETTER DHA",
	"ZANABAZAR SQUARE LETTER NA",
	"ZANABAZAR SQUARE LETTER PA",
	"ZANABAZAR SQUARE LETTER PHA",
	"ZANABAZAR SQUARE LETTER BA",
	"ZANABAZAR SQUARE LETTER BHA",
	"ZANABAZAR SQUARE LETTER MA",
	"ZANABAZAR SQUARE LETTER TSA",
	"ZANABAZAR SQUARE LETTER TSHA",
	"ZANABAZAR SQUARE LETTER DZA",
	"ZANABAZAR SQUARE LETTER DZHA",
	"ZANABAZAR SQUARE LETTER ZHA",
	"ZANABAZAR SQUARE LETTER ZA",
	"ZANABAZAR SQUARE LETTER -A",
	"ZANABAZAR SQUARE LETTER YA",
	"ZANABAZAR SQUARE LETTER RA",
	"ZANABAZAR SQUARE LETTER LA",
	"ZANABAZAR SQUARE LETTER VA",
	"ZANABAZAR SQUARE LETTER SHA",
	"ZANABAZAR SQUARE LETTER SSA",
	"ZANABAZAR SQUARE LETTER SA",
	"ZANABAZAR SQUARE LETTER HA",
	"ZANABAZAR SQUARE LETTER KSSA",
	"ZANABAZAR SQUARE FINAL CONSONANT MARK",
	"ZANABAZAR SQUARE SIGN VIRAMA",
	"ZANABAZAR SQUARE SIGN CANDRABINDU",
	"ZANABAZAR SQUARE SIGN CANDRABINDU WITH ORNAMENT",
	"ZANABAZAR SQUARE SIGN CANDRA WITH ORNAMENT",
	"ZANABAZAR SQUARE SIGN ANUSVARA",
	"ZANABAZAR SQUARE SIGN VISARGA",
	"ZANABAZAR SQUARE CLUSTER-INITIAL LETTER RA",
	"ZANABAZAR SQUARE CLUSTER-FINAL LETTER YA",
	"ZANABAZAR SQUARE CLUSTER-FINAL LETTER RA",
	"ZANABAZAR SQUARE CLUSTER-FINAL LETTER LA",
	"ZANABAZAR SQUARE CLUSTER-FINAL LETTER VA",
	"ZANABAZAR SQUARE INITIAL HEAD MARK",
	"ZANABAZAR SQUARE CLOSING HEAD MARK",
	"ZANABAZAR SQUARE MARK TSHEG",
	"ZANABAZAR SQUARE MARK SHAD",
	"ZANABAZAR SQUARE MARK DOUBLE SHAD",
	"ZANABAZAR SQUARE MARK LONG TSHEG",
	"ZANABAZAR SQUARE INITIAL DOUBLE-LINED HEAD MARK",
	"ZANABAZAR SQUARE CLOSING DOUBLE-LINED HEAD MARK",
	"ZANABAZAR SQUARE SUBJOINER",
	"SOYOMBO LETTER A",
	"SOYOMBO VOWEL SIGN I",
	"SOYOMBO VOWEL SIGN UE",
	"SOYOMBO VOWEL SIGN U",
	"SOYOMBO VOWEL SIGN E",
	"SOYOMBO VOWEL SIGN O",
	"SOYOMBO VOWEL SIGN OE",
	"SOYOMBO VOWEL SIGN AI",
	"SOYOMBO VOWEL SIGN AU",
	"SOYOMBO VOWEL SIGN VOCALIC R",
	"SOYOMBO VOWEL SIGN VOCALIC L",
	"SOYOMBO VOWEL LENGTH MARK",
	"SOYOMBO LETTER KA",
	"SOYOMBO LETTER KHA",
	"SOYOMBO LETTER GA",
	"SOYOMBO LETTER GHA",
	"SOYOMBO LETTER NGA",
	"SOYOMBO LETTER CA",
	"SOYOMBO LETTER CHA",
	"SOYOMBO LETTER JA",
	"SOYOMBO LETTER JHA",
	"SOYOMBO LETTER NYA",
	"SOYOMBO LETTER TTA",
	"SOYOMBO LETTER TTHA",
	"SOYOMBO LETTER DDA",
	"SOYOMBO LETTER DDHA",
	"SOYOMBO LETTER NNA",
	"SOYOMBO LETTER TA",
	"SOYOMBO LETTER THA",
	"SOYOMBO LETTER DA",
	"SOYOMBO LETTER DHA",
	"SOYOMBO LETTER NA",
	"SOYOMBO LETTER PA",
	"SOYOMBO LETTER PHA",
	"SOYOMBO LETTER BA",
	"SOYOMBO LETTER BHA",
	"SOYOMBO LETTER MA",
	"SOYOMBO LETTER TSA",
	"SOYOMBO LETTER TSHA",
	"SOYOMBO LETTER DZA",
	"SOYOMBO LETTER ZHA",
	"SOYOMBO LETTER ZA",
	"SOYOMBO LETTER -A",
	"SOYOMBO LETTER YA",
	"SOYOMBO LETTER RA",
	"SOYOMBO LETTER LA",
	"SOYOMBO LETTER VA",
	"SOYOMBO LETTER SHA",
	"SOYOMBO LETTER SSA",
	"SOYOMBO LETTER SA",
	"SOYOMBO LETTER HA",
	"SOYOMBO LETTER KSSA",
	"SOYOMBO SIGN JIHVAMULIYA",
	"SOYOMBO SIGN UPADHMANIYA",
	"SOYOMBO CLUSTER-INITIAL LETTER RA",
	"SOYOMBO CLUSTER-INITIAL LETTER LA",
	"SOYOMBO CLUSTER-INITIAL LETTER SHA",
	"SOYOMBO CLUSTER-INITIAL LETTER SA",
	"SOYOMBO FINAL CONSONANT SIGN G",
	"SOYOMBO FINAL CONSONANT SIGN K",
	"SOYOMBO FINAL CONSONANT SIGN NG",
	"SOYOMBO FINAL CONSONANT SIGN D",
	"SOYOMBO FINAL CONSONANT SIGN N",
	"SOYOMBO FINAL CONSONANT SIGN B",
	"SOYOMBO FINAL CONSONANT SIGN M",
	"SOYOMBO FINAL CONSONANT SIGN R",
	"SOYOMBO FINAL CONSONANT SIGN L",
	"SOYOMBO FINAL CONSONANT SIGN SH",
	"SOYOMBO FINAL CONSONANT SIGN S",
	"SOYOMBO FINAL CONSONANT SIGN -A",
	"SOYOMBO SIGN ANUSVARA",
	"SOYOMBO SIGN VISARGA",
	"SOYOMBO GEMINATION MARK",
	"SOYOMBO SUBJOINER",
	"SOYOMBO MARK TSHEG",
	"SOYOMBO MARK SHAD",
	"SOYOMBO MARK DOUBLE SHAD",
	"SOYOMBO MARK PLUTA",
	"SOYOMBO HEAD MARK WITH MOON AND SUN AND TRIPLE FLAME",
	"SOYOMBO HEAD MARK WITH MOON AND SUN AND FLAME",
	"SOYOMBO HEAD MARK WITH MOON AND SUN",
	"SOYOMBO TERMINAL MARK-1",
	"SOYOMBO TERMINAL MARK-2",
	"CANADIAN SYLLABICS NATTILIK HI",
	"CANADIAN SYLLABICS NATTILIK HII",
	"CANADIAN SYLLABICS NATTILIK HO",
	"CANADIAN SYLLABICS NATTILIK HOO",
	"CANADIAN SYLLABICS NATTILIK HA",
	"CANADIAN SYLLABICS NATTILIK HAA",
	"CANADIAN SYLLABICS NATTILIK SHRI",
	"CANADIAN SYLLABICS NATTILIK SHRII",
	"CANADIAN SYLLABICS NATTILIK SHRO",
	"CANADIAN SYLLABICS NATTILIK SHROO",
	"CANADIAN SYLLABICS NATTILIK SHRA",
	"CANADIAN SYLLABICS NATTILIK SHRAA",
	"CANADIAN SYLLABICS SPE",
	"CANADIAN SYLLABICS SPI",
	"CANADIAN SYLLABICS SPO",
	"CANADIAN SYLLABICS SPA",
	"PAU CIN HAU LETTER PA",
	"PAU CIN HAU LETTER KA",
	"PAU CIN HAU LETTER LA",
	"PAU CIN HAU LETTER MA",
	"PAU CIN HAU LETTER DA",
	"PAU CIN HAU LETTER ZA",
	"PAU CIN HAU LETTER VA",
	"PAU CIN HAU LETTER NGA",
	"PAU CIN HAU LETTER HA",
	"PAU CIN HAU LETTER GA",
	"PAU CIN HAU LETTER KHA",
	"PAU CIN HAU LETTER SA",
	"PAU CIN HAU LETTER BA",
	"PAU CIN HAU LETTER CA",
	"PAU CIN HAU LETTER TA",
	"PAU CIN HAU LETTER THA",
	"PAU CIN HAU LETTER NA",
	"PAU CIN HAU LETTER PHA",
	"PAU CIN HAU LETTER RA",
	"PAU CIN HAU LETTER FA",
	"PAU CIN HAU LETTER CHA",
	"PAU CIN HAU LETTER A",
	"PAU CIN HAU LETTER E",
	"PAU CIN HAU LETTER I",
	"PAU CIN HAU LETTER O",
	"PAU CIN HAU LETTER U",
	"PAU CIN HAU LETTER UA",
	"PAU CIN HAU LETTER IA",
	"PAU CIN HAU LETTER FINAL P",
	"PAU CIN HAU LETTER FINAL K",
	"PAU CIN HAU LETTER FINAL T",
	"PAU CIN HAU LETTER FINAL M",
	"PAU CIN HAU LETTER FINAL N",
	"PAU CIN HAU LETTER FINAL L",
	"PAU CIN HAU LETTER FINAL W",
	"PAU CIN HAU LETTER FINAL NG",
	"PAU CIN HAU LETTER FINAL Y",
	"PAU CIN HAU RISING TONE LONG",
	"PAU CIN HAU RISING TONE",
	"PAU CIN HAU SANDHI GLOTTAL STOP",
	"PAU CIN HAU RISING TONE LONG FINAL",
	"PAU CIN HAU RISING TONE FINAL",
	"PAU CIN HAU SANDHI GLOTTAL STOP FINAL",
	"PAU CIN HAU SANDHI TONE LONG",
	"PAU CIN HAU SANDHI TONE",
	"PAU CIN HAU SANDHI TONE LONG FINAL",
	"PAU CIN HAU SANDHI TONE FINAL",
	"PAU CIN HAU MID-LEVEL TONE",
	"PAU CIN HAU GLOTTAL STOP VARIANT",
	"PAU CIN HAU MID-LEVEL TONE LONG FINAL",
	"PAU CIN HAU MID-LEVEL TONE FINAL",
	"PAU CIN HAU LOW-FALLING TONE LONG",
	"PAU CIN HAU LOW-FALLING TONE",
	"PAU CIN HAU GLOTTAL STOP",
	"PAU CIN HAU LOW-FALLING TONE LONG FINAL",
	"PAU CIN HAU LOW-FALLING TONE FINAL",
	"PAU CIN HAU GLOTTAL STOP FINAL",
	"DEVANAGARI HEAD MARK",
	"DEVANAGARI HEAD MARK WITH HEADSTROKE",
	"DEVANAGARI SIGN BHALE",
	"DEVANAGARI SIGN BHALE WITH HOOK",
	"DEVANAGARI SIGN EXTENDED BHALE",
	"DEVANAGARI SIGN EXTENDED BHALE WITH HOOK",
	"DEVANAGARI SIGN WESTERN FIVE-LIKE BHALE",
	"DEVANAGARI SIGN WESTERN NINE-LIKE BHALE",
	"DEVANAGARI SIGN REVERSED NINE-LIKE BHALE",
	"DEVANAGARI SIGN MINDU",
	"BHAIKSUKI LETTER A",
	"BHAIKSUKI LETTER AA",
	"BHAIKSUKI LETTER I",
	"BHAIKSUKI LETTER II",
	"BHAIKSUKI LETTER U",
	"BHAIKSUKI LETTER UU",
	"BHAIKSUKI LETTER VOCALIC R",
	"BHAIKSUKI LETTER VOCALIC RR",
	"BHAIKSUKI LETTER VOCALIC L",
	"BHAIKSUKI LETTER E",
	"BHAIKSUKI LETTER AI",
	"BHAIKSUKI LETTER O",
	"BHAIKSUKI LETTER AU",
	"BHAIKSUKI LETTER KA",
	"BHAIKSUKI LETTER KHA",
	"BHAIKSUKI LETTER GA",
	"BHAIKSUKI LETTER GHA",
	"BHAIKSUKI LETTER NGA",
	"BHAIKSUKI LETTER CA",
	"BHAIKSUKI LETTER CHA",
	"BHAIKSUKI LETTER JA",
	"BHAIKSUKI LETTER JHA",
	"BHAIKSUKI LETTER NYA",
	"BHAIKSUKI LETTER TTA",
	"BHAIKSUKI LETTER TTHA",
	"BHAIKSUKI LETTER DDA",
	"BHAIKSUKI LETTER DDHA",
	"BHAIKSUKI LETTER NNA",
	"BHAIKSUKI LETTER TA",
	"BHAIKSUKI LETTER THA",
	"BHAIKSUKI LETTER DA",
	"BHAIKSUKI LETTER DHA",
	"BHAIKSUKI LETTER NA",
	"BHAIKSUKI LETTER PA",
	"BHAIKSUKI LETTER PHA",
	"BHAIKSUKI LETTER BA",
	"BHAIKSUKI LETTER BHA",
	"BHAIKSUKI LETTER MA",
	"BHAIKSUKI LETTER YA",
	"BHAIKSUKI LETTER RA",
	"BHAIKSUKI LETTER LA",
	"BHAIKSUKI LETTER VA",
	"BHAIKSUKI LETTER SHA",
	"BHAIKSUKI LETTER SSA",
	"BHAIKSUKI LETTER SA",
	"BHAIKSUKI LETTER HA",
	"BHAIKSUKI VOWEL SIGN AA",
	"BHAIKSUKI VOWEL SIGN I",
	"BHAIKSUKI VOWEL SIGN II",
	"BHAIKSUKI VOWEL SIGN U",
	"BHAIKSUKI VOWEL SIGN UU",
	"BHAIKSUKI VOWEL SIGN VOCALIC R",
	"BHAIKSUKI VOWEL SIGN VOCALIC RR",
	"BHAIKSUKI VOWEL SIGN VOCALIC L",
	"BHAIKSUKI VOWEL SIGN E",
	"BHAIKSUKI VOWEL SIGN AI",
	"BHAIKSUKI VOWEL SIGN O",
	"BHAIKSUKI VOWEL SIGN AU",
	"BHAIKSUKI SIGN CANDRABINDU",
	"BHAIKSUKI SIGN ANUSVARA",
	"BHAIKSUKI SIGN VISARGA",
	"BHAIKSUKI SIGN VIRAMA",
	"BHAIKSUKI SIGN AVAGRAHA",
	"BHAIKSUKI DANDA",
	"BHAIKSUKI DOUBLE DANDA",
	"BHAIKSUKI WORD SEPARATOR",
	"BHAIKSUKI GAP FILLER-1",
	"BHAIKSUKI GAP FILLER-2",
	"BHAIKSUKI DIGIT ZERO",
	"BHAIKSUKI DIGIT ONE",
	"BHAIKSUKI DIGIT TWO",
	"BHAIKSUKI DIGIT THREE",
	"BHAIKSUKI DIGIT FOUR",
	"BHAIKSUKI DIGIT FIVE",
	"BHAIKSUKI DIGIT SIX",
	"BHAIKSUKI DIGIT SEVEN",
	"BHAIKSUKI DIGIT EIGHT",
	"BHAIKSUKI DIGIT NINE",
	"BHAIKSUKI NUMBER ONE",
	"BHAIKSUKI NUMBER TWO",
	"BHAIKSUKI NUMBER THREE",
	"BHAIKSUKI NUMBER FOUR",
	"BHAIKSUKI NUMBER FIVE",
	"BHAIKSUKI NUMBER SIX",
	"BHAIKSUKI NUMBER SEVEN",
	"BHAIKSUKI NUMBER EIGHT",
	"BHAIKSUKI NUMBER NINE",
	"BHAIKSUKI NUMBER TEN",
	"BHAIKSUKI NUMBER TWENTY",
	"BHAIKSUKI NUMBER THIRTY",
	"BHAIKSUKI NUMBER FORTY",
	"BHAIKSUKI NUMBER FIFTY",
	"BHAIKSUKI NUMBER SIXTY",
	"BHAIKSUKI NUMBER SEVENTY",
	"BHAIKSUKI NUMBER EIGHTY",
	"BHAIKSUKI NUMBER NINETY",
	"BHAIKSUKI HUNDREDS UNIT MARK",
	"MARCHEN HEAD MARK",
	"MARCHEN MARK SHAD",
	"MARCHEN LETTER KA",
	"MARCHEN LETTER KHA",
	"MARCHEN LETTER GA",
	"MARCHEN LETTER NGA",
	"MARCHEN LETTER CA",
	"MARCHEN LETTER CHA",
	"MARCHEN LETTER JA",
	"MARCHEN LETTER NYA",
	"MARCHEN LETTER TA",
	"MARCHEN LETTER THA",
	"MARCHEN LETTER DA",
	"MARCHEN LETTER NA",
	"MARCHEN LETTER PA",
	"MARCHEN LETTER PHA",
	"MARCHEN LETTER BA",
	"MARCHEN LETTER MA",
	"MARCHEN LETTER TSA",
	"MARCHEN LETTER TSHA",
	"MARCHEN LETTER DZA",
	"MARCHEN LETTER WA",
	"MARCHEN LETTER ZHA",
	"MARCHEN LETTER ZA",
	"MARCHEN LETTER -A",
	"MARCHEN LETTER YA",
	"MARCHEN LETTER RA",
	"MARCHEN LETTER LA",
	"MARCHEN LETTER SHA",
	"MARCHEN LETTER SA",
	"MARCHEN LETTER HA",
	"MARCHEN LETTER A",
	"MARCHEN SUBJOINED LETTER KA",
	"MARCHEN SUBJOINED LETTER KHA",
	"MARCHEN SUBJOINED LETTER GA",
	"MARCHEN SUBJOINED LETTER NGA",
	"MARCHEN SUBJOINED LETTER CA",
	"MARCHEN SUBJOINED LETTER CHA",
	"MARCHEN SUBJOINED LETTER JA",
	"MARCHEN SUBJOINED LETTER NYA",
	"MARCHEN SUBJOINED LETTER TA",
	"MARCHEN SUBJOINED LETTER THA",
	"MARCHEN SUBJOINED LETTER DA",
	"MARCHEN SUBJOINED LETTER NA",
	"MARCHEN SUBJOINED LETTER PA",
	"MARCHEN SUBJOINED LETTER PHA",
	"MARCHEN SUBJOINED LETTER BA",
	"MARCHEN SUBJOINED LETTER MA",
	"MARCHEN SUBJOINED LETTER TSA",
	"MARCHEN SUBJOINED LETTER TSHA",
	"MARCHEN SUBJOINED LETTER DZA",
	"MARCHEN SUBJOINED LETTER WA",
	"MARCHEN SUBJOINED LETTER ZHA",
	"MARCHEN SUBJOINED LETTER ZA",
	"MARCHEN SUBJOINED LETTER YA",
	"MARCHEN SUBJOINED LETTER RA",
	"MARCHEN SUBJOINED LETTER LA",
	"MARCHEN SUBJOINED LETTER SHA",
	"MARCHEN SUBJOINED LETTER SA",
	"MARCHEN SUBJOINED LETTER HA",
	"MARCHEN SUBJOINED LETTER A",
	"MARCHEN VOWEL SIGN AA",
	"MARCHEN VOWEL SIGN I",
	"MARCHEN VOWEL SIGN U",
	"MARCHEN VOWEL SIGN E",
	"MARCHEN VOWEL SIGN O",
	"MARCHEN SIGN ANUSVARA",
	"MARCHEN SIGN CANDRABINDU",
	"MASARAM GONDI LETTER A",
	"MASARAM GONDI LETTER AA",
	"MASARAM GONDI LETTER I",
	"MASARAM GONDI LETTER II",
	"MASARAM GONDI LETTER U",
	"MASARAM GONDI LETTER UU",
	"MASARAM GONDI LETTER E",
	"MASARAM GONDI LETTER AI",
	"MASARAM GONDI LETTER O",
	"MASARAM GONDI LETTER AU",
	"MASARAM GONDI LETTER KA",
	"MASARAM GONDI LETTER KHA",
	"MASARAM GONDI LETTER GA",
	"MASARAM GONDI LETTER GHA",
	"MASARAM GONDI LETTER NGA",
	"MASARAM GONDI LETTER CA",
	"MASARAM GONDI LETTER CHA",
	"MASARAM GONDI LETTER JA",
	"MASARAM GONDI LETTER JHA",
	"MASARAM GONDI LETTER NYA",
	"MASARAM GONDI LETTER TTA",
	"MASARAM GONDI LETTER TTHA",
	"MASARAM GONDI LETTER DDA",
	"MASARAM GONDI LETTER DDHA",
	"MASARAM GONDI LETTER NNA",
	"MASARAM GONDI LETTER TA",
	"MASARAM GONDI LETTER THA",
	"MASARAM GONDI LETTER DA",
	"MASARAM GONDI LETTER DHA",
	"MASARAM GONDI LETTER NA",
	"MASARAM GONDI LETTER PA",
	"MASARAM GONDI LETTER PHA",
	"MASARAM GONDI LETTER BA",
	"MASARAM GONDI LETTER BHA",
	"MASARAM GONDI LETTER MA",
	"MASARAM GONDI LETTER YA",
	"MASARAM GONDI LETTER RA",
	"MASARAM GONDI LETTER LA",
	"MASARAM GONDI LETTER VA",
	"MASARAM GONDI LETTER SHA",
	"MASARAM GONDI LETTER SSA",
	"MASARAM GONDI LETTER SA",
	"MASARAM GONDI LETTER HA",
	"MASARAM GONDI LETTER LLA",
	"MASARAM GONDI LETTER KSSA",
	"MASARAM GONDI LETTER JNYA",
	"MASARAM GONDI LETTER TRA",
	"MASARAM GONDI VOWEL SIGN AA",
	"MASARAM GONDI VOWEL SIGN I",
	"MASARAM GONDI VOWEL SIGN II",
	"MASARAM GONDI VOWEL SIGN U",
	"MASARAM GONDI VOWEL SIGN UU",
	"MASARAM GONDI VOWEL SIGN VOCALIC R",
	"MASARAM GONDI VOWEL SIGN E",
	"MASARAM GONDI VOWEL SIGN AI",
	"MASARAM GONDI VOWEL SIGN O",
	"MASARAM GONDI VOWEL SIGN AU",
	"MASARAM GONDI SIGN ANUSVARA",
	"MASARAM GONDI SIGN VISARGA",
	"MASARAM GONDI SIGN NUKTA",
	"MASARAM GONDI SIGN CANDRA",
	"MASARAM GONDI SIGN HALANTA",
	"MASARAM GONDI VIRAMA",
	"MASARAM GONDI REPHA",
	"MASARAM GONDI RA-KARA",
	"MASARAM GONDI DIGIT ZERO",
	"MASARAM GONDI DIGIT ONE",
	"MASARAM GONDI DIGIT TWO",
	"MASARAM GONDI DIGIT THREE",
	"MASARAM GONDI DIGIT FOUR",
	"MASARAM GONDI DIGIT FIVE",
	"MASARAM GONDI DIGIT SIX",
	"MASARAM GONDI DIGIT SEVEN",
	"MASARAM GONDI DIGIT EIGHT",
	"MASARAM GONDI DIGIT NINE",
	"GUNJALA GONDI LETTER A",
	"GUNJALA GONDI LETTER AA",
	"GUNJALA GONDI LETTER I",
	"GUNJALA GONDI LETTER II",
	"GUNJALA GONDI LETTER U",
	"GUNJALA GONDI LETTER UU",
	"GUNJALA GONDI LETTER EE",
	"GUNJALA GONDI LETTER AI",
	"GUNJALA GONDI LETTER OO",
	"GUNJALA GONDI LETTER AU",
	"GUNJALA GONDI LETTER YA",
	"GUNJALA GONDI LETTER VA",
	"GUNJALA GONDI LETTER BA",
	"GUNJALA GONDI LETTER BHA",
	"GUNJALA GONDI LETTER MA",
	"GUNJALA GONDI LETTER KA",
	"GUNJALA GONDI LETTER KHA",
	"GUNJALA GONDI LETTER TA",
	"GUNJALA GONDI LETTER THA",
	"GUNJALA GONDI LETTER LA",
	"GUNJALA GONDI LETTER GA",
	"GUNJALA GONDI LETTER GHA",
	"GUNJALA GONDI LETTER DA",
	"GUNJALA GONDI LETTER DHA",
	"GUNJALA GONDI LETTER NA",
	"GUNJALA GONDI LETTER CA",
	"GUNJALA GONDI LETTER CHA",
	"GUNJALA GONDI LETTER TTA",
	"GUNJALA GONDI LETTER TTHA",
	"GUNJALA GONDI LETTER LLA",
	"GUNJALA GONDI LETTER JA",
	"GUNJALA GONDI LETTER JHA",
	"GUNJALA GONDI LETTER DDA",
	"GUNJALA GONDI LETTER DDHA",
	"GUNJALA GONDI LETTER NGA",
	"GUNJALA GONDI LETTER PA",
	"GUNJALA GONDI LETTER PHA",
	"GUNJALA GONDI LETTER HA",
	"GUNJALA GONDI LETTER RA",
	"GUNJALA GONDI LETTER SA",
	"GUNJALA GONDI VOWEL SIGN AA",
	"GUNJALA GONDI VOWEL SIGN I",
	"GUNJALA GONDI VOWEL SIGN II",
	"GUNJALA GONDI VOWEL SIGN U",
	"GUNJALA GONDI VOWEL SIGN UU",
	"GUNJALA GONDI VOWEL SIGN EE",
	"GUNJALA GONDI VOWEL SIGN AI",
	"GUNJALA GONDI VOWEL SIGN OO",
	"GUNJALA GONDI VOWEL SIGN AU",
	"GUNJALA GONDI SIGN ANUSVARA",
	"GUNJALA GONDI SIGN VISARGA",
	"GUNJALA GONDI VIRAMA",
	"GUNJALA GONDI OM",
	"GUNJALA GONDI DIGIT ZERO",
	"GUNJALA GONDI DIGIT ONE",
	"GUNJALA GONDI DIGIT TWO",
	"GUNJALA GONDI DIGIT THREE",
	"GUNJALA GONDI DIGIT FOUR",
	"GUNJALA GONDI DIGIT FIVE",
	"GUNJALA GONDI DIGIT SIX",
	"GUNJALA GONDI DIGIT SEVEN",
	"GUNJALA GONDI DIGIT EIGHT",
	"GUNJALA GONDI DIGIT NINE",
	"MAKASAR LETTER KA",
	"MAKASAR LETTER GA",
	"MAKASAR LETTER NGA",
	"MAKASAR LETTER PA",
	"MAKASAR LETTER BA",
	"MAKASAR LETTER MA",
	"MAKASAR LETTER TA",
	"MAKASAR LETTER DA",
	"MAKASAR LETTER NA",
	"MAKASAR LETTER CA",
	"MAKASAR LETTER JA",
	"MAKASAR LETTER NYA",
	"MAKASAR LETTER YA",
	"MAKASAR LETTER RA",
	"MAKASAR LETTER LA",
	"MAKASAR LETTER VA",
	"MAKASAR LETTER SA",
	"MAKASAR LETTER A",
	"MAKASAR ANGKA",
	"MAKASAR VOWEL SIGN I",
	"MAKASAR VOWEL SIGN U",
	"MAKASAR VOWEL SIGN E",
	"MAKASAR VOWEL SIGN O",
	"MAKASAR PASSIMBANG",
	"MAKASAR END OF SECTION",
	"KAWI SIGN CANDRABINDU",
	"KAWI SIGN ANUSVARA",
	"KAWI SIGN REPHA",
	"KAWI SIGN VISARGA",
	"KAWI LETTER A",
	"KAWI LETTER AA",
	"KAWI LETTER I",
	"KAWI LETTER II",
	"KAWI LETTER U",
	"KAWI LETTER UU",
	"KAWI LETTER VOCALIC R",
	"KAWI LETTER VOCALIC RR",
	"KAWI LETTER VOCALIC L",
	"KAWI LETTER VOCALIC LL",
	"KAWI LETTER E",
	"KAWI LETTER AI",
	"KAWI LETTER O",
	"KAWI LETTER KA",
	"KAWI LETTER KHA",
	"KAWI LETTER GA",
	"KAWI LETTER GHA",
	"KAWI LETTER NGA",
	"KAWI LETTER CA",
	"KAWI LETTER CHA",
	"KAWI LETTER JA",
	"KAWI LETTER JHA",
	"KAWI LETTER NYA",
	"KAWI LETTER TTA",
	"KAWI LETTER TTHA",
	"KAWI LETTER DDA",
	"KAWI LETTER DDHA",
	"KAWI LETTER NNA",
	"KAWI LETTER TA",
	"KAWI LETTER THA",
	"KAWI LETTER DA",
	"KAWI LETTER DHA",
	"KAWI LETTER NA",
	"KAWI LETTER PA",
	"KAWI LETTER PHA",
	"KAWI LETTER BA",
	"KAWI LETTER BHA",
	"KAWI LETTER MA",
	"KAWI LETTER YA",
	"KAWI LETTER RA",
	"KAWI LETTER LA",
	"KAWI LETTER WA",
	"KAWI LETTER SHA",
	"KAWI LETTER SSA",
	"KAWI LETTER SA",
	"KAWI LETTER HA",
	"KAWI LETTER JNYA",
	"KAWI VOWEL SIGN AA",
	"KAWI VOWEL SIGN ALTERNATE AA",
	"KAWI VOWEL SIGN I",
	"KAWI VOWEL SIGN II",
	"KAWI VOWEL SIGN U",
	"KAWI VOWEL SIGN UU",
	"KAWI VOWEL SIGN VOCALIC R",
	"KAWI VOWEL SIGN E",
	"KAWI VOWEL SIGN AI",
	"KAWI VOWEL SIGN EU",
	"KAWI SIGN KILLER",
	"KAWI CONJOINER",
	"KAWI DANDA",
	"KAWI DOUBLE DANDA",
	"KAWI PUNCTUATION SECTION MARKER",
	"KAWI PUNCTUATION ALTERNATE SECTION MARKER",
	"KAWI PUNCTUATION FLOWER",
	"KAWI PUNCTUATION SPACE FILLER",
	"KAWI PUNCTUATION DOT",
	"KAWI PUNCTUATION DOUBLE DOT",
	"KAWI PUNCTUATION TRIPLE DOT",
	"KAWI PUNCTUATION CIRCLE",
	"KAWI PUNCTUATION FILLED CIRCLE",
	"KAWI PUNCTUATION SPIRAL",
	"KAWI PUNCTUATION CLOSING SPIRAL",
	"KAWI DIGIT ZERO",
	"KAWI DIGIT ONE",
	"KAWI DIGIT TWO",
	"KAWI DIGIT THREE",
	"KAWI DIGIT FOUR",
	"KAWI DIGIT FIVE",
	"KAWI DIGIT SIX",
	"KAWI DIGIT SEVEN",
	"KAWI DIGIT EIGHT",
	"KAWI DIGIT NINE",
	"LISU LETTER YHA",
	"TAMIL FRACTION ONE THREE-HUNDRED-AND-TWENTIETH",
	"TAMIL FRACTION ONE ONE-HUNDRED-AND-SIXTIETH",
	"TAMIL FRACTION ONE EIGHTIETH",
	"TAMIL FRACTION ONE SIXTY-FOURTH",
	"TAMIL FRACTION ONE FORTIETH",
	"TAMIL FRACTION ONE THIRTY-SECOND",
	"TAMIL FRACTION THREE EIGHTIETHS",
	"TAMIL FRACTION THREE SIXTY-FOURTHS",
	"TAMIL FRACTION ONE TWENTIETH",
	"TAMIL FRACTION ONE SIXTEENTH-1",
	"TAMIL FRACTION ONE SIXTEENTH-2",
	"TAMIL FRACTION ONE TENTH",
	"TAMIL FRACTION ONE EIGHTH",
	"TAMIL FRACTION THREE TWENTIETHS",
	"TAMIL FRACTION THREE SIXTEENTHS",
	"TAMIL FRACTION ONE FIFTH",
	"TAMIL FRACTION ONE QUARTER",
	"TAMIL FRACTION ONE HALF-1",
	"TAMIL FRACTION ONE HALF-2",
	"TAMIL FRACTION THREE QUARTERS",
	"TAMIL FRACTION DOWNSCALING FACTOR KIIZH",
	"TAMIL SIGN NEL",
	"TAMIL SIGN CEVITU",
	"TAMIL SIGN AAZHAAKKU",
	"TAMIL SIGN UZHAKKU",
	"TAMIL SIGN MUUVUZHAKKU",
	"TAMIL SIGN KURUNI",
	"TAMIL SIGN PATHAKKU",
	"TAMIL SIGN MUKKURUNI",
	"TAMIL SIGN KAACU",
	"TAMIL SIGN PANAM",
	"TAMIL SIGN PON",
	"TAMIL SIGN VARAAKAN",
	"TAMIL SIGN PAARAM",
	"TAMIL SIGN KUZHI",
	"TAMIL SIGN VELI",
	"TAMIL WET CULTIVATION SIGN",
	"TAMIL DRY CULTIVATION SIGN",
	"TAMIL LAND SIGN",
	"TAMIL SALT PAN SIGN",
	"TAMIL TRADITIONAL CREDIT SIGN",
	"TAMIL TRADITIONAL NUMBER SIGN",
	"TAMIL CURRENT SIGN",
	"TAMIL AND ODD SIGN",
	"TAMIL SPENT SIGN",
	"TAMIL TOTAL SIGN",
	"TAMIL IN POSSESSION SIGN",
	"TAMIL STARTING FROM SIGN",
	"TAMIL SIGN MUTHALIYA",
	"TAMIL SIGN VAKAIYARAA",
	"TAMIL PUNCTUATION END OF TEXT",
	"CUNEIFORM SIGN A",
	"CUNEIFORM SIGN A TIMES A",
	"CUNEIFORM SIGN A TIMES BAD",
	"CUNEIFORM SIGN A TIMES GAN2 TENU",
	"CUNEIFORM SIGN A TIMES HA",
	"CUNEIFORM SIGN A TIMES IGI",
	"CUNEIFORM SIGN A TIMES LAGAR GUNU",
	"CUNEIFORM SIGN A TIMES MUSH",
	"CUNEIFORM SIGN A TIMES SAG",
	"CUNEIFORM SIGN A2",
	"CUNEIFORM SIGN AB",
	"CUNEIFORM SIGN AB TIMES ASH2",
	"CUNEIFORM SIGN AB TIMES DUN3 GUNU",
	"CUNEIFORM SIGN AB TIMES GAL",
	"CUNEIFORM SIGN AB TIMES GAN2 TENU",
	"CUNEIFORM SIGN AB TIMES HA",
	"CUNEIFORM SIGN AB TIMES IGI GUNU",
	"CUNEIFORM SIGN AB TIMES IMIN",
	"CUNEIFORM SIGN AB TIMES LAGAB",
	"CUNEIFORM SIGN AB TIMES SHESH",
	"CUNEIFORM SIGN AB TIMES U PLUS U PLUS U",
	"CUNEIFORM SIGN AB GUNU",
	"CUNEIFORM SIGN AB2",
	"CUNEIFORM SIGN AB2 TIMES BALAG",
	"CUNEIFORM SIGN AB2 TIMES GAN2 TENU",
	"CUNEIFORM SIGN AB2 TIMES ME PLUS EN",
	"CUNEIFORM SIGN AB2 TIMES SHA3",
	"CUNEIFORM SIGN AB2 TIMES TAK4",
	"CUNEIFORM SIGN AD",
	"CUNEIFORM SIGN AK",
	"CUNEIFORM SIGN AK TIMES ERIN2",
	"CUNEIFORM SIGN AK TIMES SHITA PLUS GISH",
	"CUNEIFORM SIGN AL",
	"CUNEIFORM SIGN AL TIMES AL",
	"CUNEIFORM SIGN AL TIMES DIM2",
	"CUNEIFORM SIGN AL TIMES GISH",
	"CUNEIFORM SIGN AL TIMES HA",
	"CUNEIFORM SIGN AL TIMES KAD3",
	"CUNEIFORM SIGN AL TIMES KI",
	"CUNEIFORM SIGN AL TIMES SHE",
	"CUNEIFORM SIGN AL TIMES USH",
	"CUNEIFORM SIGN ALAN",
	"CUNEIFORM SIGN ALEPH",
	"CUNEIFORM SIGN AMAR",
	"CUNEIFORM SIGN AMAR TIMES SHE",
	"CUNEIFORM SIGN AN",
	"CUNEIFORM SIGN AN OVER AN",
	"CUNEIFORM SIGN AN THREE TIMES",
	"CUNEIFORM SIGN AN PLUS NAGA OPPOSING AN PLUS NAGA",
	"CUNEIFORM SIGN AN PLUS NAGA SQUARED",
	"CUNEIFORM SIGN ANSHE",
	"CUNEIFORM SIGN APIN",
	"CUNEIFORM SIGN ARAD",
	"CUNEIFORM SIGN ARAD TIMES KUR",
	"CUNEIFORM SIGN ARKAB",
	"CUNEIFORM SIGN ASAL2",
	"CUNEIFORM SIGN ASH",
	"CUNEIFORM SIGN ASH ZIDA TENU",
	"CUNEIFORM SIGN ASH KABA TENU",
	"CUNEIFORM SIGN ASH OVER ASH TUG2 OVER TUG2 TUG2 OVER TUG2 PAP",
	"CUNEIFORM SIGN ASH OVER ASH OVER ASH",
	"CUNEIFORM SIGN ASH OVER ASH OVER ASH CROSSING ASH OVER ASH OVER ASH",
	"CUNEIFORM SIGN ASH2",
	"CUNEIFORM SIGN ASHGAB",
	"CUNEIFORM SIGN BA",
	"CUNEIFORM SIGN BAD",
	"CUNEIFORM SIGN BAG3",
	"CUNEIFORM SIGN BAHAR2",
	"CUNEIFORM SIGN BAL",
	"CUNEIFORM SIGN BAL OVER BAL",
	"CUNEIFORM SIGN BALAG",
	"CUNEIFORM SIGN BAR",
	"CUNEIFORM SIGN BARA2",
	"CUNEIFORM SIGN BI",
	"CUNEIFORM SIGN BI TIMES A",
	"CUNEIFORM SIGN BI TIMES GAR",
	"CUNEIFORM SIGN BI TIMES IGI GUNU",
	"CUNEIFORM SIGN BU",
	"CUNEIFORM SIGN BU OVER BU AB",
	"CUNEIFORM SIGN BU OVER BU UN",
	"CUNEIFORM SIGN BU CROSSING BU",
	"CUNEIFORM SIGN BULUG",
	"CUNEIFORM SIGN BULUG OVER BULUG",
	"CUNEIFORM SIGN BUR",
	"CUNEIFORM SIGN BUR2",
	"CUNEIFORM SIGN DA",
	"CUNEIFORM SIGN DAG",
	"CUNEIFORM SIGN DAG KISIM5 TIMES A PLUS MASH",
	"CUNEIFORM SIGN DAG KISIM5 TIMES AMAR",
	"CUNEIFORM SIGN DAG KISIM5 TIMES BALAG",
	"CUNEIFORM SIGN DAG KISIM5 TIMES BI",
	"CUNEIFORM SIGN DAG KISIM5 TIMES GA",
	"CUNEIFORM SIGN DAG KISIM5 TIMES GA PLUS MASH",
	"CUNEIFORM SIGN DAG KISIM5 TIMES GI",
	"CUNEIFORM SIGN DAG KISIM5 TIMES GIR2",
	"CUNEIFORM SIGN DAG KISIM5 TIMES GUD",
	"CUNEIFORM SIGN DAG KISIM5 TIMES HA",
	"CUNEIFORM SIGN DAG KISIM5 TIMES IR",
	"CUNEIFORM SIGN DAG KISIM5 TIMES IR PLUS LU",
	"CUNEIFORM SIGN DAG KISIM5 TIMES KAK",
	"CUNEIFORM SIGN DAG KISIM5 TIMES LA",
	"CUNEIFORM SIGN DAG KISIM5 TIMES LU",
	"CUNEIFORM SIGN DAG KISIM5 TIMES LU PLUS MASH2",
	"CUNEIFORM SIGN DAG KISIM5 TIMES LUM",
	"CUNEIFORM SIGN DAG KISIM5 TIMES NE",
	"CUNEIFORM SIGN DAG KISIM5 TIMES PAP PLUS PAP",
	"CUNEIFORM SIGN DAG KISIM5 TIMES SI",
	"CUNEIFORM SIGN DAG KISIM5 TIMES TAK4",
	"CUNEIFORM SIGN DAG KISIM5 TIMES U2 PLUS GIR2",
	"CUNEIFORM SIGN DAG KISIM5 TIMES USH",
	"CUNEIFORM SIGN DAM",
	"CUNEIFORM SIGN DAR",
	"CUNEIFORM SIGN DARA3",
	"CUNEIFORM SIGN DARA4",
	"CUNEIFORM SIGN DI",
	"CUNEIFORM SIGN DIB",
	"CUNEIFORM SIGN DIM",
	"CUNEIFORM SIGN DIM TIMES SHE",
	"CUNEIFORM SIGN DIM2",
	"CUNEIFORM SIGN DIN",
	"CUNEIFORM SIGN DIN KASKAL U GUNU DISH",
	"CUNEIFORM SIGN DISH",
	"CUNEIFORM SIGN DU",
	"CUNEIFORM SIGN DU OVER DU",
	"CUNEIFORM SIGN DU GUNU",
	"CUNEIFORM SIGN DU SHESHIG",
	"CUNEIFORM SIGN DUB",
	"CUNEIFORM SIGN DUB TIMES ESH2",
	"CUNEIFORM SIGN DUB2",
	"CUNEIFORM SIGN DUG",
	"CUNEIFORM SIGN DUGUD",
	"CUNEIFORM SIGN DUH",
	"CUNEIFORM SIGN DUN",
	"CUNEIFORM SIGN DUN3",
	"CUNEIFORM SIGN DUN3 GUNU",
	"CUNEIFORM SIGN DUN3 GUNU GUNU",
	"CUNEIFORM SIGN DUN4",
	"CUNEIFORM SIGN DUR2",
	"CUNEIFORM SIGN E",
	"CUNEIFORM SIGN E TIMES PAP",
	"CUNEIFORM SIGN E OVER E NUN OVER NUN",
	"CUNEIFORM SIGN E2",
	"CUNEIFORM SIGN E2 TIMES A PLUS HA PLUS DA",
	"CUNEIFORM SIGN E2 TIMES GAR",
	"CUNEIFORM SIGN E2 TIMES MI",
	"CUNEIFORM SIGN E2 TIMES SAL",
	"CUNEIFORM SIGN E2 TIMES SHE",
	"CUNEIFORM SIGN E2 TIMES U",
	"CUNEIFORM SIGN EDIN",
	"CUNEIFORM SIGN EGIR",
	"CUNEIFORM SIGN EL",
	"CUNEIFORM SIGN EN",
	"CUNEIFORM SIGN EN TIMES GAN2",
	"CUNEIFORM SIGN EN TIMES GAN2 TENU",
	"CUNEIFORM SIGN EN TIMES ME",
	"CUNEIFORM SIGN EN CROSSING EN",
	"CUNEIFORM SIGN EN OPPOSING EN",
	"CUNEIFORM SIGN EN SQUARED",
	"CUNEIFORM SIGN EREN",
	"CUNEIFORM SIGN ERIN2",
	"CUNEIFORM SIGN ESH2",
	"CUNEIFORM SIGN EZEN",
	"CUNEIFORM SIGN EZEN TIMES A",
	"CUNEIFORM SIGN EZEN TIMES A PLUS LAL",
	"CUNEIFORM SIGN EZEN TIMES A PLUS LAL TIMES LAL",
	"CUNEIFORM SIGN EZEN TIMES AN",
	"CUNEIFORM SIGN EZEN TIMES BAD",
	"CUNEIFORM SIGN EZEN TIMES DUN3 GUNU",
	"CUNEIFORM SIGN EZEN TIMES DUN3 GUNU GUNU",
	"CUNEIFORM SIGN EZEN TIMES HA",
	"CUNEIFORM SIGN EZEN TIMES HA GUNU",
	"CUNEIFORM SIGN EZEN TIMES IGI GUNU",
	"CUNEIFORM SIGN EZEN TIMES KASKAL",
	"CUNEIFORM SIGN EZEN TIMES KASKAL SQUARED",
	"CUNEIFORM SIGN EZEN TIMES KU3",
	"CUNEIFORM SIGN EZEN TIMES LA",
	"CUNEIFORM SIGN EZEN TIMES LAL TIMES LAL",
	"CUNEIFORM SIGN EZEN TIMES LI",
	"CUNEIFORM SIGN EZEN TIMES LU",
	"CUNEIFORM SIGN EZEN TIMES U2",
	"CUNEIFORM SIGN EZEN TIMES UD",
	"CUNEIFORM SIGN GA",
	"CUNEIFORM SIGN GA GUNU",
	"CUNEIFORM SIGN GA2",
	"CUNEIFORM SIGN GA2 TIMES A PLUS DA PLUS HA",
	"CUNEIFORM SIGN GA2 TIMES A PLUS HA",
	"CUNEIFORM SIGN GA2 TIMES A PLUS IGI",
	"CUNEIFORM SIGN GA2 TIMES AB2 TENU PLUS TAB",
	"CUNEIFORM SIGN GA2 TIMES AN",
	"CUNEIFORM SIGN GA2 TIMES ASH",
	"CUNEIFORM SIGN GA2 TIMES ASH2 PLUS GAL",
	"CUNEIFORM SIGN GA2 TIMES BAD",
	"CUNEIFORM SIGN GA2 TIMES BAR PLUS RA",
	"CUNEIFORM SIGN GA2 TIMES BUR",
	"CUNEIFORM SIGN GA2 TIMES BUR PLUS RA",
	"CUNEIFORM SIGN GA2 TIMES DA",
	"CUNEIFORM SIGN GA2 TIMES DI",
	"CUNEIFORM SIGN GA2 TIMES DIM TIMES SHE",
	"CUNEIFORM SIGN GA2 TIMES DUB",
	"CUNEIFORM SIGN GA2 TIMES EL",
	"CUNEIFORM SIGN GA2 TIMES EL PLUS LA",
	"CUNEIFORM SIGN GA2 TIMES EN",
	"CUNEIFORM SIGN GA2 TIMES EN TIMES GAN2 TENU",
	"CUNEIFORM SIGN GA2 TIMES GAN2 TENU",
	"CUNEIFORM SIGN GA2 TIMES GAR",
	"CUNEIFORM SIGN GA2 TIMES GI",
	"CUNEIFORM SIGN GA2 TIMES GI4",
	"CUNEIFORM SIGN GA2 TIMES GI4 PLUS A",
	"CUNEIFORM SIGN GA2 TIMES GIR2 PLUS SU",
	"CUNEIFORM SIGN GA2 TIMES HA PLUS LU PLUS ESH2",
	"CUNEIFORM SIGN GA2 TIMES HAL",
	"CUNEIFORM SIGN GA2 TIMES HAL PLUS LA",
	"CUNEIFORM SIGN GA2 TIMES HI PLUS LI",
	"CUNEIFORM SIGN GA2 TIMES HUB2",
	"CUNEIFORM SIGN GA2 TIMES IGI GUNU",
	"CUNEIFORM SIGN GA2 TIMES ISH PLUS HU PLUS ASH",
	"CUNEIFORM SIGN GA2 TIMES KAK",
	"CUNEIFORM SIGN GA2 TIMES KASKAL",
	"CUNEIFORM SIGN GA2 TIMES KID",
	"CUNEIFORM SIGN GA2 TIMES KID PLUS LAL",
	"CUNEIFORM SIGN GA2 TIMES KU3 PLUS AN",
	"CUNEIFORM SIGN GA2 TIMES LA",
	"CUNEIFORM SIGN GA2 TIMES ME PLUS EN",
	"CUNEIFORM SIGN GA2 TIMES MI",
	"CUNEIFORM SIGN GA2 TIMES NUN",
	"CUNEIFORM SIGN GA2 TIMES NUN OVER NUN",
	"CUNEIFORM SIGN GA2 TIMES PA",
	"CUNEIFORM SIGN GA2 TIMES SAL",
	"CUNEIFORM SIGN GA2 TIMES SAR",
	"CUNEIFORM SIGN GA2 TIMES SHE",
	"CUNEIFORM SIGN GA2 TIMES SHE PLUS TUR",
	"CUNEIFORM SIGN GA2 TIMES SHID",
	"CUNEIFORM SIGN GA2 TIMES SUM",
	"CUNEIFORM SIGN GA2 TIMES TAK4",
	"CUNEIFORM SIGN GA2 TIMES U",
	"CUNEIFORM SIGN GA2 TIMES UD",
	"CUNEIFORM SIGN GA2 TIMES UD PLUS DU",
	"CUNEIFORM SIGN GA2 OVER GA2",
	"CUNEIFORM SIGN GABA",
	"CUNEIFORM SIGN GABA CROSSING GABA",
	"CUNEIFORM SIGN GAD",
	"CUNEIFORM SIGN GAD OVER GAD GAR OVER GAR",
	"CUNEIFORM SIGN GAL",
	"CUNEIFORM SIGN GAL GAD OVER GAD GAR OVER GAR",
	"CUNEIFORM SIGN GALAM",
	"CUNEIFORM SIGN GAM",
	"CUNEIFORM SIGN GAN",
	"CUNEIFORM SIGN GAN2",
	"CUNEIFORM SIGN GAN2 TENU",
	"CUNEIFORM SIGN GAN2 OVER GAN2",
	"CUNEIFORM SIGN GAN2 CROSSING GAN2",
	"CUNEIFORM SIGN GAR",
	"CUNEIFORM SIGN GAR3",
	"CUNEIFORM SIGN GASHAN",
	"CUNEIFORM SIGN GESHTIN",
	"CUNEIFORM SIGN GESHTIN TIMES KUR",
	"CUNEIFORM SIGN GI",
	"CUNEIFORM SIGN GI TIMES E",
	"CUNEIFORM SIGN GI TIMES U",
	"CUNEIFORM SIGN GI CROSSING GI",
	"CUNEIFORM SIGN GI4",
	"CUNEIFORM SIGN GI4 OVER GI4",
	"CUNEIFORM SIGN GI4 CROSSING GI4",
	"CUNEIFORM SIGN GIDIM",
	"CUNEIFORM SIGN GIR2",
	"CUNEIFORM SIGN GIR2 GUNU",
	"CUNEIFORM SIGN GIR3",
	"CUNEIFORM SIGN GIR3 TIMES A PLUS IGI",
	"CUNEIFORM SIGN GIR3 TIMES GAN2 TENU",
	"CUNEIFORM SIGN GIR3 TIMES IGI",
	"CUNEIFORM SIGN GIR3 TIMES LU PLUS IGI",
	"CUNEIFORM SIGN GIR3 TIMES PA",
	"CUNEIFORM SIGN GISAL",
	"CUNEIFORM SIGN GISH",
	"CUNEIFORM SIGN GISH CROSSING GISH",
	"CUNEIFORM SIGN GISH TIMES BAD",
	"CUNEIFORM SIGN GISH TIMES TAK4",
	"CUNEIFORM SIGN GISH TENU",
	"CUNEIFORM SIGN GU",
	"CUNEIFORM SIGN GU CROSSING GU",
	"CUNEIFORM SIGN GU2",
	"CUNEIFORM SIGN GU2 TIMES KAK",
	"CUNEIFORM SIGN GU2 TIMES KAK TIMES IGI GUNU",
	"CUNEIFORM SIGN GU2 TIMES NUN",
	"CUNEIFORM SIGN GU2 TIMES SAL PLUS TUG2",
	"CUNEIFORM SIGN GU2 GUNU",
	"CUNEIFORM SIGN GUD",
	"CUNEIFORM SIGN GUD TIMES A PLUS KUR",
	"CUNEIFORM SIGN GUD TIMES KUR",
	"CUNEIFORM SIGN GUD OVER GUD LUGAL",
	"CUNEIFORM SIGN GUL",
	"CUNEIFORM SIGN GUM",
	"CUNEIFORM SIGN GUM TIMES SHE",
	"CUNEIFORM SIGN GUR",
	"CUNEIFORM SIGN GUR7",
	"CUNEIFORM SIGN GURUN",
	"CUNEIFORM SIGN GURUSH",
	"CUNEIFORM SIGN HA",
	"CUNEIFORM SIGN HA TENU",
	"CUNEIFORM SIGN HA GUNU",
	"CUNEIFORM SIGN HAL",
	"CUNEIFORM SIGN HI",
	"CUNEIFORM SIGN HI TIMES ASH",
	"CUNEIFORM SIGN HI TIMES ASH2",
	"CUNEIFORM SIGN HI TIMES BAD",
	"CUNEIFORM SIGN HI TIMES DISH",
	"CUNEIFORM SIGN HI TIMES GAD",
	"CUNEIFORM SIGN HI TIMES KIN",
	"CUNEIFORM SIGN HI TIMES NUN",
	"CUNEIFORM SIGN HI TIMES SHE",
	"CUNEIFORM SIGN HI TIMES U",
	"CUNEIFORM SIGN HU",
	"CUNEIFORM SIGN HUB2",
	"CUNEIFORM SIGN HUB2 TIMES AN",
	"CUNEIFORM SIGN HUB2 TIMES HAL",
	"CUNEIFORM SIGN HUB2 TIMES KASKAL",
	"CUNEIFORM SIGN HUB2 TIMES LISH",
	"CUNEIFORM SIGN HUB2 TIMES UD",
	"CUNEIFORM SIGN HUL2",
	"CUNEIFORM SIGN I",
	"CUNEIFORM SIGN I A",
	"CUNEIFORM SIGN IB",
	"CUNEIFORM SIGN IDIM",
	"CUNEIFORM SIGN IDIM OVER IDIM BUR",
	"CUNEIFORM SIGN IDIM OVER IDIM SQUARED",
	"CUNEIFORM SIGN IG",
	"CUNEIFORM SIGN IGI",
	"CUNEIFORM SIGN IGI DIB",
	"CUNEIFORM SIGN IGI RI",
	"CUNEIFORM SIGN IGI OVER IGI SHIR OVER SHIR UD OVER UD",
	"CUNEIFORM SIGN IGI GUNU",
	"CUNEIFORM SIGN IL",
	"CUNEIFORM SIGN IL TIMES GAN2 TENU",
	"CUNEIFORM SIGN IL2",
	"CUNEIFORM SIGN IM",
	"CUNEIFORM SIGN IM TIMES TAK4",
	"CUNEIFORM SIGN IM CROSSING IM",
	"CUNEIFORM SIGN IM OPPOSING IM",
	"CUNEIFORM SIGN IM SQUARED",
	"CUNEIFORM SIGN IMIN",
	"CUNEIFORM SIGN IN",
	"CUNEIFORM SIGN IR",
	"CUNEIFORM SIGN ISH",
	"CUNEIFORM SIGN KA",
	"CUNEIFORM SIGN KA TIMES A",
	"CUNEIFORM SIGN KA TIMES AD",
	"CUNEIFORM SIGN KA TIMES AD PLUS KU3",
	"CUNEIFORM SIGN KA TIMES ASH2",
	"CUNEIFORM SIGN KA TIMES BAD",
	"CUNEIFORM SIGN KA TIMES BALAG",
	"CUNEIFORM SIGN KA TIMES BAR",
	"CUNEIFORM SIGN KA TIMES BI",
	"CUNEIFORM SIGN KA TIMES ERIN2",
	"CUNEIFORM SIGN KA TIMES ESH2",
	"CUNEIFORM SIGN KA TIMES GA",
	"CUNEIFORM SIGN KA TIMES GAL",
	"CUNEIFORM SIGN KA TIMES GAN2 TENU",
	"CUNEIFORM SIGN KA TIMES GAR",
	"CUNEIFORM SIGN KA TIMES GAR PLUS SHA3 PLUS A",
	"CUNEIFORM SIGN KA TIMES GI",
	"CUNEIFORM SIGN KA TIMES GIR2",
	"CUNEIFORM SIGN KA TIMES GISH PLUS SAR",
	"CUNEIFORM SIGN KA TIMES GISH CROSSING GISH",
	"CUNEIFORM SIGN KA TIMES GU",
	"CUNEIFORM SIGN KA TIMES GUR7",
	"CUNEIFORM SIGN KA TIMES IGI",
	"CUNEIFORM SIGN KA TIMES IM",
	"CUNEIFORM SIGN KA TIMES KAK",
	"CUNEIFORM SIGN KA TIMES KI",
	"CUNEIFORM SIGN KA TIMES KID",
	"CUNEIFORM SIGN KA TIMES LI",
	"CUNEIFORM SIGN KA TIMES LU",
	"CUNEIFORM SIGN KA TIMES ME",
	"CUNEIFORM SIGN KA TIMES ME PLUS DU",
	"CUNEIFORM SIGN KA TIMES ME PLUS GI",
	"CUNEIFORM SIGN KA TIMES ME PLUS TE",
	"CUNEIFORM SIGN KA TIMES MI",
	"CUNEIFORM SIGN KA TIMES MI PLUS NUNUZ",
	"CUNEIFORM SIGN KA TIMES NE",
	"CUNEIFORM SIGN KA TIMES NUN",
	"CUNEIFORM SIGN KA TIMES PI",
	"CUNEIFORM SIGN KA TIMES RU",
	"CUNEIFORM SIGN KA TIMES SA",
	"CUNEIFORM SIGN KA TIMES SAR",
	"CUNEIFORM SIGN KA TIMES SHA",
	"CUNEIFORM SIGN KA TIMES SHE",
	"CUNEIFORM SIGN KA TIMES SHID",
	"CUNEIFORM SIGN KA TIMES SHU",
	"CUNEIFORM SIGN KA TIMES SIG",
	"CUNEIFORM SIGN KA TIMES SUHUR",
	"CUNEIFORM SIGN KA TIMES TAR",
	"CUNEIFORM SIGN KA TIMES U",
	"CUNEIFORM SIGN KA TIMES U2",
	"CUNEIFORM SIGN KA TIMES UD",
	"CUNEIFORM SIGN KA TIMES UMUM TIMES PA",
	"CUNEIFORM SIGN KA TIMES USH",
	"CUNEIFORM SIGN KA TIMES ZI",
	"CUNEIFORM SIGN KA2",
	"CUNEIFORM SIGN KA2 CROSSING KA2",
	"CUNEIFORM SIGN KAB",
	"CUNEIFORM SIGN KAD2",
	"CUNEIFORM SIGN KAD3",
	"CUNEIFORM SIGN KAD4",
	"CUNEIFORM SIGN KAD5",
	"CUNEIFORM SIGN KAD5 OVER KAD5",
	"CUNEIFORM SIGN KAK",
	"CUNEIFORM SIGN KAK TIMES IGI GUNU",
	"CUNEIFORM SIGN KAL",
	"CUNEIFORM SIGN KAL TIMES BAD",
	"CUNEIFORM SIGN KAL CROSSING KAL",
	"CUNEIFORM SIGN KAM2",
	"CUNEIFORM SIGN KAM4",
	"CUNEIFORM SIGN KASKAL",
	"CUNEIFORM SIGN KASKAL LAGAB TIMES U OVER LAGAB TIMES U",
	"CUNEIFORM SIGN KASKAL OVER KASKAL LAGAB TIMES U OVER LAGAB TIMES U",
	"CUNEIFORM SIGN KESH2",
	"CUNEIFORM SIGN KI",
	"CUNEIFORM SIGN KI TIMES BAD",
	"CUNEIFORM SIGN KI TIMES U",
	"CUNEIFORM SIGN KI TIMES UD",
	"CUNEIFORM SIGN KID",
	"CUNEIFORM SIGN KIN",
	"CUNEIFORM SIGN KISAL",
	"CUNEIFORM SIGN KISH",
	"CUNEIFORM SIGN KISIM5",
	"CUNEIFORM SIGN KISIM5 OVER KISIM5",
	"CUNEIFORM SIGN KU",
	"CUNEIFORM SIGN KU OVER HI TIMES ASH2 KU OVER HI TIMES ASH2",
	"CUNEIFORM SIGN KU3",
	"CUNEIFORM SIGN KU4",
	"CUNEIFORM SIGN KU4 VARIANT FORM",
	"CUNEIFORM SIGN KU7",
	"CUNEIFORM SIGN KUL",
	"CUNEIFORM SIGN KUL GUNU",
	"CUNEIFORM SIGN KUN",
	"CUNEIFORM SIGN KUR",
	"CUNEIFORM SIGN KUR OPPOSING KUR",
	"CUNEIFORM SIGN KUSHU2",
	"CUNEIFORM SIGN KWU318",
	"CUNEIFORM SIGN LA",
	"CUNEIFORM SIGN LAGAB",
	"CUNEIFORM SIGN LAGAB TIMES A",
	"CUNEIFORM SIGN LAGAB TIMES A PLUS DA PLUS HA",
	"CUNEIFORM SIGN LAGAB TIMES A PLUS GAR",
	"CUNEIFORM SIGN LAGAB TIMES A PLUS LAL",
	"CUNEIFORM SIGN LAGAB TIMES AL",
	"CUNEIFORM SIGN LAGAB TIMES AN",
	"CUNEIFORM SIGN LAGAB TIMES ASH ZIDA TENU",
	"CUNEIFORM SIGN LAGAB TIMES BAD",
	"CUNEIFORM SIGN LAGAB TIMES BI",
	"CUNEIFORM SIGN LAGAB TIMES DAR",
	"CUNEIFORM SIGN LAGAB TIMES EN",
	"CUNEIFORM SIGN LAGAB TIMES GA",
	"CUNEIFORM SIGN LAGAB TIMES GAR",
	"CUNEIFORM SIGN LAGAB TIMES GUD",
	"CUNEIFORM SIGN LAGAB TIMES GUD PLUS GUD",
	"CUNEIFORM SIGN LAGAB TIMES HA",
	"CUNEIFORM SIGN LAGAB TIMES HAL",
	"CUNEIFORM SIGN LAGAB TIMES HI TIMES NUN",
	"CUNEIFORM SIGN LAGAB TIMES IGI GUNU",
	"CUNEIFORM SIGN LAGAB TIMES IM",
	"CUNEIFORM SIGN LAGAB TIMES IM PLUS HA",
	"CUNEIFORM SIGN LAGAB TIMES IM PLUS LU",
	"CUNEIFORM SIGN LAGAB TIMES KI",
	"CUNEIFORM SIGN LAGAB TIMES KIN",
	"CUNEIFORM SIGN LAGAB TIMES KU3",
	"CUNEIFORM SIGN LAGAB TIMES KUL",
	"CUNEIFORM SIGN LAGAB TIMES KUL PLUS HI PLUS A",
	"CUNEIFORM SIGN LAGAB TIMES LAGAB",
	"CUNEIFORM SIGN LAGAB TIMES LISH",
	"CUNEIFORM SIGN LAGAB TIMES LU",
	"CUNEIFORM SIGN LAGAB TIMES LUL",
	"CUNEIFORM SIGN LAGAB TIMES ME",
	"CUNEIFORM SIGN LAGAB TIMES ME PLUS EN",
	"CUNEIFORM SIGN LAGAB TIMES MUSH",
	"CUNEIFORM SIGN LAGAB TIMES NE",
	"CUNEIFORM SIGN LAGAB TIMES SHE PLUS SUM",
	"CUNEIFORM SIGN LAGAB TIMES SHITA PLUS GISH PLUS ERIN2",
	"CUNEIFORM SIGN LAGAB TIMES SHITA PLUS GISH TENU",
	"CUNEIFORM SIGN LAGAB TIMES SHU2",
	"CUNEIFORM SIGN LAGAB TIMES SHU2 PLUS SHU2",
	"CUNEIFORM SIGN LAGAB TIMES SUM",
	"CUNEIFORM SIGN LAGAB TIMES TAG",
	"CUNEIFORM SIGN LAGAB TIMES TAK4",
	"CUNEIFORM SIGN LAGAB TIMES TE PLUS A PLUS SU PLUS NA",
	"CUNEIFORM SIGN LAGAB TIMES U",
	"CUNEIFORM SIGN LAGAB TIMES U PLUS A",
	"CUNEIFORM SIGN LAGAB TIMES U PLUS U PLUS U",
	"CUNEIFORM SIGN LAGAB TIMES U2 PLUS ASH",
	"CUNEIFORM SIGN LAGAB TIMES UD",
	"CUNEIFORM SIGN LAGAB TIMES USH",
	"CUNEIFORM SIGN LAGAB SQUARED",
	"CUNEIFORM SIGN LAGAR",
	"CUNEIFORM SIGN LAGAR TIMES SHE",
	"CUNEIFORM SIGN LAGAR TIMES SHE PLUS SUM",
	"CUNEIFORM SIGN LAGAR GUNU",
	"CUNEIFORM SIGN LAGAR GUNU OVER LAGAR GUNU SHE",
	"CUNEIFORM SIGN LAHSHU",
	"CUNEIFORM SIGN LAL",
	"CUNEIFORM SIGN LAL TIMES LAL",
	"CUNEIFORM SIGN LAM",
	"CUNEIFORM SIGN LAM TIMES KUR",
	"CUNEIFORM SIGN LAM TIMES KUR PLUS RU",
	"CUNEIFORM SIGN LI",
	"CUNEIFORM SIGN LIL",
	"CUNEIFORM SIGN LIMMU2",
	"CUNEIFORM SIGN LISH",
	"CUNEIFORM SIGN LU",
	"CUNEIFORM SIGN LU TIMES BAD",
	"CUNEIFORM SIGN LU2",
	"CUNEIFORM SIGN LU2 TIMES AL",
	"CUNEIFORM SIGN LU2 TIMES BAD",
	"CUNEIFORM SIGN LU2 TIMES ESH2",
	"CUNEIFORM SIGN LU2 TIMES ESH2 TENU",
	"CUNEIFORM SIGN LU2 TIMES GAN2 TENU",
	"CUNEIFORM SIGN LU2 TIMES HI TIMES BAD",
	"CUNEIFORM SIGN LU2 TIMES IM",
	"CUNEIFORM SIGN LU2 TIMES KAD2",
	"CUNEIFORM SIGN LU2 TIMES KAD3",
	"CUNEIFORM SIGN LU2 TIMES KAD3 PLUS ASH",
	"CUNEIFORM SIGN LU2 TIMES KI",
	"CUNEIFORM SIGN LU2 TIMES LA PLUS ASH",
	"CUNEIFORM SIGN LU2 TIMES LAGAB",
	"CUNEIFORM SIGN LU2 TIMES ME PLUS EN",
	"CUNEIFORM SIGN LU2 TIMES NE",
	"CUNEIFORM SIGN LU2 TIMES NU",
	"CUNEIFORM SIGN LU2 TIMES SI PLUS ASH",
	"CUNEIFORM SIGN LU2 TIMES SIK2 PLUS BU",
	"CUNEIFORM SIGN LU2 TIMES TUG2",
	"CUNEIFORM SIGN LU2 TENU",
	"CUNEIFORM SIGN LU2 CROSSING LU2",
	"CUNEIFORM SIGN LU2 OPPOSING LU2",
	"CUNEIFORM SIGN LU2 SQUARED",
	"CUNEIFORM SIGN LU2 SHESHIG",
	"CUNEIFORM SIGN LU3",
	"CUNEIFORM SIGN LUGAL",
	"CUNEIFORM SIGN LUGAL OVER LUGAL",
	"CUNEIFORM SIGN LUGAL OPPOSING LUGAL",
	"CUNEIFORM SIGN LUGAL SHESHIG",
	"CUNEIFORM SIGN LUH",
	"CUNEIFORM SIGN LUL",
	"CUNEIFORM SIGN LUM",
	"CUNEIFORM SIGN LUM OVER LUM",
	"CUNEIFORM SIGN LUM OVER LUM GAR OVER GAR",
	"CUNEIFORM SIGN MA",
	"CUNEIFORM SIGN MA TIMES TAK4",
	"CUNEIFORM SIGN MA GUNU",
	"CUNEIFORM SIGN MA2",
	"CUNEIFORM SIGN MAH",
	"CUNEIFORM SIGN MAR",
	"CUNEIFORM SIGN MASH",
	"CUNEIFORM SIGN MASH2",
	"CUNEIFORM SIGN ME",
	"CUNEIFORM SIGN MES",
	"CUNEIFORM SIGN MI",
	"CUNEIFORM SIGN MIN",
	"CUNEIFORM SIGN MU",
	"CUNEIFORM SIGN MU OVER MU",
	"CUNEIFORM SIGN MUG",
	"CUNEIFORM SIGN MUG GUNU",
	"CUNEIFORM SIGN MUNSUB",
	"CUNEIFORM SIGN MURGU2",
	"CUNEIFORM SIGN MUSH",
	"CUNEIFORM SIGN MUSH TIMES A",
	"CUNEIFORM SIGN MUSH TIMES KUR",
	"CUNEIFORM SIGN MUSH TIMES ZA",
	"CUNEIFORM SIGN MUSH OVER MUSH",
	"CUNEIFORM SIGN MUSH OVER MUSH TIMES A PLUS NA",
	"CUNEIFORM SIGN MUSH CROSSING MUSH",
	"CUNEIFORM SIGN MUSH3",
	"CUNEIFORM SIGN MUSH3 TIMES A",
	"CUNEIFORM SIGN MUSH3 TIMES A PLUS DI",
	"CUNEIFORM SIGN MUSH3 TIMES DI",
	"CUNEIFORM SIGN MUSH3 GUNU",
	"CUNEIFORM SIGN NA",
	"CUNEIFORM SIGN NA2",
	"CUNEIFORM SIGN NAGA",
	"CUNEIFORM SIGN NAGA INVERTED",
	"CUNEIFORM SIGN NAGA TIMES SHU TENU",
	"CUNEIFORM SIGN NAGA OPPOSING NAGA",
	"CUNEIFORM SIGN NAGAR",
	"CUNEIFORM SIGN NAM NUTILLU",
	"CUNEIFORM SIGN NAM",
	"CUNEIFORM SIGN NAM2",
	"CUNEIFORM SIGN NE",
	"CUNEIFORM SIGN NE TIMES A",
	"CUNEIFORM SIGN NE TIMES UD",
	"CUNEIFORM SIGN NE SHESHIG",
	"CUNEIFORM SIGN NI",
	"CUNEIFORM SIGN NI TIMES E",
	"CUNEIFORM SIGN NI2",
	"CUNEIFORM SIGN NIM",
	"CUNEIFORM SIGN NIM TIMES GAN2 TENU",
	"CUNEIFORM SIGN NIM TIMES GAR PLUS GAN2 TENU",
	"CUNEIFORM SIGN NINDA2",
	"CUNEIFORM SIGN NINDA2 TIMES AN",
	"CUNEIFORM SIGN NINDA2 TIMES ASH",
	"CUNEIFORM SIGN NINDA2 TIMES ASH PLUS ASH",
	"CUNEIFORM SIGN NINDA2 TIMES GUD",
	"CUNEIFORM SIGN NINDA2 TIMES ME PLUS GAN2 TENU",
	"CUNEIFORM SIGN NINDA2 TIMES NE",
	"CUNEIFORM SIGN NINDA2 TIMES NUN",
	"CUNEIFORM SIGN NINDA2 TIMES SHE",
	"CUNEIFORM SIGN NINDA2 TIMES SHE PLUS A AN",
	"CUNEIFORM SIGN NINDA2 TIMES SHE PLUS ASH",
	"CUNEIFORM SIGN NINDA2 TIMES SHE PLUS ASH PLUS ASH",
	"CUNEIFORM SIGN NINDA2 TIMES U2 PLUS ASH",
	"CUNEIFORM SIGN NINDA2 TIMES USH",
	"CUNEIFORM SIGN NISAG",
	"CUNEIFORM SIGN NU",
	"CUNEIFORM SIGN NU11",
	"CUNEIFORM SIGN NUN",
	"CUNEIFORM SIGN NUN LAGAR TIMES GAR",
	"CUNEIFORM SIGN NUN LAGAR TIMES MASH",
	"CUNEIFORM SIGN NUN LAGAR TIMES SAL",
	"CUNEIFORM SIGN NUN LAGAR TIMES SAL OVER NUN LAGAR TIMES SAL",
	"CUNEIFORM SIGN NUN LAGAR TIMES USH",
	"CUNEIFORM SIGN NUN TENU",
	"CUNEIFORM SIGN NUN OVER NUN",
	"CUNEIFORM SIGN NUN CROSSING NUN",
	"CUNEIFORM SIGN NUN CROSSING NUN LAGAR OVER LAGAR",
	"CUNEIFORM SIGN NUNUZ",
	"CUNEIFORM SIGN NUNUZ AB2 TIMES ASHGAB",
	"CUNEIFORM SIGN NUNUZ AB2 TIMES BI",
	"CUNEIFORM SIGN NUNUZ AB2 TIMES DUG",
	"CUNEIFORM SIGN NUNUZ AB2 TIMES GUD",
	"CUNEIFORM SIGN NUNUZ AB2 TIMES IGI GUNU",
	"CUNEIFORM SIGN NUNUZ AB2 TIMES KAD3",
	"CUNEIFORM SIGN NUNUZ AB2 TIMES LA",
	"CUNEIFORM SIGN NUNUZ AB2 TIMES NE",
	"CUNEIFORM SIGN NUNUZ AB2 TIMES SILA3",
	"CUNEIFORM SIGN NUNUZ AB2 TIMES U2",
	"CUNEIFORM SIGN NUNUZ KISIM5 TIMES BI",
	"CUNEIFORM SIGN NUNUZ KISIM5 TIMES BI U",
	"CUNEIFORM SIGN PA",
	"CUNEIFORM SIGN PAD",
	"CUNEIFORM SIGN PAN",
	"CUNEIFORM SIGN PAP",
	"CUNEIFORM SIGN PESH2",
	"CUNEIFORM SIGN PI",
	"CUNEIFORM SIGN PI TIMES A",
	"CUNEIFORM SIGN PI TIMES AB",
	"CUNEIFORM SIGN PI TIMES BI",
	"CUNEIFORM SIGN PI TIMES BU",
	"CUNEIFORM SIGN PI TIMES E",
	"CUNEIFORM SIGN PI TIMES I",
	"CUNEIFORM SIGN PI TIMES IB",
	"CUNEIFORM SIGN PI TIMES U",
	"CUNEIFORM SIGN PI TIMES U2",
	"CUNEIFORM SIGN PI CROSSING PI",
	"CUNEIFORM SIGN PIRIG",
	"CUNEIFORM SIGN PIRIG TIMES KAL",
	"CUNEIFORM SIGN PIRIG TIMES UD",
	"CUNEIFORM SIGN PIRIG TIMES ZA",
	"CUNEIFORM SIGN PIRIG OPPOSING PIRIG",
	"CUNEIFORM SIGN RA",
	"CUNEIFORM SIGN RAB",
	"CUNEIFORM SIGN RI",
	"CUNEIFORM SIGN RU",
	"CUNEIFORM SIGN SA",
	"CUNEIFORM SIGN SAG NUTILLU",
	"CUNEIFORM SIGN SAG",
	"CUNEIFORM SIGN SAG TIMES A",
	"CUNEIFORM SIGN SAG TIMES DU",
	"CUNEIFORM SIGN SAG TIMES DUB",
	"CUNEIFORM SIGN SAG TIMES HA",
	"CUNEIFORM SIGN SAG TIMES KAK",
	"CUNEIFORM SIGN SAG TIMES KUR",
	"CUNEIFORM SIGN SAG TIMES LUM",
	"CUNEIFORM SIGN SAG TIMES MI",
	"CUNEIFORM SIGN SAG TIMES NUN",
	"CUNEIFORM SIGN SAG TIMES SAL",
	"CUNEIFORM SIGN SAG TIMES SHID",
	"CUNEIFORM SIGN SAG TIMES TAB",
	"CUNEIFORM SIGN SAG TIMES U2",
	"CUNEIFORM SIGN SAG TIMES UB",
	"CUNEIFORM SIGN SAG TIMES UM",
	"CUNEIFORM SIGN SAG TIMES UR",
	"CUNEIFORM SIGN SAG TIMES USH",
	"CUNEIFORM SIGN SAG OVER SAG",
	"CUNEIFORM SIGN SAG GUNU",
	"CUNEIFORM SIGN SAL",
	"CUNEIFORM SIGN SAL LAGAB TIMES ASH2",
	"CUNEIFORM SIGN SANGA2",
	"CUNEIFORM SIGN SAR",
	"CUNEIFORM SIGN SHA",
	"CUNEIFORM SIGN SHA3",
	"CUNEIFORM SIGN SHA3 TIMES A",
	"CUNEIFORM SIGN SHA3 TIMES BAD",
	"CUNEIFORM SIGN SHA3 TIMES GISH",
	"CUNEIFORM SIGN SHA3 TIMES NE",
	"CUNEIFORM SIGN SHA3 TIMES SHU2",
	"CUNEIFORM SIGN SHA3 TIMES TUR",
	"CUNEIFORM SIGN SHA3 TIMES U",
	"CUNEIFORM SIGN SHA3 TIMES U PLUS A",
	"CUNEIFORM SIGN SHA6",
	"CUNEIFORM SIGN SHAB6",
	"CUNEIFORM SIGN SHAR2",
	"CUNEIFORM SIGN SHE",
	"CUNEIFORM SIGN SHE HU",
	"CUNEIFORM SIGN SHE OVER SHE GAD OVER GAD GAR OVER GAR",
	"CUNEIFORM SIGN SHE OVER SHE TAB OVER TAB GAR OVER GAR",
	"CUNEIFORM SIGN SHEG9",
	"CUNEIFORM SIGN SHEN",
	"CUNEIFORM SIGN SHESH",
	"CUNEIFORM SIGN SHESH2",
	"CUNEIFORM SIGN SHESHLAM",
	"CUNEIFORM SIGN SHID",
	"CUNEIFORM SIGN SHID TIMES A",
	"CUNEIFORM SIGN SHID TIMES IM",
	"CUNEIFORM SIGN SHIM",
	"CUNEIFORM SIGN SHIM TIMES A",
	"CUNEIFORM SIGN SHIM TIMES BAL",
	"CUNEIFORM SIGN SHIM TIMES BULUG",
	"CUNEIFORM SIGN SHIM TIMES DIN",
	"CUNEIFORM SIGN SHIM TIMES GAR",
	"CUNEIFORM SIGN SHIM TIMES IGI",
	"CUNEIFORM SIGN SHIM TIMES IGI GUNU",
	"CUNEIFORM SIGN SHIM TIMES KUSHU2",
	"CUNEIFORM SIGN SHIM TIMES LUL",
	"CUNEIFORM SIGN SHIM TIMES MUG",
	"CUNEIFORM SIGN SHIM TIMES SAL",
	"CUNEIFORM SIGN SHINIG",
	"CUNEIFORM SIGN SHIR",
	"CUNEIFORM SIGN SHIR TENU",
	"CUNEIFORM SIGN SHIR OVER SHIR BUR OVER BUR",
	"CUNEIFORM SIGN SHITA",
	"CUNEIFORM SIGN SHU",
	"CUNEIFORM SIGN SHU OVER INVERTED SHU",
	"CUNEIFORM SIGN SHU2",
	"CUNEIFORM SIGN SHUBUR",
	"CUNEIFORM SIGN SI",
	"CUNEIFORM SIGN SI GUNU",
	"CUNEIFORM SIGN SIG",
	"CUNEIFORM SIGN SIG4",
	"CUNEIFORM SIGN SIG4 OVER SIG4 SHU2",
	"CUNEIFORM SIGN SIK2",
	"CUNEIFORM SIGN SILA3",
	"CUNEIFORM SIGN SU",
	"CUNEIFORM SIGN SU OVER SU",
	"CUNEIFORM SIGN SUD",
	"CUNEIFORM SIGN SUD2",
	"CUNEIFORM SIGN SUHUR",
	"CUNEIFORM SIGN SUM",
	"CUNEIFORM SIGN SUMASH",
	"CUNEIFORM SIGN SUR",
	"CUNEIFORM SIGN SUR9",
	"CUNEIFORM SIGN TA",
	"CUNEIFORM SIGN TA ASTERISK",
	"CUNEIFORM SIGN TA TIMES HI",
	"CUNEIFORM SIGN TA TIMES MI",
	"CUNEIFORM SIGN TA GUNU",
	"CUNEIFORM SIGN TAB",
	"CUNEIFORM SIGN TAB OVER TAB NI OVER NI DISH OVER DISH",
	"CUNEIFORM SIGN TAB SQUARED",
	"CUNEIFORM SIGN TAG",
	"CUNEIFORM SIGN TAG TIMES BI",
	"CUNEIFORM SIGN TAG TIMES GUD",
	"CUNEIFORM SIGN TAG TIMES SHE",
	"CUNEIFORM SIGN TAG TIMES SHU",
	"CUNEIFORM SIGN TAG TIMES TUG2",
	"CUNEIFORM SIGN TAG TIMES UD",
	"CUNEIFORM SIGN TAK4",
	"CUNEIFORM SIGN TAR",
	"CUNEIFORM SIGN TE",
	"CUNEIFORM SIGN TE GUNU",
	"CUNEIFORM SIGN TI",
	"CUNEIFORM SIGN TI TENU",
	"CUNEIFORM SIGN TIL",
	"CUNEIFORM SIGN TIR",
	"CUNEIFORM SIGN TIR TIMES TAK4",
	"CUNEIFORM SIGN TIR OVER TIR",
	"CUNEIFORM SIGN TIR OVER TIR GAD OVER GAD GAR OVER GAR",
	"CUNEIFORM SIGN TU",
	"CUNEIFORM SIGN TUG2",
	"CUNEIFORM SIGN TUK",
	"CUNEIFORM SIGN TUM",
	"CUNEIFORM SIGN TUR",
	"CUNEIFORM SIGN TUR OVER TUR ZA OVER ZA",
	"CUNEIFORM SIGN U",
	"CUNEIFORM SIGN U GUD",
	"CUNEIFORM SIGN U U U",
	"CUNEIFORM SIGN U OVER U PA OVER PA GAR OVER GAR",
	"CUNEIFORM SIGN U OVER U SUR OVER SUR",
	"CUNEIFORM SIGN U OVER U U REVERSED OVER U REVERSED",
	"CUNEIFORM SIGN U2",
	"CUNEIFORM SIGN UB",
	"CUNEIFORM SIGN UD",
	"CUNEIFORM SIGN UD KUSHU2",
	"CUNEIFORM SIGN UD TIMES BAD",
	"CUNEIFORM SIGN UD TIMES MI",
	"CUNEIFORM SIGN UD TIMES U PLUS U PLUS U",
	"CUNEIFORM SIGN UD TIMES U PLUS U PLUS U GUNU",
	"CUNEIFORM SIGN UD GUNU",
	"CUNEIFORM SIGN UD SHESHIG",
	"CUNEIFORM SIGN UD SHESHIG TIMES BAD",
	"CUNEIFORM SIGN UDUG",
	"CUNEIFORM SIGN UM",
	"CUNEIFORM SIGN UM TIMES LAGAB",
	"CUNEIFORM SIGN UM TIMES ME PLUS DA",
	"CUNEIFORM SIGN UM TIMES SHA3",
	"CUNEIFORM SIGN UM TIMES U",
	"CUNEIFORM SIGN UMBIN",
	"CUNEIFORM SIGN UMUM",
	"CUNEIFORM SIGN UMUM TIMES KASKAL",
	"CUNEIFORM SIGN UMUM TIMES PA",
	"CUNEIFORM SIGN UN",
	"CUNEIFORM SIGN UN GUNU",
	"CUNEIFORM SIGN UR",
	"CUNEIFORM SIGN UR CROSSING UR",
	"CUNEIFORM SIGN UR SHESHIG",
	"CUNEIFORM SIGN UR2",
	"CUNEIFORM SIGN UR2 TIMES A PLUS HA",
	"CUNEIFORM SIGN UR2 TIMES A PLUS NA",
	"CUNEIFORM SIGN UR2 TIMES AL",
	"CUNEIFORM SIGN UR2 TIMES HA",
	"CUNEIFORM SIGN UR2 TIMES NUN",
	"CUNEIFORM SIGN UR2 TIMES U2",
	"CUNEIFORM SIGN UR2 TIMES U2 PLUS ASH",
	"CUNEIFORM SIGN UR2 TIMES U2 PLUS BI",
	"CUNEIFORM SIGN UR4",
	"CUNEIFORM SIGN URI",
	"CUNEIFORM SIGN URI3",
	"CUNEIFORM SIGN URU",
	"CUNEIFORM SIGN URU TIMES A",
	"CUNEIFORM SIGN URU TIMES ASHGAB",
	"CUNEIFORM SIGN URU TIMES BAR",
	"CUNEIFORM SIGN URU TIMES DUN",
	"CUNEIFORM SIGN URU TIMES GA",
	"CUNEIFORM SIGN URU TIMES GAL",
	"CUNEIFORM SIGN URU TIMES GAN2 TENU",
	"CUNEIFORM SIGN URU TIMES GAR",
	"CUNEIFORM SIGN URU TIMES GU",
	"CUNEIFORM SIGN URU TIMES HA",
	"CUNEIFORM SIGN URU TIMES IGI",
	"CUNEIFORM SIGN URU TIMES IM",
	"CUNEIFORM SIGN URU TIMES ISH",
	"CUNEIFORM SIGN URU TIMES KI",
	"CUNEIFORM SIGN URU TIMES LUM",
	"CUNEIFORM SIGN URU TIMES MIN",
	"CUNEIFORM SIGN URU TIMES PA",
	"CUNEIFORM SIGN URU TIMES SHE",
	"CUNEIFORM SIGN URU TIMES SIG4",
	"CUNEIFORM SIGN URU TIMES TU",
	"CUNEIFORM SIGN URU TIMES U PLUS GUD",
	"CUNEIFORM SIGN URU TIMES UD",
	"CUNEIFORM SIGN URU TIMES URUDA",
	"CUNEIFORM SIGN URUDA",
	"CUNEIFORM SIGN URUDA TIMES U",
	"CUNEIFORM SIGN USH",
	"CUNEIFORM SIGN USH TIMES A",
	"CUNEIFORM SIGN USH TIMES KU",
	"CUNEIFORM SIGN USH TIMES KUR",
	"CUNEIFORM SIGN USH TIMES TAK4",
	"CUNEIFORM SIGN USHX",
	"CUNEIFORM SIGN USH2",
	"CUNEIFORM SIGN USHUMX",
	"CUNEIFORM SIGN UTUKI",
	"CUNEIFORM SIGN UZ3",
	"CUNEIFORM SIGN UZ3 TIMES KASKAL",
	"CUNEIFORM SIGN UZU",
	"CUNEIFORM SIGN ZA",
	"CUNEIFORM SIGN ZA TENU",
	"CUNEIFORM SIGN ZA SQUARED TIMES KUR",
	"CUNEIFORM SIGN ZAG",
	"CUNEIFORM SIGN ZAMX",
	"CUNEIFORM SIGN ZE2",
	"CUNEIFORM SIGN ZI",
	"CUNEIFORM SIGN ZI OVER ZI",
	"CUNEIFORM SIGN ZI3",
	"CUNEIFORM SIGN ZIB",
	"CUNEIFORM SIGN ZIB KABA TENU",
	"CUNEIFORM SIGN ZIG",
	"CUNEIFORM SIGN ZIZ2",
	"CUNEIFORM SIGN ZU",
	"CUNEIFORM SIGN ZU5",
	"CUNEIFORM SIGN ZU5 TIMES A",
	"CUNEIFORM SIGN ZUBUR",
	"CUNEIFORM SIGN ZUM",
	"CUNEIFORM SIGN KAP ELAMITE",
	"CUNEIFORM SIGN AB TIMES NUN",
	"CUNEIFORM SIGN AB2 TIMES A",
	"CUNEIFORM SIGN AMAR TIMES KUG",
	"CUNEIFORM SIGN DAG KISIM5 TIMES U2 PLUS MASH",
	"CUNEIFORM SIGN DAG3",
	"CUNEIFORM SIGN DISH PLUS SHU",
	"CUNEIFORM SIGN DUB TIMES SHE",
	"CUNEIFORM SIGN EZEN TIMES GUD",
	"CUNEIFORM SIGN EZEN TIMES SHE",
	"CUNEIFORM SIGN GA2 TIMES AN PLUS KAK PLUS A",
	"CUNEIFORM SIGN GA2 TIMES ASH2",
	"CUNEIFORM SIGN GE22",
	"CUNEIFORM SIGN GIG",
	"CUNEIFORM SIGN HUSH",
	"CUNEIFORM SIGN KA TIMES ANSHE",
	"CUNEIFORM SIGN KA TIMES ASH3",
	"CUNEIFORM SIGN KA TIMES GISH",
	"CUNEIFORM SIGN KA TIMES GUD",
	"CUNEIFORM SIGN KA TIMES HI TIMES ASH2",
	"CUNEIFORM SIGN KA TIMES LUM",
	"CUNEIFORM SIGN KA TIMES PA",
	"CUNEIFORM SIGN KA TIMES SHUL",
	"CUNEIFORM SIGN KA TIMES TU",
	"CUNEIFORM SIGN KA TIMES UR2",
	"CUNEIFORM SIGN LAGAB TIMES GI",
	"CUNEIFORM SIGN LU2 SHESHIG TIMES BAD",
	"CUNEIFORM SIGN LU2 TIMES ESH2 PLUS LAL",
	"CUNEIFORM SIGN LU2 TIMES SHU",
	"CUNEIFORM SIGN MESH",
	"CUNEIFORM SIGN MUSH3 TIMES ZA",
	"CUNEIFORM SIGN NA4",
	"CUNEIFORM SIGN NIN",
	"CUNEIFORM SIGN NIN9",
	"CUNEIFORM SIGN NINDA2 TIMES BAL",
	"CUNEIFORM SIGN NINDA2 TIMES GI",
	"CUNEIFORM SIGN NU11 ROTATED NINETY DEGREES",
	"CUNEIFORM SIGN PESH2 ASTERISK",
	"CUNEIFORM SIGN PIR2",
	"CUNEIFORM SIGN SAG TIMES IGI GUNU",
	"CUNEIFORM SIGN TI2",
	"CUNEIFORM SIGN UM TIMES ME",
	"CUNEIFORM SIGN U U",
	"CUNEIFORM NUMERIC SIGN TWO ASH",
	"CUNEIFORM NUMERIC SIGN THREE ASH",
	"CUNEIFORM NUMERIC SIGN FOUR ASH",
	"CUNEIFORM NUMERIC SIGN FIVE ASH",
	"CUNEIFORM NUMERIC SIGN SIX ASH",
	"CUNEIFORM NUMERIC SIGN SEVEN ASH",
	"CUNEIFORM NUMERIC SIGN EIGHT ASH",
	"CUNEIFORM NUMERIC SIGN NINE ASH",
	"CUNEIFORM NUMERIC SIGN THREE DISH",
	"CUNEIFORM NUMERIC SIGN FOUR DISH",
	"CUNEIFORM NUMERIC SIGN FIVE DISH",
	"CUNEIFORM NUMERIC SIGN SIX DISH",
	"CUNEIFORM NUMERIC SIGN SEVEN DISH",
	"CUNEIFORM NUMERIC SIGN EIGHT DISH",
	"CUNEIFORM NUMERIC SIGN NINE DISH",
	"CUNEIFORM NUMERIC SIGN FOUR U",
	"CUNEIFORM NUMERIC SIGN FIVE U",
	"CUNEIFORM NUMERIC SIGN SIX U",
	"CUNEIFORM NUMERIC SIGN SEVEN U",
	"CUNEIFORM NUMERIC SIGN EIGHT U",
	"CUNEIFORM NUMERIC SIGN NINE U",
	"CUNEIFORM NUMERIC SIGN ONE GESH2",
	"CUNEIFORM NUMERIC SIGN TWO GESH2",
	"CUNEIFORM NUMERIC SIGN THREE GESH2",
	"CUNEIFORM NUMERIC SIGN FOUR GESH2",
	"CUNEIFORM NUMERIC SIGN FIVE GESH2",
	"CUNEIFORM NUMERIC SIGN SIX GESH2",
	"CUNEIFORM NUMERIC SIGN SEVEN GESH2",
	"CUNEIFORM NUMERIC SIGN EIGHT GESH2",
	"CUNEIFORM NUMERIC SIGN NINE GESH2",
	"CUNEIFORM NUMERIC SIGN ONE GESHU",
	"CUNEIFORM NUMERIC SIGN TWO GESHU",
	"CUNEIFORM NUMERIC SIGN THREE GESHU",
	"CUNEIFORM NUMERIC SIGN FOUR GESHU",
	"CUNEIFORM NUMERIC SIGN FIVE GESHU",
	"CUNEIFORM NUMERIC SIGN TWO SHAR2",
	"CUNEIFORM NUMERIC SIGN THREE SHAR2",
	"CUNEIFORM NUMERIC SIGN THREE SHAR2 VARIANT FORM",
	"CUNEIFORM NUMERIC SIGN FOUR SHAR2",
	"CUNEIFORM NUMERIC SIGN FIVE SHAR2",
	"CUNEIFORM NUMERIC SIGN SIX SHAR2",
	"CUNEIFORM NUMERIC SIGN SEVEN SHAR2",
	"CUNEIFORM NUMERIC SIGN EIGHT SHAR2",
	"CUNEIFORM NUMERIC SIGN NINE SHAR2",
	"CUNEIFORM NUMERIC SIGN ONE SHARU",
	"CUNEIFORM NUMERIC SIGN TWO SHARU",
	"CUNEIFORM NUMERIC SIGN THREE SHARU",
	"CUNEIFORM NUMERIC SIGN THREE SHARU VARIANT FORM",
	"CUNEIFORM NUMERIC SIGN FOUR SHARU",
	"CUNEIFORM NUMERIC SIGN FIVE SHARU",
	"CUNEIFORM NUMERIC SIGN SHAR2 TIMES GAL PLUS DISH",
	"CUNEIFORM NUMERIC SIGN SHAR2 TIMES GAL PLUS MIN",
	"CUNEIFORM NUMERIC SIGN ONE BURU",
	"CUNEIFORM NUMERIC SIGN TWO BURU",
	"CUNEIFORM NUMERIC SIGN THREE BURU",
	"CUNEIFORM NUMERIC SIGN THREE BURU VARIANT FORM",
	"CUNEIFORM NUMERIC SIGN FOUR BURU",
	"CUNEIFORM NUMERIC SIGN FIVE BURU",
	"CUNEIFORM NUMERIC SIGN THREE VARIANT FORM ESH16",
	"CUNEIFORM NUMERIC SIGN THREE VARIANT FORM ESH21",
	"CUNEIFORM NUMERIC SIGN FOUR VARIANT FORM LIMMU",
	"CUNEIFORM NUMERIC SIGN FOUR VARIANT FORM LIMMU4",
	"CUNEIFORM NUMERIC SIGN FOUR VARIANT FORM LIMMU A",
	"CUNEIFORM NUMERIC SIGN FOUR VARIANT FORM LIMMU B",
	"CUNEIFORM NUMERIC SIGN SIX VARIANT FORM ASH9",
	"CUNEIFORM NUMERIC SIGN SEVEN VARIANT FORM IMIN3",
	"CUNEIFORM NUMERIC SIGN SEVEN VARIANT FORM IMIN A",
	"CUNEIFORM NUMERIC SIGN SEVEN VARIANT FORM IMIN B",
	"CUNEIFORM NUMERIC SIGN EIGHT VARIANT FORM USSU",
	"CUNEIFORM NUMERIC SIGN EIGHT VARIANT FORM USSU3",
	"CUNEIFORM NUMERIC SIGN NINE VARIANT FORM ILIMMU",
	"CUNEIFORM NUMERIC SIGN NINE VARIANT FORM ILIMMU3",
	"CUNEIFORM NUMERIC SIGN NINE VARIANT FORM ILIMMU4",
	"CUNEIFORM NUMERIC SIGN NINE VARIANT FORM ILIMMU A",
	"CUNEIFORM NUMERIC SIGN TWO ASH TENU",
	"CUNEIFORM NUMERIC SIGN THREE ASH TENU",
	"CUNEIFORM NUMERIC SIGN FOUR ASH TENU",
	"CUNEIFORM NUMERIC SIGN FIVE ASH TENU",
	"CUNEIFORM NUMERIC SIGN SIX ASH TENU",
	"CUNEIFORM NUMERIC SIGN ONE BAN2",
	"CUNEIFORM NUMERIC SIGN TWO BAN2",
	"CUNEIFORM NUMERIC SIGN THREE BAN2",
	"CUNEIFORM NUMERIC SIGN FOUR BAN2",
	"CUNEIFORM NUMERIC SIGN FOUR BAN2 VARIANT FORM",
	"CUNEIFORM NUMERIC SIGN FIVE BAN2",
	"CUNEIFORM NUMERIC SIGN FIVE BAN2 VARIANT FORM",
	"CUNEIFORM NUMERIC SIGN NIGIDAMIN",
	"CUNEIFORM NUMERIC SIGN NIGIDAESH",
	"CUNEIFORM NUMERIC SIGN ONE ESHE3",
	"CUNEIFORM NUMERIC SIGN TWO ESHE3",
	"CUNEIFORM NUMERIC SIGN ONE THIRD DISH",
	"CUNEIFORM NUMERIC SIGN TWO THIRDS DISH",
	"CUNEIFORM NUMERIC SIGN FIVE SIXTHS DISH",
	"CUNEIFORM NUMERIC SIGN ONE THIRD VARIANT FORM A",
	"CUNEIFORM NUMERIC SIGN TWO THIRDS VARIANT FORM A",
	"CUNEIFORM NUMERIC SIGN ONE EIGHTH ASH",
	"CUNEIFORM NUMERIC SIGN ONE QUARTER ASH",
	"CUNEIFORM NUMERIC SIGN OLD ASSYRIAN ONE SIXTH",
	"CUNEIFORM NUMERIC SIGN OLD ASSYRIAN ONE QUARTER",
	"CUNEIFORM NUMERIC SIGN ONE QUARTER GUR",
	"CUNEIFORM NUMERIC SIGN ONE HALF GUR",
	"CUNEIFORM NUMERIC SIGN ELAMITE ONE THIRD",
	"CUNEIFORM NUMERIC SIGN ELAMITE TWO THIRDS",
	"CUNEIFORM NUMERIC SIGN ELAMITE FORTY",
	"CUNEIFORM NUMERIC SIGN ELAMITE FIFTY",
	"CUNEIFORM NUMERIC SIGN FOUR U VARIANT FORM",
	"CUNEIFORM NUMERIC SIGN FIVE U VARIANT FORM",
	"CUNEIFORM NUMERIC SIGN SIX U VARIANT FORM",
	"CUNEIFORM NUMERIC SIGN SEVEN U VARIANT FORM",
	"CUNEIFORM NUMERIC SIGN EIGHT U VARIANT FORM",
	"CUNEIFORM NUMERIC SIGN NINE U VARIANT FORM",
	"CUNEIFORM PUNCTUATION SIGN OLD ASSYRIAN WORD DIVIDER",
	"CUNEIFORM PUNCTUATION SIGN VERTICAL COLON",
	"CUNEIFORM PUNCTUATION SIGN DIAGONAL COLON",
	"CUNEIFORM PUNCTUATION SIGN DIAGONAL TRICOLON",
	"CUNEIFORM PUNCTUATION SIGN DIAGONAL QUADCOLON",
	"CUNEIFORM SIGN AB TIMES NUN TENU",
	"CUNEIFORM SIGN AB TIMES SHU2",
	"CUNEIFORM SIGN AD TIMES ESH2",
	"CUNEIFORM SIGN BAD TIMES DISH TENU",
	"CUNEIFORM SIGN BAHAR2 TIMES AB2",
	"CUNEIFORM SIGN BAHAR2 TIMES NI",
	"CUNEIFORM SIGN BAHAR2 TIMES ZA",
	"CUNEIFORM SIGN BU OVER BU TIMES NA2",
	"CUNEIFORM SIGN DA TIMES TAK4",
	"CUNEIFORM SIGN DAG TIMES KUR",
	"CUNEIFORM SIGN DIM TIMES IGI",
	"CUNEIFORM SIGN DIM TIMES U U U",
	"CUNEIFORM SIGN DIM2 TIMES UD",
	"CUNEIFORM SIGN DUG TIMES ANSHE",
	"CUNEIFORM SIGN DUG TIMES ASH",
	"CUNEIFORM SIGN DUG TIMES ASH AT LEFT",
	"CUNEIFORM SIGN DUG TIMES DIN",
	"CUNEIFORM SIGN DUG TIMES DUN",
	"CUNEIFORM SIGN DUG TIMES ERIN2",
	"CUNEIFORM SIGN DUG TIMES GA",
	"CUNEIFORM SIGN DUG TIMES GI",
	"CUNEIFORM SIGN DUG TIMES GIR2 GUNU",
	"CUNEIFORM SIGN DUG TIMES GISH",
	"CUNEIFORM SIGN DUG TIMES HA",
	"CUNEIFORM SIGN DUG TIMES HI",
	"CUNEIFORM SIGN DUG TIMES IGI GUNU",
	"CUNEIFORM SIGN DUG TIMES KASKAL",
	"CUNEIFORM SIGN DUG TIMES KUR",
	"CUNEIFORM SIGN DUG TIMES KUSHU2",
	"CUNEIFORM SIGN DUG TIMES KUSHU2 PLUS KASKAL",
	"CUNEIFORM SIGN DUG TIMES LAK-020",
	"CUNEIFORM SIGN DUG TIMES LAM",
	"CUNEIFORM SIGN DUG TIMES LAM TIMES KUR",
	"CUNEIFORM SIGN DUG TIMES LUH PLUS GISH",
	"CUNEIFORM SIGN DUG TIMES MASH",
	"CUNEIFORM SIGN DUG TIMES MES",
	"CUNEIFORM SIGN DUG TIMES MI",
	"CUNEIFORM SIGN DUG TIMES NI",
	"CUNEIFORM SIGN DUG TIMES PI",
	"CUNEIFORM SIGN DUG TIMES SHE",
	"CUNEIFORM SIGN DUG TIMES SI GUNU",
	"CUNEIFORM SIGN E2 TIMES KUR",
	"CUNEIFORM SIGN E2 TIMES PAP",
	"CUNEIFORM SIGN ERIN2 X",
	"CUNEIFORM SIGN ESH2 CROSSING ESH2",
	"CUNEIFORM SIGN EZEN SHESHIG TIMES ASH",
	"CUNEIFORM SIGN EZEN SHESHIG TIMES HI",
	"CUNEIFORM SIGN EZEN SHESHIG TIMES IGI GUNU",
	"CUNEIFORM SIGN EZEN SHESHIG TIMES LA",
	"CUNEIFORM SIGN EZEN SHESHIG TIMES LAL",
	"CUNEIFORM SIGN EZEN SHESHIG TIMES ME",
	"CUNEIFORM SIGN EZEN SHESHIG TIMES MES",
	"CUNEIFORM SIGN EZEN SHESHIG TIMES SU",
	"CUNEIFORM SIGN EZEN TIMES SU",
	"CUNEIFORM SIGN GA2 TIMES BAHAR2",
	"CUNEIFORM SIGN GA2 TIMES DIM GUNU",
	"CUNEIFORM SIGN GA2 TIMES DUG TIMES IGI GUNU",
	"CUNEIFORM SIGN GA2 TIMES DUG TIMES KASKAL",
	"CUNEIFORM SIGN GA2 TIMES EREN",
	"CUNEIFORM SIGN GA2 TIMES GA",
	"CUNEIFORM SIGN GA2 TIMES GAR PLUS DI",
	"CUNEIFORM SIGN GA2 TIMES GAR PLUS NE",
	"CUNEIFORM SIGN GA2 TIMES HA PLUS A",
	"CUNEIFORM SIGN GA2 TIMES KUSHU2 PLUS KASKAL",
	"CUNEIFORM SIGN GA2 TIMES LAM",
	"CUNEIFORM SIGN GA2 TIMES LAM TIMES KUR",
	"CUNEIFORM SIGN GA2 TIMES LUH",
	"CUNEIFORM SIGN GA2 TIMES MUSH",
	"CUNEIFORM SIGN GA2 TIMES NE",
	"CUNEIFORM SIGN GA2 TIMES NE PLUS E2",
	"CUNEIFORM SIGN GA2 TIMES NE PLUS GI",
	"CUNEIFORM SIGN GA2 TIMES SHIM",
	"CUNEIFORM SIGN GA2 TIMES ZIZ2",
	"CUNEIFORM SIGN GABA ROTATED NINETY DEGREES",
	"CUNEIFORM SIGN GESHTIN TIMES U",
	"CUNEIFORM SIGN GISH TIMES GISH CROSSING GISH",
	"CUNEIFORM SIGN GU2 TIMES IGI GUNU",
	"CUNEIFORM SIGN GUD PLUS GISH TIMES TAK4",
	"CUNEIFORM SIGN HA TENU GUNU",
	"CUNEIFORM SIGN HI TIMES ASH OVER HI TIMES ASH",
	"CUNEIFORM SIGN KA TIMES BU",
	"CUNEIFORM SIGN KA TIMES KA",
	"CUNEIFORM SIGN KA TIMES U U U",
	"CUNEIFORM SIGN KA TIMES UR",
	"CUNEIFORM SIGN LAGAB TIMES ZU OVER ZU",
	"CUNEIFORM SIGN LAK-003",
	"CUNEIFORM SIGN LAK-021",
	"CUNEIFORM SIGN LAK-025",
	"CUNEIFORM SIGN LAK-030",
	"CUNEIFORM SIGN LAK-050",
	"CUNEIFORM SIGN LAK-051",
	"CUNEIFORM SIGN LAK-062",
	"CUNEIFORM SIGN LAK-079 OVER LAK-079 GUNU",
	"CUNEIFORM SIGN LAK-080",
	"CUNEIFORM SIGN LAK-081 OVER LAK-081",
	"CUNEIFORM SIGN LAK-092",
	"CUNEIFORM SIGN LAK-130",
	"CUNEIFORM SIGN LAK-142",
	"CUNEIFORM SIGN LAK-210",
	"CUNEIFORM SIGN LAK-219",
	"CUNEIFORM SIGN LAK-220",
	"CUNEIFORM SIGN LAK-225",
	"CUNEIFORM SIGN LAK-228",
	"CUNEIFORM SIGN LAK-238",
	"CUNEIFORM SIGN LAK-265",
	"CUNEIFORM SIGN LAK-266",
	"CUNEIFORM SIGN LAK-343",
	"CUNEIFORM SIGN LAK-347",
	"CUNEIFORM SIGN LAK-348",
	"CUNEIFORM SIGN LAK-383",
	"CUNEIFORM SIGN LAK-384",
	"CUNEIFORM SIGN LAK-390",
	"CUNEIFORM SIGN LAK-441",
	"CUNEIFORM SIGN LAK-449",
	"CUNEIFORM SIGN LAK-449 TIMES GU",
	"CUNEIFORM SIGN LAK-449 TIMES IGI",
	"CUNEIFORM SIGN LAK-449 TIMES PAP PLUS LU3",
	"CUNEIFORM SIGN LAK-449 TIMES PAP PLUS PAP PLUS LU3",
	"CUNEIFORM SIGN LAK-449 TIMES U2 PLUS BA",
	"CUNEIFORM SIGN LAK-450",
	"CUNEIFORM SIGN LAK-457",
	"CUNEIFORM SIGN LAK-470",
	"CUNEIFORM SIGN LAK-483",
	"CUNEIFORM SIGN LAK-490",
	"CUNEIFORM SIGN LAK-492",
	"CUNEIFORM SIGN LAK-493",
	"CUNEIFORM SIGN LAK-495",
	"CUNEIFORM SIGN LAK-550",
	"CUNEIFORM SIGN LAK-608",
	"CUNEIFORM SIGN LAK-617",
	"CUNEIFORM SIGN LAK-617 TIMES ASH",
	"CUNEIFORM SIGN LAK-617 TIMES BAD",
	"CUNEIFORM SIGN LAK-617 TIMES DUN3 GUNU GUNU",
	"CUNEIFORM SIGN LAK-617 TIMES KU3",
	"CUNEIFORM SIGN LAK-617 TIMES LA",
	"CUNEIFORM SIGN LAK-617 TIMES TAR",
	"CUNEIFORM SIGN LAK-617 TIMES TE",
	"CUNEIFORM SIGN LAK-617 TIMES U2",
	"CUNEIFORM SIGN LAK-617 TIMES UD",
	"CUNEIFORM SIGN LAK-617 TIMES URUDA",
	"CUNEIFORM SIGN LAK-636",
	"CUNEIFORM SIGN LAK-648",
	"CUNEIFORM SIGN LAK-648 TIMES DUB",
	"CUNEIFORM SIGN LAK-648 TIMES GA",
	"CUNEIFORM SIGN LAK-648 TIMES IGI",
	"CUNEIFORM SIGN LAK-648 TIMES IGI GUNU",
	"CUNEIFORM SIGN LAK-648 TIMES NI",
	"CUNEIFORM SIGN LAK-648 TIMES PAP PLUS PAP PLUS LU3",
	"CUNEIFORM SIGN LAK-648 TIMES SHESH PLUS KI",
	"CUNEIFORM SIGN LAK-648 TIMES UD",
	"CUNEIFORM SIGN LAK-648 TIMES URUDA",
	"CUNEIFORM SIGN LAK-724",
	"CUNEIFORM SIGN LAK-749",
	"CUNEIFORM SIGN LU2 GUNU TIMES ASH",
	"CUNEIFORM SIGN LU2 TIMES DISH",
	"CUNEIFORM SIGN LU2 TIMES HAL",
	"CUNEIFORM SIGN LU2 TIMES PAP",
	"CUNEIFORM SIGN LU2 TIMES PAP PLUS PAP PLUS LU3",
	"CUNEIFORM SIGN LU2 TIMES TAK4",
	"CUNEIFORM SIGN MI PLUS ZA7",
	"CUNEIFORM SIGN MUSH OVER MUSH TIMES GA",
	"CUNEIFORM SIGN MUSH OVER MUSH TIMES KAK",
	"CUNEIFORM SIGN NINDA2 TIMES DIM GUNU",
	"CUNEIFORM SIGN NINDA2 TIMES GISH",
	"CUNEIFORM SIGN NINDA2 TIMES GUL",
	"CUNEIFORM SIGN NINDA2 TIMES HI",
	"CUNEIFORM SIGN NINDA2 TIMES KESH2",
	"CUNEIFORM SIGN NINDA2 TIMES LAK-050",
	"CUNEIFORM SIGN NINDA2 TIMES MASH",
	"CUNEIFORM SIGN NINDA2 TIMES PAP PLUS PAP",
	"CUNEIFORM SIGN NINDA2 TIMES U",
	"CUNEIFORM SIGN NINDA2 TIMES U PLUS U",
	"CUNEIFORM SIGN NINDA2 TIMES URUDA",
	"CUNEIFORM SIGN SAG GUNU TIMES HA",
	"CUNEIFORM SIGN SAG TIMES EN",
	"CUNEIFORM SIGN SAG TIMES SHE AT LEFT",
	"CUNEIFORM SIGN SAG TIMES TAK4",
	"CUNEIFORM SIGN SHA6 TENU",
	"CUNEIFORM SIGN SHE OVER SHE",
	"CUNEIFORM SIGN SHE PLUS HUB2",
	"CUNEIFORM SIGN SHE PLUS NAM2",
	"CUNEIFORM SIGN SHE PLUS SAR",
	"CUNEIFORM SIGN SHU2 PLUS DUG TIMES NI",
	"CUNEIFORM SIGN SHU2 PLUS E2 TIMES AN",
	"CUNEIFORM SIGN SI TIMES TAK4",
	"CUNEIFORM SIGN TAK4 PLUS SAG",
	"CUNEIFORM SIGN TUM TIMES GAN2 TENU",
	"CUNEIFORM SIGN TUM TIMES THREE DISH",
	"CUNEIFORM SIGN UR2 INVERTED",
	"CUNEIFORM SIGN UR2 TIMES UD",
	"CUNEIFORM SIGN URU TIMES DARA3",
	"CUNEIFORM SIGN URU TIMES LAK-668",
	"CUNEIFORM SIGN URU TIMES LU3",
	"CUNEIFORM SIGN ZA7",
	"CUNEIFORM SIGN ZU OVER ZU PLUS SAR",
	"CUNEIFORM SIGN ZU5 TIMES THREE DISH TENU",
	"CYPRO-MINOAN SIGN CM001",
	"CYPRO-MINOAN SIGN CM002",
	"CYPRO-MINOAN SIGN CM004",
	"CYPRO-MINOAN SIGN CM005",
	"CYPRO-MINOAN SIGN CM006",
	"CYPRO-MINOAN SIGN CM007",
	"CYPRO-MINOAN SIGN CM008",
	"CYPRO-MINOAN SIGN CM009",
	"CYPRO-MINOAN SIGN CM010",
	"CYPRO-MINOAN SIGN CM011",
	"CYPRO-MINOAN SIGN CM012",
	"CYPRO-MINOAN SIGN CM012B",
	"CYPRO-MINOAN SIGN CM013",
	"CYPRO-MINOAN SIGN CM015",
	"CYPRO-MINOAN SIGN CM017",
	"CYPRO-MINOAN SIGN CM019",
	"CYPRO-MINOAN SIGN CM021",
	"CYPRO-MINOAN SIGN CM023",
	"CYPRO-MINOAN SIGN CM024",
	"CYPRO-MINOAN SIGN CM025",
	"CYPRO-MINOAN SIGN CM026",
	"CYPRO-MINOAN SIGN CM027",
	"CYPRO-MINOAN SIGN CM028",
	"CYPRO-MINOAN SIGN CM029",
	"CYPRO-MINOAN SIGN CM030",
	"CYPRO-MINOAN SIGN CM033",
	"CYPRO-MINOAN SIGN CM034",
	"CYPRO-MINOAN SIGN CM035",
	"CYPRO-MINOAN SIGN CM036",
	"CYPRO-MINOAN SIGN CM037",
	"CYPRO-MINOAN SIGN CM038",
	"CYPRO-MINOAN SIGN CM039",
	"CYPRO-MINOAN SIGN CM040",
	"CYPRO-MINOAN SIGN CM041",
	"CYPRO-MINOAN SIGN CM044",
	"CYPRO-MINOAN SIGN CM046",
	"CYPRO-MINOAN SIGN CM047",
	"CYPRO-MINOAN SIGN CM049",
	"CYPRO-MINOAN SIGN CM050",
	"CYPRO-MINOAN SIGN CM051",
	"CYPRO-MINOAN SIGN CM052",
	"CYPRO-MINOAN SIGN CM053",
	"CYPRO-MINOAN SIGN CM054",
	"CYPRO-MINOAN SIGN CM055",
	"CYPRO-MINOAN SIGN CM056",
	"CYPRO-MINOAN SIGN CM058",
	"CYPRO-MINOAN SIGN CM059",
	"CYPRO-MINOAN SIGN CM060",
	"CYPRO-MINOAN SIGN CM061",
	"CYPRO-MINOAN SIGN CM062",
	"CYPRO-MINOAN SIGN CM063",
	"CYPRO-MINOAN SIGN CM064",
	"CYPRO-MINOAN SIGN CM066",
	"CYPRO-MINOAN SIGN CM067",
	"CYPRO-MINOAN SIGN CM068",
	"CYPRO-MINOAN SIGN CM069",
	"CYPRO-MINOAN SIGN CM070",
	"CYPRO-MINOAN SIGN CM071",
	"CYPRO-MINOAN SIGN CM072",
	"CYPRO-MINOAN SIGN CM073",
	"CYPRO-MINOAN SIGN CM074",
	"CYPRO-MINOAN SIGN CM075",
	"CYPRO-MINOAN SIGN CM075B",
	"CYPRO-MINOAN SIGN CM076",
	"CYPRO-MINOAN SIGN CM078",
	"CYPRO-MINOAN SIGN CM079",
	"CYPRO-MINOAN SIGN CM080",
	"CYPRO-MINOAN SIGN CM081",
	"CYPRO-MINOAN SIGN CM082",
	"CYPRO-MINOAN SIGN CM083",
	"CYPRO-MINOAN SIGN CM084",
	"CYPRO-MINOAN SIGN CM085",
	"CYPRO-MINOAN SIGN CM086",
	"CYPRO-MINOAN SIGN CM087",
	"CYPRO-MINOAN SIGN CM088",
	"CYPRO-MINOAN SIGN CM089",
	"CYPRO-MINOAN SIGN CM090",
	"CYPRO-MINOAN SIGN CM091",
	"CYPRO-MINOAN SIGN CM092",
	"CYPRO-MINOAN SIGN CM094",
	"CYPRO-MINOAN SIGN CM095",
	"CYPRO-MINOAN SIGN CM096",
	"CYPRO-MINOAN SIGN CM097",
	"CYPRO-MINOAN SIGN CM098",
	"CYPRO-MINOAN SIGN CM099",
	"CYPRO-MINOAN SIGN CM100",
	"CYPRO-MINOAN SIGN CM101",
	"CYPRO-MINOAN SIGN CM102",
	"CYPRO-MINOAN SIGN CM103",
	"CYPRO-MINOAN SIGN CM104",
	"CYPRO-MINOAN SIGN CM105",
	"CYPRO-MINOAN SIGN CM107",
	"CYPRO-MINOAN SIGN CM108",
	"CYPRO-MINOAN SIGN CM109",
	"CYPRO-MINOAN SIGN CM110",
	"CYPRO-MINOAN SIGN CM112",
	"CYPRO-MINOAN SIGN CM114",
	"CYPRO-MINOAN SIGN CM301",
	"CYPRO-MINOAN SIGN CM302",
	"EGYPTIAN HIEROGLYPH A001",
	"EGYPTIAN HIEROGLYPH A002",
	"EGYPTIAN HIEROGLYPH A003",
	"EGYPTIAN HIEROGLYPH A004",
	"EGYPTIAN HIEROGLYPH A005",
	"EGYPTIAN HIEROGLYPH A005A",
	"EGYPTIAN HIEROGLYPH A006",
	"EGYPTIAN HIEROGLYPH A006A",
	"EGYPTIAN HIEROGLYPH A006B",
	"EGYPTIAN HIEROGLYPH A007",
	"EGYPTIAN HIEROGLYPH A008",
	"EGYPTIAN HIEROGLYPH A009",
	"EGYPTIAN HIEROGLYPH A010",
	"EGYPTIAN HIEROGLYPH A011",
	"EGYPTIAN HIEROGLYPH A012",
	"EGYPTIAN HIEROGLYPH A013",
	"EGYPTIAN HIEROGLYPH A014",
	"EGYPTIAN HIEROGLYPH A014A",
	"EGYPTIAN HIEROGLYPH A015",
	"EGYPTIAN HIEROGLYPH A016",
	"EGYPTIAN HIEROGLYPH A017",
	"EGYPTIAN HIEROGLYPH A017A",
	"EGYPTIAN HIEROGLYPH A018",
	"EGYPTIAN HIEROGLYPH A019",
	"EGYPTIAN HIEROGLYPH A020",
	"EGYPTIAN HIEROGLYPH A021",
	"EGYPTIAN HIEROGLYPH A022",
	"EGYPTIAN HIEROGLYPH A023",
	"EGYPTIAN HIEROGLYPH A024",
	"EGYPTIAN HIEROGLYPH A025",
	"EGYPTIAN HIEROGLYPH A026",
	"EGYPTIAN HIEROGLYPH A027",
	"EGYPTIAN HIEROGLYPH A028",
	"EGYPTIAN HIEROGLYPH A029",
	"EGYPTIAN HIEROGLYPH A030",
	"EGYPTIAN HIEROGLYPH A031",
	"EGYPTIAN HIEROGLYPH A032",
	"EGYPTIAN HIEROGLYPH A032A",
	"EGYPTIAN HIEROGLYPH A033",
	"EGYPTIAN HIEROGLYPH A034",
	"EGYPTIAN HIEROGLYPH A035",
	"EGYPTIAN HIEROGLYPH A036",
	"EGYPTIAN HIEROGLYPH A037",
	"EGYPTIAN HIEROGLYPH A038",
	"EGYPTIAN HIEROGLYPH A039",
	"EGYPTIAN HIEROGLYPH A040",
	"EGYPTIAN HIEROGLYPH A040A",
	"EGYPTIAN HIEROGLYPH A041",
	"EGYPTIAN HIEROGLYPH A042",
	"EGYPTIAN HIEROGLYPH A042A",
	"EGYPTIAN HIEROGLYPH A043",
	"EGYPTIAN HIEROGLYPH A043A",
	"EGYPTIAN HIEROGLYPH A044",
	"EGYPTIAN HIEROGLYPH A045",
	"EGYPTIAN HIEROGLYPH A045A",
	"EGYPTIAN HIEROGLYPH A046",
	"EGYPTIAN HIEROGLYPH A047",
	"EGYPTIAN HIEROGLYPH A048",
	"EGYPTIAN HIEROGLYPH A049",
	"EGYPTIAN HIEROGLYPH A050",
	"EGYPTIAN HIEROGLYPH A051",
	"EGYPTIAN HIEROGLYPH A052",
	"EGYPTIAN HIEROGLYPH A053",
	"EGYPTIAN HIEROGLYPH A054",
	"EGYPTIAN HIEROGLYPH A055",
	"EGYPTIAN HIEROGLYPH A056",
	"EGYPTIAN HIEROGLYPH A057",
	"EGYPTIAN HIEROGLYPH A058",
	"EGYPTIAN HIEROGLYPH A059",
	"EGYPTIAN HIEROGLYPH A060",
	"EGYPTIAN HIEROGLYPH A061",
	"EGYPTIAN HIEROGLYPH A062",
	"EGYPTIAN HIEROGLYPH A063",
	"EGYPTIAN HIEROGLYPH A064",
	"EGYPTIAN HIEROGLYPH A065",
	"EGYPTIAN HIEROGLYPH A066",
	"EGYPTIAN HIEROGLYPH A067",
	"EGYPTIAN HIEROGLYPH A068",
	"EGYPTIAN HIEROGLYPH A069",
	"EGYPTIAN HIEROGLYPH A070",
	"EGYPTIAN HIEROGLYPH B001",
	"EGYPTIAN HIEROGLYPH B002",
	"EGYPTIAN HIEROGLYPH B003",
	"EGYPTIAN HIEROGLYPH B004",
	"EGYPTIAN HIEROGLYPH B005",
	"EGYPTIAN HIEROGLYPH B005A",
	"EGYPTIAN HIEROGLYPH B006",
	"EGYPTIAN HIEROGLYPH B007",
	"EGYPTIAN HIEROGLYPH B008",
	"EGYPTIAN HIEROGLYPH B009",
	"EGYPTIAN HIEROGLYPH C001",
	"EGYPTIAN HIEROGLYPH C002",
	"EGYPTIAN HIEROGLYPH C002A",
	"EGYPTIAN HIEROGLYPH C002B",
	"EGYPTIAN HIEROGLYPH C002C",
	"EGYPTIAN HIEROGLYPH C003",
	"EGYPTIAN HIEROGLYPH C004",
	"EGYPTIAN HIEROGLYPH C005",
	"EGYPTIAN HIEROGLYPH C006",
	"EGYPTIAN HIEROGLYPH C007",
	"EGYPTIAN HIEROGLYPH C008",
	"EGYPTIAN HIEROGLYPH C009",
	"EGYPTIAN HIEROGLYPH C010",
	"EGYPTIAN HIEROGLYPH C010A",
	"EGYPTIAN HIEROGLYPH C011",
	"EGYPTIAN HIEROGLYPH C012",
	"EGYPTIAN HIEROGLYPH C013",
	"EGYPTIAN HIEROGLYPH C014",
	"EGYPTIAN HIEROGLYPH C015",
	"EGYPTIAN HIEROGLYPH C016",
	"EGYPTIAN HIEROGLYPH C017",
	"EGYPTIAN HIEROGLYPH C018",
	"EGYPTIAN HIEROGLYPH C019",
	"EGYPTIAN HIEROGLYPH C020",
	"EGYPTIAN HIEROGLYPH C021",
	"EGYPTIAN HIEROGLYPH C022",
	"EGYPTIAN HIEROGLYPH C023",
	"EGYPTIAN HIEROGLYPH C024",
	"EGYPTIAN HIEROGLYPH D001",
	"EGYPTIAN HIEROGLYPH D002",
	"EGYPTIAN HIEROGLYPH D003",
	"EGYPTIAN HIEROGLYPH D004",
	"EGYPTIAN HIEROGLYPH D005",
	"EGYPTIAN HIEROGLYPH D006",
	"EGYPTIAN HIEROGLYPH D007",
	"EGYPTIAN HIEROGLYPH D008",
	"EGYPTIAN HIEROGLYPH D008A",
	"EGYPTIAN HIEROGLYPH D009",
	"EGYPTIAN HIEROGLYPH D010",
	"EGYPTIAN HIEROGLYPH D011",
	"EGYPTIAN HIEROGLYPH D012",
	"EGYPTIAN HIEROGLYPH D013",
	"EGYPTIAN HIEROGLYPH D014",
	"EGYPTIAN HIEROGLYPH D015",
	"EGYPTIAN HIEROGLYPH D016",
	"EGYPTIAN HIEROGLYPH D017",
	"EGYPTIAN HIEROGLYPH D018",
	"EGYPTIAN HIEROGLYPH D019",
	"EGYPTIAN HIEROGLYPH D020",
	"EGYPTIAN HIEROGLYPH D021",
	"EGYPTIAN HIEROGLYPH D022",
	"EGYPTIAN HIEROGLYPH D023",
	"EGYPTIAN HIEROGLYPH D024",
	"EGYPTIAN HIEROGLYPH D025",
	"EGYPTIAN HIEROGLYPH D026",
	"EGYPTIAN HIEROGLYPH D027",
	"EGYPTIAN HIEROGLYPH D027A",
	"EGYPTIAN HIEROGLYPH D028",
	"EGYPTIAN HIEROGLYPH D029",
	"EGYPTIAN HIEROGLYPH D030",
	"EGYPTIAN HIEROGLYPH D031",
	"EGYPTIAN HIEROGLYPH D031A",
	"EGYPTIAN HIEROGLYPH D032",
	"EGYPTIAN HIEROGLYPH D033",
	"EGYPTIAN HIEROGLYPH D034",
	"EGYPTIAN HIEROGLYPH D034A",
	"EGYPTIAN HIEROGLYPH D035",
	"EGYPTIAN HIEROGLYPH D036",
	"EGYPTIAN HIEROGLYPH D037",
	"EGYPTIAN HIEROGLYPH D038",
	"EGYPTIAN HIEROGLYPH D039",
	"EGYPTIAN HIEROGLYPH D040",
	"EGYPTIAN HIEROGLYPH D041",
	"EGYPTIAN HIEROGLYPH D042",
	"EGYPTIAN HIEROGLYPH D043",
	"EGYPTIAN HIEROGLYPH D044",
	"EGYPTIAN HIEROGLYPH D045",
	"EGYPTIAN HIEROGLYPH D046",
	"EGYPTIAN HIEROGLYPH D046A",
	"EGYPTIAN HIEROGLYPH D047",
	"EGYPTIAN HIEROGLYPH D048",
	"EGYPTIAN HIEROGLYPH D048A",
	"EGYPTIAN HIEROGLYPH D049",
	"EGYPTIAN HIEROGLYPH D050",
	"EGYPTIAN HIEROGLYPH D050A",
	"EGYPTIAN HIEROGLYPH D050B",
	"EGYPTIAN HIEROGLYPH D050C",
	"EGYPTIAN HIEROGLYPH D050D",
	"EGYPTIAN HIEROGLYPH D050E",
	"EGYPTIAN HIEROGLYPH D050F",
	"EGYPTIAN HIEROGLYPH D050G",
	"EGYPTIAN HIEROGLYPH D050H",
	"EGYPTIAN HIEROGLYPH D050I",
	"EGYPTIAN HIEROGLYPH D051",
	"EGYPTIAN HIEROGLYPH D052",
	"EGYPTIAN HIEROGLYPH D052A",
	"EGYPTIAN HIEROGLYPH D053",
	"EGYPTIAN HIEROGLYPH D054",
	"EGYPTIAN HIEROGLYPH D054A",
	"EGYPTIAN HIEROGLYPH D055",
	"EGYPTIAN HIEROGLYPH D056",
	"EGYPTIAN HIEROGLYPH D057",
	"EGYPTIAN HIEROGLYPH D058",
	"EGYPTIAN HIEROGLYPH D059",
	"EGYPTIAN HIEROGLYPH D060",
	"EGYPTIAN HIEROGLYPH D061",
	"EGYPTIAN HIEROGLYPH D062",
	"EGYPTIAN HIEROGLYPH D063",
	"EGYPTIAN HIEROGLYPH D064",
	"EGYPTIAN HIEROGLYPH D065",
	"EGYPTIAN HIEROGLYPH D066",
	"EGYPTIAN HIEROGLYPH D067",
	"EGYPTIAN HIEROGLYPH D067A",
	"EGYPTIAN HIEROGLYPH D067B",
	"EGYPTIAN HIEROGLYPH D067C",
	"EGYPTIAN HIEROGLYPH D067D",
	"EGYPTIAN HIEROGLYPH D067E",
	"EGYPTIAN HIEROGLYPH D067F",
	"EGYPTIAN HIEROGLYPH D067G",
	"EGYPTIAN HIEROGLYPH D067H",
	"EGYPTIAN HIEROGLYPH E001",
	"EGYPTIAN HIEROGLYPH E002",
	"EGYPTIAN HIEROGLYPH E003",
	"EGYPTIAN HIEROGLYPH E004",
	"EGYPTIAN HIEROGLYPH E005",
	"EGYPTIAN HIEROGLYPH E006",
	"EGYPTIAN HIEROGLYPH E007",
	"EGYPTIAN HIEROGLYPH E008",
	"EGYPTIAN HIEROGLYPH E008A",
	"EGYPTIAN HIEROGLYPH E009",
	"EGYPTIAN HIEROGLYPH E009A",
	"EGYPTIAN HIEROGLYPH E010",
	"EGYPTIAN HIEROGLYPH E011",
	"EGYPTIAN HIEROGLYPH E012",
	"EGYPTIAN HIEROGLYPH E013",
	"EGYPTIAN HIEROGLYPH E014",
	"EGYPTIAN HIEROGLYPH E015",
	"EGYPTIAN HIEROGLYPH E016",
	"EGYPTIAN HIEROGLYPH E016A",
	"EGYPTIAN HIEROGLYPH E017",
	"EGYPTIAN HIEROGLYPH E017A",
	"EGYPTIAN HIEROGLYPH E018",
	"EGYPTIAN HIEROGLYPH E019",
	"EGYPTIAN HIEROGLYPH E020",
	"EGYPTIAN HIEROGLYPH E020A",
	"EGYPTIAN HIEROGLYPH E021",
	"EGYPTIAN HIEROGLYPH E022",
	"EGYPTIAN HIEROGLYPH E023",
	"EGYPTIAN HIEROGLYPH E024",
	"EGYPTIAN HIEROGLYPH E025",
	"EGYPTIAN HIEROGLYPH E026",
	"EGYPTIAN HIEROGLYPH E027",
	"EGYPTIAN HIEROGLYPH E028",
	"EGYPTIAN HIEROGLYPH E028A",
	"EGYPTIAN HIEROGLYPH E029",
	"EGYPTIAN HIEROGLYPH E030",
	"EGYPTIAN HIEROGLYPH E031",
	"EGYPTIAN HIEROGLYPH E032",
	"EGYPTIAN HIEROGLYPH E033",
	"EGYPTIAN HIEROGLYPH E034",
	"EGYPTIAN HIEROGLYPH E034A",
	"EGYPTIAN HIEROGLYPH E036",
	"EGYPTIAN HIEROGLYPH E037",
	"EGYPTIAN HIEROGLYPH E038",
	"EGYPTIAN HIEROGLYPH F001",
	"EGYPTIAN HIEROGLYPH F001A",
	"EGYPTIAN HIEROGLYPH F002",
	"EGYPTIAN HIEROGLYPH F003",
	"EGYPTIAN HIEROGLYPH F004",
	"EGYPTIAN HIEROGLYPH F005",
	"EGYPTIAN HIEROGLYPH F006",
	"EGYPTIAN HIEROGLYPH F007",
	"EGYPTIAN HIEROGLYPH F008",
	"EGYPTIAN HIEROGLYPH F009",
	"EGYPTIAN HIEROGLYPH F010",
	"EGYPTIAN HIEROGLYPH F011",
	"EGYPTIAN HIEROGLYPH F012",
	"EGYPTIAN HIEROGLYPH F013",
	"EGYPTIAN HIEROGLYPH F013A",
	"EGYPTIAN HIEROGLYPH F014",
	"EGYPTIAN HIEROGLYPH F015",
	"EGYPTIAN HIEROGLYPH F016",
	"EGYPTIAN HIEROGLYPH F017",
	"EGYPTIAN HIEROGLYPH F018",
	"EGYPTIAN HIEROGLYPH F019",
	"EGYPTIAN HIEROGLYPH F020",
	"EGYPTIAN HIEROGLYPH F021",
	"EGYPTIAN HIEROGLYPH F021A",
	"EGYPTIAN HIEROGLYPH F022",
	"EGYPTIAN HIEROGLYPH F023",
	"EGYPTIAN HIEROGLYPH F024",
	"EGYPTIAN HIEROGLYPH F025",
	"EGYPTIAN HIEROGLYPH F026",
	"EGYPTIAN HIEROGLYPH F027",
	"EGYPTIAN HIEROGLYPH F028",
	"EGYPTIAN HIEROGLYPH F029",
	"EGYPTIAN HIEROGLYPH F030",
	"EGYPTIAN HIEROGLYPH F031",
	"EGYPTIAN HIEROGLYPH F031A",
	"EGYPTIAN HIEROGLYPH F032",
	"EGYPTIAN HIEROGLYPH F033",
	"EGYPTIAN HIEROGLYPH F034",
	"EGYPTIAN HIEROGLYPH F035",
	"EGYPTIAN HIEROGLYPH F036",
	"EGYPTIAN HIEROGLYPH F037",
	"EGYPTIAN HIEROGLYPH F037A",
	"EGYPTIAN HIEROGLYPH F038",
	"EGYPTIAN HIEROGLYPH F038A",
	"EGYPTIAN HIEROGLYPH F039",
	"EGYPTIAN HIEROGLYPH F040",
	"EGYPTIAN HIEROGLYPH F041",
	"EGYPTIAN HIEROGLYPH F042",
	"EGYPTIAN HIEROGLYPH F043",
	"EGYPTIAN HIEROGLYPH F044",
	"EGYPTIAN HIEROGLYPH F045",
	"EGYPTIAN HIEROGLYPH F045A",
	"EGYPTIAN HIEROGLYPH F046",
	"EGYPTIAN HIEROGLYPH F046A",
	"EGYPTIAN HIEROGLYPH F047",
	"EGYPTIAN HIEROGLYPH F047A",
	"EGYPTIAN HIEROGLYPH F048",
	"EGYPTIAN HIEROGLYPH F049",
	"EGYPTIAN HIEROGLYPH F050",
	"EGYPTIAN HIEROGLYPH F051",
	"EGYPTIAN HIEROGLYPH F051A",
	"EGYPTIAN HIEROGLYPH F051B",
	"EGYPTIAN HIEROGLYPH F051C",
	"EGYPTIAN HIEROGLYPH F052",
	"EGYPTIAN HIEROGLYPH F053",
	"EGYPTIAN HIEROGLYPH G001",
	"EGYPTIAN HIEROGLYPH G002",
	"EGYPTIAN HIEROGLYPH G003",
	"EGYPTIAN HIEROGLYPH G004",
	"EGYPTIAN HIEROGLYPH G005",
	"EGYPTIAN HIEROGLYPH G006",
	"EGYPTIAN HIEROGLYPH G006A",
	"EGYPTIAN HIEROGLYPH G007",
	"EGYPTIAN HIEROGLYPH G007A",
	"EGYPTIAN HIEROGLYPH G007B",
	"EGYPTIAN HIEROGLYPH G008",
	"EGYPTIAN HIEROGLYPH G009",
	"EGYPTIAN HIEROGLYPH G010",
	"EGYPTIAN HIEROGLYPH G011",
	"EGYPTIAN HIEROGLYPH G011A",
	"EGYPTIAN HIEROGLYPH G012",
	"EGYPTIAN HIEROGLYPH G013",
	"EGYPTIAN HIEROGLYPH G014",
	"EGYPTIAN HIEROGLYPH G015",
	"EGYPTIAN HIEROGLYPH G016",
	"EGYPTIAN HIEROGLYPH G017",
	"EGYPTIAN HIEROGLYPH G018",
	"EGYPTIAN HIEROGLYPH G019",
	"EGYPTIAN HIEROGLYPH G020",
	"EGYPTIAN HIEROGLYPH G020A",
	"EGYPTIAN HIEROGLYPH G021",
	"EGYPTIAN HIEROGLYPH G022",
	"EGYPTIAN HIEROGLYPH G023",
	"EGYPTIAN HIEROGLYPH G024",
	"EGYPTIAN HIEROGLYPH G025",
	"EGYPTIAN HIEROGLYPH G026",
	"EGYPTIAN HIEROGLYPH G026A",
	"EGYPTIAN HIEROGLYPH G027",
	"EGYPTIAN HIEROGLYPH G028",
	"EGYPTIAN HIEROGLYPH G029",
	"EGYPTIAN HIEROGLYPH G030",
	"EGYPTIAN HIEROGLYPH G031",
	"EGYPTIAN HIEROGLYPH G032",
	"EGYPTIAN HIEROGLYPH G033",
	"EGYPTIAN HIEROGLYPH G034",
	"EGYPTIAN HIEROGLYPH G035",
	"EGYPTIAN HIEROGLYPH G036",
	"EGYPTIAN HIEROGLYPH G036A",
	"EGYPTIAN HIEROGLYPH G037",
	"EGYPTIAN HIEROGLYPH G037A",
	"EGYPTIAN HIEROGLYPH G038",
	"EGYPTIAN HIEROGLYPH G039",
	"EGYPTIAN HIEROGLYPH G040",
	"EGYPTIAN HIEROGLYPH G041",
	"EGYPTIAN HIEROGLYPH G042",
	"EGYPTIAN HIEROGLYPH G043",
	"EGYPTIAN HIEROGLYPH G043A",
	"EGYPTIAN HIEROGLYPH G044",
	"EGYPTIAN HIEROGLYPH G045",
	"EGYPTIAN HIEROGLYPH G045A",
	"EGYPTIAN HIEROGLYPH G046",
	"EGYPTIAN HIEROGLYPH G047",
	"EGYPTIAN HIEROGLYPH G048",
	"EGYPTIAN HIEROGLYPH G049",
	"EGYPTIAN HIEROGLYPH G050",
	"EGYPTIAN HIEROGLYPH G051",
	"EGYPTIAN HIEROGLYPH G052",
	"EGYPTIAN HIEROGLYPH G053",
	"EGYPTIAN HIEROGLYPH G054",
	"EGYPTIAN HIEROGLYPH H001",
	"EGYPTIAN HIEROGLYPH H002",
	"EGYPTIAN HIEROGLYPH H003",
	"EGYPTIAN HIEROGLYPH H004",
	"EGYPTIAN HIEROGLYPH H005",
	"EGYPTIAN HIEROGLYPH H006",
	"EGYPTIAN HIEROGLYPH H006A",
	"EGYPTIAN HIEROGLYPH H007",
	"EGYPTIAN HIEROGLYPH H008",
	"EGYPTIAN HIEROGLYPH I001",
	"EGYPTIAN HIEROGLYPH I002",
	"EGYPTIAN HIEROGLYPH I003",
	"EGYPTIAN HIEROGLYPH I004",
	"EGYPTIAN HIEROGLYPH I005",
	"EGYPTIAN HIEROGLYPH I005A",
	"EGYPTIAN HIEROGLYPH I006",
	"EGYPTIAN HIEROGLYPH I007",
	"EGYPTIAN HIEROGLYPH I008",
	"EGYPTIAN HIEROGLYPH I009",
	"EGYPTIAN HIEROGLYPH I009A",
	"EGYPTIAN HIEROGLYPH I010",
	"EGYPTIAN HIEROGLYPH I010A",
	"EGYPTIAN HIEROGLYPH I011",
	"EGYPTIAN HIEROGLYPH I011A",
	"EGYPTIAN HIEROGLYPH I012",
	"EGYPTIAN HIEROGLYPH I013",
	"EGYPTIAN HIEROGLYPH I014",
	"EGYPTIAN HIEROGLYPH I015",
	"EGYPTIAN HIEROGLYPH K001",
	"EGYPTIAN HIEROGLYPH K002",
	"EGYPTIAN HIEROGLYPH K003",
	"EGYPTIAN HIEROGLYPH K004",
	"EGYPTIAN HIEROGLYPH K005",
	"EGYPTIAN HIEROGLYPH K006",
	"EGYPTIAN HIEROGLYPH K007",
	"EGYPTIAN HIEROGLYPH K008",
	"EGYPTIAN HIEROGLYPH L001",
	"EGYPTIAN HIEROGLYPH L002",
	"EGYPTIAN HIEROGLYPH L002A",
	"EGYPTIAN HIEROGLYPH L003",
	"EGYPTIAN HIEROGLYPH L004",
	"EGYPTIAN HIEROGLYPH L005",
	"EGYPTIAN HIEROGLYPH L006",
	"EGYPTIAN HIEROGLYPH L006A",
	"EGYPTIAN HIEROGLYPH L007",
	"EGYPTIAN HIEROGLYPH L008",
	"EGYPTIAN HIEROGLYPH M001",
	"EGYPTIAN HIEROGLYPH M001A",
	"EGYPTIAN HIEROGLYPH M001B",
	"EGYPTIAN HIEROGLYPH M002",
	"EGYPTIAN HIEROGLYPH M003",
	"EGYPTIAN HIEROGLYPH M003A",
	"EGYPTIAN HIEROGLYPH M004",
	"EGYPTIAN HIEROGLYPH M005",
	"EGYPTIAN HIEROGLYPH M006",
	"EGYPTIAN HIEROGLYPH M007",
	"EGYPTIAN HIEROGLYPH M008",
	"EGYPTIAN HIEROGLYPH M009",
	"EGYPTIAN HIEROGLYPH M010",
	"EGYPTIAN HIEROGLYPH M010A",
	"EGYPTIAN HIEROGLYPH M011",
	"EGYPTIAN HIEROGLYPH M012",
	"EGYPTIAN HIEROGLYPH M012A",
	"EGYPTIAN HIEROGLYPH M012B",
	"EGYPTIAN HIEROGLYPH M012C",
	"EGYPTIAN HIEROGLYPH M012D",
	"EGYPTIAN HIEROGLYPH M012E",
	"EGYPTIAN HIEROGLYPH M012F",
	"EGYPTIAN HIEROGLYPH M012G",
	"EGYPTIAN HIEROGLYPH M012H",
	"EGYPTIAN HIEROGLYPH M013",
	"EGYPTIAN HIEROGLYPH M014",
	"EGYPTIAN HIEROGLYPH M015",
	"EGYPTIAN HIEROGLYPH M015A",
	"EGYPTIAN HIEROGLYPH M016",
	"EGYPTIAN HIEROGLYPH M016A",
	"EGYPTIAN HIEROGLYPH M017",
	"EGYPTIAN HIEROGLYPH M017A",
	"EGYPTIAN HIEROGLYPH M018",
	"EGYPTIAN HIEROGLYPH M019",
	"EGYPTIAN HIEROGLYPH M020",
	"EGYPTIAN HIEROGLYPH M021",
	"EGYPTIAN HIEROGLYPH M022",
	"EGYPTIAN HIEROGLYPH M022A",
	"EGYPTIAN HIEROGLYPH M023",
	"EGYPTIAN HIEROGLYPH M024",
	"EGYPTIAN HIEROGLYPH M024A",
	"EGYPTIAN HIEROGLYPH M025",
	"EGYPTIAN HIEROGLYPH M026",
	"EGYPTIAN HIEROGLYPH M027",
	"EGYPTIAN HIEROGLYPH M028",
	"EGYPTIAN HIEROGLYPH M028A",
	"EGYPTIAN HIEROGLYPH M029",
	"EGYPTIAN HIEROGLYPH M030",
	"EGYPTIAN HIEROGLYPH M031",
	"EGYPTIAN HIEROGLYPH M031A",
	"EGYPTIAN HIEROGLYPH M032",
	"EGYPTIAN HIEROGLYPH M033",
	"EGYPTIAN HIEROGLYPH M033A",
	"EGYPTIAN HIEROGLYPH M033B",
	"EGYPTIAN HIEROGLYPH M034",
	"EGYPTIAN HIEROGLYPH M035",
	"EGYPTIAN HIEROGLYPH M036",
	"EGYPTIAN HIEROGLYPH M037",
	"EGYPTIAN HIEROGLYPH M038",
	"EGYPTIAN HIEROGLYPH M039",
	"EGYPTIAN HIEROGLYPH M040",
	"EGYPTIAN HIEROGLYPH M040A",
	"EGYPTIAN HIEROGLYPH M041",
	"EGYPTIAN HIEROGLYPH M042",
	"EGYPTIAN HIEROGLYPH M043",
	"EGYPTIAN HIEROGLYPH M044",
	"EGYPTIAN HIEROGLYPH N001",
	"EGYPTIAN HIEROGLYPH N002",
	"EGYPTIAN HIEROGLYPH N003",
	"EGYPTIAN HIEROGLYPH N004",
	"EGYPTIAN HIEROGLYPH N005",
	"EGYPTIAN HIEROGLYPH N006",
	"EGYPTIAN HIEROGLYPH N007",
	"EGYPTIAN HIEROGLYPH N008",
	"EGYPTIAN HIEROGLYPH N009",
	"EGYPTIAN HIEROGLYPH N010",
	"EGYPTIAN HIEROGLYPH N011",
	"EGYPTIAN HIEROGLYPH N012",
	"EGYPTIAN HIEROGLYPH N013",
	"EGYPTIAN HIEROGLYPH N014",
	"EGYPTIAN HIEROGLYPH N015",
	"EGYPTIAN HIEROGLYPH N016",
	"EGYPTIAN HIEROGLYPH N017",
	"EGYPTIAN HIEROGLYPH N018",
	"EGYPTIAN HIEROGLYPH N018A",
	"EGYPTIAN HIEROGLYPH N018B",
	"EGYPTIAN HIEROGLYPH N019",
	"EGYPTIAN HIEROGLYPH N020",
	"EGYPTIAN HIEROGLYPH N021",
	"EGYPTIAN HIEROGLYPH N022",
	"EGYPTIAN HIEROGLYPH N023",
	"EGYPTIAN HIEROGLYPH N024",
	"EGYPTIAN HIEROGLYPH N025",
	"EGYPTIAN HIEROGLYPH N025A",
	"EGYPTIAN HIEROGLYPH N026",
	"EGYPTIAN HIEROGLYPH N027",
	"EGYPTIAN HIEROGLYPH N028",
	"EGYPTIAN HIEROGLYPH N029",
	"EGYPTIAN HIEROGLYPH N030",
	"EGYPTIAN HIEROGLYPH N031",
	"EGYPTIAN HIEROGLYPH N032",
	"EGYPTIAN HIEROGLYPH N033",
	"EGYPTIAN HIEROGLYPH N033A",
	"EGYPTIAN HIEROGLYPH N034",
	"EGYPTIAN HIEROGLYPH N034A",
	"EGYPTIAN HIEROGLYPH N035",
	"EGYPTIAN HIEROGLYPH N035A",
	"EGYPTIAN HIEROGLYPH N036",
	"EGYPTIAN HIEROGLYPH N037",
	"EGYPTIAN HIEROGLYPH N037A",
	"EGYPTIAN HIEROGLYPH N038",
	"EGYPTIAN HIEROGLYPH N039",
	"EGYPTIAN HIEROGLYPH N040",
	"EGYPTIAN HIEROGLYPH N041",
	"EGYPTIAN HIEROGLYPH N042",
	"EGYPTIAN HIEROGLYPH NL001",
	"EGYPTIAN HIEROGLYPH NL002",
	"EGYPTIAN HIEROGLYPH NL003",
	"EGYPTIAN HIEROGLYPH NL004",
	"EGYPTIAN HIEROGLYPH NL005",
	"EGYPTIAN HIEROGLYPH NL005A",
	"EGYPTIAN HIEROGLYPH NL006",
	"EGYPTIAN HIEROGLYPH NL007",
	"EGYPTIAN HIEROGLYPH NL008",
	"EGYPTIAN HIEROGLYPH NL009",
	"EGYPTIAN HIEROGLYPH NL010",
	"EGYPTIAN HIEROGLYPH NL011",
	"EGYPTIAN HIEROGLYPH NL012",
	"EGYPTIAN HIEROGLYPH NL013",
	"EGYPTIAN HIEROGLYPH NL014",
	"EGYPTIAN HIEROGLYPH NL015",
	"EGYPTIAN HIEROGLYPH NL016",
	"EGYPTIAN HIEROGLYPH NL017",
	"EGYPTIAN HIEROGLYPH NL017A",
	"EGYPTIAN HIEROGLYPH NL018",
	"EGYPTIAN HIEROGLYPH NL019",
	"EGYPTIAN HIEROGLYPH NL020",
	"EGYPTIAN HIEROGLYPH NU001",
	"EGYPTIAN HIEROGLYPH NU002",
	"EGYPTIAN HIEROGLYPH NU003",
	"EGYPTIAN HIEROGLYPH NU004",
	"EGYPTIAN HIEROGLYPH NU005",
	"EGYPTIAN HIEROGLYPH NU006",
	"EGYPTIAN HIEROGLYPH NU007",
	"EGYPTIAN HIEROGLYPH NU008",
	"EGYPTIAN HIEROGLYPH NU009",
	"EGYPTIAN HIEROGLYPH NU010",
	"EGYPTIAN HIEROGLYPH NU010A",
	"EGYPTIAN HIEROGLYPH NU011",
	"EGYPTIAN HIEROGLYPH NU011A",
	"EGYPTIAN HIEROGLYPH NU012",
	"EGYPTIAN HIEROGLYPH NU013",
	"EGYPTIAN HIEROGLYPH NU014",
	"EGYPTIAN HIEROGLYPH NU015",
	"EGYPTIAN HIEROGLYPH NU016",
	"EGYPTIAN HIEROGLYPH NU017",
	"EGYPTIAN HIEROGLYPH NU018",
	"EGYPTIAN HIEROGLYPH NU018A",
	"EGYPTIAN HIEROGLYPH NU019",
	"EGYPTIAN HIEROGLYPH NU020",
	"EGYPTIAN HIEROGLYPH NU021",
	"EGYPTIAN HIEROGLYPH NU022",
	"EGYPTIAN HIEROGLYPH NU022A",
	"EGYPTIAN HIEROGLYPH O001",
	"EGYPTIAN HIEROGLYPH O001A",
	"EGYPTIAN HIEROGLYPH O002",
	"EGYPTIAN HIEROGLYPH O003",
	"EGYPTIAN HIEROGLYPH O004",
	"EGYPTIAN HIEROGLYPH O005",
	"EGYPTIAN HIEROGLYPH O005A",
	"EGYPTIAN HIEROGLYPH O006",
	"EGYPTIAN HIEROGLYPH O006A",
	"EGYPTIAN HIEROGLYPH O006B",
	"EGYPTIAN HIEROGLYPH O006C",
	"EGYPTIAN HIEROGLYPH O006D",
	"EGYPTIAN HIEROGLYPH O006E",
	"EGYPTIAN HIEROGLYPH O006F",
	"EGYPTIAN HIEROGLYPH O007",
	"EGYPTIAN HIEROGLYPH O008",
	"EGYPTIAN HIEROGLYPH O009",
	"EGYPTIAN HIEROGLYPH O010",
	"EGYPTIAN HIEROGLYPH O010A",
	"EGYPTIAN HIEROGLYPH O010B",
	"EGYPTIAN HIEROGLYPH O010C",
	"EGYPTIAN HIEROGLYPH O011",
	"EGYPTIAN HIEROGLYPH O012",
	"EGYPTIAN HIEROGLYPH O013",
	"EGYPTIAN HIEROGLYPH O014",
	"EGYPTIAN HIEROGLYPH O015",
	"EGYPTIAN HIEROGLYPH O016",
	"EGYPTIAN HIEROGLYPH O017",
	"EGYPTIAN HIEROGLYPH O018",
	"EGYPTIAN HIEROGLYPH O019",
	"EGYPTIAN HIEROGLYPH O019A",
	"EGYPTIAN HIEROGLYPH O020",
	"EGYPTIAN HIEROGLYPH O020A",
	"EGYPTIAN HIEROGLYPH O021",
	"EGYPTIAN HIEROGLYPH O022",
	"EGYPTIAN HIEROGLYPH O023",
	"EGYPTIAN HIEROGLYPH O024",
	"EGYPTIAN HIEROGLYPH O024A",
	"EGYPTIAN HIEROGLYPH O025",
	"EGYPTIAN HIEROGLYPH O025A",
	"EGYPTIAN HIEROGLYPH O026",
	"EGYPTIAN HIEROGLYPH O027",
	"EGYPTIAN HIEROGLYPH O028",
	"EGYPTIAN HIEROGLYPH O029",
	"EGYPTIAN HIEROGLYPH O029A",
	"EGYPTIAN HIEROGLYPH O030",
	"EGYPTIAN HIEROGLYPH O030A",
	"EGYPTIAN HIEROGLYPH O031",
	"EGYPTIAN HIEROGLYPH O032",
	"EGYPTIAN HIEROGLYPH O033",
	"EGYPTIAN HIEROGLYPH O033A",
	"EGYPTIAN HIEROGLYPH O034",
	"EGYPTIAN HIEROGLYPH O035",
	"EGYPTIAN HIEROGLYPH O036",
	"EGYPTIAN HIEROGLYPH O036A",
	"EGYPTIAN HIEROGLYPH O036B",
	"EGYPTIAN HIEROGLYPH O036C",
	"EGYPTIAN HIEROGLYPH O036D",
	"EGYPTIAN HIEROGLYPH O037",
	"EGYPTIAN HIEROGLYPH O038",
	"EGYPTIAN HIEROGLYPH O039",
	"EGYPTIAN HIEROGLYPH O040",
	"EGYPTIAN HIEROGLYPH O041",
	"EGYPTIAN HIEROGLYPH O042",
	"EGYPTIAN HIEROGLYPH O043",
	"EGYPTIAN HIEROGLYPH O044",
	"EGYPTIAN HIEROGLYPH O045",
	"EGYPTIAN HIEROGLYPH O046",
	"EGYPTIAN HIEROGLYPH O047",
	"EGYPTIAN HIEROGLYPH O048",
	"EGYPTIAN HIEROGLYPH O049",
	"EGYPTIAN HIEROGLYPH O050",
	"EGYPTIAN HIEROGLYPH O050A",
	"EGYPTIAN HIEROGLYPH O050B",
	"EGYPTIAN HIEROGLYPH O051",
	"EGYPTIAN HIEROGLYPH P001",
	"EGYPTIAN HIEROGLYPH P001A",
	"EGYPTIAN HIEROGLYPH P002",
	"EGYPTIAN HIEROGLYPH P003",
	"EGYPTIAN HIEROGLYPH P003A",
	"EGYPTIAN HIEROGLYPH P004",
	"EGYPTIAN HIEROGLYPH P005",
	"EGYPTIAN HIEROGLYPH P006",
	"EGYPTIAN HIEROGLYPH P007",
	"EGYPTIAN HIEROGLYPH P008",
	"EGYPTIAN HIEROGLYPH P009",
	"EGYPTIAN HIEROGLYPH P010",
	"EGYPTIAN HIEROGLYPH P011",
	"EGYPTIAN HIEROGLYPH Q001",
	"EGYPTIAN HIEROGLYPH Q002",
	"EGYPTIAN HIEROGLYPH Q003",
	"EGYPTIAN HIEROGLYPH Q004",
	"EGYPTIAN HIEROGLYPH Q005",
	"EGYPTIAN HIEROGLYPH Q006",
	"EGYPTIAN HIEROGLYPH Q007",
	"EGYPTIAN HIEROGLYPH R001",
	"EGYPTIAN HIEROGLYPH R002",
	"EGYPTIAN HIEROGLYPH R002A",
	"EGYPTIAN HIEROGLYPH R003",
	"EGYPTIAN HIEROGLYPH R003A",
	"EGYPTIAN HIEROGLYPH R003B",
	"EGYPTIAN HIEROGLYPH R004",
	"EGYPTIAN HIEROGLYPH R005",
	"EGYPTIAN HIEROGLYPH R006",
	"EGYPTIAN HIEROGLYPH R007",
	"EGYPTIAN HIEROGLYPH R008",
	"EGYPTIAN HIEROGLYPH R009",
	"EGYPTIAN HIEROGLYPH R010",
	"EGYPTIAN HIEROGLYPH R010A",
	"EGYPTIAN HIEROGLYPH R011",
	"EGYPTIAN HIEROGLYPH R012",
	"EGYPTIAN HIEROGLYPH R013",
	"EGYPTIAN HIEROGLYPH R014",
	"EGYPTIAN HIEROGLYPH R015",
	"EGYPTIAN HIEROGLYPH R016",
	"EGYPTIAN HIEROGLYPH R016A",
	"EGYPTIAN HIEROGLYPH R017",
	"EGYPTIAN HIEROGLYPH R018",
	"EGYPTIAN HIEROGLYPH R019",
	"EGYPTIAN HIEROGLYPH R020",
	"EGYPTIAN HIEROGLYPH R021",
	"EGYPTIAN HIEROGLYPH R022",
	"EGYPTIAN HIEROGLYPH R023",
	"EGYPTIAN HIEROGLYPH R024",
	"EGYPTIAN HIEROGLYPH R025",
	"EGYPTIAN HIEROGLYPH R026",
	"EGYPTIAN HIEROGLYPH R027",
	"EGYPTIAN HIEROGLYPH R028",
	"EGYPTIAN HIEROGLYPH R029",
	"EGYPTIAN HIEROGLYPH S001",
	"EGYPTIAN HIEROGLYPH S002",
	"EGYPTIAN HIEROGLYPH S002A",
	"EGYPTIAN HIEROGLYPH S003",
	"EGYPTIAN HIEROGLYPH S004",
	"EGYPTIAN HIEROGLYPH S005",
	"EGYPTIAN HIEROGLYPH S006",
	"EGYPTIAN HIEROGLYPH S006A",
	"EGYPTIAN HIEROGLYPH S007",
	"EGYPTIAN HIEROGLYPH S008",
	"EGYPTIAN HIEROGLYPH S009",
	"EGYPTIAN HIEROGLYPH S010",
	"EGYPTIAN HIEROGLYPH S011",
	"EGYPTIAN HIEROGLYPH S012",
	"EGYPTIAN HIEROGLYPH S013",
	"EGYPTIAN HIEROGLYPH S014",
	"EGYPTIAN HIEROGLYPH S014A",
	"EGYPTIAN HIEROGLYPH S014B",
	"EGYPTIAN HIEROGLYPH S015",
	"EGYPTIAN HIEROGLYPH S016",
	"EGYPTIAN HIEROGLYPH S017",
	"EGYPTIAN HIEROGLYPH S017A",
	"EGYPTIAN HIEROGLYPH S018",
	"EGYPTIAN HIEROGLYPH S019",
	"EGYPTIAN HIEROGLYPH S020",
	"EGYPTIAN HIEROGLYPH S021",
	"EGYPTIAN HIEROGLYPH S022",
	"EGYPTIAN HIEROGLYPH S023",
	"EGYPTIAN HIEROGLYPH S024",
	"EGYPTIAN HIEROGLYPH S025",
	"EGYPTIAN HIEROGLYPH S026",
	"EGYPTIAN HIEROGLYPH S026A",
	"EGYPTIAN HIEROGLYPH S026B",
	"EGYPTIAN HIEROGLYPH S027",
	"EGYPTIAN HIEROGLYPH S028",
	"EGYPTIAN HIEROGLYPH S029",
	"EGYPTIAN HIEROGLYPH S030",
	"EGYPTIAN HIEROGLYPH S031",
	"EGYPTIAN HIEROGLYPH S032",
	"EGYPTIAN HIEROGLYPH S033",
	"EGYPTIAN HIEROGLYPH S034",
	"EGYPTIAN HIEROGLYPH S035",
	"EGYPTIAN HIEROGLYPH S035A",
	"EGYPTIAN HIEROGLYPH S036",
	"EGYPTIAN HIEROGLYPH S037",
	"EGYPTIAN HIEROGLYPH S038",
	"EGYPTIAN HIEROGLYPH S039",
	"EGYPTIAN HIEROGLYPH S040",
	"EGYPTIAN HIEROGLYPH S041",
	"EGYPTIAN HIEROGLYPH S042",
	"EGYPTIAN HIEROGLYPH S043",
	"EGYPTIAN HIEROGLYPH S044",
	"EGYPTIAN HIEROGLYPH S045",
	"EGYPTIAN HIEROGLYPH S046",
	"EGYPTIAN HIEROGLYPH T001",
	"EGYPTIAN HIEROGLYPH T002",
	"EGYPTIAN HIEROGLYPH T003",
	"EGYPTIAN HIEROGLYPH T003A",
	"EGYPTIAN HIEROGLYPH T004",
	"EGYPTIAN HIEROGLYPH T005",
	"EGYPTIAN HIEROGLYPH T006",
	"EGYPTIAN HIEROGLYPH T007",
	"EGYPTIAN HIEROGLYPH T007A",
	"EGYPTIAN HIEROGLYPH T008",
	"EGYPTIAN HIEROGLYPH T008A",
	"EGYPTIAN HIEROGLYPH T009",
	"EGYPTIAN HIEROGLYPH T009A",
	"EGYPTIAN HIEROGLYPH T010",
	"EGYPTIAN HIEROGLYPH T011",
	"EGYPTIAN HIEROGLYPH T011A",
	"EGYPTIAN HIEROGLYPH T012",
	"EGYPTIAN HIEROGLYPH T013",
	"EGYPTIAN HIEROGLYPH T014",
	"EGYPTIAN HIEROGLYPH T015",
	"EGYPTIAN HIEROGLYPH T016",
	"EGYPTIAN HIEROGLYPH T016A",
	"EGYPTIAN HIEROGLYPH T017",
	"EGYPTIAN HIEROGLYPH T018",
	"EGYPTIAN HIEROGLYPH T019",
	"EGYPTIAN HIEROGLYPH T020",
	"EGYPTIAN HIEROGLYPH T021",
	"EGYPTIAN HIEROGLYPH T022",
	"EGYPTIAN HIEROGLYPH T023",
	"EGYPTIAN HIEROGLYPH T024",
	"EGYPTIAN HIEROGLYPH T025",
	"EGYPTIAN HIEROGLYPH T026",
	"EGYPTIAN HIEROGLYPH T027",
	"EGYPTIAN HIEROGLYPH T028",
	"EGYPTIAN HIEROGLYPH T029",
	"EGYPTIAN HIEROGLYPH T030",
	"EGYPTIAN HIEROGLYPH T031",
	"EGYPTIAN HIEROGLYPH T032",
	"EGYPTIAN HIEROGLYPH T032A",
	"EGYPTIAN HIEROGLYPH T033",
	"EGYPTIAN HIEROGLYPH T033A",
	"EGYPTIAN HIEROGLYPH T034",
	"EGYPTIAN HIEROGLYPH T035",
	"EGYPTIAN HIEROGLYPH T036",
	"EGYPTIAN HIEROGLYPH U001",
	"EGYPTIAN HIEROGLYPH U002",
	"EGYPTIAN HIEROGLYPH U003",
	"EGYPTIAN HIEROGLYPH U004",
	"EGYPTIAN HIEROGLYPH U005",
	"EGYPTIAN HIEROGLYPH U006",
	"EGYPTIAN HIEROGLYPH U006A",
	"EGYPTIAN HIEROGLYPH U006B",
	"EGYPTIAN HIEROGLYPH U007",
	"EGYPTIAN HIEROGLYPH U008",
	"EGYPTIAN HIEROGLYPH U009",
	"EGYPTIAN HIEROGLYPH U010",
	"EGYPTIAN HIEROGLYPH U011",
	"EGYPTIAN HIEROGLYPH U012",
	"EGYPTIAN HIEROGLYPH U013",
	"EGYPTIAN HIEROGLYPH U014",
	"EGYPTIAN HIEROGLYPH U015",
	"EGYPTIAN HIEROGLYPH U016",
	"EGYPTIAN HIEROGLYPH U017",
	"EGYPTIAN HIEROGLYPH U018",
	"EGYPTIAN HIEROGLYPH U019",
	"EGYPTIAN HIEROGLYPH U020",
	"EGYPTIAN HIEROGLYPH U021",
	"EGYPTIAN HIEROGLYPH U022",
	"EGYPTIAN HIEROGLYPH U023",
	"EGYPTIAN HIEROGLYPH U023A",
	"EGYPTIAN HIEROGLYPH U024",
	"EGYPTIAN HIEROGLYPH U025",
	"EGYPTIAN HIEROGLYPH U026",
	"EGYPTIAN HIEROGLYPH U027",
	"EGYPTIAN HIEROGLYPH U028",
	"EGYPTIAN HIEROGLYPH U029",
	"EGYPTIAN HIEROGLYPH U029A",
	"EGYPTIAN HIEROGLYPH U030",
	"EGYPTIAN HIEROGLYPH U031",
	"EGYPTIAN HIEROGLYPH U032",
	"EGYPTIAN HIEROGLYPH U032A",
	"EGYPTIAN HIEROGLYPH U033",
	"EGYPTIAN HIEROGLYPH U034",
	"EGYPTIAN HIEROGLYPH U035",
	"EGYPTIAN HIEROGLYPH U036",
	"EGYPTIAN HIEROGLYPH U037",
	"EGYPTIAN HIEROGLYPH U038",
	"EGYPTIAN HIEROGLYPH U039",
	"EGYPTIAN HIEROGLYPH U040",
	"EGYPTIAN HIEROGLYPH U041",
	"EGYPTIAN HIEROGLYPH U042",
	"EGYPTIAN HIEROGLYPH V001",
	"EGYPTIAN HIEROGLYPH V001A",
	"EGYPTIAN HIEROGLYPH V001B",
	"EGYPTIAN HIEROGLYPH V001C",
	"EGYPTIAN HIEROGLYPH V001D",
	"EGYPTIAN HIEROGLYPH V001E",
	"EGYPTIAN HIEROGLYPH V001F",
	"EGYPTIAN HIEROGLYPH V001G",
	"EGYPTIAN HIEROGLYPH V001H",
	"EGYPTIAN HIEROGLYPH V001I",
	"EGYPTIAN HIEROGLYPH V002",
	"EGYPTIAN HIEROGLYPH V002A",
	"EGYPTIAN HIEROGLYPH V003",
	"EGYPTIAN HIEROGLYPH V004",
	"EGYPTIAN HIEROGLYPH V005",
	"EGYPTIAN HIEROGLYPH V006",
	"EGYPTIAN HIEROGLYPH V007",
	"EGYPTIAN HIEROGLYPH V007A",
	"EGYPTIAN HIEROGLYPH V007B",
	"EGYPTIAN HIEROGLYPH V008",
	"EGYPTIAN HIEROGLYPH V009",
	"EGYPTIAN HIEROGLYPH V010",
	"EGYPTIAN HIEROGLYPH V011",
	"EGYPTIAN HIEROGLYPH V011A",
	"EGYPTIAN HIEROGLYPH V011B",
	"EGYPTIAN HIEROGLYPH V011C",
	"EGYPTIAN HIEROGLYPH V012",
	"EGYPTIAN HIEROGLYPH V012A",
	"EGYPTIAN HIEROGLYPH V012B",
	"EGYPTIAN HIEROGLYPH V013",
	"EGYPTIAN HIEROGLYPH V014",
	"EGYPTIAN HIEROGLYPH V015",
	"EGYPTIAN HIEROGLYPH V016",
	"EGYPTIAN HIEROGLYPH V017",
	"EGYPTIAN HIEROGLYPH V018",
	"EGYPTIAN HIEROGLYPH V019",
	"EGYPTIAN HIEROGLYPH V020",
	"EGYPTIAN HIEROGLYPH V020A",
	"EGYPTIAN HIEROGLYPH V020B",
	"EGYPTIAN HIEROGLYPH V020C",
	"EGYPTIAN HIEROGLYPH V020D",
	"EGYPTIAN HIEROGLYPH V020E",
	"EGYPTIAN HIEROGLYPH V020F",
	"EGYPTIAN HIEROGLYPH V020G",
	"EGYPTIAN HIEROGLYPH V020H",
	"EGYPTIAN HIEROGLYPH V020I",
	"EGYPTIAN HIEROGLYPH V020J",
	"EGYPTIAN HIEROGLYPH V020K",
	"EGYPTIAN HIEROGLYPH V020L",
	"EGYPTIAN HIEROGLYPH V021",
	"EGYPTIAN HIEROGLYPH V022",
	"EGYPTIAN HIEROGLYPH V023",
	"EGYPTIAN HIEROGLYPH V023A",
	"EGYPTIAN HIEROGLYPH V024",
	"EGYPTIAN HIEROGLYPH V025",
	"EGYPTIAN HIEROGLYPH V026",
	"EGYPTIAN HIEROGLYPH V027",
	"EGYPTIAN HIEROGLYPH V028",
	"EGYPTIAN HIEROGLYPH V028A",
	"EGYPTIAN HIEROGLYPH V029",
	"EGYPTIAN HIEROGLYPH V029A",
	"EGYPTIAN HIEROGLYPH V030",
	"EGYPTIAN HIEROGLYPH V030A",
	"EGYPTIAN HIEROGLYPH V031",
	"EGYPTIAN HIEROGLYPH V031A",
	"EGYPTIAN HIEROGLYPH V032",
	"EGYPTIAN HIEROGLYPH V033",
	"EGYPTIAN HIEROGLYPH V033A",
	"EGYPTIAN HIEROGLYPH V034",
	"EGYPTIAN HIEROGLYPH V035",
	"EGYPTIAN HIEROGLYPH V036",
	"EGYPTIAN HIEROGLYPH V037",
	"EGYPTIAN HIEROGLYPH V037A",
	"EGYPTIAN HIEROGLYPH V038",
	"EGYPTIAN HIEROGLYPH V039",
	"EGYPTIAN HIEROGLYPH V040",
	"EGYPTIAN HIEROGLYPH V040A",
	"EGYPTIAN HIEROGLYPH W001",
	"EGYPTIAN HIEROGLYPH W002",
	"EGYPTIAN HIEROGLYPH W003",
	"EGYPTIAN HIEROGLYPH W003A",
	"EGYPTIAN HIEROGLYPH W004",
	"EGYPTIAN HIEROGLYPH W005",
	"EGYPTIAN HIEROGLYPH W006",
	"EGYPTIAN HIEROGLYPH W007",
	"EGYPTIAN HIEROGLYPH W008",
	"EGYPTIAN HIEROGLYPH W009",
	"EGYPTIAN HIEROGLYPH W009A",
	"EGYPTIAN HIEROGLYPH W010",
	"EGYPTIAN HIEROGLYPH W010A",
	"EGYPTIAN HIEROGLYPH W011",
	"EGYPTIAN HIEROGLYPH W012",
	"EGYPTIAN HIEROGLYPH W013",
	"EGYPTIAN HIEROGLYPH W014",
	"EGYPTIAN HIEROGLYPH W014A",
	"EGYPTIAN HIEROGLYPH W015",
	"EGYPTIAN HIEROGLYPH W016",
	"EGYPTIAN HIEROGLYPH W017",
	"EGYPTIAN HIEROGLYPH W017A",
	"EGYPTIAN HIEROGLYPH W018",
	"EGYPTIAN HIEROGLYPH W018A",
	"EGYPTIAN HIEROGLYPH W019",
	"EGYPTIAN HIEROGLYPH W020",
	"EGYPTIAN HIEROGLYPH W021",
	"EGYPTIAN HIEROGLYPH W022",
	"EGYPTIAN HIEROGLYPH W023",
	"EGYPTIAN HIEROGLYPH W024",
	"EGYPTIAN HIEROGLYPH W024A",
	"EGYPTIAN HIEROGLYPH W025",
	"EGYPTIAN HIEROGLYPH X001",
	"EGYPTIAN HIEROGLYPH X002",
	"EGYPTIAN HIEROGLYPH X003",
	"EGYPTIAN HIEROGLYPH X004",
	"EGYPTIAN HIEROGLYPH X004A",
	"EGYPTIAN HIEROGLYPH X004B",
	"EGYPTIAN HIEROGLYPH X005",
	"EGYPTIAN HIEROGLYPH X006",
	"EGYPTIAN HIEROGLYPH X006A",
	"EGYPTIAN HIEROGLYPH X007",
	"EGYPTIAN HIEROGLYPH X008",
	"EGYPTIAN HIEROGLYPH X008A",
	"EGYPTIAN HIEROGLYPH Y001",
	"EGYPTIAN HIEROGLYPH Y001A",
	"EGYPTIAN HIEROGLYPH Y002",
	"EGYPTIAN HIEROGLYPH Y003",
	"EGYPTIAN HIEROGLYPH Y004",
	"EGYPTIAN HIEROGLYPH Y005",
	"EGYPTIAN HIEROGLYPH Y006",
	"EGYPTIAN HIEROGLYPH Y007",
	"EGYPTIAN HIEROGLYPH Y008",
	"EGYPTIAN HIEROGLYPH Z001",
	"EGYPTIAN HIEROGLYPH Z002",
	"EGYPTIAN HIEROGLYPH Z002A",
	"EGYPTIAN HIEROGLYPH Z002B",
	"EGYPTIAN HIEROGLYPH Z002C",
	"EGYPTIAN HIEROGLYPH Z002D",
	"EGYPTIAN HIEROGLYPH Z003",
	"EGYPTIAN HIEROGLYPH Z003A",
	"EGYPTIAN HIEROGLYPH Z003B",
	"EGYPTIAN HIEROGLYPH Z004",
	"EGYPTIAN HIEROGLYPH Z004A",
	"EGYPTIAN HIEROGLYPH Z005",
	"EGYPTIAN HIEROGLYPH Z005A",
	"EGYPTIAN HIEROGLYPH Z006",
	"EGYPTIAN HIEROGLYPH Z007",
	"EGYPTIAN HIEROGLYPH Z008",
	"EGYPTIAN HIEROGLYPH Z009",
	"EGYPTIAN HIEROGLYPH Z010",
	"EGYPTIAN HIEROGLYPH Z011",
	"EGYPTIAN HIEROGLYPH Z012",
	"EGYPTIAN HIEROGLYPH Z013",
	"EGYPTIAN HIEROGLYPH Z014",
	"EGYPTIAN HIEROGLYPH Z015",
	"EGYPTIAN HIEROGLYPH Z015A",
	"EGYPTIAN HIEROGLYPH Z015B",
	"EGYPTIAN HIEROGLYPH Z015C",
	"EGYPTIAN HIEROGLYPH Z015D",
	"EGYPTIAN HIEROGLYPH Z015E",
	"EGYPTIAN HIEROGLYPH Z015F",
	"EGYPTIAN HIEROGLYPH Z015G",
	"EGYPTIAN HIEROGLYPH Z015H",
	"EGYPTIAN HIEROGLYPH Z015I",
	"EGYPTIAN HIEROGLYPH Z016",
	"EGYPTIAN HIEROGLYPH Z016A",
	"EGYPTIAN HIEROGLYPH Z016B",
	"EGYPTIAN HIEROGLYPH Z016C",
	"EGYPTIAN HIEROGLYPH Z016D",
	"EGYPTIAN HIEROGLYPH Z016E",
	"EGYPTIAN HIEROGLYPH Z016F",
	"EGYPTIAN HIEROGLYPH Z016G",
	"EGYPTIAN HIEROGLYPH Z016H",
	"EGYPTIAN HIEROGLYPH AA001",
	"EGYPTIAN HIEROGLYPH AA002",
	"EGYPTIAN HIEROGLYPH AA003",
	"EGYPTIAN HIEROGLYPH AA004",
	"EGYPTIAN HIEROGLYPH AA005",
	"EGYPTIAN HIEROGLYPH AA006",
	"EGYPTIAN HIEROGLYPH AA007",
	"EGYPTIAN HIEROGLYPH AA007A",
	"EGYPTIAN HIEROGLYPH AA007B",
	"EGYPTIAN HIEROGLYPH AA008",
	"EGYPTIAN HIEROGLYPH AA009",
	"EGYPTIAN HIEROGLYPH AA010",
	"EGYPTIAN HIEROGLYPH AA011",
	"EGYPTIAN HIEROGLYPH AA012",
	"EGYPTIAN HIEROGLYPH AA013",
	"EGYPTIAN HIEROGLYPH AA014",
	"EGYPTIAN HIEROGLYPH AA015",
	"EGYPTIAN HIEROGLYPH AA016",
	"EGYPTIAN HIEROGLYPH AA017",
	"EGYPTIAN HIEROGLYPH AA018",
	"EGYPTIAN HIEROGLYPH AA019",
	"EGYPTIAN HIEROGLYPH AA020",
	"EGYPTIAN HIEROGLYPH AA021",
	"EGYPTIAN HIEROGLYPH AA022",
	"EGYPTIAN HIEROGLYPH AA023",
	"EGYPTIAN HIEROGLYPH AA024",
	"EGYPTIAN HIEROGLYPH AA025",
	"EGYPTIAN HIEROGLYPH AA026",
	"EGYPTIAN HIEROGLYPH AA027",
	"EGYPTIAN HIEROGLYPH AA028",
	"EGYPTIAN HIEROGLYPH AA029",
	"EGYPTIAN HIEROGLYPH AA030",
	"EGYPTIAN HIEROGLYPH AA031",
	"EGYPTIAN HIEROGLYPH AA032",
	"EGYPTIAN HIEROGLYPH V011D",
	"EGYPTIAN HIEROGLYPH VERTICAL JOINER",
	"EGYPTIAN HIEROGLYPH HORIZONTAL JOINER",
	"EGYPTIAN HIEROGLYPH INSERT AT TOP START",
	"EGYPTIAN HIEROGLYPH INSERT AT BOTTOM START",
	"EGYPTIAN HIEROGLYPH INSERT AT TOP END",
	"EGYPTIAN HIEROGLYPH INSERT AT BOTTOM END",
	"EGYPTIAN HIEROGLYPH OVERLAY MIDDLE",
	"EGYPTIAN HIEROGLYPH BEGIN SEGMENT",
	"EGYPTIAN HIEROGLYPH END SEGMENT",
	"EGYPTIAN HIEROGLYPH INSERT AT MIDDLE",
	"EGYPTIAN HIEROGLYPH INSERT AT TOP",
	"EGYPTIAN HIEROGLYPH INSERT AT BOTTOM",
	"EGYPTIAN HIEROGLYPH BEGIN ENCLOSURE",
	"EGYPTIAN HIEROGLYPH END ENCLOSURE",
	"EGYPTIAN HIEROGLYPH BEGIN WALLED ENCLOSURE",
	"EGYPTIAN HIEROGLYPH END WALLED ENCLOSURE",
	"EGYPTIAN HIEROGLYPH MIRROR HORIZONTALLY",
	"EGYPTIAN HIEROGLYPH FULL BLANK",
	"EGYPTIAN HIEROGLYPH HALF BLANK",
	"EGYPTIAN HIEROGLYPH LOST SIGN",
	"EGYPTIAN HIEROGLYPH HALF LOST SIGN",
	"EGYPTIAN HIEROGLYPH TALL LOST SIGN",
	"EGYPTIAN HIEROGLYPH WIDE LOST SIGN",
	"EGYPTIAN HIEROGLYPH MODIFIER DAMAGED AT TOP START",
	"EGYPTIAN HIEROGLYPH MODIFIER DAMAGED AT BOTTOM START",
	"EGYPTIAN HIEROGLYPH MODIFIER DAMAGED AT START",
	"EGYPTIAN HIEROGLYPH MODIFIER DAMAGED AT TOP END",
	"EGYPTIAN HIEROGLYPH MODIFIER DAMAGED AT TOP",
	"EGYPTIAN HIEROGLYPH MODIFIER DAMAGED AT BOTTOM START AND TOP END",
	"EGYPTIAN HIEROGLYPH MODIFIER DAMAGED AT START AND TOP",
	"EGYPTIAN HIEROGLYPH MODIFIER DAMAGED AT BOTTOM END",
	"EGYPTIAN HIEROGLYPH MODIFIER DAMAGED AT TOP START AND BOTTOM END",
	"EGYPTIAN HIEROGLYPH MODIFIER DAMAGED AT BOTTOM",
	"EGYPTIAN HIEROGLYPH MODIFIER DAMAGED AT START AND BOTTOM",
	"EGYPTIAN HIEROGLYPH MODIFIER DAMAGED AT END",
	"EGYPTIAN HIEROGLYPH MODIFIER DAMAGED AT TOP AND END",
	"EGYPTIAN HIEROGLYPH MODIFIER DAMAGED AT BOTTOM AND END",
	"EGYPTIAN HIEROGLYPH MODIFIER DAMAGED",
	"ANATOLIAN HIEROGLYPH A001",
	"ANATOLIAN HIEROGLYPH A002",
	"ANATOLIAN HIEROGLYPH A003",
	"ANATOLIAN HIEROGLYPH A004",
	"ANATOLIAN HIEROGLYPH A005",
	"ANATOLIAN HIEROGLYPH A006",
	"ANATOLIAN HIEROGLYPH A007",
	"ANATOLIAN HIEROGLYPH A008",
	"ANATOLIAN HIEROGLYPH A009",
	"ANATOLIAN HIEROGLYPH A010",
	"ANATOLIAN HIEROGLYPH A010A",
	"ANATOLIAN HIEROGLYPH A011",
	"ANATOLIAN HIEROGLYPH A012",
	"ANATOLIAN HIEROGLYPH A013",
	"ANATOLIAN HIEROGLYPH A014",
	"ANATOLIAN HIEROGLYPH A015",
	"ANATOLIAN HIEROGLYPH A016",
	"ANATOLIAN HIEROGLYPH A017",
	"ANATOLIAN HIEROGLYPH A018",
	"ANATOLIAN HIEROGLYPH A019",
	"ANATOLIAN HIEROGLYPH A020",
	"ANATOLIAN HIEROGLYPH A021",
	"ANATOLIAN HIEROGLYPH A022",
	"ANATOLIAN HIEROGLYPH A023",
	"ANATOLIAN HIEROGLYPH A024",
	"ANATOLIAN HIEROGLYPH A025",
	"ANATOLIAN HIEROGLYPH A026",
	"ANATOLIAN HIEROGLYPH A026A",
	"ANATOLIAN HIEROGLYPH A027",
	"ANATOLIAN HIEROGLYPH A028",
	"ANATOLIAN HIEROGLYPH A029",
	"ANATOLIAN HIEROGLYPH A030",
	"ANATOLIAN HIEROGLYPH A031",
	"ANATOLIAN HIEROGLYPH A032",
	"ANATOLIAN HIEROGLYPH A033",
	"ANATOLIAN HIEROGLYPH A034",
	"ANATOLIAN HIEROGLYPH A035",
	"ANATOLIAN HIEROGLYPH A036",
	"ANATOLIAN HIEROGLYPH A037",
	"ANATOLIAN HIEROGLYPH A038",
	"ANATOLIAN HIEROGLYPH A039",
	"ANATOLIAN HIEROGLYPH A039A",
	"ANATOLIAN HIEROGLYPH A040",
	"ANATOLIAN HIEROGLYPH A041",
	"ANATOLIAN HIEROGLYPH A041A",
	"ANATOLIAN HIEROGLYPH A042",
	"ANATOLIAN HIEROGLYPH A043",
	"ANATOLIAN HIEROGLYPH A044",
	"ANATOLIAN HIEROGLYPH A045",
	"ANATOLIAN HIEROGLYPH A045A",
	"ANATOLIAN HIEROGLYPH A046",
	"ANATOLIAN HIEROGLYPH A046A",
	"ANATOLIAN HIEROGLYPH A046B",
	"ANATOLIAN HIEROGLYPH A047",
	"ANATOLIAN HIEROGLYPH A048",
	"ANATOLIAN HIEROGLYPH A049",
	"ANATOLIAN HIEROGLYPH A050",
	"ANATOLIAN HIEROGLYPH A051",
	"ANATOLIAN HIEROGLYPH A052",
	"ANATOLIAN HIEROGLYPH A053",
	"ANATOLIAN HIEROGLYPH A054",
	"ANATOLIAN HIEROGLYPH A055",
	"ANATOLIAN HIEROGLYPH A056",
	"ANATOLIAN HIEROGLYPH A057",
	"ANATOLIAN HIEROGLYPH A058",
	"ANATOLIAN HIEROGLYPH A059",
	"ANATOLIAN HIEROGLYPH A060",
	"ANATOLIAN HIEROGLYPH A061",
	"ANATOLIAN HIEROGLYPH A062",
	"ANATOLIAN HIEROGLYPH A063",
	"ANATOLIAN HIEROGLYPH A064",
	"ANATOLIAN HIEROGLYPH A065",
	"ANATOLIAN HIEROGLYPH A066",
	"ANATOLIAN HIEROGLYPH A066A",
	"ANATOLIAN HIEROGLYPH A066B",
	"ANATOLIAN HIEROGLYPH A066C",
	"ANATOLIAN HIEROGLYPH A067",
	"ANATOLIAN HIEROGLYPH A068",
	"ANATOLIAN HIEROGLYPH A069",
	"ANATOLIAN HIEROGLYPH A070",
	"ANATOLIAN HIEROGLYPH A071",
	"ANATOLIAN HIEROGLYPH A072",
	"ANATOLIAN HIEROGLYPH A073",
	"ANATOLIAN HIEROGLYPH A074",
	"ANATOLIAN HIEROGLYPH A075",
	"ANATOLIAN HIEROGLYPH A076",
	"ANATOLIAN HIEROGLYPH A077",
	"ANATOLIAN HIEROGLYPH A078",
	"ANATOLIAN HIEROGLYPH A079",
	"ANATOLIAN HIEROGLYPH A080",
	"ANATOLIAN HIEROGLYPH A081",
	"ANATOLIAN HIEROGLYPH A082",
	"ANATOLIAN HIEROGLYPH A083",
	"ANATOLIAN HIEROGLYPH A084",
	"ANATOLIAN HIEROGLYPH A085",
	"ANATOLIAN HIEROGLYPH A086",
	"ANATOLIAN HIEROGLYPH A087",
	"ANATOLIAN HIEROGLYPH A088",
	"ANATOLIAN HIEROGLYPH A089",
	"ANATOLIAN HIEROGLYPH A090",
	"ANATOLIAN HIEROGLYPH A091",
	"ANATOLIAN HIEROGLYPH A092",
	"ANATOLIAN HIEROGLYPH A093",
	"ANATOLIAN HIEROGLYPH A094",
	"ANATOLIAN HIEROGLYPH A095",
	"ANATOLIAN HIEROGLYPH A096",
	"ANATOLIAN HIEROGLYPH A097",
	"ANATOLIAN HIEROGLYPH A097A",
	"ANATOLIAN HIEROGLYPH A098",
	"ANATOLIAN HIEROGLYPH A098A",
	"ANATOLIAN HIEROGLYPH A099",
	"ANATOLIAN HIEROGLYPH A100",
	"ANATOLIAN HIEROGLYPH A100A",
	"ANATOLIAN HIEROGLYPH A101",
	"ANATOLIAN HIEROGLYPH A101A",
	"ANATOLIAN HIEROGLYPH A102",
	"ANATOLIAN HIEROGLYPH A102A",
	"ANATOLIAN HIEROGLYPH A103",
	"ANATOLIAN HIEROGLYPH A104",
	"ANATOLIAN HIEROGLYPH A104A",
	"ANATOLIAN HIEROGLYPH A104B",
	"ANATOLIAN HIEROGLYPH A104C",
	"ANATOLIAN HIEROGLYPH A105",
	"ANATOLIAN HIEROGLYPH A105A",
	"ANATOLIAN HIEROGLYPH A105B",
	"ANATOLIAN HIEROGLYPH A106",
	"ANATOLIAN HIEROGLYPH A107",
	"ANATOLIAN HIEROGLYPH A107A",
	"ANATOLIAN HIEROGLYPH A107B",
	"ANATOLIAN HIEROGLYPH A107C",
	"ANATOLIAN HIEROGLYPH A108",
	"ANATOLIAN HIEROGLYPH A109",
	"ANATOLIAN HIEROGLYPH A110",
	"ANATOLIAN HIEROGLYPH A110A",
	"ANATOLIAN HIEROGLYPH A110B",
	"ANATOLIAN HIEROGLYPH A111",
	"ANATOLIAN HIEROGLYPH A112",
	"ANATOLIAN HIEROGLYPH A113",
	"ANATOLIAN HIEROGLYPH A114",
	"ANATOLIAN HIEROGLYPH A115",
	"ANATOLIAN HIEROGLYPH A115A",
	"ANATOLIAN HIEROGLYPH A116",
	"ANATOLIAN HIEROGLYPH A117",
	"ANATOLIAN HIEROGLYPH A118",
	"ANATOLIAN HIEROGLYPH A119",
	"ANATOLIAN HIEROGLYPH A120",
	"ANATOLIAN HIEROGLYPH A121",
	"ANATOLIAN HIEROGLYPH A122",
	"ANATOLIAN HIEROGLYPH A123",
	"ANATOLIAN HIEROGLYPH A124",
	"ANATOLIAN HIEROGLYPH A125",
	"ANATOLIAN HIEROGLYPH A125A",
	"ANATOLIAN HIEROGLYPH A126",
	"ANATOLIAN HIEROGLYPH A127",
	"ANATOLIAN HIEROGLYPH A128",
	"ANATOLIAN HIEROGLYPH A129",
	"ANATOLIAN HIEROGLYPH A130",
	"ANATOLIAN HIEROGLYPH A131",
	"ANATOLIAN HIEROGLYPH A132",
	"ANATOLIAN HIEROGLYPH A133",
	"ANATOLIAN HIEROGLYPH A134",
	"ANATOLIAN HIEROGLYPH A135",
	"ANATOLIAN HIEROGLYPH A135A",
	"ANATOLIAN HIEROGLYPH A136",
	"ANATOLIAN HIEROGLYPH A137",
	"ANATOLIAN HIEROGLYPH A138",
	"ANATOLIAN HIEROGLYPH A139",
	"ANATOLIAN HIEROGLYPH A140",
	"ANATOLIAN HIEROGLYPH A141",
	"ANATOLIAN HIEROGLYPH A142",
	"ANATOLIAN HIEROGLYPH A143",
	"ANATOLIAN HIEROGLYPH A144",
	"ANATOLIAN HIEROGLYPH A145",
	"ANATOLIAN HIEROGLYPH A146",
	"ANATOLIAN HIEROGLYPH A147",
	"ANATOLIAN HIEROGLYPH A148",
	"ANATOLIAN HIEROGLYPH A149",
	"ANATOLIAN HIEROGLYPH A150",
	"ANATOLIAN HIEROGLYPH A151",
	"ANATOLIAN HIEROGLYPH A152",
	"ANATOLIAN HIEROGLYPH A153",
	"ANATOLIAN HIEROGLYPH A154",
	"ANATOLIAN HIEROGLYPH A155",
	"ANATOLIAN HIEROGLYPH A156",
	"ANATOLIAN HIEROGLYPH A157",
	"ANATOLIAN HIEROGLYPH A158",
	"ANATOLIAN HIEROGLYPH A159",
	"ANATOLIAN HIEROGLYPH A160",
	"ANATOLIAN HIEROGLYPH A161",
	"ANATOLIAN HIEROGLYPH A162",
	"ANATOLIAN HIEROGLYPH A163",
	"ANATOLIAN HIEROGLYPH A164",
	"ANATOLIAN HIEROGLYPH A165",
	"ANATOLIAN HIEROGLYPH A166",
	"ANATOLIAN HIEROGLYPH A167",
	"ANATOLIAN HIEROGLYPH A168",
	"ANATOLIAN HIEROGLYPH A169",
	"ANATOLIAN HIEROGLYPH A170",
	"ANATOLIAN HIEROGLYPH A171",
	"ANATOLIAN HIEROGLYPH A172",
	"ANATOLIAN HIEROGLYPH A173",
	"ANATOLIAN HIEROGLYPH A174",
	"ANATOLIAN HIEROGLYPH A175",
	"ANATOLIAN HIEROGLYPH A176",
	"ANATOLIAN HIEROGLYPH A177",
	"ANATOLIAN HIEROGLYPH A178",
	"ANATOLIAN HIEROGLYPH A179",
	"ANATOLIAN HIEROGLYPH A180",
	"ANATOLIAN HIEROGLYPH A181",
	"ANATOLIAN HIEROGLYPH A182",
	"ANATOLIAN HIEROGLYPH A183",
	"ANATOLIAN HIEROGLYPH A184",
	"ANATOLIAN HIEROGLYPH A185",
	"ANATOLIAN HIEROGLYPH A186",
	"ANATOLIAN HIEROGLYPH A187",
	"ANATOLIAN HIEROGLYPH A188",
	"ANATOLIAN HIEROGLYPH A189",
	"ANATOLIAN HIEROGLYPH A190",
	"ANATOLIAN HIEROGLYPH A191",
	"ANATOLIAN HIEROGLYPH A192",
	"ANATOLIAN HIEROGLYPH A193",
	"ANATOLIAN HIEROGLYPH A194",
	"ANATOLIAN HIEROGLYPH A195",
	"ANATOLIAN HIEROGLYPH A196",
	"ANATOLIAN HIEROGLYPH A197",
	"ANATOLIAN HIEROGLYPH A198",
	"ANATOLIAN HIEROGLYPH A199",
	"ANATOLIAN HIEROGLYPH A200",
	"ANATOLIAN HIEROGLYPH A201",
	"ANATOLIAN HIEROGLYPH A202",
	"ANATOLIAN HIEROGLYPH A202A",
	"ANATOLIAN HIEROGLYPH A202B",
	"ANATOLIAN HIEROGLYPH A203",
	"ANATOLIAN HIEROGLYPH A204",
	"ANATOLIAN HIEROGLYPH A205",
	"ANATOLIAN HIEROGLYPH A206",
	"ANATOLIAN HIEROGLYPH A207",
	"ANATOLIAN HIEROGLYPH A207A",
	"ANATOLIAN HIEROGLYPH A208",
	"ANATOLIAN HIEROGLYPH A209",
	"ANATOLIAN HIEROGLYPH A209A",
	"ANATOLIAN HIEROGLYPH A210",
	"ANATOLIAN HIEROGLYPH A211",
	"ANATOLIAN HIEROGLYPH A212",
	"ANATOLIAN HIEROGLYPH A213",
	"ANATOLIAN HIEROGLYPH A214",
	"ANATOLIAN HIEROGLYPH A215",
	"ANATOLIAN HIEROGLYPH A215A",
	"ANATOLIAN HIEROGLYPH A216",
	"ANATOLIAN HIEROGLYPH A216A",
	"ANATOLIAN HIEROGLYPH A217",
	"ANATOLIAN HIEROGLYPH A218",
	"ANATOLIAN HIEROGLYPH A219",
	"ANATOLIAN HIEROGLYPH A220",
	"ANATOLIAN HIEROGLYPH A221",
	"ANATOLIAN HIEROGLYPH A222",
	"ANATOLIAN HIEROGLYPH A223",
	"ANATOLIAN HIEROGLYPH A224",
	"ANATOLIAN HIEROGLYPH A225",
	"ANATOLIAN HIEROGLYPH A226",
	"ANATOLIAN HIEROGLYPH A227",
	"ANATOLIAN HIEROGLYPH A227A",
	"ANATOLIAN HIEROGLYPH A228",
	"ANATOLIAN HIEROGLYPH A229",
	"ANATOLIAN HIEROGLYPH A230",
	"ANATOLIAN HIEROGLYPH A231",
	"ANATOLIAN HIEROGLYPH A232",
	"ANATOLIAN HIEROGLYPH A233",
	"ANATOLIAN HIEROGLYPH A234",
	"ANATOLIAN HIEROGLYPH A235",
	"ANATOLIAN HIEROGLYPH A236",
	"ANATOLIAN HIEROGLYPH A237",
	"ANATOLIAN HIEROGLYPH A238",
	"ANATOLIAN HIEROGLYPH A239",
	"ANATOLIAN HIEROGLYPH A240",
	"ANATOLIAN HIEROGLYPH A241",
	"ANATOLIAN HIEROGLYPH A242",
	"ANATOLIAN HIEROGLYPH A243",
	"ANATOLIAN HIEROGLYPH A244",
	"ANATOLIAN HIEROGLYPH A245",
	"ANATOLIAN HIEROGLYPH A246",
	"ANATOLIAN HIEROGLYPH A247",
	"ANATOLIAN HIEROGLYPH A248",
	"ANATOLIAN HIEROGLYPH A249",
	"ANATOLIAN HIEROGLYPH A250",
	"ANATOLIAN HIEROGLYPH A251",
	"ANATOLIAN HIEROGLYPH A252",
	"ANATOLIAN HIEROGLYPH A253",
	"ANATOLIAN HIEROGLYPH A254",
	"ANATOLIAN HIEROGLYPH A255",
	"ANATOLIAN HIEROGLYPH A256",
	"ANATOLIAN HIEROGLYPH A257",
	"ANATOLIAN HIEROGLYPH A258",
	"ANATOLIAN HIEROGLYPH A259",
	"ANATOLIAN HIEROGLYPH A260",
	"ANATOLIAN HIEROGLYPH A261",
	"ANATOLIAN HIEROGLYPH A262",
	"ANATOLIAN HIEROGLYPH A263",
	"ANATOLIAN HIEROGLYPH A264",
	"ANATOLIAN HIEROGLYPH A265",
	"ANATOLIAN HIEROGLYPH A266",
	"ANATOLIAN HIEROGLYPH A267",
	"ANATOLIAN HIEROGLYPH A267A",
	"ANATOLIAN HIEROGLYPH A268",
	"ANATOLIAN HIEROGLYPH A269",
	"ANATOLIAN HIEROGLYPH A270",
	"ANATOLIAN HIEROGLYPH A271",
	"ANATOLIAN HIEROGLYPH A272",
	"ANATOLIAN HIEROGLYPH A273",
	"ANATOLIAN HIEROGLYPH A274",
	"ANATOLIAN HIEROGLYPH A275",
	"ANATOLIAN HIEROGLYPH A276",
	"ANATOLIAN HIEROGLYPH A277",
	"ANATOLIAN HIEROGLYPH A278",
	"ANATOLIAN HIEROGLYPH A279",
	"ANATOLIAN HIEROGLYPH A280",
	"ANATOLIAN HIEROGLYPH A281",
	"ANATOLIAN HIEROGLYPH A282",
	"ANATOLIAN HIEROGLYPH A283",
	"ANATOLIAN HIEROGLYPH A284",
	"ANATOLIAN HIEROGLYPH A285",
	"ANATOLIAN HIEROGLYPH A286",
	"ANATOLIAN HIEROGLYPH A287",
	"ANATOLIAN HIEROGLYPH A288",
	"ANATOLIAN HIEROGLYPH A289",
	"ANATOLIAN HIEROGLYPH A289A",
	"ANATOLIAN HIEROGLYPH A290",
	"ANATOLIAN HIEROGLYPH A291",
	"ANATOLIAN HIEROGLYPH A292",
	"ANATOLIAN HIEROGLYPH A293",
	"ANATOLIAN HIEROGLYPH A294",
	"ANATOLIAN HIEROGLYPH A294A",
	"ANATOLIAN HIEROGLYPH A295",
	"ANATOLIAN HIEROGLYPH A296",
	"ANATOLIAN HIEROGLYPH A297",
	"ANATOLIAN HIEROGLYPH A298",
	"ANATOLIAN HIEROGLYPH A299",
	"ANATOLIAN HIEROGLYPH A299A",
	"ANATOLIAN HIEROGLYPH A300",
	"ANATOLIAN HIEROGLYPH A301",
	"ANATOLIAN HIEROGLYPH A302",
	"ANATOLIAN HIEROGLYPH A303",
	"ANATOLIAN HIEROGLYPH A304",
	"ANATOLIAN HIEROGLYPH A305",
	"ANATOLIAN HIEROGLYPH A306",
	"ANATOLIAN HIEROGLYPH A307",
	"ANATOLIAN HIEROGLYPH A308",
	"ANATOLIAN HIEROGLYPH A309",
	"ANATOLIAN HIEROGLYPH A309A",
	"ANATOLIAN HIEROGLYPH A310",
	"ANATOLIAN HIEROGLYPH A311",
	"ANATOLIAN HIEROGLYPH A312",
	"ANATOLIAN HIEROGLYPH A313",
	"ANATOLIAN HIEROGLYPH A314",
	"ANATOLIAN HIEROGLYPH A315",
	"ANATOLIAN HIEROGLYPH A316",
	"ANATOLIAN HIEROGLYPH A317",
	"ANATOLIAN HIEROGLYPH A318",
	"ANATOLIAN HIEROGLYPH A319",
	"ANATOLIAN HIEROGLYPH A320",
	"ANATOLIAN HIEROGLYPH A321",
	"ANATOLIAN HIEROGLYPH A322",
	"ANATOLIAN HIEROGLYPH A323",
	"ANATOLIAN HIEROGLYPH A324",
	"ANATOLIAN HIEROGLYPH A325",
	"ANATOLIAN HIEROGLYPH A326",
	"ANATOLIAN HIEROGLYPH A327",
	"ANATOLIAN HIEROGLYPH A328",
	"ANATOLIAN HIEROGLYPH A329",
	"ANATOLIAN HIEROGLYPH A329A",
	"ANATOLIAN HIEROGLYPH A330",
	"ANATOLIAN HIEROGLYPH A331",
	"ANATOLIAN HIEROGLYPH A332A",
	"ANATOLIAN HIEROGLYPH A332B",
	"ANATOLIAN HIEROGLYPH A332C",
	"ANATOLIAN HIEROGLYPH A333",
	"ANATOLIAN HIEROGLYPH A334",
	"ANATOLIAN HIEROGLYPH A335",
	"ANATOLIAN HIEROGLYPH A336",
	"ANATOLIAN HIEROGLYPH A336A",
	"ANATOLIAN HIEROGLYPH A336B",
	"ANATOLIAN HIEROGLYPH A336C",
	"ANATOLIAN HIEROGLYPH A337",
	"ANATOLIAN HIEROGLYPH A338",
	"ANATOLIAN HIEROGLYPH A339",
	"ANATOLIAN HIEROGLYPH A340",
	"ANATOLIAN HIEROGLYPH A341",
	"ANATOLIAN HIEROGLYPH A342",
	"ANATOLIAN HIEROGLYPH A343",
	"ANATOLIAN HIEROGLYPH A344",
	"ANATOLIAN HIEROGLYPH A345",
	"ANATOLIAN HIEROGLYPH A346",
	"ANATOLIAN HIEROGLYPH A347",
	"ANATOLIAN HIEROGLYPH A348",
	"ANATOLIAN HIEROGLYPH A349",
	"ANATOLIAN HIEROGLYPH A350",
	"ANATOLIAN HIEROGLYPH A351",
	"ANATOLIAN HIEROGLYPH A352",
	"ANATOLIAN HIEROGLYPH A353",
	"ANATOLIAN HIEROGLYPH A354",
	"ANATOLIAN HIEROGLYPH A355",
	"ANATOLIAN HIEROGLYPH A356",
	"ANATOLIAN HIEROGLYPH A357",
	"ANATOLIAN HIEROGLYPH A358",
	"ANATOLIAN HIEROGLYPH A359",
	"ANATOLIAN HIEROGLYPH A359A",
	"ANATOLIAN HIEROGLYPH A360",
	"ANATOLIAN HIEROGLYPH A361",
	"ANATOLIAN HIEROGLYPH A362",
	"ANATOLIAN HIEROGLYPH A363",
	"ANATOLIAN HIEROGLYPH A364",
	"ANATOLIAN HIEROGLYPH A364A",
	"ANATOLIAN HIEROGLYPH A365",
	"ANATOLIAN HIEROGLYPH A366",
	"ANATOLIAN HIEROGLYPH A367",
	"ANATOLIAN HIEROGLYPH A368",
	"ANATOLIAN HIEROGLYPH A368A",
	"ANATOLIAN HIEROGLYPH A369",
	"ANATOLIAN HIEROGLYPH A370",
	"ANATOLIAN HIEROGLYPH A371",
	"ANATOLIAN HIEROGLYPH A371A",
	"ANATOLIAN HIEROGLYPH A372",
	"ANATOLIAN HIEROGLYPH A373",
	"ANATOLIAN HIEROGLYPH A374",
	"ANATOLIAN HIEROGLYPH A375",
	"ANATOLIAN HIEROGLYPH A376",
	"ANATOLIAN HIEROGLYPH A377",
	"ANATOLIAN HIEROGLYPH A378",
	"ANATOLIAN HIEROGLYPH A379",
	"ANATOLIAN HIEROGLYPH A380",
	"ANATOLIAN HIEROGLYPH A381",
	"ANATOLIAN HIEROGLYPH A381A",
	"ANATOLIAN HIEROGLYPH A382",
	"ANATOLIAN HIEROGLYPH A383 RA OR RI",
	"ANATOLIAN HIEROGLYPH A383A",
	"ANATOLIAN HIEROGLYPH A384",
	"ANATOLIAN HIEROGLYPH A385",
	"ANATOLIAN HIEROGLYPH A386",
	"ANATOLIAN HIEROGLYPH A386A",
	"ANATOLIAN HIEROGLYPH A387",
	"ANATOLIAN HIEROGLYPH A388",
	"ANATOLIAN HIEROGLYPH A389",
	"ANATOLIAN HIEROGLYPH A390",
	"ANATOLIAN HIEROGLYPH A391",
	"ANATOLIAN HIEROGLYPH A392",
	"ANATOLIAN HIEROGLYPH A393 EIGHT",
	"ANATOLIAN HIEROGLYPH A394",
	"ANATOLIAN HIEROGLYPH A395",
	"ANATOLIAN HIEROGLYPH A396",
	"ANATOLIAN HIEROGLYPH A397",
	"ANATOLIAN HIEROGLYPH A398",
	"ANATOLIAN HIEROGLYPH A399",
	"ANATOLIAN HIEROGLYPH A400",
	"ANATOLIAN HIEROGLYPH A401",
	"ANATOLIAN HIEROGLYPH A402",
	"ANATOLIAN HIEROGLYPH A403",
	"ANATOLIAN HIEROGLYPH A404",
	"ANATOLIAN HIEROGLYPH A405",
	"ANATOLIAN HIEROGLYPH A406",
	"ANATOLIAN HIEROGLYPH A407",
	"ANATOLIAN HIEROGLYPH A408",
	"ANATOLIAN HIEROGLYPH A409",
	"ANATOLIAN HIEROGLYPH A410 BEGIN LOGOGRAM MARK",
	"ANATOLIAN HIEROGLYPH A410A END LOGOGRAM MARK",
	"ANATOLIAN HIEROGLYPH A411",
	"ANATOLIAN HIEROGLYPH A412",
	"ANATOLIAN HIEROGLYPH A413",
	"ANATOLIAN HIEROGLYPH A414",
	"ANATOLIAN HIEROGLYPH A415",
	"ANATOLIAN HIEROGLYPH A416",
	"ANATOLIAN HIEROGLYPH A417",
	"ANATOLIAN HIEROGLYPH A418",
	"ANATOLIAN HIEROGLYPH A419",
	"ANATOLIAN HIEROGLYPH A420",
	"ANATOLIAN HIEROGLYPH A421",
	"ANATOLIAN HIEROGLYPH A422",
	"ANATOLIAN HIEROGLYPH A423",
	"ANATOLIAN HIEROGLYPH A424",
	"ANATOLIAN HIEROGLYPH A425",
	"ANATOLIAN HIEROGLYPH A426",
	"ANATOLIAN HIEROGLYPH A427",
	"ANATOLIAN HIEROGLYPH A428",
	"ANATOLIAN HIEROGLYPH A429",
	"ANATOLIAN HIEROGLYPH A430",
	"ANATOLIAN HIEROGLYPH A431",
	"ANATOLIAN HIEROGLYPH A432",
	"ANATOLIAN HIEROGLYPH A433",
	"ANATOLIAN HIEROGLYPH A434",
	"ANATOLIAN HIEROGLYPH A435",
	"ANATOLIAN HIEROGLYPH A436",
	"ANATOLIAN HIEROGLYPH A437",
	"ANATOLIAN HIEROGLYPH A438",
	"ANATOLIAN HIEROGLYPH A439",
	"ANATOLIAN HIEROGLYPH A440",
	"ANATOLIAN HIEROGLYPH A441",
	"ANATOLIAN HIEROGLYPH A442",
	"ANATOLIAN HIEROGLYPH A443",
	"ANATOLIAN HIEROGLYPH A444",
	"ANATOLIAN HIEROGLYPH A445",
	"ANATOLIAN HIEROGLYPH A446",
	"ANATOLIAN HIEROGLYPH A447",
	"ANATOLIAN HIEROGLYPH A448",
	"ANATOLIAN HIEROGLYPH A449",
	"ANATOLIAN HIEROGLYPH A450",
	"ANATOLIAN HIEROGLYPH A450A",
	"ANATOLIAN HIEROGLYPH A451",
	"ANATOLIAN HIEROGLYPH A452",
	"ANATOLIAN HIEROGLYPH A453",
	"ANATOLIAN HIEROGLYPH A454",
	"ANATOLIAN HIEROGLYPH A455",
	"ANATOLIAN HIEROGLYPH A456",
	"ANATOLIAN HIEROGLYPH A457",
	"ANATOLIAN HIEROGLYPH A457A",
	"ANATOLIAN HIEROGLYPH A458",
	"ANATOLIAN HIEROGLYPH A459",
	"ANATOLIAN HIEROGLYPH A460",
	"ANATOLIAN HIEROGLYPH A461",
	"ANATOLIAN HIEROGLYPH A462",
	"ANATOLIAN HIEROGLYPH A463",
	"ANATOLIAN HIEROGLYPH A464",
	"ANATOLIAN HIEROGLYPH A465",
	"ANATOLIAN HIEROGLYPH A466",
	"ANATOLIAN HIEROGLYPH A467",
	"ANATOLIAN HIEROGLYPH A468",
	"ANATOLIAN HIEROGLYPH A469",
	"ANATOLIAN HIEROGLYPH A470",
	"ANATOLIAN HIEROGLYPH A471",
	"ANATOLIAN HIEROGLYPH A472",
	"ANATOLIAN HIEROGLYPH A473",
	"ANATOLIAN HIEROGLYPH A474",
	"ANATOLIAN HIEROGLYPH A475",
	"ANATOLIAN HIEROGLYPH A476",
	"ANATOLIAN HIEROGLYPH A477",
	"ANATOLIAN HIEROGLYPH A478",
	"ANATOLIAN HIEROGLYPH A479",
	"ANATOLIAN HIEROGLYPH A480",
	"ANATOLIAN HIEROGLYPH A481",
	"ANATOLIAN HIEROGLYPH A482",
	"ANATOLIAN HIEROGLYPH A483",
	"ANATOLIAN HIEROGLYPH A484",
	"ANATOLIAN HIEROGLYPH A485",
	"ANATOLIAN HIEROGLYPH A486",
	"ANATOLIAN HIEROGLYPH A487",
	"ANATOLIAN HIEROGLYPH A488",
	"ANATOLIAN HIEROGLYPH A489",
	"ANATOLIAN HIEROGLYPH A490",
	"ANATOLIAN HIEROGLYPH A491",
	"ANATOLIAN HIEROGLYPH A492",
	"ANATOLIAN HIEROGLYPH A493",
	"ANATOLIAN HIEROGLYPH A494",
	"ANATOLIAN HIEROGLYPH A495",
	"ANATOLIAN HIEROGLYPH A496",
	"ANATOLIAN HIEROGLYPH A497",
	"ANATOLIAN HIEROGLYPH A501",
	"ANATOLIAN HIEROGLYPH A502",
	"ANATOLIAN HIEROGLYPH A503",
	"ANATOLIAN HIEROGLYPH A504",
	"ANATOLIAN HIEROGLYPH A505",
	"ANATOLIAN HIEROGLYPH A506",
	"ANATOLIAN HIEROGLYPH A507",
	"ANATOLIAN HIEROGLYPH A508",
	"ANATOLIAN HIEROGLYPH A509",
	"ANATOLIAN HIEROGLYPH A510",
	"ANATOLIAN HIEROGLYPH A511",
	"ANATOLIAN HIEROGLYPH A512",
	"ANATOLIAN HIEROGLYPH A513",
	"ANATOLIAN HIEROGLYPH A514",
	"ANATOLIAN HIEROGLYPH A515",
	"ANATOLIAN HIEROGLYPH A516",
	"ANATOLIAN HIEROGLYPH A517",
	"ANATOLIAN HIEROGLYPH A518",
	"ANATOLIAN HIEROGLYPH A519",
	"ANATOLIAN HIEROGLYPH A520",
	"ANATOLIAN HIEROGLYPH A521",
	"ANATOLIAN HIEROGLYPH A522",
	"ANATOLIAN HIEROGLYPH A523",
	"ANATOLIAN HIEROGLYPH A524",
	"ANATOLIAN HIEROGLYPH A525",
	"ANATOLIAN HIEROGLYPH A526",
	"ANATOLIAN HIEROGLYPH A527",
	"ANATOLIAN HIEROGLYPH A528",
	"ANATOLIAN HIEROGLYPH A529",
	"ANATOLIAN HIEROGLYPH A530",
	"BAMUM LETTER PHASE-A NGKUE MFON",
	"BAMUM LETTER PHASE-A GBIEE FON",
	"BAMUM LETTER PHASE-A PON MFON PIPAEMGBIEE",
	"BAMUM LETTER PHASE-A PON MFON PIPAEMBA",
	"BAMUM LETTER PHASE-A NAA MFON",
	"BAMUM LETTER PHASE-A SHUENSHUET",
	"BAMUM LETTER PHASE-A TITA MFON",
	"BAMUM LETTER PHASE-A NZA MFON",
	"BAMUM LETTER PHASE-A SHINDA PA NJI",
	"BAMUM LETTER PHASE-A PON PA NJI PIPAEMGBIEE",
	"BAMUM LETTER PHASE-A PON PA NJI PIPAEMBA",
	"BAMUM LETTER PHASE-A MAEMBGBIEE",
	"BAMUM LETTER PHASE-A TU MAEMBA",
	"BAMUM LETTER PHASE-A NGANGU",
	"BAMUM LETTER PHASE-A MAEMVEUX",
	"BAMUM LETTER PHASE-A MANSUAE",
	"BAMUM LETTER PHASE-A MVEUAENGAM",
	"BAMUM LETTER PHASE-A SEUNYAM",
	"BAMUM LETTER PHASE-A NTOQPEN",
	"BAMUM LETTER PHASE-A KEUKEUTNDA",
	"BAMUM LETTER PHASE-A NKINDI",
	"BAMUM LETTER PHASE-A SUU",
	"BAMUM LETTER PHASE-A NGKUENZEUM",
	"BAMUM LETTER PHASE-A LAPAQ",
	"BAMUM LETTER PHASE-A LET KUT",
	"BAMUM LETTER PHASE-A NTAP MFAA",
	"BAMUM LETTER PHASE-A MAEKEUP",
	"BAMUM LETTER PHASE-A PASHAE",
	"BAMUM LETTER PHASE-A GHEUAERAE",
	"BAMUM LETTER PHASE-A PAMSHAE",
	"BAMUM LETTER PHASE-A MON NGGEUAET",
	"BAMUM LETTER PHASE-A NZUN MEUT",
	"BAMUM LETTER PHASE-A U YUQ NAE",
	"BAMUM LETTER PHASE-A GHEUAEGHEUAE",
	"BAMUM LETTER PHASE-A NTAP NTAA",
	"BAMUM LETTER PHASE-A SISA",
	"BAMUM LETTER PHASE-A MGBASA",
	"BAMUM LETTER PHASE-A MEUNJOMNDEUQ",
	"BAMUM LETTER PHASE-A MOOMPUQ",
	"BAMUM LETTER PHASE-A KAFA",
	"BAMUM LETTER PHASE-A PA LEERAEWA",
	"BAMUM LETTER PHASE-A NDA LEERAEWA",
	"BAMUM LETTER PHASE-A PET",
	"BAMUM LETTER PHASE-A MAEMKPEN",
	"BAMUM LETTER PHASE-A NIKA",
	"BAMUM LETTER PHASE-A PUP",
	"BAMUM LETTER PHASE-A TUAEP",
	"BAMUM LETTER PHASE-A LUAEP",
	"BAMUM LETTER PHASE-A SONJAM",
	"BAMUM LETTER PHASE-A TEUTEUWEN",
	"BAMUM LETTER PHASE-A MAENYI",
	"BAMUM LETTER PHASE-A KET",
	"BAMUM LETTER PHASE-A NDAANGGEUAET",
	"BAMUM LETTER PHASE-A KUOQ",
	"BAMUM LETTER PHASE-A MOOMEUT",
	"BAMUM LETTER PHASE-A SHUM",
	"BAMUM LETTER PHASE-A LOMMAE",
	"BAMUM LETTER PHASE-A FIRI",
	"BAMUM LETTER PHASE-A ROM",
	"BAMUM LETTER PHASE-A KPOQ",
	"BAMUM LETTER PHASE-A SOQ",
	"BAMUM LETTER PHASE-A MAP PIEET",
	"BAMUM LETTER PHASE-A SHIRAE",
	"BAMUM LETTER PHASE-A NTAP",
	"BAMUM LETTER PHASE-A SHOQ NSHUT YUM",
	"BAMUM LETTER PHASE-A NYIT MONGKEUAEQ",
	"BAMUM LETTER PHASE-A PAARAE",
	"BAMUM LETTER PHASE-A NKAARAE",
	"BAMUM LETTER PHASE-A UNKNOWN",
	"BAMUM LETTER PHASE-A NGGEN",
	"BAMUM LETTER PHASE-A MAESI",
	"BAMUM LETTER PHASE-A NJAM",
	"BAMUM LETTER PHASE-A MBANYI",
	"BAMUM LETTER PHASE-A NYET",
	"BAMUM LETTER PHASE-A TEUAEN",
	"BAMUM LETTER PHASE-A SOT",
	"BAMUM LETTER PHASE-A PAAM",
	"BAMUM LETTER PHASE-A NSHIEE",
	"BAMUM LETTER PHASE-A MAEM",
	"BAMUM LETTER PHASE-A NYI",
	"BAMUM LETTER PHASE-A KAQ",
	"BAMUM LETTER PHASE-A NSHA",
	"BAMUM LETTER PHASE-A VEE",
	"BAMUM LETTER PHASE-A LU",
	"BAMUM LETTER PHASE-A NEN",
	"BAMUM LETTER PHASE-A NAQ",
	"BAMUM LETTER PHASE-A MBAQ",
	"BAMUM LETTER PHASE-B NSHUET",
	"BAMUM LETTER PHASE-B TU MAEMGBIEE",
	"BAMUM LETTER PHASE-B SIEE",
	"BAMUM LETTER PHASE-B SET TU",
	"BAMUM LETTER PHASE-B LOM NTEUM",
	"BAMUM LETTER PHASE-B MBA MAELEE",
	"BAMUM LETTER PHASE-B KIEEM",
	"BAMUM LETTER PHASE-B YEURAE",
	"BAMUM LETTER PHASE-B MBAARAE",
	"BAMUM LETTER PHASE-B KAM",
	"BAMUM LETTER PHASE-B PEESHI",
	"BAMUM LETTER PHASE-B YAFU LEERAEWA",
	"BAMUM LETTER PHASE-B LAM NSHUT NYAM",
	"BAMUM LETTER PHASE-B NTIEE SHEUOQ",
	"BAMUM LETTER PHASE-B NDU NJAA",
	"BAMUM LETTER PHASE-B GHEUGHEUAEM",
	"BAMUM LETTER PHASE-B PIT",
	"BAMUM LETTER PHASE-B TU NSIEE",
	"BAMUM LETTER PHASE-B SHET NJAQ",
	"BAMUM LETTER PHASE-B SHEUAEQTU",
	"BAMUM LETTER PHASE-B MFON TEUAEQ",
	"BAMUM LETTER PHASE-B MBIT MBAAKET",
	"BAMUM LETTER PHASE-B NYI NTEUM",
	"BAMUM LETTER PHASE-B KEUPUQ",
	"BAMUM LETTER PHASE-B GHEUGHEN",
	"BAMUM LETTER PHASE-B KEUYEUX",
	"BAMUM LETTER PHASE-B LAANAE",
	"BAMUM LETTER PHASE-B PARUM",
	"BAMUM LETTER PHASE-B VEUM",
	"BAMUM LETTER PHASE-B NGKINDI MVOP",
	"BAMUM LETTER PHASE-B NGGEU MBU",
	"BAMUM LETTER PHASE-B WUAET",
	"BAMUM LETTER PHASE-B SAKEUAE",
	"BAMUM LETTER PHASE-B TAAM",
	"BAMUM LETTER PHASE-B MEUQ",
	"BAMUM LETTER PHASE-B NGGUOQ",
	"BAMUM LETTER PHASE-B NGGUOQ LARGE",
	"BAMUM LETTER PHASE-B MFIYAQ",
	"BAMUM LETTER PHASE-B SUE",
	"BAMUM LETTER PHASE-B MBEURI",
	"BAMUM LETTER PHASE-B MONTIEEN",
	"BAMUM LETTER PHASE-B NYAEMAE",
	"BAMUM LETTER PHASE-B PUNGAAM",
	"BAMUM LETTER PHASE-B MEUT NGGEET",
	"BAMUM LETTER PHASE-B FEUX",
	"BAMUM LETTER PHASE-B MBUOQ",
	"BAMUM LETTER PHASE-B FEE",
	"BAMUM LETTER PHASE-B KEUAEM",
	"BAMUM LETTER PHASE-B MA NJEUAENA",
	"BAMUM LETTER PHASE-B MA NJUQA",
	"BAMUM LETTER PHASE-B LET",
	"BAMUM LETTER PHASE-B NGGAAM",
	"BAMUM LETTER PHASE-B NSEN",
	"BAMUM LETTER PHASE-B MA",
	"BAMUM LETTER PHASE-B KIQ",
	"BAMUM LETTER PHASE-B NGOM",
	"BAMUM LETTER PHASE-C NGKUE MAEMBA",
	"BAMUM LETTER PHASE-C NZA",
	"BAMUM LETTER PHASE-C YUM",
	"BAMUM LETTER PHASE-C WANGKUOQ",
	"BAMUM LETTER PHASE-C NGGEN",
	"BAMUM LETTER PHASE-C NDEUAEREE",
	"BAMUM LETTER PHASE-C NGKAQ",
	"BAMUM LETTER PHASE-C GHARAE",
	"BAMUM LETTER PHASE-C MBEEKEET",
	"BAMUM LETTER PHASE-C GBAYI",
	"BAMUM LETTER PHASE-C NYIR MKPARAQ MEUN",
	"BAMUM LETTER PHASE-C NTU MBIT",
	"BAMUM LETTER PHASE-C MBEUM",
	"BAMUM LETTER PHASE-C PIRIEEN",
	"BAMUM LETTER PHASE-C NDOMBU",
	"BAMUM LETTER PHASE-C MBAA CABBAGE-TREE",
	"BAMUM LETTER PHASE-C KEUSHEUAEP",
	"BAMUM LETTER PHASE-C GHAP",
	"BAMUM LETTER PHASE-C KEUKAQ",
	"BAMUM LETTER PHASE-C YU MUOMAE",
	"BAMUM LETTER PHASE-C NZEUM",
	"BAMUM LETTER PHASE-C MBUE",
	"BAMUM LETTER PHASE-C NSEUAEN",
	"BAMUM LETTER PHASE-C MBIT",
	"BAMUM LETTER PHASE-C YEUQ",
	"BAMUM LETTER PHASE-C KPARAQ",
	"BAMUM LETTER PHASE-C KAA",
	"BAMUM LETTER PHASE-C SEUX",
	"BAMUM LETTER PHASE-C NDIDA",
	"BAMUM LETTER PHASE-C TAASHAE",
	"BAMUM LETTER PHASE-C NJUEQ",
	"BAMUM LETTER PHASE-C TITA YUE",
	"BAMUM LETTER PHASE-C SUAET",
	"BAMUM LETTER PHASE-C NGGUAEN NYAM",
	"BAMUM LETTER PHASE-C VEUX",
	"BAMUM LETTER PHASE-C NANSANAQ",
	"BAMUM LETTER PHASE-C MA KEUAERI",
	"BAMUM LETTER PHASE-C NTAA",
	"BAMUM LETTER PHASE-C NGGUON",
	"BAMUM LETTER PHASE-C LAP",
	"BAMUM LETTER PHASE-C MBIRIEEN",
	"BAMUM LETTER PHASE-C MGBASAQ",
	"BAMUM LETTER PHASE-C NTEUNGBA",
	"BAMUM LETTER PHASE-C TEUTEUX",
	"BAMUM LETTER PHASE-C NGGUM",
	"BAMUM LETTER PHASE-C FUE",
	"BAMUM LETTER PHASE-C NDEUT",
	"BAMUM LETTER PHASE-C NSA",
	"BAMUM LETTER PHASE-C NSHAQ",
	"BAMUM LETTER PHASE-C BUNG",
	"BAMUM LETTER PHASE-C VEUAEPEN",
	"BAMUM LETTER PHASE-C MBERAE",
	"BAMUM LETTER PHASE-C RU",
	"BAMUM LETTER PHASE-C NJAEM",
	"BAMUM LETTER PHASE-C LAM",
	"BAMUM LETTER PHASE-C TITUAEP",
	"BAMUM LETTER PHASE-C NSUOT NGOM",
	"BAMUM LETTER PHASE-C NJEEEE",
	"BAMUM LETTER PHASE-C KET",
	"BAMUM LETTER PHASE-C NGGU",
	"BAMUM LETTER PHASE-C MAESI",
	"BAMUM LETTER PHASE-C MBUAEM",
	"BAMUM LETTER PHASE-C LU",
	"BAMUM LETTER PHASE-C KUT",
	"BAMUM LETTER PHASE-C NJAM",
	"BAMUM LETTER PHASE-C NGOM",
	"BAMUM LETTER PHASE-C WUP",
	"BAMUM LETTER PHASE-C NGGUEET",
	"BAMUM LETTER PHASE-C NSOM",
	"BAMUM LETTER PHASE-C NTEN",
	"BAMUM LETTER PHASE-C KUOP NKAARAE",
	"BAMUM LETTER PHASE-C NSUN",
	"BAMUM LETTER PHASE-C NDAM",
	"BAMUM LETTER PHASE-C MA NSIEE",
	"BAMUM LETTER PHASE-C YAA",
	"BAMUM LETTER PHASE-C NDAP",
	"BAMUM LETTER PHASE-C SHUEQ",
	"BAMUM LETTER PHASE-C SETFON",
	"BAMUM LETTER PHASE-C MBI",
	"BAMUM LETTER PHASE-C MAEMBA",
	"BAMUM LETTER PHASE-C MBANYI",
	"BAMUM LETTER PHASE-C KEUSEUX",
	"BAMUM LETTER PHASE-C MBEUX",
	"BAMUM LETTER PHASE-C KEUM",
	"BAMUM LETTER PHASE-C MBAA PICKET",
	"BAMUM LETTER PHASE-C YUWOQ",
	"BAMUM LETTER PHASE-C NJEUX",
	"BAMUM LETTER PHASE-C MIEE",
	"BAMUM LETTER PHASE-C MUAE",
	"BAMUM LETTER PHASE-C SHIQ",
	"BAMUM LETTER PHASE-C KEN LAW",
	"BAMUM LETTER PHASE-C KEN FATIGUE",
	"BAMUM LETTER PHASE-C NGAQ",
	"BAMUM LETTER PHASE-C NAQ",
	"BAMUM LETTER PHASE-C LIQ",
	"BAMUM LETTER PHASE-C PIN",
	"BAMUM LETTER PHASE-C PEN",
	"BAMUM LETTER PHASE-C TET",
	"BAMUM LETTER PHASE-D MBUO",
	"BAMUM LETTER PHASE-D WAP",
	"BAMUM LETTER PHASE-D NJI",
	"BAMUM LETTER PHASE-D MFON",
	"BAMUM LETTER PHASE-D NJIEE",
	"BAMUM LETTER PHASE-D LIEE",
	"BAMUM LETTER PHASE-D NJEUT",
	"BAMUM LETTER PHASE-D NSHEE",
	"BAMUM LETTER PHASE-D NGGAAMAE",
	"BAMUM LETTER PHASE-D NYAM",
	"BAMUM LETTER PHASE-D WUAEN",
	"BAMUM LETTER PHASE-D NGKUN",
	"BAMUM LETTER PHASE-D SHEE",
	"BAMUM LETTER PHASE-D NGKAP",
	"BAMUM LETTER PHASE-D KEUAETMEUN",
	"BAMUM LETTER PHASE-D TEUT",
	"BAMUM LETTER PHASE-D SHEUAE",
	"BAMUM LETTER PHASE-D NJAP",
	"BAMUM LETTER PHASE-D SUE",
	"BAMUM LETTER PHASE-D KET",
	"BAMUM LETTER PHASE-D YAEMMAE",
	"BAMUM LETTER PHASE-D KUOM",
	"BAMUM LETTER PHASE-D SAP",
	"BAMUM LETTER PHASE-D MFEUT",
	"BAMUM LETTER PHASE-D NDEUX",
	"BAMUM LETTER PHASE-D MALEERI",
	"BAMUM LETTER PHASE-D MEUT",
	"BAMUM LETTER PHASE-D SEUAEQ",
	"BAMUM LETTER PHASE-D YEN",
	"BAMUM LETTER PHASE-D NJEUAEM",
	"BAMUM LETTER PHASE-D KEUOT MBUAE",
	"BAMUM LETTER PHASE-D NGKEURI",
	"BAMUM LETTER PHASE-D TU",
	"BAMUM LETTER PHASE-D GHAA",
	"BAMUM LETTER PHASE-D NGKYEE",
	"BAMUM LETTER PHASE-D FEUFEUAET",
	"BAMUM LETTER PHASE-D NDEE",
	"BAMUM LETTER PHASE-D MGBOFUM",
	"BAMUM LETTER PHASE-D LEUAEP",
	"BAMUM LETTER PHASE-D NDON",
	"BAMUM LETTER PHASE-D MONI",
	"BAMUM LETTER PHASE-D MGBEUN",
	"BAMUM LETTER PHASE-D PUUT",
	"BAMUM LETTER PHASE-D MGBIEE",
	"BAMUM LETTER PHASE-D MFO",
	"BAMUM LETTER PHASE-D LUM",
	"BAMUM LETTER PHASE-D NSIEEP",
	"BAMUM LETTER PHASE-D MBAA",
	"BAMUM LETTER PHASE-D KWAET",
	"BAMUM LETTER PHASE-D NYET",
	"BAMUM LETTER PHASE-D TEUAEN",
	"BAMUM LETTER PHASE-D SOT",
	"BAMUM LETTER PHASE-D YUWOQ",
	"BAMUM LETTER PHASE-D KEUM",
	"BAMUM LETTER PHASE-D RAEM",
	"BAMUM LETTER PHASE-D TEEEE",
	"BAMUM LETTER PHASE-D NGKEUAEQ",
	"BAMUM LETTER PHASE-D MFEUAE",
	"BAMUM LETTER PHASE-D NSIEET",
	"BAMUM LETTER PHASE-D KEUP",
	"BAMUM LETTER PHASE-D PIP",
	"BAMUM LETTER PHASE-D PEUTAE",
	"BAMUM LETTER PHASE-D NYUE",
	"BAMUM LETTER PHASE-D LET",
	"BAMUM LETTER PHASE-D NGGAAM",
	"BAMUM LETTER PHASE-D MFIEE",
	"BAMUM LETTER PHASE-D NGGWAEN",
	"BAMUM LETTER PHASE-D YUOM",
	"BAMUM LETTER PHASE-D PAP",
	"BAMUM LETTER PHASE-D YUOP",
	"BAMUM LETTER PHASE-D NDAM",
	"BAMUM LETTER PHASE-D NTEUM",
	"BAMUM LETTER PHASE-D SUAE",
	"BAMUM LETTER PHASE-D KUN",
	"BAMUM LETTER PHASE-D NGGEUX",
	"BAMUM LETTER PHASE-D NGKIEE",
	"BAMUM LETTER PHASE-D TUOT",
	"BAMUM LETTER PHASE-D MEUN",
	"BAMUM LETTER PHASE-D KUQ",
	"BAMUM LETTER PHASE-D NSUM",
	"BAMUM LETTER PHASE-D TEUN",
	"BAMUM LETTER PHASE-D MAENJET",
	"BAMUM LETTER PHASE-D NGGAP",
	"BAMUM LETTER PHASE-D LEUM",
	"BAMUM LETTER PHASE-D NGGUOM",
	"BAMUM LETTER PHASE-D NSHUT",
	"BAMUM LETTER PHASE-D NJUEQ",
	"BAMUM LETTER PHASE-D GHEUAE",
	"BAMUM LETTER PHASE-D KU",
	"BAMUM LETTER PHASE-D REN OLD",
	"BAMUM LETTER PHASE-D TAE",
	"BAMUM LETTER PHASE-D TOQ",
	"BAMUM LETTER PHASE-D NYI",
	"BAMUM LETTER PHASE-D RII",
	"BAMUM LETTER PHASE-D LEEEE",
	"BAMUM LETTER PHASE-D MEEEE",
	"BAMUM LETTER PHASE-D M",
	"BAMUM LETTER PHASE-D SUU",
	"BAMUM LETTER PHASE-D MU",
	"BAMUM LETTER PHASE-D SHII",
	"BAMUM LETTER PHASE-D SHEUX",
	"BAMUM LETTER PHASE-D KYEE",
	"BAMUM LETTER PHASE-D NU",
	"BAMUM LETTER PHASE-D SHU",
	"BAMUM LETTER PHASE-D NTEE",
	"BAMUM LETTER PHASE-D PEE",
	"BAMUM LETTER PHASE-D NI",
	"BAMUM LETTER PHASE-D SHOQ",
	"BAMUM LETTER PHASE-D PUQ",
	"BAMUM LETTER PHASE-D MVOP",
	"BAMUM LETTER PHASE-D LOQ",
	"BAMUM LETTER PHASE-D REN MUCH",
	"BAMUM LETTER PHASE-D TI",
	"BAMUM LETTER PHASE-D NTUU",
	"BAMUM LETTER PHASE-D MBAA SEVEN",
	"BAMUM LETTER PHASE-D SAQ",
	"BAMUM LETTER PHASE-D FAA",
	"BAMUM LETTER PHASE-E NDAP",
	"BAMUM LETTER PHASE-E TOON",
	"BAMUM LETTER PHASE-E MBEUM",
	"BAMUM LETTER PHASE-E LAP",
	"BAMUM LETTER PHASE-E VOM",
	"BAMUM LETTER PHASE-E LOON",
	"BAMUM LETTER PHASE-E PAA",
	"BAMUM LETTER PHASE-E SOM",
	"BAMUM LETTER PHASE-E RAQ",
	"BAMUM LETTER PHASE-E NSHUOP",
	"BAMUM LETTER PHASE-E NDUN",
	"BAMUM LETTER PHASE-E PUAE",
	"BAMUM LETTER PHASE-E TAM",
	"BAMUM LETTER PHASE-E NGKA",
	"BAMUM LETTER PHASE-E KPEUX",
	"BAMUM LETTER PHASE-E WUO",
	"BAMUM LETTER PHASE-E SEE",
	"BAMUM LETTER PHASE-E NGGEUAET",
	"BAMUM LETTER PHASE-E PAAM",
	"BAMUM LETTER PHASE-E TOO",
	"BAMUM LETTER PHASE-E KUOP",
	"BAMUM LETTER PHASE-E LOM",
	"BAMUM LETTER PHASE-E NSHIEE",
	"BAMUM LETTER PHASE-E NGOP",
	"BAMUM LETTER PHASE-E MAEM",
	"BAMUM LETTER PHASE-E NGKEUX",
	"BAMUM LETTER PHASE-E NGOQ",
	"BAMUM LETTER PHASE-E NSHUE",
	"BAMUM LETTER PHASE-E RIMGBA",
	"BAMUM LETTER PHASE-E NJEUX",
	"BAMUM LETTER PHASE-E PEEM",
	"BAMUM LETTER PHASE-E SAA",
	"BAMUM LETTER PHASE-E NGGURAE",
	"BAMUM LETTER PHASE-E MGBA",
	"BAMUM LETTER PHASE-E GHEUX",
	"BAMUM LETTER PHASE-E NGKEUAEM",
	"BAMUM LETTER PHASE-E NJAEMLI",
	"BAMUM LETTER PHASE-E MAP",
	"BAMUM LETTER PHASE-E LOOT",
	"BAMUM LETTER PHASE-E NGGEEEE",
	"BAMUM LETTER PHASE-E NDIQ",
	"BAMUM LETTER PHASE-E TAEN NTEUM",
	"BAMUM LETTER PHASE-E SET",
	"BAMUM LETTER PHASE-E PUM",
	"BAMUM LETTER PHASE-E NDAA SOFTNESS",
	"BAMUM LETTER PHASE-E NGGUAESHAE NYAM",
	"BAMUM LETTER PHASE-E YIEE",
	"BAMUM LETTER PHASE-E GHEUN",
	"BAMUM LETTER PHASE-E TUAE",
	"BAMUM LETTER PHASE-E YEUAE",
	"BAMUM LETTER PHASE-E PO",
	"BAMUM LETTER PHASE-E TUMAE",
	"BAMUM LETTER PHASE-E KEUAE",
	"BAMUM LETTER PHASE-E SUAEN",
	"BAMUM LETTER PHASE-E TEUAEQ",
	"BAMUM LETTER PHASE-E VEUAE",
	"BAMUM LETTER PHASE-E WEUX",
	"BAMUM LETTER PHASE-E LAAM",
	"BAMUM LETTER PHASE-E PU",
	"BAMUM LETTER PHASE-E TAAQ",
	"BAMUM LETTER PHASE-E GHAAMAE",
	"BAMUM LETTER PHASE-E NGEUREUT",
	"BAMUM LETTER PHASE-E SHEUAEQ",
	"BAMUM LETTER PHASE-E MGBEN",
	"BAMUM LETTER PHASE-E MBEE",
	"BAMUM LETTER PHASE-E NZAQ",
	"BAMUM LETTER PHASE-E NKOM",
	"BAMUM LETTER PHASE-E GBET",
	"BAMUM LETTER PHASE-E TUM",
	"BAMUM LETTER PHASE-E KUET",
	"BAMUM LETTER PHASE-E YAP",
	"BAMUM LETTER PHASE-E NYI CLEAVER",
	"BAMUM LETTER PHASE-E YIT",
	"BAMUM LETTER PHASE-E MFEUQ",
	"BAMUM LETTER PHASE-E NDIAQ",
	"BAMUM LETTER PHASE-E PIEEQ",
	"BAMUM LETTER PHASE-E YUEQ",
	"BAMUM LETTER PHASE-E LEUAEM",
	"BAMUM LETTER PHASE-E FUE",
	"BAMUM LETTER PHASE-E GBEUX",
	"BAMUM LETTER PHASE-E NGKUP",
	"BAMUM LETTER PHASE-E KET",
	"BAMUM LETTER PHASE-E MAE",
	"BAMUM LETTER PHASE-E NGKAAMI",
	"BAMUM LETTER PHASE-E GHET",
	"BAMUM LETTER PHASE-E FA",
	"BAMUM LETTER PHASE-E NTUM",
	"BAMUM LETTER PHASE-E PEUT",
	"BAMUM LETTER PHASE-E YEUM",
	"BAMUM LETTER PHASE-E NGGEUAE",
	"BAMUM LETTER PHASE-E NYI BETWEEN",
	"BAMUM LETTER PHASE-E NZUQ",
	"BAMUM LETTER PHASE-E POON",
	"BAMUM LETTER PHASE-E MIEE",
	"BAMUM LETTER PHASE-E FUET",
	"BAMUM LETTER PHASE-E NAE",
	"BAMUM LETTER PHASE-E MUAE",
	"BAMUM LETTER PHASE-E GHEUAE",
	"BAMUM LETTER PHASE-E FU I",
	"BAMUM LETTER PHASE-E MVI",
	"BAMUM LETTER PHASE-E PUAQ",
	"BAMUM LETTER PHASE-E NGKUM",
	"BAMUM LETTER PHASE-E KUT",
	"BAMUM LETTER PHASE-E PIET",
	"BAMUM LETTER PHASE-E NTAP",
	"BAMUM LETTER PHASE-E YEUAET",
	"BAMUM LETTER PHASE-E NGGUP",
	"BAMUM LETTER PHASE-E PA PEOPLE",
	"BAMUM LETTER PHASE-E FU CALL",
	"BAMUM LETTER PHASE-E FOM",
	"BAMUM LETTER PHASE-E NJEE",
	"BAMUM LETTER PHASE-E A",
	"BAMUM LETTER PHASE-E TOQ",
	"BAMUM LETTER PHASE-E O",
	"BAMUM LETTER PHASE-E I",
	"BAMUM LETTER PHASE-E LAQ",
	"BAMUM LETTER PHASE-E PA PLURAL",
	"BAMUM LETTER PHASE-E TAA",
	"BAMUM LETTER PHASE-E TAQ",
	"BAMUM LETTER PHASE-E NDAA MY HOUSE",
	"BAMUM LETTER PHASE-E SHIQ",
	"BAMUM LETTER PHASE-E YEUX",
	"BAMUM LETTER PHASE-E NGUAE",
	"BAMUM LETTER PHASE-E YUAEN",
	"BAMUM LETTER PHASE-E YOQ SWIMMING",
	"BAMUM LETTER PHASE-E YOQ COVER",
	"BAMUM LETTER PHASE-E YUQ",
	"BAMUM LETTER PHASE-E YUN",
	"BAMUM LETTER PHASE-E KEUX",
	"BAMUM LETTER PHASE-E PEUX",
	"BAMUM LETTER PHASE-E NJEE EPOCH",
	"BAMUM LETTER PHASE-E PUE",
	"BAMUM LETTER PHASE-E WUE",
	"BAMUM LETTER PHASE-E FEE",
	"BAMUM LETTER PHASE-E VEE",
	"BAMUM LETTER PHASE-E LU",
	"BAMUM LETTER PHASE-E MI",
	"BAMUM LETTER PHASE-E REUX",
	"BAMUM LETTER PHASE-E RAE",
	"BAMUM LETTER PHASE-E NGUAET",
	"BAMUM LETTER PHASE-E NGA",
	"BAMUM LETTER PHASE-E SHO",
	"BAMUM LETTER PHASE-E SHOQ",
	"BAMUM LETTER PHASE-E FU REMEDY",
	"BAMUM LETTER PHASE-E NA",
	"BAMUM LETTER PHASE-E PI",
	"BAMUM LETTER PHASE-E LOQ",
	"BAMUM LETTER PHASE-E KO",
	"BAMUM LETTER PHASE-E MEN",
	"BAMUM LETTER PHASE-E MA",
	"BAMUM LETTER PHASE-E MAQ",
	"BAMUM LETTER PHASE-E TEU",
	"BAMUM LETTER PHASE-E KI",
	"BAMUM LETTER PHASE-E MON",
	"BAMUM LETTER PHASE-E TEN",
	"BAMUM LETTER PHASE-E FAQ",
	"BAMUM LETTER PHASE-E GHOM",
	"BAMUM LETTER PHASE-F KA",
	"BAMUM LETTER PHASE-F U",
	"BAMUM LETTER PHASE-F KU",
	"BAMUM LETTER PHASE-F EE",
	"BAMUM LETTER PHASE-F REE",
	"BAMUM LETTER PHASE-F TAE",
	"BAMUM LETTER PHASE-F NYI",
	"BAMUM LETTER PHASE-F LA",
	"BAMUM LETTER PHASE-F RII",
	"BAMUM LETTER PHASE-F RIEE",
	"BAMUM LETTER PHASE-F MEEEE",
	"BAMUM LETTER PHASE-F TAA",
	"BAMUM LETTER PHASE-F NDAA",
	"BAMUM LETTER PHASE-F NJAEM",
	"BAMUM LETTER PHASE-F M",
	"BAMUM LETTER PHASE-F SUU",
	"BAMUM LETTER PHASE-F SHII",
	"BAMUM LETTER PHASE-F SI",
	"BAMUM LETTER PHASE-F SEUX",
	"BAMUM LETTER PHASE-F KYEE",
	"BAMUM LETTER PHASE-F KET",
	"BAMUM LETTER PHASE-F NUAE",
	"BAMUM LETTER PHASE-F NU",
	"BAMUM LETTER PHASE-F NJUAE",
	"BAMUM LETTER PHASE-F YOQ",
	"BAMUM LETTER PHASE-F SHU",
	"BAMUM LETTER PHASE-F YA",
	"BAMUM LETTER PHASE-F NSHA",
	"BAMUM LETTER PHASE-F PEUX",
	"BAMUM LETTER PHASE-F NTEE",
	"BAMUM LETTER PHASE-F WUE",
	"BAMUM LETTER PHASE-F PEE",
	"BAMUM LETTER PHASE-F RU",
	"BAMUM LETTER PHASE-F NI",
	"BAMUM LETTER PHASE-F REUX",
	"BAMUM LETTER PHASE-F KEN",
	"BAMUM LETTER PHASE-F NGKWAEN",
	"BAMUM LETTER PHASE-F NGGA",
	"BAMUM LETTER PHASE-F SHO",
	"BAMUM LETTER PHASE-F PUAE",
	"BAMUM LETTER PHASE-F FOM",
	"BAMUM LETTER PHASE-F WA",
	"BAMUM LETTER PHASE-F LI",
	"BAMUM LETTER PHASE-F LOQ",
	"BAMUM LETTER PHASE-F KO",
	"BAMUM LETTER PHASE-F MBEN",
	"BAMUM LETTER PHASE-F REN",
	"BAMUM LETTER PHASE-F MA",
	"BAMUM LETTER PHASE-F MO",
	"BAMUM LETTER PHASE-F MBAA",
	"BAMUM LETTER PHASE-F TET",
	"BAMUM LETTER PHASE-F KPA",
	"BAMUM LETTER PHASE-F SAMBA",
	"BAMUM LETTER PHASE-F VUEQ",
	"MRO LETTER TA",
	"MRO LETTER NGI",
	"MRO LETTER YO",
	"MRO LETTER MIM",
	"MRO LETTER BA",
	"MRO LETTER DA",
	"MRO LETTER A",
	"MRO LETTER PHI",
	"MRO LETTER KHAI",
	"MRO LETTER HAO",
	"MRO LETTER DAI",
	"MRO LETTER CHU",
	"MRO LETTER KEAAE",
	"MRO LETTER OL",
	"MRO LETTER MAEM",
	"MRO LETTER NIN",
	"MRO LETTER PA",
	"MRO LETTER OO",
	"MRO LETTER O",
	"MRO LETTER RO",
	"MRO LETTER SHI",
	"MRO LETTER THEA",
	"MRO LETTER EA",
	"MRO LETTER WA",
	"MRO LETTER E",
	"MRO LETTER KO",
	"MRO LETTER LAN",
	"MRO LETTER LA",
	"MRO LETTER HAI",
	"MRO LETTER RI",
	"MRO LETTER TEK",
	"MRO DIGIT ZERO",
	"MRO DIGIT ONE",
	"MRO DIGIT TWO",
	"MRO DIGIT THREE",
	"MRO DIGIT FOUR",
	"MRO DIGIT FIVE",
	"MRO DIGIT SIX",
	"MRO DIGIT SEVEN",
	"MRO DIGIT EIGHT",
	"MRO DIGIT NINE",
	"MRO DANDA",
	"MRO DOUBLE DANDA",
	"TANGSA LETTER OZ",
	"TANGSA LETTER OC",
	"TANGSA LETTER OQ",
	"TANGSA LETTER OX",
	"TANGSA LETTER AZ",
	"TANGSA LETTER AC",
	"TANGSA LETTER AQ",
	"TANGSA LETTER AX",
	"TANGSA LETTER VZ",
	"TANGSA LETTER VC",
	"TANGSA LETTER VQ",
	"TANGSA LETTER VX",
	"TANGSA LETTER EZ",
	"TANGSA LETTER EC",
	"TANGSA LETTER EQ",
	"TANGSA LETTER EX",
	"TANGSA LETTER IZ",
	"TANGSA LETTER IC",
	"TANGSA LETTER IQ",
	"TANGSA LETTER IX",
	"TANGSA LETTER UZ",
	"TANGSA LETTER UC",
	"TANGSA LETTER UQ",
	"TANGSA LETTER UX",
	"TANGSA LETTER AWZ",
	"TANGSA LETTER AWC",
	"TANGSA LETTER AWQ",
	"TANGSA LETTER AWX",
	"TANGSA LETTER UIZ",
	"TANGSA LETTER UIC",
	"TANGSA LETTER UIQ",
	"TANGSA LETTER UIX",
	"TANGSA LETTER FINAL NG",
	"TANGSA LETTER LONG UEX",
	"TANGSA LETTER SHORT UEZ",
	"TANGSA LETTER SHORT AWX",
	"TANGSA LETTER UEC",
	"TANGSA LETTER UEZ",
	"TANGSA LETTER UEQ",
	"TANGSA LETTER UEX",
	"TANGSA LETTER UIUZ",
	"TANGSA LETTER UIUC",
	"TANGSA LETTER UIUQ",
	"TANGSA LETTER UIUX",
	"TANGSA LETTER MZ",
	"TANGSA LETTER MC",
	"TANGSA LETTER MQ",
	"TANGSA LETTER MX",
	"TANGSA LETTER KA",
	"TANGSA LETTER KHA",
	"TANGSA LETTER GA",
	"TANGSA LETTER NGA",
	"TANGSA LETTER SA",
	"TANGSA LETTER YA",
	"TANGSA LETTER WA",
	"TANGSA LETTER PA",
	"TANGSA LETTER NYA",
	"TANGSA LETTER PHA",
	"TANGSA LETTER BA",
	"TANGSA LETTER MA",
	"TANGSA LETTER NA",
	"TANGSA LETTER HA",
	"TANGSA LETTER LA",
	"TANGSA LETTER HTA",
	"TANGSA LETTER TA",
	"TANGSA LETTER DA",
	"TANGSA LETTER RA",
	"TANGSA LETTER NHA",
	"TANGSA LETTER SHA",
	"TANGSA LETTER CA",
	"TANGSA LETTER TSA",
	"TANGSA LETTER GHA",
	"TANGSA LETTER HTTA",
	"TANGSA LETTER THA",
	"TANGSA LETTER XA",
	"TANGSA LETTER FA",
	"TANGSA LETTER DHA",
	"TANGSA LETTER CHA",
	"TANGSA LETTER ZA",
	"TANGSA DIGIT ZERO",
	"TANGSA DIGIT ONE",
	"TANGSA DIGIT TWO",
	"TANGSA DIGIT THREE",
	"TANGSA DIGIT FOUR",
	"TANGSA DIGIT FIVE",
	"TANGSA DIGIT SIX",
	"TANGSA DIGIT SEVEN",
	"TANGSA DIGIT EIGHT",
	"TANGSA DIGIT NINE",
	"BASSA VAH LETTER ENNI",
	"BASSA VAH LETTER KA",
	"BASSA VAH LETTER SE",
	"BASSA VAH LETTER FA",
	"BASSA VAH LETTER MBE",
	"BASSA VAH LETTER YIE",
	"BASSA VAH LETTER GAH",
	"BASSA VAH LETTER DHII",
	"BASSA VAH LETTER KPAH",
	"BASSA VAH LETTER JO",
	"BASSA VAH LETTER HWAH",
	"BASSA VAH LETTER WA",
	"BASSA VAH LETTER ZO",
	"BASSA VAH LETTER GBU",
	"BASSA VAH LETTER DO",
	"BASSA VAH LETTER CE",
	"BASSA VAH LETTER UWU",
	"BASSA VAH LETTER TO",
	"BASSA VAH LETTER BA",
	"BASSA VAH LETTER VU",
	"BASSA VAH LETTER YEIN",
	"BASSA VAH LETTER PA",
	"BASSA VAH LETTER WADDA",
	"BASSA VAH LETTER A",
	"BASSA VAH LETTER O",
	"BASSA VAH LETTER OO",
	"BASSA VAH LETTER U",
	"BASSA VAH LETTER EE",
	"BASSA VAH LETTER E",
	"BASSA VAH LETTER I",
	"BASSA VAH COMBINING HIGH TONE",
	"BASSA VAH COMBINING LOW TONE",
	"BASSA VAH COMBINING MID TONE",
	"BASSA VAH COMBINING LOW-MID TONE",
	"BASSA VAH COMBINING HIGH-LOW TONE",
	"BASSA VAH FULL STOP",
	"PAHAWH HMONG VOWEL KEEB",
	"PAHAWH HMONG VOWEL KEEV",
	"PAHAWH HMONG VOWEL KIB",
	"PAHAWH HMONG VOWEL KIV",
	"PAHAWH HMONG VOWEL KAUB",
	"PAHAWH HMONG VOWEL KAUV",
	"PAHAWH HMONG VOWEL KUB",
	"PAHAWH HMONG VOWEL KUV",
	"PAHAWH HMONG VOWEL KEB",
	"PAHAWH HMONG VOWEL KEV",
	"PAHAWH HMONG VOWEL KAIB",
	"PAHAWH HMONG VOWEL KAIV",
	"PAHAWH HMONG VOWEL KOOB",
	"PAHAWH HMONG VOWEL KOOV",
	"PAHAWH HMONG VOWEL KAWB",
	"PAHAWH HMONG VOWEL KAWV",
	"PAHAWH HMONG VOWEL KUAB",
	"PAHAWH HMONG VOWEL KUAV",
	"PAHAWH HMONG VOWEL KOB",
	"PAHAWH HMONG VOWEL KOV",
	"PAHAWH HMONG VOWEL KIAB",
	"PAHAWH HMONG VOWEL KIAV",
	"PAHAWH HMONG VOWEL KAB",
	"PAHAWH HMONG VOWEL KAV",
	"PAHAWH HMONG VOWEL KWB",
	"PAHAWH HMONG VOWEL KWV",
	"PAHAWH HMONG VOWEL KAAB",
	"PAHAWH HMONG VOWEL KAAV",
	"PAHAWH HMONG CONSONANT VAU",
	"PAHAWH HMONG CONSONANT NTSAU",
	"PAHAWH HMONG CONSONANT LAU",
	"PAHAWH HMONG CONSONANT HAU",
	"PAHAWH HMONG CONSONANT NLAU",
	"PAHAWH HMONG CONSONANT RAU",
	"PAHAWH HMONG CONSONANT NKAU",
	"PAHAWH HMONG CONSONANT QHAU",
	"PAHAWH HMONG CONSONANT YAU",
	"PAHAWH HMONG CONSONANT HLAU",
	"PAHAWH HMONG CONSONANT MAU",
	"PAHAWH HMONG CONSONANT CHAU",
	"PAHAWH HMONG CONSONANT NCHAU",
	"PAHAWH HMONG CONSONANT HNAU",
	"PAHAWH HMONG CONSONANT PLHAU",
	"PAHAWH HMONG CONSONANT NTHAU",
	"PAHAWH HMONG CONSONANT NAU",
	"PAHAWH HMONG CONSONANT AU",
	"PAHAWH HMONG CONSONANT XAU",
	"PAHAWH HMONG CONSONANT CAU",
	"PAHAWH HMONG MARK CIM TUB",
	"PAHAWH HMONG MARK CIM SO",
	"PAHAWH HMONG MARK CIM KES",
	"PAHAWH HMONG MARK CIM KHAV",
	"PAHAWH HMONG MARK CIM SUAM",
	"PAHAWH HMONG MARK CIM HOM",
	"PAHAWH HMONG MARK CIM TAUM",
	"PAHAWH HMONG SIGN VOS THOM",
	"PAHAWH HMONG SIGN VOS TSHAB CEEB",
	"PAHAWH HMONG SIGN CIM CHEEM",
	"PAHAWH HMONG SIGN VOS THIAB",
	"PAHAWH HMONG SIGN VOS FEEM",
	"PAHAWH HMONG SIGN XYEEM NTXIV",
	"PAHAWH HMONG SIGN XYEEM RHO",
	"PAHAWH HMONG SIGN XYEEM TOV",
	"PAHAWH HMONG SIGN XYEEM FAIB",
	"PAHAWH HMONG SIGN VOS SEEV",
	"PAHAWH HMONG SIGN MEEJ SUAB",
	"PAHAWH HMONG SIGN VOS NRUA",
	"PAHAWH HMONG SIGN IB YAM",
	"PAHAWH HMONG SIGN XAUS",
	"PAHAWH HMONG SIGN CIM TSOV ROG",
	"PAHAWH HMONG DIGIT ZERO",
	"PAHAWH HMONG DIGIT ONE",
	"PAHAWH HMONG DIGIT TWO",
	"PAHAWH HMONG DIGIT THREE",
	"PAHAWH HMONG DIGIT FOUR",
	"PAHAWH HMONG DIGIT FIVE",
	"PAHAWH HMONG DIGIT SIX",
	"PAHAWH HMONG DIGIT SEVEN",
	"PAHAWH HMONG DIGIT EIGHT",
	"PAHAWH HMONG DIGIT NINE",
	"PAHAWH HMONG NUMBER TENS",
	"PAHAWH HMONG NUMBER HUNDREDS",
	"PAHAWH HMONG NUMBER TEN THOUSANDS",
	"PAHAWH HMONG NUMBER MILLIONS",
	"PAHAWH HMONG NUMBER HUNDRED MILLIONS",
	"PAHAWH HMONG NUMBER TEN BILLIONS",
	"PAHAWH HMONG NUMBER TRILLIONS",
	"PAHAWH HMONG SIGN VOS LUB",
	"PAHAWH HMONG SIGN XYOO",
	"PAHAWH HMONG SIGN HLI",
	"PAHAWH HMONG SIGN THIRD-STAGE HLI",
	"PAHAWH HMONG SIGN ZWJ THAJ",
	"PAHAWH HMONG SIGN HNUB",
	"PAHAWH HMONG SIGN NQIG",
	"PAHAWH HMONG SIGN XIAB",
	"PAHAWH HMONG SIGN NTUJ",
	"PAHAWH HMONG SIGN AV",
	"PAHAWH HMONG SIGN TXHEEJ CEEV",
	"PAHAWH HMONG SIGN MEEJ TSEEB",
	"PAHAWH HMONG SIGN TAU",
	"PAHAWH HMONG SIGN LOS",
	"PAHAWH HMONG SIGN MUS",
	"PAHAWH HMONG SIGN CIM HAIS LUS NTOG NTOG",
	"PAHAWH HMONG SIGN CIM CUAM TSHOOJ",
	"PAHAWH HMONG SIGN CIM TXWV",
	"PAHAWH HMONG SIGN CIM TXWV CHWV",
	"PAHAWH HMONG SIGN CIM PUB DAWB",
	"PAHAWH HMONG SIGN CIM NRES TOS",
	"PAHAWH HMONG CLAN SIGN TSHEEJ",
	"PAHAWH HMONG CLAN SIGN YEEG",
	"PAHAWH HMONG CLAN SIGN LIS",
	"PAHAWH HMONG CLAN SIGN LAUJ",
	"PAHAWH HMONG CLAN SIGN XYOOJ",
	"PAHAWH HMONG CLAN SIGN KOO",
	"PAHAWH HMONG CLAN SIGN HAWJ",
	"PAHAWH HMONG CLAN SIGN MUAS",
	"PAHAWH HMONG CLAN SIGN THOJ",
	"PAHAWH HMONG CLAN SIGN TSAB",
	"PAHAWH HMONG CLAN SIGN PHAB",
	"PAHAWH HMONG CLAN SIGN KHAB",
	"PAHAWH HMONG CLAN SIGN HAM",
	"PAHAWH HMONG CLAN SIGN VAJ",
	"PAHAWH HMONG CLAN SIGN FAJ",
	"PAHAWH HMONG CLAN SIGN YAJ",
	"PAHAWH HMONG CLAN SIGN TSWB",
	"PAHAWH HMONG CLAN SIGN KWM",
	"PAHAWH HMONG CLAN SIGN VWJ",
	"MEDEFAIDRIN CAPITAL LETTER M",
	"MEDEFAIDRIN CAPITAL LETTER S",
	"MEDEFAIDRIN CAPITAL LETTER V",
	"MEDEFAIDRIN CAPITAL LETTER W",
	"MEDEFAIDRIN CAPITAL LETTER ATIU",
	"MEDEFAIDRIN CAPITAL LETTER Z",
	"MEDEFAIDRIN CAPITAL LETTER KP",
	"MEDEFAIDRIN CAPITAL LETTER P",
	"MEDEFAIDRIN CAPITAL LETTER T",
	"MEDEFAIDRIN CAPITAL LETTER G",
	"MEDEFAIDRIN CAPITAL LETTER F",
	"MEDEFAIDRIN CAPITAL LETTER I",
	"MEDEFAIDRIN CAPITAL LETTER K",
	"MEDEFAIDRIN CAPITAL LETTER A",
	"MEDEFAIDRIN CAPITAL LETTER J",
	"MEDEFAIDRIN CAPITAL LETTER E",
	"MEDEFAIDRIN CAPITAL LETTER B",
	"MEDEFAIDRIN CAPITAL LETTER C",
	"MEDEFAIDRIN CAPITAL LETTER U",
	"MEDEFAIDRIN CAPITAL LETTER YU",
	"MEDEFAIDRIN CAPITAL LETTER L",
	"MEDEFAIDRIN CAPITAL LETTER Q",
	"MEDEFAIDRIN CAPITAL LETTER HP",
	"MEDEFAIDRIN CAPITAL LETTER NY",
	"MEDEFAIDRIN CAPITAL LETTER X",
	"MEDEFAIDRIN CAPITAL LETTER D",
	"MEDEFAIDRIN CAPITAL LETTER OE",
	"MEDEFAIDRIN CAPITAL LETTER N",
	"MEDEFAIDRIN CAPITAL LETTER R",
	"MEDEFAIDRIN CAPITAL LETTER O",
	"MEDEFAIDRIN CAPITAL LETTER AI",
	"MEDEFAIDRIN CAPITAL LETTER Y",
	"MEDEFAIDRIN SMALL LETTER M",
	"MEDEFAIDRIN SMALL LETTER S",
	"MEDEFAIDRIN SMALL LETTER V",
	"MEDEFAIDRIN SMALL LETTER W",
	"MEDEFAIDRIN SMALL LETTER ATIU",
	"MEDEFAIDRIN SMALL LETTER Z",
	"MEDEFAIDRIN SMALL LETTER KP",
	"MEDEFAIDRIN SMALL LETTER P",
	"MEDEFAIDRIN SMALL LETTER T",
	"MEDEFAIDRIN SMALL LETTER G",
	"MEDEFAIDRIN SMALL LETTER F",
	"MEDEFAIDRIN SMALL LETTER I",
	"MEDEFAIDRIN SMALL LETTER K",
	"MEDEFAIDRIN SMALL LETTER A",
	"MEDEFAIDRIN SMALL LETTER J",
	"MEDEFAIDRIN SMALL LETTER E",
	"MEDEFAIDRIN SMALL LETTER B",
	"MEDEFAIDRIN SMALL LETTER C",
	"MEDEFAIDRIN SMALL LETTER U",
	"MEDEFAIDRIN SMALL LETTER YU",
	"MEDEFAIDRIN SMALL LETTER L",
	"MEDEFAIDRIN SMALL LETTER Q",
	"MEDEFAIDRIN SMALL LETTER HP",
	"MEDEFAIDRIN SMALL LETTER NY",
	"MEDEFAIDRIN SMALL LETTER X",
	"MEDEFAIDRIN SMALL LETTER D",
	"MEDEFAIDRIN SMALL LETTER OE",
	"MEDEFAIDRIN SMALL LETTER N",
	"MEDEFAIDRIN SMALL LETTER R",
	"MEDEFAIDRIN SMALL LETTER O",
	"MEDEFAIDRIN SMALL LETTER AI",
	"MEDEFAIDRIN SMALL LETTER Y",
	"MEDEFAIDRIN DIGIT ZERO",
	"MEDEFAIDRIN DIGIT ONE",
	"MEDEFAIDRIN DIGIT TWO",
	"MEDEFAIDRIN DIGIT THREE",
	"MEDEFAIDRIN DIGIT FOUR",
	"MEDEFAIDRIN DIGIT FIVE",
	"MEDEFAIDRIN DIGIT SIX",
	"MEDEFAIDRIN DIGIT SEVEN",
	"MEDEFAIDRIN DIGIT EIGHT",
	"MEDEFAIDRIN DIGIT NINE",
	"MEDEFAIDRIN NUMBER TEN",
	"MEDEFAIDRIN NUMBER ELEVEN",
	"MEDEFAIDRIN NUMBER TWELVE",
	"MEDEFAIDRIN NUMBER THIRTEEN",
	"MEDEFAIDRIN NUMBER FOURTEEN",
	"MEDEFAIDRIN NUMBER FIFTEEN",
	"MEDEFAIDRIN NUMBER SIXTEEN",
	"MEDEFAIDRIN NUMBER SEVENTEEN",
	"MEDEFAIDRIN NUMBER EIGHTEEN",
	"MEDEFAIDRIN NUMBER NINETEEN",
	"MEDEFAIDRIN DIGIT ONE ALTERNATE FORM",
	"MEDEFAIDRIN DIGIT TWO ALTERNATE FORM",
	"MEDEFAIDRIN DIGIT THREE ALTERNATE FORM",
	"MEDEFAIDRIN COMMA",
	"MEDEFAIDRIN FULL STOP",
	"MEDEFAIDRIN SYMBOL AIVA",
	"MEDEFAIDRIN EXCLAMATION OH",
	"MIAO LETTER PA",
	"MIAO LETTER BA",
	"MIAO LETTER YI PA",
	"MIAO LETTER PLA",
	"MIAO LETTER MA",
	"MIAO LETTER MHA",
	"MIAO LETTER ARCHAIC MA",
	"MIAO LETTER FA",
	"MIAO LETTER VA",
	"MIAO LETTER VFA",
	"MIAO LETTER TA",
	"MIAO LETTER DA",
	"MIAO LETTER YI TTA",
	"MIAO LETTER YI TA",
	"MIAO LETTER TTA",
	"MIAO LETTER DDA",
	"MIAO LETTER NA",
	"MIAO LETTER NHA",
	"MIAO LETTER YI NNA",
	"MIAO LETTER ARCHAIC NA",
	"MIAO LETTER NNA",
	"MIAO LETTER NNHA",
	"MIAO LETTER LA",
	"MIAO LETTER LYA",
	"MIAO LETTER LHA",
	"MIAO LETTER LHYA",
	"MIAO LETTER TLHA",
	"MIAO LETTER DLHA",
	"MIAO LETTER TLHYA",
	"MIAO LETTER DLHYA",
	"MIAO LETTER KA",
	"MIAO LETTER GA",
	"MIAO LETTER YI KA",
	"MIAO LETTER QA",
	"MIAO LETTER QGA",
	"MIAO LETTER NGA",
	"MIAO LETTER NGHA",
	"MIAO LETTER ARCHAIC NGA",
	"MIAO LETTER HA",
	"MIAO LETTER XA",
	"MIAO LETTER GHA",
	"MIAO LETTER GHHA",
	"MIAO LETTER TSSA",
	"MIAO LETTER DZZA",
	"MIAO LETTER NYA",
	"MIAO LETTER NYHA",
	"MIAO LETTER TSHA",
	"MIAO LETTER DZHA",
	"MIAO LETTER YI TSHA",
	"MIAO LETTER YI DZHA",
	"MIAO LETTER REFORMED TSHA",
	"MIAO LETTER SHA",
	"MIAO LETTER SSA",
	"MIAO LETTER ZHA",
	"MIAO LETTER ZSHA",
	"MIAO LETTER TSA",
	"MIAO LETTER DZA",
	"MIAO LETTER YI TSA",
	"MIAO LETTER SA",
	"MIAO LETTER ZA",
	"MIAO LETTER ZSA",
	"MIAO LETTER ZZA",
	"MIAO LETTER ZZSA",
	"MIAO LETTER ARCHAIC ZZA",
	"MIAO LETTER ZZYA",
	"MIAO LETTER ZZSYA",
	"MIAO LETTER WA",
	"MIAO LETTER AH",
	"MIAO LETTER HHA",
	"MIAO LETTER BRI",
	"MIAO LETTER SYI",
	"MIAO LETTER DZYI",
	"MIAO LETTER TE",
	"MIAO LETTER TSE",
	"MIAO LETTER RTE",
	"MIAO SIGN CONSONANT MODIFIER BAR",
	"MIAO LETTER NASALIZATION",
	"MIAO SIGN ASPIRATION",
	"MIAO SIGN REFORMED VOICING",
	"MIAO SIGN REFORMED ASPIRATION",
	"MIAO VOWEL SIGN A",
	"MIAO VOWEL SIGN AA",
	"MIAO VOWEL SIGN AHH",
	"MIAO VOWEL SIGN AN",
	"MIAO VOWEL SIGN ANG",
	"MIAO VOWEL SIGN O",
	"MIAO VOWEL SIGN OO",
	"MIAO VOWEL SIGN WO",
	"MIAO VOWEL SIGN W",
	"MIAO VOWEL SIGN E",
	"MIAO VOWEL SIGN EN",
	"MIAO VOWEL SIGN ENG",
	"MIAO VOWEL SIGN OEY",
	"MIAO VOWEL SIGN I",
	"MIAO VOWEL SIGN IA",
	"MIAO VOWEL SIGN IAN",
	"MIAO VOWEL SIGN IANG",
	"MIAO VOWEL SIGN IO",
	"MIAO VOWEL SIGN IE",
	"MIAO VOWEL SIGN II",
	"MIAO VOWEL SIGN IU",
	"MIAO VOWEL SIGN ING",
	"MIAO VOWEL SIGN U",
	"MIAO VOWEL SIGN UA",
	"MIAO VOWEL SIGN UAN",
	"MIAO VOWEL SIGN UANG",
	"MIAO VOWEL SIGN UU",
	"MIAO VOWEL SIGN UEI",
	"MIAO VOWEL SIGN UNG",
	"MIAO VOWEL SIGN Y",
	"MIAO VOWEL SIGN YI",
	"MIAO VOWEL SIGN AE",
	"MIAO VOWEL SIGN AEE",
	"MIAO VOWEL SIGN ERR",
	"MIAO VOWEL SIGN ROUNDED ERR",
	"MIAO VOWEL SIGN ER",
	"MIAO VOWEL SIGN ROUNDED ER",
	"MIAO VOWEL SIGN AI",
	"MIAO VOWEL SIGN EI",
	"MIAO VOWEL SIGN AU",
	"MIAO VOWEL SIGN OU",
	"MIAO VOWEL SIGN N",
	"MIAO VOWEL SIGN NG",
	"MIAO VOWEL SIGN UOG",
	"MIAO VOWEL SIGN YUI",
	"MIAO VOWEL SIGN OG",
	"MIAO VOWEL SIGN OER",
	"MIAO VOWEL SIGN VW",
	"MIAO VOWEL SIGN IG",
	"MIAO VOWEL SIGN EA",
	"MIAO VOWEL SIGN IONG",
	"MIAO VOWEL SIGN UI",
	"MIAO TONE RIGHT",
	"MIAO TONE TOP RIGHT",
	"MIAO TONE ABOVE",
	"MIAO TONE BELOW",
	"MIAO LETTER TONE-2",
	"MIAO LETTER TONE-3",
	"MIAO LETTER TONE-4",
	"MIAO LETTER TONE-5",
	"MIAO LETTER TONE-6",
	"MIAO LETTER TONE-7",
	"MIAO LETTER TONE-8",
	"MIAO LETTER REFORMED TONE-1",
	"MIAO LETTER REFORMED TONE-2",
	"MIAO LETTER REFORMED TONE-4",
	"MIAO LETTER REFORMED TONE-5",
	"MIAO LETTER REFORMED TONE-6",
	"MIAO LETTER REFORMED TONE-8",
	"TANGUT ITERATION MARK",
	"NUSHU ITERATION MARK",
	"OLD CHINESE HOOK MARK",
	"OLD CHINESE ITERATION MARK",
	"KHITAN SMALL SCRIPT FILLER",
	"VIETNAMESE ALTERNATE READING MARK CA",
	"VIETNAMESE ALTERNATE READING MARK NHAY",
	"<Tangut Ideograph, First>",
	"<Tangut Ideograph, Last>",
	"TANGUT COMPONENT-001",
	"TANGUT COMPONENT-002",
	"TANGUT COMPONENT-003",
	"TANGUT COMPONENT-004",
	"TANGUT COMPONENT-005",
	"TANGUT COMPONENT-006",
	"TANGUT COMPONENT-007",
	"TANGUT COMPONENT-008",
	"TANGUT COMPONENT-009",
	"TANGUT COMPONENT-010",
	"TANGUT COMPONENT-011",
	"TANGUT COMPONENT-012",
	"TANGUT COMPONENT-013",
	"TANGUT COMPONENT-014",
	"TANGUT COMPONENT-015",
	"TANGUT COMPONENT-016",
	"TANGUT COMPONENT-017",
	"TANGUT COMPONENT-018",
	"TANGUT COMPONENT-019",
	"TANGUT COMPONENT-020",
	"TANGUT COMPONENT-021",
	"TANGUT COMPONENT-022",
	"TANGUT COMPONENT-023",
	"TANGUT COMPONENT-024",
	"TANGUT COMPONENT-025",
	"TANGUT COMPONENT-026",
	"TANGUT COMPONENT-027",
	"TANGUT COMPONENT-028",
	"TANGUT COMPONENT-029",
	"TANGUT COMPONENT-030",
	"TANGUT COMPONENT-031",
	"TANGUT COMPONENT-032",
	"TANGUT COMPONENT-033",
	"TANGUT COMPONENT-034",
	"TANGUT COMPONENT-035",
	"TANGUT COMPONENT-036",
	"TANGUT COMPONENT-037",
	"TANGUT COMPONENT-038",
	"TANGUT COMPONENT-039",
	"TANGUT COMPONENT-040",
	"TANGUT COMPONENT-041",
	"TANGUT COMPONENT-042",
	"TANGUT COMPONENT-043",
	"TANGUT COMPONENT-044",
	"TANGUT COMPONENT-045",
	"TANGUT COMPONENT-046",
	"TANGUT COMPONENT-047",
	"TANGUT COMPONENT-048",
	"TANGUT COMPONENT-049",
	"TANGUT COMPONENT-050",
	"TANGUT COMPONENT-051",
	"TANGUT COMPONENT-052",
	"TANGUT COMPONENT-053",
	"TANGUT COMPONENT-054",
	"TANGUT COMPONENT-055",
	"TANGUT COMPONENT-056",
	"TANGUT COMPONENT-057",
	"TANGUT COMPONENT-058",
	"TANGUT COMPONENT-059",
	"TANGUT COMPONENT-060",
	"TANGUT COMPONENT-061",
	"TANGUT COMPONENT-062",
	"TANGUT COMPONENT-063",
	"TANGUT COMPONENT-064",
	"TANGUT COMPONENT-065",
	"TANGUT COMPONENT-066",
	"TANGUT COMPONENT-067",
	"TANGUT COMPONENT-068",
	"TANGUT COMPONENT-069",
	"TANGUT COMPONENT-070",
	"TANGUT COMPONENT-071",
	"TANGUT COMPONENT-072",
	"TANGUT COMPONENT-073",
	"TANGUT COMPONENT-074",
	"TANGUT COMPONENT-075",
	"TANGUT COMPONENT-076",
	"TANGUT COMPONENT-077",
	"TANGUT COMPONENT-078",
	"TANGUT COMPONENT-079",
	"TANGUT COMPONENT-080",
	"TANGUT COMPONENT-081",
	"TANGUT COMPONENT-082",
	"TANGUT COMPONENT-083",
	"TANGUT COMPONENT-084",
	"TANGUT COMPONENT-085",
	"TANGUT COMPONENT-086",
	"TANGUT COMPONENT-087",
	"TANGUT COMPONENT-088",
	"TANGUT COMPONENT-089",
	"TANGUT COMPONENT-090",
	"TANGUT COMPONENT-091",
	"TANGUT COMPONENT-092",
	"TANGUT COMPONENT-093",
	"TANGUT COMPONENT-094",
	"TANGUT COMPONENT-095",
	"TANGUT COMPONENT-096",
	"TANGUT COMPONENT-097",
	"TANGUT COMPONENT-098",
	"TANGUT COMPONENT-099",
	"TANGUT COMPONENT-100",
	"TANGUT COMPONENT-101",
	"TANGUT COMPONENT-102",
	"TANGUT COMPONENT-103",
	"TANGUT COMPONENT-104",
	"TANGUT COMPONENT-105",
	"TANGUT COMPONENT-106",
	"TANGUT COMPONENT-107",
	"TANGUT COMPONENT-108",
	"TANGUT COMPONENT-109",
	"TANGUT COMPONENT-110",
	"TANGUT COMPONENT-111",
	"TANGUT COMPONENT-112",
	"TANGUT COMPONENT-113",
	"TANGUT COMPONENT-114",
	"TANGUT COMPONENT-115",
	"TANGUT COMPONENT-116",
	"TANGUT COMPONENT-117",
	"TANGUT COMPONENT-118",
	"TANGUT COMPONENT-119",
	"TANGUT COMPONENT-120",
	"TANGUT COMPONENT-121",
	"TANGUT COMPONENT-122",
	"TANGUT COMPONENT-123",
	"TANGUT COMPONENT-124",
	"TANGUT COMPONENT-125",
	"TANGUT COMPONENT-126",
	"TANGUT COMPONENT-127",
	"TANGUT COMPONENT-128",
	"TANGUT COMPONENT-129",
	"TANGUT COMPONENT-130",
	"TANGUT COMPONENT-131",
	"TANGUT COMPONENT-132",
	"TANGUT COMPONENT-133",
	"TANGUT COMPONENT-134",
	"TANGUT COMPONENT-135",
	"TANGUT COMPONENT-136",
	"TANGUT COMPONENT-137",
	"TANGUT COMPONENT-138",
	"TANGUT COMPONENT-139",
	"TANGUT COMPONENT-140",
	"TANGUT COMPONENT-141",
	"TANGUT COMPONENT-142",
	"TANGUT COMPONENT-143",
	"TANGUT COMPONENT-144",
	"TANGUT COMPONENT-145",
	"TANGUT COMPONENT-146",
	"TANGUT COMPONENT-147",
	"TANGUT COMPONENT-148",
	"TANGUT COMPONENT-149",
	"TANGUT COMPONENT-150",
	"TANGUT COMPONENT-151",
	"TANGUT COMPONENT-152",
	"TANGUT COMPONENT-153",
	"TANGUT COMPONENT-154",
	"TANGUT COMPONENT-155",
	"TANGUT COMPONENT-156",
	"TANGUT COMPONENT-157",
	"TANGUT COMPONENT-158",
	"TANGUT COMPONENT-159",
	"TANGUT COMPONENT-160",
	"TANGUT COMPONENT-161",
	"TANGUT COMPONENT-162",
	"TANGUT COMPONENT-163",
	"TANGUT COMPONENT-164",
	"TANGUT COMPONENT-165",
	"TANGUT COMPONENT-166",
	"TANGUT COMPONENT-167",
	"TANGUT COMPONENT-168",
	"TANGUT COMPONENT-169",
	"TANGUT COMPONENT-170",
	"TANGUT COMPONENT-171",
	"TANGUT COMPONENT-172",
	"TANGUT COMPONENT-173",
	"TANGUT COMPONENT-174",
	"TANGUT COMPONENT-175",
	"TANGUT COMPONENT-176",
	"TANGUT COMPONENT-177",
	"TANGUT COMPONENT-178",
	"TANGUT COMPONENT-179",
	"TANGUT COMPONENT-180",
	"TANGUT COMPONENT-181",
	"TANGUT COMPONENT-182",
	"TANGUT COMPONENT-183",
	"TANGUT COMPONENT-184",
	"TANGUT COMPONENT-185",
	"TANGUT COMPONENT-186",
	"TANGUT COMPONENT-187",
	"TANGUT COMPONENT-188",
	"TANGUT COMPONENT-189",
	"TANGUT COMPONENT-190",
	"TANGUT COMPONENT-191",
	"TANGUT COMPONENT-192",
	"TANGUT COMPONENT-193",
	"TANGUT COMPONENT-194",
	"TANGUT COMPONENT-195",
	"TANGUT COMPONENT-196",
	"TANGUT COMPONENT-197",
	"TANGUT COMPONENT-198",
	"TANGUT COMPONENT-199",
	"TANGUT COMPONENT-200",
	"TANGUT COMPONENT-201",
	"TANGUT COMPONENT-202",
	"TANGUT COMPONENT-203",
	"TANGUT COMPONENT-204",
	"TANGUT COMPONENT-205",
	"TANGUT COMPONENT-206",
	"TANGUT COMPONENT-207",
	"TANGUT COMPONENT-208",
	"TANGUT COMPONENT-209",
	"TANGUT COMPONENT-210",
	"TANGUT COMPONENT-211",
	"TANGUT COMPONENT-212",
	"TANGUT COMPONENT-213",
	"TANGUT COMPONENT-214",
	"TANGUT COMPONENT-215",
	"TANGUT COMPONENT-216",
	"TANGUT COMPONENT-217",
	"TANGUT COMPONENT-218",
	"TANGUT COMPONENT-219",
	"TANGUT COMPONENT-220",
	"TANGUT COMPONENT-221",
	"TANGUT COMPONENT-222",
	"TANGUT COMPONENT-223",
	"TANGUT COMPONENT-224",
	"TANGUT COMPONENT-225",
	"TANGUT COMPONENT-226",
	"TANGUT COMPONENT-227",
	"TANGUT COMPONENT-228",
	"TANGUT COMPONENT-229",
	"TANGUT COMPONENT-230",
	"TANGUT COMPONENT-231",
	"TANGUT COMPONENT-232",
	"TANGUT COMPONENT-233",
	"TANGUT COMPONENT-234",
	"TANGUT COMPONENT-235",
	"TANGUT COMPONENT-236",
	"TANGUT COMPONENT-237",
	"TANGUT COMPONENT-238",
	"TANGUT COMPONENT-239",
	"TANGUT COMPONENT-240",
	"TANGUT COMPONENT-241",
	"TANGUT COMPONENT-242",
	"TANGUT COMPONENT-243",
	"TANGUT COMPONENT-244",
	"TANGUT COMPONENT-245",
	"TANGUT COMPONENT-246",
	"TANGUT COMPONENT-247",
	"TANGUT COMPONENT-248",
	"TANGUT COMPONENT-249",
	"TANGUT COMPONENT-250",
	"TANGUT COMPONENT-251",
	"TANGUT COMPONENT-252",
	"TANGUT COMPONENT-253",
	"TANGUT COMPONENT-254",
	"TANGUT COMPONENT-255",
	"TANGUT COMPONENT-256",
	"TANGUT COMPONENT-257",
	"TANGUT COMPONENT-258",
	"TANGUT COMPONENT-259",
	"TANGUT COMPONENT-260",
	"TANGUT COMPONENT-261",
	"TANGUT COMPONENT-262",
	"TANGUT COMPONENT-263",
	"TANGUT COMPONENT-264",
	"TANGUT COMPONENT-265",
	"TANGUT COMPONENT-266",
	"TANGUT COMPONENT-267",
	"TANGUT COMPONENT-268",
	"TANGUT COMPONENT-269",
	"TANGUT COMPONENT-270",
	"TANGUT COMPONENT-271",
	"TANGUT COMPONENT-272",
	"TANGUT COMPONENT-273",
	"TANGUT COMPONENT-274",
	"TANGUT COMPONENT-275",
	"TANGUT COMPONENT-276",
	"TANGUT COMPONENT-277",
	"TANGUT COMPONENT-278",
	"TANGUT COMPONENT-279",
	"TANGUT COMPONENT-280",
	"TANGUT COMPONENT-281",
	"TANGUT COMPONENT-282",
	"TANGUT COMPONENT-283",
	"TANGUT COMPONENT-284",
	"TANGUT COMPONENT-285",
	"TANGUT COMPONENT-286",
	"TANGUT COMPONENT-287",
	"TANGUT COMPONENT-288",
	"TANGUT COMPONENT-289",
	"TANGUT COMPONENT-290",
	"TANGUT COMPONENT-291",
	"TANGUT COMPONENT-292",
	"TANGUT COMPONENT-293",
	"TANGUT COMPONENT-294",
	"TANGUT COMPONENT-295",
	"TANGUT COMPONENT-296",
	"TANGUT COMPONENT-297",
	"TANGUT COMPONENT-298",
	"TANGUT COMPONENT-299",
	"TANGUT COMPONENT-300",
	"TANGUT COMPONENT-301",
	"TANGUT COMPONENT-302",
	"TANGUT COMPONENT-303",
	"TANGUT COMPONENT-304",
	"TANGUT COMPONENT-305",
	"TANGUT COMPONENT-306",
	"TANGUT COMPONENT-307",
	"TANGUT COMPONENT-308",
	"TANGUT COMPONENT-309",
	"TANGUT COMPONENT-310",
	"TANGUT COMPONENT-311",
	"TANGUT COMPONENT-312",
	"TANGUT COMPONENT-313",
	"TANGUT COMPONENT-314",
	"TANGUT COMPONENT-315",
	"TANGUT COMPONENT-316",
	"TANGUT COMPONENT-317",
	"TANGUT COMPONENT-318",
	"TANGUT COMPONENT-319",
	"TANGUT COMPONENT-320",
	"TANGUT COMPONENT-321",
	"TANGUT COMPONENT-322",
	"TANGUT COMPONENT-323",
	"TANGUT COMPONENT-324",
	"TANGUT COMPONENT-325",
	"TANGUT COMPONENT-326",
	"TANGUT COMPONENT-327",
	"TANGUT COMPONENT-328",
	"TANGUT COMPONENT-329",
	"TANGUT COMPONENT-330",
	"TANGUT COMPONENT-331",
	"TANGUT COMPONENT-332",
	"TANGUT COMPONENT-333",
	"TANGUT COMPONENT-334",
	"TANGUT COMPONENT-335",
	"TANGUT COMPONENT-336",
	"TANGUT COMPONENT-337",
	"TANGUT COMPONENT-338",
	"TANGUT COMPONENT-339",
	"TANGUT COMPONENT-340",
	"TANGUT COMPONENT-341",
	"TANGUT COMPONENT-342",
	"TANGUT COMPONENT-343",
	"TANGUT COMPONENT-344",
	"TANGUT COMPONENT-345",
	"TANGUT COMPONENT-346",
	"TANGUT COMPONENT-347",
	"TANGUT COMPONENT-348",
	"TANGUT COMPONENT-349",
	"TANGUT COMPONENT-350",
	"TANGUT COMPONENT-351",
	"TANGUT COMPONENT-352",
	"TANGUT COMPONENT-353",
	"TANGUT COMPONENT-354",
	"TANGUT COMPONENT-355",
	"TANGUT COMPONENT-356",
	"TANGUT COMPONENT-357",
	"TANGUT COMPONENT-358",
	"TANGUT COMPONENT-359",
	"TANGUT COMPONENT-360",
	"TANGUT COMPONENT-361",
	"TANGUT COMPONENT-362",
	"TANGUT COMPONENT-363",
	"TANGUT COMPONENT-364",
	"TANGUT COMPONENT-365",
	"TANGUT COMPONENT-366",
	"TANGUT COMPONENT-367",
	"TANGUT COMPONENT-368",
	"TANGUT COMPONENT-369",
	"TANGUT COMPONENT-370",
	"TANGUT COMPONENT-371",
	"TANGUT COMPONENT-372",
	"TANGUT COMPONENT-373",
	"TANGUT COMPONENT-374",
	"TANGUT COMPONENT-375",
	"TANGUT COMPONENT-376",
	"TANGUT COMPONENT-377",
	"TANGUT COMPONENT-378",
	"TANGUT COMPONENT-379",
	"TANGUT COMPONENT-380",
	"TANGUT COMPONENT-381",
	"TANGUT COMPONENT-382",
	"TANGUT COMPONENT-383",
	"TANGUT COMPONENT-384",
	"TANGUT COMPONENT-385",
	"TANGUT COMPONENT-386",
	"TANGUT COMPONENT-387",
	"TANGUT COMPONENT-388",
	"TANGUT COMPONENT-389",
	"TANGUT COMPONENT-390",
	"TANGUT COMPONENT-391",
	"TANGUT COMPONENT-392",
	"TANGUT COMPONENT-393",
	"TANGUT COMPONENT-394",
	"TANGUT COMPONENT-395",
	"TANGUT COMPONENT-396",
	"TANGUT COMPONENT-397",
	"TANGUT COMPONENT-398",
	"TANGUT COMPONENT-399",
	"TANGUT COMPONENT-400",
	"TANGUT COMPONENT-401",
	"TANGUT COMPONENT-402",
	"TANGUT COMPONENT-403",
	"TANGUT COMPONENT-404",
	"TANGUT COMPONENT-405",
	"TANGUT COMPONENT-406",
	"TANGUT COMPONENT-407",
	"TANGUT COMPONENT-408",
	"TANGUT COMPONENT-409",
	"TANGUT COMPONENT-410",
	"TANGUT COMPONENT-411",
	"TANGUT COMPONENT-412",
	"TANGUT COMPONENT-413",
	"TANGUT COMPONENT-414",
	"TANGUT COMPONENT-415",
	"TANGUT COMPONENT-416",
	"TANGUT COMPONENT-417",
	"TANGUT COMPONENT-418",
	"TANGUT COMPONENT-419",
	"TANGUT COMPONENT-420",
	"TANGUT COMPONENT-421",
	"TANGUT COMPONENT-422",
	"TANGUT COMPONENT-423",
	"TANGUT COMPONENT-424",
	"TANGUT COMPONENT-425",
	"TANGUT COMPONENT-426",
	"TANGUT COMPONENT-427",
	"TANGUT COMPONENT-428",
	"TANGUT COMPONENT-429",
	"TANGUT COMPONENT-430",
	"TANGUT COMPONENT-431",
	"TANGUT COMPONENT-432",
	"TANGUT COMPONENT-433",
	"TANGUT COMPONENT-434",
	"TANGUT COMPONENT-435",
	"TANGUT COMPONENT-436",
	"TANGUT COMPONENT-437",
	"TANGUT COMPONENT-438",
	"TANGUT COMPONENT-439",
	"TANGUT COMPONENT-440",
	"TANGUT COMPONENT-441",
	"TANGUT COMPONENT-442",
	"TANGUT COMPONENT-443",
	"TANGUT COMPONENT-444",
	"TANGUT COMPONENT-445",
	"TANGUT COMPONENT-446",
	"TANGUT COMPONENT-447",
	"TANGUT COMPONENT-448",
	"TANGUT COMPONENT-449",
	"TANGUT COMPONENT-450",
	"TANGUT COMPONENT-451",
	"TANGUT COMPONENT-452",
	"TANGUT COMPONENT-453",
	"TANGUT COMPONENT-454",
	"TANGUT COMPONENT-455",
	"TANGUT COMPONENT-456",
	"TANGUT COMPONENT-457",
	"TANGUT COMPONENT-458",
	"TANGUT COMPONENT-459",
	"TANGUT COMPONENT-460",
	"TANGUT COMPONENT-461",
	"TANGUT COMPONENT-462",
	"TANGUT COMPONENT-463",
	"TANGUT COMPONENT-464",
	"TANGUT COMPONENT-465",
	"TANGUT COMPONENT-466",
	"TANGUT COMPONENT-467",
	"TANGUT COMPONENT-468",
	"TANGUT COMPONENT-469",
	"TANGUT COMPONENT-470",
	"TANGUT COMPONENT-471",
	"TANGUT COMPONENT-472",
	"TANGUT COMPONENT-473",
	"TANGUT COMPONENT-474",
	"TANGUT COMPONENT-475",
	"TANGUT COMPONENT-476",
	"TANGUT COMPONENT-477",
	"TANGUT COMPONENT-478",
	"TANGUT COMPONENT-479",
	"TANGUT COMPONENT-480",
	"TANGUT COMPONENT-481",
	"TANGUT COMPONENT-482",
	"TANGUT COMPONENT-483",
	"TANGUT COMPONENT-484",
	"TANGUT COMPONENT-485",
	"TANGUT COMPONENT-486",
	"TANGUT COMPONENT-487",
	"TANGUT COMPONENT-488",
	"TANGUT COMPONENT-489",
	"TANGUT COMPONENT-490",
	"TANGUT COMPONENT-491",
	"TANGUT COMPONENT-492",
	"TANGUT COMPONENT-493",
	"TANGUT COMPONENT-494",
	"TANGUT COMPONENT-495",
	"TANGUT COMPONENT-496",
	"TANGUT COMPONENT-497",
	"TANGUT COMPONENT-498",
	"TANGUT COMPONENT-499",
	"TANGUT COMPONENT-500",
	"TANGUT COMPONENT-501",
	"TANGUT COMPONENT-502",
	"TANGUT COMPONENT-503",
	"TANGUT COMPONENT-504",
	"TANGUT COMPONENT-505",
	"TANGUT COMPONENT-506",
	"TANGUT COMPONENT-507",
	"TANGUT COMPONENT-508",
	"TANGUT COMPONENT-509",
	"TANGUT COMPONENT-510",
	"TANGUT COMPONENT-511",
	"TANGUT COMPONENT-512",
	"TANGUT COMPONENT-513",
	"TANGUT COMPONENT-514",
	"TANGUT COMPONENT-515",
	"TANGUT COMPONENT-516",
	"TANGUT COMPONENT-517",
	"TANGUT COMPONENT-518",
	"TANGUT COMPONENT-519",
	"TANGUT COMPONENT-520",
	"TANGUT COMPONENT-521",
	"TANGUT COMPONENT-522",
	"TANGUT COMPONENT-523",
	"TANGUT COMPONENT-524",
	"TANGUT COMPONENT-525",
	"TANGUT COMPONENT-526",
	"TANGUT COMPONENT-527",
	"TANGUT COMPONENT-528",
	"TANGUT COMPONENT-529",
	"TANGUT COMPONENT-530",
	"TANGUT COMPONENT-531",
	"TANGUT COMPONENT-532",
	"TANGUT COMPONENT-533",
	"TANGUT COMPONENT-534",
	"TANGUT COMPONENT-535",
	"TANGUT COMPONENT-536",
	"TANGUT COMPONENT-537",
	"TANGUT COMPONENT-538",
	"TANGUT COMPONENT-539",
	"TANGUT COMPONENT-540",
	"TANGUT COMPONENT-541",
	"TANGUT COMPONENT-542",
	"TANGUT COMPONENT-543",
	"TANGUT COMPONENT-544",
	"TANGUT COMPONENT-545",
	"TANGUT COMPONENT-546",
	"TANGUT COMPONENT-547",
	"TANGUT COMPONENT-548",
	"TANGUT COMPONENT-549",
	"TANGUT COMPONENT-550",
	"TANGUT COMPONENT-551",
	"TANGUT COMPONENT-552",
	"TANGUT COMPONENT-553",
	"TANGUT COMPONENT-554",
	"TANGUT COMPONENT-555",
	"TANGUT COMPONENT-556",
	"TANGUT COMPONENT-557",
	"TANGUT COMPONENT-558",
	"TANGUT COMPONENT-559",
	"TANGUT COMPONENT-560",
	"TANGUT COMPONENT-561",
	"TANGUT COMPONENT-562",
	"TANGUT COMPONENT-563",
	"TANGUT COMPONENT-564",
	"TANGUT COMPONENT-565",
	"TANGUT COMPONENT-566",
	"TANGUT COMPONENT-567",
	"TANGUT COMPONENT-568",
	"TANGUT COMPONENT-569",
	"TANGUT COMPONENT-570",
	"TANGUT COMPONENT-571",
	"TANGUT COMPONENT-572",
	"TANGUT COMPONENT-573",
	"TANGUT COMPONENT-574",
	"TANGUT COMPONENT-575",
	"TANGUT COMPONENT-576",
	"TANGUT COMPONENT-577",
	"TANGUT COMPONENT-578",
	"TANGUT COMPONENT-579",
	"TANGUT COMPONENT-580",
	"TANGUT COMPONENT-581",
	"TANGUT COMPONENT-582",
	"TANGUT COMPONENT-583",
	"TANGUT COMPONENT-584",
	"TANGUT COMPONENT-585",
	"TANGUT COMPONENT-586",
	"TANGUT COMPONENT-587",
	"TANGUT COMPONENT-588",
	"TANGUT COMPONENT-589",
	"TANGUT COMPONENT-590",
	"TANGUT COMPONENT-591",
	"TANGUT COMPONENT-592",
	"TANGUT COMPONENT-593",
	"TANGUT COMPONENT-594",
	"TANGUT COMPONENT-595",
	"TANGUT COMPONENT-596",
	"TANGUT COMPONENT-597",
	"TANGUT COMPONENT-598",
	"TANGUT COMPONENT-599",
	"TANGUT COMPONENT-600",
	"TANGUT COMPONENT-601",
	"TANGUT COMPONENT-602",
	"TANGUT COMPONENT-603",
	"TANGUT COMPONENT-604",
	"TANGUT COMPONENT-605",
	"TANGUT COMPONENT-606",
	"TANGUT COMPONENT-607",
	"TANGUT COMPONENT-608",
	"TANGUT COMPONENT-609",
	"TANGUT COMPONENT-610",
	"TANGUT COMPONENT-611",
	"TANGUT COMPONENT-612",
	"TANGUT COMPONENT-613",
	"TANGUT COMPONENT-614",
	"TANGUT COMPONENT-615",
	"TANGUT COMPONENT-616",
	"TANGUT COMPONENT-617",
	"TANGUT COMPONENT-618",
	"TANGUT COMPONENT-619",
	"TANGUT COMPONENT-620",
	"TANGUT COMPONENT-621",
	"TANGUT COMPONENT-622",
	"TANGUT COMPONENT-623",
	"TANGUT COMPONENT-624",
	"TANGUT COMPONENT-625",
	"TANGUT COMPONENT-626",
	"TANGUT COMPONENT-627",
	"TANGUT COMPONENT-628",
	"TANGUT COMPONENT-629",
	"TANGUT COMPONENT-630",
	"TANGUT COMPONENT-631",
	"TANGUT COMPONENT-632",
	"TANGUT COMPONENT-633",
	"TANGUT COMPONENT-634",
	"TANGUT COMPONENT-635",
	"TANGUT COMPONENT-636",
	"TANGUT COMPONENT-637",
	"TANGUT COMPONENT-638",
	"TANGUT COMPONENT-639",
	"TANGUT COMPONENT-640",
	"TANGUT COMPONENT-641",
	"TANGUT COMPONENT-642",
	"TANGUT COMPONENT-643",
	"TANGUT COMPONENT-644",
	"TANGUT COMPONENT-645",
	"TANGUT COMPONENT-646",
	"TANGUT COMPONENT-647",
	"TANGUT COMPONENT-648",
	"TANGUT COMPONENT-649",
	"TANGUT COMPONENT-650",
	"TANGUT COMPONENT-651",
	"TANGUT COMPONENT-652",
	"TANGUT COMPONENT-653",
	"TANGUT COMPONENT-654",
	"TANGUT COMPONENT-655",
	"TANGUT COMPONENT-656",
	"TANGUT COMPONENT-657",
	"TANGUT COMPONENT-658",
	"TANGUT COMPONENT-659",
	"TANGUT COMPONENT-660",
	"TANGUT COMPONENT-661",
	"TANGUT COMPONENT-662",
	"TANGUT COMPONENT-663",
	"TANGUT COMPONENT-664",
	"TANGUT COMPONENT-665",
	"TANGUT COMPONENT-666",
	"TANGUT COMPONENT-667",
	"TANGUT COMPONENT-668",
	"TANGUT COMPONENT-669",
	"TANGUT COMPONENT-670",
	"TANGUT COMPONENT-671",
	"TANGUT COMPONENT-672",
	"TANGUT COMPONENT-673",
	"TANGUT COMPONENT-674",
	"TANGUT COMPONENT-675",
	"TANGUT COMPONENT-676",
	"TANGUT COMPONENT-677",
	"TANGUT COMPONENT-678",
	"TANGUT COMPONENT-679",
	"TANGUT COMPONENT-680",
	"TANGUT COMPONENT-681",
	"TANGUT COMPONENT-682",
	"TANGUT COMPONENT-683",
	"TANGUT COMPONENT-684",
	"TANGUT COMPONENT-685",
	"TANGUT COMPONENT-686",
	"TANGUT COMPONENT-687",
	"TANGUT COMPONENT-688",
	"TANGUT COMPONENT-689",
	"TANGUT COMPONENT-690",
	"TANGUT COMPONENT-691",
	"TANGUT COMPONENT-692",
	"TANGUT COMPONENT-693",
	"TANGUT COMPONENT-694",
	"TANGUT COMPONENT-695",
	"TANGUT COMPONENT-696",
	"TANGUT COMPONENT-697",
	"TANGUT COMPONENT-698",
	"TANGUT COMPONENT-699",
	"TANGUT COMPONENT-700",
	"TANGUT COMPONENT-701",
	"TANGUT COMPONENT-702",
	"TANGUT COMPONENT-703",
	"TANGUT COMPONENT-704",
	"TANGUT COMPONENT-705",
	"TANGUT COMPONENT-706",
	"TANGUT COMPONENT-707",
	"TANGUT COMPONENT-708",
	"TANGUT COMPONENT-709",
	"TANGUT COMPONENT-710",
	"TANGUT COMPONENT-711",
	"TANGUT COMPONENT-712",
	"TANGUT COMPONENT-713",
	"TANGUT COMPONENT-714",
	"TANGUT COMPONENT-715",
	"TANGUT COMPONENT-716",
	"TANGUT COMPONENT-717",
	"TANGUT COMPONENT-718",
	"TANGUT COMPONENT-719",
	"TANGUT COMPONENT-720",
	"TANGUT COMPONENT-721",
	"TANGUT COMPONENT-722",
	"TANGUT COMPONENT-723",
	"TANGUT COMPONENT-724",
	"TANGUT COMPONENT-725",
	"TANGUT COMPONENT-726",
	"TANGUT COMPONENT-727",
	"TANGUT COMPONENT-728",
	"TANGUT COMPONENT-729",
	"TANGUT COMPONENT-730",
	"TANGUT COMPONENT-731",
	"TANGUT COMPONENT-732",
	"TANGUT COMPONENT-733",
	"TANGUT COMPONENT-734",
	"TANGUT COMPONENT-735",
	"TANGUT COMPONENT-736",
	"TANGUT COMPONENT-737",
	"TANGUT COMPONENT-738",
	"TANGUT COMPONENT-739",
	"TANGUT COMPONENT-740",
	"TANGUT COMPONENT-741",
	"TANGUT COMPONENT-742",
	"TANGUT COMPONENT-743",
	"TANGUT COMPONENT-744",
	"TANGUT COMPONENT-745",
	"TANGUT COMPONENT-746",
	"TANGUT COMPONENT-747",
	"TANGUT COMPONENT-748",
	"TANGUT COMPONENT-749",
	"TANGUT COMPONENT-750",
	"TANGUT COMPONENT-751",
	"TANGUT COMPONENT-752",
	"TANGUT COMPONENT-753",
	"TANGUT COMPONENT-754",
	"TANGUT COMPONENT-755",
	"TANGUT COMPONENT-756",
	"TANGUT COMPONENT-757",
	"TANGUT COMPONENT-758",
	"TANGUT COMPONENT-759",
	"TANGUT COMPONENT-760",
	"TANGUT COMPONENT-761",
	"TANGUT COMPONENT-762",
	"TANGUT COMPONENT-763",
	"TANGUT COMPONENT-764",
	"TANGUT COMPONENT-765",
	"TANGUT COMPONENT-766",
	"TANGUT COMPONENT-767",
	"TANGUT COMPONENT-768",
	"KHITAN SMALL SCRIPT CHARACTER-18B00",
	"KHITAN SMALL SCRIPT CHARACTER-18B01",
	"KHITAN SMALL SCRIPT CHARACTER-18B02",
	"KHITAN SMALL SCRIPT CHARACTER-18B03",
	"KHITAN SMALL SCRIPT CHARACTER-18B04",
	"KHITAN SMALL SCRIPT CHARACTER-18B05",
	"KHITAN SMALL SCRIPT CHARACTER-18B06",
	"KHITAN SMALL SCRIPT CHARACTER-18B07",
	"KHITAN SMALL SCRIPT CHARACTER-18B08",
	"KHITAN SMALL SCRIPT CHARACTER-18B09",
	"KHITAN SMALL SCRIPT CHARACTER-18B0A",
	"KHITAN SMALL SCRIPT CHARACTER-18B0B",
	"KHITAN SMALL SCRIPT CHARACTER-18B0C",
	"KHITAN SMALL SCRIPT CHARACTER-18B0D",
	"KHITAN SMALL SCRIPT CHARACTER-18B0E",
	"KHITAN SMALL SCRIPT CHARACTER-18B0F",
	"KHITAN SMALL SCRIPT CHARACTER-18B10",
	"KHITAN SMALL SCRIPT CHARACTER-18B11",
	"KHITAN SMALL SCRIPT CHARACTER-18B12",
	"KHITAN SMALL SCRIPT CHARACTER-18B13",
	"KHITAN SMALL SCRIPT CHARACTER-18B14",
	"KHITAN SMALL SCRIPT CHARACTER-18B15",
	"KHITAN SMALL SCRIPT CHARACTER-18B16",
	"KHITAN SMALL SCRIPT CHARACTER-18B17",
	"KHITAN SMALL SCRIPT CHARACTER-18B18",
	"KHITAN SMALL SCRIPT CHARACTER-18B19",
	"KHITAN SMALL SCRIPT CHARACTER-18B1A",
	"KHITAN SMALL SCRIPT CHARACTER-18B1B",
	"KHITAN SMALL SCRIPT CHARACTER-18B1C",
	"KHITAN SMALL SCRIPT CHARACTER-18B1D",
	"KHITAN SMALL SCRIPT CHARACTER-18B1E",
	"KHITAN SMALL SCRIPT CHARACTER-18B1F",
	"KHITAN SMALL SCRIPT CHARACTER-18B20",
	"KHITAN SMALL SCRIPT CHARACTER-18B21",
	"KHITAN SMALL SCRIPT CHARACTER-18B22",
	"KHITAN SMALL SCRIPT CHARACTER-18B23",
	"KHITAN SMALL SCRIPT CHARACTER-18B24",
	"KHITAN SMALL SCRIPT CHARACTER-18B25",
	"KHITAN SMALL SCRIPT CHARACTER-18B26",
	"KHITAN SMALL SCRIPT CHARACTER-18B27",
	"KHITAN SMALL SCRIPT CHARACTER-18B28",
	"KHITAN SMALL SCRIPT CHARACTER-18B29",
	"KHITAN SMALL SCRIPT CHARACTER-18B2A",
	"KHITAN SMALL SCRIPT CHARACTER-18B2B",
	"KHITAN SMALL SCRIPT CHARACTER-18B2C",
	"KHITAN SMALL SCRIPT CHARACTER-18B2D",
	"KHITAN SMALL SCRIPT CHARACTER-18B2E",
	"KHITAN SMALL SCRIPT CHARACTER-18B2F",
	"KHITAN SMALL SCRIPT CHARACTER-18B30",
	"KHITAN SMALL SCRIPT CHARACTER-18B31",
	"KHITAN SMALL SCRIPT CHARACTER-18B32",
	"KHITAN SMALL SCRIPT CHARACTER-18B33",
	"KHITAN SMALL SCRIPT CHARACTER-18B34",
	"KHITAN SMALL SCRIPT CHARACTER-18B35",
	"KHITAN SMALL SCRIPT CHARACTER-18B36",
	"KHITAN SMALL SCRIPT CHARACTER-18B37",
	"KHITAN SMALL SCRIPT CHARACTER-18B38",
	"KHITAN SMALL SCRIPT CHARACTER-18B39",
	"KHITAN SMALL SCRIPT CHARACTER-18B3A",
	"KHITAN SMALL SCRIPT CHARACTER-18B3B",
	"KHITAN SMALL SCRIPT CHARACTER-18B3C",
	"KHITAN SMALL SCRIPT CHARACTER-18B3D",
	"KHITAN SMALL SCRIPT CHARACTER-18B3E",
	"KHITAN SMALL SCRIPT CHARACTER-18B3F",
	"KHITAN SMALL SCRIPT CHARACTER-18B40",
	"KHITAN SMALL SCRIPT CHARACTER-18B41",
	"KHITAN SMALL SCRIPT CHARACTER-18B42",
	"KHITAN SMALL SCRIPT CHARACTER-18B43",
	"KHITAN SMALL SCRIPT CHARACTER-18B44",
	"KHITAN SMALL SCRIPT CHARACTER-18B45",
	"KHITAN SMALL SCRIPT CHARACTER-18B46",
	"KHITAN SMALL SCRIPT CHARACTER-18B47",
	"KHITAN SMALL SCRIPT CHARACTER-18B48",
	"KHITAN SMALL SCRIPT CHARACTER-18B49",
	"KHITAN SMALL SCRIPT CHARACTER-18B4A",
	"KHITAN SMALL SCRIPT CHARACTER-18B4B",
	"KHITAN SMALL SCRIPT CHARACTER-18B4C",
	"KHITAN SMALL SCRIPT CHARACTER-18B4D",
	"KHITAN SMALL SCRIPT CHARACTER-18B4E",
	"KHITAN SMALL SCRIPT CHARACTER-18B4F",
	"KHITAN SMALL SCRIPT CHARACTER-18B50",
	"KHITAN SMALL SCRIPT CHARACTER-18B51",
	"KHITAN SMALL SCRIPT CHARACTER-18B52",
	"KHITAN SMALL SCRIPT CHARACTER-18B53",
	"KHITAN SMALL SCRIPT CHARACTER-18B54",
	"KHITAN SMALL SCRIPT CHARACTER-18B55",
	"KHITAN SMALL SCRIPT CHARACTER-18B56",
	"KHITAN SMALL SCRIPT CHARACTER-18B57",
	"KHITAN SMALL SCRIPT CHARACTER-18B58",
	"KHITAN SMALL SCRIPT CHARACTER-18B59",
	"KHITAN SMALL SCRIPT CHARACTER-18B5A",
	"KHITAN SMALL SCRIPT CHARACTER-18B5B",
	"KHITAN SMALL SCRIPT CHARACTER-18B5C",
	"KHITAN SMALL SCRIPT CHARACTER-18B5D",
	"KHITAN SMALL SCRIPT CHARACTER-18B5E",
	"KHITAN SMALL SCRIPT CHARACTER-18B5F",
	"KHITAN SMALL SCRIPT CHARACTER-18B60",
	"KHITAN SMALL SCRIPT CHARACTER-18B61",
	"KHITAN SMALL SCRIPT CHARACTER-18B62",
	"KHITAN SMALL SCRIPT CHARACTER-18B63",
	"KHITAN SMALL SCRIPT CHARACTER-18B64",
	"KHITAN SMALL SCRIPT CHARACTER-18B65",
	"KHITAN SMALL SCRIPT CHARACTER-18B66",
	"KHITAN SMALL SCRIPT CHARACTER-18B67",
	"KHITAN SMALL SCRIPT CHARACTER-18B68",
	"KHITAN SMALL SCRIPT CHARACTER-18B69",
	"KHITAN SMALL SCRIPT CHARACTER-18B6A",
	"KHITAN SMALL SCRIPT CHARACTER-18B6B",
	"KHITAN SMALL SCRIPT CHARACTER-18B6C",
	"KHITAN SMALL SCRIPT CHARACTER-18B6D",
	"KHITAN SMALL SCRIPT CHARACTER-18B6E",
	"KHITAN SMALL SCRIPT CHARACTER-18B6F",
	"KHITAN SMALL SCRIPT CHARACTER-18B70",
	"KHITAN SMALL SCRIPT CHARACTER-18B71",
	"KHITAN SMALL SCRIPT CHARACTER-18B72",
	"KHITAN SMALL SCRIPT CHARACTER-18B73",
	"KHITAN SMALL SCRIPT CHARACTER-18B74",
	"KHITAN SMALL SCRIPT CHARACTER-18B75",
	"KHITAN SMALL SCRIPT CHARACTER-18B76",
	"KHITAN SMALL SCRIPT CHARACTER-18B77",
	"KHITAN SMALL SCRIPT CHARACTER-18B78",
	"KHITAN SMALL SCRIPT CHARACTER-18B79",
	"KHITAN SMALL SCRIPT CHARACTER-18B7A",
	"KHITAN SMALL SCRIPT CHARACTER-18B7B",
	"KHITAN SMALL SCRIPT CHARACTER-18B7C",
	"KHITAN SMALL SCRIPT CHARACTER-18B7D",
	"KHITAN SMALL SCRIPT CHARACTER-18B7E",
	"KHITAN SMALL SCRIPT CHARACTER-18B7F",
	"KHITAN SMALL SCRIPT CHARACTER-18B80",
	"KHITAN SMALL SCRIPT CHARACTER-18B81",
	"KHITAN SMALL SCRIPT CHARACTER-18B82",
	"KHITAN SMALL SCRIPT CHARACTER-18B83",
	"KHITAN SMALL SCRIPT CHARACTER-18B84",
	"KHITAN SMALL SCRIPT CHARACTER-18B85",
	"KHITAN SMALL SCRIPT CHARACTER-18B86",
	"KHITAN SMALL SCRIPT CHARACTER-18B87",
	"KHITAN SMALL SCRIPT CHARACTER-18B88",
	"KHITAN SMALL SCRIPT CHARACTER-18B89",
	"KHITAN SMALL SCRIPT CHARACTER-18B8A",
	"KHITAN SMALL SCRIPT CHARACTER-18B8B",
	"KHITAN SMALL SCRIPT CHARACTER-18B8C",
	"KHITAN SMALL SCRIPT CHARACTER-18B8D",
	"KHITAN SMALL SCRIPT CHARACTER-18B8E",
	"KHITAN SMALL SCRIPT CHARACTER-18B8F",
	"KHITAN SMALL SCRIPT CHARACTER-18B90",
	"KHITAN SMALL SCRIPT CHARACTER-18B91",
	"KHITAN SMALL SCRIPT CHARACTER-18B92",
	"KHITAN SMALL SCRIPT CHARACTER-18B93",
	"KHITAN SMALL SCRIPT CHARACTER-18B94",
	"KHITAN SMALL SCRIPT CHARACTER-18B95",
	"KHITAN SMALL SCRIPT CHARACTER-18B96",
	"KHITAN SMALL SCRIPT CHARACTER-18B97",
	"KHITAN SMALL SCRIPT CHARACTER-18B98",
	"KHITAN SMALL SCRIPT CHARACTER-18B99",
	"KHITAN SMALL SCRIPT CHARACTER-18B9A",
	"KHITAN SMALL SCRIPT CHARACTER-18B9B",
	"KHITAN SMALL SCRIPT CHARACTER-18B9C",
	"KHITAN SMALL SCRIPT CHARACTER-18B9D",
	"KHITAN SMALL SCRIPT CHARACTER-18B9E",
	"KHITAN SMALL SCRIPT CHARACTER-18B9F",
	"KHITAN SMALL SCRIPT CHARACTER-18BA0",
	"KHITAN SMALL SCRIPT CHARACTER-18BA1",
	"KHITAN SMALL SCRIPT CHARACTER-18BA2",
	"KHITAN SMALL SCRIPT CHARACTER-18BA3",
	"KHITAN SMALL SCRIPT CHARACTER-18BA4",
	"KHITAN SMALL SCRIPT CHARACTER-18BA5",
	"KHITAN SMALL SCRIPT CHARACTER-18BA6",
	"KHITAN SMALL SCRIPT CHARACTER-18BA7",
	"KHITAN SMALL SCRIPT CHARACTER-18BA8",
	"KHITAN SMALL SCRIPT CHARACTER-18BA9",
	"KHITAN SMALL SCRIPT CHARACTER-18BAA",
	"KHITAN SMALL SCRIPT CHARACTER-18BAB",
	"KHITAN SMALL SCRIPT CHARACTER-18BAC",
	"KHITAN SMALL SCRIPT CHARACTER-18BAD",
	"KHITAN SMALL SCRIPT CHARACTER-18BAE",
	"KHITAN SMALL SCRIPT CHARACTER-18BAF",
	"KHITAN SMALL SCRIPT CHARACTER-18BB0",
	"KHITAN SMALL SCRIPT CHARACTER-18BB1",
	"KHITAN SMALL SCRIPT CHARACTER-18BB2",
	"KHITAN SMALL SCRIPT CHARACTER-18BB3",
	"KHITAN SMALL SCRIPT CHARACTER-18BB4",
	"KHITAN SMALL SCRIPT CHARACTER-18BB5",
	"KHITAN SMALL SCRIPT CHARACTER-18BB6",
	"KHITAN SMALL SCRIPT CHARACTER-18BB7",
	"KHITAN SMALL SCRIPT CHARACTER-18BB8",
	"KHITAN SMALL SCRIPT CHARACTER-18BB9",
	"KHITAN SMALL SCRIPT CHARACTER-18BBA",
	"KHITAN SMALL SCRIPT CHARACTER-18BBB",
	"KHITAN SMALL SCRIPT CHARACTER-18BBC",
	"KHITAN SMALL SCRIPT CHARACTER-18BBD",
	"KHITAN SMALL SCRIPT CHARACTER-18BBE",
	"KHITAN SMALL SCRIPT CHARACTER-18BBF",
	"KHITAN SMALL SCRIPT CHARACTER-18BC0",
	"KHITAN SMALL SCRIPT CHARACTER-18BC1",
	"KHITAN SMALL SCRIPT CHARACTER-18BC2",
	"KHITAN SMALL SCRIPT CHARACTER-18BC3",
	"KHITAN SMALL SCRIPT CHARACTER-18BC4",
	"KHITAN SMALL SCRIPT CHARACTER-18BC5",
	"KHITAN SMALL SCRIPT CHARACTER-18BC6",
	"KHITAN SMALL SCRIPT CHARACTER-18BC7",
	"KHITAN SMALL SCRIPT CHARACTER-18BC8",
	"KHITAN SMALL SCRIPT CHARACTER-18BC9",
	"KHITAN SMALL SCRIPT CHARACTER-18BCA",
	"KHITAN SMALL SCRIPT CHARACTER-18BCB",
	"KHITAN SMALL SCRIPT CHARACTER-18BCC",
	"KHITAN SMALL SCRIPT CHARACTER-18BCD",
	"KHITAN SMALL SCRIPT CHARACTER-18BCE",
	"KHITAN SMALL SCRIPT CHARACTER-18BCF",
	"KHITAN SMALL SCRIPT CHARACTER-18BD0",
	"KHITAN SMALL SCRIPT CHARACTER-18BD1",
	"KHITAN SMALL SCRIPT CHARACTER-18BD2",
	"KHITAN SMALL SCRIPT CHARACTER-18BD3",
	"KHITAN SMALL SCRIPT CHARACTER-18BD4",
	"KHITAN SMALL SCRIPT CHARACTER-18BD5",
	"KHITAN SMALL SCRIPT CHARACTER-18BD6",
	"KHITAN SMALL SCRIPT CHARACTER-18BD7",
	"KHITAN SMALL SCRIPT CHARACTER-18BD8",
	"KHITAN SMALL SCRIPT CHARACTER-18BD9",
	"KHITAN SMALL SCRIPT CHARACTER-18BDA",
	"KHITAN SMALL SCRIPT CHARACTER-18BDB",
	"KHITAN SMALL SCRIPT CHARACTER-18BDC",
	"KHITAN SMALL SCRIPT CHARACTER-18BDD",
	"KHITAN SMALL SCRIPT CHARACTER-18BDE",
	"KHITAN SMALL SCRIPT CHARACTER-18BDF",
	"KHITAN SMALL SCRIPT CHARACTER-18BE0",
	"KHITAN SMALL SCRIPT CHARACTER-18BE1",
	"KHITAN SMALL SCRIPT CHARACTER-18BE2",
	"KHITAN SMALL SCRIPT CHARACTER-18BE3",
	"KHITAN SMALL SCRIPT CHARACTER-18BE4",
	"KHITAN SMALL SCRIPT CHARACTER-18BE5",
	"KHITAN SMALL SCRIPT CHARACTER-18BE6",
	"KHITAN SMALL SCRIPT CHARACTER-18BE7",
	"KHITAN SMALL SCRIPT CHARACTER-18BE8",
	"KHITAN SMALL SCRIPT CHARACTER-18BE9",
	"KHITAN SMALL SCRIPT CHARACTER-18BEA",
	"KHITAN SMALL SCRIPT CHARACTER-18BEB",
	"KHITAN SMALL SCRIPT CHARACTER-18BEC",
	"KHITAN SMALL SCRIPT CHARACTER-18BED",
	"KHITAN SMALL SCRIPT CHARACTER-18BEE",
	"KHITAN SMALL SCRIPT CHARACTER-18BEF",
	"KHITAN SMALL SCRIPT CHARACTER-18BF0",
	"KHITAN SMALL SCRIPT CHARACTER-18BF1",
	"KHITAN SMALL SCRIPT CHARACTER-18BF2",
	"KHITAN SMALL SCRIPT CHARACTER-18BF3",
	"KHITAN SMALL SCRIPT CHARACTER-18BF4",
	"KHITAN SMALL SCRIPT CHARACTER-18BF5",
	"KHITAN SMALL SCRIPT CHARACTER-18BF6",
	"KHITAN SMALL SCRIPT CHARACTER-18BF7",
	"KHITAN SMALL SCRIPT CHARACTER-18BF8",
	"KHITAN SMALL SCRIPT CHARACTER-18BF9",
	"KHITAN SMALL SCRIPT CHARACTER-18BFA",
	"KHITAN SMALL SCRIPT CHARACTER-18BFB",
	"KHITAN SMALL SCRIPT CHARACTER-18BFC",
	"KHITAN SMALL SCRIPT CHARACTER-18BFD",
	"KHITAN SMALL SCRIPT CHARACTER-18BFE",
	"KHITAN SMALL SCRIPT CHARACTER-18BFF",
	"KHITAN SMALL SCRIPT CHARACTER-18C00",
	"KHITAN SMALL SCRIPT CHARACTER-18C01",
	"KHITAN SMALL SCRIPT CHARACTER-18C02",
	"KHITAN SMALL SCRIPT CHARACTER-18C03",
	"KHITAN SMALL SCRIPT CHARACTER-18C04",
	"KHITAN SMALL SCRIPT CHARACTER-18C05",
	"KHITAN SMALL SCRIPT CHARACTER-18C06",
	"KHITAN SMALL SCRIPT CHARACTER-18C07",
	"KHITAN SMALL SCRIPT CHARACTER-18C08",
	"KHITAN SMALL SCRIPT CHARACTER-18C09",
	"KHITAN SMALL SCRIPT CHARACTER-18C0A",
	"KHITAN SMALL SCRIPT CHARACTER-18C0B",
	"KHITAN SMALL SCRIPT CHARACTER-18C0C",
	"KHITAN SMALL SCRIPT CHARACTER-18C0D",
	"KHITAN SMALL SCRIPT CHARACTER-18C0E",
	"KHITAN SMALL SCRIPT CHARACTER-18C0F",
	"KHITAN SMALL SCRIPT CHARACTER-18C10",
	"KHITAN SMALL SCRIPT CHARACTER-18C11",
	"KHITAN SMALL SCRIPT CHARACTER-18C12",
	"KHITAN SMALL SCRIPT CHARACTER-18C13",
	"KHITAN SMALL SCRIPT CHARACTER-18C14",
	"KHITAN SMALL SCRIPT CHARACTER-18C15",
	"KHITAN SMALL SCRIPT CHARACTER-18C16",
	"KHITAN SMALL SCRIPT CHARACTER-18C17",
	"KHITAN SMALL SCRIPT CHARACTER-18C18",
	"KHITAN SMALL SCRIPT CHARACTER-18C19",
	"KHITAN SMALL SCRIPT CHARACTER-18C1A",
	"KHITAN SMALL SCRIPT CHARACTER-18C1B",
	"KHITAN SMALL SCRIPT CHARACTER-18C1C",
	"KHITAN SMALL SCRIPT CHARACTER-18C1D",
	"KHITAN SMALL SCRIPT CHARACTER-18C1E",
	"KHITAN SMALL SCRIPT CHARACTER-18C1F",
	"KHITAN SMALL SCRIPT CHARACTER-18C20",
	"KHITAN SMALL SCRIPT CHARACTER-18C21",
	"KHITAN SMALL SCRIPT CHARACTER-18C22",
	"KHITAN SMALL SCRIPT CHARACTER-18C23",
	"KHITAN SMALL SCRIPT CHARACTER-18C24",
	"KHITAN SMALL SCRIPT CHARACTER-18C25",
	"KHITAN SMALL SCRIPT CHARACTER-18C26",
	"KHITAN SMALL SCRIPT CHARACTER-18C27",
	"KHITAN SMALL SCRIPT CHARACTER-18C28",
	"KHITAN SMALL SCRIPT CHARACTER-18C29",
	"KHITAN SMALL SCRIPT CHARACTER-18C2A",
	"KHITAN SMALL SCRIPT CHARACTER-18C2B",
	"KHITAN SMALL SCRIPT CHARACTER-18C2C",
	"KHITAN SMALL SCRIPT CHARACTER-18C2D",
	"KHITAN SMALL SCRIPT CHARACTER-18C2E",
	"KHITAN SMALL SCRIPT CHARACTER-18C2F",
	"KHITAN SMALL SCRIPT CHARACTER-18C30",
	"KHITAN SMALL SCRIPT CHARACTER-18C31",
	"KHITAN SMALL SCRIPT CHARACTER-18C32",
	"KHITAN SMALL SCRIPT CHARACTER-18C33",
	"KHITAN SMALL SCRIPT CHARACTER-18C34",
	"KHITAN SMALL SCRIPT CHARACTER-18C35",
	"KHITAN SMALL SCRIPT CHARACTER-18C36",
	"KHITAN SMALL SCRIPT CHARACTER-18C37",
	"KHITAN SMALL SCRIPT CHARACTER-18C38",
	"KHITAN SMALL SCRIPT CHARACTER-18C39",
	"KHITAN SMALL SCRIPT CHARACTER-18C3A",
	"KHITAN SMALL SCRIPT CHARACTER-18C3B",
	"KHITAN SMALL SCRIPT CHARACTER-18C3C",
	"KHITAN SMALL SCRIPT CHARACTER-18C3D",
	"KHITAN SMALL SCRIPT CHARACTER-18C3E",
	"KHITAN SMALL SCRIPT CHARACTER-18C3F",
	"KHITAN SMALL SCRIPT CHARACTER-18C40",
	"KHITAN SMALL SCRIPT CHARACTER-18C41",
	"KHITAN SMALL SCRIPT CHARACTER-18C42",
	"KHITAN SMALL SCRIPT CHARACTER-18C43",
	"KHITAN SMALL SCRIPT CHARACTER-18C44",
	"KHITAN SMALL SCRIPT CHARACTER-18C45",
	"KHITAN SMALL SCRIPT CHARACTER-18C46",
	"KHITAN SMALL SCRIPT CHARACTER-18C47",
	"KHITAN SMALL SCRIPT CHARACTER-18C48",
	"KHITAN SMALL SCRIPT CHARACTER-18C49",
	"KHITAN SMALL SCRIPT CHARACTER-18C4A",
	"KHITAN SMALL SCRIPT CHARACTER-18C4B",
	"KHITAN SMALL SCRIPT CHARACTER-18C4C",
	"KHITAN SMALL SCRIPT CHARACTER-18C4D",
	"KHITAN SMALL SCRIPT CHARACTER-18C4E",
	"KHITAN SMALL SCRIPT CHARACTER-18C4F",
	"KHITAN SMALL SCRIPT CHARACTER-18C50",
	"KHITAN SMALL SCRIPT CHARACTER-18C51",
	"KHITAN SMALL SCRIPT CHARACTER-18C52",
	"KHITAN SMALL SCRIPT CHARACTER-18C53",
	"KHITAN SMALL SCRIPT CHARACTER-18C54",
	"KHITAN SMALL SCRIPT CHARACTER-18C55",
	"KHITAN SMALL SCRIPT CHARACTER-18C56",
	"KHITAN SMALL SCRIPT CHARACTER-18C57",
	"KHITAN SMALL SCRIPT CHARACTER-18C58",
	"KHITAN SMALL SCRIPT CHARACTER-18C59",
	"KHITAN SMALL SCRIPT CHARACTER-18C5A",
	"KHITAN SMALL SCRIPT CHARACTER-18C5B",
	"KHITAN SMALL SCRIPT CHARACTER-18C5C",
	"KHITAN SMALL SCRIPT CHARACTER-18C5D",
	"KHITAN SMALL SCRIPT CHARACTER-18C5E",
	"KHITAN SMALL SCRIPT CHARACTER-18C5F",
	"KHITAN SMALL SCRIPT CHARACTER-18C60",
	"KHITAN SMALL SCRIPT CHARACTER-18C61",
	"KHITAN SMALL SCRIPT CHARACTER-18C62",
	"KHITAN SMALL SCRIPT CHARACTER-18C63",
	"KHITAN SMALL SCRIPT CHARACTER-18C64",
	"KHITAN SMALL SCRIPT CHARACTER-18C65",
	"KHITAN SMALL SCRIPT CHARACTER-18C66",
	"KHITAN SMALL SCRIPT CHARACTER-18C67",
	"KHITAN SMALL SCRIPT CHARACTER-18C68",
	"KHITAN SMALL SCRIPT CHARACTER-18C69",
	"KHITAN SMALL SCRIPT CHARACTER-18C6A",
	"KHITAN SMALL SCRIPT CHARACTER-18C6B",
	"KHITAN SMALL SCRIPT CHARACTER-18C6C",
	"KHITAN SMALL SCRIPT CHARACTER-18C6D",
	"KHITAN SMALL SCRIPT CHARACTER-18C6E",
	"KHITAN SMALL SCRIPT CHARACTER-18C6F",
	"KHITAN SMALL SCRIPT CHARACTER-18C70",
	"KHITAN SMALL SCRIPT CHARACTER-18C71",
	"KHITAN SMALL SCRIPT CHARACTER-18C72",
	"KHITAN SMALL SCRIPT CHARACTER-18C73",
	"KHITAN SMALL SCRIPT CHARACTER-18C74",
	"KHITAN SMALL SCRIPT CHARACTER-18C75",
	"KHITAN SMALL SCRIPT CHARACTER-18C76",
	"KHITAN SMALL SCRIPT CHARACTER-18C77",
	"KHITAN SMALL SCRIPT CHARACTER-18C78",
	"KHITAN SMALL SCRIPT CHARACTER-18C79",
	"KHITAN SMALL SCRIPT CHARACTER-18C7A",
	"KHITAN SMALL SCRIPT CHARACTER-18C7B",
	"KHITAN SMALL SCRIPT CHARACTER-18C7C",
	"KHITAN SMALL SCRIPT CHARACTER-18C7D",
	"KHITAN SMALL SCRIPT CHARACTER-18C7E",
	"KHITAN SMALL SCRIPT CHARACTER-18C7F",
	"KHITAN SMALL SCRIPT CHARACTER-18C80",
	"KHITAN SMALL SCRIPT CHARACTER-18C81",
	"KHITAN SMALL SCRIPT CHARACTER-18C82",
	"KHITAN SMALL SCRIPT CHARACTER-18C83",
	"KHITAN SMALL SCRIPT CHARACTER-18C84",
	"KHITAN SMALL SCRIPT CHARACTER-18C85",
	"KHITAN SMALL SCRIPT CHARACTER-18C86",
	"KHITAN SMALL SCRIPT CHARACTER-18C87",
	"KHITAN SMALL SCRIPT CHARACTER-18C88",
	"KHITAN SMALL SCRIPT CHARACTER-18C89",
	"KHITAN SMALL SCRIPT CHARACTER-18C8A",
	"KHITAN SMALL SCRIPT CHARACTER-18C8B",
	"KHITAN SMALL SCRIPT CHARACTER-18C8C",
	"KHITAN SMALL SCRIPT CHARACTER-18C8D",
	"KHITAN SMALL SCRIPT CHARACTER-18C8E",
	"KHITAN SMALL SCRIPT CHARACTER-18C8F",
	"KHITAN SMALL SCRIPT CHARACTER-18C90",
	"KHITAN SMALL SCRIPT CHARACTER-18C91",
	"KHITAN SMALL SCRIPT CHARACTER-18C92",
	"KHITAN SMALL SCRIPT CHARACTER-18C93",
	"KHITAN SMALL SCRIPT CHARACTER-18C94",
	"KHITAN SMALL SCRIPT CHARACTER-18C95",
	"KHITAN SMALL SCRIPT CHARACTER-18C96",
	"KHITAN SMALL SCRIPT CHARACTER-18C97",
	"KHITAN SMALL SCRIPT CHARACTER-18C98",
	"KHITAN SMALL SCRIPT CHARACTER-18C99",
	"KHITAN SMALL SCRIPT CHARACTER-18C9A",
	"KHITAN SMALL SCRIPT CHARACTER-18C9B",
	"KHITAN SMALL SCRIPT CHARACTER-18C9C",
	"KHITAN SMALL SCRIPT CHARACTER-18C9D",
	"KHITAN SMALL SCRIPT CHARACTER-18C9E",
	"KHITAN SMALL SCRIPT CHARACTER-18C9F",
	"KHITAN SMALL SCRIPT CHARACTER-18CA0",
	"KHITAN SMALL SCRIPT CHARACTER-18CA1",
	"KHITAN SMALL SCRIPT CHARACTER-18CA2",
	"KHITAN SMALL SCRIPT CHARACTER-18CA3",
	"KHITAN SMALL SCRIPT CHARACTER-18CA4",
	"KHITAN SMALL SCRIPT CHARACTER-18CA5",
	"KHITAN SMALL SCRIPT CHARACTER-18CA6",
	"KHITAN SMALL SCRIPT CHARACTER-18CA7",
	"KHITAN SMALL SCRIPT CHARACTER-18CA8",
	"KHITAN SMALL SCRIPT CHARACTER-18CA9",
	"KHITAN SMALL SCRIPT CHARACTER-18CAA",
	"KHITAN SMALL SCRIPT CHARACTER-18CAB",
	"KHITAN SMALL SCRIPT CHARACTER-18CAC",
	"KHITAN SMALL SCRIPT CHARACTER-18CAD",
	"KHITAN SMALL SCRIPT CHARACTER-18CAE",
	"KHITAN SMALL SCRIPT CHARACTER-18CAF",
	"KHITAN SMALL SCRIPT CHARACTER-18CB0",
	"KHITAN SMALL SCRIPT CHARACTER-18CB1",
	"KHITAN SMALL SCRIPT CHARACTER-18CB2",
	"KHITAN SMALL SCRIPT CHARACTER-18CB3",
	"KHITAN SMALL SCRIPT CHARACTER-18CB4",
	"KHITAN SMALL SCRIPT CHARACTER-18CB5",
	"KHITAN SMALL SCRIPT CHARACTER-18CB6",
	"KHITAN SMALL SCRIPT CHARACTER-18CB7",
	"KHITAN SMALL SCRIPT CHARACTER-18CB8",
	"KHITAN SMALL SCRIPT CHARACTER-18CB9",
	"KHITAN SMALL SCRIPT CHARACTER-18CBA",
	"KHITAN SMALL SCRIPT CHARACTER-18CBB",
	"KHITAN SMALL SCRIPT CHARACTER-18CBC",
	"KHITAN SMALL SCRIPT CHARACTER-18CBD",
	"KHITAN SMALL SCRIPT CHARACTER-18CBE",
	"KHITAN SMALL SCRIPT CHARACTER-18CBF",
	"KHITAN SMALL SCRIPT CHARACTER-18CC0",
	"KHITAN SMALL SCRIPT CHARACTER-18CC1",
	"KHITAN SMALL SCRIPT CHARACTER-18CC2",
	"KHITAN SMALL SCRIPT CHARACTER-18CC3",
	"KHITAN SMALL SCRIPT CHARACTER-18CC4",
	"KHITAN SMALL SCRIPT CHARACTER-18CC5",
	"KHITAN SMALL SCRIPT CHARACTER-18CC6",
	"KHITAN SMALL SCRIPT CHARACTER-18CC7",
	"KHITAN SMALL SCRIPT CHARACTER-18CC8",
	"KHITAN SMALL SCRIPT CHARACTER-18CC9",
	"KHITAN SMALL SCRIPT CHARACTER-18CCA",
	"KHITAN SMALL SCRIPT CHARACTER-18CCB",
	"KHITAN SMALL SCRIPT CHARACTER-18CCC",
	"KHITAN SMALL SCRIPT CHARACTER-18CCD",
	"KHITAN SMALL SCRIPT CHARACTER-18CCE",
	"KHITAN SMALL SCRIPT CHARACTER-18CCF",
	"KHITAN SMALL SCRIPT CHARACTER-18CD0",
	"KHITAN SMALL SCRIPT CHARACTER-18CD1",
	"KHITAN SMALL SCRIPT CHARACTER-18CD2",
	"KHITAN SMALL SCRIPT CHARACTER-18CD3",
	"KHITAN SMALL SCRIPT CHARACTER-18CD4",
	"KHITAN SMALL SCRIPT CHARACTER-18CD5",
	"<Tangut Ideograph Supplement, First>",
	"<Tangut Ideograph Supplement, Last>",
	"KATAKANA LETTER MINNAN TONE-2",
	"KATAKANA LETTER MINNAN TONE-3",
	"KATAKANA LETTER MINNAN TONE-4",
	"KATAKANA LETTER MINNAN TONE-5",
	"KATAKANA LETTER MINNAN TONE-7",
	"KATAKANA LETTER MINNAN TONE-8",
	"KATAKANA LETTER MINNAN NASALIZED TONE-1",
	"KATAKANA LETTER MINNAN NASALIZED TONE-2",
	"KATAKANA LETTER MINNAN NASALIZED TONE-3",
	"KATAKANA LETTER MINNAN NASALIZED TONE-4",
	"KATAKANA LETTER MINNAN NASALIZED TONE-5",
	"KATAKANA LETTER MINNAN NASALIZED TONE-7",
	"KATAKANA LETTER MINNAN NASALIZED TONE-8",
	"KATAKANA LETTER ARCHAIC E",
	"HIRAGANA LETTER ARCHAIC YE",
	"HENTAIGANA LETTER A-1",
	"HENTAIGANA LETTER A-2",
	"HENTAIGANA LETTER A-3",
	"HENTAIGANA LETTER A-WO",
	"HENTAIGANA LETTER I-1",
	"HENTAIGANA LETTER I-2",
	"HENTAIGANA LETTER I-3",
	"HENTAIGANA LETTER I-4",
	"HENTAIGANA LETTER U-1",
	"HENTAIGANA LETTER U-2",
	"HENTAIGANA LETTER U-3",
	"HENTAIGANA LETTER U-4",
	"HENTAIGANA LETTER U-5",
	"HENTAIGANA LETTER E-2",
	"HENTAIGANA LETTER E-3",
	"HENTAIGANA LETTER E-4",
	"HENTAIGANA LETTER E-5",
	"HENTAIGANA LETTER E-6",
	"HENTAIGANA LETTER O-1",
	"HENTAIGANA LETTER O-2",
	"HENTAIGANA LETTER O-3",
	"HENTAIGANA LETTER KA-1",
	"HENTAIGANA LETTER KA-2",
	"HENTAIGANA LETTER KA-3",
	"HENTAIGANA LETTER KA-4",
	"HENTAIGANA LETTER KA-5",
	"HENTAIGANA LETTER KA-6",
	"HENTAIGANA LETTER KA-7",
	"HENTAIGANA LETTER KA-8",
	"HENTAIGANA LETTER KA-9",
	"HENTAIGANA LETTER KA-10",
	"HENTAIGANA LETTER KA-11",
	"HENTAIGANA LETTER KA-KE",
	"HENTAIGANA LETTER KI-1",
	"HENTAIGANA LETTER KI-2",
	"HENTAIGANA LETTER KI-3",
	"HENTAIGANA LETTER KI-4",
	"HENTAIGANA LETTER KI-5",
	"HENTAIGANA LETTER KI-6",
	"HENTAIGANA LETTER KI-7",
	"HENTAIGANA LETTER KI-8",
	"HENTAIGANA LETTER KU-1",
	"HENTAIGANA LETTER KU-2",
	"HENTAIGANA LETTER KU-3",
	"HENTAIGANA LETTER KU-4",
	"HENTAIGANA LETTER KU-5",
	"HENTAIGANA LETTER KU-6",
	"HENTAIGANA LETTER KU-7",
	"HENTAIGANA LETTER KE-1",
	"HENTAIGANA LETTER KE-2",
	"HENTAIGANA LETTER KE-3",
	"HENTAIGANA LETTER KE-4",
	"HENTAIGANA LETTER KE-5",
	"HENTAIGANA LETTER KE-6",
	"HENTAIGANA LETTER KO-1",
	"HENTAIGANA LETTER KO-2",
	"HENTAIGANA LETTER KO-3",
	"HENTAIGANA LETTER KO-KI",
	"HENTAIGANA LETTER SA-1",
	"HENTAIGANA LETTER SA-2",
	"HENTAIGANA LETTER SA-3",
	"HENTAIGANA LETTER SA-4",
	"HENTAIGANA LETTER SA-5",
	"HENTAIGANA LETTER SA-6",
	"HENTAIGANA LETTER SA-7",
	"HENTAIGANA LETTER SA-8",
	"HENTAIGANA LETTER SI-1",
	"HENTAIGANA LETTER SI-2",
	"HENTAIGANA LETTER SI-3",
	"HENTAIGANA LETTER SI-4",
	"HENTAIGANA LETTER SI-5",
	"HENTAIGANA LETTER SI-6",
	"HENTAIGANA LETTER SU-1",
	"HENTAIGANA LETTER SU-2",
	"HENTAIGANA LETTER SU-3",
	"HENTAIGANA LETTER SU-4",
	"HENTAIGANA LETTER SU-5",
	"HENTAIGANA LETTER SU-6",
	"HENTAIGANA LETTER SU-7",
	"HENTAIGANA LETTER SU-8",
	"HENTAIGANA LETTER SE-1",
	"HENTAIGANA LETTER SE-2",
	"HENTAIGANA LETTER SE-3",
	"HENTAIGANA LETTER SE-4",
	"HENTAIGANA LETTER SE-5",
	"HENTAIGANA LETTER SO-1",
	"HENTAIGANA LETTER SO-2",
	"HENTAIGANA LETTER SO-3",
	"HENTAIGANA LETTER SO-4",
	"HENTAIGANA LETTER SO-5",
	"HENTAIGANA LETTER SO-6",
	"HENTAIGANA LETTER SO-7",
	"HENTAIGANA LETTER TA-1",
	"HENTAIGANA LETTER TA-2",
	"HENTAIGANA LETTER TA-3",
	"HENTAIGANA LETTER TA-4",
	"HENTAIGANA LETTER TI-1",
	"HENTAIGANA LETTER TI-2",
	"HENTAIGANA LETTER TI-3",
	"HENTAIGANA LETTER TI-4",
	"HENTAIGANA LETTER TI-5",
	"HENTAIGANA LETTER TI-6",
	"HENTAIGANA LETTER TI-7",
	"HENTAIGANA LETTER TU-1",
	"HENTAIGANA LETTER TU-2",
	"HENTAIGANA LETTER TU-3",
	"HENTAIGANA LETTER TU-4",
	"HENTAIGANA LETTER TU-TO",
	"HENTAIGANA LETTER TE-1",
	"HENTAIGANA LETTER TE-2",
	"HENTAIGANA LETTER TE-3",
	"HENTAIGANA LETTER TE-4",
	"HENTAIGANA LETTER TE-5",
	"HENTAIGANA LETTER TE-6",
	"HENTAIGANA LETTER TE-7",
	"HENTAIGANA LETTER TE-8",
	"HENTAIGANA LETTER TE-9",
	"HENTAIGANA LETTER TO-1",
	"HENTAIGANA LETTER TO-2",
	"HENTAIGANA LETTER TO-3",
	"HENTAIGANA LETTER TO-4",
	"HENTAIGANA LETTER TO-5",
	"HENTAIGANA LETTER TO-6",
	"HENTAIGANA LETTER TO-RA",
	"HENTAIGANA LETTER NA-1",
	"HENTAIGANA LETTER NA-2",
	"HENTAIGANA LETTER NA-3",
	"HENTAIGANA LETTER NA-4",
	"HENTAIGANA LETTER NA-5",
	"HENTAIGANA LETTER NA-6",
	"HENTAIGANA LETTER NA-7",
	"HENTAIGANA LETTER NA-8",
	"HENTAIGANA LETTER NA-9",
	"HENTAIGANA LETTER NI-1",
	"HENTAIGANA LETTER NI-2",
	"HENTAIGANA LETTER NI-3",
	"HENTAIGANA LETTER NI-4",
	"HENTAIGANA LETTER NI-5",
	"HENTAIGANA LETTER NI-6",
	"HENTAIGANA LETTER NI-7",
	"HENTAIGANA LETTER NI-TE",
	"HENTAIGANA LETTER NU-1",
	"HENTAIGANA LETTER NU-2",
	"HENTAIGANA LETTER NU-3",
	"HENTAIGANA LETTER NE-1",
	"HENTAIGANA LETTER NE-2",
	"HENTAIGANA LETTER NE-3",
	"HENTAIGANA LETTER NE-4",
	"HENTAIGANA LETTER NE-5",
	"HENTAIGANA LETTER NE-6",
	"HENTAIGANA LETTER NE-KO",
	"HENTAIGANA LETTER NO-1",
	"HENTAIGANA LETTER NO-2",
	"HENTAIGANA LETTER NO-3",
	"HENTAIGANA LETTER NO-4",
	"HENTAIGANA LETTER NO-5",
	"HENTAIGANA LETTER HA-1",
	"HENTAIGANA LETTER HA-2",
	"HENTAIGANA LETTER HA-3",
	"HENTAIGANA LETTER HA-4",
	"HENTAIGANA LETTER HA-5",
	"HENTAIGANA LETTER HA-6",
	"HENTAIGANA LETTER HA-7",
	"HENTAIGANA LETTER HA-8",
	"HENTAIGANA LETTER HA-9",
	"HENTAIGANA LETTER HA-10",
	"HENTAIGANA LETTER HA-11",
	"HENTAIGANA LETTER HI-1",
	"HENTAIGANA LETTER HI-2",
	"HENTAIGANA LETTER HI-3",
	"HENTAIGANA LETTER HI-4",
	"HENTAIGANA LETTER HI-5",
	"HENTAIGANA LETTER HI-6",
	"HENTAIGANA LETTER HI-7",
	"HENTAIGANA LETTER HU-1",
	"HENTAIGANA LETTER HU-2",
	"HENTAIGANA LETTER HU-3",
	"HENTAIGANA LETTER HE-1",
	"HENTAIGANA LETTER HE-2",
	"HENTAIGANA LETTER HE-3",
	"HENTAIGANA LETTER HE-4",
	"HENTAIGANA LETTER HE-5",
	"HENTAIGANA LETTER HE-6",
	"HENTAIGANA LETTER HE-7",
	"HENTAIGANA LETTER HO-1",
	"HENTAIGANA LETTER HO-2",
	"HENTAIGANA LETTER HO-3",
	"HENTAIGANA LETTER HO-4",
	"HENTAIGANA LETTER HO-5",
	"HENTAIGANA LETTER HO-6",
	"HENTAIGANA LETTER HO-7",
	"HENTAIGANA LETTER HO-8",
	"HENTAIGANA LETTER MA-1",
	"HENTAIGANA LETTER MA-2",
	"HENTAIGANA LETTER MA-3",
	"HENTAIGANA LETTER MA-4",
	"HENTAIGANA LETTER MA-5",
	"HENTAIGANA LETTER MA-6",
	"HENTAIGANA LETTER MA-7",
	"HENTAIGANA LETTER MI-1",
	"HENTAIGANA LETTER MI-2",
	"HENTAIGANA LETTER MI-3",
	"HENTAIGANA LETTER MI-4",
	"HENTAIGANA LETTER MI-5",
	"HENTAIGANA LETTER MI-6",
	"HENTAIGANA LETTER MI-7",
	"HENTAIGANA LETTER MU-1",
	"HENTAIGANA LETTER MU-2",
	"HENTAIGANA LETTER MU-3",
	"HENTAIGANA LETTER MU-4",
	"HENTAIGANA LETTER ME-1",
	"HENTAIGANA LETTER ME-2",
	"HENTAIGANA LETTER ME-MA",
	"HENTAIGANA LETTER MO-1",
	"HENTAIGANA LETTER MO-2",
	"HENTAIGANA LETTER MO-3",
	"HENTAIGANA LETTER MO-4",
	"HENTAIGANA LETTER MO-5",
	"HENTAIGANA LETTER MO-6",
	"HENTAIGANA LETTER YA-1",
	"HENTAIGANA LETTER YA-2",
	"HENTAIGANA LETTER YA-3",
	"HENTAIGANA LETTER YA-4",
	"HENTAIGANA LETTER YA-5",
	"HENTAIGANA LETTER YA-YO",
	"HENTAIGANA LETTER YU-1",
	"HENTAIGANA LETTER YU-2",
	"HENTAIGANA LETTER YU-3",
	"HENTAIGANA LETTER YU-4",
	"HENTAIGANA LETTER YO-1",
	"HENTAIGANA LETTER YO-2",
	"HENTAIGANA LETTER YO-3",
	"HENTAIGANA LETTER YO-4",
	"HENTAIGANA LETTER YO-5",
	"HENTAIGANA LETTER YO-6",
	"HENTAIGANA LETTER RA-1",
	"HENTAIGANA LETTER RA-2",
	"HENTAIGANA LETTER RA-3",
	"HENTAIGANA LETTER RA-4",
	"HENTAIGANA LETTER RI-1",
	"HENTAIGANA LETTER RI-2",
	"HENTAIGANA LETTER RI-3",
	"HENTAIGANA LETTER RI-4",
	"HENTAIGANA LETTER RI-5",
	"HENTAIGANA LETTER RI-6",
	"HENTAIGANA LETTER RI-7",
	"HENTAIGANA LETTER RU-1",
	"HENTAIGANA LETTER RU-2",
	"HENTAIGANA LETTER RU-3",
	"HENTAIGANA LETTER RU-4",
	"HENTAIGANA LETTER RU-5",
	"HENTAIGANA LETTER RU-6",
	"HENTAIGANA LETTER RE-1",
	"HENTAIGANA LETTER RE-2",
	"HENTAIGANA LETTER RE-3",
	"HENTAIGANA LETTER RE-4",
	"HENTAIGANA LETTER RO-1",
	"HENTAIGANA LETTER RO-2",
	"HENTAIGANA LETTER RO-3",
	"HENTAIGANA LETTER RO-4",
	"HENTAIGANA LETTER RO-5",
	"HENTAIGANA LETTER RO-6",
	"HENTAIGANA LETTER WA-1",
	"HENTAIGANA LETTER WA-2",
	"HENTAIGANA LETTER WA-3",
	"HENTAIGANA LETTER WA-4",
	"HENTAIGANA LETTER WA-5",
	"HENTAIGANA LETTER WI-1",
	"HENTAIGANA LETTER WI-2",
	"HENTAIGANA LETTER WI-3",
	"HENTAIGANA LETTER WI-4",
	"HENTAIGANA LETTER WI-5",
	"HENTAIGANA LETTER WE-1",
	"HENTAIGANA LETTER WE-2",
	"HENTAIGANA LETTER WE-3",
	"HENTAIGANA LETTER WE-4",
	"HENTAIGANA LETTER WO-1",
	"HENTAIGANA LETTER WO-2",
	"HENTAIGANA LETTER WO-3",
	"HENTAIGANA LETTER WO-4",
	"HENTAIGANA LETTER WO-5",
	"HENTAIGANA LETTER WO-6",
	"HENTAIGANA LETTER WO-7",
	"HENTAIGANA LETTER N-MU-MO-1",
	"HENTAIGANA LETTER N-MU-MO-2",
	"HIRAGANA LETTER ARCHAIC WU",
	"KATAKANA LETTER ARCHAIC YI",
	"KATAKANA LETTER ARCHAIC YE",
	"KATAKANA LETTER ARCHAIC WU",
	"HIRAGANA LETTER SMALL KO",
	"HIRAGANA LETTER SMALL WI",
	"HIRAGANA LETTER SMALL WE",
	"HIRAGANA LETTER SMALL WO",
	"KATAKANA LETTER SMALL KO",
	"KATAKANA LETTER SMALL WI",
	"KATAKANA LETTER SMALL WE",
	"KATAKANA LETTER SMALL WO",
	"KATAKANA LETTER SMALL N",
	"NUSHU CHARACTER-1B170",
	"NUSHU CHARACTER-1B171",
	"NUSHU CHARACTER-1B172",
	"NUSHU CHARACTER-1B173",
	"NUSHU CHARACTER-1B174",
	"NUSHU CHARACTER-1B175",
	"NUSHU CHARACTER-1B176",
	"NUSHU CHARACTER-1B177",
	"NUSHU CHARACTER-1B178",
	"NUSHU CHARACTER-1B179",
	"NUSHU CHARACTER-1B17A",
	"NUSHU CHARACTER-1B17B",
	"NUSHU CHARACTER-1B17C",
	"NUSHU CHARACTER-1B17D",
	"NUSHU CHARACTER-1B17E",
	"NUSHU CHARACTER-1B17F",
	"NUSHU CHARACTER-1B180",
	"NUSHU CHARACTER-1B181",
	"NUSHU CHARACTER-1B182",
	"NUSHU CHARACTER-1B183",
	"NUSHU CHARACTER-1B184",
	"NUSHU CHARACTER-1B185",
	"NUSHU CHARACTER-1B186",
	"NUSHU CHARACTER-1B187",
	"NUSHU CHARACTER-1B188",
	"NUSHU CHARACTER-1B189",
	"NUSHU CHARACTER-1B18A",
	"NUSHU CHARACTER-1B18B",
	"NUSHU CHARACTER-1B18C",
	"NUSHU CHARACTER-1B18D",
	"NUSHU CHARACTER-1B18E",
	"NUSHU CHARACTER-1B18F",
	"NUSHU CHARACTER-1B190",
	"NUSHU CHARACTER-1B191",
	"NUSHU CHARACTER-1B192",
	"NUSHU CHARACTER-1B193",
	"NUSHU CHARACTER-1B194",
	"NUSHU CHARACTER-1B195",
	"NUSHU CHARACTER-1B196",
	"NUSHU CHARACTER-1B197",
	"NUSHU CHARACTER-1B198",
	"NUSHU CHARACTER-1B199",
	"NUSHU CHARACTER-1B19A",
	"NUSHU CHARACTER-1B19B",
	"NUSHU CHARACTER-1B19C",
	"NUSHU CHARACTER-1B19D",
	"NUSHU CHARACTER-1B19E",
	"NUSHU CHARACTER-1B19F",
	"NUSHU CHARACTER-1B1A0",
	"NUSHU CHARACTER-1B1A1",
	"NUSHU CHARACTER-1B1A2",
	"NUSHU CHARACTER-1B1A3",
	"NUSHU CHARACTER-1B1A4",
	"NUSHU CHARACTER-1B1A5",
	"NUSHU CHARACTER-1B1A6",
	"NUSHU CHARACTER-1B1A7",
	"NUSHU CHARACTER-1B1A8",
	"NUSHU CHARACTER-1B1A9",
	"NUSHU CHARACTER-1B1AA",
	"NUSHU CHARACTER-1B1AB",
	"NUSHU CHARACTER-1B1AC",
	"NUSHU CHARACTER-1B1AD",
	"NUSHU CHARACTER-1B1AE",
	"NUSHU CHARACTER-1B1AF",
	"NUSHU CHARACTER-1B1B0",
	"NUSHU CHARACTER-1B1B1",
	"NUSHU CHARACTER-1B1B2",
	"NUSHU CHARACTER-1B1B3",
	"NUSHU CHARACTER-1B1B4",
	"NUSHU CHARACTER-1B1B5",
	"NUSHU CHARACTER-1B1B6",
	"NUSHU CHARACTER-1B1B7",
	"NUSHU CHARACTER-1B1B8",
	"NUSHU CHARACTER-1B1B9",
	"NUSHU CHARACTER-1B1BA",
	"NUSHU CHARACTER-1B1BB",
	"NUSHU CHARACTER-1B1BC",
	"NUSHU CHARACTER-1B1BD",
	"NUSHU CHARACTER-1B1BE",
	"NUSHU CHARACTER-1B1BF",
	"NUSHU CHARACTER-1B1C0",
	"NUSHU CHARACTER-1B1C1",
	"NUSHU CHARACTER-1B1C2",
	"NUSHU CHARACTER-1B1C3",
	"NUSHU CHARACTER-1B1C4",
	"NUSHU CHARACTER-1B1C5",
	"NUSHU CHARACTER-1B1C6",
	"NUSHU CHARACTER-1B1C7",
	"NUSHU CHARACTER-1B1C8",
	"NUSHU CHARACTER-1B1C9",
	"NUSHU CHARACTER-1B1CA",
	"NUSHU CHARACTER-1B1CB",
	"NUSHU CHARACTER-1B1CC",
	"NUSHU CHARACTER-1B1CD",
	"NUSHU CHARACTER-1B1CE",
	"NUSHU CHARACTER-1B1CF",
	"NUSHU CHARACTER-1B1D0",
	"NUSHU CHARACTER-1B1D1",
	"NUSHU CHARACTER-1B1D2",
	"NUSHU CHARACTER-1B1D3",
	"NUSHU CHARACTER-1B1D4",
	"NUSHU CHARACTER-1B1D5",
	"NUSHU CHARACTER-1B1D6",
	"NUSHU CHARACTER-1B1D7",
	"NUSHU CHARACTER-1B1D8",
	"NUSHU CHARACTER-1B1D9",
	"NUSHU CHARACTER-1B1DA",
	"NUSHU CHARACTER-1B1DB",
	"NUSHU CHARACTER-1B1DC",
	"NUSHU CHARACTER-1B1DD",
	"NUSHU CHARACTER-1B1DE",
	"NUSHU CHARACTER-1B1DF",
	"NUSHU CHARACTER-1B1E0",
	"NUSHU CHARACTER-1B1E1",
	"NUSHU CHARACTER-1B1E2",
	"NUSHU CHARACTER-1B1E3",
	"NUSHU CHARACTER-1B1E4",
	"NUSHU CHARACTER-1B1E5",
	"NUSHU CHARACTER-1B1E6",
	"NUSHU CHARACTER-1B1E7",
	"NUSHU CHARACTER-1B1E8",
	"NUSHU CHARACTER-1B1E9",
	"NUSHU CHARACTER-1B1EA",
	"NUSHU CHARACTER-1B1EB",
	"NUSHU CHARACTER-1B1EC",
	"NUSHU CHARACTER-1B1ED",
	"NUSHU CHARACTER-1B1EE",
	"NUSHU CHARACTER-1B1EF",
	"NUSHU CHARACTER-1B1F0",
	"NUSHU CHARACTER-1B1F1",
	"NUSHU CHARACTER-1B1F2",
	"NUSHU CHARACTER-1B1F3",
	"NUSHU CHARACTER-1B1F4",
	"NUSHU CHARACTER-1B1F5",
	"NUSHU CHARACTER-1B1F6",
	"NUSHU CHARACTER-1B1F7",
	"NUSHU CHARACTER-1B1F8",
	"NUSHU CHARACTER-1B1F9",
	"NUSHU CHARACTER-1B1FA",
	"NUSHU CHARACTER-1B1FB",
	"NUSHU CHARACTER-1B1FC",
	"NUSHU CHARACTER-1B1FD",
	"NUSHU CHARACTER-1B1FE",
	"NUSHU CHARACTER-1B1FF",
	"NUSHU CHARACTER-1B200",
	"NUSHU CHARACTER-1B201",
	"NUSHU CHARACTER-1B202",
	"NUSHU CHARACTER-1B203",
	"NUSHU CHARACTER-1B204",
	"NUSHU CHARACTER-1B205",
	"NUSHU CHARACTER-1B206",
	"NUSHU CHARACTER-1B207",
	"NUSHU CHARACTER-1B208",
	"NUSHU CHARACTER-1B209",
	"NUSHU CHARACTER-1B20A",
	"NUSHU CHARACTER-1B20B",
	"NUSHU CHARACTER-1B20C",
	"NUSHU CHARACTER-1B20D",
	"NUSHU CHARACTER-1B20E",
	"NUSHU CHARACTER-1B20F",
	"NUSHU CHARACTER-1B210",
	"NUSHU CHARACTER-1B211",
	"NUSHU CHARACTER-1B212",
	"NUSHU CHARACTER-1B213",
	"NUSHU CHARACTER-1B214",
	"NUSHU CHARACTER-1B215",
	"NUSHU CHARACTER-1B216",
	"NUSHU CHARACTER-1B217",
	"NUSHU CHARACTER-1B218",
	"NUSHU CHARACTER-1B219",
	"NUSHU CHARACTER-1B21A",
	"NUSHU CHARACTER-1B21B",
	"NUSHU CHARACTER-1B21C",
	"NUSHU CHARACTER-1B21D",
	"NUSHU CHARACTER-1B21E",
	"NUSHU CHARACTER-1B21F",
	"NUSHU CHARACTER-1B220",
	"NUSHU CHARACTER-1B221",
	"NUSHU CHARACTER-1B222",
	"NUSHU CHARACTER-1B223",
	"NUSHU CHARACTER-1B224",
	"NUSHU CHARACTER-1B225",
	"NUSHU CHARACTER-1B226",
	"NUSHU CHARACTER-1B227",
	"NUSHU CHARACTER-1B228",
	"NUSHU CHARACTER-1B229",
	"NUSHU CHARACTER-1B22A",
	"NUSHU CHARACTER-1B22B",
	"NUSHU CHARACTER-1B22C",
	"NUSHU CHARACTER-1B22D",
	"NUSHU CHARACTER-1B22E",
	"NUSHU CHARACTER-1B22F",
	"NUSHU CHARACTER-1B230",
	"NUSHU CHARACTER-1B231",
	"NUSHU CHARACTER-1B232",
	"NUSHU CHARACTER-1B233",
	"NUSHU CHARACTER-1B234",
	"NUSHU CHARACTER-1B235",
	"NUSHU CHARACTER-1B236",
	"NUSHU CHARACTER-1B237",
	"NUSHU CHARACTER-1B238",
	"NUSHU CHARACTER-1B239",
	"NUSHU CHARACTER-1B23A",
	"NUSHU CHARACTER-1B23B",
	"NUSHU CHARACTER-1B23C",
	"NUSHU CHARACTER-1B23D",
	"NUSHU CHARACTER-1B23E",
	"NUSHU CHARACTER-1B23F",
	"NUSHU CHARACTER-1B240",
	"NUSHU CHARACTER-1B241",
	"NUSHU CHARACTER-1B242",
	"NUSHU CHARACTER-1B243",
	"NUSHU CHARACTER-1B244",
	"NUSHU CHARACTER-1B245",
	"NUSHU CHARACTER-1B246",
	"NUSHU CHARACTER-1B247",
	"NUSHU CHARACTER-1B248",
	"NUSHU CHARACTER-1B249",
	"NUSHU CHARACTER-1B24A",
	"NUSHU CHARACTER-1B24B",
	"NUSHU CHARACTER-1B24C",
	"NUSHU CHARACTER-1B24D",
	"NUSHU CHARACTER-1B24E",
	"NUSHU CHARACTER-1B24F",
	"NUSHU CHARACTER-1B250",
	"NUSHU CHARACTER-1B251",
	"NUSHU CHARACTER-1B252",
	"NUSHU CHARACTER-1B253",
	"NUSHU CHARACTER-1B254",
	"NUSHU CHARACTER-1B255",
	"NUSHU CHARACTER-1B256",
	"NUSHU CHARACTER-1B257",
	"NUSHU CHARACTER-1B258",
	"NUSHU CHARACTER-1B259",
	"NUSHU CHARACTER-1B25A",
	"NUSHU CHARACTER-1B25B",
	"NUSHU CHARACTER-1B25C",
	"NUSHU CHARACTER-1B25D",
	"NUSHU CHARACTER-1B25E",
	"NUSHU CHARACTER-1B25F",
	"NUSHU CHARACTER-1B260",
	"NUSHU CHARACTER-1B261",
	"NUSHU CHARACTER-1B262",
	"NUSHU CHARACTER-1B263",
	"NUSHU CHARACTER-1B264",
	"NUSHU CHARACTER-1B265",
	"NUSHU CHARACTER-1B266",
	"NUSHU CHARACTER-1B267",
	"NUSHU CHARACTER-1B268",
	"NUSHU CHARACTER-1B269",
	"NUSHU CHARACTER-1B26A",
	"NUSHU CHARACTER-1B26B",
	"NUSHU CHARACTER-1B26C",
	"NUSHU CHARACTER-1B26D",
	"NUSHU CHARACTER-1B26E",
	"NUSHU CHARACTER-1B26F",
	"NUSHU CHARACTER-1B270",
	"NUSHU CHARACTER-1B271",
	"NUSHU CHARACTER-1B272",
	"NUSHU CHARACTER-1B273",
	"NUSHU CHARACTER-1B274",
	"NUSHU CHARACTER-1B275",
	"NUSHU CHARACTER-1B276",
	"NUSHU CHARACTER-1B277",
	"NUSHU CHARACTER-1B278",
	"NUSHU CHARACTER-1B279",
	"NUSHU CHARACTER-1B27A",
	"NUSHU CHARACTER-1B27B",
	"NUSHU CHARACTER-1B27C",
	"NUSHU CHARACTER-1B27D",
	"NUSHU CHARACTER-1B27E",
	"NUSHU CHARACTER-1B27F",
	"NUSHU CHARACTER-1B280",
	"NUSHU CHARACTER-1B281",
	"NUSHU CHARACTER-1B282",
	"NUSHU CHARACTER-1B283",
	"NUSHU CHARACTER-1B284",
	"NUSHU CHARACTER-1B285",
	"NUSHU CHARACTER-1B286",
	"NUSHU CHARACTER-1B287",
	"NUSHU CHARACTER-1B288",
	"NUSHU CHARACTER-1B289",
	"NUSHU CHARACTER-1B28A",
	"NUSHU CHARACTER-1B28B",
	"NUSHU CHARACTER-1B28C",
	"NUSHU CHARACTER-1B28D",
	"NUSHU CHARACTER-1B28E",
	"NUSHU CHARACTER-1B28F",
	"NUSHU CHARACTER-1B290",
	"NUSHU CHARACTER-1B291",
	"NUSHU CHARACTER-1B292",
	"NUSHU CHARACTER-1B293",
	"NUSHU CHARACTER-1B294",
	"NUSHU CHARACTER-1B295",
	"NUSHU CHARACTER-1B296",
	"NUSHU CHARACTER-1B297",
	"NUSHU CHARACTER-1B298",
	"NUSHU CHARACTER-1B299",
	"NUSHU CHARACTER-1B29A",
	"NUSHU CHARACTER-1B29B",
	"NUSHU CHARACTER-1B29C",
	"NUSHU CHARACTER-1B29D",
	"NUSHU CHARACTER-1B29E",
	"NUSHU CHARACTER-1B29F",
	"NUSHU CHARACTER-1B2A0",
	"NUSHU CHARACTER-1B2A1",
	"NUSHU CHARACTER-1B2A2",
	"NUSHU CHARACTER-1B2A3",
	"NUSHU CHARACTER-1B2A4",
	"NUSHU CHARACTER-1B2A5",
	"NUSHU CHARACTER-1B2A6",
	"NUSHU CHARACTER-1B2A7",
	"NUSHU CHARACTER-1B2A8",
	"NUSHU CHARACTER-1B2A9",
	"NUSHU CHARACTER-1B2AA",
	"NUSHU CHARACTER-1B2AB",
	"NUSHU CHARACTER-1B2AC",
	"NUSHU CHARACTER-1B2AD",
	"NUSHU CHARACTER-1B2AE",
	"NUSHU CHARACTER-1B2AF",
	"NUSHU CHARACTER-1B2B0",
	"NUSHU CHARACTER-1B2B1",
	"NUSHU CHARACTER-1B2B2",
	"NUSHU CHARACTER-1B2B3",
	"NUSHU CHARACTER-1B2B4",
	"NUSHU CHARACTER-1B2B5",
	"NUSHU CHARACTER-1B2B6",
	"NUSHU CHARACTER-1B2B7",
	"NUSHU CHARACTER-1B2B8",
	"NUSHU CHARACTER-1B2B9",
	"NUSHU CHARACTER-1B2BA",
	"NUSHU CHARACTER-1B2BB",
	"NUSHU CHARACTER-1B2BC",
	"NUSHU CHARACTER-1B2BD",
	"NUSHU CHARACTER-1B2BE",
	"NUSHU CHARACTER-1B2BF",
	"NUSHU CHARACTER-1B2C0",
	"NUSHU CHARACTER-1B2C1",
	"NUSHU CHARACTER-1B2C2",
	"NUSHU CHARACTER-1B2C3",
	"NUSHU CHARACTER-1B2C4",
	"NUSHU CHARACTER-1B2C5",
	"NUSHU CHARACTER-1B2C6",
	"NUSHU CHARACTER-1B2C7",
	"NUSHU CHARACTER-1B2C8",
	"NUSHU CHARACTER-1B2C9",
	"NUSHU CHARACTER-1B2CA",
	"NUSHU CHARACTER-1B2CB",
	"NUSHU CHARACTER-1B2CC",
	"NUSHU CHARACTER-1B2CD",
	"NUSHU CHARACTER-1B2CE",
	"NUSHU CHARACTER-1B2CF",
	"NUSHU CHARACTER-1B2D0",
	"NUSHU CHARACTER-1B2D1",
	"NUSHU CHARACTER-1B2D2",
	"NUSHU CHARACTER-1B2D3",
	"NUSHU CHARACTER-1B2D4",
	"NUSHU CHARACTER-1B2D5",
	"NUSHU CHARACTER-1B2D6",
	"NUSHU CHARACTER-1B2D7",
	"NUSHU CHARACTER-1B2D8",
	"NUSHU CHARACTER-1B2D9",
	"NUSHU CHARACTER-1B2DA",
	"NUSHU CHARACTER-1B2DB",
	"NUSHU CHARACTER-1B2DC",
	"NUSHU CHARACTER-1B2DD",
	"NUSHU CHARACTER-1B2DE",
	"NUSHU CHARACTER-1B2DF",
	"NUSHU CHARACTER-1B2E0",
	"NUSHU CHARACTER-1B2E1",
	"NUSHU CHARACTER-1B2E2",
	"NUSHU CHARACTER-1B2E3",
	"NUSHU CHARACTER-1B2E4",
	"NUSHU CHARACTER-1B2E5",
	"NUSHU CHARACTER-1B2E6",
	"NUSHU CHARACTER-1B2E7",
	"NUSHU CHARACTER-1B2E8",
	"NUSHU CHARACTER-1B2E9",
	"NUSHU CHARACTER-1B2EA",
	"NUSHU CHARACTER-1B2EB",
	"NUSHU CHARACTER-1B2EC",
	"NUSHU CHARACTER-1B2ED",
	"NUSHU CHARACTER-1B2EE",
	"NUSHU CHARACTER-1B2EF",
	"NUSHU CHARACTER-1B2F0",
	"NUSHU CHARACTER-1B2F1",
	"NUSHU CHARACTER-1B2F2",
	"NUSHU CHARACTER-1B2F3",
	"NUSHU CHARACTER-1B2F4",
	"NUSHU CHARACTER-1B2F5",
	"NUSHU CHARACTER-1B2F6",
	"NUSHU CHARACTER-1B2F7",
	"NUSHU CHARACTER-1B2F8",
	"NUSHU CHARACTER-1B2F9",
	"NUSHU CHARACTER-1B2FA",
	"NUSHU CHARACTER-1B2FB",
	"DUPLOYAN LETTER H",
	"DUPLOYAN LETTER X",
	"DUPLOYAN LETTER P",
	"DUPLOYAN LETTER T",
	"DUPLOYAN LETTER F",
	"DUPLOYAN LETTER K",
	"DUPLOYAN LETTER L",
	"DUPLOYAN LETTER B",
	"DUPLOYAN LETTER D",
	"DUPLOYAN LETTER V",
	"DUPLOYAN LETTER G",
	"DUPLOYAN LETTER R",
	"DUPLOYAN LETTER P N",
	"DUPLOYAN LETTER D S",
	"DUPLOYAN LETTER F N",
	"DUPLOYAN LETTER K M",
	"DUPLOYAN LETTER R S",
	"DUPLOYAN LETTER TH",
	"DUPLOYAN LETTER SLOAN DH",
	"DUPLOYAN LETTER DH",
	"DUPLOYAN LETTER KK",
	"DUPLOYAN LETTER SLOAN J",
	"DUPLOYAN LETTER HL",
	"DUPLOYAN LETTER LH",
	"DUPLOYAN LETTER RH",
	"DUPLOYAN LETTER M",
	"DUPLOYAN LETTER N",
	"DUPLOYAN LETTER J",
	"DUPLOYAN LETTER S",
	"DUPLOYAN LETTER M N",
	"DUPLOYAN LETTER N M",
	"DUPLOYAN LETTER J M",
	"DUPLOYAN LETTER S J",
	"DUPLOYAN LETTER M WITH DOT",
	"DUPLOYAN LETTER N WITH DOT",
	"DUPLOYAN LETTER J WITH DOT",
	"DUPLOYAN LETTER J WITH DOTS INSIDE AND ABOVE",
	"DUPLOYAN LETTER S WITH DOT",
	"DUPLOYAN LETTER S WITH DOT BELOW",
	"DUPLOYAN LETTER M S",
	"DUPLOYAN LETTER N S",
	"DUPLOYAN LETTER J S",
	"DUPLOYAN LETTER S S",
	"DUPLOYAN LETTER M N S",
	"DUPLOYAN LETTER N M S",
	"DUPLOYAN LETTER J M S",
	"DUPLOYAN LETTER S J S",
	"DUPLOYAN LETTER J S WITH DOT",
	"DUPLOYAN LETTER J N",
	"DUPLOYAN LETTER J N S",
	"DUPLOYAN LETTER S T",
	"DUPLOYAN LETTER S T R",
	"DUPLOYAN LETTER S P",
	"DUPLOYAN LETTER S P R",
	"DUPLOYAN LETTER T S",
	"DUPLOYAN LETTER T R S",
	"DUPLOYAN LETTER W",
	"DUPLOYAN LETTER WH",
	"DUPLOYAN LETTER W R",
	"DUPLOYAN LETTER S N",
	"DUPLOYAN LETTER S M",
	"DUPLOYAN LETTER K R S",
	"DUPLOYAN LETTER G R S",
	"DUPLOYAN LETTER S K",
	"DUPLOYAN LETTER S K R",
	"DUPLOYAN LETTER A",
	"DUPLOYAN LETTER SLOAN OW",
	"DUPLOYAN LETTER OA",
	"DUPLOYAN LETTER O",
	"DUPLOYAN LETTER AOU",
	"DUPLOYAN LETTER I",
	"DUPLOYAN LETTER E",
	"DUPLOYAN LETTER IE",
	"DUPLOYAN LETTER SHORT I",
	"DUPLOYAN LETTER UI",
	"DUPLOYAN LETTER EE",
	"DUPLOYAN LETTER SLOAN EH",
	"DUPLOYAN LETTER ROMANIAN I",
	"DUPLOYAN LETTER SLOAN EE",
	"DUPLOYAN LETTER LONG I",
	"DUPLOYAN LETTER YE",
	"DUPLOYAN LETTER U",
	"DUPLOYAN LETTER EU",
	"DUPLOYAN LETTER XW",
	"DUPLOYAN LETTER U N",
	"DUPLOYAN LETTER LONG U",
	"DUPLOYAN LETTER ROMANIAN U",
	"DUPLOYAN LETTER UH",
	"DUPLOYAN LETTER SLOAN U",
	"DUPLOYAN LETTER OOH",
	"DUPLOYAN LETTER OW",
	"DUPLOYAN LETTER OU",
	"DUPLOYAN LETTER WA",
	"DUPLOYAN LETTER WO",
	"DUPLOYAN LETTER WI",
	"DUPLOYAN LETTER WEI",
	"DUPLOYAN LETTER WOW",
	"DUPLOYAN LETTER NASAL U",
	"DUPLOYAN LETTER NASAL O",
	"DUPLOYAN LETTER NASAL I",
	"DUPLOYAN LETTER NASAL A",
	"DUPLOYAN LETTER PERNIN AN",
	"DUPLOYAN LETTER PERNIN AM",
	"DUPLOYAN LETTER SLOAN EN",
	"DUPLOYAN LETTER SLOAN AN",
	"DUPLOYAN LETTER SLOAN ON",
	"DUPLOYAN LETTER VOCALIC M",
	"DUPLOYAN AFFIX LEFT HORIZONTAL SECANT",
	"DUPLOYAN AFFIX MID HORIZONTAL SECANT",
	"DUPLOYAN AFFIX RIGHT HORIZONTAL SECANT",
	"DUPLOYAN AFFIX LOW VERTICAL SECANT",
	"DUPLOYAN AFFIX MID VERTICAL SECANT",
	"DUPLOYAN AFFIX HIGH VERTICAL SECANT",
	"DUPLOYAN AFFIX ATTACHED SECANT",
	"DUPLOYAN AFFIX ATTACHED LEFT-TO-RIGHT SECANT",
	"DUPLOYAN AFFIX ATTACHED TANGENT",
	"DUPLOYAN AFFIX ATTACHED TAIL",
	"DUPLOYAN AFFIX ATTACHED E HOOK",
	"DUPLOYAN AFFIX ATTACHED I HOOK",
	"DUPLOYAN AFFIX ATTACHED TANGENT HOOK",
	"DUPLOYAN AFFIX HIGH ACUTE",
	"DUPLOYAN AFFIX HIGH TIGHT ACUTE",
	"DUPLOYAN AFFIX HIGH GRAVE",
	"DUPLOYAN AFFIX HIGH LONG GRAVE",
	"DUPLOYAN AFFIX HIGH DOT",
	"DUPLOYAN AFFIX HIGH CIRCLE",
	"DUPLOYAN AFFIX HIGH LINE",
	"DUPLOYAN AFFIX HIGH WAVE",
	"DUPLOYAN AFFIX HIGH VERTICAL",
	"DUPLOYAN AFFIX LOW ACUTE",
	"DUPLOYAN AFFIX LOW TIGHT ACUTE",
	"DUPLOYAN AFFIX LOW GRAVE",
	"DUPLOYAN AFFIX LOW LONG GRAVE",
	"DUPLOYAN AFFIX LOW DOT",
	"DUPLOYAN AFFIX LOW CIRCLE",
	"DUPLOYAN AFFIX LOW LINE",
	"DUPLOYAN AFFIX LOW WAVE",
	"DUPLOYAN AFFIX LOW VERTICAL",
	"DUPLOYAN AFFIX LOW ARROW",
	"DUPLOYAN SIGN O WITH CROSS",
	"DUPLOYAN THICK LETTER SELECTOR",
	"DUPLOYAN DOUBLE MARK",
	"DUPLOYAN PUNCTUATION CHINOOK FULL STOP",
	"SHORTHAND FORMAT LETTER OVERLAP",
	"SHORTHAND FORMAT CONTINUING OVERLAP",
	"SHORTHAND FORMAT DOWN STEP",
	"SHORTHAND FORMAT UP STEP",
	"ZNAMENNY COMBINING MARK GORAZDO NIZKO S KRYZHEM ON LEFT",
	"ZNAMENNY COMBINING MARK NIZKO S KRYZHEM ON LEFT",
	"ZNAMENNY COMBINING MARK TSATA ON LEFT",
	"ZNAMENNY COMBINING MARK GORAZDO NIZKO ON LEFT",
	"ZNAMENNY COMBINING MARK NIZKO ON LEFT",
	"ZNAMENNY COMBINING MARK SREDNE ON LEFT",
	"ZNAMENNY COMBINING MARK MALO POVYSHE ON LEFT",
	"ZNAMENNY COMBINING MARK POVYSHE ON LEFT",
	"ZNAMENNY COMBINING MARK VYSOKO ON LEFT",
	"ZNAMENNY COMBINING MARK MALO POVYSHE S KHOKHLOM ON LEFT",
	"ZNAMENNY COMBINING MARK POVYSHE S KHOKHLOM ON LEFT",
	"ZNAMENNY COMBINING MARK VYSOKO S KHOKHLOM ON LEFT",
	"ZNAMENNY COMBINING MARK GORAZDO NIZKO S KRYZHEM ON RIGHT",
	"ZNAMENNY COMBINING MARK NIZKO S KRYZHEM ON RIGHT",
	"ZNAMENNY COMBINING MARK TSATA ON RIGHT",
	"ZNAMENNY COMBINING MARK GORAZDO NIZKO ON RIGHT",
	"ZNAMENNY COMBINING MARK NIZKO ON RIGHT",
	"ZNAMENNY COMBINING MARK SREDNE ON RIGHT",
	"ZNAMENNY COMBINING MARK MALO POVYSHE ON RIGHT",
	"ZNAMENNY COMBINING MARK POVYSHE ON RIGHT",
	"ZNAMENNY COMBINING MARK VYSOKO ON RIGHT",
	"ZNAMENNY COMBINING MARK MALO POVYSHE S KHOKHLOM ON RIGHT",
	"ZNAMENNY COMBINING MARK POVYSHE S KHOKHLOM ON RIGHT",
	"ZNAMENNY COMBINING MARK VYSOKO S KHOKHLOM ON RIGHT",
	"ZNAMENNY COMBINING MARK TSATA S KRYZHEM",
	"ZNAMENNY COMBINING MARK MALO POVYSHE S KRYZHEM",
	"ZNAMENNY COMBINING MARK STRANNO MALO POVYSHE",
	"ZNAMENNY COMBINING MARK POVYSHE S KRYZHEM",
	"ZNAMENNY COMBINING MARK POVYSHE STRANNO",
	"ZNAMENNY COMBINING MARK VYSOKO S KRYZHEM",
	"ZNAMENNY COMBINING MARK MALO POVYSHE STRANNO",
	"ZNAMENNY COMBINING MARK GORAZDO VYSOKO",
	"ZNAMENNY COMBINING MARK ZELO",
	"ZNAMENNY COMBINING MARK ON",
	"ZNAMENNY COMBINING MARK RAVNO",
	"ZNAMENNY COMBINING MARK TIKHAYA",
	"ZNAMENNY COMBINING MARK BORZAYA",
	"ZNAMENNY COMBINING MARK UDARKA",
	"ZNAMENNY COMBINING MARK PODVERTKA",
	"ZNAMENNY COMBINING MARK LOMKA",
	"ZNAMENNY COMBINING MARK KUPNAYA",
	"ZNAMENNY COMBINING MARK KACHKA",
	"ZNAMENNY COMBINING MARK ZEVOK",
	"ZNAMENNY COMBINING MARK SKOBA",
	"ZNAMENNY COMBINING MARK RAZSEKA",
	"ZNAMENNY COMBINING MARK KRYZH ON LEFT",
	"ZNAMENNY COMBINING TONAL RANGE MARK MRACHNO",
	"ZNAMENNY COMBINING TONAL RANGE MARK SVETLO",
	"ZNAMENNY COMBINING TONAL RANGE MARK TRESVETLO",
	"ZNAMENNY COMBINING MARK ZADERZHKA",
	"ZNAMENNY COMBINING MARK DEMESTVENNY ZADERZHKA",
	"ZNAMENNY COMBINING MARK OTSECHKA",
	"ZNAMENNY COMBINING MARK PODCHASHIE",
	"ZNAMENNY COMBINING MARK PODCHASHIE WITH VERTICAL STROKE",
	"ZNAMENNY COMBINING MARK CHASHKA",
	"ZNAMENNY COMBINING MARK CHASHKA POLNAYA",
	"ZNAMENNY COMBINING MARK OBLACHKO",
	"ZNAMENNY COMBINING MARK SOROCHYA NOZHKA",
	"ZNAMENNY COMBINING MARK TOCHKA",
	"ZNAMENNY COMBINING MARK DVOETOCHIE",
	"ZNAMENNY COMBINING ATTACHING VERTICAL OMET",
	"ZNAMENNY COMBINING MARK CURVED OMET",
	"ZNAMENNY COMBINING MARK KRYZH",
	"ZNAMENNY COMBINING LOWER TONAL RANGE INDICATOR",
	"ZNAMENNY PRIZNAK MODIFIER LEVEL-2",
	"ZNAMENNY PRIZNAK MODIFIER LEVEL-3",
	"ZNAMENNY PRIZNAK MODIFIER DIRECTION FLIP",
	"ZNAMENNY PRIZNAK MODIFIER KRYZH",
	"ZNAMENNY PRIZNAK MODIFIER ROG",
	"ZNAMENNY NEUME KRYUK",
	"ZNAMENNY NEUME KRYUK TIKHY",
	"ZNAMENNY NEUME PARAKLIT",
	"ZNAMENNY NEUME DVA V CHELNU",
	"ZNAMENNY NEUME KLYUCH",
	"ZNAMENNY NEUME ZANOZHEK",
	"ZNAMENNY NEUME STOPITSA",
	"ZNAMENNY NEUME STOPITSA S OCHKOM",
	"ZNAMENNY NEUME PEREVODKA",
	"ZNAMENNY NEUME PEREVODKA NEPOSTOYANNAYA",
	"ZNAMENNY NEUME STOPITSA WITH SOROCHYA NOZHKA",
	"ZNAMENNY NEUME CHELYUSTKA",
	"ZNAMENNY NEUME PALKA",
	"ZNAMENNY NEUME ZAPYATAYA",
	"ZNAMENNY NEUME GOLUBCHIK BORZY",
	"ZNAMENNY NEUME GOLUBCHIK TIKHY",
	"ZNAMENNY NEUME GOLUBCHIK MRACHNY",
	"ZNAMENNY NEUME GOLUBCHIK SVETLY",
	"ZNAMENNY NEUME GOLUBCHIK TRESVETLY",
	"ZNAMENNY NEUME VRAKHIYA PROSTAYA",
	"ZNAMENNY NEUME VRAKHIYA MRACHNAYA",
	"ZNAMENNY NEUME VRAKHIYA SVETLAYA",
	"ZNAMENNY NEUME VRAKHIYA TRESVETLAYA",
	"ZNAMENNY NEUME VRAKHIYA KLYUCHEVAYA PROSTAYA",
	"ZNAMENNY NEUME VRAKHIYA KLYUCHEVAYA MRACHNAYA",
	"ZNAMENNY NEUME VRAKHIYA KLYUCHEVAYA SVETLAYA",
	"ZNAMENNY NEUME VRAKHIYA KLYUCHEVAYA TRESVETLAYA",
	"ZNAMENNY NEUME DOUBLE ZAPYATAYA",
	"ZNAMENNY NEUME REVERSED CHELYUSTKA",
	"ZNAMENNY NEUME DERBITSA",
	"ZNAMENNY NEUME KHAMILO",
	"ZNAMENNY NEUME CHASHKA",
	"ZNAMENNY NEUME PODCHASHIE",
	"ZNAMENNY NEUME SKAMEYTSA MRACHNAYA",
	"ZNAMENNY NEUME SKAMEYTSA SVETLAYA",
	"ZNAMENNY NEUME SKAMEYTSA TRESVETLAYA",
	"ZNAMENNY NEUME SKAMEYTSA TIKHAYA",
	"ZNAMENNY NEUME DEMESTVENNY KLYUCH",
	"ZNAMENNY NEUME SKAMEYTSA KLYUCHEVAYA SVETLAYA",
	"ZNAMENNY NEUME SKAMEYTSA KLYUCHENEPOSTOYANNAYA",
	"ZNAMENNY NEUME SKAMEYTSA KLYUCHEVAYA TIKHAYA",
	"ZNAMENNY NEUME SKAMEYTSA DVOECHELNAYA PROSTAYA",
	"ZNAMENNY NEUME SKAMEYTSA DVOECHELNAYA SVETLAYA",
	"ZNAMENNY NEUME SKAMEYTSA DVOECHELNAYA NEPOSTOYANNAYA",
	"ZNAMENNY NEUME SKAMEYTSA DVOECHELNAYA KLYUCHEVAYA",
	"ZNAMENNY NEUME SLOZHITIE",
	"ZNAMENNY NEUME SLOZHITIE S ZAPYATOY",
	"ZNAMENNY NEUME SLOZHITIE ZAKRYTOE",
	"ZNAMENNY NEUME SLOZHITIE S KRYZHEM",
	"ZNAMENNY NEUME KRYZH",
	"ZNAMENNY NEUME ROG",
	"ZNAMENNY NEUME FITA",
	"ZNAMENNY NEUME KOBYLA",
	"ZNAMENNY NEUME ZMEYTSA",
	"ZNAMENNY NEUME STATYA",
	"ZNAMENNY NEUME STATYA S ZAPYATOY",
	"ZNAMENNY NEUME STATYA S KRYZHEM",
	"ZNAMENNY NEUME STATYA S ZAPYATOY I KRYZHEM",
	"ZNAMENNY NEUME STATYA S KRYZHEM I ZAPYATOY",
	"ZNAMENNY NEUME STATYA ZAKRYTAYA",
	"ZNAMENNY NEUME STATYA ZAKRYTAYA S ZAPYATOY",
	"ZNAMENNY NEUME STATYA S ROGOM",
	"ZNAMENNY NEUME STATYA S DVUMYA ZAPYATYMI",
	"ZNAMENNY NEUME STATYA S ZAPYATOY I PODCHASHIEM",
	"ZNAMENNY NEUME POLKULIZMY",
	"ZNAMENNY NEUME STATYA NEPOSTOYANNAYA",
	"ZNAMENNY NEUME STRELA PROSTAYA",
	"ZNAMENNY NEUME STRELA MRACHNOTIKHAYA",
	"ZNAMENNY NEUME STRELA KRYZHEVAYA",
	"ZNAMENNY NEUME STRELA POLUPOVODNAYA",
	"ZNAMENNY NEUME STRELA POVODNAYA",
	"ZNAMENNY NEUME STRELA NEPOSTOYANNAYA",
	"ZNAMENNY NEUME STRELA KLYUCHEPOVODNAYA",
	"ZNAMENNY NEUME STRELA KLYUCHENEPOSTOYANNAYA",
	"ZNAMENNY NEUME STRELA TIKHAYA PUTNAYA",
	"ZNAMENNY NEUME STRELA DVOECHELNAYA",
	"ZNAMENNY NEUME STRELA DVOECHELNOKRYZHEVAYA",
	"ZNAMENNY NEUME STRELA DVOECHELNOPOVODNAYA",
	"ZNAMENNY NEUME STRELA DVOECHELNAYA KLYUCHEVAYA",
	"ZNAMENNY NEUME STRELA DVOECHELNOPOVODNAYA KLYUCHEVAYA",
	"ZNAMENNY NEUME STRELA GROMNAYA WITH SINGLE ZAPYATAYA",
	"ZNAMENNY NEUME STRELA GROMOPOVODNAYA WITH SINGLE ZAPYATAYA",
	"ZNAMENNY NEUME STRELA GROMNAYA",
	"ZNAMENNY NEUME STRELA GROMOPOVODNAYA",
	"ZNAMENNY NEUME STRELA GROMOPOVODNAYA WITH DOUBLE ZAPYATAYA",
	"ZNAMENNY NEUME STRELA GROMOKRYZHEVAYA",
	"ZNAMENNY NEUME STRELA GROMOKRYZHEVAYA POVODNAYA",
	"ZNAMENNY NEUME MECHIK",
	"ZNAMENNY NEUME MECHIK POVODNY",
	"ZNAMENNY NEUME MECHIK KLYUCHEVOY",
	"ZNAMENNY NEUME MECHIK KLYUCHEPOVODNY",
	"ZNAMENNY NEUME MECHIK KLYUCHENEPOSTOYANNY",
	"ZNAMENNY NEUME STRELA TRYASOGLASNAYA",
	"ZNAMENNY NEUME STRELA TRYASOPOVODNAYA",
	"ZNAMENNY NEUME STRELA TRYASOSTRELNAYA",
	"ZNAMENNY NEUME OSOKA",
	"ZNAMENNY NEUME OSOKA SVETLAYA",
	"ZNAMENNY NEUME OSOKA TRESVETLAYA",
	"ZNAMENNY NEUME OSOKA KRYUKOVAYA SVETLAYA",
	"ZNAMENNY NEUME OSOKA KLYUCHEVAYA SVETLAYA",
	"ZNAMENNY NEUME OSOKA KLYUCHEVAYA NEPOSTOYANNAYA",
	"ZNAMENNY NEUME STRELA KRYUKOVAYA",
	"ZNAMENNY NEUME STRELA KRYUKOVAYA POVODNAYA",
	"ZNAMENNY NEUME STRELA KRYUKOVAYA GROMNAYA WITH SINGLE ZAPYATAYA",
	"ZNAMENNY NEUME STRELA KRYUKOVAYA GROMOPOVODNAYA WITH SINGLE ZAPYATAYA",
	"ZNAMENNY NEUME STRELA KRYUKOVAYA GROMNAYA",
	"ZNAMENNY NEUME STRELA KRYUKOVAYA GROMOPOVODNAYA",
	"ZNAMENNY NEUME STRELA KRYUKOVAYA GROMOPOVODNAYA WITH DOUBLE ZAPYATAYA",
	"ZNAMENNY NEUME STRELA KRYUKOVAYA GROMOKRYZHEVAYA",
	"ZNAMENNY NEUME STRELA KRYUKOVAYA GROMOKRYZHEVAYA POVODNAYA",
	"ZNAMENNY NEUME STRELA KRYUKOVAYA TRYASKA",
	"ZNAMENNY NEUME KUFISMA",
	"ZNAMENNY NEUME OBLAKO",
	"ZNAMENNY NEUME DUDA",
	"ZNAMENNY NEUME NEMKA",
	"ZNAMENNY NEUME PAUK",
	"BYZANTINE MUSICAL SYMBOL PSILI",
	"BYZANTINE MUSICAL SYMBOL DASEIA",
	"BYZANTINE MUSICAL SYMBOL PERISPOMENI",
	"BYZANTINE MUSICAL SYMBOL OXEIA EKFONITIKON",
	"BYZANTINE MUSICAL SYMBOL OXEIA DIPLI",
	"BYZANTINE MUSICAL SYMBOL VAREIA EKFONITIKON",
	"BYZANTINE MUSICAL SYMBOL VAREIA DIPLI",
	"BYZANTINE MUSICAL SYMBOL KATHISTI",
	"BYZANTINE MUSICAL SYMBOL SYRMATIKI",
	"BYZANTINE MUSICAL SYMBOL PARAKLITIKI",
	"BYZANTINE MUSICAL SYMBOL YPOKRISIS",
	"BYZANTINE MUSICAL SYMBOL YPOKRISIS DIPLI",
	"BYZANTINE MUSICAL SYMBOL KREMASTI",
	"BYZANTINE MUSICAL SYMBOL APESO EKFONITIKON",
	"BYZANTINE MUSICAL SYMBOL EXO EKFONITIKON",
	"BYZANTINE MUSICAL SYMBOL TELEIA",
	"BYZANTINE MUSICAL SYMBOL KENTIMATA",
	"BYZANTINE MUSICAL SYMBOL APOSTROFOS",
	"BYZANTINE MUSICAL SYMBOL APOSTROFOS DIPLI",
	"BYZANTINE MUSICAL SYMBOL SYNEVMA",
	"BYZANTINE MUSICAL SYMBOL THITA",
	"BYZANTINE MUSICAL SYMBOL OLIGON ARCHAION",
	"BYZANTINE MUSICAL SYMBOL GORGON ARCHAION",
	"BYZANTINE MUSICAL SYMBOL PSILON",
	"BYZANTINE MUSICAL SYMBOL CHAMILON",
	"BYZANTINE MUSICAL SYMBOL VATHY",
	"BYZANTINE MUSICAL SYMBOL ISON ARCHAION",
	"BYZANTINE MUSICAL SYMBOL KENTIMA ARCHAION",
	"BYZANTINE MUSICAL SYMBOL KENTIMATA ARCHAION",
	"BYZANTINE MUSICAL SYMBOL SAXIMATA",
	"BYZANTINE MUSICAL SYMBOL PARICHON",
	"BYZANTINE MUSICAL SYMBOL STAVROS APODEXIA",
	"BYZANTINE MUSICAL SYMBOL OXEIAI ARCHAION",
	"BYZANTINE MUSICAL SYMBOL VAREIAI ARCHAION",
	"BYZANTINE MUSICAL SYMBOL APODERMA ARCHAION",
	"BYZANTINE MUSICAL SYMBOL APOTHEMA",
	"BYZANTINE MUSICAL SYMBOL KLASMA",
	"BYZANTINE MUSICAL SYMBOL REVMA",
	"BYZANTINE MUSICAL SYMBOL PIASMA ARCHAION",
	"BYZANTINE MUSICAL SYMBOL TINAGMA",
	"BYZANTINE MUSICAL SYMBOL ANATRICHISMA",
	"BYZANTINE MUSICAL SYMBOL SEISMA",
	"BYZANTINE MUSICAL SYMBOL SYNAGMA ARCHAION",
	"BYZANTINE MUSICAL SYMBOL SYNAGMA META STAVROU",
	"BYZANTINE MUSICAL SYMBOL OYRANISMA ARCHAION",
	"BYZANTINE MUSICAL SYMBOL THEMA",
	"BYZANTINE MUSICAL SYMBOL LEMOI",
	"BYZANTINE MUSICAL SYMBOL DYO",
	"BYZANTINE MUSICAL SYMBOL TRIA",
	"BYZANTINE MUSICAL SYMBOL TESSERA",
	"BYZANTINE MUSICAL SYMBOL KRATIMATA",
	"BYZANTINE MUSICAL SYMBOL APESO EXO NEO",
	"BYZANTINE MUSICAL SYMBOL FTHORA ARCHAION",
	"BYZANTINE MUSICAL SYMBOL IMIFTHORA",
	"BYZANTINE MUSICAL SYMBOL TROMIKON ARCHAION",
	"BYZANTINE MUSICAL SYMBOL KATAVA TROMIKON",
	"BYZANTINE MUSICAL SYMBOL PELASTON",
	"BYZANTINE MUSICAL SYMBOL PSIFISTON",
	"BYZANTINE MUSICAL SYMBOL KONTEVMA",
	"BYZANTINE MUSICAL SYMBOL CHOREVMA ARCHAION",
	"BYZANTINE MUSICAL SYMBOL RAPISMA",
	"BYZANTINE MUSICAL SYMBOL PARAKALESMA ARCHAION",
	"BYZANTINE MUSICAL SYMBOL PARAKLITIKI ARCHAION",
	"BYZANTINE MUSICAL SYMBOL ICHADIN",
	"BYZANTINE MUSICAL SYMBOL NANA",
	"BYZANTINE MUSICAL SYMBOL PETASMA",
	"BYZANTINE MUSICAL SYMBOL KONTEVMA ALLO",
	"BYZANTINE MUSICAL SYMBOL TROMIKON ALLO",
	"BYZANTINE MUSICAL SYMBOL STRAGGISMATA",
	"BYZANTINE MUSICAL SYMBOL GRONTHISMATA",
	"BYZANTINE MUSICAL SYMBOL ISON NEO",
	"BYZANTINE MUSICAL SYMBOL OLIGON NEO",
	"BYZANTINE MUSICAL SYMBOL OXEIA NEO",
	"BYZANTINE MUSICAL SYMBOL PETASTI",
	"BYZANTINE MUSICAL SYMBOL KOUFISMA",
	"BYZANTINE MUSICAL SYMBOL PETASTOKOUFISMA",
	"BYZANTINE MUSICAL SYMBOL KRATIMOKOUFISMA",
	"BYZANTINE MUSICAL SYMBOL PELASTON NEO",
	"BYZANTINE MUSICAL SYMBOL KENTIMATA NEO ANO",
	"BYZANTINE MUSICAL SYMBOL KENTIMA NEO ANO",
	"BYZANTINE MUSICAL SYMBOL YPSILI",
	"BYZANTINE MUSICAL SYMBOL APOSTROFOS NEO",
	"BYZANTINE MUSICAL SYMBOL APOSTROFOI SYNDESMOS NEO",
	"BYZANTINE MUSICAL SYMBOL YPORROI",
	"BYZANTINE MUSICAL SYMBOL KRATIMOYPORROON",
	"BYZANTINE MUSICAL SYMBOL ELAFRON",
	"BYZANTINE MUSICAL SYMBOL CHAMILI",
	"BYZANTINE MUSICAL SYMBOL MIKRON ISON",
	"BYZANTINE MUSICAL SYMBOL VAREIA NEO",
	"BYZANTINE MUSICAL SYMBOL PIASMA NEO",
	"BYZANTINE MUSICAL SYMBOL PSIFISTON NEO",
	"BYZANTINE MUSICAL SYMBOL OMALON",
	"BYZANTINE MUSICAL SYMBOL ANTIKENOMA",
	"BYZANTINE MUSICAL SYMBOL LYGISMA",
	"BYZANTINE MUSICAL SYMBOL PARAKLITIKI NEO",
	"BYZANTINE MUSICAL SYMBOL PARAKALESMA NEO",
	"BYZANTINE MUSICAL SYMBOL ETERON PARAKALESMA",
	"BYZANTINE MUSICAL SYMBOL KYLISMA",
	"BYZANTINE MUSICAL SYMBOL ANTIKENOKYLISMA",
	"BYZANTINE MUSICAL SYMBOL TROMIKON NEO",
	"BYZANTINE MUSICAL SYMBOL EKSTREPTON",
	"BYZANTINE MUSICAL SYMBOL SYNAGMA NEO",
	"BYZANTINE MUSICAL SYMBOL SYRMA",
	"BYZANTINE MUSICAL SYMBOL CHOREVMA NEO",
	"BYZANTINE MUSICAL SYMBOL EPEGERMA",
	"BYZANTINE MUSICAL SYMBOL SEISMA NEO",
	"BYZANTINE MUSICAL SYMBOL XIRON KLASMA",
	"BYZANTINE MUSICAL SYMBOL TROMIKOPSIFISTON",
	"BYZANTINE MUSICAL SYMBOL PSIFISTOLYGISMA",
	"BYZANTINE MUSICAL SYMBOL TROMIKOLYGISMA",
	"BYZANTINE MUSICAL SYMBOL TROMIKOPARAKALESMA",
	"BYZANTINE MUSICAL SYMBOL PSIFISTOPARAKALESMA",
	"BYZANTINE MUSICAL SYMBOL TROMIKOSYNAGMA",
	"BYZANTINE MUSICAL SYMBOL PSIFISTOSYNAGMA",
	"BYZANTINE MUSICAL SYMBOL GORGOSYNTHETON",
	"BYZANTINE MUSICAL SYMBOL ARGOSYNTHETON",
	"BYZANTINE MUSICAL SYMBOL ETERON ARGOSYNTHETON",
	"BYZANTINE MUSICAL SYMBOL OYRANISMA NEO",
	"BYZANTINE MUSICAL SYMBOL THEMATISMOS ESO",
	"BYZANTINE MUSICAL SYMBOL THEMATISMOS EXO",
	"BYZANTINE MUSICAL SYMBOL THEMA APLOUN",
	"BYZANTINE MUSICAL SYMBOL THES KAI APOTHES",
	"BYZANTINE MUSICAL SYMBOL KATAVASMA",
	"BYZANTINE MUSICAL SYMBOL ENDOFONON",
	"BYZANTINE MUSICAL SYMBOL YFEN KATO",
	"BYZANTINE MUSICAL SYMBOL YFEN ANO",
	"BYZANTINE MUSICAL SYMBOL STAVROS",
	"BYZANTINE MUSICAL SYMBOL KLASMA ANO",
	"BYZANTINE MUSICAL SYMBOL DIPLI ARCHAION",
	"BYZANTINE MUSICAL SYMBOL KRATIMA ARCHAION",
	"BYZANTINE MUSICAL SYMBOL KRATIMA ALLO",
	"BYZANTINE MUSICAL SYMBOL KRATIMA NEO",
	"BYZANTINE MUSICAL SYMBOL APODERMA NEO",
	"BYZANTINE MUSICAL SYMBOL APLI",
	"BYZANTINE MUSICAL SYMBOL DIPLI",
	"BYZANTINE MUSICAL SYMBOL TRIPLI",
	"BYZANTINE MUSICAL SYMBOL TETRAPLI",
	"BYZANTINE MUSICAL SYMBOL KORONIS",
	"BYZANTINE MUSICAL SYMBOL LEIMMA ENOS CHRONOU",
	"BYZANTINE MUSICAL SYMBOL LEIMMA DYO CHRONON",
	"BYZANTINE MUSICAL SYMBOL LEIMMA TRION CHRONON",
	"BYZANTINE MUSICAL SYMBOL LEIMMA TESSARON CHRONON",
	"BYZANTINE MUSICAL SYMBOL LEIMMA IMISEOS CHRONOU",
	"BYZANTINE MUSICAL SYMBOL GORGON NEO ANO",
	"BYZANTINE MUSICAL SYMBOL GORGON PARESTIGMENON ARISTERA",
	"BYZANTINE MUSICAL SYMBOL GORGON PARESTIGMENON DEXIA",
	"BYZANTINE MUSICAL SYMBOL DIGORGON",
	"BYZANTINE MUSICAL SYMBOL DIGORGON PARESTIGMENON ARISTERA KATO",
	"BYZANTINE MUSICAL SYMBOL DIGORGON PARESTIGMENON ARISTERA ANO",
	"BYZANTINE MUSICAL SYMBOL DIGORGON PARESTIGMENON DEXIA",
	"BYZANTINE MUSICAL SYMBOL TRIGORGON",
	"BYZANTINE MUSICAL SYMBOL ARGON",
	"BYZANTINE MUSICAL SYMBOL IMIDIARGON",
	"BYZANTINE MUSICAL SYMBOL DIARGON",
	"BYZANTINE MUSICAL SYMBOL AGOGI POLI ARGI",
	"BYZANTINE MUSICAL SYMBOL AGOGI ARGOTERI",
	"BYZANTINE MUSICAL SYMBOL AGOGI ARGI",
	"BYZANTINE MUSICAL SYMBOL AGOGI METRIA",
	"BYZANTINE MUSICAL SYMBOL AGOGI MESI",
	"BYZANTINE MUSICAL SYMBOL AGOGI GORGI",
	"BYZANTINE MUSICAL SYMBOL AGOGI GORGOTERI",
	"BYZANTINE MUSICAL SYMBOL AGOGI POLI GORGI",
	"BYZANTINE MUSICAL SYMBOL MARTYRIA PROTOS ICHOS",
	"BYZANTINE MUSICAL SYMBOL MARTYRIA ALLI PROTOS ICHOS",
	"BYZANTINE MUSICAL SYMBOL MARTYRIA DEYTEROS ICHOS",
	"BYZANTINE MUSICAL SYMBOL MARTYRIA ALLI DEYTEROS ICHOS",
	"BYZANTINE MUSICAL SYMBOL MARTYRIA TRITOS ICHOS",
	"BYZANTINE MUSICAL SYMBOL MARTYRIA TRIFONIAS",
	"BYZANTINE MUSICAL SYMBOL MARTYRIA TETARTOS ICHOS",
	"BYZANTINE MUSICAL SYMBOL MARTYRIA TETARTOS LEGETOS ICHOS",
	"BYZANTINE MUSICAL SYMBOL MARTYRIA LEGETOS ICHOS",
	"BYZANTINE MUSICAL SYMBOL MARTYRIA PLAGIOS ICHOS",
	"BYZANTINE MUSICAL SYMBOL ISAKIA TELOUS ICHIMATOS",
	"BYZANTINE MUSICAL SYMBOL APOSTROFOI TELOUS ICHIMATOS",
	"BYZANTINE MUSICAL SYMBOL FANEROSIS TETRAFONIAS",
	"BYZANTINE MUSICAL SYMBOL FANEROSIS MONOFONIAS",
	"BYZANTINE MUSICAL SYMBOL FANEROSIS DIFONIAS",
	"BYZANTINE MUSICAL SYMBOL MARTYRIA VARYS ICHOS",
	"BYZANTINE MUSICAL SYMBOL MARTYRIA PROTOVARYS ICHOS",
	"BYZANTINE MUSICAL SYMBOL MARTYRIA PLAGIOS TETARTOS ICHOS",
	"BYZANTINE MUSICAL SYMBOL GORTHMIKON N APLOUN",
	"BYZANTINE MUSICAL SYMBOL GORTHMIKON N DIPLOUN",
	"BYZANTINE MUSICAL SYMBOL ENARXIS KAI FTHORA VOU",
	"BYZANTINE MUSICAL SYMBOL IMIFONON",
	"BYZANTINE MUSICAL SYMBOL IMIFTHORON",
	"BYZANTINE MUSICAL SYMBOL FTHORA ARCHAION DEYTEROU ICHOU",
	"BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI PA",
	"BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI NANA",
	"BYZANTINE MUSICAL SYMBOL FTHORA NAOS ICHOS",
	"BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI DI",
	"BYZANTINE MUSICAL SYMBOL FTHORA SKLIRON DIATONON DI",
	"BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI KE",
	"BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI ZO",
	"BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI NI KATO",
	"BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI NI ANO",
	"BYZANTINE MUSICAL SYMBOL FTHORA MALAKON CHROMA DIFONIAS",
	"BYZANTINE MUSICAL SYMBOL FTHORA MALAKON CHROMA MONOFONIAS",
	"BYZANTINE MUSICAL SYMBOL FHTORA SKLIRON CHROMA VASIS",
	"BYZANTINE MUSICAL SYMBOL FTHORA SKLIRON CHROMA SYNAFI",
	"BYZANTINE MUSICAL SYMBOL FTHORA NENANO",
	"BYZANTINE MUSICAL SYMBOL CHROA ZYGOS",
	"BYZANTINE MUSICAL SYMBOL CHROA KLITON",
	"BYZANTINE MUSICAL SYMBOL CHROA SPATHI",
	"BYZANTINE MUSICAL SYMBOL FTHORA I YFESIS TETARTIMORION",
	"BYZANTINE MUSICAL SYMBOL FTHORA ENARMONIOS ANTIFONIA",
	"BYZANTINE MUSICAL SYMBOL YFESIS TRITIMORION",
	"BYZANTINE MUSICAL SYMBOL DIESIS TRITIMORION",
	"BYZANTINE MUSICAL SYMBOL DIESIS TETARTIMORION",
	"BYZANTINE MUSICAL SYMBOL DIESIS APLI DYO DODEKATA",
	"BYZANTINE MUSICAL SYMBOL DIESIS MONOGRAMMOS TESSERA DODEKATA",
	"BYZANTINE MUSICAL SYMBOL DIESIS DIGRAMMOS EX DODEKATA",
	"BYZANTINE MUSICAL SYMBOL DIESIS TRIGRAMMOS OKTO DODEKATA",
	"BYZANTINE MUSICAL SYMBOL YFESIS APLI DYO DODEKATA",
	"BYZANTINE MUSICAL SYMBOL YFESIS MONOGRAMMOS TESSERA DODEKATA",
	"BYZANTINE MUSICAL SYMBOL YFESIS DIGRAMMOS EX DODEKATA",
	"BYZANTINE MUSICAL SYMBOL YFESIS TRIGRAMMOS OKTO DODEKATA",
	"BYZANTINE MUSICAL SYMBOL GENIKI DIESIS",
	"BYZANTINE MUSICAL SYMBOL GENIKI YFESIS",
	"BYZANTINE MUSICAL SYMBOL DIASTOLI APLI MIKRI",
	"BYZANTINE MUSICAL SYMBOL DIASTOLI APLI MEGALI",
	"BYZANTINE MUSICAL SYMBOL DIASTOLI DIPLI",
	"BYZANTINE MUSICAL SYMBOL DIASTOLI THESEOS",
	"BYZANTINE MUSICAL SYMBOL SIMANSIS THESEOS",
	"BYZANTINE MUSICAL SYMBOL SIMANSIS THESEOS DISIMOU",
	"BYZANTINE MUSICAL SYMBOL SIMANSIS THESEOS TRISIMOU",
	"BYZANTINE MUSICAL SYMBOL SIMANSIS THESEOS TETRASIMOU",
	"BYZANTINE MUSICAL SYMBOL SIMANSIS ARSEOS",
	"BYZANTINE MUSICAL SYMBOL SIMANSIS ARSEOS DISIMOU",
	"BYZANTINE MUSICAL SYMBOL SIMANSIS ARSEOS TRISIMOU",
	"BYZANTINE MUSICAL SYMBOL SIMANSIS ARSEOS TETRASIMOU",
	"BYZANTINE MUSICAL SYMBOL DIGRAMMA GG",
	"BYZANTINE MUSICAL SYMBOL DIFTOGGOS OU",
	"BYZANTINE MUSICAL SYMBOL STIGMA",
	"BYZANTINE MUSICAL SYMBOL ARKTIKO PA",
	"BYZANTINE MUSICAL SYMBOL ARKTIKO VOU",
	"BYZANTINE MUSICAL SYMBOL ARKTIKO GA",
	"BYZANTINE MUSICAL SYMBOL ARKTIKO DI",
	"BYZANTINE MUSICAL SYMBOL ARKTIKO KE",
	"BYZANTINE MUSICAL SYMBOL ARKTIKO ZO",
	"BYZANTINE MUSICAL SYMBOL ARKTIKO NI",
	"BYZANTINE MUSICAL SYMBOL KENTIMATA NEO MESO",
	"BYZANTINE MUSICAL SYMBOL KENTIMA NEO MESO",
	"BYZANTINE MUSICAL SYMBOL KENTIMATA NEO KATO",
	"BYZANTINE MUSICAL SYMBOL KENTIMA NEO KATO",
	"BYZANTINE MUSICAL SYMBOL KLASMA KATO",
	"BYZANTINE MUSICAL SYMBOL GORGON NEO KATO",
	"MUSICAL SYMBOL SINGLE BARLINE",
	"MUSICAL SYMBOL DOUBLE BARLINE",
	"MUSICAL SYMBOL FINAL BARLINE",
	"MUSICAL SYMBOL REVERSE FINAL BARLINE",
	"MUSICAL SYMBOL DASHED BARLINE",
	"MUSICAL SYMBOL SHORT BARLINE",
	"MUSICAL SYMBOL LEFT REPEAT SIGN",
	"MUSICAL SYMBOL RIGHT REPEAT SIGN",
	"MUSICAL SYMBOL REPEAT DOTS",
	"MUSICAL SYMBOL DAL SEGNO",
	"MUSICAL SYMBOL DA CAPO",
	"MUSICAL SYMBOL SEGNO",
	"MUSICAL SYMBOL CODA",
	"MUSICAL SYMBOL REPEATED FIGURE-1",
	"MUSICAL SYMBOL REPEATED FIGURE-2",
	"MUSICAL SYMBOL REPEATED FIGURE-3",
	"MUSICAL SYMBOL FERMATA",
	"MUSICAL SYMBOL FERMATA BELOW",
	"MUSICAL SYMBOL BREATH MARK",
	"MUSICAL SYMBOL CAESURA",
	"MUSICAL SYMBOL BRACE",
	"MUSICAL SYMBOL BRACKET",
	"MUSICAL SYMBOL ONE-LINE STAFF",
	"MUSICAL SYMBOL TWO-LINE STAFF",
	"MUSICAL SYMBOL THREE-LINE STAFF",
	"MUSICAL SYMBOL FOUR-LINE STAFF",
	"MUSICAL SYMBOL FIVE-LINE STAFF",
	"MUSICAL SYMBOL SIX-LINE STAFF",
	"MUSICAL SYMBOL SIX-STRING FRETBOARD",
	"MUSICAL SYMBOL FOUR-STRING FRETBOARD",
	"MUSICAL SYMBOL G CLEF",
	"MUSICAL SYMBOL G CLEF OTTAVA ALTA",
	"MUSICAL SYMBOL G CLEF OTTAVA BASSA",
	"MUSICAL SYMBOL C CLEF",
	"MUSICAL SYMBOL F CLEF",
	"MUSICAL SYMBOL F CLEF OTTAVA ALTA",
	"MUSICAL SYMBOL F CLEF OTTAVA BASSA",
	"MUSICAL SYMBOL DRUM CLEF-1",
	"MUSICAL SYMBOL DRUM CLEF-2",
	"MUSICAL SYMBOL MULTIPLE MEASURE REST",
	"MUSICAL SYMBOL DOUBLE SHARP",
	"MUSICAL SYMBOL DOUBLE FLAT",
	"MUSICAL SYMBOL FLAT UP",
	"MUSICAL SYMBOL FLAT DOWN",
	"MUSICAL SYMBOL NATURAL UP",
	"MUSICAL SYMBOL NATURAL DOWN",
	"MUSICAL SYMBOL SHARP UP",
	"MUSICAL SYMBOL SHARP DOWN",
	"MUSICAL SYMBOL QUARTER TONE SHARP",
	"MUSICAL SYMBOL QUARTER TONE FLAT",
	"MUSICAL SYMBOL COMMON TIME",
	"MUSICAL SYMBOL CUT TIME",
	"MUSICAL SYMBOL OTTAVA ALTA",
	"MUSICAL SYMBOL OTTAVA BASSA",
	"MUSICAL SYMBOL QUINDICESIMA ALTA",
	"MUSICAL SYMBOL QUINDICESIMA BASSA",
	"MUSICAL SYMBOL MULTI REST",
	"MUSICAL SYMBOL WHOLE REST",
	"MUSICAL SYMBOL HALF REST",
	"MUSICAL SYMBOL QUARTER REST",
	"MUSICAL SYMBOL EIGHTH REST",
	"MUSICAL SYMBOL SIXTEENTH REST",
	"MUSICAL SYMBOL THIRTY-SECOND REST",
	"MUSICAL SYMBOL SIXTY-FOURTH REST",
	"MUSICAL SYMBOL ONE HUNDRED TWENTY-EIGHTH REST",
	"MUSICAL SYMBOL X NOTEHEAD",
	"MUSICAL SYMBOL PLUS NOTEHEAD",
	"MUSICAL SYMBOL CIRCLE X NOTEHEAD",
	"MUSICAL SYMBOL SQUARE NOTEHEAD WHITE",
	"MUSICAL SYMBOL SQUARE NOTEHEAD BLACK",
	"MUSICAL SYMBOL TRIANGLE NOTEHEAD UP WHITE",
	"MUSICAL SYMBOL TRIANGLE NOTEHEAD UP BLACK",
	"MUSICAL SYMBOL TRIANGLE NOTEHEAD LEFT WHITE",
	"MUSICAL SYMBOL TRIANGLE NOTEHEAD LEFT BLACK",
	"MUSICAL SYMBOL TRIANGLE NOTEHEAD RIGHT WHITE",
	"MUSICAL SYMBOL TRIANGLE NOTEHEAD RIGHT BLACK",
	"MUSICAL SYMBOL TRIANGLE NOTEHEAD DOWN WHITE",
	"MUSICAL SYMBOL TRIANGLE NOTEHEAD DOWN BLACK",
	"MUSICAL SYMBOL TRIANGLE NOTEHEAD UP RIGHT WHITE",
	"MUSICAL SYMBOL TRIANGLE NOTEHEAD UP RIGHT BLACK",
	"MUSICAL SYMBOL MOON NOTEHEAD WHITE",
	"MUSICAL SYMBOL MOON NOTEHEAD BLACK",
	"MUSICAL SYMBOL TRIANGLE-ROUND NOTEHEAD DOWN WHITE",
	"MUSICAL SYMBOL TRIANGLE-ROUND NOTEHEAD DOWN BLACK",
	"MUSICAL SYMBOL PARENTHESIS NOTEHEAD",
	"MUSICAL SYMBOL VOID NOTEHEAD",
	"MUSICAL SYMBOL NOTEHEAD BLACK",
	"MUSICAL SYMBOL NULL NOTEHEAD",
	"MUSICAL SYMBOL CLUSTER NOTEHEAD WHITE",
	"MUSICAL SYMBOL CLUSTER NOTEHEAD BLACK",
	"MUSICAL SYMBOL BREVE",
	"MUSICAL SYMBOL WHOLE NOTE",
	"MUSICAL SYMBOL HALF NOTE",
	"MUSICAL SYMBOL QUARTER NOTE",
	"MUSICAL SYMBOL EIGHTH NOTE",
	"MUSICAL SYMBOL SIXTEENTH NOTE",
	"MUSICAL SYMBOL THIRTY-SECOND NOTE",
	"MUSICAL SYMBOL SIXTY-FOURTH NOTE",
	"MUSICAL SYMBOL ONE HUNDRED TWENTY-EIGHTH NOTE",
	"MUSICAL SYMBOL COMBINING STEM",
	"MUSICAL SYMBOL COMBINING SPRECHGESANG STEM",
	"MUSICAL SYMBOL COMBINING TREMOLO-1",
	"MUSICAL SYMBOL COMBINING TREMOLO-2",
	"MUSICAL SYMBOL COMBINING TREMOLO-3",
	"MUSICAL SYMBOL FINGERED TREMOLO-1",
	"MUSICAL SYMBOL FINGERED TREMOLO-2",
	"MUSICAL SYMBOL FINGERED TREMOLO-3",
	"MUSICAL SYMBOL COMBINING AUGMENTATION DOT",
	"MUSICAL SYMBOL COMBINING FLAG-1",
	"MUSICAL SYMBOL COMBINING FLAG-2",
	"MUSICAL SYMBOL COMBINING FLAG-3",
	"MUSICAL SYMBOL COMBINING FLAG-4",
	"MUSICAL SYMBOL COMBINING FLAG-5",
	"MUSICAL SYMBOL BEGIN BEAM",
	"MUSICAL SYMBOL END BEAM",
	"MUSICAL SYMBOL BEGIN TIE",
	"MUSICAL SYMBOL END TIE",
	"MUSICAL SYMBOL BEGIN SLUR",
	"MUSICAL SYMBOL END SLUR",
	"MUSICAL SYMBOL BEGIN PHRASE",
	"MUSICAL SYMBOL END PHRASE",
	"MUSICAL SYMBOL COMBINING ACCENT",
	"MUSICAL SYMBOL COMBINING STACCATO",
	"MUSICAL SYMBOL COMBINING TENUTO",
	"MUSICAL SYMBOL COMBINING STACCATISSIMO",
	"MUSICAL SYMBOL COMBINING MARCATO",
	"MUSICAL SYMBOL COMBINING MARCATO-STACCATO",
	"MUSICAL SYMBOL COMBINING ACCENT-STACCATO",
	"MUSICAL SYMBOL COMBINING LOURE",
	"MUSICAL SYMBOL ARPEGGIATO UP",
	"MUSICAL SYMBOL ARPEGGIATO DOWN",
	"MUSICAL SYMBOL COMBINING DOIT",
	"MUSICAL SYMBOL COMBINING RIP",
	"MUSICAL SYMBOL COMBINING FLIP",
	"MUSICAL SYMBOL COMBINING SMEAR",
	"MUSICAL SYMBOL COMBINING BEND",
	"MUSICAL SYMBOL COMBINING DOUBLE TONGUE",
	"MUSICAL SYMBOL COMBINING TRIPLE TONGUE",
	"MUSICAL SYMBOL RINFORZANDO",
	"MUSICAL SYMBOL SUBITO",
	"MUSICAL SYMBOL Z",
	"MUSICAL SYMBOL PIANO",
	"MUSICAL SYMBOL MEZZO",
	"MUSICAL SYMBOL FORTE",
	"MUSICAL SYMBOL CRESCENDO",
	"MUSICAL SYMBOL DECRESCENDO",
	"MUSICAL SYMBOL GRACE NOTE SLASH",
	"MUSICAL SYMBOL GRACE NOTE NO SLASH",
	"MUSICAL SYMBOL TR",
	"MUSICAL SYMBOL TURN",
	"MUSICAL SYMBOL INVERTED TURN",
	"MUSICAL SYMBOL TURN SLASH",
	"MUSICAL SYMBOL TURN UP",
	"MUSICAL SYMBOL ORNAMENT STROKE-1",
	"MUSICAL SYMBOL ORNAMENT STROKE-2",
	"MUSICAL SYMBOL ORNAMENT STROKE-3",
	"MUSICAL SYMBOL ORNAMENT STROKE-4",
	"MUSICAL SYMBOL ORNAMENT STROKE-5",
	"MUSICAL SYMBOL ORNAMENT STROKE-6",
	"MUSICAL SYMBOL ORNAMENT STROKE-7",
	"MUSICAL SYMBOL ORNAMENT STROKE-8",
	"MUSICAL SYMBOL ORNAMENT STROKE-9",
	"MUSICAL SYMBOL ORNAMENT STROKE-10",
	"MUSICAL SYMBOL ORNAMENT STROKE-11",
	"MUSICAL SYMBOL HAUPTSTIMME",
	"MUSICAL SYMBOL NEBENSTIMME",
	"MUSICAL SYMBOL END OF STIMME",
	"MUSICAL SYMBOL DEGREE SLASH",
	"MUSICAL SYMBOL COMBINING DOWN BOW",
	"MUSICAL SYMBOL COMBINING UP BOW",
	"MUSICAL SYMBOL COMBINING HARMONIC",
	"MUSICAL SYMBOL COMBINING SNAP PIZZICATO",
	"MUSICAL SYMBOL PEDAL MARK",
	"MUSICAL SYMBOL PEDAL UP MARK",
	"MUSICAL SYMBOL HALF PEDAL MARK",
	"MUSICAL SYMBOL GLISSANDO UP",
	"MUSICAL SYMBOL GLISSANDO DOWN",
	"MUSICAL SYMBOL WITH FINGERNAILS",
	"MUSICAL SYMBOL DAMP",
	"MUSICAL SYMBOL DAMP ALL",
	"MUSICAL SYMBOL MAXIMA",
	"MUSICAL SYMBOL LONGA",
	"MUSICAL SYMBOL BREVIS",
	"MUSICAL SYMBOL SEMIBREVIS WHITE",
	"MUSICAL SYMBOL SEMIBREVIS BLACK",
	"MUSICAL SYMBOL MINIMA",
	"MUSICAL SYMBOL MINIMA BLACK",
	"MUSICAL SYMBOL SEMIMINIMA WHITE",
	"MUSICAL SYMBOL SEMIMINIMA BLACK",
	"MUSICAL SYMBOL FUSA WHITE",
	"MUSICAL SYMBOL FUSA BLACK",
	"MUSICAL SYMBOL LONGA PERFECTA REST",
	"MUSICAL SYMBOL LONGA IMPERFECTA REST",
	"MUSICAL SYMBOL BREVIS REST",
	"MUSICAL SYMBOL SEMIBREVIS REST",
	"MUSICAL SYMBOL MINIMA REST",
	"MUSICAL SYMBOL SEMIMINIMA REST",
	"MUSICAL SYMBOL TEMPUS PERFECTUM CUM PROLATIONE PERFECTA",
	"MUSICAL SYMBOL TEMPUS PERFECTUM CUM PROLATIONE IMPERFECTA",
	"MUSICAL SYMBOL TEMPUS PERFECTUM CUM PROLATIONE PERFECTA DIMINUTION-1",
	"MUSICAL SYMBOL TEMPUS IMPERFECTUM CUM PROLATIONE PERFECTA",
	"MUSICAL SYMBOL TEMPUS IMPERFECTUM CUM PROLATIONE IMPERFECTA",
	"MUSICAL SYMBOL TEMPUS IMPERFECTUM CUM PROLATIONE IMPERFECTA DIMINUTION-1",
	"MUSICAL SYMBOL TEMPUS IMPERFECTUM CUM PROLATIONE IMPERFECTA DIMINUTION-2",
	"MUSICAL SYMBOL TEMPUS IMPERFECTUM CUM PROLATIONE IMPERFECTA DIMINUTION-3",
	"MUSICAL SYMBOL CROIX",
	"MUSICAL SYMBOL GREGORIAN C CLEF",
	"MUSICAL SYMBOL GREGORIAN F CLEF",
	"MUSICAL SYMBOL SQUARE B",
	"MUSICAL SYMBOL VIRGA",
	"MUSICAL SYMBOL PODATUS",
	"MUSICAL SYMBOL CLIVIS",
	"MUSICAL SYMBOL SCANDICUS",
	"MUSICAL SYMBOL CLIMACUS",
	"MUSICAL SYMBOL TORCULUS",
	"MUSICAL SYMBOL PORRECTUS",
	"MUSICAL SYMBOL PORRECTUS FLEXUS",
	"MUSICAL SYMBOL SCANDICUS FLEXUS",
	"MUSICAL SYMBOL TORCULUS RESUPINUS",
	"MUSICAL SYMBOL PES SUBPUNCTIS",
	"MUSICAL SYMBOL KIEVAN C CLEF",
	"MUSICAL SYMBOL KIEVAN END OF PIECE",
	"MUSICAL SYMBOL KIEVAN FINAL NOTE",
	"MUSICAL SYMBOL KIEVAN RECITATIVE MARK",
	"MUSICAL SYMBOL KIEVAN WHOLE NOTE",
	"MUSICAL SYMBOL KIEVAN HALF NOTE",
	"MUSICAL SYMBOL KIEVAN QUARTER NOTE STEM DOWN",
	"MUSICAL SYMBOL KIEVAN QUARTER NOTE STEM UP",
	"MUSICAL SYMBOL KIEVAN EIGHTH NOTE STEM DOWN",
	"MUSICAL SYMBOL KIEVAN EIGHTH NOTE STEM UP",
	"MUSICAL SYMBOL KIEVAN FLAT SIGN",
	"MUSICAL SYMBOL SORI",
	"MUSICAL SYMBOL KORON",
	"GREEK VOCAL NOTATION SYMBOL-1",
	"GREEK VOCAL NOTATION SYMBOL-2",
	"GREEK VOCAL NOTATION SYMBOL-3",
	"GREEK VOCAL NOTATION SYMBOL-4",
	"GREEK VOCAL NOTATION SYMBOL-5",
	"GREEK VOCAL NOTATION SYMBOL-6",
	"GREEK VOCAL NOTATION SYMBOL-7",
	"GREEK VOCAL NOTATION SYMBOL-8",
	"GREEK VOCAL NOTATION SYMBOL-9",
	"GREEK VOCAL NOTATION SYMBOL-10",
	"GREEK VOCAL NOTATION SYMBOL-11",
	"GREEK VOCAL NOTATION SYMBOL-12",
	"GREEK VOCAL NOTATION SYMBOL-13",
	"GREEK VOCAL NOTATION SYMBOL-14",
	"GREEK VOCAL NOTATION SYMBOL-15",
	"GREEK VOCAL NOTATION SYMBOL-16",
	"GREEK VOCAL NOTATION SYMBOL-17",
	"GREEK VOCAL NOTATION SYMBOL-18",
	"GREEK VOCAL NOTATION SYMBOL-19",
	"GREEK VOCAL NOTATION SYMBOL-20",
	"GREEK VOCAL NOTATION SYMBOL-21",
	"GREEK VOCAL NOTATION SYMBOL-22",
	"GREEK VOCAL NOTATION SYMBOL-23",
	"GREEK VOCAL NOTATION SYMBOL-24",
	"GREEK VOCAL NOTATION SYMBOL-50",
	"GREEK VOCAL NOTATION SYMBOL-51",
	"GREEK VOCAL NOTATION SYMBOL-52",
	"GREEK VOCAL NOTATION SYMBOL-53",
	"GREEK VOCAL NOTATION SYMBOL-54",
	"GREEK INSTRUMENTAL NOTATION SYMBOL-1",
	"GREEK INSTRUMENTAL NOTATION SYMBOL-2",
	"GREEK INSTRUMENTAL NOTATION SYMBOL-4",
	"GREEK INSTRUMENTAL NOTATION SYMBOL-5",
	"GREEK INSTRUMENTAL NOTATION SYMBOL-7",
	"GREEK INSTRUMENTAL NOTATION SYMBOL-8",
	"GREEK INSTRUMENTAL NOTATION SYMBOL-11",
	"GREEK INSTRUMENTAL NOTATION SYMBOL-12",
	"GREEK INSTRUMENTAL NOTATION SYMBOL-13",
	"GREEK INSTRUMENTAL NOTATION SYMBOL-14",
	"GREEK INSTRUMENTAL NOTATION SYMBOL-17",
	"GREEK INSTRUMENTAL NOTATION SYMBOL-18",
	"GREEK INSTRUMENTAL NOTATION SYMBOL-19",
	"GREEK INSTRUMENTAL NOTATION SYMBOL-23",
	"GREEK INSTRUMENTAL NOTATION SYMBOL-24",
	"GREEK INSTRUMENTAL NOTATION SYMBOL-25",
	"GREEK INSTRUMENTAL NOTATION SYMBOL-26",
	"GREEK INSTRUMENTAL NOTATION SYMBOL-27",
	"GREEK INSTRUMENTAL NOTATION SYMBOL-29",
	"GREEK INSTRUMENTAL NOTATION SYMBOL-30",
	"GREEK INSTRUMENTAL NOTATION SYMBOL-32",
	"GREEK INSTRUMENTAL NOTATION SYMBOL-36",
	"GREEK INSTRUMENTAL NOTATION SYMBOL-37",
	"GREEK INSTRUMENTAL NOTATION SYMBOL-38",
	"GREEK INSTRUMENTAL NOTATION SYMBOL-39",
	"GREEK INSTRUMENTAL NOTATION SYMBOL-40",
	"GREEK INSTRUMENTAL NOTATION SYMBOL-42",
	"GREEK INSTRUMENTAL NOTATION SYMBOL-43",
	"GREEK INSTRUMENTAL NOTATION SYMBOL-45",
	"GREEK INSTRUMENTAL NOTATION SYMBOL-47",
	"GREEK INSTRUMENTAL NOTATION SYMBOL-48",
	"GREEK INSTRUMENTAL NOTATION SYMBOL-49",
	"GREEK INSTRUMENTAL NOTATION SYMBOL-50",
	"GREEK INSTRUMENTAL NOTATION SYMBOL-51",
	"GREEK INSTRUMENTAL NOTATION SYMBOL-52",
	"GREEK INSTRUMENTAL NOTATION SYMBOL-53",
	"GREEK INSTRUMENTAL NOTATION SYMBOL-54",
	"COMBINING GREEK MUSICAL TRISEME",
	"COMBINING GREEK MUSICAL TETRASEME",
	"COMBINING GREEK MUSICAL PENTASEME",
	"GREEK MUSICAL LEIMMA",
	"KAKTOVIK NUMERAL ZERO",
	"KAKTOVIK NUMERAL ONE",
	"KAKTOVIK NUMERAL TWO",
	"KAKTOVIK NUMERAL THREE",
	"KAKTOVIK NUMERAL FOUR",
	"KAKTOVIK NUMERAL FIVE",
	"KAKTOVIK NUMERAL SIX",
	"KAKTOVIK NUMERAL SEVEN",
	"KAKTOVIK NUMERAL EIGHT",
	"KAKTOVIK NUMERAL NINE",
	"KAKTOVIK NUMERAL TEN",
	"KAKTOVIK NUMERAL ELEVEN",
	"KAKTOVIK NUMERAL TWELVE",
	"KAKTOVIK NUMERAL THIRTEEN",
	"KAKTOVIK NUMERAL FOURTEEN",
	"KAKTOVIK NUMERAL FIFTEEN",
	"KAKTOVIK NUMERAL SIXTEEN",
	"KAKTOVIK NUMERAL SEVENTEEN",
	"KAKTOVIK NUMERAL EIGHTEEN",
	"KAKTOVIK NUMERAL NINETEEN",
	"MAYAN NUMERAL ZERO",
	"MAYAN NUMERAL ONE",
	"MAYAN NUMERAL TWO",
	"MAYAN NUMERAL THREE",
	"MAYAN NUMERAL FOUR",
	"MAYAN NUMERAL FIVE",
	"MAYAN NUMERAL SIX",
	"MAYAN NUMERAL SEVEN",
	"MAYAN NUMERAL EIGHT",
	"MAYAN NUMERAL NINE",
	"MAYAN NUMERAL TEN",
	"MAYAN NUMERAL ELEVEN",
	"MAYAN NUMERAL TWELVE",
	"MAYAN NUMERAL THIRTEEN",
	"MAYAN NUMERAL FOURTEEN",
	"MAYAN NUMERAL FIFTEEN",
	"MAYAN NUMERAL SIXTEEN",
	"MAYAN NUMERAL SEVENTEEN",
	"MAYAN NUMERAL EIGHTEEN",
	"MAYAN NUMERAL NINETEEN",
	"MONOGRAM FOR EARTH",
	"DIGRAM FOR HEAVENLY EARTH",
	"DIGRAM FOR HUMAN EARTH",
	"DIGRAM FOR EARTHLY HEAVEN",
	"DIGRAM FOR EARTHLY HUMAN",
	"DIGRAM FOR EARTH",
	"TETRAGRAM FOR CENTRE",
	"TETRAGRAM FOR FULL CIRCLE",
	"TETRAGRAM FOR MIRED",
	"TETRAGRAM FOR BARRIER",
	"TETRAGRAM FOR KEEPING SMALL",
	"TETRAGRAM FOR CONTRARIETY",
	"TETRAGRAM FOR ASCENT",
	"TETRAGRAM FOR OPPOSITION",
	"TETRAGRAM FOR BRANCHING OUT",
	"TETRAGRAM FOR DEFECTIVENESS OR DISTORTION",
	"TETRAGRAM FOR DIVERGENCE",
	"TETRAGRAM FOR YOUTHFULNESS",
	"TETRAGRAM FOR INCREASE",
	"TETRAGRAM FOR PENETRATION",
	"TETRAGRAM FOR REACH",
	"TETRAGRAM FOR CONTACT",
	"TETRAGRAM FOR HOLDING BACK",
	"TETRAGRAM FOR WAITING",
	"TETRAGRAM FOR FOLLOWING",
	"TETRAGRAM FOR ADVANCE",
	"TETRAGRAM FOR RELEASE",
	"TETRAGRAM FOR RESISTANCE",
	"TETRAGRAM FOR EASE",
	"TETRAGRAM FOR JOY",
	"TETRAGRAM FOR CONTENTION",
	"TETRAGRAM FOR ENDEAVOUR",
	"TETRAGRAM FOR DUTIES",
	"TETRAGRAM FOR CHANGE",
	"TETRAGRAM FOR DECISIVENESS",
	"TETRAGRAM FOR BOLD RESOLUTION",
	"TETRAGRAM FOR PACKING",
	"TETRAGRAM FOR LEGION",
	"TETRAGRAM FOR CLOSENESS",
	"TETRAGRAM FOR KINSHIP",
	"TETRAGRAM FOR GATHERING",
	"TETRAGRAM FOR STRENGTH",
	"TETRAGRAM FOR PURITY",
	"TETRAGRAM FOR FULLNESS",
	"TETRAGRAM FOR RESIDENCE",
	"TETRAGRAM FOR LAW OR MODEL",
	"TETRAGRAM FOR RESPONSE",
	"TETRAGRAM FOR GOING TO MEET",
	"TETRAGRAM FOR ENCOUNTERS",
	"TETRAGRAM FOR STOVE",
	"TETRAGRAM FOR GREATNESS",
	"TETRAGRAM FOR ENLARGEMENT",
	"TETRAGRAM FOR PATTERN",
	"TETRAGRAM FOR RITUAL",
	"TETRAGRAM FOR FLIGHT",
	"TETRAGRAM FOR VASTNESS OR WASTING",
	"TETRAGRAM FOR CONSTANCY",
	"TETRAGRAM FOR MEASURE",
	"TETRAGRAM FOR ETERNITY",
	"TETRAGRAM FOR UNITY",
	"TETRAGRAM FOR DIMINISHMENT",
	"TETRAGRAM FOR CLOSED MOUTH",
	"TETRAGRAM FOR GUARDEDNESS",
	"TETRAGRAM FOR GATHERING IN",
	"TETRAGRAM FOR MASSING",
	"TETRAGRAM FOR ACCUMULATION",
	"TETRAGRAM FOR EMBELLISHMENT",
	"TETRAGRAM FOR DOUBT",
	"TETRAGRAM FOR WATCH",
	"TETRAGRAM FOR SINKING",
	"TETRAGRAM FOR INNER",
	"TETRAGRAM FOR DEPARTURE",
	"TETRAGRAM FOR DARKENING",
	"TETRAGRAM FOR DIMMING",
	"TETRAGRAM FOR EXHAUSTION",
	"TETRAGRAM FOR SEVERANCE",
	"TETRAGRAM FOR STOPPAGE",
	"TETRAGRAM FOR HARDNESS",
	"TETRAGRAM FOR COMPLETION",
	"TETRAGRAM FOR CLOSURE",
	"TETRAGRAM FOR FAILURE",
	"TETRAGRAM FOR AGGRAVATION",
	"TETRAGRAM FOR COMPLIANCE",
	"TETRAGRAM FOR ON THE VERGE",
	"TETRAGRAM FOR DIFFICULTIES",
	"TETRAGRAM FOR LABOURING",
	"TETRAGRAM FOR FOSTERING",
	"COUNTING ROD UNIT DIGIT ONE",
	"COUNTING ROD UNIT DIGIT TWO",
	"COUNTING ROD UNIT DIGIT THREE",
	"COUNTING ROD UNIT DIGIT FOUR",
	"COUNTING ROD UNIT DIGIT FIVE",
	"COUNTING ROD UNIT DIGIT SIX",
	"COUNTING ROD UNIT DIGIT SEVEN",
	"COUNTING ROD UNIT DIGIT EIGHT",
	"COUNTING ROD UNIT DIGIT NINE",
	"COUNTING ROD TENS DIGIT ONE",
	"COUNTING ROD TENS DIGIT TWO",
	"COUNTING ROD TENS DIGIT THREE",
	"COUNTING ROD TENS DIGIT FOUR",
	"COUNTING ROD TENS DIGIT FIVE",
	"COUNTING ROD TENS DIGIT SIX",
	"COUNTING ROD TENS DIGIT SEVEN",
	"COUNTING ROD TENS DIGIT EIGHT",
	"COUNTING ROD TENS DIGIT NINE",
	"IDEOGRAPHIC TALLY MARK ONE",
	"IDEOGRAPHIC TALLY MARK TWO",
	"IDEOGRAPHIC TALLY MARK THREE",
	"IDEOGRAPHIC TALLY MARK FOUR",
	"IDEOGRAPHIC TALLY MARK FIVE",
	"TALLY MARK ONE",
	"TALLY MARK FIVE",
	"MATHEMATICAL BOLD CAPITAL A",
	"MATHEMATICAL BOLD CAPITAL B",
	"MATHEMATICAL BOLD CAPITAL C",
	"MATHEMATICAL BOLD CAPITAL D",
	"MATHEMATICAL BOLD CAPITAL E",
	"MATHEMATICAL BOLD CAPITAL F",
	"MATHEMATICAL BOLD CAPITAL G",
	"MATHEMATICAL BOLD CAPITAL H",
	"MATHEMATICAL BOLD CAPITAL I",
	"MATHEMATICAL BOLD CAPITAL J",
	"MATHEMATICAL BOLD CAPITAL K",
	"MATHEMATICAL BOLD CAPITAL L",
	"MATHEMATICAL BOLD CAPITAL M",
	"MATHEMATICAL BOLD CAPITAL N",
	"MATHEMATICAL BOLD CAPITAL O",
	"MATHEMATICAL BOLD CAPITAL P",
	"MATHEMATICAL BOLD CAPITAL Q",
	"MATHEMATICAL BOLD CAPITAL R",
	"MATHEMATICAL BOLD CAPITAL S",
	"MATHEMATICAL BOLD CAPITAL T",
	"MATHEMATICAL BOLD CAPITAL U",
	"MATHEMATICAL BOLD CAPITAL V",
	"MATHEMATICAL BOLD CAPITAL W",
	"MATHEMATICAL BOLD CAPITAL X",
	"MATHEMATICAL BOLD CAPITAL Y",
	"MATHEMATICAL BOLD CAPITAL Z",
	"MATHEMATICAL BOLD SMALL A",
	"MATHEMATICAL BOLD SMALL B",
	"MATHEMATICAL BOLD SMALL C",
	"MATHEMATICAL BOLD SMALL D",
	"MATHEMATICAL BOLD SMALL E",
	"MATHEMATICAL BOLD SMALL F",
	"MATHEMATICAL BOLD SMALL G",
	"MATHEMATICAL BOLD SMALL H",
	"MATHEMATICAL BOLD SMALL I",
	"MATHEMATICAL BOLD SMALL J",
	"MATHEMATICAL BOLD SMALL K",
	"MATHEMATICAL BOLD SMALL L",
	"MATHEMATICAL BOLD SMALL M",
	"MATHEMATICAL BOLD SMALL N",
	"MATHEMATICAL BOLD SMALL O",
	"MATHEMATICAL BOLD SMALL P",
	"MATHEMATICAL BOLD SMALL Q",
	"MATHEMATICAL BOLD SMALL R",
	"MATHEMATICAL BOLD SMALL S",
	"MATHEMATICAL BOLD SMALL T",
	"MATHEMATICAL BOLD SMALL U",
	"MATHEMATICAL BOLD SMALL V",
	"MATHEMATICAL BOLD SMALL W",
	"MATHEMATICAL BOLD SMALL X",
	"MATHEMATICAL BOLD SMALL Y",
	"MATHEMATICAL BOLD SMALL Z",
	"MATHEMATICAL ITALIC CAPITAL A",
	"MATHEMATICAL ITALIC CAPITAL B",
	"MATHEMATICAL ITALIC CAPITAL C",
	"MATHEMATICAL ITALIC CAPITAL D",
	"MATHEMATICAL ITALIC CAPITAL E",
	"MATHEMATICAL ITALIC CAPITAL F",
	"MATHEMATICAL ITALIC CAPITAL G",
	"MATHEMATICAL ITALIC CAPITAL H",
	"MATHEMATICAL ITALIC CAPITAL I",
	"MATHEMATICAL ITALIC CAPITAL J",
	"MATHEMATICAL ITALIC CAPITAL K",
	"MATHEMATICAL ITALIC CAPITAL L",
	"MATHEMATICAL ITALIC CAPITAL M",
	"MATHEMATICAL ITALIC CAPITAL N",
	"MATHEMATICAL ITALIC CAPITAL O",
	"MATHEMATICAL ITALIC CAPITAL P",
	"MATHEMATICAL ITALIC CAPITAL Q",
	"MATHEMATICAL ITALIC CAPITAL R",
	"MATHEMATICAL ITALIC CAPITAL S",
	"MATHEMATICAL ITALIC CAPITAL T",
	"MATHEMATICAL ITALIC CAPITAL U",
	"MATHEMATICAL ITALIC CAPITAL V",
	"MATHEMATICAL ITALIC CAPITAL W",
	"MATHEMATICAL ITALIC CAPITAL X",
	"MATHEMATICAL ITALIC CAPITAL Y",
	"MATHEMATICAL ITALIC CAPITAL Z",
	"MATHEMATICAL ITALIC SMALL A",
	"MATHEMATICAL ITALIC SMALL B",
	"MATHEMATICAL ITALIC SMALL C",
	"MATHEMATICAL ITALIC SMALL D",
	"MATHEMATICAL ITALIC SMALL E",
	"MATHEMATICAL ITALIC SMALL F",
	"MATHEMATICAL ITALIC SMALL G",
	"MATHEMATICAL ITALIC SMALL I",
	"MATHEMATICAL ITALIC SMALL J",
	"MATHEMATICAL ITALIC SMALL K",
	"MATHEMATICAL ITALIC SMALL L",
	"MATHEMATICAL ITALIC SMALL M",
	"MATHEMATICAL ITALIC SMALL N",
	"MATHEMATICAL ITALIC SMALL O",
	"MATHEMATICAL ITALIC SMALL P",
	"MATHEMATICAL ITALIC SMALL Q",
	"MATHEMATICAL ITALIC SMALL R",
	"MATHEMATICAL ITALIC SMALL S",
	"MATHEMATICAL ITALIC SMALL T",
	"MATHEMATICAL ITALIC SMALL U",
	"MATHEMATICAL ITALIC SMALL V",
	"MATHEMATICAL ITALIC SMALL W",
	"MATHEMATICAL ITALIC SMALL X",
	"MATHEMATICAL ITALIC SMALL Y",
	"MATHEMATICAL ITALIC SMALL Z",
	"MATHEMATICAL BOLD ITALIC CAPITAL A",
	"MATHEMATICAL BOLD ITALIC CAPITAL B",
	"MATHEMATICAL BOLD ITALIC CAPITAL C",
	"MATHEMATICAL BOLD ITALIC CAPITAL D",
	"MATHEMATICAL BOLD ITALIC CAPITAL E",
	"MATHEMATICAL BOLD ITALIC CAPITAL F",
	"MATHEMATICAL BOLD ITALIC CAPITAL G",
	"MATHEMATICAL BOLD ITALIC CAPITAL H",
	"MATHEMATICAL BOLD ITALIC CAPITAL I",
	"MATHEMATICAL BOLD ITALIC CAPITAL J",
	"MATHEMATICAL BOLD ITALIC CAPITAL K",
	"MATHEMATICAL BOLD ITALIC CAPITAL L",
	"MATHEMATICAL BOLD ITALIC CAPITAL M",
	"MATHEMATICAL BOLD ITALIC CAPITAL N",
	"MATHEMATICAL BOLD ITALIC CAPITAL O",
	"MATHEMATICAL BOLD ITALIC CAPITAL P",
	"MATHEMATICAL BOLD ITALIC CAPITAL Q",
	"MATHEMATICAL BOLD ITALIC CAPITAL R",
	"MATHEMATICAL BOLD ITALIC CAPITAL S",
	"MATHEMATICAL BOLD ITALIC CAPITAL T",
	"MATHEMATICAL BOLD ITALIC CAPITAL U",
	"MATHEMATICAL BOLD ITALIC CAPITAL V",
	"MATHEMATICAL BOLD ITALIC CAPITAL W",
	"MATHEMATICAL BOLD ITALIC CAPITAL X",
	"MATHEMATICAL BOLD ITALIC CAPITAL Y",
	"MATHEMATICAL BOLD ITALIC CAPITAL Z",
	"MATHEMATICAL BOLD ITALIC SMALL A",
	"MATHEMATICAL BOLD ITALIC SMALL B",
	"MATHEMATICAL BOLD ITALIC SMALL C",
	"MATHEMATICAL BOLD ITALIC SMALL D",
	"MATHEMATICAL BOLD ITALIC SMALL E",
	"MATHEMATICAL BOLD ITALIC SMALL F",
	"MATHEMATICAL BOLD ITALIC SMALL G",
	"MATHEMATICAL BOLD ITALIC SMALL H",
	"MATHEMATICAL BOLD ITALIC SMALL I",
	"MATHEMATICAL BOLD ITALIC SMALL J",
	"MATHEMATICAL BOLD ITALIC SMALL K",
	"MATHEMATICAL BOLD ITALIC SMALL L",
	"MATHEMATICAL BOLD ITALIC SMALL M",
	"MATHEMATICAL BOLD ITALIC SMALL N",
	"MATHEMATICAL BOLD ITALIC SMALL O",
	"MATHEMATICAL BOLD ITALIC SMALL P",
	"MATHEMATICAL BOLD ITALIC SMALL Q",
	"MATHEMATICAL BOLD ITALIC SMALL R",
	"MATHEMATICAL BOLD ITALIC SMALL S",
	"MATHEMATICAL BOLD ITALIC SMALL T",
	"MATHEMATICAL BOLD ITALIC SMALL U",
	"MATHEMATICAL BOLD ITALIC SMALL V",
	"MATHEMATICAL BOLD ITALIC SMALL W",
	"MATHEMATICAL BOLD ITALIC SMALL X",
	"MATHEMATICAL BOLD ITALIC SMALL Y",
	"MATHEMATICAL BOLD ITALIC SMALL Z",
	"MATHEMATICAL SCRIPT CAPITAL A",
	"MATHEMATICAL SCRIPT CAPITAL C",
	"MATHEMATICAL SCRIPT CAPITAL D",
	"MATHEMATICAL SCRIPT CAPITAL G",
	"MATHEMATICAL SCRIPT CAPITAL J",
	"MATHEMATICAL SCRIPT CAPITAL K",
	"MATHEMATICAL SCRIPT CAPITAL N",
	"MATHEMATICAL SCRIPT CAPITAL O",
	"MATHEMATICAL SCRIPT CAPITAL P",
	"MATHEMATICAL SCRIPT CAPITAL Q",
	"MATHEMATICAL SCRIPT CAPITAL S",
	"MATHEMATICAL SCRIPT CAPITAL T",
	"MATHEMATICAL SCRIPT CAPITAL U",
	"MATHEMATICAL SCRIPT CAPITAL V",
	"MATHEMATICAL SCRIPT CAPITAL W",
	"MATHEMATICAL SCRIPT CAPITAL X",
	"MATHEMATICAL SCRIPT CAPITAL Y",
	"MATHEMATICAL SCRIPT CAPITAL Z",
	"MATHEMATICAL SCRIPT SMALL A",
	"MATHEMATICAL SCRIPT SMALL B",
	"MATHEMATICAL SCRIPT SMALL C",
	"MATHEMATICAL SCRIPT SMALL D",
	"MATHEMATICAL SCRIPT SMALL F",
	"MATHEMATICAL SCRIPT SMALL H",
	"MATHEMATICAL SCRIPT SMALL I",
	"MATHEMATICAL SCRIPT SMALL J",
	"MATHEMATICAL SCRIPT SMALL K",
	"MATHEMATICAL SCRIPT SMALL L",
	"MATHEMATICAL SCRIPT SMALL M",
	"MATHEMATICAL SCRIPT SMALL N",
	"MATHEMATICAL SCRIPT SMALL P",
	"MATHEMATICAL SCRIPT SMALL Q",
	"MATHEMATICAL SCRIPT SMALL R",
	"MATHEMATICAL SCRIPT SMALL S",
	"MATHEMATICAL SCRIPT SMALL T",
	"MATHEMATICAL SCRIPT SMALL U",
	"MATHEMATICAL SCRIPT SMALL V",
	"MATHEMATICAL SCRIPT SMALL W",
	"MATHEMATICAL SCRIPT SMALL X",
	"MATHEMATICAL SCRIPT SMALL Y",
	"MATHEMATICAL SCRIPT SMALL Z",
	"MATHEMATICAL BOLD SCRIPT CAPITAL A",
	"MATHEMATICAL BOLD SCRIPT CAPITAL B",
	"MATHEMATICAL BOLD SCRIPT CAPITAL C",
	"MATHEMATICAL BOLD SCRIPT CAPITAL D",
	"MATHEMATICAL BOLD SCRIPT CAPITAL E",
	"MATHEMATICAL BOLD SCRIPT CAPITAL F",
	"MATHEMATICAL BOLD SCRIPT CAPITAL G",
	"MATHEMATICAL BOLD SCRIPT CAPITAL H",
	"MATHEMATICAL BOLD SCRIPT CAPITAL I",
	"MATHEMATICAL BOLD SCRIPT CAPITAL J",
	"MATHEMATICAL BOLD SCRIPT CAPITAL K",
	"MATHEMATICAL BOLD SCRIPT CAPITAL L",
	"MATHEMATICAL BOLD SCRIPT CAPITAL M",
	"MATHEMATICAL BOLD SCRIPT CAPITAL N",
	"MATHEMATICAL BOLD SCRIPT CAPITAL O",
	"MATHEMATICAL BOLD SCRIPT CAPITAL P",
	"MATHEMATICAL BOLD SCRIPT CAPITAL Q",
	"MATHEMATICAL BOLD SCRIPT CAPITAL R",
	"MATHEMATICAL BOLD SCRIPT CAPITAL S",
	"MATHEMATICAL BOLD SCRIPT CAPITAL T",
	"MATHEMATICAL BOLD SCRIPT CAPITAL U",
	"MATHEMATICAL BOLD SCRIPT CAPITAL V",
	"MATHEMATICAL BOLD SCRIPT CAPITAL W",
	"MATHEMATICAL BOLD SCRIPT CAPITAL X",
	"MATHEMATICAL BOLD SCRIPT CAPITAL Y",
	"MATHEMATICAL BOLD SCRIPT CAPITAL Z",
	"MATHEMATICAL BOLD SCRIPT SMALL A",
	"MATHEMATICAL BOLD SCRIPT SMALL B",
	"MATHEMATICAL BOLD SCRIPT SMALL C",
	"MATHEMATICAL BOLD SCRIPT SMALL D",
	"MATHEMATICAL BOLD SCRIPT SMALL E",
	"MATHEMATICAL BOLD SCRIPT SMALL F",
	"MATHEMATICAL BOLD SCRIPT SMALL G",
	"MATHEMATICAL BOLD SCRIPT SMALL H",
	"MATHEMATICAL BOLD SCRIPT SMALL I",
	"MATHEMATICAL BOLD SCRIPT SMALL J",
	"MATHEMATICAL BOLD SCRIPT SMALL K",
	"MATHEMATICAL BOLD SCRIPT SMALL L",
	"MATHEMATICAL BOLD SCRIPT SMALL M",
	"MATHEMATICAL BOLD SCRIPT SMALL N",
	"MATHEMATICAL BOLD SCRIPT SMALL O",
	"MATHEMATICAL BOLD SCRIPT SMALL P",
	"MATHEMATICAL BOLD SCRIPT SMALL Q",
	"MATHEMATICAL BOLD SCRIPT SMALL R",
	"MATHEMATICAL BOLD SCRIPT SMALL S",
	"MATHEMATICAL BOLD SCRIPT SMALL T",
	"MATHEMATICAL BOLD SCRIPT SMALL U",
	"MATHEMATICAL BOLD SCRIPT SMALL V",
	"MATHEMATICAL BOLD SCRIPT SMALL W",
	"MATHEMATICAL BOLD SCRIPT SMALL X",
	"MATHEMATICAL BOLD SCRIPT SMALL Y",
	"MATHEMATICAL BOLD SCRIPT SMALL Z",
	"MATHEMATICAL FRAKTUR CAPITAL A",
	"MATHEMATICAL FRAKTUR CAPITAL B",
	"MATHEMATICAL FRAKTUR CAPITAL D",
	"MATHEMATICAL FRAKTUR CAPITAL E",
	"MATHEMATICAL FRAKTUR CAPITAL F",
	"MATHEMATICAL FRAKTUR CAPITAL G",
	"MATHEMATICAL FRAKTUR CAPITAL J",
	"MATHEMATICAL FRAKTUR CAPITAL K",
	"MATHEMATICAL FRAKTUR CAPITAL L",
	"MATHEMATICAL FRAKTUR CAPITAL M",
	"MATHEMATICAL FRAKTUR CAPITAL N",
	"MATHEMATICAL FRAKTUR CAPITAL O",
	"MATHEMATICAL FRAKTUR CAPITAL P",
	"MATHEMATICAL FRAKTUR CAPITAL Q",
	"MATHEMATICAL FRAKTUR CAPITAL S",
	"MATHEMATICAL FRAKTUR CAPITAL T",
	"MATHEMATICAL FRAKTUR CAPITAL U",
	"MATHEMATICAL FRAKTUR CAPITAL V",
	"MATHEMATICAL FRAKTUR CAPITAL W",
	"MATHEMATICAL FRAKTUR CAPITAL X",
	"MATHEMATICAL FRAKTUR CAPITAL Y",
	"MATHEMATICAL FRAKTUR SMALL A",
	"MATHEMATICAL FRAKTUR SMALL B",
	"MATHEMATICAL FRAKTUR SMALL C",
	"MATHEMATICAL FRAKTUR SMALL D",
	"MATHEMATICAL FRAKTUR SMALL E",
	"MATHEMATICAL FRAKTUR SMALL F",
	"MATHEMATICAL FRAKTUR SMALL G",
	"MATHEMATICAL FRAKTUR SMALL H",
	"MATHEMATICAL FRAKTUR SMALL I",
	"MATHEMATICAL FRAKTUR SMALL J",
	"MATHEMATICAL FRAKTUR SMALL K",
	"MATHEMATICAL FRAKTUR SMALL L",
	"MATHEMATICAL FRAKTUR SMALL M",
	"MATHEMATICAL FRAKTUR SMALL N",
	"MATHEMATICAL FRAKTUR SMALL O",
	"MATHEMATICAL FRAKTUR SMALL P",
	"MATHEMATICAL FRAKTUR SMALL Q",
	"MATHEMATICAL FRAKTUR SMALL R",
	"MATHEMATICAL FRAKTUR SMALL S",
	"MATHEMATICAL FRAKTUR SMALL T",
	"MATHEMATICAL FRAKTUR SMALL U",
	"MATHEMATICAL FRAKTUR SMALL V",
	"MATHEMATICAL FRAKTUR SMALL W",
	"MATHEMATICAL FRAKTUR SMALL X",
	"MATHEMATICAL FRAKTUR SMALL Y",
	"MATHEMATICAL FRAKTUR SMALL Z",
	"MATHEMATICAL DOUBLE-STRUCK CAPITAL A",
	"MATHEMATICAL DOUBLE-STRUCK CAPITAL B",
	"MATHEMATICAL DOUBLE-STRUCK CAPITAL D",
	"MATHEMATICAL DOUBLE-STRUCK CAPITAL E",
	"MATHEMATICAL DOUBLE-STRUCK CAPITAL F",
	"MATHEMATICAL DOUBLE-STRUCK CAPITAL G",
	"MATHEMATICAL DOUBLE-STRUCK CAPITAL I",
	"MATHEMATICAL DOUBLE-STRUCK CAPITAL J",
	"MATHEMATICAL DOUBLE-STRUCK CAPITAL K",
	"MATHEMATICAL DOUBLE-STRUCK CAPITAL L",
	"MATHEMATICAL DOUBLE-STRUCK CAPITAL M",
	"MATHEMATICAL DOUBLE-STRUCK CAPITAL O",
	"MATHEMATICAL DOUBLE-STRUCK CAPITAL S",
	"MATHEMATICAL DOUBLE-STRUCK CAPITAL T",
	"MATHEMATICAL DOUBLE-STRUCK CAPITAL U",
	"MATHEMATICAL DOUBLE-STRUCK CAPITAL V",
	"MATHEMATICAL DOUBLE-STRUCK CAPITAL W",
	"MATHEMATICAL DOUBLE-STRUCK CAPITAL X",
	"MATHEMATICAL DOUBLE-STRUCK CAPITAL Y",
	"MATHEMATICAL DOUBLE-STRUCK SMALL A",
	"MATHEMATICAL DOUBLE-STRUCK SMALL B",
	"MATHEMATICAL DOUBLE-STRUCK SMALL C",
	"MATHEMATICAL DOUBLE-STRUCK SMALL D",
	"MATHEMATICAL DOUBLE-STRUCK SMALL E",
	"MATHEMATICAL DOUBLE-STRUCK SMALL F",
	"MATHEMATICAL DOUBLE-STRUCK SMALL G",
	"MATHEMATICAL DOUBLE-STRUCK SMALL H",
	"MATHEMATICAL DOUBLE-STRUCK SMALL I",
	"MATHEMATICAL DOUBLE-STRUCK SMALL J",
	"MATHEMATICAL DOUBLE-STRUCK SMALL K",
	"MATHEMATICAL DOUBLE-STRUCK SMALL L",
	"MATHEMATICAL DOUBLE-STRUCK SMALL M",
	"MATHEMATICAL DOUBLE-STRUCK SMALL N",
	"MATHEMATICAL DOUBLE-STRUCK SMALL O",
	"MATHEMATICAL DOUBLE-STRUCK SMALL P",
	"MATHEMATICAL DOUBLE-STRUCK SMALL Q",
	"MATHEMATICAL DOUBLE-STRUCK SMALL R",
	"MATHEMATICAL DOUBLE-STRUCK SMALL S",
	"MATHEMATICAL DOUBLE-STRUCK SMALL T",
	"MATHEMATICAL DOUBLE-STRUCK SMALL U",
	"MATHEMATICAL DOUBLE-STRUCK SMALL V",
	"MATHEMATICAL DOUBLE-STRUCK SMALL W",
	"MATHEMATICAL DOUBLE-STRUCK SMALL X",
	"MATHEMATICAL DOUBLE-STRUCK SMALL Y",
	"MATHEMATICAL DOUBLE-STRUCK SMALL Z",
	"MATHEMATICAL BOLD FRAKTUR CAPITAL A",
	"MATHEMATICAL BOLD FRAKTUR CAPITAL B",
	"MATHEMATICAL BOLD FRAKTUR CAPITAL C",
	"MATHEMATICAL BOLD FRAKTUR CAPITAL D",
	"MATHEMATICAL BOLD FRAKTUR CAPITAL E",
	"MATHEMATICAL BOLD FRAKTUR CAPITAL F",
	"MATHEMATICAL BOLD FRAKTUR CAPITAL G",
	"MATHEMATICAL BOLD FRAKTUR CAPITAL H",
	"MATHEMATICAL BOLD FRAKTUR CAPITAL I",
	"MATHEMATICAL BOLD FRAKTUR CAPITAL J",
	"MATHEMATICAL BOLD FRAKTUR CAPITAL K",
	"MATHEMATICAL BOLD FRAKTUR CAPITAL L",
	"MATHEMATICAL BOLD FRAKTUR CAPITAL M",
	"MATHEMATICAL BOLD FRAKTUR CAPITAL N",
	"MATHEMATICAL BOLD FRAKTUR CAPITAL O",
	"MATHEMATICAL BOLD FRAKTUR CAPITAL P",
	"MATHEMATICAL BOLD FRAKTUR CAPITAL Q",
	"MATHEMATICAL BOLD FRAKTUR CAPITAL R",
	"MATHEMATICAL BOLD FRAKTUR CAPITAL S",
	"MATHEMATICAL BOLD FRAKTUR CAPITAL T",
	"MATHEMATICAL BOLD FRAKTUR CAPITAL U",
	"MATHEMATICAL BOLD FRAKTUR CAPITAL V",
	"MATHEMATICAL BOLD FRAKTUR CAPITAL W",
	"MATHEMATICAL BOLD FRAKTUR CAPITAL X",
	"MATHEMATICAL BOLD FRAKTUR CAPITAL Y",
	"MATHEMATICAL BOLD FRAKTUR CAPITAL Z",
	"MATHEMATICAL BOLD FRAKTUR SMALL A",
	"MATHEMATICAL BOLD FRAKTUR SMALL B",
	"MATHEMATICAL BOLD FRAKTUR SMALL C",
	"MATHEMATICAL BOLD FRAKTUR SMALL D",
	"MATHEMATICAL BOLD FRAKTUR SMALL E",
	"MATHEMATICAL BOLD FRAKTUR SMALL F",
	"MATHEMATICAL BOLD FRAKTUR SMALL G",
	"MATHEMATICAL BOLD FRAKTUR SMALL H",
	"MATHEMATICAL BOLD FRAKTUR SMALL I",
	"MATHEMATICAL BOLD FRAKTUR SMALL J",
	"MATHEMATICAL BOLD FRAKTUR SMALL K",
	"MATHEMATICAL BOLD FRAKTUR SMALL L",
	"MATHEMATICAL BOLD FRAKTUR SMALL M",
	"MATHEMATICAL BOLD FRAKTUR SMALL N",
	"MATHEMATICAL BOLD FRAKTUR SMALL O",
	"MATHEMATICAL BOLD FRAKTUR SMALL P",
	"MATHEMATICAL BOLD FRAKTUR SMALL Q",
	"MATHEMATICAL BOLD FRAKTUR SMALL R",
	"MATHEMATICAL BOLD FRAKTUR SMALL S",
	"MATHEMATICAL BOLD FRAKTUR SMALL T",
	"MATHEMATICAL BOLD FRAKTUR SMALL U",
	"MATHEMATICAL BOLD FRAKTUR SMALL V",
	"MATHEMATICAL BOLD FRAKTUR SMALL W",
	"MATHEMATICAL BOLD FRAKTUR SMALL X",
	"MATHEMATICAL BOLD FRAKTUR SMALL Y",
	"MATHEMATICAL BOLD FRAKTUR SMALL Z",
	"MATHEMATICAL SANS-SERIF CAPITAL A",
	"MATHEMATICAL SANS-SERIF CAPITAL B",
	"MATHEMATICAL SANS-SERIF CAPITAL C",
	"MATHEMATICAL SANS-SERIF CAPITAL D",
	"MATHEMATICAL SANS-SERIF CAPITAL E",
	"MATHEMATICAL SANS-SERIF CAPITAL F",
	"MATHEMATICAL SANS-SERIF CAPITAL G",
	"MATHEMATICAL SANS-SERIF CAPITAL H",
	"MATHEMATICAL SANS-SERIF CAPITAL I",
	"MATHEMATICAL SANS-SERIF CAPITAL J",
	"MATHEMATICAL SANS-SERIF CAPITAL K",
	"MATHEMATICAL SANS-SERIF CAPITAL L",
	"MATHEMATICAL SANS-SERIF CAPITAL M",
	"MATHEMATICAL SANS-SERIF CAPITAL N",
	"MATHEMATICAL SANS-SERIF CAPITAL O",
	"MATHEMATICAL SANS-SERIF CAPITAL P",
	"MATHEMATICAL SANS-SERIF CAPITAL Q",
	"MATHEMATICAL SANS-SERIF CAPITAL R",
	"MATHEMATICAL SANS-SERIF CAPITAL S",
	"MATHEMATICAL SANS-SERIF CAPITAL T",
	"MATHEMATICAL SANS-SERIF CAPITAL U",
	"MATHEMATICAL SANS-SERIF CAPITAL V",
	"MATHEMATICAL SANS-SERIF CAPITAL W",
	"MATHEMATICAL SANS-SERIF CAPITAL X",
	"MATHEMATICAL SANS-SERIF CAPITAL Y",
	"MATHEMATICAL SANS-SERIF CAPITAL Z",
	"MATHEMATICAL SANS-SERIF SMALL A",
	"MATHEMATICAL SANS-SERIF SMALL B",
	"MATHEMATICAL SANS-SERIF SMALL C",
	"MATHEMATICAL SANS-SERIF SMALL D",
	"MATHEMATICAL SANS-SERIF SMALL E",
	"MATHEMATICAL SANS-SERIF SMALL F",
	"MATHEMATICAL SANS-SERIF SMALL G",
	"MATHEMATICAL SANS-SERIF SMALL H",
	"MATHEMATICAL SANS-SERIF SMALL I",
	"MATHEMATICAL SANS-SERIF SMALL J",
	"MATHEMATICAL SANS-SERIF SMALL K",
	"MATHEMATICAL SANS-SERIF SMALL L",
	"MATHEMATICAL SANS-SERIF SMALL M",
	"MATHEMATICAL SANS-SERIF SMALL N",
	"MATHEMATICAL SANS-SERIF SMALL O",
	"MATHEMATICAL SANS-SERIF SMALL P",
	"MATHEMATICAL SANS-SERIF SMALL Q",
	"MATHEMATICAL SANS-SERIF SMALL R",
	"MATHEMATICAL SANS-SERIF SMALL S",
	"MATHEMATICAL SANS-SERIF SMALL T",
	"MATHEMATICAL SANS-SERIF SMALL U",
	"MATHEMATICAL SANS-SERIF SMALL V",
	"MATHEMATICAL SANS-SERIF SMALL W",
	"MATHEMATICAL SANS-SERIF SMALL X",
	"MATHEMATICAL SANS-SERIF SMALL Y",
	"MATHEMATICAL SANS-SERIF SMALL Z",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL A",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL B",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL C",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL D",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL E",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL F",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL G",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL H",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL I",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL J",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL K",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL L",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL M",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL N",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL O",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL P",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL Q",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL R",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL S",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL T",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL U",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL V",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL W",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL X",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL Y",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL Z",
	"MATHEMATICAL SANS-SERIF BOLD SMALL A",
	"MATHEMATICAL SANS-SERIF BOLD SMALL B",
	"MATHEMATICAL SANS-SERIF BOLD SMALL C",
	"MATHEMATICAL SANS-SERIF BOLD SMALL D",
	"MATHEMATICAL SANS-SERIF BOLD SMALL E",
	"MATHEMATICAL SANS-SERIF BOLD SMALL F",
	"MATHEMATICAL SANS-SERIF BOLD SMALL G",
	"MATHEMATICAL SANS-SERIF BOLD SMALL H",
	"MATHEMATICAL SANS-SERIF BOLD SMALL I",
	"MATHEMATICAL SANS-SERIF BOLD SMALL J",
	"MATHEMATICAL SANS-SERIF BOLD SMALL K",
	"MATHEMATICAL SANS-SERIF BOLD SMALL L",
	"MATHEMATICAL SANS-SERIF BOLD SMALL M",
	"MATHEMATICAL SANS-SERIF BOLD SMALL N",
	"MATHEMATICAL SANS-SERIF BOLD SMALL O",
	"MATHEMATICAL SANS-SERIF BOLD SMALL P",
	"MATHEMATICAL SANS-SERIF BOLD SMALL Q",
	"MATHEMATICAL SANS-SERIF BOLD SMALL R",
	"MATHEMATICAL SANS-SERIF BOLD SMALL S",
	"MATHEMATICAL SANS-SERIF BOLD SMALL T",
	"MATHEMATICAL SANS-SERIF BOLD SMALL U",
	"MATHEMATICAL SANS-SERIF BOLD SMALL V",
	"MATHEMATICAL SANS-SERIF BOLD SMALL W",
	"MATHEMATICAL SANS-SERIF BOLD SMALL X",
	"MATHEMATICAL SANS-SERIF BOLD SMALL Y",
	"MATHEMATICAL SANS-SERIF BOLD SMALL Z",
	"MATHEMATICAL SANS-SERIF ITALIC CAPITAL A",
	"MATHEMATICAL SANS-SERIF ITALIC CAPITAL B",
	"MATHEMATICAL SANS-SERIF ITALIC CAPITAL C",
	"MATHEMATICAL SANS-SERIF ITALIC CAPITAL D",
	"MATHEMATICAL SANS-SERIF ITALIC CAPITAL E",
	"MATHEMATICAL SANS-SERIF ITALIC CAPITAL F",
	"MATHEMATICAL SANS-SERIF ITALIC CAPITAL G",
	"MATHEMATICAL SANS-SERIF ITALIC CAPITAL H",
	"MATHEMATICAL SANS-SERIF ITALIC CAPITAL I",
	"MATHEMATICAL SANS-SERIF ITALIC CAPITAL J",
	"MATHEMATICAL SANS-SERIF ITALIC CAPITAL K",
	"MATHEMATICAL SANS-SERIF ITALIC CAPITAL L",
	"MATHEMATICAL SANS-SERIF ITALIC CAPITAL M",
	"MATHEMATICAL SANS-SERIF ITALIC CAPITAL N",
	"MATHEMATICAL SANS-SERIF ITALIC CAPITAL O",
	"MATHEMATICAL SANS-SERIF ITALIC CAPITAL P",
	"MATHEMATICAL SANS-SERIF ITALIC CAPITAL Q",
	"MATHEMATICAL SANS-SERIF ITALIC CAPITAL R",
	"MATHEMATICAL SANS-SERIF ITALIC CAPITAL S",
	"MATHEMATICAL SANS-SERIF ITALIC CAPITAL T",
	"MATHEMATICAL SANS-SERIF ITALIC CAPITAL U",
	"MATHEMATICAL SANS-SERIF ITALIC CAPITAL V",
	"MATHEMATICAL SANS-SERIF ITALIC CAPITAL W",
	"MATHEMATICAL SANS-SERIF ITALIC CAPITAL X",
	"MATHEMATICAL SANS-SERIF ITALIC CAPITAL Y",
	"MATHEMATICAL SANS-SERIF ITALIC CAPITAL Z",
	"MATHEMATICAL SANS-SERIF ITALIC SMALL A",
	"MATHEMATICAL SANS-SERIF ITALIC SMALL B",
	"MATHEMATICAL SANS-SERIF ITALIC SMALL C",
	"MATHEMATICAL SANS-SERIF ITALIC SMALL D",
	"MATHEMATICAL SANS-SERIF ITALIC SMALL E",
	"MATHEMATICAL SANS-SERIF ITALIC SMALL F",
	"MATHEMATICAL SANS-SERIF ITALIC SMALL G",
	"MATHEMATICAL SANS-SERIF ITALIC SMALL H",
	"MATHEMATICAL SANS-SERIF ITALIC SMALL I",
	"MATHEMATICAL SANS-SERIF ITALIC SMALL J",
	"MATHEMATICAL SANS-SERIF ITALIC SMALL K",
	"MATHEMATICAL SANS-SERIF ITALIC SMALL L",
	"MATHEMATICAL SANS-SERIF ITALIC SMALL M",
	"MATHEMATICAL SANS-SERIF ITALIC SMALL N",
	"MATHEMATICAL SANS-SERIF ITALIC SMALL O",
	"MATHEMATICAL SANS-SERIF ITALIC SMALL P",
	"MATHEMATICAL SANS-SERIF ITALIC SMALL Q",
	"MATHEMATICAL SANS-SERIF ITALIC SMALL R",
	"MATHEMATICAL SANS-SERIF ITALIC SMALL S",
	"MATHEMATICAL SANS-SERIF ITALIC SMALL T",
	"MATHEMATICAL SANS-SERIF ITALIC SMALL U",
	"MATHEMATICAL SANS-SERIF ITALIC SMALL V",
	"MATHEMATICAL SANS-SERIF ITALIC SMALL W",
	"MATHEMATICAL SANS-SERIF ITALIC SMALL X",
	"MATHEMATICAL SANS-SERIF ITALIC SMALL Y",
	"MATHEMATICAL SANS-SERIF ITALIC SMALL Z",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL A",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL B",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL C",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL D",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL E",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL F",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL G",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL H",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL I",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL J",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL K",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL L",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL M",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL N",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL O",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL P",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL Q",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL R",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL S",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL T",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL U",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL V",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL W",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL X",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL Y",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL Z",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL A",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL B",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL C",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL D",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL E",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL F",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL G",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL H",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL I",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL J",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL K",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL L",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL M",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL N",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL O",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL P",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL Q",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL R",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL S",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL T",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL U",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL V",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL W",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL X",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL Y",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL Z",
	"MATHEMATICAL MONOSPACE CAPITAL A",
	"MATHEMATICAL MONOSPACE CAPITAL B",
	"MATHEMATICAL MONOSPACE CAPITAL C",
	"MATHEMATICAL MONOSPACE CAPITAL D",
	"MATHEMATICAL MONOSPACE CAPITAL E",
	"MATHEMATICAL MONOSPACE CAPITAL F",
	"MATHEMATICAL MONOSPACE CAPITAL G",
	"MATHEMATICAL MONOSPACE CAPITAL H",
	"MATHEMATICAL MONOSPACE CAPITAL I",
	"MATHEMATICAL MONOSPACE CAPITAL J",
	"MATHEMATICAL MONOSPACE CAPITAL K",
	"MATHEMATICAL MONOSPACE CAPITAL L",
	"MATHEMATICAL MONOSPACE CAPITAL M",
	"MATHEMATICAL MONOSPACE CAPITAL N",
	"MATHEMATICAL MONOSPACE CAPITAL O",
	"MATHEMATICAL MONOSPACE CAPITAL P",
	"MATHEMATICAL MONOSPACE CAPITAL Q",
	"MATHEMATICAL MONOSPACE CAPITAL R",
	"MATHEMATICAL MONOSPACE CAPITAL S",
	"MATHEMATICAL MONOSPACE CAPITAL T",
	"MATHEMATICAL MONOSPACE CAPITAL U",
	"MATHEMATICAL MONOSPACE CAPITAL V",
	"MATHEMATICAL MONOSPACE CAPITAL W",
	"MATHEMATICAL MONOSPACE CAPITAL X",
	"MATHEMATICAL MONOSPACE CAPITAL Y",
	"MATHEMATICAL MONOSPACE CAPITAL Z",
	"MATHEMATICAL MONOSPACE SMALL A",
	"MATHEMATICAL MONOSPACE SMALL B",
	"MATHEMATICAL MONOSPACE SMALL C",
	"MATHEMATICAL MONOSPACE SMALL D",
	"MATHEMATICAL MONOSPACE SMALL E",
	"MATHEMATICAL MONOSPACE SMALL F",
	"MATHEMATICAL MONOSPACE SMALL G",
	"MATHEMATICAL MONOSPACE SMALL H",
	"MATHEMATICAL MONOSPACE SMALL I",
	"MATHEMATICAL MONOSPACE SMALL J",
	"MATHEMATICAL MONOSPACE SMALL K",
	"MATHEMATICAL MONOSPACE SMALL L",
	"MATHEMATICAL MONOSPACE SMALL M",
	"MATHEMATICAL MONOSPACE SMALL N",
	"MATHEMATICAL MONOSPACE SMALL O",
	"MATHEMATICAL MONOSPACE SMALL P",
	"MATHEMATICAL MONOSPACE SMALL Q",
	"MATHEMATICAL MONOSPACE SMALL R",
	"MATHEMATICAL MONOSPACE SMALL S",
	"MATHEMATICAL MONOSPACE SMALL T",
	"MATHEMATICAL MONOSPACE SMALL U",
	"MATHEMATICAL MONOSPACE SMALL V",
	"MATHEMATICAL MONOSPACE SMALL W",
	"MATHEMATICAL MONOSPACE SMALL X",
	"MATHEMATICAL MONOSPACE SMALL Y",
	"MATHEMATICAL MONOSPACE SMALL Z",
	"MATHEMATICAL ITALIC SMALL DOTLESS I",
	"MATHEMATICAL ITALIC SMALL DOTLESS J",
	"MATHEMATICAL BOLD CAPITAL ALPHA",
	"MATHEMATICAL BOLD CAPITAL BETA",
	"MATHEMATICAL BOLD CAPITAL GAMMA",
	"MATHEMATICAL BOLD CAPITAL DELTA",
	"MATHEMATICAL BOLD CAPITAL EPSILON",
	"MATHEMATICAL BOLD CAPITAL ZETA",
	"MATHEMATICAL BOLD CAPITAL ETA",
	"MATHEMATICAL BOLD CAPITAL THETA",
	"MATHEMATICAL BOLD CAPITAL IOTA",
	"MATHEMATICAL BOLD CAPITAL KAPPA",
	"MATHEMATICAL BOLD CAPITAL LAMDA",
	"MATHEMATICAL BOLD CAPITAL MU",
	"MATHEMATICAL BOLD CAPITAL NU",
	"MATHEMATICAL BOLD CAPITAL XI",
	"MATHEMATICAL BOLD CAPITAL OMICRON",
	"MATHEMATICAL BOLD CAPITAL PI",
	"MATHEMATICAL BOLD CAPITAL RHO",
	"MATHEMATICAL BOLD CAPITAL THETA SYMBOL",
	"MATHEMATICAL BOLD CAPITAL SIGMA",
	"MATHEMATICAL BOLD CAPITAL TAU",
	"MATHEMATICAL BOLD CAPITAL UPSILON",
	"MATHEMATICAL BOLD CAPITAL PHI",
	"MATHEMATICAL BOLD CAPITAL CHI",
	"MATHEMATICAL BOLD CAPITAL PSI",
	"MATHEMATICAL BOLD CAPITAL OMEGA",
	"MATHEMATICAL BOLD NABLA",
	"MATHEMATICAL BOLD SMALL ALPHA",
	"MATHEMATICAL BOLD SMALL BETA",
	"MATHEMATICAL BOLD SMALL GAMMA",
	"MATHEMATICAL BOLD SMALL DELTA",
	"MATHEMATICAL BOLD SMALL EPSILON",
	"MATHEMATICAL BOLD SMALL ZETA",
	"MATHEMATICAL BOLD SMALL ETA",
	"MATHEMATICAL BOLD SMALL THETA",
	"MATHEMATICAL BOLD SMALL IOTA",
	"MATHEMATICAL BOLD SMALL KAPPA",
	"MATHEMATICAL BOLD SMALL LAMDA",
	"MATHEMATICAL BOLD SMALL MU",
	"MATHEMATICAL BOLD SMALL NU",
	"MATHEMATICAL BOLD SMALL XI",
	"MATHEMATICAL BOLD SMALL OMICRON",
	"MATHEMATICAL BOLD SMALL PI",
	"MATHEMATICAL BOLD SMALL RHO",
	"MATHEMATICAL BOLD SMALL FINAL SIGMA",
	"MATHEMATICAL BOLD SMALL SIGMA",
	"MATHEMATICAL BOLD SMALL TAU",
	"MATHEMATICAL BOLD SMALL UPSILON",
	"MATHEMATICAL BOLD SMALL PHI",
	"MATHEMATICAL BOLD SMALL CHI",
	"MATHEMATICAL BOLD SMALL PSI",
	"MATHEMATICAL BOLD SMALL OMEGA",
	"MATHEMATICAL BOLD PARTIAL DIFFERENTIAL",
	"MATHEMATICAL BOLD EPSILON SYMBOL",
	"MATHEMATICAL BOLD THETA SYMBOL",
	"MATHEMATICAL BOLD KAPPA SYMBOL",
	"MATHEMATICAL BOLD PHI SYMBOL",
	"MATHEMATICAL BOLD RHO SYMBOL",
	"MATHEMATICAL BOLD PI SYMBOL",
	"MATHEMATICAL ITALIC CAPITAL ALPHA",
	"MATHEMATICAL ITALIC CAPITAL BETA",
	"MATHEMATICAL ITALIC CAPITAL GAMMA",
	"MATHEMATICAL ITALIC CAPITAL DELTA",
	"MATHEMATICAL ITALIC CAPITAL EPSILON",
	"MATHEMATICAL ITALIC CAPITAL ZETA",
	"MATHEMATICAL ITALIC CAPITAL ETA",
	"MATHEMATICAL ITALIC CAPITAL THETA",
	"MATHEMATICAL ITALIC CAPITAL IOTA",
	"MATHEMATICAL ITALIC CAPITAL KAPPA",
	"MATHEMATICAL ITALIC CAPITAL LAMDA",
	"MATHEMATICAL ITALIC CAPITAL MU",
	"MATHEMATICAL ITALIC CAPITAL NU",
	"MATHEMATICAL ITALIC CAPITAL XI",
	"MATHEMATICAL ITALIC CAPITAL OMICRON",
	"MATHEMATICAL ITALIC CAPITAL PI",
	"MATHEMATICAL ITALIC CAPITAL RHO",
	"MATHEMATICAL ITALIC CAPITAL THETA SYMBOL",
	"MATHEMATICAL ITALIC CAPITAL SIGMA",
	"MATHEMATICAL ITALIC CAPITAL TAU",
	"MATHEMATICAL ITALIC CAPITAL UPSILON",
	"MATHEMATICAL ITALIC CAPITAL PHI",
	"MATHEMATICAL ITALIC CAPITAL CHI",
	"MATHEMATICAL ITALIC CAPITAL PSI",
	"MATHEMATICAL ITALIC CAPITAL OMEGA",
	"MATHEMATICAL ITALIC NABLA",
	"MATHEMATICAL ITALIC SMALL ALPHA",
	"MATHEMATICAL ITALIC SMALL BETA",
	"MATHEMATICAL ITALIC SMALL GAMMA",
	"MATHEMATICAL ITALIC SMALL DELTA",
	"MATHEMATICAL ITALIC SMALL EPSILON",
	"MATHEMATICAL ITALIC SMALL ZETA",
	"MATHEMATICAL ITALIC SMALL ETA",
	"MATHEMATICAL ITALIC SMALL THETA",
	"MATHEMATICAL ITALIC SMALL IOTA",
	"MATHEMATICAL ITALIC SMALL KAPPA",
	"MATHEMATICAL ITALIC SMALL LAMDA",
	"MATHEMATICAL ITALIC SMALL MU",
	"MATHEMATICAL ITALIC SMALL NU",
	"MATHEMATICAL ITALIC SMALL XI",
	"MATHEMATICAL ITALIC SMALL OMICRON",
	"MATHEMATICAL ITALIC SMALL PI",
	"MATHEMATICAL ITALIC SMALL RHO",
	"MATHEMATICAL ITALIC SMALL FINAL SIGMA",
	"MATHEMATICAL ITALIC SMALL SIGMA",
	"MATHEMATICAL ITALIC SMALL TAU",
	"MATHEMATICAL ITALIC SMALL UPSILON",
	"MATHEMATICAL ITALIC SMALL PHI",
	"MATHEMATICAL ITALIC SMALL CHI",
	"MATHEMATICAL ITALIC SMALL PSI",
	"MATHEMATICAL ITALIC SMALL OMEGA",
	"MATHEMATICAL ITALIC PARTIAL DIFFERENTIAL",
	"MATHEMATICAL ITALIC EPSILON SYMBOL",
	"MATHEMATICAL ITALIC THETA SYMBOL",
	"MATHEMATICAL ITALIC KAPPA SYMBOL",
	"MATHEMATICAL ITALIC PHI SYMBOL",
	"MATHEMATICAL ITALIC RHO SYMBOL",
	"MATHEMATICAL ITALIC PI SYMBOL",
	"MATHEMATICAL BOLD ITALIC CAPITAL ALPHA",
	"MATHEMATICAL BOLD ITALIC CAPITAL BETA",
	"MATHEMATICAL BOLD ITALIC CAPITAL GAMMA",
	"MATHEMATICAL BOLD ITALIC CAPITAL DELTA",
	"MATHEMATICAL BOLD ITALIC CAPITAL EPSILON",
	"MATHEMATICAL BOLD ITALIC CAPITAL ZETA",
	"MATHEMATICAL BOLD ITALIC CAPITAL ETA",
	"MATHEMATICAL BOLD ITALIC CAPITAL THETA",
	"MATHEMATICAL BOLD ITALIC CAPITAL IOTA",
	"MATHEMATICAL BOLD ITALIC CAPITAL KAPPA",
	"MATHEMATICAL BOLD ITALIC CAPITAL LAMDA",
	"MATHEMATICAL BOLD ITALIC CAPITAL MU",
	"MATHEMATICAL BOLD ITALIC CAPITAL NU",
	"MATHEMATICAL BOLD ITALIC CAPITAL XI",
	"MATHEMATICAL BOLD ITALIC CAPITAL OMICRON",
	"MATHEMATICAL BOLD ITALIC CAPITAL PI",
	"MATHEMATICAL BOLD ITALIC CAPITAL RHO",
	"MATHEMATICAL BOLD ITALIC CAPITAL THETA SYMBOL",
	"MATHEMATICAL BOLD ITALIC CAPITAL SIGMA",
	"MATHEMATICAL BOLD ITALIC CAPITAL TAU",
	"MATHEMATICAL BOLD ITALIC CAPITAL UPSILON",
	"MATHEMATICAL BOLD ITALIC CAPITAL PHI",
	"MATHEMATICAL BOLD ITALIC CAPITAL CHI",
	"MATHEMATICAL BOLD ITALIC CAPITAL PSI",
	"MATHEMATICAL BOLD ITALIC CAPITAL OMEGA",
	"MATHEMATICAL BOLD ITALIC NABLA",
	"MATHEMATICAL BOLD ITALIC SMALL ALPHA",
	"MATHEMATICAL BOLD ITALIC SMALL BETA",
	"MATHEMATICAL BOLD ITALIC SMALL GAMMA",
	"MATHEMATICAL BOLD ITALIC SMALL DELTA",
	"MATHEMATICAL BOLD ITALIC SMALL EPSILON",
	"MATHEMATICAL BOLD ITALIC SMALL ZETA",
	"MATHEMATICAL BOLD ITALIC SMALL ETA",
	"MATHEMATICAL BOLD ITALIC SMALL THETA",
	"MATHEMATICAL BOLD ITALIC SMALL IOTA",
	"MATHEMATICAL BOLD ITALIC SMALL KAPPA",
	"MATHEMATICAL BOLD ITALIC SMALL LAMDA",
	"MATHEMATICAL BOLD ITALIC SMALL MU",
	"MATHEMATICAL BOLD ITALIC SMALL NU",
	"MATHEMATICAL BOLD ITALIC SMALL XI",
	"MATHEMATICAL BOLD ITALIC SMALL OMICRON",
	"MATHEMATICAL BOLD ITALIC SMALL PI",
	"MATHEMATICAL BOLD ITALIC SMALL RHO",
	"MATHEMATICAL BOLD ITALIC SMALL FINAL SIGMA",
	"MATHEMATICAL BOLD ITALIC SMALL SIGMA",
	"MATHEMATICAL BOLD ITALIC SMALL TAU",
	"MATHEMATICAL BOLD ITALIC SMALL UPSILON",
	"MATHEMATICAL BOLD ITALIC SMALL PHI",
	"MATHEMATICAL BOLD ITALIC SMALL CHI",
	"MATHEMATICAL BOLD ITALIC SMALL PSI",
	"MATHEMATICAL BOLD ITALIC SMALL OMEGA",
	"MATHEMATICAL BOLD ITALIC PARTIAL DIFFERENTIAL",
	"MATHEMATICAL BOLD ITALIC EPSILON SYMBOL",
	"MATHEMATICAL BOLD ITALIC THETA SYMBOL",
	"MATHEMATICAL BOLD ITALIC KAPPA SYMBOL",
	"MATHEMATICAL BOLD ITALIC PHI SYMBOL",
	"MATHEMATICAL BOLD ITALIC RHO SYMBOL",
	"MATHEMATICAL BOLD ITALIC PI SYMBOL",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL ALPHA",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL BETA",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL GAMMA",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL DELTA",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL EPSILON",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL ZETA",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL ETA",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL THETA",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL IOTA",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL KAPPA",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL LAMDA",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL MU",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL NU",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL XI",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL OMICRON",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL PI",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL RHO",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL THETA SYMBOL",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL SIGMA",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL TAU",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL UPSILON",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL PHI",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL CHI",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL PSI",
	"MATHEMATICAL SANS-SERIF BOLD CAPITAL OMEGA",
	"MATHEMATICAL SANS-SERIF BOLD NABLA",
	"MATHEMATICAL SANS-SERIF BOLD SMALL ALPHA",
	"MATHEMATICAL SANS-SERIF BOLD SMALL BETA",
	"MATHEMATICAL SANS-SERIF BOLD SMALL GAMMA",
	"MATHEMATICAL SANS-SERIF BOLD SMALL DELTA",
	"MATHEMATICAL SANS-SERIF BOLD SMALL EPSILON",
	"MATHEMATICAL SANS-SERIF BOLD SMALL ZETA",
	"MATHEMATICAL SANS-SERIF BOLD SMALL ETA",
	"MATHEMATICAL SANS-SERIF BOLD SMALL THETA",
	"MATHEMATICAL SANS-SERIF BOLD SMALL IOTA",
	"MATHEMATICAL SANS-SERIF BOLD SMALL KAPPA",
	"MATHEMATICAL SANS-SERIF BOLD SMALL LAMDA",
	"MATHEMATICAL SANS-SERIF BOLD SMALL MU",
	"MATHEMATICAL SANS-SERIF BOLD SMALL NU",
	"MATHEMATICAL SANS-SERIF BOLD SMALL XI",
	"MATHEMATICAL SANS-SERIF BOLD SMALL OMICRON",
	"MATHEMATICAL SANS-SERIF BOLD SMALL PI",
	"MATHEMATICAL SANS-SERIF BOLD SMALL RHO",
	"MATHEMATICAL SANS-SERIF BOLD SMALL FINAL SIGMA",
	"MATHEMATICAL SANS-SERIF BOLD SMALL SIGMA",
	"MATHEMATICAL SANS-SERIF BOLD SMALL TAU",
	"MATHEMATICAL SANS-SERIF BOLD SMALL UPSILON",
	"MATHEMATICAL SANS-SERIF BOLD SMALL PHI",
	"MATHEMATICAL SANS-SERIF BOLD SMALL CHI",
	"MATHEMATICAL SANS-SERIF BOLD SMALL PSI",
	"MATHEMATICAL SANS-SERIF BOLD SMALL OMEGA",
	"MATHEMATICAL SANS-SERIF BOLD PARTIAL DIFFERENTIAL",
	"MATHEMATICAL SANS-SERIF BOLD EPSILON SYMBOL",
	"MATHEMATICAL SANS-SERIF BOLD THETA SYMBOL",
	"MATHEMATICAL SANS-SERIF BOLD KAPPA SYMBOL",
	"MATHEMATICAL SANS-SERIF BOLD PHI SYMBOL",
	"MATHEMATICAL SANS-SERIF BOLD RHO SYMBOL",
	"MATHEMATICAL SANS-SERIF BOLD PI SYMBOL",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL ALPHA",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL BETA",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL GAMMA",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL DELTA",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL EPSILON",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL ZETA",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL ETA",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL THETA",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL IOTA",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL KAPPA",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL LAMDA",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL MU",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL NU",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL XI",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMICRON",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL PI",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL RHO",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL THETA SYMBOL",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL SIGMA",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL TAU",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL UPSILON",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL PHI",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL CHI",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL PSI",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMEGA",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC NABLA",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ALPHA",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL BETA",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL GAMMA",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL DELTA",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL EPSILON",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ZETA",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ETA",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL THETA",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL IOTA",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL KAPPA",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL LAMDA",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL MU",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL NU",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL XI",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMICRON",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL PI",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL RHO",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL FINAL SIGMA",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL SIGMA",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL TAU",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL UPSILON",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL PHI",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL CHI",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL PSI",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMEGA",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC PARTIAL DIFFERENTIAL",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC EPSILON SYMBOL",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC THETA SYMBOL",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC KAPPA SYMBOL",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC PHI SYMBOL",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC RHO SYMBOL",
	"MATHEMATICAL SANS-SERIF BOLD ITALIC PI SYMBOL",
	"MATHEMATICAL BOLD CAPITAL DIGAMMA",
	"MATHEMATICAL BOLD SMALL DIGAMMA",
	"MATHEMATICAL BOLD DIGIT ZERO",
	"MATHEMATICAL BOLD DIGIT ONE",
	"MATHEMATICAL BOLD DIGIT TWO",
	"MATHEMATICAL BOLD DIGIT THREE",
	"MATHEMATICAL BOLD DIGIT FOUR",
	"MATHEMATICAL BOLD DIGIT FIVE",
	"MATHEMATICAL BOLD DIGIT SIX",
	"MATHEMATICAL BOLD DIGIT SEVEN",
	"MATHEMATICAL BOLD DIGIT EIGHT",
	"MATHEMATICAL BOLD DIGIT NINE",
	"MATHEMATICAL DOUBLE-STRUCK DIGIT ZERO",
	"MATHEMATICAL DOUBLE-STRUCK DIGIT ONE",
	"MATHEMATICAL DOUBLE-STRUCK DIGIT TWO",
	"MATHEMATICAL DOUBLE-STRUCK DIGIT THREE",
	"MATHEMATICAL DOUBLE-STRUCK DIGIT FOUR",
	"MATHEMATICAL DOUBLE-STRUCK DIGIT FIVE",
	"MATHEMATICAL DOUBLE-STRUCK DIGIT SIX",
	"MATHEMATICAL DOUBLE-STRUCK DIGIT SEVEN",
	"MATHEMATICAL DOUBLE-STRUCK DIGIT EIGHT",
	"MATHEMATICAL DOUBLE-STRUCK DIGIT NINE",
	"MATHEMATICAL SANS-SERIF DIGIT ZERO",
	"MATHEMATICAL SANS-SERIF DIGIT ONE",
	"MATHEMATICAL SANS-SERIF DIGIT TWO",
	"MATHEMATICAL SANS-SERIF DIGIT THREE",
	"MATHEMATICAL SANS-SERIF DIGIT FOUR",
	"MATHEMATICAL SANS-SERIF DIGIT FIVE",
	"MATHEMATICAL SANS-SERIF DIGIT SIX",
	"MATHEMATICAL SANS-SERIF DIGIT SEVEN",
	"MATHEMATICAL SANS-SERIF DIGIT EIGHT",
	"MATHEMATICAL SANS-SERIF DIGIT NINE",
	"MATHEMATICAL SANS-SERIF BOLD DIGIT ZERO",
	"MATHEMATICAL SANS-SERIF BOLD DIGIT ONE",
	"MATHEMATICAL SANS-SERIF BOLD DIGIT TWO",
	"MATHEMATICAL SANS-SERIF BOLD DIGIT THREE",
	"MATHEMATICAL SANS-SERIF BOLD DIGIT FOUR",
	"MATHEMATICAL SANS-SERIF BOLD DIGIT FIVE",
	"MATHEMATICAL SANS-SERIF BOLD DIGIT SIX",
	"MATHEMATICAL SANS-SERIF BOLD DIGIT SEVEN",
	"MATHEMATICAL SANS-SERIF BOLD DIGIT EIGHT",
	"MATHEMATICAL SANS-SERIF BOLD DIGIT NINE",
	"MATHEMATICAL MONOSPACE DIGIT ZERO",
	"MATHEMATICAL MONOSPACE DIGIT ONE",
	"MATHEMATICAL MONOSPACE DIGIT TWO",
	"MATHEMATICAL MONOSPACE DIGIT THREE",
	"MATHEMATICAL MONOSPACE DIGIT FOUR",
	"MATHEMATICAL MONOSPACE DIGIT FIVE",
	"MATHEMATICAL MONOSPACE DIGIT SIX",
	"MATHEMATICAL MONOSPACE DIGIT SEVEN",
	"MATHEMATICAL MONOSPACE DIGIT EIGHT",
	"MATHEMATICAL MONOSPACE DIGIT NINE",
	"SIGNWRITING HAND-FIST INDEX",
	"SIGNWRITING HAND-CIRCLE INDEX",
	"SIGNWRITING HAND-CUP INDEX",
	"SIGNWRITING HAND-OVAL INDEX",
	"SIGNWRITING HAND-HINGE INDEX",
	"SIGNWRITING HAND-ANGLE INDEX",
	"SIGNWRITING HAND-FIST INDEX BENT",
	"SIGNWRITING HAND-CIRCLE INDEX BENT",
	"SIGNWRITING HAND-FIST THUMB UNDER INDEX BENT",
	"SIGNWRITING HAND-FIST INDEX RAISED KNUCKLE",
	"SIGNWRITING HAND-FIST INDEX CUPPED",
	"SIGNWRITING HAND-FIST INDEX HINGED",
	"SIGNWRITING HAND-FIST INDEX HINGED LOW",
	"SIGNWRITING HAND-CIRCLE INDEX HINGE",
	"SIGNWRITING HAND-FIST INDEX MIDDLE",
	"SIGNWRITING HAND-CIRCLE INDEX MIDDLE",
	"SIGNWRITING HAND-FIST INDEX MIDDLE BENT",
	"SIGNWRITING HAND-FIST INDEX MIDDLE RAISED KNUCKLES",
	"SIGNWRITING HAND-FIST INDEX MIDDLE HINGED",
	"SIGNWRITING HAND-FIST INDEX UP MIDDLE HINGED",
	"SIGNWRITING HAND-FIST INDEX HINGED MIDDLE UP",
	"SIGNWRITING HAND-FIST INDEX MIDDLE CONJOINED",
	"SIGNWRITING HAND-FIST INDEX MIDDLE CONJOINED INDEX BENT",
	"SIGNWRITING HAND-FIST INDEX MIDDLE CONJOINED MIDDLE BENT",
	"SIGNWRITING HAND-FIST INDEX MIDDLE CONJOINED CUPPED",
	"SIGNWRITING HAND-FIST INDEX MIDDLE CONJOINED HINGED",
	"SIGNWRITING HAND-FIST INDEX MIDDLE CROSSED",
	"SIGNWRITING HAND-CIRCLE INDEX MIDDLE CROSSED",
	"SIGNWRITING HAND-FIST MIDDLE BENT OVER INDEX",
	"SIGNWRITING HAND-FIST INDEX BENT OVER MIDDLE",
	"SIGNWRITING HAND-FIST INDEX MIDDLE THUMB",
	"SIGNWRITING HAND-CIRCLE INDEX MIDDLE THUMB",
	"SIGNWRITING HAND-FIST INDEX MIDDLE STRAIGHT THUMB BENT",
	"SIGNWRITING HAND-FIST INDEX MIDDLE BENT THUMB STRAIGHT",
	"SIGNWRITING HAND-FIST INDEX MIDDLE THUMB BENT",
	"SIGNWRITING HAND-FIST INDEX MIDDLE HINGED SPREAD THUMB SIDE",
	"SIGNWRITING HAND-FIST INDEX UP MIDDLE HINGED THUMB SIDE",
	"SIGNWRITING HAND-FIST INDEX UP MIDDLE HINGED THUMB CONJOINED",
	"SIGNWRITING HAND-FIST INDEX HINGED MIDDLE UP THUMB SIDE",
	"SIGNWRITING HAND-FIST INDEX MIDDLE UP SPREAD THUMB FORWARD",
	"SIGNWRITING HAND-FIST INDEX MIDDLE THUMB CUPPED",
	"SIGNWRITING HAND-FIST INDEX MIDDLE THUMB CIRCLED",
	"SIGNWRITING HAND-FIST INDEX MIDDLE THUMB HOOKED",
	"SIGNWRITING HAND-FIST INDEX MIDDLE THUMB HINGED",
	"SIGNWRITING HAND-FIST THUMB BETWEEN INDEX MIDDLE STRAIGHT",
	"SIGNWRITING HAND-FIST INDEX MIDDLE CONJOINED THUMB SIDE",
	"SIGNWRITING HAND-FIST INDEX MIDDLE CONJOINED THUMB SIDE CONJOINED",
	"SIGNWRITING HAND-FIST INDEX MIDDLE CONJOINED THUMB SIDE BENT",
	"SIGNWRITING HAND-FIST MIDDLE THUMB HOOKED INDEX UP",
	"SIGNWRITING HAND-FIST INDEX THUMB HOOKED MIDDLE UP",
	"SIGNWRITING HAND-FIST INDEX MIDDLE CONJOINED HINGED THUMB SIDE",
	"SIGNWRITING HAND-FIST INDEX MIDDLE CROSSED THUMB SIDE",
	"SIGNWRITING HAND-FIST INDEX MIDDLE CONJOINED THUMB FORWARD",
	"SIGNWRITING HAND-FIST INDEX MIDDLE CONJOINED CUPPED THUMB FORWARD",
	"SIGNWRITING HAND-FIST MIDDLE THUMB CUPPED INDEX UP",
	"SIGNWRITING HAND-FIST INDEX THUMB CUPPED MIDDLE UP",
	"SIGNWRITING HAND-FIST MIDDLE THUMB CIRCLED INDEX UP",
	"SIGNWRITING HAND-FIST MIDDLE THUMB CIRCLED INDEX HINGED",
	"SIGNWRITING HAND-FIST INDEX THUMB ANGLED OUT MIDDLE UP",
	"SIGNWRITING HAND-FIST INDEX THUMB ANGLED IN MIDDLE UP",
	"SIGNWRITING HAND-FIST INDEX THUMB CIRCLED MIDDLE UP",
	"SIGNWRITING HAND-FIST INDEX MIDDLE THUMB CONJOINED HINGED",
	"SIGNWRITING HAND-FIST INDEX MIDDLE THUMB ANGLED OUT",
	"SIGNWRITING HAND-FIST INDEX MIDDLE THUMB ANGLED",
	"SIGNWRITING HAND-FIST MIDDLE THUMB ANGLED OUT INDEX UP",
	"SIGNWRITING HAND-FIST MIDDLE THUMB ANGLED OUT INDEX CROSSED",
	"SIGNWRITING HAND-FIST MIDDLE THUMB ANGLED INDEX UP",
	"SIGNWRITING HAND-FIST INDEX THUMB HOOKED MIDDLE HINGED",
	"SIGNWRITING HAND-FLAT FOUR FINGERS",
	"SIGNWRITING HAND-FLAT FOUR FINGERS BENT",
	"SIGNWRITING HAND-FLAT FOUR FINGERS HINGED",
	"SIGNWRITING HAND-FLAT FOUR FINGERS CONJOINED",
	"SIGNWRITING HAND-FLAT FOUR FINGERS CONJOINED SPLIT",
	"SIGNWRITING HAND-CLAW FOUR FINGERS CONJOINED",
	"SIGNWRITING HAND-FIST FOUR FINGERS CONJOINED BENT",
	"SIGNWRITING HAND-HINGE FOUR FINGERS CONJOINED",
	"SIGNWRITING HAND-FLAT FIVE FINGERS SPREAD",
	"SIGNWRITING HAND-FLAT HEEL FIVE FINGERS SPREAD",
	"SIGNWRITING HAND-FLAT FIVE FINGERS SPREAD FOUR BENT",
	"SIGNWRITING HAND-FLAT HEEL FIVE FINGERS SPREAD FOUR BENT",
	"SIGNWRITING HAND-FLAT FIVE FINGERS SPREAD BENT",
	"SIGNWRITING HAND-FLAT HEEL FIVE FINGERS SPREAD BENT",
	"SIGNWRITING HAND-FLAT FIVE FINGERS SPREAD THUMB FORWARD",
	"SIGNWRITING HAND-CUP FIVE FINGERS SPREAD",
	"SIGNWRITING HAND-CUP FIVE FINGERS SPREAD OPEN",
	"SIGNWRITING HAND-HINGE FIVE FINGERS SPREAD OPEN",
	"SIGNWRITING HAND-OVAL FIVE FINGERS SPREAD",
	"SIGNWRITING HAND-FLAT FIVE FINGERS SPREAD HINGED",
	"SIGNWRITING HAND-FLAT FIVE FINGERS SPREAD HINGED THUMB SIDE",
	"SIGNWRITING HAND-FLAT FIVE FINGERS SPREAD HINGED NO THUMB",
	"SIGNWRITING HAND-FLAT",
	"SIGNWRITING HAND-FLAT BETWEEN PALM FACINGS",
	"SIGNWRITING HAND-FLAT HEEL",
	"SIGNWRITING HAND-FLAT THUMB SIDE",
	"SIGNWRITING HAND-FLAT HEEL THUMB SIDE",
	"SIGNWRITING HAND-FLAT THUMB BENT",
	"SIGNWRITING HAND-FLAT THUMB FORWARD",
	"SIGNWRITING HAND-FLAT SPLIT INDEX THUMB SIDE",
	"SIGNWRITING HAND-FLAT SPLIT CENTRE",
	"SIGNWRITING HAND-FLAT SPLIT CENTRE THUMB SIDE",
	"SIGNWRITING HAND-FLAT SPLIT CENTRE THUMB SIDE BENT",
	"SIGNWRITING HAND-FLAT SPLIT LITTLE",
	"SIGNWRITING HAND-CLAW",
	"SIGNWRITING HAND-CLAW THUMB SIDE",
	"SIGNWRITING HAND-CLAW NO THUMB",
	"SIGNWRITING HAND-CLAW THUMB FORWARD",
	"SIGNWRITING HAND-HOOK CURLICUE",
	"SIGNWRITING HAND-HOOK",
	"SIGNWRITING HAND-CUP OPEN",
	"SIGNWRITING HAND-CUP",
	"SIGNWRITING HAND-CUP OPEN THUMB SIDE",
	"SIGNWRITING HAND-CUP THUMB SIDE",
	"SIGNWRITING HAND-CUP OPEN NO THUMB",
	"SIGNWRITING HAND-CUP NO THUMB",
	"SIGNWRITING HAND-CUP OPEN THUMB FORWARD",
	"SIGNWRITING HAND-CUP THUMB FORWARD",
	"SIGNWRITING HAND-CURLICUE OPEN",
	"SIGNWRITING HAND-CURLICUE",
	"SIGNWRITING HAND-CIRCLE",
	"SIGNWRITING HAND-OVAL",
	"SIGNWRITING HAND-OVAL THUMB SIDE",
	"SIGNWRITING HAND-OVAL NO THUMB",
	"SIGNWRITING HAND-OVAL THUMB FORWARD",
	"SIGNWRITING HAND-HINGE OPEN",
	"SIGNWRITING HAND-HINGE OPEN THUMB FORWARD",
	"SIGNWRITING HAND-HINGE",
	"SIGNWRITING HAND-HINGE SMALL",
	"SIGNWRITING HAND-HINGE OPEN THUMB SIDE",
	"SIGNWRITING HAND-HINGE THUMB SIDE",
	"SIGNWRITING HAND-HINGE OPEN NO THUMB",
	"SIGNWRITING HAND-HINGE NO THUMB",
	"SIGNWRITING HAND-HINGE THUMB SIDE TOUCHING INDEX",
	"SIGNWRITING HAND-HINGE THUMB BETWEEN MIDDLE RING",
	"SIGNWRITING HAND-ANGLE",
	"SIGNWRITING HAND-FIST INDEX MIDDLE RING",
	"SIGNWRITING HAND-CIRCLE INDEX MIDDLE RING",
	"SIGNWRITING HAND-HINGE INDEX MIDDLE RING",
	"SIGNWRITING HAND-ANGLE INDEX MIDDLE RING",
	"SIGNWRITING HAND-HINGE LITTLE",
	"SIGNWRITING HAND-FIST INDEX MIDDLE RING BENT",
	"SIGNWRITING HAND-FIST INDEX MIDDLE RING CONJOINED",
	"SIGNWRITING HAND-HINGE INDEX MIDDLE RING CONJOINED",
	"SIGNWRITING HAND-FIST LITTLE DOWN",
	"SIGNWRITING HAND-FIST LITTLE DOWN RIPPLE STRAIGHT",
	"SIGNWRITING HAND-FIST LITTLE DOWN RIPPLE CURVED",
	"SIGNWRITING HAND-FIST LITTLE DOWN OTHERS CIRCLED",
	"SIGNWRITING HAND-FIST LITTLE UP",
	"SIGNWRITING HAND-FIST THUMB UNDER LITTLE UP",
	"SIGNWRITING HAND-CIRCLE LITTLE UP",
	"SIGNWRITING HAND-OVAL LITTLE UP",
	"SIGNWRITING HAND-ANGLE LITTLE UP",
	"SIGNWRITING HAND-FIST LITTLE RAISED KNUCKLE",
	"SIGNWRITING HAND-FIST LITTLE BENT",
	"SIGNWRITING HAND-FIST LITTLE TOUCHES THUMB",
	"SIGNWRITING HAND-FIST LITTLE THUMB",
	"SIGNWRITING HAND-HINGE LITTLE THUMB",
	"SIGNWRITING HAND-FIST LITTLE INDEX THUMB",
	"SIGNWRITING HAND-HINGE LITTLE INDEX THUMB",
	"SIGNWRITING HAND-ANGLE LITTLE INDEX THUMB INDEX THUMB OUT",
	"SIGNWRITING HAND-ANGLE LITTLE INDEX THUMB INDEX THUMB",
	"SIGNWRITING HAND-FIST LITTLE INDEX",
	"SIGNWRITING HAND-CIRCLE LITTLE INDEX",
	"SIGNWRITING HAND-HINGE LITTLE INDEX",
	"SIGNWRITING HAND-ANGLE LITTLE INDEX",
	"SIGNWRITING HAND-FIST INDEX MIDDLE LITTLE",
	"SIGNWRITING HAND-CIRCLE INDEX MIDDLE LITTLE",
	"SIGNWRITING HAND-HINGE INDEX MIDDLE LITTLE",
	"SIGNWRITING HAND-HINGE RING",
	"SIGNWRITING HAND-ANGLE INDEX MIDDLE LITTLE",
	"SIGNWRITING HAND-FIST INDEX MIDDLE CROSS LITTLE",
	"SIGNWRITING HAND-CIRCLE INDEX MIDDLE CROSS LITTLE",
	"SIGNWRITING HAND-FIST RING DOWN",
	"SIGNWRITING HAND-HINGE RING DOWN INDEX THUMB HOOK MIDDLE",
	"SIGNWRITING HAND-ANGLE RING DOWN MIDDLE THUMB INDEX CROSS",
	"SIGNWRITING HAND-FIST RING UP",
	"SIGNWRITING HAND-FIST RING RAISED KNUCKLE",
	"SIGNWRITING HAND-FIST RING LITTLE",
	"SIGNWRITING HAND-CIRCLE RING LITTLE",
	"SIGNWRITING HAND-OVAL RING LITTLE",
	"SIGNWRITING HAND-ANGLE RING LITTLE",
	"SIGNWRITING HAND-FIST RING MIDDLE",
	"SIGNWRITING HAND-FIST RING MIDDLE CONJOINED",
	"SIGNWRITING HAND-FIST RING MIDDLE RAISED KNUCKLES",
	"SIGNWRITING HAND-FIST RING INDEX",
	"SIGNWRITING HAND-FIST RING THUMB",
	"SIGNWRITING HAND-HOOK RING THUMB",
	"SIGNWRITING HAND-FIST INDEX RING LITTLE",
	"SIGNWRITING HAND-CIRCLE INDEX RING LITTLE",
	"SIGNWRITING HAND-CURLICUE INDEX RING LITTLE ON",
	"SIGNWRITING HAND-HOOK INDEX RING LITTLE OUT",
	"SIGNWRITING HAND-HOOK INDEX RING LITTLE IN",
	"SIGNWRITING HAND-HOOK INDEX RING LITTLE UNDER",
	"SIGNWRITING HAND-CUP INDEX RING LITTLE",
	"SIGNWRITING HAND-HINGE INDEX RING LITTLE",
	"SIGNWRITING HAND-ANGLE INDEX RING LITTLE OUT",
	"SIGNWRITING HAND-ANGLE INDEX RING LITTLE",
	"SIGNWRITING HAND-FIST MIDDLE DOWN",
	"SIGNWRITING HAND-HINGE MIDDLE",
	"SIGNWRITING HAND-FIST MIDDLE UP",
	"SIGNWRITING HAND-CIRCLE MIDDLE UP",
	"SIGNWRITING HAND-FIST MIDDLE RAISED KNUCKLE",
	"SIGNWRITING HAND-FIST MIDDLE UP THUMB SIDE",
	"SIGNWRITING HAND-HOOK MIDDLE THUMB",
	"SIGNWRITING HAND-FIST MIDDLE THUMB LITTLE",
	"SIGNWRITING HAND-FIST MIDDLE LITTLE",
	"SIGNWRITING HAND-FIST MIDDLE RING LITTLE",
	"SIGNWRITING HAND-CIRCLE MIDDLE RING LITTLE",
	"SIGNWRITING HAND-CURLICUE MIDDLE RING LITTLE ON",
	"SIGNWRITING HAND-CUP MIDDLE RING LITTLE",
	"SIGNWRITING HAND-HINGE MIDDLE RING LITTLE",
	"SIGNWRITING HAND-ANGLE MIDDLE RING LITTLE OUT",
	"SIGNWRITING HAND-ANGLE MIDDLE RING LITTLE IN",
	"SIGNWRITING HAND-ANGLE MIDDLE RING LITTLE",
	"SIGNWRITING HAND-CIRCLE MIDDLE RING LITTLE BENT",
	"SIGNWRITING HAND-CLAW MIDDLE RING LITTLE CONJOINED",
	"SIGNWRITING HAND-CLAW MIDDLE RING LITTLE CONJOINED SIDE",
	"SIGNWRITING HAND-HOOK MIDDLE RING LITTLE CONJOINED OUT",
	"SIGNWRITING HAND-HOOK MIDDLE RING LITTLE CONJOINED IN",
	"SIGNWRITING HAND-HOOK MIDDLE RING LITTLE CONJOINED",
	"SIGNWRITING HAND-HINGE INDEX HINGED",
	"SIGNWRITING HAND-FIST INDEX THUMB SIDE",
	"SIGNWRITING HAND-HINGE INDEX THUMB SIDE",
	"SIGNWRITING HAND-FIST INDEX THUMB SIDE THUMB DIAGONAL",
	"SIGNWRITING HAND-FIST INDEX THUMB SIDE THUMB CONJOINED",
	"SIGNWRITING HAND-FIST INDEX THUMB SIDE THUMB BENT",
	"SIGNWRITING HAND-FIST INDEX THUMB SIDE INDEX BENT",
	"SIGNWRITING HAND-FIST INDEX THUMB SIDE BOTH BENT",
	"SIGNWRITING HAND-FIST INDEX THUMB SIDE INDEX HINGE",
	"SIGNWRITING HAND-FIST INDEX THUMB FORWARD INDEX STRAIGHT",
	"SIGNWRITING HAND-FIST INDEX THUMB FORWARD INDEX BENT",
	"SIGNWRITING HAND-FIST INDEX THUMB HOOK",
	"SIGNWRITING HAND-FIST INDEX THUMB CURLICUE",
	"SIGNWRITING HAND-FIST INDEX THUMB CURVE THUMB INSIDE",
	"SIGNWRITING HAND-CLAW INDEX THUMB CURVE THUMB INSIDE",
	"SIGNWRITING HAND-FIST INDEX THUMB CURVE THUMB UNDER",
	"SIGNWRITING HAND-FIST INDEX THUMB CIRCLE",
	"SIGNWRITING HAND-CUP INDEX THUMB",
	"SIGNWRITING HAND-CUP INDEX THUMB OPEN",
	"SIGNWRITING HAND-HINGE INDEX THUMB OPEN",
	"SIGNWRITING HAND-HINGE INDEX THUMB LARGE",
	"SIGNWRITING HAND-HINGE INDEX THUMB",
	"SIGNWRITING HAND-HINGE INDEX THUMB SMALL",
	"SIGNWRITING HAND-ANGLE INDEX THUMB OUT",
	"SIGNWRITING HAND-ANGLE INDEX THUMB IN",
	"SIGNWRITING HAND-ANGLE INDEX THUMB",
	"SIGNWRITING HAND-FIST THUMB",
	"SIGNWRITING HAND-FIST THUMB HEEL",
	"SIGNWRITING HAND-FIST THUMB SIDE DIAGONAL",
	"SIGNWRITING HAND-FIST THUMB SIDE CONJOINED",
	"SIGNWRITING HAND-FIST THUMB SIDE BENT",
	"SIGNWRITING HAND-FIST THUMB FORWARD",
	"SIGNWRITING HAND-FIST THUMB BETWEEN INDEX MIDDLE",
	"SIGNWRITING HAND-FIST THUMB BETWEEN MIDDLE RING",
	"SIGNWRITING HAND-FIST THUMB BETWEEN RING LITTLE",
	"SIGNWRITING HAND-FIST THUMB UNDER TWO FINGERS",
	"SIGNWRITING HAND-FIST THUMB OVER TWO FINGERS",
	"SIGNWRITING HAND-FIST THUMB UNDER THREE FINGERS",
	"SIGNWRITING HAND-FIST THUMB UNDER FOUR FINGERS",
	"SIGNWRITING HAND-FIST THUMB OVER FOUR RAISED KNUCKLES",
	"SIGNWRITING HAND-FIST",
	"SIGNWRITING HAND-FIST HEEL",
	"SIGNWRITING TOUCH SINGLE",
	"SIGNWRITING TOUCH MULTIPLE",
	"SIGNWRITING TOUCH BETWEEN",
	"SIGNWRITING GRASP SINGLE",
	"SIGNWRITING GRASP MULTIPLE",
	"SIGNWRITING GRASP BETWEEN",
	"SIGNWRITING STRIKE SINGLE",
	"SIGNWRITING STRIKE MULTIPLE",
	"SIGNWRITING STRIKE BETWEEN",
	"SIGNWRITING BRUSH SINGLE",
	"SIGNWRITING BRUSH MULTIPLE",
	"SIGNWRITING BRUSH BETWEEN",
	"SIGNWRITING RUB SINGLE",
	"SIGNWRITING RUB MULTIPLE",
	"SIGNWRITING RUB BETWEEN",
	"SIGNWRITING SURFACE SYMBOLS",
	"SIGNWRITING SURFACE BETWEEN",
	"SIGNWRITING SQUEEZE LARGE SINGLE",
	"SIGNWRITING SQUEEZE SMALL SINGLE",
	"SIGNWRITING SQUEEZE LARGE MULTIPLE",
	"SIGNWRITING SQUEEZE SMALL MULTIPLE",
	"SIGNWRITING SQUEEZE SEQUENTIAL",
	"SIGNWRITING FLICK LARGE SINGLE",
	"SIGNWRITING FLICK SMALL SINGLE",
	"SIGNWRITING FLICK LARGE MULTIPLE",
	"SIGNWRITING FLICK SMALL MULTIPLE",
	"SIGNWRITING FLICK SEQUENTIAL",
	"SIGNWRITING SQUEEZE FLICK ALTERNATING",
	"SIGNWRITING MOVEMENT-HINGE UP DOWN LARGE",
	"SIGNWRITING MOVEMENT-HINGE UP DOWN SMALL",
	"SIGNWRITING MOVEMENT-HINGE UP SEQUENTIAL",
	"SIGNWRITING MOVEMENT-HINGE DOWN SEQUENTIAL",
	"SIGNWRITING MOVEMENT-HINGE UP DOWN ALTERNATING LARGE",
	"SIGNWRITING MOVEMENT-HINGE UP DOWN ALTERNATING SMALL",
	"SIGNWRITING MOVEMENT-HINGE SIDE TO SIDE SCISSORS",
	"SIGNWRITING MOVEMENT-WALLPLANE FINGER CONTACT",
	"SIGNWRITING MOVEMENT-FLOORPLANE FINGER CONTACT",
	"SIGNWRITING MOVEMENT-WALLPLANE SINGLE STRAIGHT SMALL",
	"SIGNWRITING MOVEMENT-WALLPLANE SINGLE STRAIGHT MEDIUM",
	"SIGNWRITING MOVEMENT-WALLPLANE SINGLE STRAIGHT LARGE",
	"SIGNWRITING MOVEMENT-WALLPLANE SINGLE STRAIGHT LARGEST",
	"SIGNWRITING MOVEMENT-WALLPLANE SINGLE WRIST FLEX",
	"SIGNWRITING MOVEMENT-WALLPLANE DOUBLE STRAIGHT",
	"SIGNWRITING MOVEMENT-WALLPLANE DOUBLE WRIST FLEX",
	"SIGNWRITING MOVEMENT-WALLPLANE DOUBLE ALTERNATING",
	"SIGNWRITING MOVEMENT-WALLPLANE DOUBLE ALTERNATING WRIST FLEX",
	"SIGNWRITING MOVEMENT-WALLPLANE CROSS",
	"SIGNWRITING MOVEMENT-WALLPLANE TRIPLE STRAIGHT MOVEMENT",
	"SIGNWRITING MOVEMENT-WALLPLANE TRIPLE WRIST FLEX",
	"SIGNWRITING MOVEMENT-WALLPLANE TRIPLE ALTERNATING",
	"SIGNWRITING MOVEMENT-WALLPLANE TRIPLE ALTERNATING WRIST FLEX",
	"SIGNWRITING MOVEMENT-WALLPLANE BEND SMALL",
	"SIGNWRITING MOVEMENT-WALLPLANE BEND MEDIUM",
	"SIGNWRITING MOVEMENT-WALLPLANE BEND LARGE",
	"SIGNWRITING MOVEMENT-WALLPLANE CORNER SMALL",
	"SIGNWRITING MOVEMENT-WALLPLANE CORNER MEDIUM",
	"SIGNWRITING MOVEMENT-WALLPLANE CORNER LARGE",
	"SIGNWRITING MOVEMENT-WALLPLANE CORNER ROTATION",
	"SIGNWRITING MOVEMENT-WALLPLANE CHECK SMALL",
	"SIGNWRITING MOVEMENT-WALLPLANE CHECK MEDIUM",
	"SIGNWRITING MOVEMENT-WALLPLANE CHECK LARGE",
	"SIGNWRITING MOVEMENT-WALLPLANE BOX SMALL",
	"SIGNWRITING MOVEMENT-WALLPLANE BOX MEDIUM",
	"SIGNWRITING MOVEMENT-WALLPLANE BOX LARGE",
	"SIGNWRITING MOVEMENT-WALLPLANE ZIGZAG SMALL",
	"SIGNWRITING MOVEMENT-WALLPLANE ZIGZAG MEDIUM",
	"SIGNWRITING MOVEMENT-WALLPLANE ZIGZAG LARGE",
	"SIGNWRITING MOVEMENT-WALLPLANE PEAKS SMALL",
	"SIGNWRITING MOVEMENT-WALLPLANE PEAKS MEDIUM",
	"SIGNWRITING MOVEMENT-WALLPLANE PEAKS LARGE",
	"SIGNWRITING TRAVEL-WALLPLANE ROTATION-WALLPLANE SINGLE",
	"SIGNWRITING TRAVEL-WALLPLANE ROTATION-WALLPLANE DOUBLE",
	"SIGNWRITING TRAVEL-WALLPLANE ROTATION-WALLPLANE ALTERNATING",
	"SIGNWRITING TRAVEL-WALLPLANE ROTATION-FLOORPLANE SINGLE",
	"SIGNWRITING TRAVEL-WALLPLANE ROTATION-FLOORPLANE DOUBLE",
	"SIGNWRITING TRAVEL-WALLPLANE ROTATION-FLOORPLANE ALTERNATING",
	"SIGNWRITING TRAVEL-WALLPLANE SHAKING",
	"SIGNWRITING TRAVEL-WALLPLANE ARM SPIRAL SINGLE",
	"SIGNWRITING TRAVEL-WALLPLANE ARM SPIRAL DOUBLE",
	"SIGNWRITING TRAVEL-WALLPLANE ARM SPIRAL TRIPLE",
	"SIGNWRITING MOVEMENT-DIAGONAL AWAY SMALL",
	"SIGNWRITING MOVEMENT-DIAGONAL AWAY MEDIUM",
	"SIGNWRITING MOVEMENT-DIAGONAL AWAY LARGE",
	"SIGNWRITING MOVEMENT-DIAGONAL AWAY LARGEST",
	"SIGNWRITING MOVEMENT-DIAGONAL TOWARDS SMALL",
	"SIGNWRITING MOVEMENT-DIAGONAL TOWARDS MEDIUM",
	"SIGNWRITING MOVEMENT-DIAGONAL TOWARDS LARGE",
	"SIGNWRITING MOVEMENT-DIAGONAL TOWARDS LARGEST",
	"SIGNWRITING MOVEMENT-DIAGONAL BETWEEN AWAY SMALL",
	"SIGNWRITING MOVEMENT-DIAGONAL BETWEEN AWAY MEDIUM",
	"SIGNWRITING MOVEMENT-DIAGONAL BETWEEN AWAY LARGE",
	"SIGNWRITING MOVEMENT-DIAGONAL BETWEEN AWAY LARGEST",
	"SIGNWRITING MOVEMENT-DIAGONAL BETWEEN TOWARDS SMALL",
	"SIGNWRITING MOVEMENT-DIAGONAL BETWEEN TOWARDS MEDIUM",
	"SIGNWRITING MOVEMENT-DIAGONAL BETWEEN TOWARDS LARGE",
	"SIGNWRITING MOVEMENT-DIAGONAL BETWEEN TOWARDS LARGEST",
	"SIGNWRITING MOVEMENT-FLOORPLANE SINGLE STRAIGHT SMALL",
	"SIGNWRITING MOVEMENT-FLOORPLANE SINGLE STRAIGHT MEDIUM",
	"SIGNWRITING MOVEMENT-FLOORPLANE SINGLE STRAIGHT LARGE",
	"SIGNWRITING MOVEMENT-FLOORPLANE SINGLE STRAIGHT LARGEST",
	"SIGNWRITING MOVEMENT-FLOORPLANE SINGLE WRIST FLEX",
	"SIGNWRITING MOVEMENT-FLOORPLANE DOUBLE STRAIGHT",
	"SIGNWRITING MOVEMENT-FLOORPLANE DOUBLE WRIST FLEX",
	"SIGNWRITING MOVEMENT-FLOORPLANE DOUBLE ALTERNATING",
	"SIGNWRITING MOVEMENT-FLOORPLANE DOUBLE ALTERNATING WRIST FLEX",
	"SIGNWRITING MOVEMENT-FLOORPLANE CROSS",
	"SIGNWRITING MOVEMENT-FLOORPLANE TRIPLE STRAIGHT MOVEMENT",
	"SIGNWRITING MOVEMENT-FLOORPLANE TRIPLE WRIST FLEX",
	"SIGNWRITING MOVEMENT-FLOORPLANE TRIPLE ALTERNATING MOVEMENT",
	"SIGNWRITING MOVEMENT-FLOORPLANE TRIPLE ALTERNATING WRIST FLEX",
	"SIGNWRITING MOVEMENT-FLOORPLANE BEND",
	"SIGNWRITING MOVEMENT-FLOORPLANE CORNER SMALL",
	"SIGNWRITING MOVEMENT-FLOORPLANE CORNER MEDIUM",
	"SIGNWRITING MOVEMENT-FLOORPLANE CORNER LARGE",
	"SIGNWRITING MOVEMENT-FLOORPLANE CHECK",
	"SIGNWRITING MOVEMENT-FLOORPLANE BOX SMALL",
	"SIGNWRITING MOVEMENT-FLOORPLANE BOX MEDIUM",
	"SIGNWRITING MOVEMENT-FLOORPLANE BOX LARGE",
	"SIGNWRITING MOVEMENT-FLOORPLANE ZIGZAG SMALL",
	"SIGNWRITING MOVEMENT-FLOORPLANE ZIGZAG MEDIUM",
	"SIGNWRITING MOVEMENT-FLOORPLANE ZIGZAG LARGE",
	"SIGNWRITING MOVEMENT-FLOORPLANE PEAKS SMALL",
	"SIGNWRITING MOVEMENT-FLOORPLANE PEAKS MEDIUM",
	"SIGNWRITING MOVEMENT-FLOORPLANE PEAKS LARGE",
	"SIGNWRITING TRAVEL-FLOORPLANE ROTATION-FLOORPLANE SINGLE",
	"SIGNWRITING TRAVEL-FLOORPLANE ROTATION-FLOORPLANE DOUBLE",
	"SIGNWRITING TRAVEL-FLOORPLANE ROTATION-FLOORPLANE ALTERNATING",
	"SIGNWRITING TRAVEL-FLOORPLANE ROTATION-WALLPLANE SINGLE",
	"SIGNWRITING TRAVEL-FLOORPLANE ROTATION-WALLPLANE DOUBLE",
	"SIGNWRITING TRAVEL-FLOORPLANE ROTATION-WALLPLANE ALTERNATING",
	"SIGNWRITING TRAVEL-FLOORPLANE SHAKING",
	"SIGNWRITING MOVEMENT-WALLPLANE CURVE QUARTER SMALL",
	"SIGNWRITING MOVEMENT-WALLPLANE CURVE QUARTER MEDIUM",
	"SIGNWRITING MOVEMENT-WALLPLANE CURVE QUARTER LARGE",
	"SIGNWRITING MOVEMENT-WALLPLANE CURVE QUARTER LARGEST",
	"SIGNWRITING MOVEMENT-WALLPLANE CURVE HALF-CIRCLE SMALL",
	"SIGNWRITING MOVEMENT-WALLPLANE CURVE HALF-CIRCLE MEDIUM",
	"SIGNWRITING MOVEMENT-WALLPLANE CURVE HALF-CIRCLE LARGE",
	"SIGNWRITING MOVEMENT-WALLPLANE CURVE HALF-CIRCLE LARGEST",
	"SIGNWRITING MOVEMENT-WALLPLANE CURVE THREE-QUARTER CIRCLE SMALL",
	"SIGNWRITING MOVEMENT-WALLPLANE CURVE THREE-QUARTER CIRCLE MEDIUM",
	"SIGNWRITING MOVEMENT-WALLPLANE HUMP SMALL",
	"SIGNWRITING MOVEMENT-WALLPLANE HUMP MEDIUM",
	"SIGNWRITING MOVEMENT-WALLPLANE HUMP LARGE",
	"SIGNWRITING MOVEMENT-WALLPLANE LOOP SMALL",
	"SIGNWRITING MOVEMENT-WALLPLANE LOOP MEDIUM",
	"SIGNWRITING MOVEMENT-WALLPLANE LOOP LARGE",
	"SIGNWRITING MOVEMENT-WALLPLANE LOOP SMALL DOUBLE",
	"SIGNWRITING MOVEMENT-WALLPLANE WAVE CURVE DOUBLE SMALL",
	"SIGNWRITING MOVEMENT-WALLPLANE WAVE CURVE DOUBLE MEDIUM",
	"SIGNWRITING MOVEMENT-WALLPLANE WAVE CURVE DOUBLE LARGE",
	"SIGNWRITING MOVEMENT-WALLPLANE WAVE CURVE TRIPLE SMALL",
	"SIGNWRITING MOVEMENT-WALLPLANE WAVE CURVE TRIPLE MEDIUM",
	"SIGNWRITING MOVEMENT-WALLPLANE WAVE CURVE TRIPLE LARGE",
	"SIGNWRITING MOVEMENT-WALLPLANE CURVE THEN STRAIGHT",
	"SIGNWRITING MOVEMENT-WALLPLANE CURVED CROSS SMALL",
	"SIGNWRITING MOVEMENT-WALLPLANE CURVED CROSS MEDIUM",
	"SIGNWRITING ROTATION-WALLPLANE SINGLE",
	"SIGNWRITING ROTATION-WALLPLANE DOUBLE",
	"SIGNWRITING ROTATION-WALLPLANE ALTERNATE",
	"SIGNWRITING MOVEMENT-WALLPLANE SHAKING",
	"SIGNWRITING MOVEMENT-WALLPLANE CURVE HITTING FRONT WALL",
	"SIGNWRITING MOVEMENT-WALLPLANE HUMP HITTING FRONT WALL",
	"SIGNWRITING MOVEMENT-WALLPLANE LOOP HITTING FRONT WALL",
	"SIGNWRITING MOVEMENT-WALLPLANE WAVE HITTING FRONT WALL",
	"SIGNWRITING ROTATION-WALLPLANE SINGLE HITTING FRONT WALL",
	"SIGNWRITING ROTATION-WALLPLANE DOUBLE HITTING FRONT WALL",
	"SIGNWRITING ROTATION-WALLPLANE ALTERNATING HITTING FRONT WALL",
	"SIGNWRITING MOVEMENT-WALLPLANE CURVE HITTING CHEST",
	"SIGNWRITING MOVEMENT-WALLPLANE HUMP HITTING CHEST",
	"SIGNWRITING MOVEMENT-WALLPLANE LOOP HITTING CHEST",
	"SIGNWRITING MOVEMENT-WALLPLANE WAVE HITTING CHEST",
	"SIGNWRITING ROTATION-WALLPLANE SINGLE HITTING CHEST",
	"SIGNWRITING ROTATION-WALLPLANE DOUBLE HITTING CHEST",
	"SIGNWRITING ROTATION-WALLPLANE ALTERNATING HITTING CHEST",
	"SIGNWRITING MOVEMENT-WALLPLANE WAVE DIAGONAL PATH SMALL",
	"SIGNWRITING MOVEMENT-WALLPLANE WAVE DIAGONAL PATH MEDIUM",
	"SIGNWRITING MOVEMENT-WALLPLANE WAVE DIAGONAL PATH LARGE",
	"SIGNWRITING MOVEMENT-FLOORPLANE CURVE HITTING CEILING SMALL",
	"SIGNWRITING MOVEMENT-FLOORPLANE CURVE HITTING CEILING LARGE",
	"SIGNWRITING MOVEMENT-FLOORPLANE HUMP HITTING CEILING SMALL DOUBLE",
	"SIGNWRITING MOVEMENT-FLOORPLANE HUMP HITTING CEILING LARGE DOUBLE",
	"SIGNWRITING MOVEMENT-FLOORPLANE HUMP HITTING CEILING SMALL TRIPLE",
	"SIGNWRITING MOVEMENT-FLOORPLANE HUMP HITTING CEILING LARGE TRIPLE",
	"SIGNWRITING MOVEMENT-FLOORPLANE LOOP HITTING CEILING SMALL SINGLE",
	"SIGNWRITING MOVEMENT-FLOORPLANE LOOP HITTING CEILING LARGE SINGLE",
	"SIGNWRITING MOVEMENT-FLOORPLANE LOOP HITTING CEILING SMALL DOUBLE",
	"SIGNWRITING MOVEMENT-FLOORPLANE LOOP HITTING CEILING LARGE DOUBLE",
	"SIGNWRITING MOVEMENT-FLOORPLANE WAVE HITTING CEILING SMALL",
	"SIGNWRITING MOVEMENT-FLOORPLANE WAVE HITTING CEILING LARGE",
	"SIGNWRITING ROTATION-FLOORPLANE SINGLE HITTING CEILING",
	"SIGNWRITING ROTATION-FLOORPLANE DOUBLE HITTING CEILING",
	"SIGNWRITING ROTATION-FLOORPLANE ALTERNATING HITTING CEILING",
	"SIGNWRITING MOVEMENT-FLOORPLANE CURVE HITTING FLOOR SMALL",
	"SIGNWRITING MOVEMENT-FLOORPLANE CURVE HITTING FLOOR LARGE",
	"SIGNWRITING MOVEMENT-FLOORPLANE HUMP HITTING FLOOR SMALL DOUBLE",
	"SIGNWRITING MOVEMENT-FLOORPLANE HUMP HITTING FLOOR LARGE DOUBLE",
	"SIGNWRITING MOVEMENT-FLOORPLANE HUMP HITTING FLOOR TRIPLE SMALL TRIPLE",
	"SIGNWRITING MOVEMENT-FLOORPLANE HUMP HITTING FLOOR TRIPLE LARGE TRIPLE",
	"SIGNWRITING MOVEMENT-FLOORPLANE LOOP HITTING FLOOR SMALL SINGLE",
	"SIGNWRITING MOVEMENT-FLOORPLANE LOOP HITTING FLOOR LARGE SINGLE",
	"SIGNWRITING MOVEMENT-FLOORPLANE LOOP HITTING FLOOR SMALL DOUBLE",
	"SIGNWRITING MOVEMENT-FLOORPLANE LOOP HITTING FLOOR LARGE DOUBLE",
	"SIGNWRITING MOVEMENT-FLOORPLANE WAVE HITTING FLOOR SMALL",
	"SIGNWRITING MOVEMENT-FLOORPLANE WAVE HITTING FLOOR LARGE",
	"SIGNWRITING ROTATION-FLOORPLANE SINGLE HITTING FLOOR",
	"SIGNWRITING ROTATION-FLOORPLANE DOUBLE HITTING FLOOR",
	"SIGNWRITING ROTATION-FLOORPLANE ALTERNATING HITTING FLOOR",
	"SIGNWRITING MOVEMENT-FLOORPLANE CURVE SMALL",
	"SIGNWRITING MOVEMENT-FLOORPLANE CURVE MEDIUM",
	"SIGNWRITING MOVEMENT-FLOORPLANE CURVE LARGE",
	"SIGNWRITING MOVEMENT-FLOORPLANE CURVE LARGEST",
	"SIGNWRITING MOVEMENT-FLOORPLANE CURVE COMBINED",
	"SIGNWRITING MOVEMENT-FLOORPLANE HUMP SMALL",
	"SIGNWRITING MOVEMENT-FLOORPLANE LOOP SMALL",
	"SIGNWRITING MOVEMENT-FLOORPLANE WAVE SNAKE",
	"SIGNWRITING MOVEMENT-FLOORPLANE WAVE SMALL",
	"SIGNWRITING MOVEMENT-FLOORPLANE WAVE LARGE",
	"SIGNWRITING ROTATION-FLOORPLANE SINGLE",
	"SIGNWRITING ROTATION-FLOORPLANE DOUBLE",
	"SIGNWRITING ROTATION-FLOORPLANE ALTERNATING",
	"SIGNWRITING MOVEMENT-FLOORPLANE SHAKING PARALLEL",
	"SIGNWRITING MOVEMENT-WALLPLANE ARM CIRCLE SMALL SINGLE",
	"SIGNWRITING MOVEMENT-WALLPLANE ARM CIRCLE MEDIUM SINGLE",
	"SIGNWRITING MOVEMENT-WALLPLANE ARM CIRCLE SMALL DOUBLE",
	"SIGNWRITING MOVEMENT-WALLPLANE ARM CIRCLE MEDIUM DOUBLE",
	"SIGNWRITING MOVEMENT-FLOORPLANE ARM CIRCLE HITTING WALL SMALL SINGLE",
	"SIGNWRITING MOVEMENT-FLOORPLANE ARM CIRCLE HITTING WALL MEDIUM SINGLE",
	"SIGNWRITING MOVEMENT-FLOORPLANE ARM CIRCLE HITTING WALL LARGE SINGLE",
	"SIGNWRITING MOVEMENT-FLOORPLANE ARM CIRCLE HITTING WALL SMALL DOUBLE",
	"SIGNWRITING MOVEMENT-FLOORPLANE ARM CIRCLE HITTING WALL MEDIUM DOUBLE",
	"SIGNWRITING MOVEMENT-FLOORPLANE ARM CIRCLE HITTING WALL LARGE DOUBLE",
	"SIGNWRITING MOVEMENT-WALLPLANE WRIST CIRCLE FRONT SINGLE",
	"SIGNWRITING MOVEMENT-WALLPLANE WRIST CIRCLE FRONT DOUBLE",
	"SIGNWRITING MOVEMENT-FLOORPLANE WRIST CIRCLE HITTING WALL SINGLE",
	"SIGNWRITING MOVEMENT-FLOORPLANE WRIST CIRCLE HITTING WALL DOUBLE",
	"SIGNWRITING MOVEMENT-WALLPLANE FINGER CIRCLES SINGLE",
	"SIGNWRITING MOVEMENT-WALLPLANE FINGER CIRCLES DOUBLE",
	"SIGNWRITING MOVEMENT-FLOORPLANE FINGER CIRCLES HITTING WALL SINGLE",
	"SIGNWRITING MOVEMENT-FLOORPLANE FINGER CIRCLES HITTING WALL DOUBLE",
	"SIGNWRITING DYNAMIC ARROWHEAD SMALL",
	"SIGNWRITING DYNAMIC ARROWHEAD LARGE",
	"SIGNWRITING DYNAMIC FAST",
	"SIGNWRITING DYNAMIC SLOW",
	"SIGNWRITING DYNAMIC TENSE",
	"SIGNWRITING DYNAMIC RELAXED",
	"SIGNWRITING DYNAMIC SIMULTANEOUS",
	"SIGNWRITING DYNAMIC SIMULTANEOUS ALTERNATING",
	"SIGNWRITING DYNAMIC EVERY OTHER TIME",
	"SIGNWRITING DYNAMIC GRADUAL",
	"SIGNWRITING HEAD",
	"SIGNWRITING HEAD RIM",
	"SIGNWRITING HEAD MOVEMENT-WALLPLANE STRAIGHT",
	"SIGNWRITING HEAD MOVEMENT-WALLPLANE TILT",
	"SIGNWRITING HEAD MOVEMENT-FLOORPLANE STRAIGHT",
	"SIGNWRITING HEAD MOVEMENT-WALLPLANE CURVE",
	"SIGNWRITING HEAD MOVEMENT-FLOORPLANE CURVE",
	"SIGNWRITING HEAD MOVEMENT CIRCLE",
	"SIGNWRITING FACE DIRECTION POSITION NOSE FORWARD TILTING",
	"SIGNWRITING FACE DIRECTION POSITION NOSE UP OR DOWN",
	"SIGNWRITING FACE DIRECTION POSITION NOSE UP OR DOWN TILTING",
	"SIGNWRITING EYEBROWS STRAIGHT UP",
	"SIGNWRITING EYEBROWS STRAIGHT NEUTRAL",
	"SIGNWRITING EYEBROWS STRAIGHT DOWN",
	"SIGNWRITING DREAMY EYEBROWS NEUTRAL DOWN",
	"SIGNWRITING DREAMY EYEBROWS DOWN NEUTRAL",
	"SIGNWRITING DREAMY EYEBROWS UP NEUTRAL",
	"SIGNWRITING DREAMY EYEBROWS NEUTRAL UP",
	"SIGNWRITING FOREHEAD NEUTRAL",
	"SIGNWRITING FOREHEAD CONTACT",
	"SIGNWRITING FOREHEAD WRINKLED",
	"SIGNWRITING EYES OPEN",
	"SIGNWRITING EYES SQUEEZED",
	"SIGNWRITING EYES CLOSED",
	"SIGNWRITING EYE BLINK SINGLE",
	"SIGNWRITING EYE BLINK MULTIPLE",
	"SIGNWRITING EYES HALF OPEN",
	"SIGNWRITING EYES WIDE OPEN",
	"SIGNWRITING EYES HALF CLOSED",
	"SIGNWRITING EYES WIDENING MOVEMENT",
	"SIGNWRITING EYE WINK",
	"SIGNWRITING EYELASHES UP",
	"SIGNWRITING EYELASHES DOWN",
	"SIGNWRITING EYELASHES FLUTTERING",
	"SIGNWRITING EYEGAZE-WALLPLANE STRAIGHT",
	"SIGNWRITING EYEGAZE-WALLPLANE STRAIGHT DOUBLE",
	"SIGNWRITING EYEGAZE-WALLPLANE STRAIGHT ALTERNATING",
	"SIGNWRITING EYEGAZE-FLOORPLANE STRAIGHT",
	"SIGNWRITING EYEGAZE-FLOORPLANE STRAIGHT DOUBLE",
	"SIGNWRITING EYEGAZE-FLOORPLANE STRAIGHT ALTERNATING",
	"SIGNWRITING EYEGAZE-WALLPLANE CURVED",
	"SIGNWRITING EYEGAZE-FLOORPLANE CURVED",
	"SIGNWRITING EYEGAZE-WALLPLANE CIRCLING",
	"SIGNWRITING CHEEKS PUFFED",
	"SIGNWRITING CHEEKS NEUTRAL",
	"SIGNWRITING CHEEKS SUCKED",
	"SIGNWRITING TENSE CHEEKS HIGH",
	"SIGNWRITING TENSE CHEEKS MIDDLE",
	"SIGNWRITING TENSE CHEEKS LOW",
	"SIGNWRITING EARS",
	"SIGNWRITING NOSE NEUTRAL",
	"SIGNWRITING NOSE CONTACT",
	"SIGNWRITING NOSE WRINKLES",
	"SIGNWRITING NOSE WIGGLES",
	"SIGNWRITING AIR BLOWING OUT",
	"SIGNWRITING AIR SUCKING IN",
	"SIGNWRITING AIR BLOW SMALL ROTATIONS",
	"SIGNWRITING AIR SUCK SMALL ROTATIONS",
	"SIGNWRITING BREATH INHALE",
	"SIGNWRITING BREATH EXHALE",
	"SIGNWRITING MOUTH CLOSED NEUTRAL",
	"SIGNWRITING MOUTH CLOSED FORWARD",
	"SIGNWRITING MOUTH CLOSED CONTACT",
	"SIGNWRITING MOUTH SMILE",
	"SIGNWRITING MOUTH SMILE WRINKLED",
	"SIGNWRITING MOUTH SMILE OPEN",
	"SIGNWRITING MOUTH FROWN",
	"SIGNWRITING MOUTH FROWN WRINKLED",
	"SIGNWRITING MOUTH FROWN OPEN",
	"SIGNWRITING MOUTH OPEN CIRCLE",
	"SIGNWRITING MOUTH OPEN FORWARD",
	"SIGNWRITING MOUTH OPEN WRINKLED",
	"SIGNWRITING MOUTH OPEN OVAL",
	"SIGNWRITING MOUTH OPEN OVAL WRINKLED",
	"SIGNWRITING MOUTH OPEN OVAL YAWN",
	"SIGNWRITING MOUTH OPEN RECTANGLE",
	"SIGNWRITING MOUTH OPEN RECTANGLE WRINKLED",
	"SIGNWRITING MOUTH OPEN RECTANGLE YAWN",
	"SIGNWRITING MOUTH KISS",
	"SIGNWRITING MOUTH KISS FORWARD",
	"SIGNWRITING MOUTH KISS WRINKLED",
	"SIGNWRITING MOUTH TENSE",
	"SIGNWRITING MOUTH TENSE FORWARD",
	"SIGNWRITING MOUTH TENSE SUCKED",
	"SIGNWRITING LIPS PRESSED TOGETHER",
	"SIGNWRITING LIP LOWER OVER UPPER",
	"SIGNWRITING LIP UPPER OVER LOWER",
	"SIGNWRITING MOUTH CORNERS",
	"SIGNWRITING MOUTH WRINKLES SINGLE",
	"SIGNWRITING MOUTH WRINKLES DOUBLE",
	"SIGNWRITING TONGUE STICKING OUT FAR",
	"SIGNWRITING TONGUE LICKING LIPS",
	"SIGNWRITING TONGUE TIP BETWEEN LIPS",
	"SIGNWRITING TONGUE TIP TOUCHING INSIDE MOUTH",
	"SIGNWRITING TONGUE INSIDE MOUTH RELAXED",
	"SIGNWRITING TONGUE MOVES AGAINST CHEEK",
	"SIGNWRITING TONGUE CENTRE STICKING OUT",
	"SIGNWRITING TONGUE CENTRE INSIDE MOUTH",
	"SIGNWRITING TEETH",
	"SIGNWRITING TEETH MOVEMENT",
	"SIGNWRITING TEETH ON TONGUE",
	"SIGNWRITING TEETH ON TONGUE MOVEMENT",
	"SIGNWRITING TEETH ON LIPS",
	"SIGNWRITING TEETH ON LIPS MOVEMENT",
	"SIGNWRITING TEETH BITE LIPS",
	"SIGNWRITING MOVEMENT-WALLPLANE JAW",
	"SIGNWRITING MOVEMENT-FLOORPLANE JAW",
	"SIGNWRITING NECK",
	"SIGNWRITING HAIR",
	"SIGNWRITING EXCITEMENT",
	"SIGNWRITING SHOULDER HIP SPINE",
	"SIGNWRITING SHOULDER HIP POSITIONS",
	"SIGNWRITING WALLPLANE SHOULDER HIP MOVE",
	"SIGNWRITING FLOORPLANE SHOULDER HIP MOVE",
	"SIGNWRITING SHOULDER TILTING FROM WAIST",
	"SIGNWRITING TORSO-WALLPLANE STRAIGHT STRETCH",
	"SIGNWRITING TORSO-WALLPLANE CURVED BEND",
	"SIGNWRITING TORSO-FLOORPLANE TWISTING",
	"SIGNWRITING UPPER BODY TILTING FROM HIP JOINTS",
	"SIGNWRITING LIMB COMBINATION",
	"SIGNWRITING LIMB LENGTH-1",
	"SIGNWRITING LIMB LENGTH-2",
	"SIGNWRITING LIMB LENGTH-3",
	"SIGNWRITING LIMB LENGTH-4",
	"SIGNWRITING LIMB LENGTH-5",
	"SIGNWRITING LIMB LENGTH-6",
	"SIGNWRITING LIMB LENGTH-7",
	"SIGNWRITING FINGER",
	"SIGNWRITING LOCATION-WALLPLANE SPACE",
	"SIGNWRITING LOCATION-FLOORPLANE SPACE",
	"SIGNWRITING LOCATION HEIGHT",
	"SIGNWRITING LOCATION WIDTH",
	"SIGNWRITING LOCATION DEPTH",
	"SIGNWRITING LOCATION HEAD NECK",
	"SIGNWRITING LOCATION TORSO",
	"SIGNWRITING LOCATION LIMBS DIGITS",
	"SIGNWRITING COMMA",
	"SIGNWRITING FULL STOP",
	"SIGNWRITING SEMICOLON",
	"SIGNWRITING COLON",
	"SIGNWRITING PARENTHESIS",
	"SIGNWRITING FILL MODIFIER-2",
	"SIGNWRITING FILL MODIFIER-3",
	"SIGNWRITING FILL MODIFIER-4",
	"SIGNWRITING FILL MODIFIER-5",
	"SIGNWRITING FILL MODIFIER-6",
	"SIGNWRITING ROTATION MODIFIER-2",
	"SIGNWRITING ROTATION MODIFIER-3",
	"SIGNWRITING ROTATION MODIFIER-4",
	"SIGNWRITING ROTATION MODIFIER-5",
	"SIGNWRITING ROTATION MODIFIER-6",
	"SIGNWRITING ROTATION MODIFIER-7",
	"SIGNWRITING ROTATION MODIFIER-8",
	"SIGNWRITING ROTATION MODIFIER-9",
	"SIGNWRITING ROTATION MODIFIER-10",
	"SIGNWRITING ROTATION MODIFIER-11",
	"SIGNWRITING ROTATION MODIFIER-12",
	"SIGNWRITING ROTATION MODIFIER-13",
	"SIGNWRITING ROTATION MODIFIER-14",
	"SIGNWRITING ROTATION MODIFIER-15",
	"SIGNWRITING ROTATION MODIFIER-16",
	"LATIN SMALL LETTER FENG DIGRAPH WITH TRILL",
	"LATIN SMALL LETTER REVERSED SCRIPT G",
	"LATIN LETTER SMALL CAPITAL TURNED G",
	"LATIN SMALL LETTER REVERSED K",
	"LATIN LETTER SMALL CAPITAL L WITH BELT",
	"LATIN SMALL LETTER LEZH WITH RETROFLEX HOOK",
	"LATIN SMALL LETTER TURNED Y WITH BELT",
	"LATIN SMALL LETTER REVERSED ENG",
	"LATIN SMALL LETTER TURNED R WITH LONG LEG AND RETROFLEX HOOK",
	"LATIN SMALL LETTER T WITH HOOK AND RETROFLEX HOOK",
	"LATIN LETTER RETROFLEX CLICK WITH RETROFLEX HOOK",
	"LATIN SMALL LETTER ESH WITH DOUBLE BAR",
	"LATIN SMALL LETTER ESH WITH DOUBLE BAR AND CURL",
	"LATIN SMALL LETTER TURNED T WITH CURL",
	"LATIN LETTER INVERTED GLOTTAL STOP WITH CURL",
	"LATIN LETTER STRETCHED C WITH CURL",
	"LATIN LETTER SMALL CAPITAL TURNED K",
	"LATIN SMALL LETTER L WITH FISHHOOK",
	"LATIN SMALL LETTER DEZH DIGRAPH WITH PALATAL HOOK",
	"LATIN SMALL LETTER L WITH BELT AND PALATAL HOOK",
	"LATIN SMALL LETTER ENG WITH PALATAL HOOK",
	"LATIN SMALL LETTER TURNED R WITH PALATAL HOOK",
	"LATIN SMALL LETTER R WITH FISHHOOK AND PALATAL HOOK",
	"LATIN SMALL LETTER TESH DIGRAPH WITH PALATAL HOOK",
	"LATIN SMALL LETTER EZH WITH PALATAL HOOK",
	"LATIN SMALL LETTER DEZH DIGRAPH WITH RETROFLEX HOOK",
	"LATIN SMALL LETTER I WITH STROKE AND RETROFLEX HOOK",
	"LATIN SMALL LETTER O WITH RETROFLEX HOOK",
	"LATIN SMALL LETTER TESH DIGRAPH WITH RETROFLEX HOOK",
	"LATIN SMALL LETTER C WITH RETROFLEX HOOK",
	"LATIN SMALL LETTER S WITH CURL",
	"LATIN SMALL LETTER D WITH MID-HEIGHT LEFT HOOK",
	"LATIN SMALL LETTER L WITH MID-HEIGHT LEFT HOOK",
	"LATIN SMALL LETTER N WITH MID-HEIGHT LEFT HOOK",
	"LATIN SMALL LETTER R WITH MID-HEIGHT LEFT HOOK",
	"LATIN SMALL LETTER S WITH MID-HEIGHT LEFT HOOK",
	"LATIN SMALL LETTER T WITH MID-HEIGHT LEFT HOOK",
	"COMBINING GLAGOLITIC LETTER AZU",
	"COMBINING GLAGOLITIC LETTER BUKY",
	"COMBINING GLAGOLITIC LETTER VEDE",
	"COMBINING GLAGOLITIC LETTER GLAGOLI",
	"COMBINING GLAGOLITIC LETTER DOBRO",
	"COMBINING GLAGOLITIC LETTER YESTU",
	"COMBINING GLAGOLITIC LETTER ZHIVETE",
	"COMBINING GLAGOLITIC LETTER ZEMLJA",
	"COMBINING GLAGOLITIC LETTER IZHE",
	"COMBINING GLAGOLITIC LETTER INITIAL IZHE",
	"COMBINING GLAGOLITIC LETTER I",
	"COMBINING GLAGOLITIC LETTER DJERVI",
	"COMBINING GLAGOLITIC LETTER KAKO",
	"COMBINING GLAGOLITIC LETTER LJUDIJE",
	"COMBINING GLAGOLITIC LETTER MYSLITE",
	"COMBINING GLAGOLITIC LETTER NASHI",
	"COMBINING GLAGOLITIC LETTER ONU",
	"COMBINING GLAGOLITIC LETTER POKOJI",
	"COMBINING GLAGOLITIC LETTER RITSI",
	"COMBINING GLAGOLITIC LETTER SLOVO",
	"COMBINING GLAGOLITIC LETTER TVRIDO",
	"COMBINING GLAGOLITIC LETTER UKU",
	"COMBINING GLAGOLITIC LETTER FRITU",
	"COMBINING GLAGOLITIC LETTER HERU",
	"COMBINING GLAGOLITIC LETTER SHTA",
	"COMBINING GLAGOLITIC LETTER TSI",
	"COMBINING GLAGOLITIC LETTER CHRIVI",
	"COMBINING GLAGOLITIC LETTER SHA",
	"COMBINING GLAGOLITIC LETTER YERU",
	"COMBINING GLAGOLITIC LETTER YERI",
	"COMBINING GLAGOLITIC LETTER YATI",
	"COMBINING GLAGOLITIC LETTER YU",
	"COMBINING GLAGOLITIC LETTER SMALL YUS",
	"COMBINING GLAGOLITIC LETTER YO",
	"COMBINING GLAGOLITIC LETTER IOTATED SMALL YUS",
	"COMBINING GLAGOLITIC LETTER BIG YUS",
	"COMBINING GLAGOLITIC LETTER IOTATED BIG YUS",
	"COMBINING GLAGOLITIC LETTER FITA",
	"MODIFIER LETTER CYRILLIC SMALL A",
	"MODIFIER LETTER CYRILLIC SMALL BE",
	"MODIFIER LETTER CYRILLIC SMALL VE",
	"MODIFIER LETTER CYRILLIC SMALL GHE",
	"MODIFIER LETTER CYRILLIC SMALL DE",
	"MODIFIER LETTER CYRILLIC SMALL IE",
	"MODIFIER LETTER CYRILLIC SMALL ZHE",
	"MODIFIER LETTER CYRILLIC SMALL ZE",
	"MODIFIER LETTER CYRILLIC SMALL I",
	"MODIFIER LETTER CYRILLIC SMALL KA",
	"MODIFIER LETTER CYRILLIC SMALL EL",
	"MODIFIER LETTER CYRILLIC SMALL EM",
	"MODIFIER LETTER CYRILLIC SMALL O",
	"MODIFIER LETTER CYRILLIC SMALL PE",
	"MODIFIER LETTER CYRILLIC SMALL ER",
	"MODIFIER LETTER CYRILLIC SMALL ES",
	"MODIFIER LETTER CYRILLIC SMALL TE",
	"MODIFIER LETTER CYRILLIC SMALL U",
	"MODIFIER LETTER CYRILLIC SMALL EF",
	"MODIFIER LETTER CYRILLIC SMALL HA",
	"MODIFIER LETTER CYRILLIC SMALL TSE",
	"MODIFIER LETTER CYRILLIC SMALL CHE",
	"MODIFIER LETTER CYRILLIC SMALL SHA",
	"MODIFIER LETTER CYRILLIC SMALL YERU",
	"MODIFIER LETTER CYRILLIC SMALL E",
	"MODIFIER LETTER CYRILLIC SMALL YU",
	"MODIFIER LETTER CYRILLIC SMALL DZZE",
	"MODIFIER LETTER CYRILLIC SMALL SCHWA",
	"MODIFIER LETTER CYRILLIC SMALL BYELORUSSIAN-UKRAINIAN I",
	"MODIFIER LETTER CYRILLIC SMALL JE",
	"MODIFIER LETTER CYRILLIC SMALL BARRED O",
	"MODIFIER LETTER CYRILLIC SMALL STRAIGHT U",
	"MODIFIER LETTER CYRILLIC SMALL PALOCHKA",
	"CYRILLIC SUBSCRIPT SMALL LETTER A",
	"CYRILLIC SUBSCRIPT SMALL LETTER BE",
	"CYRILLIC SUBSCRIPT SMALL LETTER VE",
	"CYRILLIC SUBSCRIPT SMALL LETTER GHE",
	"CYRILLIC SUBSCRIPT SMALL LETTER DE",
	"CYRILLIC SUBSCRIPT SMALL LETTER IE",
	"CYRILLIC SUBSCRIPT SMALL LETTER ZHE",
	"CYRILLIC SUBSCRIPT SMALL LETTER ZE",
	"CYRILLIC SUBSCRIPT SMALL LETTER I",
	"CYRILLIC SUBSCRIPT SMALL LETTER KA",
	"CYRILLIC SUBSCRIPT SMALL LETTER EL",
	"CYRILLIC SUBSCRIPT SMALL LETTER O",
	"CYRILLIC SUBSCRIPT SMALL LETTER PE",
	"CYRILLIC SUBSCRIPT SMALL LETTER ES",
	"CYRILLIC SUBSCRIPT SMALL LETTER U",
	"CYRILLIC SUBSCRIPT SMALL LETTER EF",
	"CYRILLIC SUBSCRIPT SMALL LETTER HA",
	"CYRILLIC SUBSCRIPT SMALL LETTER TSE",
	"CYRILLIC SUBSCRIPT SMALL LETTER CHE",
	"CYRILLIC SUBSCRIPT SMALL LETTER SHA",
	"CYRILLIC SUBSCRIPT SMALL LETTER HARD SIGN",
	"CYRILLIC SUBSCRIPT SMALL LETTER YERU",
	"CYRILLIC SUBSCRIPT SMALL LETTER GHE WITH UPTURN",
	"CYRILLIC SUBSCRIPT SMALL LETTER BYELORUSSIAN-UKRAINIAN I",
	"CYRILLIC SUBSCRIPT SMALL LETTER DZE",
	"CYRILLIC SUBSCRIPT SMALL LETTER DZHE",
	"MODIFIER LETTER CYRILLIC SMALL ES WITH DESCENDER",
	"MODIFIER LETTER CYRILLIC SMALL YERU WITH BACK YER",
	"MODIFIER LETTER CYRILLIC SMALL STRAIGHT U WITH STROKE",
	"COMBINING CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I",
	"NYIAKENG PUACHUE HMONG LETTER MA",
	"NYIAKENG PUACHUE HMONG LETTER TSA",
	"NYIAKENG PUACHUE HMONG LETTER NTA",
	"NYIAKENG PUACHUE HMONG LETTER TA",
	"NYIAKENG PUACHUE HMONG LETTER HA",
	"NYIAKENG PUACHUE HMONG LETTER NA",
	"NYIAKENG PUACHUE HMONG LETTER XA",
	"NYIAKENG PUACHUE HMONG LETTER NKA",
	"NYIAKENG PUACHUE HMONG LETTER CA",
	"NYIAKENG PUACHUE HMONG LETTER LA",
	"NYIAKENG PUACHUE HMONG LETTER SA",
	"NYIAKENG PUACHUE HMONG LETTER ZA",
	"NYIAKENG PUACHUE HMONG LETTER NCA",
	"NYIAKENG PUACHUE HMONG LETTER NTSA",
	"NYIAKENG PUACHUE HMONG LETTER KA",
	"NYIAKENG PUACHUE HMONG LETTER DA",
	"NYIAKENG PUACHUE HMONG LETTER NYA",
	"NYIAKENG PUACHUE HMONG LETTER NRA",
	"NYIAKENG PUACHUE HMONG LETTER VA",
	"NYIAKENG PUACHUE HMONG LETTER NTXA",
	"NYIAKENG PUACHUE HMONG LETTER TXA",
	"NYIAKENG PUACHUE HMONG LETTER FA",