/*************************************************************************
* Copyright (C) 2002 Intel Corporation
*
* Licensed under the Apache License,  Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* 	http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law  or agreed  to  in  writing,  software
* distributed under  the License  is  distributed  on  an  "AS IS"  BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the  specific  language  governing  permissions  and
* limitations under the License.
*************************************************************************/

#ifndef IFMA_ECPRECOMP5_P256_H
#define IFMA_ECPRECOMP5_P256_H

#include <internal/ecnist/ifma_ecpoint_p256.h>

#define MUL_BASEPOINT_WIN_SIZE (5)

#define BP_WIN_SIZE  MUL_BASEPOINT_WIN_SIZE
#define BP_N_SLOTS  NUMBER_OF_DIGITS(P256_BITSIZE,BP_WIN_SIZE)
#define BP_N_ENTRY (1<<(BP_WIN_SIZE-1))

__ALIGN64 static SINGLE_P256_POINT_AFFINE ifma_ec_nistp256_bp_precomp[][BP_N_ENTRY] = {
{/* digit=0 [{1,2,3,..,}]*([2^0]*G)  */
   {{0x00030d418a9143c1,0x000c4fedb60179e7,0x00062251075ba95f,0x0005c669fb732b77,0x00008905f76b5375}, {0x0005357ce95560a8,0x00043a19e45cddf2,0x00021f3258b4ab8e,0x000d8552e88688dd,0x0000571ff18a5885}},
   {{0x00046d410ddd64df,0x0000b433827d8500,0x0001490d9aa6ae3c,0x000a3a832205038d,0x00006bb32e52dcf3}, {0x00048d361bee1a57,0x000b7b236ff82f36,0x000042dbe152cd7c,0x000a3aa9a8fb0e92,0x00008c577517a5b8}},
   {{0x0003f904eebc1272,0x0009e87d81fbffac,0x000cbbc98b027f84,0x00047e46ad77dd87,0x00006936a3fd6ff7}, {0x0005c1fc983a7ebd,0x000c3861fe1ab04c,0x0002ee98e583e47a,0x000c06a88208311a,0x00005f06a2ab587c}},
   {{0x000b50d46918dcc5,0x000d7623c17374b0,0x000100af24650a6e,0x00076abcdaacace8,0x000077362f591b01}, {0x000f24ce4cbaba68,0x00017ad6f4472d96,0x000ddd22e1762847,0x000862eb6c36dee5,0x00004b14c39cc5ab}},
   {{0x0008aaec45c61f5c,0x0009d4b9537dbe1b,0x00076c20c90ec649,0x0003c7d41cb5aad0,0x0000907960649052}, {0x0009b4ae7ba4f107,0x000f75eb882beb30,0x0007a1f6873c568e,0x000915c540a9877e,0x00003a076bb9dd1e}},
   {{0x00047373e77664a1,0x000f246cee3e4039,0x00017a3ad55ae744,0x000673c50a961a5b,0x00003074b5964213}, {0x0006220d377e44ba,0x00030dff14b593d3,0x000639f11299c2b5,0x00075f5424d44cef,0x00004c9916dea07f}},
   {{0x000354ea0173b4f1,0x0003c23c00f70746,0x00023bb082bd2021,0x000e03e43eaab50c,0x00003ba5119d3123}, {0x000d0303f5b9d4de,0x00017da67bdd2847,0x000c941956742f2f,0x0008670f933bdc77,0x0000aedd9164e240}},
   {{0x0004cd19499a78fb,0x0004bf9b345527f1,0x0002cfc6b462ab5c,0x00030cdf90f02af0,0x0000763891f62652}, {0x000a3a9532d49775,0x000d7f9eba15f59d,0x00060bbf021e3327,0x000f75c23c7b84be,0x00006ec12f2c706d}},
   {{0x0006e8f264e20e8e,0x000c79a7a84175c9,0x000c8eb00abe6bfe,0x00016a4cc09c0444,0x000005b3081d0c4e}, {0x000777aa45f33140,0x000dce5d45e31eb7,0x000b12f1a56af7be,0x000f9b2b6e019a88,0x000086659cdfd835}},
   {{0x000dbd19dc21ec8c,0x00094fcf81392c18,0x000250b4998f9868,0x00028eb37d2cd648,0x0000c61c947e4b34}, {0x000407880dd9e767,0x0000c83fbe080c2b,0x0009be5d2c43a899,0x000ab4ef7d2d6577,0x00008719a555b3b4}},
   {{0x000260a6245e4043,0x00053e7fdfe0ea7d,0x000ac1ab59de4079,0x000072eff3a4158d,0x0000e7090f1949c9}, {0x00085612b944e886,0x000e857f61c81a76,0x000ad643d250f939,0x00088dac0daa891e,0x000089300244125b}},
   {{0x0001aa7d26977684,0x00058a345a3304b7,0x00037385eabdedef,0x000155e409d29dee,0x0000ee1df780b83e}, {0x00012d91cbb5b437,0x00065a8956370cac,0x000de6d66170ed2f,0x000ac9b8228cfa8a,0x0000ff57c95c3238}},
   {{0x00025634b2ed7097,0x0009156fd30dccc4,0x0009e98110e35676,0x0007594cbcd43f55,0x000038477acc395b}, {0x0002b90c00ee17ff,0x000f842ed2e33575,0x0001f5bc16874838,0x0007968cd06422bd,0x0000bc0876ab9e7b}},
   {{0x000a35bb0cf664af,0x00068f9707e3a242,0x000832660126e48f,0x00072d2717bf54c6,0x0000aae7333ed12c}, {0x0002db7995d586b1,0x000e732237c227b5,0x00065e7dbbe29569,0x000bbbd8e4193e2a,0x000052706dc3eaa1}},
   {{0x000d8b7bc60055be,0x000d76e27e4b72bc,0x00081937003cc23e,0x000a090e337424e4,0x00002aa0e43ead3d}, {0x000524f6383c45d2,0x000422a41b2540b8,0x0008a4797d766355,0x000df444efa6de77,0x0000042170a9079a}},
   {{0x0000b650bc6fb805,0x0004effe2e6b808b,0x00083f5495882e07,0x00072385ef2f7c2c,0x00004d63c80e103b}, {0x0001bd652a23f9b6,0x0008eb0b6587f2f1,0x000580e9e3670c31,0x00021ff5c4623bb1,0x00004edf7b261efe}},
},
{/* digit=1 [{1,2,3,..,}]*([2^5]*G)  */
   {{0x000fccfc5e3a3d83,0x000c1079dfbfd8c5,0x000ad0197befd904,0x0002a48c6d6a58fe,0x0000922707799553}, {0x0003e6ddbef42f56,0x0003e80a990809e2,0x0009a2e407e449b6,0x0002a41b969c1aad,0x0000231d792f591c}},
   {{0x00096f305968b809,0x0002789f73b9db6d,0x000c61e01380a091,0x0008c6eda70b83c2,0x00005fb8394e69b3}, {0x000651280edfe2f2,0x00096faeaf829a3c,0x000424bf88f726bb,0x0009706010a4a078,0x000096720442e844}},
   {{0x0008d2333e12b701,0x000b09dd329b802b,0x000bc354d6d490a4,0x000a0d04f356cc6a,0x00001eddf7fe0a0d}, {0x0008328d87fd1d83,0x000ccd0258131e20,0x00029bca2fd2f4f8,0x000b70d3b48cc47c,0x0000f2a78b3541a2}},
   {{0x000cb817a2ad62aa,0x00090c62ff5463c5,0x000ad9db57ef2b6b,0x0006169749bba4b3,0x0000d311f2ce6d5a}, {0x0008087c2ff3b6df,0x0002467834ffb77a,0x000d6b138b46feaf,0x00018808aa266d75,0x0000a38d321dc008}},
   {{0x000fa1ae3451a09e,0x0002dc117423c04a,0x000cf56ee7cc6910,0x000a24a76be3aa51,0x00007577d588d844}, {0x000ed8cdb77f3410,0x000c23ae4a2a266f,0x000782760cfa258d,0x000d4a53a7a98cda,0x00004b48868ceaf7}},
   {{0x000affc4e6916c6d,0x0006b11842dac0f2,0x000b4d1576fb9495,0x000b8f9034bcb624,0x0000e2efdc8692ef}, {0x0007eceac793c87f,0x00058dc6fdcdd66f,0x000a1c50102f0262,0x0006efa0d3235c9a,0x00006e494971b466}},
   {{0x00036d19c0859c3e,0x0005d269386a0827,0x000a87b3389ea551,0x000236125071871a,0x00009d82f60504e8}, {0x000612442e855f5b,0x000d895e00d87834,0x000e7e62b209f50f,0x00037b1d9e03aae6,0x00004b4959f0e5be}},
   {{0x0008ffa696946fc7,0x000849cba56d486d,0x000f35a1550fbc6d,0x00062c0e3d423e90,0x0000c3da19630dd9}, {0x000fdb03cfd5d8b3,0x0002589dfca5e673,0x0002305aa0704b7c,0x000e53c6ce581ff5,0x000099d49ebc14d5}},
   {{0x000afbb10e6d9501,0x0004d2bf970a7966,0x00054ca2a37e4a4c,0x000a1013d0c8559d,0x00003d628660ee39}, {0x0003c38d3bd15e94,0x000d44a80bcc15f5,0x000d8f608014b8be,0x000feed0674c77bf,0x0000dfab987093fb}},
   {{0x0007c367b92d4531,0x0002149a26c024c9,0x000d14a39d2c271a,0x00000550eb4b2b89,0x0000198de20532e8}, {0x000ea75799b80d93,0x000b5f826ae59eab,0x0000061ecab6e0c2,0x000fd89a004eedd1,0x00001a9f43a199c4}},
   {{0x0008b75b5498a7c3,0x0009f9f64c2d734c,0x0005b1677aeccad8,0x00096865dd54fa29,0x000083902a0e4c54}, {0x000276feb9d33a9f,0x0000bf55286978cb,0x0005c163000aedca,0x00050cb01d14594c,0x0000eba17076cf7d}},
   {{0x000496d6ec293cde,0x0006ae7051f5380a,0x00049140a733dbda,0x000bf5237e388db8,0x0000e4b32b13946d}, {0x000fda9cae368d14,0x0000bdb0b2f3b1c4,0x0003ac46e5001a7b,0x0006562df593742e,0x0000af675f279b3e}},
   {{0x000ffdcc01b0a469,0x000ef3f843c21a1f,0x00038e81a07ad675,0x000da82cec2d0767,0x000010aec763a8b7}, {0x000d740a4509ba71,0x00033c7b821613b4,0x00091f1e50570107,0x000d902d75c8f715,0x000034c1b6f1dfe1}},
   {{0x0007c44d67826eb7,0x000f3c379637b20e,0x000e03a5d1212d3c,0x000a25f14f67877d,0x0000538a2fcf02ba}, {0x00037a19d252415f,0x000f7eb4b587133c,0x00049d1d97db3904,0x0004b96d40d7574c,0x00001126b9a9801c}},
   {{0x000aeb9c56729fc9,0x000857a8bd8539a7,0x0009d10c621a5944,0x000afb47c6da5d04,0x00003a4c4a955197}, {0x000539c259338612,0x000a07494d9dd185,0x000e7bfa94994bcb,0x000236cf033de14c,0x00002e9b000521f9}},
   {{0x0008110399492969,0x000aa61db1b544e3,0x0006eaff55b63827,0x00028fae5323ed20,0x000042370d3521f4}, {0x000af2ee0d985a17,0x000b0239846df2ca,0x0006312f8192cc64,0x0001080c0b8f47ae,0x0000dc61f9206620}},
},
{/* digit=2 [{1,2,3,..,}]*([2^10]*G)  */
   {{0x00081e144cc3adda,0x0005e7be82cf4f70,0x000dd6472d5ffa1d,0x000862e9890b6c0e,0x0000da26e1aded17}, {0x000271563483caaf,0x00083f6077fd276f,0x000466e3ce6924cd,0x000d1e15a7fe980a,0x00001c794b1a1902}},
   {{0x00024b9eb7926b83,0x00039dbe55093d2b,0x000dd640bbff88cb,0x000d45a0f399afe4,0x0000c5fe1305f76e}, {0x00062f43764fb3df,0x00074151b62d6f35,0x0009ce5f37b5af31,0x00090ee5bd0bc7d7,0x0000daf6b21dc668}},
   {{0x0007fe891e5d7d3f,0x000683a076783202,0x000dfdd61f14b7d1,0x000f48088497b3c0,0x00007c2eec11a8c4}, {0x00073f43756e621a,0x000f7825b948aa55,0x000878572c013a23,0x0001837c03b34563,0x00000472beb053a4}},
   {{0x000b0e5ab4b35a24,0x0001b5eeaacf6772,0x0005b95801d8b600,0x0001da328f7ce479,0x0000a20ed2a81fb8}, {0x0005cd44fec01e63,0x000c77ff50ad9f68,0x0002d97fd3ed7ddc,0x0004f9160fd2640c,0x0000a2414271b82f}},
   {{0x0002cf983dfedc91,0x00047d87631a29ae,0x00029c8d2f843713,0x0002729f57171174,0x00008d15867246d9}, {0x0003ecf69769bb7a,0x00062479ab828305,0x000b0f4b2c55eb85,0x000524bef7791c21,0x0000a5956badd491}},
   {{0x000bfa1c5c5ea50e,0x000b8796068184cf,0x000d50942d3baf14,0x000662463984030d,0x00004b7839d2716a}, {0x000f794e7de6dc08,0x0003e22aa7ced5f1,0x000acfeec5cd0f4d,0x000606d295f3f159,0x0000d933553153e0}},
   {{0x000533b3cef0d7d8,0x0007abbb4381e652,0x00080f500d94f7b1,0x000bfb038752be0e,0x0000e6e24891e9c9}, {0x000169716caca6a2,0x000818531ad9c975,0x00051ade1866c49d,0x000407a917e23971,0x0000d016ec18037c}},
   {{0x0009862d5d721d5b,0x0002abd3a1828000,0x000a2cda40c3357a,0x00008477f3a83b7a,0x000058ae74fa6f83}, {0x0001a812e6dad6be,0x0001143d6c5b2a91,0x00096c4d8de28605,0x00024d6bdccc41f9,0x00007312ec0eae1e}},
   {{0x0006e3960e913af1,0x000e88bf140d903f,0x0004890b8b2b58be,0x00024e8deff02535,0x000055810069d2e9}, {0x0005db493c95e5ba,0x00003ae20eb8b575,0x000b6d8e03fac42f,0x000efef377c8c109,0x000043e2b474b47c}},
   {{0x000b2fbfacfa4591,0x0008b1b5aa6b5f57,0x000db2092874b149,0x0001daa9e89acac4,0x0000362bf8def438}, {0x0006830b76328a07,0x000028572ae425d7,0x000132f7d38188b7,0x0002c9443e941429,0x0000895a29f92dd4}},
   {{0x00078dd5e22cbb29,0x000ae6bb4391cbde,0x000a4273bf449c85,0x000a18b289f357b6,0x0000fce23fdd8e84}, {0x0002730939eb3b47,0x000ba6c32280cfc3,0x000f1346c8b3d982,0x000fc8eac234bad5,0x000081954b4e0769}},
   {{0x00068feaae6ee702,0x00053602b0c96faf,0x00094052a78f4cc1,0x000d805e3321a86e,0x0000fb3a0d6934d5}, {0x0008f3bb25a43ba1,0x000109ee2951f3b9,0x000b0612a30bf803,0x0001d06ffee43321,0x00002f775e43eb82}},
   {{0x000f805f57209b51,0x0003e952ac8d4fdf,0x000969a6f9bd65ac,0x00075ef2a3abd3c7,0x0000359927f05237}, {0x000463f88d2e8610,0x0009623287c3e09b,0x00070eb7a661d219,0x000684821e64495a,0x0000afbbb1dd67dc}},
   {{0x000e3d3acff89f9f,0x000de852251f7418,0x00084658b227f16a,0x000f7ded5bc6e4eb,0x0000066b9c9e90a9}, {0x0009071800a7f873,0x000d2a72862ac236,0x000776da5383ddc0,0x0003182b48465d8a,0x0000d82f64f8e2d8}},
   {{0x000104b87453b283,0x00088387344d5852,0x0007cfc08073e812,0x000088000e78e481,0x0000a82ed47c9362}, {0x000304c88de46a44,0x000d17fadf4ae222,0x000c8e108666c94f,0x0000fa00b2d08ea0,0x0000b2955b949e05}},
   {{0x00012e76e6485b37,0x000b071c52f8f8d1,0x0004a2f6d4d3e24d,0x000550d8e3ee4168,0x0000161957d91d95}, {0x0001283cdb12a6c3,0x0001fe50e1641963,0x00066cc73bf3fa88,0x000c38c6254b6331,0x0000aefa7aedee8c}},
},
{/* digit=3 [{1,2,3,..,}]*([2^15]*G)  */
   {{0x000fe623b36f9fd2,0x0003dde19fc079b0,0x0008482ef26543b2,0x000824f36e64a095,0x00003f63771bb095}, {0x000d596b6a1142e5,0x0005e35aac0b14cf,0x000081dd55ea6aac,0x00012a36a0e8bdf3,0x0000fb89d79503dc}},
   {{0x00065fce3779ee34,0x000d7d495d9e0f01,0x000284e7ae00e7f9,0x000218dfa4efa220,0x0000564bade87ac6}, {0x000312ac4708e8e4,0x000b671e9adf90e6,0x000684b9f4f5725f,0x000415a95f55ae3d,0x00007f7ccb15e94b}},
   {{0x00077e5522e6b693,0x00038bcd6c18da3a,0x00024fd5669c908c,0x0003f6ef1b9e48d9,0x00007c64e36da4bb}, {0x000dbdfee478d7d1,0x000bf193f7a05a4f,0x000cd16dfba75c8b,0x00015174bc1e8456,0x0000fb08f0856fad}},
   {{0x000890361a341c13,0x000fdcfd61423617,0x00033316c3604dc5,0x000921d22295eb85,0x0000dbde4ac74af2}, {0x000fc5d1c7eef696,0x0005714f4fa1898a,0x0003c21ca5889680,0x00030aa500216020,0x0000f0d1f30a0ef7}},
   {{0x0001b4b12cfe2978,0x000ba92f74e54820,0x000e874e83eee129,0x000c4161fe114ec9,0x000099b055d12c5f}, {0x0007a643a39c8cf8,0x000df8963cc94e47,0x00033f86382f09ef,0x000c62efd3fd8fd3,0x00005132b2b5c949}},
   {{0x0008b1dbe7a2af37,0x0008dfb74a72bd9b,0x000879697ec51caa,0x0007d549937a4b63,0x0000c9a9d215c268}, {0x000e44f6ef5f0145,0x0002990c69001773,0x00042161e8abcf41,0x000f29e87bd02281,0x000003937564cb6f}},
   {{0x000072232398baaa,0x0001bcfca031766e,0x000029cf2205fee4,0x00090d049f53417a,0x000088c68b8e0238}, {0x00050417337aaa82,0x000ceeb384f4bc27,0x000aba92f9ed364a,0x000a88c0816f8529,0x0000e9e194124e38}},
   {{0x000770977f7195ad,0x0006ddeb838ffabf,0x0004f012d8ec8616,0x000b3f1a1285a8bb,0x000068835046a3ea}, {0x00024f8309004c28,0x000593ffe95eee5d,0x000223ea4a96e4b7,0x000a528cdffe12bd,0x0000f5c2ee636739}},
   {{0x000e1dda1887395c,0x0005d32a65deecac,0x000a9552940960f3,0x000a35d611ff5c3a,0x000058215b13c1e5}, {0x0009b58f0e1a5240,0x000bf590dfb8d48c,0x000d95662b406856,0x000f82c7605e049c,0x0000dd036eea33ec}},
   {{0x000333959145a65f,0x00080a4063373d61,0x0008a52a0cd9bc36,0x00058f92d11be32d,0x00006877b2887a1c}, {0x000819bf5cbdb258,0x00085e090249837a,0x000990e5f2a4fd1d,0x00011ae22a7de774,0x000040fa5a0f9455}},
   {{0x00093277946d3f97,0x000397472273fe28,0x000b6ae86e132bd2,0x0000677eeb510c1e,0x000077708c660595}, {0x000c8cd1297029e8,0x000c3bf9305e18e2,0x00085d6d92c61095,0x0005306466c2586b,0x0000ac06c375a1ea}},
   {{0x00090b36b0cf82eb,0x00057615b5e7e58e,0x0009c145a6438d24,0x0001ca57b1f8fc66,0x00000d8b2dae6f1e}, {0x000dadbd9184c4d2,0x0005d93d997654d5,0x000147d473dbb18d,0x000608ea3e0f56d1,0x0000afa8c8dc0a48}},
   {{0x00039ad653ae3263,0x000a774cbb438712,0x000d4c08314bcf72,0x0004af5737650e20,0x0000df86536410ed}, {0x0006fe7b53ca5557,0x000d3bd5d538d2d8,0x000d38468688cb00,0x0007b65f81bda31a,0x0000ccfe3cd60116}},
   {{0x0008c07e3533d77b,0x00097e341c9926e0,0x0002dc4edd7222e6,0x000cf7ed60ec3d8d,0x0000dfe0d902c476}, {0x0009ab61d056605f,0x000596a8551f1fe5,0x000fb8d8ca9ea9df,0x000b0f9489941e47,0x0000eb874ec3a7f1}},
   {{0x000181060a716760,0x0008f66a8ad161fc,0x00017231ee852d1a,0x00011f172bbd6564,0x0000d6de7bd3babb}, {0x0006f88c8e347f89,0x00070bd99cc36fde,0x0000769501c58754,0x0003b9e8e54ed034,0x00007f0f335096e8}},
   {{0x0006aa9bd7638026,0x000005303da1ed40,0x000e62ec4c21486a,0x00033e01ae291ec7,0x000022a04933f993}, {0x0000c9dbb7a8ee0d,0x000b9c01aedb7fd8,0x000be74ecdc2ed3b,0x00071e65c35a1208,0x0000540cb1b169f6}},
},
{/* digit=4 [{1,2,3,..,}]*([2^20]*G)  */
   {{0x000746a584c5e205,0x000169dc7035a7a8,0x000548c9b267e4ea,0x0002f3093a15cfb9,0x0000e6e21359bd01}, {0x000cc6a8c8f936e6,0x000455c241dcdf31,0x0005efb868af84d0,0x0002cb03990a6f34,0x0000fef4e6219b96}},
   {{0x0008f09257226088,0x000a931cf5c6f636,0x000b4f7ac131260d,0x000828c0eb353bfa,0x00005c78880b7eee}, {0x00081ffc3bdf24eb,0x000b45c3c5a84c15,0x0004e6f405bff75c,0x0000c985e8c83fa1,0x000081d1c0fb295e}},
   {{0x000e23d442a8ad11,0x000cf6b9c164f2ef,0x0000aa5e5c3816a7,0x000e6599df2d8bdc,0x000091ae46f220a8}, {0x0007f8700611c5bf,0x00070f1099488366,0x00069595283171ed,0x000a1243a2ecf8ca,0x0000a4a73efe48d1}},
   {{0x0007cc8f43a730f8,0x000bb3ab590efcde,0x00003240be89b6f3,0x0005db4823f529ad,0x00002b79aff18bea}, {0x0002856962fe5de3,0x000b30c591f3568f,0x00028a8580c590ad,0x000f4befc74a144a,0x0000b662498e3203}},
   {{0x0004ed082dd1b6ad,0x000797b703af48fc,0x0005d6aaa5783a13,0x000d425463cb9a00,0x000031ec55d406ec}, {0x000d33f8e9a76414,0x000cc98d9e7a9f8e,0x000887493625453e,0x00056663beade4ec,0x000042b80509a795}},
   {{0x000cf0d6c39765a2,0x000d8c3cca0b91e3,0x000953b50a2db3ac,0x000f1a088f2f08cb,0x0000414582cef43c}, {0x0008bbc60eee9a8a,0x0001d29aa0428dec,0x00032f5d554c79f0,0x00015f381cd5ec65,0x0000672303b6f82e}},
   {{0x000582d3bfab839b,0x00037f8adade46df,0x0007a1bc392474e0,0x00097886a7766a14,0x00006940f54bdc0f}, {0x0008ef2f2759f255,0x00095719f4c64473,0x00050c3459dd9578,0x0000d4d859b7f407,0x0000e788bf302218}},
   {{0x000afa8719c05631,0x000cac5fc79f376a,0x000750cd3cd8ad2d,0x00008e203fdb9fcb,0x00004ff052f5418b}, {0x00084cf3e2d65208,0x0007944ed509f750,0x000f25b987ebdf0f,0x000837743bf0f2d3,0x00006ad71d02354d}},
   {{0x000c9fdfd67ca259,0x0007d0f2015ca839,0x0007b2a65023e626,0x000cba9414a7930e,0x00002dbe373413ed}, {0x00081ee64c2200f7,0x000f1446f2f3f649,0x0001367bb94fb9cd,0x00033091411a6a3f,0x0000985c191ca1e8}},
   {{0x000fe9226f435728,0x000add824758b827,0x0009094c1dfd3ab5,0x000d67b15dd23a53,0x00005c0e37ae6623}, {0x00079727be19ae06,0x00067f0d36b5575c,0x000b1ff7e616a339,0x00045341ebb3c826,0x000035b9485740ad}},
   {{0x0003c6037e2efeaf,0x0001134a96f6c812,0x0003e4a958d49b50,0x0000fe566a346b97,0x0000176b5bba7de0}, {0x000fa3b82dfa945b,0x000559e429ae1c58,0x0002b187c2eb27a9,0x000bb9a7c67a67a1,0x0000155ba8392298}},
   {{0x0003cdada430c0b9,0x000daa96dac692bf,0x000ac326a4702850,0x0005e4391cf0a515,0x00005de4f4a3b8c2}, {0x000ad09e265c17ce,0x0003287b3881b01b,0x000fac5ca24e4546,0x0007a5f43e583ce1,0x000017cb3194ead9}},
   {{0x00042073d99bcfab,0x000c38becf6df1a5,0x00045956959db703,0x00090f7e455142d2,0x00000ee51445901b}, {0x000d451e26d994fa,0x00037360caaffc05,0x000a639b17a6062b,0x0008b03f1ded5f4f,0x0000f9303497335b}},
   {{0x000924374dcec468,0x000cd4c2b73f6cc3,0x0006cd99c33cfc02,0x000f8902917844f2,0x0000819dd9651773}, {0x0002aa60871f4274,0x0005b6f01c340957,0x000f1f5af8e0cf36,0x000e503fa52988bf,0x0000eb357eb275e8}},
   {{0x000248a21fd08616,0x00043bd5a4b63d8f,0x000e2a6bfade3bd6,0x000c5f6b56c953c2,0x000099cd2b5887d6}, {0x000e1be47d05e8f9,0x000318f53732debc,0x000852b081a4fbb1,0x00087a07163beaa5,0x00002c49e6d7ec69}},
   {{0x000c8c4868af75df,0x000e55c8c7ead9d0,0x00081ecb0d7325cf,0x0004ecbb471996cc,0x0000f5d55f451182}, {0x00045411977a0ee8,0x0004f22038c6be31,0x0004bb4955085c4c,0x000081ad5335bff9,0x000094ad8a748e2a}},
},
{/* digit=5 [{1,2,3,..,}]*([2^25]*G)  */
   {{0x00034b22c11bb373,0x000dbd4c74a35402,0x000c5f25d2d0366d,0x000142c9a968daee,0x0000660106897b63}, {0x0006d2c68d7b6d44,0x0008cc84294207cd,0x00068b1eea8f74f0,0x000ee4a275140477,0x0000b5f7e8a3e62a}},
   {{0x0009f0b879fbbed4,0x00069a9d1869f236,0x000766f450ff0ae8,0x0000fc1251d75956,0x0000984d8c06be8d}, {0x00095a6d21008f03,0x00000a1a1c497ecc,0x0006c50f329bd54a,0x0002517b9828c5d2,0x00002c0087c81d0d}},
   {{0x000eb6662b5f3af3,0x0000dabb373447fe,0x000f35cb1cefab56,0x000eb9149de60e19,0x00009f8db14457f0}, {0x000cc5b3c61bfd60,0x000d41216703ffae,0x0004e1cc2a5a4d41,0x0009537f8fabed22,0x0000d5a8186871ad}},
   {{0x0008ea601799a527,0x0001486d2952190d,0x000ff2a7ca20cec4,0x000d36c062ffb27f,0x000041b32e5e9f19}, {0x00081814eb57d471,0x000406aef06bf80d,0x000ecb5887a2d0ed,0x000f5af9735fb01c,0x0000641caaad6061}},
   {{0x000d171656e8c3aa,0x00027acd0705ae2a,0x000b6055cc0e2a46,0x00026d606f6a8aa0,0x0000f4513d7cb65a}, {0x0009e14d616d5bcb,0x0004c1253b1f3f54,0x000ce243a64ee395,0x000e7738b10bc1b8,0x0000cbeace6413a4}},
   {{0x0002256f779d6a77,0x000ca9e7284e68d3,0x000f3b15320423b4,0x0007036e19aa1b38,0x00003d0b6c2f444f}, {0x00061489c64e6a37,0x0006c72562246661,0x00033156399587c3,0x00002dff5277fe61,0x0000174ad4b16565}},
   {{0x000fc920133918d8,0x000e32c9ef97ec1f,0x0006cbb9a15d9bf5,0x000f5cf885b542fc,0x0000abe6453d720c}, {0x0005dced4ec68aba,0x0003879c24a34e71,0x000bb61cf57a6761,0x000002d88ed52a31,0x0000ba824459437a}},
   {{0x000824f20151427a,0x0005f24302067f99,0x000112357206828b,0x0004ec0a9097d7e1,0x0000cf9a2f2a9e41}, {0x000c9da279153564,0x0006c01efee3dbda,0x000b288e27e0734b,0x00009c14fab5bbd2,0x0000c630fc5362dd}},
   {{0x0003e66bd70a5e18,0x0001505de7136d88,0x000d8487d9bd884c,0x000404c8d9d445d4,0x0000440cd8b8eeae}, {0x0000f293d26f83eb,0x000f72a3c5e4a3cd,0x000fa2ca73fd9452,0x000096b3a078663f,0x0000feadd29b0d4a}},
   {{0x000a559d68432ba6,0x000b733915db13ae,0x000e8da08940043f,0x0005bae76c7c94e2,0x0000b1630c4a4306}, {0x000546d19f06c75d,0x00015eb35abdd6d8,0x000157d8e7e1e98c,0x000074a51c9310f0,0x0000ef84328c6fa6}},
   {{0x000993c3a7a4e0e9,0x000f0d79d314765b,0x00019eb24fb8f4ae,0x000c8bcea2c50e2a,0x000025016e64891b}, {0x000afdc3ad1ece76,0x000c908fabe28f70,0x000f6132b0abba84,0x000d76aa9922c815,0x0000c021373bd076}},
   {{0x0002615a44539610,0x000b993d112c00af,0x000cdd6521705494,0x000cb30032e12aa1,0x0000ebfa612046d9}, {0x000a9f31b63728c8,0x00025e022b059f03,0x00077c5c98f3618a,0x00077c55b24d903e,0x000037838a3f2acb}},
   {{0x000cbd98fceb0471,0x00052f8b11a1fe65,0x000ec802fde872ef,0x00081d8aba0d3d8f,0x000039f1d32aa9f3}, {0x000aed9c587958d1,0x000ca9f6a7da0721,0x0005d9d06066a015,0x000a1ef59ec4e3ed,0x000044285717cbac}},
   {{0x0000fffe298cdf56,0x00041b2e51b666fe,0x000d3afa43f61bea,0x000e2f1d372117ba,0x0000521a09d4f656}, {0x000c966e8a58fe76,0x0000fa47ebc7b3b8,0x0004be57325203a1,0x00003c9e81588d5c,0x0000132e2f37f49a}},
   {{0x000b0130f8c2c991,0x000fe17725c2ec1a,0x0000a980b60e8968,0x000cb1d1a4a59394,0x00005ed15b030e9c}, {0x00054cc64a00bec8,0x0002c168738277d7,0x0001fb65190d09c3,0x000e52a94fe02dc3,0x0000372cd1a9c94a}},
   {{0x000107a1ac2703b2,0x00084bc857b58537,0x000daccd1b49258d,0x00052937df14debc,0x00004ab68d7e4ae8}, {0x000b5d4734e59d08,0x00084495cc807ed8,0x0001db9b35f8740c,0x0005be04aedd5a29,0x00000b360f8cfb99}},
},
{/* digit=6 [{1,2,3,..,}]*([2^30]*G)  */
   {{0x000c68da61a76fa3,0x000d9a1554dc55d5,0x0003b279c598b441,0x000efca39923b977,0x00003331d3c66bf9}, {0x000848e298de399d,0x0006d1a27f562d4c,0x000b8ab70cfdb8e7,0x0009b9c4c855ea57,0x0000cdb9daf3f787}},
   {{0x00007367f636a38c,0x00064e76d5cb4c4f,0x000b68b8b9f943fb,0x000a1ef03510baa8,0x0000246780b5ed07}, {0x00014156d549fc2b,0x0000b07781ca3c05,0x000d95413c2953f3,0x0002e2e55e2c69d8,0x0000300fadd2bd28}},
   {{0x0001163c27901b4b,0x000fd99b8bf3a14b,0x000c6da0afd9236d,0x00029692b091eccb,0x0000b1dac700ad1d}, {0x0001d53a91cf76e1,0x0002c31f1ee780e6,0x000efcf774110a41,0x000d761d87c3ba13,0x0000f374bb4ef450}},
   {{0x00086024147519ad,0x000b56b372f02028,0x00085ebc8d0981ea,0x0008e8d9d4a7caa7,0x0000953c50eabdf5}, {0x00061ccfd590f8f8,0x000ac4e6c9179d63,0x000eb64cf72e9626,0x0008f2ffd9611022,0x000063ebb7f1eb28}},
   {{0x0000a0a097e4403b,0x00056985466515e1,0x0007d4826cb3d0a8,0x000838d8d8e211d6,0x000039af66ebb9d2}, {0x0004588bd475ca8d,0x0005f077b80ba5f9,0x00027c26ce06b796,0x0005e02edb1485da,0x0000290d33bce0fd}},
   {{0x00002f31306583d2,0x0000237c622e6862,0x0006a7bc805b10da,0x000e439f9aaa0f07,0x00005e94efbaf8f4}, {0x000c9b7fa3dc26dc,0x0002d6ff03c58a35,0x000c394cee0e5fb9,0x000e5fe77e3843eb,0x0000ede65964361d}},
   {{0x00075090c22b5403,0x000a87c267d4bf90,0x000b0d6932cde42a,0x0000d98a18f9ed5a,0x0000ba62aa69e466}, {0x000f97bab9ea96a6,0x000283b60e32b24b,0x0004d9bd55d03964,0x0006a3ee6a45067c,0x000066c5b9eded4a}},
   {{0x0007cf5678a31b0f,0x000d4998b620877b,0x0000fb396d50301a,0x0002a5834257c5c0,0x00009fb18a0f4e67}, {0x000d8ebe8758851b,0x0005ad99ba44ff8b,0x000fd93b71e64e4c,0x000b8b9b8eaedf7d,0x0000a2f2a98b4e76}},
   {{0x000a2f09b56ddbdb,0x000bda2f1cf3ae02,0x0009dff0d1339b5a,0x00043d42b569c783,0x00000b9e865aee9a}, {0x000ca4177bb064e9,0x00026d249f634ff8,0x0006f689a145a281,0x000f5daab7beacf8,0x0000bafec2791d35}},
   {{0x0003fddae57c7b7a,0x00017b932522bba2,0x0006d4aa3345342f,0x000b615d9c80fe55,0x000003907bb0525b}, {0x00010e1ff2189336,0x00044a52117b38b0,0x000f2e6eac066b65,0x0002b22e14192094,0x00006a27dca6d32f}},
   {{0x000b121fbabbe926,0x000b81330076b2e6,0x000890015281850f,0x0007f4a93581ec97,0x00009b1ddedd5ff7}, {0x000b18fab1051053,0x0001789ccfef7cf0,0x000914009953ced3,0x0008ad0151f85feb,0x0000c9f1b87b8ed4}},
   {{0x00007e0e90fb21e5,0x00006ba7fca1a18f,0x000cd67b500fd2b8,0x0007f6d0387f2795,0x0000b89a4e823970}, {0x000ad3f894407ce5,0x00041c2261328f83,0x00006c13ba0025b9,0x000025779563c7f9,0x0000f548f319e7bb}},
   {{0x00089494fde0c1fc,0x000e25b6ec20ff75,0x000e1db6cbf8a1ab,0x00058eb02278fb87,0x0000447ad7af5ed6}, {0x000aa3803d0ccf24,0x0008419a7c0348d4,0x00017cecc80acb33,0x000d825bc7c89e6e,0x00006736b8b43be1}},
   {{0x000f742d43b5eaaa,0x00063fa59b852126,0x0006bfd45054a076,0x000a8efd0d5e3612,0x00001f8fbd7d84f8}, {0x00080f5d563fccc1,0x0005e280a9283176,0x000b578cf48ca505,0x000514d00b81b227,0x00000aad9183994a}},
   {{0x000301f358bcdc04,0x0008ca9d47f8e63f,0x00043d43a07689e9,0x000903df689e2f4f,0x0000d542a16d0920}, {0x00093d59ca0a7072,0x00056ac68065aea2,0x00090008cd061fe4,0x000db5f033bf1b00,0x00009749558e08a6}},
   {{0x000d3a7c35d87949,0x00077356bae50ee6,0x0003322fd042e655,0x0009670f59698d64,0x0000379ae15e0a61}, {0x000ae62fcc9981ea,0x0000cd2934c664b9,0x0004e65ebaed3d63,0x0004278454b3025e,0x0000b09f64899950}},
},
{/* digit=7 [{1,2,3,..,}]*([2^35]*G)  */
   {{0x0003a1222248acc7,0x000ec264e366b208,0x000fdee281f6ec0e,0x000bb4e659b7045a,0x0000a823a4156430}, {0x0002a04e1900a791,0x000ab9ee65762459,0x0005ea54acde09d4,0x0005a742b6463f4b,0x0000efe9ed3e3ca6}},
   {{0x0006dbe305406dd9,0x000f4d5d1957e27a,0x0007d4d8f8eb7dc7,0x000de4654a687638,0x0000c47940a57762}, {0x0005b5d99b307781,0x00065e793682be4d,0x000c740e325380c5,0x0004ae502d37f3da,0x000040deabe2566e}},
   {{0x000d067afd32acfd,0x000a11f71ccf4481,0x00096f2dad8f0fcc,0x0003f90208dd0cb5,0x0000049d7316aad9}, {0x000263d42ab580e7,0x0000b3f707b4c79f,0x0005e0eda09411bb,0x0004021cfde1ff83,0x0000270749100f03}},
   {{0x0006126c49a861ec,0x0005214f0d06eaee,0x0009bfc17024f3b6,0x00038091a3f1e8c6,0x00003c3a8ea67686}, {0x000752cb103d4c8d,0x0002c218b36b3400,0x00051504a02bc461,0x000bf9f67f75eb76,0x00006848b57a02ae}},
   {{0x00002e6c30fa92bf,0x000caa552784bd98,0x00083169b5a70d96,0x000227a085c4ea3f,0x0000a9423bbf6908}, {0x000be12fe97a5b9f,0x000881b991182ffe,0x00017884685da604,0x00018dacbc2f7f63,0x0000d96bc7181532}},
   {{0x00081db1782269b6,0x0008c597e5509583,0x000385153ae34bf7,0x0000485b5c60645f,0x0000f0e96b043088}, {0x000021577884456e,0x000b89310ea7bf6a,0x000fad2deb3b5688,0x000d4c37c9429504,0x0000020f0e5f7896}},
   {{0x000a0ab0976505f7,0x0002995e2ec5730b,0x00031ab71567f681,0x000b9ed706201063,0x00002cfa977b1d22}, {0x0005ead8a2373da8,0x0003fba45a6833e5,0x000029d15a8d0d5f,0x0009f33a1d8f9c03,0x0000f34f1cd7c55b}},
   {{0x000428dbbe5a1a9a,0x000e9126bd67cca4,0x0001058268187fd5,0x00019f6036973a48,0x000039b666458bd6}, {0x000deef2d65a8087,0x000f24636b196d42,0x0005d564c4969044,0x0000778611ee47dd,0x0000b2f3a4a42873}},
   {{0x0007d45300eb294a,0x000d769c14949415,0x000a47aa92b2a656,0x000ea42000dd76d3,0x00002864e5046243}, {0x0006c47db89842e4,0x000721479fb78271,0x000b2f6dc12dfd7d,0x000d66fb9a2c56e0,0x00006be862b17f85}},
   {{0x000d8dd0f82b2148,0x00097103cbc603b0,0x000d79e19460c34f,0x0007f8732e5c0318,0x0000b8888bb28411}, {0x00037dcc07226779,0x00088c1c0f278f3c,0x000f7a0c610d21be,0x0000e0447c8468e0,0x0000bf022143decc}},
   {{0x0007d1242b48b998,0x000cc84240960baa,0x000fb5cfb1bcb665,0x00010d0b847cd6eb,0x00007c2ae571ad4d}, {0x000b1220de367261,0x00082fdfbd21f1cb,0x00079d460e7043c6,0x0002cb3bd0826a4e,0x00001f5e5985bd1a}},
   {{0x0004160b7fe7b6e0,0x000a400a3fb29755,0x00028ca1e7d16189,0x0008ccd73e9beae3,0x0000dd04b97e793d}, {0x0003c9b506db8cc0,0x000ecf38814ca9c8,0x0004b45e65cd47aa,0x000a8426fc430db6,0x000079b5499d818e}},
   {{0x0001102c1c24a3b9,0x00078c161c1aebb0,0x000f00a4aca24e56,0x000c7a803eea6936,0x0000ad76ee906176}, {0x0001fc2538e0ff72,0x00094604b3b09745,0x00049cfd794f8980,0x000f694311436e32,0x00007b4a7bd61224}},
   {{0x000d21ae0ac29416,0x000462d3193703b5,0x000c992d0279b025,0x0001f2d307c052ca,0x0000aa7cb934fa8b}, {0x00025800d37c7a50,0x0007342d54225a18,0x000d2ef9213380c3,0x0003c692ac2d66d5,0x000035a70c9030c6}},
   {{0x00025dd4ce4f152f,0x000109df7c06c160,0x000e4bb141f419a7,0x0004cd7d5b221491,0x0000c43c6cd739fb}, {0x0006591925d6b2de,0x00028218659849f0,0x0001b16294b37d9d,0x000e04ac54a971d0,0x00001a9c2a031d50}},
   {{0x000b78571ba18615,0x000c80c8f93d5109,0x00033bb9348b22d5,0x000d0898fa84a786,0x00003fba6baaaebb}, {0x0007df3e5eea7d82,0x000648ca71587ff2,0x0006f1a05521c879,0x000ee499d5133bce,0x0000d50cd541d0eb}},
},
{/* digit=8 [{1,2,3,..,}]*([2^40]*G)  */
   {{0x0006d65533ef2177,0x000453ca2e87889f,0x0002b41677158c7e,0x00057f8b670dfbdc,0x00005910a01f44c2}, {0x000bf07cf88577d2,0x0000c45e2acef336,0x000a23d852224525,0x000f580ed92e8d7c,0x00009f8be4c4b812}},
   {{0x000b2452133ffd9d,0x0000b30f1a20fbb9,0x000a1f52a39a8b2f,0x000df7784bc97dd5,0x00006aebf57740ed}, {0x0007acb76ccdac60,0x000c1586ff273225,0x000de7dd1af4d36e,0x000c168eaa8863f8,0x0000045d5cf88647}},
   {{0x000414351facc618,0x000d668a25bcc51e,0x000f872edbaf2647,0x0006590f5271a00f,0x0000f32ef99bd2d9}, {0x000488c7593cbd4c,0x000c42b82fabca12,0x000eb3f16ed266c5,0x000fe24a2f78ad14,0x000034049490d47a}},
   {{0x000d574c005979da,0x0001ca40e350a6f3,0x000e2ecf9c2072b4,0x00044e5ca5c1568d,0x00008c8bf5c45153}, {0x000e555114df14a7,0x000d8dc5ec6b97ae,0x000a85418d4374a4,0x000f78054cc28f2c,0x00001cb9e2843c41}},
   {{0x0006702094704963,0x000dbbd2381509c1,0x000dd4398a489a5e,0x00069694dde4648e,0x0000ca7b94ab0111}, {0x0005d682ad636a41,0x0004f8dc5f1e3c38,0x000a219436702702,0x00069dfc1965deaf,0x00008666e16710be}},
   {{0x000fd350369c8e10,0x0002b9dc843b6792,0x00002e2ab9271aa6,0x0003838711a4b14d,0x00002b2a3e27ee1a}, {0x000e35f0e2b379be,0x000bf652ab25b226,0x0005601063d3de39,0x000876cca6d4c93b,0x0000ced0cf5a95bd}},
   {{0x000b4ca2a604b3b7,0x0003ca61676245be,0x0008b806e56f6518,0x000480852f5a7097,0x0000aa3978781dc4}, {0x000ac2a0e01fabc4,0x0004e37d99f9e13f,0x000211ffe7c6ee8a,0x0003eae51384ee05,0x0000ff6976d5bc9d}},
   {{0x000507903605c397,0x000e3142c96c8910,0x000923684f0843d9,0x0008938374493416,0x000032caa306a0a2}, {0x000c27061160170e,0x000b637fbaa3b2e8,0x000eda3acc32788c,0x000e0659cd818ea6,0x00002e9423a7e2b2}},
   {{0x000492316e043a20,0x00011dd3d209dde0,0x00031ebe898a4526,0x000abdeaf9f61bd4,0x00000919f4dbaf56}, {0x00017db6d8774b1e,0x000b78e0e309e424,0x000df81ea5fc5279,0x000c7e84aa40613a,0x0000f419edb9c627}},
   {{0x000759239ef620fd,0x000fa4fa29c43919,0x000416d839d47283,0x0002687e428fa39d,0x00001a7c251f9f30}, {0x0006e1cd746218f3,0x0007e10d967e4607,0x0000ae61ff3ad6ee,0x000929cbb5f434a0,0x0000cd2c019b0d4c}},
   {{0x000d0537a4af00f8,0x00064a294614fa24,0x00082182e3f93892,0x0009468d700c1839,0x00000133443ccc59}, {0x0007106ec87c9255,0x000bbed6665cf039,0x000cca8b562bd59f,0x000a3098414348c7,0x000074c7620ef9f0}},
   {{0x000d39b0260e52a4,0x000c506533256967,0x000ca7954d42585c,0x0007b2cd9bd60521,0x0000fa20877c1ed5}, {0x000eff8e34a0bbeb,0x000bd4f6ef6460c1,0x000af848356b0040,0x00061378be2b24b1,0x00002278164a5531}},
   {{0x00042e2bb8b6a071,0x000eba23f86a95be,0x0004ce47064be74e,0x00076a973d74fd15,0x0000c2d2857e8dc0}, {0x0001c575a8878682,0x000b1de64818b1fa,0x0004e896738df8e0,0x00076cb88e52f9c3,0x000074b4f01ab4cc}},
   {{0x0001ec2c11c208bc,0x00098e3a723459c8,0x000a089d8240207d,0x0000718957eb80f4,0x000086960bce137a}, {0x00054fd7f1a932c2,0x0004b3f2fa17de11,0x00011c0ebb517fe7,0x000d360d5d945571,0x0000aa33789a0929}},
   {{0x00005b4f8b7559df,0x000c0ae292003f5c,0x000532acc0be4c7a,0x000284ed6d3ef756,0x00006c3ed88dea7a}, {0x000b0a8f46ec59b3,0x0004bcea6c83e463,0x000dc836b531d9b1,0x000f0b0d6bdbafc2,0x0000ee501e95ab27}},
   {{0x00075455922ac1c3,0x000c752b3f638df2,0x000de57c4a7b3ef5,0x00008b5e77b21471,0x00001682c10b34c0}, {0x00024f04bd55d319,0x000587b61c71c768,0x000a5089db6d1c08,0x000d3ea1db0903c2,0x0000c092172a84e5}},
},
{/* digit=9 [{1,2,3,..,}]*([2^45]*G)  */
   {{0x0005035ea6c39976,0x000a62610bef5ace,0x00080dd3954259aa,0x000a398f18bb3f3c,0x0000910b95bbfc3f}, {0x000f51043e09aee6,0x000f47675665fce2,0x00072db61ced56c9,0x000e68b0e265acd8,0x0000982812f0e9fc}},
   {{0x0003d931341ed7a4,0x000c67b59d49b8fa,0x000b8c4a44223272,0x0002e3fdcb194783,0x0000e413c022d130}, {0x0009127e17e44ceb,0x000483b3adfb6d99,0x000aa96caee86bf7,0x00047d46902fe625,0x000073540e595aae}},
   {{0x000ef6c872b4a606,0x0003e613521bcc50,0x0003e15d1ab2a34a,0x000511d9c5c19098,0x00001dde5dfb9905}, {0x000f6219f2275f33,0x0006151d894be417,0x000b0bdaa0750c8b,0x0009bd45b04ab978,0x0000bfd9fd475858}},
   {{0x000bfabaf95894c5,0x0006d76b2241aafc,0x000dda48b7b9bdc0,0x0004df9af983625b,0x0000977faf2f3fcb}, {0x00042ef052c4b5b7,0x0000967591f0bed0,0x000f24ec79fe87f7,0x000f1b589c73ca22,0x0000d37fa9f564a9}},
   {{0x000148045ee2f40e,0x000e616b60cfbd78,0x00049a8c475e354a,0x000535fe0b58a18d,0x000040e94e3da359}, {0x000a59f62accd765,0x000a3c762837bd4f,0x0008c277b05cf466,0x00074065abda9944,0x0000a9e01bf98b13}},
   {{0x00055e6f2606a828,0x000110f2fb57b51e,0x000a4e37ce25f706,0x0007062cef6c2ab1,0x000064e359dddcf2}, {0x0006b187ce573162,0x00001a96b23d479e,0x000f16df72cab250,0x0008b5cd4898628e,0x0000056538d0f375}},
   {{0x000a0c3d41d3bd3d,0x000837a26bdeef69,0x0002edf9fb533b8c,0x000af012801d97db,0x0000c4a826ab1877}, {0x00058513d590dbeb,0x000b3e4e93576c1c,0x000b3337484632f6,0x0002e6236d36b779,0x000046833e44bbca}},
   {{0x00064880a750c0f3,0x00031e548e83cc7a,0x000110f0539bacfe,0x0005880d418c760c,0x0000e4daa4ce1f11}, {0x000e7b55ffc69ff6,0x000c320531272733,0x00022df9446f147b,0x000b7c285b2434d7,0x0000a444f6646fc6}},
   {{0x000e4bb346ac9cbf,0x000339811bb2008b,0x0001540c12e6cb02,0x000e46b6ccc747f4,0x0000119334febf6d}, {0x000ffe9cc97fe6e0,0x000bf3d828834e6b,0x0003dd1c77f4b578,0x000495459db72275,0x00005843cd82066b}},
   {{0x0008cd5dbf2af333,0x000e7f6b0eab7cb8,0x00040d844ded9566,0x00067fa1caf5488e,0x0000ae59bd6ace1f}, {0x000ad33dd82429e5,0x000b6c4467c7acf4,0x00083d011cc7ebd2,0x000db7a4f6e95de7,0x0000197e39166e92}},
   {{0x000031885e7a4af1,0x0000e7a6878dd4f2,0x000051913291bf9a,0x0000349dd8b6eebd,0x000074f5125036be}, {0x000364527f601893,0x000d5b37ec732ac3,0x000fdb42ed8902ee,0x000421246166a11c,0x00001c4e3b837076}},
   {{0x0009dfdbc6ebdfb0,0x000589de549b7de2,0x000f26a64a1ee450,0x000980fd7181aa3e,0x000003179eedf2f3}, {0x0004d30fd71bc789,0x00042e86a5831bce,0x000b85711eb842b1,0x000405500125dc5e,0x0000f5869848f11f}},
   {{0x000089eb833eccba,0x0009dbc51c795b5a,0x000be0e93c1b3077,0x0001724581157f9f,0x0000b487d69fb29b}, {0x00051082222f24bf,0x000c06dd35dfc725,0x000c24afe338cd22,0x0006eca2010e6f5f,0x00008298f16581d4}},
   {{0x000f723042389edd,0x0004d54b19722ce7,0x000251d75df7de0d,0x0008c7e8ea2e142c,0x000022a4d38c4e8e}, {0x00058566c29c8bcf,0x000d2d1e201ee999,0x000c885c99fefdbf,0x000c6fc97d946eda,0x00006ea9768c38ea}},
   {{0x000a8e974e75a2ec,0x000dedac968f9aac,0x000306befcda6fc1,0x0007f87f6651bf46,0x00007445e4f8b2ed}, {0x00012d8d1571ac12,0x0004baf3a679584a,0x0003fbc43684846c,0x0004f2afc622a986,0x0000f9e101e0a681}},
   {{0x000465ac3f16ea83,0x000d82f1d11c7a1a,0x00068a172115a461,0x0006981767dd956c,0x0000392f2ec013a4}, {0x0009ccde526cdc7f,0x000b32292b81c7a9,0x000d391988e537fd,0x00052c86d8cf69a6,0x0000fc5ff4414468}},
},
{/* digit=10 [{1,2,3,..,}]*([2^50]*G)  */
   {{0x0004f7ea90567e6d,0x0006e6ae5cb797b1,0x00010903d513257b,0x000723b5454a3c9f,0x00008d2c9ae39bc3}, {0x00093246b29cb44f,0x000c87c8cbac38da,0x000918e42b540a21,0x00014dabbfe43501,0x0000ffa707b46c36}},
   {{0x000e05b1cb76219d,0x0000a1567e7e56c2,0x000c4c9100ec0bf9,0x0004d917076f8661,0x000067b085c8abc0}, {0x00004595e93a96a9,0x000a6bdc249a9fb9,0x000dd0bb77526c1e,0x0006947d44d367ec,0x000053999182dc0d}},
   {{0x000c583a4c506ece,0x0007f1acfe972ccb,0x000f1aea2957ed18,0x00062cabaed83312,0x0000f2a6cb563253}, {0x000de428e195c43b,0x00095e6050c6130d,0x000686a5dc842025,0x0004a77da972a708,0x000052999a29508b}},
   {{0x0009167ceca9754a,0x0005ab7939a083f4,0x0003fd0bf426d2cf,0x0004e18555e35572,0x000096e6d0764f14}, {0x000a8dd87880e616,0x00058508e4d54768,0x000b65e151554381,0x000f9fa9d7e772b1,0x00003439dd70c302}},
   {{0x000f8e1698e04cc2,0x0002f69005c8b11d,0x0003c6179877be20,0x000c0512749e8c4f,0x0000dbc9d0a9853f}, {0x0004f939454d9370,0x000db4800e1b187d,0x0005e68e8e682ce9,0x00085ba9129ad816,0x0000fe29735be7f7}},
   {{0x0009ccf3a4434b4b,0x00006a7954dc3101,0x0004972a7a345811,0x0008dcf9dac80de3,0x0000043d05524f6b}, {0x000319e11137b1a0,0x000eed5cc03f021c,0x000ea5ad400a754c,0x0005b60aa2c794cb,0x000093e67f470c01}},
   {{0x0000351d598d7107,0x00065b3a4da420ac,0x00071de1f272c416,0x000b0f6b82fe1aca,0x000046e79f348f54}, {0x000c7364b573e9b5,0x0006ad4b50406e7f,0x00098d87b75d03f4,0x000da10c1cc36d0b,0x000013ba3f16f472}},
   {{0x0003145983c38b5e,0x000b837abc8b859d,0x000ff7be6b14f176,0x000a594793fb9dca,0x0000be5a56015a66}, {0x0001dcd9f87dc596,0x00039bdbf5607cec,0x000eb32577c595cd,0x0005fcfb543b2226,0x0000908064724c93}},
   {{0x000b70678a6513b9,0x000a0edb1943dca3,0x0006e2dd892ea4a2,0x00089372642216db,0x0000b45d0b52fd57}, {0x00070dbc69d11ae9,0x0008bc57595f114e,0x00077c2721477dd1,0x00059c2c2208b4ec,0x00005c5b4d86b68f}},
   {{0x0001fa47ea67c77a,0x000f43ea810cfe54,0x00001d374952bd2a,0x00036dd91fef568d,0x00003a1c621af113}, {0x000d5a9c7ec6d792,0x000f1225c3425ad0,0x00069601bff7038a,0x00047ce03c6689bc,0x00005059bc765e87}},
   {{0x000c80676cb25661,0x0001a24892d99a75,0x00008fe458f76acb,0x0007d86ae7b9cc1f,0x00009ef73297a490}, {0x000ab715f228bf03,0x0009517032d72db4,0x000abe3c0f3cdea3,0x00025bdb1f482edc,0x0000baf76b4eb863}},
   {{0x000688eadd70482e,0x00099b4a4e8a6aac,0x0008a6eef708de92,0x000c4295b6dd7375,0x0000a4bf353525b3}, {0x0001f2c87912868c,0x00052f09297a1004,0x000f3860ab1b1be9,0x000f4a59ae23c5a9,0x00004f0f83a115dc}},
   {{0x00027bf8538a5c69,0x000cf9abff17c71e,0x00071e3da195c63d,0x000fa06d3152851b,0x0000cbdfda88a680}, {0x00076ca849d7eab8,0x000abc2732719db8,0x00008dceaebe2764,0x000b6fe63357e3f2,0x0000c5bd833d65b1}},
   {{0x0000d7c2fa4f1264,0x00051c99a2327590,0x00025e0c308a3b86,0x000edee478b6bfdb,0x000082cc2c2b1db2}, {0x0007e645f321bb80,0x000b9a8005b437df,0x0008c19588a93821,0x000d0a3fa2f10ccc,0x0000d3322182c269}},
   {{0x00014df3fd165e81,0x0008f61f8811ba55,0x000ef9f00499fd6a,0x000e8a62cd1fe0bf,0x000020a4bb989ad7}, {0x000d0955f4a5ac5d,0x0000c5a7a2f0f2ff,0x00017baf1cfd174f,0x000089042301ba9d,0x00002fa487b47f22}},
   {{0x00052381d531696e,0x000fa8cdde69b934,0x00086afc757201bf,0x000ea7fde922519a,0x000030438969d35c}, {0x000c1e18555970de,0x00084535935e7608,0x0002ea38b8267dfa,0x0008b4f4c60a5732,0x00000bf7978604ef}},
},
{/* digit=11 [{1,2,3,..,}]*([2^55]*G)  */
   {{0x000ea68c094dbb56,0x000e7968d4106233,0x000b3002db77d062,0x000d57de719bbc58,0x00008e7dd3d9dc49}, {0x0005740013a5e585,0x0006ec9e3c1b8d82,0x00099b6ab2131174,0x0008f1bcb0a2a77c,0x0000c48a3b412f88}},
   {{0x0003e91991724f36,0x000bd9cbd686c791,0x000d4fc1e5eda799,0x000d547db595c763,0x0000b63b80c0c4fe}, {0x000fc697e5fb5166,0x000a70f1c9646ea0,0x000a92ca5737708b,0x00067a3628745f11,0x00001f37958fa869}},
   {{0x000fd610979e6b3b,0x0004e3d407235320,0x00080bacc1d0bd3e,0x0005145ac006fcaa,0x00001d9c60f82002}, {0x0007ed0af780b927,0x000e10a9ce31610e,0x00020b54bf5bf446,0x0006c2d41c011d3c,0x00007f76da189159}},
   {{0x0009b2caa6650728,0x00046fd324ef9af3,0x00027bd3178322fa,0x000aafbd153394c3,0x00001d5f271b129d}, {0x0000c42f48027f5b,0x000bd536e717c72e,0x000369d0faa40cdb,0x0004e6445a657a2d,0x000003bbfc59a7f7}},
   {{0x000d5429b6a42eae,0x00045daf41b97a04,0x0006b0b89fa597e8,0x0003dd6c58ec2772,0x0000d8eb16ae30d4}, {0x000e5e1ec9dcf577,0x0000f97cff8165e1,0x0006e2b22b7a770c,0x0002b6ae6d918f9f,0x0000c277a9b364e8}},
   {{0x000c4180d738ded3,0x0000b0de572946a8,0x000a816756f1a5bb,0x0003d4c10230b98b,0x00002c6f30c412b3}, {0x000129dd8fffb620,0x0007b459bf057559,0x0003b67766a281b4,0x00073a77c1bd3afa,0x0000709b38078299}},
   {{0x000e0c1da36cb47f,0x000a2e0210f00875,0x0003787c8fdf5b7c,0x00041e8e0c7e4d3a,0x0000043f5271b1c7}, {0x0001b006d74d72d5,0x0002e8b45ba976df,0x0006b797a0514df7,0x000c395ecf7c3e0a,0x0000e30b2862deaa}},
   {{0x000b232a3326505c,0x00022e1d41bf8c26,0x000e32afa38d6927,0x000a864459453eff,0x0000e8143ae3cb3e}, {0x000c1fa7e6ab6665,0x000fd2286264932e,0x00036f8ed6cd2d22,0x0005baf59a46fe67,0x00000bf0d00eeca8}},
   {{0x0008f7d605238a52,0x0002248496ab15c7,0x00010acc1e9d8784,0x0004e2afcf75d0d2,0x0000948f2297c8c1}, {0x000d76de8daf0cb3,0x0004703be800e81f,0x00078d30cd02d11e,0x0009cadc4df35187,0x0000482bc96c6513}},
   {{0x0005852877a21ec5,0x0006bf537a940b82,0x000a9a6a2300414a,0x000bffef1cba4021,0x00000824eeec6943}, {0x000fcecf83cba5d5,0x000843b4f3c0a0db,0x000f24dd7f953814,0x0009dd1174416248,0x0000322d64e34fb0}},
   {{0x000cf278a448bbc2,0x000fa85251da56b6,0x000e79b240ca898d,0x0001a77082cad836,0x0000e7b9ed33a8e5}, {0x000318a43e1c8025,0x00037bf8689ddc7d,0x000071b1a4750e52,0x000dc14887a072f0,0x00002090f87d14bf}},
   {{0x00073843d9325f3b,0x00004371cb845744,0x0001e36c5a9bef2d,0x000f71c7d2188ba6,0x0000bd6a7d87602d}, {0x000a9028f61bc0b8,0x000ceed0b6a1ba3a,0x0006e8298f49085e,0x00001d0bc625d6ae,0x000032b0b1e22e9c}},
   {{0x000f2196196bc6e2,0x000bcf097efd5beb,0x00087293a0e66736,0x000cddf128f3b8ea,0x0000998e4058addf}, {0x00031b85d16c9619,0x00009418f05655cc,0x0009fe81987a434e,0x0000c59e94aaccdc,0x00004a486c235649}},
   {{0x000c447f1f0ced18,0x00031492dd2ba337,0x000a08efa800cc79,0x00041dcb93151dbe,0x000020cf3f95e0a7}, {0x00082dc1c0f7d133,0x000054dde6caff19,0x000f96ee3ef92196,0x0000c6ead7d97245,0x000019c8dbe59dea}},
   {{0x000385bde259ec84,0x0009f0f67b0d1ff2,0x000661cfff6b0836,0x000f5bc4cc65b006,0x000067e635914230}, {0x0008c802dbed3d35,0x0002a1920da6ce46,0x00037479f7b98426,0x000de0e4d2574215,0x0000c8aa88cd7bb8}},
   {{0x00038717b82b99b6,0x000ce70eb624d3ea,0x00095d46675922d4,0x0003462f66ec543b,0x00006e673cd1ee1e}, {0x00067c4b5f2b89a4,0x0005e90e5cd36afe,0x0000a2ada3de9c1e,0x00023b4c278bb631,0x000020fa3844bdb3}},
},
{/* digit=12 [{1,2,3,..,}]*([2^60]*G)  */
   {{0x00096796424c49b9,0x0007d7c241c9646f,0x000f68b49f888dfe,0x000f20512d4b9324,0x0000a6b62d93571d}, {0x000b26d179483cb7,0x00022511fae281b4,0x0003aa51f666f963,0x000d166281b3e4d5,0x0000f96a765ef3db}},
   {{0x000d37c051af62b9,0x000a7bf944968553,0x000d59aa1e9a998e,0x00081350844f9fb0,0x000083fd55976afb}, {0x000c0ca65d698049,0x000ddea5ff2d9670,0x000d8623b732b22d,0x00078247640ba95f,0x0000f61916436351}},
   {{0x000b4e0bdefdd4f1,0x0005e366e401f167,0x0003bbec06995846,0x000c214aa368aba7,0x000021487098b240}, {0x000323318969006d,0x000e11fe53d1378c,0x0000c4361cb4d73c,0x00012a8f50a80e13,0x000067f59524ef52}},
   {{0x00081088cad38c0b,0x000fbbd68ae2332f,0x0008e27a3471b7e8,0x000b0ca6ac3fb20d,0x000054660dbc36b4}, {0x0001e11a6fd8de44,0x000a637799ef123a,0x0006ac17c44dbffe,0x000cef0540b977ce,0x000095173a8ef60a}},
   {{0x00037434573eab0b,0x000b21ac6031eb44,0x000dd9afd11570df,0x00023147d9b45b44,0x00008066addd2067}, {0x0002ad8f8a3f0b44,0x0009a0ace2a215f9,0x000b38b809e0e489,0x0000527dcd0aadfa,0x00006506ae957020}},
   {{0x00069f78fca399da,0x00016207bb63429a,0x00088f582fe9e27d,0x000f6e4c655ed687,0x0000426d7494db75}, {0x0005c02ca81c66da,0x00070531d4251869,0x000ff48ba84fb8d2,0x0002469a3a8956de,0x0000f1d0d57166d2}},
   {{0x0009565352c4b5c2,0x0001390bc3e25a05,0x0006f9f5f4926153,0x000a9b609f7521f6,0x0000baef6bfe70a4}, {0x000fa6509ed3561b,0x0002e84b230ce7e6,0x0004cdc691137023,0x0004157151659bd0,0x0000db83c64a007d}},
   {{0x000284d391c2a82a,0x0002758308e89ebb,0x000f1edcabcdd486,0x0006c7606f16ec83,0x000013e2c38095dc}, {0x00056f04a057a87a,0x000006b48f982ab7,0x000651c44a876550,0x000e01a252face68,0x000052b540c81765}},
   {{0x000a1a85ca37ff0e,0x000bed2f1c8fcb35,0x000a26112e1a04f1,0x00077d438816ce15,0x0000206a111e95b1}, {0x000b6048a4241497,0x000704752cfb3c10,0x000f1dbb8c6a3f56,0x000dfb4f16a37a47,0x0000c372f9b431a3}},
   {{0x00005b5c20b4d2a0,0x00050c662a67122d,0x000ffc9e9ff659cf,0x000683ed57c128e8,0x0000fbb15859e987}, {0x0000df247319a2b3,0x000a074be470add7,0x000a7b3074b98bab,0x000f30c03d747356,0x000042e696e6efeb}},
   {{0x00048f7864ac537c,0x0008e6940d3df84b,0x00074c7ae0471340,0x000033414db22d61,0x000073a1c444c213}, {0x0004ea5ffdd93ec9,0x0006d102783e18ac,0x000c3e83f724fc75,0x000bf50fe13fcc91,0x00002a8c2c9808f0}},
   {{0x00022fd8f67f6de6,0x0003786931777f2e,0x0003eca95ab01883,0x000f2ac66d1db686,0x0000bb7732b91b5e}, {0x00027c6915f80ced,0x00018f90efd84fa9,0x0006b48ad6fa1d6d,0x000428abd75de845,0x00002cb507b545b6}},
   {{0x000f82ae255d7eca,0x00030460e204a72c,0x0005b0a4452025c2,0x000ed970ae542d7d,0x000085143113305a}, {0x00015f5a14bbfe81,0x0006285365fe9583,0x000d950403f36182,0x000da2b2b3a36b66,0x00002c7b3348cf4e}},
   {{0x000b4d1e744119d4,0x0009429a71e7a545,0x00017fcbf4c93b16,0x000d84edbb908c61,0x0000dc97320f35a3}, {0x0004f856bf88105f,0x000d2b51bc1f94c0,0x000013af3452e1bc,0x000e231c41ff50b3,0x000007af446124d7}},
   {{0x000e57ca3d24f6a1,0x0007e345a763bdb9,0x000cfbb5f8a8246d,0x0004db63bd2a6d98,0x0000dd8e85e96ed0}, {0x000da42c01f420b6,0x000304407bc776f2,0x000f548f57ef0547,0x00064a1e98ba7faf,0x0000b7afbef5d30b}},
   {{0x0002fc516a0d2bb2,0x000bfa6234994f92,0x000c62c8b0d5cc16,0x00067f7241cf3a57,0x0000f5e69621d1b6}, {0x000c70bf5a01797f,0x000c709561925c15,0x0001fdb523d20b44,0x000f7a14911b3707,0x0000648f9177d6f0}},
},
{/* digit=13 [{1,2,3,..,}]*([2^65]*G)  */
   {{0x000c8b8fac61d9a1,0x0002d3c6fe8a027c,0x000bff5037d25e06,0x0002f7d08805bfe5,0x00003271e6c7ff63}, {0x000a6c0232f76a55,0x000d201ef42655dc,0x0000a51788957c32,0x0001739e728bcba1,0x0000ea60412062c5}},
   {{0x000462bb4d8bc50a,0x0006091957709ad5,0x000412a68181c0b1,0x00048c4bd4fe1c78,0x0000e0341bd60dff}, {0x00045cf7003e8666,0x000a2a24a41bb6bc,0x0004c24c2f11a6de,0x000b67f407151ad0,0x00002c9d27e3a5b7}},
   {{0x0005719a8afd30bb,0x0007da826dce3286,0x000a8fbe08679832,0x000ad32f04e891c4,0x0000b6b6e1c9bf56}, {0x0005b11471f1ff0f,0x0008ce15baf00a69,0x00096c43ed76c338,0x000157118edb95be,0x00002beaaf580794}},
   {{0x000b12e523b8bf60,0x000b8f910c1b0a50,0x0001675888009eb5,0x000abdf535af824a,0x0000f835f9cfb2a2}, {0x00029312afceb620,0x000a169d383ff59b,0x000ac02b0c797df2,0x0000caeb3f5fb066,0x000029d4c6fdaa2d}},
   {{0x000ebd1e0a1b12ac,0x000cb70ba95f87a7,0x0002ae9cb1e4ef88,0x000402cc33345cdc,0x0000ecf1276c1cc8}, {0x000012e1b39b80f3,0x000d05c33ba4687c,0x0009661c2fd90d0a,0x00029e73ef5a675c,0x000068fc88f10174}},
   {{0x00026052b7ce5421,0x00096472bde1b822,0x000d2f4dae6d4ce9,0x000b2e43e16ebe09,0x000080ff42e63b92}, {0x000cc022c34a1c65,0x0008f22c46c2c59b,0x00014a8a23803d6f,0x000b27c8aff74f5c,0x00005aebf8060a08}},
   {{0x000970e2fdd23cc0,0x000c5682e971b956,0x000e86ebcb80288b,0x000939e6e6d91e9a,0x0000564c83f8c9f1}, {0x00032a239560368e,0x000a249c28e25519,0x000a158c3e893752,0x0002622b03cee5a6,0x000012d656be4964}},
   {{0x0002010f5b343bcf,0x000a02f142fe58af,0x0005f4bdf0f2e400,0x000aa84483bfdea8,0x00000b1d093f3bfe}, {0x0001b95c70816030,0x00093dba10972ea0,0x00038f3a6e943e4c,0x00063647be92adb4,0x00000bb7742e5bf6}},
   {{0x00014576be5f7de2,0x0008a2263c9e4ed7,0x000cacb36d93006f,0x0008abc073694cca,0x0000ff7a5b45ae11}, {0x00053f1cd871236b,0x000d12aa6d523cce,0x00098d76df156a39,0x000d38ecc5f271b1,0x0000c615b7031383}},
   {{0x0004fb486df2a61b,0x00073cf7b4a2137a,0x000d042ffa1ed9c0,0x0005ec02e460e27b,0x00007f5e2fb0f62f}, {0x000ec6bcc2423b79,0x000f2a63eea77aa6,0x00050a6e175ce0a7,0x000c9ed7a45fb1f2,0x00003bc919d753cd}},
   {{0x0000af231f63950e,0x000034caa2c96793,0x000ac7e62a77797c,0x000aeb726e80ee27,0x00001e6e62738b28}, {0x00078b0b3c9fef02,0x00004d5f90be6361,0x000ce51cfaf7752e,0x000e1f74ecaf18ee,0x0000864d0edea806}},
   {{0x000ccaaddce33450,0x0007012a4350ec2f,0x000598bdc2a6811b,0x00012896760ff1ac,0x000054d652ad1bf4}, {0x00051d492a210056,0x0000d3110fdf0a11,0x00060100fad7f397,0x0003622c95928c19,0x0000c91c825dbf03}},
   {{0x0005b7799eb6df0e,0x00009386b7791778,0x00017a48e26c3cc5,0x000f30545ed98864,0x0000990b4e4e7d6e}, {0x0006b7e2586abba3,0x000529c96e9a0f45,0x000eb4206239ca6a,0x00090ab327459ce2,0x0000a4c3313d002b}},
   {{0x000125dec3f1dec5,0x0000411178da19e6,0x0004a673807b1f04,0x000dcd893ededa90,0x00005187a5a5bebe}, {0x0004722eb329d415,0x000ea170b391f7d0,0x00099f828f449099,0x00076dad317a69ca,0x00000c3db2b84a49}},
   {{0x000b69b92222f1f5,0x000a1cf7ae703806,0x0005217ee5a2459c,0x0005ac1789f69ca8,0x0000f232b5f33dc8}, {0x0003ec548e9e5167,0x0006c197eb31660e,0x000fcca23124b4e4,0x00024ea0a0cb13aa,0x0000bd63ba4f2132}},
   {{0x000481b7bfe71786,0x000e05405868b674,0x0008c867d4e1deba,0x0000e9a61b2821c4,0x00009c15b35b13b3}, {0x0001666368710884,0x000cd220b1ff3b4a,0x0003d9f4de5e29f5,0x0006750b82bb3523,0x0000e07633358cdc}},
},
{/* digit=14 [{1,2,3,..,}]*([2^70]*G)  */
   {{0x000f5c7a3e6fced0,0x0005f45fbdeb0d53,0x000339a70e8cbbdd,0x000b81f85c01df13,0x0000ff71880142ce}, {0x0008774bd70437a2,0x00019a0bda6a4c4e,0x0008bd26e5fb3289,0x000521fcdbebd2f1,0x0000f9526f123a9d}},
   {{0x000305192c4d6840,0x00057612efcd40ce,0x0009cae208b04d72,0x00056cb9dcda366f,0x0000edc4d24f0588}, {0x000e6bf854279005,0x00058c09dfea64f2,0x0009bf26c3de8129,0x0005a9841b448737,0x00000b62c6dbdf13}},
   {{0x000e3b4c72dfe67a,0x0005f0e19fdfd4f8,0x00013bd35c416b0f,0x000b9d78b9098d4c,0x0000c11118ab5b8c}, {0x000a318f00628413,0x000f59f356f4f598,0x000177a0cbfe0602,0x0005374ae3637e30,0x0000409774791136}},
   {{0x000fb5ed005832ae,0x000ab1042e4f0db2,0x00070f8ca5f5efd3,0x0009cbac4ffdc6ed,0x00004645d0c952da}, {0x000f58bc9001d1f8,0x000bce1172059596,0x00098a08452c8f0b,0x0009de7d4aa0d2e3,0x000015bfe3a904f4}},
   {{0x000443f23885e5fd,0x000918433aab97e5,0x000d4e604f72f8f9,0x0003feed00b154e4,0x00000b35e6bb5e17}, {0x000a0489164722d3,0x000b58761ec857b2,0x000a838323e3c665,0x000e3b3bdd13973d,0x0000c8b1a1ea3daf}},
   {{0x000ace654317cac3,0x0009221771b34497,0x000dfe8b8be600ab,0x00010f842e409eb0,0x000086a67d769423}, {0x0008d8d4431cc288,0x0002185dc5242554,0x000c4be32a7cff14,0x0006e0cd60f5a193,0x00003ebd5c95071c}},
   {{0x00080a7b1fd2b0bc,0x00059bec33e8ba3a,0x000743fb39b3ad39,0x0002f9f3868d6179,0x0000fd169fdbdb46}, {0x00099d79ce0a6af4,0x0001a42d3ff8d3b4,0x000c3e1b255dc1cf,0x000473c4fb9e6cc6,0x00007e6961daf69a}},
   {{0x0003acce548b37b2,0x000264d4054954eb,0x000341b4fb38e754,0x0007fa6c3daa517b,0x0000f6928ec890bf}, {0x000b32386ce6c413,0x0004e0adadcd0496,0x000b5faf901be1c5,0x000985904e67e74b,0x0000cbaf679115c9}},
   {{0x000214550ca42470,0x000ae7dd30aa8cd1,0x0008fee24ba1aa47,0x0000e82f81ddf1e5,0x00003452936eec9b}, {0x0003b81243aea965,0x000ec5c3d0e58bdc,0x0009483619a2919a,0x000ccf4ea640ec10,0x0000ac86d5bbe0bc}},
   {{0x000d918c36cf4406,0x00076939719cf892,0x000218b64aed3e83,0x0000dd507b08d2c0,0x0000f1bcbbb2e979}, {0x000d6ed60919b8eb,0x0000dac1f9eb4a84,0x000d5daefd890079,0x0002c5484941aa0d,0x000022fe40b17fd6}},
   {{0x0005ba2157f2db33,0x000f5e28ca9c97e1,0x000b9f454bda2fc8,0x00072e2d050da437,0x0000d57eb575379d}, {0x000eba2fb5ee9973,0x0002b11538cae9b5,0x00032797401648ca,0x000bb702bb76f6f6,0x000038f14b92f3f4}},
   {{0x000226ad7ab9a2d8,0x000cfdfae958524d,0x00051d8c29c00090,0x00062c8ba5f53987,0x0000afcbcddbab82}, {0x0002729e99d043b6,0x000b4ebc943a5739,0x000862935ef51263,0x00017b3feace9320,0x000039efc04106c8}},
   {{0x00054b366b4be7ad,0x000db4a37a1e1fe0,0x000d75cd93f25a9d,0x0001b5239ef1ad78,0x00007b58f4a2062c}, {0x000f9a9ff563436b,0x000938af51e76f74,0x000e97fecf718ff2,0x000c09a234d31315,0x00006a8e2b1d92f1}},
   {{0x0003aa8327720c15,0x00026a092cc8a7f5,0x000746c4d956ca32,0x0003923f03d64a28,0x00001fe1782b6d0d}, {0x00034db3c832c80a,0x000bcda2e3b4d19b,0x000104ccc60dccc5,0x0001fc845dd62e0a,0x00007ab1de2020b2}},
   {{0x000ae0b3893d123d,0x0002e15ee71cb293,0x000a9468bf7b7578,0x0007438aa3c61442,0x0000686123dab15d}, {0x0006891a7ab4116f,0x0007b4e6a4598c61,0x000e5fad76fcd72c,0x00046abc21911077,0x0000b6a20e8604fa}},
   {{0x000be7d341d81dcf,0x000842148379e839,0x000026eadcddb688,0x000c5dea6211a1f7,0x00003b25760e4d1c}, {0x000c8f6a7a73ae65,0x000e11d5b48340cf,0x000a50ebc83879a5,0x0008fa75acb1ed41,0x00009a60cc88c07d}},
},
{/* digit=15 [{1,2,3,..,}]*([2^75]*G)  */
   {{0x00030b665c7322db,0x000103c1b3fb4395,0x00072f685cf12cc0,0x00091d170b018601,0x0000915ee22cb583}, {0x000f03ba317db248,0x000897b8ffc49afd,0x000d3d05087dec65,0x0000e6ff46597be4,0x00000a1c1ed80650}},
   {{0x000a7b397acf4ec2,0x00003ea8b6403e22,0x0009692850426c40,0x0006703e3295a64e,0x00002aabc59c6a45}, {0x000714c5f5942bc4,0x000dba3182edb929,0x0004152ba9a6168b,0x000367e216a66510,0x00006908d03f6926}},
   {{0x0008ac6c2babcc13,0x0008ce81ae8d52cb,0x000f1a7114748d44,0x000ac42844f03f80,0x0000db784b328df4}, {0x0008f122df1fe365,0x0009a33cc7c0ad91,0x0005e5555e40f25b,0x0006f8f700d0e73b,0x0000c28fa0900332}},
   {{0x000d8745a1251fb6,0x0008672725c7a9f5,0x000ffe89e967747a,0x00035db95c33e531,0x000009d211049649}, {0x0006ca82fe122271,0x0005f426469dcafd,0x00093183caf9b5b9,0x000fef1e9ee04c56,0x0000084a333d8146}},
   {{0x000b1c8321a518cb,0x0005dbce226f56da,0x000acb9fafd4439a,0x00071b30b30d194f,0x00005052f3125835}, {0x000641012afd4761,0x0001f3fe624a1442,0x0001c92e6d02e417,0x000b52ec394f6553,0x00006d4bf5ae4bc0}},
   {{0x000b88210395755c,0x00039ec1df80ce06,0x000f55e96117ce63,0x000d1e3efae513ef,0x0000f36cba7bd7fe}, {0x000eca9a40ebf884,0x000f73d37e127340,0x000bbf9ffe6ec1bc,0x00005e8a51b64e86,0x0000e0dbb58cb40e}},
   {{0x000d0bf5f8b8a84c,0x0005c66f3ede120a,0x0000ebc2cbfa00f3,0x000e3ae8c6064ec3,0x000039e40b8e3001}, {0x000f7cde7b1cbab5,0x0006b4a562849614,0x000857a19cd4420c,0x0006cb3446a8f316,0x000019b93b236f70}},
   {{0x0009933aed1d1f71,0x0003405630909664,0x0002e39cf566eaff,0x000124245057f0ad,0x000048ff65b2f832}, {0x00089d4cf94cf0dc,0x0003920c58b3042e,0x00061aa0d319bec8,0x0007ac6a26762653,0x000086fa3034fbc8}},
   {{0x000e5b80863b6647,0x000accabdb533805,0x000feff918be7ac6,0x0002062f7d70505d,0x0000dea8bd105896}, {0x0005a3b410e3c4e4,0x00097c603ebf2800,0x000ec15d224a4f0e,0x00041d8c4fd5ae4a,0x0000dc253f84f966}},
   {{0x0007b9c7ea2ee345,0x000bb9cc3a71359d,0x0001ea37a3fd0d94,0x000c876b53c31c3a,0x000033425fb1f818}, {0x00099c3810156e0e,0x000350c164487cd1,0x0006425420ea020e,0x0005ea0557ba094a,0x0000657e7e87465f}},
   {{0x0003ad1fbc824398,0x000b7896e9fdea72,0x0001c33ffc726868,0x000231597c913c51,0x0000a3fa8e362114}, {0x0000e5608445b3e7,0x000488d098d32a6c,0x000ea77d42c4cd88,0x000f710bf51faf2f,0x000009f208aeb1c4}},
   {{0x000d2ab5c8b06d5c,0x00023e4eac46fc83,0x0006f7779b1a785a,0x000504f99315bc84,0x0000f31d817af9ea}, {0x000fe6a15d7dc85d,0x0003e4016b332391,0x0001cb4c72f132b0,0x0005a059547fe318,0x0000b66d8a735015}},
   {{0x0004843f45aac50f,0x000da1eaaad05b9e,0x00054eea0c31e042,0x000a567e8c0b345a,0x00000437b95862c7}, {0x0001ce8fe1d348b4,0x0008a3786432e453,0x000510d38e148937,0x000b0095e19c4a3f,0x0000df3f0170e348}},
   {{0x0000e8b593d070f7,0x0005e255625d59cd,0x0007a03994375751,0x000eeae51fdda75b,0x0000bb6e6b09dec1}, {0x000b662334c0922f,0x000e1cf41b79729b,0x000f324023df631d,0x000c8711abf3c578,0x0000cb4666d8cd33}},
   {{0x000b445735e843cc,0x000cd7379134b805,0x000ab9f872a8e890,0x0002b62bc7c10c52,0x0000bb5e1ed780a9}, {0x000a2d9dc2c4efe8,0x000e2e8cc7bdd6ad,0x000418a74fccf504,0x00080be50115acb2,0x0000dd90e07452bd}},
   {{0x000d7e1adc1696fc,0x00024acd72d06b66,0x0001b743598ebe59,0x0005eba5f24550cc,0x0000e23139474b9a}, {0x00022d4db067df91,0x0005baff9b00234a,0x00000c9c198dda09,0x0006950bbc75a061,0x0000560a9c8a39cf}},
},
{/* digit=16 [{1,2,3,..,}]*([2^80]*G)  */
   {{0x0000f1cf1c367cab,0x000b190fbc7de405,0x000a110329bc85a9,0x0003a8f373c4a2e1,0x000064232b85d039}, {0x0007eb0167dad297,0x000124b78ab2f557,0x00029348b1604f30,0x0003419baa94afe8,0x00007fbd8ddb1654}},
   {{0x0004802fcf0a7fd8,0x0008d488b01e31f1,0x00052b49842fd078,0x000200f1d78d6d99,0x0000eb572d987ac5}, {0x000a44c4d194a88b,0x00090a017e66e0a2,0x00088aefcd2b63fd,0x000a10c8efc6c8f8,0x000076f6bdafa881}},
   {{0x000932c68af43eec,0x000db03d00bda2f7,0x000b061f55502468,0x0005ad25dc978f2f,0x00009a1904ae8c81}, {0x000538d470c56a4f,0x000e293d8cedd3af,0x000108ef3159abc5,0x0001773a37245f20,0x0000a17081f123f7}},
   {{0x000a9b2b4b4b67c8,0x0000680206041fe2,0x0008058d8c1d10df,0x000fbb1d64abfcbc,0x0000943b9b2f12a0}, {0x000d9143b3def048,0x0001cce775ff90ee,0x000bc904085ab3aa,0x000dfae05fd4ca7b,0x0000b34a56562c75}},
   {{0x000acf88e2f7d902,0x000757be32cd5c18,0x000eb5ee9fdbf33d,0x000114ea085cd7d2,0x0000d702cfbd3201}, {0x000ebdb85c88ce89,0x000b8e01d617b6e0,0x0007333ac23a3ce3,0x000b6aa041618e56,0x0000dd0fd8fa57ed}},
   {{0x000610798fa7aaac,0x00043073aa4eb2b2,0x000d6b19b41209ee,0x000caf31570359f2,0x0000be6868dbc577}, {0x0004bdc32c04dd3e,0x000defeee397186c,0x00086c0cfa6c35fa,0x000fe1d4a1b312f0,0x00000a5ccc7b9461}},
   {{0x000f3a36fa6110cc,0x00013b93561f516f,0x00057522b74fb1eb,0x000dc5ac0c904784,0x0000fd321052bb8b}, {0x00084a2cc80ad571,0x000576a9b6372d68,0x000f4e8cd7c27fc3,0x0002f02461baedad,0x0000d56251a71724}},
   {{0x00011a9431dd80e8,0x0009f3306cd9b840,0x000b3b730eb7c7cc,0x0003d2a0fadd29d1,0x00003858b5c7e37b}, {0x000d193b6251d5c7,0x0002a352d952bf4c,0x000fbc0511cca1fd,0x000636566157a490,0x0000990a638f9b98}},
   {{0x00081a321175ec17,0x00057e018109892c,0x0008be3169159a50,0x0002e5570130532d,0x00006060c21b26fa}, {0x0002dfc6b6f0f228,0x00044a01a671074d,0x00070bd8e9725fc6,0x0003fdbf6679b927,0x0000fe6605057c9b}},
   {{0x0001154b6e00a84b,0x000174890e60ce71,0x00060988fd9fe7e4,0x000004210bc6c345,0x0000dc2ef531859b}, {0x000d868d5c890ee1,0x0006019c47dcdcf0,0x000714567893115e,0x000a53d97966fbee,0x000017813356c85a}},
   {{0x00030cc732043499,0x000d04a0679c71d5,0x00061e031c9df473,0x0005fe3572f00142,0x0000786b71fb2f13}, {0x00005fa6b64e56fd,0x000835219c46ed65,0x000f53d71e2fb48e,0x0004053dbec45bed,0x00007d782f39589f}},
   {{0x000b66b73ed09660,0x00082886032b350f,0x000390493968e4b0,0x000dbe5a16ed6e88,0x0000a83ce84a121e}, {0x000fc10a3d9cda09,0x000505ce67fb7c86,0x00037dbf65a40a6d,0x000282dcb8cda7f9,0x00005b44768f51f6}},
   {{0x0003c8a446cd7f44,0x000b506d52a60651,0x00023866c158c423,0x0008ee31503261c4,0x0000b96f570d3c14}, {0x0009cc7239a85237,0x000625ac4b8b5daf,0x0004bf7f6611b597,0x0004436e3981db72,0x0000e7d0f78d7afc}},
   {{0x000101ed6fc38377,0x000eee1b3a09984f,0x000942626340bf99,0x0006184b96036f06,0x0000bc878ab7c7da}, {0x00016441c6fb0358,0x000e2182fe9fb374,0x000c7a67ac65bd5a,0x000d7c9b9c2fb86c,0x0000d1b19afdce68}},
   {{0x000b80c8ce59954f,0x000388222ac03d1a,0x000f878dd742c5a9,0x000a984ddacbf894,0x0000c085118d7d54}, {0x0001dfa21e38ec27,0x000aa6f4ff7ffb0f,0x000a888fe1c7b59c,0x000889288752397e,0x000005d270d210dc}},
   {{0x000692a87dec0e16,0x000d97b39d00e5aa,0x000cfa0b5010ded8,0x000a281b1b80c854,0x00006beb87700f8e}, {0x000f5313476cd0e8,0x0005308d394950d7,0x000479fc6a63d0e6,0x0007419a09eea953,0x00002ae98927499e}},
},
{/* digit=17 [{1,2,3,..,}]*([2^85]*G)  */
   {{0x000b9105ca7d8669,0x0001aadb3b34ab58,0x000eac0bc582967e,0x000af4f9ae4447cc,0x000019c667d0bf56}, {0x00017b160f5dcd7b,0x000f2dcaadbc9aec,0x0003467f5ec697b9,0x00032e5b98f34146,0x0000187f1f859671}},
   {{0x000dcb6ec7fae9f1,0x0004dfb66e5aeb5d,0x000445d52995f271,0x000620cee95d8e69,0x0000b6c2d4619e27}, {0x0001c318129d7161,0x0000f958c1aa3262,0x000f4af63b03909f,0x000df67c468ef91a,0x000062c42a00ba5c}},
   {{0x0005eef9c053df72,0x00079300ea6fe8cb,0x00049cffb8de25b3,0x0009bbbb03fa92c8,0x000042e43a808416}, {0x00051f4dd6f958ec,0x000f34445a8de4fa,0x0000d89496925a77,0x00039026e72a50e9,0x000066648e3eb1f6}},
   {{0x00096f31711ebec8,0x000f4e98fdc46c3b,0x000b4411f2da40f1,0x000bb6399774d357,0x00007c8bdf495b65}, {0x00089e3c2eef12d5,0x000aec7471f3da3a,0x00012c594de95bb9,0x00056b100f225bd8,0x00004907c5d7b75a}},
   {{0x0004d2945c1dd539,0x0007931debb5699e,0x0007f00e0cadc589,0x000a0e4f49fcc7a7,0x00003057bc0373e5}, {0x0007ecd027a4cd18,0x00034614011a2f8b,0x000677c68114734b,0x000f4f67a01db767,0x00009d9be5efe273}},
   {{0x000ee5931fba2393,0x000368bd91d1e0de,0x0001a3c1df47424d,0x00033adf8886f407,0x0000f7d41e8d8192}, {0x00023c2cf6eb9980,0x000f609a287f7086,0x000c9076286bb49a,0x00054b942bb24963,0x0000ef6eea555a96}},
   {{0x0004a2e649d4e574,0x000fd917526e4add,0x000b44ac4cd53a2a,0x00031d8526233020,0x0000028746afaa2c}, {0x000839064291d4c7,0x00017e5ad9095131,0x000185681bf48f15,0x0004425ce57f597b,0x0000c3ac1b0b854d}},
   {{0x0001db6f79588c00,0x0009b55768cca80d,0x00054438afa52fc6,0x000a4f0b4df1ae7f,0x0000cadd1a7f9b46}, {0x000a6b31803dd6fc,0x000495eaae35b40e,0x0002e4e16488e4fa,0x000c97df047d5538,0x00009b5b7e0ef6e0}},
   {{0x00072d0b611c24be,0x000480a8f351c199,0x000cf64211d468e6,0x0004910b7580697b,0x0000c9dd0ef68fbc}, {0x000d2bf956c2e32a,0x00043cddf94e5b59,0x000ee766573dc686,0x0006c45d5e2321bc,0x00007b4f8effe9a0}},
   {{0x0008f17cf41c6e88,0x0009837b925c03cc,0x000d2427cf1f03c2,0x0008e4439c19cc66,0x000023d24bafb6c1}, {0x0009013901f0b4f7,0x000188941c2e32ef,0x00028092e684360f,0x00032e9ebaff522c,0x0000891e4e3956c9}},
   {{0x0008f82d8d38a9b9,0x000057de1391174e,0x000c175dd2e97c60,0x00003535709850a1,0x000069041a0c2ae5}, {0x000533b76a2086b3,0x000ba7c2e8fecbfd,0x0009dfb67d6bba71,0x0005d982d58ee609,0x0000a8b342d364a8}},
   {{0x000bf0502f40d9ab,0x00077c318a4df83c,0x0009c26744681c46,0x00092de85756180e,0x0000e79d046c8470}, {0x000480a78bd01e0c,0x0003b2a51db9af1e,0x000afbab66dd359e,0x000198a2ce3821e3,0x00005cee5b6d7733}},
   {{0x000d8fc3b922bf8a,0x000fac29b133671e,0x0006e99c4e4d8c09,0x000eb9e7eb12393b,0x0000ff3974d2793b}, {0x00094052c18df9b0,0x0003910071390374,0x0007a0b95c5c3a29,0x00096b6a77234fe3,0x00002c29a21b661c}},
   {{0x000fe2e34d74e31b,0x000f8bf79ab65a52,0x000feeb8fa352c30,0x000304e7ff6c5aab,0x0000fbe8ff0a5c97}, {0x0001ce6a79046089,0x000a34fca249d608,0x000e5e2001f812f3,0x000ee80b24bc9ab9,0x00001022c67c8012}},
   {{0x000e7d7cc5f43941,0x000c3536e142184d,0x0004aa60ab5551b5,0x0001d51e89b212d3,0x00004a96feb05005}, {0x000ef740d12bb0b3,0x000030b9677e4e21,0x000f7731dc522f02,0x000d315b12e4672d,0x00009f80382ab326}},
   {{0x00038b67c4a658ad,0x000870e72182c127,0x00098e44fb3c4763,0x00085e6b77be4687,0x0000c047df2e7a7f}, {0x000d4c55e59d92d3,0x0005b8e64d8d2439,0x000ca9b16cedca47,0x000dfe7724cd0d87,0x00005e4fd59d5540}},
},
{/* digit=18 [{1,2,3,..,}]*([2^90]*G)  */
   {{0x000344f3a29467a3,0x0009951eba6d9894,0x000e5c2f2de81e94,0x0007b3aaea066ba5,0x0000fc8a61438c8c}, {0x000f88f06d0de9fa,0x00049b75ce0a7adf,0x000bc87d5bbc11cf,0x000de1ffbb7accfb,0x00001458e271badf}},
   {{0x0003668e039c2560,0x000b7c17fd5d1cb4,0x000aa062b5f26fb8,0x000f04eee426af79,0x000072002d0d78fb}, {0x000a237e84fb7e3e,0x00002c82133d4c9c,0x0007e4181b401d8a,0x000151caa525926d,0x0000943083453dbb}},
   {{0x000ad1e6ee7c983a,0x000c141328f52f5f,0x00078d5f7eb0f9d7,0x00026efba68b441d,0x000006b3b9ed5bc7}, {0x0000255593e1ff1d,0x000d0fbec115a255,0x000a8f046552dd43,0x0001325c48a7abbb,0x00004fc56a47d0bf}},
   {{0x000da31be24319a2,0x000bc095a8e7f92d,0x00078218503f7d28,0x000dbc852fe84098,0x000076ddafe49c24}, {0x00054961d7a64eb7,0x00090f1dbe4280cd,0x00038d2d5e436088,0x000035bf81a87784,0x0000e4d52a8f5169}},
   {{0x0001cefba04b5d1d,0x0006524c735262f2,0x000c6171f9a44270,0x0006afef07966c33,0x0000b7ba891ee081}, {0x000ea59033745a93,0x000090a78f67306f,0x000251bf92aacf7e,0x00008685aa3883ad,0x000045aede956bd7}},
   {{0x000d5b11d59715df,0x0001e788983e19e3,0x000f1f248c7eaa76,0x000d82f5a730b0ab,0x0000bab8085eae3f}, {0x0000d2153765b2f5,0x0003aa127f3d65e5,0x0007b1b10bdd4e08,0x000fd34cf3c07439,0x00009f8090d01b59}},
   {{0x000e17d98119f103,0x000d188c36a6dc1d,0x0008e23df74353c5,0x000592e4aaf33a3d,0x00001e075c0a8baf}, {0x000a03a46d1ca3c2,0x000c27b660c70f7c,0x000fe2e5999c5e3a,0x00000550d0241388,0x0000e9a6be14a7ec}},
   {{0x000fd9d615faa8f2,0x0000768554ed7b15,0x000a448828fa1eb4,0x000f325bb4447e7a,0x0000bb2d0d1229ff}, {0x0002a646caa6d2f2,0x000e02e7351b075e,0x000506c628eb879d,0x0004dc9cd5624e9a,0x000018eaef0c87e2}},
   {{0x0009695241fbd6f3,0x000fd81c1223ac44,0x0006aac6f67c9b16,0x000720e6868f21b5,0x00004bd8fa428bcb}, {0x000bd33b6691c76d,0x0005681a797306b6,0x0004078db6c92476,0x0001cb9a12444ca5,0x000002e91aa3d105}},
   {{0x000684744ddfa350,0x0005dab3f74737e5,0x000e96cf49ccfc5c,0x000b8f9ac1df3f1e,0x0000c0571a13b480}, {0x000b3d54b3a7b3cd,0x00088dcdbb992fbe,0x000415b3a35c0366,0x000d9982a0f5dcb2,0x000057759b51413e}},
   {{0x00079c00b33d3f8b,0x0005c064e4090773,0x00029c8f6421883c,0x0000c77d0873d76c,0x0000fa433a48274c}, {0x000778f23a5891e0,0x000535e2de0456dc,0x000b517ced663bf6,0x0006c2488fdb485d,0x00000bba55e19b22}},
   {{0x00047d83d30a2c5c,0x000e378a81dc1fe6,0x0001a4a9b0857f77,0x0003f451d5a33413,0x00000a94af9e9d39}, {0x0005c0bdaa6ec1a9,0x0002f8d2d7edbc3a,0x000614797ba9fe49,0x0005332b4335b4bb,0x000091c4d6902f83}},
   {{0x000eee78a058fb62,0x000cdb09121aedbb,0x0004dddceb9d19dd,0x000bc4841bb45bd3,0x0000dbc80b920964}, {0x000137d1d6cb654b,0x000a983d01c54ed9,0x00028e22e1b9016d,0x00046aafc501bc65,0x00002d2f8821cad6}},
   {{0x0008c28d2f01cb3a,0x0003375db0b15325,0x0007d0db493d6eaa,0x000492a19a2b0de8,0x00001e48f0478fe8}, {0x000faf6c508b23ac,0x000975d53549f747,0x000f9b838f137571,0x000cf4df5e58e2fc,0x00007186cef67fd3}},
   {{0x000fb2f286bad396,0x00033dcad1e25e76,0x000c7e904bad9efe,0x0005a500e75190ed,0x0000a6f063e6fecb}, {0x000ed85aed8acc3a,0x000bcd20af6c5150,0x00069dbfab56ccfb,0x0000a8de0d1e982c,0x0000bf5628b1c7e1}},
   {{0x00068cee978a1d35,0x00032ab92d0477b8,0x000a5b862e3a68b3,0x00041d0102979487,0x0000f0606c38a61d}, {0x000be276f9326f11,0x0004b6fe3c2e2814,0x000df73512f521c1,0x000e4407464d7dac,0x00000f5f9d3877f7}},
},
{/* digit=19 [{1,2,3,..,}]*([2^95]*G)  */
   {{0x0001244c5f95cd80,0x0000f4ab95f4b06b,0x000e5836dda8c8af,0x000ffc1bae59c2b9,0x00007d51e7e3acff}, {0x0005e6ac2ccbcda6,0x000f2528c3e001e1,0x0009fead43bc1923,0x000710e3324577a4,0x00001a1b8848aa7a}},
   {{0x000ee31b0e63d348,0x000229e54fab4fe7,0x000e7b5a4f460057,0x00083140493334d5,0x0000589fb9286d54}, {0x000f5cc6583553ae,0x000a025649e5aa70,0x0000446520879094,0x000c4eec90450710,0x0000bb0696de2541}},
   {{0x0005247d95ea1682,0x000a0970764a172a,0x0009781691758fad,0x00001b8c803a511d,0x000099cfe2efe77e}, {0x0001e17b0a98927c,0x000060014495652a,0x00075b56a2e26e1d,0x000f94bae0af9f71,0x00002e22a81964b9}},
   {{0x0001a3ea2dee7a63,0x000c434b2284758c,0x000aba6addcde2f3,0x0000a77ba445d24e,0x00005aaf668a6cee}, {0x00004a9e5aa049a6,0x000d31103e847e0b,0x000afecc3e74083a,0x000f7a5eb183ce40,0x0000b89dea04a043}},
   {{0x000b1eda4f7e665e,0x0009c23df8e7afbf,0x00012c2f4403cce6,0x000c33d49cc83f13,0x00001cc2367571a9}, {0x000a6c0db92faac1,0x000ddc3befe17ab6,0x0003a0f36acd15e0,0x000e096f8ed98858,0x0000821de7715f9b}},
   {{0x0000e0399375235e,0x0006d9917970b99f,0x0004ec0677614c84,0x0005201ec93ce952,0x000040e7bf97b122}, {0x0000631ee4c47744,0x0009fb04914cb567,0x0009dd2266f03847,0x0001f8896e9429dc,0x00003489b6ccc57c}},
   {{0x00022a5c5f264649,0x000b1442809a7b97,0x000644810ca4c3df,0x000f81ed10986723,0x0000e495172cc924}, {0x0006968a2c5bc14a,0x000ec8de6b7aef4a,0x000a2cbb5750eac4,0x000445ae01884d52,0x0000c40830b94a5f}},
   {{0x0009d23fe67ba665,0x000043cf2f340e29,0x000fcf9139145076,0x000ddaa45b5ea997,0x0000be00843dbd7d}, {0x0003e05d53ff04d3,0x00032de91ef7358c,0x0009ec1a0bf7ccdc,0x0009977d684dbfb6,0x000067e7cf2b01fd}},
   {{0x000f1076103adf86,0x000c5e8e98108c54,0x000bd3c9b2d813d6,0x000a7651466fa85f,0x00008c65d22a0e1c}, {0x000aa40255f9164e,0x000df1a864b2b81b,0x0002ca1415b34c3e,0x000dea5602209b12,0x00007d7248f685ba}},
   {{0x000d227cc2338fb4,0x000950e2615346ff,0x0001a007689ff6fa,0x0003af7e57077933,0x00003d241c546e1f}, {0x000b97dde9b62a31,0x000490ae30eafdcd,0x000bddf7d6a06e98,0x0003c4b9bf16804f,0x000070471a2e3616}},
   {{0x000e207a6469d438,0x0000af753a85fd23,0x000b5ca72cb9f5f1,0x00078b5e2625d4fb,0x00002e4e54b37b1c}, {0x000ca5378b9e8143,0x0000e25b817a2cd0,0x000cfd965fcd4405,0x000974868f719f30,0x0000164471a0848a}},
   {{0x000a8ae3113655ef,0x000a67b83180ff5b,0x000e0eabefa2c6e2,0x000a962c48271977,0x00009f3c556237fe}, {0x0007022a42581cb1,0x000208f710e3340f,0x0002e5aa8e1de0bc,0x000940de640adef6,0x00006b2389159428}},
   {{0x000738f25f653f59,0x0007a764f6355045,0x00011ffc3e42b8cb,0x0004aa24f89406dc,0x0000959314546b3e}, {0x00049f3c97400525,0x000105ffc48b81c8,0x000f67a492c9cf4c,0x000c621299e52177,0x0000869f6e4100c6}},
   {{0x00019e455950cc3a,0x000bb6b66bb83616,0x000ac6d84c71d665,0x0007e34a034b34af,0x0000987f83385e4c}, {0x00027727a79a6a7a,0x0007426d6c23a074,0x000167e1056e5d01,0x00084dde50b97638,0x0000a6c81f0888aa}},
   {{0x00086f75fe015763,0x000caea51395b841,0x000f3f8d4446e276,0x000142c3c5ef8105,0x0000d7f7df6a4f7f}, {0x000b565f9ef16565,0x00042c414ef67c69,0x00029206087efa42,0x0001ae9b7e620d3d,0x00000b1de34beec2}},
   {{0x000f3b7b0dc85957,0x00082f1d9f2e0ca1,0x000dd82a727de460,0x000447aaf3bf39ba,0x00009356a79d5862}, {0x0002345f5f9a0529,0x0008839a42f9c060,0x0004d40fc1a8b0f8,0x000368253eee4284,0x00003b0bfe5de5b6}},
},
{/* digit=20 [{1,2,3,..,}]*([2^100]*G)  */
   {{0x0003a5dc8de610b8,0x000ae7e223ce0f89,0x000ad6dc5e8c515f,0x00028ef774bfa64e,0x00009d20f96125c7}, {0x0000966098583ce0,0x000493f2a7d77a1e,0x000304d4aa2eedb9,0x00082d1b2820974c,0x0000842e3dac0772}},
   {{0x0000e9d74cd06ff8,0x000f2ca3eeaca101,0x00063aa2b9c17c7d,0x0004fef4c86cd380,0x0000595c4b3f3461}, {0x00000ca990f62ccd,0x0002fa0c3be5a3de,0x0008ce9f5d9bed21,0x000443a886078adf,0x0000db27ce42cd44}},
   {{0x00097befc15aa1ee,0x0007d54b07455a30,0x0009a5f1240d1254,0x000ee57bad470651,0x0000d03f7188439d}, {0x000bb6c4a02c4997,0x000d5ffe71d20794,0x0003adcaff725083,0x00030fbcad75190f,0x0000f68ea1cb3729}},
   {{0x000581d26ee83821,0x0005259d638e9c7c,0x00028ae3dcf17dcc,0x000047de8273abb7,0x0000d1129270821f}, {0x000847750491a746,0x00019de0dfb91149,0x000a435ab687fa76,0x000e3ecc2580227e,0x0000b8bdb94f1ce7}},
   {{0x0006d8af7f91d0f2,0x0001882a57289c80,0x000d767543b61b0f,0x0004c62640032d94,0x000073eb5de67d83}, {0x000abf77b4e4d538,0x000f5e4017772988,0x0005071b3b7ce66b,0x000a981fba6b3271,0x00002413c252d3a1}},
   {{0x0007b7e3cc8ac855,0x00078d02753b7553,0x00037df2f8d725f5,0x00031dad05ff64b7,0x00005fe871346d25}, {0x00004a96ab6b01c8,0x0008fcd9372457ce,0x00086699b69a02a8,0x000231cf82ac35cf,0x0000242d3ae1cb4b}},
   {{0x00035269be47be0e,0x0007eb28fea169c4,0x0006c67e5323b7dd,0x000e461a5538ba3a,0x0000f921d70fd378}, {0x00061fc3c4b880ea,0x000df8940a67f929,0x000f0ff393f6f914,0x000f9c0990eb0afe,0x00006c2921090eef}},
   {{0x00003a553fb2b560,0x00074e057f78b23a,0x000e490d96ce141e,0x000e75796525c389,0x0000bc95725a31a7}, {0x00067911220fd06a,0x000ba08b0bd61ec5,0x000ebeba9716e3a3,0x00066f91cd6bf7e8,0x00007326ca75ee6b}},
   {{0x0003d32343bf1a9e,0x000757d1a6b170b6,0x0006865b48fd3bd2,0x000fa12454879c31,0x0000e959ff7a458e}, {0x000dcf89706dc3f5,0x0001c64e4b2e0461,0x0008843c8737db0e,0x0006f5b92626802f,0x00004498bbcc745e}},
   {{0x000352b5acf6e10e,0x000ccfe652c35341,0x000577a7fc50343f,0x00023c6af3792d18,0x00001a4c6188f168}, {0x000d0cd33425d0a3,0x000d6b7bc47f9b26,0x0006bb20b306399e,0x000054fa792f3370,0x00001219614c8111}},
   {{0x000428cd5f30851d,0x00065a4f66304c1f,0x0005d48a494dfed2,0x0000cd7df53772fc,0x0000d2d5a3063326}, {0x00015bdd44cc7a57,0x000d4d12533a5741,0x0003057c94ba6b20,0x00020dc0e93cb824,0x000094c486a84de3}},
   {{0x000355699f241d77,0x0006901a349d6095,0x00089e491ee4adbd,0x0005459b35bf6aaa,0x0000f0076f4836f7}, {0x00018ba9264da3d1,0x000d52a7a28bd19a,0x00061c9716eb2d2c,0x000a5dbdba941f87,0x0000550518bb3be4}},
   {{0x000d97302f1cd1e1,0x000b0dd212a4c232,0x0009802f7ce87eac,0x000dbd5e4c8c73e6,0x00002ef02902fffd}, {0x000c74e1bcea6e23,0x00040cb92cbb941e,0x0008f9d05d0b5402,0x000aae509fb9d47e,0x0000bf1615a22992}},
   {{0x0007007eafbb1e1a,0x0006475b7a93b249,0x000b68d78d75c9ce,0x0003959558352def,0x00002f26699c23f6}, {0x0001ecfe469b17ae,0x0009072d3ec2eb91,0x000cb113f6254577,0x00098caea47de782,0x0000be4b0872e1fa}},
   {{0x000e675b055cb405,0x000b477b5167bdb8,0x0002fb863898f8e7,0x00001f9cc65651b8,0x00006544814bd88f}, {0x0008e95263a75a91,0x000f0a22fcdab092,0x0003bd37ccfb6836,0x000664551d14db3f,0x0000d3837fbc6ad4}},
   {{0x000c982cf7d62d27,0x000cb3ba815020d3,0x000763f9e1f36e29,0x000006d8ae0bf092,0x0000a527e6b8d3a7}, {0x0009097581a85e38,0x000f5c158be5b4a8,0x0007d726e1f1a520,0x000862798db37d16,0x0000802786e9113e}},
},
{/* digit=21 [{1,2,3,..,}]*([2^105]*G)  */
   {{0x000149e36f09ab05,0x0009fa10bb5befb2,0x000e2099803f163c,0x000bab8029704506,0x00006f0af006b5a3}, {0x000cfec70880e0de,0x000ede3d913f7af4,0x000ceb4bd7332a66,0x000f5452e6c84a7e,0x0000dc4a79b7c228}},
   {{0x0007dd0c55c44969,0x000695bbabd2c37c,0x000d7f363a6a9635,0x0001decb7e63f2ad,0x0000dce3782be73f}, {0x000a16ab2b91f71a,0x0002bba0163ce1e5,0x000e515ade448982,0x000ecf52759c32f6,0x00005e2f1f92615e}},
   {{0x0009be7abded5516,0x000868b744107451,0x00010d9a903d358b,0x0002b6ed00b10b0e,0x0000392b0b188da5}, {0x000a2980b75c904f,0x000db8f7f96c6744,0x0002cf932c305b0a,0x0006c9142e421d18,0x00006fc5d518e463}},
   {{0x00047c9d64cc78c4,0x000b5b6cb27b7958,0x0008022ab6c50621,0x000a1cc7099bf8df,0x00008f862ec004ed}, {0x00032ede1603c166,0x000efc9a9450d127,0x00029b4fc19a80e0,0x00051582257f54b4,0x00006d3b2c6a5460}},
   {{0x000f87e822e37bef,0x0003353bda4e6ca4,0x000190aeb73f237b,0x0002840747f3a241,0x000006fa370704cf}, {0x000bb6efc621c127,0x0003d0b80ec60a6b,0x000a556f35d624b6,0x0000a7db0724257b,0x0000fa0c354ae2d2}},
   {{0x000fa31e3229d41f,0x0001a4531bd4e921,0x000d38209a929c65,0x0007bc94156027a6,0x00003d69f745bdb9}, {0x000d19a168336319,0x000d73d51be38906,0x000511cd868a34c2,0x0002a83b59583b0e,0x00009ce6bfe8dc13}},
   {{0x000daaaffcdb4631,0x000a24a38b083fac,0x000a9078d658bbc1,0x0005de02a801f8f1,0x0000567bcf97ab85}, {0x00098e03572359bb,0x0004d659e68be084,0x00023807ccf0353e,0x0008a20b86e9c87d,0x0000c08728dd198e}},
   {{0x000b7bc453cadd69,0x00072c0bc1f88de2,0x000abd3af203900a,0x000ffb2cd86e47a6,0x000011cac131502e}, {0x0000242ec965469f,0x000139e0017e2d55,0x0009798850e9f769,0x0001ee733f078f65,0x0000b87d44a3cf75}},
   {{0x0000e4bfc25419a6,0x0002ebff3cfde179,0x000b6e83f3646720,0x000fd268db638625,0x0000cc69f23ccad6}, {0x000e45a6bc68bb94,0x0005e97f73340219,0x0005dc97ce43d79b,0x00049a3d44536846,0x0000b9eea326a0b9}},
   {{0x000c6ba6102d0212,0x00080f4461ea1b96,0x0009f19a8eaafac7,0x000875b4b85c41c4,0x000075c28e4ef538}, {0x0001a9ddd2e54e03,0x0004d605618b3545,0x00036cd246991adb,0x0002162b8b4bcd7b,0x000072a4f8c86f37}},
   {{0x000bd73a6a5da60f,0x000fec4c9ff0c890,0x000536e576f083d9,0x00024304e14d94f0,0x00009ee1edb9aec8}, {0x00041ec8bdcf8e7c,0x00004b041e265712,0x000fff040a5db827,0x000201da0b9a99e3,0x0000aaf21de3c271}},
   {{0x000b2e14f0dd2e8f,0x000e1a377ac7b4e2,0x0007a2198e77e7c4,0x000eb779202c3f0d,0x0000759b80018200}, {0x00026eddcfe314e5,0x000403d5cf99c875,0x0005138b6eb84c52,0x0003f461b52ace51,0x0000aa7ff8c73fca}},
   {{0x00013c3b9791a263,0x000a9dd58b16ff0b,0x000aad2de960022d,0x000619abd55c9257,0x0000baaaaa4230fe}, {0x00023460d881efdb,0x000f96325e2a9a4b,0x0005c18d4506416b,0x0007afe1381e7603,0x00003bb68bfa2781}},
   {{0x000b8bf5116f9379,0x00063126894315bf,0x00019a2c87c64a58,0x000462e1e25cc384,0x0000fd6b0c51335f}, {0x000ba3ce8ee0e0e2,0x0000098c21fa4bf0,0x00066bee06f6fba6,0x00054437d57b39ae,0x000092d513042672}},
   {{0x000105dbab093b30,0x000902839986f451,0x00074a89c012f59b,0x000e978a91580234,0x000048c919c2de03}, {0x000a2b591071cd58,0x0009834970a5c476,0x000b7994b791ed89,0x000ffd09bd9042e1,0x0000eaf517a21057}},
   {{0x000e2a2d551ee106,0x0008127e09a66066,0x00001148d87a8f1d,0x0003fda0d08bab2c,0x0000da8e4f1a24f3}, {0x00017f0cf9a4e718,0x000fbbf5cb19466d,0x00062ecc0ff50200,0x000ac45ccf97d8d0,0x00000c0d9b001d80}},
},
{/* digit=22 [{1,2,3,..,}]*([2^110]*G)  */
   {{0x0007ceb1bf4581ca,0x00060ca7b1669885,0x0009722ace635e18,0x000006878ddd2265,0x00000903c4cbdb68}, {0x000458948f214029,0x0004296abda2366e,0x00040319031b49c1,0x0003fda29c4b09e0,0x00007197ca4629f4}},
   {{0x000de1cf3480d4af,0x0006cc8acf1a03e2,0x000295a9cf0d8edc,0x00097d023e330368,0x0000add5f69b546a}, {0x00097ad96f8acb1a,0x0004c71bdae28955,0x000dd43f4bddd49d,0x00041976fcd52821,0x00005a4541306191}},
   {{0x000c79f439f29cfa,0x000fadd82a3bfa32,0x000a2c1b17bf321b,0x0006185f127f54ea,0x00008365f2e935e9}, {0x00029024d0ef8dd1,0x000149228c4a852d,0x0005afed3395ce2c,0x0008e3a69f44e821,0x00006c1f898c2745}},
   {{0x000b6bfc360e25a8,0x0004875a1a788ce9,0x0001732f4e642519,0x00057a1dc756a848,0x00003c0440fd432b}, {0x000b3f1d720281f6,0x000e7135e051c670,0x000052be72205910,0x000a397ed14b0edb,0x000097b3d282568e}},
   {{0x0009005dc4532331,0x000a1fac4bcfdef2,0x0003d55acc208c47,0x0002075057a3feac,0x0000723725da02c1}, {0x000c62733eb0fec9,0x000b2b3c63bb9c31,0x0003058384913ccd,0x000d96813e542b07,0x0000d48e72ac10c2}},
   {{0x0004ec4d9bbeb3da,0x000337b2921c5442,0x0006d37c534ceafe,0x0006afbe68022e29,0x000028e0a2bd59f1}, {0x0002dd9bc3f9d739,0x00092af3e1fffdd8,0x000736dc46939a8f,0x0008e6c5cff45c31,0x000010f56430892e}},
   {{0x000b349dfe392607,0x000703549093de09,0x000853b02984612f,0x0007030cede28167,0x0000d809bb499d17}, {0x0006bfb2756c4f00,0x000a93f02b80450b,0x000ad9561c59ff9b,0x0002c73e69545720,0x0000c7cf0be3331e}},
   {{0x0009b9afb3ff9ed0,0x000b17f6515c2e59,0x0004da44928c2e0a,0x0004521cbee4fd47,0x000071279a44f364}, {0x000ff6601fbe8556,0x0007ffda51c497ab,0x000597c0b3ee394e,0x00034ab90385f667,0x0000e9fccc7027ee}},
   {{0x000d419362fb228d,0x000136aa0be4ced2,0x00094b197894637c,0x0001e7aa4fc55eb2,0x00009cbac1dcd4ca}, {0x00074800ccdb6ce3,0x000550dfaa49068b,0x000033b78ca4c556,0x0008a7b835382176,0x00005db7525f5ce9}},
   {{0x000927274fd1997f,0x00010fadeb588cf5,0x000db260c987d203,0x0003bd6647c6c3d4,0x000008bb13c88554}, {0x000eb1056fad695f,0x000d78334cc7566e,0x000dd1db239e17dd,0x0002ff9a97b3bb7d,0x000091199d9b1c5a}},
   {{0x000a437bdc47fe45,0x0002ff3751f0402f,0x00057d48535bd252,0x000cb63c2281b7cf,0x00000083ea5df607}, {0x000e480df6d730de,0x000db1bb06a26f41,0x0001fb48a1164e47,0x000da6f9040c2239,0x000012df252ba23d}},
   {{0x000de9314092ebb4,0x000d028e240c0b89,0x000d2f064f17256b,0x000b148f89a7f393,0x0000f57841f21ed3}, {0x0004405e708d8553,0x0001d3f1c3d04ee1,0x000d7eed5856aae7,0x00027098e5424fbd,0x0000333e4efa3ab4}},
   {{0x0002b5148f835b12,0x00030adaaba8f9cf,0x0007beade4a70faf,0x00003280d2e24fed,0x0000b1e4e6735f04}, {0x000c0b91fb3ceeef,0x00054a54b0b4eadb,0x000d4a188b817b08,0x000e5f24a787257f,0x0000f13304713482}},
   {{0x00012ec4efe42dc3,0x00029664b2bc3120,0x0008f9cb97251b2c,0x000465696c2e6b79,0x0000543376a6b8f3}, {0x000e8416fbfb6a97,0x00039cb91a03337a,0x00002d855e0893a8,0x00073ee3744e9d7b,0x0000e673186906d4}},
   {{0x000996f3ef143db6,0x000dd99378bc9509,0x0008ccc899cf1e82,0x0006be559cd09b0b,0x00004b4a2fcb2cda}, {0x000a8b31bcd55df0,0x000d2507cb37d3bd,0x00010e49bfec4e87,0x0004453d48a85eb6,0x00002fbe1bd1f9cc}},
   {{0x0007adedda492f81,0x000a682972053bc7,0x000931b4cc11a3ae,0x0004bb4e89a3e734,0x00007512e2eaf569}, {0x00049f3177bf8b6c,0x000948c7ff3e5dc3,0x00011145d232ea4b,0x0009c2dc4f9d16f5,0x0000cf109a3f3b37}},
},
{/* digit=23 [{1,2,3,..,}]*([2^115]*G)  */
   {{0x000857080eb24a90,0x000d488e0cfd60e2,0x00059cdb87bedfb4,0x0000a9721ebbd7c2,0x0000b0da855bc639}, {0x00004dbde314c709,0x000bdc32e8462b4d,0x00062fc9ecdbf1fb,0x000ab6a3833eabb1,0x0000939b48c40dd3}},
   {{0x0002c1f711b0eb9e,0x0007980ab9549689,0x0000792dbb905f2c,0x000125cce26309a2,0x0000c8ac9b3e684e}, {0x000d8b6b40a24474,0x00015fe3fb24486a,0x0008e3b3f60121fc,0x0003941626fccf1a,0x0000e568622aad1f}},
   {{0x000bb22236f4a982,0x0008e66800bb5cfb,0x0009a77740b0c59e,0x0009482ac69a8f5a,0x0000b33f804f6bec}, {0x000929532e6c4662,0x000f2e599c73b372,0x0005c31cc68956d0,0x00084e847a249f15,0x00004d80f0e01ce2}},
   {{0x00046c64a8a3d626,0x000fc47743d25a4b,0x000f7e4338469c4c,0x000848cbb3a13d88,0x00002b23a1061be5}, {0x00096b4a63d1a4c4,0x000a3d183f3ee835,0x000afb01c454e7fe,0x000638243fce6117,0x0000e65e5e65c4c3}},
   {{0x00030e3dc09508b4,0x000f34317655b7e8,0x000690355faf6d2c,0x000ed632606cebdf,0x00008bb92b410c3d}, {0x00054845c7cf8929,0x000945d5f01f65b7,0x000401d69f6cd7ac,0x00087832c30a5996,0x000012686517d921}},
   {{0x00077176add85450,0x000672c49b66e5db,0x000421d771b71cb6,0x000fead856073968,0x00003840fe883e3a}, {0x000dad51ec699775,0x0008e07f6726b391,0x000ca160cae243fb,0x0005f4788ac87be8,0x0000174cced9ce35}},
   {{0x00067f8ff81578e1,0x00008045447d7520,0x00005aa6f7862215,0x000c77b0c22fcf05,0x0000030f0a67bed1}, {0x0009f151f0bd7390,0x0007e6debe8531f2,0x000677e982d7989c,0x000fd55c070e728e,0x0000a817bd306e81}},
   {{0x0007eb6cbc613e57,0x0004d97ea61cc1e1,0x0007eded533131d5,0x00011abf69d39eaf,0x00003c2f4354e6af}, {0x0002493a4a375fa7,0x000c4833c5c24ca5,0x0006e71cf5f06787,0x000666114e091f3e,0x00006451f57fb746}},
   {{0x000e082e1539388e,0x000f959a9c6b01c7,0x0006bacfbfd286f2,0x000e52b458104117,0x0000580f07d1bc3d}, {0x0006f75884d772fe,0x000760bb9d4fdcdb,0x000083011d75c3bb,0x00098cfc6c2e4edb,0x000018789a3ad9c2}},
   {{0x000ab8495fe1347f,0x00087f24503c5ee6,0x00086dd6bab0f6c3,0x000ef4907e3ffb44,0x000000b6c757002f}, {0x000f9a6a78629992,0x000c9ed89e2648bf,0x0008419eb85e5a06,0x000f1666d311af3d,0x00004f3ad7854733}},
   {{0x000551311820d440,0x000c86c4473a5e20,0x000d80eef0c651bc,0x000be51d230c2b9b,0x000042c4a1207515}, {0x0007ca0bfe9e2841,0x00081369827a4251,0x00038699de8f6057,0x000d05084f04f016,0x000074618ee02bc6}},
   {{0x00003fc6c68d6876,0x000cbff052c75e3e,0x000d16e7a3e732c3,0x00074692d0efa66e,0x00003d92b27165bb}, {0x00082badd44867cb,0x000e48c081b8ffcd,0x0006c8785a71b4a9,0x0002cfbc1676a773,0x0000e2c06174d893}},
   {{0x0001a4b9eca1c9f0,0x000c8ce5e5357bfa,0x000eec30a960bc1d,0x000d38e267d9f317,0x00006fb89ef6c257}, {0x000999ad364a26d0,0x000b26eaab582328,0x0005ba59669b794c,0x000a94ad28ab1fb8,0x00005dcbff356d0a}},
   {{0x0006d282bcffbc46,0x0006a6eadb7a5337,0x00035ae69708817a,0x000fde0ff50e05cd,0x00003b5fb75d4bc7}, {0x000e953e7fe08c4a,0x00045583ca1871c9,0x000e81c5cb4d8bfd,0x0001383e8d788245,0x00005f5e93d80474}},
   {{0x000160f293c9f316,0x00038864d7a7426c,0x000bbba308eb5633,0x0003025e1164023e,0x00004c2bae38fd5a}, {0x00001e1265aff7bd,0x000f96fd4b148006,0x000075a9c52d8a87,0x0004c58aba20e746,0x0000aa32bf94e123}},
   {{0x000bdef694db7e04,0x000779fcddc680f9,0x000b8dce1edca878,0x000ba111981c3403,0x0000274dcf1b0e10}, {0x00043b86def6d1a2,0x0000cbdb1866f727,0x0000c6f58d25b167,0x0007f5a4491e8c05,0x0000be2b2aba7fbd}},
},
{/* digit=24 [{1,2,3,..,}]*([2^120]*G)  */
   {{0x0005c9dd111f8ec7,0x000d47c4e7603e0e,0x000392a51bcc33f8,0x00092d002f9a91bd,0x0000da4a7963132e}, {0x0000ae30bb1151be,0x000722e322511a0b,0x0004e9e7854febac,0x0000b80a3a508269,0x000058ffec2c4fe4}},
   {{0x000349d29c4120ba,0x000f20d0d915fbb8,0x00010ba519f94391,0x00091124074fa754,0x000066adbf6b50a5}, {0x000543c34bfca38e,0x000fd9e1ccfcc164,0x00020219ce0f2755,0x000979b9da0f53e8,0x00008234499a6b49}},
   {{0x000c513516e19e45,0x000775c4d5937b23,0x000e71ef656e2e84,0x0004c54f727d735c,0x0000b6304a7479a4}, {0x000a7363ab7e433f,0x00000e742f836638,0x0007fc19f1adea47,0x000697f054b8545b,0x0000935381baa1d0}},
   {{0x0004f9d918e49366,0x000652513982b550,0x0004d9cb965035ef,0x000508a553a0c26f,0x0000cb10d571ea85}, {0x00057b7a242da112,0x000d472b726848d9,0x00002a96b16a4d3d,0x00063b1d7e637c85,0x00007c7032b930d4}},
   {{0x0006b7d5846426f7,0x0008b47d441d5536,0x0006fbf48e7d09e8,0x000d7ce10b404d73,0x0000fa003d15784b}, {0x000614f17fd95965,0x0000e5cb98db25f7,0x00083a76a49e0e0a,0x0000f7dc65957b2e,0x0000d40da8e1ddbe}},
   {{0x0008bb4a595939dd,0x00085874021737f6,0x000ad76120355647,0x00095ebe740e7c84,0x000089bc84460446}, {0x000da5d85a9184d6,0x000b3fc0b074f7f3,0x0008a888e562563b,0x000e7ba6d2e6aaf8,0x000012d8643761fb}},
   {{0x000bba354530bb24,0x00078b0869ea9fb3,0x000431163bde3ef7,0x000a3549bc90460b,0x0000d03d7d324819}, {0x0004f9e43b6a782b,0x0006ec88a68633ae,0x000ffedd9216db30,0x00083fe1dd88e000,0x0000280da9fc2bd4}},
   {{0x00086913e538cd75,0x000c3e08ad53458f,0x0005d15ffa7001f6,0x0005dd02b8c6e6bf,0x000048234a451121}, {0x0009d2d3d5b40458,0x0005ca904190ff5a,0x000607f8bb0ffeeb,0x000729d5a3aca448,0x0000cbd665cb0a06}},
   {{0x0003573f37f59371,0x000dc1e4fca5a37f,0x0008ab0fceb0f6c7,0x0006ac1965a554ac,0x00007fbf56c37467}, {0x0006bd9acf7d720d,0x0007402247662e2f,0x000d53bef41fc8f8,0x0007d0817a14b385,0x0000ae327a64d76a}},
   {{0x0005c891f5f82dce,0x00068361079e515d,0x000a353309a7f67d,0x000e1ac8da81e311,0x000044990c52b18b}, {0x000ed95af103e596,0x00072dac9261c7d5,0x00094b8d3ece8aba,0x000e835e82b09993,0x0000830f09a76adf}},
   {{0x0001ac194d7d9b17,0x0002582e7f1743c4,0x000da0fca5bafdd8,0x0007ad6f0614c15f,0x00004b043a818ae3}, {0x000afa19e71734c5,0x000e4c450f2e3ba6,0x000e242b115d5437,0x0003c1fa5883fe67,0x0000143bdc27c195}},
   {{0x000ce7c6b53f5f95,0x0004cb176d99a2a9,0x0005c081b6424659,0x000ee661298d36b9,0x00003505bb86d9a9}, {0x0009e61f2ba70b0d,0x0008bafad4533f6f,0x000eb4a6ad07e16c,0x000c8dcf1694bbe7,0x0000febceda0cb0b}},
   {{0x000d7f2b1f3390b4,0x000c65b61272c676,0x000e127a99f7a1b8,0x0007bf0ebebfc9c2,0x0000602500c9dd99}, {0x000771c4711230f9,0x000b720f09c17f09,0x000e5e38b058eb37,0x000bc01b693d4bfe,0x0000289eb1fd653c}},
   {{0x0002b391770f5a7b,0x00005e44eb82a44d,0x00069712ae4d4d79,0x00020d92e69d1e3f,0x0000f11c4d75c6a8}, {0x000f3e542c4224c6,0x000be49d941cb5e7,0x00050e878d6b4e81,0x000c53fd72bd1654,0x0000a61e28b4e25a}},
   {{0x0009dc7ab952578a,0x000186e84d0b54da,0x000872042b5423df,0x0006df08b64eeb9b,0x0000c205782f990f}, {0x00096eb21f4c77af,0x0003bab273af4ff6,0x00036b3f11a79c3e,0x00027939bc922e94,0x0000f807ef9c6d9a}},
   {{0x000a8f833f6746cb,0x00054ea990cac7f3,0x000ddb0a921e46f6,0x000554e15fd5c5ca,0x0000d41f01728614}, {0x0004434426ffb589,0x000584dbc204346f,0x000969b7f8055943,0x00039a63dd20fe5a,0x0000d59e9577899a}},
},
{/* digit=25 [{1,2,3,..,}]*([2^125]*G)  */
   {{0x0000ba9b733aa5fc,0x000b305af2353c2f,0x000ac82a5dece47c,0x00018a38e3f715a2,0x000097ba641e203f}, {0x000550409c110608,0x0004c6af512dc3af,0x000f2814656ea2c0,0x0004947ac28daff3,0x00007fab43b159ef}},
   {{0x0001641d4c5105f3,0x000e3d7fbd650989,0x000e6bdb01ae80f8,0x0008606d67225fbe,0x0000b433b59afc4d}, {0x0006db693e856387,0x000273e9862f44e6,0x0005c32ecf7b5925,0x000f506b78515766,0x000002fefd81e362}},
   {{0x0006a5c97290293f,0x000be388acbffe75,0x000916bdabf04a19,0x000bec0bbbb9cf5e,0x0000489527481f93}, {0x0007ec32a5923d75,0x000bade0c370dee0,0x00019d8fcc7bc949,0x00093f6d51217504,0x00004f5d4768fdcc}},
   {{0x000475d0fefb0c3a,0x000aa6d7c35d3754,0x0003798a4d48fb56,0x0008e60070b63336,0x0000e89f3d32fdb9}, {0x00089c86363d14cb,0x0000b7abd27d970b,0x000d5a0218981752,0x000aedebf7d47444,0x00003083bb07ac72}},
   {{0x000a2ffcc5e62e9f,0x00046edb02a40acd,0x000120c763b8b7d7,0x000063b700741c66,0x000077e84806d974}, {0x0000678a5e3d4647,0x0002d6bf35a30d31,0x0002f9043de68b1f,0x0000cb5ae83028d3,0x000024e4717c17cb}},
   {{0x00041debe949a447,0x0007e46a4fa53897,0x000047bdc638e938,0x0007c9cfe6419ca0,0x0000047f6491aea5}, {0x0008a9041fbab170,0x0008576bdba254e4,0x0002afddcda8e0b2,0x0007bfe807eebcc7,0x00007d3336df4257}},
   {{0x000563b4f3011dbc,0x000476610c03fae8,0x00081af0bda33776,0x0008ebed4f6f2a63,0x0000277984d99537}, {0x000a10c5751d2b2e,0x00089a4bf3f45ab0,0x000e3caf370a18bb,0x00036058d07ad4ea,0x00008ef5530cc430}},
   {{0x000c244bfe209256,0x00032fdce86762a8,0x00038706391c19ac,0x0004f5fa96a5d5dd,0x00001d587d481d32}, {0x00073a2a37173eaf,0x000763778b65e876,0x000bab43e2384800,0x000fbd20f8441e05,0x0000a11fe133621e}},
   {{0x000389a8391d54b2,0x0008a8afe546edd0,0x000e60bbddac74c0,0x000b876525a4ad5b,0x0000419ac96b0ad7}, {0x0003a0277eee51b9,0x0005e239768d078a,0x000d48035e86ecf3,0x000a5b3b0a259d8f,0x00004db43cc2d29c}},
   {{0x000772e81685d7b3,0x00018f34a976047b,0x0005f48ef23f27d8,0x0005c3927608e291,0x0000b0b43fad521d}, {0x000fb2663ca72840,0x00041d4db8377613,0x0003b526b7f5729b,0x0003d187b1489858,0x00000b732a6bbadd}},
   {{0x000a25b90f8550aa,0x00027c8dae9d4fff,0x000fbb232254db3d,0x000f0eb8cef963c1,0x0000d1cb48244bfd}, {0x0006ea1958773c2f,0x0003110114f184d2,0x00051e67e5862266,0x0005c5fadb3a87f0,0x00003185723a69e4}},
   {{0x000f4262048e3968,0x0005b83d9de48e02,0x0001e85ad436b50b,0x0008d6778d348147,0x0000b01ea6b5005c}, {0x000afee97015c07d,0x00087e3ba2aed3c7,0x000d3a1d246cdf1a,0x000ff3aa42e50183,0x000054b52698541d}},
   {{0x000c4f948a48e22e,0x000df0335a96e120,0x000151c7bf24977e,0x0008d7baf3442336,0x00002815a80b3664}, {0x000deba66e0a6b21,0x000f717515e8b4d2,0x0003ff24a783a84c,0x0005d968424c0bff,0x00002dd1bb648e1c}},
   {{0x000cf304e23e9bca,0x0005726e36243f24,0x0000b6d614387f81,0x00077b86a46a033b,0x0000f1bc8462b2d7}, {0x00001ba527de79c6,0x0003e261bbb625c4,0x0007b4bc70e1346d,0x00062eeb96c44b28,0x000058493c7b2545}},
   {{0x000e9d8fdd41d983,0x00018cc7c7fbfcb0,0x0008fa4d98be980c,0x00088d772e86506f,0x000056b14ada48cb}, {0x000ccefea6178f26,0x000d18bb0e35fd9f,0x000f391a9c84a620,0x000c055c75367c62,0x0000a83a5c683100}},
   {{0x00049feb8a24a205,0x0001a52ca53f23f9,0x000fb485317ebfed,0x00005d4b691bbebc,0x0000617ff6bb278a}, {0x00034c5e3c99ebdb,0x000d6784156a241b,0x0005d67dffc64242,0x0000109206482f69,0x0000967ce0f9e27c}},
},
{/* digit=26 [{1,2,3,..,}]*([2^130]*G)  */
   {{0x0000f0441c23fa36,0x000061989a2eb448,0x000a29ca7b4712eb,0x00028bdccbba0f93,0x0000e205c1536194}, {0x0007957b36416860,0x000d45ac8b4e90db,0x0004e03500432691,0x00051707a759acf6,0x0000514d89c9c972}},
   {{0x0002c6bc4fe3c395,0x00031c7bebdfe3b2,0x000693459ba4a815,0x000b11a23ab6b725,0x00003bc377064922}, {0x000c8ab5afc60db8,0x0004a0b9f2a34645,0x0000fc507aa02235,0x0002e6d2a2954cce,0x0000c2731bbfce1c}},
   {{0x000efb6d9790ed61,0x000c96aa793b5066,0x0003e042ea77a0cb,0x00074b0a915f3c22,0x0000c5def0479c58}, {0x000007873b6c1da8,0x00027cd8557a0e83,0x00060f3b155cf85d,0x0000628f7c7c7604,0x00007052acbc6e58}},
   {{0x00091c2e48fb8898,0x0002fb8a9d066a70,0x00082a0e226882c1,0x00052d224986631b,0x000044ed736b5181}, {0x000476fd86e27c75,0x0009b4afefdc282f,0x00019e34da04edac,0x00078b3b256ebc61,0x00006a413e95787d}},
   {{0x000b6a20d645fd62,0x000dd61d314816ea,0x000079ae9632cbd8,0x000cbbac1bf7cf62,0x000057ee5c8133ec}, {0x00034a81680ac730,0x000872c77aa0bf6b,0x000a0a1d1aa084e8,0x000b167b5a864e05,0x0000641f6db359a1}},
   {{0x000095dc8385050d,0x00050f4b441cf01d,0x00027706a0d54a5d,0x000b7d5a37ccb409,0x0000f008f5515d7e}, {0x00034f35bf716c71,0x0008541bd6ca74eb,0x000e6fa0257a65b5,0x000a09df345e4835,0x000091f913b98342}},
   {{0x000d46da670ff1d2,0x0008ab97a1cc1554,0x000d9749324833d8,0x0004986fa6ab3cde,0x000015e0371a9926}, {0x000d592e56d74ff8,0x0004c3b5e1ec549b,0x000e93cb958a8caf,0x00083bbc6087a323,0x0000b054987d648b}},
   {{0x000061d5a74be506,0x00047ea16ff582ee,0x000bfc8a2e41781c,0x000e2d80b0c81e99,0x000024f4d696b547}, {0x000545dbdcc9ae4f,0x0005509b1e8e3a83,0x000c935392573dbb,0x000797582960c4a6,0x000001059ae4ae18}},
   {{0x000a238013ff83b1,0x0002ead69d08c431,0x0009589ea7c0018b,0x00019f89aeb52a4c,0x000021f41abab1cf}, {0x000bcbaef0f59585,0x000b2be8fbdc0cfb,0x00015aa318deb3ae,0x0006fcc2b954081f,0x0000acc09b39c0c0}},
   {{0x000bfa86d518ffb0,0x0006930f124b775c,0x000e81d0fdecee1f,0x000b2f9a402804f5,0x0000e8225c52a0ee}, {0x0005d39fee9e867d,0x000f2b505454884a,0x0007a70d19540428,0x0002a9e2bf2e2010,0x00009917c3c7010b}},
   {{0x00042fa3d843d538,0x000593ef927aa98f,0x00084ca7433777cc,0x0005dd4440cdbecb,0x0000c22f9639dc7c}, {0x0002b70c8d947081,0x000cb814364f4bc8,0x000f59b7e7e0b43f,0x0004c4186d4e2486,0x0000abc895e5d6bf}},
   {{0x0001e274d559d96d,0x0002e8db6c013815,0x0009921af4f18c0d,0x00002879a3aa836f,0x0000beab27c5c046}, {0x0009eaa7040bf3b5,0x0004c614b091242b,0x0004baf5d39c479e,0x000944e38ede2b0e,0x0000bb192b840a53}},
   {{0x000572337e440d7b,0x0008fde23f68896d,0x000c64918685c5fd,0x00080c05b1a26dc2,0x00009390e318ad65}, {0x0001c4e7dee5b9b3,0x0003aeb04f6e8791,0x000065aa6b90c505,0x00028d07b942a18f,0x00004acdf2a4ca09}},
   {{0x00064d39de40ca36,0x000f72f3857e733b,0x000ed92f71d4b6d6,0x0002485e2be8e9b2,0x00004ca7048177da}, {0x000ae9b8da993153,0x0004dfc698a4c65d,0x000958c279c14517,0x0000975a296b94ff,0x00008684e0873950}},
   {{0x000e34b3390ff239,0x000b4e7d18ef7872,0x0007fe7b1968ce4a,0x000e2a0b4a745e62,0x0000607b0a15aff3}, {0x000818eeb40e3a5b,0x000410fa8d7a1b05,0x000ed48096ac6220,0x0005f205b9058571,0x00002432ef1a7cb6}},
   {{0x0009f973112795f7,0x0007284e6ee1715c,0x000b66bcde824443,0x000bede5cb4858ec,0x0000c1367361baff}, {0x00015955dbec38e2,0x000c188ad1535466,0x000e0952f51c0782,0x000fa87ba4c53ac6,0x00007e6782a3b21d}},
},
{/* digit=27 [{1,2,3,..,}]*([2^135]*G)  */
   {{0x0009740e2c2bf152,0x000589e99704feb0,0x000fbc565627a220,0x000de8cc8d73d0c2,0x000023eed8fe20c8}, {0x0002583a8363b49a,0x000929c2b0a61ee3,0x000dbc85c1a0b6cb,0x0001aba9f7c3d290,0x00008dfbb97bef4c}},
   {{0x000236e846e364f6,0x000c7ea50ca0c16c,0x00026b86d7f33527,0x00070c6481077509,0x0000c2a36096598e}, {0x0005e52f024e9245,0x00044db4afcaa675,0x000831790e0fa07a,0x0000d5c5c3ce7d66,0x0000b4ef350f6cbb}},
   {{0x0006b2da6dc1d29b,0x00094871e1444280,0x000f49276d303000,0x00004af1feb333aa,0x00005583b9f770bc}, {0x000be7895695f204,0x000149d012b51db0,0x000f61643fc84181,0x0001282409f27205,0x00000d3417515883}},
   {{0x0004c050f15dde91,0x0007fd5f2b820521,0x000e82b62a47a76a,0x0005eeab254d3062,0x00001a05fe04ec95}, {0x000f46e9d529b36f,0x00009f9e3df67eaf,0x00031769855ab130,0x0007acd463e37199,0x0000d251439bcda4}},
   {{0x000669c72ba075b6,0x00055a4690158c3c,0x0009f8ba889f78b5,0x000ed6f706aade3e,0x0000d8bd566132d7}, {0x000e63b805f08d67,0x000d53bcc1b525f4,0x00025d8477f48200,0x0000a7de801968b0,0x00004afac04f7cbe}},
   {{0x0007598a9d82abfd,0x000b16c170f5e2a3,0x00066b0875f188cc,0x000ad9b168220050,0x0000a22c21397155}, {0x0005d3afbddb4799,0x0003dd715b99151e,0x00097cb2e4b606b8,0x000b65ba73b54bf9,0x0000a1bfe43cecd8}},
   {{0x0002522cccc18ad5,0x000da1a6e0277973,0x000c2354daadf3f8,0x000689a7382c9317,0x0000ce1680d2818b}, {0x000bbfcd9ecbee97,0x000bacae62ac359e,0x0001ac38a4330689,0x000ee8455ce5b4c5,0x0000921dfeb6e238}},
   {{0x00022f3dbfb894e2,0x0006ae274b18e131,0x00058aadfbe9b79f,0x00035165a49de5ca,0x0000495775831487}, {0x000ef61bb9390993,0x0009f6d13694111d,0x000fc253b1d6a974,0x00015e1474b4ced3,0x0000a1485e67c5db}},
   {{0x0004ddb0f5f27cac,0x000ae80d59ff6599,0x000601023e85461f,0x000bfb3f05481a66,0x0000665427bbc9eb}, {0x0001a697587fd52b,0x0007dd49efceb057,0x000420688935289f,0x0006aeb1becc60ea,0x000022639d9c3a78}},
   {{0x000dab61430c9ab7,0x0002b238e9975afd,0x0008042ae0bdd41d,0x0004cb8094743041,0x00001f9addb3dddc}, {0x000c016c52dd907b,0x000c79e2047f7090,0x0001011a6d9bdf44,0x000c7836f1fe801b,0x000063accbd89acd}},
   {{0x00076680448087c4,0x000f31432dae264c,0x000f9bf47ac30903,0x000d02f851b26600,0x000000ed311acdd6}, {0x00079fef8fd24247,0x000a8a6da98b045e,0x0001e673afdfd974,0x000167d5c9f6410c,0x00006f2e733cb2c5}},
   {{0x000acab4baef62e3,0x0002785b91e87817,0x000e576109f5a220,0x000e036666ebe66c,0x00002ad31f4273bf}, {0x00030a425bcf4d6c,0x0002915056e66283,0x000332156ea95059,0x0002d699811c89e1,0x000089cf1ff4c11b}},
   {{0x0005acbc46d7ce17,0x00071b085877889e,0x0007a50509a515bb,0x0000358ac1a03d0b,0x0000d3e738b62926}, {0x000c2ce2a6cb0ebd,0x0004bf7adc79861c,0x0000163766f2e295,0x00008f91c4d45133,0x00009fd2c812ad59}},
   {{0x000337ac0b7eff35,0x000e75e48b3c0ad7,0x000f13a5f8552225,0x000cbe96f78b0c73,0x0000e70062ed2349}, {0x0005048e7073969a,0x0009233cb3d26b8d,0x000caa20f392d2a2,0x0007074e4f727c4e,0x0000068c99ecccde}},
   {{0x000d65861a023efa,0x000419e5246e1888,0x000563ec01d72aab,0x000a4309a26348e5,0x0000097196463439}, {0x000d54badb9b5b76,0x0001645a524b567d,0x00038e60873fac1a,0x000f482fe97ef7fe,0x000008748d29f384}},
   {{0x00086ec1ed66f181,0x000bc61fce43ebde,0x000bed74d225d906,0x000ab74cab07d6e8,0x00006e4617f37855}, {0x000aaddb2fbc3dd3,0x000f5aeddf5b6568,0x000cf2fadedb5484,0x000699578f20e86d,0x0000516497c915f5}},
},
{/* digit=28 [{1,2,3,..,}]*([2^140]*G)  */
   {{0x0003fecfa181e695,0x0000e0d69a98ef0a,0x000eab95d9ea02f8,0x00002162e9cf8e66,0x000020f2beb74720}, {0x000540a1df843618,0x0000f1fa6d5d621c,0x000f5f6ff1203772,0x000ef2ee3c7b510f,0x000017a069c2bb2b}},
   {{0x0002fb6b294cda6a,0x000519039f348357,0x0005cbb216ce9bf7,0x0000d980e012f009,0x00000aecc1c7063f}, {0x0001c3af02909e50,0x000f48ce9cdc57c2,0x000e336f8c7d59ec,0x0005f42732b8448a,0x000056e37233f4f8}},
   {{0x000b53189e800ca4,0x0006d45208fd8a10,0x00014ba3750fe0c1,0x000acc5e43c0d3b7,0x000027d200e74189}, {0x000e24fe616e2c00,0x0008ee1854c105de,0x000342a739c25f4c,0x0009524d3222a58f,0x0000807804fa027c}},
   {{0x000653a4f0d56f34,0x00078a28b805c222,0x00073434b961e404,0x000a18ec03f8b04a,0x0000c966787eb712}, {0x0006c42864fee422,0x000a3b0ece5ccc19,0x00031c159c1be93d,0x000655887d9f22c1,0x0000bb6d593fce45}},
   {{0x0009ec9b809b7ceb,0x000b32c72c2c22c4,0x000a0bf368a41486,0x000c68d13b9420fe,0x00003d36eea566da}, {0x000c08a328cc987f,0x000b4a3264616fdd,0x00010dbba0a3bcd2,0x0004c38103c49dd8,0x00009d81a293b78a}},
   {{0x00065ade4d559419,0x000da03840873de8,0x000f18b9bdedafa5,0x000267df414abb4e,0x0000ee9ea438aee5}, {0x000aa1637a55a4a5,0x0003b15f93b9260f,0x0009c3598eb19a51,0x00078e01d7ebd29e,0x000023fc56d69321}},
   {{0x000070cb98fe684f,0x0009224a1458501d,0x000bc6b3fd60fbe9,0x0007cab45761c892,0x00005384859ee6f2}, {0x00071f7b59e763bd,0x00088b5a8e5e4b02,0x000a482923d4606a,0x0004454eda5d9b05,0x0000a7731d1b6fec}},
   {{0x000369390d458714,0x000fc6166d8da3e3,0x000a90403e976403,0x00063775c3368289,0x0000bd17983b2f1d}, {0x000679ed5d2c53a7,0x00088dcf3b87a616,0x0006a694e5ec4bcd,0x0007e53e6d7613b6,0x0000460fc7753fc2}},
   {{0x0009b8295caabee0,0x0005889501e37046,0x0006ed265de024ca,0x0008b26bdadc0607,0x0000cb1236b5a0ef}, {0x000ddbf0972ebf9d,0x000452aca4324065,0x0004aff76f1dd387,0x000d23d88b97cf74,0x00001359afece8e3}},
   {{0x000ba2b91502cf37,0x0007984db75d52a3,0x00030b1c92c3832a,0x00060b94a12dddde,0x0000802eabd531fd}, {0x0007327a37fddab7,0x000b8aafa9733370,0x000e6f91a65d6f2a,0x00030ac525c5b811,0x00006aeb0c9cf465}},
   {{0x0005ff62f93a6750,0x000405f48679e881,0x0008ae884a6ec968,0x0008736dcbb55635,0x0000af61472e19e3}, {0x0004372a5f696be1,0x000a5f22fb707233,0x0006cea90c65e57e,0x000b2a168da30c94,0x000036a8a8775681}},
   {{0x00081dc0f9f44d43,0x000ffc46585aad5e,0x00047d1b1f09a695,0x0008b1a1649164c4,0x0000b4b36c8b79dc}, {0x000177b3b6b234cb,0x00046730d9d020d4,0x00080531d096a250,0x00095c5611b9b8ef,0x0000a904b3c14bb4}},
   {{0x000d9d493a3147a2,0x000c7a5655451192,0x000f072129f30a5d,0x000c1370b1f9cb6e,0x000099585462d87f}, {0x0003effc17db9ba2,0x000cab1644a8d332,0x00049ffbccb18548,0x000683f8a306d44f,0x00008d658f16c2e8}},
   {{0x00060cda99f8c71a,0x000aabf742ff44ba,0x0004b3f9967b7abd,0x000160c6310f9c91,0x0000e430a339412c}, {0x00076d388ace52f4,0x000412d7067d1e67,0x00007cd1b4bc0fa2,0x0002c0c3c286aa8f,0x0000cb8f38ce985b}},
   {{0x000be808c3bff364,0x00021263e57583cc,0x0009bdcd1005a0bd,0x000b6b060d7dda25,0x0000a1c56433a5ca}, {0x000dbb99fe4fc88b,0x00081c97bbb52b7b,0x0002321ae09418e2,0x00064e28274fb4a1,0x0000137007e0c87b}},
   {{0x0001fe1c63c4962c,0x0008d81fdb258053,0x0004c2b6b50541e8,0x000fca1c1291a1fd,0x00000693a1866df4}, {0x000604e0117f203b,0x00025a99b8d0b2c4,0x000212c44245f196,0x0002a7fedc20aac6,0x00001ed4e57020f5}},
},
{/* digit=29 [{1,2,3,..,}]*([2^145]*G)  */
   {{0x0000fb6700a1acd0,0x0003fd999681b556,0x000b4e1bae823fd7,0x0000a3da915d1f6c,0x0000d0301186ebe0}, {0x000b0c989fca8cdb,0x000b49da0e0b744f,0x00031d76f970d01d,0x0009695ad8c56479,0x000015737c0a659b}},
   {{0x000384ece53c2d04,0x000d1e4606daa12b,0x000ec12b0779d897,0x0001ad653e47b073,0x000062dbbba9756f}, {0x00009f2cafe37b68,0x000f6cce2e1769fe,0x000f607fd273d1eb,0x000c250ac1d5383c,0x0000035f7ff92e10}},
   {{0x0002d5a2093c22a9,0x000145703aedca44,0x0003287b6ebd0bd3,0x0008b9a08f2afd65,0x0000bb88bac9d1bc}, {0x000853875c1e3b2d,0x000ffa11447cfbaf,0x0005c4c8dbd2ac94,0x000207586d816cea,0x0000c3aa800f8dc3}},
   {{0x00034c77e6c55202,0x000fbcb9ea58854d,0x00086666dc27df9e,0x000a85205f2369d6,0x00009d1febf2417a}, {0x000819e93470afed,0x000912a27f9e9846,0x0001e65043e6a966,0x00080954d008a2e3,0x0000ba7ced06cb76}},
   {{0x0003e41d07fa53db,0x0009c4e35bc526a4,0x000da2f8c3154a78,0x000f99cb768924e0,0x0000a964a2bd3613}, {0x0008d35ba1d16c4f,0x00010b54d0575a54,0x0006402052e1bfed,0x000f290f992136bc,0x000039cb9157156d}},
   {{0x000e64699b444ad9,0x000d340504c5c913,0x0002e53dbddfce99,0x000536c8482a99d4,0x0000aaf2c2661aff}, {0x000f7962664cf67c,0x000931393e2bee90,0x000225bb074ab5c9,0x000d6c3ad0faeae6,0x0000355648ced63d}},
   {{0x0001d271d91cf9d3,0x000d8377b20ae4e3,0x0005e1327cb35d4f,0x000e7544de1e4505,0x0000298e31b58703}, {0x0007237de0133394,0x0000e3d101c65508,0x000aab0dc32cbf30,0x000bb9870dba22e8,0x0000a52623d7d155}},
   {{0x000f541338d6e434,0x00030541d5ccecaf,0x000bc88ca56f7dd7,0x0002c375d426de96,0x00008d94f6bded3a}, {0x000a3bb2ef8279cf,0x000a1b1867f26354,0x000225151d575465,0x0000d7ff99b0ff95,0x00003e19d89e9450}},
   {{0x00035acc85dcf572,0x0008a88f5415dbf4,0x000c558076174565,0x00056f06367e9a17,0x00002d077a5ea90c}, {0x0002258a2e04e763,0x000e3e06e405fbf7,0x000e6f954ba965d3,0x000a742724d06fe3,0x0000e47d475b1251}},
   {{0x0000151e0fb82f76,0x000675668ac2b8ba,0x000d711b00d16072,0x0002f2022ba25814,0x0000addf557df3fe}, {0x0001e1c6b9c94354,0x000a773826bd2b83,0x000240f89ce3a060,0x00003a53fa11c11c,0x0000f9cc8d8d56e3}},
   {{0x00031f6641f82c90,0x0004dffec7564b93,0x0009158abd97c7c5,0x000a7ff5ee6d1f1a,0x000054493a385c3d}, {0x00005f5eb7d96df8,0x000764473a39a57a,0x000e16d55a3afd44,0x0006adc2a4d9c488,0x00003e144f675f87}},
   {{0x0003268e32dd620a,0x000ec27849a292a8,0x000378882913ec99,0x000cfe4dd8fdfa2c,0x0000f96f33f8e6f8}, {0x00037e5dc3fa8a51,0x0001a0b03a1dc067,0x000f037b0236bb53,0x000a5323e59f2989,0x00003f9b5a7e9a12}},
   {{0x000ae9559029aa6e,0x000b7a4db2ed50d8,0x0008f373dd74e292,0x000b372b9c335584,0x0000c018db78c45a}, {0x000690269cc53a8b,0x000c6a8798641f44,0x00013475e8c4b628,0x0009f56c743d284b,0x0000f4a933923de1}},
   {{0x0004f47f0cefa69d,0x0009d45468664a8a,0x000f603c1dc8e4cb,0x000ac4659ba69b23,0x0000ab4d601e87b7}, {0x0004337c1ebc8d9d,0x000382b4074ba6ca,0x0002fb7339fa6585,0x000ea94a4b4f8190,0x00002bb5d7b7525d}},
   {{0x00092d5f81f95671,0x000a3d698470eb2e,0x0004c81eb54cb95e,0x000c644f2acb28e0,0x0000c1ebfc508cee}, {0x0009fac06e074235,0x0008e7fa0c858f79,0x000f4db4472225f9,0x00009160cd861634,0x0000ec36159c52c9}},
   {{0x000f6ce51efb3108,0x0004158df5be0d0d,0x000158e59cb5b2eb,0x00033656459e2936,0x00002aae2b99466e}, {0x0008a39411aa636f,0x0004e4c0a933fb65,0x000f026b77152ecc,0x00011f010c758a49,0x00004837f98bb093}},
},
{/* digit=30 [{1,2,3,..,}]*([2^150]*G)  */
   {{0x000523a626332d5d,0x00028561bb44994f,0x000845ea27bc3883,0x000089305ed4b03d,0x000039d3ee292a1f}, {0x000fdd3e7676b0dc,0x000f3b7060176561,0x00064f9a8620e35f,0x0001f676ce424ff2,0x00004c341a09a268}},
   {{0x00031769bb816483,0x0005353120d000f8,0x000cabc62d69eb48,0x000cb1a17d75f44c,0x00004a07f82e749f}, {0x000f787bbfb55541,0x000052e283f82c3a,0x0009213a0b06ed4d,0x0007b44722889fa1,0x000062b085eecf3c}},
   {{0x0000ddaeb300f7aa,0x000c4db5e80136d9,0x000d5244c9dcf7df,0x000aa1c45cb26874,0x0000127ee79d48e3}, {0x000cc53575f1dbba,0x0004e0e6161e488a,0x0002650d095037e8,0x000215b7e5928329,0x0000be67d99b4938}},
   {{0x0000d2f7189e71f4,0x00081ecf91e73267,0x000757a21c643874,0x000ce4d5758e57db,0x000027d09f8690a9}, {0x000308f38384a7a9,0x000420732b99846a,0x000845819aac3acb,0x000e030e94100917,0x00005cba11237ce5}},
   {{0x000aa377378058e6,0x0000a4411154eb81,0x000828ac741c746a,0x000b29410c73bcfb,0x0000439be91fd972}, {0x000b4b043a2fbad0,0x000f82b5e8404bf3,0x00097bd4c39e6dad,0x000ccb4f71640863,0x0000f7de5687f1ee}},
   {{0x0002a73f37ec3c39,0x000d4d59eba0db33,0x0004d3257c65259b,0x00038f9291709cdb,0x0000a793b264d389}, {0x000e34be43756f0e,0x000dbafb56c9f39f,0x000208b272f76bdc,0x0002c2bf37867a61,0x0000a1d4307e8997}},
   {{0x00044878a429f4f8,0x000b5b516609d0a7,0x00069b5df0649712,0x000af23826ba57e7,0x00002335df29fc7a}, {0x000f0675c93d9950,0x000a68677be62389,0x000d9951b59ac367,0x000ccea77985ff21,0x000038956fb85011}},
   {{0x000851aaaca5e9b7,0x0000e6713b9797b7,0x0000a61f6518aa52,0x000b68c357e8c715,0x0000842e7e35c2c2}, {0x000af656868a5489,0x00025068fc818dff,0x000917733d963bd8,0x000327d4da5c8b65,0x000027091000b247}},
   {{0x000db942f6d0d97b,0x0000943b9373d6ff,0x000d36db605c3ee4,0x000c3e02e541ebff,0x00007415a977e1dc}, {0x000682e163aa2f64,0x0003ef3af218e383,0x000fdbadb46febdd,0x00021a50a0507eba,0x0000ca8ab4e0e52e}},
   {{0x000832e1b7cfb737,0x0001cec354c9a3f0,0x0008eadca7a8afe5,0x0002bb3e91c97e37,0x0000449c59a1c3b3}, {0x000c3710b1c4655c,0x000a379da87ea619,0x00038d96a692e4c6,0x0000ec3f3f5d86de,0x00005320f42dc08c}},
   {{0x000f2bc8fec5dec0,0x000f84d6786c92a6,0x000ffa084a71383f,0x00071587588c06db,0x0000d85f5ca6857e}, {0x00011b3b6c774d40,0x00084c3521a8e873,0x00029fe0f672357c,0x0008cde5fe74615b,0x00002bc51105b715}},
   {{0x0001e48a105fc8eb,0x0009789ba48c37a0,0x0001c2180769d754,0x000387108c6fe1d5,0x0000032dd3467bd1}, {0x00026db020b0aa69,0x000f7664c73c9538,0x0000cf95d05137e7,0x00028a366302c466,0x00009004e1242cef}},
   {{0x0005b284f9735368,0x000e535b04ea824f,0x000a03089b43e299,0x00042c472c88f74d,0x0000269d57ac5a2e}, {0x00063fc6607b38e8,0x000ea9390b0c7c1e,0x000ee2869e89e2aa,0x00097447c740da1b,0x0000556f6fd2f3fb}},
   {{0x0003995a4b6bed1a,0x0004f7095c541a0a,0x000a73ce92dab579,0x0008a666c6a1ff2a,0x0000dd0a54bede43}, {0x0006b1afca906cd1,0x000619de10dd160b,0x000633da325fc601,0x000d5a248e9c99d3,0x0000fe3f746258a4}},
   {{0x000edc88be85c1d0,0x00083ca09cb6c253,0x000e3055add3d0e4,0x000dbfb997f6879a,0x0000c929ad007431}, {0x000621584d2db42b,0x000e578828cdcef1,0x000bd4b66b50df3e,0x000b039589da9d6d,0x0000c4fd2e4899c2}},
   {{0x000c9a7d298c241d,0x000986807cfd214b,0x00064eadbe3b697b,0x0009c51f1c780245,0x0000de8cdd084814}, {0x000f0a75a4d2604d,0x000e9c1538af946b,0x0005b1fcc27154d7,0x000f81c5cc9230de,0x000088519ea36864}},
},
{/* digit=31 [{1,2,3,..,}]*([2^155]*G)  */
   {{0x000dd1a7cb1282c7,0x00064e46973ab828,0x00008d6b2a08d762,0x0003f2fbaf8d40e7,0x00002571fa1bdaeb}, {0x000732ff22dfd98c,0x00064087108d85b1,0x00088207a87ab01a,0x000754eaaafea859,0x0000cc832f929f00}},
   {{0x0001185ca8d9d1ae,0x000cf987ded2488f,0x000c46124adf2c77,0x0005f37f3039f060,0x00005d70b7651e09}, {0x00086506260e70ff,0x00070750d10582d5,0x000bac36439d75ea,0x0003289cf3d0b175,0x00003a7564e11d01}},
   {{0x0004700ec3128c2f,0x00019e383f4994ab,0x0003024eb6c76d86,0x000c68ec36b150c0,0x0000b43947843daa}, {0x000764a8dc796230,0x000db440fbb2fc68,0x000c5ee0d5b86995,0x000bd3d66879bfcc,0x0000522894295aa8}},
   {{0x000a43e3fcd3efca,0x000418088e9ab24a,0x0003d46eadd26c03,0x000a6f05ef4dc9bd,0x00002f99d592a4c6}, {0x000d3552f1da46cd,0x000d4afacdd1ddab,0x000d4057872c3f8c,0x000b94090c4eee92,0x000028bb4209a623}},
   {{0x0003becee8314f30,0x000ddbea298f5e7c,0x00080acec1c068ae,0x00095b08d381f17c,0x00003b56be8e3304}, {0x000b8f29222882d6,0x000664af8bf7aeff,0x000c57d8c95ff38f,0x0004eff0e32d351f,0x0000635be5277b44}},
   {{0x00092d2e7417ce17,0x0001270ee7f52427,0x00067a41eff42bc7,0x000a57aff4dc6d5c,0x00007709b7b90882}, {0x000731dbe217f2cb,0x000cabb721773554,0x0001dd0592af2a8c,0x000476a8eee76959,0x0000b2930c9fbba6}},
   {{0x0009126cecdaa7af,0x000d1b13247b174a,0x00084c1c4fc8c7e0,0x000c3a39c110d234,0x00008eb8758731df}, {0x0000212c00674527,0x000e0b9b926c022f,0x00042daf43f6f69e,0x000de399032da0ef,0x00009f00adef3f80}},
   {{0x000dddaf176f2c08,0x0004625726581e6a,0x000342ffb01ca460,0x0008d58a404ded85,0x0000cf60f96c4183}, {0x000691cc9071c4aa,0x0003944428039bbc,0x0009c0d81fd58874,0x000f7ef7101c8580,0x00007fb754d2c456}},
   {{0x0009ff4c1e99d816,0x000643c617c0f855,0x0008c6ba708e1a7d,0x0007945398fd4324,0x0000ffedd9231283}, {0x00059d2d629d2080,0x00053490530e8a6a,0x000505989a9d141d,0x0004ee42f6fc1838,0x00009bf250d479d9}},
   {{0x000a1d5af71013f7,0x00049bedc9466af7,0x0007370a0e68216e,0x0001cc84cba30bd2,0x0000981afbff7042}, {0x0006a679449f0e1f,0x000d1a47edae0249,0x000feca2286cfc4b,0x0008fa4073c936b1,0x00005694612f3f8f}},
   {{0x000f9e12cb7191e8,0x000865b08ea6ec14,0x000332bb978ea1bd,0x000e24bc65aa9b46,0x00004cc22b43f80c}, {0x000e9e9d49d5bf18,0x000599087da40098,0x000f6e357cd4ec1c,0x0004b7bc9d07c5ae,0x000039a02691f8f6}},
   {{0x000d6715bde48f8d,0x00025189bc7dbcad,0x00009ee8ac970387,0x000ff78d45299ec7,0x00001287ee3545aa}, {0x0008874db1dbf1fd,0x000ac90c88d67d1f,0x000368313ea46588,0x0003ad90ba649a84,0x00005fdcbcf30d54}},
   {{0x000643037577dd85,0x0003d9c5fe88f795,0x000bdc13283b82af,0x00039e4c1bea26cd,0x000089fa086ec043}, {0x0009538b13799dff,0x0000e295d034033e,0x0009ddcca85fa8b2,0x000333ef17f73fbd,0x000032bd123cdb66}},
   {{0x000e9959890272db,0x00098e713a10cf3d,0x0008227b875f3432,0x000dc7ae13479fe2,0x00008561eaaaefac}, {0x00097a08332aafd7,0x000503809b62a6a2,0x00063036f9b0d8bb,0x000da862fa1cfd0c,0x0000a16eb562d64b}},
   {{0x0004ec13cf482834,0x00055c8a705e4cc3,0x0007d4f84b09daa2,0x00029d91e9d0d05b,0x0000df6ef651b389}, {0x0000763aa21ba469,0x00081293f8fbe16b,0x00020aabfc6b1d17,0x0009797ff5b602d5,0x00004d671be53393}},
   {{0x0008e8a2ac13e274,0x000f0eb1a9f5f7e4,0x0001f0a624494f6d,0x0008f0adbf84eb98,0x00009badc3293643}, {0x000a541004f7571b,0x00002f1c94ee50be,0x00027bc31bac67d1,0x000e27753d73a1b7,0x00003d01cf2e0686}},
},
{/* digit=32 [{1,2,3,..,}]*([2^160]*G)  */
   {{0x000e50f6d3549cf8,0x000f7acd665ed433,0x00011fcb46f33696,0x00085fe95bfdacce,0x000010ee2532f7c9}, {0x0000fe17159bb2cd,0x000da58b357b6545,0x0009fea72f7dfbeb,0x0007445b057e74d6,0x0000485717b62731}},
   {{0x00042e8ee36860ce,0x000c6113c22d896c,0x000104213daf04df,0x0004e93adbb7b744,0x00005fd5fa1ffd39}, {0x0005d941a4e0551e,0x000d38d101516823,0x0009845236772cfb,0x000a97476071e309,0x00004e879df3a56b}},
   {{0x0000aa9b898fd522,0x00079e9af1a76c8d,0x0004f03f82fb38a5,0x000c6fc1f2b9a93b,0x0000b1aad44e3f0c}, {0x000332e7cf2c0846,0x000ea367d26d58b5,0x0006e4a8d1c57d96,0x000b69c297eabdfa,0x00005a947eeaa0e2}},
   {{0x000afb0285b94916,0x0007be4c705eaaaf,0x000d9caab01a0be8,0x00033f9f1d4f5d2a,0x0000e349a4b237a2}, {0x00012464a1c6a163,0x0005f9383260cf1c,0x0006d5471d99e6b6,0x00089bba3d43665f,0x00006974d052f8cc}},
   {{0x000b616fdd5b8549,0x0007c728719ff535,0x000921cad592549c,0x000ef85231468606,0x00008c8ce34c11b1}, {0x00037e7e9090b363,0x0008dbf7bbb728b9,0x000d8797467fc3ab,0x0003fde2337097a9,0x0000e5adca22970e}},
   {{0x00049a1cfe89d80f,0x000cea9c8371c26c,0x000d066d2b42c026,0x0003edda6c013ada,0x0000b8f722946a4f}, {0x00079ecd850935b3,0x000ca631e1b308b5,0x00019853434c1a74,0x000f259b5fe596ac,0x00009ff21f711f24}},
   {{0x00068a7b3f85ff0f,0x000c2a888044cdcc,0x000dbe894acd21cd,0x0000d3c6719b2e05,0x0000ae1d3d97b826}, {0x000dece8a1c5d92d,0x00040c52077eedfe,0x000dd13edbca01a9,0x000aacf085549c16,0x0000c5c3baf195eb}},
   {{0x0009e148f9290579,0x000630c853df27f2,0x000e9c5ce7a64ae0,0x0002a4956cd18358,0x0000d9cce836ed09}, {0x00059796e93b7c7b,0x000181bb9e27cc6e,0x0009e29a0e1e4709,0x000644070b3083aa,0x0000f181a75e785e}},
   {{0x000063fbe7b643ab,0x000796085760cc17,0x000214c9e7872e1c,0x000637d6b0fffbb4,0x000018bbc0f22bf3}, {0x000de0c722591c92,0x000928c29e0c8b17,0x000304f201edeab1,0x000fb67fbfd98ef4,0x0000d1dbb6bbc77f}},
   {{0x0002c658ead09f79,0x00050780d14df53f,0x0001b66bc1335e1d,0x000fc7d9cc20e0cd,0x0000b670a384be0b}, {0x000dc8128efbeedb,0x000bd326a6e5ce53,0x0008e9a630c74e77,0x0002478604e0d2b8,0x0000ab38fcac3dc2}},
   {{0x00016d3c7141771f,0x000a3f226b662556,0x000ca63a9a86691a,0x000f2aea19fea4b3,0x0000c05dc439e672}, {0x000e786718ba28fd,0x000acc66b984a9c6,0x0003702f207b7995,0x000efe3f434f551b,0x00006f62130aa84e}},
   {{0x000e8c85c0a3f1ee,0x00019c87c37f8ed6,0x000e3b78dbcad249,0x000a461dfb62bb9e,0x0000ba8e478abceb}, {0x0008cb0eeaede4b8,0x0007f976deb637d3,0x0006147fb0bc498e,0x00060932944c046b,0x0000b123f36771f9}},
   {{0x0007987b5b41d786,0x0006ebf0c4f84b0e,0x000b80ecdea7df90,0x0007e554d03560fa,0x0000cf306f75b1db}, {0x000fb5689fd4773f,0x000f10f9be330d59,0x000352da4ab254f3,0x0003ee28a09a9277,0x000081862f6541ea}},
   {{0x000dcc7de79dc241,0x0002458f69cda155,0x0001850dff1168a3,0x000848aac215950d,0x00005c8295bc204c}, {0x000aa367d8184ffe,0x000d50447bdbf661,0x000e4a59ec396228,0x0005e531cd5143bd,0x00003a26e3c4beab}},
   {{0x00001579f759d014,0x000f3eae4fdeb59b,0x0000ba8c0a2923d2,0x000442d832775769,0x0000bf7e38b84f51}, {0x0002563b413fc268,0x0002f9e53b36b681,0x00089f66dedb7d36,0x000415cfa585c4c3,0x0000e1adc31d4bd3}},
   {{0x000a13f1402b9d0c,0x00026c7bc863d3b3,0x0008c3e6e573441c,0x00057d8b301ec457,0x000026fc9c4cadaf}, {0x0001bfd7493cea35,0x000ecaf8145696e7,0x0008c608fd05d4b3,0x0002768aca2a8a6a,0x00003ef07f65725b}},
},
{/* digit=33 [{1,2,3,..,}]*([2^165]*G)  */
   {{0x000c9d646ac49d20,0x000b83137aa9a6b5,0x000225a3842c77c0,0x00090724d000fc68,0x0000f63cfc82fe1e}, {0x000b01bc6441f959,0x00095c8e448f22d1,0x0007fb1ba7d38f71,0x0008df0b33fa5f78,0x00004dcfda1a9015}},
   {{0x000de10296c36eff,0x000192c4da77211c,0x0007836da7ee8967,0x00060ac617d270a5,0x00000cd9c328cb75}, {0x000cbf7e455fe908,0x000afe7334f301fd,0x0007de4ec3fb53cb,0x000fcff81e2ea44e,0x0000adab3ad8b384}},
   {{0x0008a2b599ff0f94,0x00074104fc6b0177,0x000694ff368a923d,0x000f121bfa44dfda,0x0000f7199dc37667}, {0x0008ff6e46f2a79c,0x000d29f8131dc06d,0x000b4ce7c08b5dea,0x000c3d42519a59ab,0x00004f710bd742ae}},
   {{0x000368b4ed80940f,0x00058a6fcedd3014,0x00097579f67e6d05,0x0007f58c208c49ca,0x0000e3d7a8292359}, {0x00032027e096ae27,0x0006b4b393665e20,0x000dcdffcb1f3e1e,0x000e82b6da26f32f,0x00009422f1dd097b}},
   {{0x0009c748c878145f,0x000e49c635655054,0x000cf2d5e67f14ed,0x000d0f32ddf78c9b,0x0000faa843058201}, {0x0004a9dd1b2de28e,0x0007254be41447d9,0x00082755bc09c4be,0x0003bccc80e178ca,0x00003251d113697c}},
   {{0x00009d35001417b1,0x000e4962ed5e2bbe,0x0009f46c3795e84e,0x000a2e4b79d1ca27,0x0000f7f8a3b93836}, {0x00000b14a64dc32e,0x00042f84f7396922,0x0009155c0c842433,0x0005071110da07cc,0x0000e8fbe62394b0}},
   {{0x0005391035703ccf,0x000950c7e24d2f6a,0x000fcbb9a9899bf6,0x00075ad3f7f248bb,0x000065027dfc5558}, {0x0006b69ffff3b37b,0x0003645b4431a7a1,0x000afd67967b6eb5,0x000cde69d7e1d249,0x0000d819babc10fc}},
   {{0x0002cfb9db3b3818,0x000e54df0a4b263a,0x00004e61f9c3a2de,0x000324f28d06e97d,0x0000b1adfbcc2449}, {0x000d9397e053a1bd,0x000696daf7076ec1,0x0000ac7abee2be5c,0x000173b0ba1e1481,0x0000d2ae779c530f}},
   {{0x0008e703b9f04267,0x00059c84f17c3e70,0x000b70a0be5b02fb,0x00065cbf4ff35be3,0x000081b3c600b155}, {0x000636a6e124c3a1,0x000a7b496784e76c,0x0003f0370bde81eb,0x00045d9412f8e244,0x00005d42362a99be}},
   {{0x0003ae2a4af76c14,0x000bc8276fe70f50,0x0003a33c6550e66d,0x000f84d1e0c1fcbf,0x00002be231046629}, {0x000743e516ace497,0x0007d36a2262edf7,0x0006ca192ce43666,0x00013e71ac703644,0x00003631cb5b76fe}},
   {{0x00082d4a160bcfa6,0x000558ceb1f2d47f,0x0005a8d25258fb07,0x000c9cef818e8fdf,0x0000685475ecfd31}, {0x000385ae1e9b13f4,0x0004b0508bdbcef6,0x000f1f90de0a4259,0x00081e1ad7ae16ae,0x00005a155efa3f8a}},
   {{0x00007c28034b95e9,0x000587bdc5608ca4,0x0009807e8c93eb97,0x0004eabec24e8d33,0x00001b734d76d64a}, {0x000ce398f668b26c,0x000a541823d5d0fe,0x0009e4e004822cc4,0x0001adf953bc32f0,0x0000a0a7c60c6d86}},
   {{0x000d4470f33e712d,0x000555a87cb04c74,0x000962db43cec1e0,0x0006a98cec0610e5,0x0000971af1641a25}, {0x000c983a2ef4ac95,0x0003874e9d00a044,0x00073d881caa1da6,0x000c8bab972d8346,0x00000747c5a53a26}},
   {{0x0009982a3e25566d,0x000d48e1b8960434,0x000b2d24beef9075,0x000a547c7bead092,0x000099f72fbda21b}, {0x00009315005e541b,0x0007eece3205b93e,0x00062f2f62a7a983,0x0000a63b388ed114,0x0000488b15ade346}},
   {{0x000cd67969d56af1,0x000ccfc58a8b43f6,0x000e703779e0d872,0x00046c301c1509a4,0x000003d1a1318ad6}, {0x000e37e9d0624278,0x000c39bef78c078e,0x000e661424e69c5a,0x000d81d21ec00136,0x0000de1ecb32634c}},
   {{0x000d97a205b9d8b0,0x0004056756d40435,0x000f8210e6eb8f06,0x0009ead5e88a8bb6,0x000070ef12dec9fd}, {0x00095053bcc876ae,0x0007c7404ce34d84,0x000a1db5e12a7533,0x0005acf22b49e1b8,0x0000c1f2051f4bfa}},
},
{/* digit=34 [{1,2,3,..,}]*([2^170]*G)  */
   {{0x00081b5c4e83d33c,0x00089efd488b43ed,0x000eb4d0fd9f3587,0x000393564a620f9d,0x00006927bdc6c6a7}, {0x0008df79f9e0f036,0x000e9cd7e1a945c2,0x000a348f12868661,0x0008e01cf4e8d0ff,0x0000bd4c28499853}},
   {{0x0006e8c06d75fc1f,0x00064249a89f5603,0x00045e7dd2dcf7bb,0x0002a691dd1d3de2,0x0000578dc4cdbd6e}, {0x0008903df2ce7a06,0x00083c39afac4c02,0x0006404abaee3628,0x0008187c847c3114,0x0000304c0d904e97}},
   {{0x00036c327d02dccc,0x0001ba68bcc2fb68,0x0005e912d5ad0098,0x000cfd5b24b44c00,0x0000c83d210411fd}, {0x0007ec1666fba0ca,0x0006747546353652,0x0006da9c26994819,0x0002b25cdcb1a855,0x0000593426821a73}},
   {{0x0008b33070d3aab6,0x000b3a2cd5e5e4ac,0x000fc91732643672,0x00013ef2eff79b1c,0x000065ca49bf0a7c}, {0x000da59b3efb9983,0x000cd52f13415a8d,0x000f9a5308a5b922,0x0004d77e9ebbab3c,0x00005986e7c256da}},
   {{0x0004cbd8088b454e,0x0006ba9e0c8a63ee,0x0002447cbdb7f32f,0x00019ad377d4186b,0x00003e982abb3702}, {0x000c1e4c2a2a5938,0x00048773f24f06cc,0x00085942372c3686,0x000c8f213b4da795,0x0000bbf1d33f5040}},
   {{0x00087d0ad886aac2,0x000a9771b64503c1,0x0004045ab5c16878,0x000aed907dfc6fc7,0x0000c6360bf9800c}, {0x0005bb5b9c972a3d,0x000dac9a6dba2429,0x000a79aa6c9e6f88,0x000ac1c0ffbf2492,0x0000e29d50b11c26}},
   {{0x000fb68d84d835d2,0x0009661dc1e6b1f0,0x00094f8d7c90caf3,0x000b91f2e5b04675,0x00006897ae285012}, {0x0008a08a4d6755dd,0x000b3991fbdabcf6,0x000bf17e8403ee41,0x000d64a33e343e3b,0x00002c7980e379b3}},
   {{0x000cf4fda79e5acb,0x0009d630215f534a,0x00085756e68b83b3,0x000cb1ac748b2ed0,0x0000031725995d37}, {0x000841ac5ccc2c46,0x000add9d50696735,0x0001754bd7d7dc96,0x000dd54147e410fd,0x00005296e953399d}},
   {{0x000c9a1deb8568b6,0x000020fb3d321e71,0x000f8fb81a35daea,0x00096a88b6f2662c,0x0000d51afe8f4906}, {0x000ac6e51803a198,0x000f0621908081be,0x0006f463ce3d24b7,0x000ee7f27cfd9ddf,0x0000c6865caf2284}},
   {{0x000f169d23233f3a,0x0005d7cb637fe00d,0x000a0cf6c3e32279,0x000bdc7f897c0e1d,0x0000651f5d8d1d6b}, {0x000af191a230c767,0x00025daa5e4add61,0x000abcd7ebd52727,0x0008dc5a753636d0,0x00008bdd37ca70bd}},
   {{0x00027c17078c4322,0x000c977fedb7cddb,0x000290570e1961b9,0x000885fedc2f5cc2,0x0000c3fefca39cbd}, {0x0000a36c2af389a8,0x000d3da71ceacf88,0x000aa846396c610f,0x00090a703977a932,0x0000eb776400586d}},
   {{0x000b3edf0290a8fd,0x0005fb47c387831a,0x0004efb4fcae8196,0x00010ddad7dece18,0x0000cfc53b417491}, {0x000f23c4cb632f9e,0x0005d91f80676698,0x00084180ac42a1ad,0x00026ed116a81d62,0x0000bedf5f9c9013}},
   {{0x0003f0ab2cf89408,0x0007ef948f519163,0x0002653c872b0b17,0x000a04ad28dc3078,0x0000882984a5b903}, {0x0005d0c6a19d2bbd,0x000bb6f782cbb809,0x0009070644b9e7f0,0x00043baaf739882d,0x000012be0ff5b326}},
   {{0x000f28b638a7e819,0x000ec980ddc39561,0x0006f247a54155cd,0x00010022db4a96d2,0x0000d774e4ed787d}, {0x0006e2e078637d27,0x000cee0ae06a1a9e,0x000cfa3541c363e2,0x00098d0493483ee9,0x00006843cb3ef74b}},
   {{0x000f1bc789a283b1,0x000d780836f40491,0x000e5402d72d3ac3,0x00073d9a1c5ea388,0x0000b192421e5cc4}, {0x00099989dc84cacd,0x000ccc6e75b85c0b,0x000191ce2b0a8482,0x00092f939961d03a,0x0000a3bc8663d837}},
   {{0x000c4cdb30cfb3a6,0x00010c9db4c8d7e0,0x000c8d9df6d09b8c,0x00066ce0ba1a4207,0x0000fd495f77c52c}, {0x000169f275264daf,0x0005f57d8362fb0e,0x000ad722280c2b74,0x000c7afdd987f749,0x0000dc229b03398e}},
},
{/* digit=35 [{1,2,3,..,}]*([2^175]*G)  */
   {{0x000ed8452666a58c,0x000026a9c3c2b0d1,0x0009064084bcb6e0,0x0003ff7c57411c26,0x0000fc20755d3556}, {0x0001c505294dba30,0x00068b7dd31ea08b,0x0001eca74a30ba28,0x0002b9d70ba90e99,0x000094e142ce762c}},
   {{0x000783e979f39254,0x000a6f4c89a7b81d,0x0001bf7fa1efd130,0x000a9e125c2144fd,0x0000b2969045b265}, {0x0009634b9db65b69,0x000173599d8aed8e,0x0003563f335c82e3,0x0008ab4aa7a54f40,0x0000df088ad922c3}},
   {{0x000b066bb3fd30a1,0x000adff0354ee5cf,0x00024e36c429169d,0x000e1d709cf85235,0x000036f4fb31155b}, {0x000af011fbba712e,0x0003706ba1a14826,0x000aea73e6ef0f0b,0x00044df9928b3177,0x00002bf6af33eaa2}},
   {{0x0004f124237b64b8,0x000963ecfd078d08,0x000845dd8688ebe9,0x000324d7b8a70cf6,0x000008fc59cdda4a}, {0x0002b2ba3585862b,0x00053df29386a903,0x0001ec29bb66825d,0x000dc805a5a8db43,0x0000b143a98ea1e8}},
   {{0x00094ce12ae381b9,0x000bf6ccda9035ee,0x00006eaca3a7f176,0x0004df363a657e46,0x0000ae5a380d3cd0}, {0x0008d15ed251b464,0x00008aca5e649bec,0x000f20f071f5d6d3,0x000285f47b3b359f,0x0000d65f03537e4b}},
   {{0x000ba24f111661eb,0x00040105eb049e93,0x00024b578edced48,0x000068e6dc9ba1f4,0x0000f8f66b8983e9}, {0x0004df4d7ed8216f,0x00069e2cbecf872d,0x000e73754bf07f37,0x0007075281d89998,0x0000ec85fbc7aab8}},
   {{0x0000deea5ba5b0b7,0x000dd2d052999a3c,0x000b02d42e6a116c,0x000cb63e9775fee9,0x00002b0520111545}, {0x0006f7d31a3b4ea6,0x00082bbd9b32bc50,0x000b12a97e589307,0x00067168bc5f37e4,0x0000b000c06aa73b}},
   {{0x000bf22765fa7d04,0x000fdd6a537013b5,0x00080db9859805be,0x000ce327a5e29d42,0x0000f53916fb76b1}, {0x000f61f33ddf6269,0x000e1085d103714f,0x000809ee34206238,0x000b1c8c50d4b7e5,0x000099f450e15f8e}},
   {{0x0006051e4c79e9bf,0x0002d66a9fea658a,0x000be7b231394cb7,0x0008fd37f31ed5c6,0x00004c88f374aa6f}, {0x000721f4aaa499e0,0x0005e3fb2a6b0fb0,0x00092851d68b3a7d,0x000913a788097d3a,0x000060e7f8ae96f4}},
   {{0x000be731a3a93bc2,0x0005821adc1a82ee,0x000030efd42bbf46,0x0007bba10b6fa4ef,0x000047aa4c7a7b09}, {0x000c632f60c77da5,0x000a7223523e8b8d,0x0004579cf6ffbc26,0x0000f654f6ff1134,0x0000825653ce8025}},
   {{0x000097ebc1aa2b92,0x000317a0333ab2dd,0x000a0db380788939,0x000612fcf55e7137,0x0000648487f992c1}, {0x00013363fcef2614,0x000cceabf129dad0,0x000276be26239c81,0x000ad34ee761de9d,0x000006a7a345eda6}},
   {{0x00067ba4a493b31c,0x0001dbf7f0264bf3,0x00095914b54f20a5,0x0006abf696e06297,0x0000ddab96e4bf23}, {0x000c70aed25ea138,0x000b01cbbbe74ff2,0x0008544c5fa1d09e,0x00031708fc8c8746,0x000047a670de96b3}},
   {{0x000421e64bcb626e,0x000746dee0b5f133,0x00010346caea638c,0x000ed2f6e7680bb3,0x000006f4098b5d4c}, {0x00014527512a30b9,0x000d5589a59a0996,0x000d0c180f3d867f,0x0004ab9e73254f52,0x0000063d8a3c33c7}},
   {{0x000c595d314e7bc2,0x000b267899ededa6,0x0001ed5d32ee7464,0x000612fcef423c0a,0x000017e76ea89cc7}, {0x000ce1fe7cda917f,0x000a9a893f1627cc,0x000c74f6b12d8016,0x000e60ccd6de849f,0x0000a5817e3e3144}},
   {{0x00041640821ee4c9,0x00037bc619921f35,0x00072879f1583eab,0x0007b1e490caf61d,0x000098ad9f4876ae}, {0x0001950a41157f70,0x0006e8da3a7e1e18,0x00026b95fa9d7e1e,0x000a10963784eb84,0x0000ee4ed6e542e2}},
   {{0x0004cc5ac751e7b7,0x00028d4211bdb79d,0x000de4fc693f9647,0x0000641c72d3d2c8,0x0000b69cbf64f44f}, {0x0000ca2f4bf94e19,0x0008612894e23da9,0x00017d60b1a5325f,0x000b5c7a437f6c79,0x0000be7048726c9c}},
},
{/* digit=36 [{1,2,3,..,}]*([2^180]*G)  */
   {{0x0009976e1337c262,0x000db73d68e5949c,0x000b768d96faadeb,0x0000697e158614f1,0x00002dfa557bcc4f}, {0x000da17be93c6d61,0x00019504f5b9ccd6,0x000694da124866c6,0x0008c61121353c8d,0x0000c6ca5801140b}},
   {{0x0004a7dd4b79bb87,0x000ae2c878c8f160,0x00047b8e8aee806f,0x000053c4144f118d,0x00002edf52c049f9}, {0x000a84e2127015a3,0x00006cb7cef3ebfc,0x0006deec89051d0c,0x000d7456e8fe5829,0x00003b2818871010}},
   {{0x00060ed9aed9f40e,0x0000732a8c99bd56,0x000c371ea70ca6ad,0x00009ce4978bfb95,0x00005464d0e50031}, {0x0002fdfd9e535ef8,0x000718c9185b1af3,0x000b42488abf57ea,0x0006fa6d7a741712,0x0000e0296a869728}},
   {{0x0009383171b445fe,0x0002a131ad4c0107,0x0003987e89bcf21e,0x000c8eacdfe205c9,0x000063f4153a92e8}, {0x00062a930add43df,0x0002d980f05a7294,0x00006e96862ebb14,0x0006b05f3954e53b,0x0000e1d75ae142cf}},
   {{0x000416e1f017d5eb,0x0005c674e99b8b57,0x000f488a03753339,0x00095dbe6d94c0e8,0x000093a787b8c16f}, {0x00051a2dcc99ccc0,0x00039aa47c1dc3ac,0x000dfd8d5c134b41,0x0001edf28fcdafaf,0x0000d57bd8e10b83}},
   {{0x000fbccf0bcfc46a,0x000e15cffee69276,0x0005d915b3a822ac,0x00076b928ed2fec7,0x0000145c11463594}, {0x00081538be17bcdc,0x0002ea6c3d8ff61a,0x00016c82f01e867c,0x0009af9634e15d65,0x00001437bd32948b}},
   {{0x000d2006c19d4c7d,0x000711b1e976d2fc,0x000f237e8a0f3c43,0x000bb120545ff694,0x0000d10ec4090bf8}, {0x000696cac7cd3e1f,0x000b6f24bfe64f89,0x000af7706ed3714e,0x000c31463eb1d85f,0x0000cbd604eb027c}},
   {{0x000c6c7af8685c8b,0x000d7f8f01aa5f95,0x00074692ad4c1c8c,0x000068144bbe3225,0x0000800347984a4a}, {0x000c6e52eca3cdb7,0x000b7c04d3997c8f,0x0002bc5cfea1db16,0x0003d2405bc82e8f,0x000063d518064479}},
   {{0x0008eddc355363b4,0x000fb8820d6e16ce,0x00061a5084af2f70,0x0004728b7ed4d276,0x00001d3444f1d195}, {0x000a2b438da9649c,0x0005eeb4a20017fe,0x000b19c3d9bf6935,0x0000a5e13b5f916a,0x00000519c159c936}},
   {{0x0001ae92e42e1716,0x00038d41ccf9c257,0x000c8854fcb31ab6,0x0002a0d7f3c576b5,0x00006e5191c26239}, {0x0005a1c6cd5683b8,0x0002e06fe6897156,0x000e2fda6484b028,0x0000a473a25d6767,0x00007ba21df0a65c}},
   {{0x000e49ca70684d10,0x000133e80c3dde74,0x000a5c34d3ae8766,0x000c355984a2a916,0x00009a83eccb8298}, {0x000867caa4ca4c09,0x00002375b8ff9a19,0x0000396dc0208561,0x000e636296328bf7,0x0000c9ddc4d6e6fa}},
   {{0x000c1b808bd98d05,0x00041575f2404451,0x00075d270644b1cd,0x0006bd1907eb3373,0x00006c8bebe4a228}, {0x000d2acc4632b46f,0x0009bfd60242c713,0x0005c754617da427,0x0003dd413065b7c9,0x00008239899af17a}},
   {{0x0003d260b083b6e6,0x000aa6f6a54d9468,0x0002074dd0a3752e,0x000592e8bedc2375,0x000037622fc9e822}, {0x00005136be55d3b0,0x0004324d006dea00,0x000fc02709f5e12f,0x0009e6529486a964,0x00009ba0d0c92339}},
   {{0x00058473a9770805,0x0007bc6a6ab63638,0x00082261e4cf8e1b,0x000806419a5c6c04,0x000017a9ad135ce4}, {0x000d40c056aa7aa0,0x000ae56c61b02792,0x000b19e0c4c7c6ad,0x00067ff19cb178a4,0x000046d5c4fe4ba2}},
   {{0x00026ab121550b37,0x000a5147ce84d3e9,0x000ff722ae4975e4,0x0002a00a8be0f95e,0x00001e4702cdfd4f}, {0x0002acf3cb7b2807,0x000cb8272d7313b9,0x000a9fe5cc588716,0x000e42162c7bf3da,0x00008c008f352a79}},
   {{0x000963f4c8303203,0x0000603203e3f3b7,0x000327afb842c7aa,0x0009b67f22ca0ae7,0x00008e13092c6760}, {0x000fb62757558f1a,0x000157eca8c173b8,0x0003316273cc3e83,0x00023444174474f6,0x000077989cb63c40}},
},
{/* digit=37 [{1,2,3,..,}]*([2^185]*G)  */
   {{0x00017f4b0166f7a3,0x00079eec74e6ae83,0x000874bfdfbd3e3f,0x0003a3cdb516ace0,0x0000d846019f681f}, {0x000ee5c7c1620b02,0x000d0b63c5010b12,0x00068c51eba68b4d,0x000b5b8c03cd3266,0x0000a6279f76e0bc}},
   {{0x000139f8f5fcda83,0x00048dee5bfdfd8e,0x0003f9f77f3e558c,0x000969a76cbaf4e3,0x0000a4c97a4a1771}, {0x000e84bf6dce6a73,0x0005e3e6c2d1da27,0x00059a6e9ff373d9,0x00062cc115193cd7,0x0000f9b702593d22}},
   {{0x0006fea87baa6279,0x0001672aa6801253,0x0001e5dc958c1fec,0x0001b8dc29b63760,0x0000e3c3c1d6e9e0}, {0x000127b2bcfe0b0f,0x00013a12f50defc8,0x00079b3973510710,0x000f207ccd6cb148,0x0000792f805e8a82}},
   {{0x00084911a335cc88,0x0009ea5913e48c31,0x000b32919563459b,0x0005ac9b920d61c7,0x000005ab8b720242}, {0x00012da8d006086c,0x0009fcf5c0fd2ac5,0x0002138d76ca4846,0x000442efea51d8ac,0x0000b647545f44cd}},
   {{0x000f521e447f2c48,0x0009e04291f0a3f4,0x0005926de81b8da7,0x00002f5680bc467d,0x00004f21fd5b4a12}, {0x00031814e9df3d85,0x0009e9ab8d341d1e,0x00019aa4a1ca4861,0x000366309ddeec5b,0x00009f72f7e9d329}},
   {{0x0002466cdedca850,0x00001a09538c9f1b,0x00011115d140bb71,0x00059eac8ae8515e,0x0000d63ff676f03f}, {0x00055517d234afbb,0x000dce208fc1755e,0x0008a4b5d61c2db4,0x00030efa9859cef2,0x0000dd6d4fce4af0}},
   {{0x000e67f906151e50,0x000f55e106493f39,0x0007cf7b7cea27f5,0x00062ddca1d4e1c1,0x0000c326d122fe23}, {0x000ac337dd35df39,0x00093396dbdf05f7,0x000b7db1c0c3b763,0x0004a87912f5ac03,0x0000dea4b70ec9ed}},
   {{0x00053e453544774f,0x000b4adba2bc5110,0x000e371f5834d0ec,0x0003bb5215d7f7ba,0x0000cfd57c05c866}, {0x000383dd6901b1d3,0x000485587dc3ded2,0x000625f623b49fbb,0x000762cd44a08d07,0x0000ee4d65bcde9b}},
   {{0x000fe5bdf53aad08,0x000564604a673e56,0x000a261a051314de,0x000c90b86ad98607,0x0000b7e021297afc}, {0x00011273b72aec51,0x0005b4f9f509cbf4,0x000484b5713c85d0,0x00095bdda56845b6,0x00003cb1642c3d09}},
   {{0x0004b6e717815de8,0x000027e131d15a99,0x000c023aad995c7a,0x000ced48b46df226,0x0000cfd094df02af}, {0x00043cdced6a8867,0x0003afcabe757bc7,0x000ac9390b7d70ec,0x000a8fba6c9e47dd,0x000020694260310a}},
   {{0x000b3263e8f793c6,0x000e6de3b289a607,0x000915b21a541166,0x000da6944ff2924a,0x00008bea907158ec}, {0x00037b4402928970,0x000e4b768423d85b,0x00013bbbed2a508a,0x0001f4d10bb79da4,0x0000262f48106149}},
   {{0x00080f55464d0ebe,0x000687a613a7d17e,0x000c97dad89d3e1a,0x000be697791260c8,0x0000c2ff220c4f0c}, {0x0004ac2e9e6bc105,0x000827cba305ed98,0x000624fdce3c53de,0x0000ec4bbaf9b283,0x0000e9451cd6485c}},
   {{0x0009f63b7abad118,0x0001e3a46189fdfc,0x0007037b7c7ec3a9,0x00070fc9ebee42f6,0x0000247f5054dac1}, {0x0008f8d397583e59,0x00067c3f8c2efc51,0x0005edcb1e7d24de,0x000efba54832669c,0x00004bba48488c2c}},
   {{0x000756db1761ec84,0x000864b97e551f13,0x00096cc28e53c8b9,0x000a8d72aee3f840,0x00008c361a0d20f1}, {0x000672d8c31190a9,0x0000701855d4a98b,0x0003f4b2a7bc1e7d,0x000bc3942cfb07bf,0x0000bf44a3fc2a28}},
   {{0x000976299da550cc,0x000956baa042eba8,0x0008c2f9db2c1781,0x000a9d7068b08278,0x00000fa414654869}, {0x0009e39d50b693f4,0x000c588e2c5e73bd,0x0008f9f62b79e2a9,0x000c7bb1cb8de40f,0x000015b04ee5ea50}},
   {{0x000137d0d63d1fae,0x000122a9d89f64e5,0x000436309658fc05,0x000a606889487450,0x00009ae30f9b598d}, {0x00010d1818baf918,0x00060b6a0c202ed7,0x0001a6b44e27e9e0,0x0007db9e28dcfb1c,0x000083acb6556ac5}},
},
{/* digit=38 [{1,2,3,..,}]*([2^190]*G)  */
   {{0x000728dc2c6ff707,0x000f55dc22358735,0x000e277f979d6122,0x000cc6b3f5d00319,0x0000ee84e264ded8}, {0x000afb063cd880a6,0x0005d574af6091a8,0x000de7f423f3ea7c,0x000151acfcdc8402,0x00002d07930131aa}},
   {{0x00083f9dec31a21e,0x00028ad9d573b02c,0x0007be365988c8b2,0x00034d73e983aea5,0x0000968734e446f8}, {0x000ea8f5da6309bd,0x0003f1f1ce169137,0x00044092110f3a62,0x0001b4a82a9ea2ca,0x0000f94739f2b46f}},
   {{0x00065a434a35ea84,0x00070d4412f61df1,0x0008836c33418e0f,0x0009651af1f8af51,0x00002ceef4d530e1}, {0x000ca0b543a1957f,0x0004986cb1235560,0x00098ed30c33761e,0x00097c76624b1ffe,0x0000772f4c000909}},
   {{0x000410ef4f8b16a8,0x000e447b266a56f8,0x0009c87c197241af,0x000b1a8a406b8e6d,0x000003f3e034d42a}, {0x00009a804dbec69c,0x00067bbad05f7f03,0x0008e197fa83b85f,0x000dc106097273ad,0x0000097440f1067a}},
   {{0x000b6dd418e7ddd1,0x0003372f19d6c507,0x00027eb4d39888d9,0x0008846eae26be0c,0x00007b53ed40babb}, {0x000021b2b01ae4fe,0x0006ef488682fc27,0x0005e2d8788462e8,0x00029adee096ec21,0x0000b2fea9bb242e}},
   {{0x00000c756b95bce4,0x0006216da680bbcc,0x0002142525ec0390,0x0002d239162ee672,0x00003132b63c6a89}, {0x0003ff22f3263bf6,0x000c3cd0a1424bdd,0x000415ccbd5b3733,0x0004e9f92eaa8244,0x000063e8924ed547}},
   {{0x000ab35ce7c42d4d,0x000eb2feab100d38,0x000111b459fd493e,0x0005c276056b6d82,0x0000a11dae243efc}, {0x00002785545a7fb2,0x000c20d507e6dc74,0x00066fa58bdb2601,0x000c29f21dfeeb70,0x000014369a859ae8}},
   {{0x0007fa0b311898c7,0x00045d0eac653f74,0x00014d0bce2a272e,0x000ee2dbba5851f9,0x0000a1a966134a43}, {0x00067cea1c8cde9a,0x0008d271abe3e5a3,0x0001615cd9d958ba,0x0000b053ff7eb63d,0x00002280dcf95ae2}},
   {{0x000d566d4312483b,0x000cb43e216f8c0e,0x0000444935179a95,0x000a211c185fec17,0x0000306333a04991}, {0x000ecdb0081a726e,0x00056fa89bbbd801,0x00091b6b90149b0c,0x0003a2cfe9065a43,0x0000dc92787b633f}},
   {{0x000d9e37a6a308bd,0x000f7c2767d3d6d9,0x0008cbeb66237582,0x000d9db74a8bc6f3,0x000094d3f1b9cb6f}, {0x000735bba21f248e,0x00048cd1efb092a9,0x000b03284272ad0e,0x0002249437b69c05,0x00007f047034948c}},
   {{0x00068a9e9adfe1c3,0x000d014e39bb9ae8,0x000fe378f3984403,0x00062885875720f2,0x00003f901e0ea44a}, {0x00025fe3652438c6,0x00063dd1f20bea11,0x000bf7fbdae9ec4e,0x00079bbe740d9ebe,0x0000dbd3ddca2dbe}},
   {{0x00044a43794f8dcb,0x0009983c5c362663,0x0009d10a0dcca923,0x000df27d6b6bbf3f,0x0000320c5cb31d9b}, {0x00028ff47b50a951,0x0001bef03371620e,0x000100153933e3b0,0x0008d6e081bf8599,0x000083be9a0d3a8c}},
   {{0x00043d77613aa81f,0x000f95fe65848a94,0x000b10288801007f,0x000ee780fc4dbc7f,0x000058280d4d86be}, {0x000d82f7c978c385,0x0000bde44d7b14fd,0x00060252fdf1204c,0x0006a5508a1c8441,0x000091554cb11764}},
   {{0x00081ea77b46a081,0x0007b74806997ddc,0x00033f683cf5a647,0x000c6033a8cb3466,0x0000b867e6ba2363}, {0x00011141f60558ee,0x00024f41450e4392,0x000630e8bcdbcdd6,0x000b429fc04601cc,0x0000a7c66d677038}},
   {{0x0008820fbeee3f97,0x000fd9091afd34fc,0x00031f35c93e5348,0x000924064b9be59a,0x00001f37864c7e3d}, {0x00034e0943aa75e5,0x00085b8ff6e402fb,0x000cf0d19a18c9c5,0x0008a6b80f31b133,0x0000c9682db58351}},
   {{0x00085c341dca5663,0x000aa8622aa3b6c1,0x0001b6dfb7de7fed,0x00028869e84d9290,0x00000a02b0eac4ad}, {0x0001daa2fd3cf36d,0x00070f89e59fc7c8,0x000496733d131954,0x00012ae2be8184cd,0x00005f449ec63d34}},
},
{/* digit=39 [{1,2,3,..,}]*([2^195]*G)  */
   {{0x000ec644cd8f64c3,0x000ff79d7b51c492,0x000c7525658a2d78,0x000016dced1fc51f,0x0000e658aedbf433}, {0x000942e05da59eb6,0x0002addc37220b61,0x0002e7f87ba3d60a,0x000b6e1c311cd174,0x0000473ffef56b01}},
   {{0x000604f692ac542f,0x0000327b91d38303,0x000aaf9bdf079ffe,0x0004fa29f63e6315,0x000099ee566e1f34}, {0x000661fd62191997,0x0006648ce41c8a1d,0x00074d9048c883bc,0x000b1aa065118f3c,0x000013889ee7faf8}},
   {{0x000f697960eb8c77,0x000c72de04d3c035,0x000ad9228f1599f2,0x0001ab192450f8d2,0x0000d48129c2829c}, {0x00085e13a50afc95,0x000713a96ee024d7,0x000fb6d7b2745ba2,0x000a42456534013b,0x000036202676bad2}},
   {{0x0003f8f81a1b3bed,0x0004fe2764a0972b,0x000c4f5f74f3ce14,0x00085b12d0f1cc28,0x0000eee0c0e97f39}, {0x000adc0d39e25c35,0x00007467a0807df4,0x000cf5a584061982,0x0005fff40ebc9361,0x000027729a6922ad}},
   {{0x000398a4a9eb3f0a,0x000e9b99a48fa691,0x0004b5b3256c1dbf,0x0005fdfa87e1b91b,0x0000d639614f378b}, {0x000243ec26b53020,0x000c3ccb4c10437a,0x000e070150275878,0x0003c00e81e4a21d,0x0000c6265c9850df}},
   {{0x0000937b1b76ba6f,0x00045d2026dcca6c,0x000d9ae0a1a2eab8,0x000025c1715e1519,0x00001ad919aaac4a}, {0x000dfb807ea7b0ef,0x000e4ed9eb8935b3,0x0006d08abedf5496,0x0007309932e5ff2d,0x0000314874f15bd2}},
   {{0x0007149a8c25ff63,0x0006482e6569c832,0x00068fc3829bf255,0x000ad56012f5c6cd,0x0000e67e8bd6b982}, {0x00075386ecdca88a,0x000621753a045e3a,0x000db3256f297eaa,0x00005470121e5405,0x0000b9697d590851}},
   {{0x0006a753f73f449b,0x0007dd44fc79efb2,0x000c0dc4d1d1c94f,0x0000cf99f0fbc53b,0x0000747ea0be698a}, {0x000c3fe228d291e6,0x0004e3c129d65218,0x000acc51635b804b,0x0006689ac859b8d1,0x0000c10697df5d6e}},
   {{0x0007171f6bdf1bf4,0x0006bacb0d8fe5d2,0x00096a31b0b77b87,0x0001039a95471d84,0x00006a50dbb7f16b}, {0x0003f977b865bff3,0x00063b1c198c2a4f,0x000702ea6848195e,0x000228191ad08821,0x0000f20b43779035}},
   {{0x000438f0876fd4e6,0x000723d2f383c38e,0x0000934cb45f0c30,0x0006edc03cc2ecb1,0x0000a8f24398c9d4}, {0x000431b65ccde7b6,0x0007c7e76a6ff16b,0x0003484d741e2cd1,0x00044a59c8cf8f4e,0x00004426efde3152}},
   {{0x00098093a69fc01b,0x000b4aa9dfc2e6ec,0x0006f2a557e20fec,0x000fdeacfdbb07f5,0x00001cd6868bbbdb}, {0x0004995986eb9ed8,0x0004bdd0955e247b,0x000c7a20174785bf,0x00080d08f74f61c0,0x0000861a15bdd01a}},
   {{0x0008e44fc94dea3f,0x000eead6a0b01c0a,0x000113cef34c8cdb,0x000ff9a19c384004,0x0000d32fba505490}, {0x00090f6795dcfb75,0x000333588baf58d1,0x0001fc1c0fef01b0,0x000ac94e6d1d63ca,0x00003173f9740a41}},
   {{0x0007e4182997cc14,0x000ca3720c9c5463,0x000de5d4508c5a96,0x00075a38bce01c11,0x00009d623e54dfdd}, {0x000a4680fb2a3acc,0x000e719c25af8c72,0x000a92421cc53bbf,0x000cf2598eba7978,0x0000d61f28c63bde}},
   {{0x000402aba16f73bc,0x0003ccf9b9fc2b1d,0x0006ef7bf2fb3101,0x0007446d51e60e44,0x0000731021c791e1}, {0x00047244fee99d47,0x00068ac5c1ea9d3b,0x000ea9af74bca48b,0x00083a00f5f514bb,0x000051f55a6074c2}},
   {{0x0009fe8662595c2b,0x000661a807732389,0x000d1d43b495d672,0x00065ed6c971d2b0,0x0000518637d43b7a}, {0x00053bad98c99cec,0x000954d39f5b30e4,0x0001ce415ba6e0d4,0x00082337db02a643,0x0000d909c7db6e1d}},
   {{0x000251acb452fdbb,0x0004a0f306506e30,0x0003548d931ee696,0x000f5b00b3e50893,0x00008949a50a4b0e}, {0x00083263c88f3bd1,0x0000cb1d9989208b,0x000d4df03ab147c3,0x0000c5dd6515fd44,0x00007a12f75f72eb}},
},
{/* digit=40 [{1,2,3,..,}]*([2^200]*G)  */
   {{0x0004f7881fdad909,0x00057d2cf6ab2591,0x000054de5cf638f5,0x000350290bc03fcc,0x000032811a7a8b06}, {0x000b3309bbd11ff0,0x000fb40449742f00,0x00051d26676108a6,0x0000c1801bb9e0a8,0x0000dd099bebf899}},
   {{0x000dd8a58d6cd461,0x00057e6634d214c6,0x0001bc3289cb633b,0x0007e5b1305047f8,0x00002ede0e236a17}, {0x000ca62065a6f4f9,0x000cd7be487b332c,0x00047ed1cc3a47ec,0x000b13e41eb1870f,0x00009e66e5977598}},
   {{0x000a6777b0ac93d1,0x000d68f5e0d7ebd6,0x000f5492ba6e37b0,0x000f3a1516c09676,0x0000e4bf888aac05}, {0x0002ce04df0ba2b4,0x000d1062341bcdb4,0x000acac20935d5cf,0x00000e4a30333382,0x000029438c49198b}},
   {{0x00038be67e573e06,0x0008e084c44bfb28,0x000c1c2c505891db,0x00044b3131137396,0x0000aebfa4039584}, {0x000dce9e56e55c19,0x00029caa46d0ac9c,0x0001fe8eb7148ced,0x000f4c9e10c7efb6,0x0000fd835db8f97c}},
   {{0x0006f56c17706169,0x000d79da9a2d6c62,0x000730e455351909,0x000a79558e6825a3,0x0000d8c8bc093ef0}, {0x00078b6056becfd1,0x00039090b36d543f,0x0004432f933f1325,0x00050272ad499779,0x0000386493c5721f}},
   {{0x000eefa5abea82a6,0x000933fe62d43794,0x0001ef6068dc611b,0x000e6909f1af3728,0x0000af546c899839}, {0x00078c7c977ec238,0x000c3d5c05766255,0x000d1a4c0a8de294,0x0004d462ddaf0f7c,0x0000243fc70cf95f}},
   {{0x000f400b008733a5,0x000d012e1f57e566,0x000509cd0cba0697,0x000d8c4537c2b240,0x0000f989c69a7353}, {0x000c9724c3c2b2fb,0x00084f031fa87dbe,0x000d5d11f90e02fa,0x000dfc44d15c53cf,0x00003404faef8314}},
   {{0x000a109081e9387c,0x0006cc935828a36d,0x00040b015fb9780d,0x0006fa15940332e5,0x00009d7b51ca0f46}, {0x000cd41d6d9f6711,0x0008a1a2ac17faad,0x000201e5fba6c1e2,0x00062af66a7833ed,0x00009d9971a090f4}},
   {{0x000c3a9f327a07f6,0x000ae490937df02c,0x000b3afa5efb27a9,0x000be421451e96b1,0x00007e24de8f1883}, {0x0005d4770869e549,0x0003d4a3856a1ad6,0x00032e880d36291a,0x000fde770a1abf71,0x0000511d0a39e28d}},
   {{0x000d650f8d1cac45,0x000b1d16bda5fdee,0x000abbe46eb99194,0x00076c653b19f71c,0x0000f45af5089b92}, {0x0004c6126ee9d77a,0x000a6c02ca5dd078,0x00032e720f7a1558,0x0003f7161d6c59f0,0x0000e3ffb95e70cf}},
   {{0x0005facc72a4be52,0x00062d8480899b18,0x0007afea9f66de23,0x000c1c9a14d07c71,0x00005bfbfc04d551}, {0x0000ecd4cdf3d880,0x0003647f73c42cef,0x0002d67f78cee2aa,0x000a21c10a7d3d72,0x000090037a294564}},
   {{0x0007987fa9ced27b,0x00037a9e5dbce656,0x0000d8e8c36b2d88,0x0000d044bdeec638,0x00005e6a6b18bc30}, {0x000e9b9592bef367,0x000f7e81b7497ba7,0x000ce596b2b373c4,0x0004cbd84b5e01f0,0x0000cc51c6330bf5}},
   {{0x0007bb84f3815c4e,0x00033aa9017e6ac0,0x00085720addb9f62,0x00083751e30228ca,0x000059d63f65cb75}, {0x0008e777baad2d02,0x0004b42f5d7369e1,0x0007749832cfdb78,0x000d51e25dd53df5,0x0000f80e7cf0042c}},
   {{0x0006bafec695bb00,0x0008f13c78ad4bf5,0x00082abb022da1ca,0x00049e0f9c4b1311,0x00002ea555aae7d2}, {0x00083f25e05d9e30,0x000f70382afa8685,0x000080408e09cdcd,0x000658df072ec787,0x0000a317847cbf75}},
   {{0x0008d7f4d6ee4ab7,0x000e2570c3dc43f1,0x0008c9b2ad3ac8cd,0x0000f0e27e49070b,0x000016709a835a4c}, {0x00052b0916a26b1e,0x000e6e0711779308,0x0006948683cc17fc,0x00055c54f5e3d459,0x0000e0341ac828f6}},
   {{0x000f462060b5f619,0x0003ebd057c2f431,0x000e1bf65a56f46b,0x0001fea48dca6c47,0x0000a38783ed1bcf}, {0x00033a9da710718f,0x00063e0aeaf67a5d,0x00029d1875a77998,0x000732da87314d2d,0x0000a0edc3fb687d}},
},
{/* digit=41 [{1,2,3,..,}]*([2^205]*G)  */
   {{0x0004849cb198ac73,0x000cdf2646651c89,0x000200678a884a93,0x0004e5fda964ef9b,0x0000c351b8730983}, {0x000ef9fe2c4b44b8,0x0006b326790cafb2,0x00002264a580f6c4,0x0004e2384805210b,0x0000ba6f9e2c2a19}},
   {{0x00034abd3c095f18,0x000e64b76d7139d9,0x0003e698404b261b,0x000b109d2e6970e7,0x000079fb23bde5fc}, {0x0006c72dfd754907,0x0004f1bcf1c11150,0x0005e70073a97d08,0x0002a6d3201d82bf,0x0000f0ac52fe9823}},
   {{0x00001fb319d76820,0x00090a982feeb251,0x00061b344b029312,0x0001fa51c1c9b902,0x0000e008c5bbfd37}, {0x000dd1c0278ca331,0x0006d5aa53b1d866,0x00013a2cf666f76a,0x000836d5cfb77960,0x0000d3a1aadb3521}},
   {{0x000131a567193ec5,0x000a95f6e70b76b4,0x0001eebddaf3c305,0x0008314587bd3903,0x0000709def8c1bbe}, {0x00099830eb2b6692,0x000b675b70295705,0x00064ac164d80ce1,0x0003ab638a7da803,0x0000f431d23de1c8}},
   {{0x000276638235d4e4,0x0007096e3298e781,0x000175bc81c62bd6,0x000d4d4378660c3f,0x0000d04e18957afd}, {0x000160185a8068c5,0x000142b29a8532a8,0x0000d8a3bdb58e4e,0x00003b98a65b86c7,0x0000f0e6f4ee8a04}},
   {{0x00092b73f894ae03,0x0005875f18ce2c24,0x00053cad0f59df3e,0x0002944cb740d28f,0x0000eb585fbf4f01}, {0x0000c8632c7f717e,0x000acf943f4c17da,0x0007c51d2eb8c795,0x0009486ee23fb5f6,0x0000f18757648889}},
   {{0x00011a4e822f0d08,0x0000da8704f83ea0,0x000c6820fbc647ad,0x000bec3b315b3550,0x000063dec3e37e76}, {0x0005d3af017bfc7f,0x0008a76b822901ff,0x000bd0d3b2005443,0x000d0e167fca370b,0x000063dde656f5e3}},
   {{0x000bc15adf7cccff,0x0005efa1e1b075d9,0x0009bc17e81a3e5d,0x000d429c39e44424,0x000037dccb37ea7f}, {0x0004873907fba12d,0x00097a372904da65,0x00083a6c535daa6d,0x0005be3564cfc662,0x000009fa4f71a939}},
   {{0x000b3b56aa39dff0,0x00029f8e4d8cb510,0x0004c4b9f59b43da,0x000c01a8ce31fd9e,0x0000e20be26c1303}, {0x0007182e8ee47c94,0x000b3db981011818,0x000e14ff6d9687cd,0x0005723a520e4da1,0x000029808bac836d}},
   {{0x00046996d16768e9,0x0009d28bf217174d,0x0004e490d9fc4ff6,0x000979e7705a9415,0x0000d96dd291d2d9}, {0x000d9d8ce5d72c41,0x0004b11c714f77e2,0x000e4a03e9d06c5a,0x00028af2aa513679,0x0000386b3c2130ff}},
   {{0x0002d69ea40dc3a4,0x00026ecc018f26a4,0x00070f04adc84ad2,0x0002ece5c36c7b32,0x00006ba6d4790fa7}, {0x000d1c593e58a8e2,0x0000f20c088c6c37,0x0006e86daa239473,0x000038a3be4263cb,0x0000c417d369126d}},
   {{0x00023bb440e22296,0x000213ef4d04cca5,0x00011ec39324673a,0x0008d34f3adf343e,0x0000136d7f23c596}, {0x0002899b053a9270,0x0001ae067ecd7a7b,0x000779cd93eaa266,0x0005ea8549b9c802,0x000061d7940c5338}},
   {{0x00041fcaaa2902bc,0x000924f69ad3e071,0x0003f9ffd539ad79,0x0002f6e6453f9481,0x000058d3c48f75bc}, {0x0006fad5dc64e964,0x00097240e354b332,0x000a1e7a93aafcaa,0x00089fdd1b0903ac,0x0000ceb97675211b}},
   {{0x000de4687032d585,0x00030e2c79e01eb4,0x00004ef23c54f3d8,0x0001b3b7818df45d,0x00005faa9c8b73d4}, {0x0004f6f89b95355d,0x0009e7415c84ced6,0x0000ebad34860d2e,0x0005be8fdb9bd205,0x0000b53e0cd3685a}},
   {{0x000ca5fabfae1ca1,0x000c0a21459b919f,0x00066a4d2937afaa,0x0003318e0ca91c1f,0x000094cc7f333ec1}, {0x000143a8aa116906,0x000ca9b59e08ad25,0x00050860abe40ad8,0x00034bd7d60d9be7,0x0000c53b00926bf4}},
   {{0x0007080eb6b242d6,0x0002db71e246832d,0x00031139dd30bd02,0x000e531027991bbe,0x00008797e91a62e4}, {0x000e20a6b4e185ab,0x000d92d9b707423f,0x000f7811b82f2c67,0x00095c75c817684c,0x0000d53005eb45bb}},
},
{/* digit=42 [{1,2,3,..,}]*([2^210]*G)  */
   {{0x00049be9d8e68fd9,0x00028b044320e5f6,0x000c33398db0f053,0x000fae66fde9b3e0,0x00002f4209bf6c8c}, {0x000afcc1a739d4b6,0x000f428ab8dee9d1,0x000c6f1d009aea75,0x000aa4b4375fb5ea,0x0000420b560d08f7}},
   {{0x000499c6254dc41f,0x00038a837e7e9eae,0x0000524a77e29392,0x0005f184aec08c09,0x000082b921a7d6f5}, {0x000962e1402cec5e,0x00071a2f30e7493c,0x000b879cb9f17ca1,0x00045edcd783e8e9,0x0000a3d8c153a6f1}},
   {{0x00015e75e0dee6e5,0x00028c628aa2dede,0x00061bb9374f2487,0x0002e083e9c4fe78,0x00006d4822ab187b}, {0x00017cfc59826f90,0x00092408169eb664,0x0009ef885ca26096,0x00038fedf69d06c7,0x00000031f8adc7d1}},
   {{0x00046e60ebcf7262,0x00014231470e103c,0x0007c21094482b83,0x0006ef4f6dfaca48,0x0000e0ace9782e66}, {0x000a9d31f8d1f420,0x0001574944d23246,0x0007f334b1b1e83f,0x000d8113dfa63aa5,0x0000cf8daed9f025}},
   {{0x0008ea800ee11c1c,0x0003f5e3dd7530d7,0x0008c43c5eb053cd,0x000662db65b13ed5,0x00003ad49be7d151}, {0x0008e41b64279905,0x000d207eae1e99fd,0x000abb71e12cf15b,0x000d0dd9ad4f1b1a,0x0000143e74d57545}},
   {{0x0006336c88bdee1c,0x00059876767c3026,0x00073199625f2930,0x000950dc078571c6,0x000088690b3ad552}, {0x0002c2d852705b44,0x00040e09552d274f,0x0006575d1b0bf8d4,0x0006513628beeb98,0x000007be238bf864}},
   {{0x0003049a639fc6b8,0x0009060036250e5e,0x000cc1646e75c35d,0x0007398cf35bd85d,0x0000bcaced2ec262}, {0x000cf1db55367425,0x0006ca9e068be22e,0x0007909c5013dd89,0x000505c7f411cb8a,0x0000757ac98d61dd}},
   {{0x0001f0d1e935abb5,0x0003c54de37a85de,0x0009cebb5defd10b,0x0004be68d9e39236,0x00004d5ef9bc6132}, {0x00041ba74f17e266,0x000818c1dde44d63,0x000d918fdc0a0e3c,0x000a1346d7758187,0x0000687601562ca3}},
   {{0x0003e9cf36658f0c,0x000bb1f8057ec731,0x0006a835ac433ef1,0x00094bc53262461b,0x00008f053993c863}, {0x0008cdfe983c4a11,0x0001f3b7b931ff39,0x000b9045bbf5e816,0x00046b83193c46b7,0x0000e4ebf5db4a6e}},
   {{0x0002a6043a24fe7c,0x000e3fb3492bf994,0x0002fde0529c1191,0x00032cdf66244990,0x0000792a7ad2713c}, {0x0008ad8b737982c6,0x0009421e60e32fd8,0x00083591a7e3a031,0x000455a9b0de4473,0x0000df141eee310a}},
   {{0x000a039e6d6f4714,0x000ed198d12eaec1,0x000eee5ac14b2ba0,0x0004ceabc1a1603a,0x000001f483720b96}, {0x00037964fd03f663,0x0009ad8f3f122ee4,0x000380f183fdb4e4,0x000d163ef267f629,0x0000e8e9670bda64}},
   {{0x000180c207674f17,0x0006c3ae8fdbbc19,0x000aeb71e112e09a,0x0001c7296675546a,0x00009432af25101b}, {0x000558fde2ddec64,0x000f1357753fd5eb,0x000e1158a81392d1,0x00099167a76b973a,0x000016fbbff8a899}},
   {{0x000fdfd0d4a9dcf2,0x0008744ddf129e65,0x0008568667bc29e4,0x000fe29c1a92d93c,0x000073c69058e98d}, {0x000e418cdfaa6b88,0x0002d061c69f69fc,0x000f75e27606bd82,0x000a1ec2d495a06a,0x0000ed3d505ed873}},
   {{0x00028416ab25b6a0,0x00072b1a4523af55,0x000c99e03c6c0ffc,0x00091bab18827b21,0x000060e864890346}, {0x000f90f93c7f3988,0x000b02f8d10b5207,0x000d0f9e39f4a96c,0x0004f55d71cd793a,0x00004f435d37c3a5}},
   {{0x000c55b8e33787f1,0x0005963846734b03,0x00051b9f0ef42f97,0x0007c2ef7304f750,0x00008aca1dc841c8}, {0x00020a72d4bfe80d,0x000c353e732c56f1,0x00037ca16fd823b3,0x00096a41bccfe475,0x0000f6c9c74eb5a9}},
   {{0x00032c7904fc3fa4,0x000587e3636aee73,0x00091d9aa14a23f4,0x000540838659c3f0,0x0000a995e5df12d8}, {0x0003becf3a5598a7,0x000741eaa99520a5,0x00004e03c56534b1,0x0002682ed3dca4bf,0x000016c563b48d56}},
},
{/* digit=43 [{1,2,3,..,}]*([2^215]*G)  */
   {{0x000dea7e0f222c2d,0x000ba2e651425043,0x00016cd30309d42a,0x000eebc4fe9ddd92,0x00006539c7ddf87f}, {0x000a57c432ac7d72,0x0000127fda1003c5,0x0000698de72692cf,0x0003b1cc28c85f28,0x0000331fb469ec28}},
   {{0x0008eeae457a4773,0x000bbe6ddc05a015,0x000c41671d19857d,0x000d588326522418,0x0000ffdfc7e6c2c0}, {0x000525426ee7cda3,0x0009af02c3a83a3a,0x0003bbfc8341b086,0x0006917023bf4272,0x0000d15002a44452}},
   {{0x000b2f687500b96e,0x00064dcd9425c961,0x000615433795510e,0x0000282308172978,0x00005d0145545445}, {0x0003302bf690cbe3,0x0001431eca675bd1,0x0008038a444e4883,0x000f0243306bc72b,0x000051d151eef57b}},
   {{0x000324c85edfa308,0x000407d4f3da5ef7,0x000b50c862597655,0x00096bb52f5bc0dc,0x0000f6927b0c832a}, {0x000e1ba55f2f94c5,0x0008e44b45fad08e,0x000aa455d6a996f9,0x0001f79133cb8da8,0x0000d0721ecc58dc}},
   {{0x0004e1f9a8764417,0x0003a47a818df3d4,0x00003edde82bc0c1,0x00025fc3ddc11706,0x00007163f2e7a25f}, {0x00002caa3bfaa53f,0x0001f2256982b54c,0x0006f37dcbd1b250,0x0004a4d4e1728c1a,0x0000e36c214714c9}},
   {{0x000e7e9262a35393,0x000d3670d59ef3ca,0x000c5e1b978a49d1,0x000c1c07de0f63c1,0x0000072c30c99cb7}, {0x0008a5277c850e61,0x000f0f6a3de61d27,0x0002ca7ad84f15f8,0x0004b836a8bb4559,0x0000912e3eef4d42}},
   {{0x000e2d490e317342,0x00065fca007cc1ff,0x0003f77e891b1f12,0x000c883459b1d0ae,0x000062b051d66425}, {0x0008f765c51e2741,0x0002204e6146cf5c,0x0004046b5997481e,0x0006bd5fc1198bd8,0x0000cb0a6bbf7f7a}},
   {{0x000a92079e5fb67e,0x000a90aa725e6ba7,0x000f5d837e1331fe,0x000e207080ccf57d,0x00004cae01e5ff72}, {0x0003ee60412a77db,0x000c2f449025d924,0x000ef5a3106ff7ca,0x0007a80e75f7cd23,0x0000c957822bddef}},
   {{0x0007ad11b7f30b08,0x0005b629dcf9c473,0x0006ae160525ab2c,0x0006e0163f4cc118,0x00005076713f3e6b}, {0x0003180f6998bcf4,0x000371c8d8d8d9be,0x0008c005493d91da,0x000768b902ce661b,0x00007e7924db4a8a}},
   {{0x0008086365e668b9,0x000a1abda5fbdc98,0x0005f1fbeada8dcd,0x000fc32c146b4c25,0x0000cfcde2a5f34c}, {0x000453e7e85d1e48,0x0009792358b5acbb,0x0000823ff9ca0967,0x00011d95fc2d9624,0x0000d65adf78c11d}},
   {{0x000fd177e19a46f4,0x000746161156323c,0x0007d33630948a7a,0x00079d10d06b977e,0x00001c47ec1e7025}, {0x000998e59e9260b4,0x000406c242609455,0x000bc3744c865e44,0x000149f93021ec13,0x0000981994f0d92a}},
   {{0x000230cb0ce1c552,0x0004ebbfb6078cf7,0x00016363b5b534d0,0x000e82ce1ef1130e,0x00007e0aa7ad4999}, {0x000ac2d79362c410,0x000091bb6cb0ce1d,0x00023df2467920c9,0x000f281e648d6322,0x0000f7d9eefe32e8}},
   {{0x000f264d66f51c09,0x000acd9ccea59766,0x00021e232644317a,0x000737139b37bcd7,0x00008bdde0c49daf}, {0x000c758165166bd1,0x000592802108c2ec,0x0007aa66f0951a28,0x000a27d39fbf2499,0x0000a2f6862eb62d}},
   {{0x00057f10296f4fd3,0x0003ba51b4367755,0x0009508051dca76a,0x0007f1c3e98f60fb,0x00001ff32eab31cf}, {0x0007bf18d2c714bf,0x00083e9d2aca643e,0x000dc2d2364b5c33,0x000b9ab9fd9ccc6a,0x0000c2397edbc721}},
   {{0x0001fc764465367b,0x00047b098f57ab65,0x00082376fe438701,0x0009285a91d519d3,0x00005afdb0b03cad}, {0x0001875138d55231,0x000e0aecacfb457e,0x000484f49a92beca,0x000c2af762f6e811,0x000014b5c86eda16}},
   {{0x000f39afa8338349,0x0002163285626943,0x00070fc102295172,0x000e6cf1d63dd541,0x0000f5fa5903ecc2}, {0x0008725e77d9a3b0,0x000a6384ebe0b66c,0x00045e24a11235ce,0x0003b106a8c11858,0x0000137b286ebd09}},
},
{/* digit=44 [{1,2,3,..,}]*([2^220]*G)  */
   {{0x0007d6ac42bd6d29,0x00082b1f96aedb56,0x00043b28e6df8646,0x00023f7efe5b1a48,0x000061bbb05f379b}, {0x000f5f070a6a26b8,0x000cb28e6e39b6ca,0x0005fc8d370686c0,0x000dc900da06cf89,0x000004d88113363f}},
   {{0x0009ce74462007dd,0x00047cb5f5b763b9,0x0005edde7b8ab48a,0x000fd9cec673d2f5,0x00001567f755cfae}, {0x0001b6b0887bcec5,0x000e9178f3c24638,0x0006266cb694497c,0x0004130e6525e31e,0x0000931de26b97d6}},
   {{0x0009da11f17a34c7,0x0008b35a145614e4,0x00050363b5420ab3,0x000b6e476372412f,0x0000b15d62433fab}, {0x00040b1e274e49c4,0x000456b1860aa0ef,0x000afe5a45cf5074,0x000e9a96583fbf66,0x00004240511347e3}},
   {{0x00055021a93507a4,0x00074d3c06cf142b,0x000ec3f40b4cd118,0x0003c29f70e76a91,0x000084e81ad8e755}, {0x00087b5272e9d6ec,0x000506ff514a830f,0x000192a8eea1c93e,0x000359a7cc2adcc4,0x000077e27e302f45}},
   {{0x0008b1e48ac28403,0x0004bcba9477b535,0x000946b431831129,0x000819aa58f990a6,0x0000098baf9cab41}, {0x000c1584198da522,0x000bf46bfd1b66c4,0x00036a908ab4fc17,0x0008380f0a4c3cbf,0x0000ae9e34b78cf7}},
   {{0x00040ec0ccced589,0x000b7da44f9845eb,0x0001812c625cd4b9,0x000650b3e0645887,0x00009f80d55a6cef}, {0x00040c9ce6dc1532,0x0007b86655215713,0x00007014d138d511,0x000b918cdb45bc4e,0x0000f34bb38a4b60}},
   {{0x00099e84a34f239b,0x000c090402d54174,0x0003aa83215fdb83,0x000db1075f46bf43,0x000061e15b013215}, {0x00059d4a127f89a5,0x000bb7e816daaabe,0x00018b6925d541e0,0x0000265aba0659a6,0x0000532773367266}},
   {{0x0009cf2d0c051995,0x0002aae784548cda,0x00072a182502fbc2,0x00037270bda9dff5,0x0000f9b71b8b158b}, {0x0003a592b82dd077,0x00052523032ee0f3,0x000505a327630273,0x00009f0fe1a721c4,0x0000b6e3e8367964}},
   {{0x000155d3f6effc78,0x000f1c90f0c7023c,0x000ec2c5d1fbd69f,0x00027365d7da8abe,0x0000813872c57e86}, {0x000c2c655f5e228d,0x0008e0923b419f3b,0x000a307ca1148286,0x000ee495d75c741a,0x0000a92c2584f24e}},
   {{0x0007732edc665d13,0x00017939ef1b2635,0x0009680899fb5b73,0x000c524db720fb94,0x00006f75f2c63138}, {0x00093ec48d3cb97f,0x00047d261726f8b7,0x0005c4ffb8dff1d4,0x0008700b65791b88,0x00007c79e2ee1a3a}},
   {{0x0001028754c92e1a,0x000a2f0fef3408dd,0x000f55919ca90b57,0x00086a7a9b84ac8a,0x0000a95e0e28d936}, {0x0007315167021a4e,0x000940d5ff984673,0x00092e7066cb6a0d,0x0001a60cc4801a10,0x0000dcab23b1c5e6}},
   {{0x0006356ea37ba9e7,0x00049afff55db4c6,0x0006cc8621adc841,0x000ab680080ef959,0x000056c85b8dd647}, {0x00094aa1db9c2153,0x0000f013b1a5c9db,0x00086c9032dd36db,0x000884ae6ac61c42,0x0000fd32f88f76cf}},
   {{0x00090fca06d107eb,0x000d076611377f12,0x0007b4b38697261f,0x00012f6bb5be4e94,0x000049826b6ebb79}, {0x000dfe85ba8bffb2,0x00005e3fa8e4019d,0x000bcfe7fb1af790,0x000aea52e1bdf201,0x0000ed3ca8ff1169}},
   {{0x000da8cd745fff18,0x0005e9b9924e3bef,0x00051138170b9e9b,0x00053525df48cfd1,0x00004f93fe3506bc}, {0x000c5a9b279a6c36,0x000478f96132aa42,0x000b6aea5651da6c,0x0002a250368c8b01,0x00004e44c480c786}},
   {{0x0009947d9de99a88,0x000d493477bde17a,0x00019e287c2e61b2,0x000134d7f684d41d,0x000043c21237e358}, {0x000e2e904f7e8aba,0x000915f27aeee2d3,0x0001858c4bf93ffe,0x000dbe89830d1d7b,0x00008f449652106a}},
   {{0x0007bc035d0b34a2,0x000b6327c0a7e341,0x0000362d1440b386,0x0009436fb7262dac,0x0000c41114d00cdf}, {0x000cef1ad95a0b12,0x000847d543622ba5,0x000e486c9c09b37a,0x00029706d6cdd201,0x00000477abf62ff9}},
},
{/* digit=45 [{1,2,3,..,}]*([2^225]*G)  */
   {{0x000dcb3292a92874,0x000637b092c7a004,0x0006c0605ddc15cf,0x0007afc83a846480,0x0000a68df707db99}, {0x0004e4505bf7dd0a,0x0008eccf7f8c9c13,0x000b5f8afa4e63d3,0x0001cc06e6517f41,0x0000a8b93434d7bc}},
   {{0x00064717af715d2e,0x0003f0134a96c417,0x0001ec956e2f7f59,0x0003034c1873efa4,0x00004e7b4f757821}, {0x000ff9788d5374a6,0x000320823d5be5c8,0x000ee8fe22b915e6,0x0006518a6bc755b2,0x0000657624d47112}},
   {{0x00000e07442f1d58,0x0000e6e0e3abd6f8,0x000c64047475607d,0x00083d02807f16b7,0x0000858e1e427498}, {0x000120b8231ee10a,0x000ac38a1ece5859,0x000aa73a41b80e7e,0x0003ac2b72525ac6,0x00007cdea3e24442}},
   {{0x0007b11e51732d26,0x0007c538fc0e5747,0x00039eec5dfd6eb2,0x000c56fc43b0cc3b,0x0000af127792b36c}, {0x000852d06c425aef,0x000b6c221b9b70b0,0x000826d9c6df92f8,0x0009c27c8d4f9ece,0x000059aba7ca4935}},
   {{0x0002cf152bfda056,0x00090197b98cd2eb,0x000a1726fe0e4c4e,0x000e3cbd35076cf8,0x0000c06085b8db11}, {0x000c4d74463ba14f,0x00021030238c15c0,0x00027536d9d292f8,0x000c1d2311ee8b37,0x0000eea86f0aeaed}},
   {{0x0006054afa05dd8e,0x00011caf119ea7f9,0x00064bb5926dfcf2,0x0002b8020ef2e305,0x0000f4dca5141cb0}, {0x000838a65d306723,0x0004cd657e86cda7,0x000d595c88b08d53,0x0008361c5b439546,0x00009b58725725cb}},
   {{0x00053931a62cc262,0x000630c0e052fda8,0x000c633f323c69b9,0x000d488227df15bf,0x0000ac788483bae7}, {0x00078f9187d073d8,0x0009167f807d4878,0x0006e6d8f6c2be91,0x000a42f65861d833,0x00008b8974d4e528}},
   {{0x0002c2e421d3aa42,0x000cc84fa840c37e,0x00054e41cf926407,0x000643f8abc03d14,0x00006605ecd5f7af}, {0x00041a6d6a5eabf5,0x0003d16b668e2423,0x0000101021edb84f,0x000d8c8836edb804,0x0000b337ce7e45e1}},
   {{0x000a2dccc78cf662,0x00044fdbff77666b,0x0008d4668b301817,0x000a2a6d4dd0db16,0x000059455d03dab3}, {0x00064c5cde3acec5,0x0004c3adb276f585,0x000303f657714192,0x000f7b027d725d8a,0x00005deb6ca36f38}},
   {{0x00005d73272d8383,0x0009ca6295c5864d,0x0002fda32e22924f,0x0005445189593f6c,0x000030d7189e184b}, {0x000a62cbde1f7140,0x0004e5cb1a6379ef,0x0001c833235771c9,0x0008542f4826b864,0x00000a894fbc8cee}},
   {{0x000cd0a1058a3184,0x000538053a9adcda,0x000c68de2369cf3f,0x000d9f86c3de5031,0x0000653a5767c4b6}, {0x000dd5aaa4e5c975,0x000167ab3c741688,0x00065c2835be80aa,0x00009120cefe7cbc,0x00007f95f1356867}},
   {{0x000b6de34eaacda9,0x00079ba0f1dec240,0x000438e55d9e116e,0x0002d73be45ec779,0x00001787c9e26f75}, {0x000532bf129ac2fd,0x00078a36e22c897f,0x0009fb8f3d307b7c,0x000b27c194067574,0x000014f95d0e57fd}},
   {{0x000360416df4285e,0x000af0c56ae21625,0x000c5cfc3b0c9bab,0x00005593032b19cf,0x0000497e5c3e9752}, {0x0006bb4164bda960,0x0009a0b74da11209,0x0003826ba1ee4241,0x0006608fc3624340,0x0000c8f0069dc09e}},
   {{0x00074a15b0ec6f5e,0x00037289b2b8c44b,0x000d6fc7347989fe,0x0000aa945f848458,0x0000c362a70d61c7}, {0x00098a7b3a8ad418,0x000ffb63db51070c,0x0004c35f473a20fb,0x000dca6d2c2173f4,0x0000a56149e1acc9}},
   {{0x000c36f35d33ae72,0x000330bb5a94a395,0x000afe84b200ea12,0x00076a00c789bd0b,0x000043ef52d29192}, {0x000c577e23ae233d,0x000ed460d1ec3934,0x000fa76a4b93807a,0x000490e72a53b1f8,0x00008914cb193ca4}},
   {{0x0006b86d23ddc820,0x000c7e0143f04c07,0x0007af2c503fd344,0x000a4fa95362ff31,0x0000add3db7e18b7}, {0x0003e3f8260e01bc,0x000494a1cc919c67,0x000f2e433fbeb49e,0x0001ead1351bf292,0x0000755e7ed45114}},
},
{/* digit=46 [{1,2,3,..,}]*([2^230]*G)  */
   {{0x000db47f23206d55,0x000fcd2601522bf5,0x0008ff89a2f6d341,0x000457c7b876533f,0x0000157c30c878fa}, {0x000c5c52d4fb936f,0x000bf6518cdc7517,0x000847a64ef22f7a,0x000a88eeb483e6bf,0x0000508455982e0f}},
   {{0x00059d8df7304d44,0x000bbf210e8eab96,0x0003fbd60b71bcf1,0x0004de69a2438bd7,0x0000595cd1f9d11b}, {0x000329a4835859dc,0x000cbdbb6e569c0d,0x000928a4e4a0f0d2,0x00015406038e5edf,0x000094296224f5ad}},
   {{0x0003840a70c6ec41,0x0007d031119508a3,0x0008ab2029e8819f,0x000a27dd209d9670,0x00000d7c4e7de943}, {0x000b317a29b49a1f,0x000256627d1f372f,0x000df39ec57a67fb,0x000f170912561e7c,0x0000a3ce6f35f7c8}},
   {{0x0003462f23f2d925,0x000d10b940789121,0x0006cde206cab71b,0x0004bc1bdd0a6317,0x00004c9b20d3e4d5}, {0x000d8aa9f2ac02f8,0x0006a06eedb03cd2,0x00008643403f8e61,0x000db947f68e1693,0x000031469c612dd3}},
   {{0x0007465653f3c5f5,0x000ea040feb1fe7d,0x000b7edfe283dd45,0x00031141fe599bf3,0x0000ff039add0379}, {0x000995b4e96fa49d,0x0001d3e25094bf76,0x000c83f742640b6b,0x000ac2bb096341c1,0x00002bec885ca560}},
   {{0x000df248f9813540,0x000c3588a2598521,0x000a0992c587e23e,0x000407cbedf281d7,0x00006930a5538961}, {0x0000debbe5bbe21a,0x00048491817f0932,0x000065160a7ffa5b,0x0002a946c8b4d909,0x0000c4f39939ff6d}},
   {{0x000b2a3cc53da664,0x0001b17a9b4e2e4e,0x000e05b2c04708a7,0x0002019bfdc7b20d,0x0000cdc9aee8907a}, {0x0008dfc6c475566e,0x000a67be1691e5cc,0x00005c3fd2b83cbf,0x000eaf895833a74c,0x0000e938a7323b0d}},
   {{0x000a1583ae9c1bde,0x0008037ce2407aa7,0x000ab38b4e0af6d9,0x0008ca054342d928,0x00008b75007ea1c9}, {0x00086afe02358f2b,0x00063a921228efce,0x0001c67fc31b8b85,0x000d58552a19120a,0x00004069ea593aea}},
   {{0x0006205c6ffcfe64,0x00066a39418a3b82,0x0008521fb2eb3125,0x00061584b4a9e1c1,0x00008614dd91b610}, {0x00062bbeea7475fe,0x0008c8ead16204c3,0x00010a876916ab96,0x000ec38a7975bc03,0x0000a4e7d12ccc77}},
   {{0x000d6e27fa03cb3d,0x000a3fdd7d883232,0x000cbfc5ddb938e5,0x00080e34c1d2cd2c,0x00002f45c137f3a5}, {0x00020b57883e6142,0x00089e7c5f265926,0x00067e1e35fd27e6,0x000aaef39e45a915,0x0000cc71d2d64d8a}},
   {{0x00093c706ba8e6ff,0x0007223deffd6ef4,0x0002b5a4f05c07bf,0x000e9bdebf9b4d9c,0x0000958147f1d038}, {0x000cee03e5561c4e,0x0009994a6afc5af5,0x00072168b8d0b5a7,0x0007fcbde22df137,0x00005d249c6b8409}},
   {{0x00090cde36d07576,0x000179a293824a90,0x000b48ddff722d7b,0x000f439b7fb04c04,0x000028ad2a84be16}, {0x000bfb520226040e,0x00007104b6c4cd3f,0x00003c1886c34ecb,0x000aaf50c0754ec9,0x0000c336b090d23c}},
   {{0x0000b4295c69248e,0x000d1ed9030374c7,0x0008cc87a8813259,0x000a94c3e330684b,0x0000689371cf11a7}, {0x000bbf7fbbbc20ba,0x000cc5f9a6e252bf,0x000413e6d73a8543,0x000031c7bb2fdd7e,0x0000066b3f065cf2}},
   {{0x00062a21e206ee56,0x00002c49a633473d,0x000f6b2c3f1e2748,0x0006ea27ab956ce9,0x00001830b48c2b60}, {0x0006846e78e815f7,0x000edc02082a67cd,0x0002ec365fe40139,0x0006aae2bbbfcb95,0x00004c11642db983}},
   {{0x000b89c44f489710,0x00076d660683cf61,0x000d431bde2d700f,0x000f4a72ef285cd1,0x0000593b24e9bdeb}, {0x000bc5b0561f8a1a,0x00000a16f2564084,0x000f6d27784ce74d,0x000dfdfcbc79d309,0x000094fe2fee139b}},
   {{0x000439e558df0194,0x000a6c712b279f51,0x000185a24230da4b,0x000f50118919e355,0x0000dcefcddc4b78}, {0x0000fb2a47d4c5ab,0x000f030e009ea7d9,0x000eed27355ac9ab,0x000faf4d2fc35974,0x000072d824d8bea8}},
},
{/* digit=47 [{1,2,3,..,}]*([2^235]*G)  */
   {{0x000b2b5ef7d92893,0x0007e97f015a549d,0x0000493b62480d4a,0x00033131d5590bc4,0x0000a55b52e9f780}, {0x0008115309eadb09,0x000a02e5c62540eb,0x0006a3d5adea7de5,0x000d60d4d631f0cc,0x0000d5e9d7d23e8d}},
   {{0x00060411e84e0e5b,0x0002fea34c931968,0x00073a732a5db84d,0x0007c049d5bb1970,0x00008d2fe571bcfd}, {0x0005f36f3eb82fab,0x000c4dff8b584577,0x00074c1108cb20cc,0x0008996659b65f83,0x00008b4a422e30c7}},
   {{0x000ff87aedbae9f1,0x000926880a54c925,0x0004d0e717daf0eb,0x000cf58284ddf59c,0x0000581cf93416f8}, {0x000a8873ac1f4527,0x00098b6aeffe3eec,0x000fb8dc3b417fce,0x00040035918046ee,0x00003d318ac72209}},
   {{0x000cda3af2ebc2fd,0x000cfb4efe24c4f4,0x000cd10b1a0af843,0x000e0383b857c19c,0x0000dc9d1ec614d3}, {0x000c8bb62771deb1,0x000a81c5aa817bde,0x0002391ae829277a,0x0004ca6af18dd683,0x0000740f316d71a8}},
   {{0x00012d8e12b31f8c,0x000b577736e6dd4a,0x0008935e8577e29b,0x00086c6353722ba8,0x0000a1d3729c15f2}, {0x000b6a239a3e0358,0x000f53b03a9f86c7,0x0000d536e6e5250b,0x000831f9d98930fd,0x0000c4cbbac7a0c3}},
   {{0x0000910cab91f1eb,0x00039d1cd2162d50,0x000d02252bedd9e4,0x00017a2634b74fed,0x0000d60f8e1c2586}, {0x000537b9e05614a8,0x000667af5fc5d8c7,0x0002bd926fd26c76,0x000fc78660b58158,0x000070192452cf07}},
   {{0x0006ccfaf64ecb6b,0x00069bd72775afa2,0x0000f695ae6054f9,0x000fde0bcbab5b14,0x0000c71b4a59348e}, {0x00052becc96d9633,0x000f2e5d9018fc2e,0x000568771150abf5,0x000f838d182fa604,0x00005b4c061a0339}},
   {{0x000e99aeeaf8c495,0x000d1e24d7288928,0x0002b156cee7aa73,0x000a1cfc5007c2e7,0x0000fcf57c63d408}, {0x0009e39b6057604e,0x0000e2868bbf9f71,0x000103e2d7d343c0,0x000ea14cca254b7e,0x00006eb38aad131b}},
   {{0x000a04e5f40ff526,0x000f9cd2914ac624,0x000d3bfd63611d7c,0x00063a57e8b42b1f,0x0000cde40fe5a850}, {0x000c449178b7e5bc,0x00006972cc137811,0x000b461354cb6093,0x00056e3579125e33,0x0000a102ef848a4e}},
   {{0x000e3520a981b0d0,0x0003bd1a41a40ba4,0x0009fab9c1c354cb,0x0008d51aabaa3adf,0x0000701a7d153c41}, {0x0007cefdcf2b9218,0x00033cf48061dd1a,0x00025cce66ceef0b,0x000e339083b598de,0x000090a54c8690a5}},
   {{0x000956640ac1807d,0x0005b4da0b1ec535,0x000b82421d4c1e56,0x000dfff4b33f97e0,0x00000bd23184b41b}, {0x000b42e147b72e1a,0x000f5777104c53a4,0x000fb530df8d39f5,0x000fdc96e64e64d3,0x00007a6ba67f6074}},
   {{0x00018db4f6d01b11,0x00027f11e8a04057,0x000591a3be73c6bc,0x0005319c11bb8ca0,0x00002d09a5a1acc4}, {0x00074eee7de13f4c,0x0005444fd682cbf1,0x00048af70177e2be,0x000b7ba5f574cb1c,0x0000e5966935961c}},
   {{0x000e84ebc6fab9f1,0x0001b80f6474989f,0x00002a1bce70ce6b,0x000fd3ae9ff3053b,0x00002ef4866a9c0a}, {0x00057f9e3411a268,0x0000fb485b9822d9,0x000e201190b41d88,0x0008e0020e56d04a,0x00001e3d01fb2852}},
   {{0x000ed6c048752a14,0x000e601341b4c59e,0x000c6b09241f2702,0x000b232e35903b9d,0x0000291aba85f5b5}, {0x000aa70a653d61da,0x0003af2eb51e8173,0x000b93f8fd1b648d,0x0004fd91b7ce065a,0x000055408ef39e2f}},
   {{0x000ed0985e341605,0x00032a03cde21fa4,0x00084df2da26d7dc,0x000107cdac0848fa,0x0000e9a28d66b697}, {0x00004d914ea0ea1e,0x00075ffe5520a880,0x0009b139ca8d1542,0x0008606f422dae63,0x0000edccc0eb4b5a}},
   {{0x000624f8be762b49,0x0000758e3413b33e,0x000d805fa2a9ee4d,0x000fd7068e636967,0x0000848949c0db8b}, {0x000d7e5d23a84178,0x000d73e29da55308,0x000ee471f892f3b1,0x000089495c139e3d,0x0000631594e5757e}},
},
{/* digit=48 [{1,2,3,..,}]*([2^240]*G)  */
   {{0x000e2ea1f095615b,0x000664e68c331083,0x0008818be0a28ad7,0x0000ccbbfc02523d,0x0000585113ba3585}, {0x0005f0b30df8aa1c,0x000b8ab7e3ac7d93,0x0002f00cbaddda07,0x000f6bd2c3429955,0x000033ed1dee909d}},
   {{0x0000d483e07113c9,0x0008ed8b63ae2dc4,0x000684c2b6e4a5d3,0x00026bc582a94b79,0x000032b33d4f22da}, {0x000f6510dbbf08dd,0x000894c23a52f534,0x0005bdc9b211d07c,0x0005573eeece0fee,0x0000f178169c7015}},
   {{0x000905a83cdd60ed,0x0004d1170184abe7,0x00023642a50602fb,0x000aff989886cdb0,0x0000568d09176e1f}, {0x00022c70259217fd,0x0008f43141e45b19,0x00095f86e93831cd,0x0008280fca35870c,0x0000ec2057b268ae}},
   {{0x0008925913cc16df,0x000cf1a26f5a568f,0x000f499ae18bc5b6,0x000e83efa413bef5,0x00008835dedb3f0a}, {0x0000bd865a40ab05,0x0008c94b377eb6e6,0x000084a696559643,0x000de06cd8562592,0x0000ce433b99f23e}},
   {{0x000523d42e06189e,0x00006e3aff13860d,0x000b20650bf07794,0x00000c2b616dcac1,0x000066dd6d201313}, {0x000fd67ff99abde3,0x000097aac50dd4a0,0x00046b2d7c990355,0x0002aed22ecf8b7c,0x0000333b1e86abf9}},
   {{0x00065e784d6365d8,0x000f0f759fb8c0da,0x000e81930bcb7443,0x0008aab5c712b17a,0x00000428dffcc6e0}, {0x000afefa4faf8433,0x000dcfa9855ff19d,0x0003ac7ceced8538,0x00071df0ac409cbe,0x000058c1fb6b82da}},
   {{0x000def7be42a5821,0x000055046be6efec,0x000e8dba9d3fc608,0x0001ffb9af13c809,0x0000e6c984774149}, {0x0004925d30c31f70,0x000aac2a21223b57,0x0000859e7b7eb72b,0x000942776a0dacef,0x00006fec31421900}},
   {{0x00094b07e50122b3,0x000b1af07ca53247,0x0003fc97bdd744f8,0x000d9d00a12f08d6,0x00009650f1aa6626}, {0x00047f71fa38477c,0x000914dc124f101b,0x0006eb58a3d815f1,0x0008865569ae95b2,0x00003cde18955fb1}},
   {{0x0002fbbf4737f217,0x000af209f5ac7ec6,0x000f9adbed8dba5a,0x000767b4b5d7a9a5,0x000007d28f8161dc}, {0x000460bcaa999eab,0x000c6c92e4cc7711,0x000d4bf2dba7b174,0x0002788c4bab6618,0x00008f0c9819b8bd}},
   {{0x0008932790691bf5,0x0008b6b736ae9d65,0x000d63b6eed61058,0x00088f212c2f04c0,0x0000cf06fd6163d4}, {0x0003facd9588e411,0x00021b93257e9736,0x0007acace1f9bf76,0x000ecf99d1ffc466,0x0000cf4a1aa1a061}},
   {{0x00075b2c0519a238,0x000dcf6952e328d6,0x000294a8a9ebf94f,0x0003f5728bb767a2,0x00005512b4e7e0af}, {0x0008ba899b16a0de,0x000bda7548a71895,0x0006be61595c2430,0x00074bd30d1b10a1,0x00003ebbb9865bfb}},
   {{0x0003f5eb2e636456,0x000724c8423207b5,0x00014d5cfbe57e54,0x000aca7779c21672,0x000017969cd629a3}, {0x00068cd8a7017a0a,0x000a1e9b7ee8d176,0x00016177677b4d19,0x000a71b8fd0e939c,0x00008c4f4f075968}},
   {{0x000b865d2fdca23e,0x0007ec8ef89581ee,0x0009056145a15ee0,0x00019a968fa10a01,0x0000ff5b8f0680ee}, {0x000cabbcb1c8a0ef,0x000cc8c838f9f0c0,0x0004a14c02e1ee9c,0x0008e41587d8b88a,0x00006f278971ff69}},
   {{0x00034b3bf44da801,0x00094ab32e66519d,0x00078a000283834f,0x0002f65e60879762,0x0000e62960e72731}, {0x000b27be6901c550,0x000824fdbc1f9b87,0x000acc27d80e7853,0x000b5abbbc09512f,0x00006394239ac143}},
   {{0x000646e9e2fce99d,0x00004e80857f9c4b,0x00043b52a68a2108,0x00084236d54e4436,0x0000e8d6d63dd8eb}, {0x000156342146a0a4,0x00021eaa36227032,0x0001387878ba826f,0x000d36e27a58bd86,0x00003b6c03c50281}},
   {{0x0007a952f41deff1,0x000ad63b89b702b3,0x0003ff9510e44a59,0x000af4573257dc14,0x00009c02205e752b}, {0x0003069c4b7d692e,0x00031d1502ac46c2,0x0002208462e6392c,0x000b628057b1a21b,0x000051ff946ec1b5}},
},
{/* digit=49 [{1,2,3,..,}]*([2^245]*G)  */
   {{0x000cb51566c5c43e,0x00085597f0466e85,0x00094d94acff9c91,0x00027cb354e90c49,0x00000a3933301479}, {0x000fac10dc1eb2bf,0x00013ff319fa8427,0x00096527488cfd8c,0x000745f2d4e68401,0x0000a2e067e57aaa}},
   {{0x0002a7f3e5f9f11f,0x0009e6cb3b8eb6d9,0x000f800bd9afe153,0x000e185d1a6dd7dd,0x00006c13cc1baf17}, {0x000c58e325fc3ee3,0x0000731dc3b215f6,0x000a3d3e77109540,0x000e2ce68e7c07af,0x0000f8417a1c4c7a}},
   {{0x0004772813b230d7,0x000ea7344427ec23,0x0007fc56a634d0f5,0x000f76a1548ab1d7,0x0000fab17513e06a}, {0x00010a74f7c4f830,0x0004220a67d9b62c,0x0001209a0a7d2edc,0x0009f01c40417092,0x0000b9815a0face5}},
   {{0x000589b319540c33,0x00097283d6f82842,0x000ae9fcb18490f5,0x000ba072731f84da,0x0000db6d960f3683}, {0x00063bb146110697,0x000e9788bf05c85c,0x0007460d2b19436a,0x000db1205459df34,0x00003f6e095511a7}},
   {{0x000938eb6357f373,0x0008fbd8aa62dc7f,0x000a979fcc5d00f7,0x000a999878dcb92c,0x00007e83eda1b023}, {0x000e2731560bf3d1,0x00090d0fae616b23,0x0009414bd1086e45,0x000ea1682483169a,0x0000b956bc100ea9}},
   {{0x000bb91c31b9c38e,0x000a68ef57b57b85,0x0003bab6f0c5aa90,0x000684fedeb169af,0x0000610ad740d373}, {0x00070df02ba8e15d,0x0005bca7f771f138,0x0002c036c0337edb,0x000e8114acf747b6,0x0000921d57786b94}},
   {{0x00064392c422f7ac,0x00022d348898dbc8,0x0005bfcd1fb63536,0x000e10c3084668c4,0x0000357c9e3eb315}, {0x000b5405b2e5b8ce,0x00010102b9a4b173,0x0000fb1997e94693,0x00062a37c890eb7b,0x0000c225a84b61b6}},
   {{0x000a3c8ee3c76cb3,0x0003a32a1f6ef306,0x00063e9563cf1162,0x000c26b6d5ab6468,0x0000b8a4cbe8c005}, {0x00029a59ce6bb278,0x000184d4b16fdcd5,0x00023798dc4afaa5,0x000fab30624a2679,0x00005e56df6eb307}},
   {{0x000893c2bf296984,0x000497ce76030281,0x0009a558f91fc19a,0x000f7735a5dca3ad,0x00000ceb3fa8d50b}, {0x0006060bc9ba369d,0x0006897888c21baf,0x000a34c07927e103,0x0009800936bf1986,0x00004cf10c2934ae}},
   {{0x0005334859dd614c,0x000a58d0c8ee3a3e,0x000cd51d59c475b5,0x000325a3080d1f07,0x00009c0d0a7788b4}, {0x0008691c234296f5,0x000444887fb61ac9,0x000ea9cf22a0a83a,0x0002f5065114270c,0x0000230a6e8f2480}},
   {{0x000bf0f72e3d5c1e,0x00056f21439ef7a2,0x000e303343771744,0x0002f91edcbf259c,0x00000030a795ce20}, {0x0009ebf1202e9ca6,0x000c15e6e5916f2d,0x000dac4f8e79dde6,0x00004d952072aff1,0x0000c8d087f1b9b4}},
   {{0x000c73dbce913af4,0x000b058a07cbad0f,0x000f00c8a909e587,0x0006abd300da84d4,0x000025cd048f5446}, {0x000b9be90e9d8bf9,0x000aae431b0eb59c,0x0001aecff991616d,0x000c3b43aa117a53,0x00001af92d3e9f4d}},
   {{0x000c292e93fda293,0x0007b97d91bc9b1e,0x000ace1e676bb6c1,0x000ae34509d95faf,0x0000653fe47ee855}, {0x0000b280f680e752,0x000bceb6c26c7318,0x0006d423675eefd1,0x0001d884cdf29fb6,0x0000d70a9978b582}},
   {{0x000e20720445c36d,0x0001898771747a3e,0x0009f73e971d1ac8,0x0000803fc539f794,0x000005cf3d8682e3}, {0x000e20b7b1c7129b,0x000fa69e61f28758,0x000544c2dffadcc1,0x000e53005d3a2f59,0x0000e16f5c24fff5}},
   {{0x00065b8aad581350,0x0009037aa5be73cf,0x0006fd6a0622c211,0x0008cf79373b3f64,0x0000e029db50d397}, {0x000c43794fba0377,0x0006f20797a68bdf,0x00030d38eaefbd68,0x000463cfa5382bbd,0x0000627cfbfc85d7}},
   {{0x0000fef4e4ca4631,0x00072566cc63b233,0x000780900bcef728,0x00027dc161d2cacf,0x000035dc5396b548}, {0x000052e27bf1bc68,0x000f87dfa06c638f,0x0003321da10a224e,0x000c8f6973586d6d,0x0000b0c5738a6152}},
},
{/* digit=50 [{1,2,3,..,}]*([2^250]*G)  */
   {{0x000ba6b23a5d8961,0x00056fe4364e9910,0x00033c6771fe19e3,0x000fd05e1da8c39a,0x00005b4488b39fd9}, {0x00092541a1f22bff,0x000fbb8163e81f43,0x000e5658e920a8a6,0x00039a4fd1b24907,0x00002c4f79da6ec8}},
   {{0x000619c76497ee80,0x0006c717370e8b5c,0x000cf68e15d2b0ac,0x00079298204cb64f,0x0000bdec21162bc6}, {0x000ccefa63b10110,0x0007e0de1ac56973,0x0000e0c8bf9e3fa9,0x000cb45efb693e3d,0x000037248e9d2d4f}},
   {{0x0004e2ab20364e46,0x00088770b20dd369,0x000d77d1c6269971,0x0000a50183291b6e,0x00009aada7fcd618}, {0x000054bf185509bd,0x0005a870107751f9,0x000b96d8dfd7e845,0x0007ee06a2308a7f,0x000053e48d2f8dc8}},
   {{0x0002dc91ec34f9e7,0x0004c38106038080,0x0000cb4f3d8772d3,0x000128cf06d66c53,0x0000be5ed0e3475c}, {0x0003c1931e82b100,0x0007c9ff6b4ccb9e,0x000a1b45ec63d285,0x000bcab92118c692,0x0000aec44147285b}},
   {{0x0001afbe8316c455,0x000cf6700b8b3707,0x000ff8578982be4f,0x000fa73d5d177c64,0x0000ec4058319a82}, {0x000e37bcfa86678a,0x0003ff0312845518,0x000bbb74c24e809f,0x000de5912f39604b,0x0000d4b4f7060c14}},
   {{0x000f4868eb6e843f,0x000abc4ab3aba3d6,0x0003cf2dc6415834,0x000c3d128a81514f,0x00003b496304f3e6}, {0x000ae90987dd2f21,0x000ad10bce559119,0x000149ed6437a6d8,0x000332b31cdd6b9b,0x0000b77791d16871}},
   {{0x000b650e16e05e91,0x000084e746409c34,0x000a3f029965a774,0x00077c93fd22fbce,0x0000eb6a9689f952}, {0x000a63d7bad84f61,0x0001e58f2fee2520,0x000840d48ad91720,0x000cbdda92c1669b,0x00002109c4abcef5}},
   {{0x0009ae71e29a3efb,0x000f9c93302efc18,0x000aae10ecbe906e,0x0009f820107914ce,0x00007a23f35668e1}, {0x00075c2efd2119d3,0x000eccadc9c8e9d8,0x000a1711303198c6,0x00003835591bf64d,0x0000cf0bbf86d443}},
   {{0x0003027aad991c1a,0x0007e49be4b7ab29,0x00072da90598d0bf,0x00083fec94a21ab9,0x0000da4cfde1ecfa}, {0x000b9c0fbcec63aa,0x000163219a3493d4,0x000652a557ca617a,0x0002dff00424eb6a,0x0000f9346ea8b856}},
   {{0x0004d79023814615,0x0005411bc478c3e0,0x0000b3ef2b1643ab,0x0001b6792becfa39,0x00004476778fcd2f}, {0x0000c4d66bf3aafb,0x000a7c21c65a8daa,0x000a13ac32bc1287,0x00090a3e182910b5,0x0000b04730140b07}},
   {{0x0006947d17d4e0b1,0x000eedc3a47b8376,0x0006fd0ffc5772be,0x00095e665a50db1a,0x00007f904ba55b09}, {0x00043832883487ec,0x00030270aaedcee6,0x000cb1fd9f56db7f,0x0004d4a738d94f46,0x00008fa426ad42fd}},
   {{0x0005bb72b7247593,0x000182d4c63aae48,0x0007d6f2c945353e,0x00010952159d07de,0x000089caef37ec5b}, {0x000bb53db65ef147,0x000e6d99de434a8e,0x000f2405f2dc2cb7,0x0008a3116fa3ed83,0x00003429bba31420}},
   {{0x0008febd56daf065,0x000afa837f6908ed,0x000b6e05a8d98277,0x000abd4947c636a9,0x00008c8a77b10d58}, {0x00096a45f121e4ff,0x00062076d3d3f454,0x000fb0c5d16cd67c,0x000b46fcbd1958e3,0x0000be185ed28e1e}},
   {{0x0009760ff79d2ee9,0x000f639e7832b7ef,0x00005b499dd4d06a,0x000d316d025001b9,0x00008fe1c6285b61}, {0x0003980c5f128050,0x00083009cd9aa9f8,0x0004eb16d376e3b7,0x0002dfa322b09f51,0x00008e213122c383}},
   {{0x0008626dc4ad4f4b,0x00019ddbc0b6aea6,0x0002e90655dc5168,0x00088df76697bd60,0x0000eeb3ea63c378}, {0x000a2f2145691136,0x000c435f44841ec4,0x000e44df2e48b820,0x0009fd3fb560949a,0x0000ca13462f2cc0}},
   {{0x000d590b01e6e274,0x000da180b2dcb618,0x000aea4a9047e2cc,0x0003a491b299b504,0x000012c9e1edfa40}, {0x0008a36794075521,0x0006e332b8e388d2,0x00068de1949c5013,0x000b972a1b6fcce6,0x000078851bc85122}},
},
{/* digit=51 [{1,2,3,..,}]*([2^255]*G)  */
   {{0x000d46d95a7b1a29,0x0005ac6341fb197d,0x0004c2ece9c4e7ad,0x000f89b26eca2948,0x0000211e48a6e7f4}, {0x0007f6ec78ef1f42,0x000fe65745861499,0x0003eede82b2c090,0x000017f7286a6e1c,0x00005f92e472f60e}},
   {{0x00070af3aeac968f,0x0008d4b63266b4e3,0x000ac5664e4f7fee,0x000cbec4acd4c2e3,0x00008910bd3beb38}, {0x000e50cc9c0726e3,0x0009a97b40bf1c3a,0x0005a5a1b1530956,0x0004cd40884b7ffd,0x0000890896b1f831}},
   {{0x0007d205ffe7b376,0x000ab747d2da090d,0x0004fc5193b7f3ef,0x00071e42cb525fb5,0x0000e220933566a9}, {0x00060dfb486d440d,0x00056fe13465ddc1,0x000e4c1517fcfec4,0x0002b4b3da7e4e76,0x00006fa48a2a8d30}},
   {{0x0003c9f82e4c6346,0x0003da4464f85ced,0x0001dca258efb831,0x00012b8706381b7a,0x0000cd15a3cba2a4}, {0x000a8fdbfcd8fb51,0x000f5e54cd229347,0x000d8932f31db2ee,0x0001afb4aeb11ef8,0x00001e7c1ed44441}},
   {{0x00065ef12045cf9f,0x000eaccce8bdae40,0x000cf65256fcb2ca,0x0003112fa0ba4ef2,0x0000683125ebb72c}, {0x000a4eae312410e0,0x00076cd8e830a01d,0x000fb3f0767e2867,0x0009a5abd9575298,0x00005f11e11eef64}},
   {{0x00084f5903fa2711,0x0002a9da921e9968,0x000b01e54e6da0fd,0x00014e96f2f2695d,0x0000ee3e9bd78762}, {0x000181ce27a94979,0x0003fe215e04a26e,0x0002cabca36d254e,0x000613b2f32a6c25,0x0000948148810b57}},
   {{0x0001058fa28a7e00,0x00050bf5ec74ea96,0x000229666c726cf2,0x000799e74d55c8db,0x0000bd9abbfa57f5}, {0x000ef074dfc47b3a,0x00026c52f91d7479,0x000a8bde2d9c65fc,0x00027fee0283fe36,0x000032a8b5f1d4b7}},
   {{0x000b43a43228d831,0x00003ad63f99ab41,0x000a5122924ae1c3,0x0002b47e525f1a46,0x00004af860fdd26d}, {0x000ef613f714aa18,0x000d6b78795ed6ba,0x000a9d694f51865a,0x00052753e21fcee6,0x00002ceb1de0a37b}},
   {{0x000d27d483076829,0x0003510566da8605,0x000f2d7ab745aaba,0x000823557cae36bf,0x00001332ba1db127}, {0x0003638f3429f438,0x000f6c462929cb5c,0x00018b7bd43a21c4,0x0000c669bc95352b,0x0000c2addf4678cb}},
   {{0x0005bfd2f9fd51a3,0x0002181b97f74a66,0x00036ce507f2f1fe,0x000ded9ad05d69ad,0x000014fc2a4b44f4}, {0x0003d8cb55fc5c6d,0x0007efb1e23dd559,0x000453ccee3510ce,0x00063129b7be6937,0x00003541b7a39fae}},
   {{0x000cbcad7154cedc,0x00067f52651ab013,0x0005e642e949b285,0x0004a343b41f6e9f,0x00003a3462a46ed9}, {0x0006cd6222b24dc4,0x0009c28c9c26f3c8,0x000dad3b67578fe8,0x00040a6ac7bfa12e,0x0000112c5d7c8479}},
   {{0x0006525eca445df4,0x0001ecdfa4c69929,0x000a6d3bcf1af24f,0x000cc7b5b4eb61eb,0x0000560910cd8972}, {0x0001c32093eaa327,0x00090d3c67bb5475,0x0008711100183134,0x000a7dcbd90ce62d,0x00005fc863ac38ba}},
   {{0x000f8b64ae3a2787,0x0005a37cdf658fe1,0x000be0492160c530,0x000d81b2f029e733,0x00009a68042ea75c}, {0x000094a5b3f3ada8,0x000d965c32501d8c,0x000792e225d723bb,0x000ea988b958ffa5,0x000029fa987311c1}},
   {{0x0008a4176a9f05d0,0x000b9011d488711b,0x00048a65e06ca4e4,0x000894543bc62ba2,0x000017535ffc9290}, {0x00084ce406851d75,0x000f40e960b4840b,0x00028fd34afa3acd,0x00092c5c3394af71,0x00004eb4d5b7ac0f}},
   {{0x000a73e4a14f8366,0x000790946328923e,0x00017a4dfc8cc8c5,0x0009296e3f117fe9,0x0000372f934572ce}, {0x0000249c29ba567e,0x0005ac829cca7500,0x00002ec7acbd437e,0x000d168c63aaabdd,0x00009b2f90d5b42b}},
   {{0x000e87355dbd4b3d,0x00079639bbb1db09,0x0006519621f87992,0x000573e83e47e51c,0x00004ef0fb7943fb}, {0x000b9d8f1bfb12a4,0x00082e5e8b7227d3,0x0007b90146ab877e,0x000b644eebdc9d15,0x0000c2110057aa5c}},
}
};

#endif /* IFMA_ECPRECOMP5_P256_H */
