#!/usr/bin/env python

"""
Import utilities.

Copyright (C) 2017 Paul Boddie <paul@boddie.org.uk>

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 3 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public License along with
this program.  If not, see <http://www.gnu.org/licenses/>.
"""

from os.path import isdir, join, splitext
from os import listdir
from importlib import import_module

def get_extensions(dirname, modname, stores, reserved):

    "Import extensions inside 'dirname'."

    for filename in listdir(dirname):
        pathname = join(dirname, filename)

        # Descend into directories.

        if isdir(pathname):
            get_extensions(pathname, "%s.%s" % (modname, filename),
                           stores, reserved)
            continue

        # Identify modules and import them.

        leafname, ext = splitext(filename)

        if ext == ".py" and leafname not in reserved:
            stores[leafname] = import_module("%s.%s" % (modname, leafname))

# vim: tabstop=4 expandtab shiftwidth=4
