      program     he5_sw_readdimscaleF_64

      implicit    none

      include     'hdfeos5.inc'

      integer     status
      integer     i, j, jj
      integer     he5_swopen
      integer     he5_swattach
      integer     he5_swwrfld
      integer     he5_swwrattr
      integer     he5_swwrgattr
      integer     he5_ehwrglatt
      integer     he5_swwrlattr 
      integer     he5_swdetach
      integer     he5_swclose
      integer     HE5_SWdscaleattrinfo, HE5_SWreaddscaleattr
      integer     HE5_SWgetdimscale, HE5_SWinqdscaleattrs
      integer     ntype
      integer     swfid,swid1
      real*4      datbuf_f(1) 
      integer*8   datbuf_i(3)
      integer*8   nbands
      integer     bands(3)
      integer*8   datbuf_i2(2) 
      integer     count(2)
      integer         attr_int(25)
      real*8          attr_flt(25)
      real*16         attr_dbl(25)
      character       attr_char(25)
      integer         dimsize
      integer         bufsize, nattr 
      integer         data(30)
      integer         FAIL
      parameter       (FAIL=-1)
      character*100   attrlist
      character*100   strbufsize
      character*15    attrname(10)
      integer         numtype

!  /*
!   * Open the HDF swath file, "swath.he5".
!   */

      swfid = HE5_SWopen("swath.he5", HE5F_ACC_RDWR)
 
!  /*
!   * If the swath file cannot be found, HE5_SWopen will return -1 for the file
!   * handle (swfid).  We there check that this is not the case before
!   * proceeding with the other routines.
!   * 
!   * The HE5_SWattach routine returns the handle to the existing swath "Swath1",
!   * SWid.  If the swath is not found, HE5_SWattach returns -1 for the handle.
!   */ 

      if (swfid .ne. FAIL) then
     
         SWid1 = HE5_SWattach(swfid, "Swath1")

!      /* the field Pollution has Time,YDim,XDim dimensions. 
!	 xdim = 120
!	 ydim = 200
!	 Time dim is set to 10
!      */

         if (SWid1 .eq. FAIL) then
            
            write(*,*) 'Error: Cannot attach to swath  Swath1'
            status = HE5_SWclose(swfid)
            stop
         endif

         bufsize = HE5_SWgetdimscale(SWid1, "Spectra", "Bands", 
     1        dimsize, numtype, data)
         if (bufsize .eq. -1) then
	
            write(*,*) 'Error:Cannot get Dimension Scale size of Bands',
     1           ' dimemnsion in field Spectra'
            status = HE5_SWdetach(SWid1)
            status = HE5_SWclose(swfid)
            stop
            
         else
            
            write(*,*) 'bufsize = ',bufsize
            write(*,*) 'dimsize = ',dimsize
            write(*,*) 'numtype = ',numtype
            
            write(*,*) 'Values are:'
            do i = 1,dimsize
               write(*,*) 'DimscaleValue[',i,'] = ',data(i)
            enddo
         endif
         
         nattr = HE5_SWinqdscaleattrs(SWid1, "Bands", attrlist, 
     1        strbufsize)
         if ( nattr .lt. 0 ) then
            
            write(*,*) 'Error: Cannot get Dimension Scale attribute',
     1           ' list for Bands'
            status = HE5_SWdetach(SWid1)
            status = HE5_SWclose(swfid)
            stop
         endif
         write(*,*) ' '
         write(*,*) 'Dimension scale for Bands Attribute:'

         attrname(1) = 'label'
         attrname(2) = 'unit'
         attrname(3) = 'format'
         attrname(4) = 'MissingValue'
         attrname(5) = 'IntValues'
         do j = 1,5
            attr_char = ''
            count(1)= 0
            count(2)= 0

            status = HE5_SWdscaleattrinfo(SWid1,"Bands", attrname(j), 
     1        ntype, count)
                              
            if( ntype .eq. 0) then
               status = HE5_SWreaddscaleattr(SWid1,"Bands", attrname(j), 
     1              attr_int)
            endif

            if( ntype .eq. 10) then
               status = HE5_SWreaddscaleattr(SWid1,"Bands", attrname(j), 
     1              attr_flt)
            endif
            
            if( ntype .eq. 11) then
               status = HE5_SWreaddscaleattr(SWid1,"Bands", attrname(j), 
     1              attr_dbl)
            endif
            
            if( ntype .eq. 57) then
               status = HE5_SWreaddscaleattr(SWid1,"Bands", attrname(j), 
     1              attr_char)
            endif

            write(*,*) ' '
            write(*,*) 'Status returned by HE5_SWreaddscaleattr() :', 
     1           status
            write(*,*) 'Attribute Name: ',attrname(j)
            write(*,*) 'Number of attribute elements: ', count(1),
     1     '   ',count(2)
            write(*,*) 'Data type of attribute: ', ntype
            
            if( ntype .eq. 0) then
               do jj = 1,count(1)
                  write(*,*) 'Attrvalue[',jj,']: ', attr_int(jj)
               enddo
            endif
            
            if( ntype .eq. 10) then
               do jj = 1,count(1)
                  write(*,*) 'Attrvalue[',jj,']: ',attr_flt(jj)
               enddo
            endif

            if( ntype .eq. 11) then
               do jj = 1,count(1)
                  write(*,*) 'Attrvalue[',jj,']: ',attr_dbl(jj)
               enddo
            endif

            if( ntype .eq. 57) then
               write(*,*) 'Attrvalue: ', attr_char
            endif
         enddo
      endif

      status = HE5_SWdetach(SWid1)
      
      status = HE5_SWclose(swfid)
      
      stop
      end

