# yesod-test

Pragmatic integration tests for haskell web applications using WAI and optionally a database (Persistent).

Its main goal is to encourage integration and system testing of web applications by making everything *easy to test*. 

Your tests are like browser sessions that keep track of cookies and the last
visited page. You can perform assertions on the content of HTML responses
using CSS selectors.

You can also easily build requests using forms present in the current page.
This is very useful for testing web applications built in yesod for example,
where your forms may have field names generated by the framework or a randomly
generated CSRF "\_token" field.

Your database is also directly available so you can use runDB to set up
backend pre-conditions, or to assert that your session is having the desired effect.

The testing facilities behind the scenes are HSpec (on top of HUnit).

The code sample below covers the core concepts of yesod-test. Check out the
[yesod-scaffolding for usage in a complete application](https://github.com/yesodweb/yesod-scaffold/tree/postgres/test).

```haskell
spec :: Spec
spec = withApp $ do
    describe "Basic navigation and assertions" $ do
      it "Gets a page that has a form, with auto generated fields and token" $ do
        get ("url/to/page/with/form" :: Text) -- Load a page.
        statusIs 200 -- Assert the status was success.

        bodyContains "Hello Person" -- Assert any part of the document contains some text.
        
        -- Perform CSS queries and assertions.
        htmlCount "form .main" 1 -- It matches 1 element.
        htmlAllContain "h1#mainTitle" "Sign Up Now!" -- All matches have some text.

        -- Performs the POST using the current page to extract field values:
        request $ do
          setMethod "POST"
          setUrl SignupR
          addToken -- Add the CSRF _token field with the currently shown value.

          -- Lookup field by the text on the labels pointing to them.
          byLabel "Email:" "gustavo@cerati.com"
          byLabel "Password:" "secret"
          byLabel "Confirm:" "secret"

      it "Sends another form, this one has a file" $ do
        request $ do
          setMethod "POST"
          setUrl ("url/to/post/file/to" :: Text)
          -- You can easily add files, though you still need to provide the MIME type for them.
          addFile "file_field_name" "path/to/local/file" "image/jpeg"
          
          -- And of course you can add any field if you know its name.
          addPostParam "answer" "42"

        statusIs 302

    describe "Database access" $ do
      it "selects the list" $ do
        -- See the Yesod scaffolding for the runDB implementation
        msgs <- runDB $ selectList ([] :: [Filter Message]) []
        assertEqual "One Message in the DB" 1 (length msgs)
```

