// Code generated by protoc-gen-go.
// source: dnstap.proto
// DO NOT EDIT!

/*
Package dnstap is a generated protocol buffer package.

It is generated from these files:
	dnstap.proto

It has these top-level messages:
	Dnstap
	Message
*/
package dnstap

import proto "github.com/golang/protobuf/proto"
import json "encoding/json"
import math "math"

// Reference proto, json, and math imports to suppress error if they are not otherwise used.
var _ = proto.Marshal
var _ = &json.SyntaxError{}
var _ = math.Inf

// SocketFamily: the network protocol family of a socket. This specifies how
// to interpret "network address" fields.
type SocketFamily int32

const (
	SocketFamily_INET  SocketFamily = 1
	SocketFamily_INET6 SocketFamily = 2
)

var SocketFamily_name = map[int32]string{
	1: "INET",
	2: "INET6",
}
var SocketFamily_value = map[string]int32{
	"INET":  1,
	"INET6": 2,
}

func (x SocketFamily) Enum() *SocketFamily {
	p := new(SocketFamily)
	*p = x
	return p
}
func (x SocketFamily) String() string {
	return proto.EnumName(SocketFamily_name, int32(x))
}
func (x *SocketFamily) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(SocketFamily_value, data, "SocketFamily")
	if err != nil {
		return err
	}
	*x = SocketFamily(value)
	return nil
}

// SocketProtocol: the transport protocol of a socket. This specifies how to
// interpret "transport port" fields.
type SocketProtocol int32

const (
	SocketProtocol_UDP SocketProtocol = 1
	SocketProtocol_TCP SocketProtocol = 2
)

var SocketProtocol_name = map[int32]string{
	1: "UDP",
	2: "TCP",
}
var SocketProtocol_value = map[string]int32{
	"UDP": 1,
	"TCP": 2,
}

func (x SocketProtocol) Enum() *SocketProtocol {
	p := new(SocketProtocol)
	*p = x
	return p
}
func (x SocketProtocol) String() string {
	return proto.EnumName(SocketProtocol_name, int32(x))
}
func (x *SocketProtocol) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(SocketProtocol_value, data, "SocketProtocol")
	if err != nil {
		return err
	}
	*x = SocketProtocol(value)
	return nil
}

// Identifies which field below is filled in.
type Dnstap_Type int32

const (
	Dnstap_MESSAGE Dnstap_Type = 1
)

var Dnstap_Type_name = map[int32]string{
	1: "MESSAGE",
}
var Dnstap_Type_value = map[string]int32{
	"MESSAGE": 1,
}

func (x Dnstap_Type) Enum() *Dnstap_Type {
	p := new(Dnstap_Type)
	*p = x
	return p
}
func (x Dnstap_Type) String() string {
	return proto.EnumName(Dnstap_Type_name, int32(x))
}
func (x *Dnstap_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Dnstap_Type_value, data, "Dnstap_Type")
	if err != nil {
		return err
	}
	*x = Dnstap_Type(value)
	return nil
}

type Message_Type int32

const (
	// AUTH_QUERY is a DNS query message received from a resolver by an
	// authoritative name server, from the perspective of the authorative
	// name server.
	Message_AUTH_QUERY Message_Type = 1
	// AUTH_RESPONSE is a DNS response message sent from an authoritative
	// name server to a resolver, from the perspective of the authoritative
	// name server.
	Message_AUTH_RESPONSE Message_Type = 2
	// RESOLVER_QUERY is a DNS query message sent from a resolver to an
	// authoritative name server, from the perspective of the resolver.
	// Resolvers typically clear the RD (recursion desired) bit when
	// sending queries.
	Message_RESOLVER_QUERY Message_Type = 3
	// RESOLVER_RESPONSE is a DNS response message received from an
	// authoritative name server by a resolver, from the perspective of
	// the resolver.
	Message_RESOLVER_RESPONSE Message_Type = 4
	// CLIENT_QUERY is a DNS query message sent from a client to a DNS
	// server which is expected to perform further recursion, from the
	// perspective of the DNS server. The client may be a stub resolver or
	// forwarder or some other type of software which typically sets the RD
	// (recursion desired) bit when querying the DNS server. The DNS server
	// may be a simple forwarding proxy or it may be a full recursive
	// resolver.
	Message_CLIENT_QUERY Message_Type = 5
	// CLIENT_RESPONSE is a DNS response message sent from a DNS server to
	// a client, from the perspective of the DNS server. The DNS server
	// typically sets the RA (recursion available) bit when responding.
	Message_CLIENT_RESPONSE Message_Type = 6
	// FORWARDER_QUERY is a DNS query message sent from a downstream DNS
	// server to an upstream DNS server which is expected to perform
	// further recursion, from the perspective of the downstream DNS
	// server.
	Message_FORWARDER_QUERY Message_Type = 7
	// FORWARDER_RESPONSE is a DNS response message sent from an upstream
	// DNS server performing recursion to a downstream DNS server, from the
	// perspective of the downstream DNS server.
	Message_FORWARDER_RESPONSE Message_Type = 8
	// STUB_QUERY is a DNS query message sent from a stub resolver to a DNS
	// server, from the perspective of the stub resolver.
	Message_STUB_QUERY Message_Type = 9
	// STUB_RESPONSE is a DNS response message sent from a DNS server to a
	// stub resolver, from the perspective of the stub resolver.
	Message_STUB_RESPONSE Message_Type = 10
	// TOOL_QUERY is a DNS query message sent from a DNS software tool to a
	// DNS server, from the perspective of the tool.
	Message_TOOL_QUERY Message_Type = 11
	// TOOL_RESPONSE is a DNS response message received by a DNS software
	// tool from a DNS server, from the perspective of the tool.
	Message_TOOL_RESPONSE Message_Type = 12
)

var Message_Type_name = map[int32]string{
	1:  "AUTH_QUERY",
	2:  "AUTH_RESPONSE",
	3:  "RESOLVER_QUERY",
	4:  "RESOLVER_RESPONSE",
	5:  "CLIENT_QUERY",
	6:  "CLIENT_RESPONSE",
	7:  "FORWARDER_QUERY",
	8:  "FORWARDER_RESPONSE",
	9:  "STUB_QUERY",
	10: "STUB_RESPONSE",
	11: "TOOL_QUERY",
	12: "TOOL_RESPONSE",
}
var Message_Type_value = map[string]int32{
	"AUTH_QUERY":         1,
	"AUTH_RESPONSE":      2,
	"RESOLVER_QUERY":     3,
	"RESOLVER_RESPONSE":  4,
	"CLIENT_QUERY":       5,
	"CLIENT_RESPONSE":    6,
	"FORWARDER_QUERY":    7,
	"FORWARDER_RESPONSE": 8,
	"STUB_QUERY":         9,
	"STUB_RESPONSE":      10,
	"TOOL_QUERY":         11,
	"TOOL_RESPONSE":      12,
}

func (x Message_Type) Enum() *Message_Type {
	p := new(Message_Type)
	*p = x
	return p
}
func (x Message_Type) String() string {
	return proto.EnumName(Message_Type_name, int32(x))
}
func (x *Message_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Message_Type_value, data, "Message_Type")
	if err != nil {
		return err
	}
	*x = Message_Type(value)
	return nil
}

// "Dnstap": this is the top-level dnstap type, which is a "union" type that
// contains other kinds of dnstap payloads, although currently only one type
// of dnstap payload is defined.
// See: https://developers.google.com/protocol-buffers/docs/techniques#union
type Dnstap struct {
	// DNS server identity.
	// If enabled, this is the identity string of the DNS server which generated
	// this message. Typically this would be the same string as returned by an
	// "NSID" (RFC 5001) query.
	Identity []byte `protobuf:"bytes,1,opt,name=identity" json:"identity,omitempty"`
	// DNS server version.
	// If enabled, this is the version string of the DNS server which generated
	// this message. Typically this would be the same string as returned by a
	// "version.bind" query.
	Version []byte `protobuf:"bytes,2,opt,name=version" json:"version,omitempty"`
	// Extra data for this payload.
	// This field can be used for adding an arbitrary byte-string annotation to
	// the payload. No encoding or interpretation is applied or enforced.
	Extra []byte       `protobuf:"bytes,3,opt,name=extra" json:"extra,omitempty"`
	Type  *Dnstap_Type `protobuf:"varint,15,req,name=type,enum=dnstap.Dnstap_Type" json:"type,omitempty"`
	// One of the following will be filled in.
	Message          *Message `protobuf:"bytes,14,opt,name=message" json:"message,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *Dnstap) Reset()         { *m = Dnstap{} }
func (m *Dnstap) String() string { return proto.CompactTextString(m) }
func (*Dnstap) ProtoMessage()    {}

func (m *Dnstap) GetIdentity() []byte {
	if m != nil {
		return m.Identity
	}
	return nil
}

func (m *Dnstap) GetVersion() []byte {
	if m != nil {
		return m.Version
	}
	return nil
}

func (m *Dnstap) GetExtra() []byte {
	if m != nil {
		return m.Extra
	}
	return nil
}

func (m *Dnstap) GetType() Dnstap_Type {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return Dnstap_MESSAGE
}

func (m *Dnstap) GetMessage() *Message {
	if m != nil {
		return m.Message
	}
	return nil
}

// Message: a wire-format (RFC 1035 section 4) DNS message and associated
// metadata. Applications generating "Message" payloads should follow
// certain requirements based on the MessageType, see below.
type Message struct {
	// One of the Type values described above.
	Type *Message_Type `protobuf:"varint,1,req,name=type,enum=dnstap.Message_Type" json:"type,omitempty"`
	// One of the SocketFamily values described above.
	SocketFamily *SocketFamily `protobuf:"varint,2,opt,name=socket_family,enum=dnstap.SocketFamily" json:"socket_family,omitempty"`
	// One of the SocketProtocol values described above.
	SocketProtocol *SocketProtocol `protobuf:"varint,3,opt,name=socket_protocol,enum=dnstap.SocketProtocol" json:"socket_protocol,omitempty"`
	// The network address of the message initiator.
	// For SocketFamily INET, this field is 4 octets (IPv4 address).
	// For SocketFamily INET6, this field is 16 octets (IPv6 address).
	QueryAddress []byte `protobuf:"bytes,4,opt,name=query_address" json:"query_address,omitempty"`
	// The network address of the message responder.
	// For SocketFamily INET, this field is 4 octets (IPv4 address).
	// For SocketFamily INET6, this field is 16 octets (IPv6 address).
	ResponseAddress []byte `protobuf:"bytes,5,opt,name=response_address" json:"response_address,omitempty"`
	// The transport port of the message initiator.
	// This is a 16-bit UDP or TCP port number, depending on SocketProtocol.
	QueryPort *uint32 `protobuf:"varint,6,opt,name=query_port" json:"query_port,omitempty"`
	// The transport port of the message responder.
	// This is a 16-bit UDP or TCP port number, depending on SocketProtocol.
	ResponsePort *uint32 `protobuf:"varint,7,opt,name=response_port" json:"response_port,omitempty"`
	// The time at which the DNS query message was sent or received, depending
	// on whether this is an AUTH_QUERY, RESOLVER_QUERY, or CLIENT_QUERY.
	// This is the number of seconds since the UNIX epoch.
	QueryTimeSec *uint64 `protobuf:"varint,8,opt,name=query_time_sec" json:"query_time_sec,omitempty"`
	// The time at which the DNS query message was sent or received.
	// This is the seconds fraction, expressed as a count of nanoseconds.
	QueryTimeNsec *uint32 `protobuf:"fixed32,9,opt,name=query_time_nsec" json:"query_time_nsec,omitempty"`
	// The initiator's original wire-format DNS query message, verbatim.
	QueryMessage []byte `protobuf:"bytes,10,opt,name=query_message" json:"query_message,omitempty"`
	// The "zone" or "bailiwick" pertaining to the DNS query message.
	// This is a wire-format DNS domain name.
	QueryZone []byte `protobuf:"bytes,11,opt,name=query_zone" json:"query_zone,omitempty"`
	// The time at which the DNS response message was sent or received,
	// depending on whether this is an AUTH_RESPONSE, RESOLVER_RESPONSE, or
	// CLIENT_RESPONSE.
	// This is the number of seconds since the UNIX epoch.
	ResponseTimeSec *uint64 `protobuf:"varint,12,opt,name=response_time_sec" json:"response_time_sec,omitempty"`
	// The time at which the DNS response message was sent or received.
	// This is the seconds fraction, expressed as a count of nanoseconds.
	ResponseTimeNsec *uint32 `protobuf:"fixed32,13,opt,name=response_time_nsec" json:"response_time_nsec,omitempty"`
	// The responder's original wire-format DNS response message, verbatim.
	ResponseMessage  []byte `protobuf:"bytes,14,opt,name=response_message" json:"response_message,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *Message) Reset()         { *m = Message{} }
func (m *Message) String() string { return proto.CompactTextString(m) }
func (*Message) ProtoMessage()    {}

func (m *Message) GetType() Message_Type {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return Message_AUTH_QUERY
}

func (m *Message) GetSocketFamily() SocketFamily {
	if m != nil && m.SocketFamily != nil {
		return *m.SocketFamily
	}
	return SocketFamily_INET
}

func (m *Message) GetSocketProtocol() SocketProtocol {
	if m != nil && m.SocketProtocol != nil {
		return *m.SocketProtocol
	}
	return SocketProtocol_UDP
}

func (m *Message) GetQueryAddress() []byte {
	if m != nil {
		return m.QueryAddress
	}
	return nil
}

func (m *Message) GetResponseAddress() []byte {
	if m != nil {
		return m.ResponseAddress
	}
	return nil
}

func (m *Message) GetQueryPort() uint32 {
	if m != nil && m.QueryPort != nil {
		return *m.QueryPort
	}
	return 0
}

func (m *Message) GetResponsePort() uint32 {
	if m != nil && m.ResponsePort != nil {
		return *m.ResponsePort
	}
	return 0
}

func (m *Message) GetQueryTimeSec() uint64 {
	if m != nil && m.QueryTimeSec != nil {
		return *m.QueryTimeSec
	}
	return 0
}

func (m *Message) GetQueryTimeNsec() uint32 {
	if m != nil && m.QueryTimeNsec != nil {
		return *m.QueryTimeNsec
	}
	return 0
}

func (m *Message) GetQueryMessage() []byte {
	if m != nil {
		return m.QueryMessage
	}
	return nil
}

func (m *Message) GetQueryZone() []byte {
	if m != nil {
		return m.QueryZone
	}
	return nil
}

func (m *Message) GetResponseTimeSec() uint64 {
	if m != nil && m.ResponseTimeSec != nil {
		return *m.ResponseTimeSec
	}
	return 0
}

func (m *Message) GetResponseTimeNsec() uint32 {
	if m != nil && m.ResponseTimeNsec != nil {
		return *m.ResponseTimeNsec
	}
	return 0
}

func (m *Message) GetResponseMessage() []byte {
	if m != nil {
		return m.ResponseMessage
	}
	return nil
}

func init() {
	proto.RegisterEnum("dnstap.SocketFamily", SocketFamily_name, SocketFamily_value)
	proto.RegisterEnum("dnstap.SocketProtocol", SocketProtocol_name, SocketProtocol_value)
	proto.RegisterEnum("dnstap.Dnstap_Type", Dnstap_Type_name, Dnstap_Type_value)
	proto.RegisterEnum("dnstap.Message_Type", Message_Type_name, Message_Type_value)
}
