// Code generated by smithy-go-codegen DO NOT EDIT.

package supplychain

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/supplychain/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Enables you to programmatically view the list of Amazon Web Services Supply
// Chain data lake datasets. Developers can view the datasets and the corresponding
// information such as namespace, schema, and so on for a given instance ID and
// namespace.
func (c *Client) ListDataLakeDatasets(ctx context.Context, params *ListDataLakeDatasetsInput, optFns ...func(*Options)) (*ListDataLakeDatasetsOutput, error) {
	if params == nil {
		params = &ListDataLakeDatasetsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListDataLakeDatasets", params, optFns, c.addOperationListDataLakeDatasetsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListDataLakeDatasetsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// The request parameters of ListDataLakeDatasets.
type ListDataLakeDatasetsInput struct {

	// The Amazon Web Services Supply Chain instance identifier.
	//
	// This member is required.
	InstanceId *string

	// The namespace of the dataset, besides the custom defined namespace, every
	// instance comes with below pre-defined namespaces:
	//
	//   - asc - For information on the Amazon Web Services Supply Chain supported
	//   datasets see [https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/data-model-asc.html].
	//
	//   - default - For datasets with custom user-defined schemas.
	//
	// [https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/data-model-asc.html]: https://docs.aws.amazon.com/aws-supply-chain/latest/userguide/data-model-asc.html
	//
	// This member is required.
	Namespace *string

	// The max number of datasets to fetch in this paginated request.
	MaxResults *int32

	// The pagination token to fetch next page of datasets.
	NextToken *string

	noSmithyDocumentSerde
}

// The response parameters of ListDataLakeDatasets.
type ListDataLakeDatasetsOutput struct {

	// The list of fetched dataset details.
	//
	// This member is required.
	Datasets []types.DataLakeDataset

	// The pagination token to fetch next page of datasets.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListDataLakeDatasetsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListDataLakeDatasets{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListDataLakeDatasets{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListDataLakeDatasets"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListDataLakeDatasetsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListDataLakeDatasets(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListDataLakeDatasetsPaginatorOptions is the paginator options for
// ListDataLakeDatasets
type ListDataLakeDatasetsPaginatorOptions struct {
	// The max number of datasets to fetch in this paginated request.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListDataLakeDatasetsPaginator is a paginator for ListDataLakeDatasets
type ListDataLakeDatasetsPaginator struct {
	options   ListDataLakeDatasetsPaginatorOptions
	client    ListDataLakeDatasetsAPIClient
	params    *ListDataLakeDatasetsInput
	nextToken *string
	firstPage bool
}

// NewListDataLakeDatasetsPaginator returns a new ListDataLakeDatasetsPaginator
func NewListDataLakeDatasetsPaginator(client ListDataLakeDatasetsAPIClient, params *ListDataLakeDatasetsInput, optFns ...func(*ListDataLakeDatasetsPaginatorOptions)) *ListDataLakeDatasetsPaginator {
	if params == nil {
		params = &ListDataLakeDatasetsInput{}
	}

	options := ListDataLakeDatasetsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListDataLakeDatasetsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListDataLakeDatasetsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListDataLakeDatasets page.
func (p *ListDataLakeDatasetsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListDataLakeDatasetsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListDataLakeDatasets(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListDataLakeDatasetsAPIClient is a client that implements the
// ListDataLakeDatasets operation.
type ListDataLakeDatasetsAPIClient interface {
	ListDataLakeDatasets(context.Context, *ListDataLakeDatasetsInput, ...func(*Options)) (*ListDataLakeDatasetsOutput, error)
}

var _ ListDataLakeDatasetsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListDataLakeDatasets(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListDataLakeDatasets",
	}
}
