// Code generated by smithy-go-codegen DO NOT EDIT.

package codestarconnections

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/codestarconnections/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates the sync configuration for your connection and a specified external Git
// repository.
func (c *Client) UpdateSyncConfiguration(ctx context.Context, params *UpdateSyncConfigurationInput, optFns ...func(*Options)) (*UpdateSyncConfigurationOutput, error) {
	if params == nil {
		params = &UpdateSyncConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateSyncConfiguration", params, optFns, c.addOperationUpdateSyncConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateSyncConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateSyncConfigurationInput struct {

	// The name of the Amazon Web Services resource for the sync configuration to be
	// updated.
	//
	// This member is required.
	ResourceName *string

	// The sync type for the sync configuration to be updated.
	//
	// This member is required.
	SyncType types.SyncConfigurationType

	// The branch for the sync configuration to be updated.
	Branch *string

	// The configuration file for the sync configuration to be updated.
	ConfigFile *string

	// Whether to enable or disable publishing of deployment status to source
	// providers.
	PublishDeploymentStatus types.PublishDeploymentStatus

	// The ID of the repository link for the sync configuration to be updated.
	RepositoryLinkId *string

	// The ARN of the IAM role for the sync configuration to be updated.
	RoleArn *string

	// When to trigger Git sync to begin the stack update.
	TriggerResourceUpdateOn types.TriggerResourceUpdateOn

	noSmithyDocumentSerde
}

type UpdateSyncConfigurationOutput struct {

	// The information returned for the sync configuration to be updated.
	//
	// This member is required.
	SyncConfiguration *types.SyncConfiguration

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateSyncConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpUpdateSyncConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpUpdateSyncConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateSyncConfiguration"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateSyncConfigurationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateSyncConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateSyncConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateSyncConfiguration",
	}
}
