// Code generated by smithy-go-codegen DO NOT EDIT.

package greengrassv2

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Gets the pre-signed URL to download a public or a Lambda component artifact.
// Core devices call this operation to identify the URL that they can use to
// download an artifact to install.
func (c *Client) GetComponentVersionArtifact(ctx context.Context, params *GetComponentVersionArtifactInput, optFns ...func(*Options)) (*GetComponentVersionArtifactOutput, error) {
	if params == nil {
		params = &GetComponentVersionArtifactInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetComponentVersionArtifact", params, optFns, c.addOperationGetComponentVersionArtifactMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetComponentVersionArtifactOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetComponentVersionArtifactInput struct {

	// The ARN
	// (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of
	// the component version. Specify the ARN of a public or a Lambda component
	// version.
	//
	// This member is required.
	Arn *string

	// The name of the artifact. You can use the GetComponent
	// (https://docs.aws.amazon.com/greengrass/v2/APIReference/API_GetComponent.html)
	// operation to download the component recipe, which includes the URI of the
	// artifact. The artifact name is the section of the URI after the scheme. For
	// example, in the artifact URI greengrass:SomeArtifact.zip, the artifact name is
	// SomeArtifact.zip.
	//
	// This member is required.
	ArtifactName *string

	noSmithyDocumentSerde
}

type GetComponentVersionArtifactOutput struct {

	// The URL of the artifact.
	//
	// This member is required.
	PreSignedUrl *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetComponentVersionArtifactMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetComponentVersionArtifact{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetComponentVersionArtifact{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetComponentVersionArtifactValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetComponentVersionArtifact(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetComponentVersionArtifact(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "greengrass",
		OperationName: "GetComponentVersionArtifact",
	}
}
