# Security Policy

Found a security issue in [GoAccess](https://github.com/allinurl/goaccess)?
Read on.

## Reporting a Vulnerability

GoAccess takes all security bugs seriously. Thank you for improving the
security of `goaccess`. I appreciate your efforts and responsible disclosure
and will make every effort to acknowledge your contributions.

Vulnerabilities should be reported to [hello@goaccess.io](mailto:hello@goaccess.io) which is a private,
maintainer-only email address.


When I receive a security bug report, I will work on the fix and prepare a
release including the following steps:

  * Confirm the problem and determine the affected versions.
  * Audit the code to find any potential similar problems.

## Comments on this Policy

If you have suggestions on how this process could be improved please submit a
pull request.

When reporting an issue, where possible, please provide the following (if
possible):

* Commit version where the issue was introduced.
* A proof of concept (plaintext; or ideally send a patch to same email address)
* Steps to reproduce
* Your recommended fixes, if any.

> Note: Please do not open public issues for security issues, as GitHub does
> not provide facility for private issues, and deleting the issue makes it hard
> to triage/respond back to the reporter.
