function function_name(name)
{
    match(name, /[^() ]+/, array);
    return array[0];
}

BEGIN {
    print "/* Autogenerated by opengl_wrapper.awk */";
    print "";
}

/MESA|EXT|ARB|glBegin\(|glEnd\(/ {
    next;
}

/glGetError/ {
    /* Infinite recursion ... */
    next;
}

/^GLAPI void GLAPIENTRY .+\( void \);/ {
    f = function_name($4);
    printf "#define %s() OPENGL_VOID_CALL_VOID(%s)\n", f, f;
    next;
}

/^GLAPI void GLAPIENTRY / {
    f = function_name($4);
    printf "#define %s(...) OPENGL_VOID_CALL(%s, __VA_ARGS__)\n", f, f;
    next;
}

/^GLAPI const [^ ]+ GLAPIENTRY / {
    f = function_name($5);
    printf "#define %s(...) OPENGL_CALL(const %s, %s, __VA_ARGS__)\n", f, $3, f;
    next;
}

/^GLAPI [^ ]+ GLAPIENTRY / {
    f = function_name($4);
    printf "#define %s(...) OPENGL_CALL(%s, %s, __VA_ARGS__)\n", f, $2, f;
    next;
}
