# frozen_string_literal: true

class QueueBackfillVulnerabilityExternalIssueLinksProjectId < Gitlab::Database::Migration[2.2]
  milestone '17.2'
  restrict_gitlab_migration gitlab_schema: :gitlab_main_cell

  MIGRATION = "BackfillVulnerabilityExternalIssueLinksProjectId"
  DELAY_INTERVAL = 2.minutes
  BATCH_SIZE = 1000
  SUB_BATCH_SIZE = 100

  def up
    Gitlab::Database::QueryAnalyzers::Base.suppress_schema_issues_for_decomposed_tables do
      queue_batched_background_migration(
        MIGRATION,
        :vulnerability_external_issue_links,
        :id,
        :project_id,
        :vulnerabilities,
        :project_id,
        :vulnerability_id,
        job_interval: DELAY_INTERVAL,
        batch_size: BATCH_SIZE,
        sub_batch_size: SUB_BATCH_SIZE
      )
    end
  end

  def down
    Gitlab::Database::QueryAnalyzers::Base.suppress_schema_issues_for_decomposed_tables do
      delete_batched_background_migration(
        MIGRATION,
        :vulnerability_external_issue_links,
        :id,
        [
          :project_id,
          :vulnerabilities,
          :project_id,
          :vulnerability_id
        ]
      )
    end
  end
end
