function list = getlistofvariablesinscript(mscript)

% Returns the list of variables in a script.
%
% INPUTS
% - mscript   [char]   1×n array, name of a MATLAB script.
%
% OUTPUTS
% - list      [cell]   cell of row char arrays, list of variables defined in mscript.

% Copyright © 2020-2025 Dynare Team
%
% This file is part of Dynare.
%
% Dynare is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% Dynare is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with Dynare.  If not, see <https://www.gnu.org/licenses/>.

if ~ischar(mscript)
    error('Input argument must be a row char array (name of a MATLAB script')
end

if ~isfile(mscript)
    error('Cannot find %s.', mscript)
end

[~, ~, ext] = fileparts(mscript);

if ~isequal(ext, '.m')
    error('Wrong extension')
end

run(mscript);

list = whos;
list = {list(:).name};
list = setdiff(list, {'filepath', 'filename', 'ext', 'mscript'});
