# -*- coding: iso-8859-1 -*-
# Copyright (C) 2004-2005 Tristan Seligmann and Jonathan Jacobs
# Copyright (C) 2012-2014 Bastian Kleineidam

from re import compile
from ..scraper import make_scraper
from ..util import tagre
from ..helpers import bounceStarter

_imageSearch = (
    compile(tagre("img", "src", r'(http://assets\.amuniversal\.com/[0-9a-fA-F]+)', before='alt="[0-9a-fA-F]+"')),
    compile(tagre("img", "src", r'(http://assets\.amuniversal\.com/[0-9a-fA-F]+)')),
    compile(tagre("meta", "content", r'(http://assets\.amuniversal\.com/[0-9a-fA-F]+)', before="og:image")),
)
_prevSearch = compile(tagre("a", "href", r'(/[^"]+/\d+/\d+/\d+)', after="prev"))
_nextSearch = compile(tagre("a", "href", r'(/[^"]+/\d+/\d+/\d+)', after="next"))

def add(name, shortname):
    baseUrl = 'http://www.gocomics.com'
    url = baseUrl + shortname
    classname = 'GoComics_%s' % name

    @classmethod
    def namer(cls, imageUrl, pageUrl):
        prefix, year, month, day = pageUrl.rsplit('/', 3)
        return "%s_%s%s%s.gif" % (name, year, month, day)

    globals()[classname] = make_scraper(classname,
        url = url,
        starter = bounceStarter(url, _nextSearch),
        name='GoComics/' + name,
        stripUrl=baseUrl + shortname + '/%s',
        imageSearch = _imageSearch,
        prevSearch = _prevSearch,
        help='Index format: yyyy/mm/dd',
        namer=namer,
    )


# do not edit anything below since these entries are generated from scripts/update.sh
# DO NOT REMOVE
add('060', '/0-60')
add('2CowsandaChicken', '/2cowsandachicken')
add('9ChickweedLane', '/9chickweedlane')
add('9to5', '/9to5')
add('ABitSketch', '/a-bit-sketch')
add('ABootsAndPupComic', '/a-boots-and-pup-comic')
add('AdamAtHome', '/adamathome')
add('AdultChildren', '/adult-children')
add('AdventuresofDaisy', '/Adventures-of-Daisy')
add('AdventuresofMartyandTurkey', '/marty-and-turkey')
add('AdventuresofMikeAndSimon', '/adventures-of-mike-and-simon')
add('Agnes', '/agnes')
add('AlisonWard', '/alison-ward')
add('AlleyOop', '/alley-oop')
add('AmaZnEvents', '/amaznevents')
add('Andertoons', '/andertoons')
add('Andnow', '/and-now')
add('AndyCapp', '/andycapp')
add('Anecdote', '/anecdote')
add('AngryLittleGirls', '/angry-little-girls')
add('AnimalCrackers', '/animalcrackers')
add('Annie', '/annie')
add('AnythingGoes', '/anything-goes')
add('AppleCreekComics', '/apple-creek')
add('ArloandJanis', '/arloandjanis')
add('AskShagg', '/askshagg')
add('AuntyAcid', '/aunty-acid')
add('BC', '/bc')
add('BERSERKALERT', '/berserk-alert')
add('BUNS', '/buns')
add('BUSHYTALES', '/bushy-tales')
add('BackintheDay', '/backintheday')
add('BadReporter', '/badreporter')
add('Badlands', '/badlands')
add('Baldo', '/baldo')
add('BallardStreet', '/ballardstreet')
add('BananaTriangle', '/banana-triangle')
add('BarkeaterLake', '/barkeaterlake')
add('BarkingCrayon', '/barking-crayon')
add('BarneyAndClyde', '/barneyandclyde')
add('BasicInstructions', '/basicinstructions')
add('BatchRejection', '/batch-rejection')
add('Bazoobee', '/bazoobee')
add('Beardo', '/beardo')
add('Ben', '/ben')
add('BenAndSeymour', '/ben-seymour')
add('BenSargent', '/bensargent')
add('BeneaththeFerns', '/beneath-the-ferns')
add('BergerAndWyse', '/berger-and-wyse')
add('BestInShow', '/best-in-show')
add('Betty', '/betty')
add('Bewley', '/bewley')
add('BiffAndRiley', '/biff-and-riley')
add('BigNate', '/bignate')
add('BigTop', '/bigtop')
add('BillyAndCo', '/billy-and-co')
add('Biographic', '/biographic')
add('Birdbrains', '/birdbrains')
add('BlackboardDaze', '/blackboard-daze')
add('Bliss', '/bliss')
add('BloomCounty', '/bloomcounty')
add('BlueSkiesToons', '/blue-skies-toons')
add('Bluebonnets', '/cowsandstuff')
add('BoNanas', '/bonanas')
add('BobGorrell', '/bobgorrell')
add('BobtheGroanUP', '/bob-the-groanup')
add('BobtheSquirrel', '/bobthesquirrel')
add('Boogerbrain', '/boogerbrain')
add('Boomerangs', '/boomerangs')
add('BotBrothers', '/bot-brothers')
add('BottAuto', '/bott-auto')
add('Bottomliners', '/bottomliners')
add('BoundandGagged', '/boundandgagged')
add('BreakofDay', '/break-of-day')
add('Brevity', '/brevity')
add('BrewsterRockit', '/brewsterrockit')
add('BrianMcFadden', '/brian-mcfadden')
add('BrilliantMines', '/brilliant-mines')
add('BroomHilda', '/broomhilda')
add('BuffaloChips', '/buffalo-chips')
add('Bully', '/bully')
add('Buni', '/buni')
add('BuzzaWuzza', '/buzza-wuzza')
add('CAFFEINATED', '/CAFFEINATED')
add('CafconLeche', '/cafeconleche')
add('CalAndOzz', '/cal-and-ozz')
add('CalvinandHobbes', '/calvinandhobbes')
add('Candorville', '/candorville')
add('CandyPills', '/candy-pills')
add('Cartertoons', '/cartertoons')
add('Cathy', '/cathy')
add('CestlaVie', '/cestlavie')
add('ChanLowe', '/chanlowe')
add('CharmysArmy', '/charmy-s-army')
add('ChasingUnicorns', '/chasing-unicorns')
add('CheapThrillsCuisine', '/cheap-thrills-cuisine')
add('ChipBok', '/chipbok')
add('ChrisBritt', '/chrisbritt')
add('ChubbyGirlComics', '/chubbygirlcomics')
add('ChuckleBros', '/chucklebros')
add('CitizenDog', '/citizendog')
add('Classifudds', '/classifudds')
add('ClayBennett', '/claybennett')
add('ClayJones', '/clayjones')
add('Cleats', '/cleats')
add('CleoandCompany', '/cleo-and-company')
add('ClosetoHome', '/closetohome')
add('CockroachComix', '/cockroachcomix')
add('CoffeeShopTidbits', '/coffee-shop-tidbits')
add('Committed', '/committed')
add('Computoon', '/compu-toon')
add('ConnietotheWonnie', '/connie-to-the-wonnie')
add('Cornered', '/cornered')
add('Cortoons', '/cortoons')
add('CourageousManAdventures', '/courageous-man-adventures')
add('CowSheepandaGnomeNamedHelga', '/cow-sheep-and-a-gnome-named-helga')
add('CowTown', '/cowtown')
add('CowandBoyClassics', '/cowandboy')
add('Crumb', '/crumb')
add('CuldeSac', '/culdesac')
add('DabneyandDad', '/dabney-and-dad')
add('DaddysHome', '/daddyshome')
add('DanWasserman', '/danwasserman')
add('DanaSummers', '/danasummers')
add('DarkSideoftheHorse', '/darksideofthehorse')
add('DarrinBell', '/darrin-bell')
add('DeepDarkFears', '/deep-dark-fears')
add('DevinCraneComicStripGhostwriter', '/devincranecomicstripghostwriter')
add('DialHforHBomb', '/dial-h-for-h-bomb')
add('DiamondLil', '/diamondlil')
add('DickTracy', '/dicktracy')
add('DilbertClassics', '/dilbert-classics')
add('DitzAbledPrincess', '/ditzabled-princess')
add('DogEatDoug', '/dogeatdoug')
add('DogsofCKennel', '/dogsofckennel')
add('DomesticAbuse', '/domesticabuse')
add('DontPicktheFlowers', '/dont-pick-the-flowers')
add('DoodleDaysComics', '/doodle-days')
add('DoodleTown', '/doodle-town')
add('Doonesbury', '/doonesbury')
add('Drabble', '/drabble')
add('Dragin', '/dragin')
add('DrewSheneman', '/drewsheneman')
add('Dromo', '/dro-mo')
add('DudeandDude', '/dudedude')
add('DumbQuestionBadAnswer', '/dumb-question-bad-answer')
add('DustSpecks', '/dust-specks')
add('EBEJeebie', '/ebe-jeebie')
add('EDITORIALPASTANDPRESENT', '/editorial-past-and-present')
add('Econogirl', '/econogirl')
add('Eek', '/eek')
add('ElephantintheRoom', '/elephant-in-the-room')
add('EleriMaiHarrisCartoons', '/eleri-mai-harris-cartoons')
add('ElfandMotorbelly', '/elf-and-motorbelly')
add('Elmo', '/elmo')
add('EmmyLou', '/emmy-lou')
add('Endtown', '/endtown')
add('EngagAndNevets', '/engag-nevets')
add('ErictheCircle', '/eric-the-circle')
add('EspressoCity', '/Espresso-City')
add('EttoreandBaldo', '/ettore-and-baldo')
add('FMinus', '/fminus')
add('FacesoftheNewsbyKerryWaghorn', '/facesinthenews')
add('FamilyTree', '/familytree')
add('FantasticMegaLeague', '/fantastiteam')
add('FarOut', '/far-out')
add('FarcesofNature', '/farces-of-nature')
add('Farcus', '/farcus')
add('FatCats', '/fat-cats')
add('Featherweight', '/featherweight')
add('FloandFriends', '/floandfriends')
add('FoolishMortals', '/foolish-mortals')
add('ForBetterorForWorse', '/forbetterorforworse')
add('ForHeavensSake', '/forheavenssake')
add('FortKnox', '/fortknox')
add('FourEyes', '/four-eyes')
add('FoxTrot', '/foxtrot')
add('FoxTrotClassics', '/foxtrotclassics')
add('Francis', '/francis')
add('FrankAndErnest', '/frankandernest')
add('FrankAndSteinway', '/frank-and-steinway')
add('FrankBlunt', '/frankblunt')
add('Frazz', '/frazz')
add('FredBasset', '/fredbasset')
add('FreeRange', '/freerange')
add('FreshlySqueezed', '/freshlysqueezed')
add('FriedCritter', '/fried-critter')
add('FrizziToons', '/frizzitoons')
add('FrogApplause', '/frogapplause')
add('FundayMorning', '/funday-morning')
add('GIRTH', '/girth')
add('GarciaCartoonCo', '/garcia-cartoon-co')
add('Garfield', '/garfield')
add('GarfieldMinusGarfield', '/garfieldminusgarfield')
add('GaryMarkstein', '/garymarkstein')
add('GaryVarvel', '/garyvarvel')
add('GasolineAlley', '/gasolinealley')
add('GatorsAndSuch', '/gators-and-such')
add('Geech', '/geech')
add('GenerationMute', '/generation-mute')
add('GentleCreatures', '/gentle-creatures')
add('GetAGrip', '/get-a-grip')
add('GetFuzzy', '/getfuzzy')
add('GetaLife', '/getalife')
add('GilThorp', '/gilthorp')
add('GingerMeggs', '/gingermeggs')
add('GlennMcCoy', '/glennmccoy')
add('GoComicsontheRoad', '/gocomics-on-the-road')
add('Graffiti', '/graffiti')
add('GrandAvenue', '/grand-avenue')
add('GrannyAnny', '/granny-anny')
add('GrayMatters', '/gray-matters')
add('GreenHumour', '/green-humour')
add('GreenPieces', '/green-pieces')
add('GunstonStreet', '/gunston-street')
add('HIP', '/hip')
add('HUBRIS', '/hubris')
add('HaikuEwe', '/haikuewe')
add('HalfFull', '/half-full')
add('HamShears', '/ham-shears')
add('HanginOut', '/hangin-out')
add('HankandDalesOurWorld', '/hank-and-dales-our-world')
add('HanktheSock', '/hank-the-sock')
add('HarambeeHills', '/harambeehills')
add('Hbenson7', '/hbenson7')
add('HeadComics', '/head-comics')
add('Headcheese', '/headcheese')
add('HealthCapsules', '/healthcapsules')
add('HeartoftheCity', '/heartofthecity')
add('Heathcliff', '/heathcliff')
add('HeavenlyNostrils', '/heavenly-nostrils')
add('HenryPayne', '/henrypayne')
add('HerbandJamaal', '/herbandjamaal')
add('Herman', '/herman')
add('HolidayDoodles', '/holiday-doodles')
add('HolySchnark', '/holy-schnark!')
add('HomeandAway', '/homeandaway')
add('HoodootheUnwiseOwl', '/hoodootheunwiseowl')
add('HumanCull', '/human-cull')
add('Humoresque', '/humoresque ')
add('HutchOwen', '/hutch-owen')
add('ImTellingMom', '/telling-mom')
add('ImaDillo', '/i-m-a-dillo')
add('ImagineThis', '/imaginethis')
add('InherittheMirth', '/inherit-the-mirth')
add('InkPen', '/inkpen')
add('InspectorDangersCrimeQuiz', '/inspector-dangers-crime-quiz')
add('IntheBleachers', '/inthebleachers')
add('IntheSticks', '/inthesticks')
add('InvisibleBread', '/invisible-bread')
add('ItsAllAboutYou', '/itsallaboutyou')
add('ItsjustJim', '/its-just-jim')
add('JackOhman', '/jackohman')
add('JackRadioComics', '/jack-radio-comics')
add('JanesWorld', '/janesworld')
add('JeffDanziger', '/jeffdanziger')
add('JeffStahler', '/jeffstahler')
add('JenSorensen', '/jen-sorensen')
add('JerryHolbert', '/jerryholbert')
add('JillpokeBohemia', '/jillpoke-bohemia')
add('JimMorin', '/jimmorin')
add('JimsJournal', '/jimsjournal')
add('JoeHeller', '/joe-heller')
add('JoeVanilla', '/joevanilla')
add('JoelPett', '/joelpett')
add('JohnDeering', '/johndeering')
add('JumpStart', '/jumpstart')
add('JustPosted', '/just-posted')
add('JustSayUncle', '/just-say-uncle')
add('KartoonsByKline', '/kartoons-by-kline')
add('KatetheGreat', '/kate-the-great')
add('KenCatalino', '/kencatalino')
add('KevinKallaugher', '/kevinkallaugher')
add('KidSpot', '/kidspot')
add('KidTown', '/kidtown')
add('KirbysTreehouse', '/kirbys-treehouse')
add('KitNCarlyle', '/kitandcarlyle')
add('KitchenCapers', '/kitchen-capers')
add('Kliban', '/kliban')
add('KlibansCats', '/klibans-cats')
add('KozmooftheCosmos', '/kozmoofthecosmos')
add('LIGHTERSIDE', '/lighter-side')
add('LaCucaracha', '/lacucaracha')
add('LaloAlcaraz', '/laloalcaraz')
add('LardWantsWorldPeace', '/lard-wants-world-peace')
add('LardsWorldPeaceTips', '/lards-world-peace-tips')
add('LarryvilleBlue', '/larryville-blue')
add('LastKiss', '/lastkiss')
add('LeGooseyLu', '/LeGoosey-Lu')
add('Leadbellies', '/leadbellies')
add('LegendofBill', '/legendofbill')
add('LeighLunaComics', '/leigh-luna-comics')
add('LibertyMeadows', '/libertymeadows')
add('LilAbner', '/lil-abner')
add('Lio', '/lio')
add('LisaBenson', '/lisabenson')
add('LittleDogLost', '/littledoglost')
add('LittleFriedChickenandSushi', '/little-fried-chicken-and-sushi')
add('Lola', '/lola')
add('LooseParts', '/looseparts')
add('LostInTranslation', '/lost-in-translation')
add('LostSheep', '/lostsheep')
add('LostSideofSuburbia', '/lostsideofsuburbia')
add('Luann', '/luann')
add('LuannAgainn', '/luann-againn')
add('Lucan', '/lucan')
add('LucasLuminous', '/lucas-luminous')
add('LuckyCow', '/luckycow')
add('LumandAbner', '/lum-and-abner')
add('Mac', '/mac')
add('MagicinaMinute', '/magicinaminute')
add('Maintaining', '/maintaining')
add('MakingIt', '/making-it')
add('MariasDay', '/marias-day')
add('Markonpaper', '/mark-on-paper')
add('Marmaduke', '/marmaduke')
add('MarshallRamsey', '/marshallramsey')
add('MaryBWary', '/mary-b-wary')
add('MassiveFalls', '/massive-falls')
add('MattBors', '/matt-bors')
add('MattDavies', '/mattdavies')
add('MattWuerker', '/mattwuerker')
add('McArroni', '/mcarroni')
add('MediumLarge', '/medium-large')
add('MegClassics', '/meg-classics')
add('MichaelRamirez', '/michaelramirez')
add('Mick', '/mick')
add('MidLifewAlan', '/mid-life-with-alan')
add('MikeLester', '/mike-lester')
add('MikeLuckovich', '/mikeluckovich')
add('MikeduJour', '/mike-du-jour')
add('Millennialville', '/millennialville')
add('Milton50', '/milton-5-0')
add('Mindframe', '/mindframe')
add('MinimumSecurity', '/minimumsecurity')
add('MiscSoup', '/misc-soup')
add('MisterAndMe', '/mister-and-me')
add('MixedMedications', '/mixedmedications')
add('ModeratelyConfused', '/moderately-confused')
add('MollyandtheBear', '/mollyandthebear')
add('Momma', '/momma')
add('Monty', '/monty')
add('Mortimer', '/mortimer')
add('MortsIsland', '/noahs-island')
add('MotleyClassics', '/motley-classics')
add('MrGigiandtheSquid', '/mr-gigi-and-the-squid')
add('MrMorris', '/mr-morris')
add('Mulligan', '/mulligan')
add('MustardandBoloney', '/mustard-and-boloney')
add('MuttAndJeff', '/muttandjeff')
add('MyCage', '/mycage')
add('MyGuardianGrandpa', '/my-guardian-grandpa')
add('MythTickle', '/mythtickle')
add('NEUROTICA', '/neurotica')
add('Nancy', '/nancy')
add('NavyBean', '/navybean')
add('NeatStep', '/neatstep')
add('NedAndLarry', '/ned-and-larry')
add('NeighborhoodZone', '/neightborhood-zone')
add('NestHeads', '/nestheads')
add('NewAdventuresofQueenVictoria', '/thenewadventuresofqueenvictoria')
add('NickAnderson', '/nickanderson')
add('NickandZuzu', '/nick-and-zuzu')
add('NoOrdinaryLife', '/no-ordinary-life')
add('NoPlaceLikeHolmes', '/no-place-like-holmes')
add('NobodysHome', '/nobodys-home')
add('NonSequitur', '/nonsequitur')
add('Norman', '/Norman')
add('NothingisNotSomething', '/nothing-is-not-something')
add('ONIONAndPEA', '/onion-and-pea')
add('Oat', '/oat')
add('ObamaandtheFatman', '/obama-and-the-fatman')
add('OfftheMark', '/offthemark')
add('OhBrother', '/oh-brother')
add('OllieandQuentin', '/ollie-and-quentin')
add('OnAClaireDay', '/onaclaireday')
add('OneBigHappy', '/onebighappy')
add('OntheQuad', '/on-the-quad')
add('OrangesareFunny', '/oranges-are-funny')
add('OrdinaryBill', '/ordinary-bill')
add('OriginsoftheSundayComics', '/origins-of-the-sunday-comics')
add('Outnumbered', '/outnumbered')
add('OutoftheGenePoolReRuns', '/outofthegenepool')
add('Overboard', '/overboard')
add('OvertheHedge', '/overthehedge')
add('OzyandMillie', '/ozy-and-millie')
add('PCandPixel', '/pcandpixel')
add('PaddedCell', '/padded-cell')
add('ParisDoodles', '/mo-willems-paris-doodles')
add('PatOliphant', '/patoliphant')
add('PaulSzep', '/paulszep')
add('Peanizles', '/peanizles')
add('Peanuts', '/peanuts')
add('PearlsBeforeSwine', '/pearlsbeforeswine')
add('Peeples', '/peeples')
add('PetFood', '/pet-food')
add('PhilHands', '/phil-hands')
add('Pi', '/pi')
add('Pibgorn', '/pibgorn')
add('PibgornSketches', '/pibgornsketches')
add('Pickles', '/pickles')
add('PigtimesCartoon', '/pigtimes-cartoon')
add('Pinkerton', '/pinkerton')
add('PipethePelican', '/pipe-the-pelican')
add('PirateMike', '/pirate-mike')
add('PlanB', '/planb')
add('PlasticBabyHeadsfromOuterSpace', '/plastic-babyheads')
add('PlentyofPenguins', '/plenty-of-penguins')
add('Pluggers', '/pluggers')
add('PoliceLimit', '/policelimit')
add('PoochCafe', '/poochcafe')
add('PoorlyDrawnLines', '/poorly-drawn-lines')
add('PopCultureShockTherapy', '/pop-culture-shock-therapy')
add('Poptropica', '/poptropica')
add('PreTeena', '/preteena')
add('PricklyCity', '/pricklycity')
add('Putz', '/putz')
add('QuestionsForKids', '/questions-for-kids')
add('RabbitsAgainstMagic', '/rabbitsagainstmagic')
add('RaisingDuncan', '/raising-duncan')
add('RandolphItch2am', '/randolphitch')
add('RandomActsofNancy', '/random-acts-of-nancy')
add('RealLifeAdventures', '/reallifeadventures')
add('RealityCheck', '/realitycheck')
add('RedMeat', '/redmeat')
add('RedandRover', '/redandrover')
add('ReplyAll', '/replyall')
add('ReplyAllLite', '/reply-all-lite')
add('RicigsToonTrivia', '/ricigs-toon-trivia')
add('RipHaywire', '/riphaywire')
add('RipleysBelieveItorNot', '/ripleysbelieveitornot')
add('RobRogers', '/robrogers')
add('RobbieandBobby', '/robbie-and-bobby')
add('RobertAriail', '/robert-ariail')
add('RogueSymmetry', '/rogue_symmetry')
add('RonWarren', '/ron-warren')
add('RoseisRose', '/roseisrose')
add('Rubes', '/rubes')
add('RudyPark', '/rudypark')
add('SCAIRYTALESTheNotSoScaryFairyTales', '/Scairy-Tales:-the-not-so-scary-fairy-tales!')
add('SNAFU', '/snafu')
add('SPACESLUGS', '/spaceslugs')
add('STEPDAD', '/stepdad')
add('Sabine', '/sabine')
add('SantavsDracula', '/santa-vs-dracula')
add('SarahsScribbles', '/sarahs-scribbles')
add('SavageChickens', '/savage-chickens')
add('ScaryGary', '/scarygary')
add('ScottStantis', '/scottstantis')
add('Scurvyville', '/scurvyville')
add('SecondPrize', '/secondprize')
add('ShirleyandSonClassics', '/shirley-and-son-classics')
add('Shoe', '/shoe')
add('Shoecabbage', '/shoecabbage')
add('Shortcuts', '/shortcuts')
add('ShutterbugFollies', '/shutterbug-follies')
add('SignGarden', '/signgarden')
add('SigneWilkinson', '/signewilkinson')
add('SkinHorse', '/skinhorse')
add('Skippy', '/skippy')
add('Skooled', '/skooled')
add('SleepytownBeagles', '/sleepytown-beagles')
add('SmallNerdyCreatures', '/small-nerdy-creatures')
add('Smith', '/smith')
add('SnowSez', '/snowsez')
add('SoccerEarth', '/soccer-earth')
add('SookyRottweiler', '/sooky-rottweiler')
add('SouptoNutz', '/soup-to-nutz')
add('SpaceNutz', '/space-nutz')
add('SpaceTimeFunnies', '/spacetimefunnies')
add('Speechless', '/speechless')
add('SpeedBump', '/speedbump')
add('SportsbyVoort', '/sports-by-voort')
add('SpottheFrog', '/spot-the-frog')
add('StankoAndTibor', '/stankotibor')
add('Starslip', '/starslip')
add('SteveBenson', '/stevebenson')
add('SteveBreen', '/stevebreen')
add('SteveKelley', '/stevekelley')
add('StoneSoup', '/stonesoup')
add('Stookie', '/Stookie')
add('StrangeBrew', '/strangebrew')
add('StuartCarlson', '/stuartcarlson')
add('SubSub', '/subsub')
add('SuburbanFairyTales', '/suburban-fairy-tales')
add('SuburbanWilderness', '/suburban-wilderness')
add('SuckerHeadSmack', '/suckerhead-smack')
add('SunnyStreet', '/sunny-street')
add('SunshineState', '/sunshine-state')
add('SuperFunPakComix', '/super-fun-pak-comix')
add('SuperSiblings', '/super-siblings')
add('SweetandSourPork', '/sweet-and-sour-pork')
add('Sylvia', '/sylvia')
add('THESILVERLINING', '/silver-lining')
add('TOBY', '/toby')
add('TOWHOMITMAYCONCERN', '/towhomitmayconcern')
add('TankMcNamara', '/tankmcnamara')
add('Tarzan', '/tarzan')
add('TeacherInk', '/teacher-ink')
add('TedRall', '/tedrall')
add('TenCats', '/ten-cats')
add('ThatMonkeyTune', '/that-monkey-tune')
add('ThatNewCarlSmell', '/that-new-carl-smell')
add('Thatababy', '/thatababy')
add('ThatisPriceless', '/that-is-priceless')
add('ThatsLife', '/thats-life')
add('TheAcademiaWaltz', '/academiawaltz')
add('TheAcerbicCaf', '/the-acerbic-cafe')
add('TheAdventuresofTeetyBallerina', '/the-adventures-of-teety-ballerina')
add('TheArgyleSweater', '/theargylesweater')
add('TheBarn', '/thebarn')
add('TheBeauforts', '/the-beauforts')
add('TheBentPinky', '/the-bent-pinky')
add('TheBigPicture', '/thebigpicture')
add('TheBoobiehatch', '/the-boobiehatch')
add('TheBoondocks', '/boondocks')
add('TheBornLoser', '/the-born-loser')
add('TheBuckets', '/thebuckets')
add('TheCardinal', '/thecardinal')
add('TheCity', '/thecity')
add('TheCreeps', '/the-creeps')
add('TheDinetteSet', '/dinetteset')
add('TheDoozies', '/thedoozies')
add('TheDuplex', '/duplex')
add('TheEdperiment', '/the-edperiment')
add('TheElderberries', '/theelderberries')
add('TheFlyingMcCoys', '/theflyingmccoys')
add('TheFruitBowl', '/thefruitbowl')
add('TheFuscoBrothers', '/thefuscobrothers')
add('TheGoldenKid', '/golden-kid')
add('TheGreenMonkeys', '/thegreenmonkeys')
add('TheGrizzwells', '/thegrizzwells')
add('TheHumbleStumble', '/humble-stumble')
add('TheInsolentLemon', '/the-insolent-lemon')
add('TheKChronicles', '/thekchronicles')
add('TheKnightLife', '/theknightlife')
add('TheLeftyBoscoPictureShow', '/leftyboscopictureshow')
add('TheLightedLab', '/the-lighted-lab')
add('TheLilMiesters', '/the-lil-miesters')
add('TheLostBear', '/the-lost-bear')
add('TheMartianConfederacy', '/the-martian-confederacy')
add('TheMeaningofLila', '/meaningoflila')
add('TheMiddletons', '/themiddletons')
add('TheNormClassics', '/thenorm')
add('TheOdderLimits', '/the-odder-limits')
add('TheOldManAndHisDog', '/old-man-and-his-dog')
add('TheOtherCoast', '/theothercoast')
add('TheQuinnAndFinnShow', '/quinn-and-finn')
add('TheQuixoteSyndrome', '/the-quixote-syndrome')
add('TheSingleDadDiaries', '/single-dad-diaries')
add('TheSunshineClub', '/the-sunshine-club')
add('TheVernalPool', '/vernal-pool')
add('TheWanderingMelon', '/the-wandering-melon')
add('TheWorstThingIveEverDone', '/the-worst-thing-ive-ever-done')
add('ThinLines', '/thinlines')
add('Thingsesque', '/thingsesque')
add('Think', '/think')
add('ThrompTM', '/thromp')
add('TimEagan', '/tim-eagan')
add('TinySepuku', '/tinysepuku')
add('ToBeNamed', '/to-be-named')
add('TodaysDogg', '/todays-dogg')
add('TomToles', '/tomtoles')
add('TomtheDancingBug', '/tomthedancingbug')
add('TonyAuth', '/tonyauth')
add('TooMuchCoffeeMan', '/toomuchcoffeeman')
add('Toocrazy', '/too-crazy')
add('Trivquiz', '/trivquiz')
add('TruthFacts', '/truth-facts')
add('Twaggies', '/twaggies')
add('TwoBits', '/two-bits')
add('USAcres', '/us-acres')
add('UncleArtsFunland', '/uncleartsfunland')
add('UnderstandingChaos', '/understanding-chaos')
add('UnstrangePhenomena', '/unstrange-phenomena')
add('Vernscartoons', '/vernscartoons')
add('ViewsAfrica', '/viewsafrica')
add('ViewsAmerica', '/viewsamerica')
add('ViewsAsia', '/viewsasia')
add('ViewsBusiness', '/viewsbusiness')
add('ViewsEurope', '/viewseurope')
add('ViewsLatinAmerica', '/viewslatinamerica')
add('ViewsMidEast', '/viewsmideast')
add('ViewsoftheWorld', '/viewsoftheworld')
add('ViiviAndWagner', '/viivi-and-wagner')
add('WTDuck', '/wtduck')
add('WaltHandelsman', '/walthandelsman')
add('WatchYourHead', '/watchyourhead')
add('WayOutComics', '/way-out-comics')
add('WayOutInLeftField', '/Way-Out-In-Left-Field')
add('WeePals', '/weepals')
add('WendlesLife', '/wendleslife')
add('Whatcatscanandcantdo', '/whatcatscanandcantdo')
add('WhiskeyFalls', '/whiskey-falls')
add('WideOpen', '/wide-open')
add('WinLoseDrew', '/drewlitton')
add('WindingRoads', '/winding-roads')
add('WitoftheWorld', '/witoftheworld')
add('WizardofId', '/wizardofid')
add('WorkingDaze', '/working-daze')
add('WorkingItOut', '/workingitout')
add('Wrobbertcartoons', '/wrobbertcartoons')
add('WuMo', '/wumo')
add('YouCanwithBeakmanandJax', '/beakman')
add('YouGuysAreMyFriendsTheComic', '/you-guys-are-my-friends')
add('ZacharyNixonJohnson', '/zachary-nixon-johnson')
add('ZackHill', '/zackhill')
add('ZenPencils', '/zen-pencils')
add('Ziggy', '/ziggy')
add('Zootopia', '/zootopia')
