/*
  xmms - DBMix output plugin

   Description: 
   ============
   This program is an output plugin for xmms v0.9 or greater.
   The plugin allows a data stream to be generated using xmms,
   an to be sent to the DBMix sound daemon for 
   Fourier/Additive Synthesis.  This allows a user may output multiple
   audio streams concurrently to the same audio device.
  

   Original Output Plugin code: (C) 1998-1999 Mikael Alm, Olle Hallnas,
                                Thomas Nillson and 4Front Technologies

   Modifications by Robert Michael S Dean, (c) 1999-2000

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public Licensse as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef DBMIXOUT_H
#define DBMIXOUT_H

#include <gtk/gtk.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>

#include <fcntl.h>
#include <unistd.h>
#include <pthread.h>

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "xmms/plugin.h"
/* #include "libxmms/util.h" */

#include <dbchannel.h>

extern OutputPlugin op;

typedef struct
{
    gchar channel_name[DB_CHANNEL_NAME_SIZE];
	gint buffer_size;
	gint prebuffer;
	gint close_flag;
	gint buffer_enable;
}
DBMixConfig;

#define DBMIX_MESSAGES (DBMSG_ALL)

extern DBMixConfig dbmix_cfg;

void dbmix_message_handler(dbfsd_msg msg);
void * dbmix_message_handler_loop(void * arg);

int dbmix_message_handler_callback(gpointer data);

void dbmix_init(void);
void dbmix_about(void);
void dbmix_configure(void);

void dbmix_get_volume(int *l, int *r);
void dbmix_set_volume(int l, int r);

int  dbmix_playing(void);
int  dbmix_free(void);
void dbmix_write(void *ptr, int length);
void dbmix_close(void);
void dbmix_flush(int time);
void dbmix_pause(short p);
int  dbmix_open(AFormat fmt, int rate, int nch);
int  dbmix_get_output_time(void);
int  dbmix_get_written_time(void);
void dbmix_set_audio_params(void);

#endif
