/*
 * This file is part of the GIRAFFE Pipeline
 * Copyright (C) 2002-2019 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef GIALIAS_H
#define GIALIAS_H

#include <cpl_macros.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Primary FITS keywords
 */

/* File structure */

#define GIALIAS_BITPIX  "BITPIX"
#define GIALIAS_BZERO   "BZERO"
#define GIALIAS_BSCALE  "BSCALE"
#define GIALIAS_BUNIT   "BUNIT"
#define GIALIAS_NAXIS1  "NAXIS1"
#define GIALIAS_NAXIS2  "NAXIS2"
#define GIALIAS_NAXIS3  "NAXIS3"
#define GIALIAS_EXTNAME "EXTNAME"

/* WCS keywords */

#define GIALIAS_CRPIX1 "CRPIX1"
#define GIALIAS_CRVAL1 "CRVAL1"
#define GIALIAS_CDELT1 "CDELT1"
#define GIALIAS_CTYPE1 "CTYPE1"
#define GIALIAS_CUNIT1 "CUNIT1"
#define GIALIAS_CRDER1 "CRDER1"
#define GIALIAS_CSYER1 "CSYER1"
#define GIALIAS_CRPIX2 "CRPIX2"
#define GIALIAS_CRVAL2 "CRVAL2"
#define GIALIAS_CDELT2 "CDELT2"
#define GIALIAS_CTYPE2 "CTYPE2"
#define GIALIAS_CUNIT2 "CUNIT2"
#define GIALIAS_CRPIX3 "CRPIX3"
#define GIALIAS_CRVAL3 "CRVAL3"
#define GIALIAS_CDELT3 "CDELT3"
#define GIALIAS_CTYPE3 "CTYPE3"
#define GIALIAS_CUNIT3 "CUNIT3"

/* Miscellaneous */

#define GIALIAS_INSTRUMENT "INSTRUME"
#define GIALIAS_EXPTIME    "EXPTIME"
#define GIALIAS_DATAMIN    "DATAMIN"
#define GIALIAS_DATAMAX    "DATAMAX"
#define GIALIAS_CREATOR    "CREATOR"
#define GIALIAS_ORIGIN     "ORIGIN"
#define GIALIAS_DATE       "DATE"
#define GIALIAS_DATEOBS    "DATE-OBS"
#define GIALIAS_MJDOBS     "MJD-OBS"
#define GIALIAS_EQUINOX    "EQUINOX"
#define GIALIAS_DATAMD5    "DATAMD5"
#define GIALIAS_CHECKSUM   "CHECKSUM"
#define GIALIAS_DATASUM    "DATASUM"
#define GIALIAS_ARCFILE    "ARCFILE"
#define GIALIAS_ORIGFILE   "ORIGFILE"
#define GIALIAS_PIPEFILE   "PIPEFILE"
#define GIALIAS_RADEG      "RA"
#define GIALIAS_DECDEG     "DEC"
#define GIALIAS_LST        "LST"

/*
 * Hierarchical keywords
 */

/* OBS */

#define GIALIAS_TARGET  "ESO OBS TARG NAME"
#define GIALIAS_PROGID  "ESO OBS PROG ID"
#define GIALIAS_OBSID   "ESO OBS ID"

/* TPL */

#define GIALIAS_TPLID    "ESO TPL ID"
#define GIALIAS_TPLEXPNO "ESO TPL EXPNO"

/* DPR */

#define GIALIAS_DPRCATG "ESO DPR CATG"
#define GIALIAS_DPRTYPE "ESO DPR TYPE"
#define GIALIAS_DPRTECH "ESO DPR TECH"

/* TEL */

#define GIALIAS_TEL_LON        "ESO TEL GEOLON"
#define GIALIAS_TEL_LAT        "ESO TEL GEOLAT"
#define GIALIAS_TEL_ELEV       "ESO TEL GEOELEV"
#define GIALIAS_AIRMASS_START  "ESO TEL AIRM START"
#define GIALIAS_AIRMASS_END    "ESO TEL AIRM END"

/* ADA */

#define GIALIAS_POSANG  "ESO ADA POSANG"

/* INS */

#define GIALIAS_INSMODE    "ESO INS MODE"
#define GIALIAS_SETUPNAME  "ESO INS EXP MODE"
#define GIALIAS_FILTNAME   "ESO INS FILT NAME"
#define GIALIAS_SLITNAME   "ESO INS SLIT NAME"
#define GIALIAS_GRATNAME   "ESO INS GRAT NAME"
#define GIALIAS_GRATWLEN   "ESO INS GRAT WLEN"
#define GIALIAS_GRATORDER  "ESO INS GRAT ORDER"
#define GIALIAS_GRATGRV    "ESO INS GRAT GROOVES"
#define GIALIAS_GRATPOS    "ESO INS GRAT ENC"
#define GIALIAS_SLITS_NAME "ESO INS SLITS NAME"
#define GIALIAS_SLITS_ID   "ESO INS SLITS ID"
#define GIALIAS_STSCFF     "ESO INS LAMP4 ST"
#define GIALIAS_STSCTAL    "ESO INS LAMP5 ST"

/* INS1 */

#define GIALIAS_ARGUS_SCALE  "ESO INS1 OPTI1 POS"

/* DET */

#define GIALIAS_CHIPX   "ESO DET CHIP1 NX"
#define GIALIAS_CHIPY   "ESO DET CHIP1 NY"
#define GIALIAS_PIXSIZX "ESO DET CHIP1 PSZX"
#define GIALIAS_PIXSIZY "ESO DET CHIP1 PSZY"
#define GIALIAS_OVSCX   "ESO DET OUT1 OVSCX"
#define GIALIAS_OVSCY   "ESO DET OUT1 OVSCY"
#define GIALIAS_PRSCX   "ESO DET OUT1 PRSCX"
#define GIALIAS_PRSCY   "ESO DET OUT1 PRSCY"
#define GIALIAS_CONAD   "ESO DET OUT1 CONAD"
#define GIALIAS_GAIN    "ESO DET OUT1 GAIN"
#define GIALIAS_RON     "ESO DET OUT1 RON"
#define GIALIAS_OUTX    "ESO DET OUT1 NX"
#define GIALIAS_WINX    "ESO DET WIN1 NX"
#define GIALIAS_WINY    "ESO DET WIN1 NY"
#define GIALIAS_BINX    "ESO DET WIN1 BINX"
#define GIALIAS_BINY    "ESO DET WIN1 BINY"

/* For backwards compatibility */

#define GIALIAS_CONAD_LEGACY "ESO DET OUT CONAD"

/* PRO */

#define GIALIAS_PRODID     "ESO PRO DID"
#define GIALIAS_PROCATG    "ESO PRO CATG"
#define GIALIAS_PROTYPE    "ESO PRO TYPE"
#define GIALIAS_PROTECH    "ESO PRO TECH"
#define GIALIAS_PROSCIENCE "ESO PRO SCIENCE"
#define GIALIAS_EXPTTOT    "ESO PRO EXPTTOT"
#define GIALIAS_DATANCOM   "ESO PRO DATANCOM"
#define GIALIAS_DATASIG    "ESO PRO DATARMS"
#define GIALIAS_DATAMEAN   "ESO PRO DATAAVG"
#define GIALIAS_DATAMEDI   "ESO PRO DATAMED"
#define GIALIAS_PROPIPEID  "ESO PRO REC1 PIPE ID"
#define GIALIAS_ANCESTOR   "ESO PRO ANCESTOR"

/* QC */

#define GIALIAS_QCRON      "ESO QC OUT1 RON RAW"
#define GIALIAS_QCMRON     "ESO QC OUT1 RON MASTER"
#define GIALIAS_QCSTRUCTX  "ESO QC OUT1 STRUCT X"
#define GIALIAS_QCSTRUCTY  "ESO QC OUT1 STRUCT Y"
#define GIALIAS_QCMBIASAVG "ESO QC BIAS MASTER MEAN"
#define GIALIAS_QCMBIASRMS "ESO QC BIAS MASTER RMS"
#define GIALIAS_QCMBIASMED "ESO QC BIAS MASTER MEDIAN"

#define GIALIAS_QCMDARKAVG "ESO QC DARK CURRENT"

#define GIALIAS_QCGLOWFLX "ESO QC GLOW LEVEL"
#define GIALIAS_QCGLOWX   "ESO QC GLOW POSX"
#define GIALIAS_QCGLOWY   "ESO QC GLOW POSY"

#define GIALIAS_QCLAMP         "ESO QC LAMP EFFIC"
#define GIALIAS_QCLAMP_SIMCAL  "ESO QC LAMP EFFIC1"

#define GIALIAS_QCMEAN     "ESO QC OUT1 MEAN RAW"
#define GIALIAS_QCNSAT     "ESO QC OUT1 NSAT RAW"

#define GIALIAS_QCLCRMS    "ESO QC FIBRE CENTROID RMS "
#define GIALIAS_QCLCDIFF   "ESO QC FIBRE CENTROID DIFF "
#define GIALIAS_QCLWAVG    "ESO QC FIBRE WIDTH MEAN"
#define GIALIAS_QCLWRMS    "ESO QC FIBRE WIDTH RMS"
#define GIALIAS_QCTRMED    "ESO QC FIBRE TRANS MEDIAN"
#define GIALIAS_QCTRRMS    "ESO QC FIBRE TRANS RMS"
#define GIALIAS_QCTRERR    "ESO QC FIBRE TRANS ERROR"
#define GIALIAS_QCTRNF     "ESO QC FIBRE TRANS NFIBRES"

#define GIALIAS_QCRESOLAVG "ESO QC RESOL MEAN"
#define GIALIAS_QCRESOLRMS "ESO QC RESOL RMS"
#define GIALIAS_QCRESOLTOT "ESO QC RESOL NTOTAL"
#define GIALIAS_QCRESOLLIN "ESO QC RESOL NLINES"
#define GIALIAS_QCRESOLPWR "ESO QC RESOL POWER"

#define GIALIAS_QCRBRMS    "ESO QC WSOL REBIN RMS"

#define GIALIAS_QCEFFICIENCY  "ESO QC EFFICIENCY MEAN"
#define GIALIAS_QCSKYLEVEL    "ESO QC SKY MEAN"


/*
 * GIRAFFE specific keywords
 */

#define GIALIAS_GIRFTYPE "ESO PRO GIRFRAME TYPE"
#define GIALIAS_NFIBERS  "ESO PRO SLIT NFIBRES"


/*
 * Bias removal
 */

#define GIALIAS_BIASVALUE  "ESO PRO BIAS VALUE"
#define GIALIAS_BIASERROR  "ESO PRO BIAS ERROR"
#define GIALIAS_BIASSIGMA  "ESO PRO BIAS SIGMA"
#define GIALIAS_BIASSURF   "ESO PRO BIAS SURFACE"
#define GIALIAS_BIASPLANE  "ESO PRO BIAS PLANE"
#define GIALIAS_BIASAREAS  "ESO PRO BIAS AREAS"
#define GIALIAS_BIASMETHOD "ESO PRO BIAS METHOD"

#define GIALIAS_BCLIPSIGMA "ESO PRO BIAS CLIPSIGMA"
#define GIALIAS_BCLIPNITER "ESO PRO BIAS CLIPNITER"
#define GIALIAS_BCLIPMFRAC "ESO PRO BIAS CLIPMFRAC"


/*
 * Bad pixel map
 */

#define GIALIAS_BPM_NPIX        "ESO PRO BPM NPIX"
#define GIALIAS_BPM_FRACTION    "ESO PRO BPM MAXFRAC"
#define GIALIAS_BPM_MEDIAN_MIN  "ESO PRO BPM MEDIAN MIN"
#define GIALIAS_BPM_MEDIAN_MAX  "ESO PRO BPM MEDIAN MAX"
#define GIALIAS_BPM_ROW_MIN     "ESO PRO BPM ROW MIN"
#define GIALIAS_BPM_ROW_MAX     "ESO PRO BPM ROW MAX"
#define GIALIAS_BPM_FACTOR      "ESO PRO BPM SIGMA"
#define GIALIAS_BPM_NOISE       "ESO PRO BPM NOISE"


/*
 * Dark correction
 */

#define GIALIAS_DARKVALUE  "ESO PRO DARK VALUE"
#define GIALIAS_DARKMODE   "ESO PRO DARK MODE"
#define GIALIAS_DARKMAX    "ESO PRO DARK MAXVAL"
#define GIALIAS_DARKEXPECT "ESO PRO DARK EXPECTED"
#define GIALIAS_DARKTHRESH "ESO PRO DARK THRESHOLD"
#define GIALIAS_DARKMETHOD "ESO PRO DARK METHOD"

/*
 * Spectrum localization
 */

#define GIALIAS_LFULLLOC    "ESO PRO LOC FULL"
#define GIALIAS_LOCYDEG     "ESO PRO LOC YFITDEG"
#define GIALIAS_LOCWDEG     "ESO PRO LOC WFITDEG"
#define GIALIAS_LNOISEMULT  "ESO PRO LOC NOISEMULT"
#define GIALIAS_LEXTRAWID   "ESO PRO LOC EXTRAWID"
#define GIALIAS_LMETHOD     "ESO PRO LOC METHOD"
#define GIALIAS_LNORMALIZE  "ESO PRO LOC NORMALIZATION"

#define GIALIAS_LCLIPSIGMA  "ESO PRO LOC CLIPSIGMA"
#define GIALIAS_LCLIPNITER  "ESO PRO LOC CLIPNITER"
#define GIALIAS_LCLIPMFRAC  "ESO PRO LOC CLIPMFRAC"

#define GIALIAS_LOCNX       "ESO PRO LOC NX"
#define GIALIAS_LOCNS       "ESO PRO LOC NS"
#define GIALIAS_LOCWIDCOEF  "ESO PRO LOC WID COEFF"

/*
 * PSF fitting
 */

#define GIALIAS_PSFMODEL    "ESO PRO PSF MODEL"
#define GIALIAS_PSFXBINS    "ESO PRO PSF XBINS"
#define GIALIAS_PSFYDEG     "ESO PRO PSF YDEG"
#define GIALIAS_PSFWDEG     "ESO PRO PSF WDEG"
#define GIALIAS_PSFPRMS     "ESO PRO PSF PARAMS"
#define GIALIAS_PSFWCOEF    "ESO PRO PSF COEFFi"
#define GIALIAS_PSFNORM     "ESO PRO PSF NORMALIZATION"

#define GIALIAS_PSFNX       "ESO PRO PSF NX"
#define GIALIAS_PSFNY       "ESO PRO PSF NY"
#define GIALIAS_PSFNS       "ESO PRO PSF NS"

#define GIALIAS_PSFSIGMA    "ESO PRO PSF SIGMA"
#define GIALIAS_PSFNITER    "ESO PRO PSF NITER"
#define GIALIAS_PSFMFRAC    "ESO PRO PSF MFRAC"

/*
 * Spectrum extraction
 */

#define GIALIAS_EXT_METHOD      "ESO PRO EXTR METHOD"

#define GIALIAS_EXT_NX          "ESO PRO EXTR NX"
#define GIALIAS_EXT_NS          "ESO PRO EXTR NS"

#define GIALIAS_EXTPSF_MODEL    "ESO PRO EXTR PSFMODEL"
#define GIALIAS_EXTPSF_SIGMA    "ESO PRO EXTR PSFSIGMA"
#define GIALIAS_EXTPSF_NITER    "ESO PRO EXTR PSFNITER"

#define GIALIAS_EXTHRN_EWIDTH   "ESO PRO EXTR EWIDTH"
#define GIALIAS_EXTHRN_MINGOOD  "ESO PRO EXTR NPXLMIN"

#define GIALIAS_EXTOPT_WFACTOR  "ESO PRO EXTR WFACTOR"
#define GIALIAS_EXTOPT_BGORDER  "ESO PRO EXTR BKGORDER"
#define GIALIAS_EXTOPT_FRACTION "ESO PRO EXTR FRACTION"


/*
 * Flat field
 */

#define GIALIAS_FLAT_SCALE  "ESO PRO FLAT SCALE"


/*
 * Wavelength Calibration
 */

#define GIALIAS_WSOL_GRTHETA  "ESO PRO WSOL GRAT THETA"
#define GIALIAS_WSOL_GRORDER  "ESO PRO WSOL GRAT ORDER"
#define GIALIAS_WSOL_GRSPACE  "ESO PRO WSOL GRAT SPACE"

#define GIALIAS_WSOL_LMNAME    "ESO PRO WSOL LINE MODEL"
#define GIALIAS_WSOL_LMWIDTH   "ESO PRO WSOL LINE WIDTH"
#define GIALIAS_WSOL_LMRES     "ESO PRO WSOL LINE XRES"
#define GIALIAS_WSOL_LMTHRESH  "ESO PRO WSOL LINE THRESHOLD"
#define GIALIAS_WSOL_LMITER    "ESO PRO WSOL LINE NITER"
#define GIALIAS_WSOL_LMTEST    "ESO PRO WSOL LINE NTEST"
#define GIALIAS_WSOL_LMDCHISQ  "ESO PRO WSOL LINE DCHISQ"

#define GIALIAS_WSOL_PWORDER  "ESO PRO WSOL PSFW POLYDEG"
#define GIALIAS_WSOL_PWSIGMA  "ESO PRO WSOL PSFW CLIPSIGMA"
#define GIALIAS_WSOL_PWITER   "ESO PRO WSOL PSFW CLIPNITER"
#define GIALIAS_WSOL_PWFRAC   "ESO PRO WSOL PSFW CLIPMFRAC"
#define GIALIAS_WSOL_PWBIN    "ESO PRO WSOL PSFW BINNING"

#define GIALIAS_WSOL_OMFIT     "ESO PRO WSOL OPTICAL SOLUTION"
#define GIALIAS_WSOL_OMNAME    "ESO PRO WSOL OPTICAL MODEL"
#define GIALIAS_WSOL_OMDIR     "ESO PRO WSOL OPTMOD DIRECTION"
#define GIALIAS_WSOL_OMFCOLL   "ESO PRO WSOL OPTMOD FCOLL"
#define GIALIAS_WSOL_OMGCAM    "ESO PRO WSOL OPTMOD GCAM"
#define GIALIAS_WSOL_OMGTHETA  "ESO PRO WSOL OPTMOD THETA"
#define GIALIAS_WSOL_OMSDX     "ESO PRO WSOL OPTMOD SLITDX"
#define GIALIAS_WSOL_OMSDY     "ESO PRO WSOL OPTMOD SLITDY"
#define GIALIAS_WSOL_OMSPHI    "ESO PRO WSOL OPTMOD SLITPHI"

#define GIALIAS_WSOL_SUBSLITS  "ESO PRO WSOL SUBSLIT FIT"
#define GIALIAS_WSOL_XRSSN     "ESO PRO WSOL SUBSLIT NUMBER"
#define GIALIAS_WSOL_XRORDER   "ESO PRO WSOL XRES POLYDEG"
#define GIALIAS_WSOL_XRSIGMA   "ESO PRO WSOL XRES CLIPSIGMA"
#define GIALIAS_WSOL_XRITER    "ESO PRO WSOL XRES CLIPNITER"
#define GIALIAS_WSOL_XRFRAC    "ESO PRO WSOL XRES CLIPMFRAC"
#define GIALIAS_WSOL_XRBIN     "ESO PRO WSOL XRES BINNING"

#define GIALIAS_WSOL_RMS       "ESO PRO WSOL RMS"
#define GIALIAS_WSOL_WLMIN     "ESO PRO WSOL WLEN MIN"
#define GIALIAS_WSOL_WLMAX     "ESO PRO WSOL WLEN MAX"
#define GIALIAS_WSOL_SCALE     "ESO PRO WSOL WLEN SCALE"
#define GIALIAS_WSOL_NLINES    "ESO PRO WSOL LINE NLINES"
#define GIALIAS_WSOL_NACCEPT   "ESO PRO WSOL LINE NACCEPT"
#define GIALIAS_WSOL_NREJECT   "ESO PRO WSOL LINE NREJECT"

/*
 * Slit geometry
 */

#define GIALIAS_SCAL_CUTOFF     "ESO PRO SGEO ZMAX"

/*
 * Scattered light model
 */

#define GIALIAS_SLMNAME    "ESO PRO SLIGHT MODEL"
#define GIALIAS_SLMORDER   "ESO PRO SLIGHT ORDER"
#define GIALIAS_SLMEWIDTH  "ESO PRO SLIGHT EWIDTH"
#define GIALIAS_SLMIWIDTH  "ESO PRO SLIGHT IWIDTH"
#define GIALIAS_SLMSTEPS   "ESO PRO SLIGHT STEPS"
#define GIALIAS_SLMTRIM    "ESO PRO SLIGHT TRIM"

/*
 *  Rebinning
 */

#define GIALIAS_BINWNX    "ESO PRO REBIN NX"
#define GIALIAS_BINWNS    "ESO PRO REBIN NS"
#define GIALIAS_BINWL0    "ESO PRO REBIN WLEN0"
#define GIALIAS_BINWLMIN  "ESO PRO REBIN WLEN MIN"
#define GIALIAS_BINWLMAX  "ESO PRO REBIN WLEN MAX"
#define GIALIAS_BINSTEP   "ESO PRO REBIN LAMBDA STEP"
#define GIALIAS_BINRANGE  "ESO PRO REBIN WRANGE"
#define GIALIAS_BINMETHOD "ESO PRO REBIN METHOD"
#define GIALIAS_BINSCALE  "ESO PRO REBIN SCALE"


/*
 * FOV reconstruction
 */

#define GIALIAS_FOV_BANDMIN "ESO PRO FOV WLEN MIN"
#define GIALIAS_FOV_BANDMAX "ESO PRO FOV WLEN MAX"


/*
 * Instrument response and efficiency
 */

#define GIALIAS_SKY_LEVEL   "ESO PRO SKY MEAN"

/*
 * Science Data Product keywords and default values.
 */

#define GIALIAS_PROCATG_COMMENT         "Pipeline product category"
#define GIALIAS_PROCATG_RBNSPEC_IDP     "SCIENCE_RBNSPEC_IDP"
#define GIALIAS_FIBER_SETUP             "FIBER_SETUP"
#define GIALIAS_ORIGIN_VALUE            "ESO"
#define GIALIAS_PRODLVL_VALUE           2
#define GIALIAS_SPECSYS_VALUE           "HELIOCEN"
#define GIALIAS_EXT_OBJ_VALUE           CPL_FALSE
#define GIALIAS_PRODCATG_VALUE          "SCIENCE.SPECTRUM"
#define GIALIAS_TIMESYS                 "TIMESYS"
#define GIALIAS_M_EPOCH_VALUE           CPL_FALSE
#define GIALIAS_FLUXCAL_VALUE           "UNCALIBRATED"
#define GIALIAS_CONTNORM_VALUE          CPL_FALSE
#define GIALIAS_TOTFLUX_VALUE           CPL_FALSE
#define GIALIAS_FLUXERR_VALUE           -1
#define GIALIAS_LAMNLIN                 "LAMNLIN"
#define GIALIAS_LAMRMS                  "LAMRMS"
#define GIALIAS_SPEC_ERR                "SPEC_ERR"
#define GIALIAS_SPEC_SYE                "SPEC_SYE"
#define GIALIAS_ASSOC_VALUE             "ANCILLARY.MOSSKY"
#define GIALIAS_ASSO_PROCATG_VALUE      GIALIAS_ASSOC_VALUE
#define GIALIAS_VOCLASS_VALUE           "SPECTRUM v2.0"
#define GIALIAS_VOPUB_VALUE             "ESO/SAF"
#define GIALIAS_APERTURE                "APERTURE"
#define GIALIAS_APERTURE_VALUE          0.000334
#define GIALIAS_APERTURE_COMMENT        "[deg] Angular fibre diameter"
#define GIALIAS_FPS                     "FPS"
#define GIALIAS_FPS_COMMENT             "Original FPS index"
#define GIALIAS_GEOCORR                 "GEOCORR"
#define GIALIAS_GEOCORR_COMMENT         "geocentric RV correction"
#define GIALIAS_HELICORR                "HELICORR"
#define GIALIAS_HELICORR_COMMENT        "heliocentric RV correction"
#define GIALIAS_BARYCORR                "BARYCORR"
#define GIALIAS_BARYCORR_COMMENT        "barycentric RV correction"
#define GIALIAS_REFERENC                ""
#define GIALIAS_COLUMN_INDEX            "INDEX"
#define GIALIAS_COLUMN_RP               "RP"
#define GIALIAS_COLUMN_OBJECT           "OBJECT"
#define GIALIAS_COLUMN_TYPE             "TYPE"
#define GIALIAS_COLUMN_RA               "RA"
#define GIALIAS_COLUMN_DEC              "DEC"
#define GIALIAS_COLUMN_GCORR            "GCORR"
#define GIALIAS_COLUMN_HCORR            "HCORR"
#define GIALIAS_COLUMN_BCORR            "BCORR"
#define GIALIAS_COLUMN_WAVE             "WAVE"
#define GIALIAS_COLUMN_WAVE_UNIT        "nm"
#define GIALIAS_COLUMN_WAVE_TUTYP       "spec:Data.SpectralAxis.Value"
#define GIALIAS_COLUMN_WAVE_TUCD        "em.wl;obs.atmos"
#define GIALIAS_COLUMN_WAVE_TCOMM       "Array computed from original WCS"
#define GIALIAS_COLUMN_FLUX_REDUCED       "FLUX_REDUCED"
#define GIALIAS_COLUMN_FLUX_REDUCED_UNIT  "adu"
#define GIALIAS_COLUMN_FLUX_REDUCED_TUTYP "spec:Data.FluxAxis.Value"
#define GIALIAS_COLUMN_FLUX_REDUCED_TUCD  "phot.flux.density;em.wl;stat.uncalib"
#define GIALIAS_COLUMN_ERR_REDUCED        "ERR_REDUCED"
#define GIALIAS_COLUMN_ERR_REDUCED_UNIT   "adu"
#define GIALIAS_COLUMN_ERR_REDUCED_TUTYP  "spec:Data.FluxAxis.Accuracy.StatError"
#define GIALIAS_COLUMN_ERR_REDUCED_TUCD   "stat.error;phot.flux.density;em.wl;stat.uncalib"
#define GIALIAS_COLUMN_SNR              "SNR"
#define GIALIAS_COLUMN_SNR_UNIT         ""
#define GIALIAS_COLUMN_SNR_TUTYP        "eso:Data.FluxAxis.Accuracy.SNR"
#define GIALIAS_COLUMN_SNR_TUCD         "stat.snr;meta.main"
#define GIALIAS_COLUMN_SNR_TCOMM        "Array computed from flux and error arrays"


/* deprecated */

#define GIALIAS_WSOL_OPTMFCOLL  "ESO PRO WSOL OPTMOD FCOLL"
#define GIALIAS_WSOL_OPTMGCAM   "ESO PRO WSOL OPTMOD GCAM"
#define GIALIAS_WSOL_OPTMTHETA  "ESO PRO WSOL OPTMOD THETA"
#define GIALIAS_WSOL_OPTMSDX    "ESO PRO WSOL OPTMOD SLITDX"
#define GIALIAS_WSOL_OPTMSDY    "ESO PRO WSOL OPTMOD SLITDY"
#define GIALIAS_WSOL_OPTMSPHI   "ESO PRO WSOL OPTMOD SLITPHI"
#define GIALIAS_OPTMDIR         "ESO PRO WSOL OPTMOD DIRECTION"
#define GIALIAS_OPT_MOD         "ESO PRO WSOL OPTICAL MODEL"
#define GIALIAS_SSF             "ESO PRO WSOL SUBSLIT FIT"
#define GIALIAS_PSFW_SIG        "ESO PRO WSOL PSFW CLIPSIGMA"
#define GIALIAS_PSFW_NIT        "ESO PRO WSOL PSFW CLIPNITER"
#define GIALIAS_PSFW_MFR        "ESO PRO WSOL PSFW CLIPMFRAC"
#define GIALIAS_PSFW_PDEG       "ESO PRO WSOL PSFW POLYDEG"
#define GIALIAS_PSFW_BINN       "ESO PRO WSOL PSFW BINNING"
#define GIALIAS_PSFW_SSNR       "ESO PRO WSOL SUBSLIT NUMBER"
#define GIALIAS_XRES_SIG        "ESO PRO WSOL XRES CLIPSIGMA"
#define GIALIAS_XRES_NIT        "ESO PRO WSOL XRES CLIPNITER"
#define GIALIAS_XRES_MFR        "ESO PRO WSOL XRES CLIPMFRAC"
#define GIALIAS_XRES_PDEG       "ESO PRO WSOL XRES POLYDEG"
#define GIALIAS_XRES_BINN       "ESO PRO WSOL XRES BINNING"
#define GIALIAS_XRES_SSN        "ESO PRO WSOL SUBSLIT NUMBER"
#define GIALIAS_XRES_OMOD       "ESO PRO WSOL XRES OPTICAL MODEL"
#define GIALIAS_OPTSOL          "ESO PRO WSOL OPTIC SOLUTION"
#define GIALIAS_WSOL_LINEM      "ESO PRO WSOL LINE MODEL"
#define GIALIAS_WSOL_LINEWDTH   "ESO PRO WSOL LINE WIDTH"
#define GIALIAS_WSOL_LINETHOLD  "ESO PRO WSOL LINE THRESHOLD"
#define GIALIAS_WSOL_LINENIT    "ESO PRO WSOL LINE NITER"
#define GIALIAS_WSOL_LINENTST   "ESO PRO WSOL LINE NTEST"
#define GIALIAS_WSOL_LINEDCHQ   "ESO PRO WSOL LINE DCHISQ"
#define GIALIAS_WSOL_GRAT_THETA "ESO PRO WSOL GRAT THETA"
#define GIALIAS_WSOL_GRAT_ORDER "ESO PRO WSOL GRAT ORDER"
#define GIALIAS_WSOL_GRAT_SPACE "ESO PRO WSOL GRAT SPACE"

#ifdef __cplusplus
}
#endif

#endif /* GIALIAS_H */
