/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2025 Univ. Grenoble Alpes, CNRS, Grenoble INP - UGA, TIMC, 38000 Grenoble, France
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
#include "RegisterExtension.h"

#include <Application.h>

#include "HotPlugExtensionManager.h"
#include <QFileDialog>

using namespace camitk;

// -------------------- process --------------------
Action::ApplyStatus RegisterExtension::process() {
    QString camitkExtensionFile = getParameterValueAsString("CamiTK File");
    if (camitkExtensionFile.isEmpty()) {
        camitkExtensionFile = QFileDialog::getOpenFileName(nullptr, tr("Open CamiTK Extension File"),
                              Application::getLastUsedDirectory().absolutePath(),
                              tr("CamiTK Extension Files (*.camitk)"));

    }
    QApplication::setOverrideCursor(QCursor(Qt::WaitCursor));
    Action::ApplyStatus status = SUCCESS;
    if (!camitkExtensionFile.isEmpty()) {
        bool registered = HotPlugExtensionManager::registerExtension(camitkExtensionFile);
        if (registered) {
            refreshApplication(); // to refresh dev menus
            Application::showStatusBarMessage("Action extension " + QFileInfo(camitkExtensionFile).fileName() + " registered");
        }
        else {
            status = ABORTED;
        }
    }
    else {
        status = ABORTED;
    }

    QApplication::restoreOverrideCursor();
    Application::resetProgressBar();

    return status;
}

// -------------------- targetDefined --------------------
void RegisterExtension::targetDefined() {
}

// -------------------- parameterChanged --------------------
void RegisterExtension::parameterChanged(QString parameterName) {
}

// -------------------- init --------------------
void RegisterExtension::init() {
}
