namespace bidimensional_vector {
  
  float angle(std::pair<float,float> a, std::pair<float,float> b);
  float dot_product(std::pair<float,float> a, std::pair<float,float> b);
  float cross_product(std::pair<float,float> a, std::pair<float,float> b);

  std::pair<float,float> diff(std::pair<float,float> a, std::pair<float,float> b);

  float magn(std::pair<float,float> a);
  std::pair<float,float> normalize(std::pair<float,float> a);

  std::pair<float, float> rotate(std::pair<float, float> v, 
                                 float angle);

  std::pair<float, float> translate(std::pair<float, float> v, 
                                    float dx, float dy);

  std::pair<float, float> scale(std::pair<float, float> v, 
                                float scale_factor);

  std::pair<float, float> project_par(std::pair<float,float> v, std::pair<float,float> n);

  std::pair<float, float> project_perp(std::pair<float,float> v, std::pair<float,float> n);

  void print(std::ostream& str, std::pair<float, float> v);

  /**
   *return bool if value of v i inside interval (ref-offset;ref+offset)
   */
 
  template <class T> bool similar_to(T v, T ref, T offset){
    bool res=false;
    if( (v >= ref - offset) && (v <= ref + offset) ){
      res=!res;
    }
    return res;
  }


  const static std::pair<float,float> x_ax(1,0);
  const static std::pair<float,float> y_ax(0,1);

}
