/*
 * Copyright (c) 2021, 2023-2024 Arm Limited.
 *
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#include <cstddef>
#include <cstdint>

#if defined(__aarch64__)

namespace arm_conv {
namespace depthwise {

void a64_fp32_nhwc_3x3_s1_output4x4_mla_depthfirst_indirect_impl(
  const float *const *const input_ptrs,
  float *const *const outptrs,
  const void *params,
  unsigned int n_channels,
  const float activation_min,
  const float activation_max
)
{
  struct Args
  {
    float *const *outptrs;
    const void *params;
    const float min, max;
    const float *inptrs[36];

    Args(
      const float *const *const input_ptrs,
      float *const *const outptrs,
      const void *const params,
      const float min,
      const float max
    ) : outptrs(outptrs), params(params), min(min), max(max)
    {
      inptrs[0] = input_ptrs[14];
      inptrs[1] = input_ptrs[0];
      inptrs[2] = input_ptrs[5];
      inptrs[3] = input_ptrs[15];
      inptrs[4] = input_ptrs[30];
      inptrs[5] = input_ptrs[35];
      inptrs[6] = input_ptrs[20];
      inptrs[7] = input_ptrs[1];
      inptrs[8] = input_ptrs[4];
      inptrs[9] = input_ptrs[21];
      inptrs[10] = input_ptrs[6];
      inptrs[11] = input_ptrs[11];
      inptrs[12] = input_ptrs[24];
      inptrs[13] = input_ptrs[8];
      inptrs[14] = input_ptrs[29];
      inptrs[15] = input_ptrs[9];
      inptrs[16] = input_ptrs[31];
      inptrs[17] = input_ptrs[13];
      inptrs[18] = input_ptrs[34];
      inptrs[19] = input_ptrs[16];
      inptrs[20] = input_ptrs[2];
      inptrs[21] = input_ptrs[19];
      inptrs[22] = input_ptrs[3];
      inptrs[23] = input_ptrs[12];
      inptrs[24] = input_ptrs[22];
      inptrs[25] = input_ptrs[17];
      inptrs[26] = input_ptrs[18];
      inptrs[27] = input_ptrs[26];
      inptrs[28] = input_ptrs[23];
      inptrs[29] = input_ptrs[32];
      inptrs[30] = input_ptrs[27];
      inptrs[31] = input_ptrs[33];
      inptrs[32] = input_ptrs[7];
      inptrs[33] = input_ptrs[10];
      inptrs[34] = input_ptrs[25];
      inptrs[35] = input_ptrs[28];

    }
  };

  Args params_struct(input_ptrs, outptrs, params,
                     activation_min, activation_max);

  __asm__ __volatile__(
    "mov x6, #0x10\n"  // cntb _, ALL, #1
    "lsr x7, %x[n_channels], #0x2\n"
    "ldr x8, [%x[params_struct], %[offsetof_args_outptrs]]\n"
    "ldr x17, [%x[params_struct], %[offsetof_args_params]]\n"
    "add x21, %x[params_struct], %[offsetof_args_min]\n"
    "add x20, %x[params_struct], %[offsetof_args_max]\n"
    "ld1r { v15.4s }, [x21]\n"
    "ld1r { v14.4s }, [x20]\n"
    "add x16, %x[params_struct], %[offsetof_Args_inptrs]\n"
    "mov x15, #0x0\n"
    "sub x14, XZR, x6\n"
    "cbz x7, 3f\n"
    "ldr q30, [x17, #0x0]\n"
    "ldr q0, [x17, #0x10]\n"
    "cmp x6, x7, LSL #4\n"
    "ldr q1, [x17, #0x20]\n"
    "ldr q2, [x17, #0x30]\n"
    "ldr q3, [x17, #0x40]\n"
    "ldr q4, [x17, #0x50]\n"
    "ldr q5, [x17, #0x60]\n"
    "ldr q6, [x17, #0x70]\n"
    "ldr q7, [x17, #0x80]\n"
    "ldr q8, [x17, #0x90]\n"
    "add x17, x17, #0xa0\n"
    "ldp x23, x22, [x16, #0x0]\n"
    "ldp x21, x20, [x16, #0x10]\n"
    "ldr q9, [x23, x15]\n"
    "ldr q10, [x22, x15]\n"
    "ldr q11, [x21, x15]\n"
    "ldr q12, [x20, x15]\n"
    "bge 2f\n"
    "1:"  // Channel loop
    "mov v21.16b, v30.16b\n fmla v21.4s, v4.4s, v9.4s\n"
    "mov v26.16b, v30.16b\n fmla v26.4s, v8.4s, v9.4s\n"
    "ldr x27, [x16, #0x20]\n"
    "ldr x24, [x16, #0x30]\n"
    "mov v27.16b, v30.16b\n fmla v27.4s, v3.4s, v9.4s\n"
    "mov v31.16b, v30.16b\n fmla v31.4s, v1.4s, v9.4s\n"
    "ldr x23, [x16, #0x28]\n"
    "ldr x22, [x16, #0x38]\n"
    "mov v28.16b, v30.16b\n fmla v28.4s, v0.4s, v9.4s\n"
    "mov v18.16b, v30.16b\n fmla v18.4s, v7.4s, v9.4s\n"
    "ldr x26, [x16, #0x40]\n"
    "ldr x20, [x16, #0x48]\n"
    "mov v20.16b, v30.16b\n fmla v20.4s, v6.4s, v9.4s\n"
    "mov v13.16b, v30.16b\n fmla v13.4s, v5.4s, v9.4s\n"
    "ldr x25, [x16, #0x50]\n"
    "ldr x21, [x16, #0x58]\n"
    "fmla v21.4s, v5.4s, v12.4s\n"
    "mov v16.16b, v30.16b\n fmla v16.4s, v2.4s, v9.4s\n"
    "ldr q9, [x24, x15]\n"
    "ldr x13, [x16, #0x70]\n"
    "fmla v26.4s, v0.4s, v10.4s\n"
    "ldr q17, [x27, x15]\n"
    "mov v25.16b, v30.16b\n fmla v25.4s, v2.4s, v11.4s\n"
    "ldr q29, [x23, x15]\n"
    "fmla v27.4s, v4.4s, v12.4s\n"
    "fmla v31.4s, v2.4s, v12.4s\n"
    "ldr x24, [x16, #0x60]\n"
    "ldr x23, [x16, #0x68]\n"
    "fmla v28.4s, v1.4s, v12.4s\n"
    "fmla v18.4s, v8.4s, v12.4s\n"
    "ldr x12, [x8, #0x0]\n"
    "ldr x11, [x8, #0x8]\n"
    "fmla v20.4s, v7.4s, v12.4s\n"
    "mov v24.16b, v30.16b\n fmla v24.4s, v6.4s, v17.4s\n"
    "ldr q10, [x20, x15]\n"
    "ldr x28, [x16, #0x88]\n"
    "fmla v21.4s, v7.4s, v9.4s\n"
    "fmla v25.4s, v6.4s, v12.4s\n"
    "ldr x10, [x8, #0x10]\n"
    "ldr x9, [x8, #0x18]\n"
    "mov v22.16b, v30.16b\n fmla v22.4s, v3.4s, v12.4s\n"
    "mov v19.16b, v30.16b\n fmla v19.4s, v0.4s, v12.4s\n"
    "ldr q12, [x22, x15]\n"
    "ldr x22, [x16, #0x78]\n"
    "mov v17.16b, v30.16b\n fmla v17.4s, v8.4s, v29.4s\n"
    "ldr q11, [x26, x15]\n"
    "fmla v27.4s, v6.4s, v9.4s\n"
    "ldr x20, [x16, #0x80]\n"
    "fmla v31.4s, v4.4s, v9.4s\n"
    "fmla v28.4s, v3.4s, v9.4s\n"
    "add x14, x14, #0x10\n"
    "mov v29.16b, v30.16b\n fmla v29.4s, v1.4s, v9.4s\n"
    "mov v23.16b, v30.16b\n fmla v23.4s, v0.4s, v9.4s\n"
    "ldr q30, [x17, #0x0]\n"
    "fmla v13.4s, v8.4s, v9.4s\n"
    "fmla v16.4s, v5.4s, v9.4s\n"
    "fmla v24.4s, v2.4s, v9.4s\n"
    "ldr q9, [x25, x15]\n"
    "fmla v26.4s, v1.4s, v12.4s\n"
    "ldr x27, [x16, #0x90]\n"
    "fmla v18.4s, v0.4s, v12.4s\n"
    "ldr q12, [x21, x15]\n"
    "fmla v20.4s, v2.4s, v11.4s\n"
    "ldr x21, [x16, #0x98]\n"
    "fmla v21.4s, v8.4s, v10.4s\n"
    "fmla v25.4s, v1.4s, v11.4s\n"
    "ldr q11, [x24, x15]\n"
    "ldr x26, [x16, #0xa0]\n"
    "fmla v27.4s, v7.4s, v10.4s\n"
    "fmla v22.4s, v6.4s, v10.4s\n"
    "fmla v31.4s, v5.4s, v10.4s\n"
    "fmla v28.4s, v4.4s, v10.4s\n"
    "fmla v19.4s, v3.4s, v10.4s\n"
    "fmla v29.4s, v2.4s, v10.4s\n"
    "fmla v23.4s, v1.4s, v10.4s\n"
    "fmla v17.4s, v0.4s, v10.4s\n"
    "ldr q10, [x23, x15]\n"
    "ldr x25, [x16, #0xa8]\n"
    "fmla v26.4s, v3.4s, v9.4s\n"
    "fmla v13.4s, v0.4s, v9.4s\n"
    "fmla v16.4s, v6.4s, v11.4s\n"
    "fmla v24.4s, v3.4s, v11.4s\n"
    "ldr q9, [x13, x15]\n"
    "ldr x24, [x16, #0xb0]\n"
    "fmla v18.4s, v4.4s, v10.4s\n"
    "fmla v20.4s, v3.4s, v10.4s\n"
    "fmla v21.4s, v1.4s, v10.4s\n"
    "fmla v25.4s, v5.4s, v12.4s\n"
    "fmla v22.4s, v2.4s, v12.4s\n"
    "ldr q12, [x22, x15]\n"
    "fmla v27.4s, v0.4s, v10.4s\n"
    "ldr x23, [x16, #0xb8]\n"
    "fmla v19.4s, v8.4s, v9.4s\n"
    "fmla v17.4s, v5.4s, v9.4s\n"
    "ldr q9, [x20, x15]\n"
    "ldr x22, [x16, #0xc0]\n"
    "fmla v26.4s, v5.4s, v10.4s\n"
    "fmla v13.4s, v2.4s, v10.4s\n"
    "ldr q11, [x28, x15]\n"
    "ldr x20, [x16, #0xc8]\n"
    "fmla v18.4s, v5.4s, v12.4s\n"
    "fmla v20.4s, v4.4s, v12.4s\n"
    "fmla v21.4s, v2.4s, v12.4s\n"
    "fmla v25.4s, v3.4s, v12.4s\n"
    "fmla v27.4s, v1.4s, v12.4s\n"
    "fmla v22.4s, v0.4s, v12.4s\n"
    "ldr q10, [x21, x15]\n"
    "ldr x28, [x16, #0xd8]\n"
    "fmla v24.4s, v7.4s, v9.4s\n"
    "fmla v29.4s, v6.4s, v9.4s\n"
    "ldr q9, [x27, x15]\n"
    "ldr x21, [x16, #0xd0]\n"
    "fmla v26.4s, v7.4s, v11.4s\n"
    "fmla v18.4s, v6.4s, v11.4s\n"
    "fmla v13.4s, v4.4s, v11.4s\n"
    "fmla v21.4s, v3.4s, v11.4s\n"
    "fmla v16.4s, v1.4s, v11.4s\n"
    "fmla v31.4s, v0.4s, v11.4s\n"
    "ldr q12, [x26, x15]\n"
    "ldr x27, [x16, #0xe0]\n"
    "fmla v20.4s, v8.4s, v10.4s\n"
    "fmla v23.4s, v8.4s, v9.4s\n"
    "fmla v17.4s, v7.4s, v9.4s\n"
    "ldr q11, [x25, x15]\n"
    "fmla v19.4s, v1.4s, v10.4s\n"
    "ldr x26, [x16, #0xe8]\n"
    "fmla v25.4s, v7.4s, v10.4s\n"
    "fmla v27.4s, v5.4s, v10.4s\n"
    "fmla v22.4s, v4.4s, v10.4s\n"
    "fmla v28.4s, v2.4s, v10.4s\n"
    "ldr q9, [x24, x15]\n"
    "ldr x25, [x16, #0xf0]\n"
    "fmla v26.4s, v2.4s, v12.4s\n"
    "fmla v18.4s, v1.4s, v12.4s\n"
    "fmla v20.4s, v0.4s, v12.4s\n"
    "ldr q12, [x23, x15]\n"
    "fmla v13.4s, v7.4s, v11.4s\n"
    "ldr x24, [x16, #0xf8]\n"
    "fmla v21.4s, v6.4s, v11.4s\n"
    "fmla v16.4s, v4.4s, v11.4s\n"
    "fmla v31.4s, v3.4s, v11.4s\n"
    "fmla v24.4s, v1.4s, v11.4s\n"
    "fmla v29.4s, v0.4s, v11.4s\n"
    "ldr q10, [x22, x15]\n"
    "fmla v18.4s, v2.4s, v9.4s\n"
    "ldr x22, [x16, #0x100]\n"
    "fmla v20.4s, v1.4s, v9.4s\n"
    "fmla v25.4s, v0.4s, v9.4s\n"
    "ldr q11, [x20, x15]\n"
    "ldr x20, [x16, #0x108]\n"
    "fmla v26.4s, v6.4s, v12.4s\n"
    "fmla v13.4s, v3.4s, v12.4s\n"
    "fmla v19.4s, v4.4s, v10.4s\n"
    "fmla v23.4s, v2.4s, v10.4s\n"
    "fmla v16.4s, v0.4s, v12.4s\n"
    "ldr q9, [x21, x15]\n"
    "fmla v27.4s, v8.4s, v10.4s\n"
    "ldr x23, [x16, #0x110]\n"
    "fmla v22.4s, v7.4s, v10.4s\n"
    "fmla v28.4s, v5.4s, v10.4s\n"
    "fmla v17.4s, v1.4s, v10.4s\n"
    "ldr q10, [x28, x15]\n"
    "fmla v25.4s, v8.4s, v11.4s\n"
    "ldr x21, [x16, #0x118]\n"
    "fmla v19.4s, v2.4s, v11.4s\n"
    "fmla v24.4s, v0.4s, v9.4s\n"
    "fmla v13.4s, v6.4s, v9.4s\n"
    "fmla v16.4s, v3.4s, v9.4s\n"
    "ldr q9, [x26, x15]\n"
    "fmla v29.4s, v4.4s, v10.4s\n"
    "fmla v23.4s, v3.4s, v10.4s\n"
    "fmla v22.4s, v5.4s, v11.4s\n"
    "ldr q12, [x27, x15]\n"
    "fmla v31.4s, v7.4s, v10.4s\n"
    "fmla v28.4s, v6.4s, v10.4s\n"
    "fmla v24.4s, v5.4s, v10.4s\n"
    "fmla v16.4s, v8.4s, v10.4s\n"
    "ldr q10, [x25, x15]\n"
    "fmla v19.4s, v5.4s, v12.4s\n"
    "fmla v17.4s, v2.4s, v12.4s\n"
    "fmla v29.4s, v7.4s, v9.4s\n"
    "fmla v23.4s, v6.4s, v9.4s\n"
    "fmla v22.4s, v8.4s, v12.4s\n"
    "ldr q12, [x24, x15]\n"
    "fmla v24.4s, v8.4s, v9.4s\n"
    "ldr q9, [x22, x15]\n"
    "fmla v31.4s, v8.4s, v10.4s\n"
    "fmla v28.4s, v7.4s, v10.4s\n"
    "fmla v19.4s, v6.4s, v10.4s\n"
    "fmla v29.4s, v5.4s, v10.4s\n"
    "fmla v17.4s, v3.4s, v10.4s\n"
    "fmla v23.4s, v4.4s, v10.4s\n"
    "ldr q11, [x20, x15]\n"
    "fmla v26.4s, v4.4s, v9.4s\n"
    "ldp x20, x22, [x16, #0x0]\n"
    "fmla v18.4s, v3.4s, v9.4s\n"
    "fmla v13.4s, v1.4s, v9.4s\n"
    "fmla v21.4s, v0.4s, v9.4s\n"
    "ldr q10, [x21, x15]\n"
    "ldr q0, [x17, #0x10]\n"
    "ldr q9, [x20, x6]\n"
    "fmla v20.4s, v5.4s, v11.4s\n"
    "fmla v25.4s, v4.4s, v11.4s\n"
    "fmla v29.4s, v8.4s, v12.4s\n"
    "fmla v23.4s, v7.4s, v12.4s\n"
    "fmax v26.4s, v26.4s, v15.4s\n"
    "fmla v17.4s, v6.4s, v12.4s\n"
    "ldr q12, [x23, x15]\n"
    "fmla v27.4s, v2.4s, v11.4s\n"
    "ldr q2, [x17, #0x30]\n"
    "fmla v22.4s, v1.4s, v11.4s\n"
    "ldr q1, [x17, #0x20]\n"
    "fmax v18.4s, v18.4s, v15.4s\n"
    "fmla v28.4s, v8.4s, v10.4s\n"
    "ldr q8, [x17, #0x90]\n"
    "fmax v20.4s, v20.4s, v15.4s\n"
    "fmax v25.4s, v25.4s, v15.4s\n"
    "fmla v19.4s, v7.4s, v10.4s\n"
    "fmla v16.4s, v7.4s, v12.4s\n"
    "ldr q7, [x17, #0x80]\n"
    "fmla v31.4s, v6.4s, v12.4s\n"
    "ldr q6, [x17, #0x70]\n"
    "fmin v26.4s, v26.4s, v14.4s\n"
    "fmin v18.4s, v18.4s, v14.4s\n"
    "fmla v24.4s, v4.4s, v12.4s\n"
    "ldp x21, x20, [x16, #0x10]\n"
    "fmin v20.4s, v20.4s, v14.4s\n"
    "fmin v25.4s, v25.4s, v14.4s\n"
    "fmla v29.4s, v3.4s, v12.4s\n"
    "ldr q3, [x17, #0x40]\n"
    "fmax v13.4s, v13.4s, v15.4s\n"
    "fmax v21.4s, v21.4s, v15.4s\n"
    "fmla v23.4s, v5.4s, v10.4s\n"
    "ldr q5, [x17, #0x60]\n"
    "ldr q11, [x21, x6]\n"
    "ldr q12, [x20, x6]\n"
    "fmax v27.4s, v27.4s, v15.4s\n"
    "fmax v22.4s, v22.4s, v15.4s\n"
    "str q26, [x12, x14]\n"
    "ldr x23, [x8, #0x20]\n"
    "fmla v17.4s, v4.4s, v10.4s\n"
    "ldr q10, [x22, x6]\n"
    "ldr q4, [x17, #0x50]\n"
    "str q18, [x11, x14]\n"
    "ldr x22, [x8, #0x28]\n"
    "fmin v13.4s, v13.4s, v14.4s\n"
    "str q20, [x10, x14]\n"
    "ldr x21, [x8, #0x30]\n"
    "fmin v21.4s, v21.4s, v14.4s\n"
    "fmin v27.4s, v27.4s, v14.4s\n"
    "str q25, [x9, x14]\n"
    "ldr x20, [x8, #0x38]\n"
    "fmin v22.4s, v22.4s, v14.4s\n"
    "fmax v16.4s, v16.4s, v15.4s\n"
    "fmax v31.4s, v31.4s, v15.4s\n"
    "fmax v28.4s, v28.4s, v15.4s\n"
    "str q13, [x23, x14]\n"
    "ldr x23, [x8, #0x40]\n"
    "fmax v19.4s, v19.4s, v15.4s\n"
    "str q21, [x22, x14]\n"
    "ldr x22, [x8, #0x48]\n"
    "fmax v24.4s, v24.4s, v15.4s\n"
    "str q27, [x21, x14]\n"
    "ldr x21, [x8, #0x50]\n"
    "fmin v16.4s, v16.4s, v14.4s\n"
    "fmax v29.4s, v29.4s, v15.4s\n"
    "str q22, [x20, x14]\n"
    "ldr x20, [x8, #0x58]\n"
    "fmin v31.4s, v31.4s, v14.4s\n"
    "fmin v28.4s, v28.4s, v14.4s\n"
    "fmin v19.4s, v19.4s, v14.4s\n"
    "fmax v23.4s, v23.4s, v15.4s\n"
    "add x6, x6, #0x10\n"
    "add x15, x15, #0x10\n"
    "fmax v17.4s, v17.4s, v15.4s\n"
    "str q16, [x23, x14]\n"
    "ldr x23, [x8, #0x60]\n"
    "cmp x6, x7, LSL #4\n"
    "str q31, [x22, x14]\n"
    "ldr x22, [x8, #0x68]\n"
    "fmin v24.4s, v24.4s, v14.4s\n"
    "fmin v29.4s, v29.4s, v14.4s\n"
    "str q28, [x21, x14]\n"
    "ldr x21, [x8, #0x70]\n"
    "fmin v23.4s, v23.4s, v14.4s\n"
    "add x17, x17, #0xa0\n"
    "str q19, [x20, x14]\n"
    "ldr x20, [x8, #0x78]\n"
    "fmin v17.4s, v17.4s, v14.4s\n"
    "str q24, [x23, x14]\n"
    "str q29, [x22, x14]\n"
    "str q23, [x21, x14]\n"
    "str q17, [x20, x14]\n"
    "blt 1b\n"
    "2:"  // Channel tail
    "mov v16.16b, v30.16b\n fmla v16.4s, v4.4s, v9.4s\n"
    "mov v19.16b, v30.16b\n fmla v19.4s, v8.4s, v9.4s\n"
    "ldr x27, [x16, #0x20]\n"
    "ldr x24, [x16, #0x30]\n"
    "mov v13.16b, v30.16b\n fmla v13.4s, v3.4s, v9.4s\n"
    "mov v31.16b, v30.16b\n fmla v31.4s, v1.4s, v9.4s\n"
    "ldr x23, [x16, #0x28]\n"
    "ldr x22, [x16, #0x38]\n"
    "mov v17.16b, v30.16b\n fmla v17.4s, v0.4s, v9.4s\n"
    "mov v18.16b, v30.16b\n fmla v18.4s, v7.4s, v9.4s\n"
    "ldr x26, [x16, #0x40]\n"
    "ldr x21, [x16, #0x48]\n"
    "mov v25.16b, v30.16b\n fmla v25.4s, v6.4s, v9.4s\n"
    "mov v28.16b, v30.16b\n fmla v28.4s, v5.4s, v9.4s\n"
    "ldr x25, [x16, #0x50]\n"
    "ldr x20, [x16, #0x58]\n"
    "fmla v16.4s, v5.4s, v12.4s\n"
    "mov v29.16b, v30.16b\n fmla v29.4s, v2.4s, v9.4s\n"
    "ldr q22, [x24, x15]\n"
    "ldr x13, [x16, #0x70]\n"
    "fmla v19.4s, v0.4s, v10.4s\n"
    "ldr q20, [x27, x15]\n"
    "mov v27.16b, v30.16b\n fmla v27.4s, v2.4s, v11.4s\n"
    "ldr q23, [x23, x15]\n"
    "fmla v13.4s, v4.4s, v12.4s\n"
    "fmla v31.4s, v2.4s, v12.4s\n"
    "ldr x24, [x16, #0x60]\n"
    "ldr x23, [x16, #0x68]\n"
    "fmla v17.4s, v1.4s, v12.4s\n"
    "fmla v18.4s, v8.4s, v12.4s\n"
    "ldr x12, [x8, #0x0]\n"
    "ldr x11, [x8, #0x8]\n"
    "fmla v25.4s, v7.4s, v12.4s\n"
    "mov v11.16b, v30.16b\n fmla v11.4s, v6.4s, v20.4s\n"
    "ldr q9, [x21, x15]\n"
    "ldr x28, [x16, #0x88]\n"
    "fmla v16.4s, v7.4s, v22.4s\n"
    "fmla v27.4s, v6.4s, v12.4s\n"
    "ldr x10, [x8, #0x10]\n"
    "ldr x9, [x8, #0x18]\n"
    "mov v10.16b, v30.16b\n fmla v10.4s, v3.4s, v12.4s\n"
    "mov v26.16b, v30.16b\n fmla v26.4s, v0.4s, v12.4s\n"
    "ldr q21, [x22, x15]\n"
    "ldr x22, [x16, #0x78]\n"
    "mov v24.16b, v30.16b\n fmla v24.4s, v8.4s, v23.4s\n"
    "ldr q23, [x26, x15]\n"
    "fmla v13.4s, v6.4s, v22.4s\n"
    "ldr x21, [x16, #0x80]\n"
    "fmla v31.4s, v4.4s, v22.4s\n"
    "fmla v17.4s, v3.4s, v22.4s\n"
    "add x14, x14, #0x10\n"
    "mov v12.16b, v30.16b\n fmla v12.4s, v1.4s, v22.4s\n"
    "fmla v30.4s, v0.4s, v22.4s\n"
    "fmla v28.4s, v8.4s, v22.4s\n"
    "fmla v29.4s, v5.4s, v22.4s\n"
    "fmla v11.4s, v2.4s, v22.4s\n"
    "ldr q22, [x25, x15]\n"
    "fmla v19.4s, v1.4s, v21.4s\n"
    "ldr x27, [x16, #0x90]\n"
    "fmla v18.4s, v0.4s, v21.4s\n"
    "ldr q21, [x20, x15]\n"
    "fmla v25.4s, v2.4s, v23.4s\n"
    "ldr x20, [x16, #0x98]\n"
    "fmla v16.4s, v8.4s, v9.4s\n"
    "fmla v27.4s, v1.4s, v23.4s\n"
    "ldr q20, [x24, x15]\n"
    "ldr x26, [x16, #0xa0]\n"
    "fmla v13.4s, v7.4s, v9.4s\n"
    "fmla v10.4s, v6.4s, v9.4s\n"
    "fmla v31.4s, v5.4s, v9.4s\n"
    "fmla v17.4s, v4.4s, v9.4s\n"
    "fmla v26.4s, v3.4s, v9.4s\n"
    "fmla v12.4s, v2.4s, v9.4s\n"
    "fmla v30.4s, v1.4s, v9.4s\n"
    "fmla v24.4s, v0.4s, v9.4s\n"
    "ldr q23, [x23, x15]\n"
    "ldr x25, [x16, #0xa8]\n"
    "fmla v19.4s, v3.4s, v22.4s\n"
    "fmla v28.4s, v0.4s, v22.4s\n"
    "fmla v29.4s, v6.4s, v20.4s\n"
    "fmla v11.4s, v3.4s, v20.4s\n"
    "ldr q20, [x13, x15]\n"
    "ldr x24, [x16, #0xb0]\n"
    "fmla v18.4s, v4.4s, v23.4s\n"
    "fmla v25.4s, v3.4s, v23.4s\n"
    "fmla v16.4s, v1.4s, v23.4s\n"
    "fmla v27.4s, v5.4s, v21.4s\n"
    "fmla v10.4s, v2.4s, v21.4s\n"
    "ldr q22, [x22, x15]\n"
    "fmla v13.4s, v0.4s, v23.4s\n"
    "ldr x23, [x16, #0xb8]\n"
    "fmla v26.4s, v8.4s, v20.4s\n"
    "fmla v24.4s, v5.4s, v20.4s\n"
    "ldr q21, [x21, x15]\n"
    "ldr x22, [x16, #0xc0]\n"
    "fmla v19.4s, v5.4s, v23.4s\n"
    "fmla v28.4s, v2.4s, v23.4s\n"
    "ldr q20, [x28, x15]\n"
    "ldr x21, [x16, #0xc8]\n"
    "fmla v18.4s, v5.4s, v22.4s\n"
    "fmla v25.4s, v4.4s, v22.4s\n"
    "fmla v16.4s, v2.4s, v22.4s\n"
    "fmla v27.4s, v3.4s, v22.4s\n"
    "fmla v13.4s, v1.4s, v22.4s\n"
    "fmla v10.4s, v0.4s, v22.4s\n"
    "ldr q22, [x20, x15]\n"
    "ldr x28, [x16, #0xd8]\n"
    "fmla v11.4s, v7.4s, v21.4s\n"
    "fmla v12.4s, v6.4s, v21.4s\n"
    "ldr q21, [x27, x15]\n"
    "ldr x20, [x16, #0xd0]\n"
    "fmla v19.4s, v7.4s, v20.4s\n"
    "fmla v18.4s, v6.4s, v20.4s\n"
    "fmla v28.4s, v4.4s, v20.4s\n"
    "fmla v16.4s, v3.4s, v20.4s\n"
    "fmla v29.4s, v1.4s, v20.4s\n"
    "fmla v31.4s, v0.4s, v20.4s\n"
    "ldr q20, [x26, x15]\n"
    "ldr x27, [x16, #0xe0]\n"
    "fmla v25.4s, v8.4s, v22.4s\n"
    "fmla v30.4s, v8.4s, v21.4s\n"
    "fmla v24.4s, v7.4s, v21.4s\n"
    "ldr q21, [x25, x15]\n"
    "fmla v26.4s, v1.4s, v22.4s\n"
    "ldr x26, [x16, #0xe8]\n"
    "fmla v27.4s, v7.4s, v22.4s\n"
    "fmla v13.4s, v5.4s, v22.4s\n"
    "fmla v10.4s, v4.4s, v22.4s\n"
    "fmla v17.4s, v2.4s, v22.4s\n"
    "ldr q22, [x24, x15]\n"
    "ldr x25, [x16, #0xf0]\n"
    "fmla v19.4s, v2.4s, v20.4s\n"
    "fmla v18.4s, v1.4s, v20.4s\n"
    "fmla v25.4s, v0.4s, v20.4s\n"
    "ldr q20, [x23, x15]\n"
    "fmla v28.4s, v7.4s, v21.4s\n"
    "ldr x24, [x16, #0xf8]\n"
    "fmla v16.4s, v6.4s, v21.4s\n"
    "fmla v29.4s, v4.4s, v21.4s\n"
    "fmla v31.4s, v3.4s, v21.4s\n"
    "fmla v11.4s, v1.4s, v21.4s\n"
    "fmla v12.4s, v0.4s, v21.4s\n"
    "ldr q21, [x22, x15]\n"
    "fmla v18.4s, v2.4s, v22.4s\n"
    "ldr x23, [x16, #0x100]\n"
    "fmla v25.4s, v1.4s, v22.4s\n"
    "fmla v27.4s, v0.4s, v22.4s\n"
    "ldr q23, [x21, x15]\n"
    "ldr x22, [x16, #0x108]\n"
    "fmla v19.4s, v6.4s, v20.4s\n"
    "fmla v28.4s, v3.4s, v20.4s\n"
    "fmla v26.4s, v4.4s, v21.4s\n"
    "fmla v30.4s, v2.4s, v21.4s\n"
    "fmla v29.4s, v0.4s, v20.4s\n"
    "ldr q20, [x20, x15]\n"
    "fmla v13.4s, v8.4s, v21.4s\n"
    "ldr x21, [x16, #0x110]\n"
    "fmla v10.4s, v7.4s, v21.4s\n"
    "fmla v17.4s, v5.4s, v21.4s\n"
    "fmla v24.4s, v1.4s, v21.4s\n"
    "ldr q21, [x28, x15]\n"
    "fmla v27.4s, v8.4s, v23.4s\n"
    "ldr x20, [x16, #0x118]\n"
    "fmla v26.4s, v2.4s, v23.4s\n"
    "fmla v11.4s, v0.4s, v20.4s\n"
    "fmla v28.4s, v6.4s, v20.4s\n"
    "fmla v29.4s, v3.4s, v20.4s\n"
    "ldr q22, [x26, x15]\n"
    "fmla v12.4s, v4.4s, v21.4s\n"
    "fmla v30.4s, v3.4s, v21.4s\n"
    "fmla v10.4s, v5.4s, v23.4s\n"
    "ldr q20, [x27, x15]\n"
    "fmla v31.4s, v7.4s, v21.4s\n"
    "fmla v17.4s, v6.4s, v21.4s\n"
    "fmla v11.4s, v5.4s, v21.4s\n"
    "fmla v29.4s, v8.4s, v21.4s\n"
    "ldr q21, [x25, x15]\n"
    "fmla v26.4s, v5.4s, v20.4s\n"
    "fmla v24.4s, v2.4s, v20.4s\n"
    "fmla v12.4s, v7.4s, v22.4s\n"
    "fmla v30.4s, v6.4s, v22.4s\n"
    "fmla v10.4s, v8.4s, v20.4s\n"
    "ldr q20, [x24, x15]\n"
    "fmla v11.4s, v8.4s, v22.4s\n"
    "ldr q22, [x23, x15]\n"
    "fmla v31.4s, v8.4s, v21.4s\n"
    "fmla v17.4s, v7.4s, v21.4s\n"
    "fmla v26.4s, v6.4s, v21.4s\n"
    "fmla v12.4s, v5.4s, v21.4s\n"
    "fmla v24.4s, v3.4s, v21.4s\n"
    "fmla v30.4s, v4.4s, v21.4s\n"
    "ldr q21, [x22, x15]\n"
    "fmla v19.4s, v4.4s, v22.4s\n"
    "fmla v18.4s, v3.4s, v22.4s\n"
    "fmla v28.4s, v1.4s, v22.4s\n"
    "fmla v16.4s, v0.4s, v22.4s\n"
    "ldr q23, [x20, x15]\n"
    "fmla v25.4s, v5.4s, v21.4s\n"
    "fmla v27.4s, v4.4s, v21.4s\n"
    "fmla v12.4s, v8.4s, v20.4s\n"
    "fmla v30.4s, v7.4s, v20.4s\n"
    "fmla v24.4s, v6.4s, v20.4s\n"
    "ldr q0, [x21, x15]\n"
    "fmax v19.4s, v19.4s, v15.4s\n"
    "fmla v13.4s, v2.4s, v21.4s\n"
    "fmla v10.4s, v1.4s, v21.4s\n"
    "fmax v18.4s, v18.4s, v15.4s\n"
    "add x15, x15, #0x10\n"
    "fmax v25.4s, v25.4s, v15.4s\n"
    "fmla v17.4s, v8.4s, v23.4s\n"
    "fmla v26.4s, v7.4s, v23.4s\n"
    "fmax v27.4s, v27.4s, v15.4s\n"
    "fmla v29.4s, v7.4s, v0.4s\n"
    "fmla v31.4s, v6.4s, v0.4s\n"
    "fmin v19.4s, v19.4s, v14.4s\n"
    "fmin v18.4s, v18.4s, v14.4s\n"
    "fmla v11.4s, v4.4s, v0.4s\n"
    "fmin v25.4s, v25.4s, v14.4s\n"
    "fmax v28.4s, v28.4s, v15.4s\n"
    "fmla v12.4s, v3.4s, v0.4s\n"
    "fmin v27.4s, v27.4s, v14.4s\n"
    "fmax v16.4s, v16.4s, v15.4s\n"
    "fmla v30.4s, v5.4s, v23.4s\n"
    "fmax v13.4s, v13.4s, v15.4s\n"
    "fmax v10.4s, v10.4s, v15.4s\n"
    "str q19, [x12, x14]\n"
    "ldr x23, [x8, #0x20]\n"
    "str q18, [x11, x14]\n"
    "ldr x22, [x8, #0x28]\n"
    "fmla v24.4s, v4.4s, v23.4s\n"
    "fmin v28.4s, v28.4s, v14.4s\n"
    "str q25, [x10, x14]\n"
    "ldr x21, [x8, #0x30]\n"
    "fmin v16.4s, v16.4s, v14.4s\n"
    "fmax v29.4s, v29.4s, v15.4s\n"
    "str q27, [x9, x14]\n"
    "ldr x20, [x8, #0x38]\n"
    "fmin v13.4s, v13.4s, v14.4s\n"
    "fmin v10.4s, v10.4s, v14.4s\n"
    "fmax v31.4s, v31.4s, v15.4s\n"
    "fmax v17.4s, v17.4s, v15.4s\n"
    "str q28, [x23, x14]\n"
    "ldr x23, [x8, #0x40]\n"
    "fmax v26.4s, v26.4s, v15.4s\n"
    "str q16, [x22, x14]\n"
    "ldr x22, [x8, #0x48]\n"
    "fmin v29.4s, v29.4s, v14.4s\n"
    "str q13, [x21, x14]\n"
    "ldr x21, [x8, #0x50]\n"
    "fmax v11.4s, v11.4s, v15.4s\n"
    "fmax v12.4s, v12.4s, v15.4s\n"
    "str q10, [x20, x14]\n"
    "ldr x20, [x8, #0x58]\n"
    "fmin v31.4s, v31.4s, v14.4s\n"
    "fmin v17.4s, v17.4s, v14.4s\n"
    "fmin v26.4s, v26.4s, v14.4s\n"
    "fmax v30.4s, v30.4s, v15.4s\n"
    "str q29, [x23, x14]\n"
    "ldr x23, [x8, #0x60]\n"
    "fmax v24.4s, v24.4s, v15.4s\n"
    "fmin v11.4s, v11.4s, v14.4s\n"
    "str q31, [x22, x14]\n"
    "ldr x22, [x8, #0x68]\n"
    "str q17, [x21, x14]\n"
    "ldr x21, [x8, #0x70]\n"
    "fmin v12.4s, v12.4s, v14.4s\n"
    "str q26, [x20, x14]\n"
    "ldr x20, [x8, #0x78]\n"
    "fmin v30.4s, v30.4s, v14.4s\n"
    "fmin v24.4s, v24.4s, v14.4s\n"
    "str q11, [x23, x14]\n"
    "str q12, [x22, x14]\n"
    "str q30, [x21, x14]\n"
    "str q24, [x20, x14]\n"
    "3:"  // Oddments
    "tst %x[n_channels], #0x3\n"
    "beq 72f\n"
    "ldr q30, [x17, #0x0]\n"
    "ldr q0, [x17, #0x10]\n"
    "mov x14, x15\n"
    "ldr q1, [x17, #0x20]\n"
    "ldr q2, [x17, #0x30]\n"
    "ldr q3, [x17, #0x40]\n"
    "ldr q4, [x17, #0x50]\n"
    "ldr q5, [x17, #0x60]\n"
    "ldr q6, [x17, #0x70]\n"
    "ldr q7, [x17, #0x80]\n"
    "ldr q8, [x17, #0x90]\n"
    "ldr x23, [x16, #0x0]\n"
    "ldr x22, [x16, #0x8]\n"
    "ldr x21, [x16, #0x10]\n"
    "ldr x20, [x16, #0x18]\n"
    "add x23, x23, x15\n"
    "add x22, x22, x15\n"
    "add x21, x21, x15\n"
    "add x20, x20, x15\n"
    "tbz %x[n_channels], #1, 4f\n"
    "ld1 { v9.d }[0], [x23], #0x8\n"
    "ld1 { v10.d }[0], [x22], #0x8\n"
    "ld1 { v11.d }[0], [x21], #0x8\n"
    "ld1 { v12.d }[0], [x20], #0x8\n"
    "tbz %x[n_channels], #0, 5f\n"
    "ld1 { v9.s }[2], [x23], #0x4\n"
    "ld1 { v10.s }[2], [x22], #0x4\n"
    "ld1 { v11.s }[2], [x21], #0x4\n"
    "ld1 { v12.s }[2], [x20], #0x4\n"
    "b 5f\n"
    "4:"  // Oddments: Load inputs (2, 2), (0, 0), (0, 5), (2, 3): Bit 1: Unset
    "ld1 { v9.s }[0], [x23], #0x4\n"
    "ld1 { v10.s }[0], [x22], #0x4\n"
    "ld1 { v11.s }[0], [x21], #0x4\n"
    "ld1 { v12.s }[0], [x20], #0x4\n"
    "5:"  // Oddments: Load inputs (2, 2), (0, 0), (0, 5), (2, 3): Bit 1: End
    "mov v16.16b, v30.16b\n fmla v16.4s, v8.4s, v9.4s\n"
    "mov v17.16b, v30.16b\n fmla v17.4s, v7.4s, v9.4s\n"
    "ldr x20, [x16, #0x20]\n"
    "mov v18.16b, v30.16b\n fmla v18.4s, v6.4s, v9.4s\n"
    "mov v21.16b, v30.16b\n fmla v21.4s, v4.4s, v9.4s\n"
    "mov v22.16b, v30.16b\n fmla v22.4s, v3.4s, v9.4s\n"
    "mov v25.16b, v30.16b\n fmla v25.4s, v1.4s, v9.4s\n"
    "mov v26.16b, v30.16b\n fmla v26.4s, v0.4s, v9.4s\n"
    "mov v19.16b, v30.16b\n fmla v19.4s, v2.4s, v11.4s\n"
    "add x20, x20, x15\n"
    "mov v20.16b, v30.16b\n fmla v20.4s, v5.4s, v9.4s\n"
    "mov v24.16b, v30.16b\n fmla v24.4s, v2.4s, v9.4s\n"
    "fmla v16.4s, v0.4s, v10.4s\n"
    "fmla v17.4s, v8.4s, v12.4s\n"
    "fmla v18.4s, v7.4s, v12.4s\n"
    "fmla v21.4s, v5.4s, v12.4s\n"
    "fmla v19.4s, v6.4s, v12.4s\n"
    "fmla v22.4s, v4.4s, v12.4s\n"
    "mov v23.16b, v30.16b\n fmla v23.4s, v3.4s, v12.4s\n"
    "fmla v25.4s, v2.4s, v12.4s\n"
    "fmla v26.4s, v1.4s, v12.4s\n"
    "mov v27.16b, v30.16b\n fmla v27.4s, v0.4s, v12.4s\n"
    "tbz %x[n_channels], #1, 6f\n"
    "ld1 { v10.d }[0], [x20], #0x8\n"
    "tbz %x[n_channels], #0, 7f\n"
    "ld1 { v10.s }[2], [x20], #0x4\n"
    "b 7f\n"
    "6:"  // Oddments: Load input (5, 0): Bit 1: Unset
    "ld1 { v10.s }[0], [x20], #0x4\n"
    "7:"  // Oddments: Load input (5, 0): Bit 1: End
    "ldr x20, [x16, #0x28]\n"
    "mov v28.16b, v30.16b\n fmla v28.4s, v6.4s, v10.4s\n"
    "add x20, x20, x15\n"
    "tbz %x[n_channels], #1, 8f\n"
    "ld1 { v11.d }[0], [x20], #0x8\n"
    "tbz %x[n_channels], #0, 9f\n"
    "ld1 { v11.s }[2], [x20], #0x4\n"
    "b 9f\n"
    "8:"  // Oddments: Load input (5, 5): Bit 1: Unset
    "ld1 { v11.s }[0], [x20], #0x4\n"
    "9:"  // Oddments: Load input (5, 5): Bit 1: End
    "ldr x20, [x16, #0x30]\n"
    "mov v31.16b, v30.16b\n fmla v31.4s, v8.4s, v11.4s\n"
    "add x20, x20, x15\n"
    "tbz %x[n_channels], #1, 10f\n"
    "ld1 { v9.d }[0], [x20], #0x8\n"
    "tbz %x[n_channels], #0, 11f\n"
    "ld1 { v9.s }[2], [x20], #0x4\n"
    "b 11f\n"
    "10:"  // Oddments: Load input (3, 2): Bit 1: Unset
    "ld1 { v9.s }[0], [x20], #0x4\n"
    "11:"  // Oddments: Load input (3, 2): Bit 1: End
    "ldr x20, [x16, #0x38]\n"
    "fmla v20.4s, v8.4s, v9.4s\n"
    "fmla v21.4s, v7.4s, v9.4s\n"
    "fmla v22.4s, v6.4s, v9.4s\n"
    "fmla v24.4s, v5.4s, v9.4s\n"
    "fmla v25.4s, v4.4s, v9.4s\n"
    "fmla v26.4s, v3.4s, v9.4s\n"
    "fmla v28.4s, v2.4s, v9.4s\n"
    "mov v29.16b, v30.16b\n fmla v29.4s, v1.4s, v9.4s\n"
    "add x20, x20, x15\n"
    "fmla v30.4s, v0.4s, v9.4s\n"
    "tbz %x[n_channels], #1, 12f\n"
    "ld1 { v12.d }[0], [x20], #0x8\n"
    "tbz %x[n_channels], #0, 13f\n"
    "ld1 { v12.s }[2], [x20], #0x4\n"
    "b 13f\n"
    "12:"  // Oddments: Load input (0, 1): Bit 1: Unset
    "ld1 { v12.s }[0], [x20], #0x4\n"
    "13:"  // Oddments: Load input (0, 1): Bit 1: End
    "ldr x20, [x16, #0x40]\n"
    "fmla v16.4s, v1.4s, v12.4s\n"
    "fmla v17.4s, v0.4s, v12.4s\n"
    "add x20, x20, x15\n"
    "tbz %x[n_channels], #1, 14f\n"
    "ld1 { v11.d }[0], [x20], #0x8\n"
    "tbz %x[n_channels], #0, 15f\n"
    "ld1 { v11.s }[2], [x20], #0x4\n"
    "b 15f\n"
    "14:"  // Oddments: Load input (0, 4): Bit 1: Unset
    "ld1 { v11.s }[0], [x20], #0x4\n"
    "15:"  // Oddments: Load input (0, 4): Bit 1: End
    "ldr x20, [x16, #0x48]\n"
    "fmla v18.4s, v2.4s, v11.4s\n"
    "fmla v19.4s, v1.4s, v11.4s\n"
    "add x20, x20, x15\n"
    "tbz %x[n_channels], #1, 16f\n"
    "ld1 { v10.d }[0], [x20], #0x8\n"
    "tbz %x[n_channels], #0, 17f\n"
    "ld1 { v10.s }[2], [x20], #0x4\n"
    "b 17f\n"
    "16:"  // Oddments: Load input (3, 3): Bit 1: Unset
    "ld1 { v10.s }[0], [x20], #0x4\n"
    "17:"  // Oddments: Load input (3, 3): Bit 1: End
    "ldr x20, [x16, #0x50]\n"
    "fmla v21.4s, v8.4s, v10.4s\n"
    "fmla v22.4s, v7.4s, v10.4s\n"
    "fmla v23.4s, v6.4s, v10.4s\n"
    "fmla v25.4s, v5.4s, v10.4s\n"
    "fmla v26.4s, v4.4s, v10.4s\n"
    "fmla v27.4s, v3.4s, v10.4s\n"
    "fmla v29.4s, v2.4s, v10.4s\n"
    "fmla v30.4s, v1.4s, v10.4s\n"
    "add x20, x20, x15\n"
    "fmla v31.4s, v0.4s, v10.4s\n"
    "tbz %x[n_channels], #1, 18f\n"
    "ld1 { v9.d }[0], [x20], #0x8\n"
    "tbz %x[n_channels], #0, 19f\n"
    "ld1 { v9.s }[2], [x20], #0x4\n"
    "b 19f\n"
    "18:"  // Oddments: Load input (1, 0): Bit 1: Unset
    "ld1 { v9.s }[0], [x20], #0x4\n"
    "19:"  // Oddments: Load input (1, 0): Bit 1: End
    "ldr x20, [x16, #0x58]\n"
    "fmla v16.4s, v3.4s, v9.4s\n"
    "fmla v20.4s, v0.4s, v9.4s\n"
    "add x20, x20, x15\n"
    "tbz %x[n_channels], #1, 20f\n"
    "ld1 { v12.d }[0], [x20], #0x8\n"
    "tbz %x[n_channels], #0, 21f\n"
    "ld1 { v12.s }[2], [x20], #0x4\n"
    "b 21f\n"
    "20:"  // Oddments: Load input (1, 5): Bit 1: Unset
    "ld1 { v12.s }[0], [x20], #0x4\n"
    "21:"  // Oddments: Load input (1, 5): Bit 1: End
    "ldr x20, [x16, #0x60]\n"
    "fmla v19.4s, v5.4s, v12.4s\n"
    "fmla v23.4s, v2.4s, v12.4s\n"
    "add x20, x20, x15\n"
    "tbz %x[n_channels], #1, 22f\n"
    "ld1 { v11.d }[0], [x20], #0x8\n"
    "tbz %x[n_channels], #0, 23f\n"
    "ld1 { v11.s }[2], [x20], #0x4\n"
    "b 23f\n"
    "22:"  // Oddments: Load input (4, 0): Bit 1: Unset
    "ld1 { v11.s }[0], [x20], #0x4\n"
    "23:"  // Oddments: Load input (4, 0): Bit 1: End
    "ldr x20, [x16, #0x68]\n"
    "fmla v24.4s, v6.4s, v11.4s\n"
    "fmla v28.4s, v3.4s, v11.4s\n"
    "add x20, x20, x15\n"
    "tbz %x[n_channels], #1, 24f\n"
    "ld1 { v10.d }[0], [x20], #0x8\n"
    "tbz %x[n_channels], #0, 25f\n"
    "ld1 { v10.s }[2], [x20], #0x4\n"
    "b 25f\n"
    "24:"  // Oddments: Load input (1, 2): Bit 1: Unset
    "ld1 { v10.s }[0], [x20], #0x4\n"
    "25:"  // Oddments: Load input (1, 2): Bit 1: End
    "ldr x20, [x16, #0x70]\n"
    "fmla v16.4s, v5.4s, v10.4s\n"
    "fmla v17.4s, v4.4s, v10.4s\n"
    "fmla v18.4s, v3.4s, v10.4s\n"
    "fmla v20.4s, v2.4s, v10.4s\n"
    "fmla v21.4s, v1.4s, v10.4s\n"
    "fmla v22.4s, v0.4s, v10.4s\n"
    "add x20, x20, x15\n"
    "tbz %x[n_channels], #1, 26f\n"
    "ld1 { v11.d }[0], [x20], #0x8\n"
    "tbz %x[n_channels], #0, 27f\n"
    "ld1 { v11.s }[2], [x20], #0x4\n"
    "b 27f\n"
    "26:"  // Oddments: Load input (4, 5): Bit 1: Unset
    "ld1 { v11.s }[0], [x20], #0x4\n"
    "27:"  // Oddments: Load input (4, 5): Bit 1: End
    "ldr x20, [x16, #0x78]\n"
    "fmla v27.4s, v8.4s, v11.4s\n"
    "fmla v31.4s, v5.4s, v11.4s\n"
    "add x20, x20, x15\n"
    "tbz %x[n_channels], #1, 28f\n"
    "ld1 { v12.d }[0], [x20], #0x8\n"
    "tbz %x[n_channels], #0, 29f\n"
    "ld1 { v12.s }[2], [x20], #0x4\n"
    "b 29f\n"
    "28:"  // Oddments: Load input (1, 3): Bit 1: Unset
    "ld1 { v12.s }[0], [x20], #0x4\n"
    "29:"  // Oddments: Load input (1, 3): Bit 1: End
    "ldr x20, [x16, #0x80]\n"
    "fmla v17.4s, v5.4s, v12.4s\n"
    "fmla v18.4s, v4.4s, v12.4s\n"
    "fmla v19.4s, v3.4s, v12.4s\n"
    "fmla v21.4s, v2.4s, v12.4s\n"
    "fmla v22.4s, v1.4s, v12.4s\n"
    "fmla v23.4s, v0.4s, v12.4s\n"
    "add x20, x20, x15\n"
    "tbz %x[n_channels], #1, 30f\n"
    "ld1 { v11.d }[0], [x20], #0x8\n"
    "tbz %x[n_channels], #0, 31f\n"
    "ld1 { v11.s }[2], [x20], #0x4\n"
    "b 31f\n"
    "30:"  // Oddments: Load input (5, 1): Bit 1: Unset
    "ld1 { v11.s }[0], [x20], #0x4\n"
    "31:"  // Oddments: Load input (5, 1): Bit 1: End
    "ldr x20, [x16, #0x88]\n"
    "fmla v28.4s, v7.4s, v11.4s\n"
    "fmla v29.4s, v6.4s, v11.4s\n"
    "add x20, x20, x15\n"
    "tbz %x[n_channels], #1, 32f\n"
    "ld1 { v10.d }[0], [x20], #0x8\n"
    "tbz %x[n_channels], #0, 33f\n"
    "ld1 { v10.s }[2], [x20], #0x4\n"
    "b 33f\n"
    "32:"  // Oddments: Load input (2, 1): Bit 1: Unset
    "ld1 { v10.s }[0], [x20], #0x4\n"
    "33:"  // Oddments: Load input (2, 1): Bit 1: End
    "ldr x20, [x16, #0x90]\n"
    "fmla v16.4s, v7.4s, v10.4s\n"
    "fmla v17.4s, v6.4s, v10.4s\n"
    "fmla v20.4s, v4.4s, v10.4s\n"
    "fmla v21.4s, v3.4s, v10.4s\n"
    "fmla v24.4s, v1.4s, v10.4s\n"
    "fmla v25.4s, v0.4s, v10.4s\n"
    "add x20, x20, x15\n"
    "tbz %x[n_channels], #1, 34f\n"
    "ld1 { v11.d }[0], [x20], #0x8\n"
    "tbz %x[n_channels], #0, 35f\n"
    "ld1 { v11.s }[2], [x20], #0x4\n"
    "b 35f\n"
    "34:"  // Oddments: Load input (5, 4): Bit 1: Unset
    "ld1 { v11.s }[0], [x20], #0x4\n"
    "35:"  // Oddments: Load input (5, 4): Bit 1: End
    "ldr x20, [x16, #0x98]\n"
    "fmla v30.4s, v8.4s, v11.4s\n"
    "fmla v31.4s, v7.4s, v11.4s\n"
    "add x20, x20, x15\n"
    "tbz %x[n_channels], #1, 36f\n"
    "ld1 { v12.d }[0], [x20], #0x8\n"
    "tbz %x[n_channels], #0, 37f\n"
    "ld1 { v12.s }[2], [x20], #0x4\n"
    "b 37f\n"
    "36:"  // Oddments: Load input (2, 4): Bit 1: Unset
    "ld1 { v12.s }[0], [x20], #0x4\n"
    "37:"  // Oddments: Load input (2, 4): Bit 1: End
    "ldr x20, [x16, #0xa0]\n"
    "fmla v18.4s, v8.4s, v12.4s\n"
    "fmla v19.4s, v7.4s, v12.4s\n"
    "fmla v22.4s, v5.4s, v12.4s\n"
    "fmla v23.4s, v4.4s, v12.4s\n"
    "fmla v26.4s, v2.4s, v12.4s\n"
    "fmla v27.4s, v1.4s, v12.4s\n"
    "add x20, x20, x15\n"
    "tbz %x[n_channels], #1, 38f\n"
    "ld1 { v10.d }[0], [x20], #0x8\n"
    "tbz %x[n_channels], #0, 39f\n"
    "ld1 { v10.s }[2], [x20], #0x4\n"
    "b 39f\n"
    "38:"  // Oddments: Load input (0, 2): Bit 1: Unset
    "ld1 { v10.s }[0], [x20], #0x4\n"
    "39:"  // Oddments: Load input (0, 2): Bit 1: End
    "ldr x20, [x16, #0xa8]\n"
    "fmla v16.4s, v2.4s, v10.4s\n"
    "fmla v17.4s, v1.4s, v10.4s\n"
    "fmla v18.4s, v0.4s, v10.4s\n"
    "add x20, x20, x15\n"
    "tbz %x[n_channels], #1, 40f\n"
    "ld1 { v11.d }[0], [x20], #0x8\n"
    "tbz %x[n_channels], #0, 41f\n"
    "ld1 { v11.s }[2], [x20], #0x4\n"
    "b 41f\n"
    "40:"  // Oddments: Load input (3, 1): Bit 1: Unset
    "ld1 { v11.s }[0], [x20], #0x4\n"
    "41:"  // Oddments: Load input (3, 1): Bit 1: End
    "ldr x20, [x16, #0xb0]\n"
    "fmla v20.4s, v7.4s, v11.4s\n"
    "fmla v21.4s, v6.4s, v11.4s\n"
    "fmla v24.4s, v4.4s, v11.4s\n"
    "fmla v25.4s, v3.4s, v11.4s\n"
    "fmla v28.4s, v1.4s, v11.4s\n"
    "fmla v29.4s, v0.4s, v11.4s\n"
    "add x20, x20, x15\n"
    "tbz %x[n_channels], #1, 42f\n"
    "ld1 { v12.d }[0], [x20], #0x8\n"
    "tbz %x[n_channels], #0, 43f\n"
    "ld1 { v12.s }[2], [x20], #0x4\n"
    "b 43f\n"
    "42:"  // Oddments: Load input (0, 3): Bit 1: Unset
    "ld1 { v12.s }[0], [x20], #0x4\n"
    "43:"  // Oddments: Load input (0, 3): Bit 1: End
    "ldr x20, [x16, #0xb8]\n"
    "fmla v17.4s, v2.4s, v12.4s\n"
    "fmla v18.4s, v1.4s, v12.4s\n"
    "fmla v19.4s, v0.4s, v12.4s\n"
    "add x20, x20, x15\n"
    "tbz %x[n_channels], #1, 44f\n"
    "ld1 { v10.d }[0], [x20], #0x8\n"
    "tbz %x[n_channels], #0, 45f\n"
    "ld1 { v10.s }[2], [x20], #0x4\n"
    "b 45f\n"
    "44:"  // Oddments: Load input (2, 0): Bit 1: Unset
    "ld1 { v10.s }[0], [x20], #0x4\n"
    "45:"  // Oddments: Load input (2, 0): Bit 1: End
    "ldr x20, [x16, #0xc0]\n"
    "fmla v16.4s, v6.4s, v10.4s\n"
    "fmla v20.4s, v3.4s, v10.4s\n"
    "fmla v24.4s, v0.4s, v10.4s\n"
    "add x20, x20, x15\n"
    "tbz %x[n_channels], #1, 46f\n"
    "ld1 { v11.d }[0], [x20], #0x8\n"
    "tbz %x[n_channels], #0, 47f\n"
    "ld1 { v11.s }[2], [x20], #0x4\n"
    "b 47f\n"
    "46:"  // Oddments: Load input (3, 4): Bit 1: Unset
    "ld1 { v11.s }[0], [x20], #0x4\n"
    "47:"  // Oddments: Load input (3, 4): Bit 1: End
    "ldr x20, [x16, #0xc8]\n"
    "fmla v22.4s, v8.4s, v11.4s\n"
    "fmla v23.4s, v7.4s, v11.4s\n"
    "fmla v26.4s, v5.4s, v11.4s\n"
    "fmla v27.4s, v4.4s, v11.4s\n"
    "fmla v30.4s, v2.4s, v11.4s\n"
    "fmla v31.4s, v1.4s, v11.4s\n"
    "add x20, x20, x15\n"
    "tbz %x[n_channels], #1, 48f\n"
    "ld1 { v12.d }[0], [x20], #0x8\n"
    "tbz %x[n_channels], #0, 49f\n"
    "ld1 { v12.s }[2], [x20], #0x4\n"
    "b 49f\n"
    "48:"  // Oddments: Load input (2, 5): Bit 1: Unset
    "ld1 { v12.s }[0], [x20], #0x4\n"
    "49:"  // Oddments: Load input (2, 5): Bit 1: End
    "ldr x20, [x16, #0xd0]\n"
    "fmla v19.4s, v8.4s, v12.4s\n"
    "fmla v23.4s, v5.4s, v12.4s\n"
    "fmla v27.4s, v2.4s, v12.4s\n"
    "add x20, x20, x15\n"
    "tbz %x[n_channels], #1, 50f\n"
    "ld1 { v10.d }[0], [x20], #0x8\n"
    "tbz %x[n_channels], #0, 51f\n"
    "ld1 { v10.s }[2], [x20], #0x4\n"
    "b 51f\n"
    "50:"  // Oddments: Load input (3, 0): Bit 1: Unset
    "ld1 { v10.s }[0], [x20], #0x4\n"
    "51:"  // Oddments: Load input (3, 0): Bit 1: End
    "ldr x20, [x16, #0xd8]\n"
    "fmla v20.4s, v6.4s, v10.4s\n"
    "fmla v24.4s, v3.4s, v10.4s\n"
    "fmla v28.4s, v0.4s, v10.4s\n"
    "add x20, x20, x15\n"
    "tbz %x[n_channels], #1, 52f\n"
    "ld1 { v11.d }[0], [x20], #0x8\n"
    "tbz %x[n_channels], #0, 53f\n"
    "ld1 { v11.s }[2], [x20], #0x4\n"
    "b 53f\n"
    "52:"  // Oddments: Load input (4, 2): Bit 1: Unset
    "ld1 { v11.s }[0], [x20], #0x4\n"
    "53:"  // Oddments: Load input (4, 2): Bit 1: End
    "ldr x20, [x16, #0xe0]\n"
    "fmla v24.4s, v8.4s, v11.4s\n"
    "fmla v25.4s, v7.4s, v11.4s\n"
    "fmla v26.4s, v6.4s, v11.4s\n"
    "fmla v28.4s, v5.4s, v11.4s\n"
    "fmla v29.4s, v4.4s, v11.4s\n"
    "fmla v30.4s, v3.4s, v11.4s\n"
    "add x20, x20, x15\n"
    "tbz %x[n_channels], #1, 54f\n"
    "ld1 { v12.d }[0], [x20], #0x8\n"
    "tbz %x[n_channels], #0, 55f\n"
    "ld1 { v12.s }[2], [x20], #0x4\n"
    "b 55f\n"
    "54:"  // Oddments: Load input (3, 5): Bit 1: Unset
    "ld1 { v12.s }[0], [x20], #0x4\n"
    "55:"  // Oddments: Load input (3, 5): Bit 1: End
    "ldr x20, [x16, #0xe8]\n"
    "fmla v23.4s, v8.4s, v12.4s\n"
    "fmla v27.4s, v5.4s, v12.4s\n"
    "fmla v31.4s, v2.4s, v12.4s\n"
    "add x20, x20, x15\n"
    "tbz %x[n_channels], #1, 56f\n"
    "ld1 { v10.d }[0], [x20], #0x8\n"
    "tbz %x[n_channels], #0, 57f\n"
    "ld1 { v10.s }[2], [x20], #0x4\n"
    "b 57f\n"
    "56:"  // Oddments: Load input (5, 2): Bit 1: Unset
    "ld1 { v10.s }[0], [x20], #0x4\n"
    "57:"  // Oddments: Load input (5, 2): Bit 1: End
    "ldr x20, [x16, #0xf0]\n"
    "fmla v28.4s, v8.4s, v10.4s\n"
    "fmla v29.4s, v7.4s, v10.4s\n"
    "fmla v30.4s, v6.4s, v10.4s\n"
    "add x20, x20, x15\n"
    "tbz %x[n_channels], #1, 58f\n"
    "ld1 { v11.d }[0], [x20], #0x8\n"
    "tbz %x[n_channels], #0, 59f\n"
    "ld1 { v11.s }[2], [x20], #0x4\n"
    "b 59f\n"
    "58:"  // Oddments: Load input (4, 3): Bit 1: Unset
    "ld1 { v11.s }[0], [x20], #0x4\n"
    "59:"  // Oddments: Load input (4, 3): Bit 1: End
    "ldr x20, [x16, #0xf8]\n"
    "fmla v25.4s, v8.4s, v11.4s\n"
    "fmla v26.4s, v7.4s, v11.4s\n"
    "fmla v27.4s, v6.4s, v11.4s\n"
    "fmla v29.4s, v5.4s, v11.4s\n"
    "fmla v30.4s, v4.4s, v11.4s\n"
    "fmla v31.4s, v3.4s, v11.4s\n"
    "add x20, x20, x15\n"
    "tbz %x[n_channels], #1, 60f\n"
    "ld1 { v12.d }[0], [x20], #0x8\n"
    "tbz %x[n_channels], #0, 61f\n"
    "ld1 { v12.s }[2], [x20], #0x4\n"
    "b 61f\n"
    "60:"  // Oddments: Load input (5, 3): Bit 1: Unset
    "ld1 { v12.s }[0], [x20], #0x4\n"
    "61:"  // Oddments: Load input (5, 3): Bit 1: End
    "ldr x20, [x16, #0x100]\n"
    "fmla v29.4s, v8.4s, v12.4s\n"
    "fmla v30.4s, v7.4s, v12.4s\n"
    "fmla v31.4s, v6.4s, v12.4s\n"
    "add x20, x20, x15\n"
    "tbz %x[n_channels], #1, 62f\n"
    "ld1 { v10.d }[0], [x20], #0x8\n"
    "tbz %x[n_channels], #0, 63f\n"
    "ld1 { v10.s }[2], [x20], #0x4\n"
    "b 63f\n"
    "62:"  // Oddments: Load input (1, 1): Bit 1: Unset
    "ld1 { v10.s }[0], [x20], #0x4\n"
    "63:"  // Oddments: Load input (1, 1): Bit 1: End
    "ldr x20, [x16, #0x108]\n"
    "fmla v16.4s, v4.4s, v10.4s\n"
    "fmla v17.4s, v3.4s, v10.4s\n"
    "fmla v20.4s, v1.4s, v10.4s\n"
    "fmla v21.4s, v0.4s, v10.4s\n"
    "add x20, x20, x15\n"
    "tbz %x[n_channels], #1, 64f\n"
    "ld1 { v11.d }[0], [x20], #0x8\n"
    "tbz %x[n_channels], #0, 65f\n"
    "ld1 { v11.s }[2], [x20], #0x4\n"
    "b 65f\n"
    "64:"  // Oddments: Load input (1, 4): Bit 1: Unset
    "ld1 { v11.s }[0], [x20], #0x4\n"
    "65:"  // Oddments: Load input (1, 4): Bit 1: End
    "ldr x20, [x16, #0x110]\n"
    "fmla v18.4s, v5.4s, v11.4s\n"
    "fmla v19.4s, v4.4s, v11.4s\n"
    "fmla v22.4s, v2.4s, v11.4s\n"
    "fmla v23.4s, v1.4s, v11.4s\n"
    "add x20, x20, x15\n"
    "tbz %x[n_channels], #1, 66f\n"
    "ld1 { v12.d }[0], [x20], #0x8\n"
    "tbz %x[n_channels], #0, 67f\n"
    "ld1 { v12.s }[2], [x20], #0x4\n"
    "b 67f\n"
    "66:"  // Oddments: Load input (4, 1): Bit 1: Unset
    "ld1 { v12.s }[0], [x20], #0x4\n"
    "67:"  // Oddments: Load input (4, 1): Bit 1: End
    "ldr x20, [x16, #0x118]\n"
    "fmla v24.4s, v7.4s, v12.4s\n"
    "fmla v25.4s, v6.4s, v12.4s\n"
    "fmla v28.4s, v4.4s, v12.4s\n"
    "fmla v29.4s, v3.4s, v12.4s\n"
    "add x20, x20, x15\n"
    "tbz %x[n_channels], #1, 68f\n"
    "ld1 { v10.d }[0], [x20], #0x8\n"
    "tbz %x[n_channels], #0, 69f\n"
    "ld1 { v10.s }[2], [x20], #0x4\n"
    "b 69f\n"
    "68:"  // Oddments: Load input (4, 4): Bit 1: Unset
    "ld1 { v10.s }[0], [x20], #0x4\n"
    "69:"  // Oddments: Load input (4, 4): Bit 1: End
    "fmla v26.4s, v8.4s, v10.4s\n"
    "fmla v27.4s, v7.4s, v10.4s\n"
    "fmax v16.4s, v16.4s, v15.4s\n"
    "fmla v30.4s, v5.4s, v10.4s\n"
    "fmla v31.4s, v4.4s, v10.4s\n"
    "fmax v17.4s, v17.4s, v15.4s\n"
    "fmax v18.4s, v18.4s, v15.4s\n"
    "fmax v19.4s, v19.4s, v15.4s\n"
    "fmax v20.4s, v20.4s, v15.4s\n"
    "fmax v21.4s, v21.4s, v15.4s\n"
    "fmax v22.4s, v22.4s, v15.4s\n"
    "fmax v23.4s, v23.4s, v15.4s\n"
    "fmax v24.4s, v24.4s, v15.4s\n"
    "fmax v25.4s, v25.4s, v15.4s\n"
    "fmax v26.4s, v26.4s, v15.4s\n"
    "fmax v27.4s, v27.4s, v15.4s\n"
    "fmax v28.4s, v28.4s, v15.4s\n"
    "fmax v29.4s, v29.4s, v15.4s\n"
    "fmax v30.4s, v30.4s, v15.4s\n"
    "fmax v31.4s, v31.4s, v15.4s\n"
    "fmin v16.4s, v16.4s, v14.4s\n"
    "fmin v17.4s, v17.4s, v14.4s\n"
    "fmin v18.4s, v18.4s, v14.4s\n"
    "fmin v19.4s, v19.4s, v14.4s\n"
    "fmin v20.4s, v20.4s, v14.4s\n"
    "fmin v21.4s, v21.4s, v14.4s\n"
    "fmin v22.4s, v22.4s, v14.4s\n"
    "fmin v23.4s, v23.4s, v14.4s\n"
    "fmin v24.4s, v24.4s, v14.4s\n"
    "fmin v25.4s, v25.4s, v14.4s\n"
    "fmin v26.4s, v26.4s, v14.4s\n"
    "fmin v27.4s, v27.4s, v14.4s\n"
    "fmin v28.4s, v28.4s, v14.4s\n"
    "fmin v29.4s, v29.4s, v14.4s\n"
    "fmin v30.4s, v30.4s, v14.4s\n"
    "fmin v31.4s, v31.4s, v14.4s\n"
    "tbz %x[n_channels], #1, 70f\n"
    "ldr x23, [x8, #0x0]\n"
    "ldr x22, [x8, #0x8]\n"
    "ldr x21, [x8, #0x10]\n"
    "ldr x20, [x8, #0x18]\n"
    "add x23, x23, x14\n"
    "st1 { v16.d }[0], [x23]\n"
    "ldr x23, [x8, #0x20]\n"
    "add x22, x22, x14\n"
    "st1 { v17.d }[0], [x22]\n"
    "ldr x22, [x8, #0x28]\n"
    "add x21, x21, x14\n"
    "add x20, x20, x14\n"
    "st1 { v18.d }[0], [x21]\n"
    "ldr x21, [x8, #0x30]\n"
    "st1 { v19.d }[0], [x20]\n"
    "ldr x20, [x8, #0x38]\n"
    "add x23, x23, x14\n"
    "add x22, x22, x14\n"
    "st1 { v20.d }[0], [x23]\n"
    "ldr x23, [x8, #0x40]\n"
    "add x21, x21, x14\n"
    "st1 { v21.d }[0], [x22]\n"
    "ldr x22, [x8, #0x48]\n"
    "add x20, x20, x14\n"
    "st1 { v22.d }[0], [x21]\n"
    "ldr x21, [x8, #0x50]\n"
    "st1 { v23.d }[0], [x20]\n"
    "ldr x20, [x8, #0x58]\n"
    "add x23, x23, x14\n"
    "add x22, x22, x14\n"
    "st1 { v24.d }[0], [x23]\n"
    "ldr x23, [x8, #0x60]\n"
    "add x21, x21, x14\n"
    "st1 { v25.d }[0], [x22]\n"
    "ldr x22, [x8, #0x68]\n"
    "add x20, x20, x14\n"
    "st1 { v26.d }[0], [x21]\n"
    "ldr x21, [x8, #0x70]\n"
    "st1 { v27.d }[0], [x20]\n"
    "ldr x20, [x8, #0x78]\n"
    "add x23, x23, x14\n"
    "add x22, x22, x14\n"
    "st1 { v28.d }[0], [x23]\n"
    "add x21, x21, x14\n"
    "st1 { v29.d }[0], [x22]\n"
    "add x20, x20, x14\n"
    "add x14, x14, #0x8\n"
    "st1 { v30.d }[0], [x21]\n"
    "st1 { v31.d }[0], [x20]\n"
    "tbz %x[n_channels], #0, 71f\n"
    "ldr x23, [x8, #0x0]\n"
    "ldr x22, [x8, #0x8]\n"
    "ldr x21, [x8, #0x10]\n"
    "ldr x20, [x8, #0x18]\n"
    "add x23, x23, x14\n"
    "st1 { v16.s }[2], [x23]\n"
    "ldr x23, [x8, #0x20]\n"
    "add x22, x22, x14\n"
    "st1 { v17.s }[2], [x22]\n"
    "ldr x22, [x8, #0x28]\n"
    "add x21, x21, x14\n"
    "add x20, x20, x14\n"
    "st1 { v18.s }[2], [x21]\n"
    "ldr x21, [x8, #0x30]\n"
    "st1 { v19.s }[2], [x20]\n"
    "ldr x20, [x8, #0x38]\n"
    "add x23, x23, x14\n"
    "add x22, x22, x14\n"
    "st1 { v20.s }[2], [x23]\n"
    "ldr x23, [x8, #0x40]\n"
    "add x21, x21, x14\n"
    "st1 { v21.s }[2], [x22]\n"
    "ldr x22, [x8, #0x48]\n"
    "add x20, x20, x14\n"
    "st1 { v22.s }[2], [x21]\n"
    "ldr x21, [x8, #0x50]\n"
    "st1 { v23.s }[2], [x20]\n"
    "ldr x20, [x8, #0x58]\n"
    "add x23, x23, x14\n"
    "add x22, x22, x14\n"
    "st1 { v24.s }[2], [x23]\n"
    "ldr x23, [x8, #0x60]\n"
    "add x21, x21, x14\n"
    "st1 { v25.s }[2], [x22]\n"
    "ldr x22, [x8, #0x68]\n"
    "add x20, x20, x14\n"
    "st1 { v26.s }[2], [x21]\n"
    "ldr x21, [x8, #0x70]\n"
    "st1 { v27.s }[2], [x20]\n"
    "ldr x20, [x8, #0x78]\n"
    "add x23, x23, x14\n"
    "add x22, x22, x14\n"
    "st1 { v28.s }[2], [x23]\n"
    "add x21, x21, x14\n"
    "st1 { v29.s }[2], [x22]\n"
    "add x20, x20, x14\n"
    "st1 { v30.s }[2], [x21]\n"
    "st1 { v31.s }[2], [x20]\n"
    "b 71f\n"
    "70:"  // Oddments: Store: Bit 1: Unset
    "ldr x23, [x8, #0x0]\n"
    "ldr x22, [x8, #0x8]\n"
    "ldr x21, [x8, #0x10]\n"
    "ldr x20, [x8, #0x18]\n"
    "add x23, x23, x14\n"
    "st1 { v16.s }[0], [x23]\n"
    "ldr x23, [x8, #0x20]\n"
    "add x22, x22, x14\n"
    "st1 { v17.s }[0], [x22]\n"
    "ldr x22, [x8, #0x28]\n"
    "add x21, x21, x14\n"
    "add x20, x20, x14\n"
    "st1 { v18.s }[0], [x21]\n"
    "ldr x21, [x8, #0x30]\n"
    "st1 { v19.s }[0], [x20]\n"
    "ldr x20, [x8, #0x38]\n"
    "add x23, x23, x14\n"
    "add x22, x22, x14\n"
    "st1 { v20.s }[0], [x23]\n"
    "ldr x23, [x8, #0x40]\n"
    "add x21, x21, x14\n"
    "st1 { v21.s }[0], [x22]\n"
    "ldr x22, [x8, #0x48]\n"
    "add x20, x20, x14\n"
    "st1 { v22.s }[0], [x21]\n"
    "ldr x21, [x8, #0x50]\n"
    "st1 { v23.s }[0], [x20]\n"
    "ldr x20, [x8, #0x58]\n"
    "add x23, x23, x14\n"
    "add x22, x22, x14\n"
    "st1 { v24.s }[0], [x23]\n"
    "ldr x23, [x8, #0x60]\n"
    "add x21, x21, x14\n"
    "st1 { v25.s }[0], [x22]\n"
    "ldr x22, [x8, #0x68]\n"
    "add x20, x20, x14\n"
    "st1 { v26.s }[0], [x21]\n"
    "ldr x21, [x8, #0x70]\n"
    "st1 { v27.s }[0], [x20]\n"
    "ldr x20, [x8, #0x78]\n"
    "add x23, x23, x14\n"
    "add x22, x22, x14\n"
    "st1 { v28.s }[0], [x23]\n"
    "add x21, x21, x14\n"
    "st1 { v29.s }[0], [x22]\n"
    "add x20, x20, x14\n"
    "st1 { v30.s }[0], [x21]\n"
    "st1 { v31.s }[0], [x20]\n"
    "71:"  // Oddments: Store: Bit 1: End
    "72:"  // End
    :
    : [n_channels] "r" ((unsigned long) n_channels), [offsetof_Args_inptrs] "I" (offsetof(Args, inptrs)), [offsetof_args_max] "I" (offsetof(Args, max)), [offsetof_args_min] "I" (offsetof(Args, min)), [offsetof_args_outptrs] "I" (offsetof(Args, outptrs)), [offsetof_args_params] "I" (offsetof(Args, params)), [params_struct] "r" (&params_struct)
    : "cc", "memory", "v0", "v1", "v2", "v3", "v4", "v5", "v6", "v7", "v8", "v9", "v10", "v11", "v12", "v13", "v14", "v15", "v16", "v17", "v18", "v19", "v20", "v21", "v22", "v23", "v24", "v25", "v26", "v27", "v28", "v29", "v30", "v31", "x6", "x7", "x8", "x9", "x10", "x11", "x12", "x13", "x14", "x15", "x16", "x17", "x20", "x21", "x22", "x23", "x24", "x25", "x26", "x27", "x28"
  );
}

}  // namespace depthwise
}  // namespace arm_conv

#endif  // defined(__aarch64__)
