/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runner;

import java.util.ArrayList;
import junit.framework.Test;
import junit.runner.Version;
import org.junit.internal.runners.OldTestClassRunner;
import org.junit.internal.runners.TextListener;
import org.junit.runner.Description;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitCore {
    private RunNotifier fNotifier = new RunNotifier();

    public static void main(String ... args) {
        Result result = new JUnitCore().runMain(args);
        JUnitCore.killAllThreads(result);
    }

    private static void killAllThreads(Result result) {
        System.exit(result.wasSuccessful() ? 0 : 1);
    }

    public static Result runClasses(Class<?> ... classes) {
        return new JUnitCore().run(classes);
    }

    public Result runMain(String ... args) {
        System.out.println("JUnit version " + Version.id());
        ArrayList classes = new ArrayList();
        ArrayList<Failure> missingClasses = new ArrayList<Failure>();
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String each = stringArray[n2];
            try {
                classes.add(Class.forName(each));
            }
            catch (ClassNotFoundException e) {
                System.out.println("Could not find class: " + each);
                Description description = Description.createSuiteDescription(each);
                Failure failure = new Failure(description, e);
                missingClasses.add(failure);
            }
            ++n2;
        }
        TextListener listener = new TextListener();
        this.addListener(listener);
        Result result = this.run(classes.toArray(new Class[0]));
        for (Failure each : missingClasses) {
            result.getFailures().add(each);
        }
        return result;
    }

    public String getVersion() {
        return Version.id();
    }

    public Result run(Class<?> ... classes) {
        return this.run(Request.classes("All", classes));
    }

    public Result run(Request request) {
        return this.run(request.getRunner());
    }

    public Result run(Test test) {
        return this.run(new OldTestClassRunner(test));
    }

    public Result run(Runner runner) {
        Result result = new Result();
        RunListener listener = result.createListener();
        this.addFirstListener(listener);
        try {
            this.fNotifier.fireTestRunStarted(runner.getDescription());
            runner.run(this.fNotifier);
            this.fNotifier.fireTestRunFinished(result);
        }
        finally {
            this.removeListener(listener);
        }
        return result;
    }

    private void addFirstListener(RunListener listener) {
        this.fNotifier.addFirstListener(listener);
    }

    public void addListener(RunListener listener) {
        this.fNotifier.addListener(listener);
    }

    public void removeListener(RunListener listener) {
        this.fNotifier.removeListener(listener);
    }
}

