/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.requests;

import junit.framework.TestCase;
import org.junit.Ignore;
import org.junit.internal.requests.IgnoredClassRunner;
import org.junit.internal.runners.InitializationError;
import org.junit.internal.runners.OldTestClassRunner;
import org.junit.internal.runners.TestClassRunner;
import org.junit.runner.Request;
import org.junit.runner.RunWith;
import org.junit.runner.Runner;
import org.junit.runners.AllTests;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassRequest
extends Request {
    private static final String CONSTRUCTOR_ERROR_FORMAT = "Custom runner class %s should have a public constructor with signature %s(Class testClass)";
    private final Class<?> fTestClass;
    private boolean fCanUseSuiteMethod;

    public ClassRequest(Class<?> testClass, boolean canUseSuiteMethod) {
        this.fTestClass = testClass;
        this.fCanUseSuiteMethod = canUseSuiteMethod;
    }

    public ClassRequest(Class<?> testClass) {
        this(testClass, true);
    }

    @Override
    public Runner getRunner() {
        return this.buildRunner(this.getRunnerClass(this.fTestClass));
    }

    public Runner buildRunner(Class<? extends Runner> runnerClass) {
        try {
            return runnerClass.getConstructor(Class.class).newInstance(this.fTestClass);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String simpleName = runnerClass.getSimpleName();
            InitializationError error = new InitializationError(String.format(CONSTRUCTOR_ERROR_FORMAT, simpleName, simpleName));
            return Request.errorReport(this.fTestClass, error).getRunner();
        }
        catch (Exception e) {
            return Request.errorReport(this.fTestClass, e).getRunner();
        }
    }

    Class<? extends Runner> getRunnerClass(Class<?> testClass) {
        if (testClass.getAnnotation(Ignore.class) != null) {
            return new IgnoredClassRunner(testClass).getClass();
        }
        RunWith annotation = testClass.getAnnotation(RunWith.class);
        if (annotation != null) {
            return annotation.value();
        }
        if (this.hasSuiteMethod() && this.fCanUseSuiteMethod) {
            return AllTests.class;
        }
        if (this.isPre4Test(testClass)) {
            return OldTestClassRunner.class;
        }
        return TestClassRunner.class;
    }

    public boolean hasSuiteMethod() {
        try {
            this.fTestClass.getMethod("suite", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        return true;
    }

    boolean isPre4Test(Class<?> testClass) {
        return TestCase.class.isAssignableFrom(testClass);
    }
}

