#!/usr/bin/env bash

if [ ! -e /dev/kfd ]
then
	echo "/dev/kfd not present, system either lacks AMD GPU or AMDGPU driver is not loaded."
	echo "Skipping tests."
	# Magic number to signal 'skipped'
	exit 77
elif [ "$(id -u)" != "0" ] && [ ! -r /dev/kfd ]
then
	echo "/dev/kfd present but no read permission."
	echo "Skipping tests."
	exit 77
fi

which amd-smi

amd-smi --help
amd-smi version
amd-smi list
amd-smi static
amd-smi metric
amd-smi topology
amd-smi monitor

