'\" 
'\" $Id: auth.n,v 1.2 2007/02/27 13:04:48 pda Exp $
'\" 
'\" Copyright (c) 2003 by Pierre David <Pierre.David@crc.u-strasbg.fr>
'\" All rights reserved.
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH auth n 1.0 Auth "Authentication system access functions"
.BS
'\" Note: do not modify the .SH NAME line immediately below!
.SH NAME
::auth \- Authentication package
.SH SYNOPSIS
\fBpackage require Tcl 8\fR
.sp
\fBpackage require auth ?1.0?\fR
.sp
\fB::auth::init\fR \fIaccess\fR
.sp
\fB::auth::close\fR
.sp
\fB::auth::crypt\fR \fIstring\fR
.sp
\fB::auth::genpw\fR
.sp
\fB::auth::getuser\fR \fIlogin\fR \fIarray\fR
.sp
\fB::auth::setuser\fR \fIarray\fR
.sp
\fB::auth::deluser\fR \fIlogin\fR ?\fItransact\fR?
.sp
\fB::auth::searchuser\fR \fIcritarray\fR ?\fIsortkeys\fR?
.sp
\fB::auth::lsgroup\fR \fIarray\fR
.sp
\fB::auth::addgroup\fR \fIname\fR \fIdescr\fR \fImsg\fR
.sp
\fB::auth::delgroup\fR \fIname\fR \fImsg\fR
.sp
\fB::auth::setgroup\fR \fIname\fR \fIdescr\fR \fImembers\fR \fImsg\fR
.BE
.SH DESCRIPTION
.PP
This package provides procedures to access the authentication subsystem.
.TP
\fB::auth::init\fR \fIaccess\fR
Initializes the authentication subsystem. The parameter \fIaccess\fR
is a list of two elements: the \fImethod\fR and the \fIkey\fR. The
signification of the \fIkey\fR depends upon the \fImethod\fR. Available
\fImethod\fR values are:
.RS
.TP
\fBpostgresql\fR
user and group informations are stored in a PostgreSQL database.
The \fIkey\fR value is a database connection string such as,
for example,
\fB{dbname=auth user=pda password=xyztuv}\fR. See the PostgreSQL
documentation for more information.
.PP
No other method is available at this time.
.RE
.TP
\fB::auth::close\fR
Flushes all modifications, and ends access to the authentication
subsystem.
.TP
\fB::auth::crypt\fR \fIstring\fR
Returns a crypted \fIstring\fR.
.TP
\fB::auth::genpw\fR
Generates a semi-random password, and returns its value un-encrypted.
Notice: this functions calls an external program \fBpwgen\fR (available
on FreeBSD as the sysutils/pwgen port).
.TP
\fB::auth::getuser\fR \fIlogin\fR \fIarray\fR
Returns all information stored about a user, specified by its
\fIlogin\fR. Informations are returned in the \fIarray\fR (which
must be empty). Affected fields are:
.RS
.TP
\fIarray\fR(\fBlogin\fR)
login name.
.TP
\fIarray\fR(\fBnom\fR)
first name.
.TP
\fIarray\fR(\fBprenom\fR)
christian name.
.TP
\fIarray\fR(\fBmel\fR)
e-mail address.
.TP
\fIarray\fR(\fBtel\fR)
telephone number.
.TP
\fIarray\fR(\fBfax\fR)
fax number.
.TP
\fIarray\fR(\fBmobile\fR)
mobile phone number.
.TP
\fIarray\fR(\fBadr\fR)
postal address.
.TP
\fIarray\fR(\fBpassword\fR)
encrypted password.
.TP
\fIarray\fR(\fBgroupes\fR)
list of all groups this user belongs to.
.PP
If the user is found, this function returns 1. Else or if an error
occurred, this function returns 0.
.RE
.TP
\fB::auth::setuser\fR \fIarray\fR
Creates an entry for the given user, or modifies all informations if
(s)he already exists. Information about the user are specified by the
\fIarray\fR parameter (see the \fB::auth::getuser\fR function).
This function returns the empty string if no error occured, or an error
message.
.TP
\fB::auth::deluser\fR \fIlogin\fR ?\fItransact\fR?
Remove the user specified by its \fIlogin\fR from the authentication
subsystem (including his/her group membership).
The \fItransact\fR parameter specifies if the deletion
must be in a SQL transaction (if applies) depending upon its value:
"\fBtransaction\fR" (default) or "\fBpas de transaction\fR".
This function returns the empty string if no error occured, or an error
message.
.TP
\fB::auth::searchuser\fR \fIcritarray\fR ?\fIsortkeys\fR?
Search the authentication subsystem for a list of login names. The
\fIcritarray\fR specifies the search criteria:
.RS
\fIcritarray\fR(\fBlogin\fR)
login name
.TP
\fIcritarray\fR(\fBnom\fR)
first name
.TP
\fIcritarray\fR(\fBprenom\fR)
christian name
.TP
\fIcritarray\fR(\fBmel\fR)
e-mail address
.TP
\fIcritarray\fR(\fBtel\fR)
telephone number
.TP
\fIcritarray\fR(\fBfax\fR)
fax number
.TP
\fIcritarray\fR(\fBmobile\fR)
mobile phone number
.TP
\fIcritarray\fR(\fBadr\fR)
postal address.
.TP
\fIcritarray\fR(\fBgroupe\fR)
a group name
.RE
.RS
.PP
Each criterium is a anchored pattern, with shell-like regular
expressions (special characters are \fB*\fR and \fB?\fR).
.PP
The returned list is sorted according to \fIsortkeys\fR, which is itself
a list of sortkeys, each sortkey is of the form \fI+crit\fR or \fI-crit\fR
where \fB+\fR and \fB-\fR characters give the sorting order (ascendant
or descendant), and the \fIcrit\fR is one criterium, which must be one
of \fBlogin\fR, \fBnom\fR, \fBprenom\fR, \fBmel\fR, \fBtel\fR, \fBfax\fR,
\fBmobile\fR or \fBadr\fR.
.PP
The returned list is composed of login names.
.RE
.TP
\fB::auth::lsgroup\fR \fIarray\fR
Returns, with the \fIarray\fR parameter, all groups found in the
authentication subsystem. Each index of \fIarray\fR is a group name, and
\fIarray\fR(\fIgroup\fR) is a list containing the description of the
group as the first element, and the list of the login names of the
members as the second element.
This function returns 1 if no error occurred, or 0 if an error occurred.
.TP
\fB::auth::addgroup\fR \fIname\fR \fIdescr\fR \fImsg\fR
Adds a not yet existing group named \fIname\fR to the authentication
subsystem, with the \fIdescr\fR description.
This function returns 1 if it was successful. If an error occurred,
this function  returns 0 and the \fImsg\fR variable is set to the
error message.
.TP
\fB::auth::delgroup\fR \fIname\fR \fImsg\fR
Removes a group from the authentication subsystem.
This function returns 1 if it was successful. If an error occurred,
this function  returns 0 and the \fImsg\fR variable is set to the
error message.
.TP
\fB::auth::setgroup\fR \fIname\fR \fIdescr\fR \fImembers\fR \fImsg\fR
Updates a group in the authentication subsystem. The group is given by
its \fIname\fR, and may already exist. The new description is given by
the \fIdescr\fR parameter. Group membership is updated with the
\fImembers\fR list which must contains login names of all members.
This function returns 1 if it was successful. If an error occurred,
this function  returns 0 and the \fImsg\fR variable is set to the
error message.
.TP
\fB::auth::getconfig\fR \fIkey\fR
Returns the value associated with the \fIkey\fR, or the empty list
if the key is not defined.
.TP
\fB::auth::setconfig\fR \fIkey\fR \fIval\fR \fImsg\fR
Sets the value associated with the \fIkey\fR to \fIval\fR.
This function returns 1 if it was successful. If an error occurred,
this function  returns 0 and the \fImsg\fR variable is set to the
error message.
.SH "SEE ALSO"
webapp(n),
pgsql(n)
.SH AUTHORS
Jean Benoit (Jean.Benoit@crc.u-strasbg.fr),
Pierre David (Pierre.David@crc.u-strasbg.fr)
