.\" $FreeBSD: stable/4/usr.bin/at/at.man 114606 2003-05-03 21:55:26Z keramida $
.Dd April 12, 1995
.Dt "AT" 1
.Os
.Sh NAME
.Nm at ,
.Nm batch ,
.Nm atq ,
.Nm atrm
.Nd queue, examine or delete jobs for later execution
.Sh SYNOPSIS
.Nm at
.Op Fl V
.Op Fl q Ar queue
.Op Fl f Ar file
.Op Fl mldbv
.Ar time
.Nm at
.Op Fl V
.Fl c Ar job Op Ar job ...
.Pp
.Nm atq
.Op Fl V
.Op Fl q Ar queue
.Op Fl v
.Pp
.Nm atrm
.Op Fl V
.Ar job
.Op Ar job ...
.Pp
.Nm batch
.Op Fl V
.Op Fl q Ar queue
.Op Fl f Ar file
.Op Fl mv
.Op Ar time
.Sh DESCRIPTION
.Nm \&At
and
.Nm batch
read commands from standard input or a specified file which are to
be executed at a later time, using
.Xr sh 1 .
.Bl -tag -width indent
.It Nm at
executes commands at a specified time;
.It Nm atq
lists the user's pending jobs, unless the user is the superuser; in that
case, everybody's jobs are listed;
.It Nm atrm
deletes jobs;
.It Nm batch
executes commands when system load levels permit; in other words, when the load average
drops below _LOADAVG_MX, or the value specified in the invocation of
.Nm atrun .
.El
.Pp
.Nm \&At
allows some moderately complex
.Ar time
specifications.
It accepts times of the form
.Ar HHMM
or
.Ar HH:MM
to run a job at a specific time of day.
(If that time is already past, the next day is assumed.)
As an alternative, the following keywords may be specified:
.Em midnight ,
.Em noon ,
or
.Em teatime
(4pm)
and time-of-day may be suffixed with
.Em AM
or
.Em PM
for running in the morning or the evening.
The day on which the job is to be run may also be specified
by giving a date in the form
.Ar \%month-name day
with an optional
.Ar year ,
or giving a date of the forms
.Ar DD.MM.YYYY ,
.Ar DD.MM.YY ,
.Ar MM/DD/YYYY ,
.Ar MM/DD/YY ,
.Ar MMDDYYYY , or
.Ar MMDDYY .
The specification of a date must follow the specification of
the time of day.
Time can also be specified as:
.Op Em now
.Em + Ar count \%time-units ,
where the time-units can be
.Em minutes ,
.Em hours ,
.Em days ,
.Em weeks ,
.Em months
or
.Em years
and you can tell
.Nm
to run the job today by suffixing the time with
.Em today
and to run the job tomorrow by suffixing the time with
.Em tomorrow .
.Pp
For example, to run a job at 4pm three days from now, you would do
.Nm at Ar 4pm + 3 days ,
to run a job at 10:00am on July 31, you would do
.Nm at Ar 10am Jul 31
and to run a job at 1am tomorrow, you would do
.Nm at Ar 1am tomorrow .
.Pp
For both
.Nm
and
.Nm batch ,
commands are read from standard input or the file specified
with the
.Fl f
option and executed.
The working directory, the environment (except for the variables
.Ev TERM ,
.Ev TERMCAP ,
.Ev DISPLAY
and
.Em _ )
and the
.Ar umask
are retained from the time of invocation.
An
.Nm
or
.Nm batch
command invoked from a
.Xr su 1
shell will retain the current userid.
The user will be mailed standard error and standard output from his
commands, if any.
Mail will be sent using the command
.Xr sendmail 8 .
If
.Nm
is executed from a
.Xr su 1
shell, the owner of the login shell will receive the mail.
.Pp
The superuser may use these commands in any case.
For other users, permission to use
.Nm
is determined by the files
.Pa _PERM_PATH/at.allow
and
.Pa _PERM_PATH/at.deny .
.Pp
If the file
.Pa _PERM_PATH/at.allow
exists, only usernames mentioned in it are allowed to use
.Nm .
In these two files, a user is considered to be listed only if the user
name has no blank or other characters before it on its line and a
newline character immediately after the name, even at the end of
the file.
Other lines are ignored and may be used for comments.
.Pp
If
.Pa _PERM_PATH/at.allow
does not exist,
.Pa _PERM_PATH/at.deny
is checked, every username not mentioned in it is then allowed
to use
.Nm Ns .
.Pp
If neither exists, only the superuser is allowed use of
.Nm Ns .
This is the default configuration.
.Sh OPTIONS
.Bl -tag -width indent
.It Fl V
Print the version number to standard error.
.It Fl q Ar queue
Use the specified queue.
A queue designation consists of a single letter; valid queue designations
range from
.Ar a
to
.Ar z
and
.Ar A
to
.Ar Z .
The
.Ar _DEFAULT_AT_QUEUE
queue is the default for
.Nm
and the
.Ar _DEFAULT_BATCH_QUEUE
queue for
.Nm batch .
Queues with higher letters run with increased niceness.
If a job is submitted to a queue designated with an uppercase letter, it
is treated as if it had been submitted to batch at that time.
If
.Nm atq
is given a specific queue, it will only show jobs pending in that queue.
.It Fl m
Send mail to the user when the job has completed even if there was no
output.
.It Fl f Ar file
Read the job from
.Ar file
rather than standard input.
.It Fl l
Is an alias for
.Nm atq .
.It Fl d
Is an alias for
.Nm atrm .
.It Fl b
Is an alias for
.Nm batch .
.It Fl v
For
.Nm atq ,
shows completed but not yet deleted jobs in the queue; otherwise
shows the time the job will be executed.
.It Fl c
Cat the jobs listed on the command line to standard output.
.El
.Sh FILES
.Bl -tag -width _ATJOB_DIR/_LOCKFILE -compact
.It Pa _ATJOB_DIR
directory containing job files
.It Pa _ATSPOOL_DIR
directory containing output spool files
.It Pa /var/run/utmp
login records
.It Pa _PERM_PATH/at.allow
allow permission control
.It Pa _PERM_PATH/at.deny
deny permission control
.It Pa _ATJOB_DIR/_LOCKFILE
job-creation lock file
.El
.Sh SEE ALSO
.Xr nice 1 ,
.Xr sh 1 ,
.Xr umask 2 ,
.Xr atrun 8 ,
.Xr cron 8 ,
.Xr sendmail 8
.Sh BUGS
If the file
.Pa /var/run/utmp
is not available or corrupted, or if the user is not logged on at the
time
.Nm
is invoked, the mail is sent to the userid found
in the environment variable
.Ev LOGNAME .
If that is undefined or empty, the current userid is assumed.
.Pp
.Nm \&At
and
.Nm batch
as presently implemented are not suitable when users are competing for
resources.
If this is the case for your site, you might want to consider another
batch system, such as
.Em nqs .
.Sh AUTHORS
At was mostly written by
.An Thomas Koenig Aq ig25@rz.uni-karlsruhe.de .
The time parsing routines are by
.An David Parsons Aq orc@pell.chi.il.us .
