\ #if FICL_WANT_LOCALS
\ ** ficl/softwords/jhlocal.fr
\ ** stack comment style local syntax...
\ { a b c | cleared -- d e }
\ variables before the "|" are initialized in reverse order
\ from the stack. Those after the "|" are zero initialized.
\ Anything between "--" and "}" is treated as comment
\ Uses locals...
\ locstate: 0 = looking for | or -- or }}
\           1 = found |
\           2 = found --
hide
0 constant zero

: ?--   ( c-addr u -- c-addr u flag )
    2dup s" --" compare 0= ;
: ?}    ( c-addr u -- c-addr u flag )
    2dup s" }"  compare 0= ;
: ?|    ( c-addr u -- c-addr u flag )
    2dup s" |"  compare 0= ;

: ?delim   ( c-addr u -- state | c-addr u 0 )
    ?| if 
        2drop 1
    else 
        ?-- if 
            2drop 2
        else 
            ?} if 2drop 3  else 0  endif
        endif
    endif
;

set-current

: {
    0 dup locals| locstate |
    
    \ stack locals until we hit a delimiter
    begin
        parse-word      \ ( nLocals c-addr u )
        ?delim dup to locstate
    0= while
        rot 1+          \ ( c-addr u ... c-addr u nLocals )
    repeat

    \ now unstack the locals
    0 do (local) loop   \ ( )

    \ zero locals until -- or }
    locstate 1 = if
        begin
            parse-word
            ?delim dup to locstate
        0= while
            postpone zero  (local)
        repeat
    endif

    0 0 (local)

    \ toss words until }
    locstate 2 = if
        begin
            parse-word
            ?delim dup to locstate
        0= while
            2drop
        repeat
    endif

    locstate 3 <> abort" syntax error in { } local line"
; immediate compile-only

previous 
\ #endif

